/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Pattern;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.common.Profile;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.ModelIllegalStateException;
import org.keycloak.models.ProtocolMapperContainerModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.ScopeContainerModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.saml.common.util.StringUtil;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.ProtocolMappersResource;
import org.keycloak.services.resources.admin.ScopeMappedResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

@Extension(name="x-smallrye-profile-admin", value="")
public class ClientScopeResource {
    protected static final Logger logger = Logger.getLogger(ClientScopeResource.class);
    protected RealmModel realm;
    private AdminPermissionEvaluator auth;
    private AdminEventBuilder adminEvent;
    protected ClientScopeModel clientScope;
    protected KeycloakSession session;
    protected static Pattern dynamicScreenPattern = Pattern.compile("[^\\s\\*]*\\*{1}[^\\s\\*]*");
    protected static final Pattern scopeNamePattern = Pattern.compile("[\\x21\\x23-\\x5B\\x5D-\\x7E]+");

    public ClientScopeResource(RealmModel realm, AdminPermissionEvaluator auth, ClientScopeModel clientScope, KeycloakSession session, AdminEventBuilder adminEvent) {
        this.realm = realm;
        this.auth = auth;
        this.clientScope = clientScope;
        this.session = session;
        this.adminEvent = adminEvent.resource(ResourceType.CLIENT_SCOPE);
    }

    @Path(value="protocol-mappers")
    public ProtocolMappersResource getProtocolMappers() {
        AdminPermissionEvaluator.RequirePermissionCheck manageCheck = () -> this.auth.clients().requireManage(this.clientScope);
        AdminPermissionEvaluator.RequirePermissionCheck viewCheck = () -> this.auth.clients().requireView(this.clientScope);
        return new ProtocolMappersResource(this.session, (ProtocolMapperContainerModel)this.clientScope, this.auth, this.adminEvent, manageCheck, viewCheck);
    }

    @Path(value="scope-mappings")
    public ScopeMappedResource getScopeMappedResource() {
        AdminPermissionEvaluator.RequirePermissionCheck manageCheck = () -> this.auth.clients().requireManage(this.clientScope);
        AdminPermissionEvaluator.RequirePermissionCheck viewCheck = () -> this.auth.clients().requireView(this.clientScope);
        return new ScopeMappedResource(this.realm, this.auth, (ScopeContainerModel)this.clientScope, this.session, this.adminEvent, manageCheck, viewCheck);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Tag(name="Client Scopes")
    @Operation(summary="Update the client scope")
    public Response update(ClientScopeRepresentation rep) {
        this.auth.clients().requireManageClientScopes();
        this.validateDynamicScopeUpdate(rep);
        try {
            RepresentationToModel.updateClientScope((ClientScopeRepresentation)rep, (ClientScopeModel)this.clientScope);
            this.adminEvent.operation(OperationType.UPDATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).success();
            if (this.session.getTransactionManager().isActive()) {
                this.session.getTransactionManager().commit();
            }
            return Response.noContent().build();
        }
        catch (ModelDuplicateException e) {
            throw ErrorResponse.exists("Client Scope " + rep.getName() + " already exists");
        }
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Client Scopes")
    @Operation(summary="Get representation of the client scope")
    public ClientScopeRepresentation getClientScope() {
        this.auth.clients().requireView(this.clientScope);
        return ModelToRepresentation.toRepresentation((ClientScopeModel)this.clientScope);
    }

    @DELETE
    @NoCache
    @Tag(name="Client Scopes")
    @Operation(summary="Delete the client scope")
    public Response deleteClientScope() {
        this.auth.clients().requireManage(this.clientScope);
        long clientScopesCount = Arrays.stream(this.realm.getClientScopesStream().toArray()).count();
        if (clientScopesCount > 1L) {
            try {
                this.realm.removeClientScope(this.clientScope.getId());
                this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
                return Response.noContent().build();
            }
            catch (ModelIllegalStateException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw ErrorResponse.error(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
            }
            catch (ModelException me) {
                throw ErrorResponse.error(me.getMessage(), Response.Status.BAD_REQUEST);
            }
        }
        throw ErrorResponse.error("You are not allowed to delete all the client scopes.", Response.Status.FORBIDDEN);
    }

    public static void validateDynamicClientScope(ClientScopeRepresentation clientScope) throws ErrorResponseException {
        if (clientScope.getAttributes() == null) {
            return;
        }
        boolean isDynamic = Boolean.parseBoolean((String)clientScope.getAttributes().get("is.dynamic.scope"));
        String regexp = (String)clientScope.getAttributes().get("dynamic.scope.regexp");
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.DYNAMIC_SCOPES)) {
            if (isDynamic && StringUtil.isNullOrEmpty((String)regexp)) {
                throw ErrorResponse.error("Dynamic scope regexp must not be null or empty", Response.Status.BAD_REQUEST);
            }
            if (!StringUtil.isNullOrEmpty((String)regexp) && !dynamicScreenPattern.matcher(regexp).matches()) {
                throw ErrorResponse.error(String.format("Invalid format for the Dynamic Scope regexp %1s", regexp), Response.Status.BAD_REQUEST);
            }
        } else {
            Optional.ofNullable(regexp).ifPresent(s -> {
                if (!s.isEmpty()) {
                    throw ErrorResponse.error(String.format("Unexpected value \"%1s\" for attribute %2s in ClientScope", regexp, "dynamic.scope.regexp"), Response.Status.BAD_REQUEST);
                }
            });
            if (isDynamic) {
                throw ErrorResponse.error(String.format("Unexpected value \"%1s\" for attribute %2s in ClientScope", isDynamic, "is.dynamic.scope"), Response.Status.BAD_REQUEST);
            }
        }
    }

    public static void validateClientScopeName(String name) throws ErrorResponseException {
        if (!scopeNamePattern.matcher(name).matches()) {
            String message = String.format("Unexpected name \"%s\" for ClientScope", name);
            throw ErrorResponse.error(message, Response.Status.BAD_REQUEST);
        }
    }

    public static void validateClientScopeProtocol(String protocol) throws ErrorResponseException {
        if (protocol == null || !protocol.equals("openid-connect") && !protocol.equals("saml")) {
            throw ErrorResponse.error("Unexpected protocol", Response.Status.BAD_REQUEST);
        }
    }

    public void validateDynamicScopeUpdate(ClientScopeRepresentation rep) {
        Optional<String> scopeModelOpt;
        ClientScopeResource.validateClientScopeName(rep.getName());
        if (rep.getAttributes() != null && rep.getAttributes().getOrDefault("is.dynamic.scope", "false").equalsIgnoreCase("true") && (scopeModelOpt = this.realm.getClientsStream().flatMap(clientModel -> clientModel.getClientScopes(true).values().stream()).map(ClientScopeModel::getId).filter(scopeId -> scopeId.equalsIgnoreCase(this.clientScope.getId())).findAny()).isPresent()) {
            throw ErrorResponse.error("This Client Scope can't be made dynamic as it's assigned to a Client as a Default Scope", Response.Status.BAD_REQUEST);
        }
        ClientScopeResource.validateDynamicClientScope(rep);
    }
}

