/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.models.KeyManager;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oid4vc.OID4VCClientRegistrationProvider;
import org.keycloak.protocol.oid4vc.issuance.signing.VCSigningServiceProviderFactory;
import org.keycloak.protocol.oid4vc.issuance.signing.VerifiableCredentialsSigningService;
import org.keycloak.protocol.oid4vc.model.CredentialIssuer;
import org.keycloak.protocol.oid4vc.model.OID4VCClient;
import org.keycloak.protocol.oid4vc.model.SupportedCredentialConfiguration;
import org.keycloak.services.Urls;
import org.keycloak.urls.UrlType;
import org.keycloak.wellknown.WellKnownProvider;

public class OID4VCIssuerWellKnownProvider
implements WellKnownProvider {
    private final KeycloakSession keycloakSession;
    public static final String VC_KEY = "vc";

    public OID4VCIssuerWellKnownProvider(KeycloakSession keycloakSession) {
        this.keycloakSession = keycloakSession;
    }

    public void close() {
    }

    @Override
    public Object getConfig() {
        return new CredentialIssuer().setCredentialIssuer(OID4VCIssuerWellKnownProvider.getIssuer(this.keycloakSession.getContext())).setCredentialEndpoint(OID4VCIssuerWellKnownProvider.getCredentialsEndpoint(this.keycloakSession.getContext())).setCredentialsSupported(OID4VCIssuerWellKnownProvider.getSupportedCredentials(this.keycloakSession)).setAuthorizationServers(List.of(OID4VCIssuerWellKnownProvider.getIssuer(this.keycloakSession.getContext())));
    }

    public static Map<String, SupportedCredentialConfiguration> getSupportedCredentials(KeycloakSession keycloakSession) {
        RealmModel realm = keycloakSession.getContext().getRealm();
        List<String> supportedFormats = realm.getComponentsStream(realm.getId(), VerifiableCredentialsSigningService.class.getName()).map(cm -> keycloakSession.getKeycloakSessionFactory().getProviderFactory(VerifiableCredentialsSigningService.class, cm.getProviderId())).filter(VCSigningServiceProviderFactory.class::isInstance).map(VCSigningServiceProviderFactory.class::cast).map(VCSigningServiceProviderFactory::supportedFormat).toList();
        List<String> supportedAlgorithms = OID4VCIssuerWellKnownProvider.getSupportedSignatureAlgorithms(keycloakSession);
        Map<String, SupportedCredentialConfiguration> clientAttributes = keycloakSession.getContext().getRealm().getClientsStream().filter(cm -> cm.getProtocol() != null).filter(cm -> cm.getProtocol().equals("oid4vc")).map(cm -> OID4VCClientRegistrationProvider.fromClientAttributes(cm.getClientId(), cm.getAttributes())).map(OID4VCClient::getSupportedVCTypes).flatMap(Collection::stream).filter(sc -> supportedFormats.contains(sc.getFormat())).distinct().peek(sc -> sc.setCredentialSigningAlgValuesSupported(supportedAlgorithms)).collect(Collectors.toMap(SupportedCredentialConfiguration::getId, sc -> sc, (sc1, sc2) -> sc1));
        Map<String, SupportedCredentialConfiguration> realmAttr = OID4VCIssuerWellKnownProvider.fromRealmAttributes(realm.getAttributes()).stream().filter(sc -> supportedFormats.contains(sc.getFormat())).distinct().peek(sc -> sc.setCredentialSigningAlgValuesSupported(supportedAlgorithms)).collect(Collectors.toMap(SupportedCredentialConfiguration::getId, sc -> sc, (sc1, sc2) -> sc1));
        HashMap<String, SupportedCredentialConfiguration> aggregatedAttr = new HashMap<String, SupportedCredentialConfiguration>(clientAttributes);
        aggregatedAttr.putAll(realmAttr);
        return aggregatedAttr;
    }

    public static String getIssuer(KeycloakContext context) {
        KeycloakUriInfo frontendUriInfo = context.getUri(UrlType.FRONTEND);
        return Urls.realmIssuer(frontendUriInfo.getBaseUri(), context.getRealm().getName());
    }

    public static String getCredentialsEndpoint(KeycloakContext context) {
        return OID4VCIssuerWellKnownProvider.getIssuer(context) + "/protocol/oid4vc/credential";
    }

    public static List<SupportedCredentialConfiguration> fromRealmAttributes(Map<String, String> realmAttributes) {
        HashSet supportedCredentialIds = new HashSet();
        HashMap attributes = new HashMap();
        realmAttributes.forEach((entryKey, value) -> {
            if (!entryKey.startsWith(VC_KEY)) {
                return;
            }
            String key = entryKey.substring("vc.".length());
            supportedCredentialIds.add(key.split("\\.")[0]);
            attributes.put(key, value);
        });
        return supportedCredentialIds.stream().map(id -> SupportedCredentialConfiguration.fromDotNotation(id, attributes)).toList();
    }

    public static List<String> getSupportedSignatureAlgorithms(KeycloakSession session) {
        RealmModel realm = session.getContext().getRealm();
        KeyManager keyManager = session.keys();
        return keyManager.getKeysStream(realm).filter(key -> KeyUse.SIG.equals((Object)key.getUse())).map(KeyWrapper::getAlgorithm).filter(algorithm -> algorithm != null && !algorithm.isEmpty()).distinct().collect(Collectors.toList());
    }
}

