/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.authenticators.browser.OTPFormAuthenticator;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class ConditionalOtpFormAuthenticator
extends OTPFormAuthenticator {
    public static final String SKIP = "skip";
    public static final String FORCE = "force";
    public static final String OTP_CONTROL_USER_ATTRIBUTE = "otpControlAttribute";
    public static final String SKIP_OTP_ROLE = "skipOtpRole";
    public static final String FORCE_OTP_ROLE = "forceOtpRole";
    public static final String SKIP_OTP_FOR_HTTP_HEADER = "noOtpRequiredForHeaderPattern";
    public static final String FORCE_OTP_FOR_HTTP_HEADER = "forceOtpForHeaderPattern";
    public static final String DEFAULT_OTP_OUTCOME = "defaultOtpOutcome";

    @Override
    public void authenticate(AuthenticationFlowContext context) {
        Map config;
        AuthenticatorConfigModel model = context.getAuthenticatorConfig();
        Map map = config = model != null ? model.getConfig() : Collections.emptyMap();
        if (this.tryConcludeBasedOn(this.voteForUserOtpControlAttribute(context.getUser(), config), context)) {
            return;
        }
        if (this.tryConcludeBasedOn(this.voteForUserRole(context.getRealm(), context.getUser(), config), context)) {
            return;
        }
        if (this.tryConcludeBasedOn(this.voteForHttpHeaderMatchesPattern((MultivaluedMap<String, String>)context.getHttpRequest().getHttpHeaders().getRequestHeaders(), config), context)) {
            return;
        }
        if (this.tryConcludeBasedOn(this.voteForDefaultFallback(config), context)) {
            return;
        }
        this.showOtpForm(context);
    }

    private OtpDecision voteForDefaultFallback(Map<String, String> config) {
        if (!config.containsKey(DEFAULT_OTP_OUTCOME)) {
            return OtpDecision.ABSTAIN;
        }
        switch (config.get(DEFAULT_OTP_OUTCOME)) {
            case "skip": {
                return OtpDecision.SKIP_OTP;
            }
            case "force": {
                return OtpDecision.SHOW_OTP;
            }
        }
        return OtpDecision.ABSTAIN;
    }

    private boolean tryConcludeBasedOn(OtpDecision state, AuthenticationFlowContext context) {
        switch (state.ordinal()) {
            case 1: {
                this.showOtpForm(context);
                return true;
            }
            case 0: {
                context.success();
                return true;
            }
        }
        return false;
    }

    private boolean tryConcludeBasedOn(OtpDecision state) {
        switch (state.ordinal()) {
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        return false;
    }

    private void showOtpForm(AuthenticationFlowContext context) {
        super.authenticate(context);
    }

    private OtpDecision voteForUserOtpControlAttribute(UserModel user, Map<String, String> config) {
        if (!config.containsKey(OTP_CONTROL_USER_ATTRIBUTE)) {
            return OtpDecision.ABSTAIN;
        }
        String attributeName = config.get(OTP_CONTROL_USER_ATTRIBUTE);
        if (attributeName == null) {
            return OtpDecision.ABSTAIN;
        }
        Optional value = user.getAttributeStream(attributeName).findFirst();
        if (!value.isPresent()) {
            return OtpDecision.ABSTAIN;
        }
        switch (((String)value.get()).trim()) {
            case "skip": {
                return OtpDecision.SKIP_OTP;
            }
            case "force": {
                return OtpDecision.SHOW_OTP;
            }
        }
        return OtpDecision.ABSTAIN;
    }

    private OtpDecision voteForHttpHeaderMatchesPattern(MultivaluedMap<String, String> requestHeaders, Map<String, String> config) {
        if (!config.containsKey(FORCE_OTP_FOR_HTTP_HEADER) && !config.containsKey(SKIP_OTP_FOR_HTTP_HEADER)) {
            return OtpDecision.ABSTAIN;
        }
        if (this.containsMatchingRequestHeader(requestHeaders, config.get(SKIP_OTP_FOR_HTTP_HEADER))) {
            return OtpDecision.SKIP_OTP;
        }
        if (this.containsMatchingRequestHeader(requestHeaders, config.get(FORCE_OTP_FOR_HTTP_HEADER))) {
            return OtpDecision.SHOW_OTP;
        }
        return OtpDecision.ABSTAIN;
    }

    private boolean containsMatchingRequestHeader(MultivaluedMap<String, String> requestHeaders, String headerPattern) {
        if (headerPattern == null) {
            return false;
        }
        Pattern pattern = Pattern.compile(headerPattern, 34);
        for (Map.Entry entry : requestHeaders.entrySet()) {
            String key = (String)entry.getKey();
            for (String value : (List)entry.getValue()) {
                String headerEntry = key.trim() + ": " + value.trim();
                if (!pattern.matcher(headerEntry).matches()) continue;
                return true;
            }
        }
        return false;
    }

    private OtpDecision voteForUserRole(RealmModel realm, UserModel user, Map<String, String> config) {
        if (!config.containsKey(SKIP_OTP_ROLE) && !config.containsKey(FORCE_OTP_ROLE)) {
            return OtpDecision.ABSTAIN;
        }
        if (this.userHasRole(realm, user, config.get(SKIP_OTP_ROLE))) {
            return OtpDecision.SKIP_OTP;
        }
        if (this.userHasRole(realm, user, config.get(FORCE_OTP_ROLE))) {
            return OtpDecision.SHOW_OTP;
        }
        return OtpDecision.ABSTAIN;
    }

    private boolean userHasRole(RealmModel realm, UserModel user, String roleName) {
        if (roleName == null) {
            return false;
        }
        RoleModel role = KeycloakModelUtils.getRoleFromString((RealmModel)realm, (String)roleName);
        if (role != null) {
            return user.hasRole(role);
        }
        return false;
    }

    private boolean isOTPRequired(KeycloakSession session, RealmModel realm, UserModel user) {
        MultivaluedMap requestHeaders = session.getContext().getRequestHeaders().getRequestHeaders();
        List configs = realm.getAuthenticatorConfigsStream().map(AuthenticatorConfigModel::getConfig).filter(this::containsConditionalOtpConfig).collect(Collectors.toList());
        if (configs.isEmpty()) {
            return true;
        }
        return configs.stream().anyMatch(config -> {
            if (this.tryConcludeBasedOn(this.voteForUserOtpControlAttribute(user, (Map<String, String>)config))) {
                return true;
            }
            if (this.tryConcludeBasedOn(this.voteForUserRole(realm, user, (Map<String, String>)config))) {
                return true;
            }
            if (this.tryConcludeBasedOn(this.voteForHttpHeaderMatchesPattern((MultivaluedMap<String, String>)requestHeaders, (Map<String, String>)config))) {
                return true;
            }
            if (config.get(DEFAULT_OTP_OUTCOME) != null && ((String)config.get(DEFAULT_OTP_OUTCOME)).equals(FORCE) && config.size() <= 1) {
                return true;
            }
            return this.voteForUserOtpControlAttribute(user, (Map<String, String>)config) == OtpDecision.ABSTAIN && this.voteForUserRole(realm, user, (Map<String, String>)config) == OtpDecision.ABSTAIN && this.voteForHttpHeaderMatchesPattern((MultivaluedMap<String, String>)requestHeaders, (Map<String, String>)config) == OtpDecision.ABSTAIN && (this.voteForDefaultFallback((Map<String, String>)config) == OtpDecision.SHOW_OTP || this.voteForDefaultFallback((Map<String, String>)config) == OtpDecision.ABSTAIN);
        });
    }

    private boolean containsConditionalOtpConfig(Map config) {
        return config.containsKey(OTP_CONTROL_USER_ATTRIBUTE) || config.containsKey(SKIP_OTP_ROLE) || config.containsKey(FORCE_OTP_ROLE) || config.containsKey(SKIP_OTP_FOR_HTTP_HEADER) || config.containsKey(FORCE_OTP_FOR_HTTP_HEADER) || config.containsKey(DEFAULT_OTP_OUTCOME);
    }

    @Override
    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
        if (!this.isOTPRequired(session, realm, user)) {
            user.removeRequiredAction(UserModel.RequiredAction.CONFIGURE_TOTP);
        } else if (user.getRequiredActionsStream().noneMatch(UserModel.RequiredAction.CONFIGURE_TOTP.name()::equals)) {
            user.addRequiredAction(UserModel.RequiredAction.CONFIGURE_TOTP.name());
        }
    }

    static enum OtpDecision {
        SKIP_OTP,
        SHOW_OTP,
        ABSTAIN;

    }
}

