/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.http;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.core.Future;
import io.vertx.mutiny.core.MultiMap;
import io.vertx.mutiny.core.http.ServerWebSocket;
import io.vertx.mutiny.core.net.HostAndPort;
import io.vertx.mutiny.core.net.SocketAddress;
import javax.net.ssl.SSLSession;

@MutinyGen(value=io.vertx.core.http.ServerWebSocketHandshake.class)
public class ServerWebSocketHandshake {
    public static final TypeArg<ServerWebSocketHandshake> __TYPE_ARG = new TypeArg(obj -> new ServerWebSocketHandshake((io.vertx.core.http.ServerWebSocketHandshake)obj), ServerWebSocketHandshake::getDelegate);
    private final io.vertx.core.http.ServerWebSocketHandshake delegate;
    static final TypeArg<ServerWebSocket> TYPE_ARG_0 = new TypeArg(o1 -> ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)o1), o1 -> o1.getDelegate());
    private SocketAddress cached_0;
    private SocketAddress cached_1;

    public ServerWebSocketHandshake(io.vertx.core.http.ServerWebSocketHandshake delegate) {
        this.delegate = delegate;
    }

    public ServerWebSocketHandshake(Object delegate) {
        this.delegate = (io.vertx.core.http.ServerWebSocketHandshake)delegate;
    }

    ServerWebSocketHandshake() {
        this.delegate = null;
    }

    public io.vertx.core.http.ServerWebSocketHandshake getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerWebSocketHandshake that = (ServerWebSocketHandshake)o;
        return this.delegate.equals((Object)that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public MultiMap headers() {
        MultiMap ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    public String scheme() {
        String ret = this.delegate.scheme();
        return ret;
    }

    public HostAndPort authority() {
        HostAndPort ret = HostAndPort.newInstance(this.delegate.authority());
        return ret;
    }

    public String uri() {
        String ret = this.delegate.uri();
        return ret;
    }

    public String path() {
        String ret = this.delegate.path();
        return ret;
    }

    public String query() {
        String ret = this.delegate.query();
        return ret;
    }

    @CheckReturnValue
    public Uni<ServerWebSocket> accept() {
        return UniHelper.toUni((Future)this.delegate.accept().map(x -> ServerWebSocket.newInstance(x)));
    }

    public ServerWebSocket acceptAndAwait() {
        return (ServerWebSocket)this.accept().await().indefinitely();
    }

    public void acceptAndForget() {
        this.accept().subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> reject() {
        return UniHelper.toUni((Future)this.delegate.reject());
    }

    public Void rejectAndAwait() {
        return (Void)this.reject().await().indefinitely();
    }

    public void rejectAndForget() {
        this.reject().subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> reject(int status) {
        return UniHelper.toUni((Future)this.delegate.reject(status));
    }

    public Void rejectAndAwait(int status) {
        return (Void)this.reject(status).await().indefinitely();
    }

    public void rejectAndForget(int status) {
        this.reject(status).subscribe().with(UniHelper.NOOP);
    }

    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.remoteAddress());
        return ret;
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    public SSLSession sslSession() {
        SSLSession ret = this.delegate.sslSession();
        return ret;
    }

    public static ServerWebSocketHandshake newInstance(io.vertx.core.http.ServerWebSocketHandshake arg) {
        return arg != null ? new ServerWebSocketHandshake(arg) : null;
    }
}

