/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.AbstractLocationConfigSourceLoader;
import io.smallrye.config.PropertiesConfigSource;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

public class PropertiesConfigSourceLoader
extends AbstractLocationConfigSourceLoader {
    protected final String path;
    protected final int ordinal;

    PropertiesConfigSourceLoader(String path, int ordinal) {
        this.path = path;
        this.ordinal = ordinal;
    }

    @Override
    protected String[] getFileExtensions() {
        return new String[]{"properties"};
    }

    @Override
    protected ConfigSource loadConfigSource(URL url, int ordinal) throws IOException {
        return new PropertiesConfigSource(url, ordinal);
    }

    public static List<ConfigSource> inClassPath(String path, int ordinal, ClassLoader loader) {
        return new InClassPath(path, ordinal).getConfigSources(loader);
    }

    public static List<ConfigSource> inFileSystem(String path, int ordinal, ClassLoader loader) {
        return new InFileSystem(path, ordinal).getConfigSources(loader);
    }

    private static class InFileSystem
    extends PropertiesConfigSourceLoader
    implements ConfigSourceProvider {
        public InFileSystem(String path, int ordinal) {
            super(path, ordinal);
        }

        public List<ConfigSource> getConfigSources(ClassLoader classLoader) {
            return this.loadConfigSources(this.path, this.ordinal, classLoader);
        }

        @Override
        protected List<ConfigSource> tryClassPath(URI uri, int ordinal, ClassLoader classLoader) {
            return Collections.emptyList();
        }
    }

    private static class InClassPath
    extends PropertiesConfigSourceLoader
    implements ConfigSourceProvider {
        public InClassPath(String path, int ordinal) {
            super(path, ordinal);
        }

        public List<ConfigSource> getConfigSources(ClassLoader classLoader) {
            return this.loadConfigSources(this.path, this.ordinal, classLoader);
        }

        @Override
        protected List<ConfigSource> tryFileSystem(URI uri, int ordinal) {
            return Collections.emptyList();
        }
    }
}

