/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import java.lang.ref.WeakReference;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedTable;
import javax.accessibility.AccessibleTable;
import org.GNOME.Accessibility.AtkUtil;

public class AtkTable {
    WeakReference<AccessibleContext> _ac;
    WeakReference<AccessibleTable> _acc_table;

    public AtkTable(AccessibleContext accessibleContext) {
        this._ac = new WeakReference<AccessibleContext>(accessibleContext);
        this._acc_table = new WeakReference<AccessibleTable>(accessibleContext.getAccessibleTable());
    }

    public static AtkTable createAtkTable(AccessibleContext accessibleContext) {
        return AtkUtil.invokeInSwing(() -> new AtkTable(accessibleContext), null);
    }

    public AccessibleContext ref_at(int n, int n2) {
        AccessibleTable accessibleTable = (AccessibleTable)this._acc_table.get();
        if (accessibleTable == null) {
            return null;
        }
        return AtkUtil.invokeInSwing(() -> {
            Accessible accessible = accessibleTable.getAccessibleAt(n, n2);
            if (accessible != null) {
                return accessible.getAccessibleContext();
            }
            return null;
        }, null);
    }

    public int get_index_at(int n, int n2) {
        AccessibleTable accessibleTable = (AccessibleTable)this._acc_table.get();
        if (accessibleTable == null) {
            return -1;
        }
        return AtkUtil.invokeInSwing(() -> {
            if (accessibleTable instanceof AccessibleExtendedTable) {
                return ((AccessibleExtendedTable)accessibleTable).getAccessibleIndex(n, n2);
            }
            Accessible accessible = accessibleTable.getAccessibleAt(n, n2);
            if (accessible == null) {
                return -1;
            }
            AccessibleContext accessibleContext = accessible.getAccessibleContext();
            if (accessibleContext == null) {
                return -1;
            }
            return accessibleContext.getAccessibleIndexInParent();
        }, -1);
    }

    public int get_column_at_index(int n) {
        AccessibleTable accessibleTable = (AccessibleTable)this._acc_table.get();
        if (accessibleTable == null) {
            return -1;
        }
        return AtkUtil.invokeInSwing(() -> {
            int n2 = -1;
            if (accessibleTable instanceof AccessibleExtendedTable) {
                n2 = ((AccessibleExtendedTable)accessibleTable).getAccessibleColumn(n);
            }
            return n2;
        }, -1);
    }

    public int get_row_at_index(int n) {
        AccessibleTable accessibleTable = (AccessibleTable)this._acc_table.get();
        if (accessibleTable == null) {
            return -1;
        }
        return AtkUtil.invokeInSwing(() -> {
            int n2 = -1;
            if (accessibleTable instanceof AccessibleExtendedTable) {
                n2 = ((AccessibleExtendedTable)accessibleTable).getAccessibleRow(n);
            }
            return n2;
        }, -1);
    }

    public int get_n_columns() {
        AccessibleTable accessibleTable = (AccessibleTable)this._acc_table.get();
        if (accessibleTable == null) {
            return 0;
        }
        return AtkUtil.invokeInSwing(() -> accessibleTable.getAccessibleColumnCount(), 0);
    }

    public int get_n_rows() {
        AccessibleTable accessibleTable = (AccessibleTable)this._acc_table.get();
        if (accessibleTable == null) {
            return 0;
        }
        return AtkUtil.invokeInSwing(() -> accessibleTable.getAccessibleRowCount(), 0);
    }

    public int get_column_extent_at(int n, int n2) {
        AccessibleTable accessibleTable = (AccessibleTable)this._acc_table.get();
        if (accessibleTable == null) {
            return 0;
        }
        return AtkUtil.invokeInSwing(() -> accessibleTable.getAccessibleColumnExtentAt(n, n2), 0);
    }

    public int get_row_extent_at(int n, int n2) {
        AccessibleTable accessibleTable = (AccessibleTable)this._acc_table.get();
        if (accessibleTable == null) {
            return 0;
        }
        return AtkUtil.invokeInSwing(() -> accessibleTable.getAccessibleRowExtentAt(n, n2), 0);
    }

    public AccessibleContext get_caption() {
        AccessibleTable accessibleTable = (AccessibleTable)this._acc_table.get();
        if (accessibleTable == null) {
            return null;
        }
        return AtkUtil.invokeInSwing(() -> {
            Accessible accessible = accessibleTable.getAccessibleCaption();
            if (accessible != null) {
                return accessible.getAccessibleContext();
            }
            return null;
        }, null);
    }

    public void setCaption(Accessible accessible) {
        AccessibleTable accessibleTable = (AccessibleTable)this._acc_table.get();
        if (accessibleTable == null) {
            return;
        }
        AtkUtil.invokeInSwing(() -> accessibleTable.setAccessibleCaption(accessible));
    }

    public String get_column_description(int n) {
        AccessibleTable accessibleTable = (AccessibleTable)this._acc_table.get();
        if (accessibleTable == null) {
            return "";
        }
        return AtkUtil.invokeInSwing(() -> {
            AccessibleContext accessibleContext;
            Accessible accessible = accessibleTable.getAccessibleColumnDescription(n);
            if (accessible != null && (accessibleContext = accessible.getAccessibleContext()) != null) {
                return accessibleContext.getAccessibleDescription();
            }
            return "";
        }, "");
    }

    public void setColumnDescription(int n, String string) {
        AccessibleTable accessibleTable = (AccessibleTable)this._acc_table.get();
        if (accessibleTable == null) {
            return;
        }
        AtkUtil.invokeInSwing(() -> {
            Accessible accessible = accessibleTable.getAccessibleColumnDescription(n);
            if (accessible != null && string.equals(accessible.toString())) {
                accessibleTable.setAccessibleColumnDescription(n, accessible);
            }
        });
    }

    public String get_row_description(int n) {
        AccessibleTable accessibleTable = (AccessibleTable)this._acc_table.get();
        if (accessibleTable == null) {
            return "";
        }
        return AtkUtil.invokeInSwing(() -> {
            AccessibleContext accessibleContext;
            Accessible accessible = accessibleTable.getAccessibleRowDescription(n);
            if (accessible != null && (accessibleContext = accessible.getAccessibleContext()) != null) {
                return accessibleContext.getAccessibleDescription();
            }
            return "";
        }, "");
    }

    public void setRowDescription(int n, String string) {
        AccessibleTable accessibleTable = (AccessibleTable)this._acc_table.get();
        if (accessibleTable == null) {
            return;
        }
        AtkUtil.invokeInSwing(() -> {
            Accessible accessible = accessibleTable.getAccessibleRowDescription(n);
            if (accessible != null && string.equals(accessible.toString())) {
                accessibleTable.setAccessibleRowDescription(n, accessible);
            }
        });
    }

    public AccessibleContext get_column_header(int n) {
        AccessibleTable accessibleTable = (AccessibleTable)this._acc_table.get();
        if (accessibleTable == null) {
            return null;
        }
        return AtkUtil.invokeInSwing(() -> {
            Accessible accessible;
            AccessibleTable accessibleTable2 = accessibleTable.getAccessibleColumnHeader();
            if (accessibleTable2 != null && (accessible = accessibleTable2.getAccessibleAt(0, n)) != null) {
                return accessible.getAccessibleContext();
            }
            return null;
        }, null);
    }

    public AccessibleContext get_row_header(int n) {
        AccessibleTable accessibleTable = (AccessibleTable)this._acc_table.get();
        if (accessibleTable == null) {
            return null;
        }
        return AtkUtil.invokeInSwing(() -> {
            Accessible accessible;
            AccessibleTable accessibleTable2 = accessibleTable.getAccessibleRowHeader();
            if (accessibleTable2 != null && (accessible = accessibleTable2.getAccessibleAt(n, 0)) != null) {
                return accessible.getAccessibleContext();
            }
            return null;
        }, null);
    }

    public AccessibleContext get_summary() {
        AccessibleTable accessibleTable = (AccessibleTable)this._acc_table.get();
        if (accessibleTable == null) {
            return null;
        }
        return AtkUtil.invokeInSwing(() -> {
            Accessible accessible = accessibleTable.getAccessibleSummary();
            if (accessible != null) {
                return accessible.getAccessibleContext();
            }
            return null;
        }, null);
    }

    public void setSummary(Accessible accessible) {
        AccessibleTable accessibleTable = (AccessibleTable)this._acc_table.get();
        if (accessibleTable == null) {
            return;
        }
        AtkUtil.invokeInSwing(() -> accessibleTable.setAccessibleSummary(accessible));
    }

    public int[] get_selected_columns() {
        int[] nArray = new int[]{};
        AccessibleTable accessibleTable = (AccessibleTable)this._acc_table.get();
        if (accessibleTable == null) {
            return nArray;
        }
        return AtkUtil.invokeInSwing(() -> accessibleTable.getSelectedAccessibleColumns(), nArray);
    }

    public int[] get_selected_rows() {
        int[] nArray = new int[]{};
        AccessibleTable accessibleTable = (AccessibleTable)this._acc_table.get();
        if (accessibleTable == null) {
            return nArray;
        }
        return AtkUtil.invokeInSwing(() -> accessibleTable.getSelectedAccessibleRows(), nArray);
    }

    public boolean is_column_selected(int n) {
        AccessibleTable accessibleTable = (AccessibleTable)this._acc_table.get();
        if (accessibleTable == null) {
            return false;
        }
        return AtkUtil.invokeInSwing(() -> accessibleTable.isAccessibleColumnSelected(n), false);
    }

    public boolean is_row_selected(int n) {
        AccessibleTable accessibleTable = (AccessibleTable)this._acc_table.get();
        if (accessibleTable == null) {
            return false;
        }
        return AtkUtil.invokeInSwing(() -> accessibleTable.isAccessibleRowSelected(n), false);
    }

    public boolean is_selected(int n, int n2) {
        AccessibleTable accessibleTable = (AccessibleTable)this._acc_table.get();
        if (accessibleTable == null) {
            return false;
        }
        return AtkUtil.invokeInSwing(() -> accessibleTable.isAccessibleSelected(n, n2), false);
    }
}

