#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lattices
version:              2.2.1
visibility:           public
id:                   lattices-2.2.1-EBkuMP2cnVz8FAiEWC85o3
key:                  lattices-2.2.1-EBkuMP2cnVz8FAiEWC85o3
license:              BSD-3-Clause
copyright:
    (C) 2010-2015 Maximilian Bolingbroke, 2016-2019 Oleg Grenrus

maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:
    Maximilian Bolingbroke <batterseapower@hotmail.com>, Oleg Grenrus <oleg.grenrus@iki.fi>

homepage:             http://github.com/phadej/lattices/
synopsis:
    Fine-grained library for constructing and manipulating lattices

description:
    In mathematics, a lattice is a partially ordered set in which every two
    elements @x@ and @y@ have a unique supremum (also called a least upper bound, join, or @x /\\ y@)
    and a unique infimum (also called a greatest lower bound, meet, or @x \\/ y@).

    This package provide type-classes for different lattice types, as well
    as a class for the partial order.

category:             Math
abi:                  9d692415d586c05f196b6e70c4b6594a
exposed:              True
exposed-modules:
    Algebra.Heyting Algebra.Heyting.Free Algebra.Heyting.Free.Expr
    Algebra.Lattice Algebra.Lattice.Divisibility
    Algebra.Lattice.Dropped Algebra.Lattice.Free
    Algebra.Lattice.Free.Final Algebra.Lattice.Levitated
    Algebra.Lattice.Lexicographic Algebra.Lattice.Lifted
    Algebra.Lattice.M2 Algebra.Lattice.M3 Algebra.Lattice.N5
    Algebra.Lattice.Op Algebra.Lattice.Ordered Algebra.Lattice.Unicode
    Algebra.Lattice.Wide Algebra.Lattice.ZeroHalfOne Algebra.PartialOrd
    Algebra.PartialOrd.Instances

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lattices-2.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lattices-2.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lattices-2.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lattices
hs-libraries:         HSlattices-2.2.1-EBkuMP2cnVz8FAiEWC85o3
depends:
    QuickCheck-2.15.0.1-5wgMd498nCWIkHPGslLJlo base-4.17.2.1
    containers-0.6.7 deepseq-1.4.8.0
    foldable1-classes-compat-0.1.2-6CnG8XigcKeJl7zPbqkq1N
    hashable-1.4.7.0-KrA5CwhmktQ6Qu5a4JCqq7
    integer-logarithms-1.0.4-6z6xZlE4CggDxAVq3LognB
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C transformers-0.5.6.2
    universe-base-1.1.4-8WZqwMjufjwI3TgDfimJSt
    universe-reverse-instances-1.1.2-AjziTi564DPDYqpheXk65d
    unordered-containers-0.2.20.1-JRJBW0Nl9iEJULI134IWXM

haddock-interfaces:   /usr/share/doc/haskell-lattices/html/lattices.haddock
haddock-html:         /usr/share/doc/haskell-lattices/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

