#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 generics-sop
version:              0.5.1.3
visibility:           public
id:                   generics-sop-0.5.1.3-1cdm4H81rvrYJuJwoMQFY
key:                  generics-sop-0.5.1.3-1cdm4H81rvrYJuJwoMQFY
license:              BSD-3-Clause
maintainer:           andres@well-typed.com
author:
    Edsko de Vries <edsko@well-typed.com>, Andres Löh <andres@well-typed.com>

synopsis:             Generic Programming using True Sums of Products
description:
    A library to support the definition of generic functions.
    Datatypes are viewed in a uniform, structured way:
    the choice between constructors is represented using an n-ary
    sum, and the arguments of each constructor are represented using
    an n-ary product.

    The module "Generics.SOP" is the main module of this library and contains
    more detailed documentation.

    Since version 0.4.0.0, this package is now based on
    @<https://hackage.haskell.org/package/sop-core sop-core>@. The core package
    contains all the functionality of n-ary sums and products, whereas this
    package provides the datatype-generic programming support on top.

    Examples of using this library are provided by the following
    packages:

    * @<https://hackage.haskell.org/package/basic-sop basic-sop>@ basic examples,

    * @<https://hackage.haskell.org/package/pretty-sop pretty-sop>@ generic pretty printing,

    * @<https://hackage.haskell.org/package/lens-sop lens-sop>@ generically computed lenses,

    * @<https://hackage.haskell.org/package/json-sop json-sop>@ generic JSON conversions.

    A detailed description of the ideas behind this library is provided by
    the paper:

    * Edsko de Vries and Andres Löh.
    <http://www.andres-loeh.de/TrueSumsOfProducts True Sums of Products>.
    Workshop on Generic Programming (WGP) 2014.

category:             Generics
abi:                  368bef6e3784a32ebec7ebc3b7198bd5
exposed:              True
exposed-modules:
    Generics.SOP Generics.SOP.BasicFunctors Generics.SOP.Classes
    Generics.SOP.Constraint Generics.SOP.Dict Generics.SOP.GGP
    Generics.SOP.Instances Generics.SOP.Metadata Generics.SOP.NP
    Generics.SOP.NS Generics.SOP.Sing Generics.SOP.TH
    Generics.SOP.Type.Metadata Generics.SOP.Universe

import-dirs:          /usr/lib/ghc-9.4.8/site-local/generics-sop-0.5.1.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/generics-sop-0.5.1.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/generics-sop-0.5.1.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-generics-sop
hs-libraries:         HSgenerics-sop-0.5.1.3-1cdm4H81rvrYJuJwoMQFY
depends:
    base-4.17.2.1 ghc-prim-0.9.1
    sop-core-0.5.0.2-6A7lf58QPy2GZuvhMdgskj template-haskell-2.19.0.0
    th-abstraction-0.5.0.0-BROQwjXmGCt8uLmQUfLqOy

haddock-interfaces:
    /usr/share/doc/haskell-generics-sop/html/generics-sop.haddock

haddock-html:         /usr/share/doc/haskell-generics-sop/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

