#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 entropy
version:              0.4.1.11
visibility:           public
id:                   entropy-0.4.1.11-KgGl1Y7Pn5mDV1IyWdAGFR
key:                  entropy-0.4.1.11-KgGl1Y7Pn5mDV1IyWdAGFR
license:              BSD-3-Clause
copyright:            Thomas DuBuisson <thomas.dubuisson@gmail.com>
maintainer:           Thomas DuBuisson <thomas.dubuisson@gmail.com>
author:               Thomas DuBuisson <thomas.dubuisson@gmail.com>
stability:            stable
homepage:             https://github.com/TomMD/entropy
synopsis:             A platform independent entropy source
description:
    A mostly platform independent method to obtain cryptographically strong entropy
    (RDRAND, urandom, CryptAPI, and patches welcome)
    Users looking for cryptographically strong (number-theoretically
    sound) PRNGs should see the '\''DRBG'\'' package too.

category:             Data, Cryptography
abi:                  4f5c2a57f122ca2e7a2b8f1fdb2976a3
exposed:              True
exposed-modules:      System.Entropy
hidden-modules:       System.EntropyNix
import-dirs:          /usr/lib/ghc-9.4.8/site-local/entropy-0.4.1.11
library-dirs:         /usr/lib/ghc-9.4.8/site-local/entropy-0.4.1.11
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/entropy-0.4.1.11
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-entropy
hs-libraries:         HSentropy-0.4.1.11-KgGl1Y7Pn5mDV1IyWdAGFR
depends:              base-4.17.2.1 bytestring-0.11.5.3 unix-2.7.3
haddock-interfaces:   /usr/share/doc/haskell-entropy/html/entropy.haddock
haddock-html:         /usr/share/doc/haskell-entropy/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

