#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 bytestring-to-vector
version:              0.3.0.1
visibility:           public
id:                   bytestring-to-vector-0.3.0.1-FP9annBtzhQB0ZNnC54vWE
key:                  bytestring-to-vector-0.3.0.1-FP9annBtzhQB0ZNnC54vWE
license:              BSD-3-Clause
maintainer:           Sven Heyll <sven.heyll@gmail.com>
author:               Keegan McAllister <mcallister.keegan@gmail.com>
homepage:             https://github.com/sheyll/bytestring-to-vector
synopsis:
    Convert between ByteString and Vector.Storable without copying

description:
    This library allows conversion between the types from @Data.ByteString@
    (package @bytestring@) and @Data.Vector.Storable@ (package @vector@) without
    copying the underlying data.  This is useful, for example, when @ByteString@
    IO produces or consumes vectors of numbers in native byte order.

    The conversion relies on the fact that @ByteString@ and @Vector@ use their
    respective @ForeignPtr@s in compatible ways.

    This library is a fork of the @spool@ package written by Keegan McAllister.

category:             Data Structures
abi:                  5c28837115d7abef628cb9ed5e58e862
exposed:              True
exposed-modules:      Data.Vector.Storable.ByteString
import-dirs:          /usr/lib/ghc-9.4.8/site-local/bytestring-to-vector-0.3.0.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/bytestring-to-vector-0.3.0.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/bytestring-to-vector-0.3.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-bytestring-to-vector
hs-libraries:         HSbytestring-to-vector-0.3.0.1-FP9annBtzhQB0ZNnC54vWE
depends:
    base-4.17.2.1 bytestring-0.11.5.3
    vector-0.13.2.0-DhQEcquLn8PDmAHUsOvAGS

haddock-interfaces:
    /usr/share/doc/haskell-bytestring-to-vector/html/bytestring-to-vector.haddock

haddock-html:         /usr/share/doc/haskell-bytestring-to-vector/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

