/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.attributes.Category;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.LocalConfigurationMetadataBuilder;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.VirtualComponentIdentifier;
import org.gradle.internal.component.local.model.BuildableLocalComponentMetadata;
import org.gradle.internal.component.local.model.BuildableLocalConfigurationMetadata;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.component.local.model.LocalConfigurationGraphResolveMetadata;
import org.gradle.internal.component.local.model.LocalConfigurationMetadata;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.local.model.MissingLocalArtifactMetadata;
import org.gradle.internal.component.local.model.PublishArtifactLocalArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.DefaultVariantMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.ImmutableModuleSources;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ModelContainer;

public class DefaultLocalComponentMetadata
implements LocalComponentMetadata,
BuildableLocalComponentMetadata {
    private final Map<String, DefaultLocalConfigurationMetadata> allConfigurations = Maps.newLinkedHashMap();
    private final SetMultimap<String, LocalVariantMetadata> allVariants = LinkedHashMultimap.create();
    private final ComponentIdentifier componentId;
    private final ModuleVersionIdentifier moduleVersionId;
    private final String status;
    private final AttributesSchemaInternal attributesSchema;
    protected final ModelContainer<?> model;
    protected final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final ModuleSources moduleSources = ImmutableModuleSources.of();
    private Optional<List<? extends VariantGraphResolveMetadata>> consumableConfigurations;

    public DefaultLocalComponentMetadata(ModuleVersionIdentifier moduleVersionId, ComponentIdentifier componentId, String status, AttributesSchemaInternal attributesSchema, ModelContainer<?> model, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this.moduleVersionId = moduleVersionId;
        this.componentId = componentId;
        this.status = status;
        this.attributesSchema = attributesSchema;
        this.model = model;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
    }

    @Override
    public ComponentIdentifier getId() {
        return this.componentId;
    }

    @Override
    public ModuleVersionIdentifier getModuleVersionId() {
        return this.moduleVersionId;
    }

    @Override
    public List<? extends DependencyMetadata> getSyntheticDependencies(String configuration) {
        return Collections.emptyList();
    }

    @Override
    public DefaultLocalComponentMetadata copy(ComponentIdentifier componentIdentifier, Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> artifacts) {
        ImmutableList<LocalComponentArtifactMetadata> newArtifacts;
        DefaultLocalComponentMetadata copy = new DefaultLocalComponentMetadata(this.moduleVersionId, componentIdentifier, this.status, this.attributesSchema, this.model, this.calculatedValueContainerFactory);
        for (DefaultLocalConfigurationMetadata configuration : this.allConfigurations.values()) {
            copy.addConfiguration(configuration.getName(), configuration.description, configuration.extendsFrom, (ImmutableSet<String>)configuration.hierarchy, configuration.visible, configuration.transitive, configuration.attributes, configuration.canBeConsumed, configuration.consumptionDeprecation, configuration.canBeResolved, configuration.capabilities, Collections::emptyList);
        }
        HashMap<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> transformedArtifacts = new HashMap<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata>();
        for (Map.Entry entry : this.allVariants.entries()) {
            LocalVariantMetadata oldVariant = (LocalVariantMetadata)entry.getValue();
            oldVariant.prepareToResolveArtifacts();
            newArtifacts = this.copyArtifacts((List<LocalComponentArtifactMetadata>)oldVariant.getArtifacts(), artifacts, (Map<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata>)transformedArtifacts);
            copy.allVariants.put((Object)((String)entry.getKey()), (Object)new LocalVariantMetadata(oldVariant.getName(), oldVariant.getIdentifier(), oldVariant.asDescribable(), oldVariant.getAttributes(), newArtifacts, (ImmutableCapabilities)oldVariant.getCapabilities(), this.calculatedValueContainerFactory));
        }
        for (DefaultLocalConfigurationMetadata configuration : this.allConfigurations.values()) {
            configuration.realizeDependencies();
            configuration.prepareToResolveArtifacts();
            DefaultLocalConfigurationMetadata configurationCopy = copy.allConfigurations.get(configuration.getName());
            configurationCopy.definedDependencies.addAll(configuration.definedDependencies);
            configurationCopy.definedFiles.addAll(configuration.definedFiles);
            configurationCopy.definedExcludes.addAll(configuration.definedExcludes);
            newArtifacts = this.copyArtifacts((List<LocalComponentArtifactMetadata>)configuration.getArtifacts(), artifacts, (Map<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata>)transformedArtifacts);
            configurationCopy.artifacts = this.calculatedValueContainerFactory.create(Describables.of((Object)configurationCopy.description, (Object)"artifacts"), newArtifacts);
            configurationCopy.sourceArtifacts = null;
        }
        return copy;
    }

    private ImmutableList<LocalComponentArtifactMetadata> copyArtifacts(List<LocalComponentArtifactMetadata> artifacts, Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> transformer, Map<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> transformedArtifacts) {
        if (artifacts.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder newArtifacts = new ImmutableList.Builder();
        for (LocalComponentArtifactMetadata oldArtifact : artifacts) {
            newArtifacts.add((Object)this.copyArtifact(oldArtifact, transformer, transformedArtifacts));
        }
        return newArtifacts.build();
    }

    private LocalComponentArtifactMetadata copyArtifact(LocalComponentArtifactMetadata oldArtifact, Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> transformer, Map<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> transformedArtifacts) {
        LocalComponentArtifactMetadata newArtifact = transformedArtifacts.get(oldArtifact);
        if (newArtifact == null) {
            newArtifact = (LocalComponentArtifactMetadata)transformer.transform((Object)oldArtifact);
            transformedArtifacts.put(oldArtifact, newArtifact);
        }
        return newArtifact;
    }

    @Override
    public BuildableLocalConfigurationMetadata addConfiguration(String name, String description, Set<String> extendsFrom, ImmutableSet<String> hierarchy, boolean visible, boolean transitive, ImmutableAttributes attributes, boolean canBeConsumed, DeprecationMessageBuilder.WithDocumentation consumptionDeprecation, boolean canBeResolved, ImmutableCapabilities capabilities, Supplier<List<DependencyConstraint>> consistentResolutionConstraints) {
        assert (hierarchy.contains((Object)name));
        DefaultLocalConfigurationMetadata conf = new DefaultLocalConfigurationMetadata(name, description, visible, transitive, extendsFrom, hierarchy, attributes, canBeConsumed, consumptionDeprecation, canBeResolved, capabilities, this.model, this.calculatedValueContainerFactory);
        this.addToConfigurations(name, conf);
        return conf;
    }

    protected void addToConfigurations(String name, DefaultLocalConfigurationMetadata conf) {
        this.allConfigurations.put(name, conf);
    }

    @Override
    public void addDependenciesAndExcludesForConfiguration(ConfigurationInternal configuration, LocalConfigurationMetadataBuilder localConfigurationMetadataBuilder) {
        DefaultLocalConfigurationMetadata configurationMetadata = this.allConfigurations.get(configuration.getName());
        configurationMetadata.configurationMetadataBuilder = localConfigurationMetadataBuilder;
        configurationMetadata.backingConfiguration = configuration;
    }

    public String toString() {
        return this.componentId.getDisplayName();
    }

    @Override
    public ModuleSources getSources() {
        return this.moduleSources;
    }

    @Override
    public ComponentResolveMetadata withSources(ModuleSources source) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isMissing() {
        return false;
    }

    @Override
    public boolean isChanging() {
        return false;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public List<String> getStatusScheme() {
        return DEFAULT_STATUS_SCHEME;
    }

    @Override
    public ImmutableList<? extends VirtualComponentIdentifier> getPlatformOwners() {
        return ImmutableList.of();
    }

    @Override
    public Set<String> getConfigurationNames() {
        return this.allConfigurations.keySet();
    }

    @Override
    public synchronized Optional<List<? extends VariantGraphResolveMetadata>> getVariantsForGraphTraversal() {
        if (this.consumableConfigurations == null) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            boolean hasAtLeastOneConsumableConfiguration = false;
            for (DefaultLocalConfigurationMetadata configuration : this.allConfigurations.values()) {
                if (!configuration.isCanBeConsumed() || configuration.getAttributes().isEmpty()) continue;
                hasAtLeastOneConsumableConfiguration = true;
                builder.add((Object)configuration);
            }
            this.consumableConfigurations = hasAtLeastOneConsumableConfiguration ? Optional.of((Object)builder.build()) : Optional.absent();
        }
        return this.consumableConfigurations;
    }

    @Override
    public LocalConfigurationGraphResolveMetadata getConfiguration(String name) {
        return this.allConfigurations.get(name);
    }

    @Override
    public AttributesSchemaInternal getAttributesSchema() {
        return this.attributesSchema;
    }

    @Override
    public ImmutableAttributes getAttributes() {
        return ImmutableAttributes.EMPTY;
    }

    public void reevaluate() {
        for (DefaultLocalConfigurationMetadata conf : this.allConfigurations.values()) {
            conf.reevaluate();
        }
    }

    protected class DefaultLocalConfigurationMetadata
    implements LocalConfigurationMetadata,
    BuildableLocalConfigurationMetadata,
    LocalConfigurationGraphResolveMetadata {
        private final String name;
        private final String description;
        private final boolean transitive;
        private final boolean visible;
        private final ImmutableSet<String> hierarchy;
        private final Set<String> extendsFrom;
        private final ImmutableAttributes attributes;
        private final boolean canBeConsumed;
        private final DeprecationMessageBuilder.WithDocumentation consumptionDeprecation;
        private final boolean canBeResolved;
        private final ImmutableCapabilities capabilities;
        private final ModelContainer<?> model;
        private final CalculatedValueContainerFactory factory;
        private ConfigurationInternal backingConfiguration;
        private boolean reevaluate = true;
        private LocalConfigurationMetadataBuilder configurationMetadataBuilder;
        private final List<LocalOriginDependencyMetadata> definedDependencies = Lists.newArrayList();
        private final List<ExcludeMetadata> definedExcludes = Lists.newArrayList();
        private final List<LocalFileDependencyMetadata> definedFiles = Lists.newArrayList();
        private ImmutableList<LocalOriginDependencyMetadata> configurationDependencies;
        private ImmutableSet<LocalFileDependencyMetadata> configurationFileDependencies;
        private ImmutableList<ExcludeMetadata> configurationExcludes;
        private List<PublishArtifact> sourceArtifacts = Lists.newArrayList();
        private CalculatedValueContainer<ImmutableList<LocalComponentArtifactMetadata>, ?> artifacts;

        protected DefaultLocalConfigurationMetadata(String name, String description, boolean visible, boolean transitive, Set<String> extendsFrom, ImmutableSet<String> hierarchy, ImmutableAttributes attributes, boolean canBeConsumed, DeprecationMessageBuilder.WithDocumentation consumptionDeprecation, boolean canBeResolved, ImmutableCapabilities capabilities, ModelContainer<?> model, CalculatedValueContainerFactory factory) {
            this.name = name;
            this.description = description;
            this.transitive = transitive;
            this.visible = visible;
            this.hierarchy = hierarchy;
            this.extendsFrom = extendsFrom;
            this.attributes = attributes;
            this.canBeConsumed = canBeConsumed;
            this.consumptionDeprecation = consumptionDeprecation;
            this.canBeResolved = canBeResolved;
            this.capabilities = capabilities;
            this.model = model;
            this.factory = factory;
            this.artifacts = factory.create(Describables.of((Object)description, (Object)"artifacts"), context -> {
                if (this.sourceArtifacts.isEmpty() && hierarchy.isEmpty()) {
                    this.sourceArtifacts = null;
                    return ImmutableList.of();
                }
                return (ImmutableList)model.fromMutableState(m -> {
                    LinkedHashSet<LocalComponentArtifactMetadata> result = new LinkedHashSet<LocalComponentArtifactMetadata>(this.sourceArtifacts.size());
                    for (PublishArtifact sourceArtifact : this.sourceArtifacts) {
                        result.add(new PublishArtifactLocalArtifactMetadata(DefaultLocalComponentMetadata.this.componentId, sourceArtifact));
                    }
                    for (String config : hierarchy) {
                        if (config.equals(name)) continue;
                        DefaultLocalConfigurationMetadata parent = (DefaultLocalConfigurationMetadata)DefaultLocalComponentMetadata.this.allConfigurations.get(config);
                        parent.prepareToResolveArtifacts();
                        result.addAll((Collection<LocalComponentArtifactMetadata>)parent.getArtifacts());
                    }
                    this.sourceArtifacts = null;
                    return ImmutableList.copyOf(result);
                });
            });
        }

        @Override
        public ComponentIdentifier getComponentId() {
            return DefaultLocalComponentMetadata.this.componentId;
        }

        @Override
        public void addDependency(LocalOriginDependencyMetadata dependency) {
            this.definedDependencies.add(dependency);
        }

        @Override
        public void addExclude(ExcludeMetadata exclude) {
            this.definedExcludes.add(exclude);
        }

        @Override
        public void addFiles(LocalFileDependencyMetadata files) {
            this.definedFiles.add(files);
        }

        @Override
        public void enableLocking() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.asDescribable().getDisplayName();
        }

        @Override
        public DisplayName asDescribable() {
            return Describables.of((Object)DefaultLocalComponentMetadata.this.componentId, (Object)"configuration", (Object)this.name);
        }

        public ComponentResolveMetadata getComponent() {
            return DefaultLocalComponentMetadata.this;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public Set<String> getExtendsFrom() {
            return this.extendsFrom;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ImmutableSet<String> getHierarchy() {
            return this.hierarchy;
        }

        @Override
        public boolean isTransitive() {
            return this.transitive;
        }

        @Override
        public boolean isVisible() {
            return this.visible;
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return this.attributes;
        }

        public Set<? extends LocalVariantMetadata> getVariants() {
            return DefaultLocalComponentMetadata.this.allVariants.get((Object)this.name);
        }

        @Override
        public boolean isCanBeConsumed() {
            return this.canBeConsumed;
        }

        @Override
        public DeprecationMessageBuilder.WithDocumentation getConsumptionDeprecation() {
            return this.consumptionDeprecation;
        }

        @Override
        public boolean isCanBeResolved() {
            return this.canBeResolved;
        }

        @Override
        public List<? extends LocalOriginDependencyMetadata> getDependencies() {
            if (this.configurationDependencies == null) {
                ImmutableList.Builder result = ImmutableList.builder();
                for (DefaultLocalConfigurationMetadata configuration : DefaultLocalComponentMetadata.this.allConfigurations.values()) {
                    if (!this.include(configuration)) continue;
                    configuration.addDefinedDependencies((ImmutableList.Builder<LocalOriginDependencyMetadata>)result);
                }
                AttributeValue attributeValue = this.getAttributes().findEntry(Category.CATEGORY_ATTRIBUTE);
                if (attributeValue.isPresent() && ((Category)attributeValue.get()).getName().equals("enforced-platform")) {
                    ImmutableList rawDependencies = result.build();
                    result = ImmutableList.builder();
                    for (LocalOriginDependencyMetadata rawDependency : rawDependencies) {
                        result.add((Object)rawDependency.forced());
                    }
                }
                this.configurationDependencies = result.build();
            }
            return this.configurationDependencies;
        }

        List<LocalOriginDependencyMetadata> getSyntheticDependencies() {
            return Collections.emptyList();
        }

        void addDefinedDependencies(ImmutableList.Builder<LocalOriginDependencyMetadata> result) {
            this.realizeDependencies();
            result.addAll(this.definedDependencies);
        }

        @Override
        public Set<LocalFileDependencyMetadata> getFiles() {
            if (this.configurationFileDependencies == null) {
                ImmutableSet.Builder result = ImmutableSet.builder();
                for (DefaultLocalConfigurationMetadata configuration : DefaultLocalComponentMetadata.this.allConfigurations.values()) {
                    if (!this.include(configuration)) continue;
                    configuration.addDefinedFiles((ImmutableSet.Builder<LocalFileDependencyMetadata>)result);
                }
                this.configurationFileDependencies = result.build();
            }
            return this.configurationFileDependencies;
        }

        void addDefinedFiles(ImmutableSet.Builder<LocalFileDependencyMetadata> result) {
            this.realizeDependencies();
            result.addAll(this.definedFiles);
        }

        @Override
        public ImmutableList<ExcludeMetadata> getExcludes() {
            if (this.configurationExcludes == null) {
                ImmutableList.Builder result = ImmutableList.builder();
                for (DefaultLocalConfigurationMetadata configuration : DefaultLocalComponentMetadata.this.allConfigurations.values()) {
                    if (!this.include(configuration)) continue;
                    configuration.addDefinedExcludes((ImmutableList.Builder<ExcludeMetadata>)result);
                }
                this.configurationExcludes = result.build();
            }
            return this.configurationExcludes;
        }

        void addDefinedExcludes(ImmutableList.Builder<ExcludeMetadata> result) {
            this.realizeDependencies();
            result.addAll(this.definedExcludes);
        }

        @Override
        public void addArtifacts(Collection<? extends PublishArtifact> artifacts) {
            this.sourceArtifacts.addAll(artifacts);
        }

        @Override
        public LocalConfigurationMetadata prepareToResolveArtifacts() {
            this.artifacts.finalizeIfNotAlready();
            for (LocalVariantMetadata localVariantMetadata : this.getVariants()) {
                localVariantMetadata.prepareToResolveArtifacts();
            }
            return this;
        }

        public ImmutableList<LocalComponentArtifactMetadata> getArtifacts() {
            return (ImmutableList)this.artifacts.get();
        }

        @Override
        public ComponentArtifactMetadata artifact(IvyArtifactName ivyArtifactName) {
            for (ComponentArtifactMetadata candidate : this.getArtifacts()) {
                if (!candidate.getName().equals(ivyArtifactName)) continue;
                return candidate;
            }
            return new MissingLocalArtifactMetadata(DefaultLocalComponentMetadata.this.componentId, ivyArtifactName);
        }

        @Override
        public CapabilitiesMetadata getCapabilities() {
            return this.capabilities;
        }

        @Override
        public boolean isExternalVariant() {
            return false;
        }

        private boolean include(DefaultLocalConfigurationMetadata configuration) {
            return this.hierarchy.contains((Object)configuration.getName());
        }

        @Override
        public void addVariant(String name, VariantResolveMetadata.Identifier identifier, DisplayName displayName, ImmutableAttributes attributes, ImmutableCapabilities capabilities, Collection<? extends PublishArtifact> artifacts) {
            DefaultLocalComponentMetadata.this.allVariants.put((Object)this.name, (Object)new LocalVariantMetadata(name, identifier, displayName, attributes, artifacts, capabilities, this.model, DefaultLocalComponentMetadata.this.calculatedValueContainerFactory));
        }

        synchronized void realizeDependencies() {
            if (this.reevaluate && this.backingConfiguration != null) {
                this.backingConfiguration.runDependencyActions();
                this.configurationMetadataBuilder.addDependenciesAndExcludes(this, this.backingConfiguration);
            }
            this.reevaluate = false;
        }

        synchronized void reevaluate() {
            this.definedDependencies.clear();
            this.definedFiles.clear();
            this.definedExcludes.clear();
            this.configurationDependencies = null;
            this.configurationExcludes = null;
            this.configurationFileDependencies = null;
            this.reevaluate = true;
        }

        @Override
        public boolean needsReevaluate() {
            return this.reevaluate;
        }
    }

    private class LocalVariantMetadata
    extends DefaultVariantMetadata {
        private final CalculatedValueContainer<ImmutableList<LocalComponentArtifactMetadata>, ?> artifacts;

        public LocalVariantMetadata(String name, VariantResolveMetadata.Identifier identifier, DisplayName displayName, ImmutableAttributes attributes, Collection<? extends PublishArtifact> sourceArtifacts, ImmutableCapabilities capabilities, ModelContainer<?> model, CalculatedValueContainerFactory calculatedValueContainerFactory) {
            super(name, identifier, displayName, attributes, (ImmutableList<? extends ComponentArtifactMetadata>)ImmutableList.of(), capabilities);
            this.artifacts = calculatedValueContainerFactory.create(Describables.of((Object)displayName, (Object)"artifacts"), context -> {
                if (sourceArtifacts.isEmpty()) {
                    return ImmutableList.of();
                }
                return (ImmutableList)model.fromMutableState(m -> {
                    ImmutableList.Builder result = ImmutableList.builderWithExpectedSize((int)sourceArtifacts.size());
                    for (PublishArtifact sourceArtifact : sourceArtifacts) {
                        result.add((Object)new PublishArtifactLocalArtifactMetadata(DefaultLocalComponentMetadata.this.componentId, sourceArtifact));
                    }
                    return result.build();
                });
            });
        }

        public LocalVariantMetadata(String name, VariantResolveMetadata.Identifier identifier, DisplayName displayName, ImmutableAttributes attributes, ImmutableList<LocalComponentArtifactMetadata> artifacts, ImmutableCapabilities capabilities, CalculatedValueContainerFactory calculatedValueContainerFactory) {
            super(name, identifier, displayName, attributes, (ImmutableList<? extends ComponentArtifactMetadata>)ImmutableList.of(), capabilities);
            this.artifacts = calculatedValueContainerFactory.create(Describables.of((Object)displayName, (Object)"artifacts"), artifacts);
        }

        public void prepareToResolveArtifacts() {
            this.artifacts.finalizeIfNotAlready();
        }

        @Override
        public boolean isEligibleForCaching() {
            return true;
        }

        public ImmutableList<LocalComponentArtifactMetadata> getArtifacts() {
            return (ImmutableList)this.artifacts.get();
        }
    }
}

