/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.BuildCancelledException;
import org.gradle.api.NonNullApi;
import org.gradle.execution.plan.ExecutionNodeAccessHierarchy;
import org.gradle.execution.plan.FinalizedExecutionPlan;
import org.gradle.execution.plan.FinalizerGroup;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.execution.plan.MutationInfo;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.NodeComparator;
import org.gradle.execution.plan.OrdinalGroup;
import org.gradle.execution.plan.OrdinalNodeAccess;
import org.gradle.execution.plan.QueryableExecutionPlan;
import org.gradle.execution.plan.WorkSource;
import org.gradle.internal.MutableBoolean;
import org.gradle.internal.Pair;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullApi
public class DefaultFinalizedExecutionPlan
implements WorkSource<Node>,
FinalizedExecutionPlan {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFinalizedExecutionPlan.class);
    public static final Comparator<Node> NODE_EXECUTION_ORDER = new Comparator<Node>(){

        @Override
        public int compare(Node node1, Node node2) {
            if (node1.isPriority() && !node2.isPriority()) {
                return -1;
            }
            if (!node1.isPriority() && node2.isPriority()) {
                return 1;
            }
            if (node1.getIndex() > node2.getIndex()) {
                return 1;
            }
            if (node1.getIndex() < node2.getIndex()) {
                return -1;
            }
            return NodeComparator.INSTANCE.compare(node1, node2);
        }
    };
    private final Set<Node> waitingToStartNodes = new HashSet<Node>();
    private final ExecutionQueue readyNodes = new ExecutionQueue();
    private final List<Throwable> failures = new ArrayList<Throwable>();
    private final String displayName;
    private final ExecutionNodeAccessHierarchy outputHierarchy;
    private final ExecutionNodeAccessHierarchy destroyableHierarchy;
    private final ResourceLockCoordinationService lockCoordinator;
    private final Action<ResourceLock> resourceUnlockListener = this::resourceUnlocked;
    private boolean invalidNodeRunning;
    private final boolean continueOnFailure;
    private final QueryableExecutionPlan contents;
    private final Set<Node> runningNodes = Sets.newIdentityHashSet();
    private final Map<Pair<Node, Node>, Boolean> reachableCache = new HashMap<Pair<Node, Node>, Boolean>();
    private final OrdinalNodeAccess ordinalNodeAccess;
    private final Consumer<LocalTaskNode> completionHandler;
    private boolean maybeNodesSelectable;
    private boolean buildCancelled;

    public DefaultFinalizedExecutionPlan(String displayName, OrdinalNodeAccess ordinalNodeAccess, ExecutionNodeAccessHierarchy outputHierarchy, ExecutionNodeAccessHierarchy destroyableHierarchy, ResourceLockCoordinationService lockCoordinator, List<Node> scheduledNodes, boolean continueOnFailure, QueryableExecutionPlan contents, Consumer<LocalTaskNode> completionHandler) {
        this.displayName = displayName;
        this.outputHierarchy = outputHierarchy;
        this.destroyableHierarchy = destroyableHierarchy;
        this.lockCoordinator = lockCoordinator;
        this.ordinalNodeAccess = ordinalNodeAccess;
        this.continueOnFailure = continueOnFailure;
        this.contents = contents;
        this.completionHandler = completionHandler;
        LinkedHashMultimap reachableGroups = LinkedHashMultimap.create();
        for (Node node : scheduledNodes) {
            if (node.getFinalizerGroup() == null) continue;
            node.getFinalizerGroup().scheduleMembers((SetMultimap<FinalizerGroup, FinalizerGroup>)reachableGroups);
        }
        for (int i = 0; i < scheduledNodes.size(); ++i) {
            Node node;
            node = scheduledNodes.get(i);
            node.setIndex(i);
            node.prepareForExecution((Action<Node>)((Action)this::monitoredNodeReady));
            node.updateAllDependenciesComplete();
            this.maybeNodeReady(node);
            if (!node.getDependencyPredecessors().isEmpty()) continue;
            this.waitingToStartNodes.add(node);
        }
        lockCoordinator.addLockReleaseListener(this.resourceUnlockListener);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public QueryableExecutionPlan getContents() {
        return this.contents;
    }

    @Override
    public WorkSource<Node> asWorkSource() {
        return this;
    }

    @Override
    public void close() {
        this.lockCoordinator.removeLockReleaseListener(this.resourceUnlockListener);
        this.waitingToStartNodes.clear();
        this.readyNodes.clear();
        this.runningNodes.clear();
        this.reachableCache.clear();
    }

    private void resourceUnlocked(ResourceLock resourceLock) {
        if (!(resourceLock instanceof WorkerLeaseRegistry.WorkerLease) && !this.readyNodes.isEmpty()) {
            this.maybeNodesSelectable = true;
        }
    }

    @Override
    public WorkSource.State executionState() {
        this.lockCoordinator.assertHasStateLock();
        if (this.waitingToStartNodes.isEmpty()) {
            return WorkSource.State.NoMoreWorkToStart;
        }
        if (!this.readyNodes.isEmpty() && this.maybeNodesSelectable) {
            return WorkSource.State.MaybeWorkReadyToStart;
        }
        return WorkSource.State.NoWorkReadyToStart;
    }

    @Override
    public WorkSource.Diagnostics healthDiagnostics() {
        this.lockCoordinator.assertHasStateLock();
        ArrayList<String> ordinalGroups = new ArrayList<String>();
        for (OrdinalGroup ordinalGroup : this.ordinalNodeAccess.getAllGroups()) {
            ordinalGroups.add(ordinalGroup.diagnostics());
        }
        ArrayList<String> waitingToStartItems = new ArrayList<String>(this.waitingToStartNodes.size());
        for (Node node2 : this.waitingToStartNodes) {
            waitingToStartItems.add(node2.healthDiagnostics());
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.readyNodes.size());
        for (Node node3 : this.readyNodes.nodes) {
            arrayList.add(node3.toString());
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        this.visitWaitingNodes(node -> {
            if (!this.waitingToStartNodes.contains(node)) {
                otherWaitingItems.add(node.healthDiagnostics());
            }
        });
        return new WorkSource.Diagnostics(this.displayName, ordinalGroups, waitingToStartItems, arrayList, arrayList2);
    }

    private void visitWaitingNodes(Consumer<Node> visitor) {
        ArrayList<Node> queue = new ArrayList<Node>(this.waitingToStartNodes);
        HashSet<Node> visited = new HashSet<Node>();
        HashSet<Node> visiting = new HashSet<Node>();
        while (!queue.isEmpty()) {
            Node node = (Node)queue.get(0);
            if (node.isComplete() || visited.contains(node)) {
                queue.remove(0);
                continue;
            }
            if (visiting.add(node)) {
                int pos = 0;
                for (Node successor : node.getHardSuccessors()) {
                    queue.add(pos++, successor);
                }
                continue;
            }
            visitor.accept(node);
            visited.add(node);
        }
    }

    @Override
    public WorkSource.Selection<Node> selectNext() {
        this.lockCoordinator.assertHasStateLock();
        if (this.waitingToStartNodes.isEmpty()) {
            return WorkSource.Selection.noMoreWorkToStart();
        }
        if (this.readyNodes.isEmpty() || !this.maybeNodesSelectable) {
            return WorkSource.Selection.noWorkReadyToStart();
        }
        ArrayList<ResourceLock> resources = new ArrayList<ResourceLock>();
        this.readyNodes.restart();
        while (this.readyNodes.hasNext()) {
            Node node = this.readyNodes.next();
            if (node.allDependenciesComplete()) {
                if (!node.allDependenciesSuccessful()) {
                    if (node.shouldCancelExecutionDueToDependencies()) {
                        node.cancelExecution(this::recordNodeCompleted);
                    } else {
                        node.markFailedDueToDependencies(this::recordNodeCompleted);
                    }
                    this.readyNodes.removeAndRestart(node);
                    continue;
                }
                if (node.hasPendingPreExecutionNodes()) {
                    node.visitPreExecutionNodes(prepareNode -> {
                        prepareNode.setIndex(node.getIndex());
                        prepareNode.require();
                        prepareNode.updateAllDependenciesComplete();
                        node.addDependencySuccessor((Node)prepareNode);
                        this.addNodeToPlan((Node)prepareNode);
                    });
                    node.forceAllDependenciesCompleteUpdate();
                    if (!node.allDependenciesComplete()) {
                        this.readyNodes.removeAndRestart(node);
                        continue;
                    }
                }
                if (this.attemptToStart(node, resources)) {
                    this.readyNodes.remove();
                    this.waitingToStartNodes.remove(node);
                    node.getMutationInfo().started();
                    return WorkSource.Selection.of(node);
                }
            }
            if (!node.isComplete()) continue;
            this.readyNodes.remove();
        }
        this.maybeNodesSelectable = false;
        if (this.waitingToStartNodes.isEmpty()) {
            return WorkSource.Selection.noMoreWorkToStart();
        }
        return WorkSource.Selection.noWorkReadyToStart();
    }

    private void addNodeToPlan(Node node) {
        if (node.getDependencyPredecessors().isEmpty()) {
            this.waitingToStartNodes.add(node);
        }
        this.maybeNodeReady(node);
    }

    private boolean attemptToStart(Node node, List<ResourceLock> resources) {
        resources.clear();
        if (!this.tryAcquireLocksForNode(node, resources)) {
            this.releaseLocks(resources);
            return false;
        }
        MutationInfo mutations = node.getMutationInfo();
        if (this.conflictsWithOtherNodes(node, mutations)) {
            this.releaseLocks(resources);
            return false;
        }
        node.startExecution(this::recordNodeExecutionStarted);
        if (mutations.hasValidationProblem) {
            this.invalidNodeRunning = true;
        }
        return true;
    }

    private void releaseLocks(List<ResourceLock> resources) {
        for (ResourceLock resource : resources) {
            resource.unlock();
        }
    }

    private boolean tryAcquireLocksForNode(Node node, List<ResourceLock> resources) {
        if (!this.tryLockProjectFor(node, resources)) {
            LOGGER.debug("Cannot acquire project lock for node {}", (Object)node);
            return false;
        }
        if (!this.tryLockSharedResourceFor(node, resources)) {
            LOGGER.debug("Cannot acquire shared resource lock for node {}", (Object)node);
            return false;
        }
        return true;
    }

    private boolean conflictsWithOtherNodes(Node node, MutationInfo mutations) {
        if (!this.canRunWithCurrentlyExecutedNodes(mutations)) {
            LOGGER.debug("Node {} cannot run with currently running nodes {}", (Object)node, this.runningNodes);
            return true;
        }
        if (this.mutationConflictsWithOtherNodes(node, mutations)) {
            return true;
        }
        if (this.destroysNotYetConsumedOutputOfAnotherNode(node, mutations.destroyablePaths)) {
            LOGGER.debug("Node {} destroys not yet consumed output of another node", (Object)node);
            return true;
        }
        return false;
    }

    private void updateAllDependenciesCompleteForPredecessors(Node node) {
        node.visitAllNodesWaitingForThisNode(dependent -> {
            dependent.onNodeComplete(node);
            this.maybeNodeReady((Node)dependent);
        });
    }

    private boolean tryLockProjectFor(Node node, List<ResourceLock> resources) {
        ResourceLock toLock = node.getProjectToLock();
        if (toLock == null) {
            return true;
        }
        if (toLock.tryLock()) {
            resources.add(toLock);
            return true;
        }
        return false;
    }

    private void unlockProjectFor(Node node) {
        ResourceLock toUnlock = node.getProjectToLock();
        if (toUnlock != null) {
            toUnlock.unlock();
        }
    }

    private boolean tryLockSharedResourceFor(Node node, List<ResourceLock> resources) {
        for (ResourceLock resourceLock : node.getResourcesToLock()) {
            if (!resourceLock.tryLock()) {
                return false;
            }
            resources.add(resourceLock);
        }
        return true;
    }

    private void unlockSharedResourcesFor(Node node) {
        node.getResourcesToLock().forEach(ResourceLock::unlock);
    }

    private boolean canRunWithCurrentlyExecutedNodes(MutationInfo mutations) {
        if (mutations.hasValidationProblem) {
            return this.runningNodes.isEmpty();
        }
        return !this.invalidNodeRunning;
    }

    private boolean mutationConflictsWithOtherNodes(Node node, MutationInfo mutations) {
        Set<String> nodeOutputPaths = mutations.outputPaths;
        Set<String> nodeDestroysPaths = mutations.destroyablePaths;
        if (nodeOutputPaths.isEmpty() && nodeDestroysPaths.isEmpty()) {
            return false;
        }
        BiFunction<Boolean, Node, Boolean> conflictsWithRunning = (current, candidate) -> current != false || candidate.isExecuting();
        OrdinalGroup nodeOrdinal = node.getOrdinal();
        BiFunction<Boolean, Node, Boolean> conflictsWithNodeInEarlierOrdinal = (current, candidate) -> {
            if (current.booleanValue() || candidate.isComplete()) {
                return current;
            }
            OrdinalGroup otherOrdinal = candidate.getOrdinal();
            return otherOrdinal != null && otherOrdinal.getOrdinal() < nodeOrdinal.getOrdinal();
        };
        for (String path : nodeOutputPaths) {
            if (this.outputHierarchy.visitNodesAccessing(path, false, conflictsWithRunning).booleanValue()) {
                return true;
            }
            if (nodeOrdinal == null || !this.destroyableHierarchy.visitNodesAccessing(path, false, conflictsWithNodeInEarlierOrdinal).booleanValue()) continue;
            return true;
        }
        for (String path : nodeDestroysPaths) {
            if (this.destroyableHierarchy.visitNodesAccessing(path, false, conflictsWithRunning).booleanValue()) {
                return true;
            }
            if (nodeOrdinal == null || !this.outputHierarchy.visitNodesAccessing(path, false, conflictsWithNodeInEarlierOrdinal).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean destroysNotYetConsumedOutputOfAnotherNode(Node destroyer, Set<String> destroyablePaths) {
        if (destroyablePaths.isEmpty()) {
            return false;
        }
        BiFunction<Boolean, Node, Boolean> conflicts = (current, producingNode) -> {
            if (current.booleanValue()) {
                return current;
            }
            if (!producingNode.getMutationInfo().isOutputProducedButNotYetConsumed()) {
                return false;
            }
            MutationInfo producingNodeMutations = producingNode.getMutationInfo();
            for (Node consumer : producingNodeMutations.getNodesYetToConsumeOutput()) {
                if (this.doesConsumerDependOnDestroyer(consumer, destroyer)) continue;
                LOGGER.debug("Node {} destroys output of consumer {}", (Object)destroyer, (Object)consumer);
                return true;
            }
            return false;
        };
        for (String destroyablePath : destroyablePaths) {
            if (!this.outputHierarchy.visitNodesAccessing(destroyablePath, false, conflicts).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean doesConsumerDependOnDestroyer(Node consumer, Node destroyer) {
        if (consumer == destroyer) {
            return true;
        }
        Pair nodePair = Pair.of((Object)consumer, (Object)destroyer);
        if (this.reachableCache.get(nodePair) != null) {
            return this.reachableCache.get(nodePair);
        }
        boolean reachable = false;
        for (Node dependency : consumer.getAllSuccessors()) {
            if (dependency.isComplete() || !this.doesConsumerDependOnDestroyer(dependency, destroyer)) continue;
            reachable = true;
        }
        this.reachableCache.put((Pair<Node, Node>)nodePair, reachable);
        return reachable;
    }

    private void recordNodeExecutionStarted(Node node) {
        this.runningNodes.add(node);
    }

    private void recordNodeCompleted(Node node) {
        LOGGER.debug("Node {} completed, executed: {}", (Object)node, (Object)node.isExecuted());
        this.waitingToStartNodes.remove(node);
        if (this.continueOnFailure && !node.allDependenciesComplete()) {
            for (Node successor : node.getDependencySuccessors()) {
                if (!successor.isRequired()) continue;
                this.waitingToStartNodes.add(successor);
            }
        }
        for (Node producer : node.getDependencySuccessors()) {
            MutationInfo producerMutations = producer.getMutationInfo();
            producerMutations.consumerCompleted(node);
        }
        this.updateAllDependenciesCompleteForPredecessors(node);
        if (node instanceof LocalTaskNode) {
            try {
                this.completionHandler.accept((LocalTaskNode)node);
            }
            catch (Throwable t) {
                this.failures.add(t);
            }
        }
    }

    private void monitoredNodeReady(Node node) {
        this.lockCoordinator.assertHasStateLock();
        node.updateAllDependenciesComplete();
        this.maybeNodeReady(node);
    }

    @Override
    public void finishedExecuting(Node node, @Nullable Throwable failure) {
        this.lockCoordinator.assertHasStateLock();
        try {
            this.runningNodes.remove(node);
            if (failure != null) {
                node.setExecutionFailure(failure);
            }
            if (!node.isExecuting()) {
                throw new IllegalStateException(String.format("Cannot finish executing %s as it is in an unexpected state %s.", new Object[]{node, node.getState()}));
            }
            if (!this.readyNodes.isEmpty()) {
                this.maybeNodesSelectable = true;
            }
            node.finishExecution(this::recordNodeCompleted);
            if (node.isFailed()) {
                LOGGER.debug("Node {} failed", (Object)node);
                this.handleFailure(node);
            } else {
                LOGGER.debug("Node {} finished executing", (Object)node);
                node.visitPostExecutionNodes(postNode -> {
                    postNode.setIndex(node.getIndex());
                    postNode.require();
                    postNode.updateAllDependenciesComplete();
                    this.addNodeToPlan((Node)postNode);
                    for (Node predecessor : node.getDependencyPredecessors()) {
                        predecessor.addDependencySuccessor((Node)postNode);
                        predecessor.forceAllDependenciesCompleteUpdate();
                        if (predecessor.allDependenciesComplete()) continue;
                        this.readyNodes.removeAndRestart(predecessor);
                    }
                });
            }
        }
        finally {
            this.unlockProjectFor(node);
            this.unlockSharedResourcesFor(node);
            this.invalidNodeRunning = false;
        }
    }

    private void maybeNodeReady(Node node) {
        if (node.allDependenciesComplete()) {
            this.maybeNodesSelectable = true;
            this.readyNodes.insert(node);
        }
    }

    private void handleFailure(Node node) {
        Throwable executionFailure = node.getExecutionFailure();
        if (executionFailure != null) {
            this.failures.add(executionFailure);
            this.abortExecution();
            return;
        }
        Throwable nodeFailure = node.getNodeFailure();
        if (nodeFailure != null) {
            this.failures.add(node.getNodeFailure());
            if (!this.continueOnFailure) {
                this.abortExecution();
            }
        }
    }

    private boolean abortExecution() {
        return this.abortExecution(false);
    }

    @Override
    public void abortAllAndFail(Throwable t) {
        this.lockCoordinator.assertHasStateLock();
        this.failures.add(t);
        this.abortExecution(true);
    }

    @Override
    public void cancelExecution() {
        this.lockCoordinator.assertHasStateLock();
        this.buildCancelled = this.abortExecution() || this.buildCancelled;
    }

    private boolean abortExecution(boolean abortAll) {
        MutableBoolean cancelled = new MutableBoolean();
        this.visitWaitingNodes(node -> {
            if (node.isRequired() && (abortAll || node.isCanCancel())) {
                node.cancelExecution(this::recordNodeCompleted);
                cancelled.set(true);
            }
        });
        if (cancelled.get()) {
            this.maybeNodesSelectable = true;
            return true;
        }
        return false;
    }

    @Override
    public void collectFailures(Collection<? super Throwable> failures) {
        failures.addAll(this.failures);
        if (this.buildCancelled && failures.isEmpty()) {
            failures.add((Throwable)new BuildCancelledException());
        }
    }

    @Override
    public boolean allExecutionComplete() {
        return this.waitingToStartNodes.isEmpty() && this.runningNodes.isEmpty();
    }

    static class ExecutionQueue {
        private final Set<Node> nodes = new TreeSet<Node>(NODE_EXECUTION_ORDER);
        private Iterator<Node> current;

        ExecutionQueue() {
        }

        public void clear() {
            this.nodes.clear();
            this.current = null;
        }

        public boolean isEmpty() {
            return this.nodes.isEmpty();
        }

        public int size() {
            return this.nodes.size();
        }

        public void restart() {
            this.current = this.nodes.iterator();
        }

        public boolean hasNext() {
            return this.current.hasNext();
        }

        public Node next() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            return this.current.next();
        }

        public void remove() {
            this.current.remove();
        }

        public void removeAndRestart(Node node) {
            this.nodes.remove(node);
            this.restart();
        }

        public void insert(Node node) {
            if (this.nodes.add(node)) {
                this.current = null;
            }
        }
    }
}

