/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.providers.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderInternals;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\"\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u00052\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J*\u0010\u0015\u001a\u00020\u00162\u0010\u0010\u0017\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u00182\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J&\u0010\u0019\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00182\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J&\u0010\u001b\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00182\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirCompositeSymbolProvider;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "providers", "", "(Lorg/jetbrains/kotlin/fir/FirSession;Ljava/util/List;)V", "getProviders", "()Ljava/util/List;", "getClassLikeSymbolByClassId", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getPackage", "Lorg/jetbrains/kotlin/name/FqName;", "fqName", "getTopLevelCallableSymbols", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "packageFqName", "name", "Lorg/jetbrains/kotlin/name/Name;", "getTopLevelCallableSymbolsTo", "", "destination", "", "getTopLevelFunctionSymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getTopLevelPropertySymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;"})
public final class FirCompositeSymbolProvider
extends FirSymbolProvider {
    @NotNull
    private final List<FirSymbolProvider> providers;

    public FirCompositeSymbolProvider(@NotNull FirSession session2, @NotNull List<? extends FirSymbolProvider> providers) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        super(session2);
        this.providers = providers;
    }

    @NotNull
    public final List<FirSymbolProvider> getProviders() {
        return this.providers;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FirCallableSymbol<?>> getTopLevelCallableSymbols(@NotNull FqName packageFqName, @NotNull Name name) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Iterable $this$flatMap$iv = this.providers;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            FirSymbolProvider it = (FirSymbolProvider)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getTopLevelCallableSymbols(packageFqName, name);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelCallableSymbolsTo(@NotNull List<FirCallableSymbol<?>> destination, @NotNull FqName packageFqName, @NotNull Name name) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CollectionsKt.addAll((Collection)destination, (Iterable)this.getTopLevelCallableSymbols(packageFqName, name));
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelFunctionSymbolsTo(@NotNull List<FirNamedFunctionSymbol> destination, @NotNull FqName packageFqName, @NotNull Name name) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Iterable $this$forEach$iv = this.providers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirSymbolProvider it = (FirSymbolProvider)element$iv;
            boolean bl = false;
            it.getTopLevelFunctionSymbolsTo(destination, packageFqName, name);
        }
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelPropertySymbolsTo(@NotNull List<FirPropertySymbol> destination, @NotNull FqName packageFqName, @NotNull Name name) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Iterable $this$forEach$iv = this.providers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirSymbolProvider it = (FirSymbolProvider)element$iv;
            boolean bl = false;
            it.getTopLevelPropertySymbolsTo(destination, packageFqName, name);
        }
    }

    @Override
    @Nullable
    public FqName getPackage(@NotNull FqName fqName2) {
        FqName fqName3;
        block1: {
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            for (FirSymbolProvider it : (Iterable)this.providers) {
                boolean bl = false;
                FqName fqName4 = it.getPackage(fqName2);
                if (fqName4 == null) continue;
                fqName3 = fqName4;
                break block1;
            }
            fqName3 = null;
        }
        return fqName3;
    }

    @Override
    @Nullable
    public FirClassLikeSymbol<?> getClassLikeSymbolByClassId(@NotNull ClassId classId) {
        FirClassLikeSymbol<?> firClassLikeSymbol;
        block1: {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            for (FirSymbolProvider it : (Iterable)this.providers) {
                boolean bl = false;
                FirClassLikeSymbol<?> firClassLikeSymbol2 = it.getClassLikeSymbolByClassId(classId);
                if (firClassLikeSymbol2 == null) continue;
                firClassLikeSymbol = firClassLikeSymbol2;
                break block1;
            }
            firClassLikeSymbol = null;
        }
        return firClassLikeSymbol;
    }
}

