/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.cmd.PointReference;
import tim.prune.cmd.RearrangePointsCmd;
import tim.prune.data.Checker;
import tim.prune.data.DataPoint;
import tim.prune.data.SortMode;
import tim.prune.data.Track;
import tim.prune.function.RearrangeFunction;

public class RearrangeWaypointsFunction
extends RearrangeFunction {
    public RearrangeWaypointsFunction(App app) {
        super(app, true);
    }

    @Override
    public String getNameKey() {
        return "function.rearrangewaypoints";
    }

    @Override
    protected boolean isSortByTimeAllowed() {
        return Checker.haveWaypointsGotTimestamps(this._app.getTrackInfo().getTrack());
    }

    @Override
    public String getDescriptionKey() {
        return "dialog.rearrangewaypoints.desc";
    }

    @Override
    protected String getSortNameKey() {
        return "sortbyname";
    }

    @Override
    protected void finish() {
        RearrangeFunction.Rearrange rearrange = this.getRearrangeOption();
        SortMode sortMode = this.getSortMode();
        List<PointReference> list = rearrange == RearrangeFunction.Rearrange.TO_START || rearrange == RearrangeFunction.Rearrange.TO_END ? this.collectWaypoints(rearrange, sortMode) : this.interleaveWaypoints();
        if (list == null || RearrangeWaypointsFunction.isResultANop(list)) {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getText("error.rearrange.noop"), I18nManager.getText("error.function.noop.title"), 2);
        } else {
            RearrangePointsCmd rearrangePointsCmd = RearrangePointsCmd.from(list);
            rearrangePointsCmd.setDescription(this.getName());
            rearrangePointsCmd.setConfirmText(I18nManager.getText("confirm.rearrangewaypoints"));
            this._app.execute(rearrangePointsCmd);
        }
    }

    private List<PointReference> collectWaypoints(RearrangeFunction.Rearrange rearrange, SortMode sortMode) {
        boolean bl;
        Object object;
        Track track = this._app.getTrackInfo().getTrack();
        int n = track.getNumPoints();
        ArrayList<PointReference> arrayList = new ArrayList<PointReference>();
        ArrayList<PointReference> arrayList2 = new ArrayList<PointReference>();
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        while (n2 < n) {
            DataPoint dataPoint = track.getPoint(n2);
            object = new PointReference(n2, sortMode == SortMode.SORTBY_NAME ? dataPoint.getWaypointName() : null, sortMode == SortMode.SORTBY_TIME ? dataPoint.getTimestamp() : null);
            if (dataPoint.isWaypoint()) {
                arrayList.add((PointReference)object);
                bl2 |= !arrayList2.isEmpty();
            } else {
                arrayList2.add((PointReference)object);
                bl3 |= !arrayList.isEmpty();
            }
            ++n2;
        }
        n2 = rearrange == RearrangeFunction.Rearrange.TO_START ? 1 : 0;
        boolean bl4 = bl = sortMode != SortMode.DONT_SORT;
        if (arrayList.isEmpty() || n2 != 0 && !bl2 && bl3 && !bl || n2 == 0 && bl2 && !bl3 && !bl || rearrange == RearrangeFunction.Rearrange.TO_NEAREST) {
            return null;
        }
        if (bl) {
            Collections.sort(arrayList);
        }
        object = new ArrayList();
        if (n2 != 0) {
            object.addAll(arrayList);
            object.addAll(arrayList2);
        } else {
            object.addAll(arrayList2);
            object.addAll(arrayList);
        }
        return object;
    }

    private List<PointReference> interleaveWaypoints() {
        Track track = this._app.getTrackInfo().getTrack();
        int n = track.getNumPoints();
        ArrayList<PointReference> arrayList = new ArrayList<PointReference>();
        int n2 = 0;
        while (n2 < n) {
            DataPoint dataPoint = track.getPoint(n2);
            if (dataPoint.isWaypoint()) {
                arrayList.add(new PointReference(n2, track.getNearestTrackPointIndex(n2)));
            } else {
                arrayList.add(new PointReference(n2, n2));
            }
            ++n2;
        }
        Collections.sort(arrayList);
        return arrayList;
    }
}

