 [![pipeline status](https://gitlab.com/gitlab-org/ruby/gems/gitlab-security_report_schemas/badges/main/pipeline.svg)](https://gitlab.com/gitlab-org/ruby/gems/gitlab-security_report_schemas/-/commits/main)
 [![coverage report](https://gitlab.com/gitlab-org/ruby/gems/gitlab-security_report_schemas/badges/main/coverage.svg)](https://gitlab.com/gitlab-org/ruby/gems/gitlab-security_report_schemas/-/commits/main) 
 [![Latest Release](https://gitlab.com/gitlab-org/ruby/gems/gitlab-security_report_schemas/-/badges/release.svg)](https://gitlab.com/gitlab-org/ruby/gems/gitlab-security_report_schemas/-/releases)

# Gitlab::SecurityReportSchemas

Rubygem for https://gitlab.com/gitlab-org/security-products/security-report-schemas/

This gem provides a Ruby and command line interface to validate the report artifact generated by the security analyzers.

## Installation

Install the gem and add to the application's Gemfile by executing:

    $ bundle add gitlab-security_report_schemas

If bundler is not being used to manage dependencies, install the gem by executing:

    $ gem install gitlab-security_report_schemas

## Usage

### Ruby interface

```ruby
require "security_report_schemas"

file_path = "path_of_the_report_file"
report_content = File.read(file_path)
data = JSON.parse(report_content)
validator = Gitlab::SecurityReportSchemas::Validator.new(data, "sast", "15.0.0")

validator.valid? # true/false
validator.errors # An array of error messages
validator.warnings # An array of warning messages
```

### CLI

You can use the executable to check validity of your report artifact, like so;

```sh
bundle exec security-reports-schemas $FILE_PATH
```

### Environment variables

#### Credentials

| Key                         | Description                                                                                   |
|-----------------------------|-----------------------------------------------------------------------------------------------|
| `GITLAB_PUSH_ACCESS_TOKEN`  | Own project access token used to push new schema versions. Requires `write_repository` scope. |
| `GITLAB_ISSUE_ACCESS_TOKEN` | Project access token used to create an issue on `gitlab-org/gitlab`. Requires `api` scopes.   |
| `GEM_HOST_API_KEY`          | rubygems.org API key                                                                          |

#### Configuration

| Key                       | Default                                                | Description                            |
|---------------------------|--------------------------------------------------------|----------------------------------------|
| `SCHEMAS_PATH`            | `./schemas`                                            | Schema storage location                |
| `SCHEMA_PROJECT`          | `gitlab-org/security-products/security-report-schemas` | Where to source schemas                |
| `GITLAB_PROJECT`          | `gitlab-org/gitlab`                                    | Project to open MRs for                |
| `ISSUE_TARGET_PROJECT_ID` | `278964` (`gitlab-org/gitlab`)                         | Project ID for which to open an issue. |

## Maintenance

See [`RUNBOOK.md`](./RUNBOOK.md) for solutions to common maintenance tasks.

## Development

### Updating the schemas

You can use the `rake prepare_schemas[versions]` rake task to update the schemas, like so;

```sh
rake "prepare_schemas[14.0.0 14.0.1 14.0.2 14.0.3 14.0.4]"
```

This will download the following schema versions: "14.0.0", "14.0.1", "14.0.2", "14.0.3", "14.0.4".

Check `rake -T` for other available tasks

## Contributing

See [`CONTRIBUTING.md`](CONTRIBUTING.md).

## License

See [`LICENSE.txt`](LICENSE.txt).
