# frozen_string_literal: true

module Gitlab
  module CloudConnector
    module DataModel
      class AbstractDataLoader
        def initialize(model_class)
          @model_class = model_class
        end

        def load!
          raise NotImplementedError, "#{self.class} must implement #load!"
        end

        protected

        attr_reader :model_class
      end
    end
  end
end
