# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: diff.proto for package 'gitaly'

require 'grpc'
require 'diff_pb'

module Gitaly
  module DiffService
    # DiffService is a service which provides RPCs to inspect differences
    # introduced between a set of commits.
    class Service

      include ::GRPC::GenericService

      self.marshal_class_method = :encode
      self.unmarshal_class_method = :decode
      self.service_name = 'gitaly.DiffService'

      # CommitDiff returns a diff between two different commits. The patch data is
      # chunked across messages and get streamed back to the client.
      rpc :CommitDiff, ::Gitaly::CommitDiffRequest, stream(::Gitaly::CommitDiffResponse)
      # CommitDelta returns the deltas between two different commits. A delta
      # includes everything that changed about a set of paths except for the actual
      # diff.
      rpc :CommitDelta, ::Gitaly::CommitDeltaRequest, stream(::Gitaly::CommitDeltaResponse)
      # RawDiff returns a diff between two commits. The output is the unmodified
      # output from git-diff(1). This is not to be confused with git-diff(1)'s
      # --raw mode.
      rpc :RawDiff, ::Gitaly::RawDiffRequest, stream(::Gitaly::RawDiffResponse)
      # RawPatch returns a diff between two commits in a formatted patch.The output
      # is the unmodified output from git-format-patch(1). This is not to be confused with
      # git-diff(1)'s --raw mode.
      rpc :RawPatch, ::Gitaly::RawPatchRequest, stream(::Gitaly::RawPatchResponse)
      # DiffStats returns the diff stats between two commits such as number of lines
      # changed, etc.
      rpc :DiffStats, ::Gitaly::DiffStatsRequest, stream(::Gitaly::DiffStatsResponse)
      # FindChangedPaths returns a list of files changed along with the status of each file
      rpc :FindChangedPaths, ::Gitaly::FindChangedPathsRequest, stream(::Gitaly::FindChangedPathsResponse)
      # GetPatchID computes a patch ID for a patch. Patch IDs are a unique ID computed by hashing
      # a patch with some parameters like line numbers ignored. The patch ID can thus be used to compare
      # whether diffs make the same change. Please refer to git-patch-id(1) for further information.
      # If the difference between old and new change is empty then this RPC returns an error.
      # VerbatimPatchID feature flag can be switched on to enable --verbatim mode to not strip whitespace changes
      # before generating a patch ID. Whitespace changes can affect the underlying functionality of the code
      # depending on the language used so it's preferable to default to that option.
      rpc :GetPatchID, ::Gitaly::GetPatchIDRequest, ::Gitaly::GetPatchIDResponse
      # RawRangeDiff outputs the raw range diff data for a given range specification.
      rpc :RawRangeDiff, ::Gitaly::RawRangeDiffRequest, stream(::Gitaly::RawRangeDiffResponse)
      # RangeDiff outputs the parsed commit pairs from range diff for a given range specification.
      rpc :RangeDiff, ::Gitaly::RangeDiffRequest, stream(::Gitaly::RangeDiffResponse)
      # DiffBlobs computes diffs between pairs of blobs. A batch of blob pairs is sent to the server.
      # The resulting patches are then chucked across response messages and streamed to the client.
      rpc :DiffBlobs, ::Gitaly::DiffBlobsRequest, stream(::Gitaly::DiffBlobsResponse)
    end

    Stub = Service.rpc_stub_class
  end
end
