---
stage: Tenant Scale
group: Organizations
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Project visibility, search, badges, layout.
title: Organize work with projects
---

Create projects to host your codebase in GitLab.
You can also use projects to:

- Track issues
- Plan work
- Collaborate on code
- Use CI/CD tools to continuously build, test, and deploy your app

Projects can be available [publicly, internally, or privately](../public_access.md).
GitLab does not limit the number of private projects you can create.

{{< cards >}}

- [Getting started](../get_started/get_started_projects.md)
- [Create a project](_index.md)
- [Manage projects](working_with_projects.md)
- [Project visibility](../public_access.md)
- [Project settings](working_with_projects.md)
- [Description templates](description_templates.md)
- [Project access tokens](settings/project_access_tokens.md)
- [Deploy keys](deploy_keys/_index.md)
- [Deploy tokens](deploy_tokens/_index.md)
- [Reserved project and group names](../reserved_names.md)
- [Search](../search/_index.md)
- [Badges](badges.md)
- [Project topics](project_topics.md)
- [Code intelligence](code_intelligence.md)
- [Import and migrate](import/_index.md)
- [System notes](system_notes.md)
- [Transfer a project to another namespace](import/_index.md)
- [Use a project as a Go package](use_project_as_go_package.md)
- [Tutorial: Build a protected workflow for your project](../../tutorials/protected_workflow/_index.md)
- [Troubleshooting](troubleshooting.md)

{{< /cards >}}
