---
stage: Plan
group: Project Management
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Issues
description: Tasks, bug reports, feature requests, and tracking.
---

{{< details >}}

- Tier: Free, Premium, Ultimate
- Offering: GitLab.com, GitLab Self-Managed, GitLab Dedicated

{{< /details >}}

Issues help you collaborate with your team to plan, track, and deliver work in GitLab.
Issues:

- Track feature proposals, tasks, support requests, and bug reports.
- Organize and prioritize work with assignees, due dates, and health status.
- Facilitate team discussion and decision-making through comments and threaded discussions.
- Support custom workflows through templates, labels, epics, and boards.
- Integrate with external tools like Zoom, Jira, and email services.

For more information about issues, see the GitLab blog post:
[Always start a discussion with an issue](https://about.gitlab.com/blog/2016/03/03/start-with-an-issue/).

Issues are always associated with a specific project. If you have multiple
projects in a group, you can view all of the projects' issues at once.

<div class="video-fallback">
  See the video: <a href="https://www.youtube.com/watch?v=Mt1EzlKToig">Issues - Setting up your Organization with GitLab</a>.
</div>
<figure class="video-container">
  <iframe src="https://www.youtube-nocookie.com/embed/Mt1EzlKToig" frameborder="0" allowfullscreen> </iframe>
</figure>
<!-- Video published on 2023-10-30 -->

<i class="fa fa-youtube-play youtube" aria-hidden="true"></i>
To learn how the GitLab Strategic Marketing department uses GitLab issues with [labels](../labels.md) and
[issue boards](../issue_board.md), see the video on
[Managing Commitments with Issues](https://www.youtube.com/watch?v=cuIHNintg1o&t=3).
<!-- Video published on 2020-04-10 -->

## Related topics

- [Create issues](create_issues.md)
- [Create an issue from a template](../description_templates.md#use-the-templates)
- [Edit issues](managing_issues.md#edit-an-issue)
- [Move issues](managing_issues.md#move-an-issue)
- [Close issues](managing_issues.md#close-an-issue)
- [Delete issues](managing_issues.md#delete-an-issue)
- [Promote issues](managing_issues.md#promote-an-issue-to-an-epic)
- [Set a due date](due_dates.md)
- [Import issues](csv_import.md)
- [Export issues](csv_export.md)
- [Upload designs to issues](design_management.md)
- [Linked issues](related_issues.md)
- [Similar issues](managing_issues.md#similar-issues)
- [Health status](managing_issues.md#health-status)
- [Cross-link issues](crosslinking_issues.md)
- [Sort issue lists](sorting_issue_lists.md)
- [Search for issues](managing_issues.md#filter-the-list-of-issues)
- [Epics](../../group/epics/_index.md)
- [Issue boards](../issue_board.md)
- [Issues API](../../../api/issues.md)
- [Configure an external issue tracker](../../../integration/external-issue-tracker.md)
- [Tasks](../../tasks.md)
- [External participants](../service_desk/external_participants.md)
