---
stage: Software Supply Chain Security
group: Compliance
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Compliance standards
---

{{< details >}}

- Tier: Ultimate
- Offering: GitLab.com, GitLab Self-Managed, GitLab Dedicated

{{< /details >}}

{{< history >}}

- [Introduced](https://gitlab.com/groups/gitlab-org/-/epics/16620) in GitLab 17.11.

{{< /history >}}

You can use [GitLab compliance controls](_index.md#gitlab-compliance-controls) to help meet the requirements of many
compliance standards.

The [Compliance Adherence Templates](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates) project
contains a library of JSON templates. Use these templates to quickly adopt predefined compliance frameworks.

## ISMAP compliance requirements

The Information system Security Management and Assessment Program (ISMAP) aims to secure the security level of the government's cloud service procurement
by evaluating and registering cloud services that meet the security requirements of the government in advance, thereby contributing to the smooth introduction
of cloud services.

The following table lists the requirements supported by GitLab for ISMAP and the controls for the requirements.

| ISMAP requirement                              | Description                                                                                                                                                                                                                                        | Supported controls |
|:-----------------------------------------------|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| 6.1.2 Segregation of duties                    | Conflicting duties and areas of responsibility should be segregated to reduce opportunities for unauthorized or unintentional modification or misuse of the organization's assets.                                                                 | <ul><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| 9.3.1 Use of secret authentication information | Users should be required to follow the organization's practices in the use of secret authentication information.                                                                                                                                   | <ul><li>Secret detection running</li></ul> |
| 9.4.5 Access control to program source code    | Access to program source code should be restricted.                                                                                                                                                                                                | <ul><li>Default branch protected</li></ul> |
| 12.1.2 Change management                       | Changes to the organization, business processes, information processing facilities, and systems that affect information security should be controlled.                                                                                             | <ul><li>Default branch protected</li></ul> |
| 12.6.1 Management of technical vulnerabilities | Information about technical vulnerabilities of information systems being used should be obtained in a timely fashion, the organization's exposure to such vulnerabilities evaluated and appropriate measures taken to address the associated risk. | <ul><li>Dependency scanning running</li><li>Container scanning running</li></ul> |
| 14.2.1 Secure development policy               | Rules for the development of software and systems should be established and applied to developments in the organization.                                                                                                                           | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>SAST running</li><li>DAST running</li><li>API security running</li><li>Secret detection running</li><li>Fuzz testing running</li></ul> |
| 14.2.8 System security testing                 | Testing of security functionality should be carried out during development.                                                                                                                                                                        | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>SAST running</li><li>DAST running</li><li>API security running</li><li>Secret detection running</li><li>Fuzz testing running</li></ul> |
| 18.1.2 Intellectual property rights            | Appropriate procedures should be implemented to ensure compliance with legislative, regulatory, and contractual requirements related to intellectual property rights and use of proprietary software products.                                     | <ul><li>License compliance running</li></ul> |

## ISO 27001 compliance requirements

ISO 27001 is an internationally recognized standard that provides a framework for implementing and managing an
Information Security Management System (ISMS).

The following table lists the requirements supported by GitLab for ISO 27001 and the controls for the requirements.

| ISO 27001 requirement                               | Description                                                                                                                                                                                                  | Supported controls |
|:----------------------------------------------------|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| 5.3 Segregation of duties                           | Conflicting duties and conflicting areas of responsibility shall be segregated.                                              | <ul><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| 5.17 Authentication information                     | Allocation and management of authentication information should be controlled by a management process, including advising personnel on the appropriate handling of authentication information.                | <ul><li>Secret detection running</li></ul> |
| 5.18 Access rights                                  | Access rights to information and other associated assets should be provisioned, reviewed, modified, and removed in accordance with the organization's topic-specific policy on and rules for access control. | <ul><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| 5.32 Intellectual property rights                   | The organization should implement appropriate procedures to protect intellectual property rights.                                                                                                            | <ul><li>License compliance running</li></ul> |
| 8.4 Access to source code                           | Read and write access to source code, development tools and software libraries shall be appropriately managed.                                                                                               | <ul><li>Default branch protected</li></ul> |
| 8.8 Management of technical vulnerabilities         | Information about technical vulnerabilities of information systems in use shall be obtained, the organization's exposure to such vulnerabilities shall be evaluated and appropriate measures shall be taken. | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>SAST running</li><li>DAST running</li><li>API security running</li><li>Fuzz testing running</li></ul> |
| 8.28 Secure coding                                  | Secure coding principles shall be applied to software development.                                                                                                                                           | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>SAST running</li><li>DAST running</li><li>API security running</li><li>Secret detection running</li><li>Fuzz testing running</li></ul> |
| 8.29 Security testing in development and acceptance | Security testing processes shall be defined and implemented in the development lifecycle.                                                                                                                    | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>SAST running</li><li>DAST running</li><li>API security running</li><li>Secret detection running</li><li>Fuzz testing running</li></ul> |
| 8.32 Change management                              | Changes to information processing facilities and information systems shall be subject to change management procedures.                                                                                       | <ul><li>Default branch protected</li></ul> |

## NIST 800-53 compliance requirements

The National Institute of Standards and Technology (NIST) Information Technology Laboratory (ITL) provides NIST 800-53 Revision 5.

NIST 800-53 Revision 5 compliance involves implementing security and privacy controls across various areas, including:

- Risk management
- Identification and authentication
- Incident response
- System and communications protection

The following table lists the requirements supported by GitLab for NIST 800-53 and the controls for the requirements.

| NIST 800-53 Revision 5 requirement                                         | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | Supported controls |
|:---------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| AC-3(2): Dual Authorization                                                | Enforce dual authorization for organization-defined privileged commands or other organization-defined actions.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | <ul><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| AC-5: Separation of Duties                                                 | Separate duties of individuals to prevent malevolent activity without collusion; document separation of duties; and define system access authorizations to support separation of duties.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | <ul><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| AU-9(5): Dual Authorization                                                | Enforce dual authorization for the deletion or modification of organization-defined audit information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | <ul><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| CM-3: Configuration Change Control                                         | Determine and document the types of changes to the system that are configuration-controlled; review proposed configuration-controlled changes and approve or disapprove such changes with explicit consideration for security and privacy impact analyses; document configuration change decisions; implement approved configuration-controlled changes to the system; retain records of configuration-controlled changes to the system for organization-defined time period; monitor and review activities associated with configuration-controlled changes to the system; and coordinate and provide oversight for configuration change control activities through organization-defined configuration change control element. | <ul><li>Default branch protected</li><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| CM-3(1): Automated Documentation, Notification, and Prohibition of Changes | Use automated mechanisms to document proposed changes to the system; notify organization-defined approval authorities; highlight change approvals that have not been received by organization-defined time period; prohibit changes to the system until designated approvals are received; and document all changes to the system.                                                                                                                                                                                                                                                                                                                                                                                              | <ul><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| CM-5: Access Restrictions for Change                                       | Define, document, approve, and enforce physical and logical access restrictions associated with changes to the system.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | <ul><li>Default branch protected</li><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| CM-5(4): Dual Authorization                                                | Enforce dual authorization for implementing changes to organization-defined system components and system-level information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | <ul><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| CM-6: Configuration Settings                                               | Establish and document configuration settings for components employed in the system that reflect the most restrictive mode consistent with operational requirements using organization-defined common secure configurations; implement the configuration settings; identify, document, and approve any deviations from established configuration settings for organization-defined system components based on organization-defined operational requirements; and monitor and control changes to the configuration settings in accordance with organizational policies and procedures.                                                                                                                                           | <ul><li>Author approved merge request is forbidden</li></ul> |
| CM-7: Least Functionality                                                  | Configure the system to provide only organization-defined mission essential capabilities; and prohibit or restrict organization-defined functions, system ports, protocols, software, or services.                                                                                                                                                                                                                                                                                                                                                                                                               | <ul><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| CM-9(1): Assignment of Responsibility                                      | Assign responsibility for developing the configuration management process to organizational personnel that are not directly involved in system development.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | <ul><li>Default branch protected</li></ul> |
| CM-10: Software Usage Restrictions                                         | Use software and associated documentation in accordance with contract agreements and copyright laws; track the use of software and associated documentation protected by quantity licenses to control copying and distribution; and control and document the use of peer-to-peer file sharing technology to ensure that this capability is not used for the unauthorized distribution, display, performance, or reproduction of copyrighted work.                                                                                                                                                                                                                                                                               | <ul><li>License compliance running</li></ul> |
| CP-9(7): Dual Authorization                                                | Enforce dual authorization for the deletion or destruction of organization-defined backup information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | <ul><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| IA-2(10): Single Sign-on                                                   | Provide a single sign-on capability for organization-defined system accounts and services.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | <ul><li>Auth SSO enabled</li></ul> |
| IA-2(12): Acceptance of PIV Credentials                                    | Accept and electronically verify Personal Identity Verification (PIV) credentials.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | <ul><li>Auth SSO enabled</li></ul> |
| IA-5(7): No Embedded Unencrypted Static Authenticators                     | Ensure that unencrypted static authenticators are not embedded in applications or other forms of static storage.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | <ul><li>Secret detection running</li></ul> |
| IA-5(9): Federated Credential Management                                   | Use organization-defined external organizations to federate credentials.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | <ul><li>Auth SSO enabled</li></ul> |
| IA-8(1): Acceptance of PIV Credentials From Other Agencies                 | Accept and electronically verify Personal Identity Verification (PIV) credentials from other federal agencies.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | <ul><li>Auth SSO enabled</li></ul> |
| IA-8(5): Acceptance of PIV-I Credentials                                   | Accept and verify Personal Identity Verification-I (PIV-I) credentials.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | <ul><li>Auth SSO enabled</li></ul> |
| RA-5: Vulnerability Monitoring and Scanning                                | Scan for vulnerabilities in the system and hosted applications; employ vulnerability scanning tools and techniques; analyze vulnerability scan reports and results; remediate legitimate vulnerabilities; and share vulnerability information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>DAST running</li><li>API security running</li><li>Fuzz testing running</li></ul> |
| SA-11(1): Static Code Analysis                                             | Require the developer of the system, system component, or system service to employ static code analysis tools to identify common flaws and document the results of the analysis.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | <ul><li>SAST running</li></ul> |
| SA-11(8): Dynamic Code Analysis                                            | Require the developer of the system, system component, or system service to employ dynamic code analysis tools to identify common flaws and document the results of the analysis.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | <ul><li>DAST running</li><li>Fuzz testing running</li></ul> |

## NIST CSF 2.0 compliance requirements

NIST CSF is the Cybersecurity Framework from the National Institute of Standards and Technology.

The following table lists the requirements supported by GitLab for NIST CSF and the controls for the requirements.

| NIST CSF requirement                                                                                                                                                                                                                                                                                     | Description                                                                                                                                                                                | Supported controls |
|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| ID.RA-01 - Identity - Risk Assessment: The cybersecurity risk to the organization, assets, and individuals is understood by the organization.                                                                                                                                                            | Vulnerabilities in assets are identified, validated, and recorded.                                                                                                                         | <ul><li>Dependency scanning running</li><li>Container scanning running</li></ul> |
| ID.RA-07 - Identity - Risk Assessment: The cybersecurity risk to the organization, assets, and individuals is understood by the organization.                                                                                                                                                            | Changes and exceptions are managed, assessed for risk impact, recorded, and tracked.                                                                                                       | <ul><li>Default branch protected</li></ul> |
| PR.AA-05 - Protect - Identity Management, Authentication, and Access Control: Access to physical and logical assets is limited to authorized users, services, and hardware and managed commensurate with the assessed risk of unauthorized access.                                                      | Access permissions, entitlements, and authorizations are defined in a policy, managed, enforced, and reviewed, and incorporate the principles of least privilege and separation of duties. | <ul><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| PR.PS-06 - Protect - Platform Security: The hardware, software (for example, firmware, operating systems, and applications), and services of physical and virtual platforms are managed consistent with the organization's risk strategy to protect their confidentiality, integrity, and availability. | Secure software development practices are integrated, and their performance is monitored throughout the software development lifecycle.                                                    | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>SAST running</li><li>DAST running</li><li>API security running</li><li>Secret detection running</li><li>Fuzz testing running</li></ul> |

## TISAX compliance requirements

TISAX is the Trusted Information Security Assessment Exchange.

The following table lists the requirements supported by GitLab for TISAX and the controls for the requirements.

| TISAX requirement                                                                                                                          | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | Supported controls |
|:-------------------------------------------------------------------------------------------------------------------------------------------|:-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| 1.2.2 To what extent are information security responsibilities organized?                                                                  | A successful ISMS requires clear responsibilities in the organization. An appropriate organizational separation of responsibilities should be established to avoid conflict of interests (separation of duties). (C, I, A)                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | <ul><li>At least two approvals</li><li>Author approved merge request is forbidden</li><li>Committers approved merge request is forbidden</li><li>Merge requests approval rules prevent editing</li></ul> |
| 1.3.4 To what extent is it ensured that only evaluated and approved software is used for processing the organization's information assets? | Information processing is mostly done using of specific software. Security issues in software can become a risk for the information processed. Accordingly, software must be appropriately managed. Software is approved before installation or use. The software repositories are protected against unauthorized manipulation. Approval of software is regularly reviewed. Software versions and patch levels are known.                                                                                                                                                                                                                                                                            | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>License compliance running</li> |
| 5.2.1 To what extent are changes managed?                                                                                                  | The objective is to ensure that information security aspects are considered in case of any changes to the organization, business processes and IT systems (Change Management) to prevent these changes from causing an uncontrolled reduction in the information security level. Information security requirements for changes to the organization, business processes, and IT systems are determined and applied. A formal approval procedure is established.                                                                                                                                                                                                                                       | <ul><li>Default branch protected</li></ul> |
| 5.2.5 To what extent are vulnerabilities identified and addressed?                                                                         | Vulnerabilities increase the risk of IT systems being unable to meet the requirements for confidentiality, availability and integrity. Exploitation of vulnerabilities is among the possible ways for attackers to gain access to the IT system or to threaten its operating stability. Information on technical vulnerabilities for the IT systems in use is gathered (for example, information from the manufacturer, system audits, CVS database) and evaluated. For example, Common Vulnerability Scoring System (CVSS). Potentially affected IT systems and software are identified, assessed and any vulnerabilities are addressed.                                                            | <ul><li>Dependency scanning running</li><li>Container scanning running</li></ul> |
| 5.3.1 To what extent is information security considered in new or further developed IT systems?                                            | Information security is an integral part of the entire lifecycle of IT systems. This particularly includes consideration of information security requirements in the development or acquisition of IT systems. The information security requirements associated with the design and development of IT systems are determined and considered. The information security requirements associated with the acquisition or extension of IT systems and IT components are determined and considered. Information security requirements associated with changes to developed IT systems are considered. System approval tests are carried out under consideration of the information security requirements. | <ul><li>Dependency scanning running</li><li>Container scanning running</li><li>SAST running</li><li>DAST running</li><li>API security running</li><li>Secret detection running</li><li>Fuzz testing running</li></ul> |
| 7.1.1 To what extent is compliance with regulatory and contractual provisions ensured?                                                     | Non-compliance with legal, regulatory, or contractual provisions can create risks to the information security of customers and the own organization. Therefore, it is essential to ensure that these provisions are known and observed. Legal, regulatory, and contractual provisions of relevance to information security (see examples) are determined at regular intervals.                                                                                                                                                                                                                                                                                                                       | <ul><li>License compliance running</li></ul> |
