---
stage: Application Security Testing
group: Static Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Container, dependency, and vulnerability scans.
title: Secure your application
---

GitLab can check your applications for security vulnerabilities.

{{< cards >}}

- [Getting started](get-started-security.md)
- [Application security](_index.md)
- [Compliance](../compliance/_index.md)
- [Detect](detect/_index.md)
- [Triage](triage/_index.md)
- [Analyze](analyze/_index.md)
- [Remediate](remediate/_index.md)
- [Security configuration](detect/security_configuration.md)
- [Container Scanning](container_scanning/_index.md)
- [Dependency Scanning](dependency_scanning/_index.md)
- [Comparison](comparison_dependency_and_container_scanning.md)
- [Dependency List](dependency_list/_index.md)
- [Continuous Vulnerability Scanning](continuous_vulnerability_scanning/_index.md)
- [Static Application Security Testing](sast/_index.md)
- [Infrastructure as Code (IaC) Scanning](iac_scanning/_index.md)
- [Secret detection](secret_detection/_index.md)
- [Dynamic Application Security Testing (DAST)](dast/_index.md)
- [API Security](api_security/_index.md)
- [Web API Fuzz Testing](api_fuzzing/_index.md)
- [Coverage-guided fuzz testing](coverage_fuzzing/_index.md)
- [Security Dashboard](security_dashboard/_index.md)
- [Offline environments](offline_deployments/_index.md)
- [Vulnerability report](vulnerability_report/_index.md)
- [Vulnerability Page](vulnerabilities/_index.md)
- [Vulnerability severity levels](vulnerabilities/severities.md)
- [GitLab Advisory Database](gitlab_advisory_database/_index.md)
- [CVE ID requests](cve_id_request.md)
- [Policies](policies/_index.md)
- [Security glossary](terminology/_index.md)

{{< /cards >}}
