---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Linear client secret or ID (OAuth 2.0)'
---

## Description

The response body contains content that matches the pattern of an OAuth 2.0 Linear client secret or ID was identified. Client secrets are used when allowing users to sign in to your application. Depending on the scopes requested, a malicious actor could impersonate the service to access a user's information.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To revoke a Linear OAuth 2.0 Client secret:

- Sign in to your account at <https://linear.app/>
- Select your organization in the top left corner and select "Preferences"
- In the left-hand menu, select "API" under "My Account"
- In the "OAuth Applications" section of the page, find the application that contains the identified key
- Select the ellipsis to the right of the application name and then select "Manage application" - Next to the "Admin Actions" select "Rotate secret
- When prompted, select "Rotate" in the "Rotate your client secret?" dialog

For more information, please see [Linear's documentation on OAuth 2.0 authentication](https://developers.linear.app/docs/oauth/authentication).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.67 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
