---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Slack bot user OAuth token'
---

## Description

The response body contains content that matches the pattern of a Slack bot user OAuth token was identified. A Slack app's capabilities and permissions are governed by the scopes it requests. A full list of permissions can be found [in Slack's scopes documentation](https://api.slack.com/scopes). A malicious actor with access to this token can execute functionality that was assigned to it.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To revoke a Slack bot user OAuth token (Note: This requires all users to re-authorize your application): 

- Sign in to Slack and access <https://api.slack.com/apps>
- Find the application with the identified token and select the name
- In the left-hand menu, select "OAuth & Permissions"
- Scroll down to "Revoke All OAuth Tokens" and select "Revoke tokens"
- When prompted, select "Yes, I'm sure" in the "Are you sure?" dialog
- After some time, scroll back up to the "OAuth Tokens" section and select "Reinstall to XXX", where XXX is your workspace name

For more information, please see [Slack's documentation on OAuth](https://api.slack.com/authentication/oauth-v2)

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.109 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
