---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Shippo API token'
---

## Description

The response body contains content that matches the pattern of a live Shippo API token was identified. API tokens can be used to access the Shippo API which is used for shipping services. A malicious actor with access to this token can access billing and order information and modify shipping data.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet). 

To revoke an API token:

- Sign in to your Shippo account and access <https://apps.goshippo.com/>
- In the top right-hand side, select the "gear" icon to go to the "Settings" page
- Scroll down in the left hand menu to "Advanced" and select "API"
- Under the "Token" section, select "Manage your token"
- Find the identified token and select the trash icon
- When prompted, select "Yes, remove token" in the "Manage Your Tokens" dialog

For more information, please see [Shippo's documentation on API keys](https://portal.goshippo.com/api-config/api).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.104 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
