---
stage: none
group: Tutorials
info: For assistance with this tutorials page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments-to-other-projects-and-subjects.
description: Introduction to the product.
title: 'Tutorials: Find your way around GitLab'
---

Get to know the features of GitLab and where to find them so you can get up
and running quickly.

| Topic | Description | Good for beginners |
|-------|-------------|--------------------|
| [GitLab with Git Essentials](https://university.gitlab.com/courses/gitlab-with-git-essentials-s2)  |  Learn the basics of Git and GitLab in this self-paced course. | {{< icon name="star" >}} |
| <i class="fa fa-youtube-play youtube" aria-hidden="true"></i> [How to start a free trial](https://www.youtube.com/watch?v=dIlBLrXbfrM&list=PLFGfElNsQthYDx0A_FaNNfUm9NHsK6zED&index=63) (3m 01s) | Learn how to start a free 30-day Ultimate trial, and create your first project. | {{< icon name="star" >}} |
| [Use the left sidebar to navigate GitLab](left_sidebar/_index.md) |  Start navigating the GitLab UI. | {{< icon name="star" >}} |
| <i class="fa fa-youtube-play youtube" aria-hidden="true"></i> [GitLab Continuous Delivery overview](https://www.youtube.com/watch?v=M7rBDZYsx8U&list=PLFGfElNsQthYDx0A_FaNNfUm9NHsK6zED&index=193) (17m 2s) | Learn how to use GitLab features to continuously build, test, and deploy iterative code changes. | |
| <i class="fa fa-youtube-play youtube" aria-hidden="true"></i> [Introducing GitLab Service Desk](https://www.youtube.com/watch?v=LDVQXv3I5rI) (6m 50s) | Learn how GitLab [Service Desk](../user/project/service_desk/_index.md) provides an integrated help desk solution to enhance customer support workflows. This video covers key features, such as [custom email addresses](../user/project/service_desk/configure.md#custom-email-address) and [email templates](../user/project/service_desk/configure.md#customize-emails-sent-to-external-participants), ticket management, [comment templates](../user/profile/comment_templates.md), [CRM integration](../user/crm/_index.md), automation using `gitlab-triage` in scheduled CI/CD pipelines, and analytics and [insights](../user/project/insights/_index.md). | |
