---
stage: GitLab Delivery
group: Build
info: Any user with at least the Maintainer role can merge updates to this content. For details, see https://docs.gitlab.com/development/development_processes/#development-guidelines-review.
description: Development guidelines for Distribution
title: Contribute to GitLab Distribution
---

Learn how to add new components and services to the GitLab application.

## Support all package methods

Additions must support both Omnibus GitLab and Cloud Native GitLab. Changes
to one must be made to the other to retain feature parity.

## Contributing

The primary projects handled by Distribution are listed below. For more
information, visit the [Distribution team engineering handbook page](https://handbook.gitlab.com/handbook/engineering/infrastructure-platforms/gitlab-delivery/distribution/)
or select one of the subsections in the navigation bar.

### GitLab application

- [Omnibus GitLab](https://gitlab.com/gitlab-org/omnibus-gitlab)
- [Cloud Native GitLab (CNG)](https://gitlab.com/gitlab-org/build/CNG)
- [GitLab Operator](https://gitlab.com/gitlab-org/cloud-native/gitlab-operator)
- [GitLab Chart](https://gitlab.com/gitlab-org/charts/gitlab)

### Components and tools

- [Omnibus GitLab Builder](https://gitlab.com/gitlab-org/gitlab-omnibus-builder)
- [Omnibus Fork](https://gitlab.com/gitlab-org/omnibus)
- [GitLab Logger](https://gitlab.com/gitlab-org/cloud-native/gitlab-logger)
- [Issue Bot](https://gitlab.com/gitlab-org/distribution/issue-bot)
