---
stage: Create
group: Source Code
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Use Git branches to develop new features. Add branch protections to critical branches to ensure only trusted users can merge into them.
title: デフォルトブランチ
---

{{< details >}}

- プラン:Free、Premium、Ultimate
- 提供形態:GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

新しい[プロジェクト](../../_index.md)を作成すると、GitLab はリポジトリにデフォルトブランチを作成します。デフォルトブランチには、他のブランチにはない特別な設定オプションがあります。

- これは削除できません。
- 強制プッシュに対して[初期的に保護](protected.md)されています。
- マージリクエストが[イシューのクローズパターン](../../issues/managing_issues.md#closing-issues-automatically)を使用してイシューをクローズすると、作業はこのブランチにマージされます。

[新しいプロジェクト](../../_index.md)のデフォルトブランチの名前は、GitLab 管理者によってインスタンスまたはグループに加えられた設定の変更によって異なります。GitLab は、最初に特定されたカスタマイズがないか確認し、次に広範なレベルで確認します。GitLab のデフォルトは、カスタマイズが設定されていない場合にのみ使用します。

1. [プロジェクト固有](#change-the-default-branch-name-for-a-project)のカスタムデフォルトブランチ名。
1. プロジェクトの直接のサブグループで指定された[カスタムグループのデフォルトブランチ名](#change-the-default-branch-name-for-new-projects-in-a-group)。
1. プロジェクトのトップレベルグループで指定されたカスタムグループのデフォルトブランチ名。
1. [インスタンス](#change-the-default-branch-name-for-new-projects-in-an-instance)に設定されたカスタムデフォルトブランチ名。
1. どのレベルでもカスタムデフォルトブランチ名が設定されていない場合、GitLab はデフォルトで `main` になります。

GitLab UI では、どのレベルでもデフォルトを変更できます。GitLab は、リポジトリのコピーを更新するために[必要な Gitコマンド](#update-the-default-branch-name-in-your-repository)も提供します。

## プロジェクトのデフォルトブランチ名を変更します

前提要件:

- プロジェクトのオーナーまたはメンテナーのロールを持っている必要があります。

個々の[プロジェクト](../../_index.md)のデフォルトブランチを更新するには:

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを見つけます。
1. **設定 > リポジトリ**を選択します。
1. **ブランチのデフォルト**を展開します。**デフォルトブランチ**で、新しいデフォルトブランチを選択します。
1. 任意。マージリクエストが[クローズパターンを使用](../../issues/managing_issues.md#closing-issues-automatically)するときにイシューをクローズするには、**デフォルトブランチで参照されているイシューを自動的にクローズ**チェックボックスを選択します。
1. **変更を保存**を選択します。

API ユーザーは、プロジェクトの作成または編集時に、[Projects API](../../../../api/projects.md) の `default_branch` 属性を使用することもできます。

## インスタンス内の新しいプロジェクトのデフォルトブランチ名を変更します

{{< details >}}

- プラン:Free、Premium、Ultimate
- 提供形態:GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

GitLab Self-Managed の[管理者](../../../permissions.md)は、そのインスタンスでホストされているプロジェクトの初期ブランチをカスタマイズできます。個々のグループとサブグループは、プロジェクトのインスタンスのデフォルトを上書きできます。

1. 左側のサイドバーの下部にある**管理者**を選択します。
1. **設定 > リポジトリ**を選択します。
1. **デフォルトブランチ**を展開します。
1. **初期デフォルトブランチ名**で、新しいデフォルトブランチを選択します。
1. **変更を保存**を選択します。

設定を変更した後にこのインスタンスで作成されたプロジェクトは、グループまたはサブグループの設定で上書きされない限り、カスタムブランチ名を使用します。

## グループ内の新しいプロジェクトのデフォルトブランチ名を変更する

前提要件:

- グループとサブグループのオーナーのロールを持っている必要があります。

グループ内の新しいプロジェクトのデフォルトブランチ名を変更するには:

1. 左側のサイドバーで、**検索または移動**を選択し、グループを見つけます。
1. **設定 > リポジトリ**を選択します。
1. **デフォルトブランチ**を展開します。
1. **初期デフォルトブランチ名**で、新しいデフォルトブランチを選択します。
1. **変更を保存**を選択します。

設定を変更した後にこのグループで作成されたプロジェクトは、サブグループの設定で上書きされない限り、カスタムブランチ名を使用します。

## 初期デフォルトブランチを保護する

{{< details >}}

- プラン:Free、Premium、Ultimate
- 提供形態:GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- 初期プッシュ後の完全な保護は、GitLab 16.0 で[導入されました](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/118729)。

{{< /history >}}

GitLab 管理者とグループオーナーは、次のいずれかのオプションを使用して、インスタンスまたは個々のグループのリポジトリのデフォルトブランチに適用する[ブランチ保護](protected.md)を定義できます。

- **完全に保護** \- デフォルト値。デベロッパーは新しいコミットをプッシュできませんが、メンテナーはプッシュできます。だれも強制プッシュできません。
- **初期プッシュ後に完全に保護** \- デベロッパーはリポジトリに最初のコミットをプッシュできますが、その後は誰でもプッシュできません。メンテナーは常にプッシュできます。だれも強制プッシュできません。
- **プッシュから保護** \- デベロッパーは新しいコミットをプッシュできませんが、ブランチへのマージリクエストは承認できます。メンテナーはブランチにプッシュできます。
- **部分的に保護** \- デベロッパーとメンテナーの両方が新しいコミットをプッシュできますが、強制プッシュはできません。
- **保護なし** \- デベロッパーとメンテナーの両方が新しいコミットをプッシュでき、強制プッシュできます。

{{< alert type="warning" >}}

**完全に保護**が選択されていない限り、悪意のあるデベロッパーが機密データを盗もうとする可能性があります。たとえば、悪意のある`.gitlab-ci.yml`ファイルが保護されたブランチにコミットされ、後でそのブランチに対してパイプラインが実行されると、グループの CI/CD変数が流出する可能性があります。

{{< /alert >}}

### インスタンス内のすべてのプロジェクトについて

{{< details >}}

- プラン:Free、Premium、Ultimate
- 提供形態:GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

この設定は、各リポジトリのデフォルトブランチにのみ適用されます。他のブランチを保護するには、次のいずれかを実行する必要があります。

- [リポジトリでブランチ保護](protected.md)を設定します。
- [グループのブランチ保護](../../../group/manage.md#change-the-default-branch-protection-of-a-group)を設定します。

GitLab Self-Managedインスタンスの管理者は、そのインスタンスでホストされているプロジェクトの初期デフォルトブランチ保護をカスタマイズできます。個々のグループとサブグループは、プロジェクトのインスタンスのデフォルト設定を上書きできます。

1. 左側のサイドバーの下部にある**管理者**を選択します。
1. **設定 > リポジトリ**を選択します。
1. **デフォルトブランチ**を展開します。
1. [**初期デフォルトブランチ保護**](#protect-initial-default-branches)を選択します。
1. グループオーナーがインスタンスのデフォルトブランチ保護を上書きできるようにするには、[**オーナーがグループごとにデフォルトブランチ保護を管理できるようにする**](#prevent-overrides-of-default-branch-protection)を選択します。
1. **変更を保存**を選択します。

#### デフォルトブランチ保護の上書きを防止する

{{< details >}}

- プラン:Premium、Ultimate
- 提供形態:GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

グループオーナーは、グループ単位でインスタンス全体に設定されたデフォルトブランチの保護を上書きできます。[GitLab Premium または Ultimate](https://about.gitlab.com/pricing/)では、GitLab 管理者はグループオーナーのこの権限を無効にし、インスタンスに設定された保護ルールを適用できます。

1. 左側のサイドバーの下部にある**管理者**を選択します。
1. **設定 > リポジトリ**を選択します。
1. **デフォルトブランチ**セクションを展開します。
1. **オーナーがグループごとにデフォルトブランチ保護を管理できるようにする**チェックボックスをオフにします。
1. **変更を保存**を選択します。

{{< alert type="note" >}}

GitLab 管理者は、グループのデフォルトブランチ保護を更新できます。

{{< /alert >}}

### グループ内のすべてのプロジェクトについて

{{< details >}}

- プラン:Premium、Ultimate
- 提供形態:GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

グループオーナーは、グループ単位でインスタンス全体に設定されたデフォルトブランチの保護を上書きできます。[GitLab Premium または Ultimate](https://about.gitlab.com/pricing/)では、GitLab 管理者は[初期デフォルトブランチの保護を適用](#prevent-overrides-of-default-branch-protection)でき、グループオーナーに対してこの設定をロックします。

1. 左側のサイドバーで、**検索または移動**を選択し、グループを見つけます。
1. **設定 > リポジトリ**を選択します。
1. **デフォルトブランチ**を展開します。
1. [**初期デフォルトブランチ保護**](#protect-initial-default-branches)を選択します。
1. **変更を保存**を選択します。

## リポジトリのデフォルトブランチ名を更新する

{{< alert type="warning" >}}

デフォルトブランチの名前を変更すると、テスト、CI/CD 設定、サービス、ヘルパーユーティリティ、およびリポジトリが使用するインテグレーションが中断される可能性があります。このブランチ名を変更する前に、プロジェクトオーナーとメンテナーに相談してください。関連するコードとスクリプト内の古いブランチ名への参照を含め、この変更のスコープを理解していることを確認してください。

{{< /alert >}}

既存のリポジトリのデフォルトブランチ名を変更する場合は、新しいブランチを作成しないでください。デフォルトブランチの名前を変更して、デフォルトブランチの履歴を保持します。この例では、Gitリポジトリ(`example`)のデフォルトブランチの名前を変更します。

1. ローカルコマンドラインで、`example`リポジトリに移動し、デフォルトブランチにいることを確認します。

   ```plaintext
   cd example
   git checkout master
   ```

1. 既存のデフォルトブランチの名前を新しい名前(`main`)に変更します。引数`-m`は、すべてのコミット履歴を新しいブランチに転送します。

   ```plaintext
   git branch -m master main
   ```

1. 新しく作成した`main`ブランチをアップストリームにプッシュし、ローカルブランチを同じ名前のリモートブランチを追跡するように設定します。

   ```plaintext
   git push -u origin main
   ```

1. 古いデフォルトブランチを削除する予定がある場合は、`HEAD`を新しいデフォルトブランチである`main`を指すように更新します。

   ```plaintext
   git symbolic-ref refs/remotes/origin/HEAD refs/remotes/origin/main
   ```

1. 少なくともメンテナーのロールで GitLab にサインインし、[このプロジェクトのデフォルトブランチを変更](#change-the-default-branch-name-for-a-project)する手順に従います。新しいデフォルトブランチとして`main`を選択します。
1. [保護ブランチのドキュメント](protected.md)の説明に従って、新しい`main`ブランチを保護します。
1. 任意。古いデフォルトブランチを削除する場合は:
   1. 何も指していないことを確認します。
   1. リモートでブランチを削除します:

      ```plaintext
      git push origin --delete master
      ```

      新しいデフォルトブランチが期待どおりに動作することを確認した後、後でブランチを削除できます。

1. プロジェクトのコントリビューターにこの変更を通知します。コントリビューターもいくつかの手順を実行する必要があるためです:

   - コントリビューターは、新しいデフォルトブランチをリポジトリのローカルコピーにプルする必要があります。
   - 古いデフォルトブランチをターゲットとするオープンマージリクエストを持つコントリビューターは、代わりに`main`を使用するようにマージリクエストを手動で再指定する必要があります。
1. リポジトリで、コード内の古いブランチ名への参照を更新します。
1. ヘルパーユーティリティやインテグレーションなど、リポジトリの外部にある関連コードおよびスクリプト内の古いブランチ名への参照を更新します。

## デフォルトブランチの名前変更のリダイレクト

プロジェクト内の特定のファイルまたはディレクトリの URL には、プロジェクトのデフォルトブランチ名が埋め込まれており、ドキュメントまたはブラウザのブックマークに表示されることがよくあります。[リポジトリのデフォルトブランチ名を更新](#update-the-default-branch-name-in-your-repository)すると、これらの URL が変更されるため、更新する必要があります。

移行期間を容易にするために、プロジェクトのデフォルトブランチが変更されるたびに、GitLab は古いデフォルトブランチの名前を記録します。そのブランチが削除された場合、そのブランチ上のファイルまたはディレクトリを表示しようとすると、「見つかりません」ページが表示される代わりに、現在のデフォルトブランチにリダイレクトされます。

## 関連トピック

- [Wiki のデフォルトブランチを設定する](../../wiki/_index.md)
- Git メーリングリストでの[デフォルトブランチの名前変更に関するディスカッション](https://lore.kernel.org/git/pull.656.v4.git.1593009996.gitgitgadget@gmail.com/)
- [2021 年 3 月のブログ投稿:新しい Git デフォルトブランチ名](https://about.gitlab.com/blog/2021/03/10/new-git-default-branch-name/)

## トラブルシューティング

### デフォルトブランチを変更できません: 現在のブランチにリセットされます

この問題は[イシュー 20474](https://gitlab.com/gitlab-org/gitlab/-/issues/20474)で追跡しています。この問題は、`HEAD`という名前のブランチがリポジトリに存在する場合によく発生します。問題を修正するには:

1. ローカルリポジトリで、新しい一時ブランチを作成してプッシュします:

   ```shell
   git checkout -b tmp_default && git push -u origin tmp_default
   ```

1. GitLab で、その一時ブランチに[デフォルトブランチを変更](#change-the-default-branch-name-for-a-project)します。
1. ローカルリポジトリから、`HEAD`ブランチを削除します:

   ```shell
   git push -d origin HEAD
   ```

1. GitLab で、使用する[デフォルトブランチを変更](#change-the-default-branch-name-for-a-project)します。

### GraphQL クエリでデフォルトブランチを検索します

[GraphQL クエリ](../../../../api/graphql/_index.md)を使用して、グループ内のすべてのプロジェクトのデフォルトブランチを取得できます。

結果の単一ページにすべてのプロジェクトを返すには、`GROUPNAME`をグループへのフルパスに置き換えます。GitLab は結果の最初のページを返します。`hasNextPage`が`true`の場合、`after: null`の`null`を`endCursor`の値に置き換えることで、次のページをリクエストできます:

```graphql
{
 group(fullPath: "GROUPNAME") {
   projects(after: null) {
     pageInfo {
       hasNextPage
       endCursor
     }
     nodes {
       name
       repository {
         rootRef
       }
     }
   }
 }
}
```

### 新しいサブグループは、上位レベルのサブグループからデフォルトブランチ名を継承しません

プロジェクトを含む別のサブグループを含むサブグループでデフォルトブランチを設定した場合、デフォルトブランチは継承されません。

この問題は[イシュー 327208](https://gitlab.com/gitlab-org/gitlab/-/issues/327208)で追跡しています。
