---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Use merge request reviews to discuss and improve code before it is merged into your project.
title: マージリクエストのレビュー
---

{{< details >}}

- プラン:Free、Premium、Ultimate
- 提供形態:GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

マージリクエストは、GitLabプロジェクトでファイルに変更を加えるための主要な方法です。変更を提案するには、[マージリクエストを作成して送信](../creating_merge_requests.md)します。チームはマージリクエストに[コメント](../../../discussions/_index.md)を残し、ユーザーインターフェースから承認できる[提案](suggestions.md)を行います。チームメイトがあなたの作業をレビューする際、承認するか拒否かを選択できます。

マージリクエストをレビューするには、以下を使用できます。

- GitLabインターフェース。
- [VS Code用GitLabワークフロー拡張機能](../../../../editor_extensions/visual_studio_code/_index.md)を設定している場合は、Visual Studio Code。
- [GitLab CLI](../../../../editor_extensions/gitlab_cli/_index.md)を設定している場合は、ターミナルウィンドウ。

<i class="fa fa-youtube-play youtube" aria-hidden="true"></i>[マージリクエストのレビュー](https://www.youtube.com/watch?v=2MayfXKpU08&list=PLFGfElNsQthYDx0A_FaNNfUm9NHsK6zED&index=183)の概要をご覧ください。
<!-- Video published on 2023-04-29 -->

## レビューするマージリクエストを見つける

レビューが必要なマージリクエストは、[マージリクエストホームページ](../../../../tutorials/merge_requests/homepage.md)の**レビューリクエスト**カテゴリにあります。ホームページですべてのマージリクエストを表示するには、<kbd>Shift</kbd> + <kbd>m</kbd> [キーボードショートカット](../../../shortcuts.md)を使用するか、以下を使用します:

1. 左側のサイドバーで、**マージリクエスト**アイコンを選択します。

または:

1. 左側のサイドバーで、**検索または移動**を選択します。
1. ドロップダウンリストから、**マージリクエスト**を選択します。

## マージリクエストのレビュー状態を表示する

これを行うには:

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを探します。
1. **コード > マージリクエスト**を選択し、マージリクエストを見つけます。
1. マージリクエストのタイトルを選択して表示します。
1. [マージリクエストウィジェット](../widgets.md)までスクロールして、マージリクエストのマージ可能性と承認状態を確認します。たとえば、必要な承認がない場合、このマージリクエストはブロックされます。

   ![マージリクエストウィジェットに「必要な承認はすべて付与されている必要があります」と表示されます。](img/reviews_missing_v17_3.png)

各レビュアーの個別のレビュー状態を確認するには、マージリクエストの右側のサイドバーを確認します。各**レビュアー**には、ユーザー名の右側に状態が表示されます。

- {{< icon name="dash-circle" >}} このユーザーからのレビューを待機中です。
- {{< icon name="status_running" >}} ユーザーのレビューが進行中です。
- {{< icon name="check-circle" >}} このユーザーによって承認されました。
- {{< icon name="comment-lines" >}} ユーザーが変更をリクエストし、[このマージリクエストをブロック](#prevent-merge-when-you-request-changes)しました。（必要に応じて、[このブロックを回避](#prevent-merge-when-you-request-changes)できます。）

## レビューをリクエスト

{{< history >}}

- GitLab 17.5で[導入](https://gitlab.com/groups/gitlab-org/-/epics/12878)された拡張レビュアーdrawer（`reviewer_assign_drawer`という[機能フラグ](../../../../administration/feature_flags.md)付き）。
- GitLab 17.5のGitLab.comおよびGitLab Self-Managedで[有効化](https://gitlab.com/gitlab-org/gitlab/-/issues/467205)されました。
- GitLab 17.8で[機能フラグ](https://gitlab.com/gitlab-org/gitlab/-/issues/467205) `reviewer_assign_drawer`が削除されました。

{{< /history >}}

変更の準備が完了したら、レビューをリクエストします。マージリクエストにレビュアーを割り当てるには、テキストフィールドで`/assign_reviewer @user` [クイック アクション](../../quick_actions.md#issues-merge-requests-and-epics)を使用するか、以下を使用します。

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを探します。
1. **コード > マージリクエスト**を選択し、マージリクエストを見つけます。
1. マージリクエストのタイトルを選択して表示します。
1. 右側のサイドバーの**レビュアー**セクションで:
   - 名前で特定のレビュアーを検索するには、**編集**を選択します。
   - GitLab PremiumおよびUltimateで、[承認ルールを満たす](#find-reviewers-who-fulfill-approval-rules)レビュアーを見つけるには、**割り当て**を選択してレビュアーdrawerを開きます。

GitLabは、マージリクエストをユーザーのレビューリクエストに追加します。

### 承認ルールを満たすレビュアーを見つける

{{< details >}}

- プラン:Premium、Ultimate
- 提供形態:GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

GitLab PremiumとUltimateは、マージリクエストに最適なレビュー担当者をより迅速に見つけるのに役立ちます。**レビュアーの割り当て**drawerを使用して、レビュアーのリストをフィルタリングします。マージリクエストで変更されたファイルのコードオーナーと、プロジェクトの承認ルールを満たすユーザーを確認します。

この例では、マージリクエストには3つのコードオーナー承認が必要ですが、これまでのところ承認はありません:

![3つのコードオーナー承認を必要とするが、承認がないマージリクエストの\[レビュアーの割り当て] drawer。コードオーナーのルールごとに1行、承認ルールごとに1行が表示されます。各ルールに対してレビュアーを選択できます。](img/select_good_reviewers_v17_5.png)

1. オプションの承認ルールまたはコードオーナーを表示するには、**オプションの承認ルール**（{{< icon name="chevron-lg-up" >}}）を選択して表示します。
1. 必要なレビュアータイプの横にある**編集**を選択します:
   - **コードオーナー**には、そのファイルタイプのコードオーナーのみが表示されます。
   - **承認ルール**には、その承認ルールを満たすユーザーのみが表示されます。
1. 目的のレビュアーを選択します。（GitLab PremiumとUltimateでは、複数のレビュアーを選択できます。）
1. 必要な**コードオーナー**および**承認ルール**項目ごとに繰り返します。
1. レビュアーを選択したら、右上の**閉じる**（{{< icon name="close" >}}）を選択してdrawerを非表示にします。

### レビューを再リクエスト

レビュアーが[マージリクエストのレビュー](../../../discussions/_index.md)を完了した後、マージリクエストの作成者はレビュアーに新しいレビューを要求することができます。これを行うには、マージリクエストのテキストフィールドで`/request_review @user` クイック アクションを使用するか、次のようにします。

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを探します。
1. **コード > マージリクエスト**を選択し、マージリクエストを見つけます。
1. マージリクエストのタイトルを選択して表示します。
1. マージリクエストで右側のサイドバーを折りたたんでいる場合は、{{< icon name="chevron-double-lg-left" >}} **サイドバーを展開**を選択して展開します。
1. **レビュアー**セクションで、レビュー担当者の名前の横にある**レビューを再リクエスト**アイコン（{{< icon name="redo" >}}）を選択します。

GitLabは、レビュアーの新しい[To Doアイテム](../../../todos.md)を作成し、通知メールを送信します。

## レビューを開始

ユーザーがマージリクエストのレビューを依頼した場合:

1. 次のいずれか:
   - <kbd>Shift</kbd> + <kbd>r</kbd>を押して、**レビューリクエスト**ページに移動します。
   - 左側のサイドバーで、**マージリクエスト**（{{< icon name="merge-request" >}}）**> レビューリクエスト**を選択します。

1. マージリクエストを見つけ、マージリクエストのタイトルを選択して表示します。
1. マージリクエストの説明とコメントを読んで、マージリクエストについて学びます。
1. **変更**を選択して、提案された変更の差分を表示します。**変更**ページの詳細は、[マージリクエストの変更](../changes.md)をご覧ください。
1. 必要に応じて[複数行または1行の変更を提案](suggestions.md)します。**コメントを今すぐ追加**ではなく**レビューを開始**を選択した場合、レビューが完了するまで、レビューコメントは公開されません。

1. **レビューを開始**を選択した後でさらにコメントを追加するには、次からレビューに追加します。
   - 差分ビューを含む**変更**タブ。
   - **概要**タブで、**レビューに追加**を選択します。

   ![新しいスレッド](img/mr_review_new_comment_v16_6.png)
1. [**レビューを送信**](#submit-a-review)を選択して、**レビューを開始**または**レビューに追加**で追加されたすべてのレビューコメントを公開します。[レビューを送信](#submit-a-review)するまで、これらのコメントは公開されません。

### コメント付きでスレッドを解決または未解決にする

レビューコメントでは、[解決可能なスレッド](../_index.md#resolve-a-thread)を解決または未解決にすることもできます。コメントに返信する際にスレッドを解決または未解決にするには:

1. コメントテキストエリアに、コメントを書き込みます。
1. **スレッドを解決**を選択またはクリアします。
1. **コメントを今すぐ追加**または**レビューに追加**を選択します。

保留中のコメントには、遅延したアクションに関する情報が表示されます。コメントを公開するまで、GitLabはこれらのアクションを実行しません。

- {{< icon name="check-circle-filled" >}} スレッドは解決されました。
- {{< icon name="check-circle" >}} スレッドは未解決のままです。

## レビューを送信

完了したレビューを送信するには、次のいずれかを実行します。

- レビュー以外のコメントのテキストで、`/submit_review` [クイック アクション](../../quick_actions.md)を使用します。
- **レビューを終了**を選択し、ダイアログの下部にある**レビューを送信**を選択します。ダイアログで、**サマリーコメント**を入力し、マージリクエストを承認（または拒否）して、クイック アクションを含めることができます。

  ![コメント付きでレビューを終了](img/mr_summary_comment_v16_9.png)

レビューを送信すると、GitLabは次の処理を行います。

- レビューのコメントを公開します。
- レビューコメントを添付して、マージリクエストのすべての通知可能なユーザーに1通のメールを送信します。このメールに返信すると、マージリクエストに新しいコメントが作成されます。
- レビューコメントに追加したクイック アクションを実行します。
- 任意。承認したか、変更を要求したかどうかが表示されます。
  - **コメント**:明示的な承認なしで一般的なフィードバックを残します。
  - **承認**:フィードバックを残して、変更を承認します。
  - **変更をリクエスト**:作成者がフィードバックに対応するまで、マージリクエストがマージされないようにブロックします。

### 変更をリクエストするときにマージを防ぐ

{{< details >}}

- プラン:Premium、Ultimate
- 提供形態:GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 16.11で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/430728)（`mr_reviewer_requests_changes`という[機能フラグ](../../../../administration/feature_flags.md)付き）。デフォルトでは無効になっています。
- GitLab 17.2の[GitLab.com](https://gitlab.com/gitlab-org/gitlab/-/issues/451211)および[GitLab Self-Managed](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158226)でデフォルトで有効。
- GitLab 17.3で[機能フラグが削除](https://gitlab.com/gitlab-org/gitlab/-/issues/451211)されました。

{{< /history >}}

レビュアーが[変更をリクエスト](#submit-a-review)すると、マージリクエストはマージされなくなります。この場合、マージリクエストレポート領域に**変更リクエストを完了または解決する必要があります。**というメッセージが表示されます。マージリクエストのブロックを解除するには、変更をリクエストしたレビュー担当者がマージリクエストを[再レビューして承認](#re-request-a-review)する必要があります。

### 変更リクエストを削除

{{< history >}}

- GitLab 17.8で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/480412)。

{{< /history >}}

以前に変更をリクエストした場合は、変更リクエストを削除できます。次の両方が当てはまる場合は、これが必要になる場合があります。

- マージリクエストを承認できなくなった。
- 変更リクエストをキャンセルしたいが、新しいレビューを送信したくない。

新しいレビューを送信せずに変更リクエストを削除するには:

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを探します。
1. **コード > マージリクエスト**を選択し、マージリクエストを見つけます。
1. マージリクエストのタイトルを選択して表示します。
1. マージリクエストの**概要**で、マージリクエストレポート領域までスクロールします。
1. **変更リクエストを完了または解決する必要があります**の横にある**削除**を選択します。

   ![ユーザーが変更をリクエストしたためブロックされているマージリクエスト](img/remove_v17_8.png)

### 変更のリクエストを回避する

変更をリクエストしたユーザーが再レビューまたは承認できない場合、マージリクエストをマージする権限を持つ別のユーザーがこのチェックを上書きできます。

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを探します。
1. **コード > マージリクエスト**を選択し、マージリクエストを見つけます。
1. マージリクエストのタイトルを選択して表示します。
1. マージリクエストの**概要**で、マージリクエストレポート領域までスクロールします。
1. **変更リクエストを完了または解決する必要があります**の横にある**回避**を選択します。

   ![ユーザーが変更をリクエストしたためブロックされているマージリクエスト](img/bypass_v17_2.png)

1. マージレポート領域に`Merge with caution: Override added`が表示されます。ユーザーが回避したチェックを確認するには、**マージチェックを展開**（{{< icon name="chevron-lg-down" >}}）を選択し、警告（{{< icon name="status_warning" >}}）アイコンが含まれているチェックを見つけます。この例では、作成者は**変更リクエストを完了または解決する必要があります**を回避しました。

   ![このマージリクエストには回避されたチェックが含まれており、注意してマージする必要があります。](img/status_warning_v17_4.png)

## マージリクエストの変更をダウンロード

### 差分として

マージリクエストに含まれる変更を差分としてダウンロードするには:

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを探します。
1. **コード > マージリクエスト**を選択します。
1. マージリクエストを選択します。
1. 右上隅で、**コード > テキスト差分**を選択します。

マージリクエストのURLがわかっている場合は、URLに`.diff`を付け加えて、コマンドラインから差分をダウンロードすることもできます。この例では、マージリクエスト`000000`の差分をダウンロードします。

```plaintext
https://gitlab.com/gitlab-org/gitlab/-/merge_requests/000000.diff
```

ワンラインCLIコマンドで差分をダウンロードして適用するには:

```shell
curl "https://gitlab.com/gitlab-org/gitlab/-/merge_requests/000000.diff" | git apply
```

### パッチファイルとして

マージリクエストに含まれる変更をパッチファイルとしてダウンロードするには:

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを探します。
1. **コード > マージリクエスト**を選択します。
1. マージリクエストを選択します。
1. 右上隅で、**コード > パッチ**を選択します。

マージリクエストのURLがわかっている場合は、URLに`.patch`を付け加えて、コマンドラインからパッチをダウンロードすることもできます。この例では、マージリクエスト`000000`のパッチファイルをダウンロードします。

```plaintext
https://gitlab.com/gitlab-org/gitlab/-/merge_requests/000000.patch
```

[`git am`](https://git-scm.com/docs/git-am)を使用してワンラインCLIコマンドでパッチをダウンロードして適用するには:

```shell
curl "https://gitlab.com/gitlab-org/gitlab/-/merge_requests/000000.patch" | git am
```

## 関連機能

マージリクエストは、次の機能に関連しています。

- [Cherry-pickの変更](../cherry_pick_changes.md):GitLab UIで、マージされたマージリクエストまたはコミットで**Cherry-pick**を選択して、cherry-pickします。
- [早送りマージリクエスト](../methods/_index.md#fast-forward-merge):線形Git履歴とマージコミットを作成せずにマージリクエストを受け入れる方法については
- [変更を導入したマージリクエストを見つける](../versions.md):コミット詳細ページを表示すると、GitLabはそのコミットを含むマージリクエストにリンクします。
- [マージリクエストバージョン](../versions.md):マージリクエストの差分の異なるバージョンを選択して比較する
- [競合の解決](../conflicts.md):GitLabは、GitLab UIで特定のマージリクエストの競合を解決するオプションを提供できます。
- [変更の取り消し](../revert_changes.md):マージリクエストから任意のコミットの変更を取り消します。
- [キーボードショートカット](../../../shortcuts.md#merge-requests):キーボードコマンドを使用して、マージリクエストの特定の部分にアクセスして変更します。
- [バリューストリーム分析](../../../group/value_stream_analytics/_index.md)：主要なマージリクエストの手順（`reviewed` や `approved` など）を追跡して、ソフトウェア開発ライフサイクルで最も時間が費やされている場所を特定します。この情報は、グループやプロジェクトのマージリクエストのワークフローを最適化し、全体的なデベロッパーの生産性を向上させるための、実行可能なインサイトを明らかにするのに役立ちます。[バリューストリーム分析でMRレビュー時間を削減した方法](https://about.gitlab.com/blog/2025/02/20/how-we-reduced-mr-review-time-with-value-stream-management/)について、詳しくはこちらをご覧ください。

## 関連トピック

- [マージ方法](../methods/_index.md)
- [下書きノート API](../../../../api/draft_notes.md)
