---
stage: Tenant Scale
group: Organizations
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: プロジェクトとグループを共有する
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 16.10で、`webui_members_inherited_users`という名前の[フラグ](../../../administration/feature_flags.md)とともに、招待されたグループメンバーをメンバーページのメンバータブに表示するように[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/219230)されました。デフォルトでは無効になっています。
- GitLab 17.0の[GitLab.comとGitLab Self-Managedで機能フラグ`webui_members_inherited_users`が有効](https://gitlab.com/gitlab-org/gitlab/-/issues/219230)になりました。
- GitLab 17.4で、機能フラグ`webui_members_inherited_users`が[削除](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163627)されました。招待されたグループのメンバーは、デフォルトで表示されます。

{{< /history >}}

招待によって次を共有できます。

- グループとのプロジェクト。
- 別のグループとのグループ。

## プロジェクトを共有する

グループにプロジェクトへのアクセスを許可する場合は、[グループ](../../group/_index.md)をプロジェクトに招待できます。グループの直接メンバーと継承されたメンバーはプロジェクトへのアクセス権を取得し、プロジェクトは**共有プロジェクト**になります。

この場合、継承されたメンバーとは、親グループから招待されたグループに継承されたメンバーのことです。共有プロジェクトへのアクセス権を取得できるのは、招待されたグループのメンバーのみです。招待するグループのサブグループのメンバーにプロジェクトへのアクセス権を付与する場合は、サブグループを招待する必要があります。

次のテーブルに、共有プロジェクトへのアクセス権を取得するグループメンバーの概要を示します。

| グループメンバーのソース                                                 | 共有プロジェクトへのアクセス |
|---------------------------------------------------------------------|--------------------------|
| 共有されているグループの直接メンバー                           | {{< icon name="check-circle" >}} はい   |
| 共有されているグループの継承されたメンバー                        | {{< icon name="check-circle" >}} はい   |
| サブグループの直接メンバー。ただし、共有されているグループのメンバーではない    | {{< icon name="dotted-circle" >}} いいえ   |
| サブグループの継承されたメンバー。ただし、共有されているグループのメンバーではない | {{< icon name="dotted-circle" >}} いいえ   |

招待するグループの[表示レベル](../../public_access.md)は、プロジェクトの表示レベルと同等以上に制限されている必要があります。たとえば、次のように招待できます。

- **プライベート**グループを**プライベート**プロジェクトに招待する。
- **プライベート**グループを**内部**プロジェクトに招待する。
- **プライベート**グループを**パブリック**プロジェクトに招待する。
- **内部**グループを**内部**プロジェクトに招待する。
- **内部**グループを**パブリック**プロジェクトに招待する。
- **パブリック**グループを**パブリック**プロジェクトに招待する。

プロジェクトのトップレベルグループが、階層外でプロジェクトを共有することを許可していない場合、招待されたグループまたはサブグループは、プロジェクトの[ネームスペース](../../namespace/_index.md)に存在している必要があります。

### メンバーのアクセスとロール

グループをプロジェクトに招待すると、次のメンバーがプロジェクトへのアクセス権を取得します。

- 直接グループメンバー。
- 継承されたグループメンバー。
- 招待されたグループと[共有されている他のグループのメンバー](sharing_projects_groups.md#invite-a-group-to-a-group)。

各メンバーのアクセス権は、次のものに基づいています。

- グループ内で割り当てられているロール。
- グループを招待するときに選択する最大のロール。

グループメンバーのグループのロールに、プロジェクトの最大ロールよりも少ない権限しかない場合、メンバーはグループのロールの権限を保持します。たとえば、最大のロールがメンテナーであるプロジェクトにゲストロールのメンバーを追加した場合、メンバーはプロジェクトに対してゲストロールの権限のみを持ちます。

さらに、次の通りとなります。

- グループのページでは、プロジェクトは**共有プロジェクト**タブにリストされています。
- プロジェクトの**メンバー**ページでは、グループは**グループ**タブにリストされています。このリストには、パブリックグループとプライベートグループの両方が含まれています。
- プロジェクトの**メンバー**ページでは、招待されたグループのメンバーは**メンバー**タブにリストされています。
- 使用量クォータページでは、プロファイルの横に**プロジェクト招待**バッジが付いているメンバーは、共有プロジェクトのトップレベルグループの請求対象メンバーとしてカウントされます。

[GitLab 16.11以降](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144638)では、招待されたグループの名前とメンバーシップソースは、**メンバー**タブと**グループ**タブでマスクされます。ただし、次のいずれかに該当する場合を除きます。

- 招待グループが公開されている。
- 現在のユーザーが、招待されたグループのメンバーである。
- 現在のユーザーが、現在のグループのオーナーであるか、現在のプロジェクトのメンテナー/オーナーである。

{{< alert type="note" >}}

招待されたグループの名前とメンバーシップソースは、招待されたグループへのアクセス権を持たないメンバーからはマスクされます。ただし、プロジェクトのメンテナーとオーナーがプライベート招待グループにアクセスできない場合でも、プライベート招待グループメンバーのソースを確認できます。この動作は、プロジェクトのメンテナーとオーナーが所有するプロジェクトのメンバーシップをより適切に管理できるようにすることを目的としています。

{{< /alert >}}

### 例

ネームスペース`group/subgroup01/project`のプロジェクトの場合:

- `group/subgroup02`または`group/subgroup01/subgroup03`と共有できます。
- プロジェクトのトップレベルグループが階層外でプロジェクトを共有することを許可していない場合を除き、`group_abc`と共有できます。

`Group 1`によって作成されたプロジェクトの場合:

- `Group 1`のメンバーは、プロジェクトへのアクセス権を持っています。
- `Group 1`のオーナーは、`Group 2`をプロジェクトに招待できます。これにより、`Group 1`と`Group 2`の両方のメンバーが、共有プロジェクトへのアクセス権を持つようになります。

### プロジェクトへグループを招待する

{{< history >}}

- GitLab 16.10で、`webui_members_inherited_users`という名前の[フラグ](../../../administration/feature_flags.md)とともに、招待されたグループメンバーをメンバーページのメンバータブに表示するように[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/219230)されました。デフォルトでは無効になっています。
- 機能フラグ`webui_members_inherited_users`は、GitLab 17.0で [GitLab.comおよびGitLab Self-Managedで有効](https://gitlab.com/gitlab-org/gitlab/-/issues/219230)になりました。
- サブグループとプロジェクトの直接メンバーのアクセス有効期限が[削除](https://gitlab.com/gitlab-org/gitlab/-/issues/471051)され、機能フラグ`webui_members_inherited_users`がGitLab 17.4で[削除](https://gitlab.com/gitlab-org/gitlab/-/issues/364078)されました。

{{< /history >}}

前提要件:

- メンテナーまたはオーナーのロールを持っている必要があります。
- 他のグループとのプロジェクトの共有が禁止されていない状態である必要があります。
- 招待されたグループまたはサブグループのメンバーである必要があります。

グループをプロジェクトに招待するには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを検索します。
1. **管理 > メンバー**を選択します。
1. **グループを招待**を選択します。
1. **招待するグループを選択**リストで、招待するグループを選択します。
1. **最大のロールを選択**リストから、招待されたグループのメンバーがプロジェクト内で持つことができる最高の[ロール](../../permissions.md)を選択します。ロールが高いグループメンバーは、このロールに制限されますが、ロールが低いメンバーは、既存のロールを保持します。
1. （オプション）**Access expiration date（アクセス有効期限）**を選択します。その日以降、招待されたグループはプロジェクトにアクセスできなくなります。
1. **招待**を選択します。

招待されたグループが**グループ**タブに表示されます。REST APIを使用して[プロジェクトの招待グループを一覧表示](../../../api/projects.md#list-a-projects-invited-groups)することもできます。

プライベートグループは次のとおりです。

- 承認されていないユーザーからマスクされます。
- 保護ブランチ、保護タグ、保護環境のプロジェクト設定に表示されます。

**メンバー**タブには、次が表示されます。

- プロジェクトに直接追加されたメンバー。
- プロジェクトが追加されたグループ[ネームスペース](../../namespace/_index.md)の継承されたメンバー。

招待されたグループのメンバーは、`webui_members_inherited_users`機能フラグが有効になっていない限り、**メンバー**タブには表示されません。

#### 例

名前が`project-01`のプロジェクトには、次の直接メンバーがいます。

- ユーザーA、オーナー
- ユーザーB、メンテナー

名前が`group-01`のグループには、次の直接メンバーがいます。

- ユーザーC、オーナー
- ユーザーD、メンテナー
- ユーザーE、レポーター

`group-01`が`project-01`に`Developer`権限で招待されると、ユーザーは次のロールを持ちます。

- ユーザーA、オーナー
- ユーザーB、メンテナー
- ユーザーC、デベロッパー
- ユーザーD、デベロッパー
- ユーザーE、レポーター

`group-01`が`project-01`に`Owner`権限で招待されると、ユーザーは次のロールを持ちます。

- ユーザーA、オーナー
- ユーザーB、メンテナー
- ユーザーC、オーナー
- ユーザーD、メンテナー
- ユーザーE、レポーター

### 共有プロジェクトを表示する

共有プロジェクトとは、[**グループを招待**](#invite-a-group-to-a-project)アクションを通じてグループメンバーにリソースへのアクセスを招待したプロジェクトのことです。

グループとアクセス権を共有しているプロジェクトを表示するには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択し、グループを検索します。
1. グループページで、**共有プロジェクト**タブを選択します。

共有プロジェクトのリストが表示されます。REST APIを使用して、[グループの共有プロジェクトを一覧表示](../../../api/groups.md#list-shared-projects)することもできます。

### プロジェクトがグループと共有されないようにする

別のグループとプロジェクトを共有すると、プロジェクトにさらに多くのメンバーを招待できるユーザーの数が増えます。各（サブ）グループは、アクセス許可の追加ソースになる可能性があります。したがって、混乱しやすく、制御が難しくなる場合があります。

プロジェクトが他のグループと共有されないようにするには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択し、グループを検索します。
1. **設定 > 一般**を選択します。
1. **権限とグループ機能**セクションを展開します。
1. **`<group_name>`のプロジェクトを他のグループと共有できません**を選択します。
1. **変更を保存**を選択します。

この設定を有効にすると、次の通りとなります。

- グループオーナーによってオーバーライドされない限り、すべてのサブグループに適用されます。
- プロジェクトに既に追加されているグループは、プロジェクトへのアクセス権を失います。

{{< alert type="note" >}}

[グループのユーザー上限を指定](../../group/manage.md#specify-a-user-cap-for-a-group)すると、この設定を無効にすることはできません。

{{< /alert >}}

## グループを共有する

別のグループのメンバーに自分のグループへのアクセスを許可する場合は、[グループ](../../group/_index.md)を自分のグループに招待できます。グループの直接メンバーはグループへのアクセス権を取得し、グループは**共有グループ**になります。

招待されたグループの直接メンバーのみが、共有グループへのアクセス権を取得できます。継承されたメンバーまたはサブグループメンバーはアクセスできません。サブグループメンバーにアクセスを許可するには、サブグループを直接招待します。

次のテーブルに、共有グループへのアクセス権を取得するグループメンバーの概要を示します。

| グループメンバーのソース                                          | 共有グループへのアクセス |
|--------------------------------------------------------------|------------------------|
| 招待されたグループの直接メンバー                   | {{< icon name="check-circle" >}} はい   |
| 招待されたグループの継承されたメンバー                | {{< icon name="dotted-circle" >}} いいえ    |
| サブグループのメンバー。ただし、招待されたグループのメンバーではない    | {{< icon name="dotted-circle" >}} いいえ    |

### メンバーのアクセスとロール

各メンバーのアクセス権は、次のものに基づいています。

- 招待されたグループで割り当てられているロール。
- グループを招待するときに選択する最大のロール。

グループメンバーの招待されたグループのロールに、グループの最大ロールよりも少ない権限しかない場合、メンバーは招待されたグループのロールの権限を保持します。招待されたグループのアクセス権と招待するグループのアクセス権の間で、最小限のアクセス権が付与されます。

グループをグループに招待した後は、次の通りとなります。

- グループの概要ページで、このグループと共有されているグループは**共有グループ**タブにリストされています。
- グループの**メンバー**ページでは、招待されたグループが**グループ**タブにリストされます。このリストには、パブリックグループとプライベートグループの両方が含まれています。
- グループの**メンバー**ページでは、招待されたグループのメンバーが**メンバー**タブにリストされます。
- グループの使用量クォータページでは、プロファイルの横に**グループ招待**バッジが付いている招待されたグループの直接メンバーは、招待グループの請求対象メンバーとしてカウントされます。

[GitLab 16.11以降](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144638)では、招待されたグループの名前とメンバーシップソースは、**メンバー**タブと**グループ**タブでマスクされます。ただし、次のいずれかに該当する場合を除きます。

- 招待グループが公開されている。
- 現在のユーザーが、招待されたグループのメンバーである。
- 現在のユーザーが、現在のグループのオーナーであるか、現在のプロジェクトのメンテナー/オーナーである。

{{< alert type="note" >}}

招待されたグループの名前とメンバーシップソースは、招待されたグループへのアクセス権を持たないメンバーからはマスクされます。ただし、グループオーナーがプライベート招待グループにアクセスできない場合でも、プライベート招待グループメンバーのソースを確認できます。この動作は、グループオーナーが所有するグループのメンバーシップをより適切に管理できるようにすることを目的としています。

{{< /alert >}}

### 例

`User A`は`Group 1`の直接メンバーであり、グループのメンテナーロールを持っています。`Group 2`は、デベロッパーロールで`Group 1`を招待します。`User A`は`Group 2`でデベロッパーロールを持っています。

`User B`は、`Group 1`の継承されたメンバーです。`Group 1`が招待されても、このユーザーは`Group 2`へのアクセス権を取得できません。

### グループにグループを招待する

{{< history >}}

- GitLab 17.4で、サブグループおよびプロジェクトの直接メンバーのアクセス有効期限が[削除](https://gitlab.com/gitlab-org/gitlab/-/issues/471051)されました。

{{< /history >}}

グループをプロジェクトに招待する方法と同様に、グループを別のグループに招待できます。

前提要件:

- 招待グループと招待するグループのメンバーである必要があります。

グループを自分のグループに招待するには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択し、グループを検索します。
1. **管理 > メンバー**を選択します。
1. **グループを招待**を選択します。
1. **招待するグループを選択**リストで、招待するグループを選択します。
1. グループのユーザーに最適な[ロール](../../permissions.md)または[カスタムロール](../../custom_roles/_index.md#assign-a-custom-role-to-an-invited-group)を選択します。
1. （オプション）**Access expiration date（アクセス有効期限）**を選択します。その日以降、招待されたグループはグループにアクセスできなくなります。
1. **招待**を選択します。

### 招待されたグループを削除します。

招待されたグループを削除するには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択し、グループを検索します。
1. **管理 > メンバー**を選択します。
1. **グループ**タブを選択します。
1. 削除するグループの右側にある**グループを削除する**（{{< icon name="remove" >}}）を選択します。

招待されたグループを自分のグループから削除すると、次の通りとなります。

- 招待されたグループのすべての直接メンバーは、自分のグループへのアクセス権を持たなくなります。
- 招待されたグループのメンバーは、グループの請求対象メンバーとしてカウントされなくなります。

### 共有グループを表示する

共有グループとは、[**グループを招待**](#invite-a-group-to-a-group)アクションを通じてグループメンバーにリソースへのアクセスを招待したグループのことです。

グループとアクセス権を共有しているグループを表示するには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択し、グループを検索します。
1. グループページで、**共有グループ**タブを選択します。

共有グループのリストが表示されます。REST APIを使用して[グループの共有グループをリスト表示](../../../api/groups.md#list-shared-groups)することもできます。

### グループ階層外へのグループの招待を禁止する

トップレベルグループのサブグループとプロジェクトが、トップレベルグループの階層外の他のグループを招待できないように、トップレベルグループを設定できます。このオプションは、トップレベルグループでのみ使用できます。

たとえば、次のようなグループとプロジェクトの階層があるとします。

- **動物 > 犬 > 犬プロジェクト**
- **動物 > 猫**
- **植物 > 木**

この際、**動物**グループの階層外へのグループの招待を禁止した場合、次の通りとなります。

- **犬**は**猫**グループを招待できます。
- **犬**は**木**グループを招待できません。
- **犬プロジェクト**は**猫**グループを招待できます。
- **犬プロジェクト**は**木**グループを招待できません。

グループの階層外へのグループの招待を禁止するには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択し、グループを検索します。
1. **設定 > 一般**を選択します。
1. **権限とグループ機能**を展開します。
1. **メンバーは、`<group_name>`とそのサブグループ以外のグループを招待できません**を選択します。
1. **変更を保存**を選択します。

## コラボレーションのためにグループを設定する

グループ内のプロジェクトで外部ユーザーとコラボレーションする場合は、次のベストプラクティスを検討してください。

- 組織のニーズに基づいて、グループとサブグループを論理的に構成してください。不要なグループの作成は避けてください。
- 管理するユーザーが多い場合は、プロジェクトを編成するグループとは別に、ユーザーをグループに編成することを検討してください。これらのユーザーグループを、アクセスする必要があるグループとプロジェクトに共有します。
- プロジェクトに招待するグループを慎重に検討してください。共有の過剰を防ぎ、セキュリティを維持するために、アクセスする必要のあるグループのみを招待してください。
- グループを招待する場合に、次を行ってください。
  - 最大のロールを適切に設定します。最高のロールをデフォルトにするのではなく、必要な最小限の権限を割り当てることをお勧めします。
  - 招待されたグループのサブグループのメンバーに、プロジェクトへのアクセス権を付与しないようにします。代わりに、サブグループを個別に招待することをお勧めします。
- プロジェクトへのアクセス権を持つ複数のグループに所属するユーザーの最大ロールを確認してください。意図しない高い権限を防ぐために、ユーザーのロールを変更することをお勧めします。
- 共有プロジェクトへのグループアクセスを定期的に確認し、必要に応じて更新してください。グループがプロジェクトへのアクセスを必要としなくなった場合は、削除します。
