---
stage: Plan
group: Project Management
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: ラベル
---

{{< details >}}

- プラン:Free、Premium、Ultimate
- 提供:GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

ラベルは、GitLab 機能全体で作業を整理および追跡します。プロジェクトが小規模チームから大規模な組織に成長するにつれて、ラベルは増加する作業量を追跡および管理するのに役立ちます。ラベル:

- カスタム属性でイシュー、マージリクエスト、およびエピックを分類します。
- リストとボードのコンテンツをフィルタリングします。
- 色と説明的なタイトルで作業アイテムに優先順位を付けます。
- 範囲指定したラベルで優先度と重大度を追跡します。
- 整理されたグループ化を通じてワークフローを構造化します。

## ラベルの種類

GitLabでは、次の2種類のラベルを使用できます。

- **プロジェクトラベル**は、そのプロジェクト内のイシューとマージリクエストにのみ割り当てることができます。
- **グループラベル**は、選択したグループまたはそのサブグループ内の任意のプロジェクトのイシュー、マージリクエスト、および[エピック](../group/epics/_index.md)に割り当てることができます。

## ラベルの割り当てと割り当て解除

{{< history >}}

- サイドバーでのリアルタイム更新は、GitLab 14.10で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/241538)され、`realtime_labels`という名前の[機能フラグ](../../administration/feature_flags.md)が使用され、デフォルトで無効になっています。
- サイドバーでのリアルタイム更新は、GitLab 15.1の[GitLab.comで有効](https://gitlab.com/gitlab-org/gitlab/-/issues/357370#note_991987201)になりました。
- サイドバーでのリアルタイム更新は、GitLab 15.5で[デフォルトで有効](https://gitlab.com/gitlab-org/gitlab/-/issues/357370)になっています。
- サイドバーでのリアルタイム更新は、GitLab 15.6で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/103199)されました。`realtime_labels`機能フラグを削除しました。

{{< /history >}}

ラベルは、任意のイシュー、マージリクエスト、またはエピックに割り当てることができます。

ラベルの変更は、ページを更新しなくても、次の場所で他のユーザーにすぐに表示されます。

- エピック
- インシデント
- イシュー
- マージリクエスト

ラベルを割り当てる、または割り当てを解除するには:

1. サイドバーの**ラベル**セクションで、**Edit**を選択します。
1. **ラベル割り当て**リストで、名前を入力してラベルを検索します。繰り返し検索して、さらにラベルを追加できます。選択したラベルにはチェックマークが付いています。
1. 割り当てるまたは割り当てを解除するラベルを選択します。
1. ラベルへの変更を適用するには、**ラベル割り当て**の横にある**X**を選択するか、ラベルセクションの外側の任意の領域を選択します。

または、ラベルの割り当てを解除するには、割り当てを解除するラベルの**X**を選択します。

[クイック アクション](quick_actions.md)を使用してラベルを割り当てたり、割り当て解除することもできます。

- `/label`を使用してラベルを割り当てます。
- `/unlabel`を使用してラベルを削除します。
- `/relabel`を使用してすべてのラベルを削除し、新しいラベルを割り当てます。

## 利用可能なラベルを表示

### プロジェクトラベルを表示

**プロジェクトのラベル**を表示するには:

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを見つけます。
1. **ラベル > 管理**を選択します。

または:

1. イシューまたはマージリクエストを表示します。
1. 右側のサイドバーの**ラベル**セクションで、**編集**を選択します。
1. **プロジェクトラベルの管理**を選択します。

ラベルのリストには、プロジェクトで作成されたラベルと、プロジェクトの祖先グループで作成されたすべてのラベルが含まれます。ラベルごとに、それが作成されたプロジェクトまたはグループのパスを確認できます。

### グループラベルを表示

**グループのラベル**を表示するには:

1. 左側のサイドバーで、**検索または移動**を選択し、グループを見つけます。
1. **ラベル > 管理**を選択します。

または:

1. エピックを表示します。
1. 右側のサイドバーの**ラベル**セクションで、**編集**を選択します。
1. **グループラベルの管理**を選択します。

リストには、グループ内でのみ作成されたすべてのラベルが含まれます。グループのプロジェクトで作成されたラベルはリストされません。

## ラベルを作成

{{< history >}}

- ラベルを作成するための最小ロールは、GitLab 17.7でレポーターから[プランナー](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)に変更されました。

{{< /history >}}

前提要件:

- プロジェクトまたはグループのプランナーロール以上を持っている必要があります。

### プロジェクトラベルを作成

プロジェクトラベルを作成するには:

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを見つけます。
1. **ラベル > 管理**を選択します。
1. **新しいラベル**を選択します。
1. **タイトル**フィールドに、ラベルの短い説明的な名前を入力します。このフィールドを使用して、[スコープ指定された相互に排他的なラベル](#scoped-labels)を作成することもできます。
1. 任意。**説明**フィールドに、このラベルの使用方法と時期に関する追加情報を入力します。
1. 任意。使用可能な色から選択するか、**背景色**フィールドに特定の色を表す16進数のカラー値を入力して、色を選択します。
1. **ラベルを作成**を選択します。

### イシューまたはマージリクエストからプロジェクトラベルを作成

{{< history >}}

- ラベルを作成するための最小ロールは、GitLab 17.7でレポーターから[プランナー](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)に変更されました。

{{< /history >}}

イシューまたはマージリクエストから新しいプロジェクトラベルを作成することもできます。この方法で作成するラベルは、イシューまたはマージリクエストと同じプロジェクトに属します。

前提要件:

- プロジェクトのプランナーロール以上を持っている必要があります。

これを行うには:

1. イシューまたはマージリクエストを表示します。
1. 右側のサイドバーの**ラベル**セクションで、**編集**を選択します。
1. **プロジェクトラベルを作成**を選択します。
1. 名前フィールドに入力します。この方法でラベルを作成する場合、説明を指定することはできません。説明は後で[ラベルを編集する](#edit-a-label)ことで追加できます。
1. 使用可能な色から選択するか、特定の色を表す16進数のカラー値を入力して、色を選択します。
1. **作成する**を選択します。ラベルが作成され、選択されます。

### グループラベルを作成

グループラベルを作成するには:

1. 左側のサイドバーで、**検索または移動**を選択し、グループを見つけます。
1. **ラベル > 管理**を選択します。
1. **新しいラベル**を選択します。
1. **タイトル**フィールドに、ラベルの短い説明的な名前を入力します。このフィールドを使用して、[スコープ指定された相互に排他的なラベル](#scoped-labels)を作成することもできます。
1. 任意。**説明**フィールドに、このラベルの使用方法と時期に関する追加情報を入力します。
1. 任意。使用可能な色から選択するか、**背景色**フィールドに特定の色を表す16進数のカラー値を入力して、色を選択します。
1. **ラベルを作成**を選択します。

### エピックからグループラベルを作成

{{< details >}}

- プラン:Premium、Ultimate
- 提供:GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- グループラベルを作成するための最小ロールは、GitLab 17.7でレポーターから[プランナー](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)に変更されました。

{{< /history >}}

エピックから新しいグループラベルを作成することもできます。この方法で作成するラベルは、エピックと同じグループに属します。

前提要件:

- グループのプランナーロール以上を持っている必要があります。

これを行うには:

1. エピックを表示します。
1. 右側のサイドバーの**ラベル**セクションで、**編集**を選択します。
1. **グループラベルを作成**を選択します。
1. 名前フィールドに入力します。この方法でラベルを作成する場合、説明を指定することはできません。説明は後で[ラベルを編集する](#edit-a-label)ことで追加できます。
1. 使用可能な色から選択するか、特定の色を表す16進数のカラー値を入力して、色を選択します。
1. **作成する**を選択します。

## ラベルを編集

{{< history >}}

- ラベルを編集するための最小ロールは、GitLab 17.7でレポーターから[プランナー](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)に変更されました。

{{< /history >}}

前提要件:

- プロジェクトまたはグループのプランナーロール以上を持っている必要があります。

### プロジェクトラベルを編集

**プロジェクト**ラベルを編集するには:

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを見つけます。
1. **ラベル > 管理**を選択します。
1. 編集するラベルの横にある縦方向の省略記号 ({{< icon name="ellipsis_v" >}})を選択し、次に**編集**を選択します。
1. **変更を保存**を選択します。

### グループラベルを編集

**グループ**ラベルを編集するには:

1. 左側のサイドバーで、**検索または移動**を選択し、グループを見つけます。
1. **ラベル > 管理**を選択します。
1. 編集するラベルの横にある縦方向の省略記号 ({{< icon name="ellipsis_v" >}})を選択し、次に**編集**を選択します。
1. **変更を保存**を選択します。

## ラベルを削除

{{< history >}}

- ラベルを削除するための最小ロールは、GitLab 17.7でレポーターから[プランナー](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)に変更されました。

{{< /history >}}

{{< alert type="warning" >}}

等しいラベルを削除すると、完全に削除されます。ラベルへのすべての参照がシステムから削除され、削除を元に戻すことはできません。

{{< /alert >}}

前提要件:

- プロジェクトのプランナーロール以上を持っている必要があります。

### プロジェクトラベルを削除

**プロジェクト**ラベルを削除するには:

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを見つけます。
1. **ラベル > 管理**を選択します。
1. **サブスクライブ**ボタンの横にある(\[{{< icon name="ellipsis_v" >}}])を選択し、次に**削除**を選択します。

### グループラベルを削除

**グループ**ラベルを削除するには:

1. 左側のサイドバーで、**検索または移動**を選択し、グループを見つけます。
1. **ラベル > 管理**を選択します。
1. 次のいずれか:

   - **サブスクライブ**ボタンの横にある(\[{{< icon name="ellipsis_v" >}}])を選択します。
   - 編集するラベルの横にある**編集** ({{< icon name="pencil" >}})を選択します。

1. **削除**を選択します。

## プロジェクトラベルをグループラベルにプロモート

{{< history >}}

- ラベルをプロモートするための最小ロールは、GitLab 17.7でレポーターから[プランナー](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)に変更されました。

{{< /history >}}

同じグループ内の他のプロジェクトでプロジェクトラベルを使用できるようにすることができます。次に、ラベルをグループラベルにプロモートできます。

同じグループ内の他のプロジェクトに同じタイトルのラベルがある場合、それらはすべて新しいグループラベルとマージされます。同じタイトルのグループラベルが存在する場合、それもマージされます。

{{< alert type="warning" >}}

ラベルのプロモートは永続的なアクションであり、元に戻すことはできません。

{{< /alert >}}

前提要件:

- プロジェクトのプランナーロール以上を持っている必要があります。
- プロジェクトの親グループのプランナーロール以上を持っている必要があります。

プロジェクトラベルをグループラベルにプロモートするには:

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを見つけます。
1. **ラベル > 管理**を選択します。
1. **サブスクライブ**ボタンの横にある3つのドット({{< icon name="ellipsis_v" >}})を選択し、**グループラベルをプロモートする**を選択します。

古いラベルが付いたすべてのイシュー、マージリクエスト、イシューボードリスト、イシューボードフィルター、およびラベルサブスクリプションが、新しいグループラベルに割り当てられます。

新しいグループラベルには、以前のプロジェクトラベルと同じIDが設定されます。

## サブグループラベルを親グループにプロモート

{{< history >}}

- ラベルをプロモートするための最小ロールは、GitLab 17.7でレポーターから[プランナー](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)に変更されました。

{{< /history >}}

グループラベルを親グループに直接プロモートすることはできません。これを実現するには、次の回避策を使用してください。

前提要件:

- サブグループを含むグループ（「親グループ」）が必要です。
- 親グループに、プロモートするラベルを持つサブグループが必要です。
- 両方のグループのプランナーロール以上を持っている必要があります。

ラベルを親グループに「プロモート」するには:

1. 親グループで、元のラベルと同じ名前の[ラベルを作成](#create-a-group-label)します。これを行っている間は、2つを間違えないように、異なる色にすることをお勧めします。
1. サブグループで、[そのラベルを表示](#view-group-labels)します。2つのラベルとその出典が表示されます:

   ![サブグループのラベルリストにある親グループとサブグループのラベル](img/promote_to_parent_group_workaround_v14_10.png)

1. サブグループラベル（古いラベル）の横にある**イシュー**、**マージリクエスト**、または**エピック**を選択します。
1. 古いラベルを持つイシュー、マージリクエスト、およびエピックに新しいラベルを追加します。より迅速に行うには、[一括編集](issues/managing_issues.md#bulk-edit-issues-from-a-group)を使用します。
1. サブグループまたは親グループで、下位グループに属する[ラベルを削除](#delete-a-group-label)します。

これで、親グループに古いラベルと同じ名前のラベルが設定され、同じイシュー、MR、およびエピックに追加されます。

## デフォルトのプロジェクトラベルを生成

{{< history >}}

- デフォルトのラベルを生成するための最小ロールは、GitLab 17.7でレポーターから[プランナー](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)に変更されました。

{{< /history >}}

プロジェクトまたはその親グループにラベルがない場合は、ラベルリストページからデフォルトのプロジェクトラベルセットを生成できます。

前提要件:

- プロジェクトのプランナーロール以上を持っている必要があります。
- プロジェクトにラベルが存在しない必要があります。

デフォルトのラベルをプロジェクトに追加するには:

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを見つけます。
1. **ラベル > 管理**を選択します。
1. **ラベルのデフォルトセットを生成する**を選択します。

次のラベルが作成されます:

- `bug`
- `confirmed`
- `critical`
- `discussion`
- `documentation`
- `enhancement`
- `suggestion`
- `support`

## 範囲指定したラベル

{{< details >}}

- プラン:Premium、Ultimate
- 提供:GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

チームは、範囲指定したラベルを使用して、相互に排他的なラベルでイシュー、マージリクエスト、およびエピックに注釈を付けることができます。特定のラベルが一緒に使用されるのを防ぐことで、より複雑なワークフローを作成できます。

![範囲指定したラベル](img/labels_key_value_v13_5.png)

範囲指定したラベルは、タイトルにダブルコロン（`::`）構文を使用します（例：`workflow::in-review`）。

イシュー、マージリクエスト、またはエピックは、同じ`key`を持つ`key::value`形式の範囲指定したラベルを2つ持つことはできません。同じ`key`で異なる`value`を持つ新しいラベルを追加すると、以前の`key`ラベルが新しいラベルに置き換えられます。

<div class="video-fallback">
  動画をご覧ください:<a href="https://www.youtube.com/watch?v=7l7tnEva6I8">範囲指定したラベル - GitLab で組織をセットアップする</a>。
</div>
<figure class="video-container">
  <iframe src="https://www.youtube-nocookie.com/embed/7l7tnEva6I8" frameborder="0" allowfullscreen> </iframe>
</figure>

### 範囲指定したラベルでフィルタリング

指定されたスコープでイシュー、マージリクエスト、またはエピックリストをフィルタリングするには、検索されたラベル名に`<scope>::*`を入力します。

たとえば、`platform::*`ラベルでフィルタリングすると、`platform::iOS`、`platform::Android`、または`platform::Linux`ラベルを持つイシューが返されます。

{{< alert type="note" >}}

範囲指定したラベルによるフィルタリングは、イシューまたはマージリクエストのダッシュボードページでは使用できません。

{{< /alert >}}

### 範囲指定したラベルの例

**例1。**イシューの優先度を更新する：

1. イシューの優先度が低いと判断し、`priority::low`ラベルを割り当てます。
1. さらにレビューした後、イシューの優先度が高くなったことに気付き、`priority::high`ラベルを割り当てます。
1. イシューは2つの優先度ラベルを同時に持つべきではないため、GitLabは`priority::low`ラベルを削除します。

**例2。**各イシューが1つのプラットフォームのみをターゲットとする、機能が対象とするオペレーティングシステムプラットフォームを追跡するために、イシューにカスタムフィールドが必要であるとします。

3つのラベルを作成します。

- `platform::iOS`
- `platform::Android`
- `platform::Linux`

これらのラベルのいずれかをイシューに割り当てると、`platform::`で始まる既存のラベルが自動的に削除されます。

**例3。**範囲指定したラベルを使用して、チームのワークフローの状態を表すことができます。

次のラベルがあるとします:

- `workflow::development`
- `workflow::review`
- `workflow::deployed`

イシューに`workflow::development`ラベルが既にあり、デベロッパーがイシューがレビュー中であることを示したい場合は、`workflow::review`を割り当てると、`workflow::development`ラベルが削除されます。

これは、[イシューボード](issue_board.md)のラベルリスト間でイシューを移動する場合にも発生します。範囲指定したラベルを使用すると、イシューボードで作業していないチームメンバーも、イシュー自体でワークフローの状態を一貫して進めることができます。

動画での説明については、以下をご覧ください。

<div class="video-fallback">
  動画をご覧ください:<a href="https://www.youtube.com/watch?v=4BCBby6du3c">カスタムフィールドとカスタムワークフローに範囲指定したラベルを使用する</a>。
</div>
<figure class="video-container">
  <iframe src="https://www.youtube-nocookie.com/embed/4BCBby6du3c" frameborder="0" allowfullscreen> </iframe>
</figure>

### ネストされたスコープ

作成時に複数のダブルコロン`::`を使用して、ネストされたスコープを持つラベルを作成できます。この場合、最後の`::`より前のすべてのものがスコープです。

たとえば、プロジェクトに次のラベルがあるとします:

- `workflow::backend::review`
- `workflow::backend::development`
- `workflow::frontend::review`

イシューは、`workflow::backend::review`ラベルと`workflow::backend::development`ラベルの両方を同時に持つことは**できません**。それらは両方とも同じスコープを共有しているためです：`workflow::backend`。

一方、イシューは、`workflow::backend::review`ラベルと`workflow::frontend::review`ラベルの両方を同時に持つことが**できます**。それらは両方とも異なるスコープを持っているためです：`workflow::frontend`と`workflow::backend`。

## ラベルが使用されたときに通知を受け取る

ラベルにサブスクライブすると、ラベルがイシュー、マージリクエスト、またはエピックに割り当てられるたびに[通知を受け取る](../profile/notifications.md)ことができます。

ラベルにサブスクライブするには：

1. [ラベルリストページを表示します。](#view-available-labels)
1. 任意のラベルの右側にある**サブスクライブ**を選択します。
1. 任意。プロジェクトからグループラベルにサブスクライブしている場合は、次のいずれかを選択します。
   - このプロジェクトのイベントに関する通知を受け取るには、**プロジェクトレベルでサブスクライブする**を選択します。
   - グループ全体のイベントに関する通知を受け取るには、**グループレベルでサブスクライブする**を選択します。

## ラベルの優先度を設定

{{< history >}}

- ラベルの優先度を設定するための最小ロールは、GitLab 17.7でレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

ラベルには相対的な優先度を設定できます。これは、イシューリストとマージリクエストリストを[ラベルの優先度](issues/sorting_issue_lists.md#sorting-by-label-priority)と[優先度](issues/sorting_issue_lists.md#sorting-by-priority)でソートする場合に使用されます。

ラベルの優先度を設定する場合は、プロジェクトから行う必要があります。グループラベルリストから行うことはできません。

{{< alert type="note" >}}

優先度のソートは、最も優先度の高いラベルのみに基づいています。[このディスカッション](https://gitlab.com/gitlab-org/gitlab/-/issues/14523)では、この変更を検討しています。

{{< /alert >}}

前提要件:

- プロジェクトのプランナーロール以上を持っている必要があります。

ラベルの優先度を設定するには：

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを見つけます。
1. **ラベル > 管理**を選択します。
1. 優先度を設定するラベルの横にある星印（{{< icon name="star-o" >}}）を選択します。

![ラベルの優先度](img/labels_prioritized_v13_5.png)

このラベルは、**優先ラベル**の下の、ラベルリストの最上部に表示されます。

これらのラベルの相対的な優先度を変更するには、リストを上下にドラッグします。リストの上位にあるラベルは、より高い優先度を取得します。

優先度またはラベル優先度でソートするとどうなるかについては、[イシューリストのソートと順序付け](issues/sorting_issue_lists.md)を参照してください。

## マージリクエストがマージされたときにラベルをロックする

{{< details >}}

- プラン:Free、Premium、Ultimate
- 提供:GitLab Self-Managed
- 状態：ベータ

{{< /details >}}

{{< history >}}

- GitLab 16.3 で`enforce_locked_labels_on_merge`という名前の[フラグ](../../administration/feature_flags.md)で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/408676)されました。この機能は[ベータ](../../policy/development_stages_support.md)版です。デフォルトでは無効になっています。
- ラベルをロックするための最小ロールは、GitLab 17.7でレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

{{< alert type="flag" >}}

この機能の可用性は、機能フラグによって制御されます。詳細については、履歴を参照してください。この機能はTestに使用できますが、本番環境での使用には適していません。

{{< /alert >}}

特定の監査要件に準拠するために、ラベルをロックされるように設定できます。ロックされたラベルを含むマージリクエストがマージされると、誰もMRからそれらを削除できません。

ロックされたラベルをイシューまたはエピックに追加すると、それらは標準のラベルのように動作します。

前提要件:

- プロジェクトまたはグループのプランナーロール以上を持っている必要があります。

{{< alert type="warning" >}}

ラベルをロックとして設定すると、誰もそれを取り消したり、ラベルを削除したりすることはできません。

{{< /alert >}}

マージ時にロックされるようにラベルを設定するには：

1. 左側のサイドバーで、**検索または移動**を選択して、グループまたはプロジェクトを見つけます。
1. **ラベル > 管理**を選択します。
1. 編集するラベルの横にある縦方向の省略記号 ({{< icon name="ellipsis_v" >}})を選択し、次に**編集**を選択します。
1. **マージリクエストのマージ後にラベルをロック**チェックボックスを選択します。
1. **変更を保存**を選択します。

## 関連トピック

次のチュートリアルでラベルの操作を練習します。

- [イシュートリアージ用に単一のプロジェクトを設定する](../../tutorials/issue_triage/_index.md)
- [チームハンドオフ用のイシューボードを設定する](../../tutorials/boards_for_teams/_index.md)
