---
stage: Foundations
group: Personal Productivity
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 通知メール
---

{{< details >}}

- プラン:Free、Premium、Ultimate
- 提供:GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- 強化されたメールスタイリングは、`enhanced_notify_css` という[機能フラグ](../../administration/feature_flags.md)を使用して、GitLab 14.9 で[導入されました](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/78604)。デフォルトでは無効になっています。
- 強化されたメールスタイリングは、GitLab 14.9 で[GitLab.com で有効になりました](https://gitlab.com/gitlab-org/gitlab/-/issues/355907)。
- 強化されたメールスタイリングは、GitLab 15.0 で[GitLab Self-Managed で有効になりました](https://gitlab.com/gitlab-org/gitlab/-/issues/355907)。
- プロダクトマーケティングメールは、GitLab 16.6 で[削除されました](https://gitlab.com/gitlab-org/gitlab/-/issues/418137)。

{{< /history >}}

メール通知で GitLab で何が起こっているかを常に把握できます。イシュー、マージリクエスト、エピック、およびデザインのアクティビティに関する更新を受信できます。

GitLab 管理者がユーザーにメッセージを送信するために使用できるツールについては、[GitLab からのメール](../../administration/email_from_gitlab.md)をお読みください。

GitLab 17.2 以降では、[通知はユーザーあたり、プロジェクトまたはグループあたり、24時間ごとにレート制限](../../security/rate_limits.md#notification-emails)されます。

## 通知を受け取るユーザー

イシュー、マージリクエスト、またはエピックで通知が有効になっている場合、GitLab はそこで発生するアクションを通知します。

次のいずれかの理由で通知を受信する場合があります。

- イシュー、マージリクエスト、エピック、またはデザインに参加している。コメントまたは編集を行うか、誰かがあなたに<sup>1</sup>メンションすると、参加者になります。
- [イシュー、マージリクエスト、またはエピックで通知を有効にしました](#notifications-on-issues-merge-requests-and-epics)。
- [プロジェクト](#change-level-of-project-notifications)または[グループ](#group-notifications)の通知をConfigureしました。
- パイプラインメール[インテグレーション](../project/integrations/_index.md)を介して、グループまたはプロジェクトのパイプライン通知をサブスクライブしています。

> GitLab は、次の場合に通知を送信しません:
>
> - アカウントがプロジェクトボットである。
> - アカウントがデフォルトのメールアドレスを持つサービスアカウントである。
> - アカウントがブロック（BAN）または非アクティブ化されている。
> - [コメントが編集され、ユーザーメンションが含まれる](../discussions/_index.md#edit-a-comment-to-add-a-mention)。
> - 管理者が通知をブロックしました。

## 通知設定の編集

多数の通知を受け取ると、圧倒される可能性があります。受信する通知を調整できます。たとえば、特定のプロジェクト内のすべてのアクティビティについて通知を受けたい場合があります。他のプロジェクトでは、名前でメンションされた場合にのみ通知を受けたいと考えています。

これらの通知設定は、自分にのみ適用されます。他の人が受け取る通知には影響しません。

通知設定を編集するには:

1. 左側のサイドバーで、自分のアバターを選択します。
1. **\[設定]**を選択します。
1. 左側のサイドバーで、**\[通知]**を選択します。
1. 目的のグローバル、グループ、またはプロジェクトの通知設定を編集します。編集した設定は自動的に保存されます。

### 通知スコープ

プロジェクトおよびグループごとに異なる通知レベルを選択することで、通知のスコープを調整できます。

通知スコープは、最も広範なレベルから最も具体的なレベルに適用されます。

- アクティビティが発生したプロジェクトまたはグループの通知レベルを選択していない場合、**グループ**または_デフォルト_の通知レベルが適用されます。
- **グループ**設定は、デフォルト設定よりも優先されます。
- **プロジェクト**設定は、グループ設定よりも優先されます。

### 通知レベル

プロジェクトとグループごとに、次のいずれかのレベルを選択できます。

| レベル       | 説明                                                 |
| ----------- | ----------------------------------------------------------- |
| グローバル      | グローバル設定が適用されます。                                 |
| 視聴       | すべてのアクティビティに関する通知を受信します。                     |
| 参加 | 参加したスレッドに関する通知を受信します。 |
| メンション時  | コメントで[メンション](../discussions/_index.md#mentions)された場合に通知を受信します。 |
| 無効    | 通知を受信しません。                                   |
| カスタム      | 選択したイベントと参加したスレッドに関する通知を受信します。                  |

### グローバル通知設定

**グローバル通知設定**は、プロジェクトまたはグループの別の値を選択しない限り、デフォルトの設定になります。

- **通知メール**：通知の送信先メールアドレス。デフォルトでは、プライマリメールアドレスになります。
- **グローバル通知レベル**：すべての通知に適用されるデフォルトの[通知レベル](#notification-levels)。
- **自分自身のアクティビティに関する通知を受信する**：自分自身のアクティビティに関する通知を受信するチェックボックスをオンにします。デフォルトでは選択されていません。

### グループ通知

グループごとに、通知レベルとメールアドレスを選択できます。

#### グループ通知のレベルを変更

グループの通知レベルを選択するには、次のいずれかの方法を使用します。

1. 左側のサイドバーで、自分のアバターを選択します。
1. **\[設定]**を選択します。
1. 左側のサイドバーで、**\[通知]**を選択します。
1. **\[グループ]**セクションでグループを見つけます。
1. 目的の[通知レベル](#notification-levels)を選択します。

または:

1. 左側のサイドバーで、**\[検索または移動]**を選択して、グループを見つけます。
1. ベルアイコン({{< icon name="notifications" >}})の横にある通知ドロップダウンリストを選択します。
1. 目的の[通知レベル](#notification-levels)を選択します。

#### グループ通知に使用されるメールアドレスを変更

自分が所属するグループごとに通知を受信するメールアドレスを選択できます。たとえば、フリーランスで仕事をしている場合、クライアントのプロジェクトに関するメールを個別に管理したい場合に、グループ通知を使用できます。

1. 左側のサイドバーで、自分のアバターを選択します。
1. **\[設定]**を選択します。
1. 左側のサイドバーで、**\[通知]**を選択します。
1. **\[グループ]**セクションでグループを見つけます。
1. 目的のメールアドレスを選択します。

### プロジェクト通知のレベルを変更

常に最新の状態を維持できるように、プロジェクトごとに通知レベルを選択できます。

プロジェクトの通知レベルを選択するには、次のいずれかの方法を使用します。

1. 左側のサイドバーで、自分のアバターを選択します。
1. **\[設定]**を選択します。
1. 左側のサイドバーで、**\[通知]**を選択します。
1. **\[プロジェクト]**セクションでプロジェクトを見つけます。
1. 目的の[通知レベル](#notification-levels)を選択します。

または:

1. 左側のサイドバーで、**\[検索または移動]**を選択して、プロジェクトを見つけます。
1. ベルアイコン({{< icon name="notifications" >}})の横にある通知ドロップダウンリストを選択します。
1. 目的の[通知レベル](#notification-levels)を選択します。

<i class="fa fa-youtube-play youtube" aria-hidden="true"></i> 新しいリリースが利用可能になったときに通知を受け取る方法については、[リリースの通知](https://www.youtube.com/watch?v=qyeNkGgqmH4)をご覧ください。

## 通知イベント

ユーザーには、次のイベントが通知されます。

<!-- The table is sorted first by recipient, then alphabetically. -->

| イベント                                    | 送信先         | 設定レベル                                                                                                                          |
|------------------------------------------|-----------------|-----------------------------------------------------------------------------------------------------------------------------------------|
| 新しいリリース                              | プロジェクトメンバー | カスタム通知。                                                                                                                    |
| プロジェクトを移動                            | プロジェクトメンバー | 無効以外。                                                                                                                |
| メールアドレスを変更                            | ユーザー            | セキュリティメール、常に送信されます。                                                                                                            |
| グループアクセスレベルが変更されました               | ユーザー            | ユーザーグループのアクセスレベルが変更された場合に送信されます。                                                                                           |
| 新しいメールアドレスが追加されました                  | ユーザー            | セキュリティメール、プライマリメールアドレスに送信されます。                                                                                          |
| 新しいメールアドレスが追加されました                  | ユーザー            | セキュリティメール、新しく追加されたメールアドレスに送信されます。                                                                                      |
| 新しい SAML/SCIM ユーザーがプロビジョニングされました           | ユーザー            | ユーザーが SAML/SCIM を介してプロビジョニングされた場合に送信されます。                                                                                      |
| 新しい SSH 鍵が追加されました                        | ユーザー            | セキュリティメール、常に送信されます。                                                                                                            |
| 新しいユーザーが作成されました                         | ユーザー            | ユーザーの作成時に送信されます。OmniAuth (LDAP) は除きます。                                                                                      |
| パスワードが変更されました                         | ユーザー            | セキュリティメール。ユーザーが自分のパスワードを変更すると常に送信されます。                                                                       |
| 管理者によってパスワードが変更されました        | ユーザー            | セキュリティメール。管理者が別のユーザーのパスワードを変更すると常に送信されます。                                                 |
| パーソナルアクセストークンの有効期限が近づいています     | ユーザー            | セキュリティメール、常に送信されます。                                                                                                            |
| パーソナルアクセストークンが作成されました | ユーザー            | セキュリティメール、常に送信されます。                                                                                                            |
| パーソナルアクセストークンの有効期限が切れました      | ユーザー            | セキュリティメール、常に送信されます。                                                                                                            |
| パーソナルアクセストークンが取り消されました   | ユーザー            | セキュリティメール、常に送信されます。GitLab 15.5 で[導入されました](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/98911)。                 |
| グループアクセストークンの有効期限が近づいています        | 直接グループオーナー | セキュリティメール、常に送信されます。GitLab 16.4 で[導入されました](https://gitlab.com/gitlab-org/gitlab/-/issues/367705)。                 |
| プロジェクトアクセストークンの有効期限が近づいています      | 直接プロジェクトオーナーとメンテナー | セキュリティメール、常に送信されます。GitLab 16.4 で[導入されました](https://gitlab.com/gitlab-org/gitlab/-/issues/367706)。                 |
| プロジェクトアクセスレベルが変更されました             | ユーザー            | ユーザープロジェクトのアクセスレベルが変更された場合に送信されます。                                                                                         |
| SSH 鍵の有効期限が切れました                      | ユーザー            | セキュリティメール、常に送信されます。                                                                                                            |
| 2要素認証が無効       | ユーザー            | セキュリティメール、常に送信されます。                                                                                                            |
| グループにユーザーを追加                      | ユーザー            | ユーザーがグループに追加されたときに送信されます。                                                                                                       |
| プロジェクトにユーザーを追加                    | ユーザー            | ユーザーがプロジェクトに追加されたときに送信されます。                                                                                                     |
| グループアクセスの有効期限が切れました                     | グループメンバー   | ユーザーのグループへのアクセス権が 7 日後に期限切れになる場合に送信されます。GitLab 16.3 で_[導入されました](https://gitlab.com/gitlab-org/gitlab/-/issues/12704)。_                                                                                 |
| プロジェクトアクセスの有効期限が切れました                   | プロジェクトメンバー | ユーザーのプロジェクトへのアクセス権が 7 日後に期限切れになる場合に送信されます。GitLab 16.3 で_[導入されました](https://gitlab.com/gitlab-org/gitlab/-/issues/12704)。_                                                                                                   |

## イシュー、マージリクエスト、およびエピックに関する通知

イシュー、マージリクエスト、およびエピックで発生するイベントに関する通知も受信します。

### イシュー、マージリクエスト、およびエピックに関する通知を受信するユーザー

イシュー、マージリクエスト、およびエピックでは、ほとんどのイベントについて、通知は以下に送信されます。

- 参加者:
  - 作成者と担当者。
  - コメントの作成者。
  - タイトルまたは説明でユーザー名で[メンション](../discussions/_index.md#mentions)されたユーザー。
  - 通知レベルが「参加」以上のコメントでユーザー名でメンションされたユーザー。
- ウォッチャー: 通知レベルが「視聴」のユーザー。
- サブスクライバー: 通知を手動でサブスクライブしたすべてのユーザー。
- カスタム: 通知レベルが「カスタム」で、適切なタイプのイベントの通知をオンにしたユーザー。

アクションを必要としない通知の数を最小限に抑えるため、対象となる承認者には、プロジェクト内のすべてのアクティビティについて通知されません。このような通知をオンにするには、ユーザー通知の設定を**視聴**に変更する必要があります。

### イシュー、マージリクエスト、およびエピックの通知設定を編集

イシュー、マージリクエスト、またはエピックの通知を切り替えるには: 右側のサイドバーで、縦方向の省略記号({{< icon name="ellipsis_v" >}})を選択し、**\[通知]**トグルをオンまたはオフにします。

#### 移動された通知

{{< details >}}

- 提供:GitLab Self-Managed

{{< /details >}}

{{< history >}}

- `notifications_todos_buttons` という[フラグを使用して](../../administration/feature_flags.md)、GitLab 16.5 で[導入されました](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/132678)。デフォルトでは無効になっています。

{{< /history >}}

{{< alert type="flag" >}}

この機能の可用性は、機能フラグによって制御されます。詳細については、履歴を参照してください。この機能フラグを有効にすると、通知と To Do アイテムのボタンがページ右上に移動します。

{{< /alert >}}

**通知をオン**にすると、ディスカッションに参加していなくても、更新ごとに通知を受け取るようになります。エピックで通知をオンにしても、エピックにリンクされたイシューは自動的にサブスクライブされません。

**通知をオフ**にすると、更新に関する通知の受信が停止されます。この切替をオフにすると、このイシュー、マージリクエスト、またはエピックに関連する更新からのみ登録解除されます。GitLab からの[すべてのメールをオプトアウトする方法](#opt-out-of-all-gitlab-emails)をご覧ください。

### イシュー、マージリクエスト、およびエピックに関する通知イベント

次の表に、イシュー、マージリクエスト、およびエピックの通知を生成するイベントを示します。

| タイプ | イベント | 送信先 |
|------|-------|---------|
| エピック | 完了 | サブスクライバーと参加者。 |
| エピック | 新規 | 説明でユーザー名でメンションされたすべてのユーザー（通知レベルが「メンション」以上）。 |
| エピック | 新しいメモ | 参加者、ウォッチャー、サブスクライバー、およびこのイベントが選択されたカスタム通知レベル。また、コメントでユーザー名でメンションされたすべてのユーザー（通知レベルが「メンション」以上）。 |
| エピック | 再開 | サブスクライバーと参加者。 |
| イシュー | 完了 | サブスクライバーと参加者。 |
| イシュー | 期限 | 参加者と、このイベントが選択されたカスタム通知レベル。 |
| イシュー | マイルストーンが変更されました | サブスクライバーと参加者。 |
| イシュー | マイルストーンが削除されました | サブスクライバーと参加者。 |
| イシュー | 新規 | 説明でユーザー名でメンションされたすべてのユーザー（通知レベルが「メンション」以上）。 |
| イシュー | 新しいメモ | 参加者、ウォッチャー、サブスクライバー、およびこのイベントが選択されたカスタム通知レベル。また、コメントでユーザー名でメンションされたすべてのユーザー（通知レベルが「メンション」以上）。 |
| イシュー | タイトルまたは説明が変更されました | ユーザー名による新しいメンション。 |
| イシュー | 再割り当て済 | 参加者、ウォッチャー、サブスクライバー、このイベントが選択されたカスタム通知レベル、および古い担当者。 |
| イシュー | 再開 | サブスクライバーと参加者。 |
| マージリクエスト | 完了 | サブスクライバーと参加者。 |
| マージリクエスト | 競合 | 作成者、およびマージリクエストを自動マージに設定したすべてのユーザー。 |
| マージリクエスト | [準備完了としてマーク](../project/merge_requests/drafts.md) | ウォッチャーと参加者。 |
| マージリクエスト | マージ済 | サブスクライバーと参加者。 |
| マージリクエスト | パイプラインが成功した場合にマージ済 | 作成者、参加者、ウォッチャー、サブスクライバー、およびこのイベントが選択されたカスタム通知レベル。カスタム通知レベルは、作成者、ウォッチャー、およびサブスクライバーでは無視されます。 |
| マージリクエスト | マイルストーンが変更されました | サブスクライバーと参加者。 |
| マージリクエスト | マイルストーンが削除されました | サブスクライバーと参加者。 |
| マージリクエスト | 新規 | 説明でユーザー名でメンションされたすべてのユーザー（通知レベルが「メンション」以上）。 |
| マージリクエスト | 新しいメモ | 参加者、ウォッチャー、サブスクライバー、およびこのイベントが選択されたカスタム通知レベル。また、コメントでユーザー名でメンションされたすべてのユーザー（通知レベルが「メンション」以上）。 |
| マージリクエスト | プッシュ済 | 参加者と、このイベントが選択されたカスタム通知レベル。 |
| マージリクエスト | 再割り当て済 | 参加者、ウォッチャー、サブスクライバー、このイベントが選択されたカスタム通知レベル、および古い担当者。 |
| マージリクエスト | レビューリクエスト済 | 参加者、ウォッチャー、サブスクライバー、このイベントが選択されたカスタム通知レベル、および古いレビュアー。 |
| マージリクエスト | 再開 | サブスクライバーと参加者。 |
| マージリクエスト | タイトルまたは説明が変更されました | ユーザー名による新しいメンション。 |
| マージリクエスト | 承認者として追加 | このイベントが選択されたカスタム通知レベル。GitLab 16.7 で\[[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/12855)]されました。 |
| パイプライン | 失敗 | パイプラインの作成者。 |
| パイプライン | 修正済 | パイプラインの作成者。デフォルトで有効になっています。 |
| パイプライン | 成功 | パイプラインの作成者（パイプラインの成功に対するカスタム通知レベルを持つ）。パイプラインが以前に失敗した場合、失敗後の最初の成功したパイプラインに対して「パイプラインが修正されました」というメッセージが送信され、その後の成功したパイプラインに対して「パイプラインが成功しました」というメッセージが送信されます。 |

デフォルトでは、自分が作成したイシュー、マージリクエスト、またはエピックに関する通知は受信しません。自分のイシュー、マージリクエストなどで常に通知を受信するには、\[[自分のアクティビティに関する通知](#global-notification-settings)]をオンにします。

## 不明なサインインに関する通知

{{< history >}}

- GitLab 15.10 で\[[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/225183)]された、サインインしたユーザーのフルネームとユーザー名を一覧表示します。
- GitLab 17.5 で\[[追加](https://gitlab.com/gitlab-org/gitlab/-/issues/296128)]された地理的な場所。

{{< /history >}}

{{< alert type="note" >}}

この機能は、GitLab Self-Managedインスタンスではデフォルトで有効になっています。管理者は、UI の\[[サインイン制限](../../administration/settings/sign_in_restrictions.md#email-notification-for-unknown-sign-ins)]セクションからこの機能を無効にできます。この機能は、GitLab.com で常に有効になっています。

{{< /alert >}}

ユーザーが以前に不明な IP アドレスまたはデバイスから正常にサインインすると、GitLab はメールでユーザーに通知します。このようにして、GitLab は潜在的に悪意のあるまたは不正なサインインをユーザーに事前に警告します。この通知メールには以下が含まれます:

- ホスト名。
- ユーザーの名前とユーザー名。
- IP アドレス。
- 地理的な場所。
- サインインの日時。

GitLab は、既知のサインインを識別するためにいくつかのメソッドを使用します。通知メールを送信するには、すべてのメソッドが失敗する必要があります。

- 最終サインイン IP:現在のサインイン IP アドレスは、最終サインイン IP アドレスと照合されます。
- 現在のアクティブセッション:ユーザーが同じ IP アドレスから既存のアクティブセッションを持っている場合。\[[アクティブセッション](active_sessions.md)]を参照してください。
- Cookie:正常なサインイン後、暗号化された Cookie がブラウザーに保存されます。この Cookie は、最後の正常なサインインから 14 日後に期限切れになるように設定されています。

## 誤った確認コードを使用したサインインの試行に関する通知

{{< history >}}

- GitLab 15.5 で[導入されました](https://gitlab.com/gitlab-org/gitlab/-/issues/374740)。

{{< /history >}}

GitLab は、誤った 2要素認証（2FA）コードを使用してアカウントにサインインしようとする試みを検出した場合、メール通知を送信します。これにより、悪意のある第三者がユーザー名とパスワードにアクセスし、2FA をブルートフォース攻撃しようとしていることを検出できます。

## デザインに関する通知

誰かがデザインにコメントすると、参加者にメール通知が送信されます。

参加者は次のとおりです:

- デザインの作成者（異なる作成者が異なるバージョンのデザインをアップロードした場合、複数の人がいる可能性があります）。
- デザインに関するコメントの作成者。
- デザインに関するコメントで\[[メンション](../discussions/_index.md#mentions)]されたすべてのユーザー。

## グループまたはプロジェクトのアクセス期限に関する通知

{{< history >}}

- GitLab 16.3 で\[[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/12704)]されました。

{{< /history >}}

ユーザーのグループまたはプロジェクトへのアクセスが 7 日後に期限切れになる場合、GitLab はメール通知を送信します。これにより、グループまたはプロジェクトのメンバーは、必要に応じてアクセス期間を延長するように促されます。

## すべての GitLab メールをオプトアウトする

メール通知をもう受信したくない場合は、次の手順を実行します:

1. 左側のサイドバーで、自分のアバターを選択します。
1. **\[設定]**を選択します。
1. 左側のサイドバーで、**\[通知]**を選択します。
1. \[**グローバル通知レベル**]\*\*を\[**無効**]\*\*に設定します。
1. \[**自分自身のアクティビティに関する通知を受信する**]\*\*チェックボックスをオフにします。
1. グループまたはプロジェクトに所属している場合は、通知設定を\[**グローバル**]\*\*または\[**無効**]\*\*に設定します。

GitLab Self-Managedインスタンスでは、これを行った後でも、インスタンス管理者が\[[メールを送信できる](../../administration/email_from_gitlab.md)]場合があります。

## 通知メールの配信登録を解除する

リソース単位（たとえば、特定のイシュー）で GitLab からの通知メールの配信登録を解除できます。

### 配信登録解除リンクを使用する

GitLab からのすべての通知メールの下部に、配信登録解除リンクが含まれています。

配信登録を解除するには:

1. メールの配信登録解除リンクを選択します。
1. ブラウザで GitLab にサインインしている場合は、すぐに配信登録が解除されます。
1. サインインしていない場合は、アクションを確認する必要があります。

### メールクライアントまたはその他のソフトウェアを使用する

メールクライアントは、GitLab からのメールを表示するときに\[**配信停止**]\*\*ボタンを表示する場合があります。配信登録を解除するには、このボタンを選択します。

GitLab からの通知メールには、特別なヘッダーが含まれています。これらのヘッダーを使用すると、サポートされているメールクライアントおよびその他のソフトウェアがユーザーの配信登録を自動的に解除できます。次に例を示します:

```plaintext
List-Unsubscribe: <https://gitlab.com/-/sent_notifications/[REDACTED]/unsubscribe>,<mailto:incoming+[REDACTED]-unsubscribe@incoming.gitlab.com>
List-Unsubscribe-Post: List-Unsubscribe=One-Click
```

`List-Unsubscribe`ヘッダーには 2 つのエントリがあり:

- ソフトウェアが `POST`リクエストを送信するためのリンク。このアクションは、ユーザーのリソースからの配信登録を直接解除します。このリンクに `GET`リクエストを送信すると、配信登録を解除する代わりに確認ダイアログが表示されます。
- ソフトウェアが配信登録解除メールを送信するためのメールアドレス。メールの内容は無視されます。

## メールのフィルタリングに使用できるメールヘッダー

通知メールメッセージには、GitLab 固有のヘッダーが含まれます。通知をより適切に管理するために、これらのヘッダーの内容に基づいて通知メールをフィルタリングできます。

たとえば、マージリクエストまたはイシューが割り当てられている特定のプロジェクトからのすべてのメールをフィルタリングできます。

次の表に、GitLab 固有のすべてのメールヘッダーを示します。

| ヘッダー                        | 説明 |
|-------------------------------|-------------|
| `List-Id`                     | RFC 2919 メーリングリスト識別子のプロジェクトのパス。フィルターを使用して組織のメールを整理するために使用できます。 |
| `X-GitLab-(Resource)-ID`      | 通知の対象となるリソースの ID。リソースは、たとえば、 `Issue`、`MergeRequest`、`Commit`、またはその他のこのようなリソースにすることができます。 |
| `X-GitLab-(Resource)-State`   | 通知の対象となるリソースの状態。リソースは、たとえば、`Issue`または`MergeRequest`にすることができます。値は、`opened`、`closed`、`merged`、または`locked`にすることができます。GitLab 16.4 で[導入されました](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/130967)。 |
| `X-GitLab-ConfidentialIssue`  | 通知に関するイシューの機密性を示すブール値。GitLab 16.0 で\[[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/222908)]されました。 |
| `X-GitLab-Discussion-ID`      | コメントの通知メールで、コメントが属するスレッドの ID。 |
| `X-GitLab-Group-Id`           | グループの ID。\[[エピック](../group/epics/_index.md)]の通知メールにのみ存在します。 |
| `X-GitLab-Group-Path`         | グループのパス。\[[エピック](../group/epics/_index.md)]の通知メールにのみ存在します。 |
| `X-GitLab-NotificationReason` | 通知の理由。\[[可能な値を参照](#x-gitlab-notificationreason)]。 |
| `X-GitLab-Pipeline-Id`        | パイプラインの通知メールで、通知の対象となるパイプラインの ID。 |
| `X-GitLab-Project-Id`         | プロジェクトの ID。 |
| `X-GitLab-Project-Path`       | プロジェクトのパス。 |
| `X-GitLab-Project`            | 通知が属するプロジェクトの名前。 |
| `X-GitLab-Reply-Key`          | メールによる返信をサポートする一意のトークン。 |

### X-GitLab-NotificationReason

`X-GitLab-NotificationReason`ヘッダーには、通知の理由が含まれています。値は次のいずれかであり、優先順位順に並べられています。

- `own_activity`
- `assigned`
- `review_requested`
- `mentioned`
- `subscribed`

通知の理由は、通知メールのフッターにも含まれています。たとえば、理由が`assigned`のメールには、フッターに次の文が含まれています。

> あなたが<Configure済みのGitLabホスト名> に項目を割り当てられたため、このメールを受信しています。

#### オンコールアラート通知

{{< details >}}

- プラン:Premium、Ultimate
- 提供:GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

\[[オンコールアラート](../../operations/incident_management/oncall_schedules.md)]通知メールには、\[[アラート](../../operations/incident_management/alerts.md)]の次のいずれかの状態が含まれています:

- `alert_triggered`
- `alert_acknowledged`
- `alert_resolved`
- `alert_ignored`

#### インシデントエスカレーション通知

{{< details >}}

- プラン:Premium、Ultimate
- 提供:GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

\[[インシデントエスカレーション](../../operations/incident_management/escalation_policies.md)]通知メールには、\[[インシデント](../../operations/incident_management/incidents.md)]の次のいずれかの状態が含まれています。

- `incident_triggered`
- `incident_acknowledged`
- `incident_resolved`
- `incident_ignored`

`X-GitLab-NotificationReason`ヘッダーに含めるイベントのリストを拡張することは、[[イシュー 20689](https://gitlab.com/gitlab-org/gitlab/-/issues/20689)]で追跡されています。

## トラブルシューティング

### 通知の受信者のリストをプルする

プロジェクトから通知を受信する受信者のリストをプルする場合は（主にカスタム通知のトラブルシューティングに使用）、Rails コンソールで `sudo gitlab-rails c`を実行し、プロジェクト名を必ず更新してください:

```plaintext
project = Project.find_by_full_path '<project_name>'
merge_request = project.merge_requests.find_by(iid: 1)
current_user = User.first
recipients = NotificationRecipients::BuildService.build_recipients(merge_request, current_user, action: "push_to"); recipients.count
recipients.each { |notify| puts notify.user.username }
```

### 存在しない失敗したパイプラインに関する通知

存在しなくなった失敗したパイプラインに関する通知（メールまたは Slack 経由）を受信する場合は、メッセージをトリガーした可能性のある重複した GitLab インスタンスがないか再確認してください。

### メール通知は有効になっているが、受信されない

GitLab でメール通知を有効にしたのに、ユーザーが予期どおりに通知を受信しない場合は、メールプロバイダーが GitLab インスタンスからのメールをブロックしていないことを確認してください。多くのメールプロバイダー（Outlook など）は、あまり知られていない Self-Managed メールサーバーの IP アドレスからのメールをブロックします。確認するには、インスタンスの SMTP サーバーから直接メールを送信してみてください。たとえば、Sendmail からの Test メールは次のようになります。

```plaintext
# (echo subject: test; echo) | $(which sendmail) -v -Am -i <valid email address>
```

メールプロバイダーがメッセージをブロックしている場合は、次のような出力が表示される場合があります（メールプロバイダーと SMTP サーバーによって異なります）。

```plaintext
Diagnostic-Code: smtp; 550 5.7.1 Unfortunately, messages from [xx.xx.xx.xx]
weren't sent. For more information, please go to
http://go.microsoft.com/fwlink/?LinkID=526655 (http://go.microsoft.com/fwlink/?LinkID=526655) AS(900)
```

通常、このイシューは、SMTP サーバーの IP アドレスをメールプロバイダーの許可リストに追加することで解決できます。手順については、メールプロバイダーのドキュメントを確認してください。
