---
stage: Software Supply Chain Security
group: Authentication
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: ユーザーアカウント
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

各GitLabアカウントには、ユーザープロファイルがあり、ユーザー自身とユーザーのGitLabアクティビティーに関する情報が含まれています。

プロファイルには設定も含まれており、これを使用してGitLabのエクスペリエンスをカスタマイズできます。

## ユーザープロファイルにアクセスする

プロファイルにアクセスするには:

1. 左側のサイドバーで、アバターを選択します。
1. 自分の名前またはユーザー名を選択します。

## ユーザー設定にアクセスする

ユーザー設定にアクセスするには:

1. 左側のサイドバーで、アバターを選択します。
1. **プロファイルを編集**を選択します。

## サポートPINを生成または変更する

GitLabサポートは、ユーザーの身元を確認するために、個人識別番号（PIN）を求める場合があります。PINは作成後7日で有効期限切れになります。

新しいサポートPINを生成するには:

1. 左側のサイドバーで、アバターを選択します。
1. **プロファイルを編集**を選択します。
1. 左側のサイドバーで、**アカウント**を選択します。
1. **新しいPINを生成する**を選択します。

## サポートPINにアクセスする

以前にサポートPINを作成した場合、PINはユーザープロファイルからアクセスでき、作成後7日で有効期限切れになります。

サポートPINにアクセスするには:

1. 左側のサイドバーで、アバターを選択します。
1. **プロファイルを編集**を選択します。
1. 左側のサイドバーで、**アカウント**を選択します。

## ユーザー名を変更する

ユーザー名には一意の[ネームスペース](../namespace/_index.md)があり、ユーザー名を変更すると更新されます。ユーザー名を変更する前に、[リダイレクトが動作する仕組み](../project/repository/_index.md#repository-path-changes)を参照してください。ネームスペースを更新したくない場合は、新しいユーザーまたはグループを作成し、代わりにプロジェクトをそこに転送できます。

前提要件:

- ネームスペースは次の条件を満たしている必要があります。
  - [コンテナレジストリ](../packages/container_registry/_index.md)タグ付きのプロジェクトを含まないこと。
  - [GitLab Pages](../project/pages/_index.md)をホストするプロジェクトがないこと。詳細については、[GitLabチームハンドブックのユーザー名の変更](https://handbook.gitlab.com/handbook/tools-and-tips/#change-your-username-at-gitlabcom)を参照してください。
- ユーザー名:
  - 2～255文字である必要があります。
  - アクセント記号なしの文字、数字、`_`、`-`、`.`のみを含める必要があります。
  - 次の条件を満たしている必要があります。
    - `_`、`-`、または`.`で開始しないこと。
    - 絵文字を含まないこと。
    - `.`または`.<reserved file extension>`で終わらないこと（例: `jon.png`、`jon.git`、`jon.atom`）。ただし、`jonpng`は有効です。

ユーザー名を変更するには:

1. 左側のサイドバーで、アバターを選択します。
1. **プロファイルを編集**を選択します。
1. 左側のサイドバーで、**アカウント**を選択します。
1. **ユーザー名を変更**セクションで、パスとして新しいユーザー名を入力します。
1. **ユーザー名を更新**を選択します。

## メールをユーザープロファイルに追加する

新しいメールアドレスをアカウントに追加するには:

1. 左側のサイドバーで、アバターを選択します。
1. **プロファイルを編集**を選択します。
1. 左側のサイドバーで、**メール**を選択します。
1. **新しいメールアドレスを追加**を選択します。
1. **メール**テキストボックスに、新しいメールアドレスを入力します。
1. **メールアドレスを追加**を選択します。
1. 受信した確認メールでメールアドレスを確認します。

新しいメールアドレスは、セカンダリメールアドレスとして追加されます。セカンダリメールアドレスは、パスワードのリセットに使用できますが、認証には使用できません。[プライマリメールアドレス](#change-your-primary-email)を更新できます。

{{< alert type="note" >}}

[メールを非公開にする](#set-your-public-email)と、コミットのマッチング、[プロジェクトのインポート](../project/import/_index.md)、[グループの移行](../group/import/_index.md)に使用できなくなります。

{{< /alert >}}

## ユーザープロファイルからメールアドレスを削除する

{{< history >}}

- GitLab 17.0で、未確認のセカンダリメールアドレスの自動削除が[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/151562)されました。

{{< /history >}}

セカンダリメールアドレスをアカウントから削除できます。プライマリメールアドレスは削除できません。

削除されたメールアドレスがいずれかのユーザーメールに使用されている場合、それらのユーザーメールは代わりにプライマリメールアドレスに送信されます。

未確認のセカンダリメールアドレスは、3日後に自動的に削除されます。

{{< alert type="note" >}}

[イシュー438600](https://gitlab.com/gitlab-org/gitlab/-/issues/438600)により、グループ通知は削除されたメールアドレスに引き続き送信されます。

{{< /alert >}}

アカウントからメールアドレスを削除するには:

1. 左側のサイドバーで、アバターを選択します。
1. **プロファイルを編集**を選択します。
1. 左側のサイドバーで、**メール**を選択します。
1. **削除**（{{< icon name="remove" >}}）を選択し、**削除**することを確認します。

[APIを使用してセカンダリメールアドレスを削除](../../api/user_email_addresses.md#delete-an-email-address)することもできます。

## ユーザープロファイルページを非公開にする

ユーザープロファイルを自分とGitLab管理者にのみ表示するようにできます。

{{< alert type="note" >}}

GitLab管理者は、この設定を[無効](../../administration/settings/account_and_limit_settings.md#prevent-users-from-making-their-profiles-private)にして、すべてのプロファイルを強制的に公開できます。

{{< /alert >}}

プロファイルを非公開にするには:

1. 左側のサイドバーで、アバターを選択します。
1. **プロファイルを編集**を選択します。
1. **プライベートプロファイル**チェックボックスをオンにします。
1. **プロファイル設定を更新**を選択します。

以下はユーザープロファイルページ（`https://gitlab.example.com/username`）に表示されません。

- Atomフィード
- アカウントの作成日
- アクティビティー、グループ、コントリビュートしたプロジェクト、パーソナルプロジェクト、お気に入りプロジェクト、スニペットのタブ

{{< alert type="note" >}}

ユーザープロファイルページを非公開にしても、RESTまたはGraphQL APIからすべての公開リソースが非表示になるわけではありません。たとえば、[自動生成されたプライベートコミットメールを使用](#use-an-automatically-generated-private-commit-email)しない限り、コミット署名に関連付けられているメールアドレスにアクセスできます。

{{< /alert >}}

### ユーザーの表示レベル

`/username`にあるユーザーの公開ページは、サインインしているかどうかに関係なく、常に表示されます。

ユーザーの公開ページにアクセスすると、権限のあるプロジェクトのみが表示されます。

[公開レベルが制限されている](../../administration/settings/visibility_and_access_controls.md#restrict-visibility-levels)場合、ユーザープロファイルは認証済みユーザーにのみ表示されます。

## READMEでプロファイルに詳細を追加する

READMEファイルを使用して、プロファイルページに詳細情報を追加できます。READMEファイルに情報を入力すると、その情報がプロファイルページに表示されます。

### 新規プロジェクトから

新しいプロジェクトを作成し、そのREADMEをプロファイルに追加するには:

1. 左側のサイドバーの上部で、**新規作成**（{{< icon name="plus" >}}）を選択し、**新しいプロジェクト/リポジトリ**を選択します。
1. **空のプロジェクトの作成**を選択します。
1. プロジェクトの詳細を入力します。
   - **プロジェクト名**フィールドに、新しいプロジェクトの名前を入力します。
   - **プロジェクトURL**フィールドで、自分のGitLabユーザー名を選択します。
   - **プロジェクトslug**フィールドに、自分のGitLabユーザー名を入力します。これらのフィールドはすべて大文字と小文字が区別されます。ユーザー名に大文字が含まれている場合は、大文字を含めてプロジェクトslugフィールドに入力します。
1. **表示レベル**で、**公開**を選択します。![ホストされた製品の個人プロジェクトの適切なパス](img/personal_readme_setup_v14_5.png)
1. **プロジェクトの設定**で、**リポジトリを初期化しREADMEファイルを生成する**が選択されていることを確認します。
1. **プロジェクトを作成**を選択します。
1. このプロジェクト内にREADMEファイルを作成します。ファイルは、有効な[READMEファイルまたはインデックスファイル](../project/repository/files/_index.md#readme-and-index-files)にすることができます。
1. READMEファイルに[Markdown](../markdown.md)またはその他の[サポートされているマークアップ言語](../project/repository/files/_index.md#supported-markup-languages)を入力します。

GitLabは、コントリビューショングラフの下にREADMEの内容を表示します。

### 既存のプロジェクトから

既存のプロジェクトからREADMEをプロファイルに追加するには、プロジェクトの[パスを更新](../project/working_with_projects.md#rename-a-repository)して、ユーザー名と一致するようにします。

## 外部アカウントをユーザープロファイルページに追加する

{{< history >}}

- GitLab 16.6で、`mastodon_social_ui`という名前の[フラグとともに](../feature_flags.md)Mastodonユーザーアカウントが[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/132892)されました。デフォルトでは無効になっています。
- GitLab 16.7で、Mastodonユーザーアカウントが[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/428163)になりました。機能フラグ`mastodon_social_ui`が削除されました。
- GitLab 17.4で、`verify_mastodon_user`という名前の[フラグとともに](../feature_flags.md)、GitLabユーザープロファイルを使用してMastodonアカウントを確認する機能が[追加](https://gitlab.com/gitlab-org/gitlab/-/issues/433391)されました。デフォルトでは無効になっています。

{{< /history >}}

SkypeやX（旧Twitter）など、他の特定の外部アカウントへのリンクを追加できます。他のユーザーが他のプラットフォームであなたとつながるのに役立ちます。

他のアカウントへのリンクを追加するには:

1. 左側のサイドバーで、アバターを選択します。
1. **プロファイルを編集**を選択します。
1. **主要設定**セクションで、以下を追加します。
   - Discordの[ユーザーID](https://support.discord.com/hc/en-us/articles/206346498-Where-can-I-find-my-User-Server-Message-ID-)。
   - LinkedInのプロフィール名。
   - Blueskyの[did:plc識別子](https://atproto.com/specs/did)。識別子を検索するには、[ユーザーハンドルを解決](https://bsky.social/xrpc/com.atproto.identity.resolveHandle?handle=USER_HANDLE)します。
   - Mastodonハンドル。GitLab 17.4以降では、[GitLabプロファイル](#access-your-user-profile)を使用してMastodonアカウントを確認できます。
   - Skypeのユーザー名。
   - X（旧Twitter）の@ユーザー名。

   ユーザーIDまたはユーザー名は500文字以下である必要があります。
1. **プロファイル設定を更新**を選択します。

## ユーザープロファイルページにプライベートコントリビュートを表示する

ユーザーコントリビュートカレンダーグラフと最近のアクティビティーリストでは、プライベートプロジェクトに対する[コントリビュートアクション](contributions_calendar.md#user-contribution-events)を確認できます。

プライベートコントリビュートを表示するには:

1. 左側のサイドバーで、アバターを選択します。
1. **プロファイルを編集**を選択します。
1. **主要設定**セクションで、**プロファイルにプライベートコントリビュートを含める**チェックボックスをオンにします。
1. **プロファイル設定を更新**を選択します。

## ジェンダー代名詞を追加する

GitLabアカウントにジェンダー代名詞を追加して、プロファイルの名前の横に表示できます。

ジェンダー代名詞を指定するには:

1. 左側のサイドバーで、アバターを選択します。
1. **プロファイルを編集**を選択します。
1. **ジェンダー代名詞**テキストボックスに、自分のジェンダー代名詞を入力します。テキストは50文字以下である必要があります。
1. **プロファイル設定を更新**を選択します。

## 名前の発音を追加する

GitLabアカウントに名前の発音を追加できます。これは、プロファイルの名前の下に表示されます。

名前の発音を追加するには:

1. 左側のサイドバーで、アバターを選択します。
1. **プロファイルを編集**を選択します。
1. **発音**テキストボックスに、名前の発音方法を入力します。発音は、プレーンテキストで255文字以下である必要があります。
1. **プロファイル設定を更新**を選択します。

## ステータスを設定する

ステータスを設定して、他のユーザーに自分の状況を知らせます。他のユーザーは、アバター、名前、またはユーザー名にカーソルをおくと、ステータスを確認できます。[ユーザープロファイルページを非公開](#make-your-user-profile-page-private)にした場合でも、ステータスは公開されます。

ステータスは、以下の要素で構成されています。それぞれを個別に使用して、ステータスを示すことができます。

- ステータスを示す絵文字。
- 空き状況を説明するメッセージ。`:palm_tree:`や`:bulb:`のような絵文字コードを含めることができます。最大100文字。
- `Busy`バッジをステータスに追加するチェックボックス。

現在のステータスを設定するには:

1. 左側のサイドバーで、アバターを選択します。
1. **ステータスの設定**を選択します。以前にステータスを設定した場合は、代わりに**状態を編集**を選択します。
1. オプション: ステータスメッセージを入力します。
1. オプション: **ビジーに設定する**チェックボックスをオンにします。
1. オプション: **次の期間でステータスを初期化する**ドロップダウンリストから値を選択します。
1. **ステータスの設定**を選択します。

ステータスが更新されます。[ユーザー設定](#access-your-user-settings)ページまたは[ユーザーAPI](../../api/users.md#set-your-user-status)からステータスを設定することもできます。

## タイムゾーンを設定する

ローカルタイムゾーンを設定すると、次のことができます。

- プロファイルや、名前の上にカーソルをおくと情報が表示される場所に、自分のローカル時間を表示できます。
- コントリビュートカレンダーをローカル時間に合わせ、コントリビュートした時間をより正確に反映できます。

タイムゾーンを設定するには:

1. 左側のサイドバーで、アバターを選択します。
1. **プロファイルを編集**を選択します。
1. **タイムゾーンの設定**セクションで、ドロップダウンリストからタイムゾーンを選択します。

## コミットに表示されるメールアドレスを変更する

コミットメールとは、GitLabインターフェースを通じて実行されるすべてのGit関連アクションに表示されるメールアドレスです。

自分で確認したメールアドレスはすべて、コミットメールとして使用できます。デフォルトでは、プライマリメールが使用されます。

コミットメールを変更するには:

1. 左側のサイドバーで、アバターを選択します。
1. **プロファイルを編集**を選択します。
1. **コミットメール**ドロップダウンリストで、メールアドレスを選択します。
1. **プロファイル設定を更新**を選択します。

## プライマリメールアドレスを変更する

プライマリメールは、ログイン、コミットメール、通知メールのデフォルトメールアドレスです。

プライマリメールを変更するには:

1. 左側のサイドバーで、アバターを選択します。
1. **プロファイルを編集**を選択します。
1. **メール**フィールドに、新しいメールアドレスを入力します。
1. **プロファイル設定を更新**を選択します。
1. オプション: 以前にこのメールをGitLab.comアカウントに追加していない場合は、確認メールを選択します。

## 公開メールを設定する

公開プロファイルに表示する[設定済みのメールアドレス](#add-emails-to-your-user-profile)を1つ選択できます。

1. 左側のサイドバーで、アバターを選択します。
1. **プロファイルを編集**を選択します。
1. **公開メール**フィールドで、利用可能なメールアドレスを1つ選択します。
1. **プロファイル設定を更新**を選択します。

### 自動生成されたプライベートコミットメールを使用する

GitLabは、自動生成されたプライベートコミットメールアドレスを提供するため、メール情報を非公開にすることができます。

プライベートコミットメールを使用するには:

1. 左側のサイドバーで、アバターを選択します。
1. **プロファイルを編集**を選択します。
1. **コミットメール**ドロップダウンリストで、**プライベートメールを使用する**を選択します。
1. **プロファイル設定を更新**を選択します。

すべてのGit関連のアクションは、プライベートコミットメールを使用します。

完全に匿名性を保つために、次のコマンドを実行して、プライベートコミットメールをコピーし、ローカルマシンで設定することもできます。

```shell
git config --global user.email <your email address>
```

## ユーザーをフォローする

次のいずれかから、ユーザーをフォローまたはフォロー解除できます。

- 自分の[ユーザープロファイル](#access-your-user-profile)
- ユーザー名にカーソルをおくと表示される小さなポップオーバー（GitLab 15.0で[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/76050)）

[GitLab 15.5以降](https://gitlab.com/gitlab-org/gitlab/-/issues/360755)では、フォローできるユーザーの最大数は300人です。

[GitLab 16.10以降](https://gitlab.com/gitlab-org/gitlab/-/issues/441774)では、ブロックされたユーザーはユーザープロファイルのフォロワーリストに表示されません。

### 他のユーザーのフォローと他のユーザーからのフォローを無効にする

{{< history >}}

- GitLab 16.0で、`disable_follow_users`という名前の[フラグとともに](../feature_flags.md)[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/325558)されました。
- GitLab 16.3で、[機能フラグが削除](https://gitlab.com/gitlab-org/gitlab/-/issues/420620)されました。

{{< /history >}}

他のユーザーのフォローと他のユーザーからのフォローを無効にできます。

1. 左側のサイドバーで、アバターを選択します。
1. **プロファイルを編集**を選択します。
1. **設定**を選択します。
1. **ユーザーのフォローを有効にする**チェックボックスをオフにします。
1. **変更の保存**を選択します。

{{< alert type="note" >}}

この機能を無効にすると、現在フォローしている/フォローされているすべての接続が削除されます。

{{< /alert >}}

## ユーザーのアクティビティーを表示する

GitLabは、[ユーザーのコントリビュートアクティビティー](contributions_calendar.md)を追跡します。ユーザーのアクティビティーを表示するには:

1. ユーザーのプロフィールに移動します。
1. GitLabメニューで、**アクティビティー**を選択します。

**最新のアクティビティー**コントリビュートのリストが表示されます。

## 自分のアクティビティーを表示する

自分のアクティビティーを表示するには:

1. 左側のサイドバーで、**検索または移動**を選択します。
1. **あなたの作業**を選択します。
1. **アクティビティー**を選択します。
1. オプション: コントリビュートの種類でアクティビティーをフィルタリングするには、**あなたのアクティビティー**タブで、次のタブを選択します。

   - **すべて**: グループとプロジェクトで行ったすべてのコントリビュート。
   - **プッシュイベント**: プロジェクトで行ったプッシュイベント。
   - **マージイベント**: プロジェクトで承認したマージリクエスト。
   - **イシューイベント**: プロジェクトでオープンおよびクローズしたイシュー。
   - **コメント**: プロジェクトに投稿したコメント。
   - **Wiki**: プロジェクトで作成および更新したWikiページ。
   - **デザイン**: プロジェクトで追加、更新、および削除したデザイン。
   - **チーム**: 参加および離脱したプロジェクト。

## サービスにサインインする

GitLabにサインインするために、通常のユーザー名とパスワードを使用する代わりに、サインインサービスを使用できます。

### サインインサービスを接続する

GitLabへのサインインに使用するサインインサービスを接続するには:

1. 左側のサイドバーで、アバターを選択します。
1. **プロファイルを編集**を選択します。
1. **アカウント**を選択します。
1. **サインインに利用するサービス**セクションを探します。
1. **接続したアカウント**セクションで、サインインするサービスに対応するボタンを選択します。
1. 選択したサービスの手順に従って、サインインを開始します。

### サインインサービスを切断する

GitLabへのサインインに使用されるサインインサービスを切断するには:

1. 左側のサイドバーで、アバターを選択します。
1. **プロファイルを編集**を選択します。
1. **アカウント**を選択します。
1. **サインインに利用するサービス**セクションを探します。
1. **接続したアカウント**セクションで、サインインしたくないサービスに対応するボタンの横にある**切断**を選択します。

## セッションの継続時間

### 2週間サインインしたままにする

デフォルトでは、GitLabからサインアウトするのは、無効な状態が7日間（10080分）続いた後か、ブラウザウィンドウを閉じるかのいずれか早い方です。

GitLab管理者は[このデフォルトを変更](../../administration/settings/account_and_limit_settings.md#customize-the-default-session-duration)できます。

### 無期限にサインインしたままにする

{{< history >}}

- GitLab 16.0で、**ログイン情報を記憶する**設定をオン/オフにする機能が[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/369133)されました。

{{< /history >}}

無期限にサインインしたままにするには、GitLabサインインページの**ログイン情報を記憶する**チェックボックスをオンにします。

サーバーがセッション時間を1週間に設定していても、ブラウザが自動再認証を可能にするセキュアトークンを保存するため、サインインしたままになります。

セキュリティまたはコンプライアンスの目的でセッションを定期的に期限切れにする必要がある環境では、GitLab管理者が[**ログイン情報を記憶する**設定をオフにする](../../administration/settings/account_and_limit_settings.md#session-duration)ことができます。

### サインインに使用されるCookie

サインインすると、次の3つのCookieが設定されます。

- `_gitlab_session`というセッションCookie: このCookieには、設定された有効期限はありません。ただし、`session_expire_delay`に基づいて有効期限切れになります。
- `gitlab_user`というセッションCookie: このCookieは、ユーザーにアクティブなGitLabセッションがあるかどうかを判断するために、[マーケティングサイト](https://about.gitlab.com/)で使用されます。ユーザー情報はCookieに渡されず、ログインから2週間後に有効期限切れになります。
- `remember_user_token`という永続Cookie: これは、サインインページで**ログイン情報を記憶する**を選択した場合にのみ設定されます。

ブラウザを閉じると、通常、`_gitlab_session`および`gitlab_user` Cookieはクライアント側でクリアされます。有効期限切れになったり利用できなくなったりすると、GitLabは次のようになります。

- `remember_user_token` Cookieを使用して新しい`_gitlab_session` Cookieを取得し、ブラウザを閉じてもサインインしたままにします。
- `gitlab_user`を`true`に設定します。

`remember_user_token`と`_gitlab_session` Cookieの両方がなくなったか、有効期限切れになると、再度サインインする必要があります。

{{< alert type="note" >}}

セッションがサインアウトされた場合、または[アクティブなセッションリスト](active_sessions.md)からセッションが取り消された場合、すべての**ログイン情報を記憶する**トークンが取り消されます。他のセッションがアクティブなまま、ブラウザが閉じられたり、既存のセッションが有効期限切れになったりすると、**ログイン情報を記憶する**機能でセッションは復元されません。

{{< /alert >}}

## 関連トピック

- [ユーザーを作成する](account/create_accounts.md)
- [GitLabアカウントにサインインする](../../administration/auth/_index.md)
- [パスワードを変更する](user_passwords.md)
- 次のメールを受信します。
  - [不明なIPアドレスまたはデバイスからのサインイン](notifications.md#notifications-for-unknown-sign-ins)
  - [不正確な確認コードを使用したサインインの試行](notifications.md#notifications-for-attempted-sign-ins-using-incorrect-verification-codes)
- [GitLabをOAuthプロバイダーとして使用](../../integration/oauth_provider.md)できるアプリケーションを管理する
- APIおよび承認されたアプリケーションを介してアカウントにアクセスするための[パーソナルアクセストークン](personal_access_tokens.md)を管理する
- SSHを使用してアカウントにアクセスするための[SSH鍵](../ssh.md)を管理する
- [ハイライトした構文のテーマを変更する](preferences.md#change-the-syntax-highlighting-theme)
- [アクティブなセッションを表示](active_sessions.md)して必要に応じていずれかを取り消す
