---
stage: Plan
group: Product Planning
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: エピックを管理する
---

{{< details >}}

- プラン: Premium、Ultimate
- 製品: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

このページでは、[エピック](_index.md)に関して、またはエピックに関連して実行できるすべての操作について説明します。

## エピックを作成する

{{< history >}}

- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

前提要件:

- エピックのグループに対してプランナーロール以上を持っている必要があります。

所属するグループにエピックを作成するには:

1. 新しいエピックフォームに移動します。
   - グループに移動し、左側のサイドバーから**エピック**を選択します。次に、**新しいエピック**を選択します。
   - グループ内のエピックから、**Epicアクション**（{{< icon name="ellipsis_v" >}}）を選択します。次に、**新しいエピック**を選択します。
   - 任意の場所で、上部のメニューの**新規**（{{< icon name="plus-square" >}}）を選択します。次に、**新しいエピック**を選択します。
   - 空の[ロードマップ](../roadmap/_index.md)で、**新しいエピック**を選択します。

1. タイトルを入力します。
1. フィールドに入力します。
   - 説明を入力します。
   - [エピックを非公開にする](#make-an-epic-confidential)には、**公開設定**の下のチェックボックスをオンにします。
   - ラベルを選択します。
   - 開始日と期限を選択するか、開始日と期限を[継承](#start-and-due-date-inheritance)します。
   - [色](#epic-color)を選択します。
1. **エピックを作成**を選択します。

新しく作成されたエピックが開きます。

### 開始日と期限の継承

**継承済み**を選択した場合:

- **開始日**の場合:GitLabは、エピックに割り当てられたすべての子エピックとイシューをスキャンし、子エピックまたはイシューに割り当てられたマイルストーンで見つかった最も早い開始日と一致するように開始日を設定します。
- **期限**の場合:GitLabは、エピックに割り当てられたすべての子エピックとイシューをスキャンし、子エピックまたはイシューに割り当てられたマイルストーンで見つかった最も遅い期限と一致するように期限を設定します。

これらの日付は動的であり、次のいずれかが発生した場合は再計算されます。

- 子エピックの日付が変更される。
- マイルストーンがイシューに再割り当てされる。
- マイルストーンの日付が変更される。
- イシューがエピックに追加またはエピックから削除される。

エピックの日付は子から日付を継承できるため、開始日と期限は下から上に伝播します。最下位の子エピックの開始日が変更された場合、それが親エピックの最も早い開始日の候補になります。次に、親エピックの開始日はこの変更を反映し、最上位のエピックに上方伝播します。

## エピックを編集する

{{< history >}}

- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

エピックを作成した後、次の詳細を編集できます。

- タイトル
- 説明
- 開始日
- 期限
- ラベル
- [色](#epic-color)

前提要件:

- エピックのグループに対してプランナーロール以上を持っている必要があります。

エピックのタイトルまたは説明を編集するには:

1. **編集**を選択します。
1. 変更を加えます。
1. **変更を保存**を選択します。

エピックの開始日、期限、またはラベルを編集するには:

1. 右側のサイドバーの各セクションの横にある**編集**を選択します。
1. エピックの日付またはラベルを選択します。

### エピックの説明にあるリスト項目を並べ替える

{{< history >}}

- GitLab 15.1で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/15260)されました。
- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

説明にリストがあるエピックを表示するときに、リスト項目を並べ替えることもできます。

前提要件:

- プロジェクトのプランナーロール以上を持っているか、エピックの作成者であるか、エピックの担当者である必要があります。
- エピックの説明には、[順序付き、順序なし](../../markdown.md#lists)、または[タスク](../../markdown.md#task-lists)リストが必要です。

エピックを表示するときにリスト項目を並べ替えるには:

1. リスト項目の行にカーソルをおき、グリップアイコン（{{< icon name="grip" >}}）を表示します。
1. グリップアイコンを選択して保持します。
1. 行をリストの新しい位置にドラッグします。
1. グリップアイコンをリリースします。

### エピックを一括で編集する

{{< history >}}

- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

プランナーロール以上を持っているユーザーは、エピックを管理できます。

グループ内のエピックを一括編集するときに、そのエピックのラベルを編集できます。

前提要件:

- 親エピックのグループに対してプランナーロール以上を持っている必要があります。

複数のエピックを同時に更新するには:

1. グループで、**エピック > リスト**に移動します。
1. **一括編集**を選択します。右側に編集可能なフィールドを含むサイドバーが表示されます。
1. 編集する各エピックの横にあるチェックボックスをオンにします。
1. サイドバーから適切なフィールドと値を選択します。
1. **選択済みアイテムを更新する**を選択します。

### drawerでエピックを開く

{{< details >}}

- 製品: GitLab Self-Managed

{{< /details >}}

{{< history >}}

- GitLab 17.4で`issues_list_drawer`[フラグ](../../../administration/feature_flags.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/464063)されました。デフォルトでは無効になっています。
- 機能フラグは、GitLab 17.6で`issues_list_drawer`から`epics_list_drawer`に[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170066)されました。

{{< /history >}}

{{< alert type="flag" >}}

この機能の利用可否は、機能フラグによって制御されます。詳細については、履歴を参照してください。この機能はテストには使用できますが、本番環境での使用には対応していません。

{{< /alert >}}

この機能が有効になっている場合、リストまたはエピックボードからエピックを選択すると、drawerで開きます。その後、エピックを編集したり、コメントを作成したりできます。

エピックをフルビューで開くには、次のいずれかを実行します。

- 新しいタブでエピックを開きます。エピックのリストから、次のいずれかを実行できます。
  - エピックを右クリックして、新しいブラウザタブで開きます。
  - <kbd>Cmd</kbd>キーまたは<kbd>Ctrl</kbd>キーを押しながら、エピックを選択します。
- drawerの左上隅で、**フルビューで開く**を選択します。

![drawerで開いたエピック。](img/epic_drawer_v17_4.png)

## 「続きを読む」で説明が切り詰められるのを防ぐ

{{< history >}}

- GitLab 17.10で[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181184)されました。

{{< /history >}}

<!-- When epics as work items are GA and feature flag `work_item_epics` is removed, remove the prerequisite below. -->

エピックの説明が長い場合、GitLabはその一部のみを表示します。説明全体を表示するには、**続きを読む**を選択する必要があります。この切り捨てにより、長文をスクロールせずに、ページ上の他の要素を簡単に見つけることができます。

前提要件:

- [エピックの新しい外観](epic_work_items.md)を有効にする必要があります。

説明を切り詰めるかどうかを変更するには:

1. エピックの右上隅にある**その他のアクション**（{{< icon name="ellipsis_v" >}}）を選択します。
1. 好みに応じて**説明を切り詰める**を切り替えます。

この設定は記憶され、すべてのイシュー、タスク、エピック、目標、および主な成果に影響します。

## 右側のサイドバーを非表示にする

{{< history >}}

- GitLab 17.10で[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181184)されました。

{{< /history >}}

<!-- When epics as work items are GA and feature flag `work_item_epics` is removed, remove the prerequisite below. -->

スペースがある場合、エピックの属性は説明の右側のサイドバーに表示されます。

前提要件:

- [エピックの新しい外観](epic_work_items.md)を有効にする必要があります。

サイドバーを非表示にして、説明のスペースを増やすには:

1. エピックの右上隅にある**その他のアクション**（{{< icon name="ellipsis_v" >}}）を選択します。
1. **サイドバーを非表示にする**を選択します。

この設定は記憶され、すべてのイシュー、タスク、エピック、目標、および主な成果に影響します。

サイドバーを再度表示するには:

- 上記の手順を繰り返し、**サイドバーを表示する**を選択します。

## 担当者

{{< details >}}

- 状態: ベータ
- 製品: GitLab.com、GitLab Self-Managed

{{< /details >}}

{{< history >}}

- GitLab 17.4で`work_items_beta`[フラグ](../../../administration/feature_flags.md)とともに[導入](https://gitlab.com/groups/gitlab-org/-/epics/4231)されました。デフォルトでは無効になっています。この機能は[ベータ版](../../../policy/development_stages_support.md#beta)です。

{{< /history >}}

{{< alert type="flag" >}}

この機能の利用可否は、機能フラグによって制御されます。詳細については、履歴を参照してください。この機能はテストには使用できますが、本番環境での使用には対応していません。

{{< /alert >}}

[エピックの新しい外観](epic_work_items.md)が有効になっている場合、エピックを1人以上のユーザーに割り当てることができます。

担当者は必要に応じて何度でも変更できます。担当者はエピックの責任者であるという考え方です。

ユーザーがグループのメンバーでない場合、別のグループメンバーがエピックを割り当てる場合のみ、エピックをそのユーザーに割り当てることができます。

この機能は[ベータ版](../../../policy/development_stages_support.md)です。バグを見つけた場合は、[フィードバックイシュー](https://gitlab.com/gitlab-org/gitlab/-/issues/463598)を使用して詳細を提供してください。

### エピックの担当者を変更する

{{< history >}}

- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

前提要件:

- [エピックの新しい外観](epic_work_items.md)を有効にする必要があります。
- グループのプランナーロール以上を持っている必要があります。

エピックの担当者を変更するには:

1. 左側のサイドバーで、**検索または移動**を選択し、グループを見つけます。
1. **計画 > エピック**を選択し、エピックを選択して表示します。
1. 右側のサイドバーの**担当者**セクションで、**編集**を選択します。
1. ドロップダウンリストから、担当者として追加するユーザーを選択します。
1. ドロップダウンリストの外側の領域を選択します。

担当者は、ページを更新しなくても変更されます。

## エピックの色

{{< details >}}

- プラン: Premium、Ultimate

{{< /details >}}

{{< history >}}

- GitLab 14.9で[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/79940)されました。[フラグ](../../../administration/feature_flags.md)が`epic_color_highlight`という名前で付けられています。デフォルトでは無効になっています。
- GitLab 16.11で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/365336)になりました。機能フラグ`epic_color_highlight`は削除されました。
- カスタマイズ可能な色が、GitLab 17.5で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/394864)されました。

{{< /history >}}

エピックの色を設定して、タスクを視覚的に分類および優先順位付けできます。色を使用して以下を行います。

- エピックをチームまたは会社のイニシアチブに関連付ける。
- エピック階層のレベルを示す。
- 関連するエピックをグループにまとめる。

エピックの色は、[ロードマップ](../roadmap/_index.md)と[エピックボード](epic_boards.md)に表示されます。

ロードマップでは、タイムラインバーはエピックの色と一致します。

![ロードマップ上のエピックの色](img/epic_color_roadmap_v17_0.png)

エピックボードでは、色はエピックのカードアクセントに表示されます。

![エピックボード上のエピックの色](img/epic_accent_boards_v17_0.png)

### エピックの色を変更する

{{< history >}}

- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

前提要件:

- エピックのグループに対してプランナーロール以上を持っている必要があります。

エピックの色を変更するには:

1. 左側のサイドバーで、**検索または移動**を選択し、グループを見つけます。
1. **計画 > エピック**を選択します。
1. **新しいエピック**を選択するか、既存のエピックを選択します。
1. 右側のサイドバーの**色**セクションで、**編集**を選択します。
1. 既存の色を選択するか、RGBまたは16進数値を入力します。
1. ダイアログの外側の領域を選択します。

エピックの色が更新されます。

## エピックを削除する

{{< history >}}

- GitLab 16.11で[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/452189)されました。GitLab 16.10以前では、エピックを削除すると、そのすべての子エピックとその子孫も削除されます。必要に応じて、削除する前に、親エピックから[子エピックを削除](#remove-a-child-epic-from-a-parent-epic)できます。
- GitLab 17.7で、プランナーロールがエピックを削除[できるようになりました](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)。

{{< /history >}}

前提要件:

- エピックのグループに対してプランナーロールまたはオーナーロールを持っている必要があります。

エピックを削除するには:

1. **Epicアクション**（{{< icon name="ellipsis_v" >}}）を選択し、**エピックを削除**を選択します。
1. **削除**を選択します。確認ダイアログで、**エピックを削除**を選択します。

エピックを削除すると、システム内の関連付けられているエピックから既存のすべてのイシューが解放されます。

## エピックを閉じる

{{< history >}}

- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

前提要件:

- エピックのグループに対してプランナーロール以上を持っている必要があります。

エピックを閉じるには:

- 右上隅にある**Epicアクション**（{{< icon name="ellipsis_v" >}}）を選択し、**エピックを閉じる**を選択します。

`/close`[クイックアクション](../../project/quick_actions.md)を使用することもできます。

## 閉じたエピックを再開する

{{< history >}}

- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

閉じたエピックを再開することができます。

前提要件:

- エピックのグループに対してプランナーロール以上を持っている必要があります。

これを行うには、次のいずれかを実行します。

- 右上隅にある**Epicアクション**（{{< icon name="ellipsis_v" >}}）を選択し、**エピックを再開**を選択します。
- `/reopen`[クイックアクション](../../project/quick_actions.md)を使用します。

[イシューをプロモート](../../project/issues/managing_issues.md#promote-an-issue-to-an-epic)してエピックを作成することもできます。

## イシューからエピックに移動する

イシューがエピックに属している場合、右側のサイドバーのリンクを使用して親エピックに移動できます。

![含んでいるエピック](img/containing_epic_v10_3.png)

## エピックリストを表示する

グループでは、左側のサイドバーにオープンエピックの合計数が表示されます。この数字は、グループとそのサブグループに関連付けられているすべてのエピックを示します。これには、表示する権限がないエピックも含まれます。

前提要件:

- 次のいずれかのメンバーである必要があります。
  - グループ
  - グループ内のプロジェクト
  - グループのサブグループのいずれかのプロジェクト

グループ内のエピックを表示するには:

1. 左側のサイドバーで、**検索または移動**を選択し、グループを見つけます。
1. **計画 > エピック**を選択します。

### エピックを表示できるユーザー

{{< history >}}

- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

エピックを表示できるかどうかは、[グループの表示レベル](../../public_access.md)とエピックの[公開設定の状態](#make-an-epic-confidential)によって異なります。

- 公開グループと機密ではないエピック: 誰でもエピックを表示できます。
- プライベートグループと機密ではないエピック: グループのゲストロール以上を持っている必要があります。
- 非公開のエピック（グループの表示レベルに関係なく）: グループのプランナーロール以上を持っている必要があります。

### キャッシュされるエピック数

サイドバーに表示されるオープンエピックの合計数は、1,000を超えるとキャッシュされます。キャッシュされた値は、千または百万の単位に丸められ、24時間ごとに更新されます。

## エピックのリストをフィルタリングする

{{< history >}}

- グループによるフィルタリングは、GitLab 15.9で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/385191)されました。

{{< /history >}}

エピックのリストは、次の項目でフィルタリングできます。

- タイトルまたは説明
- 作成者名/ユーザー名
- ラベル
- マイルストーン
- 公開設定
- リアクション絵文字
- グループ

![エピックのフィルター](img/epics_filter_v14_7.png)

フィルタリングするには:

1. 左側のサイドバーで、**検索または移動**を選択し、グループを見つけます。
1. **計画 > エピック**を選択します。
1. **結果を検索またはフィルタリング**フィールドを選択します。
1. ドロップダウンリストから範囲を選択するか、プレーンテキストを入力してエピックのタイトルまたは説明で検索します。
1. キーボードで<kbd>Enter</kbd>キーを押します。リストがフィルタリングされます。

### OR演算子でフィルタリングする

{{< history >}}

- ラベルと作成者のORフィルタリングは、GitLab 15.9で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/382969)され、[フラグ](../../../administration/feature_flags.md)`or_issuable_queries`が付けられました。デフォルトでは無効になっています。
- GitLab 15.9の[GitLab.comおよびGitLab Self-Managedで有効化](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/104292)されました。
- GitLab 17.0で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/296031)になりました。機能フラグ`or_issuable_queries`は削除されました。

{{< /history >}}

次の項目で[エピックのリストをフィルタリング](#filter-the-list-of-epics)するときに、OR演算子（**次のいずれか: `||`**）を使用できます。

- 作成者
- ラベル

`is one of`は、包含的ORを表します。たとえば、`Label is one of Deliverable`と`Label is one of UX`でフィルタリングすると、GitLabは`Deliverable`、`UX`、またはその両方のラベルが付いたエピックを表示します。

## エピックのリストをソートする

エピックリストは、次の順にソートすることができます。

- 開始日
- 期限
- タイトル

各オプションには、順序を**昇順**と**降順**の間で切り替えることができるボタンがあります。ソートオプションと順序は保存され、[ロードマップ](../roadmap/_index.md)など、エピックを参照する場所で使用されます。

![エピックのソート](img/epics_sort_v14_7.png)

## アクティビティのソート順を変更する

デフォルトの順序を逆にして、一番上に最新のアイテムが配置されたアクティビティフィードを操作できます。設定はローカルストレージに保存され、表示するすべてのエピックとイシューに自動的に適用されます。

アクティビティのソート順を変更するには、**古い順**ドロップダウンリストを選択し、一番古いアイテムから表示するのか、一番新しいアイテムから表示するのかを選択します。

![イシューアクティビティのソート順ドロップダウンリスト](img/epic_activity_sort_order_v13_2.png)

## エピックを非公開にする

{{< history >}}

- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

個人情報を含むアイテムで作業している場合は、エピックを非公開にすることができます。

{{< alert type="note" >}}

非公開のエピックには、[非公開のイシュー](../../project/issues/confidential_issues.md)と非公開の子エピックのみを含めることができます。ただし、マージリクエストは、公開プロジェクトで作成された場合は公開されます。非公開のマージリクエストの作成方法については、「[非公開のイシューのマージリクエスト](../../project/merge_requests/confidential.md)」を参照してください。

{{< /alert >}}

前提要件:

- エピックのグループに対してプランナーロール以上を持っている必要があります。

エピックを非公開にするには:

- **エピックの作成時:** **公開設定**の下のチェックボックスをオンにします。
- **既存のエピック:** 右側のサイドバーで、**公開設定**の横にある**編集**を選択し、**有効にする**を選択します。

GitLab 15.6以降では、`/confidential`[クイックアクション](../../project/quick_actions.md)も使用できます。

## エピックに割り当てられたイシューを管理する

このセクションでは、エピックに関連して[イシュー](../../project/issues/_index.md)に対して実行できるすべての操作について説明します。

### エピックに割り当てられたイシューを表示する

**子のイシューとエピック**セクションでは、このエピックに割り当てられているエピックとイシューを確認できます。アクセスできるエピックとイシューのみがリストに表示されます。

イシューがグループの子プロジェクトに含まれている場合は、エピックに割り当てられているイシューを常に表示できます。これは、プロジェクトの表示レベル設定は、親グループと同じにするか、親グループよりも制限を緩くする必要があるためです。

<!-- When epics as work items are generally available and feature flag `work_item_epics` is removed,
use the info below in the main body. -->

[エピックの新しい外観](epic_work_items.md)が有効になっている場合、このセクションの名前は**子アイテム**になります。子孫アイテムによって継承されるエピック、イシュー、タスクも表示できます。アクセスできるエピック、イシュー、タスクのみがリストに表示されます。

### エピック内のイシューの数とウェイトを表示する

**子のイシューとエピック**セクションヘッダーには、子孫のエピックとイシューの数、およびそれらの合計ウェイトが表示されます。

オープンおよびクローズのエピックとイシューの数を確認するには:

- セクションヘッダーまたは各エピック名の下で、合計数にカーソルをおきます。

この数字は、表示する権限がないものも含め、エピックに関連付けられているすべての子イシューと子エピックを表しています。

<!-- When epics as work items are generally available and feature flag `work_item_epics` is removed,
use the info below in the main body. -->

[エピックの新しい外観](epic_work_items.md)が有効になっている場合、このセクションの名前は**子アイテム**になります。タスクはこれらの数に含まれません。

### エピックの進捗状況を表示する

{{< history >}}

- GitLab 17.1で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/5163)されました。

{{< /history >}}

**子のイシューとエピック**セクションヘッダーに、エピックの進捗率が表示されます。

子イシューの完了したウェイトと合計ウェイトを確認するには:

- セクションヘッダーで、パーセンテージにカーソルをおきます。

ウェイトと進捗状況は、表示する権限がないイシューを含め、エピックに関連付けられているすべてのイシューを表しています。

<!-- When epics as work items are generally available and feature flag `work_item_epics` is removed,
use the info below in the main body. -->

[エピックの新しい外観](epic_work_items.md)が有効になっている場合、このセクションの名前は**子アイテム**になります。タスクはこの計算に含まれません。

### ヘルスステータス

{{< details >}}

- プラン: Ultimate

{{< /details >}}

{{< history >}}

- GitLab 17.5で[導入](https://gitlab.com/groups/gitlab-org/-/epics/9002)されました。

{{< /history >}}

エピックのヘルスステータスを使用して、プロジェクトの進捗状況をすばやく把握します。ヘルスステータスは、潜在的な問題を事前に伝達および管理するのに役立ちます。

エピックのヘルスステータスは、エピックビュー、**子アイテム**セクション、**リンクされたアイテム**セクションで確認できます。

ヘルスステータスは次のように設定できます。

- 健全（緑）
- 注意が必要（琥珀）
- リスクあり（赤）

計画された作業のタイムリーなデリバリーを妨げるリスクに対処するために、エピックヘルスステータスのレビューを次の項目に組み込みます。

- 毎日のスタンドアップミーティング
- プロジェクトの状態に関するレポート
- 週次ミーティング

#### エピックのヘルスステータスを変更する

{{< history >}}

- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

前提要件:

- [エピックの新しい外観](epic_work_items.md)を有効にする必要があります。
- グループのプランナーロール以上を持っている必要があります。

エピックのヘルスステータスを変更するには:

1. 左側のサイドバーで、**検索または移動**を選択し、グループを見つけます。
1. **計画 > エピック**を選択します。
1. エピックを選択します。
1. 右側のサイドバーの**ヘルスステータス**セクションで、**編集**を選択します。
1. ドロップダウンリストから状態を選択します。

エピックのヘルスステータスが更新されます。

`/health_status`と`/clear_health_status`の[クイックアクション](../../project/quick_actions.md#issues-merge-requests-and-epics)を使用して、ヘルスステータスを設定およびクリアすることもできます。

### エピックにイシューを追加する

{{< history >}}

- 子イシューと子エピックの最大数が、GitLab 17.1で5,000に[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/452111)されました。

{{< /history >}}

既存のイシューをエピックに追加するか、エピックに自動的に追加される新しいイシューを作成します。

直接の子イシューと子エピックの最大数は5,000です。

#### エピックに既存のイシューを追加する

{{< history >}}

- プロジェクトに必要な最小ロールが、GitLab 15.8でレポーターからゲストに[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/382506)されました。

{{< /history >}}

[別のグループ階層](_index.md#child-issues-from-different-group-hierarchies)のプロジェクトのイシューを含め、既存のイシューをエピックに追加できます。新しく追加されたイシューは、**子のイシューとエピック**セクションのイシューリストの一番上に表示されます。

エピックにはイシューのリストが含まれており、イシューは最大で1つのエピックの子アイテムとして設定できます。すでにエピックにリンクされている新しいイシューを追加すると、そのイシューは現在の親から自動的にリンク解除されます。

前提要件:

- イシューのプロジェクトとエピックのグループに対して、ゲストロール以上を持っている必要があります。

エピックに既存のイシューを追加するには:

1. エピックのページの**子のイシューとエピック**で、**追加**を選択します。
1. **既存のイシューを追加**を選択します。
1. 次のいずれかの方法を使用して、追加するイシューを指定します。
   - イシューのリンクを貼り付けます。
   - イシューのタイトルの一部を入力して、一致する目的の項目を選択し、目的のイシューを検索します。別のグループ階層からのイシューは、検索結果に表示されません。そのようなイシューを追加するには、完全なURLを入力します。

   追加するイシューが複数ある場合は、<kbd>スペース</kbd>キーを押して、この手順を繰り返します。
1. **追加**を選択します。

<!-- When epics as work items are generally available and feature flag `work_item_epics` is removed,
use the info below in the main body. -->

[エピックの新しい外観](epic_work_items.md)が有効になっている場合、このセクションの名前は**子アイテム**になります。

#### エピックからイシューを作成する

{{< history >}}

- プロジェクトに必要な最小ロールが、GitLab 15.8でレポーターからゲストに[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/382506)されました。

{{< /history >}}

エピックからイシューを作成すると、作業をより小さな部分に分割しながら、エピックのより広範なコンテキストに焦点を当て続けることができます。

エピックからの新しいイシューは、エピックのグループまたはその子孫サブグループの1つにあるプロジェクトでのみ作成できます。[エピックのグループと共有されているプロジェクト](../../project/members/sharing_projects_groups.md)に新しいイシューを作成するには、最初に[プロジェクトで直接イシューを作成](../../project/issues/create_issues.md#from-a-project)し、次に[既存のイシューをエピックに追加](#add-an-existing-issue-to-an-epic)します。

前提要件:

- イシューのプロジェクトとエピックのグループに対して、ゲストロール以上を持っている必要があります。

エピックからイシューを作成するには:

1. エピックのページの**子のイシューとエピック**で、**追加**を選択します。
1. **新しいイシューを作成**を選択します。
1. **タイトル**の下に、新しいイシューのタイトルを入力します。
1. **プロジェクト**ドロップダウンリストから、イシューを作成するプロジェクトを選択します。
1. **イシューを作成する**を選択します。

新しいイシューがエピックに割り当てられます。

<!-- When epics as work items are generally available and feature flag `work_item_epics` is removed,
use the info below in the main body. -->

[エピックの新しい外観](epic_work_items.md)が有効になっている場合、このセクションの名前は**子アイテム**になります。

### エピックからイシューを削除する

{{< history >}}

- プロジェクトに必要な最小ロールが、GitLab 15.8でレポーターからゲストに[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/382506)されました。

{{< /history >}}

エピックの詳細ページで、エピックからイシューを削除できます。エピックからイシューを削除すると、このイシューはこのエピックとの関連付けが解除されます。

前提要件:

- イシューのプロジェクトとエピックのグループに対して、ゲストロール以上を持っている必要があります。

エピックからイシューを削除するには:

1. 削除するイシューの横にある**削除**（{{< icon name="close" >}}）を選択します。**イシューを削除**警告が表示されます。
1. **削除**を選択します。

![エピックに割り当てられたイシューのリスト](img/issue_list_v15_11.png)

### エピックに割り当てられたイシューを並べ替える

{{< history >}}

- プロジェクトに必要な最小ロールが、GitLab 15.8でレポーターからゲストに[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/382506)されました。

{{< /history >}}

新しいイシューは、**子のイシューとエピック**セクションのリストの一番上に表示されます。イシューのリストは、ドラッグして並べ替えることができます。

前提要件:

- イシューのプロジェクトとエピックのグループに対して、ゲストロール以上を持っている必要があります。

エピックに割り当てられたイシューを並べ替えるには:

1. **子のイシューとエピック**セクションに移動します。
1. イシューを目的の順序にドラッグします。

<!-- When epics as work items are generally available and feature flag `work_item_epics` is removed,
use the info below in the main body. -->

[エピックの新しい外観](epic_work_items.md)が有効になっている場合、このセクションの名前は**子アイテム**になります。

### エピック間でイシューを移動する

{{< details >}}

- プラン: Ultimate
- 製品: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- プロジェクトに必要な最小ロールが、GitLab 15.8でレポーターからゲストに[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/382506)されました。

{{< /history >}}

新しいイシューは、**子のイシューとエピック**タブのリストの一番上に表示されます。イシューはエピック間で移動できます。

前提要件:

- イシューのプロジェクトとエピックのグループに対して、ゲストロール以上を持っている必要があります。

イシューを別のエピックに移動するには:

1. **子のイシューとエピック**セクションに移動します。
1. 表示されている階層で、イシューを目的の親エピックにドラッグします。

<!-- When epics as work items are generally available and feature flag `work_item_epics` is removed,
use the info below in the main body. -->

[エピックの新しい外観](epic_work_items.md)が有効になっている場合、このセクションの名前は**子アイテム**になります。

### 繰り返すイシューにエピックテンプレートを使用する

スプレッドシートテンプレートを作成して、頻繁に繰り返すイシューのパターンを管理できます。

<i class="fa fa-youtube-play youtube" aria-hidden="true"></i>エピックテンプレートの概要については、[GitLab Epics and Epic Template Tip（GitLabエピックおよびエピックテンプレートのヒント（英語））](https://www.youtube.com/watch?v=D74xKFNw8vg)を参照してください。

エピックテンプレートの詳細については、「[エピックテンプレート - 繰り返し可能なイシューのセット](https://handbook.gitlab.com/handbook/marketing/brand-and-product-marketing/product-and-solution-marketing/getting-started/104/)」を参照してください。

## マルチレベルの子エピック

{{< details >}}

- プラン: Ultimate
- 製品: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

グループまたは親エピックのグループのサブグループに属する任意のエピックを追加できます。新しい子エピックは、**子のイシューとエピック**セクションのエピックリストの一番上に表示されます。
<!-- When epics as work items are generally available and feature flag `work_item_epics` is removed,
use the info below in the main body. -->
[エピックの新しい外観](epic_work_items.md)が有効になっている場合、このセクションの名前は**子アイテム**になります。

すでに親エピックにリンクされているエピックを追加すると、現在の親へのリンクは解除されます。

エピックには、合計7レベルまでのネストされた複数の子エピックを含めることができます。

### エピックに親エピックを追加する

{{< history >}}

- GitLab 17.5で[導入](https://gitlab.com/groups/gitlab-org/-/epics/11198)されました。

{{< /history >}}

エピックの階層を作成するには、既存のエピックに親エピックを追加します。これにより、複数のエピックにわたる関連作業を整理して追跡できます。

前提要件:

- [エピックの新しい外観](epic_work_items.md)を有効にする必要があります。
- 親エピックのグループまたは子エピックのグループのいずれかに対して、ゲストロール以上を持っている必要があります。

親エピックを追加するには:

1. 左側のサイドバーで、**検索または移動**を選択し、グループを見つけます。
1. **計画 > エピック**を選択します。
1. エピックを選択します。
1. 右側のサイドバーの**親**セクションで、**編集**を選択します。
1. 検索ボックスに、親エピックのタイトルの一部を入力します。同じグループ階層内のエピックのみを検索できます。
1. 検索結果から、親として追加するエピックを選択します。

親エピックが追加されます。

### 他のグループからの子エピック

{{< history >}}

- GitLab 15.6で`child_epics_from_different_hierarchies`[フラグとともに](../../../administration/feature_flags.md)[導入されました](https://gitlab.com/groups/gitlab-org/-/epics/8502)。デフォルトでは無効になっています。
- GitLab 15.7で、グループに必要な最小ロールがレポーターからゲストに[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/382503)されました。
- GitLab 15.9で、グループ間の子エピックが[GitLab.comとGitLab Self-Managedで有効](https://gitlab.com/gitlab-org/gitlab/-/issues/375622)になりました。デフォルトで有効になっています。
- GitLab 15.10で[機能フラグ`child_epics_from_different_hierarchies`](https://gitlab.com/gitlab-org/gitlab/-/issues/382719)が削除されました。

{{< /history >}}

親エピックのグループとは異なるグループに属する子エピックを追加します。

前提要件:

- 子エピックと親エピックの両方のグループに対して、ゲストロール以上を持っている必要があります。
- 子エピックと親エピックの両方のグループで、マルチレベルの子エピックを利用できる必要があります。

別のグループから子エピックを追加するには、[既存のエピックを追加する](#add-a-child-epic-to-an-epic)ときに、エピックのURLを貼り付けます。

### ロードマップで子エピックを表示する

エピックから、[ロードマップ](../roadmap/_index.md)でその子エピックと関連するマイルストーンを表示します。

前提要件:

- 親エピックのグループに対してゲストロール以上を持っている必要があります。

親から子エピックを表示するには:

- エピックの**子のイシューとエピック**セクションで、**ロードマップ表示**を選択します。

<!-- When epics as work items are generally available and feature flag `work_item_epics` is removed,
use the info below in the main body. -->

[エピックの新しい外観](epic_work_items.md)が有効になっている場合、このセクションの名前は**子アイテム**になります。

### エピックに子エピックを追加する

{{< history >}}

- GitLab 15.7で、グループに必要な最小ロールがレポーターからゲストに[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/382503)されました。

{{< /history >}}

前提要件:

- 親エピックのグループに対してゲストロール以上を持っている必要があります。

#### 新しいエピック

新しいエピックを子エピックとして追加するには:

1. エピックの**子のイシューとエピック**セクションで、**追加 > 新しいエピックを追加**を選択します。
1. ドロップダウンリストからグループを選択します。エピックのグループはデフォルトで選択されています。
1. 新しいエピックのタイトルを入力します。
1. **エピックを作成**を選択します。

<!-- When epics as work items are generally available and feature flag `work_item_epics` is removed,
use the info below in the main body. -->

[エピックの新しい外観](epic_work_items.md)が有効になっている場合、このセクションの名前は**子アイテム**になります。

#### 既存のエピック

既存のエピックを子エピックとして追加するには:

1. エピックの**子のイシューとエピック**セクションで、**追加 > 既存のエピックを追加**を選択します。
1. 次のいずれかの方法で、追加するエピックを指定します。
   - エピックのリンクを貼り付けます。
   - エピックのタイトルの一部を入力して、一致する目的の項目を選択し、目的のエピックを検索します。この検索は、同じグループ階層内のエピックにのみ利用できます。

   追加するエピックが複数ある場合は、<kbd>スペース</kbd>キーを押してこの手順を繰り返します。
1. **追加**を選択します。

<!-- When epics as work items are generally available and feature flag `work_item_epics` is removed,
use the info below in the main body. -->

[エピックの新しい外観](epic_work_items.md)が有効になっている場合、このセクションの名前は**子アイテム**になります。

### エピック間で子エピックを移動する

{{< history >}}

- GitLab 15.7で、グループに必要な最小ロールがレポーターからゲストに[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/382503)されました。

{{< /history >}}

新しい子エピックは、**子のイシューとエピック**セクションのリストの一番上に表示されます。子エピックはエピック間で移動できます。すでに親エピックにリンクされている新しいエピックを追加すると、現在の親へのリンクは解除されます。イシューと子エピックを混在させることはできません。

前提要件:

- 親エピックのグループに対してゲストロール以上を持っている必要があります。

子エピックを別のエピックに移動するには:

1. **子のイシューとエピック**セクションに移動します。
1. エピックを目的の親エピックにドラッグします。

<!-- When epics as work items are generally available and feature flag `work_item_epics` is removed,
use the info below in the main body. -->

[エピックの新しい外観](epic_work_items.md)が有効になっている場合、このセクションの名前は**子アイテム**になります。

### エピックに割り当てられた子エピックを並べ替える

{{< history >}}

- GitLab 15.7で、グループに必要な最小ロールがレポーターからゲストに[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/382503)されました。

{{< /history >}}

新しい子エピックは、**子のイシューとエピック**セクションのリストの一番上に表示されます。子エピックのリストを並べ替えることができます。

前提要件:

- 親エピックのグループに対してゲストロール以上を持っている必要があります。

エピックに割り当てられた子エピックを並べ替えるには:

1. **子のイシューとエピック**セクションに移動します。
1. エピックを目的の順序にドラッグします。

<!-- When epics as work items are generally available and feature flag `work_item_epics` is removed,
use the info below in the main body. -->

[エピックの新しい外観](epic_work_items.md)が有効になっている場合、このセクションの名前は**子アイテム**になります。

### 親エピックから子エピックを削除する

{{< history >}}

- GitLab 15.7で、グループに必要な最小ロールがレポーターからゲストに[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/382503)されました。

{{< /history >}}

前提要件:

- 親エピックのグループに対してゲストロール以上を持っている必要があります。

親エピックから子エピックを削除するには:

1. 親エピックのエピックのリストで**削除**（{{< icon name="close" >}}）を選択します。**エピックを削除**警告が表示されます。
1. **削除**を選択します。
