---
stage: Security Risk Management
group: Security Policies
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: ポリシー
---

{{< details >}}

- プラン: Ultimate
- 製品: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

ポリシーは、セキュリティチームおよびコンプライアンスチームが、組織全体をグローバルにコントロールする方法を提供します。

セキュリティチームは、ポリシーにより以下を保証できます。

- 開発チームのパイプラインで適切な設定のセキュリティスキャナーが確実に適用されること。
- すべてのスキャンジョブが変更または改変されることなく実行されること。
- スキャンの結果に基づき、マージリクエストに対して適切な承認が提供されること。
- 検出されなくなった脆弱性が自動的に解決され、脆弱性のトリアージ作業のワークロードが軽減されること。

コンプライアンスチームは、ポリシーにより以下を行うことができます。

- すべてのマージリクエストに対して複数の承認者を一元的かつ強制的に適用する。
- マージリクエストやリポジトリ設定の有効化またはロックなど、組織の要件範囲内のプロジェクトにさまざまな設定を強制的に適用する。

次のポリシータイプが使用できます。

- [スキャン実行ポリシー](scan_execution_policies.md)。パイプラインの一部として、または指定されたスケジュールに従ってセキュリティスキャンを強制的に実行します。
- [マージリクエスト承認ポリシー](merge_request_approval_policies.md)。スキャン結果に基づいて、プロジェクトレベルの設定と承認ルールを強制的に適用します。
- [パイプライン実行ポリシー](pipeline_execution_policies.md)。プロジェクトのパイプラインの一部としてCI/CDジョブを強制的に実行します。
- [脆弱性管理ポリシー](vulnerability_management_policy.md)。デフォルトブランチで検出されなくなった脆弱性を自動的に解決します。

## セキュリティポリシープロジェクト

セキュリティポリシープロジェクトは、ポリシーのみを格納するための特別なタイプのプロジェクトです。ポリシーは、`.gitlab/security-policies/policy.yml`というYAMLファイルに保存されます。

セキュリティポリシープロジェクトに含まれるポリシーを適用するには、プロジェクト、サブグループ、グループ、あるいはそれらの複数にリンクします。セキュリティポリシープロジェクトには複数のポリシーを含めることができますが、それらはまとめて適用されます。グループまたはサブグループで適用されたセキュリティポリシープロジェクトは、すべてのサブグループとそのプロジェクトを含め、その階層以下のすべてに適用されます。

マージリクエストで適用されたポリシーの変更は、マージリクエストがマージされるとすぐに有効になります。マージリクエストを経由せず、デフォルトブランチに直接コミットされた変更は、ポリシーの変更が有効になるまでに最大10分かかります。

## セキュリティポリシープロジェクトを削除する

{{< history >}}

- GitLab 17.8で、セキュリティポリシープロジェクトの削除に対する保護が`reject_security_policy_project_deletion`[フラグ](../../../administration/feature_flags.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/482967)されました。デフォルトで有効になっています。
- GitLab 17.9で、セキュリティポリシープロジェクトを含むグループの削除に対する保護が`reject_security_policy_project_deletion_groups`[フラグ](../../../administration/feature_flags.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/512043)されました。デフォルトで有効になっています。
- GitLab 17.10で、セキュリティポリシープロジェクトの削除に対する保護が一般提供になりました。機能フラグ`reject_security_policy_project_deletion`は削除されました。
- GitLab 17.10で、セキュリティポリシープロジェクトを含むグループの削除に対する保護が一般提供になりました。機能フラグ`reject_security_policy_project_deletion_groups`は削除されました。

{{< /history >}}

{{< alert type="flag" >}}

この機能の有効性は、機能フラグによって制御されます。詳細については履歴を参照してください。

{{< /alert >}}

セキュリティポリシープロジェクトまたはその親グループの1つを削除するには、他のグループまたはプロジェクトから削除対象へのリンクをすべて削除する必要があります。そうしないと、リンクされたセキュリティポリシープロジェクトまたは親グループを削除する際にエラーメッセージが表示されます。

## ポリシー設計ガイドライン

ポリシーを設計するときの目標は次のとおりです。

- 適用した際に最小限のオーバーヘッドで最大限のカバレッジが得られるようにポリシーを設計する
- 職務分離（SoD）を確保する

### 適用

要求事項を満たすようにポリシーを適用するには、次の要素を考慮します。

- **継承: **デフォルトでは、ポリシーは、リンクされている組織単位、およびそのすべての子孫サブグループとそのプロジェクトに適用されます。
- **スコープ: **要件に合わせてポリシーのスコープを定義し、ポリシーの適用をカスタマイズできます。

#### 継承

ポリシーのカバレッジを最大化するには、セキュリティポリシープロジェクトを、目標達成が求められる最上位の組織単位（グループ、サブグループ、またはプロジェクト）にリンクします。ポリシーは、リンクされている組織単位、およびそのすべての子孫サブグループとそのプロジェクトに適用されます。最上位の組織単位に適用することで、必要なセキュリティポリシーの数を最小限に抑え、管理のオーバーヘッドを削減できます。

ポリシーの継承を使用して、ポリシーを段階的にロールアウトできます。たとえば、新しいポリシーをロールアウトする場合、1つのプロジェクトにそのポリシーを適用し、テストを実施できます。テストが成功した場合は、そのポリシーをプロジェクトから削除し、グループに適用して、ポリシーがすべての該当プロジェクトに適用されるように階層を上げていきます。

既存のグループまたはサブグループに適用されるポリシーは、その下に作成された新しいサブグループとプロジェクトに対して自動的に適用されます。ただし、以下のすべての条件が満たされている場合に限ります。

- 新しいサブグループおよびプロジェクトがポリシーのスコープ定義に含まれている（たとえば、スコープにこのグループのすべてのプロジェクトが含まれている）。
- 既存のグループまたはサブグループがセキュリティポリシープロジェクトにすでにリンクされている。

{{< alert type="note" >}}

GitLab.comユーザーは、自分のトップレベルグループまたはサブグループ全体に対してポリシーを適用できますが、GitLab.comのトップレベルグループ全体に対してポリシーを適用することはできません。GitLab Self-Managed管理者は、インスタンス内の複数のトップレベルグループ全体にポリシーを適用できます。

{{< /alert >}}

次の例は、2つのグループとその構造を示しています。

- Alphaグループには2つのサブグループが含まれており、各サブグループには複数のプロジェクトが含まれています。
- セキュリティとコンプライアンスグループには2つのポリシーが含まれています。

**Alpha**グループ（コードプロジェクトを含む）

- **財務**（サブグループ）
  - プロジェクトA
  - 受取勘定（サブグループ）
    - プロジェクトB
    - プロジェクトC
- **エンジニアリング**（サブグループ）
  - プロジェクトK
  - プロジェクトL
  - プロジェクトM

**セキュリティとコンプライアンス**グループ（セキュリティポリシープロジェクトを含む）

- Security Policy Management
- Security Policy Management - security policy project
  - SASTポリシー
  - シークレット検出ポリシー

ポリシーが適用されていないと仮定して、次の例を考えてみましょう。

- 「SAST」ポリシーがグループAlphaに適用されている場合、そのサブグループである「財務」と「エンジニアリング」、およびそれらのすべてのプロジェクトとサブグループに適用されます。「シークレット検出」ポリシーがサブグループ「受取勘定」でも適用されている場合、「SAST」と「シークレット検出」両方のポリシーがプロジェクトBとCに適用されます。ただし、プロジェクトAには「SAST」ポリシーのみが適用されます。
- 「SAST」ポリシーがサブグループ「受取勘定」に適用されている場合、プロジェクトBとCのみに適用されます。プロジェクトAに「SAST」ポリシーは適用されません。
- 「シークレット検出」ポリシーがプロジェクトKで適用されている場合、プロジェクトKのみに適用されます。他のサブグループまたはプロジェクトに「シークレット検出」ポリシーは適用されません。

#### スコープ

{{< history >}}

- GitLab 16.7で、`security_policies_policy_scope`[フラグ](../../../administration/feature_flags.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/135398)されました。デフォルトで有効になっています。
- GitLab 16.11で、[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/443594)になりました。機能フラグ`security_policies_policy_scope`は削除されました。
- GitLab 17.4で、グループによるスコープが[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/468384)されました。

{{< /history >}}

ポリシーのスコープは、次の方法で絞り込むことができます。

- コンプライアンスフレームワーク: 選択したコンプライアンスフレームワークを持つプロジェクトにポリシーを適用します。
- グループ:
  - グループ内のすべてのプロジェクト。すべての子孫サブグループとそのプロジェクトを含みます。オプションで、特定のプロジェクトを除外できます。
  - 複数のグループ内のすべてのプロジェクト。それらの子孫サブグループとそのプロジェクトを含みます。同じセキュリティポリシープロジェクトにリンクされているグループのみ、ポリシーの対象として列挙できます。オプションで、特定のプロジェクトを除外できます。
- プロジェクト: 特定のプロジェクトを含めるか除外するかを選択できます。同じセキュリティポリシープロジェクトにリンクされているプロジェクトのみ、ポリシーの対象として列挙できます。

これらのオプションは、同じポリシー内で組み合わせて使用​​できます。ただし、除外が包含よりも優先されます。

##### `policy_scope`キーワード

`policy_scope`キーワードを使用して、指定したグループ、プロジェクト、コンプライアンスフレームワーク、またはそれらの組み合わせに対してのみポリシーを適用します。

| フィールド                   | 型     | 使用可能な値          | 説明 |
|-------------------------|----------|--------------------------|-------------|
| `compliance_frameworks` | `array`  | 該当なし           | スコープ内のコンプライアンスフレームワークのIDを、キー`id`を持つオブジェクトの配列でリストします。 |
| `projects`              | `object` | `including`、`excluding` | `excluding:`または`including:`を使用して、含めるまたは除外するプロジェクトのIDを、キー`id`を持つオブジェクトの配列でリストします。 |
| `groups`                | `object` | `including`              | `including:`を使用して、含めるグループのIDを、キー`id`を持つオブジェクトの配列でリストします。同じセキュリティポリシープロジェクトにリンクされているグループのみ、ポリシーの対象として列挙できます。 |

##### スコープの例

次の例では、スキャン実行ポリシーは、IDが`2`または`11`のコンプライアンスフレームワークが適用されたすべてのプロジェクトのすべてのリリースパイプラインでSASTスキャンを強制的に実行します。

```yaml
---
scan_execution_policy:
- name: Enforce specified scans in every release pipeline
  description: This policy enforces a SAST scan for release branches
  enabled: true
  rules:
  - type: pipeline
    branches:
    - release/*
  actions:
  - scan: sast
  policy_scope:
    compliance_frameworks:
      - id: 2
      - id: 11
```

次の例では、スキャン実行ポリシーは、IDが`203`のグループ（すべての子孫サブグループとそのプロジェクトを含む）内のすべてのプロジェクトのデフォルトブランチのパイプラインで、シークレット検出とSASTスキャンを強制的に実行します。ただし、IDが`64`のプロジェクトは除外されます。

```yaml
- name: Enforce specified scans in every default branch pipeline
  description: This policy enforces Secret Detection and SAST scans for the default branch
  enabled: true
  rules:
  - type: pipeline
    branches:
    - main
  actions:
  - scan: secret_detection
  - scan: sast
  policy_scope:
    groups:
      including:
        - id: 203
    projects:
      excluding:
        - id: 64
```

### 職務分離（SoD）

ポリシーの正常な実装のためには、職務分離が不可欠です。必要なコンプライアンス要件とセキュリティ要件を達成するポリシーを実装すると同時に、開発チームが目標を達成できるようにします。

セキュリティチームとコンプライアンスチーム:

- ポリシーの定義を担当し、開発チームと協力してポリシーが開発チームの要件を満たすようにする必要があります。

開発チーム:

- いかなる方法でもポリシーを無効化、変更、または回避できないようにする必要があります。

グループ、サブグループ、またはプロジェクトでセキュリティポリシープロジェクトを適用するには、次のいずれかが必要です。

- そのグループ、サブグループ、またはプロジェクトのオーナーロール。
- `manage_security_policy_link`権限を持つそのグループ、サブグループ、またはプロジェクトの[カスタムロール](../../custom_roles/_index.md)。

オーナーロール、および`manage_security_policy_link`権限を持つカスタムロールは、グループ、サブグループ、プロジェクト全体で標準の階層ルールに従います。

| 組織単位 | グループオーナーまたはグループの`manage_security_policy_link`権限 | サブグループオーナーまたはサブグループの`manage_security_policy_link`権限 | プロジェクトオーナーまたはプロジェクトの`manage_security_policy_link`権限 |
|-------------------|---------------------------------------------------------------|---------------------------------------------------------------------|-------------------------------------------------------------------|
| グループ             | {{< icon name="check-circle" >}}はい                                        | {{< icon name="dotted-circle" >}}いいえ                                              | {{< icon name="dotted-circle" >}}いいえ                                            |
| サブグループ          | {{< icon name="check-circle" >}}はい                                        | {{< icon name="check-circle" >}}はい                                              | {{< icon name="dotted-circle" >}}いいえ                                            |
| プロジェクト           | {{< icon name="check-circle" >}}はい                                        | {{< icon name="check-circle" >}}はい                                              | {{< icon name="check-circle" >}}はい                                            |

#### 必要な権限

セキュリティポリシーを作成および管理するには:

- グループに適用されるポリシーの場合: グループのメンテナーロール以上を持っている必要があります。
- プロジェクトに適用されるポリシーの場合:
  - プロジェクトのオーナーである必要があります。
  - グループ内でプロジェクトを作成する権限を持つグループメンバーである必要があります。

{{< alert type="note" >}}

グループメンバーでない場合、プロジェクトのポリシーの追加や編集が制限されることがあります。ポリシーを作成および管理するには、グループ内でプロジェクトを作成する権限が必要です。プロジェクトレベルのポリシーを扱う場合でも、グループに必要な権限があることを確認してください。

{{< /alert >}}

## ポリシーの実装

セキュリティポリシープロジェクトの実装オプションは、GitLab.com、GitLab Dedicated、GitLab Self-Managedで若干異なります。主な違いは、GitLab.comではサブグループのみを作成できることです。職務分離（SoD）を確実にするには、よりきめ細かい権限設定が必要です。

### GitLab.comネームスペースでポリシーをグローバルに適用する

{{< details >}}

- プラン: Ultimate
- 製品: GitLab.com

{{< /details >}}

前提要件:

- セキュリティポリシープロジェクトにリンクするには、オーナーロールまたは`manage_security_policy_link`権限を持つ[カスタムロール](../../custom_roles/_index.md)が必要です。詳細については、[職務分離（SoD）](#separation-of-duties)を参照してください。

GitLab.comネームスペース内のすべてのサブグループとプロジェクト全体でポリシーをグローバルに適用するための概要ワークフロー:

1. トップレベルグループから**ポリシー**タブにアクセスします。
1. サブグループで、**ポリシー**タブに移動し、テストポリシーを作成します。

   （ヒント: テスト用にポリシーを無効にして作成できます。）ポリシーを作成すると、トップレベルグループの下に新しいセキュリティポリシープロジェクトが自動的に作成されます。このプロジェクトは、`policy.yml`またはPolicy as Codeを保存するために使用されます。
1. 必要に応じて、新しく作成したプロジェクトの権限を確認および設定します。

   デフォルトでは、オーナーとメンテナーはポリシーを作成、編集、および削除できます。デベロッパーはポリシーの変更を提案できますが、マージすることはできません。
1. サブグループ内に作成されたセキュリティポリシープロジェクトで、必要なポリシーを作成します。

   作成した`Security Policy Management`プロジェクトの**ポリシー**タブにあるポリシーエディターを使用できます。または、新しく作成したセキュリティポリシープロジェクト`Security Policy Management - security policy project`に保存されている`policy.yml`ファイルで、ポリシーを直接更新することもできます。
1. グループ、サブグループ、またはプロジェクトをセキュリティポリシープロジェクトにリンクします。

   サブグループのオーナー、または適切な権限を持つプロジェクトのオーナーは、**ポリシー**ページにアクセスし、セキュリティポリシープロジェクトへのリンクを作成できます。プロジェクトの名前は、フルパス表記とし、「- security policy project」で終わる必要があります。リンクされているすべてのグループ、サブグループ、プロジェクトは、セキュリティポリシープロジェクトで作成されたポリシーによって「適用可能」になります。詳細については、[セキュリティポリシープロジェクトへのリンク](#link-to-a-security-policy-project)を参照してください。
1. デフォルトでは、ポリシーが有効になると、リンクされているグループ、サブグループ、プロジェクト内のすべてのプロジェクトにそのポリシーが適用されます。

   よりきめ細かく適用するには、「ポリシースコープ」を追加します。ポリシースコープを使用すると、特定のプロジェクトセット、または特定のコンプライアンスフレームワークラベルを含むプロジェクトに対してポリシーを適用できます。
1. たとえば、継承された権限のブロックや、ポリシー変更に対する追加のレビューまたは承認の要求など、追加の制限が必要な場合は、セキュリティポリシープロジェクトのみにスコープが設定された追加のポリシーを作成し、追加の承認を適用します。

### GitLab DedicatedまたはGitLab Self-Managedでポリシーをグローバルに適用する

{{< details >}}

- プラン: Ultimate
- 製品: GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

前提要件:

- セキュリティポリシープロジェクトにリンクするには、オーナーロールまたは`manage_security_policy_link`権限を持つ[カスタムロール](../../custom_roles/_index.md)が必要です。詳細については、[職務分離（SoD）](#separation-of-duties)を参照してください。
- インスタンス全体で承認グループをグローバルにサポートするには、[GitLabインスタンスアプリケーションの設定](../../../api/settings.md)で`security_policy_global_group_approvers_enabled`を有効にします。

複数のグループ全体にポリシーを適用するための概要ワークフロー:

1. ポリシーを格納し、職務分離を確保するために、別のグループを作成します。

   別のスタンドアロングループを作成することで、権限を継承するユーザーの数を最小限に抑えることができます。
1. 新しいグループで、**ポリシー**タブにアクセスします。

   このタブにはポリシーエディターがあり、UIによりポリシーの作成や管理ができます。
1. テストポリシーを作成します（テスト目的でポリシーを無効な状態で作成できます）。

   ポリシーを作成すると、グループの下に新しいセキュリティポリシープロジェクトが自動的に作成されます。このプロジェクトは、`policy.yml`またはPolicy as Codeを保存するために使用されます。
1. 必要に応じて、新しく作成したプロジェクトの権限を確認および設定します。

   デフォルトでは、オーナーとメンテナーはポリシーを作成、編集、および削除できます。デベロッパーはポリシーの変更を提案できますが、マージすることはできません。
1. サブグループで作成したセキュリティポリシープロジェクトで、必要なポリシーを作成します。

   作成した`Security Policy Management`プロジェクトのポリシータブにあるポリシーエディターを使用できます。または、新しく作成したセキュリティポリシープロジェクト`Security Policy Management - security policy project`に保存されている`policy.yml`ファイルで、ポリシーを直接更新することもできます。
1. グループ、サブグループ、またはプロジェクトをセキュリティポリシープロジェクトにリンクします。

   サブグループのオーナー、または適切な権限を持つプロジェクトのオーナーは、**ポリシー**ページにアクセスし、セキュリティポリシープロジェクトへのリンクを作成できます。プロジェクトの名前は、フルパス表記とし、「- security policy project」で終わる必要があります。リンクされているすべてのグループ、サブグループ、プロジェクトは、セキュリティポリシープロジェクトで作成されたポリシーによって「適用可能」になります。詳細については、[セキュリティポリシープロジェクトへのリンク](#link-to-a-security-policy-project)を参照してください。
1. デフォルトでは、ポリシーが有効になると、リンクされているグループ、サブグループ、プロジェクト内のすべてのプロジェクトにそのポリシーが適用されます。よりきめ細かく適用するには、ポリシースコープを追加します。ポリシースコープを使用すると、特定のプロジェクトセット、または特定のコンプライアンスフレームワークラベルを含むプロジェクトに対してポリシーを適用できます。
1. たとえば、継承された権限のブロックや、ポリシー変更に対する追加のレビューまたは承認の要求など、追加の制限が必要な場合は、セキュリティポリシープロジェクトのみにスコープが設定された追加のポリシーを作成し、追加の承認を適用します。

## セキュリティポリシープロジェクトへのリンク

セキュリティポリシープロジェクトに含まれるポリシーをグループ、サブグループ、またはプロジェクトに対して適用するには、それらをリンクします。デフォルトでは、リンクされているすべてのエンティティに適用されます。ポリシーごとにきめ細かくポリシーを適用するには、各ポリシーで「ポリシースコープ」を設定します。

前提要件:

- セキュリティポリシープロジェクトにリンクするには、オーナーロールまたは`manage_security_policy_link`権限を持つ[カスタムロール](../../custom_roles/_index.md)が必要です。詳細については、[職務分離（SoD）](#separation-of-duties)を参照してください。
- レポーターロール以上、またはセキュリティポリシープロジェクトとして割り当てるプロジェクトに対する`manage_security_policy_link`権限を持つ[カスタムロール](../../custom_roles/_index.md)を持っている必要があります。詳細については、[職務分離（SoD）](#separation-of-duties)を参照してください。

グループ、サブグループ、またはプロジェクトをセキュリティポリシープロジェクトにリンクするには:

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクト、サブグループ、またはグループを見つけます。
1. **セキュリティ＞ポリシー**を選択します。
1. **ポリシープロジェクトを編集**を選択し、ドロップダウンリストからリンクするプロジェクトを検索して選択します。
1. **保存**を選択します。

セキュリティポリシープロジェクトのリンクを解除するには、同じ手順に従いますが、ダイアログでゴミ箱アイコンを選択します。同じトップレベルグループ内の別のサブグループから、または完全に異なるトップレベルグループからセキュリティポリシープロジェクトにリンクできます。ただし、[パイプライン実行ポリシー](pipeline_execution_policies.md#pipeline-execution-policy-schema)を適用する場合、パイプラインをトリガーするには、ユーザーには少なくとも、そのポリシーで参照されているCI/CD設定を含むプロジェクトに対する読み取り専用アクセス権が必要です。

### リンクされたセキュリティポリシープロジェクトを表示する

プロジェクトポリシーページへのアクセス権があり、プロジェクトオーナーではないすべてのユーザーには、代わりに、関連付けられたセキュリティポリシープロジェクトにリンクするボタンが表示されます。

## ポリシーの推奨事項

ポリシーを実装する際は、以下の推奨事項を考慮してください。

### ブランチ名

ポリシーでブランチ名を指定する場合は、個々のブランチ名ではなく、**デフォルトブランチ**や**すべての保護ブランチ**など、保護されたブランチの汎用的なカテゴリを使用します。

ポリシーは、指定されたブランチがそのプロジェクト内に存在する場合にのみ、プロジェクトに適用されます。たとえば、ポリシーがブランチ`main`にルールを適用しているが、スコープ内のいくつかのプロジェクトがデフォルトブランチとして`production`を使用している場合、ポリシーは後者には適用されません。

### プッシュルール

GitLab 17.3以前のバージョンでは、プッシュルールを使用して[ブランチ名を検証する](../../project/repository/push_rules.md#validate-branch-names)場合、プレフィックス`update-policy-`を付けたブランチ名でブランチを作成できることを確認してください。このブランチ名プレフィックスは、セキュリティポリシーの作成時または修正時に使用されます。たとえば、`update-policy-1659094451`などです。ここで、`1659094451`はタイムスタンプです。プッシュルールがブランチの作成をブロックした場合、次のエラーが発生します。

> ブランチ名`update-policy-<timestamp>`は、パターン`<branch_name_regex>`に従っていません。

[GitLab 17.4以降](https://gitlab.com/gitlab-org/gitlab/-/issues/463064)のバージョンでは、セキュリティポリシープロジェクトは、ブランチ名の検証を実行するプッシュルールから除外されます。

## ポリシー管理

ポリシーページでは、利用可能なすべての環境にデプロイされたポリシーを表示できます。次の手順により、ポリシーの情報（説明や適用状況など）を確認したり、デプロイされたポリシーを作成または編集したりすることができます。

1. 左側のサイドバーで、**検索または移動**を選択して、プロジェクトを見つけます。
1. **セキュリティ＞ポリシー**を選択します。

![ポリシーリストページ](img/policies_list_v17_7.png)

最初の列に緑色のチェックマークが表示されている場合、ポリシーは有効化されており、そのスコープ内のすべてのグループとプロジェクトに適用されていることを示します。灰色のチェックマークは、ポリシーが現在有効化されていないことを示します。

## ポリシーエディター

ポリシーエディターを使用して、ポリシーを作成、編集、および削除できます。

1. 左側のサイドバーで、**検索または移動**を選択して、プロジェクトを見つけます。
1. **セキュリティ＞ポリシー**を選択します。
   - 新しいポリシーを作成するには、**ポリシー**ページのヘッダーにある**新規ポリシー**を選択します。次に、作成するポリシーのタイプを選択します。
   - 既存のポリシーを編集するには、選択したポリシーdrawerで**ポリシーを編集**を選択します。

   ポリシーエディターには、次の2つのモードがあります。

   - 視覚的な_ルール_モードでは、ルールブロックと関連するコントロールを使用して、ポリシールールを構築およびプレビューできます。

     ![ポリシーエディターのルールモード](img/policy_rule_mode_v15_9.png)

   - YAMLモードでは、`.yaml`形式でポリシー定義を入力できます。これは、エキスパートユーザーを対象としており、ルールモードではサポートされていないケースに対応できます。

     ![ポリシーエディターのYAMLモード](img/policy_yaml_mode_v15_9.png)

     どちらのモードも、いつでも相互に切り替えることができます。ただし、YAMLリソースが正しくない場合、またはルールモードでサポートされていないデータが含まれている場合、ルールモードは自動的に無効になります。YAMLリソースが正しくない場合、ルールモードで再度使用するためには、YAMLモードを使用してポリシーを修正する必要があります。

1. **マージリクエスト経由で設定**を選択して変更を保存し、適用します。

   ポリシーのYAMLが検証され、その結果発生したエラーが表示されます。

1. 結果として生成されたマージリクエストを確認してマージします。

   プロジェクトのオーナーであり、セキュリティポリシープロジェクトがこのプロジェクトに関連付けられていない場合、マージリクエストの作成時にセキュリティポリシープロジェクトが作成され、このプロジェクトにリンクされます。

## トラブルシューティング

セキュリティポリシーを扱う場合は、次のトラブルシューティングのヒントを考慮してください。

- セキュリティポリシープロジェクトを、開発プロジェクトと、開発プロジェクトが属するグループまたはサブグループの両方にリンクしないでください。両方にリンクすると、マージリクエスト承認ポリシーからの承認ルールが、開発プロジェクトのマージリクエストに適用されなくなります。
- マージリクエスト承認ポリシーを作成する場合、[`scan_finding`ルール](merge_request_approval_policies.md#scan_finding-rule-type)内の配列`severity_levels`や配列`vulnerability_states`を空にしないでください。ルールが機能するためには、各配列に少なくとも1つのエントリが存在する必要があります。
- プロジェクトのオーナーは、グループでプロジェクトを作成する権限も持っている場合に限り、そのプロジェクトのポリシーを適用できます。グループメンバーではないプロジェクトオーナーは、ポリシーの追加または編集が制限される場合があります。プロジェクトのポリシーを管理できない場合は、グループ管理者に問い合わせて、グループに必要な権限があることを確認してください。

それでも問題が発生する場合は、[最近報告されたバグを確認](https://gitlab.com/gitlab-org/gitlab/-/issues/?sort=popularity&state=opened&label_name%5B%5D=group%3A%3Asecurity%20policies&label_name%5B%5D=type%3A%3Abug&first_page_size=20)し、同じ報告がなければ新たにイシューを報告してください。
