---
stage: Application Security Testing
group: Static Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: アプリケーションセキュリティ
---

{{< details >}}

- プラン:Ultimate
- 提供形態:GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

GitLab のセキュリティスキャン機能を使用して、開発プロセスにセキュリティをビルドします。脆弱性が本番環境に到達する前に、開発ライフサイクルの早い段階で脆弱性を特定し、対処します。

GitLab は、コード、依存関係、コンテナ、デプロイされたアプリケーション全体のセキュリティの脆弱性を検出します。以下を含みます:

- 不正アクセスポイント
- 潜在的なデータ漏洩
- サービス拒否 (DoS) の脆弱性
- サプライチェーンの弱点

セキュリティ検出はマージリクエストに直接表示され、コードがマージされる前に実行可能な情報を提供します。このプロアクティブなアプローチにより、開発の後段階でイシューを修正するためのコストと労力が削減されます。

セキュリティチームにとって、GitLabセキュリティダッシュボードは脆弱性の発見を一元化し、優先順位付けと修正の追跡をより簡単にします。デベロッパーにとって、マージリクエストのインテグレーションは、コンテキストスイッチを減らし、ワークフローをより効率的にすることを意味します。

クリック可能なデモについては、[パイプラインへのセキュリティの統合](https://gitlab.navattic.com/gitlab-scans)を参照してください。
<!-- Demo published on 2024-01-15 -->

## データプライバシー

セキュリティスキャナーのドメインにおけるデータプライバシーに関して、GitLabはソースコードを処理し、GitLab Runner上でローカルに分析を実行します。データはGitLabインフラストラクチャ（サーバーとRunner）の外部に送信されません。

弊社のスキャナーは、最新の一連の署名、ルール、およびパッチをダウンロードするためにのみインターネットにアクセスします。スキャナーがインターネットにアクセスしないようにする場合は、[オフライン環境](offline_deployments/_index.md)の使用を検討してください。

## 脆弱性スキャナーのメンテナンス

以下の脆弱性スキャナーとそのデータベースは定期的に更新されます。

| Secureスキャン ツール                                            | 脆弱性データベースの更新 |
|:----------------------------------------------------------------|:---------------------------------|
| [コンテナスキャン](container_scanning/_index.md)            | ジョブは毎日実行され、アップストリームスキャナーからの最新の脆弱性データベースの更新で新しいイメージをビルドします。GitLabは、データベースが48時間以上経過した場合にエンジニアリングチームに通知する内部アラートを通じて、このジョブを監視します。詳細については、[脆弱性データベースの更新](container_scanning/_index.md#vulnerabilities-database)を参照してください。 |
| [依存関係スキャン](dependency_scanning/_index.md)          | National Vulnerability Database（NVD）およびGitHub Advisory Databaseのデータを使用して毎日更新される[GitLab Advisory Database](gitlab_advisory_database/_index.md)に依存します。 |
| [動的アプリケーションセキュリティテスト（DAST）](dast/_index.md) | [DAST](dast/browser/_index.md)アナライザーは定期的に更新されます。 |
| [シークレット検出](secret_detection/pipeline/_index.md#detected-secrets) | GitLab は[検出ルール](secret_detection/pipeline/_index.md#detected-secrets)を保持し、[コミュニティからのコントリビュートを受け付け](secret_detection/pipeline/configure.md#add-new-patterns)ます。関連する更新プログラムが利用可能な場合、スキャンエンジンは少なくとも月に1回更新されます。 |
| [静的アプリケーションセキュリティテスト（SAST）](sast/_index.md)  | スキャンルールのソースは、[サポートされているプログラミング言語](sast/_index.md#supported-languages-and-frameworks)ごとに使用される[アナライザー](sast/analyzers.md)によって異なります。GitLab は、Semgrep ベースのアナライザーのルールセットを保持し、内部調査とユーザーフィードバックに基づいて定期的に更新します。他のアナライザーの場合、ルールセットはアップストリームのオープンソーススキャナーから供給されます。関連する更新プログラムが利用可能な場合、各アナライザーは少なくとも月に1回更新されます。 |

アナライザーの同じメジャーバージョンを使用するGitLabのバージョンでは、最新の脆弱性定義の恩恵を受けるためにそれらを更新する必要はありません。セキュリティツールはDockerイメージとしてリリースされます。それらを有効にするベンダーのジョブ定義は、[セマンティックバージョニング](https://semver.org/)に従ってメジャーリリースtagを使用します。ツールの新しいリリースごとに、これらのtagがオーバーライドされます。メジャーアナライザーバージョンでは、スキャンツールの最新バージョンが自動的に取得されますが、このアプローチにはいくつかの[既知のイシュー](https://gitlab.com/gitlab-org/gitlab/-/issues/9725)があります。

{{< alert type="note" >}}

既存の脆弱性に関する最新の脆弱性情報を入手するには、デフォルトブランチのパイプラインを再実行する必要がある場合があります。

{{< /alert >}}

## セキュリティスキャン

CI/CDパイプラインで実行されるセキュリティスキャンの場合、結果は以下によって決まります。

- パイプラインで実行されるセキュリティスキャンジョブ。
- 各ジョブの状態。
- 各ジョブの出力。

### パイプラインのセキュリティジョブ

CI/CDパイプラインで実行されるセキュリティスキャンジョブは、次の基準によって決定されます。

1. セキュリティスキャンテンプレートの組み込み

   セキュリティスキャンジョブの選択は、どのテンプレートが含まれているかによって最初に決定されます。テンプレートは、Auto DevOps、スキャン実行ポリシー、または`.gitlab-ci.yml`設定ファイルを使用して含めることができます。

1. ルールの評価

   各テンプレートには、アナライザーを実行するかどうかを決定する定義済みの[ルール](../../ci/yaml/_index.md#rules)があります。

   たとえば、シークレット検出テンプレートには次のルールが含まれています。このルールは、ブランチパイプラインでシークレット検出を実行する必要があることを示しています。マージリクエストパイプラインの場合、シークレット検出は実行されません。

   ```yaml
   rules:
     - if: $CI_COMMIT_BRANCH
   ```

1. アナライザーロジック

   テンプレートのルールでジョブを実行するように指示されている場合、テンプレートで指定されたパイプラインステージにジョブが作成されます。ただし、各アナライザーには、アナライザー自体を実行するかどうかを決定する独自のロジックがあります。

   たとえば、依存関係スキャンがデフォルトの深さでサポートされているファイルを検出しない場合、アナライザーは実行されず、アーティファクトは出力されません。

正常に完了すると、各ジョブはアーティファクトを出力します。これらのアーティファクトが処理され、結果がGitLabで利用可能になります。結果は、手動のものを含め、すべてのジョブが完了した場合にのみ表示されます。さらに、一部の機能では、結果はパイプラインがデフォルトブランチで実行される場合にのみ表示されます。

#### ジョブ状態

スキャンを完了できる場合、ジョブはパスします。_パス_の結果は、発見結果を特定したかどうかを示していません。唯一の例外はカバレッジファジングであり、発見結果を特定した場合に失敗します。

スキャンを完了できない場合、ジョブは失敗します。詳細については、パイプラインlogを表示してください。

すべてのジョブは、デフォルトで失敗することが許可されています。つまり、失敗してもパイプラインは失敗しません。

脆弱性がマージされるのを防ぎたい場合は、[マージリクエストでセキュリティ承認](#security-approvals-in-merge-requests)を追加する必要があります。これにより、選択した特定のグループからの承認なしに、不明な高または重大な発見結果がマージされるのを防ぎます。

ジョブ[`allow_failure`設定](../../ci/yaml/_index.md#allow_failure)を変更することはお勧めしません。パイプライン全体が失敗するためです。

#### ジョブアーティファクト

セキュリティスキャンジョブは、1つ以上のアーティファクトを生成する場合があります。GitLab 17.0以降、これらのアーティファクトは[`developer`ロール](../permissions.md#roles)に制限されています。

Secureアナライザーによって生成された[セキュリティレポート](../../development/integrations/secure.md#report)アーティファクトには、以前に発見されたか、無視されたか、完全に新しいかどうかにかかわらず、ターゲットブランチで見つかったすべての発見結果が含まれています（見つかったものをすべて入力します）。

## マージリクエストでのセキュリティ承認

{{< history >}}

- GitLab 15.0 で脆弱性チェック機能を[削除](https://gitlab.com/gitlab-org/gitlab/-/issues/357300)しました。
- GitLab 16.0 でライセンスチェック機能を[削除](https://gitlab.com/gitlab-org/gitlab/-/issues/397067)しました。

{{< /history >}}

次のセキュリティイシューのいずれかが発生するマージリクエストに追加の承認を強制できます。

- セキュリティの脆弱性。詳細については、[マージリクエスト承認ポリシー](policies/merge_request_approval_policies.md)をお読みください。

## Self-Managedインストールオプション

Self-Managedインストールの場合、[インターネットに接続していなくても](offline_deployments/_index.md)、ほとんどのGitLabセキュリティスキャナーを実行するように選択できます。

Self-Managedインストールでは、[OpenShift内で実行されている](../../install/openshift_and_gitlab/_index.md) GitLab Runnerでセキュリティスキャナーを実行することもできます。

## セキュリティレポートの検証

GitLab 15.0 は、脆弱性をインジェストする前に、セキュリティレポートアーティファクトの検証を強制します。これにより、破損した脆弱性データがデータベースに取り込まれるのを防ぎます。GitLabは、レポートで宣言されたスキーマバージョンに従って、[レポートスキーマ](https://gitlab.com/gitlab-org/security-products/security-report-schemas/-/tree/master/dist)に対してアーティファクトを検証します。

パイプラインの\[**セキュリティ**]タブには、検証に失敗したレポートアーティファクトと検証エラーメッセージが表示されます。

検証は、セキュリティレポートアーティファクトで宣言されたスキーマバージョンによって異なります。

- セキュリティレポートがサポートされているスキーマバージョンを指定している場合、GitLabはこのバージョンを使用して検証します。
- セキュリティレポートが非推奨のバージョンを使用している場合、GitLabはそのバージョンに対して検証を試み、検証結果に非推奨の警告を追加します。
- セキュリティレポートがレポートスキーマのサポートされているメジャーマイナーバージョンを使用しているが、パッチバージョンがベンダーバージョンと一致しない場合、GitLabはスキーマの最新のベンダーパッチバージョンに対して検証を試みます。
  - 例：セキュリティレポートはバージョン14.1.1を使用しますが、最新のベンダーバージョンは14.1.0です。GitLabは、スキーマバージョン14.1.0に対して検証します。
- セキュリティレポートがサポートされていないバージョンを使用している場合、GitLabはインストールで使用可能な最も古いスキーマバージョンに対して検証を試みますが、レポートはインジェストしません。
- セキュリティレポートがスキーマバージョンを指定していない場合、GitLabはGitLabで使用可能な最も古いスキーマバージョンに対して検証を試みます。`version`プロパティは必須であるため、この場合、検証は常に失敗しますが、他の検証エラーも存在する可能性があります。

サポートされているスキーマバージョンと非推奨のスキーマバージョンは、いつでも[ソースコード](https://gitlab.com/gitlab-org/gitlab/blob/master/lib/gitlab/ci/parsers/security/validators/schema_validator.rb)にあります。

## セキュリティスキャンの設定に関するヒント

各GitLabセキュリティスキャンツールには、_テンプレート_とも呼ばれるデフォルトの[CI/CD設定ファイル](https://gitlab.com/gitlab-org/gitlab/-/tree/master/lib/gitlab/ci/templates/Security)があります。

設定をカスタマイズする場合:

- スキャンツールのCI/CDテンプレートを[含めます](../../ci/yaml/_index.md#include)。テンプレートのコンテンツを_コピー_しないでください。
- 本番環境ワークフローには、各テンプレートの[安定した](../../development/cicd/templates.md#stable-version)バージョンを使用します。安定バージョンは変更頻度が低く、破壊的な変更は GitLab のメジャーバージョン間でのみ行われます。[最新](../../development/cicd/templates.md#latest-version)バージョンには最新の変更が含まれていますが、GitLab のマイナーバージョン間で大きな変更がある場合があります。
- 必要に応じて、テンプレートの値をオーバーライドするだけです。他のすべての値はテンプレートから継承されます。

### スキャン実行の強制

セキュリティおよびコンプライアンスチームは、セキュリティスキャンが次のことを保証する必要があります。

- すべてのプロジェクトで定期的に実行します。
- デベロッパーが無効にすることはできません。

GitLab はこれを実現するための 2 つの方法を提供しており、それぞれに長所と短所があります。

- [コンプライアンスフレームワークパイプライン](../compliance/compliance_pipelines.md)は、次の場合に推奨されます。

  - SAST IaC、DAST、依存関係スキャン、APIファジング、カバレッジガイド付きファジングなど、GitLabテンプレートを使用するスキャナーには、スキャン実行の強制が必要です。
  - GitLabの外部にあるスキャナーには、スキャン実行の強制が必要です。
  - セキュリティスキャン以外のカスタムジョブには、スキャン実行の強制が必要です。

- [スキャン実行ポリシー](policies/scan_execution_policies.md)は、次の場合に推奨されます。

  - DASTサイトまたはスキャンプロファイルを使用するDASTには、スキャン実行の強制が必要です。
  - プロジェクト固有の変数のカスタマイズを使用したSAST、SAST IaC、シークレット検出、依存関係スキャン、またはコンテナスキャンには、スキャン実行の強制が必要です。これを実現するには、ユーザーはプロジェクトごとに個別のセキュリティポリシーを作成する必要があります。
  - スキャンは、定期的なスケジュールされたケイデンスで実行する必要があります。

- どちらのソリューションも、次の場合に同等に使用できます。

  - プロジェクト固有の変数のカスタマイズがないコンテナスキャンには、スキャン実行の強制が必要です。

2つのソリューションの違いに関する追加の詳細を以下に示します。

| | コンプライアンスフレームワークパイプライン | スキャン実行ポリシー |
| ------ | ------ | ------ |
| **柔軟性** | CIファイルで実行できることをすべてサポートします。 | GitLab が明示的にサポートを追加した項目のみに制限されます。DAST、SAST、SAST IaC、シークレット検出、依存関係スキャン、およびコンテナスキャンがサポートされています。 |
| **ユーザビリティ** | CI YAMLの知識が必要です。 | `rules`および`actions`ベースのYAML構造に従います。 |
| **CIパイプラインへの組み込み** | コンプライアンスパイプラインは、プロジェクトの`.gitlab-ci.yml`ファイルの代わりに実行されます。プロジェクトの`.gitlab-ci.yml`ファイルを含めるには、`include`ステートメントを使用します。定義された変数は、含まれるプロジェクトのYAMLファイルによって上書きされることは許可されていません。 | CIパイプラインへの新しいジョブの強制的な組み込み。プロジェクトごとにカスタマイズする必要があるDASTジョブでは、プロジェクトレベルのサイトプロファイルとスキャンプロファイルを定義できます。職務分離（SoD）を確実にするために、これらのプロファイルはスキャン実行ポリシーで参照されている場合は変更できません。通常のCIジョブで使用できるのと同じ変数を使用して、セキュリティポリシーの一部としてすべてのジョブをカスタマイズできます。 |
| **スケジュール可能** | 各プロジェクトでスケジュールされたパイプラインを通じてスケジュールする必要があります。 | ポリシー設定自体を通じてネイティブにスケジュールできます。 |
| **職務分離（SoD）** | グループオーナーのみがコンプライアンスフレームワークラベルを作成できます。プロジェクトオーナーのみが、コンプライアンスフレームワークラベルをプロジェクトに適用できます。コンプライアンスパイプライン定義に対する変更を作成または承認する機能は、コンプライアンスパイプラインを含むプロジェクトへのアクセスを明示的に許可された個人に限定されます。 | プロジェクトオーナーのみが、リンクされたセキュリティポリシープロジェクトを定義できます。セキュリティポリシーに対する変更を作成または承認する機能は、セキュリティポリシープロジェクトへのアクセスを明示的に許可された個人に限定されます。 |
| **1つの標準を複数のプロジェクトに適用する機能** | 同じコンプライアンスフレームワークラベルをグループ内の複数のプロジェクトに適用できます。 | 同じセキュリティポリシープロジェクトを、同じグループに配置する必要なく、GitLab全体の複数のプロジェクトに使用できます。 |

[これらの2つの機能のユーザーエクスペリエンスを統合するための当社のビジョン](https://gitlab.com/groups/gitlab-org/-/epics/7312)に関するフィードバックをお待ちしております

## カスタムセキュリティロール

脆弱性管理、セキュリティポリシー、依存関係など、アプリケーションセキュリティ機能へのアクセスを必要とするセキュリティチームメンバー用に[カスタムロール](../custom_roles/_index.md)を作成できます。このアプローチにより、組織は、セキュリティチームメンバーに、グループまたはプロジェクトのデベロッパーまたはメンテナーに昇格させることなく必要な権限を提供することで、最小権限の原則に従うことができます。

たとえば、カスタムセキュリティロールには、次の[権限](../custom_roles/abilities.md)がある場合があります。

- 名前:カスタムセキュリティロール
- 説明:脆弱性を管理し、セキュリティポリシープロジェクトをリンクします。
- 基本ロール:レポーター（または任意のデフォルトロール）
- 権限：`admin_vulnerability`、`read_dependency`、`manage_security_policy_link`
