---
stage: none
group: Tutorials
info: For assistance with this tutorials page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments-to-other-projects-and-subjects.
description: Introduction to the product.
title: 'チュートリアル: GitLabの操作方法を理解する'
---

GitLabの機能とその機能がある場所を知ることで、すぐに使いこなせるようになります。

| トピック | 説明 | 初心者向け |
|-------|-------------|--------------------|
| [GitLab with Git Essentials](https://university.gitlab.com/courses/gitlab-with-git-essentials-s2)  |  この自主学習コースでGitとGitLabの基本を学びましょう。 | {{< icon name="star" >}} |
| <i class="fa fa-youtube-play youtube" aria-hidden="true"></i> [Use GitLab for DevOps（DevOpsにGitLabを使用する（英語））](https://www.youtube.com/watch?v=7q9Y1Cv-ib0)（12分34秒） | 計画からモニタリングまで、DevOpsライフサイクル全体でGitLabを使用します。 | {{< icon name="star" >}} |
| [左側のサイドバーを使用してGitLab内を移動する](left_sidebar/_index.md) |  GitLabのUIを操作してみましょう。 | {{< icon name="star" >}} |
| [GitLabでMarkdownを使用する](../user/markdown.md) |  GitLab Flavored Markdown（GLFM）は、マージリクエストなど、GitLabの多くの領域で使用されています。 | {{< icon name="star" >}} |
| <i class="fa fa-youtube-play youtube" aria-hidden="true"></i> [GitLab Continuous Delivery overview（GitLabの継続的デリバリーの概要（英語））](https://www.youtube.com/watch?v=M7rBDZYsx8U&list=PLFGfElNsQthYDx0A_FaNNfUm9NHsK6zED&index=193)（17分2秒） | GitLabの機能を使用して、反復的なコードの変更を継続的にビルド、テスト、およびデプロイする方法を学びましょう。 | |
| [生産性に関するヒント](https://about.gitlab.com/blog/2021/02/18/improve-your-gitlab-productivity-with-these-10-tips/) | 生産性の高いGitLabユーザーになるためのヒントをご覧ください。 | |
| <i class="fa fa-youtube-play youtube" aria-hidden="true"></i> [Introducing GitLab Service Desk（GitLabのサービスデスクのご紹介（英語））](https://www.youtube.com/watch?v=LDVQXv3I5rI)（6分50秒） | GitLabの[サービスデスク](../user/project/service_desk/_index.md)が、カスタマーサポートのワークフローを強化するための統合ヘルプデスクソリューションをどのように提供するかを学びましょう。このビデオでは、[カスタムメールアドレス](../user/project/service_desk/configure.md#custom-email-address)、[メールテンプレート](../user/project/service_desk/configure.md#customize-emails-sent-to-external-participants)、チケット管理、[コメントテンプレート](../user/profile/comment_templates.md)、[CRMのインテグレーション](../user/crm/_index.md)、スケジュールされたCI/CDパイプラインでの`gitlab-triage`を使用した自動化、分析と[インサイト](../user/project/insights/_index.md)などの主要な機能について説明します。 | |
