---
stage: Foundations
group: Import and Integrate
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: GraphQL APIのリソース
---

<!--
  This documentation is auto generated by a script.
  Please do not edit this file directly.

  To edit the introductory text, modify `tooling/graphql/docs/templates/default.md.haml`.

  Run `bundle exec rake gitlab:graphql:compile_docs`
  or check the `compile_docs` task in `lib/tasks/gitlab/graphql.rake`.
-->

このドキュメントは、GitLabの現在のGraphQLスキーマに基づいて自動生成されたものです。

APIについて調べるには、[インタラクティブGraphQLエクスプローラー](../_index.md#interactive-graphql-explorer)を使用することができます。デベロッパーは、[マシン読み取り可能GraphQLスキーマをIDL形式とJSON形式で生成](../../../development/rake_tasks.md#update-machine-readable-schema-files)することもできます。

以下の各表は、それぞれ1つのGraphQL型について記述しています。型は大まかに言ってモデルに対応していますが、モデルのすべてのフィールドとメソッドがGraphQL経由で利用できるわけではありません。

{{< alert type="warning" >}}

非推奨のフィールドには、{{< icon name="warning-solid" >}}が付いています。当社の[廃止プロセス](../_index.md#deprecation-and-removal-process)に従って削除された項目（フィールドやenumなど）は、[削除された項目](../removed_items.md)に記載されています。

{{< /alert >}}

<!-- vale off -->
<!-- Vale linting disabled after this line. -->
<!-- See https://docs.gitlab.com/ee/development/documentation/testing/vale.html#disable-vale-tests -->

<!-- markdownlint-disable MD044 -->
<!-- MD044/proper-names test disabled after this line to make page compatible with markdownlint-cli 0.29.0. -->
<!-- See https://docs.gitlab.com/ee/development/documentation/testing/markdownlint.html#disable-markdownlint-tests -->

## `Query`型

`Query`型には、すべての実行可能クエリに対するAPIのトップレベルのエントリポイントが含まれています。

### `Query.abuseReport`

不正行為レポートを検索します。

{{< details >}}GitLab 16.3で**導入**。**状態**: 実験。{{< /details >}}

[`AbuseReport`](#abusereport)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryabusereportid"></a>`id` | [`AbuseReportID!`](#abusereportid) | 不正行為レポートのID。 |

### `Query.abuseReportLabels`

不正行為レポートのラベル。

{{< details >}}GitLab 16.3で**導入**。**状態**: 実験。{{< /details >}}

[`AbuseReportLabelConnection`](#abusereportlabelconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryabusereportlabelssearchterm"></a>`searchTerm` | [`String`](#string) | ラベルを検索するための検索語句。 |

### `Query.addOnPurchase`

アクティブなアドオン購入を取得します。このクエリは、GitLab SaaS環境およびSelf-Managed環境で使用できます。

{{< details >}}GitLab 17.4で**非推奨**になりました。代わりに[addOnPurchases](#queryaddonpurchases)を使用してください。{{< /details >}}

[`AddOnPurchase`](#addonpurchase)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryaddonpurchaseaddontype"></a>`addOnType` | [`GitlabSubscriptionsAddOnType!`](#gitlabsubscriptionsaddontype) | アドオン購入のアドオンのタイプ。 |
| <a id="queryaddonpurchasenamespaceid"></a>`namespaceId` | [`NamespaceID`](#namespaceid) | アドオンが購入されたネームスペースのID。 |

### `Query.addOnPurchases`

アクティブなアドオン購入をすべて取得します。このクエリは、GitLab.com環境およびSelf-Managed環境で使用できます。

[`[AddOnPurchase!]`](#addonpurchase)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryaddonpurchasesnamespaceid"></a>`namespaceId` | [`NamespaceID`](#namespaceid) | アドオン購入の対象となるネームスペースのID。 |

### `Query.adminMemberRole`

インスタンスの単一の管理者カスタムロールを検索します。GitLab Self-Managedでのみ利用可能。

{{< details >}}GitLab 17.10で**導入**。**状態**: 実験。{{< /details >}}

[`AdminMemberRole`](#adminmemberrole)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryadminmemberroleid"></a>`id` | [`MemberRoleID`](#memberroleid) | 検索するメンバーロールのグローバルID。 |
| <a id="queryadminmemberroleids"></a>`ids` | [`[MemberRoleID!]`](#memberroleid) | 検索するメンバーロールの複数個のグローバルID。 |
| <a id="queryadminmemberroleorderby"></a>`orderBy` | [`MemberRolesOrderBy`](#memberrolesorderby) | 列の並べ替え。デフォルトはNAMEです。 |
| <a id="queryadminmemberrolesort"></a>`sort` | [`SortDirectionEnum`](#sortdirectionenum) | 列の並べ替え。デフォルトはASCです。 |

### `Query.adminMemberRolePermissions`

カスタマイズ可能な管理者権限すべてのリスト。

{{< details >}}GitLab 17.9で**導入**。**状態**: 実験。{{< /details >}}

[`CustomizableAdminPermissionConnection`](#customizableadminpermissionconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

### `Query.adminMemberRoles`

インスタンスで使用可能な管理者カスタムロール。GitLab Self-Managedでのみ利用可能。

{{< details >}}GitLab 17.10で**導入**。**状態**: 実験。{{< /details >}}

[`AdminMemberRoleConnection`](#adminmemberroleconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryadminmemberrolesid"></a>`id` | [`MemberRoleID`](#memberroleid) | 検索するメンバーロールのグローバルID。 |
| <a id="queryadminmemberrolesids"></a>`ids` | [`[MemberRoleID!]`](#memberroleid) | 検索するメンバーロールの複数個のグローバルID。 |
| <a id="queryadminmemberrolesorderby"></a>`orderBy` | [`MemberRolesOrderBy`](#memberrolesorderby) | 列の並べ替え。デフォルトはNAMEです。 |
| <a id="queryadminmemberrolessort"></a>`sort` | [`SortDirectionEnum`](#sortdirectionenum) | 列の並べ替え。デフォルトはASCです。 |

### `Query.aiConversationThreads`

AI機能の会話スレッドのリスト。

{{< details >}}GitLab 17.9で**導入**。**状態**: 実験。{{< /details >}}

[`AiConversationsThreadConnection!`](#aiconversationsthreadconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryaiconversationthreadsconversationtype"></a>`conversationType` | [`AiConversationsThreadsConversationType`](#aiconversationsthreadsconversationtype) | スレッドの会話タイプ。 |
| <a id="queryaiconversationthreadsid"></a>`id` | [`AiConversationThreadID`](#aiconversationthreadid) | スレッドのID。 |

### `Query.aiFeatureSettings`

設定可能なAI機能のリスト。

{{< details >}}GitLab 17.4で**導入**。**状態**: 実験。{{< /details >}}

[`AiFeatureSettingConnection`](#aifeaturesettingconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryaifeaturesettingsselfhostedmodelid"></a>`selfHostedModelId` | [`AiSelfHostedModelID`](#aiselfhostedmodelid) | セルフホストモデル.モデルのグローバルID。 |

### `Query.aiMessages`

GitLab Duo Chatのメッセージを検索します。

{{< details >}}GitLab 16.1で**導入**。**状態**: 実験。{{< /details >}}

[`AiMessageConnection!`](#aimessageconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryaimessagesagentversionid"></a>`agentVersionId` | [`AiAgentVersionID`](#aiagentversionid) | チャットに応答するエージェントのグローバルID。 |
| <a id="queryaimessagesconversationtype"></a>`conversationType` | [`AiConversationsThreadsConversationType`](#aiconversationsthreadsconversationtype) | スレッドの会話タイプ。 |
| <a id="queryaimessagesrequestids"></a>`requestIds` | [`[ID!]`](#id) | フェッチするリクエストIDの配列。 |
| <a id="queryaimessagesroles"></a>`roles` | [`[AiMessageRole!]`](#aimessagerole) | フェッチするロールの配列。 |
| <a id="queryaimessagesthreadid"></a>`threadId` | [`AiConversationThreadID`](#aiconversationthreadid) | 既存スレッドのグローバルID。指定されていない場合、指定されたconversation_typeの最後のスレッドを取得します。 |

### `Query.aiSelfHostedModels`

IDが指定されている場合はセルフホストモデルモデルを返し、それ以外の場合はすべてのモデルを返します。

{{< details >}}GitLab 17.1で**導入**。**状態**: 実験。{{< /details >}}

[`AiSelfHostedModelConnection`](#aiselfhostedmodelconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryaiselfhostedmodelsid"></a>`id` | [`AiSelfHostedModelID`](#aiselfhostedmodelid) | セルフホストモデルのグローバルID。 |

### `Query.aiSlashCommands`

特定のURLについて現在のユーザーが使用できるGitLab Duo Chatスラッシュ(/)コマンドを取得します。

[`[SlashCommand!]`](#slashcommand)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryaislashcommandsurl"></a>`url` | [`String!`](#string) | ユーザーが現在アクセスしているページのURL。 |

### `Query.auditEventDefinitions`

インスタンスで使用可能なすべての監査イベントの定義。

[`AuditEventDefinitionConnection!`](#auditeventdefinitionconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

### `Query.auditEventsInstanceAmazonS3Configurations`

監査イベントのインスタンスレベルのAmazon S3設定。

[`InstanceAmazonS3ConfigurationTypeConnection`](#instanceamazons3configurationtypeconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

### `Query.auditEventsInstanceStreamingDestinations`

インスタンスレベルの外部監査イベントストリーミングの宛先。

{{< details >}}GitLab 16.11で**導入**。**状態**: 実験。{{< /details >}}

[`InstanceAuditEventStreamingDestinationConnection`](#instanceauditeventstreamingdestinationconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

### `Query.blobSearch`

現在のユーザーに表示可能なコードを検索します。

{{< details >}}GitLab 17.2で**導入**。**状態**: 実験。{{< /details >}}

[`BlobSearch`](#blobsearch)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryblobsearchchunkcount"></a>`chunkCount` {{< icon name="warning-solid" >}} | [`Int`](#int) | GitLab 17.2で**導入**。**状態**: 実験。ファイルごとの最大チャンク数。 |
| <a id="queryblobsearchgroupid"></a>`groupId` {{< icon name="warning-solid" >}} | [`GroupID`](#groupid) | GitLab 17.2で**導入**。**状態**: 実験。検索するグループ。 |
| <a id="queryblobsearchincludearchived"></a>`includeArchived` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | GitLab 17.7で**導入**。**状態**: 実験。アーカイブされたプロジェクトを検索に含めます。プロジェクト検索では常にtrue。デフォルトはfalseです。 |
| <a id="queryblobsearchincludeforked"></a>`includeForked` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | GitLab 17.7で**導入**。**状態**: 実験。フォークしたプロジェクトを検索に含めます。プロジェクト検索では常にtrue。グローバル検索では利用不可。デフォルトはfalseです。 |
| <a id="queryblobsearchpage"></a>`page` {{< icon name="warning-solid" >}} | [`Int`](#int) | GitLab 17.2で**導入**。**状態**: 実験。結果をフェッチするページ番号。 |
| <a id="queryblobsearchperpage"></a>`perPage` {{< icon name="warning-solid" >}} | [`Int`](#int) | GitLab 17.2で**導入**。**状態**: 実験。ページあたりの結果数。 |
| <a id="queryblobsearchprojectid"></a>`projectId` {{< icon name="warning-solid" >}} | [`ProjectID`](#projectid) | GitLab 17.2で**導入**。**状態**: 実験。検索するプロジェクト。 |
| <a id="queryblobsearchregex"></a>`regex` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | GitLab 17.3で**導入**。**状態**: 実験。正規表現検索モードを使用します。デフォルトはfalseです。 |
| <a id="queryblobsearchrepositoryref"></a>`repositoryRef` {{< icon name="warning-solid" >}} | [`String`](#string) | GitLab 17.2で**導入**。**状態**: 実験。検索するリポジトリ参照。 |
| <a id="queryblobsearchsearch"></a>`search` | [`String!`](#string) | 検索語句。 |

### `Query.boardList`

イシューボードリストを検索します。

[`BoardList`](#boardlist)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryboardlistid"></a>`id` | [`ListID!`](#listid) | リストのグローバルID。 |
| <a id="queryboardlistissuefilters"></a>`issueFilters` | [`BoardIssueInput`](#boardissueinput) | ボードリストでイシューメタデータを取得する際に適用されるフィルター。 |

### `Query.ciApplicationSettings`

インスタンス全体に適用されるCI関連の設定。

[`CiApplicationSettings`](#ciapplicationsettings)を返します。

### `Query.ciCatalogResource`

認証済みユーザーに表示可能な単一のCI/CDカタログリソース。

{{< details >}}GitLab 16.1で**導入**。**状態**: 実験。{{< /details >}}

[`CiCatalogResource`](#cicatalogresource)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querycicatalogresourcefullpath"></a>`fullPath` | [`ID`](#id) | CI/CDカタログリソースのフルパス。 |
| <a id="querycicatalogresourceid"></a>`id` | [`CiCatalogResourceID`](#cicatalogresourceid) | CI/CDカタログリソースのグローバルID。 |

### `Query.ciCatalogResources`

認証済みユーザーに表示可能な、共通のネームスペース下のすべてのCI/CDカタログリソース。

{{< details >}}GitLab 15.11で**導入**。**状態**: 実験。{{< /details >}}

[`CiCatalogResourceConnection`](#cicatalogresourceconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querycicatalogresourcesscope"></a>`scope` | [`CiCatalogResourceScope`](#cicatalogresourcescope) | 返されるカタログリソースのスコープ。 |
| <a id="querycicatalogresourcessearch"></a>`search` | [`String`](#string) | カタログリソースを名前または説明でフィルタリングするための検索語句。 |
| <a id="querycicatalogresourcessort"></a>`sort` | [`CiCatalogResourceSort`](#cicatalogresourcesort) | 指定された基準でカタログリソースをソートします。 |
| <a id="querycicatalogresourcesverificationlevel"></a>`verificationLevel` | [`CiCatalogResourceVerificationLevel`](#cicatalogresourceverificationlevel) | 検証レベルでカタログリソースをフィルタリングします。 |

### `Query.ciConfig`

lintおよび処理されたCI設定内容。1回のリクエストで複数のリクエストはしないでください。

[`CiConfig`](#ciconfig)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryciconfigcontent"></a>`content` | [`String!`](#string) | `.gitlab-ci.yml`の内容。 |
| <a id="queryciconfigdryrun"></a>`dryRun` | [`Boolean`](#boolean) | パイプライン作成シミュレーションを実行するか、または静的チェックのみ実行します。 |
| <a id="queryciconfigprojectpath"></a>`projectPath` | [`ID!`](#id) | CI設定のプロジェクト。 |
| <a id="queryciconfigsha"></a>`sha` | [`String`](#string) | パイプラインのSHA。 |
| <a id="queryciconfigskipverifyprojectsha"></a>`skipVerifyProjectSha` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | GitLab 16.5で**導入**。**状態**: 実験。指定された`sha`はプロジェクトのリポジトリに見つかったが、それがGit参照（デタッチされたコミット）に関連付けられていない場合、検証は失敗し、検証エラーが返されます。それ以外の場合、`sha`が無効であっても検証は成功します。`true`に設定すると、この検証処理をスキップします。 |

### `Query.ciDedicatedHostedRunnerFilters`

GitLab Dedicated Runnerの使用状況データに使用可能なフィルターを返します。

[`CiDedicatedHostedRunnerFilters`](#cidedicatedhostedrunnerfilters)を返します。

### `Query.ciDedicatedHostedRunnerUsage`

GitLab Dedicatedにおいてさまざまなネームスペースに関するRunnerのコンピューティング使用状況データ。年または請求月が指定されていない場合のデフォルトは、現在の年。Ultimateのみ。

[`CiDedicatedHostedRunnerUsageConnection`](#cidedicatedhostedrunnerusageconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querycidedicatedhostedrunnerusagebillingmonth"></a>`billingMonth` | [`Date`](#date) | データを取得する対象月の最初の日。 |
| <a id="querycidedicatedhostedrunnerusagegrouping"></a>`grouping` | [`GroupingEnum`](#groupingenum) | インスタンスの集計またはルートネームスペースによって使用状況データをグループ化します。 |
| <a id="querycidedicatedhostedrunnerusagerunnerid"></a>`runnerId` | [`CiRunnerID`](#cirunnerid) | データ取得対象のRunner ID。 |
| <a id="querycidedicatedhostedrunnerusageyear"></a>`year` | [`Int`](#int) | データ取得対象の年。 |

### `Query.ciMinutesUsage`

ネームスペースのコンピューティング使用状況データ。

[`CiMinutesNamespaceMonthlyUsageConnection`](#ciminutesnamespacemonthlyusageconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryciminutesusagedate"></a>`date` | [`Date`](#date) | 使用状況データを取得する対象の日付。月の最初の日でなければなりません。 |
| <a id="queryciminutesusagenamespaceid"></a>`namespaceId` | [`NamespaceID`](#namespaceid) | 月間コンピューティング使用状況のネームスペースのグローバルID。 |

### `Query.ciPipelineStage`

CIパイプラインに属するステージ。

[`CiStage`](#cistage)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querycipipelinestageid"></a>`id` | [`CiStageID!`](#cistageid) | CIステージのグローバルID。 |

### `Query.ciQueueingHistory`

RunnerがCIジョブを百分位で選択するのにかかる時間。このクエリを使用するには、ClickHouseデータベースバックエンドを有効にしてください。

{{< details >}}GitLab 16.4で**導入**。**状態**: 実験。{{< /details >}}

[`QueueingDelayHistory`](#queueingdelayhistory)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryciqueueinghistoryfromtime"></a>`fromTime` | [`Time`](#time) | リクエスト対象時間の開始時刻。デフォルトは3時間前です。 |
| <a id="queryciqueueinghistoryrunnertype"></a>`runnerType` | [`CiRunnerType`](#cirunnertype) | ジョブを実行したRunnerのタイプでジョブをフィルタリングします。 |
| <a id="queryciqueueinghistorytotime"></a>`toTime` | [`Time`](#time) | リクエスト対象時間の終了時刻。デフォルトは現在の時刻です。 |

### `Query.ciVariables`

インスタンスのCI/CD変数のリスト。

[`CiInstanceVariableConnection`](#ciinstancevariableconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querycivariablessort"></a>`sort` | [`CiVariableSort`](#civariablesort) | 結果のソート順。 |

### `Query.cloudConnectorStatus`

Cloud Connector機能についての一連の状態チェックを実行します。

{{< details >}}GitLab 17.3で**導入**。**状態**: 実験。{{< /details >}}

[`CloudConnectorStatus`](#cloudconnectorstatus)を返します。

### `Query.complianceRequirementControls`

コンプライアンス要件コントロールすべてのリストを取得します。

[`ComplianceRequirementControl`](#compliancerequirementcontrol)を返します。

### `Query.containerRepository`

コンテナリポジトリを検索します。

[`ContainerRepositoryDetails`](#containerrepositorydetails)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querycontainerrepositoryid"></a>`id` | [`ContainerRepositoryID!`](#containerrepositoryid) | コンテナリポジトリのグローバルID。 |

### `Query.currentLicense`

現在のライセンスに関連するフィールド。

[`CurrentLicense`](#currentlicense)を返します。

### `Query.currentUser`

現在のユーザーに関する情報を取得します。

[`CurrentUser`](#currentuser)を返します。

### `Query.customField`

カスタムフィールドをIDで検索します。機能フラグ`custom_fields_feature`が有効な場合にのみ使用可能。

{{< details >}}GitLab 17.10で**導入**。**状態**: 実験。{{< /details >}}

[`CustomField`](#customfield)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querycustomfieldid"></a>`id` | [`IssuablesCustomFieldID!`](#issuablescustomfieldid) | カスタムフィールドのグローバルID。 |

### `Query.designManagement`

設計監理に関連するフィールド。

[`DesignManagement!`](#designmanagement)を返します。

### `Query.devopsAdoptionEnabledNamespaces`

設定されているDevOpsアドプションネームスペースを取得します。**状態: **ベータ版。このエンドポイントは、予告なしに変更される場合があります。

[`DevopsAdoptionEnabledNamespaceConnection`](#devopsadoptionenablednamespaceconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querydevopsadoptionenablednamespacesdisplaynamespaceid"></a>`displayNamespaceId` | [`NamespaceID`](#namespaceid) | 表示ネームスペースでフィルタリングします。 |

### `Query.duoSettings`

GitLab Duoの設定を取得します。

{{< details >}}GitLab 17.9で**導入**。**状態**: 実験。{{< /details >}}

[`DuoSettings`](#duosettings)を返します。

### `Query.duoWorkflowEvents`

GitLab Duo Workflowのイベントを一覧表示します。

{{< details >}}GitLab 17.2で**導入**。**状態**: 実験。{{< /details >}}

[`DuoWorkflowEventConnection!`](#duoworkfloweventconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryduoworkfloweventsworkflowid"></a>`workflowId` | [`AiDuoWorkflowsWorkflowID!`](#aiduoworkflowsworkflowid) | フェッチするリクエストIDの配列。 |

### `Query.duoWorkflowWorkflows`

現在のユーザーがオーナーであるワークフローを一覧表示します。

{{< details >}}GitLab 17.2で**導入**。**状態**: 実験。{{< /details >}}

[`DuoWorkflowConnection!`](#duoworkflowconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryduoworkflowworkflowsprojectpath"></a>`projectPath` | [`ID`](#id) | ワークフローを含むプロジェクトのフルパス。 |

### `Query.echo`

APIの検証に使用するテストエンドポイント。

[`String!`](#string)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryechotext"></a>`text` | [`String!`](#string) | エコーバックするテキスト。 |

### `Query.epicBoardList`

[`EpicList`](#epiclist)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryepicboardlistepicfilters"></a>`epicFilters` | [`EpicFilters`](#epicfilters) | エピックボードリストでエピックメタデータを取得する際に適用されるフィルター。 |
| <a id="queryepicboardlistid"></a>`id` | [`BoardsEpicListID!`](#boardsepiclistid) | リストのグローバルID。 |

### `Query.featureFlagEnabled`

機能フラグが有効になっているかどうかを確認します。

{{< details >}}GitLab 17.4で**非推奨**になりました。metadata.featureFlagsに置き換えられました。{{< /details >}}

[`Boolean!`](#boolean)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryfeatureflagenabledname"></a>`name` | [`String!`](#string) | 機能フラグの名前。 |

### `Query.frecentGroups`

ユーザーが最近アクセスしたグループ。

[`[Group!]`](#group)を返します。

### `Query.frecentProjects`

ユーザーが最近アクセスしたプロジェクト。

[`[Project!]`](#project)を返します。

### `Query.geoNode`

Geoノードを検索します。

[`GeoNode`](#geonode)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querygeonodename"></a>`name` | [`String`](#string) | Geoノードの名前。デフォルトは現在のGeoノードの名前です。 |

### `Query.gitpodEnabled`

アプリケーション設定でGitpodが有効になっているかどうか。

[`Boolean`](#boolean)を返します。

### `Query.googleCloudArtifactRegistryRepositoryArtifact`

Google Artifact Registryに含まれるアーティファクトに関する詳細。

{{< details >}}GitLab 16.10で**導入**。**状態**: 実験。{{< /details >}}

[`GoogleCloudArtifactRegistryArtifactDetails`](#googlecloudartifactregistryartifactdetails)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querygooglecloudartifactregistryrepositoryartifactgooglecloudprojectid"></a>`googleCloudProjectId` | [`String!`](#string) | Google CloudプロジェクトのID。 |
| <a id="querygooglecloudartifactregistryrepositoryartifactimage"></a>`image` | [`String!`](#string) | Google Artifact Registryのイメージの名前。 |
| <a id="querygooglecloudartifactregistryrepositoryartifactlocation"></a>`location` | [`String!`](#string) | Artifact Registryリポジトリの場所。 |
| <a id="querygooglecloudartifactregistryrepositoryartifactprojectpath"></a>`projectPath` | [`ID!`](#id) | プロジェクトのフルパス。 |
| <a id="querygooglecloudartifactregistryrepositoryartifactrepository"></a>`repository` | [`String!`](#string) | Google Artifact Registryのリポジトリ。 |

### `Query.group`

グループを検索します。

[`Group`](#group)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querygroupfullpath"></a>`fullPath` | [`ID!`](#id) | グループのフルパス。例：`gitlab-org/gitlab-foss`。 |

### `Query.groups`

グループを検索します。

[`GroupConnection`](#groupconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querygroupsallavailable"></a>`allAvailable` | [`Boolean`](#boolean) | `true`の場合、アクセス可能なすべてのグループを返します。`false`の場合、ユーザーがメンバーであるグループのみを返します。非認証のリクエストでは、常に全パブリックグループが返されます。`owned_only`引数が優先されます。 |
| <a id="querygroupsids"></a>`ids` | [`[ID!]`](#id) | グループをIDでフィルタリングします。 |
| <a id="querygroupsmarkedfordeletionon"></a>`markedForDeletionOn` | [`Date`](#date) | グループが削除対象としてマークされた日付。 |
| <a id="querygroupsownedonly"></a>`ownedOnly` | [`Boolean`](#boolean) | 現在のユーザーがオーナーロールを付与されているグループのみを含めます。 |
| <a id="querygroupsparentpath"></a>`parentPath` | [`ID`](#id) | 親グループのフルパス。 |
| <a id="querygroupssearch"></a>`search` | [`String`](#string) | グループ名またはグループのフルパスの検索クエリ。 |
| <a id="querygroupssort"></a>`sort` | [`String`](#string) | 結果のソート順。形式：`<field_name>_<sort_direction>`（`id_desc`や`name_asc`など）。 |
| <a id="querygroupstoplevelonly"></a>`topLevelOnly` | [`Boolean`](#boolean) | トップレベルグループのみを含めます。 |

### `Query.instanceExternalAuditEventDestinations`

インスタンスレベルの外部監査イベントの宛先。

[`InstanceExternalAuditEventDestinationConnection`](#instanceexternalauditeventdestinationconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

### `Query.instanceGoogleCloudLoggingConfigurations`

インスタンスレベルでのGoogle Cloudログの生成の設定。

[`InstanceGoogleCloudLoggingConfigurationTypeConnection`](#instancegooglecloudloggingconfigurationtypeconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

### `Query.instanceSecurityDashboard`

インスタンスセキュリティダッシュボードに関連するフィールド。

[`InstanceSecurityDashboard`](#instancesecuritydashboard)を返します。

### `Query.integrationExclusions`

{{< details >}}GitLab 17.0で**導入**。**状態**: 実験。{{< /details >}}

[`IntegrationExclusionConnection`](#integrationexclusionconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryintegrationexclusionsintegrationname"></a>`integrationName` | [`IntegrationType!`](#integrationtype) | インテグレーションのタイプ。 |

### `Query.issue`

イシューを検索します。

[`Issue`](#issue)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryissueid"></a>`id` | [`IssueID!`](#issueid) | イシューのグローバルID。 |

### `Query.issues`

現在のユーザーに表示可能なイシューを検索します。少なくとも1つのフィルターを指定する必要があります。

{{< details >}}GitLab 15.6で**導入**。**状態**: 実験。{{< /details >}}

[`IssueConnection`](#issueconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryissuesassigneeid"></a>`assigneeId` | [`String`](#string) | イシューに割り当てられているユーザーのID。ワイルドカード値「NONE」と「ANY」がサポートされています。 |
| <a id="queryissuesassigneeusername"></a>`assigneeUsername` {{< icon name="warning-solid" >}} | [`String`](#string) | GitLab 13.11で**非推奨**になりました。`assigneeUsernames`を使用してください。 |
| <a id="queryissuesassigneeusernames"></a>`assigneeUsernames` | [`[String!]`](#string) | イシューに割り当てられているユーザーのユーザー名。 |
| <a id="queryissuesassigneewildcardid"></a>`assigneeWildcardId` | [`AssigneeWildcardId`](#assigneewildcardid) | 割り当て先ユーザーのワイルドカードでフィルタリングします。assigneeUsernameともassigneeUsernamesとも互換性がありません。 |
| <a id="queryissuesauthorusername"></a>`authorUsername` | [`String`](#string) | イシューの作成者のユーザー名。 |
| <a id="queryissuesclosedafter"></a>`closedAfter` | [`Time`](#time) | 指定日付より後に完了したイシュー。 |
| <a id="queryissuesclosedbefore"></a>`closedBefore` | [`Time`](#time) | 指定日付より前に完了したイシュー。 |
| <a id="queryissuesconfidential"></a>`confidential` | [`Boolean`](#boolean) | 機密情報イシューについてフィルタリングします。「false」の場合、機密情報イシューを除外します。「true」の場合、機密情報イシューのみを返します。 |
| <a id="queryissuescreatedafter"></a>`createdAfter` | [`Time`](#time) | 指定日付より後に作成されたイシュー。 |
| <a id="queryissuescreatedbefore"></a>`createdBefore` | [`Time`](#time) | 指定日付より前に作成されたイシュー。 |
| <a id="queryissuescrmcontactid"></a>`crmContactId` | [`String`](#string) | イシューに割り当てられている連絡先のID。 |
| <a id="queryissuescrmorganizationid"></a>`crmOrganizationId` | [`String`](#string) | イシューに割り当てられている組織のID。 |
| <a id="queryissuescustomfield"></a>`customField` {{< icon name="warning-solid" >}} | [`[WorkItemWidgetCustomFieldFilterInputType!]`](#workitemwidgetcustomfieldfilterinputtype) | GitLab 17.10で**導入**。**状態**: 実験。カスタムフィールドでフィルタリングします。 |
| <a id="queryissuesdueafter"></a>`dueAfter` | [`Time`](#time) | 指定時刻以降に期限が切れるイシューを返します。 |
| <a id="queryissuesduebefore"></a>`dueBefore` | [`Time`](#time) | 指定時刻以前に期限が切れるイシューを返します。 |
| <a id="queryissuesepicid"></a>`epicId` | [`String`](#string) | イシューに関連付けられているエピックのID。「none」と「any」の値がサポートされています。 |
| <a id="queryissuesepicwildcardid"></a>`epicWildcardId` | [`EpicWildcardId`](#epicwildcardid) | エピックIDのワイルドカードでフィルタリングします。epicIdと互換性がありません。 |
| <a id="queryissueshealthstatusfilter"></a>`healthStatusFilter` | [`HealthStatusFilter`](#healthstatusfilter) | イシューのヘルスステータス。「none」と「any」の値がサポートされています。 |
| <a id="queryissuesiid"></a>`iid` | [`String`](#string) | イシューのIID。例：「1」。 |
| <a id="queryissuesiids"></a>`iids` | [`[String!]`](#string) | イシューのIIDのリスト。例：`["1", "2"]`。 |
| <a id="queryissuesin"></a>`in` | [`[IssuableSearchableField!]`](#issuablesearchablefield) | 検索を実行するフィールドを指定します。デフォルトは`[TITLE, DESCRIPTION]`です。`search`引数が必要です。 |
| <a id="queryissuesincludearchived"></a>`includeArchived` | [`Boolean`](#boolean) | アーカイブされたプロジェクトからのイシューを含めるかどうか。デフォルトは`false`です。 |
| <a id="queryissuesincludesubepics"></a>`includeSubepics` | [`Boolean`](#boolean) | epicIdでイシューをフィルタリングする際にサブエピックを含めるかどうか。 |
| <a id="queryissuesiterationcadenceid"></a>`iterationCadenceId` | [`[IterationsCadenceID!]`](#iterationscadenceid) | イテレーションケイデンスIDのリストでフィルタリングします。 |
| <a id="queryissuesiterationid"></a>`iterationId` | [`[ID]`](#id) | イシューに適用されるイテレーショングローバルIDのリスト。 |
| <a id="queryissuesiterationtitle"></a>`iterationTitle` | [`String`](#string) | イテレーションのタイトルでフィルタリングします。 |
| <a id="queryissuesiterationwildcardid"></a>`iterationWildcardId` | [`IterationWildcardId`](#iterationwildcardid) | イテレーションIDのワイルドカードでフィルタリングします。 |
| <a id="queryissueslabelname"></a>`labelName` | [`[String]`](#string) | イシューに適用されるラベル。 |
| <a id="queryissuesmilestonetitle"></a>`milestoneTitle` | [`[String]`](#string) | イシューに適用されるマイルストーン。 |
| <a id="queryissuesmilestonewildcardid"></a>`milestoneWildcardId` | [`MilestoneWildcardId`](#milestonewildcardid) | マイルストーンIDのワイルドカードでイシューをフィルタリングします。 |
| <a id="queryissuesmyreactionemoji"></a>`myReactionEmoji` | [`String`](#string) | 現在のユーザーが適用したリアクション絵文字でフィルタリングします。ワイルドカード値「NONE」と「ANY」がサポートされています。 |
| <a id="queryissuesnot"></a>`not` | [`NegatedIssueFilterInput`](#negatedissuefilterinput) | 否定条件となる引数。 |
| <a id="queryissuesor"></a>`or` | [`UnionedIssueFilterInput`](#unionedissuefilterinput) | 引数のリストのインクルーシブOR結合。 |
| <a id="queryissuessearch"></a>`search` | [`String`](#string) | タイトルまたは説明の検索クエリ。 |
| <a id="queryissuessort"></a>`sort` | [`IssueSort`](#issuesort) | 基準でイシューをソートします。 |
| <a id="queryissuesstate"></a>`state` | [`IssuableState`](#issuablestate) | イシューの現在の状態。 |
| <a id="queryissuessubscribed"></a>`subscribed` | [`SubscriptionStatus`](#subscriptionstatus) | 現在のユーザーがサブスクライブしているイシュー。 |
| <a id="queryissuestypes"></a>`types` | [`[IssueType!]`](#issuetype) | 指定されたイシュータイプでイシューをフィルタリングします。 |
| <a id="queryissuesupdatedafter"></a>`updatedAfter` | [`Time`](#time) | 指定日付より後に更新されたイシュー。 |
| <a id="queryissuesupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | 指定日付より前に更新されたイシュー。 |
| <a id="queryissuesweight"></a>`weight` | [`String`](#string) | イシューに適用されるウェイト。「none」と「any」の値がサポートされています。 |
| <a id="queryissuesweightwildcardid"></a>`weightWildcardId` | [`WeightWildcardId`](#weightwildcardid) | ウェイトIDのワイルドカードでフィルタリングします。weightと互換性がありません。 |

### `Query.iteration`

イテレーションを検索します。

[`Iteration`](#iteration)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryiterationid"></a>`id` | [`IterationID!`](#iterationid) | イテレーションをIDで検索します。 |

### `Query.jobs`

このGitLabインスタンス上のすべてのジョブ。管理者アクセス権のないユーザーには空の結果が返されます。

[`CiJobConnection`](#cijobconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryjobsfailurereason"></a>`failureReason` {{< icon name="warning-solid" >}} | [`CiJobFailureReason`](#cijobfailurereason) | GitLab 16.4で**導入**。**状態**: 実験。失敗理由でジョブをフィルタリングします。現在、`RUNNER_SYSTEM_FAILURE`と`runnerTypes: INSTANCE_TYPE`の組み合わせのみサポートされています。 |
| <a id="queryjobsrunnertypes"></a>`runnerTypes` {{< icon name="warning-solid" >}} | [`[CiRunnerType!]`](#cirunnertype) | GitLab 16.4で**導入**。**状態**: 実験。機能フラグ`:admin_jobs_filter_runner_type`が有効になっている場合に、Runnerのタイプでジョブをフィルタリングします。 |
| <a id="queryjobsstatuses"></a>`statuses` | [`[CiJobStatus!]`](#cijobstatus) | ジョブを状態でフィルタリングします。 |

### `Query.ldapAdminRoleLinks`

LDAP管理者リンク。GitLab Self-Managedでのみ利用可能。

{{< details >}}GitLab 17.11で**導入**。**状態**: 実験。{{< /details >}}

[`LdapAdminRoleLinkConnection`](#ldapadminrolelinkconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

### `Query.licenseHistoryEntries`

ライセンス履歴のエントリに関連するフィールド。

[`LicenseHistoryEntryConnection`](#licensehistoryentryconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

### `Query.memberRole`

インスタンスの単一のカスタムロールを検索します。GitLab Self-Managedでのみ利用可能。

{{< details >}}GitLab 16.6で**導入**。**状態**: 実験。{{< /details >}}

[`MemberRole`](#memberrole)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querymemberroleid"></a>`id` | [`MemberRoleID`](#memberroleid) | 検索するメンバーロールのグローバルID。 |
| <a id="querymemberroleids"></a>`ids` | [`[MemberRoleID!]`](#memberroleid) | 検索するメンバーロールの複数個のグローバルID。 |
| <a id="querymemberroleorderby"></a>`orderBy` | [`MemberRolesOrderBy`](#memberrolesorderby) | 列の並べ替え。デフォルトはNAMEです。 |
| <a id="querymemberrolesort"></a>`sort` | [`SortDirectionEnum`](#sortdirectionenum) | 列の並べ替え。デフォルトはASCです。 |

### `Query.memberRolePermissions`

標準のカスタマイズ可能権限すべてのリスト。

{{< details >}}GitLab 16.4で**導入**。**状態**: 実験。{{< /details >}}

[`CustomizableStandardPermissionConnection`](#customizablestandardpermissionconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

### `Query.memberRoles`

インスタンスで使用可能なカスタムロール。GitLab Self-Managedでのみ利用可能。

{{< details >}}GitLab 16.7で**導入**。**状態**: 実験。{{< /details >}}

[`MemberRoleConnection`](#memberroleconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querymemberrolesid"></a>`id` | [`MemberRoleID`](#memberroleid) | 検索するメンバーロールのグローバルID。 |
| <a id="querymemberrolesids"></a>`ids` | [`[MemberRoleID!]`](#memberroleid) | 検索するメンバーロールの複数個のグローバルID。 |
| <a id="querymemberrolesorderby"></a>`orderBy` | [`MemberRolesOrderBy`](#memberrolesorderby) | 列の並べ替え。デフォルトはNAMEです。 |
| <a id="querymemberrolessort"></a>`sort` | [`SortDirectionEnum`](#sortdirectionenum) | 列の並べ替え。デフォルトはASCです。 |

### `Query.mergeRequest`

マージリクエストを検索します。

[`MergeRequest`](#mergerequest)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querymergerequestid"></a>`id` | [`MergeRequestID!`](#mergerequestid) | マージリクエストのグローバルID。 |

### `Query.metadata`

GitLabに関するメタデータ。

[`Metadata`](#metadata)を返します。

### `Query.milestone`

マイルストーンを検索します。

[`Milestone`](#milestone)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querymilestoneid"></a>`id` | [`MilestoneID!`](#milestoneid) | マイルストーンをIDで検索します。 |

### `Query.mlExperiment`

機械学習の実験を検索します。

[`MlExperiment`](#mlexperiment)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querymlexperimentid"></a>`id` | [`MlExperimentID!`](#mlexperimentid) | 実験のID。 |

### `Query.mlModel`

機械学習モデルを検索します。

{{< details >}}GitLab 16.7で**導入**。**状態**: 実験。{{< /details >}}

[`MlModel`](#mlmodel)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querymlmodelid"></a>`id` | [`MlModelID!`](#mlmodelid) | モデルのID。 |

### `Query.namespace`

ネームスペースを検索します。

[`Namespace`](#namespace)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querynamespacefullpath"></a>`fullPath` | [`ID!`](#id) | ネームスペースのフルパス。例：`gitlab-org/gitlab-foss`。 |

### `Query.note`

ノートを検索します。

{{< details >}}GitLab 15.9で**導入**。**状態**: 実験。{{< /details >}}

[`Note`](#note)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querynoteid"></a>`id` | [`NoteID!`](#noteid) | ノートのグローバルID。 |

### `Query.organization`

組織を検索します。

{{< details >}}GitLab 16.4で**導入**。**状態**: 実験。{{< /details >}}

[`Organization`](#organization)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryorganizationid"></a>`id` | [`OrganizationsOrganizationID!`](#organizationsorganizationid) | 組織のID。 |

### `Query.organizations`

組織を一覧表示します。

{{< details >}}GitLab 16.8で**導入**。**状態**: 実験。{{< /details >}}

[`OrganizationConnection`](#organizationconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

### `Query.package`

パッケージを検索します。このフィールドは、1回のリクエストにつき1つのクエリに対してのみ解決できます。パッケージに`default`の状態がない場合、`null`を返します。

[`PackageDetailsType`](#packagedetailstype)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querypackageid"></a>`id` | [`PackagesPackageID!`](#packagespackageid) | パッケージのグローバルID。 |

### `Query.project`

プロジェクトを検索します。

[`Project`](#project)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryprojectfullpath"></a>`fullPath` | [`ID!`](#id) | プロジェクトのフルパス。例：`gitlab-org/gitlab-foss`。 |

### `Query.projectSecret`

特定のプロジェクトシークレットを表示します。

{{< details >}}GitLab 17.9で**導入**。**状態**: 実験。{{< /details >}}

[`ProjectSecret`](#projectsecret)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryprojectsecretname"></a>`name` | [`String!`](#string) | 表示するプロジェクトシークレットの名前。 |
| <a id="queryprojectsecretprojectpath"></a>`projectPath` | [`ID!`](#id) | シークレットが属するプロジェクト。 |

### `Query.projectSecrets`

プロジェクトシークレットを一覧表示します。

{{< details >}}GitLab 17.8で**導入**。**状態**: 実験。{{< /details >}}

[`ProjectSecretConnection`](#projectsecretconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryprojectsecretsprojectpath"></a>`projectPath` | [`ID!`](#id) | シークレットが属するプロジェクト。 |

### `Query.projectSecretsManager`

プロジェクトシークレットマネージャーを検索します。

{{< details >}}GitLab 17.4で**導入**。**状態**: 実験。{{< /details >}}

[`ProjectSecretsManager`](#projectsecretsmanager)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryprojectsecretsmanagerprojectpath"></a>`projectPath` | [`ID!`](#id) | シークレットマネージャーのプロジェクト。 |

### `Query.projects`

現在のユーザーに表示可能なプロジェクトを検索します。

[`ProjectConnection`](#projectconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryprojectsaimedfordeletion"></a>`aimedForDeletion` | [`Boolean`](#boolean) | 削除対象としてマークされているプロジェクトのみを返します。 |
| <a id="queryprojectsarchived"></a>`archived` | [`ProjectArchived`](#projectarchived) | アーカイブされた状態によりプロジェクトをフィルタリングします。 |
| <a id="queryprojectsfullpaths"></a>`fullPaths` | [`[String!]`](#string) | プロジェクトをフルパスでフィルタリングします。50を超えるフルパスを指定することはできません。 |
| <a id="queryprojectsids"></a>`ids` | [`[ID!]`](#id) | プロジェクトをIDでフィルタリングします。 |
| <a id="queryprojectsincludehidden"></a>`includeHidden` | [`Boolean`](#boolean) | 非表示のプロジェクトを含めます。 |
| <a id="queryprojectsmarkedfordeletionon"></a>`markedForDeletionOn` | [`Date`](#date) | プロジェクトが削除対象としてマークされた日付。 |
| <a id="queryprojectsmembership"></a>`membership` | [`Boolean`](#boolean) | 現在のユーザーをメンバーするプロジェクトのみを返します。 |
| <a id="queryprojectsminaccesslevel"></a>`minAccessLevel` | [`AccessLevelEnum`](#accesslevelenum) | 現在のユーザーに付与されているアクセスレベルが指定されたアクセスレベル以上であるプロジェクトのみを返します。 |
| <a id="queryprojectsnotaimedfordeletion"></a>`notAimedForDeletion` | [`Boolean`](#boolean) | 削除対象としてマークされているプロジェクトを除外します。 |
| <a id="queryprojectspersonal"></a>`personal` | [`Boolean`](#boolean) | 個人用プロジェクトのみを返します。 |
| <a id="queryprojectsprogramminglanguagename"></a>`programmingLanguageName` | [`String`](#string) | プロジェクトをプログラミング言語名でフィルタリングします（大文字と小文字は区別されません）。cssやrubyなど。 |
| <a id="queryprojectssearch"></a>`search` | [`String`](#string) | プロジェクト名、パス、または説明の検索クエリ。 |
| <a id="queryprojectssearchnamespaces"></a>`searchNamespaces` | [`Boolean`](#boolean) | プロジェクト検索にネームスペースを含めます。 |
| <a id="queryprojectssort"></a>`sort` | [`String`](#string) | 結果のソート順。形式：`<field_name>_<sort_direction>`（`id_desc`や`name_asc`など）。 |
| <a id="queryprojectstopics"></a>`topics` | [`[String!]`](#string) | プロジェクトをトピックでフィルタリングします。 |
| <a id="queryprojectstrending"></a>`trending` | [`Boolean`](#boolean) | トレンド中のプロジェクトのみを返します。 |
| <a id="queryprojectswithissuesenabled"></a>`withIssuesEnabled` | [`Boolean`](#boolean) | イシューが有効になっているプロジェクトのみを返します。 |
| <a id="queryprojectswithmergerequestsenabled"></a>`withMergeRequestsEnabled` | [`Boolean`](#boolean) | マージリクエストが有効になっているプロジェクトのみを返します。 |

### `Query.queryComplexity`

GraphQLクエリの複雑さに関する情報。

[`QueryComplexity`](#querycomplexity)を返します。

### `Query.runner`

Runnerを検索します。

[`CiRunner`](#cirunner)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryrunnerid"></a>`id` | [`CiRunnerID!`](#cirunnerid) | RunnerのID。 |

### `Query.runnerPlatforms`

サポートされているRunnerプラットフォーム。

{{< details >}}GitLab 15.9で**非推奨**になりました。使用されなくなりました。サポートされているプラットフォームについては、gitlab-Runnerのドキュメントを参照してください。{{< /details >}}

[`RunnerPlatformConnection`](#runnerplatformconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

### `Query.runnerSetup`

Runnerの設定手順。

{{< details >}}GitLab 15.9で**非推奨**になりました。使用されなくなりました。Runnerの登録コマンドについては、gitlab-Runnerのドキュメントを参照してください。{{< /details >}}

[`RunnerSetup`](#runnersetup)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryrunnersetuparchitecture"></a>`architecture` | [`String!`](#string) | 手順を生成する対象のアーキテクチャ。 |
| <a id="queryrunnersetupgroupid"></a>`groupId` {{< icon name="warning-solid" >}} | [`GroupID`](#groupid) | GitLab 13.11で**非推奨**になりました。使用されなくなりました。 |
| <a id="queryrunnersetupplatform"></a>`platform` | [`String!`](#string) | 手順を生成する対象のプラットフォーム。 |
| <a id="queryrunnersetupprojectid"></a>`projectId` {{< icon name="warning-solid" >}} | [`ProjectID`](#projectid) | GitLab 13.11で**非推奨**になりました。使用されなくなりました。 |

### `Query.runnerUsage`

RunnerごとのRunner使用状況。このクエリを使用するには、ClickHouseデータベースバックエンドを有効にしてください。

[`[CiRunnerUsage!]`](#cirunnerusage)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryrunnerusagefromdate"></a>`fromDate` | [`Date`](#date) | リクエストされた日付フレームの開始日。デフォルトは、カレンダー前月の開始日です。 |
| <a id="queryrunnerusagefullpath"></a>`fullPath` | [`ID`](#id) | ジョブを、その属するグループまたはプロジェクトのフルパスでフィルタリングします。例: `gitlab-org`や`gitlab-org/gitlab`など。これを使用できるのは、管理者と、グループ（グループが指定されている場合）またはプロジェクト（プロジェクトが指定されている場合）のメンテナーロールを付与されているユーザーだけです。最大5000個の子プロジェクトからのRunnerという制限があります。 |
| <a id="queryrunnerusagerunnertype"></a>`runnerType` | [`CiRunnerType`](#cirunnertype) | Runnerをタイプでフィルタリングします。 |
| <a id="queryrunnerusagerunnerslimit"></a>`runnersLimit` | [`Int`](#int) | 返すRunnerの最大数。その他のRunnerは`runner: null`エントリに集約されます。指定されていない場合のデフォルトは5です。最大500。 |
| <a id="queryrunnerusagetodate"></a>`toDate` | [`Date`](#date) | リクエストされた日付フレームの終了日。デフォルトは、カレンダー前月の終了日です。 |

### `Query.runnerUsageByProject`

プロジェクトごとのRunnerの使用状況。このクエリを使用するには、ClickHouseデータベースバックエンドを有効にしてください。

[`[CiRunnerUsageByProject!]`](#cirunnerusagebyproject)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryrunnerusagebyprojectfromdate"></a>`fromDate` | [`Date`](#date) | リクエストされた日付フレームの開始日。デフォルトは、カレンダー前月の開始日です。 |
| <a id="queryrunnerusagebyprojectfullpath"></a>`fullPath` | [`ID`](#id) | ジョブを、その属するグループまたはプロジェクトのフルパスに基づいてフィルタリングします。例: `gitlab-org`や`gitlab-org/gitlab`など。これを使用できるのは、管理者と、グループ（グループが指定されている場合）またはプロジェクト（プロジェクトが指定されている場合）のメンテナーロールを付与されているユーザーだけです。最大5000個の子プロジェクトからのRunnerという制限があります。 |
| <a id="queryrunnerusagebyprojectprojectslimit"></a>`projectsLimit` | [`Int`](#int) | 返すプロジェクトの最大数。その他のプロジェクトは`project: null`エントリに集約されます。指定されていない場合のデフォルトは5です。最大500。 |
| <a id="queryrunnerusagebyprojectrunnertype"></a>`runnerType` | [`CiRunnerType`](#cirunnertype) | ジョブを実行したRunnerのタイプでジョブをフィルタリングします。 |
| <a id="queryrunnerusagebyprojecttodate"></a>`toDate` | [`Date`](#date) | リクエストされた日付フレームの終了日。デフォルトは、カレンダー前月の終了日です。 |

### `Query.runners`

GitLabインスタンス（プロジェクトおよび共有）内のすべてのRunnerを取得します。アクセスは、管理者アクセス権を持つユーザーに制限されています。

[`CiRunnerConnection`](#cirunnerconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryrunnersactive"></a>`active` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | GitLab 14.8で**非推奨**になりました。名前が変更されました。`paused`を使用してください。 |
| <a id="queryrunnerscreatorid"></a>`creatorId` | [`UserID`](#userid) | Runnerを作成者IDでフィルタリングします。 |
| <a id="queryrunnerscreatorusername"></a>`creatorUsername` {{< icon name="warning-solid" >}} | [`String`](#string) | GitLab 16.7で**導入**。**状態**: 実験。Runnerを作成者のユーザー名でフィルタリングします。 |
| <a id="queryrunnersownerfullpath"></a>`ownerFullPath` {{< icon name="warning-solid" >}} | [`String`](#string) | GitLab 17.8で**導入**。**状態**: 実験。Runnerを、それを所有するプロジェクトまたはグループでフィルタリングします。 |
| <a id="queryrunnersownerwildcard"></a>`ownerWildcard` {{< icon name="warning-solid" >}} | [`CiRunnerOwnerWildcard`](#cirunnerownerwildcard) | GitLab 17.8で**導入**。**状態**: 実験。Runnerをオーナーのワイルドカードでフィルタリングします。 |
| <a id="queryrunnerspaused"></a>`paused` | [`Boolean`](#boolean) | runnerを`paused`（true）または`active`（false）の状態によりフィルタリングします。 |
| <a id="queryrunnerssearch"></a>`search` | [`String`](#string) | description（説明）フィールドのフルトークンまたは部分テキストでフィルタリングします。 |
| <a id="queryrunnerssort"></a>`sort` | [`CiRunnerSort`](#cirunnersort) | 結果のソート順。 |
| <a id="queryrunnersstatus"></a>`status` | [`CiRunnerStatus`](#cirunnerstatus) | Runnerを状態でフィルタリングします。 |
| <a id="queryrunnerstaglist"></a>`tagList` | [`[String!]`](#string) | Runnerに関連するタグでフィルタリングします（カンマ区切りまたは配列）。 |
| <a id="queryrunnerstype"></a>`type` | [`CiRunnerType`](#cirunnertype) | Runnerをタイプでフィルタリングします。 |
| <a id="queryrunnersupgradestatus"></a>`upgradeStatus` | [`CiRunnerUpgradeStatus`](#cirunnerupgradestatus) | アップグレード状態でフィルタリングします。 |
| <a id="queryrunnersversionprefix"></a>`versionPrefix` {{< icon name="warning-solid" >}} | [`String`](#string) | GitLab 16.6で**導入**されました。**状態**: 実験。Runnerをバージョンでフィルタリングします。検索語の先頭がバージョンであるRunnerマネージャーを含むRunnerが返されます。たとえば、検索語「14.」は、バージョン「14.11.1」と「14.2.3」のRunnerマネージャーを返します。 |

### `Query.selfManagedAddOnEligibleUsers`

アドオンの対象となるSelf-Managedインスタンス内のユーザー。

{{< details >}}GitLab 16.7で**導入**。**状態**: 実験。{{< /details >}}

[`AddOnUserConnection`](#addonuserconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryselfmanagedaddoneligibleusersaddonpurchaseids"></a>`addOnPurchaseIds` | [`[GitlabSubscriptionsAddOnPurchaseID!]!`](#gitlabsubscriptionsaddonpurchaseid) | 割り当てを検索する対象のアドオン購入のグローバルID。 |
| <a id="queryselfmanagedaddoneligibleusersaddontype"></a>`addOnType` | [`GitlabSubscriptionsAddOnType!`](#gitlabsubscriptionsaddontype) | 対象ユーザーのフィルタリングの基準となるアドオンのタイプ。 |
| <a id="queryselfmanagedaddoneligibleusersfilterbyassignedseat"></a>`filterByAssignedSeat` | [`String`](#string) | ユーザーリストを、割り当てられたシートでフィルタリングします。 |
| <a id="queryselfmanagedaddoneligibleuserssearch"></a>`search` | [`String`](#string) | ユーザーリストを検索します。 |
| <a id="queryselfmanagedaddoneligibleuserssort"></a>`sort` | [`GitlabSubscriptionsUserSort`](#gitlabsubscriptionsusersort) | ユーザーリストをソートします。 |

### `Query.selfManagedUsersQueuedForRolePromotion`

Self-Managedインスタンス内でロールプロモーション承認保留中のユーザーに関連するフィールド。

{{< details >}}GitLab 17.1で**導入**。**状態**: 実験。{{< /details >}}

[`UsersQueuedForRolePromotionConnection`](#usersqueuedforrolepromotionconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

### `Query.snippets`

現在のユーザーに表示可能なスニペットを検索します。

[`SnippetConnection`](#snippetconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querysnippetsauthorid"></a>`authorId` | [`UserID`](#userid) | 作成者のID。 |
| <a id="querysnippetsexplore"></a>`explore` | [`Boolean`](#boolean) | 個人用スニペットを調べます。 |
| <a id="querysnippetsids"></a>`ids` | [`[SnippetID!]`](#snippetid) | グローバルスニペットIDの配列。例：`gid://gitlab/ProjectSnippet/1`。 |
| <a id="querysnippetsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | プロジェクトのID。 |
| <a id="querysnippetstype"></a>`type` | [`TypeEnum`](#typeenum) | スニペットのタイプ。 |
| <a id="querysnippetsvisibility"></a>`visibility` | [`VisibilityScopesEnum`](#visibilityscopesenum) | スニペットの表示レベル。 |

### `Query.standardRole`

インスタンスの単一のデフォルトロールを検索します。GitLab Self-Managedでのみ利用可能。

{{< details >}}GitLab 17.6で**導入**。**状態**: 実験。{{< /details >}}

[`StandardRole`](#standardrole)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querystandardroleaccesslevel"></a>`accessLevel` | [`[MemberAccessLevel!]`](#memberaccesslevel) | フィルタリングの基準となるアクセスレベル。 |

### `Query.standardRoles`

インスタンスで利用可能なデフォルトロール。GitLab Self-Managedでのみ利用可能。

{{< details >}}GitLab 17.3で**導入**。**状態**: 実験。{{< /details >}}

[`StandardRoleConnection`](#standardroleconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querystandardrolesaccesslevel"></a>`accessLevel` | [`[MemberAccessLevel!]`](#memberaccesslevel) | フィルタリングの基準となるアクセスレベル。 |

### `Query.subscriptionFutureEntries`

将来のサブスクリプションのエントリに関連するフィールド。

[`SubscriptionFutureEntryConnection`](#subscriptionfutureentryconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

### `Query.syntheticNote`

合成ノートを検索します。

{{< details >}}GitLab 15.9で**導入**。**状態**: 実験。{{< /details >}}

[`Note`](#note)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querysyntheticnotenoteableid"></a>`noteableId` | [`NoteableID!`](#noteableid) | 合成ノートを検索するリソースのグローバルID。 |
| <a id="querysyntheticnotesha"></a>`sha` | [`String!`](#string) | ノートのグローバルID。 |

### `Query.timelogs`

現在のユーザーに表示可能なタイムログを検索します。

[`TimelogConnection`](#timelogconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querytimelogsenddate"></a>`endDate` | [`Time`](#time) | 日付範囲内のタイムログのうち、ログに記録された日付がendDate以前であるものを一覧表示します。 |
| <a id="querytimelogsendtime"></a>`endTime` | [`Time`](#time) | 時刻範囲内のタイムログのうち、ログに記録された時刻がendTime以前であるものを一覧表示します。 |
| <a id="querytimelogsgroupid"></a>`groupId` | [`GroupID`](#groupid) | グループのタイムログを一覧表示します。 |
| <a id="querytimelogsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | プロジェクトのタイムログを一覧表示します。 |
| <a id="querytimelogssort"></a>`sort` | [`TimelogSort`](#timelogsort) | タイムログを特定の順序で一覧表示します。 |
| <a id="querytimelogsstartdate"></a>`startDate` | [`Time`](#time) | 日付範囲内のタイムログのうち、ログに記録された日付がstartDate以後であるものを一覧表示します。 |
| <a id="querytimelogsstarttime"></a>`startTime` | [`Time`](#time) | 時刻範囲内のタイムログのうち、ログに記録された時刻がstartTime以後であるものを一覧表示します。 |
| <a id="querytimelogsusername"></a>`username` | [`String`](#string) | ユーザーのタイムログを一覧表示します。 |

### `Query.todo`

単一のTo Doアイテムを取得します。

[`Todo`](#todo)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querytodoid"></a>`id` | [`TodoID!`](#todoid) | To DoアイテムのID。 |

### `Query.topics`

プロジェクトのトピックを検索します。

[`TopicConnection`](#topicconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querytopicsorganizationid"></a>`organizationId` {{< icon name="warning-solid" >}} | [`OrganizationsOrganizationID`](#organizationsorganizationid) | GitLab 17.7で**導入**。**状態**: 実験。組織のグローバルID。 |
| <a id="querytopicssearch"></a>`search` | [`String`](#string) | トピック名を検索するクエリ。 |

### `Query.usageTrendsMeasurements`

インスタンスの統計を取得します。

[`UsageTrendsMeasurementConnection`](#usagetrendsmeasurementconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryusagetrendsmeasurementsidentifier"></a>`identifier` | [`MeasurementIdentifier!`](#measurementidentifier) | 取得する測定または統計のタイプ。 |
| <a id="queryusagetrendsmeasurementsrecordedafter"></a>`recordedAfter` | [`Time`](#time) | この日付より後に記録された測定。 |
| <a id="queryusagetrendsmeasurementsrecordedbefore"></a>`recordedBefore` | [`Time`](#time) | この日付より前に記録された測定。 |

### `Query.user`

ユーザーを検索します。

[`UserCore`](#usercore)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryuserid"></a>`id` | [`UserID`](#userid) | ユーザーのID。 |
| <a id="queryuserusername"></a>`username` | [`String`](#string) | ユーザーのユーザー名。 |

### `Query.users`

ユーザーを検索します。

[`UserCoreConnection`](#usercoreconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryusersactive"></a>`active` | [`Boolean`](#boolean) | アクティブユーザーでフィルタリングします。trueの場合、アクティブユーザーを返します。falseの場合、非アクティブユーザーを返します。 |
| <a id="queryusersadmins"></a>`admins` | [`Boolean`](#boolean) | 管理者ユーザーのみを返します。 |
| <a id="queryusersgroupid"></a>`groupId` | [`GroupID`](#groupid) | 特定のグループのメンバーであるユーザーを返します。 |
| <a id="queryusershumans"></a>`humans` | [`Boolean`](#boolean) | 標準ユーザーでフィルタリングします。trueの場合、ボットでも内部ユーザーでもないユーザーのみを返します。falseの場合、ボットまたは内部ユーザーであるユーザーのみを返します。 |
| <a id="queryusersids"></a>`ids` | [`[ID!]`](#id) | ユーザーのグローバルIDのリスト。 |
| <a id="queryuserssearch"></a>`search` | [`String`](#string) | 名前、ユーザー名、またはプライマリーメールでユーザーを検索するクエリ。 |
| <a id="queryuserssort"></a>`sort` | [`Sort`](#sort) | 条件でユーザーをソートします。 |
| <a id="queryusersusernames"></a>`usernames` | [`[String!]`](#string) | ユーザー名のリスト。 |

### `Query.vulnerabilities`

現在のユーザーのインスタンスセキュリティダッシュボードのプロジェクトで報告された脆弱性。

[`VulnerabilityConnection`](#vulnerabilityconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryvulnerabilitiesclusteragentid"></a>`clusterAgentId` | [`[ClustersAgentID!]`](#clustersagentid) | 脆弱性を`cluster_agent_id`でフィルタリングします。このフィルターで含められるのは、`reportType`が`cluster_image_scanning`の脆弱性だけです。 |
| <a id="queryvulnerabilitiesclusterid"></a>`clusterId` | [`[ClustersClusterID!]`](#clustersclusterid) | 脆弱性を`cluster_id`でフィルタリングします。このフィルターで含められるのは、`reportType`が`cluster_image_scanning`の脆弱性だけです。 |
| <a id="queryvulnerabilitiesdismissalreason"></a>`dismissalReason` | [`[VulnerabilityDismissalReason!]`](#vulnerabilitydismissalreason) | 却下理由でフィルタリングします。このフィルターで含められるのは、却下された脆弱性だけです。 |
| <a id="queryvulnerabilitieshasairesolution"></a>`hasAiResolution` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | GitLab 17.5で**導入**されました。**状態**: 実験。GitLab Duo脆弱性の修正で解決できる可能性が高い脆弱性のみを返します。`vulnerability_report_vr_filter`機能フラグを有効にすることが必要です。そうでない場合、引数は無視されます。 |
| <a id="queryvulnerabilitieshasissues"></a>`hasIssues` | [`Boolean`](#boolean) | リンクされたイシューがある脆弱性のみを返します。 |
| <a id="queryvulnerabilitieshasmergerequest"></a>`hasMergeRequest` | [`Boolean`](#boolean) | リンクされているマージリクエストがある脆弱性のみを返します。 |
| <a id="queryvulnerabilitieshasremediations"></a>`hasRemediations` | [`Boolean`](#boolean) | 修正がある脆弱性のみを返します。 |
| <a id="queryvulnerabilitieshasresolution"></a>`hasResolution` | [`Boolean`](#boolean) | デフォルトブランチで解決された脆弱性のみを返します。 |
| <a id="queryvulnerabilitiesidentifiername"></a>`identifierName` | [`String`](#string) | 脆弱性を識別子の名前でフィルタリングします。インスタンスセキュリティダッシュボードのクエリに適用した場合、無視されます。 |
| <a id="queryvulnerabilitiesimage"></a>`image` | [`[String!]`](#string) | 脆弱性を場所のイメージでフィルタリングします。このフィルターが存在する場合、一致するのは`container_scanning`、`cluster_image_scanning`を含む`reportType`のエントリだけです。 |
| <a id="queryvulnerabilitiesowasptopten"></a>`owaspTopTen` | [`[VulnerabilityOwaspTop10!]`](#vulnerabilityowasptop10) | 脆弱性をOWASP Top 10カテゴリでフィルタリングします。ワイルドカード値「NONE」もサポートされています。他のOWASP Top 10値と組み合わせることはできません。 |
| <a id="queryvulnerabilitiesprojectid"></a>`projectId` | [`[ID!]`](#id) | 脆弱性をプロジェクトでフィルタリングします。 |
| <a id="queryvulnerabilitiesreporttype"></a>`reportType` | [`[VulnerabilityReportType!]`](#vulnerabilityreporttype) | 脆弱性をレポートタイプでフィルタリングします。 |
| <a id="queryvulnerabilitiesscanner"></a>`scanner` | [`[String!]`](#string) | 脆弱性をVulnerabilityScanner.externalIdでフィルタリングします。 |
| <a id="queryvulnerabilitiesscannerid"></a>`scannerId` | [`[VulnerabilitiesScannerID!]`](#vulnerabilitiesscannerid) | 脆弱性をスキャナーIDでフィルタリングします。 |
| <a id="queryvulnerabilitiesseverity"></a>`severity` | [`[VulnerabilitySeverity!]`](#vulnerabilityseverity) | 脆弱性を重大度でフィルタリングします。 |
| <a id="queryvulnerabilitiessort"></a>`sort` | [`VulnerabilitySort`](#vulnerabilitysort) | 脆弱性をソート順で一覧表示します。 |
| <a id="queryvulnerabilitiesstate"></a>`state` | [`[VulnerabilityState!]`](#vulnerabilitystate) | 脆弱性を状態でフィルタリングします。 |

### `Query.vulnerabilitiesCountByDay`

現在のユーザーのインスタンスセキュリティダッシュボードのプロジェクトに対する1日あたりの脆弱性履歴数。

[`VulnerabilitiesCountByDayConnection`](#vulnerabilitiescountbydayconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryvulnerabilitiescountbydayenddate"></a>`endDate` | [`ISO8601Date!`](#iso8601date) | 脆弱性の履歴をフェッチする対象となる最後の日付。 |
| <a id="queryvulnerabilitiescountbydaystartdate"></a>`startDate` | [`ISO8601Date!`](#iso8601date) | 脆弱性の履歴をフェッチする対象となる最初の日付。 |

### `Query.vulnerability`

脆弱性を検索します。

[`Vulnerability`](#vulnerability)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryvulnerabilityid"></a>`id` | [`VulnerabilityID!`](#vulnerabilityid) | 脆弱性のグローバルID。 |

### `Query.wikiPage`

Wikiページを検索します。

{{< details >}}GitLab 17.6で**導入**。**状態**: 実験。{{< /details >}}

[`WikiPage`](#wikipage)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querywikipagenamespaceid"></a>`namespaceId` | [`NamespaceID`](#namespaceid) | WikiページのネームスペースID。 |
| <a id="querywikipageprojectid"></a>`projectId` | [`ProjectID`](#projectid) | WikiページのプロジェクトID。 |
| <a id="querywikipageslug"></a>`slug` | [`String`](#string) | Wikiページのslug。 |

### `Query.workItem`

作業アイテムを検索します。

{{< details >}}GitLab 15.1で**導入**。**状態**: 実験。{{< /details >}}

[`WorkItem`](#workitem)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryworkitemid"></a>`id` | [`WorkItemID!`](#workitemid) | 作業アイテムのグローバルID。 |

### `Query.workItemDescriptionTemplateContent`

作業アイテムの説明テンプレートを検索します。

{{< details >}}GitLab 17.9で**導入**。**状態**: 実験。{{< /details >}}

[`WorkItemDescriptionTemplate`](#workitemdescriptiontemplate)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryworkitemdescriptiontemplatecontenttemplatecontentinput"></a>`templateContentInput` | [`WorkItemDescriptionTemplateContentInput!`](#workitemdescriptiontemplatecontentinput) | 特定の説明テンプレートをフェッチするためのインプット。 |

### `Query.workItemsByReference`

作業アイテムを参照によって検索します。

{{< details >}}GitLab 16.7で**導入**。**状態**: 実験。{{< /details >}}

[`WorkItemConnection`](#workitemconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryworkitemsbyreferencecontextnamespacepath"></a>`contextNamespacePath` | [`ID`](#id) | コンテキストネームスペース（プロジェクトまたはグループ）のフルパス。 |
| <a id="queryworkitemsbyreferencerefs"></a>`refs` | [`[String!]!`](#string) | 作業アイテムの参照。短い参照またはURLのいずれかを指定できます。 |

### `Query.workspace`

ワークスペースを検索します。

[`Workspace`](#workspace)を返します。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryworkspaceid"></a>`id` | [`RemoteDevelopmentWorkspaceID!`](#remotedevelopmentworkspaceid) | ワークスペースをIDで検索します。 |

### `Query.workspaces`

インスタンス全体でワークスペースを検索します。このフィールドはインスタンス管理者のみが使用できます。管理者以外のすべてのユーザーには空の結果が返されます。

[`WorkspaceConnection`](#workspaceconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryworkspacesactualstates"></a>`actualStates` | [`[String!]`](#string) | ワークスペースを実際の状態でフィルタリングします。 |
| <a id="queryworkspacesagentids"></a>`agentIds` | [`[ClustersAgentID!]`](#clustersagentid) | ワークスペースをエージェントのグローバルIDでフィルタリングします。 |
| <a id="queryworkspacesids"></a>`ids` | [`[RemoteDevelopmentWorkspaceID!]`](#remotedevelopmentworkspaceid) | ワークスペースをワークスペースのグローバルIDでフィルタリングします。例：`["gid://gitlab/RemoteDevelopment::Workspace/1"]`。 |
| <a id="queryworkspacesincludeactualstates"></a>`includeActualStates` {{< icon name="warning-solid" >}} | [`[String!]`](#string) | GitLab 16.7で**非推奨**になりました。代わりにactual_statesを使用してください。 |
| <a id="queryworkspacesprojectids"></a>`projectIds` | [`[ProjectID!]`](#projectid) | ワークスペースをプロジェクトのグローバルIDでフィルタリングします。 |
| <a id="queryworkspacesuserids"></a>`userIds` | [`[ProjectID!]`](#projectid) | ワークスペースをユーザーのグローバルIDでフィルタリングします。 |

## `Mutation`型

`Mutation`型には、実行できるすべての変異が含まれています。

どの変異も、`input`という名前の単一の入力オブジェクトで引数を受け取ります。どの変異でも、少なくとも、エラーメッセージのリストを含む戻りフィールド`errors`をサポートしています。

どの入力オブジェクトについても、変異を識別する`clientMutationId: String`フィールドが含まれる可能性があります。

例:

```graphql
mutation($id: NoteableID!, $body: String!) {
  createNote(input: { noteableId: $id, body: $body }) {
    errors
  }
}
```

### `Mutation.abuseReportLabelCreate`

{{< details >}}GitLab 16.4で**導入**。**状態**: 実験。{{< /details >}}

入力型: `AbuseReportLabelCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationabusereportlabelcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationabusereportlabelcreatecolor"></a>`color` | [`String`](#string) | ラベルの色。先頭が「#」記号の6桁の16進表記（`#FFAABB`など）か、またはCSSカラー名のいずれかで指定。 |
| <a id="mutationabusereportlabelcreatetitle"></a>`title` | [`String!`](#string) | ラベルのタイトル。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationabusereportlabelcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationabusereportlabelcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationabusereportlabelcreatelabel"></a>`label` | [`AbuseReportLabel`](#abusereportlabel) | 変異後のラベル。 |

### `Mutation.achievementsAward`

{{< details >}}GitLab 15.10で**導入**。**状態**: 実験。{{< /details >}}

入力型: `AchievementsAwardInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationachievementsawardachievementid"></a>`achievementId` | [`AchievementsAchievementID!`](#achievementsachievementid) | 授与されるアチーブメントのグローバルID。 |
| <a id="mutationachievementsawardclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationachievementsawarduserid"></a>`userId` | [`UserID!`](#userid) | アチーブメントを授与されるユーザーのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationachievementsawardclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationachievementsawarderrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationachievementsawarduserachievement"></a>`userAchievement` | [`UserAchievement`](#userachievement) | アチーブメントの授与。 |

### `Mutation.achievementsCreate`

{{< details >}}GitLab 15.8で**導入**されました。**状態**: 実験。{{< /details >}}

入力型: `AchievementsCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationachievementscreateavatar"></a>`avatar` | [`Upload`](#upload) | アチーブメントのアバター。 |
| <a id="mutationachievementscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationachievementscreatedescription"></a>`description` | [`String`](#string) | アチーブメントの説明またはノート。 |
| <a id="mutationachievementscreatename"></a>`name` | [`String!`](#string) | アチーブメントの名前。 |
| <a id="mutationachievementscreatenamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | アチーブメントのネームスペース。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationachievementscreateachievement"></a>`achievement` | [`Achievement`](#achievement) | 作成されたアチーブメント。 |
| <a id="mutationachievementscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationachievementscreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.achievementsDelete`

{{< details >}}GitLab 15.11で**導入**。**状態**: 実験。{{< /details >}}

入力型: `AchievementsDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationachievementsdeleteachievementid"></a>`achievementId` | [`AchievementsAchievementID!`](#achievementsachievementid) | 削除するアチーブメントのグローバルID。 |
| <a id="mutationachievementsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationachievementsdeleteachievement"></a>`achievement` | [`Achievement`](#achievement) | アチーブメント。 |
| <a id="mutationachievementsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationachievementsdeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.achievementsRevoke`

{{< details >}}GitLab 15.10で**導入**。**状態**: 実験。{{< /details >}}

入力型: `AchievementsRevokeInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationachievementsrevokeclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationachievementsrevokeuserachievementid"></a>`userAchievementId` | [`AchievementsUserAchievementID!`](#achievementsuserachievementid) | 取り消すユーザーアチーブメントのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationachievementsrevokeclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationachievementsrevokeerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationachievementsrevokeuserachievement"></a>`userAchievement` | [`UserAchievement`](#userachievement) | アチーブメントの授与。 |

### `Mutation.achievementsUpdate`

{{< details >}}GitLab 15.11で**導入**。**状態**: 実験。{{< /details >}}

入力型: `AchievementsUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationachievementsupdateachievementid"></a>`achievementId` | [`AchievementsAchievementID!`](#achievementsachievementid) | 更新対象のアチーブメントのグローバルID。 |
| <a id="mutationachievementsupdateavatar"></a>`avatar` | [`Upload`](#upload) | アチーブメントのアバター。 |
| <a id="mutationachievementsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationachievementsupdatedescription"></a>`description` | [`String`](#string) | アチーブメントの説明またはノート。 |
| <a id="mutationachievementsupdatename"></a>`name` | [`String`](#string) | アチーブメントの名前。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationachievementsupdateachievement"></a>`achievement` | [`Achievement`](#achievement) | アチーブメント。 |
| <a id="mutationachievementsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationachievementsupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.addProjectToSecurityDashboard`

入力型: `AddProjectToSecurityDashboardInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaddprojecttosecuritydashboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationaddprojecttosecuritydashboardid"></a>`id` | [`ProjectID!`](#projectid) | インスタンスセキュリティダッシュボードに追加するプロジェクトのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaddprojecttosecuritydashboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationaddprojecttosecuritydashboarderrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationaddprojecttosecuritydashboardproject"></a>`project` | [`Project`](#project) | インスタンスセキュリティダッシュボードに追加されたプロジェクト。 |

### `Mutation.adminSidekiqQueuesDeleteJobs`

入力型: `AdminSidekiqQueuesDeleteJobsInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationadminsidekiqqueuesdeletejobsairesource"></a>`aiResource` | [`String`](#string) | コンテキストメタデータ内のai_resourceに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsartifactsize"></a>`artifactSize` | [`String`](#string) | コンテキストメタデータ内のartifact_sizeに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsartifactusedcdn"></a>`artifactUsedCdn` | [`String`](#string) | コンテキストメタデータ内のartifact_used_cdnに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsartifactsdependenciescount"></a>`artifactsDependenciesCount` | [`String`](#string) | コンテキストメタデータ内のartifacts_dependencies_countに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsartifactsdependenciessize"></a>`artifactsDependenciesSize` | [`String`](#string) | コンテキストメタデータ内のartifacts_dependencies_sizeに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsbulkimportentityid"></a>`bulkImportEntityId` | [`String`](#string) | コンテキストメタデータ内のbulk_import_entity_idに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobscallerid"></a>`callerId` | [`String`](#string) | コンテキストメタデータ内のcaller_idに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsclientid"></a>`clientId` | [`String`](#string) | コンテキストメタデータ内のclient_idに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationadminsidekiqqueuesdeletejobsfeaturecategory"></a>`featureCategory` | [`String`](#string) | コンテキストメタデータ内のfeature_categoryに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsjobid"></a>`jobId` | [`String`](#string) | コンテキストメタデータ内のjob_idに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsmergeactionstatus"></a>`mergeActionStatus` | [`String`](#string) | コンテキストメタデータ内のmerge_action_statusに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsorganizationid"></a>`organizationId` | [`String`](#string) | コンテキストメタデータ内のorganization_idに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobspipelineid"></a>`pipelineId` | [`String`](#string) | コンテキストメタデータ内のpipeline_idに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsproject"></a>`project` | [`String`](#string) | コンテキストメタデータ内のprojectに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsqueuename"></a>`queueName` | [`String!`](#string) | ジョブを削除する元のキューの名前。 |
| <a id="mutationadminsidekiqqueuesdeletejobsrelatedclass"></a>`relatedClass` | [`String`](#string) | コンテキストメタデータ内のrelated_classに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsremoteip"></a>`remoteIp` | [`String`](#string) | コンテキストメタデータ内のremote_ipに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsrootcallerid"></a>`rootCallerId` | [`String`](#string) | コンテキストメタデータ内のroot_caller_idに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsrootnamespace"></a>`rootNamespace` | [`String`](#string) | コンテキストメタデータ内のroot_namespaceに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsscopeduser"></a>`scopedUser` | [`String`](#string) | コンテキストメタデータ内のscoped_userに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsscopeduserid"></a>`scopedUserId` | [`String`](#string) | コンテキストメタデータ内のscoped_user_idに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobssidekiqdestinationshardredis"></a>`sidekiqDestinationShardRedis` | [`String`](#string) | コンテキストメタデータ内のsidekiq_destination_shard_redisに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobssubscriptionplan"></a>`subscriptionPlan` | [`String`](#string) | コンテキストメタデータ内のsubscription_planに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsuser"></a>`user` | [`String`](#string) | コンテキストメタデータ内のuserに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsuserid"></a>`userId` | [`String`](#string) | コンテキストメタデータ内のuser_idに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsworkerclass"></a>`workerClass` | [`String`](#string) | 指定されたワーカークラスのジョブを削除します。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationadminsidekiqqueuesdeletejobsclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationadminsidekiqqueuesdeletejobserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationadminsidekiqqueuesdeletejobsresult"></a>`result` | [`DeleteJobsResponse`](#deletejobsresponse) | 削除リクエストの状態に関する情報。 |

### `Mutation.aiAction`

{{< details >}}GitLab 15.11で**導入**。**状態**: 実験。{{< /details >}}

入力型: `AiActionInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiactionchat"></a>`chat` | [`AiChatInput`](#aichatinput) | チャットAIアクションのインプット。 |
| <a id="mutationaiactionclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationaiactionclientsubscriptionid"></a>`clientSubscriptionId` | [`String`](#string) | 変異の応答を受信するためにサブスクライブできる、クライアントによって生成されたID。 |
| <a id="mutationaiactionconversationtype"></a>`conversationType` | [`AiConversationsThreadsConversationType`](#aiconversationsthreadsconversationtype) | スレッドの会話タイプ。 |
| <a id="mutationaiactiondescriptioncomposer"></a>`descriptionComposer` | [`AiDescriptionComposerInput`](#aidescriptioncomposerinput) | description_composer AIアクションのインプット。 |
| <a id="mutationaiactionexplainvulnerability"></a>`explainVulnerability` | [`AiExplainVulnerabilityInput`](#aiexplainvulnerabilityinput) | explain_vulnerability AIアクションのインプット。 |
| <a id="mutationaiactiongeneratecommitmessage"></a>`generateCommitMessage` | [`AiGenerateCommitMessageInput`](#aigeneratecommitmessageinput) | generate_commit_message AIアクションのインプット。 |
| <a id="mutationaiactiongeneratecubequery"></a>`generateCubeQuery` | [`AiGenerateCubeQueryInput`](#aigeneratecubequeryinput) | generate_cube_query AIアクションのインプット。 |
| <a id="mutationaiactiongeneratedescription"></a>`generateDescription` | [`AiGenerateDescriptionInput`](#aigeneratedescriptioninput) | generate_description AIアクションのインプット。 |
| <a id="mutationaiactionmeasurecommenttemperature"></a>`measureCommentTemperature` | [`AiMeasureCommentTemperatureInput`](#aimeasurecommenttemperatureinput) | measure_comment_temperature AIアクションのインプット。 |
| <a id="mutationaiactionplatformorigin"></a>`platformOrigin` | [`String`](#string) | リクエストのoriginプラットフォームを指定します。 |
| <a id="mutationaiactionprojectid"></a>`projectId` | [`ProjectID`](#projectid) | ユーザー操作の対象となるプロジェクトのグローバルID。 |
| <a id="mutationaiactionresolvevulnerability"></a>`resolveVulnerability` | [`AiResolveVulnerabilityInput`](#airesolvevulnerabilityinput) | resolve_vulnerability AIアクションのインプット。 |
| <a id="mutationaiactionsummarizecomments"></a>`summarizeComments` | [`AiSummarizeCommentsInput`](#aisummarizecommentsinput) | summarize_comments AIアクションのインプット。 |
| <a id="mutationaiactionsummarizenewmergerequest"></a>`summarizeNewMergeRequest` | [`AiSummarizeNewMergeRequestInput`](#aisummarizenewmergerequestinput) | summarize_new_merge_request AIアクションのインプット。 |
| <a id="mutationaiactionsummarizereview"></a>`summarizeReview` | [`AiSummarizeReviewInput`](#aisummarizereviewinput) | summarize_review AIアクションのインプット。 |
| <a id="mutationaiactionthreadid"></a>`threadId` | [`AiConversationThreadID`](#aiconversationthreadid) | 会話を継続する既存スレッドのグローバルID。指定されていない場合、指定されたconversation_typeのための新しいスレッドが作成されます。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiactionclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationaiactionerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationaiactionrequestid"></a>`requestId` | [`String`](#string) | リクエストのID。 |
| <a id="mutationaiactionthreadid"></a>`threadId` | [`AiConversationThreadID`](#aiconversationthreadid) | スレッドのグローバルID。 |

### `Mutation.aiAgentCreate`

{{< details >}}GitLab 16.8で**導入**。**状態**: 実験。{{< /details >}}

入力型: `AiAgentCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiagentcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationaiagentcreatename"></a>`name` | [`String!`](#string) | エージェントの名前。 |
| <a id="mutationaiagentcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | エージェントが属するプロジェクト。 |
| <a id="mutationaiagentcreateprompt"></a>`prompt` | [`String!`](#string) | エージェントのプロンプト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiagentcreateagent"></a>`agent` | [`AiAgent`](#aiagent) | 変異後のエージェント。 |
| <a id="mutationaiagentcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationaiagentcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.aiAgentDestroy`

{{< details >}}GitLab 16.11で**導入**。**状態**: 実験。{{< /details >}}

入力型: `AiAgentDestroyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiagentdestroyagentid"></a>`agentId` | [`AiAgentID!`](#aiagentid) | 削除するAIエージェントのグローバルID。 |
| <a id="mutationaiagentdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationaiagentdestroyprojectpath"></a>`projectPath` | [`ID!`](#id) | エージェントが属するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiagentdestroyagent"></a>`agent` | [`AiAgent`](#aiagent) | 変異後のエージェント。 |
| <a id="mutationaiagentdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationaiagentdestroyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationaiagentdestroymessage"></a>`message` | [`String`](#string) | AIエージェント削除の結果メッセージ。 |

### `Mutation.aiAgentUpdate`

{{< details >}}GitLab 16.10で**導入**。**状態**: 実験。{{< /details >}}

入力型: `AiAgentUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiagentupdateagentid"></a>`agentId` | [`AiAgentID!`](#aiagentid) | エージェントのID。 |
| <a id="mutationaiagentupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationaiagentupdatename"></a>`name` | [`String`](#string) | エージェントの名前。 |
| <a id="mutationaiagentupdateprojectpath"></a>`projectPath` | [`ID!`](#id) | エージェントが属するプロジェクト。 |
| <a id="mutationaiagentupdateprompt"></a>`prompt` | [`String`](#string) | エージェントのプロンプト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiagentupdateagent"></a>`agent` | [`AiAgent`](#aiagent) | 変異後のエージェント。 |
| <a id="mutationaiagentupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationaiagentupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.aiFeatureSettingUpdate`

AI機能の設定を更新または作成します。

{{< details >}}GitLab 17.4で**導入**。**状態**: 実験。{{< /details >}}

入力型: `AiFeatureSettingUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaifeaturesettingupdateaiselfhostedmodelid"></a>`aiSelfHostedModelId` | [`AiSelfHostedModelID`](#aiselfhostedmodelid) | AI設定を提供するセルフホストモデルのグローバルID。 |
| <a id="mutationaifeaturesettingupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationaifeaturesettingupdatefeatures"></a>`features` | [`[AiFeatures!]!`](#aifeatures) | 設定するAI機能の配列（単一の更新またはバッチ更新）。 |
| <a id="mutationaifeaturesettingupdateprovider"></a>`provider` | [`AiFeatureProviders!`](#aifeatureproviders) | AI設定のプロバイダー。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaifeaturesettingupdateaifeaturesettings"></a>`aiFeatureSettings` | [`[AiFeatureSetting!]!`](#aifeaturesetting) | 変異後のAI機能設定のリスト。 |
| <a id="mutationaifeaturesettingupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationaifeaturesettingupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.aiSelfHostedModelConnectionCheck`

指定されたモデル設定による接続をAIゲートウェイが確立できるかどうかをチェックします。

{{< details >}}GitLab 17.7で**導入**。**状態**: 実験。{{< /details >}}

入力型: `AiSelfHostedModelConnectionCheckInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiselfhostedmodelconnectioncheckapitoken"></a>`apiToken` | [`String`](#string) | セルフホストモデルへのアクセスに使用するAPIトークン（存在する場合）。 |
| <a id="mutationaiselfhostedmodelconnectioncheckclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationaiselfhostedmodelconnectioncheckendpoint"></a>`endpoint` | [`String!`](#string) | セルフホストモデルのエンドポイント。 |
| <a id="mutationaiselfhostedmodelconnectioncheckidentifier"></a>`identifier` | [`String`](#string) | サードパーティモデルプロバイダーの識別子。 |
| <a id="mutationaiselfhostedmodelconnectioncheckmodel"></a>`model` | [`AiAcceptedSelfHostedModels!`](#aiacceptedselfhostedmodels) | デプロイ対象のAIモデル。 |
| <a id="mutationaiselfhostedmodelconnectioncheckname"></a>`name` | [`String!`](#string) | セルフホストモデルのデプロイ名。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiselfhostedmodelconnectioncheckclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationaiselfhostedmodelconnectioncheckerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationaiselfhostedmodelconnectioncheckresult"></a>`result` | [`CloudConnectorProbeResult`](#cloudconnectorproberesult) | セルフホスト型のホスト接続チェックの結果。 |

### `Mutation.aiSelfHostedModelCreate`

{{< details >}}GitLab 17.1で**導入**。**状態**: 実験。{{< /details >}}

入力型: `AiSelfHostedModelCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiselfhostedmodelcreateapitoken"></a>`apiToken` | [`String`](#string) | セルフホストモデルへのアクセスに使用するAPIトークン（存在する場合）。 |
| <a id="mutationaiselfhostedmodelcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationaiselfhostedmodelcreateendpoint"></a>`endpoint` | [`String!`](#string) | セルフホストモデルのエンドポイント。 |
| <a id="mutationaiselfhostedmodelcreateidentifier"></a>`identifier` | [`String`](#string) | サードパーティモデルプロバイダーの識別子。 |
| <a id="mutationaiselfhostedmodelcreatemodel"></a>`model` | [`AiAcceptedSelfHostedModels!`](#aiacceptedselfhostedmodels) | デプロイ対象のAIモデル。 |
| <a id="mutationaiselfhostedmodelcreatename"></a>`name` | [`String!`](#string) | セルフホストモデルのデプロイ名。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiselfhostedmodelcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationaiselfhostedmodelcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationaiselfhostedmodelcreateselfhostedmodel"></a>`selfHostedModel` | [`AiSelfHostedModel`](#aiselfhostedmodel) | 変異後のセルフホストモデル。 |

### `Mutation.aiSelfHostedModelDelete`

セルフホストモデルを削除します。

{{< details >}}GitLab 17.2で**導入**。**状態**: 実験。{{< /details >}}

入力型: `AiSelfHostedModelDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiselfhostedmodeldeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationaiselfhostedmodeldeleteid"></a>`id` | [`AiSelfHostedModelID!`](#aiselfhostedmodelid) | 削除するセルフホストモデルのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiselfhostedmodeldeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationaiselfhostedmodeldeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.aiSelfHostedModelUpdate`

セルフホストモデルを更新します。

{{< details >}}GitLab 17.2で**導入**。**状態**: 実験。{{< /details >}}

入力型: `AiSelfHostedModelUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiselfhostedmodelupdateapitoken"></a>`apiToken` | [`String`](#string) | セルフホストモデルへのアクセスに使用するAPIトークン（存在する場合）。 |
| <a id="mutationaiselfhostedmodelupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationaiselfhostedmodelupdateendpoint"></a>`endpoint` | [`String!`](#string) | セルフホストモデルのエンドポイント。 |
| <a id="mutationaiselfhostedmodelupdateid"></a>`id` | [`AiSelfHostedModelID!`](#aiselfhostedmodelid) | 更新するセルフホストモデルのグローバルID。 |
| <a id="mutationaiselfhostedmodelupdateidentifier"></a>`identifier` | [`String`](#string) | サードパーティモデルプロバイダーの識別子。 |
| <a id="mutationaiselfhostedmodelupdatemodel"></a>`model` | [`AiAcceptedSelfHostedModels!`](#aiacceptedselfhostedmodels) | デプロイ対象のAIモデル。 |
| <a id="mutationaiselfhostedmodelupdatename"></a>`name` | [`String!`](#string) | セルフホストモデルのデプロイ名。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiselfhostedmodelupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationaiselfhostedmodelupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationaiselfhostedmodelupdateselfhostedmodel"></a>`selfHostedModel` | [`AiSelfHostedModel`](#aiselfhostedmodel) | 変異後のセルフホストモデル。 |

### `Mutation.alertSetAssignees`

入力型: `AlertSetAssigneesInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationalertsetassigneesassigneeusernames"></a>`assigneeUsernames` | [`[String!]!`](#string) | アラートに割り当てるユーザー名。デフォルトでは、既存の割り当てを置き換えます。 |
| <a id="mutationalertsetassigneesclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationalertsetassigneesiid"></a>`iid` | [`String!`](#string) | 変異対象のアラートのIID。 |
| <a id="mutationalertsetassigneesoperationmode"></a>`operationMode` | [`MutationOperationMode`](#mutationoperationmode) | 実行する操作。デフォルトはREPLACEです。 |
| <a id="mutationalertsetassigneesprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のアラートの属するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationalertsetassigneesalert"></a>`alert` | [`AlertManagementAlert`](#alertmanagementalert) | 変異後のアラート。 |
| <a id="mutationalertsetassigneesclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationalertsetassigneeserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationalertsetassigneesissue"></a>`issue` | [`Issue`](#issue) | 変異後に作成されたイシュー。 |
| <a id="mutationalertsetassigneestodo"></a>`todo` | [`Todo`](#todo) | 変異後のTo Doアイテム。 |

### `Mutation.alertTodoCreate`

入力型: `AlertTodoCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationalerttodocreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationalerttodocreateiid"></a>`iid` | [`String!`](#string) | 変異対象のアラートのIID。 |
| <a id="mutationalerttodocreateprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のアラートの属するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationalerttodocreatealert"></a>`alert` | [`AlertManagementAlert`](#alertmanagementalert) | 変異後のアラート。 |
| <a id="mutationalerttodocreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationalerttodocreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationalerttodocreateissue"></a>`issue` | [`Issue`](#issue) | 変異後に作成されたイシュー。 |
| <a id="mutationalerttodocreatetodo"></a>`todo` | [`Todo`](#todo) | 変異後のTo Doアイテム。 |

### `Mutation.approvalProjectRuleDelete`

{{< details >}}GitLab 16.10で**導入**。**状態**: 実験。{{< /details >}}

入力型: `approvalProjectRuleDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationapprovalprojectruledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationapprovalprojectruledeleteid"></a>`id` | [`ApprovalProjectRuleID!`](#approvalprojectruleid) | 削除する承認プロジェクトルールのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationapprovalprojectruledeleteapprovalrule"></a>`approvalRule` | [`ApprovalProjectRule`](#approvalprojectrule) | 削除された承認ルール。 |
| <a id="mutationapprovalprojectruledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationapprovalprojectruledeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.approvalProjectRuleUpdate`

{{< details >}}GitLab 16.10で**導入**。**状態**: 実験。{{< /details >}}

入力型: `approvalProjectRuleUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationapprovalprojectruleupdateapprovalsrequired"></a>`approvalsRequired` | [`Int!`](#int) | ルールを満たすために必要な承認の数。 |
| <a id="mutationapprovalprojectruleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationapprovalprojectruleupdategroupids"></a>`groupIds` | [`[ID!]`](#id) | 承認ルールを実行できるグループのIDのリスト。 |
| <a id="mutationapprovalprojectruleupdateid"></a>`id` | [`ApprovalProjectRuleID!`](#approvalprojectruleid) | 破棄する承認ルールのグローバルID。 |
| <a id="mutationapprovalprojectruleupdatename"></a>`name` | [`String!`](#string) | 承認ルールの名前。 |
| <a id="mutationapprovalprojectruleupdateuserids"></a>`userIds` | [`[ID!]`](#id) | 承認ルールを実行できるユーザーのIDのリスト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationapprovalprojectruleupdateapprovalrule"></a>`approvalRule` | [`ApprovalProjectRule`](#approvalprojectrule) | 変異後の承認ルール。 |
| <a id="mutationapprovalprojectruleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationapprovalprojectruleupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.approveDeployment`

入力型: `ApproveDeploymentInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationapprovedeploymentclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationapprovedeploymentcomment"></a>`comment` | [`String`](#string) | 承認に伴うコメント。 |
| <a id="mutationapprovedeploymentid"></a>`id` | [`DeploymentID!`](#deploymentid) | デプロイのID。 |
| <a id="mutationapprovedeploymentrepresentedas"></a>`representedAs` | [`String`](#string) | ユーザーが複数の承認ルールに属している場合に、承認に使用するユーザー/グループ/ロールの名前。 |
| <a id="mutationapprovedeploymentstatus"></a>`status` | [`DeploymentsApprovalStatus!`](#deploymentsapprovalstatus) | 承認の状態（`APPROVED`または`REJECTED`のいずれか）。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationapprovedeploymentclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationapprovedeploymentdeploymentapproval"></a>`deploymentApproval` | [`DeploymentApproval`](#deploymentapproval) | 変異後のDeploymentApproval。 |
| <a id="mutationapprovedeploymenterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.artifactDestroy`

入力型: `ArtifactDestroyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationartifactdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationartifactdestroyid"></a>`id` | [`CiJobArtifactID!`](#cijobartifactid) | 削除するアーティファクトのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationartifactdestroyartifact"></a>`artifact` | [`CiJobArtifact`](#cijobartifact) | 削除されたアーティファクト。 |
| <a id="mutationartifactdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationartifactdestroyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.auditEventsAmazonS3ConfigurationCreate`

入力型: `AuditEventsAmazonS3ConfigurationCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsamazons3configurationcreateaccesskeyxid"></a>`accessKeyXid` | [`String!`](#string) | Amazon S3アカウントのアクセスキーID。 |
| <a id="mutationauditeventsamazons3configurationcreateawsregion"></a>`awsRegion` | [`String!`](#string) | バケットを作成するAWSリージョン。 |
| <a id="mutationauditeventsamazons3configurationcreatebucketname"></a>`bucketName` | [`String!`](#string) | 監査イベントが記録されるバケットの名前。 |
| <a id="mutationauditeventsamazons3configurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsamazons3configurationcreategrouppath"></a>`groupPath` | [`ID!`](#id) | グループパス。 |
| <a id="mutationauditeventsamazons3configurationcreatename"></a>`name` | [`String`](#string) | 宛先名。 |
| <a id="mutationauditeventsamazons3configurationcreatesecretaccesskey"></a>`secretAccessKey` | [`String!`](#string) | Amazon S3アカウントのシークレットアクセスキー。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsamazons3configurationcreateamazons3configuration"></a>`amazonS3Configuration` | [`AmazonS3ConfigurationType`](#amazons3configurationtype) | 作成された設定。 |
| <a id="mutationauditeventsamazons3configurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsamazons3configurationcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.auditEventsAmazonS3ConfigurationDelete`

入力型: `AuditEventsAmazonS3ConfigurationDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsamazons3configurationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsamazons3configurationdeleteid"></a>`id` | [`AuditEventsAmazonS3ConfigurationID!`](#auditeventsamazons3configurationid) | 破棄するAmazon S3設定のID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsamazons3configurationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsamazons3configurationdeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.auditEventsAmazonS3ConfigurationUpdate`

入力型: `AuditEventsAmazonS3ConfigurationUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsamazons3configurationupdateaccesskeyxid"></a>`accessKeyXid` | [`String`](#string) | Amazon S3アカウントのアクセスキーID。 |
| <a id="mutationauditeventsamazons3configurationupdateawsregion"></a>`awsRegion` | [`String`](#string) | バケットを作成するAWSリージョン。 |
| <a id="mutationauditeventsamazons3configurationupdatebucketname"></a>`bucketName` | [`String`](#string) | 監査イベントが記録されるバケットの名前。 |
| <a id="mutationauditeventsamazons3configurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsamazons3configurationupdateid"></a>`id` | [`AuditEventsAmazonS3ConfigurationID!`](#auditeventsamazons3configurationid) | 更新するAmazon S3設定のID。 |
| <a id="mutationauditeventsamazons3configurationupdatename"></a>`name` | [`String`](#string) | 宛先名。 |
| <a id="mutationauditeventsamazons3configurationupdatesecretaccesskey"></a>`secretAccessKey` | [`String`](#string) | Amazon S3アカウントのシークレットアクセスキー。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsamazons3configurationupdateamazons3configuration"></a>`amazonS3Configuration` | [`AmazonS3ConfigurationType`](#amazons3configurationtype) | 更新されたAmazon S3設定。 |
| <a id="mutationauditeventsamazons3configurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsamazons3configurationupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.auditEventsGroupDestinationEventsAdd`

{{< details >}}GitLab 17.0で**導入**。**状態**: 実験。{{< /details >}}

入力型: `AuditEventsGroupDestinationEventsAddInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsgroupdestinationeventsadddestinationid"></a>`destinationId` | [`AuditEventsGroupExternalStreamingDestinationID!`](#auditeventsgroupexternalstreamingdestinationid) | 宛先ID。 |
| <a id="mutationauditeventsgroupdestinationeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | ストリーミング用に追加するイベントタイプフィルターのリスト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsgroupdestinationeventsadderrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationauditeventsgroupdestinationeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]`](#string) | 監査イベントの外部宛先のためのイベントタイプフィルターのリスト。 |

### `Mutation.auditEventsGroupDestinationEventsDelete`

{{< details >}}GitLab 17.0で**導入**。**状態**: 実験。{{< /details >}}

入力型: `AuditEventsGroupDestinationEventsDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationeventsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsgroupdestinationeventsdeletedestinationid"></a>`destinationId` | [`AuditEventsGroupExternalStreamingDestinationID!`](#auditeventsgroupexternalstreamingdestinationid) | 宛先ID。 |
| <a id="mutationauditeventsgroupdestinationeventsdeleteeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | ストリーミングから削除するイベントタイプフィルターのリスト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationeventsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsgroupdestinationeventsdeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.auditEventsGroupDestinationNamespaceFilterCreate`

{{< details >}}GitLab 17.0で**導入**。**状態**: 実験。{{< /details >}}

入力型: `AuditEventsGroupDestinationNamespaceFilterCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationnamespacefiltercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsgroupdestinationnamespacefiltercreatedestinationid"></a>`destinationId` | [`AuditEventsGroupExternalStreamingDestinationID!`](#auditeventsgroupexternalstreamingdestinationid) | 宛先ID。 |
| <a id="mutationauditeventsgroupdestinationnamespacefiltercreatenamespacepath"></a>`namespacePath` | [`String`](#string) | ネームスペースのフルパス（プロジェクトまたはグループのみ）。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationnamespacefiltercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsgroupdestinationnamespacefiltercreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationauditeventsgroupdestinationnamespacefiltercreatenamespacefilter"></a>`namespaceFilter` | [`GroupAuditEventNamespaceFilter`](#groupauditeventnamespacefilter) | 作成されたネームスペースフィルター。 |

### `Mutation.auditEventsGroupDestinationNamespaceFilterDelete`

{{< details >}}GitLab 17.0で**導入**。**状態**: 実験。{{< /details >}}

入力型: `AuditEventsGroupDestinationNamespaceFilterDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationnamespacefilterdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsgroupdestinationnamespacefilterdeletenamespacefilterid"></a>`namespaceFilterId` | [`AuditEventsGroupNamespaceFilterID!`](#auditeventsgroupnamespacefilterid) | ネームスペースフィルターID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationnamespacefilterdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsgroupdestinationnamespacefilterdeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.auditEventsInstanceAmazonS3ConfigurationCreate`

入力型: `AuditEventsInstanceAmazonS3ConfigurationCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstanceamazons3configurationcreateaccesskeyxid"></a>`accessKeyXid` | [`String!`](#string) | Amazon S3アカウントのアクセスキーID。 |
| <a id="mutationauditeventsinstanceamazons3configurationcreateawsregion"></a>`awsRegion` | [`String!`](#string) | バケットを作成するAWSリージョン。 |
| <a id="mutationauditeventsinstanceamazons3configurationcreatebucketname"></a>`bucketName` | [`String!`](#string) | 監査イベントが記録されるバケットの名前。 |
| <a id="mutationauditeventsinstanceamazons3configurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsinstanceamazons3configurationcreatename"></a>`name` | [`String`](#string) | 宛先名。 |
| <a id="mutationauditeventsinstanceamazons3configurationcreatesecretaccesskey"></a>`secretAccessKey` | [`String!`](#string) | Amazon S3アカウントのシークレットアクセスキー。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstanceamazons3configurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsinstanceamazons3configurationcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationauditeventsinstanceamazons3configurationcreateinstanceamazons3configuration"></a>`instanceAmazonS3Configuration` | [`InstanceAmazonS3ConfigurationType`](#instanceamazons3configurationtype) | 作成されたインスタンスAmazon S3設定。 |

### `Mutation.auditEventsInstanceAmazonS3ConfigurationDelete`

入力型: `AuditEventsInstanceAmazonS3ConfigurationDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstanceamazons3configurationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsinstanceamazons3configurationdeleteid"></a>`id` | [`AuditEventsInstanceAmazonS3ConfigurationID!`](#auditeventsinstanceamazons3configurationid) | 削除するインスタンスレベルのAmazon S3設定のID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstanceamazons3configurationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsinstanceamazons3configurationdeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.auditEventsInstanceAmazonS3ConfigurationUpdate`

入力型: `AuditEventsInstanceAmazonS3ConfigurationUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstanceamazons3configurationupdateaccesskeyxid"></a>`accessKeyXid` | [`String`](#string) | Amazon S3アカウントのアクセスキーID。 |
| <a id="mutationauditeventsinstanceamazons3configurationupdateawsregion"></a>`awsRegion` | [`String`](#string) | バケットを作成するAWSリージョン。 |
| <a id="mutationauditeventsinstanceamazons3configurationupdatebucketname"></a>`bucketName` | [`String`](#string) | 監査イベントが記録されるバケットの名前。 |
| <a id="mutationauditeventsinstanceamazons3configurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsinstanceamazons3configurationupdateid"></a>`id` | [`AuditEventsInstanceAmazonS3ConfigurationID!`](#auditeventsinstanceamazons3configurationid) | 更新するインスタンスレベルのAmazon S3設定のID。 |
| <a id="mutationauditeventsinstanceamazons3configurationupdatename"></a>`name` | [`String`](#string) | 宛先名。 |
| <a id="mutationauditeventsinstanceamazons3configurationupdatesecretaccesskey"></a>`secretAccessKey` | [`String`](#string) | Amazon S3アカウントのシークレットアクセスキー。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstanceamazons3configurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsinstanceamazons3configurationupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationauditeventsinstanceamazons3configurationupdateinstanceamazons3configuration"></a>`instanceAmazonS3Configuration` | [`InstanceAmazonS3ConfigurationType`](#instanceamazons3configurationtype) | 更新されたインスタンスレベルのAmazon S3設定。 |

### `Mutation.auditEventsInstanceDestinationEventsAdd`

{{< details >}}GitLab 17.0で**導入**。**状態**: 実験。{{< /details >}}

入力型: `AuditEventsInstanceDestinationEventsAddInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstancedestinationeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsinstancedestinationeventsadddestinationid"></a>`destinationId` | [`AuditEventsInstanceExternalStreamingDestinationID!`](#auditeventsinstanceexternalstreamingdestinationid) | 宛先ID。 |
| <a id="mutationauditeventsinstancedestinationeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | ストリーミング用に追加するイベントタイプフィルターのリスト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstancedestinationeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsinstancedestinationeventsadderrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationauditeventsinstancedestinationeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]`](#string) | 監査イベントの外部宛先のためのイベントタイプフィルターのリスト。 |

### `Mutation.auditEventsInstanceDestinationEventsDelete`

{{< details >}}GitLab 17.0で**導入**。**状態**: 実験。{{< /details >}}

入力型: `AuditEventsInstanceDestinationEventsDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstancedestinationeventsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsinstancedestinationeventsdeletedestinationid"></a>`destinationId` | [`AuditEventsInstanceExternalStreamingDestinationID!`](#auditeventsinstanceexternalstreamingdestinationid) | 宛先ID。 |
| <a id="mutationauditeventsinstancedestinationeventsdeleteeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | ストリーミングから削除するイベントタイプフィルターのリスト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstancedestinationeventsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsinstancedestinationeventsdeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.auditEventsInstanceDestinationNamespaceFilterCreate`

{{< details >}}GitLab 17.2で**導入**。**状態**: 実験。{{< /details >}}

入力型: `AuditEventsInstanceDestinationNamespaceFilterCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstancedestinationnamespacefiltercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsinstancedestinationnamespacefiltercreatedestinationid"></a>`destinationId` | [`AuditEventsInstanceExternalStreamingDestinationID!`](#auditeventsinstanceexternalstreamingdestinationid) | 宛先ID。 |
| <a id="mutationauditeventsinstancedestinationnamespacefiltercreatenamespacepath"></a>`namespacePath` | [`String`](#string) | ネームスペースのフルパス。プロジェクトまたはグループのネームスペースのみ。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstancedestinationnamespacefiltercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsinstancedestinationnamespacefiltercreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationauditeventsinstancedestinationnamespacefiltercreatenamespacefilter"></a>`namespaceFilter` | [`InstanceAuditEventNamespaceFilter`](#instanceauditeventnamespacefilter) | 作成するネームスペースフィルター。 |

### `Mutation.auditEventsInstanceDestinationNamespaceFilterDelete`

{{< details >}}GitLab 17.2で**導入**。**状態**: 実験。{{< /details >}}

入力型: `AuditEventsInstanceDestinationNamespaceFilterDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstancedestinationnamespacefilterdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsinstancedestinationnamespacefilterdeletenamespacefilterid"></a>`namespaceFilterId` | [`AuditEventsInstanceNamespaceFilterID!`](#auditeventsinstancenamespacefilterid) | ネームスペースフィルターID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstancedestinationnamespacefilterdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsinstancedestinationnamespacefilterdeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.auditEventsStreamingDestinationEventsAdd`

入力型: `AuditEventsStreamingDestinationEventsAddInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreamingdestinationeventsadddestinationid"></a>`destinationId` | [`AuditEventsExternalAuditEventDestinationID!`](#auditeventsexternalauditeventdestinationid) | 宛先ID。 |
| <a id="mutationauditeventsstreamingdestinationeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | ストリーミング用に追加するイベントタイプフィルターのリスト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreamingdestinationeventsadderrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationauditeventsstreamingdestinationeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]`](#string) | 監査イベントの外部宛先のためのイベントタイプフィルターのリスト。 |

### `Mutation.auditEventsStreamingDestinationEventsRemove`

入力型: `AuditEventsStreamingDestinationEventsRemoveInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationeventsremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreamingdestinationeventsremovedestinationid"></a>`destinationId` | [`AuditEventsExternalAuditEventDestinationID!`](#auditeventsexternalauditeventdestinationid) | 宛先ID。 |
| <a id="mutationauditeventsstreamingdestinationeventsremoveeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | ストリーミングから削除するイベントタイプフィルターのリスト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationeventsremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreamingdestinationeventsremoveerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.auditEventsStreamingDestinationInstanceEventsAdd`

入力型: `AuditEventsStreamingDestinationInstanceEventsAddInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsadddestinationid"></a>`destinationId` | [`AuditEventsInstanceExternalAuditEventDestinationID!`](#auditeventsinstanceexternalauditeventdestinationid) | 宛先ID。 |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | ストリーミング用に追加するイベントタイプフィルターのリスト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsadderrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]`](#string) | 監査イベントの外部宛先のためのイベントタイプフィルターのリスト。 |

### `Mutation.auditEventsStreamingDestinationInstanceEventsRemove`

入力型: `AuditEventsStreamingDestinationInstanceEventsRemoveInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsremovedestinationid"></a>`destinationId` | [`AuditEventsInstanceExternalAuditEventDestinationID!`](#auditeventsinstanceexternalauditeventdestinationid) | 宛先ID。 |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsremoveeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | ストリーミングから削除するイベントタイプフィルターのリスト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsremoveerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.auditEventsStreamingHeadersCreate`

入力型: `AuditEventsStreamingHeadersCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingheaderscreateactive"></a>`active` | [`Boolean`](#boolean) | ヘッダーがアクティブかどうかを判断するブール値オプション。 |
| <a id="mutationauditeventsstreamingheaderscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreamingheaderscreatedestinationid"></a>`destinationId` | [`AuditEventsExternalAuditEventDestinationID!`](#auditeventsexternalauditeventdestinationid) | ヘッダーを関連付ける宛先。 |
| <a id="mutationauditeventsstreamingheaderscreatekey"></a>`key` | [`String!`](#string) | ヘッダーキー。 |
| <a id="mutationauditeventsstreamingheaderscreatevalue"></a>`value` | [`String!`](#string) | ヘッダー値。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingheaderscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreamingheaderscreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationauditeventsstreamingheaderscreateheader"></a>`header` | [`AuditEventStreamingHeader`](#auditeventstreamingheader) | 作成されたヘッダー。 |

### `Mutation.auditEventsStreamingHeadersDestroy`

入力型: `AuditEventsStreamingHeadersDestroyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingheadersdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreamingheadersdestroyheaderid"></a>`headerId` | [`AuditEventsStreamingHeaderID!`](#auditeventsstreamingheaderid) | 削除するヘッダー。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingheadersdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreamingheadersdestroyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.auditEventsStreamingHeadersUpdate`

入力型: `AuditEventsStreamingHeadersUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingheadersupdateactive"></a>`active` | [`Boolean`](#boolean) | ヘッダーがアクティブかどうかを判断するブール値オプション。 |
| <a id="mutationauditeventsstreamingheadersupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreamingheadersupdateheaderid"></a>`headerId` | [`AuditEventsStreamingHeaderID!`](#auditeventsstreamingheaderid) | 更新するヘッダー。 |
| <a id="mutationauditeventsstreamingheadersupdatekey"></a>`key` | [`String`](#string) | ヘッダーキー。 |
| <a id="mutationauditeventsstreamingheadersupdatevalue"></a>`value` | [`String`](#string) | ヘッダー値。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingheadersupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreamingheadersupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationauditeventsstreamingheadersupdateheader"></a>`header` | [`AuditEventStreamingHeader`](#auditeventstreamingheader) | ヘッダーを更新します。 |

### `Mutation.auditEventsStreamingHttpNamespaceFiltersAdd`

入力型: `AuditEventsStreamingHTTPNamespaceFiltersAddInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersadddestinationid"></a>`destinationId` | [`AuditEventsExternalAuditEventDestinationID!`](#auditeventsexternalauditeventdestinationid) | 宛先ID。 |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersaddgrouppath"></a>`groupPath` | [`ID`](#id) | グループのフルパス。 |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersaddprojectpath"></a>`projectPath` | [`ID`](#id) | プロジェクトのフルパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersadderrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersaddnamespacefilter"></a>`namespaceFilter` | [`AuditEventStreamingHTTPNamespaceFilter`](#auditeventstreaminghttpnamespacefilter) | 作成されたネームスペースフィルター。 |

### `Mutation.auditEventsStreamingHttpNamespaceFiltersDelete`

入力型: `AuditEventsStreamingHTTPNamespaceFiltersDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersdeletenamespacefilterid"></a>`namespaceFilterId` | [`AuditEventsStreamingHTTPNamespaceFilterID!`](#auditeventsstreaminghttpnamespacefilterid) | ネームスペースフィルターID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersdeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.auditEventsStreamingInstanceHeadersCreate`

入力型: `AuditEventsStreamingInstanceHeadersCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminginstanceheaderscreateactive"></a>`active` | [`Boolean`](#boolean) | ヘッダーがアクティブかどうかを判断するブール値オプション。 |
| <a id="mutationauditeventsstreaminginstanceheaderscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreaminginstanceheaderscreatedestinationid"></a>`destinationId` | [`AuditEventsInstanceExternalAuditEventDestinationID!`](#auditeventsinstanceexternalauditeventdestinationid) | ヘッダーを関連付けるインスタンスレベルの外部宛先。 |
| <a id="mutationauditeventsstreaminginstanceheaderscreatekey"></a>`key` | [`String!`](#string) | ヘッダーキー。 |
| <a id="mutationauditeventsstreaminginstanceheaderscreatevalue"></a>`value` | [`String!`](#string) | ヘッダー値。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminginstanceheaderscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreaminginstanceheaderscreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationauditeventsstreaminginstanceheaderscreateheader"></a>`header` | [`AuditEventsStreamingInstanceHeader`](#auditeventsstreaminginstanceheader) | 作成されたヘッダー。 |

### `Mutation.auditEventsStreamingInstanceHeadersDestroy`

入力型: `AuditEventsStreamingInstanceHeadersDestroyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminginstanceheadersdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreaminginstanceheadersdestroyheaderid"></a>`headerId` | [`AuditEventsStreamingInstanceHeaderID!`](#auditeventsstreaminginstanceheaderid) | 削除するヘッダー。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminginstanceheadersdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreaminginstanceheadersdestroyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.auditEventsStreamingInstanceHeadersUpdate`

入力型: `AuditEventsStreamingInstanceHeadersUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminginstanceheadersupdateactive"></a>`active` | [`Boolean`](#boolean) | ヘッダーがアクティブかどうかを判断するブール値オプション。 |
| <a id="mutationauditeventsstreaminginstanceheadersupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreaminginstanceheadersupdateheaderid"></a>`headerId` | [`AuditEventsStreamingInstanceHeaderID!`](#auditeventsstreaminginstanceheaderid) | 更新するヘッダー。 |
| <a id="mutationauditeventsstreaminginstanceheadersupdatekey"></a>`key` | [`String`](#string) | ヘッダーキー。 |
| <a id="mutationauditeventsstreaminginstanceheadersupdatevalue"></a>`value` | [`String`](#string) | ヘッダー値。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminginstanceheadersupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreaminginstanceheadersupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationauditeventsstreaminginstanceheadersupdateheader"></a>`header` | [`AuditEventsStreamingInstanceHeader`](#auditeventsstreaminginstanceheader) | ヘッダーを更新します。 |

### `Mutation.awardEmojiAdd`

入力型: `AwardEmojiAddInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationawardemojiaddawardableid"></a>`awardableId` | [`AwardableID!`](#awardableid) | 授与可能リソースのグローバルID。 |
| <a id="mutationawardemojiaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationawardemojiaddname"></a>`name` | [`String!`](#string) | 絵文字の名前。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationawardemojiaddawardemoji"></a>`awardEmoji` | [`AwardEmoji`](#awardemoji) | 変異後の絵文字リアクション。 |
| <a id="mutationawardemojiaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationawardemojiadderrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.awardEmojiRemove`

入力型: `AwardEmojiRemoveInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationawardemojiremoveawardableid"></a>`awardableId` | [`AwardableID!`](#awardableid) | 授与可能リソースのグローバルID。 |
| <a id="mutationawardemojiremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationawardemojiremovename"></a>`name` | [`String!`](#string) | 絵文字の名前。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationawardemojiremoveawardemoji"></a>`awardEmoji` | [`AwardEmoji`](#awardemoji) | 変異後の絵文字リアクション。 |
| <a id="mutationawardemojiremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationawardemojiremoveerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.awardEmojiToggle`

入力型: `AwardEmojiToggleInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationawardemojitoggleawardableid"></a>`awardableId` | [`AwardableID!`](#awardableid) | 授与可能リソースのグローバルID。 |
| <a id="mutationawardemojitoggleclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationawardemojitogglename"></a>`name` | [`String!`](#string) | 絵文字の名前。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationawardemojitoggleawardemoji"></a>`awardEmoji` | [`AwardEmoji`](#awardemoji) | 変異後の絵文字リアクション。 |
| <a id="mutationawardemojitoggleclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationawardemojitoggleerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationawardemojitoggletoggledon"></a>`toggledOn` | [`Boolean!`](#boolean) | 絵文字の状態を示します。トグルが絵文字を付与した場合はtrue、トグルが絵文字を削除した場合はfalse。 |

### `Mutation.boardEpicCreate`

{{< details >}}GitLab 17.5で**非推奨**になりました。WorkItem型に置き換えられました。{{< /details >}}

入力型: `BoardEpicCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationboardepiccreateboardid"></a>`boardId` | [`BoardsEpicBoardID!`](#boardsepicboardid) | エピックの属するボードのグローバルID。 |
| <a id="mutationboardepiccreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationboardepiccreategrouppath"></a>`groupPath` | [`ID!`](#id) | 作成するエピックの属するグループ。 |
| <a id="mutationboardepiccreatelistid"></a>`listId` | [`BoardsEpicListID!`](#boardsepiclistid) | エピックを作成するエピックボードリストのグローバルID。 |
| <a id="mutationboardepiccreatetitle"></a>`title` | [`String!`](#string) | エピックのタイトル。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationboardepiccreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationboardepiccreateepic"></a>`epic` | [`Epic`](#epic) | 作成後のエピック。 |
| <a id="mutationboardepiccreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.boardListCreate`

入力型: `BoardListCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationboardlistcreateassigneeid"></a>`assigneeId` | [`UserID`](#userid) | 既存ユーザーのグローバルID。 |
| <a id="mutationboardlistcreatebacklog"></a>`backlog` | [`Boolean`](#boolean) | バックログリストを作成します。 |
| <a id="mutationboardlistcreateboardid"></a>`boardId` | [`BoardID!`](#boardid) | 変異対象のイシューボードのグローバルID。 |
| <a id="mutationboardlistcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationboardlistcreateiterationid"></a>`iterationId` | [`IterationID`](#iterationid) | 既存イテレーションのグローバルID。 |
| <a id="mutationboardlistcreatelabelid"></a>`labelId` | [`LabelID`](#labelid) | 既存ラベルのグローバルID。 |
| <a id="mutationboardlistcreatemilestoneid"></a>`milestoneId` | [`MilestoneID`](#milestoneid) | 既存マイルストーンのグローバルID。 |
| <a id="mutationboardlistcreateposition"></a>`position` | [`Int`](#int) | リストの位置。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationboardlistcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationboardlistcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationboardlistcreatelist"></a>`list` | [`BoardList`](#boardlist) | イシューボードのイシューリスト。 |

### `Mutation.boardListUpdateLimitMetrics`

入力型: `BoardListUpdateLimitMetricsInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationboardlistupdatelimitmetricsclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationboardlistupdatelimitmetricslimitmetric"></a>`limitMetric` | [`ListLimitMetric`](#listlimitmetric) | リスト用の新しい制限メトリクス型。 |
| <a id="mutationboardlistupdatelimitmetricslistid"></a>`listId` | [`ListID!`](#listid) | リストのグローバルID。 |
| <a id="mutationboardlistupdatelimitmetricsmaxissuecount"></a>`maxIssueCount` | [`Int`](#int) | 新しい最大イシュー数制限。 |
| <a id="mutationboardlistupdatelimitmetricsmaxissueweight"></a>`maxIssueWeight` | [`Int`](#int) | 新しい最大イシューウェイト制限。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationboardlistupdatelimitmetricsclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationboardlistupdatelimitmetricserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationboardlistupdatelimitmetricslist"></a>`list` | [`BoardList`](#boardlist) | 更新されたリスト。 |

### `Mutation.branchDelete`

入力型: `BranchDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationbranchdeletename"></a>`name` | [`String!`](#string) | ブランチの名前。 |
| <a id="mutationbranchdeleteprojectpath"></a>`projectPath` | [`ID!`](#id) | ブランチが関連付けられているプロジェクトのフルパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchdeletebranch"></a>`branch` | [`Branch`](#branch) | 変異後のブランチ。 |
| <a id="mutationbranchdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationbranchdeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.branchRuleApprovalProjectRuleCreate`

{{< details >}}GitLab 16.10で**導入**。**状態**: 実験。{{< /details >}}

入力型: `branchRuleApprovalProjectRuleCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleapprovalprojectrulecreateapprovalsrequired"></a>`approvalsRequired` | [`Int!`](#int) | ルールを満たすために必要な承認の数。 |
| <a id="mutationbranchruleapprovalprojectrulecreatebranchruleid"></a>`branchRuleId` | [`ProjectsBranchRuleID!`](#projectsbranchruleid) | 破棄するブランチルールのグローバルID。 |
| <a id="mutationbranchruleapprovalprojectrulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationbranchruleapprovalprojectrulecreategroupids"></a>`groupIds` | [`[ID!]`](#id) | 承認ルールを実行できるグループのIDのリスト。 |
| <a id="mutationbranchruleapprovalprojectrulecreatename"></a>`name` | [`String!`](#string) | 承認ルールの名前。 |
| <a id="mutationbranchruleapprovalprojectrulecreateuserids"></a>`userIds` | [`[ID!]`](#id) | 承認ルールを実行できるユーザーのIDのリスト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleapprovalprojectrulecreateapprovalrule"></a>`approvalRule` | [`ApprovalProjectRule`](#approvalprojectrule) | 変異後の承認ルール。 |
| <a id="mutationbranchruleapprovalprojectrulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationbranchruleapprovalprojectrulecreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.branchRuleCreate`

{{< details >}}GitLab 16.7で**導入**。**状態**: 実験。{{< /details >}}

入力型: `BranchRuleCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchrulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationbranchrulecreatename"></a>`name` | [`String!`](#string) | ブランチルールのブランチ名（ワイルドカードを含む）。 |
| <a id="mutationbranchrulecreateprojectpath"></a>`projectPath` | [`ID!`](#id) | ブランチが関連付けられているプロジェクトのフルパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchrulecreatebranchrule"></a>`branchRule` | [`BranchRule`](#branchrule) | 変異後のブランチルール。 |
| <a id="mutationbranchrulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationbranchrulecreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.branchRuleDelete`

{{< details >}}GitLab 16.9で**導入**。**状態**: 実験。{{< /details >}}

入力型: `BranchRuleDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchruledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationbranchruledeleteid"></a>`id` | [`ProjectsBranchRuleID!`](#projectsbranchruleid) | 破棄するブランチルールのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchruledeletebranchrule"></a>`branchRule` | [`BranchRule`](#branchrule) | 変異後のブランチルール。 |
| <a id="mutationbranchruledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationbranchruledeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.branchRuleExternalStatusCheckCreate`

ブランチルールから新しい外部状態チェックを作成します。

{{< details >}}GitLab 16.11で**導入**。**状態**: 実験。{{< /details >}}

入力型: `BranchRuleExternalStatusCheckCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleexternalstatuscheckcreatebranchruleid"></a>`branchRuleId` | [`ProjectsBranchRuleID!`](#projectsbranchruleid) | 更新するブランチルールのグローバルID。 |
| <a id="mutationbranchruleexternalstatuscheckcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationbranchruleexternalstatuscheckcreateexternalurl"></a>`externalUrl` | [`String!`](#string) | 外部状態チェックリソースのURL。 |
| <a id="mutationbranchruleexternalstatuscheckcreatename"></a>`name` | [`String!`](#string) | 外部状態チェックの名前。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleexternalstatuscheckcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationbranchruleexternalstatuscheckcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationbranchruleexternalstatuscheckcreateexternalstatuscheck"></a>`externalStatusCheck` | [`ExternalStatusCheck`](#externalstatuscheck) | 変異後の新しい状態チェック。 |

### `Mutation.branchRuleExternalStatusCheckDestroy`

ブランチルールから外部状態チェックを破棄します。

{{< details >}}GitLab 17.0で**導入**。**状態**: 実験。{{< /details >}}

入力型: `BranchRuleExternalStatusCheckDestroyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleexternalstatuscheckdestroybranchruleid"></a>`branchRuleId` | [`ProjectsBranchRuleID!`](#projectsbranchruleid) | ブランチルールのグローバルID。 |
| <a id="mutationbranchruleexternalstatuscheckdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationbranchruleexternalstatuscheckdestroyid"></a>`id` | [`MergeRequestsExternalStatusCheckID!`](#mergerequestsexternalstatuscheckid) | 破棄する外部状態チェックのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleexternalstatuscheckdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationbranchruleexternalstatuscheckdestroyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.branchRuleExternalStatusCheckUpdate`

ブランチルールから外部状態チェックを更新します。

{{< details >}}GitLab 17.0で**導入**。**状態**: 実験。{{< /details >}}

入力型: `BranchRuleExternalStatusCheckUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleexternalstatuscheckupdatebranchruleid"></a>`branchRuleId` | [`ProjectsBranchRuleID!`](#projectsbranchruleid) | ブランチルールのグローバルID。 |
| <a id="mutationbranchruleexternalstatuscheckupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationbranchruleexternalstatuscheckupdateexternalurl"></a>`externalUrl` | [`String!`](#string) | 外部状態チェックの外部URL。 |
| <a id="mutationbranchruleexternalstatuscheckupdateid"></a>`id` | [`MergeRequestsExternalStatusCheckID!`](#mergerequestsexternalstatuscheckid) | 更新する外部状態チェックのグローバルID。 |
| <a id="mutationbranchruleexternalstatuscheckupdatename"></a>`name` | [`String!`](#string) | 外部状態チェックの名前。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleexternalstatuscheckupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationbranchruleexternalstatuscheckupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationbranchruleexternalstatuscheckupdateexternalstatuscheck"></a>`externalStatusCheck` | [`ExternalStatusCheck`](#externalstatuscheck) | 変異後に更新された外部状態チェック。 |

### `Mutation.branchRuleSquashOptionDelete`

ブランチルールのスカッシュオプションを削除します。

{{< details >}}GitLab 17.9で**導入**。**状態**: 実験。{{< /details >}}

入力型: `BranchRuleSquashOptionDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchrulesquashoptiondeletebranchruleid"></a>`branchRuleId` | [`ProjectsBranchRuleID!`](#projectsbranchruleid) | ブランチルールのグローバルID。 |
| <a id="mutationbranchrulesquashoptiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchrulesquashoptiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationbranchrulesquashoptiondeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.branchRuleSquashOptionUpdate`

ブランチルールのスカッシュオプションを更新します。

{{< details >}}GitLab 17.9で**導入**。**状態**: 実験。{{< /details >}}

入力型: `BranchRuleSquashOptionUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchrulesquashoptionupdatebranchruleid"></a>`branchRuleId` | [`ProjectsBranchRuleID!`](#projectsbranchruleid) | ブランチルールのグローバルID。 |
| <a id="mutationbranchrulesquashoptionupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationbranchrulesquashoptionupdatesquashoption"></a>`squashOption` | [`SquashOptionSetting!`](#squashoptionsetting) | 変異後のスカッシュオプション。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchrulesquashoptionupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationbranchrulesquashoptionupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationbranchrulesquashoptionupdatesquashoption"></a>`squashOption` | [`SquashOption`](#squashoption) | 変異後に更新されたスカッシュオプション。 |

### `Mutation.branchRuleUpdate`

{{< details >}}GitLab 16.7で**導入**。**状態**: 実験。{{< /details >}}

入力型: `BranchRuleUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleupdatebranchprotection"></a>`branchProtection` | [`BranchProtectionInput`](#branchprotectioninput) | ブランチルールに設定されているブランチ保護。 |
| <a id="mutationbranchruleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationbranchruleupdateid"></a>`id` | [`ProjectsBranchRuleID!`](#projectsbranchruleid) | 更新するブランチルールのグローバルID。 |
| <a id="mutationbranchruleupdatename"></a>`name` | [`String!`](#string) | ブランチルールのブランチ名（ワイルドカードを含む）。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleupdatebranchrule"></a>`branchRule` | [`BranchRule`](#branchrule) | 変異後のブランチルール。 |
| <a id="mutationbranchruleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationbranchruleupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.bulkDestroyJobArtifacts`

{{< details >}}GitLab 15.10で**導入**。**状態**: 実験。{{< /details >}}

入力型: `BulkDestroyJobArtifactsInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbulkdestroyjobartifactsclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationbulkdestroyjobartifactsids"></a>`ids` | [`[CiJobArtifactID!]!`](#cijobartifactid) | 破棄するジョブアーティファクトのグローバルID。 |
| <a id="mutationbulkdestroyjobartifactsprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | 破棄するジョブアーティファクトのグローバルプロジェクトID。projectPathと互換性がありません。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbulkdestroyjobartifactsclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationbulkdestroyjobartifactsdestroyedcount"></a>`destroyedCount` | [`Int`](#int) | 削除されたジョブアーティファクトの数。 |
| <a id="mutationbulkdestroyjobartifactsdestroyedids"></a>`destroyedIds` | [`[CiJobArtifactID!]`](#cijobartifactid) | 削除されたジョブアーティファクトのID。 |
| <a id="mutationbulkdestroyjobartifactserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.bulkEnableDevopsAdoptionNamespaces`

**状態: **ベータ版。

入力型: `BulkEnableDevopsAdoptionNamespacesInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbulkenabledevopsadoptionnamespacesclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationbulkenabledevopsadoptionnamespacesdisplaynamespaceid"></a>`displayNamespaceId` | [`NamespaceID`](#namespaceid) | 表示ネームスペースID。 |
| <a id="mutationbulkenabledevopsadoptionnamespacesnamespaceids"></a>`namespaceIds` | [`[NamespaceID!]!`](#namespaceid) | ネームスペースIDのリスト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbulkenabledevopsadoptionnamespacesclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationbulkenabledevopsadoptionnamespacesenablednamespaces"></a>`enabledNamespaces` | [`[DevopsAdoptionEnabledNamespace!]`](#devopsadoptionenablednamespace) | 変異後に有効になったネームスペース。 |
| <a id="mutationbulkenabledevopsadoptionnamespaceserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.bulkRunnerDelete`

{{< details >}}GitLab 15.3で**導入**されました。**状態**: 実験。{{< /details >}}

入力型: `BulkRunnerDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbulkrunnerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationbulkrunnerdeleteids"></a>`ids` | [`[CiRunnerID!]`](#cirunnerid) | 削除するRunnerのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbulkrunnerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationbulkrunnerdeletedeletedcount"></a>`deletedCount` | [`Int`](#int) | 有効削除されたレコードの数。同期操作が実行された場合のみ存在します。 |
| <a id="mutationbulkrunnerdeletedeletedids"></a>`deletedIds` | [`[CiRunnerID!]`](#cirunnerid) | 有効削除されたレコードのID。同期操作が実行された場合のみ存在します。 |
| <a id="mutationbulkrunnerdeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.catalogResourcesCreate`

{{< details >}}GitLab 15.11で**導入**。**状態**: 実験。{{< /details >}}

入力型: `CatalogResourcesCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcatalogresourcescreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcatalogresourcescreateprojectpath"></a>`projectPath` | [`ID!`](#id) | カタログリソースに属するプロジェクトパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcatalogresourcescreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcatalogresourcescreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.catalogResourcesDestroy`

{{< details >}}GitLab 16.6で**導入**。**状態**: 実験。{{< /details >}}

入力型: `CatalogResourcesDestroyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcatalogresourcesdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcatalogresourcesdestroyprojectpath"></a>`projectPath` | [`ID!`](#id) | カタログリソースに属するプロジェクトパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcatalogresourcesdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcatalogresourcesdestroyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.ciJobTokenScopeAddGroupOrProject`

入力型: `CiJobTokenScopeAddGroupOrProjectInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeaddgrouporprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcijobtokenscopeaddgrouporprojectdefaultpermissions"></a>`defaultPermissions` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **非推奨: ****状態**: 実験。GitLab 17.8で導入。 |
| <a id="mutationcijobtokenscopeaddgrouporprojectjobtokenpolicies"></a>`jobTokenPolicies` {{< icon name="warning-solid" >}} | [`[CiJobTokenScopePolicies!]`](#cijobtokenscopepolicies) | **非推奨: ****状態**: 実験。GitLab 17.5で導入。 |
| <a id="mutationcijobtokenscopeaddgrouporprojectprojectpath"></a>`projectPath` | [`ID!`](#id) | CIジョブトークンスコープが属するプロジェクト。 |
| <a id="mutationcijobtokenscopeaddgrouporprojecttargetpath"></a>`targetPath` | [`ID!`](#id) | CIジョブトークンスコープに追加するグループまたはプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeaddgrouporprojectcijobtokenscope"></a>`ciJobTokenScope` | [`CiJobTokenScopeType`](#cijobtokenscopetype) | CI ジョブトークンのアクセススコープ。 |
| <a id="mutationcijobtokenscopeaddgrouporprojectcijobtokenscopeallowlistentry"></a>`ciJobTokenScopeAllowlistEntry` {{< icon name="warning-solid" >}} | [`CiJobTokenScopeAllowlistEntry`](#cijobtokenscopeallowlistentry) | **非推奨: ****状態**: 実験。GitLab 17.6で導入。 |
| <a id="mutationcijobtokenscopeaddgrouporprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcijobtokenscopeaddgrouporprojecterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.ciJobTokenScopeAddProject`

入力型: `CiJobTokenScopeAddProjectInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeaddprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcijobtokenscopeaddprojectdirection"></a>`direction` {{< icon name="warning-solid" >}} | [`CiJobTokenScopeDirection`](#cijobtokenscopedirection) | **非推奨: **送信ジョブトークンスコープは削除されます。現在のところ、このフィールドで可能な設定値はINBOUNDだけです。GitLab 16.0で非推奨になりました。 |
| <a id="mutationcijobtokenscopeaddprojectprojectpath"></a>`projectPath` | [`ID!`](#id) | CIジョブトークンスコープが属するプロジェクト。 |
| <a id="mutationcijobtokenscopeaddprojecttargetprojectpath"></a>`targetProjectPath` | [`ID!`](#id) | CIジョブトークンスコープに追加するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeaddprojectcijobtokenscope"></a>`ciJobTokenScope` | [`CiJobTokenScopeType`](#cijobtokenscopetype) | CI ジョブトークンのアクセススコープ。 |
| <a id="mutationcijobtokenscopeaddprojectcijobtokenscopeallowlistentry"></a>`ciJobTokenScopeAllowlistEntry` {{< icon name="warning-solid" >}} | [`CiJobTokenScopeAllowlistEntry`](#cijobtokenscopeallowlistentry) | **非推奨: ****状態**: 実験。GitLab 17.6で導入。 |
| <a id="mutationcijobtokenscopeaddprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcijobtokenscopeaddprojecterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.ciJobTokenScopeAutopopulateAllowlist`

{{< details >}}GitLab 17.9で**導入**。**状態**: 実験。{{< /details >}}

入力型: `CiJobTokenScopeAutopopulateAllowlistInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeautopopulateallowlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcijobtokenscopeautopopulateallowlistprojectpath"></a>`projectPath` | [`ID!`](#id) | 許可リストを自動設定するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeautopopulateallowlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcijobtokenscopeautopopulateallowlisterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationcijobtokenscopeautopopulateallowliststatus"></a>`status` | [`String!`](#string) | 自動設定プロセスの状態。 |

### `Mutation.ciJobTokenScopeClearAllowlistAutopopulations`

{{< details >}}GitLab 17.9で**導入**。**状態**: 実験。{{< /details >}}

入力型: `CiJobTokenScopeClearAllowlistAutopopulationsInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeclearallowlistautopopulationsclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcijobtokenscopeclearallowlistautopopulationsprojectpath"></a>`projectPath` | [`ID!`](#id) | 許可リストを自動設定するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeclearallowlistautopopulationsclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcijobtokenscopeclearallowlistautopopulationserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationcijobtokenscopeclearallowlistautopopulationsstatus"></a>`status` | [`String!`](#string) | 自動設定プロセスの状態。 |

### `Mutation.ciJobTokenScopeRemoveGroup`

入力型: `CiJobTokenScopeRemoveGroupInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscoperemovegroupclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcijobtokenscoperemovegroupprojectpath"></a>`projectPath` | [`ID!`](#id) | CIジョブトークンスコープが属するプロジェクト。 |
| <a id="mutationcijobtokenscoperemovegrouptargetgrouppath"></a>`targetGroupPath` | [`ID!`](#id) | CIジョブトークンスコープから削除するグループ。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscoperemovegroupcijobtokenscope"></a>`ciJobTokenScope` | [`CiJobTokenScopeType`](#cijobtokenscopetype) | CI ジョブトークンのアクセススコープ。 |
| <a id="mutationcijobtokenscoperemovegroupcijobtokenscopeallowlistentry"></a>`ciJobTokenScopeAllowlistEntry` {{< icon name="warning-solid" >}} | [`CiJobTokenScopeAllowlistEntry`](#cijobtokenscopeallowlistentry) | **非推奨: ****状態**: 実験。GitLab 17.6で導入。 |
| <a id="mutationcijobtokenscoperemovegroupclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcijobtokenscoperemovegrouperrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.ciJobTokenScopeRemoveProject`

入力型: `CiJobTokenScopeRemoveProjectInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscoperemoveprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcijobtokenscoperemoveprojectdirection"></a>`direction` {{< icon name="warning-solid" >}} | [`CiJobTokenScopeDirection`](#cijobtokenscopedirection) | **非推奨: **送信ジョブトークンスコープは削除されます。現在のところ、このフィールドで可能な設定値はINBOUNDだけです。GitLab 16.9で非推奨になりました。 |
| <a id="mutationcijobtokenscoperemoveprojectprojectpath"></a>`projectPath` | [`ID!`](#id) | CIジョブトークンスコープが属するプロジェクト。 |
| <a id="mutationcijobtokenscoperemoveprojecttargetprojectpath"></a>`targetProjectPath` | [`ID!`](#id) | CIジョブトークンスコープから削除するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscoperemoveprojectcijobtokenscope"></a>`ciJobTokenScope` | [`CiJobTokenScopeType`](#cijobtokenscopetype) | CI ジョブトークンのアクセススコープ。 |
| <a id="mutationcijobtokenscoperemoveprojectcijobtokenscopeallowlistentry"></a>`ciJobTokenScopeAllowlistEntry` {{< icon name="warning-solid" >}} | [`CiJobTokenScopeAllowlistEntry`](#cijobtokenscopeallowlistentry) | **非推奨: ****状態**: 実験。GitLab 17.6で導入。 |
| <a id="mutationcijobtokenscoperemoveprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcijobtokenscoperemoveprojecterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.ciJobTokenScopeUpdatePolicies`

{{< details >}}GitLab 17.6で**導入**。**状態**: 実験。{{< /details >}}

入力型: `CiJobTokenScopeUpdatePoliciesInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeupdatepoliciesclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcijobtokenscopeupdatepoliciesdefaultpermissions"></a>`defaultPermissions` | [`Boolean!`](#boolean) | デフォルトの権限が有効か（true）、きめ細かい権限が有効か（false）を示します。 |
| <a id="mutationcijobtokenscopeupdatepoliciesjobtokenpolicies"></a>`jobTokenPolicies` | [`[CiJobTokenScopePolicies!]!`](#cijobtokenscopepolicies) | CIジョブトークンスコープに追加されたポリシーのリスト。 |
| <a id="mutationcijobtokenscopeupdatepoliciesprojectpath"></a>`projectPath` | [`ID!`](#id) | CIジョブトークンスコープが属するプロジェクト。 |
| <a id="mutationcijobtokenscopeupdatepoliciestargetpath"></a>`targetPath` | [`ID!`](#id) | CIジョブトークンのターゲットとなるグループまたはプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeupdatepoliciescijobtokenscopeallowlistentry"></a>`ciJobTokenScopeAllowlistEntry` {{< icon name="warning-solid" >}} | [`CiJobTokenScopeAllowlistEntry`](#cijobtokenscopeallowlistentry) | **非推奨: ****状態**: 実験。GitLab 17.6で導入。 |
| <a id="mutationcijobtokenscopeupdatepoliciesclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcijobtokenscopeupdatepolicieserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.clusterAgentDelete`

入力型: `ClusterAgentDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationclusteragentdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationclusteragentdeleteid"></a>`id` | [`ClustersAgentID!`](#clustersagentid) | 削除するクラスターエージェントのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationclusteragentdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationclusteragentdeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.clusterAgentTokenCreate`

入力型: `ClusterAgentTokenCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenttokencreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationclusteragenttokencreateclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID!`](#clustersagentid) | 新しいトークンに関連付けられるクラスターエージェントのグローバルID。 |
| <a id="mutationclusteragenttokencreatedescription"></a>`description` | [`String`](#string) | トークンの説明。 |
| <a id="mutationclusteragenttokencreatename"></a>`name` | [`String!`](#string) | トークンの名前。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenttokencreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationclusteragenttokencreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationclusteragenttokencreatesecret"></a>`secret` | [`String`](#string) | トークンのシークレット値。必ず保存してください。そうしない場合、再度アクセスできなくなります。 |
| <a id="mutationclusteragenttokencreatetoken"></a>`token` | [`ClusterAgentToken`](#clusteragenttoken) | 変異後に作成されたトークン。 |

### `Mutation.clusterAgentTokenRevoke`

入力型: `ClusterAgentTokenRevokeInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenttokenrevokeclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationclusteragenttokenrevokeid"></a>`id` | [`ClustersAgentTokenID!`](#clustersagenttokenid) | 失効するエージェントトークンのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenttokenrevokeclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationclusteragenttokenrevokeerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.clusterAgentUrlConfigurationCreate`

入力型: `ClusterAgentUrlConfigurationCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenturlconfigurationcreatecacert"></a>`caCert` | [`String`](#string) | エージェントエンドポイントを検証するための、PEM形式Base64エンコードのCA証明書。 |
| <a id="mutationclusteragenturlconfigurationcreateclientcert"></a>`clientCert` | [`String`](#string) | mTLS認証を使用する場合、PEM形式Base64エンコードのクライアント証明書。`client_key`と共に指定する必要があります。 |
| <a id="mutationclusteragenturlconfigurationcreateclientkey"></a>`clientKey` | [`String`](#string) | mTLS認証を使用する場合、PEM形式Base64エンコードのクライアントキー。`client_cert`と共に指定する必要があります。 |
| <a id="mutationclusteragenturlconfigurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationclusteragenturlconfigurationcreateclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID!`](#clustersagentid) | 新しいURL設定に関連付けられるクラスターエージェントのグローバルID。 |
| <a id="mutationclusteragenturlconfigurationcreatetlshost"></a>`tlsHost` | [`String`](#string) | エージェントエンドポイント証明書のサーバー名を検証するためのTLSホスト名。 |
| <a id="mutationclusteragenturlconfigurationcreateurl"></a>`url` | [`String!`](#string) | 新しいURL設定のURL。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenturlconfigurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationclusteragenturlconfigurationcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationclusteragenturlconfigurationcreateurlconfiguration"></a>`urlConfiguration` | [`ClusterAgentUrlConfiguration`](#clusteragenturlconfiguration) | 変異後に作成されたURL設定。 |

### `Mutation.clusterAgentUrlConfigurationDelete`

入力型: `ClusterAgentUrlConfigurationDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenturlconfigurationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationclusteragenturlconfigurationdeleteid"></a>`id` | [`ClustersAgentsUrlConfigurationID!`](#clustersagentsurlconfigurationid) | 削除するエージェントURL設定のグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenturlconfigurationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationclusteragenturlconfigurationdeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.commitCreate`

入力型: `CommitCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcommitcreateactions"></a>`actions` | [`[CommitAction!]!`](#commitaction) | バッチとしてコミットするアクションハッシュの配列。 |
| <a id="mutationcommitcreatebranch"></a>`branch` | [`String!`](#string) | コミットするブランチの名前。新しいブランチも可能。 |
| <a id="mutationcommitcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcommitcreatemessage"></a>`message` | [`String!`](#string) | rawコミットメッセージ。 |
| <a id="mutationcommitcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | ブランチが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationcommitcreatestartbranch"></a>`startBranch` | [`String`](#string) | 新しいブランチの場合、元のブランチの名前。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcommitcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcommitcreatecommit"></a>`commit` | [`Commit`](#commit) | 変異後のコミット。 |
| <a id="mutationcommitcreatecommitpipelinepath"></a>`commitPipelinePath` | [`String`](#string) | コミットのパイプラインのETagパス。 |
| <a id="mutationcommitcreatecontent"></a>`content` | [`[String!]`](#string) | コミットの内容。 |
| <a id="mutationcommitcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.configureContainerScanning`

新しいブランチの新規または変更後`.gitlab-ci.yml`ファイルでコンテナスキャンを有効にすることにより、プロジェクトのコンテナスキャンを設定します。新しいブランチとマージリクエストを作成するためのURLが、応答の一部として含まれます。

入力型: `ConfigureContainerScanningInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationconfigurecontainerscanningclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationconfigurecontainerscanningprojectpath"></a>`projectPath` | [`ID!`](#id) | プロジェクトのフルパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationconfigurecontainerscanningbranch"></a>`branch` | [`String`](#string) | 新規/変更後`.gitlab-ci.yml`ファイルのあるブランチ。 |
| <a id="mutationconfigurecontainerscanningclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationconfigurecontainerscanningerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationconfigurecontainerscanningsuccesspath"></a>`successPath` | [`String`](#string) | 応答成功の場合に使用するリダイレクトパス。 |

### `Mutation.configureDependencyScanning`

新しいブランチの新規または変更後`.gitlab-ci.yml`ファイルで依存関係スキャンを有効にすることにより、プロジェクトの依存関係スキャンを設定します。新しいブランチとマージリクエストを作成するためのURLが、応答の一部として含まれます。

入力型: `ConfigureDependencyScanningInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationconfiguredependencyscanningclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationconfiguredependencyscanningprojectpath"></a>`projectPath` | [`ID!`](#id) | プロジェクトのフルパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationconfiguredependencyscanningbranch"></a>`branch` | [`String`](#string) | 新規/変更後`.gitlab-ci.yml`ファイルのあるブランチ。 |
| <a id="mutationconfiguredependencyscanningclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationconfiguredependencyscanningerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationconfiguredependencyscanningsuccesspath"></a>`successPath` | [`String`](#string) | 応答成功の場合に使用するリダイレクトパス。 |

### `Mutation.configureSast`

新しいブランチの新規または変更後`.gitlab-ci.yml`ファイルでSASTを有効にすることにより、プロジェクトのSASTを設定します。新しいブランチとマージリクエストを作成するためのURLが、応答の一部として含まれます。

入力型: `ConfigureSastInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationconfiguresastclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationconfiguresastconfiguration"></a>`configuration` | [`SastCiConfigurationInput!`](#sastciconfigurationinput) | プロジェクトのSAST CI設定。 |
| <a id="mutationconfiguresastprojectpath"></a>`projectPath` | [`ID!`](#id) | プロジェクトのフルパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationconfiguresastbranch"></a>`branch` | [`String`](#string) | 新規/変更後`.gitlab-ci.yml`ファイルのあるブランチ。 |
| <a id="mutationconfiguresastclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationconfiguresasterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationconfiguresastsuccesspath"></a>`successPath` | [`String`](#string) | 応答成功の場合に使用するリダイレクトパス。 |

### `Mutation.configureSastIac`

新しいブランチの新規または変更後`.gitlab-ci.yml`ファイルで、プロジェクトに対しSAST IaCを有効にします。新しいブランチとマージリクエストを作成するためのURLが、応答の一部として含まれます。

入力型: `ConfigureSastIacInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationconfiguresastiacclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationconfiguresastiacprojectpath"></a>`projectPath` | [`ID!`](#id) | プロジェクトのフルパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationconfiguresastiacbranch"></a>`branch` | [`String`](#string) | 新規/変更後`.gitlab-ci.yml`ファイルのあるブランチ。 |
| <a id="mutationconfiguresastiacclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationconfiguresastiacerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationconfiguresastiacsuccesspath"></a>`successPath` | [`String`](#string) | 応答成功の場合に使用するリダイレクトパス。 |

### `Mutation.configureSecretDetection`

新しいブランチの新規または変更後`.gitlab-ci.yml`ファイルでシークレット検出を有効にすることにより、プロジェクトのシークレット検出を設定します。新しいブランチとマージリクエストを作成するためのURLが、応答の一部として含まれます。

入力型: `ConfigureSecretDetectionInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationconfiguresecretdetectionclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationconfiguresecretdetectionprojectpath"></a>`projectPath` | [`ID!`](#id) | プロジェクトのフルパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationconfiguresecretdetectionbranch"></a>`branch` | [`String`](#string) | 新規/変更後`.gitlab-ci.yml`ファイルのあるブランチ。 |
| <a id="mutationconfiguresecretdetectionclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationconfiguresecretdetectionerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationconfiguresecretdetectionsuccesspath"></a>`successPath` | [`String`](#string) | 応答成功の場合に使用するリダイレクトパス。 |

### `Mutation.corpusCreate`

入力型: `CorpusCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcorpuscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcorpuscreatefullpath"></a>`fullPath` | [`ID!`](#id) | コーパスが属するプロジェクト。 |
| <a id="mutationcorpuscreatepackageid"></a>`packageId` | [`PackagesPackageID!`](#packagespackageid) | コーパスパッケージのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcorpuscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcorpuscreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.createAbuseReportNote`

不正行為レポートのノートを作成します。

入力型: `CreateAbuseReportNoteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateabusereportnoteabusereportid"></a>`abuseReportId` | [`AbuseReportID!`](#abusereportid) | 不正行為レポートのID。 |
| <a id="mutationcreateabusereportnotebody"></a>`body` | [`String!`](#string) | ノートの内容。 |
| <a id="mutationcreateabusereportnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreateabusereportnotediscussionid"></a>`discussionId` | [`DiscussionID`](#discussionid) | ノートを含める返信の対象となる不正行為レポートディスカッションのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateabusereportnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreateabusereportnoteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationcreateabusereportnotenote"></a>`note` | [`AbuseReportNote`](#abusereportnote) | 変異後の不正行為レポートノート。 |

### `Mutation.createAlertIssue`

入力型: `CreateAlertIssueInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatealertissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreatealertissueiid"></a>`iid` | [`String!`](#string) | 変異対象のアラートのIID。 |
| <a id="mutationcreatealertissueprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のアラートの属するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatealertissuealert"></a>`alert` | [`AlertManagementAlert`](#alertmanagementalert) | 変異後のアラート。 |
| <a id="mutationcreatealertissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreatealertissueerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationcreatealertissueissue"></a>`issue` | [`Issue`](#issue) | 変異後に作成されたイシュー。 |
| <a id="mutationcreatealertissuetodo"></a>`todo` | [`Todo`](#todo) | 変異後のTo Doアイテム。 |

### `Mutation.createAnnotation`

{{< details >}}GitLab 16.0で**非推奨**になりました。基盤となる機能は16.0で削除されました。{{< /details >}}

入力型: `CreateAnnotationInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateannotationclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreateannotationclusterid"></a>`clusterId` | [`ClustersClusterID`](#clustersclusterid) | アノテーション追加先のクラスターのグローバルID。 |
| <a id="mutationcreateannotationdashboardpath"></a>`dashboardPath` | [`String!`](#string) | アノテーションを追加するダッシュボードを定義するファイルのパス。 |
| <a id="mutationcreateannotationdescription"></a>`description` | [`String!`](#string) | アノテーションの説明。 |
| <a id="mutationcreateannotationendingat"></a>`endingAt` | [`Time`](#time) | アノテーションが関係する終了時点を示すタイムスタンプ。 |
| <a id="mutationcreateannotationenvironmentid"></a>`environmentId` | [`EnvironmentID`](#environmentid) | アノテーション追加先の環境のグローバルID。 |
| <a id="mutationcreateannotationstartingat"></a>`startingAt` | [`Time!`](#time) | アノテーションが関係する開始時点を示すタイムスタンプ。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateannotationannotation"></a>`annotation` | [`MetricsDashboardAnnotation`](#metricsdashboardannotation) | 作成されたアノテーション。 |
| <a id="mutationcreateannotationclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreateannotationerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.createBoard`

入力型: `CreateBoardInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateboardassigneeid"></a>`assigneeId` | [`UserID`](#userid) | ボードに割り当てるユーザーのID。 |
| <a id="mutationcreateboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreateboardgrouppath"></a>`groupPath` | [`ID`](#id) | リソースが関連付けられているグループのフルパス。 |
| <a id="mutationcreateboardhidebackloglist"></a>`hideBacklogList` | [`Boolean`](#boolean) | バックログリストを非表示にするかどうか。 |
| <a id="mutationcreateboardhideclosedlist"></a>`hideClosedList` | [`Boolean`](#boolean) | 完了リストを非表示にするかどうか。 |
| <a id="mutationcreateboarditerationcadenceid"></a>`iterationCadenceId` | [`IterationsCadenceID`](#iterationscadenceid) | ボードに割り当てるイテレーションケイデンスのID。 |
| <a id="mutationcreateboarditerationid"></a>`iterationId` | [`IterationID`](#iterationid) | ボードに割り当てるイテレーションのID。 |
| <a id="mutationcreateboardlabelids"></a>`labelIds` | [`[LabelID!]`](#labelid) | ボードに追加するラベルのID。 |
| <a id="mutationcreateboardlabels"></a>`labels` | [`[String!]`](#string) | イシューのラベル。 |
| <a id="mutationcreateboardmilestoneid"></a>`milestoneId` | [`MilestoneID`](#milestoneid) | ボードに割り当てるマイルストーンのID。 |
| <a id="mutationcreateboardname"></a>`name` | [`String`](#string) | ボード名。 |
| <a id="mutationcreateboardprojectpath"></a>`projectPath` | [`ID`](#id) | リソースが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationcreateboardweight"></a>`weight` | [`Int`](#int) | ボードに割り当てるウェイト値。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateboardboard"></a>`board` | [`Board`](#board) | 変異後のボード。 |
| <a id="mutationcreateboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreateboarderrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.createBranch`

入力型: `CreateBranchInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatebranchclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreatebranchname"></a>`name` | [`String!`](#string) | ブランチの名前。 |
| <a id="mutationcreatebranchprojectpath"></a>`projectPath` | [`ID!`](#id) | ブランチが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationcreatebranchref"></a>`ref` | [`String!`](#string) | ブランチの作成元となるブランチ名またはコミットSHA。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatebranchbranch"></a>`branch` | [`Branch`](#branch) | 変異後のブランチ。 |
| <a id="mutationcreatebranchclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreatebrancherrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.createClusterAgent`

入力型: `CreateClusterAgentInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateclusteragentclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreateclusteragentname"></a>`name` | [`String!`](#string) | クラスターエージェントの名前。 |
| <a id="mutationcreateclusteragentprojectpath"></a>`projectPath` | [`ID!`](#id) | クラスターエージェントの関連プロジェクトのフルパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateclusteragentclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreateclusteragentclusteragent"></a>`clusterAgent` | [`ClusterAgent`](#clusteragent) | 変異後に作成されたクラスターエージェント。 |
| <a id="mutationcreateclusteragenterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.createComplianceFramework`

入力型: `CreateComplianceFrameworkInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatecomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreatecomplianceframeworknamespacepath"></a>`namespacePath` | [`ID!`](#id) | コンプライアンスフレームワークの追加先ネームスペースのフルパス。 |
| <a id="mutationcreatecomplianceframeworkparams"></a>`params` | [`ComplianceFrameworkInput!`](#complianceframeworkinput) | コンプライアンスフレームワークを更新するためのパラメータ。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatecomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreatecomplianceframeworkerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationcreatecomplianceframeworkframework"></a>`framework` | [`ComplianceFramework`](#complianceframework) | 作成されたコンプライアンスフレームワーク。 |

### `Mutation.createComplianceRequirement`

{{< details >}}GitLab 17.6で**導入**。**状態**: 実験。{{< /details >}}

入力型: `CreateComplianceRequirementInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatecompliancerequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreatecompliancerequirementcomplianceframeworkid"></a>`complianceFrameworkId` | [`ComplianceManagementFrameworkID!`](#compliancemanagementframeworkid) | 新しい要件のコンプライアンスフレームワークのグローバルID。 |
| <a id="mutationcreatecompliancerequirementcontrols"></a>`controls` | [`[ComplianceRequirementsControlInput!]`](#compliancerequirementscontrolinput) | コンプライアンス要件に追加するコントロール。 |
| <a id="mutationcreatecompliancerequirementparams"></a>`params` | [`ComplianceRequirementInput!`](#compliancerequirementinput) | コンプライアンス要件を更新するためのパラメータ。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatecompliancerequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreatecompliancerequirementerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationcreatecompliancerequirementrequirement"></a>`requirement` | [`ComplianceRequirement`](#compliancerequirement) | 作成されたコンプライアンス要件。 |

### `Mutation.createComplianceRequirementsControl`

{{< details >}}GitLab 17.9で**導入**。**状態**: 実験。{{< /details >}}

入力型: `CreateComplianceRequirementsControlInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatecompliancerequirementscontrolclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreatecompliancerequirementscontrolcompliancerequirementid"></a>`complianceRequirementId` | [`ComplianceManagementComplianceFrameworkComplianceRequirementID!`](#compliancemanagementcomplianceframeworkcompliancerequirementid) | 新しいコントロールのコンプライアンス要件のグローバルID。 |
| <a id="mutationcreatecompliancerequirementscontrolparams"></a>`params` | [`ComplianceRequirementsControlInput!`](#compliancerequirementscontrolinput) | コンプライアンス要件コントロールを作成するためのパラメータ。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatecompliancerequirementscontrolclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreatecompliancerequirementscontrolerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationcreatecompliancerequirementscontrolrequirementscontrol"></a>`requirementsControl` | [`ComplianceRequirementsControl`](#compliancerequirementscontrol) | 作成されたコンプライアンス要件コントロール。 |

### `Mutation.createContainerProtectionRepositoryRule`

プロジェクトのコンテナレジストリへのアクセスを制限するためのリポジトリ保護ルールを作成します。

入力型: `CreateContainerProtectionRepositoryRuleInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatecontainerprotectionrepositoryruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreatecontainerprotectionrepositoryruleminimumaccesslevelfordelete"></a>`minimumAccessLevelForDelete` | [`ContainerProtectionRepositoryRuleAccessLevel`](#containerprotectionrepositoryruleaccesslevel) | コンテナリポジトリからコンテナイメージを削除するために必要な最小GitLabアクセスレベル。有効な値には`MAINTAINER`、`OWNER`、または`ADMIN`が含まれます。値が`nil`の場合のデフォルトの最小アクセスレベルは`DEVELOPER`です。 |
| <a id="mutationcreatecontainerprotectionrepositoryruleminimumaccesslevelforpush"></a>`minimumAccessLevelForPush` | [`ContainerProtectionRepositoryRuleAccessLevel`](#containerprotectionrepositoryruleaccesslevel) | コンテナイメージをコンテナリポジトリにプッシュするために必要な最小GitLabアクセスレベル。有効な値には`MAINTAINER`、`OWNER`、または`ADMIN`が含まれます。値が`nil`の場合のデフォルトの最小アクセスレベルは`DEVELOPER`です。 |
| <a id="mutationcreatecontainerprotectionrepositoryruleprojectpath"></a>`projectPath` | [`ID!`](#id) | 保護ルールの属するプロジェクトのフルパス。 |
| <a id="mutationcreatecontainerprotectionrepositoryrulerepositorypathpattern"></a>`repositoryPathPattern` | [`String!`](#string) | 保護ルールによって保護されるコンテナリポジトリパスパターン。先頭がプロジェクトのフルパスでなければなりません。例: `my-project/*-prod-*`。ワイルドカード文字`*`は、プロジェクトのフルパスの後のどこにでも使用できます。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatecontainerprotectionrepositoryruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreatecontainerprotectionrepositoryrulecontainerprotectionrepositoryrule"></a>`containerProtectionRepositoryRule` | [`ContainerProtectionRepositoryRule`](#containerprotectionrepositoryrule) | 変異後のコンテナリポジトリ保護ルール。 |
| <a id="mutationcreatecontainerprotectionrepositoryruleerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.createContainerProtectionTagRule`

指定されたパターンに一致するコンテナイメージタグに変更を加えることのできるユーザーロールを制御する保護ルールを作成します。機能フラグ`container_registry_protected_tags`が有効な場合にのみ使用可能。

{{< details >}}GitLab 17.8で**導入**。**状態**: 実験。{{< /details >}}

入力型: `createContainerProtectionTagRuleInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatecontainerprotectiontagruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreatecontainerprotectiontagruleminimumaccesslevelfordelete"></a>`minimumAccessLevelForDelete` | [`ContainerProtectionTagRuleAccessLevel`](#containerprotectiontagruleaccesslevel) | コンテナリポジトリからコンテナイメージタグを削除するために必要な最小GitLabアクセスレベル。有効な値には`MAINTAINER`、`OWNER`、または`ADMIN`が含まれます。値が`nil`の場合、最小アクセスレベルは適用されません。デフォルトでは、デベロッパーロール以上のユーザーがタグを削除できます。GitLab 17.8で導入。**状態**: 実験。 |
| <a id="mutationcreatecontainerprotectiontagruleminimumaccesslevelforpush"></a>`minimumAccessLevelForPush` | [`ContainerProtectionTagRuleAccessLevel`](#containerprotectiontagruleaccesslevel) | コンテナイメージタグをコンテナリポジトリにプッシュするために必要な最小GitLabアクセスレベル。有効な値には`MAINTAINER`、`OWNER`、または`ADMIN`が含まれます。値が`nil`の場合、最小アクセスレベルは適用されません。デフォルトでは、デベロッパーロール以上のユーザーがタグをプッシュできます。GitLab 17.8で導入。**状態**: 実験。 |
| <a id="mutationcreatecontainerprotectiontagruleprojectpath"></a>`projectPath` | [`ID!`](#id) | コンテナイメージタグを含むプロジェクトのフルパス。 |
| <a id="mutationcreatecontainerprotectiontagruletagnamepattern"></a>`tagNamePattern` | [`String!`](#string) | 保護するコンテナイメージタグに一致するパターン。例：`v1.*`。ワイルドカード文字`*`を使用できます。GitLab 17.8で導入。**状態**: 実験。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatecontainerprotectiontagruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreatecontainerprotectiontagrulecontainerprotectiontagrule"></a>`containerProtectionTagRule` {{< icon name="warning-solid" >}} | [`ContainerProtectionTagRule`](#containerprotectiontagrule) | **非推奨: ****状態**: 実験。GitLab 17.8で導入。 |
| <a id="mutationcreatecontainerprotectiontagruleerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.createCustomEmoji`

入力型: `CreateCustomEmojiInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatecustomemojiclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreatecustomemojigrouppath"></a>`groupPath` | [`ID!`](#id) | 絵文字が関連付けられているネームスペースのフルパス。 |
| <a id="mutationcreatecustomemojiname"></a>`name` | [`String!`](#string) | 絵文字の名前。 |
| <a id="mutationcreatecustomemojiurl"></a>`url` | [`String!`](#string) | 絵文字ファイルの場所。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatecustomemojiclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreatecustomemojicustomemoji"></a>`customEmoji` | [`CustomEmoji`](#customemoji) | 新しいカスタム絵文字。 |
| <a id="mutationcreatecustomemojierrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.createDiffNote`

入力型: `CreateDiffNoteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatediffnotebody"></a>`body` | [`String!`](#string) | ノートの内容。 |
| <a id="mutationcreatediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreatediffnoteinternal"></a>`internal` | [`Boolean`](#boolean) | ノートの内部フラグ。デフォルトはfalseです。 |
| <a id="mutationcreatediffnotenoteableid"></a>`noteableId` | [`NoteableID!`](#noteableid) | ノート追加先のリソースのグローバルID。 |
| <a id="mutationcreatediffnoteposition"></a>`position` | [`DiffPositionInput!`](#diffpositioninput) | 差分に関するノートの位置。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreatediffnoteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationcreatediffnotenote"></a>`note` | [`Note`](#note) | 変異後のノート。 |
| <a id="mutationcreatediffnotequickactionsstatus"></a>`quickActionsStatus` | [`QuickActionsStatus`](#quickactionsstatus) | 変異後のクイックアクションの状態。 |

### `Mutation.createDiscussion`

入力型: `CreateDiscussionInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatediscussionbody"></a>`body` | [`String!`](#string) | ノートの内容。 |
| <a id="mutationcreatediscussionclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreatediscussioninternal"></a>`internal` | [`Boolean`](#boolean) | ノートの内部フラグ。デフォルトはfalseです。 |
| <a id="mutationcreatediscussionnoteableid"></a>`noteableId` | [`NoteableID!`](#noteableid) | ノート追加先のリソースのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatediscussionclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreatediscussionerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationcreatediscussionnote"></a>`note` | [`Note`](#note) | 変異後のノート。 |
| <a id="mutationcreatediscussionquickactionsstatus"></a>`quickActionsStatus` | [`QuickActionsStatus`](#quickactionsstatus) | 変異後のクイックアクションの状態。 |

### `Mutation.createEpic`

{{< details >}}GitLab 17.5で**非推奨**になりました。WorkItem型に置き換えられました。{{< /details >}}

入力型: `CreateEpicInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateepicaddlabelids"></a>`addLabelIds` | [`[ID!]`](#id) | エピックに追加するラベルのID。 |
| <a id="mutationcreateepicaddlabels"></a>`addLabels` | [`[String!]`](#string) | エピックに追加するラベルの配列。 |
| <a id="mutationcreateepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreateepiccolor"></a>`color` | [`Color`](#color) | エピックの色。 |
| <a id="mutationcreateepicconfidential"></a>`confidential` | [`Boolean`](#boolean) | エピックが機密かどうかを示します。 |
| <a id="mutationcreateepicdescription"></a>`description` | [`String`](#string) | エピックの説明。 |
| <a id="mutationcreateepicduedatefixed"></a>`dueDateFixed` | [`String`](#string) | エピックの終了日。 |
| <a id="mutationcreateepicduedateisfixed"></a>`dueDateIsFixed` | [`Boolean`](#boolean) | 終了日をイシューのマイルストーンではなく、due_date_fixedフィールドから取得することを示します。 |
| <a id="mutationcreateepicgrouppath"></a>`groupPath` | [`ID!`](#id) | 変異対象のエピックの属するグループ。 |
| <a id="mutationcreateepicremovelabelids"></a>`removeLabelIds` | [`[ID!]`](#id) | エピックから削除するラベルのID。 |
| <a id="mutationcreateepicstartdatefixed"></a>`startDateFixed` | [`String`](#string) | エピックの開始日。 |
| <a id="mutationcreateepicstartdateisfixed"></a>`startDateIsFixed` | [`Boolean`](#boolean) | 開始日をイシューのマイルストーンではなく、start_date_fixedフィールドから取得することを示します。 |
| <a id="mutationcreateepictitle"></a>`title` | [`String`](#string) | エピックのタイトル。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreateepicepic"></a>`epic` | [`Epic`](#epic) | 作成されたエピック。 |
| <a id="mutationcreateepicerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.createImageDiffNote`

入力型: `CreateImageDiffNoteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateimagediffnotebody"></a>`body` | [`String!`](#string) | ノートの内容。 |
| <a id="mutationcreateimagediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreateimagediffnoteinternal"></a>`internal` | [`Boolean`](#boolean) | ノートの内部フラグ。デフォルトはfalseです。 |
| <a id="mutationcreateimagediffnotenoteableid"></a>`noteableId` | [`NoteableID!`](#noteableid) | ノート追加先のリソースのグローバルID。 |
| <a id="mutationcreateimagediffnoteposition"></a>`position` | [`DiffImagePositionInput!`](#diffimagepositioninput) | 差分に関するノートの位置。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateimagediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreateimagediffnoteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationcreateimagediffnotenote"></a>`note` | [`Note`](#note) | 変異後のノート。 |
| <a id="mutationcreateimagediffnotequickactionsstatus"></a>`quickActionsStatus` | [`QuickActionsStatus`](#quickactionsstatus) | 変異後のクイックアクションの状態。 |

### `Mutation.createIssue`

入力型: `CreateIssueInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateissueassigneeids"></a>`assigneeIds` | [`[UserID!]`](#userid) | イシューに割り当てるユーザーIDの配列。 |
| <a id="mutationcreateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreateissueconfidential"></a>`confidential` | [`Boolean`](#boolean) | イシューが機密であることを示します。 |
| <a id="mutationcreateissuecreatedat"></a>`createdAt` | [`Time`](#time) | イシュー作成時のタイムスタンプ。管理者とプロジェクトオーナーのみが使用できます。 |
| <a id="mutationcreateissuedescription"></a>`description` | [`String`](#string) | イシューの説明。 |
| <a id="mutationcreateissuediscussiontoresolve"></a>`discussionToResolve` | [`String`](#string) | 解決するディスカッションのID。`merge_request_to_resolve_discussions_of`も渡してください。 |
| <a id="mutationcreateissueduedate"></a>`dueDate` | [`ISO8601Date`](#iso8601date) | イシューの期限。 |
| <a id="mutationcreateissueepicid"></a>`epicId` {{< icon name="warning-solid" >}} | [`EpicID`](#epicid) | **非推奨: **これはWorkItem hierarchyWidgetに置き換えられる予定です。GitLab 17.5で非推奨になりました。 |
| <a id="mutationcreateissuehealthstatus"></a>`healthStatus` | [`HealthStatus`](#healthstatus) | 目的のヘルスステータス。 |
| <a id="mutationcreateissueiid"></a>`iid` | [`Int`](#int) | プロジェクトイシューのIID（内部ID）。これを変更できるのは管理者とプロジェクトオーナーだけです。 |
| <a id="mutationcreateissueiterationcadenceid"></a>`iterationCadenceId` | [`IterationsCadenceID`](#iterationscadenceid) | グローバルイテレーションケイデンスID。`iterationWildcardId`が指定されている場合は必須。 |
| <a id="mutationcreateissueiterationid"></a>`iterationId` | [`IterationID`](#iterationid) | グローバルイテレーションID。`iterationWildcardId`と相互排他的な引数。 |
| <a id="mutationcreateissueiterationwildcardid"></a>`iterationWildcardId` | [`IssueCreationIterationWildcardId`](#issuecreationiterationwildcardid) | イテレーションワイルドカードID。サポートされている値は`CURRENT`です。`iterationId`と相互排他的な引数。この引数を指定する場合はiterationCadenceIdも必須です。 |
| <a id="mutationcreateissuelabelids"></a>`labelIds` | [`[LabelID!]`](#labelid) | イシューに追加するラベルのID。 |
| <a id="mutationcreateissuelabels"></a>`labels` | [`[String!]`](#string) | イシューのラベル。 |
| <a id="mutationcreateissuelocked"></a>`locked` | [`Boolean`](#boolean) | ディスカッションがイシューでロックされていることを示します。 |
| <a id="mutationcreateissuemergerequesttoresolvediscussionsof"></a>`mergeRequestToResolveDiscussionsOf` | [`MergeRequestID`](#mergerequestid) | ディスカッションを解決する対象となるマージリクエストのIID。 |
| <a id="mutationcreateissuemilestoneid"></a>`milestoneId` | [`MilestoneID`](#milestoneid) | イシューに割り当てるマイルストーンのID。nullに設定すると、更新時にマイルストーンが削除されます。 |
| <a id="mutationcreateissuemoveafterid"></a>`moveAfterId` | [`IssueID`](#issueid) | 現在のイシューの後に配置するイシューのグローバルID。 |
| <a id="mutationcreateissuemovebeforeid"></a>`moveBeforeId` | [`IssueID`](#issueid) | 現在のイシューの前に配置するイシューのグローバルID。 |
| <a id="mutationcreateissueprojectpath"></a>`projectPath` | [`ID!`](#id) | イシューが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationcreateissuetitle"></a>`title` | [`String!`](#string) | イシューのタイトル。 |
| <a id="mutationcreateissuetype"></a>`type` | [`IssueType`](#issuetype) | イシューのタイプ。 |
| <a id="mutationcreateissueweight"></a>`weight` | [`Int`](#int) | イシューのウェイト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreateissueerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationcreateissueissue"></a>`issue` | [`Issue`](#issue) | 変異後のイシュー。 |

### `Mutation.createIteration`

{{< details >}}GitLab 14.0で**非推奨**になりました。iterationCreateを使用してください。{{< /details >}}

入力型: `CreateIterationInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateiterationclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreateiterationdescription"></a>`description` | [`String`](#string) | イテレーションの説明。 |
| <a id="mutationcreateiterationduedate"></a>`dueDate` | [`String`](#string) | イテレーションの終了日。 |
| <a id="mutationcreateiterationgrouppath"></a>`groupPath` | [`ID`](#id) | リソースが関連付けられているグループのフルパス。 |
| <a id="mutationcreateiterationiterationscadenceid"></a>`iterationsCadenceId` | [`IterationsCadenceID`](#iterationscadenceid) | 新しいイテレーションに割り当てるイテレーションケイデンスのグローバルID。 |
| <a id="mutationcreateiterationprojectpath"></a>`projectPath` | [`ID`](#id) | リソースが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationcreateiterationstartdate"></a>`startDate` | [`String`](#string) | イテレーションの開始日。 |
| <a id="mutationcreateiterationtitle"></a>`title` | [`String`](#string) | イテレーションのタイトル。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateiterationclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreateiterationerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationcreateiterationiteration"></a>`iteration` | [`Iteration`](#iteration) | 作成されたイテレーション。 |

### `Mutation.createNote`

ノートを作成します。ノートの本文に含まれるのがクイックアクションだけの場合、更新時にノートが破棄され、ノートは返されません。

入力型: `CreateNoteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatenotebody"></a>`body` | [`String!`](#string) | ノートの内容。 |
| <a id="mutationcreatenoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreatenotediscussionid"></a>`discussionId` | [`DiscussionID`](#discussionid) | ノートを含める返信の対象となるディスカッションのグローバルID。 |
| <a id="mutationcreatenoteinternal"></a>`internal` | [`Boolean`](#boolean) | ノートの内部フラグ。デフォルトはfalseです。 |
| <a id="mutationcreatenotemergerequestdiffheadsha"></a>`mergeRequestDiffHeadSha` | [`String`](#string) | リクエスト送信以降にマージリクエストが更新されていないことを確認するために使用されるヘッドコミットのSHA。 |
| <a id="mutationcreatenotenoteableid"></a>`noteableId` | [`NoteableID!`](#noteableid) | ノート追加先のリソースのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatenoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreatenoteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationcreatenotenote"></a>`note` | [`Note`](#note) | 変異後のノート。 |
| <a id="mutationcreatenotequickactionsstatus"></a>`quickActionsStatus` | [`QuickActionsStatus`](#quickactionsstatus) | 変異後のクイックアクションの状態。 |

### `Mutation.createPackagesProtectionRule`

プロジェクトパッケージへのアクセスを制限する保護ルールを作成します。

入力型: `CreatePackagesProtectionRuleInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatepackagesprotectionruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreatepackagesprotectionruleminimumaccesslevelfordelete"></a>`minimumAccessLevelForDelete` {{< icon name="warning-solid" >}} | [`PackagesProtectionRuleAccessLevelForDelete`](#packagesprotectionruleaccesslevelfordelete) | **非推奨: ****状態**: 実験。GitLab 17.10で導入。 |
| <a id="mutationcreatepackagesprotectionruleminimumaccesslevelforpush"></a>`minimumAccessLevelForPush` | [`PackagesProtectionRuleAccessLevel`](#packagesprotectionruleaccesslevel) | パッケージをパッケージレジストリにプッシュするために必要な最小GitLabアクセスレベル。有効な値には`MAINTAINER`、`OWNER`、または`ADMIN`が含まれます。値が`nil`の場合のデフォルトの最小アクセスレベルは`DEVELOPER`です。 |
| <a id="mutationcreatepackagesprotectionrulepackagenamepattern"></a>`packageNamePattern` | [`String!`](#string) | 保護ルールによって保護されるパッケージ名。例：`@my-scope/my-package-*`。ワイルドカード文字`*`を使用できます。 |
| <a id="mutationcreatepackagesprotectionrulepackagetype"></a>`packageType` | [`PackagesProtectionRulePackageType!`](#packagesprotectionrulepackagetype) | 保護ルールによって保護されるパッケージのタイプ。例: `NPM`、`PYPI`。 |
| <a id="mutationcreatepackagesprotectionruleprojectpath"></a>`projectPath` | [`ID!`](#id) | 保護ルールの属するプロジェクトのフルパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatepackagesprotectionruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreatepackagesprotectionruleerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationcreatepackagesprotectionrulepackageprotectionrule"></a>`packageProtectionRule` | [`PackagesProtectionRule`](#packagesprotectionrule) | 変異後のパッケージ保護ルール。 |

### `Mutation.createRequirement`

入力型: `CreateRequirementInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreaterequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreaterequirementdescription"></a>`description` | [`String`](#string) | 要件の説明。 |
| <a id="mutationcreaterequirementprojectpath"></a>`projectPath` | [`ID!`](#id) | 要件が関連付けられているプロジェクトのフルパス。 |
| <a id="mutationcreaterequirementtitle"></a>`title` | [`String`](#string) | 要件のタイトル。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreaterequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreaterequirementerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationcreaterequirementrequirement"></a>`requirement` | [`Requirement`](#requirement) | 変異後の要件。 |

### `Mutation.createSnippet`

入力型: `CreateSnippetInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatesnippetblobactions"></a>`blobActions` | [`[SnippetBlobActionInputType!]`](#snippetblobactioninputtype) | スニペットリポジトリとBLOBに対して実行するアクション。 |
| <a id="mutationcreatesnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreatesnippetdescription"></a>`description` | [`String`](#string) | スニペットの説明。 |
| <a id="mutationcreatesnippetprojectpath"></a>`projectPath` | [`ID`](#id) | スニペットが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationcreatesnippettitle"></a>`title` | [`String!`](#string) | スニペットのタイトル。 |
| <a id="mutationcreatesnippetuploadedfiles"></a>`uploadedFiles` | [`[String!]`](#string) | スニペットの説明でアップロードされるファイルのパス。 |
| <a id="mutationcreatesnippetvisibilitylevel"></a>`visibilityLevel` | [`VisibilityLevelsEnum!`](#visibilitylevelsenum) | スニペットの表示レベル。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatesnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreatesnippeterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationcreatesnippetsnippet"></a>`snippet` | [`Snippet`](#snippet) | 変異後のスニペット。 |

### `Mutation.createTestCase`

入力型: `CreateTestCaseInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatetestcaseclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreatetestcaseconfidential"></a>`confidential` | [`Boolean`](#boolean) | テストケースの機密性を設定します。 |
| <a id="mutationcreatetestcasedescription"></a>`description` | [`String`](#string) | テストケースの説明。 |
| <a id="mutationcreatetestcaselabelids"></a>`labelIds` | [`[ID!]`](#id) | テストケースに追加するラベルのID。 |
| <a id="mutationcreatetestcaseprojectpath"></a>`projectPath` | [`ID!`](#id) | テストケースを作成するプロジェクトのフルパス。 |
| <a id="mutationcreatetestcasetitle"></a>`title` | [`String!`](#string) | テストケースのタイトル。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatetestcaseclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcreatetestcaseerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationcreatetestcasetestcase"></a>`testCase` | [`Issue`](#issue) | 作成されたテストケース。 |

### `Mutation.customFieldArchive`

{{< details >}}GitLab 17.9で**導入**。**状態**: 実験。{{< /details >}}

入力型: `CustomFieldArchiveInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomfieldarchiveclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcustomfieldarchiveid"></a>`id` | [`IssuablesCustomFieldID!`](#issuablescustomfieldid) | カスタムフィールドのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomfieldarchiveclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcustomfieldarchivecustomfield"></a>`customField` | [`CustomField`](#customfield) | アーカイブされたカスタムフィールド。 |
| <a id="mutationcustomfieldarchiveerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.customFieldCreate`

{{< details >}}GitLab 17.6で**導入**。**状態**: 実験。{{< /details >}}

入力型: `CustomFieldCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomfieldcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcustomfieldcreatefieldtype"></a>`fieldType` | [`CustomFieldType!`](#customfieldtype) | カスタムフィールドの型。 |
| <a id="mutationcustomfieldcreategrouppath"></a>`groupPath` | [`ID!`](#id) | カスタムフィールドを作成するグループパス。 |
| <a id="mutationcustomfieldcreatename"></a>`name` | [`String!`](#string) | カスタムフィールドの名前。 |
| <a id="mutationcustomfieldcreateselectoptions"></a>`selectOptions` | [`[CustomFieldSelectOptionInput!]`](#customfieldselectoptioninput) | 選択フィールドで使用可能なオプション。 |
| <a id="mutationcustomfieldcreateworkitemtypeids"></a>`workItemTypeIds` | [`[WorkItemsTypeID!]`](#workitemstypeid) | カスタムフィールドに関連付けられている作業アイテムの型のグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomfieldcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcustomfieldcreatecustomfield"></a>`customField` | [`CustomField`](#customfield) | 作成されたカスタムフィールド。 |
| <a id="mutationcustomfieldcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.customFieldUnarchive`

{{< details >}}GitLab 17.9で**導入**。**状態**: 実験。{{< /details >}}

入力型: `CustomFieldUnarchiveInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomfieldunarchiveclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcustomfieldunarchiveid"></a>`id` | [`IssuablesCustomFieldID!`](#issuablescustomfieldid) | カスタムフィールドのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomfieldunarchiveclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcustomfieldunarchivecustomfield"></a>`customField` | [`CustomField`](#customfield) | アーカイブ解除されたカスタムフィールド。 |
| <a id="mutationcustomfieldunarchiveerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.customFieldUpdate`

{{< details >}}GitLab 17.6で**導入**。**状態**: 実験。{{< /details >}}

入力型: `CustomFieldUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomfieldupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcustomfieldupdateid"></a>`id` | [`IssuablesCustomFieldID!`](#issuablescustomfieldid) | カスタムフィールドのグローバルID。 |
| <a id="mutationcustomfieldupdatename"></a>`name` | [`String`](#string) | カスタムフィールドの名前。 |
| <a id="mutationcustomfieldupdateselectoptions"></a>`selectOptions` | [`[CustomFieldSelectOptionInput!]`](#customfieldselectoptioninput) | 選択フィールドで使用可能なオプション。 |
| <a id="mutationcustomfieldupdateworkitemtypeids"></a>`workItemTypeIds` | [`[WorkItemsTypeID!]`](#workitemstypeid) | カスタムフィールドに関連付けられている作業アイテムの型のグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomfieldupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcustomfieldupdatecustomfield"></a>`customField` | [`CustomField`](#customfield) | 更新されたカスタムフィールド。 |
| <a id="mutationcustomfieldupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.customerRelationsContactCreate`

入力型: `CustomerRelationsContactCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationscontactcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcustomerrelationscontactcreatedescription"></a>`description` | [`String`](#string) | 連絡先の説明またはノート。 |
| <a id="mutationcustomerrelationscontactcreateemail"></a>`email` | [`String`](#string) | 連絡先のメールアドレス。 |
| <a id="mutationcustomerrelationscontactcreatefirstname"></a>`firstName` | [`String!`](#string) | 連絡先の名前。 |
| <a id="mutationcustomerrelationscontactcreategroupid"></a>`groupId` | [`GroupID!`](#groupid) | 連絡先のグループ。 |
| <a id="mutationcustomerrelationscontactcreatelastname"></a>`lastName` | [`String!`](#string) | 連絡先の苗字。 |
| <a id="mutationcustomerrelationscontactcreateorganizationid"></a>`organizationId` | [`CustomerRelationsOrganizationID`](#customerrelationsorganizationid) | 連絡先の組織。 |
| <a id="mutationcustomerrelationscontactcreatephone"></a>`phone` | [`String`](#string) | 連絡先の電話番号。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationscontactcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcustomerrelationscontactcreatecontact"></a>`contact` | [`CustomerRelationsContact`](#customerrelationscontact) | 変異後の連絡先。 |
| <a id="mutationcustomerrelationscontactcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.customerRelationsContactUpdate`

入力型: `CustomerRelationsContactUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationscontactupdateactive"></a>`active` | [`Boolean`](#boolean) | 連絡先の状態。 |
| <a id="mutationcustomerrelationscontactupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcustomerrelationscontactupdatedescription"></a>`description` | [`String`](#string) | 連絡先の説明またはノート。 |
| <a id="mutationcustomerrelationscontactupdateemail"></a>`email` | [`String`](#string) | 連絡先のメールアドレス。 |
| <a id="mutationcustomerrelationscontactupdatefirstname"></a>`firstName` | [`String`](#string) | 連絡先の名前。 |
| <a id="mutationcustomerrelationscontactupdateid"></a>`id` | [`CustomerRelationsContactID!`](#customerrelationscontactid) | 連絡先のグローバルID。 |
| <a id="mutationcustomerrelationscontactupdatelastname"></a>`lastName` | [`String`](#string) | 連絡先の苗字。 |
| <a id="mutationcustomerrelationscontactupdateorganizationid"></a>`organizationId` | [`CustomerRelationsOrganizationID`](#customerrelationsorganizationid) | 連絡先の組織。 |
| <a id="mutationcustomerrelationscontactupdatephone"></a>`phone` | [`String`](#string) | 連絡先の電話番号。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationscontactupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcustomerrelationscontactupdatecontact"></a>`contact` | [`CustomerRelationsContact`](#customerrelationscontact) | 変異後の連絡先。 |
| <a id="mutationcustomerrelationscontactupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.customerRelationsOrganizationCreate`

入力型: `CustomerRelationsOrganizationCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationsorganizationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcustomerrelationsorganizationcreatedefaultrate"></a>`defaultRate` | [`Float`](#float) | 組織の標準請求レート。 |
| <a id="mutationcustomerrelationsorganizationcreatedescription"></a>`description` | [`String`](#string) | 組織の説明またはノート。 |
| <a id="mutationcustomerrelationsorganizationcreategroupid"></a>`groupId` | [`GroupID!`](#groupid) | 組織のグループ。 |
| <a id="mutationcustomerrelationsorganizationcreatename"></a>`name` | [`String!`](#string) | 組織の名前。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationsorganizationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcustomerrelationsorganizationcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationcustomerrelationsorganizationcreateorganization"></a>`organization` | [`CustomerRelationsOrganization`](#customerrelationsorganization) | 変異後の組織。 |

### `Mutation.customerRelationsOrganizationUpdate`

入力型: `CustomerRelationsOrganizationUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationsorganizationupdateactive"></a>`active` | [`Boolean`](#boolean) | 組織の状態。 |
| <a id="mutationcustomerrelationsorganizationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcustomerrelationsorganizationupdatedefaultrate"></a>`defaultRate` | [`Float`](#float) | 組織の標準請求レート。 |
| <a id="mutationcustomerrelationsorganizationupdatedescription"></a>`description` | [`String`](#string) | 組織の説明またはノート。 |
| <a id="mutationcustomerrelationsorganizationupdateid"></a>`id` | [`CustomerRelationsOrganizationID!`](#customerrelationsorganizationid) | 組織のグローバルID。 |
| <a id="mutationcustomerrelationsorganizationupdatename"></a>`name` | [`String`](#string) | 組織の名前。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationsorganizationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationcustomerrelationsorganizationupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationcustomerrelationsorganizationupdateorganization"></a>`organization` | [`CustomerRelationsOrganization!`](#customerrelationsorganization) | 変異後の組織。 |

### `Mutation.dastOnDemandScanCreate`

入力型: `DastOnDemandScanCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastondemandscancreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdastondemandscancreatedastscannerprofileid"></a>`dastScannerProfileId` | [`DastScannerProfileID`](#dastscannerprofileid) | スキャンに使用するスキャナープロファイルのID。 |
| <a id="mutationdastondemandscancreatedastsiteprofileid"></a>`dastSiteProfileId` | [`DastSiteProfileID!`](#dastsiteprofileid) | スキャンに使用するサイトプロファイルのID。 |
| <a id="mutationdastondemandscancreatefullpath"></a>`fullPath` | [`ID!`](#id) | サイトプロファイルが属するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastondemandscancreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdastondemandscancreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationdastondemandscancreatepipelineurl"></a>`pipelineUrl` | [`String`](#string) | 作成されたパイプラインのURL。 |

### `Mutation.dastProfileCreate`

入力型: `DastProfileCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastprofilecreatebranchname"></a>`branchName` | [`String`](#string) | 関連するブランチ。 |
| <a id="mutationdastprofilecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdastprofilecreatedastprofileschedule"></a>`dastProfileSchedule` | [`DastProfileScheduleInput`](#dastprofilescheduleinput) | DASTプロファイルスケジュールを表します。 |
| <a id="mutationdastprofilecreatedastscannerprofileid"></a>`dastScannerProfileId` | [`DastScannerProfileID!`](#dastscannerprofileid) | 関連付けるスキャナープロファイルのID。 |
| <a id="mutationdastprofilecreatedastsiteprofileid"></a>`dastSiteProfileId` | [`DastSiteProfileID!`](#dastsiteprofileid) | 関連付けるサイトプロファイルのID。 |
| <a id="mutationdastprofilecreatedescription"></a>`description` | [`String`](#string) | プロファイルの説明。デフォルトは空の文字列です。 |
| <a id="mutationdastprofilecreatefullpath"></a>`fullPath` | [`ID!`](#id) | プロファイルが属するプロジェクト。 |
| <a id="mutationdastprofilecreatename"></a>`name` | [`String!`](#string) | プロファイルの名前。 |
| <a id="mutationdastprofilecreaterunaftercreate"></a>`runAfterCreate` | [`Boolean`](#boolean) | 作成後にプロファイルを使用してスキャンを実行します。デフォルトはfalseです。 |
| <a id="mutationdastprofilecreatetaglist"></a>`tagList` | [`[String!]`](#string) | プロファイルに関連付けられているRunnerタグを示します。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastprofilecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdastprofilecreatedastprofile"></a>`dastProfile` | [`DastProfile`](#dastprofile) | 作成されたプロファイル。 |
| <a id="mutationdastprofilecreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationdastprofilecreatepipelineurl"></a>`pipelineUrl` | [`String`](#string) | 作成されたパイプラインのURL。`runAfterCreate`が`true`に設定されている必要があります。 |

### `Mutation.dastProfileDelete`

入力型: `DastProfileDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastprofiledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdastprofiledeleteid"></a>`id` | [`DastProfileID!`](#dastprofileid) | 削除するプロファイルのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastprofiledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdastprofiledeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.dastProfileRun`

入力型: `DastProfileRunInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastprofilerunclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdastprofilerunfullpath"></a>`fullPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **非推奨: **グローバルIDを修飾する完全パスは不要です。GitLab 14.5で非推奨になりました。 |
| <a id="mutationdastprofilerunid"></a>`id` | [`DastProfileID!`](#dastprofileid) | スキャンに使用するプロファイルのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastprofilerunclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdastprofilerunerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationdastprofilerunpipelineurl"></a>`pipelineUrl` | [`String`](#string) | 作成されたパイプラインのURL。 |

### `Mutation.dastProfileUpdate`

入力型: `DastProfileUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastprofileupdatebranchname"></a>`branchName` | [`String`](#string) | 関連するブランチ。 |
| <a id="mutationdastprofileupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdastprofileupdatedastprofileschedule"></a>`dastProfileSchedule` | [`DastProfileScheduleInput`](#dastprofilescheduleinput) | DASTプロファイルスケジュールを表します。 |
| <a id="mutationdastprofileupdatedastscannerprofileid"></a>`dastScannerProfileId` | [`DastScannerProfileID`](#dastscannerprofileid) | 関連付けるスキャナープロファイルのID。 |
| <a id="mutationdastprofileupdatedastsiteprofileid"></a>`dastSiteProfileId` | [`DastSiteProfileID`](#dastsiteprofileid) | 関連付けるサイトプロファイルのID。 |
| <a id="mutationdastprofileupdatedescription"></a>`description` | [`String`](#string) | プロファイルの説明。デフォルトは空の文字列です。 |
| <a id="mutationdastprofileupdatefullpath"></a>`fullPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **非推奨: **グローバルIDを修飾する完全パスは不要です。GitLab 14.5で非推奨になりました。 |
| <a id="mutationdastprofileupdateid"></a>`id` | [`DastProfileID!`](#dastprofileid) | 削除するプロファイルのID。 |
| <a id="mutationdastprofileupdatename"></a>`name` | [`String`](#string) | プロファイルの名前。 |
| <a id="mutationdastprofileupdaterunafterupdate"></a>`runAfterUpdate` | [`Boolean`](#boolean) | 更新後にプロファイルを使用してスキャンを実行します。デフォルトはfalseです。 |
| <a id="mutationdastprofileupdatetaglist"></a>`tagList` | [`[String!]`](#string) | プロファイルに関連付けられているRunnerタグを示します。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastprofileupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdastprofileupdatedastprofile"></a>`dastProfile` | [`DastProfile`](#dastprofile) | 更新されたプロファイル。 |
| <a id="mutationdastprofileupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationdastprofileupdatepipelineurl"></a>`pipelineUrl` | [`String`](#string) | 作成されたパイプラインのURL。変異呼び出し時に入力引数`runAfterUpdate`を`true`に設定する必要があります。そうしないと、パイプラインは作成されません。 |

### `Mutation.dastScannerProfileCreate`

入力型: `DastScannerProfileCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastscannerprofilecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdastscannerprofilecreatefullpath"></a>`fullPath` | [`ID!`](#id) | スキャナープロファイルが属するプロジェクト。 |
| <a id="mutationdastscannerprofilecreateprofilename"></a>`profileName` | [`String!`](#string) | スキャナープロファイルの名前。 |
| <a id="mutationdastscannerprofilecreatescantype"></a>`scanType` | [`DastScanTypeEnum`](#dastscantypeenum) | 実行するDASTスキャンのタイプを示します。パッシブスキャンかアクティブスキャンのどちらか。 |
| <a id="mutationdastscannerprofilecreateshowdebugmessages"></a>`showDebugMessages` | [`Boolean`](#boolean) | デバッグメッセージをDASTコンソール出力に含めるかどうかを示します。デバッグメッセージを含める場合はtrue。 |
| <a id="mutationdastscannerprofilecreatespidertimeout"></a>`spiderTimeout` | [`Int`](#int) | スパイダーがサイトを走査する時間として許可される最大時間（分）。 |
| <a id="mutationdastscannerprofilecreatetaglist"></a>`tagList` {{< icon name="warning-solid" >}} | [`[String!]`](#string) | **非推奨: **DastProfileに移動しました。GitLab 15.8で非推奨になりました。 |
| <a id="mutationdastscannerprofilecreatetargettimeout"></a>`targetTimeout` | [`Int`](#int) | テスト対象のサイトがリクエストに応答するための時間として許可される最大秒数。 |
| <a id="mutationdastscannerprofilecreateuseajaxspider"></a>`useAjaxSpider` | [`Boolean`](#boolean) | ターゲットサイトのクロールにAJAX Spiderを使用するかどうかを示します。従来のスパイダーに加えてAJAX Spiderを実行する場合はtrue、従来のスパイダーだけを実行する場合はfalse。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastscannerprofilecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdastscannerprofilecreatedastscannerprofile"></a>`dastScannerProfile` | [`DastScannerProfile`](#dastscannerprofile) | 作成されたスキャナープロファイル。 |
| <a id="mutationdastscannerprofilecreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationdastscannerprofilecreateid"></a>`id` {{< icon name="warning-solid" >}} | [`DastScannerProfileID`](#dastscannerprofileid) | **非推奨:** `dastScannerProfile`フィールドを使用してください。GitLab 14.10で非推奨になりました。 |

### `Mutation.dastScannerProfileDelete`

入力型: `DastScannerProfileDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastscannerprofiledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdastscannerprofiledeletefullpath"></a>`fullPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **非推奨: **グローバルIDを修飾する完全パスは不要です。GitLab 14.5で非推奨になりました。 |
| <a id="mutationdastscannerprofiledeleteid"></a>`id` | [`DastScannerProfileID!`](#dastscannerprofileid) | 削除するスキャナープロファイルのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastscannerprofiledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdastscannerprofiledeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.dastScannerProfileUpdate`

入力型: `DastScannerProfileUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastscannerprofileupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdastscannerprofileupdatefullpath"></a>`fullPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **非推奨: **グローバルIDを修飾する完全パスは不要です。GitLab 14.5で非推奨になりました。 |
| <a id="mutationdastscannerprofileupdateid"></a>`id` | [`DastScannerProfileID!`](#dastscannerprofileid) | 更新するスキャナープロファイルのID。 |
| <a id="mutationdastscannerprofileupdateprofilename"></a>`profileName` | [`String!`](#string) | スキャナープロファイルの名前。 |
| <a id="mutationdastscannerprofileupdatescantype"></a>`scanType` | [`DastScanTypeEnum`](#dastscantypeenum) | 実行するDASTスキャンのタイプを示します。パッシブスキャンかアクティブスキャンのどちらか。 |
| <a id="mutationdastscannerprofileupdateshowdebugmessages"></a>`showDebugMessages` | [`Boolean`](#boolean) | デバッグメッセージをDASTコンソール出力に含めるかどうかを示します。デバッグメッセージを含める場合はtrue。 |
| <a id="mutationdastscannerprofileupdatespidertimeout"></a>`spiderTimeout` | [`Int!`](#int) | スパイダーがサイトを走査する時間として許可される最大時間（分）。 |
| <a id="mutationdastscannerprofileupdatetaglist"></a>`tagList` {{< icon name="warning-solid" >}} | [`[String!]`](#string) | **非推奨: **DastProfileに移動しました。GitLab 15.8で非推奨になりました。 |
| <a id="mutationdastscannerprofileupdatetargettimeout"></a>`targetTimeout` | [`Int!`](#int) | テスト対象のサイトがリクエストに応答するための時間として許可される最大秒数。 |
| <a id="mutationdastscannerprofileupdateuseajaxspider"></a>`useAjaxSpider` | [`Boolean`](#boolean) | ターゲットサイトのクロールにAJAX Spiderを使用するかどうかを示します。従来のスパイダーに加えてAJAX Spiderを実行する場合はtrue、従来のスパイダーだけを実行する場合はfalse。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastscannerprofileupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdastscannerprofileupdatedastscannerprofile"></a>`dastScannerProfile` | [`DastScannerProfile`](#dastscannerprofile) | 更新されたスキャナープロファイル。 |
| <a id="mutationdastscannerprofileupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationdastscannerprofileupdateid"></a>`id` {{< icon name="warning-solid" >}} | [`DastScannerProfileID`](#dastscannerprofileid) | **非推奨:** `dastScannerProfile`フィールドを使用してください。GitLab 14.10で非推奨になりました。 |

### `Mutation.dastSiteProfileCreate`

入力型: `DastSiteProfileCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastsiteprofilecreateauth"></a>`auth` | [`DastSiteProfileAuthInput`](#dastsiteprofileauthinput) | 認証のパラメータ。 |
| <a id="mutationdastsiteprofilecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdastsiteprofilecreateexcludedurls"></a>`excludedUrls` | [`[String!]`](#string) | 認証スキャン中にスキップするURL。デフォルトは`[]`です。 |
| <a id="mutationdastsiteprofilecreatefullpath"></a>`fullPath` | [`ID!`](#id) | サイトプロファイルが属するプロジェクト。 |
| <a id="mutationdastsiteprofilecreateoptionalvariables"></a>`optionalVariables` | [`[JSON!]`](#json) | DASTスキャン用に設定できるオプション変数。 |
| <a id="mutationdastsiteprofilecreateprofilename"></a>`profileName` | [`String!`](#string) | サイトプロファイルの名前。 |
| <a id="mutationdastsiteprofilecreaterequestheaders"></a>`requestHeaders` | [`String`](#string) | DASTによるあらゆるリクエストに追加する、リクエストヘッダーの名前と値のカンマ区切りリスト。 |
| <a id="mutationdastsiteprofilecreatescanfilepath"></a>`scanFilePath` | [`String`](#string) | スキャン方式のインプットとして使用されるファイルパスまたはURL。 |
| <a id="mutationdastsiteprofilecreatescanmethod"></a>`scanMethod` | [`DastScanMethodType`](#dastscanmethodtype) | スキャナーによるスキャン方式。 |
| <a id="mutationdastsiteprofilecreatetargettype"></a>`targetType` | [`DastTargetTypeEnum`](#dasttargettypeenum) | スキャンするターゲットのタイプ。 |
| <a id="mutationdastsiteprofilecreatetargeturl"></a>`targetUrl` | [`String`](#string) | スキャンするターゲットのURL。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastsiteprofilecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdastsiteprofilecreatedastsiteprofile"></a>`dastSiteProfile` | [`DastSiteProfile`](#dastsiteprofile) | サイトプロファイルオブジェクト。 |
| <a id="mutationdastsiteprofilecreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationdastsiteprofilecreateid"></a>`id` {{< icon name="warning-solid" >}} | [`DastSiteProfileID`](#dastsiteprofileid) | **非推奨:** `dastSiteProfile.id`フィールドを使用してください。GitLab 14.10で非推奨になりました。 |

### `Mutation.dastSiteProfileDelete`

入力型: `DastSiteProfileDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastsiteprofiledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdastsiteprofiledeletefullpath"></a>`fullPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **非推奨: **グローバルIDを修飾する完全パスは不要です。GitLab 14.5で非推奨になりました。 |
| <a id="mutationdastsiteprofiledeleteid"></a>`id` | [`DastSiteProfileID!`](#dastsiteprofileid) | 削除するサイトプロファイルのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastsiteprofiledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdastsiteprofiledeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.dastSiteProfileUpdate`

入力型: `DastSiteProfileUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastsiteprofileupdateauth"></a>`auth` | [`DastSiteProfileAuthInput`](#dastsiteprofileauthinput) | 認証のパラメータ。 |
| <a id="mutationdastsiteprofileupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdastsiteprofileupdateexcludedurls"></a>`excludedUrls` | [`[String!]`](#string) | 認証スキャン中にスキップするURL。 |
| <a id="mutationdastsiteprofileupdatefullpath"></a>`fullPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **非推奨: **グローバルIDを修飾する完全パスは不要です。GitLab 14.5で非推奨になりました。 |
| <a id="mutationdastsiteprofileupdateid"></a>`id` | [`DastSiteProfileID!`](#dastsiteprofileid) | 更新するサイトプロファイルのID。 |
| <a id="mutationdastsiteprofileupdateoptionalvariables"></a>`optionalVariables` | [`[JSON!]`](#json) | DASTスキャン用に設定できるオプション変数。 |
| <a id="mutationdastsiteprofileupdateprofilename"></a>`profileName` | [`String!`](#string) | サイトプロファイルの名前。 |
| <a id="mutationdastsiteprofileupdaterequestheaders"></a>`requestHeaders` | [`String`](#string) | DASTによるあらゆるリクエストに追加する、リクエストヘッダーの名前と値のカンマ区切りリスト。 |
| <a id="mutationdastsiteprofileupdatescanfilepath"></a>`scanFilePath` | [`String`](#string) | スキャン方式のインプットとして使用されるファイルパスまたはURL。 |
| <a id="mutationdastsiteprofileupdatescanmethod"></a>`scanMethod` | [`DastScanMethodType`](#dastscanmethodtype) | スキャナーによるスキャン方式。 |
| <a id="mutationdastsiteprofileupdatetargettype"></a>`targetType` | [`DastTargetTypeEnum`](#dasttargettypeenum) | スキャンするターゲットのタイプ。 |
| <a id="mutationdastsiteprofileupdatetargeturl"></a>`targetUrl` | [`String`](#string) | スキャンするターゲットのURL。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastsiteprofileupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdastsiteprofileupdatedastsiteprofile"></a>`dastSiteProfile` | [`DastSiteProfile`](#dastsiteprofile) | サイトプロファイルオブジェクト。 |
| <a id="mutationdastsiteprofileupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationdastsiteprofileupdateid"></a>`id` {{< icon name="warning-solid" >}} | [`DastSiteProfileID`](#dastsiteprofileid) | **非推奨:** `dastSiteProfile.id`フィールドを使用してください。GitLab 14.10で非推奨になりました。 |

### `Mutation.dastSiteTokenCreate`

入力型: `DastSiteTokenCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastsitetokencreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdastsitetokencreatefullpath"></a>`fullPath` | [`ID!`](#id) | サイトトークンが属するプロジェクト。 |
| <a id="mutationdastsitetokencreatetargeturl"></a>`targetUrl` | [`String`](#string) | 検証するターゲットのURL。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastsitetokencreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdastsitetokencreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationdastsitetokencreateid"></a>`id` | [`DastSiteTokenID`](#dastsitetokenid) | サイトトークンのID。 |
| <a id="mutationdastsitetokencreatestatus"></a>`status` | [`DastSiteProfileValidationStatusEnum`](#dastsiteprofilevalidationstatusenum) | ターゲットの現在の検証状態。 |
| <a id="mutationdastsitetokencreatetoken"></a>`token` | [`String`](#string) | トークン文字列。 |

### `Mutation.dastSiteValidationCreate`

入力型: `DastSiteValidationCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastsitevalidationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdastsitevalidationcreatedastsitetokenid"></a>`dastSiteTokenId` | [`DastSiteTokenID!`](#dastsitetokenid) | サイトトークンのID。 |
| <a id="mutationdastsitevalidationcreatefullpath"></a>`fullPath` | [`ID!`](#id) | サイトプロファイルが属するプロジェクト。 |
| <a id="mutationdastsitevalidationcreatestrategy"></a>`strategy` | [`DastSiteValidationStrategyEnum`](#dastsitevalidationstrategyenum) | 使用する検証戦略。 |
| <a id="mutationdastsitevalidationcreatevalidationpath"></a>`validationPath` | [`String!`](#string) | 検証中にリクエストするパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastsitevalidationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdastsitevalidationcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationdastsitevalidationcreateid"></a>`id` | [`DastSiteValidationID`](#dastsitevalidationid) | サイト検証のID。 |
| <a id="mutationdastsitevalidationcreatestatus"></a>`status` | [`DastSiteProfileValidationStatusEnum`](#dastsiteprofilevalidationstatusenum) | 現在の検証状態。 |

### `Mutation.dastSiteValidationRevoke`

入力型: `DastSiteValidationRevokeInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastsitevalidationrevokeclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdastsitevalidationrevokefullpath"></a>`fullPath` | [`ID!`](#id) | サイト検証が属するプロジェクト。 |
| <a id="mutationdastsitevalidationrevokenormalizedtargeturl"></a>`normalizedTargetUrl` | [`String!`](#string) | 失効するターゲットの正規化URL。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastsitevalidationrevokeclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdastsitevalidationrevokeerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.deleteAnnotation`

{{< details >}}GitLab 16.0で**非推奨**になりました。基盤となる機能は16.0で削除されました。{{< /details >}}

入力型: `DeleteAnnotationInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdeleteannotationclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdeleteannotationid"></a>`id` | [`String!`](#string) | 削除するアノーテーションのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdeleteannotationclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdeleteannotationerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.deleteContainerProtectionRepositoryRule`

コンテナリポジトリ保護ルールを削除します。

入力型: `DeleteContainerProtectionRepositoryRuleInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdeletecontainerprotectionrepositoryruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdeletecontainerprotectionrepositoryruleid"></a>`id` | [`ContainerRegistryProtectionRuleID!`](#containerregistryprotectionruleid) | 削除するコンテナリポジトリ保護ルールのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdeletecontainerprotectionrepositoryruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdeletecontainerprotectionrepositoryrulecontainerprotectionrepositoryrule"></a>`containerProtectionRepositoryRule` | [`ContainerProtectionRepositoryRule`](#containerprotectionrepositoryrule) | 正常に削除されたコンテナリポジトリ保護ルール。 |
| <a id="mutationdeletecontainerprotectionrepositoryruleerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.deleteContainerProtectionTagRule`

指定されたパターンに一致するコンテナイメージタグに変更を加えることのできるユーザーロールを制御する保護ルールを削除します。機能フラグ`container_registry_protected_tags`が有効な場合にのみ使用可能。

{{< details >}}GitLab 17.8で**導入**。**状態**: 実験。{{< /details >}}

入力型: `DeleteContainerProtectionTagRuleInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdeletecontainerprotectiontagruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdeletecontainerprotectiontagruleid"></a>`id` | [`ContainerRegistryProtectionTagRuleID!`](#containerregistryprotectiontagruleid) | 削除するタグ保護ルールのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdeletecontainerprotectiontagruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdeletecontainerprotectiontagrulecontainerprotectiontagrule"></a>`containerProtectionTagRule` {{< icon name="warning-solid" >}} | [`ContainerProtectionTagRule`](#containerprotectiontagrule) | **非推奨: ****状態**: 実験。GitLab 17.8で導入。 |
| <a id="mutationdeletecontainerprotectiontagruleerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.deleteConversationThread`

{{< details >}}GitLab 17.9で**導入**。**状態**: 実験。{{< /details >}}

入力型: `DeleteConversationThreadInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdeleteconversationthreadclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdeleteconversationthreadthreadid"></a>`threadId` | [`AiConversationThreadID!`](#aiconversationthreadid) | 削除するスレッドのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdeleteconversationthreadclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdeleteconversationthreaderrors"></a>`errors` | [`[String!]!`](#string) | スレッドの削除試行中に発生したエラーのリスト。 |
| <a id="mutationdeleteconversationthreadsuccess"></a>`success` | [`Boolean!`](#boolean) | スレッドが正常に削除された場合はtrueを返します。 |

### `Mutation.deletePackagesProtectionRule`

パッケージの保護ルールを削除します。

入力型: `DeletePackagesProtectionRuleInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdeletepackagesprotectionruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdeletepackagesprotectionruleid"></a>`id` | [`PackagesProtectionRuleID!`](#packagesprotectionruleid) | 削除するパッケージ保護ルールのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdeletepackagesprotectionruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdeletepackagesprotectionruleerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationdeletepackagesprotectionrulepackageprotectionrule"></a>`packageProtectionRule` | [`PackagesProtectionRule`](#packagesprotectionrule) | 正常に削除されたパッケージ保護ルール。 |

### `Mutation.deletePagesDeployment`

Pagesデプロイを削除します。

{{< details >}}GitLab 17.1で**導入**。**状態**: 実験。{{< /details >}}

入力型: `DeletePagesDeploymentInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdeletepagesdeploymentclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdeletepagesdeploymentid"></a>`id` | [`PagesDeploymentID!`](#pagesdeploymentid) | PagesデプロイのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdeletepagesdeploymentclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdeletepagesdeploymenterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationdeletepagesdeploymentpagesdeployment"></a>`pagesDeployment` | [`PagesDeployment!`](#pagesdeployment) | 削除されたPagesデプロイ。 |

### `Mutation.designManagementDelete`

入力型: `DesignManagementDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdesignmanagementdeletefilenames"></a>`filenames` | [`[String!]!`](#string) | 削除するデザインのファイル名。 |
| <a id="mutationdesignmanagementdeleteiid"></a>`iid` | [`ID!`](#id) | デザインを変更する対象となるイシューのIID。 |
| <a id="mutationdesignmanagementdeleteprojectpath"></a>`projectPath` | [`ID!`](#id) | イシューでデザインをアップロードする対象となるプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdesignmanagementdeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationdesignmanagementdeleteversion"></a>`version` | [`DesignVersion`](#designversion) | デザインが削除された新しいバージョン。 |

### `Mutation.designManagementMove`

入力型: `DesignManagementMoveInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementmoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdesignmanagementmoveid"></a>`id` | [`DesignManagementDesignID!`](#designmanagementdesignid) | 移動するデザインのID。 |
| <a id="mutationdesignmanagementmovenext"></a>`next` | [`DesignManagementDesignID`](#designmanagementdesignid) | 直後のデザインのID。 |
| <a id="mutationdesignmanagementmoveprevious"></a>`previous` | [`DesignManagementDesignID`](#designmanagementdesignid) | 直前のデザインのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementmoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdesignmanagementmovedesigncollection"></a>`designCollection` | [`DesignCollection`](#designcollection) | コレクションの現在の状態。 |
| <a id="mutationdesignmanagementmoveerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.designManagementUpdate`

入力型: `DesignManagementUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdesignmanagementupdatedescription"></a>`description` | [`String`](#string) | デザインの説明。 |
| <a id="mutationdesignmanagementupdateid"></a>`id` | [`DesignManagementDesignID!`](#designmanagementdesignid) | 更新するデザインのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdesignmanagementupdatedesign"></a>`design` | [`Design!`](#design) | 更新されたデザイン。 |
| <a id="mutationdesignmanagementupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.designManagementUpload`

入力型: `DesignManagementUploadInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementuploadclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdesignmanagementuploadfiles"></a>`files` | [`[Upload!]!`](#upload) | アップロードするファイル。 |
| <a id="mutationdesignmanagementuploadiid"></a>`iid` | [`ID!`](#id) | デザインを変更する対象となるイシューのIID。 |
| <a id="mutationdesignmanagementuploadprojectpath"></a>`projectPath` | [`ID!`](#id) | イシューでデザインをアップロードする対象となるプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementuploadclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdesignmanagementuploaddesigns"></a>`designs` | [`[Design!]!`](#design) | 変異によってアップロードされたデザイン。 |
| <a id="mutationdesignmanagementuploaderrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationdesignmanagementuploadskippeddesigns"></a>`skippedDesigns` | [`[Design!]!`](#design) | 最新バージョン以降にコンテンツへの変更がないためアップロードでスキップされたデザイン。 |

### `Mutation.destroyBoard`

入力型: `DestroyBoardInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroyboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdestroyboardid"></a>`id` | [`BoardID!`](#boardid) | 破棄するボードのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroyboardboard"></a>`board` | [`Board`](#board) | 変異後のボード。 |
| <a id="mutationdestroyboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdestroyboarderrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.destroyBoardList`

入力型: `DestroyBoardListInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroyboardlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdestroyboardlistlistid"></a>`listId` | [`ListID!`](#listid) | 破棄するリストのグローバルID。指定できるのはラベルリストだけです。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroyboardlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdestroyboardlisterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationdestroyboardlistlist"></a>`list` | [`BoardList`](#boardlist) | 変異後のリスト。 |

### `Mutation.destroyComplianceFramework`

入力型: `DestroyComplianceFrameworkInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroycomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdestroycomplianceframeworkid"></a>`id` | [`ComplianceManagementFrameworkID!`](#compliancemanagementframeworkid) | 破棄するコンプライアンスフレームワークのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroycomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdestroycomplianceframeworkerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.destroyComplianceRequirement`

{{< details >}}GitLab 17.7で**導入**。**状態**: 実験。{{< /details >}}

入力型: `DestroyComplianceRequirementInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroycompliancerequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdestroycompliancerequirementid"></a>`id` | [`ComplianceManagementComplianceFrameworkComplianceRequirementID!`](#compliancemanagementcomplianceframeworkcompliancerequirementid) | 破棄するコンプライアンス要件のグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroycompliancerequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdestroycompliancerequirementerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.destroyComplianceRequirementsControl`

{{< details >}}GitLab 17.9で**導入**。**状態**: 実験。{{< /details >}}

入力型: `DestroyComplianceRequirementsControlInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroycompliancerequirementscontrolclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdestroycompliancerequirementscontrolid"></a>`id` | [`ComplianceManagementComplianceFrameworkComplianceRequirementsControlID!`](#compliancemanagementcomplianceframeworkcompliancerequirementscontrolid) | 破棄するコンプライアンス要件コントロールのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroycompliancerequirementscontrolclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdestroycompliancerequirementscontrolerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.destroyContainerRepository`

入力型: `DestroyContainerRepositoryInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroycontainerrepositoryclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdestroycontainerrepositoryid"></a>`id` | [`ContainerRepositoryID!`](#containerrepositoryid) | コンテナリポジトリのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroycontainerrepositoryclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdestroycontainerrepositorycontainerrepository"></a>`containerRepository` | [`ContainerRepository!`](#containerrepository) | 削除のスケジュール後のコンテナリポジトリポリシー。 |
| <a id="mutationdestroycontainerrepositoryerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.destroyContainerRepositoryTags`

入力型: `DestroyContainerRepositoryTagsInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroycontainerrepositorytagsclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdestroycontainerrepositorytagsid"></a>`id` | [`ContainerRepositoryID!`](#containerrepositoryid) | コンテナリポジトリのID。 |
| <a id="mutationdestroycontainerrepositorytagstagnames"></a>`tagNames` | [`[String!]!`](#string) | 削除するコンテナリポジトリタグ。合計20個以下でなければなりません。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroycontainerrepositorytagsclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdestroycontainerrepositorytagsdeletedtagnames"></a>`deletedTagNames` | [`[String!]!`](#string) | 削除されたコンテナリポジトリタグ。 |
| <a id="mutationdestroycontainerrepositorytagserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.destroyCustomEmoji`

入力型: `DestroyCustomEmojiInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroycustomemojiclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdestroycustomemojiid"></a>`id` | [`CustomEmojiID!`](#customemojiid) | 削除するカスタム絵文字のグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroycustomemojiclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdestroycustomemojicustomemoji"></a>`customEmoji` | [`CustomEmoji`](#customemoji) | 削除されたカスタム絵文字。 |
| <a id="mutationdestroycustomemojierrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.destroyEpicBoard`

{{< details >}}GitLab 17.5で**非推奨**になりました。WorkItem型に置き換えられました。{{< /details >}}

入力型: `DestroyEpicBoardInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroyepicboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdestroyepicboardid"></a>`id` | [`BoardsEpicBoardID!`](#boardsepicboardid) | 破棄するボードのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroyepicboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdestroyepicboardepicboard"></a>`epicBoard` | [`EpicBoard`](#epicboard) | 変異後のエピックボード。 |
| <a id="mutationdestroyepicboarderrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.destroyNote`

入力型: `DestroyNoteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroynoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdestroynoteid"></a>`id` | [`NoteID!`](#noteid) | 破棄するノートのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroynoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdestroynoteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationdestroynotenote"></a>`note` | [`Note`](#note) | 変異後のノート。 |
| <a id="mutationdestroynotequickactionsstatus"></a>`quickActionsStatus` | [`QuickActionsStatus`](#quickactionsstatus) | 変異後のクイックアクションの状態。 |

### `Mutation.destroyPackage`

入力型: `DestroyPackageInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackageclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdestroypackageid"></a>`id` | [`PackagesPackageID!`](#packagespackageid) | パッケージのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackageclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdestroypackageerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.destroyPackageFile`

入力型: `DestroyPackageFileInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackagefileclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdestroypackagefileid"></a>`id` | [`PackagesPackageFileID!`](#packagespackagefileid) | パッケージファイルのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackagefileclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdestroypackagefileerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.destroyPackageFiles`

入力型: `DestroyPackageFilesInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackagefilesclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdestroypackagefilesids"></a>`ids` | [`[PackagesPackageFileID!]!`](#packagespackagefileid) | パッケージファイルのID。 |
| <a id="mutationdestroypackagefilesprojectpath"></a>`projectPath` | [`ID!`](#id) | パッケージクリーンアップポリシーの属するプロジェクトパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackagefilesclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdestroypackagefileserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.destroyPackages`

入力型: `DestroyPackagesInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackagesclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdestroypackagesids"></a>`ids` | [`[PackagesPackageID!]!`](#packagespackageid) | パッケージのグローバルID。最大20。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackagesclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdestroypackageserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.destroySnippet`

入力型: `DestroySnippetInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroysnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdestroysnippetid"></a>`id` | [`SnippetID!`](#snippetid) | 破棄するスニペットのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroysnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdestroysnippeterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationdestroysnippetsnippet"></a>`snippet` | [`Snippet`](#snippet) | 変異後のスニペット。 |

### `Mutation.disableDevopsAdoptionNamespace`

**状態: **ベータ版。

入力型: `DisableDevopsAdoptionNamespaceInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdisabledevopsadoptionnamespaceclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdisabledevopsadoptionnamespaceid"></a>`id` | [`[AnalyticsDevopsAdoptionEnabledNamespaceID!]!`](#analyticsdevopsadoptionenablednamespaceid) | 無効にする有効なネームスペースのID（1個または複数）。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdisabledevopsadoptionnamespaceclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdisabledevopsadoptionnamespaceerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.discussionToggleResolve`

ディスカッションの解決済み状態を切り替えます。

入力型: `DiscussionToggleResolveInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdiscussiontoggleresolveclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdiscussiontoggleresolveid"></a>`id` | [`DiscussionID!`](#discussionid) | ディスカッションのグローバルID。 |
| <a id="mutationdiscussiontoggleresolveresolve"></a>`resolve` | [`Boolean!`](#boolean) | trueの場合、ディスカッションを解決します。falseの場合、ディスカッションを未解決にします。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdiscussiontoggleresolveclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationdiscussiontoggleresolvediscussion"></a>`discussion` | [`Discussion`](#discussion) | 変異後のディスカッション。 |
| <a id="mutationdiscussiontoggleresolveerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.duoSettingsUpdate`

GitLab Duoの設定を更新します。

{{< details >}}GitLab 17.9で**導入**。**状態**: 実験。{{< /details >}}

入力型: `DuoSettingsUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationduosettingsupdateaigatewayurl"></a>`aiGatewayUrl` | [`String`](#string) | ローカルAIゲートウェイサーバーのURL。 |
| <a id="mutationduosettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationduosettingsupdateaigatewayurl"></a>`aiGatewayUrl` | [`String`](#string) | ローカルAIゲートウェイサーバーのURL。 |
| <a id="mutationduosettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationduosettingsupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.duoUserFeedback`

{{< details >}}GitLab 16.10で**導入**。**状態**: 実験。{{< /details >}}

入力型: `DuoUserFeedbackInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationduouserfeedbackagentversionid"></a>`agentVersionId` | [`AiAgentVersionID`](#aiagentversionid) | チャットに応答するエージェントのグローバルID。 |
| <a id="mutationduouserfeedbackaimessageid"></a>`aiMessageId` | [`String!`](#string) | AIメッセージのID。 |
| <a id="mutationduouserfeedbackclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationduouserfeedbacktrackingevent"></a>`trackingEvent` | [`TrackingEventInput`](#trackingeventinput) | 追跡イベントデータ。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationduouserfeedbackclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationduouserfeedbackerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.echoCreate`

変更を実行しない変異。

これは、ユーザーに変異アクセス権があることを確認するためのエンドポイントのテスト用に使用されることが想定されています。

入力型: `EchoCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationechocreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationechocreateerrors"></a>`errors` | [`[String!]`](#string) | ユーザーに返すエラー。 |
| <a id="mutationechocreatemessages"></a>`messages` | [`[String!]`](#string) | ユーザーに返すメッセージ。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationechocreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationechocreateechoes"></a>`echoes` | [`[String!]`](#string) | ユーザーに返されたメッセージ。 |
| <a id="mutationechocreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.enableDevopsAdoptionNamespace`

**状態: **ベータ版。

入力型: `EnableDevopsAdoptionNamespaceInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationenabledevopsadoptionnamespaceclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationenabledevopsadoptionnamespacedisplaynamespaceid"></a>`displayNamespaceId` | [`NamespaceID`](#namespaceid) | 表示ネームスペースID。 |
| <a id="mutationenabledevopsadoptionnamespacenamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | ネームスペースID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationenabledevopsadoptionnamespaceclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationenabledevopsadoptionnamespaceenablednamespace"></a>`enabledNamespace` | [`DevopsAdoptionEnabledNamespace`](#devopsadoptionenablednamespace) | 変異後に有効になったネームスペース。 |
| <a id="mutationenabledevopsadoptionnamespaceerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.environmentCreate`

環境を作成します。

入力型: `EnvironmentCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentcreateautostopsetting"></a>`autoStopSetting` | [`AutoStopSetting`](#autostopsetting) | 環境の自動停止設定。 |
| <a id="mutationenvironmentcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationenvironmentcreateclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID`](#clustersagentid) | 環境のクラスターエージェント。 |
| <a id="mutationenvironmentcreatedescription"></a>`description` | [`String`](#string) | 環境の説明。 |
| <a id="mutationenvironmentcreateexternalurl"></a>`externalUrl` | [`String`](#string) | 環境の外部URL。 |
| <a id="mutationenvironmentcreatefluxresourcepath"></a>`fluxResourcePath` | [`String`](#string) | 環境のFluxリソースパス。 |
| <a id="mutationenvironmentcreatekubernetesnamespace"></a>`kubernetesNamespace` | [`String`](#string) | 環境のKubernetesネームスペース。 |
| <a id="mutationenvironmentcreatename"></a>`name` | [`String!`](#string) | 環境の名前。 |
| <a id="mutationenvironmentcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | プロジェクトのフルパス。 |
| <a id="mutationenvironmentcreatetier"></a>`tier` | [`DeploymentTier`](#deploymenttier) | 環境のプラン。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationenvironmentcreateenvironment"></a>`environment` | [`Environment`](#environment) | 作成された環境。 |
| <a id="mutationenvironmentcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.environmentDelete`

環境を削除します。

入力型: `EnvironmentDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationenvironmentdeleteid"></a>`id` | [`EnvironmentID!`](#environmentid) | 削除する環境のグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationenvironmentdeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.environmentStop`

環境を停止します。

入力型: `EnvironmentStopInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentstopclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationenvironmentstopforce"></a>`force` | [`Boolean`](#boolean) | on_stopアクションを実行せずに環境を強制停止します。 |
| <a id="mutationenvironmentstopid"></a>`id` | [`EnvironmentID!`](#environmentid) | 停止する環境のグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentstopclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationenvironmentstopenvironment"></a>`environment` | [`Environment`](#environment) | 停止試行後の環境。 |
| <a id="mutationenvironmentstoperrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.environmentUpdate`

環境を更新します。

入力型: `EnvironmentUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentupdateautostopsetting"></a>`autoStopSetting` | [`AutoStopSetting`](#autostopsetting) | 環境の自動停止設定。 |
| <a id="mutationenvironmentupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationenvironmentupdateclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID`](#clustersagentid) | 環境のクラスターエージェント。 |
| <a id="mutationenvironmentupdatedescription"></a>`description` | [`String`](#string) | 環境の説明。 |
| <a id="mutationenvironmentupdateexternalurl"></a>`externalUrl` | [`String`](#string) | 環境の外部URL。 |
| <a id="mutationenvironmentupdatefluxresourcepath"></a>`fluxResourcePath` | [`String`](#string) | 環境のFluxリソースパス。 |
| <a id="mutationenvironmentupdateid"></a>`id` | [`EnvironmentID!`](#environmentid) | 更新する環境のグローバルID。 |
| <a id="mutationenvironmentupdatekubernetesnamespace"></a>`kubernetesNamespace` | [`String`](#string) | 環境のKubernetesネームスペース。 |
| <a id="mutationenvironmentupdatetier"></a>`tier` | [`DeploymentTier`](#deploymenttier) | 環境のプラン。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationenvironmentupdateenvironment"></a>`environment` | [`Environment`](#environment) | 更新試行後の環境。 |
| <a id="mutationenvironmentupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.environmentsCanaryIngressUpdate`

**非推奨** このエンドポイントは、証明書ベースのクラスターとともに削除される予定です。詳細については、[このエピックを参照してください](https://gitlab.com/groups/gitlab-org/configure/-/epics/8)。

入力型: `EnvironmentsCanaryIngressUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentscanaryingressupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationenvironmentscanaryingressupdateid"></a>`id` | [`EnvironmentID!`](#environmentid) | 更新する環境のグローバルID。 |
| <a id="mutationenvironmentscanaryingressupdateweight"></a>`weight` | [`Int!`](#int) | カナリアIngressのウェイト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentscanaryingressupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationenvironmentscanaryingressupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.epicAddIssue`

{{< details >}}GitLab 17.5で**非推奨**になりました。WorkItem型に置き換えられました。{{< /details >}}

入力型: `EpicAddIssueInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepicaddissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationepicaddissuegrouppath"></a>`groupPath` | [`ID!`](#id) | 変異対象のエピックが属するグループ。 |
| <a id="mutationepicaddissueiid"></a>`iid` | [`ID!`](#id) | 変異対象のエピックのIID。 |
| <a id="mutationepicaddissueissueiid"></a>`issueIid` | [`String!`](#string) | 追加するイシューのIID。 |
| <a id="mutationepicaddissueprojectpath"></a>`projectPath` | [`ID!`](#id) | イシューが属するプロジェクトのフルパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepicaddissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationepicaddissueepic"></a>`epic` | [`Epic`](#epic) | 変異後のエピック。 |
| <a id="mutationepicaddissueepicissue"></a>`epicIssue` | [`EpicIssue`](#epicissue) | エピックとイシューの関係。 |
| <a id="mutationepicaddissueerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.epicBoardCreate`

{{< details >}}GitLab 17.5で**非推奨**になりました。WorkItem型に置き換えられました。{{< /details >}}

入力型: `EpicBoardCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepicboardcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationepicboardcreatedisplaycolors"></a>`displayColors` | [`Boolean`](#boolean) | エピックの色を表示するかどうか。 |
| <a id="mutationepicboardcreategrouppath"></a>`groupPath` | [`ID`](#id) | リソースが関連付けられているグループのフルパス。 |
| <a id="mutationepicboardcreatehidebackloglist"></a>`hideBacklogList` | [`Boolean`](#boolean) | バックログリストを非表示にするかどうか。 |
| <a id="mutationepicboardcreatehideclosedlist"></a>`hideClosedList` | [`Boolean`](#boolean) | 完了リストを非表示にするかどうか。 |
| <a id="mutationepicboardcreatelabelids"></a>`labelIds` | [`[LabelID!]`](#labelid) | ボードに追加するラベルのID。 |
| <a id="mutationepicboardcreatelabels"></a>`labels` | [`[String!]`](#string) | イシューのラベル。 |
| <a id="mutationepicboardcreatename"></a>`name` | [`String`](#string) | ボード名。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepicboardcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationepicboardcreateepicboard"></a>`epicBoard` | [`EpicBoard`](#epicboard) | 作成されたエピックボード。 |
| <a id="mutationepicboardcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.epicBoardListCreate`

{{< details >}}GitLab 17.5で**非推奨**になりました。WorkItem型に置き換えられました。{{< /details >}}

入力型: `EpicBoardListCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepicboardlistcreatebacklog"></a>`backlog` | [`Boolean`](#boolean) | バックログリストを作成します。 |
| <a id="mutationepicboardlistcreateboardid"></a>`boardId` | [`BoardsEpicBoardID!`](#boardsepicboardid) | 変異対象のイシューボードのグローバルID。 |
| <a id="mutationepicboardlistcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationepicboardlistcreatelabelid"></a>`labelId` | [`LabelID`](#labelid) | 既存ラベルのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepicboardlistcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationepicboardlistcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationepicboardlistcreatelist"></a>`list` | [`EpicList`](#epiclist) | エピックボード中のエピックリスト。 |

### `Mutation.epicBoardListDestroy`

エピックボードリストを破棄します。

{{< details >}}GitLab 17.5で**非推奨**になりました。WorkItem型に置き換えられました。{{< /details >}}

入力型: `EpicBoardListDestroyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepicboardlistdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationepicboardlistdestroylistid"></a>`listId` | [`BoardsEpicListID!`](#boardsepiclistid) | 破棄するエピックボードリストのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepicboardlistdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationepicboardlistdestroyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationepicboardlistdestroylist"></a>`list` | [`EpicList`](#epiclist) | エピックボードリスト。ボードが正常に破棄された場合は`null`。 |

### `Mutation.epicBoardUpdate`

{{< details >}}GitLab 17.5で**非推奨**になりました。WorkItem型に置き換えられました。{{< /details >}}

入力型: `EpicBoardUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepicboardupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationepicboardupdatedisplaycolors"></a>`displayColors` | [`Boolean`](#boolean) | エピックの色を表示するかどうか。 |
| <a id="mutationepicboardupdatehidebackloglist"></a>`hideBacklogList` | [`Boolean`](#boolean) | バックログリストを非表示にするかどうか。 |
| <a id="mutationepicboardupdatehideclosedlist"></a>`hideClosedList` | [`Boolean`](#boolean) | 完了リストを非表示にするかどうか。 |
| <a id="mutationepicboardupdateid"></a>`id` | [`BoardsEpicBoardID!`](#boardsepicboardid) | エピックボードのグローバルID。 |
| <a id="mutationepicboardupdatelabelids"></a>`labelIds` | [`[LabelID!]`](#labelid) | ボードに追加するラベルのID。 |
| <a id="mutationepicboardupdatelabels"></a>`labels` | [`[String!]`](#string) | イシューのラベル。 |
| <a id="mutationepicboardupdatename"></a>`name` | [`String`](#string) | ボード名。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepicboardupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationepicboardupdateepicboard"></a>`epicBoard` | [`EpicBoard`](#epicboard) | 更新されたエピックボード。 |
| <a id="mutationepicboardupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.epicMoveList`

{{< details >}}GitLab 17.5で**非推奨**になりました。WorkItem型に置き換えられました。{{< /details >}}

入力型: `EpicMoveListInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepicmovelistboardid"></a>`boardId` | [`BoardsEpicBoardID!`](#boardsepicboardid) | エピックの属するボードのグローバルID。 |
| <a id="mutationepicmovelistclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationepicmovelistepicid"></a>`epicId` | [`EpicID!`](#epicid) | 変異対象のエピックのID。 |
| <a id="mutationepicmovelistfromlistid"></a>`fromListId` | [`BoardsEpicListID`](#boardsepiclistid) | エピックの移動元のボードリストのID。リスト間を移動する場合は必須。 |
| <a id="mutationepicmovelistmoveafterid"></a>`moveAfterId` | [`EpicID`](#epicid) | 現在のエピックの後に配置するエピックのID。 |
| <a id="mutationepicmovelistmovebeforeid"></a>`moveBeforeId` | [`EpicID`](#epicid) | 現在のエピックの前に配置するエピックのID。 |
| <a id="mutationepicmovelistpositioninlist"></a>`positionInList` | [`Int`](#int) | ボードリスト内のエピックの位置。位置は0から始まります。リストの末尾に移動するには-1を使用します。 |
| <a id="mutationepicmovelisttolistid"></a>`toListId` | [`BoardsEpicListID!`](#boardsepiclistid) | 変異後にエピックが属するリストのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepicmovelistclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationepicmovelistepic"></a>`epic` | [`Epic`](#epic) | 変異後のエピック。 |
| <a id="mutationepicmovelisterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.epicSetSubscription`

{{< details >}}GitLab 17.5で**非推奨**になりました。WorkItem型に置き換えられました。{{< /details >}}

入力型: `EpicSetSubscriptionInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepicsetsubscriptionclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationepicsetsubscriptiongrouppath"></a>`groupPath` | [`ID!`](#id) | 変異対象のエピックが属するグループ。 |
| <a id="mutationepicsetsubscriptioniid"></a>`iid` | [`ID!`](#id) | 変異対象のエピックのIID。 |
| <a id="mutationepicsetsubscriptionsubscribedstate"></a>`subscribedState` | [`Boolean!`](#boolean) | 目的とするサブスクリプションの状態。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepicsetsubscriptionclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationepicsetsubscriptionepic"></a>`epic` | [`Epic`](#epic) | 変異後のエピック。 |
| <a id="mutationepicsetsubscriptionerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.epicTreeReorder`

{{< details >}}GitLab 17.5で**非推奨**になりました。WorkItem型に置き換えられました。{{< /details >}}

入力型: `EpicTreeReorderInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepictreereorderbaseepicid"></a>`baseEpicId` | [`EpicID!`](#epicid) | ツリーのベースエピックのID。 |
| <a id="mutationepictreereorderclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationepictreereordermoved"></a>`moved` | [`EpicTreeNodeFieldsInputType!`](#epictreenodefieldsinputtype) | ツリーの位置を更新するためのパラメータ。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepictreereorderclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationepictreereordererrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.escalationPolicyCreate`

入力型: `EscalationPolicyCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationescalationpolicycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationescalationpolicycreatedescription"></a>`description` | [`String`](#string) | エスカレーションポリシーの説明。 |
| <a id="mutationescalationpolicycreatename"></a>`name` | [`String!`](#string) | エスカレーションポリシーの名前。 |
| <a id="mutationescalationpolicycreateprojectpath"></a>`projectPath` | [`ID!`](#id) | エスカレーションポリシー作成の対象となるプロジェクト。 |
| <a id="mutationescalationpolicycreaterules"></a>`rules` | [`[EscalationRuleInput!]!`](#escalationruleinput) | エスカレーションポリシーのステップ。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationescalationpolicycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationescalationpolicycreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationescalationpolicycreateescalationpolicy"></a>`escalationPolicy` | [`EscalationPolicyType`](#escalationpolicytype) | エスカレーションポリシー。 |

### `Mutation.escalationPolicyDestroy`

入力型: `EscalationPolicyDestroyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationescalationpolicydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationescalationpolicydestroyid"></a>`id` | [`IncidentManagementEscalationPolicyID!`](#incidentmanagementescalationpolicyid) | 削除するエスカレーションポリシーの内部ID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationescalationpolicydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationescalationpolicydestroyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationescalationpolicydestroyescalationpolicy"></a>`escalationPolicy` | [`EscalationPolicyType`](#escalationpolicytype) | エスカレーションポリシー。 |

### `Mutation.escalationPolicyUpdate`

入力型: `EscalationPolicyUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationescalationpolicyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationescalationpolicyupdatedescription"></a>`description` | [`String`](#string) | エスカレーションポリシーの説明。 |
| <a id="mutationescalationpolicyupdateid"></a>`id` | [`IncidentManagementEscalationPolicyID!`](#incidentmanagementescalationpolicyid) | オンコールローテーションを作成するオンコールスケジュールのID。 |
| <a id="mutationescalationpolicyupdatename"></a>`name` | [`String`](#string) | エスカレーションポリシーの名前。 |
| <a id="mutationescalationpolicyupdaterules"></a>`rules` | [`[EscalationRuleInput!]`](#escalationruleinput) | エスカレーションポリシーのステップ。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationescalationpolicyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationescalationpolicyupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationescalationpolicyupdateescalationpolicy"></a>`escalationPolicy` | [`EscalationPolicyType`](#escalationpolicytype) | エスカレーションポリシー。 |

### `Mutation.exportRequirements`

入力型: `ExportRequirementsInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationexportrequirementsauthorusername"></a>`authorUsername` | [`[String!]`](#string) | 要件を作成者のユーザー名でフィルタリングします。 |
| <a id="mutationexportrequirementsclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationexportrequirementsprojectpath"></a>`projectPath` | [`ID!`](#id) | 要件が関連付けられているプロジェクトのフルパス。 |
| <a id="mutationexportrequirementssearch"></a>`search` | [`String`](#string) | 要件タイトルの検索クエリ。 |
| <a id="mutationexportrequirementsselectedfields"></a>`selectedFields` | [`[String!]`](#string) | エクスポート対象として選択された要件フィールドのリスト。 |
| <a id="mutationexportrequirementssort"></a>`sort` | [`Sort`](#sort) | 要件をソート順に一覧表示します。 |
| <a id="mutationexportrequirementsstate"></a>`state` | [`RequirementState`](#requirementstate) | 要件を状態でフィルタリングします。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationexportrequirementsclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationexportrequirementserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.externalAuditEventDestinationCreate`

入力型: `ExternalAuditEventDestinationCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationexternalauditeventdestinationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationexternalauditeventdestinationcreatedestinationurl"></a>`destinationUrl` | [`String!`](#string) | 宛先URL。 |
| <a id="mutationexternalauditeventdestinationcreategrouppath"></a>`groupPath` | [`ID!`](#id) | グループパス。 |
| <a id="mutationexternalauditeventdestinationcreatename"></a>`name` | [`String`](#string) | 宛先名。 |
| <a id="mutationexternalauditeventdestinationcreateverificationtoken"></a>`verificationToken` | [`String`](#string) | 検証トークン。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationexternalauditeventdestinationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationexternalauditeventdestinationcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationexternalauditeventdestinationcreateexternalauditeventdestination"></a>`externalAuditEventDestination` | [`ExternalAuditEventDestination`](#externalauditeventdestination) | 作成された宛先。 |

### `Mutation.externalAuditEventDestinationDestroy`

入力型: `ExternalAuditEventDestinationDestroyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationexternalauditeventdestinationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationexternalauditeventdestinationdestroyid"></a>`id` | [`AuditEventsExternalAuditEventDestinationID!`](#auditeventsexternalauditeventdestinationid) | 破棄する外部監査イベントの宛先のID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationexternalauditeventdestinationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationexternalauditeventdestinationdestroyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.externalAuditEventDestinationUpdate`

入力型: `ExternalAuditEventDestinationUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationexternalauditeventdestinationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationexternalauditeventdestinationupdatedestinationurl"></a>`destinationUrl` | [`String`](#string) | 変更する宛先URL。 |
| <a id="mutationexternalauditeventdestinationupdateid"></a>`id` | [`AuditEventsExternalAuditEventDestinationID!`](#auditeventsexternalauditeventdestinationid) | 更新する外部監査イベントの宛先のID。 |
| <a id="mutationexternalauditeventdestinationupdatename"></a>`name` | [`String`](#string) | 宛先名。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationexternalauditeventdestinationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationexternalauditeventdestinationupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationexternalauditeventdestinationupdateexternalauditeventdestination"></a>`externalAuditEventDestination` | [`ExternalAuditEventDestination`](#externalauditeventdestination) | 更新された宛先。 |

### `Mutation.geoRegistriesBulkUpdate`

指定されたレジストリクラスの複数のGeoレジストリを変異します。

{{< details >}}GitLab 16.4で**導入**。**状態**: 実験。{{< /details >}}

入力型: `GeoRegistriesBulkUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgeoregistriesbulkupdateaction"></a>`action` | [`GeoRegistriesBulkAction!`](#georegistriesbulkaction) | Geoレジストリに対して実行するアクション。 |
| <a id="mutationgeoregistriesbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationgeoregistriesbulkupdateregistryclass"></a>`registryClass` | [`GeoRegistryClass!`](#georegistryclass) | 更新するGeoレジストリのクラス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgeoregistriesbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationgeoregistriesbulkupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationgeoregistriesbulkupdateregistryclass"></a>`registryClass` | [`GeoRegistryClass`](#georegistryclass) | 更新されたGeoレジストリクラス。 |

### `Mutation.geoRegistriesUpdate`

Geoレジストリを変異します。

{{< details >}}GitLab 16.1で**導入**。**状態**: 実験。{{< /details >}}

入力型: `GeoRegistriesUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgeoregistriesupdateaction"></a>`action` | [`GeoRegistryAction!`](#georegistryaction) | Geoレジストリに対して実行するアクション。 |
| <a id="mutationgeoregistriesupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationgeoregistriesupdateregistryid"></a>`registryId` | [`GeoBaseRegistryID!`](#geobaseregistryid) | 更新するGeoレジストリエントリのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgeoregistriesupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationgeoregistriesupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationgeoregistriesupdateregistry"></a>`registry` | [`Registrable`](#registrable) | 更新されたGeoレジストリエントリ。 |

### `Mutation.gitlabSubscriptionActivate`

入力型: `GitlabSubscriptionActivateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgitlabsubscriptionactivateactivationcode"></a>`activationCode` | [`String!`](#string) | GitLabサブスクリプションの購入後に受信したアクティベーションコード。 |
| <a id="mutationgitlabsubscriptionactivateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgitlabsubscriptionactivateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationgitlabsubscriptionactivateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationgitlabsubscriptionactivatefuturesubscriptions"></a>`futureSubscriptions` | [`[SubscriptionFutureEntry!]`](#subscriptionfutureentry) | 将来のサブスクリプションの配列。 |
| <a id="mutationgitlabsubscriptionactivatelicense"></a>`license` | [`CurrentLicense`](#currentlicense) | 現在のライセンス。 |

### `Mutation.googleCloudLoggingConfigurationCreate`

入力型: `GoogleCloudLoggingConfigurationCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgooglecloudloggingconfigurationcreateclientemail"></a>`clientEmail` | [`String!`](#string) | Google Cloud Loggingサービスの認証ややり取りに使用されるサービスアカウントに関連するメールアドレス。これは、IAM認証情報の一部です。 |
| <a id="mutationgooglecloudloggingconfigurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationgooglecloudloggingconfigurationcreategoogleprojectidname"></a>`googleProjectIdName` | [`String!`](#string) | ログ設定が属するGoogle Cloudプロジェクトの固有識別子。 |
| <a id="mutationgooglecloudloggingconfigurationcreategrouppath"></a>`groupPath` | [`ID!`](#id) | グループパス。 |
| <a id="mutationgooglecloudloggingconfigurationcreatelogidname"></a>`logIdName` | [`String`](#string) | 同じGoogle Cloudプロジェクト内で異なるログを区別および管理するために使用する固有識別子（デフォルトは`audit_events`）。 |
| <a id="mutationgooglecloudloggingconfigurationcreatename"></a>`name` | [`String`](#string) | 宛先名。 |
| <a id="mutationgooglecloudloggingconfigurationcreateprivatekey"></a>`privateKey` | [`String!`](#string) | サービスアカウントに関連付けられているプライベートキー。このキーは、サービスアカウントを認証したり、Google Cloud Loggingサービスとのやり取りを承認するために使用されます。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgooglecloudloggingconfigurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationgooglecloudloggingconfigurationcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationgooglecloudloggingconfigurationcreategooglecloudloggingconfiguration"></a>`googleCloudLoggingConfiguration` | [`GoogleCloudLoggingConfigurationType`](#googlecloudloggingconfigurationtype) | 作成された設定。 |

### `Mutation.googleCloudLoggingConfigurationDestroy`

入力型: `GoogleCloudLoggingConfigurationDestroyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgooglecloudloggingconfigurationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationgooglecloudloggingconfigurationdestroyid"></a>`id` | [`AuditEventsGoogleCloudLoggingConfigurationID!`](#auditeventsgooglecloudloggingconfigurationid) | 破棄するGoogle Cloudログ設定のID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgooglecloudloggingconfigurationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationgooglecloudloggingconfigurationdestroyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.googleCloudLoggingConfigurationUpdate`

入力型: `GoogleCloudLoggingConfigurationUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgooglecloudloggingconfigurationupdateclientemail"></a>`clientEmail` | [`String`](#string) | Google Cloud Loggingサービスの認証ややり取りに使用されるサービスアカウントに関連するメールアドレス。これは、IAM認証情報の一部です。 |
| <a id="mutationgooglecloudloggingconfigurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationgooglecloudloggingconfigurationupdategoogleprojectidname"></a>`googleProjectIdName` | [`String`](#string) | ログ設定が属するGoogle Cloudプロジェクトの固有識別子。 |
| <a id="mutationgooglecloudloggingconfigurationupdateid"></a>`id` | [`AuditEventsGoogleCloudLoggingConfigurationID!`](#auditeventsgooglecloudloggingconfigurationid) | 更新するGoogle Cloud設定のID。 |
| <a id="mutationgooglecloudloggingconfigurationupdatelogidname"></a>`logIdName` | [`String`](#string) | 同じGoogle Cloudプロジェクト内で異なるログを区別および管理するために使用する固有識別子。 |
| <a id="mutationgooglecloudloggingconfigurationupdatename"></a>`name` | [`String`](#string) | 宛先名。 |
| <a id="mutationgooglecloudloggingconfigurationupdateprivatekey"></a>`privateKey` | [`String`](#string) | サービスアカウントに関連付けられているプライベートキー。このキーは、サービスアカウントを認証したり、Google Cloud Loggingサービスとのやり取りを承認するために使用されます。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgooglecloudloggingconfigurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationgooglecloudloggingconfigurationupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationgooglecloudloggingconfigurationupdategooglecloudloggingconfiguration"></a>`googleCloudLoggingConfiguration` | [`GoogleCloudLoggingConfigurationType`](#googlecloudloggingconfigurationtype) | 更新対象の設定。 |

### `Mutation.groupAuditEventStreamingDestinationsCreate`

{{< details >}}GitLab 16.11で**導入**。**状態**: 実験。{{< /details >}}

入力型: `GroupAuditEventStreamingDestinationsCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupauditeventstreamingdestinationscreatecategory"></a>`category` | [`String!`](#string) | 宛先カテゴリ。 |
| <a id="mutationgroupauditeventstreamingdestinationscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationgroupauditeventstreamingdestinationscreateconfig"></a>`config` | [`JSON!`](#json) | 宛先設定。 |
| <a id="mutationgroupauditeventstreamingdestinationscreategrouppath"></a>`groupPath` | [`ID!`](#id) | グループパス。 |
| <a id="mutationgroupauditeventstreamingdestinationscreatename"></a>`name` | [`String`](#string) | 宛先名。 |
| <a id="mutationgroupauditeventstreamingdestinationscreatesecrettoken"></a>`secretToken` | [`String`](#string) | シークレットトークン。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupauditeventstreamingdestinationscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationgroupauditeventstreamingdestinationscreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationgroupauditeventstreamingdestinationscreateexternalauditeventdestination"></a>`externalAuditEventDestination` | [`GroupAuditEventStreamingDestination`](#groupauditeventstreamingdestination) | 作成された宛先。 |

### `Mutation.groupAuditEventStreamingDestinationsDelete`

{{< details >}}GitLab 16.11で**導入**。**状態**: 実験。{{< /details >}}

入力型: `GroupAuditEventStreamingDestinationsDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupauditeventstreamingdestinationsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationgroupauditeventstreamingdestinationsdeleteid"></a>`id` | [`AuditEventsGroupExternalStreamingDestinationID!`](#auditeventsgroupexternalstreamingdestinationid) | 削除する監査イベント外部ストリーミング宛先のID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupauditeventstreamingdestinationsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationgroupauditeventstreamingdestinationsdeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.groupAuditEventStreamingDestinationsUpdate`

{{< details >}}GitLab 16.11で**導入**。**状態**: 実験。{{< /details >}}

入力型: `GroupAuditEventStreamingDestinationsUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupauditeventstreamingdestinationsupdatecategory"></a>`category` | [`String`](#string) | 宛先カテゴリ。 |
| <a id="mutationgroupauditeventstreamingdestinationsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationgroupauditeventstreamingdestinationsupdateconfig"></a>`config` | [`JSON`](#json) | 宛先設定。 |
| <a id="mutationgroupauditeventstreamingdestinationsupdateid"></a>`id` | [`AuditEventsGroupExternalStreamingDestinationID!`](#auditeventsgroupexternalstreamingdestinationid) | 更新する外部監査イベントの宛先のID。 |
| <a id="mutationgroupauditeventstreamingdestinationsupdatename"></a>`name` | [`String`](#string) | 宛先名。 |
| <a id="mutationgroupauditeventstreamingdestinationsupdatesecrettoken"></a>`secretToken` | [`String`](#string) | シークレットトークン。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupauditeventstreamingdestinationsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationgroupauditeventstreamingdestinationsupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationgroupauditeventstreamingdestinationsupdateexternalauditeventdestination"></a>`externalAuditEventDestination` | [`GroupAuditEventStreamingDestination`](#groupauditeventstreamingdestination) | 更新された宛先。 |

### `Mutation.groupMemberBulkUpdate`

入力型: `GroupMemberBulkUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupmemberbulkupdateaccesslevel"></a>`accessLevel` | [`MemberAccessLevel!`](#memberaccesslevel) | メンバーの更新後アクセスレベル。 |
| <a id="mutationgroupmemberbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationgroupmemberbulkupdateexpiresat"></a>`expiresAt` | [`Time`](#time) | メンバーシップの期限切れ日時。 |
| <a id="mutationgroupmemberbulkupdategroupid"></a>`groupId` | [`GroupID!`](#groupid) | グループのグローバルID。 |
| <a id="mutationgroupmemberbulkupdateuserids"></a>`userIds` | [`[UserID!]!`](#userid) | メンバーのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupmemberbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationgroupmemberbulkupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationgroupmemberbulkupdategroupmembers"></a>`groupMembers` | [`[GroupMember!]`](#groupmember) | 変異後のグループメンバー。 |

### `Mutation.groupMembersExport`

{{< details >}}GitLab 17.4で**導入**。**状態**: 実験。{{< /details >}}

入力型: `GroupMembersExportInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupmembersexportclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationgroupmembersexportgroupid"></a>`groupId` | [`GroupID!`](#groupid) | グループのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupmembersexportclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationgroupmembersexporterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationgroupmembersexportmessage"></a>`message` | [`String`](#string) | エクスポートリクエストの結果メッセージ。 |

### `Mutation.groupSavedReplyCreate`

{{< details >}}GitLab 16.10で**導入**。**状態**: 実験。{{< /details >}}

入力型: `GroupSavedReplyCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupsavedreplycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationgroupsavedreplycreatecontent"></a>`content` | [`String!`](#string) | 保存済み返信の内容。 |
| <a id="mutationgroupsavedreplycreategroupid"></a>`groupId` | [`GroupID!`](#groupid) | 保存済み返信のグループ。 |
| <a id="mutationgroupsavedreplycreatename"></a>`name` | [`String!`](#string) | 保存済み返信の名前。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupsavedreplycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationgroupsavedreplycreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationgroupsavedreplycreatesavedreply"></a>`savedReply` | [`GroupSavedReply`](#groupsavedreply) | 変異後の保存済み返信。 |

### `Mutation.groupSavedReplyDestroy`

{{< details >}}GitLab 16.10で**導入**。**状態**: 実験。{{< /details >}}

入力型: `GroupSavedReplyDestroyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupsavedreplydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationgroupsavedreplydestroyid"></a>`id` | [`GroupsSavedReplyID!`](#groupssavedreplyid) | グループレベルで保存済み返信のグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupsavedreplydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationgroupsavedreplydestroyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationgroupsavedreplydestroysavedreply"></a>`savedReply` | [`GroupSavedReply`](#groupsavedreply) | 変異後の保存済み返信。 |

### `Mutation.groupSavedReplyUpdate`

{{< details >}}GitLab 16.10で**導入**。**状態**: 実験。{{< /details >}}

入力型: `GroupSavedReplyUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupsavedreplyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationgroupsavedreplyupdatecontent"></a>`content` | [`String!`](#string) | 保存済み返信の内容。 |
| <a id="mutationgroupsavedreplyupdateid"></a>`id` | [`GroupsSavedReplyID!`](#groupssavedreplyid) | グループレベルで保存済み返信のグローバルID。 |
| <a id="mutationgroupsavedreplyupdatename"></a>`name` | [`String!`](#string) | 保存済み返信の名前。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupsavedreplyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationgroupsavedreplyupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationgroupsavedreplyupdatesavedreply"></a>`savedReply` | [`GroupSavedReply`](#groupsavedreply) | 変異後の保存済み返信。 |

### `Mutation.groupUpdate`

入力型: `GroupUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationgroupupdateduofeaturesenabled"></a>`duoFeaturesEnabled` | [`Boolean`](#boolean) | グループでGitLab Duo機能が有効になっているかどうかを示します。GitLab 16.10で導入。**状態**: 実験。 |
| <a id="mutationgroupupdatefullpath"></a>`fullPath` | [`ID!`](#id) | 更新するグループのフルパス。 |
| <a id="mutationgroupupdatelockduofeaturesenabled"></a>`lockDuoFeaturesEnabled` | [`Boolean`](#boolean) | GitLab Duo機能で有効になっている設定がすべてのサブグループに適用されるかどうかを示します。GitLab 16.10で導入。**状態**: 実験。 |
| <a id="mutationgroupupdatelockmathrenderinglimitsenabled"></a>`lockMathRenderingLimitsEnabled` | [`Boolean`](#boolean) | 数式レンダリングの制限がすべての子孫グループに対してロックされているかどうかを示します。 |
| <a id="mutationgroupupdatemathrenderinglimitsenabled"></a>`mathRenderingLimitsEnabled` | [`Boolean`](#boolean) | 数式レンダリングの制限がグループに使用されるかどうかを示します。 |
| <a id="mutationgroupupdatename"></a>`name` | [`String`](#string) | ネームスペースの名前。 |
| <a id="mutationgroupupdatepath"></a>`path` | [`String`](#string) | ネームスペースのパス。 |
| <a id="mutationgroupupdatesharedrunnerssetting"></a>`sharedRunnersSetting` | [`SharedRunnersSetting`](#sharedrunnerssetting) | ネームスペースとその子孫が共有Runnerを利用できるかどうか。 |
| <a id="mutationgroupupdatevisibility"></a>`visibility` | [`VisibilityLevelsEnum`](#visibilitylevelsenum) | ネームスペースの表示レベル。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationgroupupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationgroupupdategroup"></a>`group` | [`Group`](#group) | 更新後のグループ。 |

### `Mutation.httpIntegrationCreate`

入力型: `HttpIntegrationCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationcreateactive"></a>`active` | [`Boolean!`](#boolean) | インテグレーションがアラートを受信しているかどうか。 |
| <a id="mutationhttpintegrationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationhttpintegrationcreatename"></a>`name` | [`String!`](#string) | インテグレーションの名前。 |
| <a id="mutationhttpintegrationcreatepayloadattributemappings"></a>`payloadAttributeMappings` | [`[AlertManagementPayloadAlertFieldInput!]`](#alertmanagementpayloadalertfieldinput) | GitLabアラート属性からペイロードの例に基づくフィールドへのカスタムマッピング。 |
| <a id="mutationhttpintegrationcreatepayloadexample"></a>`payloadExample` | [`JsonString`](#jsonstring) | アラートペイロードの例。 |
| <a id="mutationhttpintegrationcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | インテグレーションを作成するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationhttpintegrationcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationhttpintegrationcreateintegration"></a>`integration` | [`AlertManagementHttpIntegration`](#alertmanagementhttpintegration) | HTTPインテグレーション。 |

### `Mutation.httpIntegrationDestroy`

入力型: `HttpIntegrationDestroyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationhttpintegrationdestroyid"></a>`id` | [`AlertManagementHttpIntegrationID!`](#alertmanagementhttpintegrationid) | 削除するインテグレーションのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationhttpintegrationdestroyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationhttpintegrationdestroyintegration"></a>`integration` | [`AlertManagementHttpIntegration`](#alertmanagementhttpintegration) | HTTPインテグレーション。 |

### `Mutation.httpIntegrationResetToken`

入力型: `HttpIntegrationResetTokenInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationresettokenclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationhttpintegrationresettokenid"></a>`id` | [`AlertManagementHttpIntegrationID!`](#alertmanagementhttpintegrationid) | 変異対象のインテグレーションのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationresettokenclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationhttpintegrationresettokenerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationhttpintegrationresettokenintegration"></a>`integration` | [`AlertManagementHttpIntegration`](#alertmanagementhttpintegration) | HTTPインテグレーション。 |

### `Mutation.httpIntegrationUpdate`

入力型: `HttpIntegrationUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationupdateactive"></a>`active` | [`Boolean`](#boolean) | インテグレーションがアラートを受信しているかどうか。 |
| <a id="mutationhttpintegrationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationhttpintegrationupdateid"></a>`id` | [`AlertManagementHttpIntegrationID!`](#alertmanagementhttpintegrationid) | 変異対象のインテグレーションのID。 |
| <a id="mutationhttpintegrationupdatename"></a>`name` | [`String`](#string) | インテグレーションの名前。 |
| <a id="mutationhttpintegrationupdatepayloadattributemappings"></a>`payloadAttributeMappings` | [`[AlertManagementPayloadAlertFieldInput!]`](#alertmanagementpayloadalertfieldinput) | GitLabアラート属性からペイロードの例に基づくフィールドへのカスタムマッピング。 |
| <a id="mutationhttpintegrationupdatepayloadexample"></a>`payloadExample` | [`JsonString`](#jsonstring) | アラートペイロードの例。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationhttpintegrationupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationhttpintegrationupdateintegration"></a>`integration` | [`AlertManagementHttpIntegration`](#alertmanagementhttpintegration) | HTTPインテグレーション。 |

### `Mutation.importSourceUserCancelReassignment`

{{< details >}}GitLab 17.2で**導入**。**状態**: 実験。{{< /details >}}

入力型: `ImportSourceUserCancelReassignmentInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceusercancelreassignmentclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationimportsourceusercancelreassignmentid"></a>`id` | [`ImportSourceUserID!`](#importsourceuserid) | ソースインスタンス上のユーザーから宛先インスタンス上のユーザーへのマッピングのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceusercancelreassignmentclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationimportsourceusercancelreassignmenterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationimportsourceusercancelreassignmentimportsourceuser"></a>`importSourceUser` | [`ImportSourceUser`](#importsourceuser) | 変異後のソースインスタンスのユーザーから宛先インスタンスのユーザーへのマッピング。 |

### `Mutation.importSourceUserKeepAllAsPlaceholder`

{{< details >}}GitLab 17.6で**導入**。**状態**: 実験。{{< /details >}}

入力型: `ImportSourceUserKeepAllAsPlaceholderInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceuserkeepallasplaceholderclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationimportsourceuserkeepallasplaceholdernamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | ネームスペースのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceuserkeepallasplaceholderclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationimportsourceuserkeepallasplaceholdererrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationimportsourceuserkeepallasplaceholderupdatedimportsourceusercount"></a>`updatedImportSourceUserCount` | [`Int`](#int) | ソースインスタンスのユーザーからその宛先ユーザーへのマッピングのうち正常に更新されたものの数。 |

### `Mutation.importSourceUserKeepAsPlaceholder`

{{< details >}}GitLab 17.2で**導入**。**状態**: 実験。{{< /details >}}

入力型: `ImportSourceUserKeepAsPlaceholderInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceuserkeepasplaceholderclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationimportsourceuserkeepasplaceholderid"></a>`id` | [`ImportSourceUserID!`](#importsourceuserid) | ソースインスタンス上のユーザーから宛先インスタンス上のユーザーへのマッピングのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceuserkeepasplaceholderclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationimportsourceuserkeepasplaceholdererrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationimportsourceuserkeepasplaceholderimportsourceuser"></a>`importSourceUser` | [`ImportSourceUser`](#importsourceuser) | 変異後のソースインスタンスのユーザーから宛先インスタンスのユーザーへのマッピング。 |

### `Mutation.importSourceUserReassign`

{{< details >}}GitLab 17.2で**導入**。**状態**: 実験。{{< /details >}}

入力型: `ImportSourceUserReassignInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceuserreassignassigneeuserid"></a>`assigneeUserId` | [`UserID!`](#userid) | 割り当て先ユーザーのグローバルID。 |
| <a id="mutationimportsourceuserreassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationimportsourceuserreassignid"></a>`id` | [`ImportSourceUserID!`](#importsourceuserid) | ソースインスタンス上のユーザーから宛先インスタンス上のユーザーへのマッピングのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceuserreassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationimportsourceuserreassignerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationimportsourceuserreassignimportsourceuser"></a>`importSourceUser` | [`ImportSourceUser`](#importsourceuser) | 変異後のソースインスタンスのユーザーから宛先インスタンスのユーザーへのマッピング。 |

### `Mutation.importSourceUserResendNotification`

{{< details >}}GitLab 17.2で**導入**。**状態**: 実験。{{< /details >}}

入力型: `ImportSourceUserResendNotificationInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceuserresendnotificationclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationimportsourceuserresendnotificationid"></a>`id` | [`ImportSourceUserID!`](#importsourceuserid) | ソースインスタンス上のユーザーから宛先インスタンス上のユーザーへのマッピングのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceuserresendnotificationclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationimportsourceuserresendnotificationerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationimportsourceuserresendnotificationimportsourceuser"></a>`importSourceUser` | [`ImportSourceUser`](#importsourceuser) | 変異後のソースインスタンスのユーザーから宛先インスタンスのユーザーへのマッピング。 |

### `Mutation.instanceAuditEventStreamingDestinationsCreate`

{{< details >}}GitLab 16.11で**導入**。**状態**: 実験。{{< /details >}}

入力型: `InstanceAuditEventStreamingDestinationsCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstanceauditeventstreamingdestinationscreatecategory"></a>`category` | [`String!`](#string) | 宛先カテゴリ。 |
| <a id="mutationinstanceauditeventstreamingdestinationscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationinstanceauditeventstreamingdestinationscreateconfig"></a>`config` | [`JSON!`](#json) | 宛先設定。 |
| <a id="mutationinstanceauditeventstreamingdestinationscreatename"></a>`name` | [`String`](#string) | 宛先名。 |
| <a id="mutationinstanceauditeventstreamingdestinationscreatesecrettoken"></a>`secretToken` | [`String`](#string) | シークレットトークン。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstanceauditeventstreamingdestinationscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationinstanceauditeventstreamingdestinationscreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationinstanceauditeventstreamingdestinationscreateexternalauditeventdestination"></a>`externalAuditEventDestination` | [`InstanceAuditEventStreamingDestination`](#instanceauditeventstreamingdestination) | 作成された宛先。 |

### `Mutation.instanceAuditEventStreamingDestinationsDelete`

{{< details >}}GitLab 16.11で**導入**。**状態**: 実験。{{< /details >}}

入力型: `InstanceAuditEventStreamingDestinationsDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstanceauditeventstreamingdestinationsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationinstanceauditeventstreamingdestinationsdeleteid"></a>`id` | [`AuditEventsInstanceExternalStreamingDestinationID!`](#auditeventsinstanceexternalstreamingdestinationid) | 削除する監査イベント外部ストリーミング宛先のID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstanceauditeventstreamingdestinationsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationinstanceauditeventstreamingdestinationsdeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.instanceAuditEventStreamingDestinationsUpdate`

{{< details >}}GitLab 16.11で**導入**。**状態**: 実験。{{< /details >}}

入力型: `InstanceAuditEventStreamingDestinationsUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstanceauditeventstreamingdestinationsupdatecategory"></a>`category` | [`String`](#string) | 宛先カテゴリ。 |
| <a id="mutationinstanceauditeventstreamingdestinationsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationinstanceauditeventstreamingdestinationsupdateconfig"></a>`config` | [`JSON`](#json) | 宛先設定。 |
| <a id="mutationinstanceauditeventstreamingdestinationsupdateid"></a>`id` | [`AuditEventsInstanceExternalStreamingDestinationID!`](#auditeventsinstanceexternalstreamingdestinationid) | 更新する外部監査イベントの宛先のID。 |
| <a id="mutationinstanceauditeventstreamingdestinationsupdatename"></a>`name` | [`String`](#string) | 宛先名。 |
| <a id="mutationinstanceauditeventstreamingdestinationsupdatesecrettoken"></a>`secretToken` | [`String`](#string) | シークレットトークン。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstanceauditeventstreamingdestinationsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationinstanceauditeventstreamingdestinationsupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationinstanceauditeventstreamingdestinationsupdateexternalauditeventdestination"></a>`externalAuditEventDestination` | [`InstanceAuditEventStreamingDestination`](#instanceauditeventstreamingdestination) | 更新された宛先。 |

### `Mutation.instanceExternalAuditEventDestinationCreate`

入力型: `InstanceExternalAuditEventDestinationCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstanceexternalauditeventdestinationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationinstanceexternalauditeventdestinationcreatedestinationurl"></a>`destinationUrl` | [`String!`](#string) | 宛先URL。 |
| <a id="mutationinstanceexternalauditeventdestinationcreatename"></a>`name` | [`String`](#string) | 宛先名。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstanceexternalauditeventdestinationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationinstanceexternalauditeventdestinationcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationinstanceexternalauditeventdestinationcreateinstanceexternalauditeventdestination"></a>`instanceExternalAuditEventDestination` | [`InstanceExternalAuditEventDestination`](#instanceexternalauditeventdestination) | 作成された宛先。 |

### `Mutation.instanceExternalAuditEventDestinationDestroy`

入力型: `InstanceExternalAuditEventDestinationDestroyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstanceexternalauditeventdestinationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationinstanceexternalauditeventdestinationdestroyid"></a>`id` | [`AuditEventsInstanceExternalAuditEventDestinationID!`](#auditeventsinstanceexternalauditeventdestinationid) | 破棄する外部インスタンス監査イベント宛先のID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstanceexternalauditeventdestinationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationinstanceexternalauditeventdestinationdestroyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.instanceExternalAuditEventDestinationUpdate`

入力型: `InstanceExternalAuditEventDestinationUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstanceexternalauditeventdestinationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationinstanceexternalauditeventdestinationupdatedestinationurl"></a>`destinationUrl` | [`String`](#string) | 変更する宛先URL。 |
| <a id="mutationinstanceexternalauditeventdestinationupdateid"></a>`id` | [`AuditEventsInstanceExternalAuditEventDestinationID!`](#auditeventsinstanceexternalauditeventdestinationid) | 更新する外部インスタンス監査イベント宛先のID。 |
| <a id="mutationinstanceexternalauditeventdestinationupdatename"></a>`name` | [`String`](#string) | 宛先名。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstanceexternalauditeventdestinationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationinstanceexternalauditeventdestinationupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationinstanceexternalauditeventdestinationupdateinstanceexternalauditeventdestination"></a>`instanceExternalAuditEventDestination` | [`InstanceExternalAuditEventDestination`](#instanceexternalauditeventdestination) | 更新された宛先。 |

### `Mutation.instanceGoogleCloudLoggingConfigurationCreate`

入力型: `InstanceGoogleCloudLoggingConfigurationCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstancegooglecloudloggingconfigurationcreateclientemail"></a>`clientEmail` | [`String!`](#string) | Google Cloud Loggingサービスの認証ややり取りに使用されるサービスアカウントに関連するメールアドレス。これは、IAM認証情報の一部です。 |
| <a id="mutationinstancegooglecloudloggingconfigurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationinstancegooglecloudloggingconfigurationcreategoogleprojectidname"></a>`googleProjectIdName` | [`String!`](#string) | ログ設定が属するGoogle Cloudプロジェクトの固有識別子。 |
| <a id="mutationinstancegooglecloudloggingconfigurationcreatelogidname"></a>`logIdName` | [`String`](#string) | 同じGoogle Cloudプロジェクト内で異なるログを区別および管理するために使用する固有識別子（デフォルトは`audit_events`）。 |
| <a id="mutationinstancegooglecloudloggingconfigurationcreatename"></a>`name` | [`String`](#string) | 宛先名。 |
| <a id="mutationinstancegooglecloudloggingconfigurationcreateprivatekey"></a>`privateKey` | [`String!`](#string) | サービスアカウントに関連付けられているプライベートキー。このキーは、サービスアカウントを認証したり、Google Cloud Loggingサービスとのやり取りを承認するために使用されます。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstancegooglecloudloggingconfigurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationinstancegooglecloudloggingconfigurationcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationinstancegooglecloudloggingconfigurationcreateinstancegooglecloudloggingconfiguration"></a>`instanceGoogleCloudLoggingConfiguration` | [`InstanceGoogleCloudLoggingConfigurationType`](#instancegooglecloudloggingconfigurationtype) | 作成された設定。 |

### `Mutation.instanceGoogleCloudLoggingConfigurationDestroy`

入力型: `InstanceGoogleCloudLoggingConfigurationDestroyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstancegooglecloudloggingconfigurationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationinstancegooglecloudloggingconfigurationdestroyid"></a>`id` | [`AuditEventsInstanceGoogleCloudLoggingConfigurationID!`](#auditeventsinstancegooglecloudloggingconfigurationid) | 破棄するGoogle Cloudログ設定のID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstancegooglecloudloggingconfigurationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationinstancegooglecloudloggingconfigurationdestroyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.instanceGoogleCloudLoggingConfigurationUpdate`

入力型: `InstanceGoogleCloudLoggingConfigurationUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstancegooglecloudloggingconfigurationupdateclientemail"></a>`clientEmail` | [`String`](#string) | Google Cloud Loggingサービスの認証ややり取りに使用されるサービスアカウントに関連するメールアドレス。これは、IAM認証情報の一部です。 |
| <a id="mutationinstancegooglecloudloggingconfigurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationinstancegooglecloudloggingconfigurationupdategoogleprojectidname"></a>`googleProjectIdName` | [`String`](#string) | ログ設定が属するGoogle Cloudプロジェクトの固有識別子。 |
| <a id="mutationinstancegooglecloudloggingconfigurationupdateid"></a>`id` | [`AuditEventsInstanceGoogleCloudLoggingConfigurationID!`](#auditeventsinstancegooglecloudloggingconfigurationid) | 更新するインスタンスGoogle Cloud設定のID。 |
| <a id="mutationinstancegooglecloudloggingconfigurationupdatelogidname"></a>`logIdName` | [`String`](#string) | 同じGoogle Cloudプロジェクト内で異なるログを区別および管理するために使用する固有識別子。 |
| <a id="mutationinstancegooglecloudloggingconfigurationupdatename"></a>`name` | [`String`](#string) | 宛先名。 |
| <a id="mutationinstancegooglecloudloggingconfigurationupdateprivatekey"></a>`privateKey` | [`String`](#string) | サービスアカウントに関連付けられているプライベートキー。このキーは、サービスアカウントを認証したり、Google Cloud Loggingサービスとのやり取りを承認するために使用されます。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstancegooglecloudloggingconfigurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationinstancegooglecloudloggingconfigurationupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationinstancegooglecloudloggingconfigurationupdateinstancegooglecloudloggingconfiguration"></a>`instanceGoogleCloudLoggingConfiguration` | [`InstanceGoogleCloudLoggingConfigurationType`](#instancegooglecloudloggingconfigurationtype) | 更新対象の設定。 |

### `Mutation.integrationExclusionCreate`

{{< details >}}GitLab 17.0で**導入**。**状態**: 実験。{{< /details >}}

入力型: `IntegrationExclusionCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationintegrationexclusioncreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationintegrationexclusioncreategroupids"></a>`groupIds` | [`[GroupID!]`](#groupid) | 除外するグループのID（最大100個）。 |
| <a id="mutationintegrationexclusioncreateintegrationname"></a>`integrationName` | [`IntegrationType!`](#integrationtype) | 除外するインテグレーションのタイプ。 |
| <a id="mutationintegrationexclusioncreateprojectids"></a>`projectIds` | [`[ProjectID!]`](#projectid) | 除外するプロジェクトのID（最大100個）。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationintegrationexclusioncreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationintegrationexclusioncreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationintegrationexclusioncreateexclusions"></a>`exclusions` | [`[IntegrationExclusion!]`](#integrationexclusion) | 変異によって作成されたインテグレーション除外。 |

### `Mutation.integrationExclusionDelete`

{{< details >}}GitLab 17.0で**導入**。**状態**: 実験。{{< /details >}}

入力型: `IntegrationExclusionDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationintegrationexclusiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationintegrationexclusiondeletegroupids"></a>`groupIds` | [`[GroupID!]`](#groupid) | 除外されたグループのID。 |
| <a id="mutationintegrationexclusiondeleteintegrationname"></a>`integrationName` | [`IntegrationType!`](#integrationtype) | インテグレーションのタイプ。 |
| <a id="mutationintegrationexclusiondeleteprojectids"></a>`projectIds` | [`[ProjectID!]`](#projectid) | 除外されたプロジェクトのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationintegrationexclusiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationintegrationexclusiondeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationintegrationexclusiondeleteexclusions"></a>`exclusions` | [`[IntegrationExclusion!]`](#integrationexclusion) | 変異のため除外されなくなったプロジェクト。 |

### `Mutation.issuableResourceLinkCreate`

入力型: `IssuableResourceLinkCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuableresourcelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuableresourcelinkcreateid"></a>`id` | [`IssueID!`](#issueid) | リソースリンクの関連先インシデントID。 |
| <a id="mutationissuableresourcelinkcreatelink"></a>`link` | [`String!`](#string) | リソースのリンク。 |
| <a id="mutationissuableresourcelinkcreatelinktext"></a>`linkText` | [`String`](#string) | リソースのリンクテキスト。 |
| <a id="mutationissuableresourcelinkcreatelinktype"></a>`linkType` | [`IssuableResourceLinkType`](#issuableresourcelinktype) | リソースのリンクタイプ。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuableresourcelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuableresourcelinkcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationissuableresourcelinkcreateissuableresourcelink"></a>`issuableResourceLink` | [`IssuableResourceLink`](#issuableresourcelink) | イシュー可能リソースリンク。 |

### `Mutation.issuableResourceLinkDestroy`

入力型: `IssuableResourceLinkDestroyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuableresourcelinkdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuableresourcelinkdestroyid"></a>`id` | [`IncidentManagementIssuableResourceLinkID!`](#incidentmanagementissuableresourcelinkid) | 削除するイシュー可能リソースリンクID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuableresourcelinkdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuableresourcelinkdestroyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationissuableresourcelinkdestroyissuableresourcelink"></a>`issuableResourceLink` | [`IssuableResourceLink`](#issuableresourcelink) | イシュー可能リソースリンク。 |

### `Mutation.issueLinkAlerts`

入力型: `IssueLinkAlertsInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuelinkalertsalertreferences"></a>`alertReferences` | [`[String!]!`](#string) | インシデントにリンクするアラート参照。 |
| <a id="mutationissuelinkalertsclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuelinkalertsiid"></a>`iid` | [`String!`](#string) | 変異対象のイシューのIID。 |
| <a id="mutationissuelinkalertsprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のイシューの属するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuelinkalertsclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuelinkalertserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationissuelinkalertsissue"></a>`issue` | [`Issue`](#issue) | 変異後のイシュー。 |

### `Mutation.issueMove`

入力型: `IssueMoveInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuemoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuemoveiid"></a>`iid` | [`String!`](#string) | 変異対象のイシューのIID。 |
| <a id="mutationissuemoveprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のイシューの属するプロジェクト。 |
| <a id="mutationissuemovetargetprojectpath"></a>`targetProjectPath` | [`ID!`](#id) | イシューの移動先プロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuemoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuemoveerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationissuemoveissue"></a>`issue` | [`Issue`](#issue) | 変異後のイシュー。 |

### `Mutation.issueMoveList`

入力型: `IssueMoveListInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuemovelistboardid"></a>`boardId` | [`BoardID!`](#boardid) | イシューの属するボードのグローバルID。 |
| <a id="mutationissuemovelistclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuemovelistepicid"></a>`epicId` {{< icon name="warning-solid" >}} | [`EpicID`](#epicid) | **非推奨: **これはWorkItem hierarchyWidgetに置き換えられる予定です。GitLab 17.5で非推奨になりました。 |
| <a id="mutationissuemovelistfromlistid"></a>`fromListId` | [`ID`](#id) | イシューの移動元ボードリストのID。 |
| <a id="mutationissuemovelistiid"></a>`iid` | [`String!`](#string) | 変異対象のイシューのIID。 |
| <a id="mutationissuemovelistmoveafterid"></a>`moveAfterId` | [`ID`](#id) | 現在のイシューの後に配置するイシューのID。 |
| <a id="mutationissuemovelistmovebeforeid"></a>`moveBeforeId` | [`ID`](#id) | 現在のイシューの前に配置するイシューのID。 |
| <a id="mutationissuemovelistpositioninlist"></a>`positionInList` | [`Int`](#int) | ボードリスト内のイシューの位置。位置は0から始まります。リストの末尾に移動するには-1を使用します。 |
| <a id="mutationissuemovelistprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のイシューの属するプロジェクト。 |
| <a id="mutationissuemovelisttolistid"></a>`toListId` | [`ID`](#id) | イシューの移動先ボードリストのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuemovelistclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuemovelisterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationissuemovelistissue"></a>`issue` | [`Issue`](#issue) | 変異後のイシュー。 |

### `Mutation.issueSetAssignees`

入力型: `IssueSetAssigneesInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetassigneesassigneeusernames"></a>`assigneeUsernames` | [`[String!]!`](#string) | リソースに割り当てるユーザー名。デフォルトでは、既存の割り当てを置き換えます。 |
| <a id="mutationissuesetassigneesclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetassigneesiid"></a>`iid` | [`String!`](#string) | 変異対象のイシューのIID。 |
| <a id="mutationissuesetassigneesoperationmode"></a>`operationMode` | [`MutationOperationMode`](#mutationoperationmode) | 実行する操作。デフォルトはREPLACEです。 |
| <a id="mutationissuesetassigneesprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のイシューの属するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetassigneesclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetassigneeserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationissuesetassigneesissue"></a>`issue` | [`Issue`](#issue) | 変異後のイシュー。 |

### `Mutation.issueSetConfidential`

入力型: `IssueSetConfidentialInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetconfidentialclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetconfidentialconfidential"></a>`confidential` | [`Boolean!`](#boolean) | イシューを機密として設定するかどうか。 |
| <a id="mutationissuesetconfidentialiid"></a>`iid` | [`String!`](#string) | 変異対象のイシューのIID。 |
| <a id="mutationissuesetconfidentialprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のイシューの属するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetconfidentialclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetconfidentialerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationissuesetconfidentialissue"></a>`issue` | [`Issue`](#issue) | 変異後のイシュー。 |

### `Mutation.issueSetCrmContacts`

入力型: `IssueSetCrmContactsInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetcrmcontactsclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetcrmcontactscontactids"></a>`contactIds` | [`[CustomerRelationsContactID!]!`](#customerrelationscontactid) | 設定する顧客関連連絡先ID。デフォルトでは、既存の連絡先を置き換えます。 |
| <a id="mutationissuesetcrmcontactsiid"></a>`iid` | [`String!`](#string) | 変異対象のイシューのIID。 |
| <a id="mutationissuesetcrmcontactsoperationmode"></a>`operationMode` | [`MutationOperationMode`](#mutationoperationmode) | 操作モードを変更します。デフォルトはREPLACEです。 |
| <a id="mutationissuesetcrmcontactsprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のイシューの属するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetcrmcontactsclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetcrmcontactserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationissuesetcrmcontactsissue"></a>`issue` | [`Issue`](#issue) | 変異後のイシュー。 |

### `Mutation.issueSetDueDate`

入力型: `IssueSetDueDateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetduedateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetduedateduedate"></a>`dueDate` | [`Time`](#time) | イシューの期限となる目的の時刻。期限がnullの場合、削除されます。 |
| <a id="mutationissuesetduedateiid"></a>`iid` | [`String!`](#string) | 変異対象のイシューのIID。 |
| <a id="mutationissuesetduedateprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のイシューの属するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetduedateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetduedateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationissuesetduedateissue"></a>`issue` | [`Issue`](#issue) | 変異後のイシュー。 |

### `Mutation.issueSetEpic`

{{< details >}}GitLab 17.5で**非推奨**になりました。WorkItem型に置き換えられました。{{< /details >}}

入力型: `IssueSetEpicInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetepicepicid"></a>`epicId` {{< icon name="warning-solid" >}} | [`EpicID`](#epicid) | **非推奨: **これはWorkItem hierarchyWidgetに置き換えられる予定です。GitLab 17.5で非推奨になりました。 |
| <a id="mutationissuesetepiciid"></a>`iid` | [`String!`](#string) | 変異対象のイシューのIID。 |
| <a id="mutationissuesetepicprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のイシューの属するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetepicerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationissuesetepicissue"></a>`issue` | [`Issue`](#issue) | 変異後のイシュー。 |

### `Mutation.issueSetEscalationPolicy`

入力型: `IssueSetEscalationPolicyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetescalationpolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetescalationpolicyescalationpolicyid"></a>`escalationPolicyId` | [`IncidentManagementEscalationPolicyID`](#incidentmanagementescalationpolicyid) | イシューに割り当てるエスカレーションポリシーのグローバルID。ポリシーが存在しない場合、またはnullに設定されている場合は削除されます。 |
| <a id="mutationissuesetescalationpolicyiid"></a>`iid` | [`String!`](#string) | 変異対象のイシューのIID。 |
| <a id="mutationissuesetescalationpolicyprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のイシューの属するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetescalationpolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetescalationpolicyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationissuesetescalationpolicyissue"></a>`issue` | [`Issue`](#issue) | 変異後のイシュー。 |

### `Mutation.issueSetEscalationStatus`

入力型: `IssueSetEscalationStatusInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetescalationstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetescalationstatusiid"></a>`iid` | [`String!`](#string) | 変異対象のイシューのIID。 |
| <a id="mutationissuesetescalationstatusprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のイシューの属するプロジェクト。 |
| <a id="mutationissuesetescalationstatusstatus"></a>`status` | [`IssueEscalationStatus!`](#issueescalationstatus) | エスカレーション状態を設定します。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetescalationstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetescalationstatuserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationissuesetescalationstatusissue"></a>`issue` | [`Issue`](#issue) | 変異後のイシュー。 |

### `Mutation.issueSetIteration`

入力型: `IssueSetIterationInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetiterationclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetiterationiid"></a>`iid` | [`String!`](#string) | 変異対象のイシューのIID。 |
| <a id="mutationissuesetiterationiterationid"></a>`iterationId` | [`IterationID`](#iterationid) | イシューに割り当てるイテレーション。 |
| <a id="mutationissuesetiterationprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のイシューの属するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetiterationclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetiterationerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationissuesetiterationissue"></a>`issue` | [`Issue`](#issue) | 変異後のイシュー。 |

### `Mutation.issueSetLocked`

入力型: `IssueSetLockedInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetlockedclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetlockediid"></a>`iid` | [`String!`](#string) | 変異対象のイシューのIID。 |
| <a id="mutationissuesetlockedlocked"></a>`locked` | [`Boolean!`](#boolean) | イシューに関するディスカッションをロックするかどうか。 |
| <a id="mutationissuesetlockedprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のイシューの属するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetlockedclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetlockederrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationissuesetlockedissue"></a>`issue` | [`Issue`](#issue) | 変異後のイシュー。 |

### `Mutation.issueSetSeverity`

入力型: `IssueSetSeverityInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetseverityclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetseverityiid"></a>`iid` | [`String!`](#string) | 変異対象のイシューのIID。 |
| <a id="mutationissuesetseverityprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のイシューの属するプロジェクト。 |
| <a id="mutationissuesetseverityseverity"></a>`severity` | [`IssuableSeverity!`](#issuableseverity) | インシデントの重大度レベルを設定します。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetseverityclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetseverityerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationissuesetseverityissue"></a>`issue` | [`Issue`](#issue) | 変異後のイシュー。 |

### `Mutation.issueSetSubscription`

入力型: `IssueSetSubscriptionInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetsubscriptionclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetsubscriptioniid"></a>`iid` | [`String!`](#string) | 変異対象のイシューのIID。 |
| <a id="mutationissuesetsubscriptionprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のイシューの属するプロジェクト。 |
| <a id="mutationissuesetsubscriptionsubscribedstate"></a>`subscribedState` | [`Boolean!`](#boolean) | 目的とするサブスクリプションの状態。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetsubscriptionclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetsubscriptionerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationissuesetsubscriptionissue"></a>`issue` | [`Issue`](#issue) | 変異後のイシュー。 |

### `Mutation.issueSetWeight`

入力型: `IssueSetWeightInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetweightclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetweightiid"></a>`iid` | [`String!`](#string) | 変異対象のイシューのIID。 |
| <a id="mutationissuesetweightprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のイシューの属するプロジェクト。 |
| <a id="mutationissuesetweightweight"></a>`weight` | [`Int`](#int) | 目的とするイシューのウェイト。nullに設定すると、ウェイトは削除されます。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetweightclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetweighterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationissuesetweightissue"></a>`issue` | [`Issue`](#issue) | 変異後のイシュー。 |

### `Mutation.issueUnlinkAlert`

入力型: `IssueUnlinkAlertInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissueunlinkalertalertid"></a>`alertId` | [`AlertManagementAlertID!`](#alertmanagementalertid) | インシデントからリンク解除するアラートのグローバルID。 |
| <a id="mutationissueunlinkalertclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissueunlinkalertiid"></a>`iid` | [`String!`](#string) | 変異対象のイシューのIID。 |
| <a id="mutationissueunlinkalertprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のイシューの属するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissueunlinkalertclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissueunlinkalerterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationissueunlinkalertissue"></a>`issue` | [`Issue`](#issue) | 変異後のイシュー。 |

### `Mutation.issuesBulkUpdate`

イシューセットの複数プロパティの更新を許可します。`bulk_update_issues_mutation`機能フラグが無効になっている場合は、何もしません。

{{< details >}}GitLab 15.9で**導入**。**状態**: 実験。{{< /details >}}

入力型: `IssuesBulkUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesbulkupdateaddlabelids"></a>`addLabelIds` | [`[LabelID!]`](#labelid) | イシューに追加さすラベルのグローバルID配列。 |
| <a id="mutationissuesbulkupdateassigneeids"></a>`assigneeIds` | [`[UserID!]`](#userid) | 指定されたイシューに割り当てるユーザーのグローバルID配列。既存の割り当てが、このリストの割り当てに置き換えられます。 |
| <a id="mutationissuesbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuesbulkupdateepicid"></a>`epicId` {{< icon name="warning-solid" >}} | [`EpicID`](#epicid) | **非推奨: **これはWorkItem hierarchyWidgetに置き換えられる予定です。GitLab 17.5で非推奨になりました。 |
| <a id="mutationissuesbulkupdatehealthstatus"></a>`healthStatus` | [`HealthStatus`](#healthstatus) | イシューに割り当てるヘルスステータス。 |
| <a id="mutationissuesbulkupdateids"></a>`ids` | [`[IssueID!]!`](#issueid) | 更新するイシューのグローバルID配列。ユーザーが更新できないIDは無視されます。最大100個まで指定できます。 |
| <a id="mutationissuesbulkupdateiterationid"></a>`iterationId` | [`IterationID`](#iterationid) | イシューに割り当てるイテレーションのグローバルID。 |
| <a id="mutationissuesbulkupdatemilestoneid"></a>`milestoneId` | [`MilestoneID`](#milestoneid) | イシューに割り当てるマイルストーンのグローバルID。 |
| <a id="mutationissuesbulkupdateparentid"></a>`parentId` | [`IssueParentID!`](#issueparentid) | 一括更新のスコープとなる親のグローバルID。親としてプロジェクトも可能です。また親としてグループも可能です（PremiumおよびUltimateのみ）。例: `IssueParentID`は`"gid://gitlab/Project/1"`と`"gid://gitlab/Group/1"`です。 |
| <a id="mutationissuesbulkupdateremovelabelids"></a>`removeLabelIds` | [`[LabelID!]`](#labelid) | イシューから削除するラベルのグローバルID配列。 |
| <a id="mutationissuesbulkupdatestateevent"></a>`stateEvent` | [`IssueStateEvent`](#issuestateevent) | イシューをクローズまたは再オープンします。 |
| <a id="mutationissuesbulkupdatesubscriptionevent"></a>`subscriptionEvent` | [`IssuableSubscriptionEvent`](#issuablesubscriptionevent) | イシューの通知をサブスクライブまたはサブスクライブ解除します。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationissuesbulkupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationissuesbulkupdateupdatedissuecount"></a>`updatedIssueCount` | [`Int`](#int) | 正常に更新されたイシューの数。 |

### `Mutation.iterationCadenceCreate`

入力型: `IterationCadenceCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationiterationcadencecreateactive"></a>`active` | [`Boolean!`](#boolean) | イテレーションケイデンスがアクティブかどうか。 |
| <a id="mutationiterationcadencecreateautomatic"></a>`automatic` | [`Boolean!`](#boolean) | イテレーションケイデンスで今後のイテレーションを自動生成するかどうか。 |
| <a id="mutationiterationcadencecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationiterationcadencecreatedescription"></a>`description` | [`String`](#string) | イテレーションケイデンスの説明。最大長は5000文字です。 |
| <a id="mutationiterationcadencecreatedurationinweeks"></a>`durationInWeeks` | [`Int`](#int) | ケイデンス内でのイテレーションの期間（週単位）。 |
| <a id="mutationiterationcadencecreategrouppath"></a>`groupPath` | [`ID!`](#id) | イテレーションケイデンスを作成するグループ。 |
| <a id="mutationiterationcadencecreateiterationsinadvance"></a>`iterationsInAdvance` | [`Int`](#int) | イテレーションケイデンスが自動に設定されている場合に作成される今後のイテレーション。 |
| <a id="mutationiterationcadencecreaterollover"></a>`rollOver` | [`Boolean`](#boolean) | イテレーションケイデンスでイシューを次のイテレーションにロールオーバーするかどうか。 |
| <a id="mutationiterationcadencecreatestartdate"></a>`startDate` | [`Time`](#time) | 自動化開始日時のタイムスタンプ。 |
| <a id="mutationiterationcadencecreatetitle"></a>`title` | [`String`](#string) | イテレーションケイデンスのタイトル。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationiterationcadencecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationiterationcadencecreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationiterationcadencecreateiterationcadence"></a>`iterationCadence` | [`IterationCadence`](#iterationcadence) | 作成されたイテレーションケイデンス。 |

### `Mutation.iterationCadenceDestroy`

入力型: `IterationCadenceDestroyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationiterationcadencedestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationiterationcadencedestroyid"></a>`id` | [`IterationsCadenceID!`](#iterationscadenceid) | イテレーションケイデンスのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationiterationcadencedestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationiterationcadencedestroyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationiterationcadencedestroygroup"></a>`group` | [`Group!`](#group) | イテレーションケイデンスが属するグループ。 |

### `Mutation.iterationCadenceUpdate`

入力型: `IterationCadenceUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationiterationcadenceupdateactive"></a>`active` | [`Boolean`](#boolean) | イテレーションケイデンスがアクティブかどうか。 |
| <a id="mutationiterationcadenceupdateautomatic"></a>`automatic` | [`Boolean`](#boolean) | イテレーションケイデンスで今後のイテレーションを自動生成するかどうか。 |
| <a id="mutationiterationcadenceupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationiterationcadenceupdatedescription"></a>`description` | [`String`](#string) | イテレーションケイデンスの説明。最大長は5000文字です。 |
| <a id="mutationiterationcadenceupdatedurationinweeks"></a>`durationInWeeks` | [`Int`](#int) | ケイデンス内でのイテレーションの期間（週単位）。 |
| <a id="mutationiterationcadenceupdateid"></a>`id` | [`IterationsCadenceID!`](#iterationscadenceid) | イテレーションケイデンスのグローバルID。 |
| <a id="mutationiterationcadenceupdateiterationsinadvance"></a>`iterationsInAdvance` | [`Int`](#int) | イテレーションケイデンスが自動に設定されている場合に作成される今後のイテレーション。 |
| <a id="mutationiterationcadenceupdaterollover"></a>`rollOver` | [`Boolean`](#boolean) | イテレーションケイデンスでイシューを次のイテレーションにロールオーバーするかどうか。 |
| <a id="mutationiterationcadenceupdatestartdate"></a>`startDate` | [`Time`](#time) | 自動化開始日時のタイムスタンプ。 |
| <a id="mutationiterationcadenceupdatetitle"></a>`title` | [`String`](#string) | イテレーションケイデンスのタイトル。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationiterationcadenceupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationiterationcadenceupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationiterationcadenceupdateiterationcadence"></a>`iterationCadence` | [`IterationCadence`](#iterationcadence) | 更新されたイテレーションケイデンス。 |

### `Mutation.iterationCreate`

入力型: `iterationCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationiterationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationiterationcreatedescription"></a>`description` | [`String`](#string) | イテレーションの説明。 |
| <a id="mutationiterationcreateduedate"></a>`dueDate` | [`String`](#string) | イテレーションの終了日。 |
| <a id="mutationiterationcreategrouppath"></a>`groupPath` | [`ID`](#id) | リソースが関連付けられているグループのフルパス。 |
| <a id="mutationiterationcreateiterationscadenceid"></a>`iterationsCadenceId` | [`IterationsCadenceID`](#iterationscadenceid) | 新しいイテレーションに割り当てるイテレーションケイデンスのグローバルID。 |
| <a id="mutationiterationcreateprojectpath"></a>`projectPath` | [`ID`](#id) | リソースが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationiterationcreatestartdate"></a>`startDate` | [`String`](#string) | イテレーションの開始日。 |
| <a id="mutationiterationcreatetitle"></a>`title` | [`String`](#string) | イテレーションのタイトル。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationiterationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationiterationcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationiterationcreateiteration"></a>`iteration` | [`Iteration`](#iteration) | 作成されたイテレーション。 |

### `Mutation.iterationDelete`

入力型: `IterationDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationiterationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationiterationdeleteid"></a>`id` | [`IterationID!`](#iterationid) | イテレーションのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationiterationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationiterationdeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationiterationdeletegroup"></a>`group` | [`Group!`](#group) | イテレーションが属するグループ。 |

### `Mutation.jiraImportStart`

入力型: `JiraImportStartInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationjiraimportstartclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationjiraimportstartjiraprojectkey"></a>`jiraProjectKey` | [`String!`](#string) | インポーターJiraプロジェクトのプロジェクトキー。 |
| <a id="mutationjiraimportstartjiraprojectname"></a>`jiraProjectName` {{< icon name="warning-solid" >}} | [`String`](#string) | **非推奨: **引数は使用されません。GitLab 17.4で非推奨になりました。 |
| <a id="mutationjiraimportstartprojectpath"></a>`projectPath` | [`ID!`](#id) | Jiraプロジェクトのインポート先プロジェクト。 |
| <a id="mutationjiraimportstartusersmapping"></a>`usersMapping` | [`[JiraUsersMappingInputType!]`](#jirausersmappinginputtype) | JiraからGitLabユーザーへのマッピング。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationjiraimportstartclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationjiraimportstarterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationjiraimportstartjiraimport"></a>`jiraImport` | [`JiraImport`](#jiraimport) | 変異後のJiraインポートデータ。 |

### `Mutation.jiraImportUsers`

入力型: `JiraImportUsersInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationjiraimportusersclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationjiraimportusersprojectpath"></a>`projectPath` | [`ID!`](#id) | Jiraユーザーのインポート先プロジェクト。 |
| <a id="mutationjiraimportusersstartat"></a>`startAt` | [`Int`](#int) | インポートを開始するレコードのインデックス（デフォルトは0）（返されるレコードは50個）。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationjiraimportusersclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationjiraimportuserserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationjiraimportusersjirausers"></a>`jiraUsers` | [`[JiraUser!]`](#jirauser) | 可能ならメールと名前がマッチする、Jiraから返されるユーザー。 |

### `Mutation.jobArtifactsDestroy`

入力型: `JobArtifactsDestroyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationjobartifactsdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationjobartifactsdestroyid"></a>`id` | [`CiBuildID!`](#cibuildid) | 変異対象のジョブのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationjobartifactsdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationjobartifactsdestroydestroyedartifactscount"></a>`destroyedArtifactsCount` | [`Int!`](#int) | 削除されたアーティファクトの数。 |
| <a id="mutationjobartifactsdestroyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationjobartifactsdestroyjob"></a>`job` | [`CiJob`](#cijob) | 削除するアーティファクトを含むジョブ。 |

### `Mutation.jobCancel`

入力型: `JobCancelInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationjobcancelclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationjobcancelid"></a>`id` | [`CiBuildID!`](#cibuildid) | 変異対象のジョブのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationjobcancelclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationjobcancelerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationjobcanceljob"></a>`job` | [`CiJob`](#cijob) | 変異後のジョブ。 |

### `Mutation.jobPlay`

入力型: `JobPlayInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationjobplayclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationjobplayid"></a>`id` | [`CiProcessableID!`](#ciprocessableid) | 変異対象のジョブのID。 |
| <a id="mutationjobplayvariables"></a>`variables` | [`[CiVariableInput!]`](#civariableinput) | 手動ジョブ再生時に使用する変数。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationjobplayclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationjobplayerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationjobplayjob"></a>`job` | [`CiJob`](#cijob) | 変異後のジョブ。 |

### `Mutation.jobRetry`

入力型: `JobRetryInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationjobretryclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationjobretryid"></a>`id` | [`CiProcessableID!`](#ciprocessableid) | 変異対象のジョブのID。 |
| <a id="mutationjobretryvariables"></a>`variables` | [`[CiVariableInput!]`](#civariableinput) | 手動ジョブの再試行時に使用する変数。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationjobretryclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationjobretryerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationjobretryjob"></a>`job` | [`CiJob`](#cijob) | 変異後のジョブ。 |

### `Mutation.jobUnschedule`

入力型: `JobUnscheduleInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationjobunscheduleclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationjobunscheduleid"></a>`id` | [`CiBuildID!`](#cibuildid) | 変異対象のジョブのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationjobunscheduleclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationjobunscheduleerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationjobunschedulejob"></a>`job` | [`CiJob`](#cijob) | 変異後のジョブ。 |

### `Mutation.labelCreate`

入力型: `LabelCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationlabelcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationlabelcreatecolor"></a>`color` | [`String`](#string) | ラベルの色。先頭が「#」記号の6桁の16進表記（`#FFAABB`など）か、またはCSSカラー名のいずれかで指定。 |
| <a id="mutationlabelcreatedescription"></a>`description` | [`String`](#string) | ラベルの説明。 |
| <a id="mutationlabelcreategrouppath"></a>`groupPath` | [`ID`](#id) | リソースが関連付けられているグループのフルパス。 |
| <a id="mutationlabelcreateprojectpath"></a>`projectPath` | [`ID`](#id) | リソースが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationlabelcreatetitle"></a>`title` | [`String!`](#string) | ラベルのタイトル。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationlabelcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationlabelcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationlabelcreatelabel"></a>`label` | [`Label`](#label) | 変異後のラベル。 |

### `Mutation.markAsSpamSnippet`

入力型: `MarkAsSpamSnippetInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmarkasspamsnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmarkasspamsnippetid"></a>`id` | [`SnippetID!`](#snippetid) | 更新するスニペットのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmarkasspamsnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmarkasspamsnippeterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationmarkasspamsnippetsnippet"></a>`snippet` | [`Snippet`](#snippet) | 変異後のスニペット。 |

### `Mutation.memberRoleAdminCreate`

{{< details >}}GitLab 17.7で**導入**。**状態**: 実験。{{< /details >}}

入力型: `MemberRoleAdminCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmemberroleadmincreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmemberroleadmincreatedescription"></a>`description` | [`String`](#string) | メンバーロールの説明。 |
| <a id="mutationmemberroleadmincreatename"></a>`name` | [`String`](#string) | メンバーロールの名前。 |
| <a id="mutationmemberroleadmincreatepermissions"></a>`permissions` | [`[MemberRoleAdminPermission!]`](#memberroleadminpermission) | カスタマイズ可能な管理者権限すべてのリスト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmemberroleadmincreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmemberroleadmincreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationmemberroleadmincreatememberrole"></a>`memberRole` | [`AdminMemberRole`](#adminmemberrole) | メンバーロール。 |

### `Mutation.memberRoleAdminDelete`

{{< details >}}GitLab 17.10で**導入**。**状態**: 実験。{{< /details >}}

入力型: `MemberRoleAdminDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmemberroleadmindeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmemberroleadmindeleteid"></a>`id` | [`MemberRoleID!`](#memberroleid) | 削除する管理者メンバーロールのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmemberroleadmindeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmemberroleadmindeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationmemberroleadmindeletememberrole"></a>`memberRole` | [`MemberRole`](#memberrole) | 削除された管理者メンバーロール。 |

### `Mutation.memberRoleAdminUpdate`

{{< details >}}GitLab 17.10で**導入**。**状態**: 実験。{{< /details >}}

入力型: `MemberRoleAdminUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmemberroleadminupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmemberroleadminupdatedescription"></a>`description` | [`String`](#string) | メンバーロールの説明。 |
| <a id="mutationmemberroleadminupdateid"></a>`id` | [`MemberRoleID!`](#memberroleid) | 変異対象のメンバーロールのID。 |
| <a id="mutationmemberroleadminupdatename"></a>`name` | [`String`](#string) | メンバーロールの名前。 |
| <a id="mutationmemberroleadminupdatepermissions"></a>`permissions` | [`[MemberRoleAdminPermission!]`](#memberroleadminpermission) | カスタマイズ可能な管理者権限すべてのリスト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmemberroleadminupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmemberroleadminupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationmemberroleadminupdatememberrole"></a>`memberRole` | [`AdminMemberRole`](#adminmemberrole) | メンバーロール。 |

### `Mutation.memberRoleCreate`

{{< details >}}GitLab 16.5で**導入**。**状態**: 実験。{{< /details >}}

入力型: `MemberRoleCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmemberrolecreatebaseaccesslevel"></a>`baseAccessLevel` | [`MemberRolesAccessLevel!`](#memberrolesaccesslevel) | カスタムロールの基本アクセスレベル。 |
| <a id="mutationmemberrolecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmemberrolecreatedescription"></a>`description` | [`String`](#string) | メンバーロールの説明。 |
| <a id="mutationmemberrolecreategrouppath"></a>`groupPath` | [`ID`](#id) | 変異対象のメンバーロールが属するグループ。SaaSでは必須。 |
| <a id="mutationmemberrolecreatename"></a>`name` | [`String`](#string) | メンバーロールの名前。 |
| <a id="mutationmemberrolecreatepermissions"></a>`permissions` | [`[MemberRolePermission!]`](#memberrolepermission) | カスタマイズ可能な権限すべてのリスト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmemberrolecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmemberrolecreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationmemberrolecreatememberrole"></a>`memberRole` | [`MemberRole`](#memberrole) | メンバーロール。 |

### `Mutation.memberRoleDelete`

{{< details >}}GitLab 16.7で**導入**。**状態**: 実験。{{< /details >}}

入力型: `MemberRoleDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmemberroledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmemberroledeleteid"></a>`id` | [`MemberRoleID!`](#memberroleid) | 削除するメンバーロールのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmemberroledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmemberroledeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationmemberroledeletememberrole"></a>`memberRole` | [`MemberRole`](#memberrole) | 削除されたメンバーロール。 |

### `Mutation.memberRoleToUserAssign`

{{< details >}}GitLab 17.7で**導入**。**状態**: 実験。{{< /details >}}

入力型: `MemberRoleToUserAssignInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmemberroletouserassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmemberroletouserassignmemberroleid"></a>`memberRoleId` | [`MemberRoleID`](#memberroleid) | ユーザーに割り当てるカスタムロールのグローバルID。省略した場合、またはNULLに設定した場合、ユーザーの管理者ロール割り当てが解除されます。 |
| <a id="mutationmemberroletouserassignuserid"></a>`userId` | [`UserID!`](#userid) | カスタムロールに割り当てるユーザーのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmemberroletouserassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmemberroletouserassignerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationmemberroletouserassignusermemberrole"></a>`userMemberRole` | [`UserMemberRole`](#usermemberrole) | 作成されたユーザーメンバーロール。関係が削除された場合はnil。 |

### `Mutation.memberRoleUpdate`

入力型: `MemberRoleUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmemberroleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmemberroleupdatedescription"></a>`description` | [`String`](#string) | メンバーロールの説明。 |
| <a id="mutationmemberroleupdateid"></a>`id` | [`MemberRoleID!`](#memberroleid) | 変異対象のメンバーロールのID。 |
| <a id="mutationmemberroleupdatename"></a>`name` | [`String`](#string) | メンバーロールの名前。 |
| <a id="mutationmemberroleupdatepermissions"></a>`permissions` | [`[MemberRolePermission!]`](#memberrolepermission) | カスタマイズ可能な権限すべてのリスト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmemberroleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmemberroleupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationmemberroleupdatememberrole"></a>`memberRole` | [`MemberRole`](#memberrole) | メンバーロール。 |

### `Mutation.mergeRequestAccept`

マージリクエストを受け入れます。受け入れた場合と、可能ならすぐに、または自動マージ戦略のいずれかを使用して、ソースブランチがターゲットブランチにマージされるようにスケジュールされます。

[GitLab 16.5において](https://gitlab.com/gitlab-org/gitlab/-/issues/421510)、マージ操作は非同期です。そのため、変異リクエスト後も、マージが未完の可能性があり、その場合、`mergeRequest`と`state`は更新されません。

入力型: `MergeRequestAcceptInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestacceptclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestacceptcommitmessage"></a>`commitMessage` | [`String`](#string) | カスタムGitLab Duoマージコミットメッセージ。 |
| <a id="mutationmergerequestacceptiid"></a>`iid` | [`String!`](#string) | 変異対象のマージリクエストのIID。 |
| <a id="mutationmergerequestacceptprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のマージリクエストが属するプロジェクト。 |
| <a id="mutationmergerequestacceptsha"></a>`sha` | [`String!`](#string) | マージリクエスト時点のHEAD SHA。 |
| <a id="mutationmergerequestacceptshouldremovesourcebranch"></a>`shouldRemoveSourceBranch` | [`Boolean`](#boolean) | ソースブランチを削除する必要があるかどうか。 |
| <a id="mutationmergerequestacceptsquash"></a>`squash` | [`Boolean`](#boolean) | マージする前にソースブランチのコミットをスカッシュします。 |
| <a id="mutationmergerequestacceptsquashcommitmessage"></a>`squashCommitMessage` | [`String`](#string) | カスタムスカッシュコミットメッセージ（squashがtrueの場合）。 |
| <a id="mutationmergerequestacceptstrategy"></a>`strategy` | [`MergeStrategyEnum`](#mergestrategyenum) | マージリクエストをマージする方法。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestacceptclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestaccepterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationmergerequestacceptmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | 変異後のマージリクエスト。 |

### `Mutation.mergeRequestCreate`

入力型: `MergeRequestCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestcreatedescription"></a>`description` | [`String`](#string) | マージリクエストの説明（Markdownをキャッシュ用にHTMLとしてレンダリング）。 |
| <a id="mutationmergerequestcreatelabels"></a>`labels` | [`[String!]`](#string) | マージリクエストのラベル。 |
| <a id="mutationmergerequestcreatemergeafter"></a>`mergeAfter` | [`Time`](#time) | マージリクエストをマージできようになる日付。 |
| <a id="mutationmergerequestcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | マージリクエストが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationmergerequestcreatesourcebranch"></a>`sourceBranch` | [`String!`](#string) | マージリクエストのソースブランチ。 |
| <a id="mutationmergerequestcreatetargetbranch"></a>`targetBranch` | [`String!`](#string) | マージリクエストのターゲットブランチ。 |
| <a id="mutationmergerequestcreatetitle"></a>`title` | [`String!`](#string) | マージリクエストのタイトル。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationmergerequestcreatemergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | 変異後のマージリクエスト。 |

### `Mutation.mergeRequestDestroyRequestedChanges`

入力型: `MergeRequestDestroyRequestedChangesInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestdestroyrequestedchangesclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestdestroyrequestedchangesiid"></a>`iid` | [`String!`](#string) | 変異対象のマージリクエストのIID。 |
| <a id="mutationmergerequestdestroyrequestedchangesprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のマージリクエストが属するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestdestroyrequestedchangesclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestdestroyrequestedchangeserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationmergerequestdestroyrequestedchangesmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | 変異後のマージリクエスト。 |

### `Mutation.mergeRequestReviewerRereview`

入力型: `MergeRequestReviewerRereviewInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestreviewerrereviewclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestreviewerrereviewiid"></a>`iid` | [`String!`](#string) | 変異対象のマージリクエストのIID。 |
| <a id="mutationmergerequestreviewerrereviewprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のマージリクエストが属するプロジェクト。 |
| <a id="mutationmergerequestreviewerrereviewuserid"></a>`userId` | [`UserID!`](#userid) | 新規レビュー用にリクエストされたユーザーのユーザーID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestreviewerrereviewclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestreviewerrereviewerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationmergerequestreviewerrereviewmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | 変異後のマージリクエスト。 |

### `Mutation.mergeRequestSetAssignees`

入力型: `MergeRequestSetAssigneesInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetassigneesassigneeusernames"></a>`assigneeUsernames` | [`[String!]!`](#string) | リソースに割り当てるユーザー名。デフォルトでは、既存の割り当てを置き換えます。 |
| <a id="mutationmergerequestsetassigneesclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestsetassigneesiid"></a>`iid` | [`String!`](#string) | 変異対象のマージリクエストのIID。 |
| <a id="mutationmergerequestsetassigneesoperationmode"></a>`operationMode` | [`MutationOperationMode`](#mutationoperationmode) | 実行する操作。デフォルトはREPLACEです。 |
| <a id="mutationmergerequestsetassigneesprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のマージリクエストが属するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetassigneesclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestsetassigneeserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationmergerequestsetassigneesmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | 変異後のマージリクエスト。 |

### `Mutation.mergeRequestSetDraft`

入力型: `MergeRequestSetDraftInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetdraftclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestsetdraftdraft"></a>`draft` | [`Boolean!`](#boolean) | マージリクエストを下書きとして設定するかどうか。 |
| <a id="mutationmergerequestsetdraftiid"></a>`iid` | [`String!`](#string) | 変異対象のマージリクエストのIID。 |
| <a id="mutationmergerequestsetdraftprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のマージリクエストが属するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetdraftclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestsetdrafterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationmergerequestsetdraftmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | 変異後のマージリクエスト。 |

### `Mutation.mergeRequestSetLabels`

入力型: `MergeRequestSetLabelsInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetlabelsclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestsetlabelsiid"></a>`iid` | [`String!`](#string) | 変異対象のマージリクエストのIID。 |
| <a id="mutationmergerequestsetlabelslabelids"></a>`labelIds` | [`[LabelID!]!`](#labelid) | 設定するラベルID。デフォルトでは既存のラベルを置き換えます。 |
| <a id="mutationmergerequestsetlabelsoperationmode"></a>`operationMode` | [`MutationOperationMode`](#mutationoperationmode) | 操作モードを変更します。デフォルトはREPLACEです。 |
| <a id="mutationmergerequestsetlabelsprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のマージリクエストが属するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetlabelsclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestsetlabelserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationmergerequestsetlabelsmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | 変異後のマージリクエスト。 |

### `Mutation.mergeRequestSetLocked`

入力型: `MergeRequestSetLockedInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetlockedclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestsetlockediid"></a>`iid` | [`String!`](#string) | 変異対象のマージリクエストのIID。 |
| <a id="mutationmergerequestsetlockedlocked"></a>`locked` | [`Boolean!`](#boolean) | マージリクエストをロックするかどうか。 |
| <a id="mutationmergerequestsetlockedprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のマージリクエストが属するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetlockedclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestsetlockederrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationmergerequestsetlockedmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | 変異後のマージリクエスト。 |

### `Mutation.mergeRequestSetMilestone`

入力型: `MergeRequestSetMilestoneInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetmilestoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestsetmilestoneiid"></a>`iid` | [`String!`](#string) | 変異対象のマージリクエストのIID。 |
| <a id="mutationmergerequestsetmilestonemilestoneid"></a>`milestoneId` | [`MilestoneID`](#milestoneid) | マージリクエストに割り当てるマイルストーン。 |
| <a id="mutationmergerequestsetmilestoneprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のマージリクエストが属するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetmilestoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestsetmilestoneerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationmergerequestsetmilestonemergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | 変異後のマージリクエスト。 |

### `Mutation.mergeRequestSetReviewers`

入力型: `MergeRequestSetReviewersInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetreviewersclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestsetreviewersiid"></a>`iid` | [`String!`](#string) | 変異対象のマージリクエストのIID。 |
| <a id="mutationmergerequestsetreviewersoperationmode"></a>`operationMode` | [`MutationOperationMode`](#mutationoperationmode) | 実行する操作。デフォルトはREPLACEです。 |
| <a id="mutationmergerequestsetreviewersprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のマージリクエストが属するプロジェクト。 |
| <a id="mutationmergerequestsetreviewersreviewerusernames"></a>`reviewerUsernames` | [`[String!]!`](#string) | 割り当てるレビュアーのユーザー名。デフォルトでは、既存のレビュー担当者を置き換えます。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetreviewersclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestsetreviewerserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationmergerequestsetreviewersmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | 変異後のマージリクエスト。 |

### `Mutation.mergeRequestSetSubscription`

入力型: `MergeRequestSetSubscriptionInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetsubscriptionclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestsetsubscriptioniid"></a>`iid` | [`String!`](#string) | 変異対象のマージリクエストのIID。 |
| <a id="mutationmergerequestsetsubscriptionprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のマージリクエストが属するプロジェクト。 |
| <a id="mutationmergerequestsetsubscriptionsubscribedstate"></a>`subscribedState` | [`Boolean!`](#boolean) | 目的とするサブスクリプションの状態。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetsubscriptionclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestsetsubscriptionerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationmergerequestsetsubscriptionmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | 変異後のマージリクエスト。 |

### `Mutation.mergeRequestUpdate`

マージリクエストの属性を更新します。

入力型: `MergeRequestUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestupdatedescription"></a>`description` | [`String`](#string) | マージリクエストの説明（Markdownをキャッシュ用にHTMLとしてレンダリング）。 |
| <a id="mutationmergerequestupdateiid"></a>`iid` | [`String!`](#string) | 変異対象のマージリクエストのIID。 |
| <a id="mutationmergerequestupdatemergeafter"></a>`mergeAfter` | [`Time`](#time) | マージリクエストをマージできようになる日付。 |
| <a id="mutationmergerequestupdateoverriderequestedchanges"></a>`overrideRequestedChanges` | [`Boolean`](#boolean) | リクエストされた変更をすべてオーバーライドします。このマージリクエストをマージする権限を付与されたユーザーのみが設定できます。 |
| <a id="mutationmergerequestupdateprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のマージリクエストが属するプロジェクト。 |
| <a id="mutationmergerequestupdatestate"></a>`state` | [`MergeRequestNewState`](#mergerequestnewstate) | 状態を変更するために実行するアクション。 |
| <a id="mutationmergerequestupdatetargetbranch"></a>`targetBranch` | [`String`](#string) | マージリクエストのターゲットブランチ。 |
| <a id="mutationmergerequestupdatetimeestimate"></a>`timeEstimate` | [`String`](#string) | マージリクエストを完了するための推定時間。`null`または`0`を使用すると、現在の推定値が削除されます。 |
| <a id="mutationmergerequestupdatetitle"></a>`title` | [`String`](#string) | マージリクエストのタイトル。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationmergerequestupdatemergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | 変異後のマージリクエスト。 |

### `Mutation.mergeRequestUpdateApprovalRule`

入力型: `MergeRequestUpdateApprovalRuleInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestupdateapprovalruleapprovalruleid"></a>`approvalRuleId` | [`Int!`](#int) | 承認ルールのID。 |
| <a id="mutationmergerequestupdateapprovalruleapprovalsrequired"></a>`approvalsRequired` | [`Int!`](#int) | 特定のルールに必要な承認数。 |
| <a id="mutationmergerequestupdateapprovalruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestupdateapprovalrulegroupids"></a>`groupIds` | [`[String!]`](#string) | 承認者としてのグループのID。 |
| <a id="mutationmergerequestupdateapprovalruleiid"></a>`iid` | [`String!`](#string) | 変異対象のマージリクエストのIID。 |
| <a id="mutationmergerequestupdateapprovalrulename"></a>`name` | [`String!`](#string) | 承認ルールの名前。 |
| <a id="mutationmergerequestupdateapprovalruleprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のマージリクエストが属するプロジェクト。 |
| <a id="mutationmergerequestupdateapprovalruleremovehiddengroups"></a>`removeHiddenGroups` | [`Boolean`](#boolean) | 非表示のグループを削除するかどうか。 |
| <a id="mutationmergerequestupdateapprovalruleuserids"></a>`userIds` | [`[String!]`](#string) | 承認者としてのユーザーのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestupdateapprovalruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestupdateapprovalruleerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationmergerequestupdateapprovalrulemergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | 変異後のマージリクエスト。 |

### `Mutation.mergeTrainsDeleteCar`

{{< details >}}GitLab 17.2で**導入**。**状態**: 実験。{{< /details >}}

入力型: `MergeTrainsDeleteCarInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergetrainsdeletecarcarid"></a>`carId` | [`MergeTrainsCarID!`](#mergetrainscarid) | 車両のグローバルID。 |
| <a id="mutationmergetrainsdeletecarclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergetrainsdeletecarclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmergetrainsdeletecarerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.mlModelCreate`

{{< details >}}GitLab 16.8で**導入**。**状態**: 実験。{{< /details >}}

入力型: `MlModelCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmlmodelcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmlmodelcreatedescription"></a>`description` | [`String`](#string) | モデルの説明。 |
| <a id="mutationmlmodelcreatename"></a>`name` | [`String!`](#string) | モデルの名前。 |
| <a id="mutationmlmodelcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のモデルが属するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmlmodelcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmlmodelcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationmlmodelcreatemodel"></a>`model` | [`MlModel`](#mlmodel) | 変異後のモデル。 |

### `Mutation.mlModelDelete`

{{< details >}}GitLab 17.0で**導入**。**状態**: 実験。{{< /details >}}

入力型: `MlModelDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmlmodeldeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmlmodeldeleteid"></a>`id` | [`MlModelID!`](#mlmodelid) | 削除するモデルのグローバルID。 |
| <a id="mutationmlmodeldeleteprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のモデルが属するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmlmodeldeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmlmodeldeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationmlmodeldeletemodel"></a>`model` | [`MlModel`](#mlmodel) | 変異後のモデル。 |

### `Mutation.mlModelDestroy`

{{< details >}}GitLab 16.10で**導入**。**状態**: 実験。{{< /details >}}

入力型: `MlModelDestroyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmlmodeldestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmlmodeldestroyid"></a>`id` | [`MlModelID!`](#mlmodelid) | 削除するモデルのグローバルID。 |
| <a id="mutationmlmodeldestroyprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のモデルが属するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmlmodeldestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmlmodeldestroyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationmlmodeldestroymessage"></a>`message` | [`String`](#string) | モデル削除の結果メッセージ。 |
| <a id="mutationmlmodeldestroymodel"></a>`model` | [`MlModel`](#mlmodel) | 変異後のモデル。 |

### `Mutation.mlModelEdit`

{{< details >}}GitLab 17.3で**導入**。**状態**: 実験。{{< /details >}}

入力型: `MlModelEditInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmlmodeleditclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmlmodeleditdescription"></a>`description` | [`String`](#string) | モデルの説明。 |
| <a id="mutationmlmodeleditmodelid"></a>`modelId` | [`Int`](#int) | モデルのID。 |
| <a id="mutationmlmodeleditname"></a>`name` | [`String!`](#string) | モデルの名前。 |
| <a id="mutationmlmodeleditprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のモデルが属するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmlmodeleditclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmlmodelediterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationmlmodeleditmodel"></a>`model` | [`MlModel`](#mlmodel) | 変異後のモデル。 |

### `Mutation.mlModelVersionCreate`

{{< details >}}GitLab 17.1で**導入**。**状態**: 実験。{{< /details >}}

入力型: `MlModelVersionCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmlmodelversioncreatecandidateid"></a>`candidateId` | [`MlCandidateID`](#mlcandidateid) | 必要に応じてプロモートする候補のグローバルID。 |
| <a id="mutationmlmodelversioncreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmlmodelversioncreatedescription"></a>`description` | [`String`](#string) | モデルバージョンの説明。 |
| <a id="mutationmlmodelversioncreatemodelid"></a>`modelId` | [`MlModelID!`](#mlmodelid) | バージョンが属するモデルのグローバルID。 |
| <a id="mutationmlmodelversioncreateprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のモデルが属するプロジェクト。 |
| <a id="mutationmlmodelversioncreateversion"></a>`version` | [`String`](#string) | モデルバージョン。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmlmodelversioncreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmlmodelversioncreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationmlmodelversioncreatemodelversion"></a>`modelVersion` | [`MlModelVersion`](#mlmodelversion) | 変異後のモデル。 |

### `Mutation.mlModelVersionDelete`

{{< details >}}GitLab 17.0で**導入**。**状態**: 実験。{{< /details >}}

入力型: `MlModelVersionDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmlmodelversiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmlmodelversiondeleteid"></a>`id` | [`MlModelVersionID!`](#mlmodelversionid) | 削除するモデルバージョンのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmlmodelversiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmlmodelversiondeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationmlmodelversiondeletemodelversion"></a>`modelVersion` | [`MlModelVersion`](#mlmodelversion) | 削除されたモデルバージョン。 |

### `Mutation.mlModelVersionEdit`

{{< details >}}GitLab 17.4で**導入**。**状態**: 実験。{{< /details >}}

入力型: `MlModelVersionEditInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmlmodelversioneditclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmlmodelversioneditdescription"></a>`description` | [`String!`](#string) | モデルバージョンの説明。 |
| <a id="mutationmlmodelversioneditmodelid"></a>`modelId` | [`MlModelID!`](#mlmodelid) | バージョンが属するモデルのグローバルID。 |
| <a id="mutationmlmodelversioneditprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のモデルが属するプロジェクト。 |
| <a id="mutationmlmodelversioneditversion"></a>`version` | [`String!`](#string) | モデルバージョン。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmlmodelversioneditclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationmlmodelversionediterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationmlmodelversioneditmodelversion"></a>`modelVersion` | [`MlModelVersion`](#mlmodelversion) | 変異後のモデル。 |

### `Mutation.namespaceBanDestroy`

入力型: `NamespaceBanDestroyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationnamespacebandestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationnamespacebandestroyid"></a>`id` | [`NamespacesNamespaceBanID!`](#namespacesnamespacebanid) | 削除するネームスペースBANのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationnamespacebandestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationnamespacebandestroyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationnamespacebandestroynamespaceban"></a>`namespaceBan` | [`NamespaceBan`](#namespaceban) | ネームスペースBAN。 |

### `Mutation.namespaceCiCdSettingsUpdate`

入力型: `NamespaceCiCdSettingsUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationnamespacecicdsettingsupdateallowstalerunnerpruning"></a>`allowStaleRunnerPruning` | [`Boolean`](#boolean) | ネームスペースに直接属する停滞状態Runnerを定期的にプルーニングするかどうかを示します。 |
| <a id="mutationnamespacecicdsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationnamespacecicdsettingsupdatefullpath"></a>`fullPath` | [`ID!`](#id) | 設定が属するネームスペースのフルパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationnamespacecicdsettingsupdatecicdsettings"></a>`ciCdSettings` | [`NamespaceCiCdSetting!`](#namespacecicdsetting) | 変異後のCI/CD設定。 |
| <a id="mutationnamespacecicdsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationnamespacecicdsettingsupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.namespaceCreateRemoteDevelopmentClusterAgentMapping`

入力型: `NamespaceCreateRemoteDevelopmentClusterAgentMappingInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationnamespacecreateremotedevelopmentclusteragentmappingclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationnamespacecreateremotedevelopmentclusteragentmappingclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID!`](#clustersagentid) | ネームスペースに関連付けるクラスターエージェントのGlobalID。 |
| <a id="mutationnamespacecreateremotedevelopmentclusteragentmappingnamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | クラスターエージェントに関連付けるネームスペースのGlobalID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationnamespacecreateremotedevelopmentclusteragentmappingclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationnamespacecreateremotedevelopmentclusteragentmappingerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationnamespacecreateremotedevelopmentclusteragentmappingnamespaceclusteragentmapping"></a>`namespaceClusterAgentMapping` {{< icon name="warning-solid" >}} | [`NamespaceClusterAgentMapping`](#namespaceclusteragentmapping) | **非推奨: ****状態**: 実験。GitLab 17.10で導入。 |

### `Mutation.namespaceDeleteRemoteDevelopmentClusterAgentMapping`

入力型: `NamespaceDeleteRemoteDevelopmentClusterAgentMappingInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationnamespacedeleteremotedevelopmentclusteragentmappingclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationnamespacedeleteremotedevelopmentclusteragentmappingclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID!`](#clustersagentid) | ネームスペースからの関連付けを解除するクラスターエージェントのGlobalID。 |
| <a id="mutationnamespacedeleteremotedevelopmentclusteragentmappingnamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | クラスターエージェントからの関連付けを解除するネームスペースのGlobalID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationnamespacedeleteremotedevelopmentclusteragentmappingclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationnamespacedeleteremotedevelopmentclusteragentmappingerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.namespaceSettingsUpdate`

{{< details >}}GitLab 17.9で**導入**。**状態**: 実験。{{< /details >}}

入力型: `NamespaceSettingsUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationnamespacesettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationnamespacesettingsupdatefullpath"></a>`fullPath` | [`ID!`](#id) | 設定が属するネームスペースのフルパス。 |
| <a id="mutationnamespacesettingsupdatepipelinevariablesdefaultrole"></a>`pipelineVariablesDefaultRole` | [`PipelineVariablesDefaultRoleType`](#pipelinevariablesdefaultroletype) | ネームスペース内のパイプライン変数をオーバーライドするために必要なデフォルトの最小ロールを示します。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationnamespacesettingsupdatecicdsettings"></a>`ciCdSettings` | [`CiCdSettings!`](#cicdsettings) | 変異後のネームスペースCI/CD設定。 |
| <a id="mutationnamespacesettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationnamespacesettingsupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.noteConvertToThread`

標準のコメントを解決可能なスレッドに変換します。

入力型: `NoteConvertToThreadInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationnoteconverttothreadclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationnoteconverttothreadid"></a>`id` | [`NoteID!`](#noteid) | 変換するノートのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationnoteconverttothreadclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationnoteconverttothreaderrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationnoteconverttothreadnote"></a>`note` | [`Note`](#note) | 変異後のノート。 |
| <a id="mutationnoteconverttothreadquickactionsstatus"></a>`quickActionsStatus` | [`QuickActionsStatus`](#quickactionsstatus) | 変異後のクイックアクションの状態。 |

### `Mutation.oncallRotationCreate`

入力型: `OncallRotationCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationoncallrotationcreateactiveperiod"></a>`activePeriod` | [`OncallRotationActivePeriodInputType`](#oncallrotationactiveperiodinputtype) | オンコールローテーションが発生するアクティブ期間。 |
| <a id="mutationoncallrotationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationoncallrotationcreateendsat"></a>`endsAt` | [`OncallRotationDateInputType`](#oncallrotationdateinputtype) | オンコールローテーションの終了日時（オンコールスケジュールのタイムゾーン）。 |
| <a id="mutationoncallrotationcreatename"></a>`name` | [`String!`](#string) | オンコールローテーションの名前。 |
| <a id="mutationoncallrotationcreateparticipants"></a>`participants` | [`[OncallUserInputType!]!`](#oncalluserinputtype) | オンコールローテーションに参加しているユーザーのユーザー名。参加者は最大100名までです。 |
| <a id="mutationoncallrotationcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | オンコールスケジュールを作成するプロジェクト。 |
| <a id="mutationoncallrotationcreaterotationlength"></a>`rotationLength` | [`OncallRotationLengthInputType!`](#oncallrotationlengthinputtype) | オンコールローテーションのローテーション長。 |
| <a id="mutationoncallrotationcreatescheduleiid"></a>`scheduleIid` | [`String!`](#string) | オンコールローテーションを作成するオンコールスケジュールのIID。 |
| <a id="mutationoncallrotationcreatestartsat"></a>`startsAt` | [`OncallRotationDateInputType!`](#oncallrotationdateinputtype) | オンコールローテーションの開始日時（オンコールスケジュールのタイムゾーン）。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationoncallrotationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationoncallrotationcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationoncallrotationcreateoncallrotation"></a>`oncallRotation` | [`IncidentManagementOncallRotation`](#incidentmanagementoncallrotation) | オンコールローテーション。 |

### `Mutation.oncallRotationDestroy`

入力型: `OncallRotationDestroyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationoncallrotationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationoncallrotationdestroyid"></a>`id` | [`IncidentManagementOncallRotationID!`](#incidentmanagementoncallrotationid) | 削除するオンコールローテーションのID。 |
| <a id="mutationoncallrotationdestroyprojectpath"></a>`projectPath` | [`ID!`](#id) | オンコールスケジュールの削除元プロジェクト。 |
| <a id="mutationoncallrotationdestroyscheduleiid"></a>`scheduleIid` | [`String!`](#string) | オンコールローテーションが属するオンコールスケジュールのIID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationoncallrotationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationoncallrotationdestroyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationoncallrotationdestroyoncallrotation"></a>`oncallRotation` | [`IncidentManagementOncallRotation`](#incidentmanagementoncallrotation) | オンコールローテーション。 |

### `Mutation.oncallRotationUpdate`

入力型: `OncallRotationUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationoncallrotationupdateactiveperiod"></a>`activePeriod` | [`OncallRotationActivePeriodInputType`](#oncallrotationactiveperiodinputtype) | オンコールローテーションが発生するアクティブ期間。 |
| <a id="mutationoncallrotationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationoncallrotationupdateendsat"></a>`endsAt` | [`OncallRotationDateInputType`](#oncallrotationdateinputtype) | オンコールローテーションの終了日時（オンコールスケジュールのタイムゾーン）。 |
| <a id="mutationoncallrotationupdateid"></a>`id` | [`IncidentManagementOncallRotationID!`](#incidentmanagementoncallrotationid) | オンコールローテーションを作成するオンコールスケジュールのID。 |
| <a id="mutationoncallrotationupdatename"></a>`name` | [`String`](#string) | オンコールローテーションの名前。 |
| <a id="mutationoncallrotationupdateparticipants"></a>`participants` | [`[OncallUserInputType!]`](#oncalluserinputtype) | オンコールローテーションに参加しているユーザーのユーザー名。参加者は最大100名までです。 |
| <a id="mutationoncallrotationupdaterotationlength"></a>`rotationLength` | [`OncallRotationLengthInputType`](#oncallrotationlengthinputtype) | オンコールローテーションのローテーション長。 |
| <a id="mutationoncallrotationupdatestartsat"></a>`startsAt` | [`OncallRotationDateInputType`](#oncallrotationdateinputtype) | オンコールローテーションの開始日時（オンコールスケジュールのタイムゾーン）。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationoncallrotationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationoncallrotationupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationoncallrotationupdateoncallrotation"></a>`oncallRotation` | [`IncidentManagementOncallRotation`](#incidentmanagementoncallrotation) | オンコールローテーション。 |

### `Mutation.oncallScheduleCreate`

入力型: `OncallScheduleCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationoncallschedulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationoncallschedulecreatedescription"></a>`description` | [`String`](#string) | オンコールスケジュールの説明。 |
| <a id="mutationoncallschedulecreatename"></a>`name` | [`String!`](#string) | オンコールスケジュールの名前。 |
| <a id="mutationoncallschedulecreateprojectpath"></a>`projectPath` | [`ID!`](#id) | オンコールスケジュールを作成するプロジェクト。 |
| <a id="mutationoncallschedulecreatetimezone"></a>`timezone` | [`String!`](#string) | オンコールスケジュールのタイムゾーン。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationoncallschedulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationoncallschedulecreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationoncallschedulecreateoncallschedule"></a>`oncallSchedule` | [`IncidentManagementOncallSchedule`](#incidentmanagementoncallschedule) | オンコールスケジュール。 |

### `Mutation.oncallScheduleDestroy`

入力型: `OncallScheduleDestroyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationoncallscheduledestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationoncallscheduledestroyiid"></a>`iid` | [`String!`](#string) | 削除するオンコールスケジュールの内部ID。 |
| <a id="mutationoncallscheduledestroyprojectpath"></a>`projectPath` | [`ID!`](#id) | オンコールスケジュールの削除元プロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationoncallscheduledestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationoncallscheduledestroyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationoncallscheduledestroyoncallschedule"></a>`oncallSchedule` | [`IncidentManagementOncallSchedule`](#incidentmanagementoncallschedule) | オンコールスケジュール。 |

### `Mutation.oncallScheduleUpdate`

入力型: `OncallScheduleUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationoncallscheduleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationoncallscheduleupdatedescription"></a>`description` | [`String`](#string) | オンコールスケジュールの説明。 |
| <a id="mutationoncallscheduleupdateiid"></a>`iid` | [`String!`](#string) | 更新するオンコールスケジュールの内部ID。 |
| <a id="mutationoncallscheduleupdatename"></a>`name` | [`String`](#string) | オンコールスケジュールの名前。 |
| <a id="mutationoncallscheduleupdateprojectpath"></a>`projectPath` | [`ID!`](#id) | オンコールスケジュールを更新するプロジェクト。 |
| <a id="mutationoncallscheduleupdatetimezone"></a>`timezone` | [`String`](#string) | オンコールスケジュールのタイムゾーン。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationoncallscheduleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationoncallscheduleupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationoncallscheduleupdateoncallschedule"></a>`oncallSchedule` | [`IncidentManagementOncallSchedule`](#incidentmanagementoncallschedule) | オンコールスケジュール。 |

### `Mutation.organizationCreate`

{{< details >}}GitLab 16.6で**導入**。**状態**: 実験。{{< /details >}}

入力型: `OrganizationCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationorganizationcreateavatar"></a>`avatar` | [`Upload`](#upload) | 組織のアバター。 |
| <a id="mutationorganizationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationorganizationcreatedescription"></a>`description` | [`String`](#string) | 組織の説明。 |
| <a id="mutationorganizationcreatename"></a>`name` | [`String!`](#string) | 組織の名前。 |
| <a id="mutationorganizationcreatepath"></a>`path` | [`String!`](#string) | 組織のパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationorganizationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationorganizationcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationorganizationcreateorganization"></a>`organization` | [`Organization`](#organization) | 変異後の組織。 |

### `Mutation.organizationCreateClusterAgentMapping`

{{< details >}}GitLab 17.11で**導入**。**状態**: 実験。{{< /details >}}

入力型: `OrganizationCreateClusterAgentMappingInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationorganizationcreateclusteragentmappingclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationorganizationcreateclusteragentmappingclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID!`](#clustersagentid) | 組織に関連付けるクラスターエージェントのGlobalID。 |
| <a id="mutationorganizationcreateclusteragentmappingorganizationid"></a>`organizationId` | [`OrganizationsOrganizationID!`](#organizationsorganizationid) | クラスターエージェントに関連付ける組織のGlobalID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationorganizationcreateclusteragentmappingclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationorganizationcreateclusteragentmappingerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.organizationDeleteClusterAgentMapping`

{{< details >}}GitLab 17.11で**導入**。**状態**: 実験。{{< /details >}}

入力型: `OrganizationDeleteClusterAgentMappingInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationorganizationdeleteclusteragentmappingclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationorganizationdeleteclusteragentmappingclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID!`](#clustersagentid) | 組織との関連付けを解除するクラスターエージェントのGlobalID。 |
| <a id="mutationorganizationdeleteclusteragentmappingorganizationid"></a>`organizationId` | [`OrganizationsOrganizationID!`](#organizationsorganizationid) | クラスターエージェントとの関連付けを解除する組織のGlobalID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationorganizationdeleteclusteragentmappingclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationorganizationdeleteclusteragentmappingerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.organizationUpdate`

{{< details >}}GitLab 16.7で**導入**。**状態**: 実験。{{< /details >}}

入力型: `OrganizationUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationorganizationupdateavatar"></a>`avatar` | [`Upload`](#upload) | 組織のアバター。 |
| <a id="mutationorganizationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationorganizationupdatedescription"></a>`description` | [`String`](#string) | 組織の説明。 |
| <a id="mutationorganizationupdateid"></a>`id` | [`OrganizationsOrganizationID!`](#organizationsorganizationid) | 変異対象の組織のID。 |
| <a id="mutationorganizationupdatename"></a>`name` | [`String`](#string) | 組織の名前。 |
| <a id="mutationorganizationupdatepath"></a>`path` | [`String`](#string) | 組織のパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationorganizationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationorganizationupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationorganizationupdateorganization"></a>`organization` | [`Organization`](#organization) | 変異後の組織。 |

### `Mutation.organizationUserUpdate`

{{< details >}}GitLab 17.5で**導入**。**状態**: 実験。{{< /details >}}

入力型: `OrganizationUserUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationorganizationuserupdateaccesslevel"></a>`accessLevel` | [`OrganizationUserAccessLevel!`](#organizationuseraccesslevel) | 更新後の組織ユーザーのアクセスレベル。 |
| <a id="mutationorganizationuserupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationorganizationuserupdateid"></a>`id` | [`OrganizationsOrganizationUserID!`](#organizationsorganizationuserid) | 変異対象の組織ユーザーのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationorganizationuserupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationorganizationuserupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationorganizationuserupdateorganizationuser"></a>`organizationUser` {{< icon name="warning-solid" >}} | [`OrganizationUser`](#organizationuser) | **非推奨: ****状態**: 実験。GitLab 17.5で導入。 |

### `Mutation.pagesMarkOnboardingComplete`

入力型: `PagesMarkOnboardingCompleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpagesmarkonboardingcompleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationpagesmarkonboardingcompleteprojectpath"></a>`projectPath` | [`ID!`](#id) | プロジェクトのフルパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpagesmarkonboardingcompleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationpagesmarkonboardingcompleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationpagesmarkonboardingcompleteonboardingcomplete"></a>`onboardingComplete` | [`Boolean!`](#boolean) | プロジェクトのPagesメタデータの新しいonboarding_complete状態を示します。 |

### `Mutation.pipelineCancel`

入力型: `PipelineCancelInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinecancelclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinecancelid"></a>`id` | [`CiPipelineID!`](#cipipelineid) | 変異対象のパイプラインのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinecancelclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinecancelerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.pipelineCreate`

入力型: `PipelineCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinecreateasync"></a>`async` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **非推奨: ****状態**: 実験。GitLab 17.8で導入。 |
| <a id="mutationpipelinecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinecreateinputs"></a>`inputs` {{< icon name="warning-solid" >}} | [`[CiInputsInputType!]`](#ciinputsinputtype) | **非推奨: ****状態**: 実験。GitLab 17.10で導入。 |
| <a id="mutationpipelinecreateprojectpath"></a>`projectPath` | [`ID!`](#id) | パイプラインをトリガーしているプロジェクトのフルパス。 |
| <a id="mutationpipelinecreateref"></a>`ref` | [`String!`](#string) | パイプラインを実行するref。 |
| <a id="mutationpipelinecreatevariables"></a>`variables` | [`[CiVariableInput!]`](#civariableinput) | パイプラインの変数。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinecreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationpipelinecreatepipeline"></a>`pipeline` | [`Pipeline`](#pipeline) | 変異後に作成されたパイプライン。`async: true`の場合はnull。 |
| <a id="mutationpipelinecreaterequestid"></a>`requestId` {{< icon name="warning-solid" >}} | [`String`](#string) | **非推奨: ****状態**: 実験。GitLab 17.8で導入。 |

### `Mutation.pipelineDestroy`

入力型: `PipelineDestroyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinedestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinedestroyid"></a>`id` | [`CiPipelineID!`](#cipipelineid) | 変異対象のパイプラインのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinedestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinedestroyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.pipelineRetry`

入力型: `PipelineRetryInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelineretryclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationpipelineretryid"></a>`id` | [`CiPipelineID!`](#cipipelineid) | 変異対象のパイプラインのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelineretryclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationpipelineretryerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationpipelineretrypipeline"></a>`pipeline` | [`Pipeline`](#pipeline) | 変異後のパイプライン。 |

### `Mutation.pipelineScheduleCreate`

入力型: `PipelineScheduleCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelineschedulecreateactive"></a>`active` | [`Boolean`](#boolean) | パイプラインスケジュールをアクティブにするかどうかを示します。 |
| <a id="mutationpipelineschedulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationpipelineschedulecreatecron"></a>`cron` | [`String!`](#string) | パイプラインスケジュールのcron式。 |
| <a id="mutationpipelineschedulecreatecrontimezone"></a>`cronTimezone` | [`String`](#string) | ActiveSupport::TimeZoneでサポートされているcronタイムゾーン。例:「Pacific Time（US & Canada）」（デフォルト:「UTC」）。 |
| <a id="mutationpipelineschedulecreatedescription"></a>`description` | [`String!`](#string) | パイプラインスケジュールの説明。 |
| <a id="mutationpipelineschedulecreateinputs"></a>`inputs` {{< icon name="warning-solid" >}} | [`[CiInputsInputType!]`](#ciinputsinputtype) | **非推奨: ****状態**: 実験。GitLab 17.10で導入。 |
| <a id="mutationpipelineschedulecreateprojectpath"></a>`projectPath` | [`ID!`](#id) | パイプラインスケジュールが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationpipelineschedulecreateref"></a>`ref` | [`String!`](#string) | パイプラインスケジュールのref。 |
| <a id="mutationpipelineschedulecreatevariables"></a>`variables` | [`[PipelineScheduleVariableInput!]`](#pipelineschedulevariableinput) | パイプラインスケジュールの変数。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelineschedulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationpipelineschedulecreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationpipelineschedulecreatepipelineschedule"></a>`pipelineSchedule` | [`PipelineSchedule`](#pipelineschedule) | 作成されたパイプラインスケジュール。 |

### `Mutation.pipelineScheduleDelete`

入力型: `PipelineScheduleDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinescheduledeleteid"></a>`id` | [`CiPipelineScheduleID!`](#cipipelinescheduleid) | 変異対象のパイプラインスケジュールのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinescheduledeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.pipelineSchedulePlay`

入力型: `PipelineSchedulePlayInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduleplayclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinescheduleplayid"></a>`id` | [`CiPipelineScheduleID!`](#cipipelinescheduleid) | 変異対象のパイプラインスケジュールのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduleplayclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinescheduleplayerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationpipelinescheduleplaypipelineschedule"></a>`pipelineSchedule` | [`PipelineSchedule`](#pipelineschedule) | 変異後のパイプラインスケジュール。 |

### `Mutation.pipelineScheduleTakeOwnership`

入力型: `PipelineScheduleTakeOwnershipInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduletakeownershipclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinescheduletakeownershipid"></a>`id` | [`CiPipelineScheduleID!`](#cipipelinescheduleid) | 変異対象のパイプラインスケジュールのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduletakeownershipclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinescheduletakeownershiperrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationpipelinescheduletakeownershippipelineschedule"></a>`pipelineSchedule` | [`PipelineSchedule`](#pipelineschedule) | 更新されたパイプラインスケジュールの所有権。 |

### `Mutation.pipelineScheduleUpdate`

入力型: `PipelineScheduleUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduleupdateactive"></a>`active` | [`Boolean`](#boolean) | パイプラインスケジュールをアクティブにするかどうかを示します。 |
| <a id="mutationpipelinescheduleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinescheduleupdatecron"></a>`cron` | [`String`](#string) | パイプラインスケジュールのcron式。 |
| <a id="mutationpipelinescheduleupdatecrontimezone"></a>`cronTimezone` | [`String`](#string) | ActiveSupport::TimeZoneでサポートされているcronタイムゾーン。例:「Pacific Time（US & Canada）」（デフォルト:「UTC」）。 |
| <a id="mutationpipelinescheduleupdatedescription"></a>`description` | [`String`](#string) | パイプラインスケジュールの説明。 |
| <a id="mutationpipelinescheduleupdateid"></a>`id` | [`CiPipelineScheduleID!`](#cipipelinescheduleid) | 変異対象のパイプラインスケジュールのID。 |
| <a id="mutationpipelinescheduleupdateinputs"></a>`inputs` {{< icon name="warning-solid" >}} | [`[CiInputsInputType!]`](#ciinputsinputtype) | **非推奨: ****状態**: 実験。GitLab 17.11で導入。 |
| <a id="mutationpipelinescheduleupdateref"></a>`ref` | [`String`](#string) | パイプラインスケジュールのref。 |
| <a id="mutationpipelinescheduleupdatevariables"></a>`variables` | [`[PipelineScheduleVariableInput!]`](#pipelineschedulevariableinput) | パイプラインスケジュールの変数。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinescheduleupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationpipelinescheduleupdatepipelineschedule"></a>`pipelineSchedule` | [`PipelineSchedule`](#pipelineschedule) | 更新されたパイプラインスケジュール。 |

### `Mutation.pipelineTriggerCreate`

{{< details >}}GitLab 16.3で**導入**。**状態**: 実験。{{< /details >}}

入力型: `PipelineTriggerCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinetriggercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinetriggercreatedescription"></a>`description` | [`String!`](#string) | パイプライントリガートークンの説明。 |
| <a id="mutationpipelinetriggercreateexpiresat"></a>`expiresAt` | [`Time`](#time) | パイプライントリガートークンの有効期限のタイムスタンプ。 |
| <a id="mutationpipelinetriggercreateprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のパイプライントリガートークンが属するプロジェクトのフルパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinetriggercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinetriggercreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationpipelinetriggercreatepipelinetrigger"></a>`pipelineTrigger` | [`PipelineTrigger`](#pipelinetrigger) | 変異後のパイプライントリガートークン。 |

### `Mutation.pipelineTriggerDelete`

{{< details >}}GitLab 16.3で**導入**。**状態**: 実験。{{< /details >}}

入力型: `PipelineTriggerDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinetriggerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinetriggerdeleteid"></a>`id` | [`CiTriggerID!`](#citriggerid) | 削除するパイプライントリガートークンのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinetriggerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinetriggerdeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.pipelineTriggerUpdate`

{{< details >}}GitLab 16.3で**導入**。**状態**: 実験。{{< /details >}}

入力型: `PipelineTriggerUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinetriggerupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinetriggerupdatedescription"></a>`description` | [`String!`](#string) | パイプライントリガートークンの説明。 |
| <a id="mutationpipelinetriggerupdateid"></a>`id` | [`CiTriggerID!`](#citriggerid) | 更新するパイプライントリガートークンのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinetriggerupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinetriggerupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationpipelinetriggerupdatepipelinetrigger"></a>`pipelineTrigger` | [`PipelineTrigger`](#pipelinetrigger) | 変異後のパイプライントリガートークン。 |

### `Mutation.processUserBillablePromotionRequest`

{{< details >}}GitLab 17.2で**導入**。**状態**: 実験。{{< /details >}}

入力型: `ProcessUserBillablePromotionRequestInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprocessuserbillablepromotionrequestclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprocessuserbillablepromotionrequeststatus"></a>`status` | [`MemberApprovalStatusType!`](#memberapprovalstatustype) | メンバー承認リクエストの状態（承認、却下、保留中）。 |
| <a id="mutationprocessuserbillablepromotionrequestuserid"></a>`userId` | [`UserID!`](#userid) | プロモートするユーザーのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprocessuserbillablepromotionrequestclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprocessuserbillablepromotionrequesterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationprocessuserbillablepromotionrequestresult"></a>`result` | [`UserPromotionStatusType`](#userpromotionstatustype) | ユーザープロモーション処理の状態（success、partial_success、failed）。 |

### `Mutation.productAnalyticsProjectSettingsUpdate`

入力型: `ProductAnalyticsProjectSettingsUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationproductanalyticsprojectsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationproductanalyticsprojectsettingsupdatecubeapibaseurl"></a>`cubeApiBaseUrl` | [`String`](#string) | Cube APIのベースURL。 |
| <a id="mutationproductanalyticsprojectsettingsupdatecubeapikey"></a>`cubeApiKey` | [`String`](#string) | Cube APIのAPIキー。 |
| <a id="mutationproductanalyticsprojectsettingsupdatefullpath"></a>`fullPath` | [`ID!`](#id) | 設定が属するプロジェクトのフルパス。 |
| <a id="mutationproductanalyticsprojectsettingsupdateproductanalyticsconfiguratorconnectionstring"></a>`productAnalyticsConfiguratorConnectionString` | [`String`](#string) | プロダクト分析コンフィギュレーターの接続文字列。 |
| <a id="mutationproductanalyticsprojectsettingsupdateproductanalyticsdatacollectorhost"></a>`productAnalyticsDataCollectorHost` | [`String`](#string) | プロダクト分析データコレクターのホスト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationproductanalyticsprojectsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationproductanalyticsprojectsettingsupdatecubeapibaseurl"></a>`cubeApiBaseUrl` | [`String`](#string) | Cube APIのベースURL。 |
| <a id="mutationproductanalyticsprojectsettingsupdatecubeapikey"></a>`cubeApiKey` | [`String`](#string) | Cube APIのAPIキー。 |
| <a id="mutationproductanalyticsprojectsettingsupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationproductanalyticsprojectsettingsupdateproductanalyticsconfiguratorconnectionstring"></a>`productAnalyticsConfiguratorConnectionString` | [`String`](#string) | プロダクト分析コンフィギュレーターの接続文字列。 |
| <a id="mutationproductanalyticsprojectsettingsupdateproductanalyticsdatacollectorhost"></a>`productAnalyticsDataCollectorHost` | [`String`](#string) | プロダクト分析データコレクターのホスト。 |

### `Mutation.projectBlobsRemove`

{{< details >}}GitLab 17.1で**導入**。**状態**: 実験。{{< /details >}}

入力型: `projectBlobsRemoveInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectblobsremovebloboids"></a>`blobOids` | [`[String!]!`](#string) | blob oidのリスト。 |
| <a id="mutationprojectblobsremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectblobsremoveprojectpath"></a>`projectPath` | [`ID!`](#id) | 置き換えるプロジェクトのフルパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectblobsremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectblobsremoveerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.projectCiCdSettingsUpdate`

入力型: `ProjectCiCdSettingsUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectcicdsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectcicdsettingsupdatefullpath"></a>`fullPath` | [`ID!`](#id) | 設定が属するプロジェクトのフルパス。 |
| <a id="mutationprojectcicdsettingsupdateinboundjobtokenscopeenabled"></a>`inboundJobTokenScopeEnabled` | [`Boolean`](#boolean) | このプロジェクトへのアクセスが他のプロジェクトで生成されたCI/CDジョブトークンによって制限されているかどうかを示します。 |
| <a id="mutationprojectcicdsettingsupdatejobtokenscopeenabled"></a>`jobTokenScopeEnabled` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **非推奨: **送信ジョブトークンスコープは削除されます。このフィールドで可能な設定値はfalseだけになりました。GitLab 16.0で非推奨になりました。 |
| <a id="mutationprojectcicdsettingsupdatekeeplatestartifact"></a>`keepLatestArtifact` | [`Boolean`](#boolean) | プロジェクトで最新のアーティファクトを保持する必要があるかどうかを示します。 |
| <a id="mutationprojectcicdsettingsupdatemergepipelinesenabled"></a>`mergePipelinesEnabled` | [`Boolean`](#boolean) | プロジェクトでマージ結果パイプラインが有効になっているかどうかを示します。 |
| <a id="mutationprojectcicdsettingsupdatemergetrainsenabled"></a>`mergeTrainsEnabled` | [`Boolean`](#boolean) | プロジェクトでマージトレインが有効になっているかどうかを示します。 |
| <a id="mutationprojectcicdsettingsupdatemergetrainsskiptrainallowed"></a>`mergeTrainsSkipTrainAllowed` | [`Boolean`](#boolean) | マージトレインを更新せずにマージできるオプションを許可するかどうかを示します。`merge_trains_skip_train`機能フラグも有効になっているのでなければ、無視されます。 |
| <a id="mutationprojectcicdsettingsupdatepipelinevariablesminimumoverriderole"></a>`pipelineVariablesMinimumOverrideRole` | [`String`](#string) | パイプライン作成時またはジョブ実行時に変数を設定するために必要な最小ロール。 |
| <a id="mutationprojectcicdsettingsupdatepushrepositoryforjobtokenallowed"></a>`pushRepositoryForJobTokenAllowed` | [`Boolean`](#boolean) | ジョブトークンを使用して元のプロジェクトリポジトリにプッシュすることができるかどうかを示します。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectcicdsettingsupdatecicdsettings"></a>`ciCdSettings` | [`ProjectCiCdSetting!`](#projectcicdsetting) | 変異後のCI/CD設定。 |
| <a id="mutationprojectcicdsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectcicdsettingsupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.projectInitializeProductAnalytics`

入力型: `ProjectInitializeProductAnalyticsInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectinitializeproductanalyticsclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectinitializeproductanalyticsprojectpath"></a>`projectPath` | [`ID!`](#id) | 初期化するプロジェクトのフルパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectinitializeproductanalyticsclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectinitializeproductanalyticserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationprojectinitializeproductanalyticsproject"></a>`project` | [`Project`](#project) | 初期化が実行されたプロジェクト。 |

### `Mutation.projectMemberBulkUpdate`

プロジェクトの複数メンバーを更新します。この変異を使用するには、少なくともメンテナーの役割が必要です。

入力型: `ProjectMemberBulkUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectmemberbulkupdateaccesslevel"></a>`accessLevel` | [`MemberAccessLevel!`](#memberaccesslevel) | メンバーの更新後アクセスレベル。 |
| <a id="mutationprojectmemberbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectmemberbulkupdateexpiresat"></a>`expiresAt` | [`Time`](#time) | メンバーシップの期限切れ日時。 |
| <a id="mutationprojectmemberbulkupdateprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | プロジェクトのグローバルID。 |
| <a id="mutationprojectmemberbulkupdateuserids"></a>`userIds` | [`[UserID!]!`](#userid) | メンバーのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectmemberbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectmemberbulkupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationprojectmemberbulkupdateprojectmembers"></a>`projectMembers` | [`[ProjectMember!]`](#projectmember) | 変異後のプロジェクトメンバー。 |

### `Mutation.projectSavedReplyCreate`

{{< details >}}GitLab 16.11で**導入**。**状態**: 実験。{{< /details >}}

入力型: `ProjectSavedReplyCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsavedreplycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsavedreplycreatecontent"></a>`content` | [`String!`](#string) | 保存済み返信の内容。 |
| <a id="mutationprojectsavedreplycreatename"></a>`name` | [`String!`](#string) | 保存済み返信の名前。 |
| <a id="mutationprojectsavedreplycreateprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | 保存済み返信のプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsavedreplycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsavedreplycreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationprojectsavedreplycreatesavedreply"></a>`savedReply` | [`ProjectSavedReply`](#projectsavedreply) | 変異後の保存済み返信。 |

### `Mutation.projectSavedReplyDestroy`

{{< details >}}GitLab 16.11で**導入**。**状態**: 実験。{{< /details >}}

入力型: `ProjectSavedReplyDestroyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsavedreplydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsavedreplydestroyid"></a>`id` | [`ProjectsSavedReplyID!`](#projectssavedreplyid) | プロジェクトレベルの保存済み返信のグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsavedreplydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsavedreplydestroyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationprojectsavedreplydestroysavedreply"></a>`savedReply` | [`ProjectSavedReply`](#projectsavedreply) | 変異後の保存済み返信。 |

### `Mutation.projectSavedReplyUpdate`

{{< details >}}GitLab 16.11で**導入**。**状態**: 実験。{{< /details >}}

入力型: `ProjectSavedReplyUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsavedreplyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsavedreplyupdatecontent"></a>`content` | [`String!`](#string) | 保存済み返信の内容。 |
| <a id="mutationprojectsavedreplyupdateid"></a>`id` | [`ProjectsSavedReplyID!`](#projectssavedreplyid) | プロジェクトレベルの保存済み返信のグローバルID。 |
| <a id="mutationprojectsavedreplyupdatename"></a>`name` | [`String!`](#string) | 保存済み返信の名前。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsavedreplyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsavedreplyupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationprojectsavedreplyupdatesavedreply"></a>`savedReply` | [`ProjectSavedReply`](#projectsavedreply) | 変異後の保存済み返信。 |

### `Mutation.projectSecretCreate`

入力型: `ProjectSecretCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecretcreatebranch"></a>`branch` | [`String!`](#string) | シークレットにアクセスできるブランチ。 |
| <a id="mutationprojectsecretcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsecretcreatedescription"></a>`description` | [`String`](#string) | プロジェクトシークレットの説明。 |
| <a id="mutationprojectsecretcreateenvironment"></a>`environment` | [`String!`](#string) | シークレットにアクセスできる環境。 |
| <a id="mutationprojectsecretcreatename"></a>`name` | [`String!`](#string) | プロジェクトシークレットの名前。 |
| <a id="mutationprojectsecretcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | シークレットのプロジェクト。 |
| <a id="mutationprojectsecretcreatevalue"></a>`value` | [`String!`](#string) | プロジェクトシークレットの値。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecretcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsecretcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationprojectsecretcreateprojectsecret"></a>`projectSecret` | [`ProjectSecret`](#projectsecret) | プロジェクトシークレット。 |

### `Mutation.projectSecretDelete`

入力型: `ProjectSecretDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecretdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsecretdeletename"></a>`name` | [`String!`](#string) | プロジェクトシークレットの名前。 |
| <a id="mutationprojectsecretdeleteprojectpath"></a>`projectPath` | [`ID!`](#id) | シークレットのプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecretdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsecretdeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationprojectsecretdeleteprojectsecret"></a>`projectSecret` | [`ProjectSecret`](#projectsecret) | 削除されたプロジェクトシークレット。 |

### `Mutation.projectSecretsManagerInitialize`

入力型: `ProjectSecretsManagerInitializeInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecretsmanagerinitializeclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsecretsmanagerinitializeprojectpath"></a>`projectPath` | [`ID!`](#id) | シークレットマネージャーのプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecretsmanagerinitializeclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsecretsmanagerinitializeerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationprojectsecretsmanagerinitializeprojectsecretsmanager"></a>`projectSecretsManager` | [`ProjectSecretsManager`](#projectsecretsmanager) | プロジェクトシークレットマネージャー。 |

### `Mutation.projectSecurityExclusionCreate`

入力型: `ProjectSecurityExclusionCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecurityexclusioncreateactive"></a>`active` | [`Boolean!`](#boolean) | 除外がアクティブかどうか。 |
| <a id="mutationprojectsecurityexclusioncreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsecurityexclusioncreatedescription"></a>`description` | [`String`](#string) | （オプション）除外の説明。 |
| <a id="mutationprojectsecurityexclusioncreateprojectpath"></a>`projectPath` | [`ID!`](#id) | 除外が関連付けられるプロジェクトのフルパス。 |
| <a id="mutationprojectsecurityexclusioncreatescanner"></a>`scanner` | [`ExclusionScannerEnum!`](#exclusionscannerenum) | 除外に基づいて値を無視するスキャナー。 |
| <a id="mutationprojectsecurityexclusioncreatetype"></a>`type` | [`ExclusionTypeEnum!`](#exclusiontypeenum) | 除外のタイプ。 |
| <a id="mutationprojectsecurityexclusioncreatevalue"></a>`value` | [`String!`](#string) | 除外の値。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecurityexclusioncreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsecurityexclusioncreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationprojectsecurityexclusioncreatesecurityexclusion"></a>`securityExclusion` | [`ProjectSecurityExclusion`](#projectsecurityexclusion) | 作成されたプロジェクトセキュリティ除外。 |

### `Mutation.projectSecurityExclusionDelete`

入力型: `ProjectSecurityExclusionDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecurityexclusiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsecurityexclusiondeleteid"></a>`id` | [`SecurityProjectSecurityExclusionID!`](#securityprojectsecurityexclusionid) | 削除する除外のグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecurityexclusiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsecurityexclusiondeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.projectSecurityExclusionUpdate`

入力型: `ProjectSecurityExclusionUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecurityexclusionupdateactive"></a>`active` | [`Boolean`](#boolean) | 除外がアクティブかどうか。 |
| <a id="mutationprojectsecurityexclusionupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsecurityexclusionupdatedescription"></a>`description` | [`String`](#string) | （オプション）除外の説明。 |
| <a id="mutationprojectsecurityexclusionupdateid"></a>`id` | [`SecurityProjectSecurityExclusionID!`](#securityprojectsecurityexclusionid) | 更新する除外のグローバルID。 |
| <a id="mutationprojectsecurityexclusionupdatescanner"></a>`scanner` | [`ExclusionScannerEnum`](#exclusionscannerenum) | 除外に基づいて値を無視するスキャナー。 |
| <a id="mutationprojectsecurityexclusionupdatetype"></a>`type` | [`ExclusionTypeEnum`](#exclusiontypeenum) | 除外のタイプ。 |
| <a id="mutationprojectsecurityexclusionupdatevalue"></a>`value` | [`String`](#string) | 除外の値。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecurityexclusionupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsecurityexclusionupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationprojectsecurityexclusionupdatesecurityexclusion"></a>`securityExclusion` | [`ProjectSecurityExclusion`](#projectsecurityexclusion) | 更新されたプロジェクトセキュリティ除外。 |

### `Mutation.projectSetComplianceFramework`

プロジェクトにコンプライアンスフレームワークを割り当てます（または設定解除します）。プロジェクトに複数のコンプライアンスフレームワークが関連付けられている場合、この変異はエラーになります。

入力型: `ProjectSetComplianceFrameworkInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsetcomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsetcomplianceframeworkcomplianceframeworkid"></a>`complianceFrameworkId` | [`ComplianceManagementFrameworkID`](#compliancemanagementframeworkid) | プロジェクトに割り当てるコンプライアンスフレームワークのID。`null`に設定すると、設定が解除されます。 |
| <a id="mutationprojectsetcomplianceframeworkprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | コンプライアンスフレームワークを変更するプロジェクトのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsetcomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsetcomplianceframeworkerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationprojectsetcomplianceframeworkproject"></a>`project` | [`Project`](#project) | 変異後のプロジェクト。 |

### `Mutation.projectSetContinuousVulnerabilityScanning`

指定されたプロジェクトの継続的脆弱性スキャンを有効または無効にします。

{{< details >}}GitLab 17.3で**非推奨**になりました。CVSが永続的に有効になりました。詳細については、[このエピック](https://gitlab.com/groups/gitlab-org/-/epics/11474)を参照してください。{{< /details >}}

入力型: `ProjectSetContinuousVulnerabilityScanningInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsetcontinuousvulnerabilityscanningclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsetcontinuousvulnerabilityscanningenable"></a>`enable` | [`Boolean!`](#boolean) | 目的となる継続的脆弱性スキャン機能の状態。 |
| <a id="mutationprojectsetcontinuousvulnerabilityscanningprojectpath"></a>`projectPath` | [`ID!`](#id) | プロジェクトのフルパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsetcontinuousvulnerabilityscanningclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsetcontinuousvulnerabilityscanningcontinuousvulnerabilityscanningenabled"></a>`continuousVulnerabilityScanningEnabled` | [`Boolean!`](#boolean) | 機能が有効かどうか。 |
| <a id="mutationprojectsetcontinuousvulnerabilityscanningerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.projectSetLocked`

入力型: `ProjectSetLockedInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsetlockedclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsetlockedfilepath"></a>`filePath` | [`String!`](#string) | ファイルのフルパス。 |
| <a id="mutationprojectsetlockedlock"></a>`lock` | [`Boolean!`](#boolean) | ファイルパスをロックするかどうか。 |
| <a id="mutationprojectsetlockedprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のプロジェクトのフルパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsetlockedclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsetlockederrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationprojectsetlockedproject"></a>`project` | [`Project`](#project) | 変異後のプロジェクト。 |

### `Mutation.projectSettingsUpdate`

{{< details >}}GitLab 16.9で**導入**。**状態**: 実験。{{< /details >}}

入力型: `ProjectSettingsUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsettingsupdateduofeaturesenabled"></a>`duoFeaturesEnabled` | [`Boolean!`](#boolean) | プロジェクトでGitLab Duo機能が有効かどうかを示します。 |
| <a id="mutationprojectsettingsupdatefullpath"></a>`fullPath` | [`ID!`](#id) | 設定が属するプロジェクトのフルパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsettingsupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationprojectsettingsupdateprojectsettings"></a>`projectSettings` | [`ProjectSetting!`](#projectsetting) | 変異後のプロジェクト設定。 |

### `Mutation.projectSubscriptionCreate`

入力型: `ProjectSubscriptionCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsubscriptioncreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsubscriptioncreateprojectpath"></a>`projectPath` | [`String!`](#string) | プロジェクトサブスクリプションのダウンストリームプロジェクトのフルパス。 |
| <a id="mutationprojectsubscriptioncreateupstreampath"></a>`upstreamPath` | [`String!`](#string) | プロジェクトサブスクリプションのアップストリームプロジェクトのフルパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsubscriptioncreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsubscriptioncreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationprojectsubscriptioncreatesubscription"></a>`subscription` | [`CiSubscriptionsProject`](#cisubscriptionsproject) | 変異によって作成されたプロジェクトサブスクリプション。 |

### `Mutation.projectSubscriptionDelete`

入力型: `ProjectSubscriptionDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsubscriptiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsubscriptiondeletesubscriptionid"></a>`subscriptionId` | [`CiSubscriptionsProjectID!`](#cisubscriptionsprojectid) | 削除するサブスクリプションのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsubscriptiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsubscriptiondeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationprojectsubscriptiondeleteproject"></a>`project` | [`Project`](#project) | 変異後のプロジェクト。 |

### `Mutation.projectSyncFork`

{{< details >}}GitLab 15.9で**導入**。**状態**: 実験。{{< /details >}}

入力型: `ProjectSyncForkInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsyncforkclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsyncforkprojectpath"></a>`projectPath` | [`ID!`](#id) | 初期化するプロジェクトのフルパス。 |
| <a id="mutationprojectsyncforktargetbranch"></a>`targetBranch` | [`String!`](#string) | フェッチ先フォークのref。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsyncforkclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsyncforkdetails"></a>`details` | [`ForkDetails`](#forkdetails) | 更新されたフォークの詳細。 |
| <a id="mutationprojectsyncforkerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.projectTargetBranchRuleCreate`

入力型: `ProjectTargetBranchRuleCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojecttargetbranchrulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojecttargetbranchrulecreatename"></a>`name` | [`String!`](#string) | ターゲットブランチルールの名前。 |
| <a id="mutationprojecttargetbranchrulecreateprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | ターゲットブランチルールのプロジェクトID。 |
| <a id="mutationprojecttargetbranchrulecreatetargetbranch"></a>`targetBranch` | [`String!`](#string) | ターゲットブランチルールのターゲットブランチ。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojecttargetbranchrulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojecttargetbranchrulecreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationprojecttargetbranchrulecreatetargetbranchrule"></a>`targetBranchRule` | [`ProjectTargetBranchRule`](#projecttargetbranchrule) | 変異後のターゲットブランチルール。 |

### `Mutation.projectTargetBranchRuleDestroy`

入力型: `ProjectTargetBranchRuleDestroyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojecttargetbranchruledestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojecttargetbranchruledestroyid"></a>`id` | [`ProjectsTargetBranchRuleID!`](#projectstargetbranchruleid) | ターゲットブランチルールのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojecttargetbranchruledestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojecttargetbranchruledestroyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.projectTextReplace`

{{< details >}}GitLab 17.1で**導入**。**状態**: 実験。{{< /details >}}

入力型: `projectTextReplaceInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojecttextreplaceclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojecttextreplaceprojectpath"></a>`projectPath` | [`ID!`](#id) | 置き換えるプロジェクトのフルパス。 |
| <a id="mutationprojecttextreplacereplacements"></a>`replacements` | [`[String!]!`](#string) | プロジェクト全体で置換するテキストパターンのリスト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojecttextreplaceclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojecttextreplaceerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.projectUpdateComplianceFrameworks`

プロジェクトのコンプライアンスフレームワークを更新します。

入力型: `ProjectUpdateComplianceFrameworksInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectupdatecomplianceframeworksclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectupdatecomplianceframeworkscomplianceframeworkids"></a>`complianceFrameworkIds` | [`[ComplianceManagementFrameworkID!]!`](#compliancemanagementframeworkid) | プロジェクトで更新するコンプライアンスフレームワークのID。 |
| <a id="mutationprojectupdatecomplianceframeworksprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | コンプライアンスフレームワークを変更するプロジェクトのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectupdatecomplianceframeworksclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprojectupdatecomplianceframeworkserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationprojectupdatecomplianceframeworksproject"></a>`project` | [`Project`](#project) | 変異後のプロジェクト。 |

### `Mutation.prometheusIntegrationCreate`

入力型: `PrometheusIntegrationCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprometheusintegrationcreateactive"></a>`active` | [`Boolean!`](#boolean) | インテグレーションがアラートを受信しているかどうか。 |
| <a id="mutationprometheusintegrationcreateapiurl"></a>`apiUrl` | [`String`](#string) | Prometheusのクエリを実行できるエンドポイント。 |
| <a id="mutationprometheusintegrationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprometheusintegrationcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | インテグレーションを作成するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprometheusintegrationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprometheusintegrationcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationprometheusintegrationcreateintegration"></a>`integration` | [`AlertManagementPrometheusIntegration`](#alertmanagementprometheusintegration) | 新たに作成されたインテグレーション。 |

### `Mutation.prometheusIntegrationResetToken`

入力型: `PrometheusIntegrationResetTokenInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprometheusintegrationresettokenclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprometheusintegrationresettokenid"></a>`id` | [`IntegrationsPrometheusID!`](#integrationsprometheusid) | 変異対象のインテグレーションのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprometheusintegrationresettokenclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprometheusintegrationresettokenerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationprometheusintegrationresettokenintegration"></a>`integration` | [`AlertManagementPrometheusIntegration`](#alertmanagementprometheusintegration) | 新たに作成されたインテグレーション。 |

### `Mutation.prometheusIntegrationUpdate`

入力型: `PrometheusIntegrationUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprometheusintegrationupdateactive"></a>`active` | [`Boolean`](#boolean) | インテグレーションがアラートを受信しているかどうか。 |
| <a id="mutationprometheusintegrationupdateapiurl"></a>`apiUrl` | [`String`](#string) | Prometheusのクエリを実行できるエンドポイント。 |
| <a id="mutationprometheusintegrationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprometheusintegrationupdateid"></a>`id` | [`IntegrationsPrometheusID!`](#integrationsprometheusid) | 変異対象のインテグレーションのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprometheusintegrationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationprometheusintegrationupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationprometheusintegrationupdateintegration"></a>`integration` | [`AlertManagementPrometheusIntegration`](#alertmanagementprometheusintegration) | 新たに作成されたインテグレーション。 |

### `Mutation.promoteToEpic`

{{< details >}}GitLab 17.5で**非推奨**になりました。WorkItem型に置き換えられました。{{< /details >}}

入力型: `PromoteToEpicInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpromotetoepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationpromotetoepicgrouppath"></a>`groupPath` | [`ID`](#id) | プロモート後のエピックが属するグループ。 |
| <a id="mutationpromotetoepiciid"></a>`iid` | [`String!`](#string) | 変異対象のイシューのIID。 |
| <a id="mutationpromotetoepicprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のイシューの属するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpromotetoepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationpromotetoepicepic"></a>`epic` | [`Epic`](#epic) | イシュープロモーション後のエピック。 |
| <a id="mutationpromotetoepicerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationpromotetoepicissue"></a>`issue` | [`Issue`](#issue) | 変異後のイシュー。 |

### `Mutation.refreshStandardsAdherenceChecks`

入力型: `RefreshStandardsAdherenceChecksInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrefreshstandardsadherencechecksclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationrefreshstandardsadherencechecksgrouppath"></a>`groupPath` | [`ID!`](#id) | グループパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrefreshstandardsadherencechecksadherencechecksstatus"></a>`adherenceChecksStatus` | [`StandardsAdherenceChecksStatus`](#standardsadherencechecksstatus) | 標準準拠チェックの進行状況。 |
| <a id="mutationrefreshstandardsadherencechecksclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationrefreshstandardsadherencecheckserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.releaseAssetLinkCreate`

入力型: `ReleaseAssetLinkCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationreleaseassetlinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationreleaseassetlinkcreatedirectassetpath"></a>`directAssetPath` | [`String`](#string) | ダイレクトアセットリンクの相対パス。 |
| <a id="mutationreleaseassetlinkcreatelinktype"></a>`linkType` | [`ReleaseAssetLinkType`](#releaseassetlinktype) | アセットリンクのタイプ。 |
| <a id="mutationreleaseassetlinkcreatename"></a>`name` | [`String!`](#string) | アセットリンクの名前。 |
| <a id="mutationreleaseassetlinkcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | アセットリンクが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationreleaseassetlinkcreatetagname"></a>`tagName` | [`String!`](#string) | 関連付けられているリリースのタグの名前。 |
| <a id="mutationreleaseassetlinkcreateurl"></a>`url` | [`String!`](#string) | アセットリンクのURL。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationreleaseassetlinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationreleaseassetlinkcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationreleaseassetlinkcreatelink"></a>`link` | [`ReleaseAssetLink`](#releaseassetlink) | 変異後のアセットリンク。 |

### `Mutation.releaseAssetLinkDelete`

入力型: `ReleaseAssetLinkDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationreleaseassetlinkdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationreleaseassetlinkdeleteid"></a>`id` | [`ReleasesLinkID!`](#releaseslinkid) | 削除するリリースアセットリンクのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationreleaseassetlinkdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationreleaseassetlinkdeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationreleaseassetlinkdeletelink"></a>`link` | [`ReleaseAssetLink`](#releaseassetlink) | 削除されたリリースアセットリンク。 |

### `Mutation.releaseAssetLinkUpdate`

入力型: `ReleaseAssetLinkUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationreleaseassetlinkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationreleaseassetlinkupdatedirectassetpath"></a>`directAssetPath` | [`String`](#string) | ダイレクトアセットリンクの相対パス。 |
| <a id="mutationreleaseassetlinkupdateid"></a>`id` | [`ReleasesLinkID!`](#releaseslinkid) | 更新するリリースアセットリンクのID。 |
| <a id="mutationreleaseassetlinkupdatelinktype"></a>`linkType` | [`ReleaseAssetLinkType`](#releaseassetlinktype) | アセットリンクのタイプ。 |
| <a id="mutationreleaseassetlinkupdatename"></a>`name` | [`String`](#string) | アセットリンクの名前。 |
| <a id="mutationreleaseassetlinkupdateurl"></a>`url` | [`String`](#string) | アセットリンクのURL。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationreleaseassetlinkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationreleaseassetlinkupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationreleaseassetlinkupdatelink"></a>`link` | [`ReleaseAssetLink`](#releaseassetlink) | 変異後のアセットリンク。 |

### `Mutation.releaseCreate`

入力型: `ReleaseCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationreleasecreateassets"></a>`assets` | [`ReleaseAssetsInput`](#releaseassetsinput) | リリースに関連付けられているアセット。 |
| <a id="mutationreleasecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationreleasecreatedescription"></a>`description` | [`String`](#string) | リリースの説明（「リリースノート」）。 |
| <a id="mutationreleasecreatemilestones"></a>`milestones` | [`[String!]`](#string) | リリースに関連付けられている各マイルストーンのタイトル。GitLab Premiumのお客様は、グループマイルストーンを指定できます。 |
| <a id="mutationreleasecreatename"></a>`name` | [`String`](#string) | リリースの名前。 |
| <a id="mutationreleasecreateprojectpath"></a>`projectPath` | [`ID!`](#id) | リリースが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationreleasecreateref"></a>`ref` | [`String`](#string) | 新しいタグの作成時に使用するコミットSHAまたはブランチ名。 |
| <a id="mutationreleasecreatereleasedat"></a>`releasedAt` | [`Time`](#time) | リリースの日時。デフォルトは現在の時刻です。ISO 8601形式で指定します（`2019-03-15T08:00:00Z`）。このフィールドは、今後のリリースまたは過去のリリースを作成する場合のみ指定します。 |
| <a id="mutationreleasecreatetagmessage"></a>`tagMessage` | [`String`](#string) | 新しい注釈付きタグを作成する場合に使用するメッセージ。 |
| <a id="mutationreleasecreatetagname"></a>`tagName` | [`String!`](#string) | リリースに関連付けるタグの名前。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationreleasecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationreleasecreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationreleasecreaterelease"></a>`release` | [`Release`](#release) | 変異後のリリース。 |

### `Mutation.releaseDelete`

入力型: `ReleaseDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationreleasedeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationreleasedeleteprojectpath"></a>`projectPath` | [`ID!`](#id) | リリースが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationreleasedeletetagname"></a>`tagName` | [`String!`](#string) | 削除するリリースに関連付けられているタグの名前。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationreleasedeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationreleasedeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationreleasedeleterelease"></a>`release` | [`Release`](#release) | 削除されたリリース。 |

### `Mutation.releaseUpdate`

入力型: `ReleaseUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationreleaseupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationreleaseupdatedescription"></a>`description` | [`String`](#string) | リリースの説明（リリースノート）。 |
| <a id="mutationreleaseupdatemilestones"></a>`milestones` | [`[String!]`](#string) | リリースに関連付けられている各マイルストーンのタイトル。GitLab Premiumのお客様は、グループマイルストーンを指定できます。 |
| <a id="mutationreleaseupdatename"></a>`name` | [`String`](#string) | リリースの名前。 |
| <a id="mutationreleaseupdateprojectpath"></a>`projectPath` | [`ID!`](#id) | リリースが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationreleaseupdatereleasedat"></a>`releasedAt` | [`Time`](#time) | リリース日。 |
| <a id="mutationreleaseupdatetagname"></a>`tagName` | [`String!`](#string) | リリースに関連付けられているタグの名前。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationreleaseupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationreleaseupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationreleaseupdaterelease"></a>`release` | [`Release`](#release) | 変異後のリリース。 |

### `Mutation.removeProjectFromSecurityDashboard`

入力型: `RemoveProjectFromSecurityDashboardInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationremoveprojectfromsecuritydashboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationremoveprojectfromsecuritydashboardid"></a>`id` | [`ProjectID!`](#projectid) | インスタンスセキュリティダッシュボードから削除するプロジェクトのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationremoveprojectfromsecuritydashboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationremoveprojectfromsecuritydashboarderrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.repositionImageDiffNote`

イメージ上のDiffNote（`position.positionType`が`"image"`の場合の`Note`）の位置を変更します。

入力型: `RepositionImageDiffNoteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrepositionimagediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationrepositionimagediffnoteid"></a>`id` | [`DiffNoteID!`](#diffnoteid) | 更新するDiffNoteのグローバルID。 |
| <a id="mutationrepositionimagediffnoteposition"></a>`position` | [`UpdateDiffImagePositionInput!`](#updatediffimagepositioninput) | 差分に関するノートの位置。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrepositionimagediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationrepositionimagediffnoteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationrepositionimagediffnotenote"></a>`note` | [`Note`](#note) | 変異後のノート。 |
| <a id="mutationrepositionimagediffnotequickactionsstatus"></a>`quickActionsStatus` | [`QuickActionsStatus`](#quickactionsstatus) | 変異後のクイックアクションの状態。 |

### `Mutation.restorePagesDeployment`

削除がスケジュールされているPagesデプロイを復元します。

{{< details >}}GitLab 17.1で**導入**。**状態**: 実験。{{< /details >}}

入力型: `RestorePagesDeploymentInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrestorepagesdeploymentclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationrestorepagesdeploymentid"></a>`id` | [`PagesDeploymentID!`](#pagesdeploymentid) | PagesデプロイのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrestorepagesdeploymentclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationrestorepagesdeploymenterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationrestorepagesdeploymentpagesdeployment"></a>`pagesDeployment` | [`PagesDeployment!`](#pagesdeployment) | 復元されたPagesデプロイ。 |

### `Mutation.runnerCacheClear`

入力型: `RunnerCacheClearInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrunnercacheclearclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationrunnercacheclearprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | RunnerキャッシュをクリアするプロジェクトのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrunnercacheclearclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationrunnercacheclearerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.runnerCreate`

{{< details >}}GitLab 15.10で**導入**。**状態**: 実験。{{< /details >}}

入力型: `RunnerCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrunnercreateaccesslevel"></a>`accessLevel` | [`CiRunnerAccessLevel`](#cirunneraccesslevel) | Runnerのアクセスレベル。 |
| <a id="mutationrunnercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationrunnercreatedescription"></a>`description` | [`String`](#string) | Runnerの説明。 |
| <a id="mutationrunnercreategroupid"></a>`groupId` | [`GroupID`](#groupid) | Runnerを作成するグループのグローバルID（グループRunnerの場合のみ有効）。 |
| <a id="mutationrunnercreatelocked"></a>`locked` | [`Boolean`](#boolean) | Runnerがロックされていることを示します。 |
| <a id="mutationrunnercreatemaintenancenote"></a>`maintenanceNote` | [`String`](#string) | Runnerのメンテナンスノート。 |
| <a id="mutationrunnercreatemaximumtimeout"></a>`maximumTimeout` | [`Int`](#int) | Runnerが処理するジョブの最大タイムアウト（秒単位）。 |
| <a id="mutationrunnercreatepaused"></a>`paused` | [`Boolean`](#boolean) | Runnerによるジョブ受信が許可されていないことを示します。 |
| <a id="mutationrunnercreateprivateprojectsminutescostfactor"></a>`privateProjectsMinutesCostFactor` {{< icon name="warning-solid" >}} | [`Float`](#float) | **非推奨: ****状態**: 実験。GitLab 17.7で導入。 |
| <a id="mutationrunnercreateprojectid"></a>`projectId` | [`ProjectID`](#projectid) | Runnerを作成するプロジェクトのグローバルID（プロジェクトRunnerの場合のみ有効）。 |
| <a id="mutationrunnercreatepublicprojectsminutescostfactor"></a>`publicProjectsMinutesCostFactor` {{< icon name="warning-solid" >}} | [`Float`](#float) | **非推奨: ****状態**: 実験。GitLab 17.7で導入。 |
| <a id="mutationrunnercreaterununtagged"></a>`runUntagged` | [`Boolean`](#boolean) | Runnerがタグなしジョブを実行できることを示します。 |
| <a id="mutationrunnercreaterunnertype"></a>`runnerType` | [`CiRunnerType!`](#cirunnertype) | 作成するRunnerのタイプ。 |
| <a id="mutationrunnercreatetaglist"></a>`tagList` | [`[String!]`](#string) | Runnerに関連付けられているタグ。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrunnercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationrunnercreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationrunnercreaterunner"></a>`runner` | [`CiRunner`](#cirunner) | 変異後のRunner。 |

### `Mutation.runnerDelete`

入力型: `RunnerDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrunnerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationrunnerdeleteid"></a>`id` | [`CiRunnerID!`](#cirunnerid) | 削除するRunnerのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrunnerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationrunnerdeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.runnerUpdate`

入力型: `RunnerUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrunnerupdateaccesslevel"></a>`accessLevel` | [`CiRunnerAccessLevel`](#cirunneraccesslevel) | Runnerのアクセスレベル。 |
| <a id="mutationrunnerupdateactive"></a>`active` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **非推奨: **名前が変更されました。`paused`を使用してください。GitLab 14.8で非推奨になりました。 |
| <a id="mutationrunnerupdateassociatedprojects"></a>`associatedProjects` | [`[ProjectID!]`](#projectid) | Runnerに関連付けられているプロジェクト。プロジェクトRunnerでのみ利用可能です。 |
| <a id="mutationrunnerupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationrunnerupdatedescription"></a>`description` | [`String`](#string) | Runnerの説明。 |
| <a id="mutationrunnerupdateid"></a>`id` | [`CiRunnerID!`](#cirunnerid) | 更新するRunnerのID。 |
| <a id="mutationrunnerupdatelocked"></a>`locked` | [`Boolean`](#boolean) | Runnerがロックされていることを示します。 |
| <a id="mutationrunnerupdatemaintenancenote"></a>`maintenanceNote` | [`String`](#string) | Runnerのメンテナンスノート。 |
| <a id="mutationrunnerupdatemaximumtimeout"></a>`maximumTimeout` | [`Int`](#int) | Runnerが処理するジョブの最大タイムアウト（秒単位）。 |
| <a id="mutationrunnerupdatepaused"></a>`paused` | [`Boolean`](#boolean) | Runnerによるジョブ受信が許可されていないことを示します。 |
| <a id="mutationrunnerupdateprivateprojectsminutescostfactor"></a>`privateProjectsMinutesCostFactor` {{< icon name="warning-solid" >}} | [`Float`](#float) | **非推奨: ****状態**: 実験。GitLab 17.7で導入。 |
| <a id="mutationrunnerupdatepublicprojectsminutescostfactor"></a>`publicProjectsMinutesCostFactor` {{< icon name="warning-solid" >}} | [`Float`](#float) | **非推奨: ****状態**: 実験。GitLab 17.7で導入。 |
| <a id="mutationrunnerupdaterununtagged"></a>`runUntagged` | [`Boolean`](#boolean) | Runnerがタグなしジョブを実行できることを示します。 |
| <a id="mutationrunnerupdatetaglist"></a>`tagList` | [`[String!]`](#string) | Runnerに関連付けられているタグ。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrunnerupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationrunnerupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationrunnerupdaterunner"></a>`runner` | [`CiRunner`](#cirunner) | 変異後のRunner。 |

### `Mutation.runnersExportUsage`

入力型: `RunnersExportUsageInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrunnersexportusageclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationrunnersexportusagefromdate"></a>`fromDate` | [`ISO8601Date`](#iso8601date) | レポート期間のUTC開始日。デフォルトは、前月の開始日です。 |
| <a id="mutationrunnersexportusagefullpath"></a>`fullPath` | [`ID`](#id) | ジョブを、その属するグループまたはプロジェクトのフルパスでフィルタリングします。例: `gitlab-org`や`gitlab-org/gitlab`など。これを使用できるのは、管理者と、グループ（グループが指定されている場合）またはプロジェクト（プロジェクトが指定されている場合）のメンテナーロールを付与されているユーザーだけです。最大5000個の子プロジェクトからのRunnerという制限があります。 |
| <a id="mutationrunnersexportusagemaxprojectcount"></a>`maxProjectCount` | [`Int`](#int) | 返すプロジェクトの最大数。その他すべてのRunnerの使用状況は、`<Other projects>`エントリに起因します。デフォルトはプロジェクト1000個です。 |
| <a id="mutationrunnersexportusagerunnertype"></a>`runnerType` | [`CiRunnerType`](#cirunnertype) | レポートに含めるRunnerのスコープ。 |
| <a id="mutationrunnersexportusagetodate"></a>`toDate` | [`ISO8601Date`](#iso8601date) | レポート期間のUTC終了日。デフォルトは、`fromDate`で指定された月の月末です。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrunnersexportusageclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationrunnersexportusageerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.runnersRegistrationTokenReset`

{{< details >}}GitLab 17.7で**非推奨**になりました。基盤となる機能は15.6で非推奨となりました。それは18.0で削除される予定です。{{< /details >}}

入力型: `RunnersRegistrationTokenResetInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrunnersregistrationtokenresetclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationrunnersregistrationtokenresetid"></a>`id` | [`ID`](#id) | トークンをリセットするプロジェクトまたはグループのID。インスタンスRunnerトークンをリセットする場合は省略してください。 |
| <a id="mutationrunnersregistrationtokenresettype"></a>`type` | [`CiRunnerType!`](#cirunnertype) | トークンをリセットするオブジェクトのスコープ。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrunnersregistrationtokenresetclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationrunnersregistrationtokenreseterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationrunnersregistrationtokenresettoken"></a>`token` | [`String`](#string) | 変異後のRunnerトークン。 |

### `Mutation.savedReplyCreate`

入力型: `SavedReplyCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsavedreplycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsavedreplycreatecontent"></a>`content` | [`String!`](#string) | 保存済み返信の内容。 |
| <a id="mutationsavedreplycreatename"></a>`name` | [`String!`](#string) | 保存済み返信の名前。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsavedreplycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsavedreplycreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationsavedreplycreatesavedreply"></a>`savedReply` | [`SavedReply`](#savedreply) | 変異後の保存済み返信。 |

### `Mutation.savedReplyDestroy`

入力型: `SavedReplyDestroyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsavedreplydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsavedreplydestroyid"></a>`id` | [`UsersSavedReplyID!`](#userssavedreplyid) | ユーザー保存済み返信のグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsavedreplydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsavedreplydestroyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationsavedreplydestroysavedreply"></a>`savedReply` | [`SavedReply`](#savedreply) | 変異後の保存済み返信。 |

### `Mutation.savedReplyUpdate`

入力型: `SavedReplyUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsavedreplyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsavedreplyupdatecontent"></a>`content` | [`String!`](#string) | 保存済み返信の内容。 |
| <a id="mutationsavedreplyupdateid"></a>`id` | [`UsersSavedReplyID!`](#userssavedreplyid) | ユーザー保存済み返信のグローバルID。 |
| <a id="mutationsavedreplyupdatename"></a>`name` | [`String!`](#string) | 保存済み返信の名前。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsavedreplyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsavedreplyupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationsavedreplyupdatesavedreply"></a>`savedReply` | [`SavedReply`](#savedreply) | 変異後の保存済み返信。 |

### `Mutation.scanExecutionPolicyCommit`

`policy_yaml`のコンテンツを、指定されたプロジェクト（`full_path`）で割り当てられているセキュリティポリシープロジェクトにコミットします。

入力型: `ScanExecutionPolicyCommitInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationscanexecutionpolicycommitclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationscanexecutionpolicycommitfullpath"></a>`fullPath` | [`String`](#string) | プロジェクトのフルパス。 |
| <a id="mutationscanexecutionpolicycommitname"></a>`name` | [`String!`](#string) | ポリシーの名前。名前がnullの場合、`policy_yaml`の`name`フィールドが使用されます。 |
| <a id="mutationscanexecutionpolicycommitoperationmode"></a>`operationMode` | [`MutationOperationMode!`](#mutationoperationmode) | 操作モードを変更します。 |
| <a id="mutationscanexecutionpolicycommitpolicyyaml"></a>`policyYaml` | [`String!`](#string) | ポリシーのYAMLスニペット。 |
| <a id="mutationscanexecutionpolicycommitprojectpath"></a>`projectPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **非推奨: **`fullPath`を使用してください。GitLab 14.10で非推奨になりました。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationscanexecutionpolicycommitbranch"></a>`branch` | [`String`](#string) | ポリシーの変更のコミット先ブランチの名前。 |
| <a id="mutationscanexecutionpolicycommitclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationscanexecutionpolicycommiterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationscanexecutionpolicycommitvalidationerrors"></a>`validationErrors` | [`[SecurityPolicyValidationError!]`](#securitypolicyvalidationerror) | 変異の実行中に発生した検証エラー。 |

### `Mutation.securityFindingCreateIssue`

入力型: `SecurityFindingCreateIssueInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingcreateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsecurityfindingcreateissueproject"></a>`project` | [`ProjectID!`](#projectid) | イシューのアタッチ先プロジェクトのID。 |
| <a id="mutationsecurityfindingcreateissueuuid"></a>`uuid` | [`String!`](#string) | イシューの作成に使用されるセキュリティ検出のUUID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingcreateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsecurityfindingcreateissueerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationsecurityfindingcreateissueissue"></a>`issue` | [`Issue`](#issue) | 変異後に作成されたイシュー。 |

### `Mutation.securityFindingCreateMergeRequest`

入力型: `SecurityFindingCreateMergeRequestInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingcreatemergerequestclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsecurityfindingcreatemergerequestuuid"></a>`uuid` | [`String!`](#string) | マージリクエストの作成に使用されるセキュリティ検出のUUID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingcreatemergerequestclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsecurityfindingcreatemergerequesterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationsecurityfindingcreatemergerequestmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | 変異後に作成されたマージリクエスト。 |

### `Mutation.securityFindingCreateVulnerability`

{{< details >}}GitLab 17.5で**導入**。**状態**: 実験。{{< /details >}}

入力型: `SecurityFindingCreateVulnerabilityInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingcreatevulnerabilityclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsecurityfindingcreatevulnerabilityuuid"></a>`uuid` | [`String!`](#string) | 脆弱性の作成に使用されるセキュリティ検出のUUID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingcreatevulnerabilityclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsecurityfindingcreatevulnerabilityerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationsecurityfindingcreatevulnerabilityvulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | 変異後に作成された脆弱性。 |

### `Mutation.securityFindingDismiss`

入力型: `SecurityFindingDismissInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingdismissclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsecurityfindingdismisscomment"></a>`comment` | [`String`](#string) | 発見を無視する理由についてのコメント。 |
| <a id="mutationsecurityfindingdismissdismissalreason"></a>`dismissalReason` | [`VulnerabilityDismissalReason`](#vulnerabilitydismissalreason) | 発見を無視する理由。 |
| <a id="mutationsecurityfindingdismissuuid"></a>`uuid` | [`String!`](#string) | 無視する発見のUUID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingdismissclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsecurityfindingdismisserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationsecurityfindingdismisssecurityfinding"></a>`securityFinding` | [`PipelineSecurityReportFinding`](#pipelinesecurityreportfinding) | 無視された発見。 |
| <a id="mutationsecurityfindingdismissuuid"></a>`uuid` | [`String`](#string) | 無視された発見のUUID。 |

### `Mutation.securityFindingRevertToDetected`

入力型: `SecurityFindingRevertToDetectedInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingreverttodetectedclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsecurityfindingreverttodetectedcomment"></a>`comment` | [`String`](#string) | 発見をリバートして検出された状態に戻した理由を説明するコメント。 |
| <a id="mutationsecurityfindingreverttodetecteduuid"></a>`uuid` | [`String!`](#string) | 無視する発見のUUID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingreverttodetectedclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsecurityfindingreverttodetectederrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationsecurityfindingreverttodetectedsecurityfinding"></a>`securityFinding` | [`PipelineSecurityReportFinding`](#pipelinesecurityreportfinding) | リバートされて検出された状態に戻された発見。 |

### `Mutation.securityFindingSeverityOverride`

入力型: `SecurityFindingSeverityOverrideInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingseverityoverrideclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsecurityfindingseverityoverrideseverity"></a>`severity` | [`VulnerabilitySeverity!`](#vulnerabilityseverity) | 発見の新しい重大度値。 |
| <a id="mutationsecurityfindingseverityoverrideuuid"></a>`uuid` | [`String!`](#string) | 変更する発見のUUID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingseverityoverrideclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsecurityfindingseverityoverrideerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationsecurityfindingseverityoverridesecurityfinding"></a>`securityFinding` | [`PipelineSecurityReportFinding`](#pipelinesecurityreportfinding) | 重大度が変更された発見。 |

### `Mutation.securityPolicyProjectAssign`

指定されたプロジェクト（`security_policy_project_id`）を、指定されたプロジェクト（`full_path`）のセキュリティポリシープロジェクトとして割り当てます。プロジェクトにすでにセキュリティポリシープロジェクトがある場合、指定された`security_policy_project_id`のプロジェクトのセキュリティポリシープロジェクトを再割り当てします。

入力型: `SecurityPolicyProjectAssignInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsecuritypolicyprojectassignfullpath"></a>`fullPath` | [`String`](#string) | プロジェクトまたはグループのフルパス。 |
| <a id="mutationsecuritypolicyprojectassignprojectpath"></a>`projectPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **非推奨: **`fullPath`を使用してください。GitLab 14.10で非推奨になりました。 |
| <a id="mutationsecuritypolicyprojectassignsecuritypolicyprojectid"></a>`securityPolicyProjectId` | [`ProjectID!`](#projectid) | セキュリティポリシープロジェクトのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsecuritypolicyprojectassignerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.securityPolicyProjectCreate`

指定されたプロジェクトまたはグループ（`full_path`）のセキュリティポリシープロジェクトを作成して割り当てます。

入力型: `SecurityPolicyProjectCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsecuritypolicyprojectcreatefullpath"></a>`fullPath` | [`String`](#string) | プロジェクトまたはグループのフルパス。 |
| <a id="mutationsecuritypolicyprojectcreateprojectpath"></a>`projectPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **非推奨: **`fullPath`を使用してください。GitLab 14.10で非推奨になりました。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsecuritypolicyprojectcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationsecuritypolicyprojectcreateproject"></a>`project` | [`Project`](#project) | 作成されたセキュリティポリシープロジェクト。 |

### `Mutation.securityPolicyProjectCreateAsync`

**状態: **実験。指定されたプロジェクトまたはグループ（`full_path`）のセキュリティポリシープロジェクトを非同期で作成して割り当てます。

{{< details >}}GitLab 17.3で**導入**。**状態**: 実験。{{< /details >}}

入力型: `SecurityPolicyProjectCreateAsyncInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectcreateasyncclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsecuritypolicyprojectcreateasyncfullpath"></a>`fullPath` | [`String!`](#string) | プロジェクトまたはグループのフルパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectcreateasyncclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsecuritypolicyprojectcreateasyncerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.securityPolicyProjectUnassign`

指定されたプロジェクト（`full_path`）のセキュリティポリシープロジェクトの割り当てを解除します。

入力型: `SecurityPolicyProjectUnassignInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectunassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsecuritypolicyprojectunassignfullpath"></a>`fullPath` | [`String`](#string) | プロジェクトまたはグループのフルパス。 |
| <a id="mutationsecuritypolicyprojectunassignprojectpath"></a>`projectPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **非推奨: **`fullPath`を使用してください。GitLab 14.10で非推奨になりました。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectunassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsecuritypolicyprojectunassignerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.securityTrainingUpdate`

入力型: `SecurityTrainingUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecuritytrainingupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsecuritytrainingupdateisenabled"></a>`isEnabled` | [`Boolean!`](#boolean) | プロジェクトでトレーニングプロバイダーを有効として設定します。 |
| <a id="mutationsecuritytrainingupdateisprimary"></a>`isPrimary` | [`Boolean`](#boolean) | プロジェクトでトレーニングプロバイダーをプライマリとして設定します。 |
| <a id="mutationsecuritytrainingupdateprojectpath"></a>`projectPath` | [`ID!`](#id) | プロジェクトのフルパス。 |
| <a id="mutationsecuritytrainingupdateproviderid"></a>`providerId` | [`SecurityTrainingProviderID!`](#securitytrainingproviderid) | プロバイダーのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecuritytrainingupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsecuritytrainingupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationsecuritytrainingupdatetraining"></a>`training` | [`ProjectSecurityTraining`](#projectsecuritytraining) | 変異の対象となるトレーニングエンティティを表します。 |

### `Mutation.setContainerScanningForRegistry`

指定されたプロジェクトのコンテナレジストリでのコンテナスキャンを有効/無効にします。

入力型: `SetContainerScanningForRegistryInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsetcontainerscanningforregistryclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsetcontainerscanningforregistryenable"></a>`enable` | [`Boolean!`](#boolean) | 目的とするコンテナレジストリ機能でのコンテナスキャンの状態。 |
| <a id="mutationsetcontainerscanningforregistrynamespacepath"></a>`namespacePath` | [`ID!`](#id) | ネームスペース（プロジェクト）のフルパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsetcontainerscanningforregistryclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsetcontainerscanningforregistrycontainerscanningforregistryenabled"></a>`containerScanningForRegistryEnabled` | [`Boolean`](#boolean) | 機能が有効かどうか。 |
| <a id="mutationsetcontainerscanningforregistryerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.setGroupSecretPushProtection`

グループのシークレットプッシュ保護を有効または無効にします。

入力型: `SetGroupSecretPushProtectionInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsetgroupsecretpushprotectionclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsetgroupsecretpushprotectionnamespacepath"></a>`namespacePath` | [`ID!`](#id) | グループのフルパス。 |
| <a id="mutationsetgroupsecretpushprotectionprojectstoexclude"></a>`projectsToExclude` | [`[Int!]`](#int) | 機能から除外するプロジェクトのID。 |
| <a id="mutationsetgroupsecretpushprotectionsecretpushprotectionenabled"></a>`secretPushProtectionEnabled` | [`Boolean!`](#boolean) | 機能を有効にするかどうか。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsetgroupsecretpushprotectionclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsetgroupsecretpushprotectionerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.setPreReceiveSecretDetection`

特定のプロジェクトのシークレットプッシュ保護を有効/無効にします。

入力型: `SetPreReceiveSecretDetectionInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsetprereceivesecretdetectionclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsetprereceivesecretdetectionenable"></a>`enable` | [`Boolean!`](#boolean) | 目的とするシークレットプッシュ保護機能の状態。 |
| <a id="mutationsetprereceivesecretdetectionnamespacepath"></a>`namespacePath` | [`ID!`](#id) | ネームスペース（プロジェクト）のフルパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsetprereceivesecretdetectionclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsetprereceivesecretdetectionerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationsetprereceivesecretdetectionprereceivesecretdetectionenabled"></a>`preReceiveSecretDetectionEnabled` | [`Boolean`](#boolean) | 機能が有効かどうか。 |
| <a id="mutationsetprereceivesecretdetectionsecretpushprotectionenabled"></a>`secretPushProtectionEnabled` | [`Boolean`](#boolean) | 機能が有効かどうか。 |

### `Mutation.setSecretPushProtection`

特定のプロジェクトのシークレットプッシュ保護を有効/無効にします。

入力型: `SetSecretPushProtectionInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsetsecretpushprotectionclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsetsecretpushprotectionenable"></a>`enable` | [`Boolean!`](#boolean) | 目的とするシークレットプッシュ保護機能の状態。 |
| <a id="mutationsetsecretpushprotectionnamespacepath"></a>`namespacePath` | [`ID!`](#id) | ネームスペース（プロジェクト）のフルパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsetsecretpushprotectionclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationsetsecretpushprotectionerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationsetsecretpushprotectionprereceivesecretdetectionenabled"></a>`preReceiveSecretDetectionEnabled` | [`Boolean`](#boolean) | 機能が有効かどうか。 |
| <a id="mutationsetsecretpushprotectionsecretpushprotectionenabled"></a>`secretPushProtectionEnabled` | [`Boolean`](#boolean) | 機能が有効かどうか。 |

### `Mutation.starProject`

{{< details >}}GitLab 16.7で**導入**。**状態**: 実験。{{< /details >}}

入力型: `StarProjectInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationstarprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationstarprojectprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | お気に入り登録またはスター解除するプロジェクトのフルパス。 |
| <a id="mutationstarprojectstarred"></a>`starred` | [`Boolean!`](#boolean) | プロジェクトをお気に入り登録するか、スター解除するかを示します。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationstarprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationstarprojectcount"></a>`count` | [`String!`](#string) | プロジェクトの星の数。 |
| <a id="mutationstarprojecterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.tagCreate`

入力型: `TagCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtagcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtagcreatemessage"></a>`message` | [`String`](#string) | タグ付けメッセージ。 |
| <a id="mutationtagcreatename"></a>`name` | [`String!`](#string) | タグの名前。 |
| <a id="mutationtagcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | ブランチが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationtagcreateref"></a>`ref` | [`String!`](#string) | タグの作成元となるタグ名またはコミットSHA。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtagcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtagcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationtagcreatetag"></a>`tag` | [`Tag`](#tag) | 変異後のタグ。 |

### `Mutation.tagDelete`

入力型: `TagDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtagdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtagdeletename"></a>`name` | [`String!`](#string) | タグの名前。 |
| <a id="mutationtagdeleteprojectpath"></a>`projectPath` | [`ID!`](#id) | ブランチが関連付けられているプロジェクトのフルパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtagdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtagdeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationtagdeletetag"></a>`tag` | [`Tag`](#tag) | 変異後のタグ。 |

### `Mutation.terraformStateDelete`

入力型: `TerraformStateDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationterraformstatedeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationterraformstatedeleteid"></a>`id` | [`TerraformStateID!`](#terraformstateid) | Terraform状態のグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationterraformstatedeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationterraformstatedeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.terraformStateLock`

入力型: `TerraformStateLockInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationterraformstatelockclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationterraformstatelockid"></a>`id` | [`TerraformStateID!`](#terraformstateid) | Terraform状態のグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationterraformstatelockclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationterraformstatelockerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.terraformStateUnlock`

入力型: `TerraformStateUnlockInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationterraformstateunlockclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationterraformstateunlockid"></a>`id` | [`TerraformStateID!`](#terraformstateid) | Terraform状態のグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationterraformstateunlockclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationterraformstateunlockerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.timelineEventCreate`

{{< details >}}GitLab 15.6で**導入**。**状態**: 実験。{{< /details >}}

入力型: `TimelineEventCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtimelineeventcreateincidentid"></a>`incidentId` | [`IssueID!`](#issueid) | タイムラインイベントのインシデントID。 |
| <a id="mutationtimelineeventcreatenote"></a>`note` | [`String!`](#string) | タイムラインイベントのテキストノート。 |
| <a id="mutationtimelineeventcreateoccurredat"></a>`occurredAt` | [`Time!`](#time) | イベント発生時点のタイムスタンプ。 |
| <a id="mutationtimelineeventcreatetimelineeventtagnames"></a>`timelineEventTagNames` | [`[String!]`](#string) | インシデントタイムラインイベントのタグ。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtimelineeventcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationtimelineeventcreatetimelineevent"></a>`timelineEvent` | [`TimelineEventType`](#timelineeventtype) | タイムラインイベント。 |

### `Mutation.timelineEventDestroy`

入力型: `TimelineEventDestroyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtimelineeventdestroyid"></a>`id` | [`IncidentManagementTimelineEventID!`](#incidentmanagementtimelineeventid) | 削除するタイムラインイベントID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtimelineeventdestroyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationtimelineeventdestroytimelineevent"></a>`timelineEvent` | [`TimelineEventType`](#timelineeventtype) | タイムラインイベント。 |

### `Mutation.timelineEventPromoteFromNote`

入力型: `TimelineEventPromoteFromNoteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventpromotefromnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtimelineeventpromotefromnotenoteid"></a>`noteId` | [`NoteID!`](#noteid) | タイムラインイベントのプロモート元のノートID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventpromotefromnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtimelineeventpromotefromnoteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationtimelineeventpromotefromnotetimelineevent"></a>`timelineEvent` | [`TimelineEventType`](#timelineeventtype) | タイムラインイベント。 |

### `Mutation.timelineEventTagCreate`

入力型: `TimelineEventTagCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventtagcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtimelineeventtagcreatename"></a>`name` | [`String!`](#string) | タグの名前。 |
| <a id="mutationtimelineeventtagcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | タイムラインイベントタグを作成するプロジェクト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventtagcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtimelineeventtagcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationtimelineeventtagcreatetimelineeventtag"></a>`timelineEventTag` | [`TimelineEventTagType`](#timelineeventtagtype) | タイムラインイベントタグ。 |

### `Mutation.timelineEventUpdate`

入力型: `TimelineEventUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtimelineeventupdateid"></a>`id` | [`IncidentManagementTimelineEventID!`](#incidentmanagementtimelineeventid) | 更新するタイムラインイベントのID。 |
| <a id="mutationtimelineeventupdatenote"></a>`note` | [`String`](#string) | タイムラインイベントのテキストノート。 |
| <a id="mutationtimelineeventupdateoccurredat"></a>`occurredAt` | [`Time`](#time) | イベント発生時点のタイムスタンプ。 |
| <a id="mutationtimelineeventupdatetimelineeventtagnames"></a>`timelineEventTagNames` | [`[String!]`](#string) | インシデントタイムラインイベントのタグ。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtimelineeventupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationtimelineeventupdatetimelineevent"></a>`timelineEvent` | [`TimelineEventType`](#timelineeventtype) | タイムラインイベント。 |

### `Mutation.timelogCreate`

入力型: `TimelogCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtimelogcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtimelogcreateissuableid"></a>`issuableId` | [`IssuableID!`](#issuableid) | イシュー可能オブジェクト（Issue、WorkItem、またはMergeRequest）のグローバルID。 |
| <a id="mutationtimelogcreatespentat"></a>`spentAt` | [`Time`](#time) | 時間消費時点のタイムスタンプ。空の場合、デフォルトは現在時刻です。 |
| <a id="mutationtimelogcreatesummary"></a>`summary` | [`String!`](#string) | 消費した時間の概要。 |
| <a id="mutationtimelogcreatetimespent"></a>`timeSpent` | [`String!`](#string) | 消費した時間。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtimelogcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtimelogcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationtimelogcreatetimelog"></a>`timelog` | [`Timelog`](#timelog) | 時間ログ。 |

### `Mutation.timelogDelete`

入力型: `TimelogDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtimelogdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtimelogdeleteid"></a>`id` | [`TimelogID!`](#timelogid) | 時間ログのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtimelogdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtimelogdeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationtimelogdeletetimelog"></a>`timelog` | [`Timelog`](#timelog) | 時間ログ。 |

### `Mutation.todoCreate`

入力型: `TodoCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodocreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtodocreatetargetid"></a>`targetId` | [`TodoableID!`](#todoableid) | To Doアイテムの親のグローバルID。イシュー、マージリクエスト、デザイン、およびエピックがサポートされています。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodocreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtodocreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationtodocreatetodo"></a>`todo` | [`Todo`](#todo) | 作成されたTo Doアイテム。 |

### `Mutation.todoDeleteMany`

{{< details >}}GitLab 17.11で**導入**。**状態**: 実験。{{< /details >}}

入力型: `TodoDeleteManyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtododeletemanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtododeletemanyids"></a>`ids` | [`[TodoID!]!`](#todoid) | 処理するto-doアイテムのグローバルID（一度に最大100個までサポート）。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtododeletemanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtododeletemanyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.todoMarkDone`

入力型: `TodoMarkDoneInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodomarkdoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtodomarkdoneid"></a>`id` | [`TodoID!`](#todoid) | 完了としてマークするTo DoアイテムのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodomarkdoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtodomarkdoneerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationtodomarkdonetodo"></a>`todo` | [`Todo!`](#todo) | リクエストされたTo Doアイテム。 |

### `Mutation.todoResolveMany`

{{< details >}}GitLab 17.9で**導入**。**状態**: 実験。{{< /details >}}

入力型: `TodoResolveManyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodoresolvemanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtodoresolvemanyids"></a>`ids` | [`[TodoID!]!`](#todoid) | 処理するto-doアイテムのグローバルID（一度に最大100個までサポート）。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodoresolvemanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtodoresolvemanyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationtodoresolvemanytodos"></a>`todos` | [`[Todo!]!`](#todo) | 解決済みのto-doアイテム。 |

### `Mutation.todoRestore`

入力型: `TodoRestoreInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodorestoreclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtodorestoreid"></a>`id` | [`TodoID!`](#todoid) | 復元するTo DoアイテムのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodorestoreclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtodorestoreerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationtodorestoretodo"></a>`todo` | [`Todo!`](#todo) | リクエストされたTo Doアイテム。 |

### `Mutation.todoRestoreMany`

入力型: `TodoRestoreManyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodorestoremanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtodorestoremanyids"></a>`ids` | [`[TodoID!]!`](#todoid) | 処理するto-doアイテムのグローバルID（一度に最大100個までサポート）。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodorestoremanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtodorestoremanyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationtodorestoremanytodos"></a>`todos` | [`[Todo!]!`](#todo) | 復元されたto-doアイテム。 |

### `Mutation.todoSnooze`

{{< details >}}GitLab 17.4で**導入**。**状態**: 実験。{{< /details >}}

入力型: `TodoSnoozeInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodosnoozeclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtodosnoozeid"></a>`id` | [`TodoID!`](#todoid) | スヌーズするTo DoアイテムのグローバルID。 |
| <a id="mutationtodosnoozesnoozeuntil"></a>`snoozeUntil` | [`Time!`](#time) | todoをスヌーズするまでの時間。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodosnoozeclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtodosnoozeerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationtodosnoozetodo"></a>`todo` | [`Todo!`](#todo) | リクエストされたTo Doアイテム。 |

### `Mutation.todoSnoozeMany`

{{< details >}}GitLab 17.9で**導入**。**状態**: 実験。{{< /details >}}

入力型: `TodoSnoozeManyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodosnoozemanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtodosnoozemanyids"></a>`ids` | [`[TodoID!]!`](#todoid) | 処理するto-doアイテムのグローバルID（一度に最大100個までサポート）。 |
| <a id="mutationtodosnoozemanysnoozeuntil"></a>`snoozeUntil` | [`Time!`](#time) | todoをスヌーズするまでの時間。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodosnoozemanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtodosnoozemanyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationtodosnoozemanytodos"></a>`todos` | [`[Todo!]!`](#todo) | スヌーズされたto-doアイテム。 |

### `Mutation.todoUnSnooze`

{{< details >}}GitLab 17.4で**導入**。**状態**: 実験。{{< /details >}}

入力型: `TodoUnSnoozeInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodounsnoozeclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtodounsnoozeid"></a>`id` | [`TodoID!`](#todoid) | スヌーズするTo DoアイテムのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodounsnoozeclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtodounsnoozeerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationtodounsnoozetodo"></a>`todo` | [`Todo!`](#todo) | リクエストされたTo Doアイテム。 |

### `Mutation.todoUnsnoozeMany`

{{< details >}}GitLab 17.9で**導入**。**状態**: 実験。{{< /details >}}

入力型: `TodoUnsnoozeManyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodounsnoozemanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtodounsnoozemanyids"></a>`ids` | [`[TodoID!]!`](#todoid) | 処理するto-doアイテムのグローバルID（一度に最大100個までサポート）。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodounsnoozemanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtodounsnoozemanyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationtodounsnoozemanytodos"></a>`todos` | [`[Todo!]!`](#todo) | スヌーズ解除されたto-doアイテム。 |

### `Mutation.todosMarkAllDone`

入力型: `TodosMarkAllDoneInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodosmarkalldoneaction"></a>`action` | [`[TodoActionEnum!]`](#todoactionenum) | フィルタリングするアクション。 |
| <a id="mutationtodosmarkalldoneauthorid"></a>`authorId` | [`[ID!]`](#id) | 作成者のID。 |
| <a id="mutationtodosmarkalldoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtodosmarkalldonegroupid"></a>`groupId` | [`[ID!]`](#id) | グループのID。 |
| <a id="mutationtodosmarkalldoneprojectid"></a>`projectId` | [`[ID!]`](#id) | プロジェクトのID。 |
| <a id="mutationtodosmarkalldonetargetid"></a>`targetId` | [`TodoableID`](#todoableid) | To Doアイテムの親のグローバルID。イシュー、マージリクエスト、デザイン、およびエピックがサポートされています。引数が省略された場合、現在のユーザーの保留中のto-doアイテムはすべて完了としてマークされます。 |
| <a id="mutationtodosmarkalldonetype"></a>`type` | [`[TodoTargetEnum!]`](#todotargetenum) | todoのタイプ。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodosmarkalldoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationtodosmarkalldoneerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationtodosmarkalldonetodos"></a>`todos` | [`[Todo!]!`](#todo) | 更新されたto-doアイテム。 |

### `Mutation.updateAbuseReportNote`

不正行為レポートのノートを更新します。

{{< details >}}GitLab 17.5で**導入**。**状態**: 実験。{{< /details >}}

入力型: `UpdateAbuseReportNoteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateabusereportnotebody"></a>`body` | [`String!`](#string) | ノートの内容。 |
| <a id="mutationupdateabusereportnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdateabusereportnoteid"></a>`id` | [`AntiAbuseReportsNoteID!`](#antiabusereportsnoteid) | 更新するノートのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateabusereportnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdateabusereportnoteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationupdateabusereportnotenote"></a>`note` | [`AbuseReportNote!`](#abusereportnote) | 変異後の不正行為レポートノート。 |

### `Mutation.updateAlertStatus`

入力型: `UpdateAlertStatusInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatealertstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdatealertstatusiid"></a>`iid` | [`String!`](#string) | 変異対象のアラートのIID。 |
| <a id="mutationupdatealertstatusprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のアラートの属するプロジェクト。 |
| <a id="mutationupdatealertstatusstatus"></a>`status` | [`AlertManagementStatus!`](#alertmanagementstatus) | アラートを設定する状態。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatealertstatusalert"></a>`alert` | [`AlertManagementAlert`](#alertmanagementalert) | 変異後のアラート。 |
| <a id="mutationupdatealertstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdatealertstatuserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationupdatealertstatusissue"></a>`issue` | [`Issue`](#issue) | 変異後に作成されたイシュー。 |
| <a id="mutationupdatealertstatustodo"></a>`todo` | [`Todo`](#todo) | 変異後のTo Doアイテム。 |

### `Mutation.updateBoard`

入力型: `UpdateBoardInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateboardassigneeid"></a>`assigneeId` | [`UserID`](#userid) | ボードに割り当てるユーザーのID。 |
| <a id="mutationupdateboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdateboardhidebackloglist"></a>`hideBacklogList` | [`Boolean`](#boolean) | バックログリストを非表示にするかどうか。 |
| <a id="mutationupdateboardhideclosedlist"></a>`hideClosedList` | [`Boolean`](#boolean) | 完了リストを非表示にするかどうか。 |
| <a id="mutationupdateboardid"></a>`id` | [`BoardID!`](#boardid) | ボードのグローバルID。 |
| <a id="mutationupdateboarditerationcadenceid"></a>`iterationCadenceId` | [`IterationsCadenceID`](#iterationscadenceid) | ボードに割り当てるイテレーションケイデンスのID。 |
| <a id="mutationupdateboarditerationid"></a>`iterationId` | [`IterationID`](#iterationid) | ボードに割り当てるイテレーションのID。 |
| <a id="mutationupdateboardlabelids"></a>`labelIds` | [`[LabelID!]`](#labelid) | ボードに追加するラベルのID。 |
| <a id="mutationupdateboardlabels"></a>`labels` | [`[String!]`](#string) | イシューのラベル。 |
| <a id="mutationupdateboardmilestoneid"></a>`milestoneId` | [`MilestoneID`](#milestoneid) | ボードに割り当てるマイルストーンのID。 |
| <a id="mutationupdateboardname"></a>`name` | [`String`](#string) | ボード名。 |
| <a id="mutationupdateboardweight"></a>`weight` | [`Int`](#int) | ボードに割り当てるウェイト値。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateboardboard"></a>`board` | [`Board`](#board) | 変異後のボード。 |
| <a id="mutationupdateboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdateboarderrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.updateBoardEpicUserPreferences`

{{< details >}}GitLab 17.5で**非推奨**になりました。WorkItem型に置き換えられました。{{< /details >}}

入力型: `UpdateBoardEpicUserPreferencesInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateboardepicuserpreferencesboardid"></a>`boardId` | [`BoardID!`](#boardid) | ボードのグローバルID。 |
| <a id="mutationupdateboardepicuserpreferencesclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdateboardepicuserpreferencescollapsed"></a>`collapsed` | [`Boolean!`](#boolean) | ボードでエピックを折りたたむかどうか。 |
| <a id="mutationupdateboardepicuserpreferencesepicid"></a>`epicId` | [`EpicID!`](#epicid) | プリファレンスを設定する対象となるエピックのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateboardepicuserpreferencesclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdateboardepicuserpreferencesepicuserpreferences"></a>`epicUserPreferences` | [`BoardEpicUserPreferences`](#boardepicuserpreferences) | 変異後のボードにおけるエピックのユーザープリファレンス。 |
| <a id="mutationupdateboardepicuserpreferenceserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.updateBoardList`

入力型: `UpdateBoardListInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateboardlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdateboardlistcollapsed"></a>`collapsed` | [`Boolean`](#boolean) | ユーザーに対してリストを折りたたみ表示するかどうかを示します。 |
| <a id="mutationupdateboardlistlistid"></a>`listId` | [`ListID!`](#listid) | リストのグローバルID。 |
| <a id="mutationupdateboardlistposition"></a>`position` | [`Int`](#int) | ボード内のリストの位置。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateboardlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdateboardlisterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationupdateboardlistlist"></a>`list` | [`BoardList`](#boardlist) | 変異対象のリスト。 |

### `Mutation.updateComplianceFramework`

入力型: `UpdateComplianceFrameworkInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatecomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdatecomplianceframeworkid"></a>`id` | [`ComplianceManagementFrameworkID!`](#compliancemanagementframeworkid) | 更新するコンプライアンスフレームワークのグローバルID。 |
| <a id="mutationupdatecomplianceframeworkparams"></a>`params` | [`ComplianceFrameworkInput!`](#complianceframeworkinput) | コンプライアンスフレームワークを更新するためのパラメータ。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatecomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdatecomplianceframeworkcomplianceframework"></a>`complianceFramework` | [`ComplianceFramework`](#complianceframework) | 変異後のコンプライアンスフレームワーク。 |
| <a id="mutationupdatecomplianceframeworkerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.updateComplianceRequirement`

{{< details >}}GitLab 17.7で**導入**。**状態**: 実験。{{< /details >}}

入力型: `UpdateComplianceRequirementInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatecompliancerequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdatecompliancerequirementcontrols"></a>`controls` | [`[ComplianceRequirementsControlInput!]`](#compliancerequirementscontrolinput) | コンプライアンス要件に追加または更新するコントロール。 |
| <a id="mutationupdatecompliancerequirementid"></a>`id` | [`ComplianceManagementComplianceFrameworkComplianceRequirementID!`](#compliancemanagementcomplianceframeworkcompliancerequirementid) | 更新するコンプライアンス要件のグローバルID。 |
| <a id="mutationupdatecompliancerequirementparams"></a>`params` | [`ComplianceRequirementInput!`](#compliancerequirementinput) | コンプライアンス要件を更新するためのパラメータ。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatecompliancerequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdatecompliancerequirementerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationupdatecompliancerequirementrequirement"></a>`requirement` | [`ComplianceRequirement`](#compliancerequirement) | 更新後のコンプライアンス要件。 |

### `Mutation.updateComplianceRequirementsControl`

{{< details >}}GitLab 17.9で**導入**。**状態**: 実験。{{< /details >}}

入力型: `UpdateComplianceRequirementsControlInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatecompliancerequirementscontrolclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdatecompliancerequirementscontrolid"></a>`id` | [`ComplianceManagementComplianceFrameworkComplianceRequirementsControlID!`](#compliancemanagementcomplianceframeworkcompliancerequirementscontrolid) | 更新するコンプライアンス要件コントロールのグローバルID。 |
| <a id="mutationupdatecompliancerequirementscontrolparams"></a>`params` | [`ComplianceRequirementsControlInput!`](#compliancerequirementscontrolinput) | コンプライアンス要件コントロールを更新するためのパラメータ。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatecompliancerequirementscontrolclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdatecompliancerequirementscontrolerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationupdatecompliancerequirementscontrolrequirementscontrol"></a>`requirementsControl` | [`ComplianceRequirementsControl`](#compliancerequirementscontrol) | 更新後のコンプライアンス要件コントロール。 |

### `Mutation.updateContainerExpirationPolicy`

入力型: `UpdateContainerExpirationPolicyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatecontainerexpirationpolicycadence"></a>`cadence` | [`ContainerExpirationPolicyCadenceEnum`](#containerexpirationpolicycadenceenum) | コンテナ有効期限ポリシーのスケジュール。 |
| <a id="mutationupdatecontainerexpirationpolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdatecontainerexpirationpolicyenabled"></a>`enabled` | [`Boolean`](#boolean) | コンテナ有効期限ポリシーが有効かどうかを示します。 |
| <a id="mutationupdatecontainerexpirationpolicykeepn"></a>`keepN` | [`ContainerExpirationPolicyKeepEnum`](#containerexpirationpolicykeepenum) | 保持するタグの数。 |
| <a id="mutationupdatecontainerexpirationpolicynameregex"></a>`nameRegex` | [`UntrustedRegexp`](#untrustedregexp) | 正規表現パターンに一致する名前のタグが期限切れになります。 |
| <a id="mutationupdatecontainerexpirationpolicynameregexkeep"></a>`nameRegexKeep` | [`UntrustedRegexp`](#untrustedregexp) | 正規表現パターンに一致する名前のタグが保持されます。 |
| <a id="mutationupdatecontainerexpirationpolicyolderthan"></a>`olderThan` | [`ContainerExpirationPolicyOlderThanEnum`](#containerexpirationpolicyolderthanenum) | 指定された期間より古いタグが期限切れになります。 |
| <a id="mutationupdatecontainerexpirationpolicyprojectpath"></a>`projectPath` | [`ID!`](#id) | コンテナ有効期限ポリシーが属するプロジェクトパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatecontainerexpirationpolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdatecontainerexpirationpolicycontainerexpirationpolicy"></a>`containerExpirationPolicy` {{< icon name="warning-solid" >}} | [`ContainerExpirationPolicy`](#containerexpirationpolicy) | **非推奨: **`container_tags_expiration_policy`を使用してください。GitLab 17.5で非推奨になりました。 |
| <a id="mutationupdatecontainerexpirationpolicycontainertagsexpirationpolicy"></a>`containerTagsExpirationPolicy` | [`ContainerTagsExpirationPolicy`](#containertagsexpirationpolicy) | 変異後のコンテナタグ有効期限ポリシー。 |
| <a id="mutationupdatecontainerexpirationpolicyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.updateContainerProtectionRepositoryRule`

ユーザーロールに基づいて、コンテナイメージを変更できるユーザーを制御するコンテナリポジトリ保護ルールを更新します。

入力型: `UpdateContainerProtectionRepositoryRuleInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatecontainerprotectionrepositoryruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdatecontainerprotectionrepositoryruleid"></a>`id` | [`ContainerRegistryProtectionRuleID!`](#containerregistryprotectionruleid) | 更新するコンテナリポジトリ保護ルールのグローバルID。 |
| <a id="mutationupdatecontainerprotectionrepositoryruleminimumaccesslevelfordelete"></a>`minimumAccessLevelForDelete` | [`ContainerProtectionRepositoryRuleAccessLevel`](#containerprotectionrepositoryruleaccesslevel) | コンテナリポジトリからコンテナイメージを削除するために必要な最小GitLabアクセスレベル。有効な値には`MAINTAINER`、`OWNER`、または`ADMIN`が含まれます。値が`nil`の場合のデフォルトの最小アクセスレベルは`DEVELOPER`です。 |
| <a id="mutationupdatecontainerprotectionrepositoryruleminimumaccesslevelforpush"></a>`minimumAccessLevelForPush` | [`ContainerProtectionRepositoryRuleAccessLevel`](#containerprotectionrepositoryruleaccesslevel) | コンテナイメージをコンテナリポジトリにプッシュするために必要な最小GitLabアクセスレベル。有効な値には`MAINTAINER`、`OWNER`、または`ADMIN`が含まれます。値が`nil`の場合のデフォルトの最小アクセスレベルは`DEVELOPER`です。 |
| <a id="mutationupdatecontainerprotectionrepositoryrulerepositorypathpattern"></a>`repositoryPathPattern` | [`String`](#string) | 保護ルールによって保護されるコンテナリポジトリパスパターン。先頭がプロジェクトのフルパスでなければなりません。例: `my-project/*-prod-*`。ワイルドカード文字`*`は、プロジェクトのフルパスの後のどこにでも使用できます。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatecontainerprotectionrepositoryruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdatecontainerprotectionrepositoryrulecontainerprotectionrepositoryrule"></a>`containerProtectionRepositoryRule` | [`ContainerProtectionRepositoryRule`](#containerprotectionrepositoryrule) | 変異後のコンテナリポジトリ保護ルール。 |
| <a id="mutationupdatecontainerprotectionrepositoryruleerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.updateContainerProtectionTagRule`

指定されたパターンに一致するコンテナイメージタグを変更できるユーザーロールを制御する保護ルールを更新します。機能フラグ`container_registry_protected_tags`が有効な場合にのみ使用可能。

{{< details >}}GitLab 17.8で**導入**。**状態**: 実験。{{< /details >}}

入力型: `UpdateContainerProtectionTagRuleInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatecontainerprotectiontagruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdatecontainerprotectiontagruleid"></a>`id` | [`ContainerRegistryProtectionTagRuleID!`](#containerregistryprotectiontagruleid) | 更新するタグ保護ルールのグローバルID。 |
| <a id="mutationupdatecontainerprotectiontagruleminimumaccesslevelfordelete"></a>`minimumAccessLevelForDelete` {{< icon name="warning-solid" >}} | [`ContainerProtectionTagRuleAccessLevel`](#containerprotectiontagruleaccesslevel) | **非推奨: ****状態**: 実験。GitLab 17.8で導入。 |
| <a id="mutationupdatecontainerprotectiontagruleminimumaccesslevelforpush"></a>`minimumAccessLevelForPush` {{< icon name="warning-solid" >}} | [`ContainerProtectionTagRuleAccessLevel`](#containerprotectiontagruleaccesslevel) | **非推奨: ****状態**: 実験。GitLab 17.8で導入。 |
| <a id="mutationupdatecontainerprotectiontagruletagnamepattern"></a>`tagNamePattern` {{< icon name="warning-solid" >}} | [`String`](#string) | **非推奨: ****状態**: 実験。GitLab 17.8で導入。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatecontainerprotectiontagruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdatecontainerprotectiontagrulecontainerprotectiontagrule"></a>`containerProtectionTagRule` {{< icon name="warning-solid" >}} | [`ContainerProtectionTagRule`](#containerprotectiontagrule) | **非推奨: ****状態**: 実験。GitLab 17.8で導入。 |
| <a id="mutationupdatecontainerprotectiontagruleerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.updateDependencyProxyImageTtlGroupPolicy`

これらの設定を調整できるのはグループのオーナーだけです。

入力型: `UpdateDependencyProxyImageTtlGroupPolicyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicyenabled"></a>`enabled` | [`Boolean`](#boolean) | ポリシーが有効か無効かを示します。 |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicygrouppath"></a>`groupPath` | [`ID!`](#id) | グループ依存プロキシイメージTTLポリシーのグループパス。 |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicyttl"></a>`ttl` | [`Int`](#int) | キャッシュに入れられたイメージファイルを保持する日数。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicydependencyproxyimagettlpolicy"></a>`dependencyProxyImageTtlPolicy` | [`DependencyProxyImageTtlGroupPolicy`](#dependencyproxyimagettlgrouppolicy) | 変異後のグループイメージTTLポリシー。 |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.updateDependencyProxyPackagesSettings`

パッケージの設定に関する依存プロキシを更新または作成します。設定でパッケージと依存プロキシを有効にする必要があります。プロジェクトレベルでパッケージ機能を有効にする必要があります。

入力型: `UpdateDependencyProxyPackagesSettingsInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatedependencyproxypackagessettingsclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdatedependencyproxypackagessettingsenabled"></a>`enabled` | [`Boolean`](#boolean) | プロジェクトでパッケージの依存プロキシが有効かどうかを示します。 |
| <a id="mutationupdatedependencyproxypackagessettingsmavenexternalregistrypassword"></a>`mavenExternalRegistryPassword` | [`String`](#string) | 外部Mavenパッケージレジストリのパスワード。GitLab 16.5で導入。この機能は実験です。予告なく変更または削除される可能性があります。 |
| <a id="mutationupdatedependencyproxypackagessettingsmavenexternalregistryurl"></a>`mavenExternalRegistryUrl` | [`String`](#string) | 外部MavenパッケージレジストリのURL。 |
| <a id="mutationupdatedependencyproxypackagessettingsmavenexternalregistryusername"></a>`mavenExternalRegistryUsername` | [`String`](#string) | 外部Mavenパッケージレジストリのユーザー名。 |
| <a id="mutationupdatedependencyproxypackagessettingsprojectpath"></a>`projectPath` | [`ID!`](#id) | パッケージ設定の依存プロキシのプロジェクトパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatedependencyproxypackagessettingsclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdatedependencyproxypackagessettingsdependencyproxypackagessetting"></a>`dependencyProxyPackagesSetting` | [`DependencyProxyPackagesSetting`](#dependencyproxypackagessetting) | 変異後のパッケージ設定の依存プロキシ。 |
| <a id="mutationupdatedependencyproxypackagessettingserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.updateDependencyProxySettings`

これらの設定を調整できるのはグループのオーナーだけです。

入力型: `UpdateDependencyProxySettingsInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatedependencyproxysettingsclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdatedependencyproxysettingsenabled"></a>`enabled` | [`Boolean`](#boolean) | ポリシーが有効か無効かを示します。 |
| <a id="mutationupdatedependencyproxysettingsgrouppath"></a>`groupPath` | [`ID!`](#id) | グループ依存プロキシのグループパス。 |
| <a id="mutationupdatedependencyproxysettingsidentity"></a>`identity` | [`String`](#string) | イメージをプルする際にDocker Hubで認証するために使用されるID認証情報。ユーザー名（パスワードまたはパーソナルアクセストークン（PAT）の場合）、または組織名（組織アクセストークン（OAT）の場合）を指定できます。 |
| <a id="mutationupdatedependencyproxysettingssecret"></a>`secret` | [`String`](#string) | イメージをプルする際にDocker Hubで認証するために使用されるシークレット認証情報。パスワード、パーソナルアクセストークン（PAT）、または組織アクセストークン（OAT）を指定できます。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatedependencyproxysettingsclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdatedependencyproxysettingsdependencyproxysetting"></a>`dependencyProxySetting` | [`DependencyProxySetting`](#dependencyproxysetting) | 変異後のグループ依存プロキシ設定。 |
| <a id="mutationupdatedependencyproxysettingserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.updateEpic`

{{< details >}}GitLab 17.5で**非推奨**になりました。WorkItem型に置き換えられました。{{< /details >}}

入力型: `UpdateEpicInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateepicaddlabelids"></a>`addLabelIds` | [`[ID!]`](#id) | エピックに追加するラベルのID。 |
| <a id="mutationupdateepicaddlabels"></a>`addLabels` | [`[String!]`](#string) | エピックに追加するラベルの配列。 |
| <a id="mutationupdateepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdateepiccolor"></a>`color` | [`Color`](#color) | エピックの色。 |
| <a id="mutationupdateepicconfidential"></a>`confidential` | [`Boolean`](#boolean) | エピックが機密かどうかを示します。 |
| <a id="mutationupdateepicdescription"></a>`description` | [`String`](#string) | エピックの説明。 |
| <a id="mutationupdateepicduedatefixed"></a>`dueDateFixed` | [`String`](#string) | エピックの終了日。 |
| <a id="mutationupdateepicduedateisfixed"></a>`dueDateIsFixed` | [`Boolean`](#boolean) | 終了日をイシューのマイルストーンではなく、due_date_fixedフィールドから取得することを示します。 |
| <a id="mutationupdateepicgrouppath"></a>`groupPath` | [`ID!`](#id) | 変異対象のエピックの属するグループ。 |
| <a id="mutationupdateepiciid"></a>`iid` | [`ID!`](#id) | 変異対象のエピックのIID。 |
| <a id="mutationupdateepicremovelabelids"></a>`removeLabelIds` | [`[ID!]`](#id) | エピックから削除するラベルのID。 |
| <a id="mutationupdateepicremovelabels"></a>`removeLabels` | [`[String!]`](#string) | エピックから削除するラベルの配列。 |
| <a id="mutationupdateepicstartdatefixed"></a>`startDateFixed` | [`String`](#string) | エピックの開始日。 |
| <a id="mutationupdateepicstartdateisfixed"></a>`startDateIsFixed` | [`Boolean`](#boolean) | 開始日をイシューのマイルストーンではなく、start_date_fixedフィールドから取得することを示します。 |
| <a id="mutationupdateepicstateevent"></a>`stateEvent` | [`EpicStateEvent`](#epicstateevent) | エピックの状態イベント。 |
| <a id="mutationupdateepictitle"></a>`title` | [`String`](#string) | エピックのタイトル。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdateepicepic"></a>`epic` | [`Epic`](#epic) | 変異後のエピック。 |
| <a id="mutationupdateepicerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.updateEpicBoardList`

{{< details >}}GitLab 17.5で**非推奨**になりました。WorkItem型に置き換えられました。{{< /details >}}

入力型: `UpdateEpicBoardListInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateepicboardlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdateepicboardlistcollapsed"></a>`collapsed` | [`Boolean`](#boolean) | ユーザーに対してリストを折りたたみ表示するかどうかを示します。 |
| <a id="mutationupdateepicboardlistlistid"></a>`listId` | [`BoardsEpicListID!`](#boardsepiclistid) | エピックリストのグローバルID。 |
| <a id="mutationupdateepicboardlistposition"></a>`position` | [`Int`](#int) | ボード内のリストの位置。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateepicboardlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdateepicboardlisterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationupdateepicboardlistlist"></a>`list` | [`EpicList`](#epiclist) | 変異対象のエピックリスト。 |

### `Mutation.updateImageDiffNote`

イメージ上のDiffNote（`position.positionType`が`"image"`である`Note`）を更新します。ノートの本文に含まれるのがクイックアクションだけの場合、更新時にノートが破棄され、ノートは返されません。

入力型: `UpdateImageDiffNoteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateimagediffnotebody"></a>`body` | [`String`](#string) | ノートの内容。 |
| <a id="mutationupdateimagediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdateimagediffnoteid"></a>`id` | [`NoteID!`](#noteid) | 更新するノートのグローバルID。 |
| <a id="mutationupdateimagediffnoteposition"></a>`position` | [`UpdateDiffImagePositionInput`](#updatediffimagepositioninput) | 差分に関するノートの位置。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateimagediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdateimagediffnoteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationupdateimagediffnotenote"></a>`note` | [`Note`](#note) | 変異後のノート。 |
| <a id="mutationupdateimagediffnotequickactionsstatus"></a>`quickActionsStatus` | [`QuickActionsStatus`](#quickactionsstatus) | 変異後のクイックアクションの状態。 |

### `Mutation.updateIssue`

入力型: `UpdateIssueInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateissueaddlabelids"></a>`addLabelIds` | [`[ID!]`](#id) | イシューに追加するラベルのID。 |
| <a id="mutationupdateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdateissueconfidential"></a>`confidential` | [`Boolean`](#boolean) | イシューが機密であることを示します。 |
| <a id="mutationupdateissuedescription"></a>`description` | [`String`](#string) | イシューの説明。 |
| <a id="mutationupdateissueduedate"></a>`dueDate` | [`ISO8601Date`](#iso8601date) | イシューの期限。 |
| <a id="mutationupdateissueepicid"></a>`epicId` {{< icon name="warning-solid" >}} | [`EpicID`](#epicid) | **非推奨: **これはWorkItem hierarchyWidgetに置き換えられる予定です。GitLab 17.5で非推奨になりました。 |
| <a id="mutationupdateissuehealthstatus"></a>`healthStatus` | [`HealthStatus`](#healthstatus) | 目的のヘルスステータス。 |
| <a id="mutationupdateissueiid"></a>`iid` | [`String!`](#string) | 変異対象のイシューのIID。 |
| <a id="mutationupdateissuelabelids"></a>`labelIds` | [`[ID!]`](#id) | 設定するラベルのID。既存のイシューラベルを置き換えます。 |
| <a id="mutationupdateissuelocked"></a>`locked` | [`Boolean`](#boolean) | ディスカッションがイシューでロックされていることを示します。 |
| <a id="mutationupdateissuemilestoneid"></a>`milestoneId` | [`ID`](#id) | イシューに割り当てるマイルストーンのID。nullに設定すると、更新時にマイルストーンが削除されます。 |
| <a id="mutationupdateissueprojectpath"></a>`projectPath` | [`ID!`](#id) | 変異対象のイシューの属するプロジェクト。 |
| <a id="mutationupdateissueremovelabelids"></a>`removeLabelIds` | [`[ID!]`](#id) | イシューから削除するラベルのID。 |
| <a id="mutationupdateissuestateevent"></a>`stateEvent` | [`IssueStateEvent`](#issuestateevent) | イシューをクローズまたは再オープンします。 |
| <a id="mutationupdateissuetimeestimate"></a>`timeEstimate` | [`String`](#string) | イシュー完了にかかる推定時間。`null`または`0`を使用すると、現在の推定値が削除されます。 |
| <a id="mutationupdateissuetitle"></a>`title` | [`String`](#string) | イシューのタイトル。 |
| <a id="mutationupdateissuetype"></a>`type` | [`IssueType`](#issuetype) | イシューのタイプ。 |
| <a id="mutationupdateissueweight"></a>`weight` | [`Int`](#int) | イシューのウェイト。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdateissueerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationupdateissueissue"></a>`issue` | [`Issue`](#issue) | 変異後のイシュー。 |

### `Mutation.updateIteration`

入力型: `UpdateIterationInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateiterationclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdateiterationdescription"></a>`description` | [`String`](#string) | イテレーションの説明。 |
| <a id="mutationupdateiterationduedate"></a>`dueDate` | [`String`](#string) | イテレーションの終了日。 |
| <a id="mutationupdateiterationgrouppath"></a>`groupPath` | [`ID!`](#id) | イテレーションのグループ。 |
| <a id="mutationupdateiterationid"></a>`id` | [`ID!`](#id) | イテレーションのグローバルID。 |
| <a id="mutationupdateiterationstartdate"></a>`startDate` | [`String`](#string) | イテレーションの開始日。 |
| <a id="mutationupdateiterationtitle"></a>`title` | [`String`](#string) | イテレーションのタイトル。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateiterationclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdateiterationerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationupdateiterationiteration"></a>`iteration` | [`Iteration`](#iteration) | 更新されたイテレーション。 |

### `Mutation.updateNamespacePackageSettings`

これらの設定を調整できるのはグループのオーナーだけです。

入力型: `UpdateNamespacePackageSettingsInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatenamespacepackagesettingsauditeventsenabled"></a>`auditEventsEnabled` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **非推奨: ****状態**: 実験。GitLab 17.10で導入。 |
| <a id="mutationupdatenamespacepackagesettingsclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdatenamespacepackagesettingsgenericduplicateexceptionregex"></a>`genericDuplicateExceptionRegex` | [`UntrustedRegexp`](#untrustedregexp) | generic_duplicates_allowedがfalseの場合、この正規表現に一致する名前の重複パッケージを公開できます。それ以外の場合、この設定は無効です。 |
| <a id="mutationupdatenamespacepackagesettingsgenericduplicatesallowed"></a>`genericDuplicatesAllowed` | [`Boolean`](#boolean) | ネームスペースで汎用パッケージの重複を許可するかどうかを示します。 |
| <a id="mutationupdatenamespacepackagesettingslockmavenpackagerequestsforwarding"></a>`lockMavenPackageRequestsForwarding` | [`Boolean`](#boolean) | すべての子孫ネームスペースに対してMavenパッケージの転送がロックされるかどうかを示します。 |
| <a id="mutationupdatenamespacepackagesettingslocknpmpackagerequestsforwarding"></a>`lockNpmPackageRequestsForwarding` | [`Boolean`](#boolean) | すべての子孫ネームスペースに対してnpmパッケージの転送がロックされるかどうかを示します。 |
| <a id="mutationupdatenamespacepackagesettingslockpypipackagerequestsforwarding"></a>`lockPypiPackageRequestsForwarding` | [`Boolean`](#boolean) | すべての子孫ネームスペースに対してPyPIパッケージの転送がロックされるかどうかを示します。 |
| <a id="mutationupdatenamespacepackagesettingsmavenduplicateexceptionregex"></a>`mavenDuplicateExceptionRegex` | [`UntrustedRegexp`](#untrustedregexp) | maven_duplicates_allowedがfalseの場合、この正規表現に一致する名前の重複パッケージを公開できます。それ以外の場合、この設定は無効です。 |
| <a id="mutationupdatenamespacepackagesettingsmavenduplicatesallowed"></a>`mavenDuplicatesAllowed` | [`Boolean`](#boolean) | ネームスペースでMavenパッケージの重複を許可するかどうかを示します。 |
| <a id="mutationupdatenamespacepackagesettingsmavenpackagerequestsforwarding"></a>`mavenPackageRequestsForwarding` | [`Boolean`](#boolean) | ネームスペースでMavenパッケージの転送を許可するかどうかを示します。 |
| <a id="mutationupdatenamespacepackagesettingsnamespacepath"></a>`namespacePath` | [`ID!`](#id) | ネームスペースパッケージの設定が属するネームスペースパス。 |
| <a id="mutationupdatenamespacepackagesettingsnpmpackagerequestsforwarding"></a>`npmPackageRequestsForwarding` | [`Boolean`](#boolean) | ネームスペースでnpmパッケージの転送を許可するかどうかを示します。 |
| <a id="mutationupdatenamespacepackagesettingsnugetduplicateexceptionregex"></a>`nugetDuplicateExceptionRegex` | [`UntrustedRegexp`](#untrustedregexp) | nuget_duplicates_allowedがfalseの場合、この正規表現に一致する名前の重複パッケージを公開できます。それ以外の場合、この設定は無効です。 |
| <a id="mutationupdatenamespacepackagesettingsnugetduplicatesallowed"></a>`nugetDuplicatesAllowed` | [`Boolean`](#boolean) | ネームスペースでNuGetパッケージの重複を許可するかどうかを示します。 |
| <a id="mutationupdatenamespacepackagesettingsnugetsymbolserverenabled"></a>`nugetSymbolServerEnabled` | [`Boolean`](#boolean) | ネームスペースでNuGetシンボルサーバーが有効かどうかを示します。 |
| <a id="mutationupdatenamespacepackagesettingspypipackagerequestsforwarding"></a>`pypiPackageRequestsForwarding` | [`Boolean`](#boolean) | ネームスペースでPyPIパッケージの転送を許可するかどうかを示します。 |
| <a id="mutationupdatenamespacepackagesettingsterraformmoduleduplicateexceptionregex"></a>`terraformModuleDuplicateExceptionRegex` | [`UntrustedRegexp`](#untrustedregexp) | terraform_module_duplicates_allowedがfalseの場合、この正規表現に一致する名前の重複パッケージを公開できます。それ以外の場合、この設定は無効です。 |
| <a id="mutationupdatenamespacepackagesettingsterraformmoduleduplicatesallowed"></a>`terraformModuleDuplicatesAllowed` | [`Boolean`](#boolean) | ネームスペースでTerraformパッケージの重複を許可するかどうかを示します。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatenamespacepackagesettingsclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdatenamespacepackagesettingserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationupdatenamespacepackagesettingspackagesettings"></a>`packageSettings` | [`PackageSettings`](#packagesettings) | 変異後のネームスペースパッケージ設定。 |

### `Mutation.updateNote`

ノートを更新します。ノートの本文に含まれるのがクイックアクションだけの場合、更新時にノートが破棄され、ノートは返されません。

入力型: `UpdateNoteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatenotebody"></a>`body` | [`String`](#string) | ノートの内容。 |
| <a id="mutationupdatenoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdatenoteid"></a>`id` | [`NoteID!`](#noteid) | 更新するノートのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatenoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdatenoteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationupdatenotenote"></a>`note` | [`Note`](#note) | 変異後のノート。 |
| <a id="mutationupdatenotequickactionsstatus"></a>`quickActionsStatus` | [`QuickActionsStatus`](#quickactionsstatus) | 変異後のクイックアクションの状態。 |

### `Mutation.updatePackagesCleanupPolicy`

入力型: `UpdatePackagesCleanupPolicyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatepackagescleanuppolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdatepackagescleanuppolicykeepnduplicatedpackagefiles"></a>`keepNDuplicatedPackageFiles` | [`PackagesCleanupKeepDuplicatedPackageFilesEnum`](#packagescleanupkeepduplicatedpackagefilesenum) | 保持する重複パッケージファイルの数。 |
| <a id="mutationupdatepackagescleanuppolicyprojectpath"></a>`projectPath` | [`ID!`](#id) | パッケージクリーンアップポリシーの属するプロジェクトパス。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatepackagescleanuppolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdatepackagescleanuppolicyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationupdatepackagescleanuppolicypackagescleanuppolicy"></a>`packagesCleanupPolicy` | [`PackagesCleanupPolicy`](#packagescleanuppolicy) | 変異後のパッケージクリーンアップポリシー。 |

### `Mutation.updatePackagesProtectionRule`

プロジェクトパッケージへのアクセスを制限するよう、パッケージ保護ルールを更新します。特定の権限のないユーザーがパッケージを変更できないようにすることができます。

入力型: `UpdatePackagesProtectionRuleInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatepackagesprotectionruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdatepackagesprotectionruleid"></a>`id` | [`PackagesProtectionRuleID!`](#packagesprotectionruleid) | 更新するパッケージ保護ルールのグローバルID。 |
| <a id="mutationupdatepackagesprotectionruleminimumaccesslevelfordelete"></a>`minimumAccessLevelForDelete` {{< icon name="warning-solid" >}} | [`PackagesProtectionRuleAccessLevelForDelete`](#packagesprotectionruleaccesslevelfordelete) | **非推奨: ****状態**: 実験。GitLab 17.10で導入。 |
| <a id="mutationupdatepackagesprotectionruleminimumaccesslevelforpush"></a>`minimumAccessLevelForPush` | [`PackagesProtectionRuleAccessLevel`](#packagesprotectionruleaccesslevel) | パッケージをパッケージレジストリにプッシュするために必要な最小GitLabアクセスレベル。有効な値には`MAINTAINER`、`OWNER`、または`ADMIN`が含まれます。値が`nil`の場合のデフォルトの最小アクセスレベルは`DEVELOPER`です。 |
| <a id="mutationupdatepackagesprotectionrulepackagenamepattern"></a>`packageNamePattern` | [`String`](#string) | 保護ルールによって保護されるパッケージ名。例：`@my-scope/my-package-*`。ワイルドカード文字`*`を使用できます。 |
| <a id="mutationupdatepackagesprotectionrulepackagetype"></a>`packageType` | [`PackagesProtectionRulePackageType`](#packagesprotectionrulepackagetype) | 保護ルールによって保護されるパッケージのタイプ。例: `NPM`、`PYPI`。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatepackagesprotectionruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdatepackagesprotectionruleerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationupdatepackagesprotectionrulepackageprotectionrule"></a>`packageProtectionRule` | [`PackagesProtectionRule`](#packagesprotectionrule) | 変異後のパッケージ保護ルール。 |

### `Mutation.updateRequirement`

入力型: `UpdateRequirementInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdaterequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdaterequirementdescription"></a>`description` | [`String`](#string) | 要件の説明。 |
| <a id="mutationupdaterequirementiid"></a>`iid` {{< icon name="warning-solid" >}} | [`String`](#string) | **非推奨: **代わりにwork_item_iidを使用してください。GitLab 15.8で非推奨になりました。 |
| <a id="mutationupdaterequirementlasttestreportstate"></a>`lastTestReportState` | [`TestReportState`](#testreportstate) | 指定された状態の要件のテストレポートを作成します。 |
| <a id="mutationupdaterequirementprojectpath"></a>`projectPath` | [`ID!`](#id) | 要件が関連付けられているプロジェクトのフルパス。 |
| <a id="mutationupdaterequirementstate"></a>`state` | [`RequirementState`](#requirementstate) | 要件の状態。 |
| <a id="mutationupdaterequirementtitle"></a>`title` | [`String`](#string) | 要件のタイトル。 |
| <a id="mutationupdaterequirementworkitemiid"></a>`workItemIid` | [`String`](#string) | 更新する要件作業アイテムのIID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdaterequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdaterequirementerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationupdaterequirementrequirement"></a>`requirement` | [`Requirement`](#requirement) | 変異後の要件。 |

### `Mutation.updateSnippet`

入力型: `UpdateSnippetInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatesnippetblobactions"></a>`blobActions` | [`[SnippetBlobActionInputType!]`](#snippetblobactioninputtype) | スニペットリポジトリとBLOBに対して実行するアクション。 |
| <a id="mutationupdatesnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdatesnippetdescription"></a>`description` | [`String`](#string) | スニペットの説明。 |
| <a id="mutationupdatesnippetid"></a>`id` | [`SnippetID!`](#snippetid) | 更新するスニペットのグローバルID。 |
| <a id="mutationupdatesnippettitle"></a>`title` | [`String`](#string) | スニペットのタイトル。 |
| <a id="mutationupdatesnippetvisibilitylevel"></a>`visibilityLevel` | [`VisibilityLevelsEnum`](#visibilitylevelsenum) | スニペットの表示レベル。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatesnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationupdatesnippeterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationupdatesnippetsnippet"></a>`snippet` | [`Snippet`](#snippet) | 変異後のスニペット。 |

### `Mutation.uploadDelete`

アップロードを削除します。

入力型: `UploadDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuploaddeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationuploaddeletefilename"></a>`filename` | [`String!`](#string) | アップロードファイル名。 |
| <a id="mutationuploaddeletegrouppath"></a>`groupPath` | [`ID`](#id) | リソースが関連付けられているグループのフルパス。 |
| <a id="mutationuploaddeleteprojectpath"></a>`projectPath` | [`ID`](#id) | リソースが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationuploaddeletesecret"></a>`secret` | [`String!`](#string) | アップロードパスのシークレット部分。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuploaddeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationuploaddeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationuploaddeleteupload"></a>`upload` | [`FileUpload`](#fileupload) | 削除されたアップロード。 |

### `Mutation.userAchievementPrioritiesUpdate`

{{< details >}}GitLab 16.5で**導入**。**状態**: 実験。{{< /details >}}

入力型: `UserAchievementPrioritiesUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuserachievementprioritiesupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationuserachievementprioritiesupdateuserachievementids"></a>`userAchievementIds` | [`[AchievementsUserAchievementID!]!`](#achievementsuserachievementid) | 優先順位付けし、優先順位最高のものから順に並べたユーザーアチーブメントのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuserachievementprioritiesupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationuserachievementprioritiesupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationuserachievementprioritiesupdateuserachievements"></a>`userAchievements` | [`[UserAchievement!]!`](#userachievement) | 更新されたユーザーアチーブメント。 |

### `Mutation.userAchievementsDelete`

{{< details >}}GitLab 16.1で**導入**。**状態**: 実験。{{< /details >}}

入力型: `UserAchievementsDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuserachievementsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationuserachievementsdeleteuserachievementid"></a>`userAchievementId` | [`AchievementsUserAchievementID!`](#achievementsuserachievementid) | 削除するユーザーアチーブメントのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuserachievementsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationuserachievementsdeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationuserachievementsdeleteuserachievement"></a>`userAchievement` | [`UserAchievement`](#userachievement) | 削除されたユーザーアチーブメント。 |

### `Mutation.userAchievementsUpdate`

{{< details >}}GitLab 17.3で**導入**。**状態**: 実験。{{< /details >}}

入力型: `UserAchievementsUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuserachievementsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationuserachievementsupdateshowonprofile"></a>`showOnProfile` | [`Boolean!`](#boolean) | ユーザーアチーブメントがプロフィールに表示されるかどうかを示します。 |
| <a id="mutationuserachievementsupdateuserachievementid"></a>`userAchievementId` | [`AchievementsUserAchievementID!`](#achievementsuserachievementid) | 更新するユーザーアチーブメントのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuserachievementsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationuserachievementsupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationuserachievementsupdateuserachievement"></a>`userAchievement` | [`UserAchievement`](#userachievement) | アチーブメントの授与。 |

### `Mutation.userAddOnAssignmentBulkCreate`

入力型: `UserAddOnAssignmentBulkCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentbulkcreateaddonpurchaseid"></a>`addOnPurchaseId` | [`GitlabSubscriptionsAddOnPurchaseID!`](#gitlabsubscriptionsaddonpurchaseid) | 割り当て先AddOnPurchaseのグローバルID。 |
| <a id="mutationuseraddonassignmentbulkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationuseraddonassignmentbulkcreateuserids"></a>`userIds` | [`[UserID!]!`](#userid) | 割り当てるユーザーのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentbulkcreateaddonpurchase"></a>`addOnPurchase` | [`AddOnPurchase`](#addonpurchase) | 変異後のAddOnPurchase状態。 |
| <a id="mutationuseraddonassignmentbulkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationuseraddonassignmentbulkcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.userAddOnAssignmentBulkRemove`

入力型: `UserAddOnAssignmentBulkRemoveInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentbulkremoveaddonpurchaseid"></a>`addOnPurchaseId` | [`GitlabSubscriptionsAddOnPurchaseID!`](#gitlabsubscriptionsaddonpurchaseid) | 割り当てを解除するAddOnPurchaseのグローバルID。 |
| <a id="mutationuseraddonassignmentbulkremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationuseraddonassignmentbulkremoveuserids"></a>`userIds` | [`[UserID!]!`](#userid) | 割り当てを解除するユーザーのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentbulkremoveaddonpurchase"></a>`addOnPurchase` | [`AddOnPurchase`](#addonpurchase) | 変異後のAddOnPurchase状態。 |
| <a id="mutationuseraddonassignmentbulkremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationuseraddonassignmentbulkremoveerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.userAddOnAssignmentCreate`

入力型: `UserAddOnAssignmentCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentcreateaddonpurchaseid"></a>`addOnPurchaseId` | [`GitlabSubscriptionsAddOnPurchaseID!`](#gitlabsubscriptionsaddonpurchaseid) | 割り当て先AddOnPurchaseのグローバルID。 |
| <a id="mutationuseraddonassignmentcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationuseraddonassignmentcreateuserid"></a>`userId` | [`UserID!`](#userid) | 割り当てるユーザーのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentcreateaddonpurchase"></a>`addOnPurchase` | [`AddOnPurchase`](#addonpurchase) | 変異後のAddOnPurchase状態。 |
| <a id="mutationuseraddonassignmentcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationuseraddonassignmentcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationuseraddonassignmentcreateuser"></a>`user` | [`AddOnUser`](#addonuser) | アドオン購入が割り当てられたユーザー。 |

### `Mutation.userAddOnAssignmentRemove`

入力型: `UserAddOnAssignmentRemoveInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentremoveaddonpurchaseid"></a>`addOnPurchaseId` | [`GitlabSubscriptionsAddOnPurchaseID!`](#gitlabsubscriptionsaddonpurchaseid) | AddOnPurchase割り当ての属するグローバルID。 |
| <a id="mutationuseraddonassignmentremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationuseraddonassignmentremoveuserid"></a>`userId` | [`UserID!`](#userid) | 割り当てを削除するユーザーのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentremoveaddonpurchase"></a>`addOnPurchase` | [`AddOnPurchase`](#addonpurchase) | 変異後のAddOnPurchase状態。 |
| <a id="mutationuseraddonassignmentremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationuseraddonassignmentremoveerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationuseraddonassignmentremoveuser"></a>`user` | [`AddOnUser`](#addonuser) | アドオンが削除されたユーザー。 |

### `Mutation.userCalloutCreate`

入力型: `UserCalloutCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationusercalloutcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationusercalloutcreatefeaturename"></a>`featureName` | [`String!`](#string) | コールアウトを非表示にする機能の名前。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationusercalloutcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationusercalloutcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationusercalloutcreateusercallout"></a>`userCallout` | [`UserCallout!`](#usercallout) | 非表示になったユーザーコールアウト。 |

### `Mutation.userPreferencesUpdate`

入力型: `UserPreferencesUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuserpreferencesupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationuserpreferencesupdateextensionsmarketplaceoptinstatus"></a>`extensionsMarketplaceOptInStatus` | [`ExtensionsMarketplaceOptInStatus`](#extensionsmarketplaceoptinstatus) | ユーザーのWeb IDE拡張機能マーケットプレースオプトインの状態。 |
| <a id="mutationuserpreferencesupdateissuessort"></a>`issuesSort` | [`IssueSort`](#issuesort) | イシューリストのソート順。 |
| <a id="mutationuserpreferencesupdatemergerequestdashboardlisttype"></a>`mergeRequestDashboardListType` | [`MergeRequestsDashboardListType`](#mergerequestsdashboardlisttype) | マージリクエストダッシュボードリストのレンダリングタイプ。 |
| <a id="mutationuserpreferencesupdatemergerequestssort"></a>`mergeRequestsSort` | [`MergeRequestSort`](#mergerequestsort) | イシューリストのソート順。 |
| <a id="mutationuserpreferencesupdateorganizationgroupsprojectsdisplay"></a>`organizationGroupsProjectsDisplay` {{< icon name="warning-solid" >}} | [`OrganizationGroupProjectDisplay`](#organizationgroupprojectdisplay) | **非推奨: ****状態**: 実験。GitLab 17.2で導入。 |
| <a id="mutationuserpreferencesupdateorganizationgroupsprojectssort"></a>`organizationGroupsProjectsSort` {{< icon name="warning-solid" >}} | [`OrganizationGroupProjectSort`](#organizationgroupprojectsort) | **非推奨: ****状態**: 実験。GitLab 17.2で導入。 |
| <a id="mutationuserpreferencesupdateprojectssort"></a>`projectsSort` | [`ProjectSort`](#projectsort) | プロジェクトのソート順。 |
| <a id="mutationuserpreferencesupdateuseworkitemsview"></a>`useWorkItemsView` | [`Boolean`](#boolean) | 従来のイシュービューではなく、作業アイテムビューを使用します。 |
| <a id="mutationuserpreferencesupdatevisibilitypipelineidtype"></a>`visibilityPipelineIdType` | [`VisibilityPipelineIdType`](#visibilitypipelineidtype) | パイプラインリストにIDまたはIIDを表示するかどうかを決定します。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuserpreferencesupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationuserpreferencesupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationuserpreferencesupdateuserpreferences"></a>`userPreferences` | [`UserPreferences`](#userpreferences) | 変異後のユーザープリファレンス。 |

### `Mutation.userSetNamespaceCommitEmail`

入力型: `UserSetNamespaceCommitEmailInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationusersetnamespacecommitemailclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationusersetnamespacecommitemailemailid"></a>`emailId` | [`EmailID`](#emailid) | 設定するメールのID。 |
| <a id="mutationusersetnamespacecommitemailnamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | ネームスペースコミットメールを設定する対象のネームスペースのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationusersetnamespacecommitemailclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationusersetnamespacecommitemailerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationusersetnamespacecommitemailnamespacecommitemail"></a>`namespaceCommitEmail` | [`NamespaceCommitEmail`](#namespacecommitemail) | 変異後のユーザーネームスペースコミットメール。 |

### `Mutation.valueStreamCreate`

バリューストリームを作成します。

{{< details >}}GitLab 16.6で**導入**。**状態**: 実験。{{< /details >}}

入力型: `ValueStreamCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvaluestreamcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvaluestreamcreatename"></a>`name` | [`String!`](#string) | バリューストリームの名前。 |
| <a id="mutationvaluestreamcreatenamespacepath"></a>`namespacePath` | [`ID!`](#id) | バリューストリームを作成するネームスペース（プロジェクトまたはグループ）のフルパス。 |
| <a id="mutationvaluestreamcreatesetting"></a>`setting` | [`ValueStreamSettingInput`](#valuestreamsettinginput) | バリューストリームの設定。 |
| <a id="mutationvaluestreamcreatestages"></a>`stages` | [`[ValueStreamStageInput!]`](#valuestreamstageinput) | バリューストリームのカスタムステージ。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvaluestreamcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvaluestreamcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationvaluestreamcreatevaluestream"></a>`valueStream` | [`ValueStream`](#valuestream) | 作成されたバリューストリーム。 |

### `Mutation.valueStreamDestroy`

バリューストリームを破棄します。

{{< details >}}GitLab 16.6で**導入**。**状態**: 実験。{{< /details >}}

入力型: `ValueStreamDestroyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvaluestreamdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvaluestreamdestroyid"></a>`id` | [`AnalyticsCycleAnalyticsValueStreamID!`](#analyticscycleanalyticsvaluestreamid) | 破棄するバリューストリームのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvaluestreamdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvaluestreamdestroyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationvaluestreamdestroyvaluestream"></a>`valueStream` | [`ValueStream`](#valuestream) | 変異後に削除されたバリューストリーム。 |

### `Mutation.valueStreamUpdate`

バリューストリームを更新します。

{{< details >}}GitLab 16.6で**導入**。**状態**: 実験。{{< /details >}}

入力型: `ValueStreamUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvaluestreamupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvaluestreamupdateid"></a>`id` | [`AnalyticsCycleAnalyticsValueStreamID!`](#analyticscycleanalyticsvaluestreamid) | 更新するバリューストリームのグローバルID。 |
| <a id="mutationvaluestreamupdatename"></a>`name` | [`String`](#string) | バリューストリームの名前。 |
| <a id="mutationvaluestreamupdatesetting"></a>`setting` | [`ValueStreamSettingInput`](#valuestreamsettinginput) | バリューストリームの設定。 |
| <a id="mutationvaluestreamupdatestages"></a>`stages` | [`[ValueStreamStageInput!]`](#valuestreamstageinput) | バリューストリームのカスタムステージ。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvaluestreamupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvaluestreamupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationvaluestreamupdatevaluestream"></a>`valueStream` | [`ValueStream`](#valuestream) | 更新されたバリューストリーム。 |

### `Mutation.verifiedNamespaceCreate`

検証済みのネームスペースを作成し、渡された検証レベル情報によるマークを、すべての子カタログリソースに付けます。

入力型: `VerifiedNamespaceCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationverifiednamespacecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationverifiednamespacecreatenamespacepath"></a>`namespacePath` | [`ID!`](#id) | ルートネームスペースパス。 |
| <a id="mutationverifiednamespacecreateverificationlevel"></a>`verificationLevel` | [`CiCatalogResourceVerificationLevel!`](#cicatalogresourceverificationlevel) | GitLabが提供するネームスペースの検証について示すために使用される検証レベル。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationverifiednamespacecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationverifiednamespacecreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.vulnerabilitiesArchive`

{{< details >}}GitLab 17.10で**導入**。**状態**: 実験。{{< /details >}}

入力型: `VulnerabilitiesArchiveInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiesarchiveclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilitiesarchivedate"></a>`date` | [`Date!`](#date) | アーカイブする脆弱性の最終更新日。 |
| <a id="mutationvulnerabilitiesarchiveprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | 脆弱性をアタッチする先のプロジェクトのID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiesarchiveclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilitiesarchiveerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationvulnerabilitiesarchivestatus"></a>`status` | [`String!`](#string) | アクションの状態。 |

### `Mutation.vulnerabilitiesCreateIssue`

{{< details >}}GitLab 17.9で**導入**。**状態**: 実験。{{< /details >}}

入力型: `VulnerabilitiesCreateIssueInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiescreateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilitiescreateissueproject"></a>`project` | [`ProjectID!`](#projectid) | イシューのアタッチ先プロジェクトのID。 |
| <a id="mutationvulnerabilitiescreateissuevulnerabilityids"></a>`vulnerabilityIds` | [`[VulnerabilityID!]!`](#vulnerabilityid) | 指定されたイシューにリンクする脆弱性のID。最大100個まで指定できます。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiescreateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilitiescreateissueerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationvulnerabilitiescreateissueissue"></a>`issue` | [`Issue`](#issue) | 変異後に作成されたイシュー。 |

### `Mutation.vulnerabilitiesDismiss`

入力型: `VulnerabilitiesDismissInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiesdismissclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilitiesdismisscomment"></a>`comment` | [`String`](#string) | 脆弱性が無視された理由についてのコメント（最大50,000文字）。 |
| <a id="mutationvulnerabilitiesdismissdismissalreason"></a>`dismissalReason` | [`VulnerabilityDismissalReason`](#vulnerabilitydismissalreason) | 脆弱性を無視する理由。 |
| <a id="mutationvulnerabilitiesdismissvulnerabilityids"></a>`vulnerabilityIds` | [`[VulnerabilityID!]!`](#vulnerabilityid) | 無視する脆弱性のID（最大100エントリ）。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiesdismissclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilitiesdismisserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationvulnerabilitiesdismissvulnerabilities"></a>`vulnerabilities` | [`[Vulnerability!]!`](#vulnerability) | 状態変更後の脆弱性。 |

### `Mutation.vulnerabilitiesRemoveAllFromProject`

特定のプロジェクトから、脆弱性および関連情報をすべて削除します。GitLab 16.7で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/412602)。

入力型: `VulnerabilitiesRemoveAllFromProjectInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiesremoveallfromprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilitiesremoveallfromprojectprojectids"></a>`projectIds` | [`[ProjectID!]!`](#projectid) | 脆弱性をすべて削除することが必要なプロジェクトのID。削除はバックグラウンドで実行されるため、すぐには変更が表示されません。 |
| <a id="mutationvulnerabilitiesremoveallfromprojectresolvedondefaultbranch"></a>`resolvedOnDefaultBranch` | [`Boolean`](#boolean) | `true`に設定すると、検出されなくなった脆弱性のみ削除します。`false`に設定すると、まだ検出される脆弱性のみを削除します。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiesremoveallfromprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilitiesremoveallfromprojecterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationvulnerabilitiesremoveallfromprojectprojects"></a>`projects` | [`[Project!]!`](#project) | 削除がスケジュールされたプロジェクト。 |

### `Mutation.vulnerabilitiesSeverityOverride`

入力型: `vulnerabilitiesSeverityOverrideInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiesseverityoverrideclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilitiesseverityoverridecomment"></a>`comment` | [`String!`](#string) | 脆弱性の重大度を変更した理由についてのコメント（最大50,000文字）。 |
| <a id="mutationvulnerabilitiesseverityoverrideseverity"></a>`severity` | [`VulnerabilitySeverity!`](#vulnerabilityseverity) | 重大度の新しい重大度値。 |
| <a id="mutationvulnerabilitiesseverityoverridevulnerabilityids"></a>`vulnerabilityIds` | [`[VulnerabilityID!]!`](#vulnerabilityid) | 重大度を変更することが必要な脆弱性のID （最大100エントリ）。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiesseverityoverrideclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilitiesseverityoverrideerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationvulnerabilitiesseverityoverridevulnerabilities"></a>`vulnerabilities` | [`[Vulnerability!]!`](#vulnerability) | 重大度変更後の脆弱性。 |

### `Mutation.vulnerabilityConfirm`

入力型: `VulnerabilityConfirmInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityconfirmclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilityconfirmcomment"></a>`comment` | [`String`](#string) | 脆弱性が確認された理由についてのコメント（最大50,000文字）。 |
| <a id="mutationvulnerabilityconfirmid"></a>`id` | [`VulnerabilityID!`](#vulnerabilityid) | 確認する脆弱性のID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityconfirmclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilityconfirmerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationvulnerabilityconfirmvulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | 状態変更後の脆弱性。 |

### `Mutation.vulnerabilityCreate`

入力型: `VulnerabilityCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilitycreateconfirmedat"></a>`confirmedAt` | [`Time`](#time) | 脆弱性の状態が確認済みに変わった時点のタイムスタンプ（状態が`confirmed`の場合のデフォルトは作成時刻）。 |
| <a id="mutationvulnerabilitycreatedescription"></a>`description` | [`String!`](#string) | 脆弱性をより詳細に説明する長いテキストセクション。 |
| <a id="mutationvulnerabilitycreatedetectedat"></a>`detectedAt` | [`Time`](#time) | 脆弱性が最初に検出された時点のタイムスタンプ（デフォルトは作成時刻）。 |
| <a id="mutationvulnerabilitycreatedismissedat"></a>`dismissedAt` | [`Time`](#time) | 脆弱性の状態が無視に変わった時点のタイムスタンプ（状態が`dismissed`の場合のデフォルトは作成時刻）。 |
| <a id="mutationvulnerabilitycreateidentifiers"></a>`identifiers` | [`[VulnerabilityIdentifierInput!]!`](#vulnerabilityidentifierinput) | 脆弱性のCVEまたはCWE識別子の配列。 |
| <a id="mutationvulnerabilitycreatename"></a>`name` | [`String!`](#string) | 脆弱性の名前。 |
| <a id="mutationvulnerabilitycreateproject"></a>`project` | [`ProjectID!`](#projectid) | 脆弱性をアタッチする先のプロジェクトのID。 |
| <a id="mutationvulnerabilitycreateresolvedat"></a>`resolvedAt` | [`Time`](#time) | 脆弱性の状態が解決済みに変わった時点のタイムスタンプ（状態が`resolved`の場合のデフォルトは作成時刻）。 |
| <a id="mutationvulnerabilitycreatescanner"></a>`scanner` | [`VulnerabilityScannerInput!`](#vulnerabilityscannerinput) | 脆弱性の発見に使用されたスキャナーに関する情報。 |
| <a id="mutationvulnerabilitycreateseverity"></a>`severity` | [`VulnerabilitySeverity`](#vulnerabilityseverity) | 脆弱性の重大度（デフォルトは`unknown`）。 |
| <a id="mutationvulnerabilitycreatesolution"></a>`solution` | [`String`](#string) | 脆弱性の修正方法についての説明。 |
| <a id="mutationvulnerabilitycreatestate"></a>`state` | [`VulnerabilityState`](#vulnerabilitystate) | 脆弱性の状態（デフォルトは`detected`）。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilitycreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationvulnerabilitycreatevulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | 作成された脆弱性。 |

### `Mutation.vulnerabilityDismiss`

入力型: `VulnerabilityDismissInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitydismissclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilitydismisscomment"></a>`comment` | [`String`](#string) | 脆弱性が無視された理由についてのコメント（最大50,000文字）。 |
| <a id="mutationvulnerabilitydismissdismissalreason"></a>`dismissalReason` | [`VulnerabilityDismissalReason`](#vulnerabilitydismissalreason) | 脆弱性を無視する理由。 |
| <a id="mutationvulnerabilitydismissid"></a>`id` | [`VulnerabilityID!`](#vulnerabilityid) | 無視する脆弱性のID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitydismissclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilitydismisserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationvulnerabilitydismissvulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | 状態変更後の脆弱性。 |

### `Mutation.vulnerabilityExternalIssueLinkCreate`

入力型: `VulnerabilityExternalIssueLinkCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityexternalissuelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilityexternalissuelinkcreateexternaltracker"></a>`externalTracker` | [`VulnerabilityExternalIssueLinkExternalTracker!`](#vulnerabilityexternalissuelinkexternaltracker) | 外部イシューリンクの外部トラッカータイプ。 |
| <a id="mutationvulnerabilityexternalissuelinkcreateid"></a>`id` | [`VulnerabilityID!`](#vulnerabilityid) | 脆弱性のID。 |
| <a id="mutationvulnerabilityexternalissuelinkcreatelinktype"></a>`linkType` | [`VulnerabilityExternalIssueLinkType!`](#vulnerabilityexternalissuelinktype) | 外部イシューリンクのタイプ。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityexternalissuelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilityexternalissuelinkcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationvulnerabilityexternalissuelinkcreateexternalissuelink"></a>`externalIssueLink` | [`VulnerabilityExternalIssueLink`](#vulnerabilityexternalissuelink) | 作成された外部イシューリンク。 |

### `Mutation.vulnerabilityExternalIssueLinkDestroy`

入力型: `VulnerabilityExternalIssueLinkDestroyInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityexternalissuelinkdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilityexternalissuelinkdestroyid"></a>`id` | [`VulnerabilitiesExternalIssueLinkID!`](#vulnerabilitiesexternalissuelinkid) | 脆弱性外部イシューリンクのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityexternalissuelinkdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilityexternalissuelinkdestroyerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `Mutation.vulnerabilityIssueLinkCreate`

入力型: `VulnerabilityIssueLinkCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityissuelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilityissuelinkcreateissueid"></a>`issueId` | [`IssueID!`](#issueid) | リンク先のイシューのID。 |
| <a id="mutationvulnerabilityissuelinkcreatevulnerabilityids"></a>`vulnerabilityIds` | [`[VulnerabilityID!]!`](#vulnerabilityid) | 指定されたイシューにリンクする脆弱性のID。最大100個まで指定できます。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityissuelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilityissuelinkcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationvulnerabilityissuelinkcreateissuelinks"></a>`issueLinks` | [`[VulnerabilityIssueLink!]`](#vulnerabilityissuelink) | 作成されたイシューリンク。 |

### `Mutation.vulnerabilityResolve`

入力型: `VulnerabilityResolveInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityresolveclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilityresolvecomment"></a>`comment` | [`String`](#string) | 脆弱性が解決された理由についてのコメント（最大50,000文字）。 |
| <a id="mutationvulnerabilityresolveid"></a>`id` | [`VulnerabilityID!`](#vulnerabilityid) | 解決する脆弱性のID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityresolveclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilityresolveerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationvulnerabilityresolvevulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | 状態変更後の脆弱性。 |

### `Mutation.vulnerabilityRevertToDetected`

入力型: `VulnerabilityRevertToDetectedInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityreverttodetectedclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilityreverttodetectedcomment"></a>`comment` | [`String`](#string) | 脆弱性がリバートされた理由についてのコメント（最大50,000文字）。 |
| <a id="mutationvulnerabilityreverttodetectedid"></a>`id` | [`VulnerabilityID!`](#vulnerabilityid) | 取り消して検出状態に戻す脆弱性のID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityreverttodetectedclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilityreverttodetectederrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationvulnerabilityreverttodetectedvulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | 状態変更後の脆弱性。 |

### `Mutation.workItemAddClosingMergeRequest`

クローズマージリクエストを作業アイテムに追加します。

{{< details >}}GitLab 17.1で**導入**。**状態**: 実験。{{< /details >}}

入力型: `WorkItemAddClosingMergeRequestInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemaddclosingmergerequestclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemaddclosingmergerequestcontextnamespacepath"></a>`contextNamespacePath` | [`ID`](#id) | コンテキストネームスペース（プロジェクトまたはグループ）のフルパス。`!1`などの短い参照構文を使用してマージリクエストを検索するために使用されるのは、プロジェクトのフルパスだけです。フルの参照とURLの場合は無視されます。指定されていない場合のデフォルトは、作業アイテムのネームスペースです。 |
| <a id="mutationworkitemaddclosingmergerequestid"></a>`id` | [`WorkItemID!`](#workitemid) | 作業アイテムのグローバルID。 |
| <a id="mutationworkitemaddclosingmergerequestmergerequestreference"></a>`mergeRequestReference` | [`String!`](#string) | マージリクエスト参照（短い、フル、またはURL）。例: `!1`、`project_full_path!1`、または`https://gitlab.com/gitlab-org/gitlab/-/merge_requests/1`。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemaddclosingmergerequestclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemaddclosingmergerequestclosingmergerequest"></a>`closingMergeRequest` | [`WorkItemClosingMergeRequest`](#workitemclosingmergerequest) | 作業アイテムに追加されたクローズマージリクエスト。 |
| <a id="mutationworkitemaddclosingmergerequesterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationworkitemaddclosingmergerequestworkitem"></a>`workItem` | [`WorkItem`](#workitem) | 新しいクローズマージリクエストを含む作業アイテム。 |

### `Mutation.workItemAddLinkedItems`

リンクされたアイテムを作業アイテムに追加します。

{{< details >}}GitLab 16.3で**導入**。**状態**: 実験。{{< /details >}}

入力型: `WorkItemAddLinkedItemsInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemaddlinkeditemsclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemaddlinkeditemsid"></a>`id` | [`WorkItemID!`](#workitemid) | 作業アイテムのグローバルID。 |
| <a id="mutationworkitemaddlinkeditemslinktype"></a>`linkType` | [`WorkItemRelatedLinkType`](#workitemrelatedlinktype) | リンクのタイプ。デフォルトは`RELATED`です。 |
| <a id="mutationworkitemaddlinkeditemsworkitemsids"></a>`workItemsIds` | [`[WorkItemID!]!`](#workitemid) | リンクするアイテムのグローバルID。指定できるIDの最大数: 10。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemaddlinkeditemsclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemaddlinkeditemserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationworkitemaddlinkeditemsmessage"></a>`message` | [`String`](#string) | リンクされたアイテムの更新結果メッセージ。 |
| <a id="mutationworkitemaddlinkeditemsworkitem"></a>`workItem` | [`WorkItem`](#workitem) | 更新された作業アイテム。 |

### `Mutation.workItemBulkUpdate`

イシューセットの複数プロパティの更新を許可します。`bulk_update_issues_mutation`機能フラグが無効になっている場合は、何もしません。

{{< details >}}GitLab 17.4で**導入**。**状態**: 実験。{{< /details >}}

入力型: `WorkItemBulkUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitembulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationworkitembulkupdateids"></a>`ids` | [`[WorkItemID!]!`](#workitemid) | 更新するイシューのグローバルID配列。ユーザーが更新できないIDは無視されます。最大100個まで指定できます。 |
| <a id="mutationworkitembulkupdatelabelswidget"></a>`labelsWidget` | [`WorkItemWidgetLabelsUpdateInput`](#workitemwidgetlabelsupdateinput) | ラベルウィジェットのインプット。 |
| <a id="mutationworkitembulkupdateparentid"></a>`parentId` | [`WorkItemsParentID!`](#workitemsparentid) | 一括更新のスコープとなる親のグローバルID。親としてプロジェクトも可能です。また親としてグループも可能です（PremiumおよびUltimateのみ）。例: `WorkItemsParentID`は`"gid://gitlab/Project/1"`と`"gid://gitlab/Group/1"`です。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitembulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationworkitembulkupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationworkitembulkupdateupdatedworkitemcount"></a>`updatedWorkItemCount` | [`Int`](#int) | 正常に更新された作業アイテムの数。 |

### `Mutation.workItemConvert`

作業アイテムを新しいタイプに変換します。

{{< details >}}GitLab 15.11で**導入**。**状態**: 実験。{{< /details >}}

入力型: `WorkItemConvertInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemconvertclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemconvertid"></a>`id` | [`WorkItemID!`](#workitemid) | 作業アイテムのグローバルID。 |
| <a id="mutationworkitemconvertworkitemtypeid"></a>`workItemTypeId` | [`WorkItemsTypeID!`](#workitemstypeid) | 新しい作業アイテムタイプのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemconvertclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemconverterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationworkitemconvertworkitem"></a>`workItem` | [`WorkItem`](#workitem) | 更新された作業アイテム。 |

### `Mutation.workItemCreate`

作業アイテムを作成します。

{{< details >}}GitLab 15.1で**導入**。**状態**: 実験。{{< /details >}}

入力型: `WorkItemCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemcreateassigneeswidget"></a>`assigneesWidget` | [`WorkItemWidgetAssigneesInput`](#workitemwidgetassigneesinput) | 担当者ウィジェットのインプット。 |
| <a id="mutationworkitemcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemcreatecolorwidget"></a>`colorWidget` | [`WorkItemWidgetColorInput`](#workitemwidgetcolorinput) | カラーウィジェットのインプット。 |
| <a id="mutationworkitemcreateconfidential"></a>`confidential` | [`Boolean`](#boolean) | 作業アイテムの機密性を設定します。 |
| <a id="mutationworkitemcreatecreatedat"></a>`createdAt` | [`Time`](#time) | 作業アイテム作成時のタイムスタンプ。管理者とプロジェクトオーナーのみが使用できます。 |
| <a id="mutationworkitemcreatecrmcontactswidget"></a>`crmContactsWidget` | [`WorkItemWidgetCrmContactsCreateInput`](#workitemwidgetcrmcontactscreateinput) | CRM連絡先ウィジェットのインプット。 |
| <a id="mutationworkitemcreatecustomfieldswidget"></a>`customFieldsWidget` {{< icon name="warning-solid" >}} | [`[WorkItemWidgetCustomFieldValueInputType!]`](#workitemwidgetcustomfieldvalueinputtype) | **非推奨: ****状態**: 実験。GitLab 17.10で導入。 |
| <a id="mutationworkitemcreatedescription"></a>`description` {{< icon name="warning-solid" >}} | [`String`](#string) | **非推奨:** 代わりに説明ウィジェットを使用してください。GitLab 16.9で非推奨になりました。 |
| <a id="mutationworkitemcreatedescriptionwidget"></a>`descriptionWidget` | [`WorkItemWidgetDescriptionInput`](#workitemwidgetdescriptioninput) | 説明ウィジェットのインプット。 |
| <a id="mutationworkitemcreatediscussionstoresolve"></a>`discussionsToResolve` | [`WorkItemResolveDiscussionsInput`](#workitemresolvediscussionsinput) | 作業アイテムの作成時に、noteable（ノート可能）内のディスカッションを解決するために必要な情報。 |
| <a id="mutationworkitemcreatehealthstatuswidget"></a>`healthStatusWidget` | [`WorkItemWidgetHealthStatusInput`](#workitemwidgethealthstatusinput) | ヘルスステータスウィジェットのインプット。 |
| <a id="mutationworkitemcreatehierarchywidget"></a>`hierarchyWidget` | [`WorkItemWidgetHierarchyCreateInput`](#workitemwidgethierarchycreateinput) | 階層ウィジェットのインプット。 |
| <a id="mutationworkitemcreateiterationwidget"></a>`iterationWidget` | [`WorkItemWidgetIterationInput`](#workitemwidgetiterationinput) | 作業アイテムのイテレーションウィジェット。 |
| <a id="mutationworkitemcreatelabelswidget"></a>`labelsWidget` | [`WorkItemWidgetLabelsCreateInput`](#workitemwidgetlabelscreateinput) | ラベルウィジェットのインプット。 |
| <a id="mutationworkitemcreatelinkeditemswidget"></a>`linkedItemsWidget` | [`WorkItemWidgetLinkedItemsCreateInput`](#workitemwidgetlinkeditemscreateinput) | リンクされたアイテムウィジェットのインプット。 |
| <a id="mutationworkitemcreatemilestonewidget"></a>`milestoneWidget` | [`WorkItemWidgetMilestoneInput`](#workitemwidgetmilestoneinput) | マイルストーンウィジェットのインプット。 |
| <a id="mutationworkitemcreatenamespacepath"></a>`namespacePath` | [`ID`](#id) | 作業アイテムを作成するネームスペース（プロジェクトまたはグループ）のフルパス。 |
| <a id="mutationworkitemcreateprojectpath"></a>`projectPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **非推奨: **代わりにnamespacePathを使用してください。これはプロジェクトとグループの両方をカバーします。GitLab 15.10で非推奨になりました。 |
| <a id="mutationworkitemcreatestartandduedatewidget"></a>`startAndDueDateWidget` | [`WorkItemWidgetStartAndDueDateUpdateInput`](#workitemwidgetstartandduedateupdateinput) | 開始日と期限ウィジェットのインプット。 |
| <a id="mutationworkitemcreatetitle"></a>`title` | [`String!`](#string) | 作業アイテムのタイトル。 |
| <a id="mutationworkitemcreatevulnerabilityid"></a>`vulnerabilityId` {{< icon name="warning-solid" >}} | [`VulnerabilityID`](#vulnerabilityid) | **非推奨: ****状態**: 実験。GitLab 17.9で導入。 |
| <a id="mutationworkitemcreateweightwidget"></a>`weightWidget` | [`WorkItemWidgetWeightInput`](#workitemwidgetweightinput) | ウェイトウィジェットのインプット。 |
| <a id="mutationworkitemcreateworkitemtypeid"></a>`workItemTypeId` | [`WorkItemsTypeID!`](#workitemstypeid) | 作業アイテムタイプのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemcreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationworkitemcreateworkitem"></a>`workItem` | [`WorkItem`](#workitem) | 作成された作業アイテム。 |

### `Mutation.workItemCreateFromTask`

別の作業アイテムの説明に含まれるタスクから作業アイテムを作成します。

{{< details >}}GitLab 15.1で**導入**。**状態**: 実験。{{< /details >}}

入力型: `WorkItemCreateFromTaskInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemcreatefromtaskclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemcreatefromtaskid"></a>`id` | [`WorkItemID!`](#workitemid) | 作業アイテムのグローバルID。 |
| <a id="mutationworkitemcreatefromtaskworkitemdata"></a>`workItemData` | [`WorkItemConvertTaskInput!`](#workitemconverttaskinput) | タスクを作業アイテムに変換するために必要な引数。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemcreatefromtaskclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemcreatefromtaskerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationworkitemcreatefromtasknewworkitem"></a>`newWorkItem` | [`WorkItem`](#workitem) | タスクから作成された新しい作業アイテム。 |
| <a id="mutationworkitemcreatefromtaskworkitem"></a>`workItem` | [`WorkItem`](#workitem) | 更新された作業アイテム。 |

### `Mutation.workItemDelete`

作業アイテムを削除します。

{{< details >}}GitLab 15.1で**導入**。**状態**: 実験。{{< /details >}}

入力型: `WorkItemDeleteInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemdeleteid"></a>`id` | [`WorkItemID!`](#workitemid) | 作業アイテムのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemdeleteerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationworkitemdeletenamespace"></a>`namespace` | [`Namespace`](#namespace) | 削除された作業アイテムが属していたネームスペース。 |
| <a id="mutationworkitemdeleteproject"></a>`project` {{< icon name="warning-solid" >}} | [`Project`](#project) | **非推奨: **`namespace`を使用してください。GitLab 16.9で非推奨になりました。 |

### `Mutation.workItemExport`

{{< details >}}GitLab 15.10で**導入**。**状態**: 実験。{{< /details >}}

入力型: `WorkItemExportInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemexportassigneeusernames"></a>`assigneeUsernames` | [`[String!]`](#string) | 作業アイテムに割り当てられているユーザーのユーザー名。 |
| <a id="mutationworkitemexportassigneewildcardid"></a>`assigneeWildcardId` | [`AssigneeWildcardId`](#assigneewildcardid) | 割り当て先ユーザーのワイルドカードでフィルタリングします。`assigneeUsernames`と互換性がありません。 |
| <a id="mutationworkitemexportauthorusername"></a>`authorUsername` | [`String`](#string) | 作業アイテムを作成者のユーザー名でフィルタリングします。 |
| <a id="mutationworkitemexportclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemexportclosedafter"></a>`closedAfter` | [`Time`](#time) | 指定日より後にクローズされた作業アイテム。 |
| <a id="mutationworkitemexportclosedbefore"></a>`closedBefore` | [`Time`](#time) | 指定日より前にクローズされた作業アイテム。 |
| <a id="mutationworkitemexportconfidential"></a>`confidential` | [`Boolean`](#boolean) | 機密情報作業アイテムをフィルタリングします。`false`の場合、機密情報作業アイテムを除外します。`true`の場合、機密情報作業アイテムのみ返します。 |
| <a id="mutationworkitemexportcreatedafter"></a>`createdAfter` | [`Time`](#time) | 指定タイムスタンプより後に作成された作業アイテム。 |
| <a id="mutationworkitemexportcreatedbefore"></a>`createdBefore` | [`Time`](#time) | 指定タイムスタンプより前に作成された作業アイテム。 |
| <a id="mutationworkitemexportdueafter"></a>`dueAfter` | [`Time`](#time) | 指定タイムスタンプより後に期限切れになる作業アイテム。 |
| <a id="mutationworkitemexportduebefore"></a>`dueBefore` | [`Time`](#time) | 指定タイムスタンプより前に期限切れになる作業アイテム。 |
| <a id="mutationworkitemexportiids"></a>`iids` | [`[String!]`](#string) | 作業アイテムのIIDのリスト。例：`["1", "2"]`。 |
| <a id="mutationworkitemexportin"></a>`in` | [`[IssuableSearchableField!]`](#issuablesearchablefield) | 検索を実行するフィールドを指定します。デフォルトは`[TITLE, DESCRIPTION]`です。`search`引数が必要です。 |
| <a id="mutationworkitemexportlabelname"></a>`labelName` | [`[String!]`](#string) | 作業アイテムに適用されるラベル。 |
| <a id="mutationworkitemexportmilestonetitle"></a>`milestoneTitle` | [`[String!]`](#string) | 作業アイテムに適用されるマイルストーン。 |
| <a id="mutationworkitemexportmilestonewildcardid"></a>`milestoneWildcardId` | [`MilestoneWildcardId`](#milestonewildcardid) | マイルストーンIDのワイルドカードでフィルタリングします。`milestoneTitle`と互換性がありません。 |
| <a id="mutationworkitemexportmyreactionemoji"></a>`myReactionEmoji` | [`String`](#string) | 現在のユーザーが適用したリアクション絵文字でフィルタリングします。ワイルドカード値として`NONE`と`ANY`がサポートされています。 |
| <a id="mutationworkitemexportnot"></a>`not` | [`NegatedWorkItemFilterInput`](#negatedworkitemfilterinput) | 否定条件となる作業アイテム引数。 |
| <a id="mutationworkitemexportor"></a>`or` | [`UnionedWorkItemFilterInput`](#unionedworkitemfilterinput) | 引数のリストのインクルーシブ`OR`結合。 |
| <a id="mutationworkitemexportprojectpath"></a>`projectPath` | [`ID!`](#id) | プロジェクトのフルパス。 |
| <a id="mutationworkitemexportsearch"></a>`search` | [`String`](#string) | タイトルまたは説明の検索クエリ。 |
| <a id="mutationworkitemexportselectedfields"></a>`selectedFields` | [`[AvailableExportFields!]`](#availableexportfields) | エクスポート対象として選択されたフィールドのリスト。省略すると、利用可能なすべてのフィールドがエクスポートされます。 |
| <a id="mutationworkitemexportstate"></a>`state` | [`IssuableState`](#issuablestate) | 作業アイテムの現在の状態。 |
| <a id="mutationworkitemexportsubscribed"></a>`subscribed` | [`SubscriptionStatus`](#subscriptionstatus) | 現在のユーザーがサブスクライブしている作業アイテム。 |
| <a id="mutationworkitemexporttypes"></a>`types` | [`[IssueType!]`](#issuetype) | 作業アイテムを指定された作業アイテムタイプでフィルタリングします。 |
| <a id="mutationworkitemexportupdatedafter"></a>`updatedAfter` | [`Time`](#time) | 指定タイムスタンプより後に更新された作業アイテム。 |
| <a id="mutationworkitemexportupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | 指定タイムスタンプより前に更新された作業アイテム。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemexportclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemexporterrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationworkitemexportmessage"></a>`message` | [`String`](#string) | エクスポートリクエストの結果メッセージ。 |

### `Mutation.workItemRemoveLinkedItems`

作業アイテムにリンクされているアイテムを削除します。

{{< details >}}GitLab 16.3で**導入**。**状態**: 実験。{{< /details >}}

入力型: `WorkItemRemoveLinkedItemsInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemremovelinkeditemsclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemremovelinkeditemsid"></a>`id` | [`WorkItemID!`](#workitemid) | 作業アイテムのグローバルID。 |
| <a id="mutationworkitemremovelinkeditemsworkitemsids"></a>`workItemsIds` | [`[WorkItemID!]!`](#workitemid) | リンクを解除するアイテムのグローバルID。指定できるIDの最大数: 10。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemremovelinkeditemsclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemremovelinkeditemserrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationworkitemremovelinkeditemsmessage"></a>`message` | [`String`](#string) | リンクされたアイテムの更新結果メッセージ。 |
| <a id="mutationworkitemremovelinkeditemsworkitem"></a>`workItem` | [`WorkItem`](#workitem) | 更新された作業アイテム。 |

### `Mutation.workItemSubscribe`

{{< details >}}GitLab 16.3で**導入**。**状態**: 実験。{{< /details >}}

入力型: `WorkItemSubscribeInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemsubscribeclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemsubscribeid"></a>`id` | [`WorkItemID!`](#workitemid) | 作業アイテムのグローバルID。 |
| <a id="mutationworkitemsubscribesubscribed"></a>`subscribed` | [`Boolean!`](#boolean) | 目的とするサブスクリプションの状態。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemsubscribeclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemsubscribeerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationworkitemsubscribeworkitem"></a>`workItem` | [`WorkItem`](#workitem) | 変異後の作業アイテム。 |

### `Mutation.workItemUpdate`

グローバルIDで作業アイテムを更新します。

{{< details >}}GitLab 15.1で**導入**。**状態**: 実験。{{< /details >}}

入力型: `WorkItemUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemupdateassigneeswidget"></a>`assigneesWidget` | [`WorkItemWidgetAssigneesInput`](#workitemwidgetassigneesinput) | 担当者ウィジェットのインプット。 |
| <a id="mutationworkitemupdateawardemojiwidget"></a>`awardEmojiWidget` | [`WorkItemWidgetAwardEmojiUpdateInput`](#workitemwidgetawardemojiupdateinput) | 絵文字リアクションウィジェットのインプット。 |
| <a id="mutationworkitemupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemupdatecolorwidget"></a>`colorWidget` | [`WorkItemWidgetColorInput`](#workitemwidgetcolorinput) | カラーウィジェットのインプット。 |
| <a id="mutationworkitemupdateconfidential"></a>`confidential` | [`Boolean`](#boolean) | 作業アイテムの機密性を設定します。 |
| <a id="mutationworkitemupdatecrmcontactswidget"></a>`crmContactsWidget` | [`WorkItemWidgetCrmContactsUpdateInput`](#workitemwidgetcrmcontactsupdateinput) | CRM連絡先ウィジェットのインプット。 |
| <a id="mutationworkitemupdatecurrentusertodoswidget"></a>`currentUserTodosWidget` | [`WorkItemWidgetCurrentUserTodosInput`](#workitemwidgetcurrentusertodosinput) | To Doウィジェットのインプット。 |
| <a id="mutationworkitemupdatecustomfieldswidget"></a>`customFieldsWidget` {{< icon name="warning-solid" >}} | [`[WorkItemWidgetCustomFieldValueInputType!]`](#workitemwidgetcustomfieldvalueinputtype) | **非推奨: ****状態**: 実験。GitLab 17.10で導入。 |
| <a id="mutationworkitemupdatedescriptionwidget"></a>`descriptionWidget` | [`WorkItemWidgetDescriptionInput`](#workitemwidgetdescriptioninput) | 説明ウィジェットのインプット。 |
| <a id="mutationworkitemupdatehealthstatuswidget"></a>`healthStatusWidget` | [`WorkItemWidgetHealthStatusInput`](#workitemwidgethealthstatusinput) | ヘルスステータスウィジェットのインプット。 |
| <a id="mutationworkitemupdatehierarchywidget"></a>`hierarchyWidget` | [`WorkItemWidgetHierarchyUpdateInput`](#workitemwidgethierarchyupdateinput) | 階層ウィジェットのインプット。 |
| <a id="mutationworkitemupdateid"></a>`id` | [`WorkItemID!`](#workitemid) | 作業アイテムのグローバルID。 |
| <a id="mutationworkitemupdateiterationwidget"></a>`iterationWidget` | [`WorkItemWidgetIterationInput`](#workitemwidgetiterationinput) | イテレーションウィジェットのインプット。 |
| <a id="mutationworkitemupdatelabelswidget"></a>`labelsWidget` | [`WorkItemWidgetLabelsUpdateInput`](#workitemwidgetlabelsupdateinput) | ラベルウィジェットのインプット。 |
| <a id="mutationworkitemupdatemilestonewidget"></a>`milestoneWidget` | [`WorkItemWidgetMilestoneInput`](#workitemwidgetmilestoneinput) | マイルストーンウィジェットのインプット。 |
| <a id="mutationworkitemupdatenoteswidget"></a>`notesWidget` | [`WorkItemWidgetNotesInput`](#workitemwidgetnotesinput) | ノートウィジェットのインプット。 |
| <a id="mutationworkitemupdatenotificationswidget"></a>`notificationsWidget` | [`WorkItemWidgetNotificationsUpdateInput`](#workitemwidgetnotificationsupdateinput) | 通知ウィジェットのインプット。 |
| <a id="mutationworkitemupdateprogresswidget"></a>`progressWidget` | [`WorkItemWidgetProgressInput`](#workitemwidgetprogressinput) | 進捗状況ウィジェットのインプット。 |
| <a id="mutationworkitemupdatestartandduedatewidget"></a>`startAndDueDateWidget` | [`WorkItemWidgetStartAndDueDateUpdateInput`](#workitemwidgetstartandduedateupdateinput) | 開始日と期限ウィジェットのインプット。 |
| <a id="mutationworkitemupdatestateevent"></a>`stateEvent` | [`WorkItemStateEvent`](#workitemstateevent) | 作業アイテムをクローズまたは再オープンします。 |
| <a id="mutationworkitemupdatetimetrackingwidget"></a>`timeTrackingWidget` | [`WorkItemWidgetTimeTrackingInput`](#workitemwidgettimetrackinginput) | タイムトラッキングウィジェットのインプット。 |
| <a id="mutationworkitemupdatetitle"></a>`title` | [`String`](#string) | 作業アイテムのタイトル。 |
| <a id="mutationworkitemupdateverificationstatuswidget"></a>`verificationStatusWidget` | [`VerificationStatusInput`](#verificationstatusinput) | 検証状態ウィジェットのインプット。 |
| <a id="mutationworkitemupdateweightwidget"></a>`weightWidget` | [`WorkItemWidgetWeightInput`](#workitemwidgetweightinput) | ウェイトウィジェットのインプット。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationworkitemupdateworkitem"></a>`workItem` | [`WorkItem`](#workitem) | 更新された作業アイテム。 |

### `Mutation.workItemUserPreferenceUpdate`

作業アイテムタイプとネームスペースのユーザープリファレンスを作成または更新します。

{{< details >}}GitLab 17.10で**導入**。**状態**: 実験。{{< /details >}}

入力型: `WorkItemUserPreferenceUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemuserpreferenceupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemuserpreferenceupdatenamespacepath"></a>`namespacePath` | [`ID!`](#id) | プリファレンスを設定するネームスペースのフルパス。 |
| <a id="mutationworkitemuserpreferenceupdatesort"></a>`sort` | [`WorkItemSort`](#workitemsort) | 作業アイテムリストのソート順。 |
| <a id="mutationworkitemuserpreferenceupdateworkitemtypeid"></a>`workItemTypeId` | [`WorkItemsTypeID`](#workitemstypeid) | 作業アイテムタイプのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemuserpreferenceupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemuserpreferenceupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationworkitemuserpreferenceupdateuserpreferences"></a>`userPreferences` | [`WorkItemTypesUserPreference`](#workitemtypesuserpreference) | ユーザープリファレンス。 |

### `Mutation.workItemsHierarchyReorder`

階層ツリー内の作業アイテムを並べ替えます。

{{< details >}}GitLab 17.3で**導入**。**状態**: 実験。{{< /details >}}

入力型: `workItemsHierarchyReorderInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemshierarchyreorderadjacentworkitemid"></a>`adjacentWorkItemId` | [`WorkItemID`](#workitemid) | 次に移動する作業アイテムのID。上のアイテムや下のアイテムなど。 |
| <a id="mutationworkitemshierarchyreorderclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemshierarchyreorderid"></a>`id` | [`WorkItemID!`](#workitemid) | 並べ替える作業アイテムのグローバルID。 |
| <a id="mutationworkitemshierarchyreorderparentid"></a>`parentId` | [`WorkItemID`](#workitemid) | 新しい親作業アイテムのグローバルID。 |
| <a id="mutationworkitemshierarchyreorderrelativeposition"></a>`relativePosition` | [`RelativePositionType`](#relativepositiontype) | 隣接作業アイテムを基準とする相対位置。有効な値は、`BEFORE`または`AFTER`です。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemshierarchyreorderadjacentworkitem"></a>`adjacentWorkItem` | [`WorkItem`](#workitem) | 変異後の隣接作業アイテム。 |
| <a id="mutationworkitemshierarchyreorderclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemshierarchyreordererrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationworkitemshierarchyreorderparentworkitem"></a>`parentWorkItem` | [`WorkItem`](#workitem) | 変異後の作業アイテムの親。 |
| <a id="mutationworkitemshierarchyreorderworkitem"></a>`workItem` | [`WorkItem`](#workitem) | 変異後の作業アイテム。 |

### `Mutation.workspaceCreate`

入力型: `WorkspaceCreateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkspacecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationworkspacecreateclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID!`](#clustersagentid) | 作成されたワークスペースが関連付けられるクラスターエージェントのGlobalID。 |
| <a id="mutationworkspacecreatedesiredstate"></a>`desiredState` | [`String!`](#string) | 作成されたワークスペースの状態の希望値。 |
| <a id="mutationworkspacecreatedevfilepath"></a>`devfilePath` | [`String`](#string) | ワークスペースの設定に使用するdevfileを含むプロジェクトパス。指定されていない場合、GitLabのデフォルトdevfileが使用されます。 |
| <a id="mutationworkspacecreatedevfileref"></a>`devfileRef` {{< icon name="warning-solid" >}} | [`String`](#string) | **非推奨: **引数の名前がproject_refに変更されました。GitLab 17.8で非推奨になりました。 |
| <a id="mutationworkspacecreateeditor"></a>`editor` {{< icon name="warning-solid" >}} | [`String`](#string) | **非推奨: **引数は使用されません。GitLab 17.5で非推奨になりました。 |
| <a id="mutationworkspacecreatemaxhoursbeforetermination"></a>`maxHoursBeforeTermination` {{< icon name="warning-solid" >}} | [`Int`](#int) | **非推奨: **フィールドは使用されていません。GitLab 17.9で非推奨になりました。 |
| <a id="mutationworkspacecreateprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | 作成されたワークスペースのdevfileを提供するプロジェクトのID。 |
| <a id="mutationworkspacecreateprojectref"></a>`projectRef` | [`String`](#string) | プロジェクトリポジトリのgit ref。 |
| <a id="mutationworkspacecreatevariables"></a>`variables` | [`[WorkspaceVariableInput!]`](#workspacevariableinput) | ワークスペースに挿入する変数。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkspacecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationworkspacecreateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationworkspacecreateworkspace"></a>`workspace` | [`Workspace`](#workspace) | 作成されたワークスペース。 |

### `Mutation.workspaceUpdate`

入力型: `WorkspaceUpdateInput`

#### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkspaceupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationworkspaceupdatedesiredstate"></a>`desiredState` | [`String!`](#string) | 作成されたワークスペースの状態の希望値。 |
| <a id="mutationworkspaceupdateid"></a>`id` | [`RemoteDevelopmentWorkspaceID!`](#remotedevelopmentworkspaceid) | ワークスペースのグローバルID。 |

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkspaceupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="mutationworkspaceupdateerrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="mutationworkspaceupdateworkspace"></a>`workspace` | [`Workspace`](#workspace) | 作成されたワークスペース。 |

## 接続

スキーマ内の一部の型は`Connection`型です。これらは、グラフ内の2つのノード間のエッジのページネーションコレクションを表します。これらは、[Relayカーソル接続仕様](https://relay.dev/graphql/connections.htm)に従います。

### ページネーション引数

どの接続フィールドも、次のページネーション引数をサポートしています。

| 名前 | 型 | 説明 |
|------|------|-------------|
| `after` | [`String`](#string) | リストのうち指定されたカーソルより後にある要素を返します。 |
| `before` | [`String`](#string) | リストのうち指定されたカーソルより前にある要素を返します。 |
| `first` | [`Int`](#int) | リストのうち最初の_n_個の要素を返します。 |
| `last` | [`Int`](#int) | リストのうち最後の_n_個の要素を返します。 |

これらの引数はすべての接続フィールドに共通であるため、接続ごとに繰り返されることはありません。

### 接続フィールド

すべての接続には、少なくとも次のフィールドがあります。

| 名前 | 型 | 説明 |
|------|------|-------------|
| `pageInfo` | [`PageInfo!`](#pageinfo) | ページネーション情報。 |
| `edges` | `[edge!]` | エッジ。 |
| `nodes` | `[item!]` | 現在のページのアイテム。 |

`Edge`と`Item`の正確な型は、接続のタイプによって異なります。[`ProjectConnection`](#projectconnection)には、[`[Project!]`](#project)型のノードと、[`ProjectEdge`](#projectedge)型のエッジがあります。

### 接続のタイプ

スキーマ内の一部のタイプは、接続のモデル化のためだけに存在しています。各接続には、固有の名前付きタイプと、固有の名前付きエッジタイプがあります。これらについては、別個に下記のリストに示します。

#### `AbuseReportDiscussionConnection`

[`AbuseReportDiscussion`](#abusereportdiscussion)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="abusereportdiscussionconnectionedges"></a>`edges` | [`[AbuseReportDiscussionEdge]`](#abusereportdiscussionedge) | エッジのリスト。 |
| <a id="abusereportdiscussionconnectionnodes"></a>`nodes` | [`[AbuseReportDiscussion]`](#abusereportdiscussion) | ノードのリスト。 |
| <a id="abusereportdiscussionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AbuseReportDiscussionEdge`

[`AbuseReportDiscussion`](#abusereportdiscussion)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="abusereportdiscussionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="abusereportdiscussionedgenode"></a>`node` | [`AbuseReportDiscussion`](#abusereportdiscussion) | エッジの終端にあるアイテム。 |

#### `AbuseReportLabelConnection`

[`AbuseReportLabel`](#abusereportlabel)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="abusereportlabelconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="abusereportlabelconnectionedges"></a>`edges` | [`[AbuseReportLabelEdge]`](#abusereportlabeledge) | エッジのリスト。 |
| <a id="abusereportlabelconnectionnodes"></a>`nodes` | [`[AbuseReportLabel]`](#abusereportlabel) | ノードのリスト。 |
| <a id="abusereportlabelconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AbuseReportLabelEdge`

[`AbuseReportLabel`](#abusereportlabel)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="abusereportlabeledgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="abusereportlabeledgenode"></a>`node` | [`AbuseReportLabel`](#abusereportlabel) | エッジの終端にあるアイテム。 |

#### `AbuseReportNoteConnection`

[`AbuseReportNote`](#abusereportnote)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="abusereportnoteconnectionedges"></a>`edges` | [`[AbuseReportNoteEdge]`](#abusereportnoteedge) | エッジのリスト。 |
| <a id="abusereportnoteconnectionnodes"></a>`nodes` | [`[AbuseReportNote]`](#abusereportnote) | ノードのリスト。 |
| <a id="abusereportnoteconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AbuseReportNoteEdge`

[`AbuseReportNote`](#abusereportnote)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="abusereportnoteedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="abusereportnoteedgenode"></a>`node` | [`AbuseReportNote`](#abusereportnote) | エッジの終端にあるアイテム。 |

#### `AccessLevelDeployKeyConnection`

[`AccessLevelDeployKey`](#accessleveldeploykey)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="accessleveldeploykeyconnectionedges"></a>`edges` | [`[AccessLevelDeployKeyEdge]`](#accessleveldeploykeyedge) | エッジのリスト。 |
| <a id="accessleveldeploykeyconnectionnodes"></a>`nodes` | [`[AccessLevelDeployKey]`](#accessleveldeploykey) | ノードのリスト。 |
| <a id="accessleveldeploykeyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AccessLevelDeployKeyEdge`

[`AccessLevelDeployKey`](#accessleveldeploykey)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="accessleveldeploykeyedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="accessleveldeploykeyedgenode"></a>`node` | [`AccessLevelDeployKey`](#accessleveldeploykey) | エッジの終端にあるアイテム。 |

#### `AchievementConnection`

[`Achievement`](#achievement)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="achievementconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="achievementconnectionedges"></a>`edges` | [`[AchievementEdge]`](#achievementedge) | エッジのリスト。 |
| <a id="achievementconnectionnodes"></a>`nodes` | [`[Achievement]`](#achievement) | ノードのリスト。 |
| <a id="achievementconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AchievementEdge`

[`Achievement`](#achievement)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="achievementedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="achievementedgenode"></a>`node` | [`Achievement`](#achievement) | エッジの終端にあるアイテム。 |

#### `AddOnUserConnection`

[`AddOnUser`](#addonuser)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="addonuserconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="addonuserconnectionedges"></a>`edges` | [`[AddOnUserEdge]`](#addonuseredge) | エッジのリスト。 |
| <a id="addonuserconnectionnodes"></a>`nodes` | [`[AddOnUser]`](#addonuser) | ノードのリスト。 |
| <a id="addonuserconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AddOnUserEdge`

[`AddOnUser`](#addonuser)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="addonuseredgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="addonuseredgenode"></a>`node` | [`AddOnUser`](#addonuser) | エッジの終端にあるアイテム。 |

#### `AdminMemberRoleConnection`

[`AdminMemberRole`](#adminmemberrole)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="adminmemberroleconnectionedges"></a>`edges` | [`[AdminMemberRoleEdge]`](#adminmemberroleedge) | エッジのリスト。 |
| <a id="adminmemberroleconnectionnodes"></a>`nodes` | [`[AdminMemberRole]`](#adminmemberrole) | ノードのリスト。 |
| <a id="adminmemberroleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AdminMemberRoleEdge`

[`AdminMemberRole`](#adminmemberrole)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="adminmemberroleedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="adminmemberroleedgenode"></a>`node` | [`AdminMemberRole`](#adminmemberrole) | エッジの終端にあるアイテム。 |

#### `AgentConfigurationConnection`

[`AgentConfiguration`](#agentconfiguration)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="agentconfigurationconnectionedges"></a>`edges` | [`[AgentConfigurationEdge]`](#agentconfigurationedge) | エッジのリスト。 |
| <a id="agentconfigurationconnectionnodes"></a>`nodes` | [`[AgentConfiguration]`](#agentconfiguration) | ノードのリスト。 |
| <a id="agentconfigurationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AgentConfigurationEdge`

[`AgentConfiguration`](#agentconfiguration)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="agentconfigurationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="agentconfigurationedgenode"></a>`node` | [`AgentConfiguration`](#agentconfiguration) | エッジの終端にあるアイテム。 |

#### `AiAgentConnection`

[`AiAgent`](#aiagent)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aiagentconnectionedges"></a>`edges` | [`[AiAgentEdge]`](#aiagentedge) | エッジのリスト。 |
| <a id="aiagentconnectionnodes"></a>`nodes` | [`[AiAgent]`](#aiagent) | ノードのリスト。 |
| <a id="aiagentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AiAgentEdge`

[`AiAgent`](#aiagent)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aiagentedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="aiagentedgenode"></a>`node` | [`AiAgent`](#aiagent) | エッジの終端にあるアイテム。 |

#### `AiConversationsThreadConnection`

[`AiConversationsThread`](#aiconversationsthread)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aiconversationsthreadconnectionedges"></a>`edges` | [`[AiConversationsThreadEdge]`](#aiconversationsthreadedge) | エッジのリスト。 |
| <a id="aiconversationsthreadconnectionnodes"></a>`nodes` | [`[AiConversationsThread]`](#aiconversationsthread) | ノードのリスト。 |
| <a id="aiconversationsthreadconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AiConversationsThreadEdge`

[`AiConversationsThread`](#aiconversationsthread)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aiconversationsthreadedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="aiconversationsthreadedgenode"></a>`node` | [`AiConversationsThread`](#aiconversationsthread) | エッジの終端にあるアイテム。 |

#### `AiFeatureSettingConnection`

[`AiFeatureSetting`](#aifeaturesetting)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aifeaturesettingconnectionedges"></a>`edges` | [`[AiFeatureSettingEdge]`](#aifeaturesettingedge) | エッジのリスト。 |
| <a id="aifeaturesettingconnectionnodes"></a>`nodes` | [`[AiFeatureSetting]`](#aifeaturesetting) | ノードのリスト。 |
| <a id="aifeaturesettingconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AiFeatureSettingEdge`

[`AiFeatureSetting`](#aifeaturesetting)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aifeaturesettingedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="aifeaturesettingedgenode"></a>`node` | [`AiFeatureSetting`](#aifeaturesetting) | エッジの終端にあるアイテム。 |

#### `AiMessageConnection`

[`AiMessage`](#aimessage)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aimessageconnectionedges"></a>`edges` | [`[AiMessageEdge]`](#aimessageedge) | エッジのリスト。 |
| <a id="aimessageconnectionnodes"></a>`nodes` | [`[AiMessage]`](#aimessage) | ノードのリスト。 |
| <a id="aimessageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AiMessageEdge`

[`AiMessage`](#aimessage)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aimessageedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="aimessageedgenode"></a>`node` | [`AiMessage`](#aimessage) | エッジの終端にあるアイテム。 |

#### `AiSelfHostedModelConnection`

[`AiSelfHostedModel`](#aiselfhostedmodel)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aiselfhostedmodelconnectionedges"></a>`edges` | [`[AiSelfHostedModelEdge]`](#aiselfhostedmodeledge) | エッジのリスト。 |
| <a id="aiselfhostedmodelconnectionnodes"></a>`nodes` | [`[AiSelfHostedModel]`](#aiselfhostedmodel) | ノードのリスト。 |
| <a id="aiselfhostedmodelconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AiSelfHostedModelEdge`

[`AiSelfHostedModel`](#aiselfhostedmodel)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aiselfhostedmodeledgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="aiselfhostedmodeledgenode"></a>`node` | [`AiSelfHostedModel`](#aiselfhostedmodel) | エッジの終端にあるアイテム。 |

#### `AiUserMetricsConnection`

[`AiUserMetrics`](#aiusermetrics)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aiusermetricsconnectionedges"></a>`edges` | [`[AiUserMetricsEdge]`](#aiusermetricsedge) | エッジのリスト。 |
| <a id="aiusermetricsconnectionnodes"></a>`nodes` | [`[AiUserMetrics]`](#aiusermetrics) | ノードのリスト。 |
| <a id="aiusermetricsconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AiUserMetricsEdge`

[`AiUserMetrics`](#aiusermetrics)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aiusermetricsedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="aiusermetricsedgenode"></a>`node` | [`AiUserMetrics`](#aiusermetrics) | エッジの終端にあるアイテム。 |

#### `AiXrayReportConnection`

[`AiXrayReport`](#aixrayreport)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aixrayreportconnectionedges"></a>`edges` | [`[AiXrayReportEdge]`](#aixrayreportedge) | エッジのリスト。 |
| <a id="aixrayreportconnectionnodes"></a>`nodes` | [`[AiXrayReport]`](#aixrayreport) | ノードのリスト。 |
| <a id="aixrayreportconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AiXrayReportEdge`

[`AiXrayReport`](#aixrayreport)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aixrayreportedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="aixrayreportedgenode"></a>`node` | [`AiXrayReport`](#aixrayreport) | エッジの終端にあるアイテム。 |

#### `AlertManagementAlertConnection`

[`AlertManagementAlert`](#alertmanagementalert)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="alertmanagementalertconnectionedges"></a>`edges` | [`[AlertManagementAlertEdge]`](#alertmanagementalertedge) | エッジのリスト。 |
| <a id="alertmanagementalertconnectionnodes"></a>`nodes` | [`[AlertManagementAlert]`](#alertmanagementalert) | ノードのリスト。 |
| <a id="alertmanagementalertconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AlertManagementAlertEdge`

[`AlertManagementAlert`](#alertmanagementalert)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="alertmanagementalertedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="alertmanagementalertedgenode"></a>`node` | [`AlertManagementAlert`](#alertmanagementalert) | エッジの終端にあるアイテム。 |

#### `AlertManagementHttpIntegrationConnection`

[`AlertManagementHttpIntegration`](#alertmanagementhttpintegration)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="alertmanagementhttpintegrationconnectionedges"></a>`edges` | [`[AlertManagementHttpIntegrationEdge]`](#alertmanagementhttpintegrationedge) | エッジのリスト。 |
| <a id="alertmanagementhttpintegrationconnectionnodes"></a>`nodes` | [`[AlertManagementHttpIntegration]`](#alertmanagementhttpintegration) | ノードのリスト。 |
| <a id="alertmanagementhttpintegrationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AlertManagementHttpIntegrationEdge`

[`AlertManagementHttpIntegration`](#alertmanagementhttpintegration)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="alertmanagementhttpintegrationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="alertmanagementhttpintegrationedgenode"></a>`node` | [`AlertManagementHttpIntegration`](#alertmanagementhttpintegration) | エッジの終端にあるアイテム。 |

#### `AlertManagementIntegrationConnection`

[`AlertManagementIntegration`](#alertmanagementintegration)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="alertmanagementintegrationconnectionedges"></a>`edges` | [`[AlertManagementIntegrationEdge]`](#alertmanagementintegrationedge) | エッジのリスト。 |
| <a id="alertmanagementintegrationconnectionnodes"></a>`nodes` | [`[AlertManagementIntegration]`](#alertmanagementintegration) | ノードのリスト。 |
| <a id="alertmanagementintegrationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AlertManagementIntegrationEdge`

[`AlertManagementIntegration`](#alertmanagementintegration)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="alertmanagementintegrationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="alertmanagementintegrationedgenode"></a>`node` | [`AlertManagementIntegration`](#alertmanagementintegration) | エッジの終端にあるアイテム。 |

#### `AmazonS3ConfigurationTypeConnection`

[`AmazonS3ConfigurationType`](#amazons3configurationtype)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="amazons3configurationtypeconnectionedges"></a>`edges` | [`[AmazonS3ConfigurationTypeEdge]`](#amazons3configurationtypeedge) | エッジのリスト。 |
| <a id="amazons3configurationtypeconnectionnodes"></a>`nodes` | [`[AmazonS3ConfigurationType]`](#amazons3configurationtype) | ノードのリスト。 |
| <a id="amazons3configurationtypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AmazonS3ConfigurationTypeEdge`

[`AmazonS3ConfigurationType`](#amazons3configurationtype)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="amazons3configurationtypeedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="amazons3configurationtypeedgenode"></a>`node` | [`AmazonS3ConfigurationType`](#amazons3configurationtype) | エッジの終端にあるアイテム。 |

#### `ApprovalPolicyConnection`

[`ApprovalPolicy`](#approvalpolicy)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="approvalpolicyconnectionedges"></a>`edges` | [`[ApprovalPolicyEdge]`](#approvalpolicyedge) | エッジのリスト。 |
| <a id="approvalpolicyconnectionnodes"></a>`nodes` | [`[ApprovalPolicy]`](#approvalpolicy) | ノードのリスト。 |
| <a id="approvalpolicyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ApprovalPolicyEdge`

[`ApprovalPolicy`](#approvalpolicy)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="approvalpolicyedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="approvalpolicyedgenode"></a>`node` | [`ApprovalPolicy`](#approvalpolicy) | エッジの終端にあるアイテム。 |

#### `ApprovalProjectRuleConnection`

[`ApprovalProjectRule`](#approvalprojectrule)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="approvalprojectruleconnectionedges"></a>`edges` | [`[ApprovalProjectRuleEdge]`](#approvalprojectruleedge) | エッジのリスト。 |
| <a id="approvalprojectruleconnectionnodes"></a>`nodes` | [`[ApprovalProjectRule]`](#approvalprojectrule) | ノードのリスト。 |
| <a id="approvalprojectruleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ApprovalProjectRuleEdge`

[`ApprovalProjectRule`](#approvalprojectrule)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="approvalprojectruleedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="approvalprojectruleedgenode"></a>`node` | [`ApprovalProjectRule`](#approvalprojectrule) | エッジの終端にあるアイテム。 |

#### `AuditEventDefinitionConnection`

[`AuditEventDefinition`](#auditeventdefinition)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="auditeventdefinitionconnectionedges"></a>`edges` | [`[AuditEventDefinitionEdge]`](#auditeventdefinitionedge) | エッジのリスト。 |
| <a id="auditeventdefinitionconnectionnodes"></a>`nodes` | [`[AuditEventDefinition]`](#auditeventdefinition) | ノードのリスト。 |
| <a id="auditeventdefinitionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AuditEventDefinitionEdge`

[`AuditEventDefinition`](#auditeventdefinition)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="auditeventdefinitionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="auditeventdefinitionedgenode"></a>`node` | [`AuditEventDefinition`](#auditeventdefinition) | エッジの終端にあるアイテム。 |

#### `AuditEventStreamingHeaderConnection`

[`AuditEventStreamingHeader`](#auditeventstreamingheader)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="auditeventstreamingheaderconnectionedges"></a>`edges` | [`[AuditEventStreamingHeaderEdge]`](#auditeventstreamingheaderedge) | エッジのリスト。 |
| <a id="auditeventstreamingheaderconnectionnodes"></a>`nodes` | [`[AuditEventStreamingHeader]`](#auditeventstreamingheader) | ノードのリスト。 |
| <a id="auditeventstreamingheaderconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AuditEventStreamingHeaderEdge`

[`AuditEventStreamingHeader`](#auditeventstreamingheader)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="auditeventstreamingheaderedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="auditeventstreamingheaderedgenode"></a>`node` | [`AuditEventStreamingHeader`](#auditeventstreamingheader) | エッジの終端にあるアイテム。 |

#### `AuditEventsStreamingInstanceHeaderConnection`

[`AuditEventsStreamingInstanceHeader`](#auditeventsstreaminginstanceheader)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="auditeventsstreaminginstanceheaderconnectionedges"></a>`edges` | [`[AuditEventsStreamingInstanceHeaderEdge]`](#auditeventsstreaminginstanceheaderedge) | エッジのリスト。 |
| <a id="auditeventsstreaminginstanceheaderconnectionnodes"></a>`nodes` | [`[AuditEventsStreamingInstanceHeader]`](#auditeventsstreaminginstanceheader) | ノードのリスト。 |
| <a id="auditeventsstreaminginstanceheaderconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AuditEventsStreamingInstanceHeaderEdge`

[`AuditEventsStreamingInstanceHeader`](#auditeventsstreaminginstanceheader)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="auditeventsstreaminginstanceheaderedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="auditeventsstreaminginstanceheaderedgenode"></a>`node` | [`AuditEventsStreamingInstanceHeader`](#auditeventsstreaminginstanceheader) | エッジの終端にあるアイテム。 |

#### `AwardEmojiConnection`

[`AwardEmoji`](#awardemoji)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="awardemojiconnectionedges"></a>`edges` | [`[AwardEmojiEdge]`](#awardemojiedge) | エッジのリスト。 |
| <a id="awardemojiconnectionnodes"></a>`nodes` | [`[AwardEmoji]`](#awardemoji) | ノードのリスト。 |
| <a id="awardemojiconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AwardEmojiEdge`

[`AwardEmoji`](#awardemoji)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="awardemojiedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="awardemojiedgenode"></a>`node` | [`AwardEmoji`](#awardemoji) | エッジの終端にあるアイテム。 |

#### `BlobConnection`

[`Blob`](#blob)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="blobconnectionedges"></a>`edges` | [`[BlobEdge]`](#blobedge) | エッジのリスト。 |
| <a id="blobconnectionnodes"></a>`nodes` | [`[Blob]`](#blob) | ノードのリスト。 |
| <a id="blobconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `BlobEdge`

[`Blob`](#blob)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="blobedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="blobedgenode"></a>`node` | [`Blob`](#blob) | エッジの終端にあるアイテム。 |

#### `BoardConnection`

[`Board`](#board)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="boardconnectionedges"></a>`edges` | [`[BoardEdge]`](#boardedge) | エッジのリスト。 |
| <a id="boardconnectionnodes"></a>`nodes` | [`[Board]`](#board) | ノードのリスト。 |
| <a id="boardconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `BoardEdge`

[`Board`](#board)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="boardedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="boardedgenode"></a>`node` | [`Board`](#board) | エッジの終端にあるアイテム。 |

#### `BoardEpicConnection`

[`BoardEpic`](#boardepic)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="boardepicconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="boardepicconnectionedges"></a>`edges` | [`[BoardEpicEdge]`](#boardepicedge) | エッジのリスト。 |
| <a id="boardepicconnectionnodes"></a>`nodes` | [`[BoardEpic]`](#boardepic) | ノードのリスト。 |
| <a id="boardepicconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `BoardEpicEdge`

[`BoardEpic`](#boardepic)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="boardepicedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="boardepicedgenode"></a>`node` | [`BoardEpic`](#boardepic) | エッジの終端にあるアイテム。 |

#### `BoardListConnection`

[`BoardList`](#boardlist)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="boardlistconnectionedges"></a>`edges` | [`[BoardListEdge]`](#boardlistedge) | エッジのリスト。 |
| <a id="boardlistconnectionnodes"></a>`nodes` | [`[BoardList]`](#boardlist) | ノードのリスト。 |
| <a id="boardlistconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `BoardListEdge`

[`BoardList`](#boardlist)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="boardlistedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="boardlistedgenode"></a>`node` | [`BoardList`](#boardlist) | エッジの終端にあるアイテム。 |

#### `BranchRuleConnection`

[`BranchRule`](#branchrule)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="branchruleconnectionedges"></a>`edges` | [`[BranchRuleEdge]`](#branchruleedge) | エッジのリスト。 |
| <a id="branchruleconnectionnodes"></a>`nodes` | [`[BranchRule]`](#branchrule) | ノードのリスト。 |
| <a id="branchruleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `BranchRuleEdge`

[`BranchRule`](#branchrule)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="branchruleedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="branchruleedgenode"></a>`node` | [`BranchRule`](#branchrule) | エッジの終端にあるアイテム。 |

#### `CiBuildNeedConnection`

[`CiBuildNeed`](#cibuildneed)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cibuildneedconnectionedges"></a>`edges` | [`[CiBuildNeedEdge]`](#cibuildneededge) | エッジのリスト。 |
| <a id="cibuildneedconnectionnodes"></a>`nodes` | [`[CiBuildNeed]`](#cibuildneed) | ノードのリスト。 |
| <a id="cibuildneedconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiBuildNeedEdge`

[`CiBuildNeed`](#cibuildneed)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cibuildneededgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cibuildneededgenode"></a>`node` | [`CiBuildNeed`](#cibuildneed) | エッジの終端にあるアイテム。 |

#### `CiCatalogResourceComponentConnection`

[`CiCatalogResourceComponent`](#cicatalogresourcecomponent)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cicatalogresourcecomponentconnectionedges"></a>`edges` | [`[CiCatalogResourceComponentEdge]`](#cicatalogresourcecomponentedge) | エッジのリスト。 |
| <a id="cicatalogresourcecomponentconnectionnodes"></a>`nodes` | [`[CiCatalogResourceComponent]`](#cicatalogresourcecomponent) | ノードのリスト。 |
| <a id="cicatalogresourcecomponentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiCatalogResourceComponentEdge`

[`CiCatalogResourceComponent`](#cicatalogresourcecomponent)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cicatalogresourcecomponentedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cicatalogresourcecomponentedgenode"></a>`node` | [`CiCatalogResourceComponent`](#cicatalogresourcecomponent) | エッジの終端にあるアイテム。 |

#### `CiCatalogResourceComponentUsageConnection`

[`CiCatalogResourceComponentUsage`](#cicatalogresourcecomponentusage)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cicatalogresourcecomponentusageconnectionedges"></a>`edges` | [`[CiCatalogResourceComponentUsageEdge]`](#cicatalogresourcecomponentusageedge) | エッジのリスト。 |
| <a id="cicatalogresourcecomponentusageconnectionnodes"></a>`nodes` | [`[CiCatalogResourceComponentUsage]`](#cicatalogresourcecomponentusage) | ノードのリスト。 |
| <a id="cicatalogresourcecomponentusageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiCatalogResourceComponentUsageEdge`

[`CiCatalogResourceComponentUsage`](#cicatalogresourcecomponentusage)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cicatalogresourcecomponentusageedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cicatalogresourcecomponentusageedgenode"></a>`node` | [`CiCatalogResourceComponentUsage`](#cicatalogresourcecomponentusage) | エッジの終端にあるアイテム。 |

#### `CiCatalogResourceConnection`

[`CiCatalogResource`](#cicatalogresource)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cicatalogresourceconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="cicatalogresourceconnectionedges"></a>`edges` | [`[CiCatalogResourceEdge]`](#cicatalogresourceedge) | エッジのリスト。 |
| <a id="cicatalogresourceconnectionnodes"></a>`nodes` | [`[CiCatalogResource]`](#cicatalogresource) | ノードのリスト。 |
| <a id="cicatalogresourceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiCatalogResourceEdge`

[`CiCatalogResource`](#cicatalogresource)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cicatalogresourceedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cicatalogresourceedgenode"></a>`node` | [`CiCatalogResource`](#cicatalogresource) | エッジの終端にあるアイテム。 |

#### `CiCatalogResourceVersionConnection`

[`CiCatalogResourceVersion`](#cicatalogresourceversion)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cicatalogresourceversionconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="cicatalogresourceversionconnectionedges"></a>`edges` | [`[CiCatalogResourceVersionEdge]`](#cicatalogresourceversionedge) | エッジのリスト。 |
| <a id="cicatalogresourceversionconnectionnodes"></a>`nodes` | [`[CiCatalogResourceVersion]`](#cicatalogresourceversion) | ノードのリスト。 |
| <a id="cicatalogresourceversionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiCatalogResourceVersionEdge`

[`CiCatalogResourceVersion`](#cicatalogresourceversion)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cicatalogresourceversionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cicatalogresourceversionedgenode"></a>`node` | [`CiCatalogResourceVersion`](#cicatalogresourceversion) | エッジの終端にあるアイテム。 |

#### `CiConfigGroupConnection`

[`CiConfigGroup`](#ciconfiggroup)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciconfiggroupconnectionedges"></a>`edges` | [`[CiConfigGroupEdge]`](#ciconfiggroupedge) | エッジのリスト。 |
| <a id="ciconfiggroupconnectionnodes"></a>`nodes` | [`[CiConfigGroup]`](#ciconfiggroup) | ノードのリスト。 |
| <a id="ciconfiggroupconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiConfigGroupEdge`

[`CiConfigGroup`](#ciconfiggroup)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciconfiggroupedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="ciconfiggroupedgenode"></a>`node` | [`CiConfigGroup`](#ciconfiggroup) | エッジの終端にあるアイテム。 |

#### `CiConfigJobConnection`

[`CiConfigJob`](#ciconfigjob)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciconfigjobconnectionedges"></a>`edges` | [`[CiConfigJobEdge]`](#ciconfigjobedge) | エッジのリスト。 |
| <a id="ciconfigjobconnectionnodes"></a>`nodes` | [`[CiConfigJob]`](#ciconfigjob) | ノードのリスト。 |
| <a id="ciconfigjobconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiConfigJobEdge`

[`CiConfigJob`](#ciconfigjob)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciconfigjobedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="ciconfigjobedgenode"></a>`node` | [`CiConfigJob`](#ciconfigjob) | エッジの終端にあるアイテム。 |

#### `CiConfigNeedConnection`

[`CiConfigNeed`](#ciconfigneed)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciconfigneedconnectionedges"></a>`edges` | [`[CiConfigNeedEdge]`](#ciconfigneededge) | エッジのリスト。 |
| <a id="ciconfigneedconnectionnodes"></a>`nodes` | [`[CiConfigNeed]`](#ciconfigneed) | ノードのリスト。 |
| <a id="ciconfigneedconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiConfigNeedEdge`

[`CiConfigNeed`](#ciconfigneed)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciconfigneededgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="ciconfigneededgenode"></a>`node` | [`CiConfigNeed`](#ciconfigneed) | エッジの終端にあるアイテム。 |

#### `CiConfigStageConnection`

[`CiConfigStage`](#ciconfigstage)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciconfigstageconnectionedges"></a>`edges` | [`[CiConfigStageEdge]`](#ciconfigstageedge) | エッジのリスト。 |
| <a id="ciconfigstageconnectionnodes"></a>`nodes` | [`[CiConfigStage]`](#ciconfigstage) | ノードのリスト。 |
| <a id="ciconfigstageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiConfigStageEdge`

[`CiConfigStage`](#ciconfigstage)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciconfigstageedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="ciconfigstageedgenode"></a>`node` | [`CiConfigStage`](#ciconfigstage) | エッジの終端にあるアイテム。 |

#### `CiDedicatedHostedRunnerUsageConnection`

[`CiDedicatedHostedRunnerUsage`](#cidedicatedhostedrunnerusage)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cidedicatedhostedrunnerusageconnectionedges"></a>`edges` | [`[CiDedicatedHostedRunnerUsageEdge]`](#cidedicatedhostedrunnerusageedge) | エッジのリスト。 |
| <a id="cidedicatedhostedrunnerusageconnectionnodes"></a>`nodes` | [`[CiDedicatedHostedRunnerUsage]`](#cidedicatedhostedrunnerusage) | ノードのリスト。 |
| <a id="cidedicatedhostedrunnerusageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiDedicatedHostedRunnerUsageEdge`

[`CiDedicatedHostedRunnerUsage`](#cidedicatedhostedrunnerusage)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cidedicatedhostedrunnerusageedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cidedicatedhostedrunnerusageedgenode"></a>`node` | [`CiDedicatedHostedRunnerUsage`](#cidedicatedhostedrunnerusage) | エッジの終端にあるアイテム。 |

#### `CiGroupConnection`

[`CiGroup`](#cigroup)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cigroupconnectionedges"></a>`edges` | [`[CiGroupEdge]`](#cigroupedge) | エッジのリスト。 |
| <a id="cigroupconnectionnodes"></a>`nodes` | [`[CiGroup]`](#cigroup) | ノードのリスト。 |
| <a id="cigroupconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiGroupEdge`

[`CiGroup`](#cigroup)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cigroupedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cigroupedgenode"></a>`node` | [`CiGroup`](#cigroup) | エッジの終端にあるアイテム。 |

#### `CiGroupEnvironmentScopeConnection`

[`CiGroupEnvironmentScope`](#cigroupenvironmentscope)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cigroupenvironmentscopeconnectionedges"></a>`edges` | [`[CiGroupEnvironmentScopeEdge]`](#cigroupenvironmentscopeedge) | エッジのリスト。 |
| <a id="cigroupenvironmentscopeconnectionnodes"></a>`nodes` | [`[CiGroupEnvironmentScope]`](#cigroupenvironmentscope) | ノードのリスト。 |
| <a id="cigroupenvironmentscopeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiGroupEnvironmentScopeEdge`

[`CiGroupEnvironmentScope`](#cigroupenvironmentscope)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cigroupenvironmentscopeedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cigroupenvironmentscopeedgenode"></a>`node` | [`CiGroupEnvironmentScope`](#cigroupenvironmentscope) | エッジの終端にあるアイテム。 |

#### `CiGroupVariableConnection`

[`CiGroupVariable`](#cigroupvariable)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cigroupvariableconnectionedges"></a>`edges` | [`[CiGroupVariableEdge]`](#cigroupvariableedge) | エッジのリスト。 |
| <a id="cigroupvariableconnectionlimit"></a>`limit` | [`Int!`](#int) | グループCI/CD変数の最大数値。 |
| <a id="cigroupvariableconnectionnodes"></a>`nodes` | [`[CiGroupVariable]`](#cigroupvariable) | ノードのリスト。 |
| <a id="cigroupvariableconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiGroupVariableEdge`

[`CiGroupVariable`](#cigroupvariable)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cigroupvariableedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cigroupvariableedgenode"></a>`node` | [`CiGroupVariable`](#cigroupvariable) | エッジの終端にあるアイテム。 |

#### `CiInputsFieldConnection`

[`CiInputsField`](#ciinputsfield)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciinputsfieldconnectionedges"></a>`edges` | [`[CiInputsFieldEdge]`](#ciinputsfieldedge) | エッジのリスト。 |
| <a id="ciinputsfieldconnectionnodes"></a>`nodes` | [`[CiInputsField]`](#ciinputsfield) | ノードのリスト。 |
| <a id="ciinputsfieldconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiInputsFieldEdge`

[`CiInputsField`](#ciinputsfield)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciinputsfieldedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="ciinputsfieldedgenode"></a>`node` | [`CiInputsField`](#ciinputsfield) | エッジの終端にあるアイテム。 |

#### `CiInstanceVariableConnection`

[`CiInstanceVariable`](#ciinstancevariable)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciinstancevariableconnectionedges"></a>`edges` | [`[CiInstanceVariableEdge]`](#ciinstancevariableedge) | エッジのリスト。 |
| <a id="ciinstancevariableconnectionnodes"></a>`nodes` | [`[CiInstanceVariable]`](#ciinstancevariable) | ノードのリスト。 |
| <a id="ciinstancevariableconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiInstanceVariableEdge`

[`CiInstanceVariable`](#ciinstancevariable)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciinstancevariableedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="ciinstancevariableedgenode"></a>`node` | [`CiInstanceVariable`](#ciinstancevariable) | エッジの終端にあるアイテム。 |

#### `CiJobArtifactConnection`

[`CiJobArtifact`](#cijobartifact)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cijobartifactconnectionedges"></a>`edges` | [`[CiJobArtifactEdge]`](#cijobartifactedge) | エッジのリスト。 |
| <a id="cijobartifactconnectionnodes"></a>`nodes` | [`[CiJobArtifact]`](#cijobartifact) | ノードのリスト。 |
| <a id="cijobartifactconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiJobArtifactEdge`

[`CiJobArtifact`](#cijobartifact)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cijobartifactedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cijobartifactedgenode"></a>`node` | [`CiJobArtifact`](#cijobartifact) | エッジの終端にあるアイテム。 |

#### `CiJobConnection`

[`CiJob`](#cijob)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cijobconnectionedges"></a>`edges` | [`[CiJobEdge]`](#cijobedge) | エッジのリスト。 |
| <a id="cijobconnectionnodes"></a>`nodes` | [`[CiJob]`](#cijob) | ノードのリスト。 |
| <a id="cijobconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド

###### `CiJobConnection.count`

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cijobconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `CiJobEdge`

[`CiJob`](#cijob)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cijobedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cijobedgenode"></a>`node` | [`CiJob`](#cijob) | エッジの終端にあるアイテム。 |

#### `CiJobTokenAccessibleGroupConnection`

[`CiJobTokenAccessibleGroup`](#cijobtokenaccessiblegroup)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cijobtokenaccessiblegroupconnectionedges"></a>`edges` | [`[CiJobTokenAccessibleGroupEdge]`](#cijobtokenaccessiblegroupedge) | エッジのリスト。 |
| <a id="cijobtokenaccessiblegroupconnectionnodes"></a>`nodes` | [`[CiJobTokenAccessibleGroup]`](#cijobtokenaccessiblegroup) | ノードのリスト。 |
| <a id="cijobtokenaccessiblegroupconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiJobTokenAccessibleGroupEdge`

[`CiJobTokenAccessibleGroup`](#cijobtokenaccessiblegroup)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cijobtokenaccessiblegroupedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cijobtokenaccessiblegroupedgenode"></a>`node` | [`CiJobTokenAccessibleGroup`](#cijobtokenaccessiblegroup) | エッジの終端にあるアイテム。 |

#### `CiJobTokenAccessibleProjectConnection`

[`CiJobTokenAccessibleProject`](#cijobtokenaccessibleproject)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cijobtokenaccessibleprojectconnectionedges"></a>`edges` | [`[CiJobTokenAccessibleProjectEdge]`](#cijobtokenaccessibleprojectedge) | エッジのリスト。 |
| <a id="cijobtokenaccessibleprojectconnectionnodes"></a>`nodes` | [`[CiJobTokenAccessibleProject]`](#cijobtokenaccessibleproject) | ノードのリスト。 |
| <a id="cijobtokenaccessibleprojectconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiJobTokenAccessibleProjectEdge`

[`CiJobTokenAccessibleProject`](#cijobtokenaccessibleproject)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cijobtokenaccessibleprojectedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cijobtokenaccessibleprojectedgenode"></a>`node` | [`CiJobTokenAccessibleProject`](#cijobtokenaccessibleproject) | エッジの終端にあるアイテム。 |

#### `CiJobTokenAuthLogConnection`

[`CiJobTokenAuthLog`](#cijobtokenauthlog)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cijobtokenauthlogconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="cijobtokenauthlogconnectionedges"></a>`edges` | [`[CiJobTokenAuthLogEdge]`](#cijobtokenauthlogedge) | エッジのリスト。 |
| <a id="cijobtokenauthlogconnectionnodes"></a>`nodes` | [`[CiJobTokenAuthLog]`](#cijobtokenauthlog) | ノードのリスト。 |
| <a id="cijobtokenauthlogconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiJobTokenAuthLogEdge`

[`CiJobTokenAuthLog`](#cijobtokenauthlog)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cijobtokenauthlogedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cijobtokenauthlogedgenode"></a>`node` | [`CiJobTokenAuthLog`](#cijobtokenauthlog) | エッジの終端にあるアイテム。 |

#### `CiJobTokenScopeAllowlistEntryConnection`

[`CiJobTokenScopeAllowlistEntry`](#cijobtokenscopeallowlistentry)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cijobtokenscopeallowlistentryconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="cijobtokenscopeallowlistentryconnectionedges"></a>`edges` | [`[CiJobTokenScopeAllowlistEntryEdge]`](#cijobtokenscopeallowlistentryedge) | エッジのリスト。 |
| <a id="cijobtokenscopeallowlistentryconnectionnodes"></a>`nodes` | [`[CiJobTokenScopeAllowlistEntry]`](#cijobtokenscopeallowlistentry) | ノードのリスト。 |
| <a id="cijobtokenscopeallowlistentryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiJobTokenScopeAllowlistEntryEdge`

[`CiJobTokenScopeAllowlistEntry`](#cijobtokenscopeallowlistentry)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cijobtokenscopeallowlistentryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cijobtokenscopeallowlistentryedgenode"></a>`node` | [`CiJobTokenScopeAllowlistEntry`](#cijobtokenscopeallowlistentry) | エッジの終端にあるアイテム。 |

#### `CiManualVariableConnection`

[`CiManualVariable`](#cimanualvariable)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cimanualvariableconnectionedges"></a>`edges` | [`[CiManualVariableEdge]`](#cimanualvariableedge) | エッジのリスト。 |
| <a id="cimanualvariableconnectionnodes"></a>`nodes` | [`[CiManualVariable]`](#cimanualvariable) | ノードのリスト。 |
| <a id="cimanualvariableconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiManualVariableEdge`

[`CiManualVariable`](#cimanualvariable)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cimanualvariableedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cimanualvariableedgenode"></a>`node` | [`CiManualVariable`](#cimanualvariable) | エッジの終端にあるアイテム。 |

#### `CiMinutesNamespaceMonthlyUsageConnection`

[`CiMinutesNamespaceMonthlyUsage`](#ciminutesnamespacemonthlyusage)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciminutesnamespacemonthlyusageconnectionedges"></a>`edges` | [`[CiMinutesNamespaceMonthlyUsageEdge]`](#ciminutesnamespacemonthlyusageedge) | エッジのリスト。 |
| <a id="ciminutesnamespacemonthlyusageconnectionnodes"></a>`nodes` | [`[CiMinutesNamespaceMonthlyUsage]`](#ciminutesnamespacemonthlyusage) | ノードのリスト。 |
| <a id="ciminutesnamespacemonthlyusageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiMinutesNamespaceMonthlyUsageEdge`

[`CiMinutesNamespaceMonthlyUsage`](#ciminutesnamespacemonthlyusage)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciminutesnamespacemonthlyusageedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="ciminutesnamespacemonthlyusageedgenode"></a>`node` | [`CiMinutesNamespaceMonthlyUsage`](#ciminutesnamespacemonthlyusage) | エッジの終端にあるアイテム。 |

#### `CiMinutesProjectMonthlyUsageConnection`

[`CiMinutesProjectMonthlyUsage`](#ciminutesprojectmonthlyusage)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciminutesprojectmonthlyusageconnectionedges"></a>`edges` | [`[CiMinutesProjectMonthlyUsageEdge]`](#ciminutesprojectmonthlyusageedge) | エッジのリスト。 |
| <a id="ciminutesprojectmonthlyusageconnectionnodes"></a>`nodes` | [`[CiMinutesProjectMonthlyUsage]`](#ciminutesprojectmonthlyusage) | ノードのリスト。 |
| <a id="ciminutesprojectmonthlyusageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiMinutesProjectMonthlyUsageEdge`

[`CiMinutesProjectMonthlyUsage`](#ciminutesprojectmonthlyusage)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciminutesprojectmonthlyusageedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="ciminutesprojectmonthlyusageedgenode"></a>`node` | [`CiMinutesProjectMonthlyUsage`](#ciminutesprojectmonthlyusage) | エッジの終端にあるアイテム。 |

#### `CiProjectSubscriptionConnection`

[`CiProjectSubscription`](#ciprojectsubscription)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciprojectsubscriptionconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="ciprojectsubscriptionconnectionedges"></a>`edges` | [`[CiProjectSubscriptionEdge]`](#ciprojectsubscriptionedge) | エッジのリスト。 |
| <a id="ciprojectsubscriptionconnectionnodes"></a>`nodes` | [`[CiProjectSubscription]`](#ciprojectsubscription) | ノードのリスト。 |
| <a id="ciprojectsubscriptionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiProjectSubscriptionEdge`

[`CiProjectSubscription`](#ciprojectsubscription)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciprojectsubscriptionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="ciprojectsubscriptionedgenode"></a>`node` | [`CiProjectSubscription`](#ciprojectsubscription) | エッジの終端にあるアイテム。 |

#### `CiProjectVariableConnection`

[`CiProjectVariable`](#ciprojectvariable)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciprojectvariableconnectionedges"></a>`edges` | [`[CiProjectVariableEdge]`](#ciprojectvariableedge) | エッジのリスト。 |
| <a id="ciprojectvariableconnectionlimit"></a>`limit` | [`Int!`](#int) | プロジェクトCI/CD変数の最大数値。 |
| <a id="ciprojectvariableconnectionnodes"></a>`nodes` | [`[CiProjectVariable]`](#ciprojectvariable) | ノードのリスト。 |
| <a id="ciprojectvariableconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiProjectVariableEdge`

[`CiProjectVariable`](#ciprojectvariable)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciprojectvariableedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="ciprojectvariableedgenode"></a>`node` | [`CiProjectVariable`](#ciprojectvariable) | エッジの終端にあるアイテム。 |

#### `CiRunnerConnection`

[`CiRunner`](#cirunner)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cirunnerconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="cirunnerconnectionedges"></a>`edges` | [`[CiRunnerEdge]`](#cirunneredge) | エッジのリスト。 |
| <a id="cirunnerconnectionjobsstatistics"></a>`jobsStatistics` | [`CiJobsStatistics`](#cijobsstatistics) | Runnerのコレクションによって実行されたジョブのジョブ統計。管理者のみが利用できます。 |
| <a id="cirunnerconnectionnodes"></a>`nodes` | [`[CiRunner]`](#cirunner) | ノードのリスト。 |
| <a id="cirunnerconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiRunnerEdge`

[`CiRunner`](#cirunner)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cirunneredgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cirunneredgeediturl"></a>`editUrl` | [`String`](#string) | Runner編集ページのWeb URL。値は、クエリ内でのフィールドの配置場所によって異なります。プロジェクトまたはグループについて使用できます。 |
| <a id="cirunneredgenode"></a>`node` | [`CiRunner`](#cirunner) | エッジの終端にあるアイテム。 |
| <a id="cirunneredgeweburl"></a>`webUrl` | [`String`](#string) | RunnerのWeb URL。値は、クエリ内でのフィールドの配置場所によって異なります。プロジェクトまたはグループについて使用できます。 |

#### `CiRunnerManagerConnection`

[`CiRunnerManager`](#cirunnermanager)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cirunnermanagerconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="cirunnermanagerconnectionedges"></a>`edges` | [`[CiRunnerManagerEdge]`](#cirunnermanageredge) | エッジのリスト。 |
| <a id="cirunnermanagerconnectionnodes"></a>`nodes` | [`[CiRunnerManager]`](#cirunnermanager) | ノードのリスト。 |
| <a id="cirunnermanagerconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiRunnerManagerEdge`

[`CiRunnerManager`](#cirunnermanager)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cirunnermanageredgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cirunnermanageredgenode"></a>`node` | [`CiRunnerManager`](#cirunnermanager) | エッジの終端にあるアイテム。 |

#### `CiSecureFileRegistryConnection`

[`CiSecureFileRegistry`](#cisecurefileregistry)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cisecurefileregistryconnectionedges"></a>`edges` | [`[CiSecureFileRegistryEdge]`](#cisecurefileregistryedge) | エッジのリスト。 |
| <a id="cisecurefileregistryconnectionnodes"></a>`nodes` | [`[CiSecureFileRegistry]`](#cisecurefileregistry) | ノードのリスト。 |
| <a id="cisecurefileregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド

###### `CiSecureFileRegistryConnection.count`

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cisecurefileregistryconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `CiSecureFileRegistryEdge`

[`CiSecureFileRegistry`](#cisecurefileregistry)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cisecurefileregistryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cisecurefileregistryedgenode"></a>`node` | [`CiSecureFileRegistry`](#cisecurefileregistry) | エッジの終端にあるアイテム。 |

#### `CiStageConnection`

[`CiStage`](#cistage)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cistageconnectionedges"></a>`edges` | [`[CiStageEdge]`](#cistageedge) | エッジのリスト。 |
| <a id="cistageconnectionnodes"></a>`nodes` | [`[CiStage]`](#cistage) | ノードのリスト。 |
| <a id="cistageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiStageEdge`

[`CiStage`](#cistage)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cistageedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cistageedgenode"></a>`node` | [`CiStage`](#cistage) | エッジの終端にあるアイテム。 |

#### `CiSubscriptionsProjectConnection`

[`CiSubscriptionsProject`](#cisubscriptionsproject)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cisubscriptionsprojectconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="cisubscriptionsprojectconnectionedges"></a>`edges` | [`[CiSubscriptionsProjectEdge]`](#cisubscriptionsprojectedge) | エッジのリスト。 |
| <a id="cisubscriptionsprojectconnectionnodes"></a>`nodes` | [`[CiSubscriptionsProject]`](#cisubscriptionsproject) | ノードのリスト。 |
| <a id="cisubscriptionsprojectconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiSubscriptionsProjectEdge`

[`CiSubscriptionsProject`](#cisubscriptionsproject)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cisubscriptionsprojectedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cisubscriptionsprojectedgenode"></a>`node` | [`CiSubscriptionsProject`](#cisubscriptionsproject) | エッジの終端にあるアイテム。 |

#### `ClusterAgentActivityEventConnection`

[`ClusterAgentActivityEvent`](#clusteragentactivityevent)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="clusteragentactivityeventconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="clusteragentactivityeventconnectionedges"></a>`edges` | [`[ClusterAgentActivityEventEdge]`](#clusteragentactivityeventedge) | エッジのリスト。 |
| <a id="clusteragentactivityeventconnectionnodes"></a>`nodes` | [`[ClusterAgentActivityEvent]`](#clusteragentactivityevent) | ノードのリスト。 |
| <a id="clusteragentactivityeventconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ClusterAgentActivityEventEdge`

[`ClusterAgentActivityEvent`](#clusteragentactivityevent)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="clusteragentactivityeventedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="clusteragentactivityeventedgenode"></a>`node` | [`ClusterAgentActivityEvent`](#clusteragentactivityevent) | エッジの終端にあるアイテム。 |

#### `ClusterAgentAuthorizationCiAccessConnection`

[`ClusterAgentAuthorizationCiAccess`](#clusteragentauthorizationciaccess)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="clusteragentauthorizationciaccessconnectionedges"></a>`edges` | [`[ClusterAgentAuthorizationCiAccessEdge]`](#clusteragentauthorizationciaccessedge) | エッジのリスト。 |
| <a id="clusteragentauthorizationciaccessconnectionnodes"></a>`nodes` | [`[ClusterAgentAuthorizationCiAccess]`](#clusteragentauthorizationciaccess) | ノードのリスト。 |
| <a id="clusteragentauthorizationciaccessconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ClusterAgentAuthorizationCiAccessEdge`

[`ClusterAgentAuthorizationCiAccess`](#clusteragentauthorizationciaccess)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="clusteragentauthorizationciaccessedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="clusteragentauthorizationciaccessedgenode"></a>`node` | [`ClusterAgentAuthorizationCiAccess`](#clusteragentauthorizationciaccess) | エッジの終端にあるアイテム。 |

#### `ClusterAgentAuthorizationUserAccessConnection`

[`ClusterAgentAuthorizationUserAccess`](#clusteragentauthorizationuseraccess)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="clusteragentauthorizationuseraccessconnectionedges"></a>`edges` | [`[ClusterAgentAuthorizationUserAccessEdge]`](#clusteragentauthorizationuseraccessedge) | エッジのリスト。 |
| <a id="clusteragentauthorizationuseraccessconnectionnodes"></a>`nodes` | [`[ClusterAgentAuthorizationUserAccess]`](#clusteragentauthorizationuseraccess) | ノードのリスト。 |
| <a id="clusteragentauthorizationuseraccessconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ClusterAgentAuthorizationUserAccessEdge`

[`ClusterAgentAuthorizationUserAccess`](#clusteragentauthorizationuseraccess)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="clusteragentauthorizationuseraccessedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="clusteragentauthorizationuseraccessedgenode"></a>`node` | [`ClusterAgentAuthorizationUserAccess`](#clusteragentauthorizationuseraccess) | エッジの終端にあるアイテム。 |

#### `ClusterAgentConnection`

[`ClusterAgent`](#clusteragent)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="clusteragentconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="clusteragentconnectionedges"></a>`edges` | [`[ClusterAgentEdge]`](#clusteragentedge) | エッジのリスト。 |
| <a id="clusteragentconnectionnodes"></a>`nodes` | [`[ClusterAgent]`](#clusteragent) | ノードのリスト。 |
| <a id="clusteragentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ClusterAgentEdge`

[`ClusterAgent`](#clusteragent)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="clusteragentedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="clusteragentedgenode"></a>`node` | [`ClusterAgent`](#clusteragent) | エッジの終端にあるアイテム。 |

#### `ClusterAgentTokenConnection`

[`ClusterAgentToken`](#clusteragenttoken)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="clusteragenttokenconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="clusteragenttokenconnectionedges"></a>`edges` | [`[ClusterAgentTokenEdge]`](#clusteragenttokenedge) | エッジのリスト。 |
| <a id="clusteragenttokenconnectionnodes"></a>`nodes` | [`[ClusterAgentToken]`](#clusteragenttoken) | ノードのリスト。 |
| <a id="clusteragenttokenconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ClusterAgentTokenEdge`

[`ClusterAgentToken`](#clusteragenttoken)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="clusteragenttokenedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="clusteragenttokenedgenode"></a>`node` | [`ClusterAgentToken`](#clusteragenttoken) | エッジの終端にあるアイテム。 |

#### `ClusterAgentUrlConfigurationConnection`

[`ClusterAgentUrlConfiguration`](#clusteragenturlconfiguration)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="clusteragenturlconfigurationconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="clusteragenturlconfigurationconnectionedges"></a>`edges` | [`[ClusterAgentUrlConfigurationEdge]`](#clusteragenturlconfigurationedge) | エッジのリスト。 |
| <a id="clusteragenturlconfigurationconnectionnodes"></a>`nodes` | [`[ClusterAgentUrlConfiguration]`](#clusteragenturlconfiguration) | ノードのリスト。 |
| <a id="clusteragenturlconfigurationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ClusterAgentUrlConfigurationEdge`

[`ClusterAgentUrlConfiguration`](#clusteragenturlconfiguration)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="clusteragenturlconfigurationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="clusteragenturlconfigurationedgenode"></a>`node` | [`ClusterAgentUrlConfiguration`](#clusteragenturlconfiguration) | エッジの終端にあるアイテム。 |

#### `CodeCoverageActivityConnection`

[`CodeCoverageActivity`](#codecoverageactivity)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="codecoverageactivityconnectionedges"></a>`edges` | [`[CodeCoverageActivityEdge]`](#codecoverageactivityedge) | エッジのリスト。 |
| <a id="codecoverageactivityconnectionnodes"></a>`nodes` | [`[CodeCoverageActivity]`](#codecoverageactivity) | ノードのリスト。 |
| <a id="codecoverageactivityconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CodeCoverageActivityEdge`

[`CodeCoverageActivity`](#codecoverageactivity)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="codecoverageactivityedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="codecoverageactivityedgenode"></a>`node` | [`CodeCoverageActivity`](#codecoverageactivity) | エッジの終端にあるアイテム。 |

#### `CodeQualityDegradationConnection`

[`CodeQualityDegradation`](#codequalitydegradation)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="codequalitydegradationconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="codequalitydegradationconnectionedges"></a>`edges` | [`[CodeQualityDegradationEdge]`](#codequalitydegradationedge) | エッジのリスト。 |
| <a id="codequalitydegradationconnectionnodes"></a>`nodes` | [`[CodeQualityDegradation]`](#codequalitydegradation) | ノードのリスト。 |
| <a id="codequalitydegradationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CodeQualityDegradationEdge`

[`CodeQualityDegradation`](#codequalitydegradation)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="codequalitydegradationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="codequalitydegradationedgenode"></a>`node` | [`CodeQualityDegradation`](#codequalitydegradation) | エッジの終端にあるアイテム。 |

#### `CodeSuggestionEventConnection`

[`CodeSuggestionEvent`](#codesuggestionevent)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="codesuggestioneventconnectionedges"></a>`edges` | [`[CodeSuggestionEventEdge]`](#codesuggestioneventedge) | エッジのリスト。 |
| <a id="codesuggestioneventconnectionnodes"></a>`nodes` | [`[CodeSuggestionEvent]`](#codesuggestionevent) | ノードのリスト。 |
| <a id="codesuggestioneventconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CodeSuggestionEventEdge`

[`CodeSuggestionEvent`](#codesuggestionevent)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="codesuggestioneventedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="codesuggestioneventedgenode"></a>`node` | [`CodeSuggestionEvent`](#codesuggestionevent) | エッジの終端にあるアイテム。 |

#### `CommitConnection`

[`Commit`](#commit)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="commitconnectionedges"></a>`edges` | [`[CommitEdge]`](#commitedge) | エッジのリスト。 |
| <a id="commitconnectionnodes"></a>`nodes` | [`[Commit]`](#commit) | ノードのリスト。 |
| <a id="commitconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CommitEdge`

[`Commit`](#commit)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="commitedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="commitedgenode"></a>`node` | [`Commit`](#commit) | エッジの終端にあるアイテム。 |

#### `ComplianceFrameworkConnection`

[`ComplianceFramework`](#complianceframework)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="complianceframeworkconnectionedges"></a>`edges` | [`[ComplianceFrameworkEdge]`](#complianceframeworkedge) | エッジのリスト。 |
| <a id="complianceframeworkconnectionnodes"></a>`nodes` | [`[ComplianceFramework]`](#complianceframework) | ノードのリスト。 |
| <a id="complianceframeworkconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ComplianceFrameworkEdge`

[`ComplianceFramework`](#complianceframework)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="complianceframeworkedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="complianceframeworkedgenode"></a>`node` | [`ComplianceFramework`](#complianceframework) | エッジの終端にあるアイテム。 |

#### `ComplianceRequirementConnection`

[`ComplianceRequirement`](#compliancerequirement)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="compliancerequirementconnectionedges"></a>`edges` | [`[ComplianceRequirementEdge]`](#compliancerequirementedge) | エッジのリスト。 |
| <a id="compliancerequirementconnectionnodes"></a>`nodes` | [`[ComplianceRequirement]`](#compliancerequirement) | ノードのリスト。 |
| <a id="compliancerequirementconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ComplianceRequirementEdge`

[`ComplianceRequirement`](#compliancerequirement)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="compliancerequirementedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="compliancerequirementedgenode"></a>`node` | [`ComplianceRequirement`](#compliancerequirement) | エッジの終端にあるアイテム。 |

#### `ComplianceRequirementsControlConnection`

[`ComplianceRequirementsControl`](#compliancerequirementscontrol)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="compliancerequirementscontrolconnectionedges"></a>`edges` | [`[ComplianceRequirementsControlEdge]`](#compliancerequirementscontroledge) | エッジのリスト。 |
| <a id="compliancerequirementscontrolconnectionnodes"></a>`nodes` | [`[ComplianceRequirementsControl]`](#compliancerequirementscontrol) | ノードのリスト。 |
| <a id="compliancerequirementscontrolconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ComplianceRequirementsControlEdge`

[`ComplianceRequirementsControl`](#compliancerequirementscontrol)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="compliancerequirementscontroledgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="compliancerequirementscontroledgenode"></a>`node` | [`ComplianceRequirementsControl`](#compliancerequirementscontrol) | エッジの終端にあるアイテム。 |

#### `ComplianceStandardsAdherenceConnection`

[`ComplianceStandardsAdherence`](#compliancestandardsadherence)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="compliancestandardsadherenceconnectionedges"></a>`edges` | [`[ComplianceStandardsAdherenceEdge]`](#compliancestandardsadherenceedge) | エッジのリスト。 |
| <a id="compliancestandardsadherenceconnectionnodes"></a>`nodes` | [`[ComplianceStandardsAdherence]`](#compliancestandardsadherence) | ノードのリスト。 |
| <a id="compliancestandardsadherenceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ComplianceStandardsAdherenceEdge`

[`ComplianceStandardsAdherence`](#compliancestandardsadherence)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="compliancestandardsadherenceedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="compliancestandardsadherenceedgenode"></a>`node` | [`ComplianceStandardsAdherence`](#compliancestandardsadherence) | エッジの終端にあるアイテム。 |

#### `ComplianceViolationConnection`

[`ComplianceViolation`](#complianceviolation)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="complianceviolationconnectionedges"></a>`edges` | [`[ComplianceViolationEdge]`](#complianceviolationedge) | エッジのリスト。 |
| <a id="complianceviolationconnectionnodes"></a>`nodes` | [`[ComplianceViolation]`](#complianceviolation) | ノードのリスト。 |
| <a id="complianceviolationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ComplianceViolationEdge`

[`ComplianceViolation`](#complianceviolation)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="complianceviolationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="complianceviolationedgenode"></a>`node` | [`ComplianceViolation`](#complianceviolation) | エッジの終端にあるアイテム。 |

#### `ComponentVersionConnection`

[`ComponentVersion`](#componentversion)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="componentversionconnectionedges"></a>`edges` | [`[ComponentVersionEdge]`](#componentversionedge) | エッジのリスト。 |
| <a id="componentversionconnectionnodes"></a>`nodes` | [`[ComponentVersion]`](#componentversion) | ノードのリスト。 |
| <a id="componentversionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ComponentVersionEdge`

[`ComponentVersion`](#componentversion)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="componentversionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="componentversionedgenode"></a>`node` | [`ComponentVersion`](#componentversion) | エッジの終端にあるアイテム。 |

#### `ConnectedAgentConnection`

[`ConnectedAgent`](#connectedagent)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="connectedagentconnectionedges"></a>`edges` | [`[ConnectedAgentEdge]`](#connectedagentedge) | エッジのリスト。 |
| <a id="connectedagentconnectionnodes"></a>`nodes` | [`[ConnectedAgent]`](#connectedagent) | ノードのリスト。 |
| <a id="connectedagentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ConnectedAgentEdge`

[`ConnectedAgent`](#connectedagent)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="connectedagentedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="connectedagentedgenode"></a>`node` | [`ConnectedAgent`](#connectedagent) | エッジの終端にあるアイテム。 |

#### `ContainerProtectionRepositoryRuleConnection`

[`ContainerProtectionRepositoryRule`](#containerprotectionrepositoryrule)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="containerprotectionrepositoryruleconnectionedges"></a>`edges` | [`[ContainerProtectionRepositoryRuleEdge]`](#containerprotectionrepositoryruleedge) | エッジのリスト。 |
| <a id="containerprotectionrepositoryruleconnectionnodes"></a>`nodes` | [`[ContainerProtectionRepositoryRule]`](#containerprotectionrepositoryrule) | ノードのリスト。 |
| <a id="containerprotectionrepositoryruleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ContainerProtectionRepositoryRuleEdge`

[`ContainerProtectionRepositoryRule`](#containerprotectionrepositoryrule)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="containerprotectionrepositoryruleedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="containerprotectionrepositoryruleedgenode"></a>`node` | [`ContainerProtectionRepositoryRule`](#containerprotectionrepositoryrule) | エッジの終端にあるアイテム。 |

#### `ContainerProtectionTagRuleConnection`

[`ContainerProtectionTagRule`](#containerprotectiontagrule)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="containerprotectiontagruleconnectionedges"></a>`edges` | [`[ContainerProtectionTagRuleEdge]`](#containerprotectiontagruleedge) | エッジのリスト。 |
| <a id="containerprotectiontagruleconnectionnodes"></a>`nodes` | [`[ContainerProtectionTagRule]`](#containerprotectiontagrule) | ノードのリスト。 |
| <a id="containerprotectiontagruleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ContainerProtectionTagRuleEdge`

[`ContainerProtectionTagRule`](#containerprotectiontagrule)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="containerprotectiontagruleedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="containerprotectiontagruleedgenode"></a>`node` | [`ContainerProtectionTagRule`](#containerprotectiontagrule) | エッジの終端にあるアイテム。 |

#### `ContainerRepositoryConnection`

[`ContainerRepository`](#containerrepository)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="containerrepositoryconnectionedges"></a>`edges` | [`[ContainerRepositoryEdge]`](#containerrepositoryedge) | エッジのリスト。 |
| <a id="containerrepositoryconnectionnodes"></a>`nodes` | [`[ContainerRepository]`](#containerrepository) | ノードのリスト。 |
| <a id="containerrepositoryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ContainerRepositoryEdge`

[`ContainerRepository`](#containerrepository)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="containerrepositoryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="containerrepositoryedgenode"></a>`node` | [`ContainerRepository`](#containerrepository) | エッジの終端にあるアイテム。 |

#### `ContainerRepositoryRegistryConnection`

[`ContainerRepositoryRegistry`](#containerrepositoryregistry)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="containerrepositoryregistryconnectionedges"></a>`edges` | [`[ContainerRepositoryRegistryEdge]`](#containerrepositoryregistryedge) | エッジのリスト。 |
| <a id="containerrepositoryregistryconnectionnodes"></a>`nodes` | [`[ContainerRepositoryRegistry]`](#containerrepositoryregistry) | ノードのリスト。 |
| <a id="containerrepositoryregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド

###### `ContainerRepositoryRegistryConnection.count`

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="containerrepositoryregistryconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `ContainerRepositoryRegistryEdge`

[`ContainerRepositoryRegistry`](#containerrepositoryregistry)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="containerrepositoryregistryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="containerrepositoryregistryedgenode"></a>`node` | [`ContainerRepositoryRegistry`](#containerrepositoryregistry) | エッジの終端にあるアイテム。 |

#### `ContainerRepositoryTagConnection`

[`ContainerRepositoryTag`](#containerrepositorytag)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="containerrepositorytagconnectionedges"></a>`edges` | [`[ContainerRepositoryTagEdge]`](#containerrepositorytagedge) | エッジのリスト。 |
| <a id="containerrepositorytagconnectionnodes"></a>`nodes` | [`[ContainerRepositoryTag]`](#containerrepositorytag) | ノードのリスト。 |
| <a id="containerrepositorytagconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ContainerRepositoryTagEdge`

[`ContainerRepositoryTag`](#containerrepositorytag)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="containerrepositorytagedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="containerrepositorytagedgenode"></a>`node` | [`ContainerRepositoryTag`](#containerrepositorytag) | エッジの終端にあるアイテム。 |

#### `ContributionAnalyticsContributionConnection`

[`ContributionAnalyticsContribution`](#contributionanalyticscontribution)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="contributionanalyticscontributionconnectionedges"></a>`edges` | [`[ContributionAnalyticsContributionEdge]`](#contributionanalyticscontributionedge) | エッジのリスト。 |
| <a id="contributionanalyticscontributionconnectionnodes"></a>`nodes` | [`[ContributionAnalyticsContribution]`](#contributionanalyticscontribution) | ノードのリスト。 |
| <a id="contributionanalyticscontributionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ContributionAnalyticsContributionEdge`

[`ContributionAnalyticsContribution`](#contributionanalyticscontribution)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="contributionanalyticscontributionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="contributionanalyticscontributionedgenode"></a>`node` | [`ContributionAnalyticsContribution`](#contributionanalyticscontribution) | エッジの終端にあるアイテム。 |

#### `CoverageFuzzingCorpusConnection`

[`CoverageFuzzingCorpus`](#coveragefuzzingcorpus)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="coveragefuzzingcorpusconnectionedges"></a>`edges` | [`[CoverageFuzzingCorpusEdge]`](#coveragefuzzingcorpusedge) | エッジのリスト。 |
| <a id="coveragefuzzingcorpusconnectionnodes"></a>`nodes` | [`[CoverageFuzzingCorpus]`](#coveragefuzzingcorpus) | ノードのリスト。 |
| <a id="coveragefuzzingcorpusconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CoverageFuzzingCorpusEdge`

[`CoverageFuzzingCorpus`](#coveragefuzzingcorpus)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="coveragefuzzingcorpusedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="coveragefuzzingcorpusedgenode"></a>`node` | [`CoverageFuzzingCorpus`](#coveragefuzzingcorpus) | エッジの終端にあるアイテム。 |

#### `CustomEmojiConnection`

[`CustomEmoji`](#customemoji)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customemojiconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="customemojiconnectionedges"></a>`edges` | [`[CustomEmojiEdge]`](#customemojiedge) | エッジのリスト。 |
| <a id="customemojiconnectionnodes"></a>`nodes` | [`[CustomEmoji]`](#customemoji) | ノードのリスト。 |
| <a id="customemojiconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CustomEmojiEdge`

[`CustomEmoji`](#customemoji)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customemojiedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="customemojiedgenode"></a>`node` | [`CustomEmoji`](#customemoji) | エッジの終端にあるアイテム。 |

#### `CustomFieldConnection`

[`CustomField`](#customfield)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customfieldconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="customfieldconnectionedges"></a>`edges` | [`[CustomFieldEdge]`](#customfieldedge) | エッジのリスト。 |
| <a id="customfieldconnectionnodes"></a>`nodes` | [`[CustomField]`](#customfield) | ノードのリスト。 |
| <a id="customfieldconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CustomFieldEdge`

[`CustomField`](#customfield)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customfieldedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="customfieldedgenode"></a>`node` | [`CustomField`](#customfield) | エッジの終端にあるアイテム。 |

#### `CustomerRelationsContactConnection`

[`CustomerRelationsContact`](#customerrelationscontact)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customerrelationscontactconnectionedges"></a>`edges` | [`[CustomerRelationsContactEdge]`](#customerrelationscontactedge) | エッジのリスト。 |
| <a id="customerrelationscontactconnectionnodes"></a>`nodes` | [`[CustomerRelationsContact]`](#customerrelationscontact) | ノードのリスト。 |
| <a id="customerrelationscontactconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CustomerRelationsContactEdge`

[`CustomerRelationsContact`](#customerrelationscontact)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customerrelationscontactedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="customerrelationscontactedgenode"></a>`node` | [`CustomerRelationsContact`](#customerrelationscontact) | エッジの終端にあるアイテム。 |

#### `CustomerRelationsOrganizationConnection`

[`CustomerRelationsOrganization`](#customerrelationsorganization)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customerrelationsorganizationconnectionedges"></a>`edges` | [`[CustomerRelationsOrganizationEdge]`](#customerrelationsorganizationedge) | エッジのリスト。 |
| <a id="customerrelationsorganizationconnectionnodes"></a>`nodes` | [`[CustomerRelationsOrganization]`](#customerrelationsorganization) | ノードのリスト。 |
| <a id="customerrelationsorganizationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CustomerRelationsOrganizationEdge`

[`CustomerRelationsOrganization`](#customerrelationsorganization)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customerrelationsorganizationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="customerrelationsorganizationedgenode"></a>`node` | [`CustomerRelationsOrganization`](#customerrelationsorganization) | エッジの終端にあるアイテム。 |

#### `CustomizableAdminPermissionConnection`

[`CustomizableAdminPermission`](#customizableadminpermission)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customizableadminpermissionconnectionedges"></a>`edges` | [`[CustomizableAdminPermissionEdge]`](#customizableadminpermissionedge) | エッジのリスト。 |
| <a id="customizableadminpermissionconnectionnodes"></a>`nodes` | [`[CustomizableAdminPermission]`](#customizableadminpermission) | ノードのリスト。 |
| <a id="customizableadminpermissionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CustomizableAdminPermissionEdge`

[`CustomizableAdminPermission`](#customizableadminpermission)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customizableadminpermissionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="customizableadminpermissionedgenode"></a>`node` | [`CustomizableAdminPermission`](#customizableadminpermission) | エッジの終端にあるアイテム。 |

#### `CustomizableDashboardConnection`

[`CustomizableDashboard`](#customizabledashboard)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customizabledashboardconnectionedges"></a>`edges` | [`[CustomizableDashboardEdge]`](#customizabledashboardedge) | エッジのリスト。 |
| <a id="customizabledashboardconnectionnodes"></a>`nodes` | [`[CustomizableDashboard]`](#customizabledashboard) | ノードのリスト。 |
| <a id="customizabledashboardconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CustomizableDashboardEdge`

[`CustomizableDashboard`](#customizabledashboard)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customizabledashboardedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="customizabledashboardedgenode"></a>`node` | [`CustomizableDashboard`](#customizabledashboard) | エッジの終端にあるアイテム。 |

#### `CustomizableDashboardPanelConnection`

[`CustomizableDashboardPanel`](#customizabledashboardpanel)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customizabledashboardpanelconnectionedges"></a>`edges` | [`[CustomizableDashboardPanelEdge]`](#customizabledashboardpaneledge) | エッジのリスト。 |
| <a id="customizabledashboardpanelconnectionnodes"></a>`nodes` | [`[CustomizableDashboardPanel]`](#customizabledashboardpanel) | ノードのリスト。 |
| <a id="customizabledashboardpanelconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CustomizableDashboardPanelEdge`

[`CustomizableDashboardPanel`](#customizabledashboardpanel)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customizabledashboardpaneledgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="customizabledashboardpaneledgenode"></a>`node` | [`CustomizableDashboardPanel`](#customizabledashboardpanel) | エッジの終端にあるアイテム。 |

#### `CustomizableDashboardVisualizationConnection`

[`CustomizableDashboardVisualization`](#customizabledashboardvisualization)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customizabledashboardvisualizationconnectionedges"></a>`edges` | [`[CustomizableDashboardVisualizationEdge]`](#customizabledashboardvisualizationedge) | エッジのリスト。 |
| <a id="customizabledashboardvisualizationconnectionnodes"></a>`nodes` | [`[CustomizableDashboardVisualization]`](#customizabledashboardvisualization) | ノードのリスト。 |
| <a id="customizabledashboardvisualizationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CustomizableDashboardVisualizationEdge`

[`CustomizableDashboardVisualization`](#customizabledashboardvisualization)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customizabledashboardvisualizationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="customizabledashboardvisualizationedgenode"></a>`node` | [`CustomizableDashboardVisualization`](#customizabledashboardvisualization) | エッジの終端にあるアイテム。 |

#### `CustomizableStandardPermissionConnection`

[`CustomizableStandardPermission`](#customizablestandardpermission)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customizablestandardpermissionconnectionedges"></a>`edges` | [`[CustomizableStandardPermissionEdge]`](#customizablestandardpermissionedge) | エッジのリスト。 |
| <a id="customizablestandardpermissionconnectionnodes"></a>`nodes` | [`[CustomizableStandardPermission]`](#customizablestandardpermission) | ノードのリスト。 |
| <a id="customizablestandardpermissionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CustomizableStandardPermissionEdge`

[`CustomizableStandardPermission`](#customizablestandardpermission)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customizablestandardpermissionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="customizablestandardpermissionedgenode"></a>`node` | [`CustomizableStandardPermission`](#customizablestandardpermission) | エッジの終端にあるアイテム。 |

#### `DastProfileConnection`

[`DastProfile`](#dastprofile)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dastprofileconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="dastprofileconnectionedges"></a>`edges` | [`[DastProfileEdge]`](#dastprofileedge) | エッジのリスト。 |
| <a id="dastprofileconnectionnodes"></a>`nodes` | [`[DastProfile]`](#dastprofile) | ノードのリスト。 |
| <a id="dastprofileconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DastProfileEdge`

[`DastProfile`](#dastprofile)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dastprofileedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="dastprofileedgenode"></a>`node` | [`DastProfile`](#dastprofile) | エッジの終端にあるアイテム。 |

#### `DastScannerProfileConnection`

[`DastScannerProfile`](#dastscannerprofile)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dastscannerprofileconnectionedges"></a>`edges` | [`[DastScannerProfileEdge]`](#dastscannerprofileedge) | エッジのリスト。 |
| <a id="dastscannerprofileconnectionnodes"></a>`nodes` | [`[DastScannerProfile]`](#dastscannerprofile) | ノードのリスト。 |
| <a id="dastscannerprofileconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DastScannerProfileEdge`

[`DastScannerProfile`](#dastscannerprofile)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dastscannerprofileedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="dastscannerprofileedgenode"></a>`node` | [`DastScannerProfile`](#dastscannerprofile) | エッジの終端にあるアイテム。 |

#### `DastSiteProfileConnection`

[`DastSiteProfile`](#dastsiteprofile)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dastsiteprofileconnectionedges"></a>`edges` | [`[DastSiteProfileEdge]`](#dastsiteprofileedge) | エッジのリスト。 |
| <a id="dastsiteprofileconnectionnodes"></a>`nodes` | [`[DastSiteProfile]`](#dastsiteprofile) | ノードのリスト。 |
| <a id="dastsiteprofileconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DastSiteProfileEdge`

[`DastSiteProfile`](#dastsiteprofile)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dastsiteprofileedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="dastsiteprofileedgenode"></a>`node` | [`DastSiteProfile`](#dastsiteprofile) | エッジの終端にあるアイテム。 |

#### `DastSiteValidationConnection`

[`DastSiteValidation`](#dastsitevalidation)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dastsitevalidationconnectionedges"></a>`edges` | [`[DastSiteValidationEdge]`](#dastsitevalidationedge) | エッジのリスト。 |
| <a id="dastsitevalidationconnectionnodes"></a>`nodes` | [`[DastSiteValidation]`](#dastsitevalidation) | ノードのリスト。 |
| <a id="dastsitevalidationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DastSiteValidationEdge`

[`DastSiteValidation`](#dastsitevalidation)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dastsitevalidationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="dastsitevalidationedgenode"></a>`node` | [`DastSiteValidation`](#dastsitevalidation) | エッジの終端にあるアイテム。 |

#### `DependencyConnection`

[`Dependency`](#dependency)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dependencyconnectionedges"></a>`edges` | [`[DependencyEdge]`](#dependencyedge) | エッジのリスト。 |
| <a id="dependencyconnectionnodes"></a>`nodes` | [`[Dependency]`](#dependency) | ノードのリスト。 |
| <a id="dependencyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DependencyEdge`

[`Dependency`](#dependency)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dependencyedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="dependencyedgenode"></a>`node` | [`Dependency`](#dependency) | エッジの終端にあるアイテム。 |

#### `DependencyProxyBlobConnection`

[`DependencyProxyBlob`](#dependencyproxyblob)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dependencyproxyblobconnectionedges"></a>`edges` | [`[DependencyProxyBlobEdge]`](#dependencyproxyblobedge) | エッジのリスト。 |
| <a id="dependencyproxyblobconnectionnodes"></a>`nodes` | [`[DependencyProxyBlob]`](#dependencyproxyblob) | ノードのリスト。 |
| <a id="dependencyproxyblobconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DependencyProxyBlobEdge`

[`DependencyProxyBlob`](#dependencyproxyblob)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dependencyproxyblobedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="dependencyproxyblobedgenode"></a>`node` | [`DependencyProxyBlob`](#dependencyproxyblob) | エッジの終端にあるアイテム。 |

#### `DependencyProxyBlobRegistryConnection`

[`DependencyProxyBlobRegistry`](#dependencyproxyblobregistry)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dependencyproxyblobregistryconnectionedges"></a>`edges` | [`[DependencyProxyBlobRegistryEdge]`](#dependencyproxyblobregistryedge) | エッジのリスト。 |
| <a id="dependencyproxyblobregistryconnectionnodes"></a>`nodes` | [`[DependencyProxyBlobRegistry]`](#dependencyproxyblobregistry) | ノードのリスト。 |
| <a id="dependencyproxyblobregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド

###### `DependencyProxyBlobRegistryConnection.count`

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dependencyproxyblobregistryconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `DependencyProxyBlobRegistryEdge`

[`DependencyProxyBlobRegistry`](#dependencyproxyblobregistry)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dependencyproxyblobregistryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="dependencyproxyblobregistryedgenode"></a>`node` | [`DependencyProxyBlobRegistry`](#dependencyproxyblobregistry) | エッジの終端にあるアイテム。 |

#### `DependencyProxyManifestConnection`

[`DependencyProxyManifest`](#dependencyproxymanifest)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dependencyproxymanifestconnectionedges"></a>`edges` | [`[DependencyProxyManifestEdge]`](#dependencyproxymanifestedge) | エッジのリスト。 |
| <a id="dependencyproxymanifestconnectionnodes"></a>`nodes` | [`[DependencyProxyManifest]`](#dependencyproxymanifest) | ノードのリスト。 |
| <a id="dependencyproxymanifestconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DependencyProxyManifestEdge`

[`DependencyProxyManifest`](#dependencyproxymanifest)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dependencyproxymanifestedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="dependencyproxymanifestedgenode"></a>`node` | [`DependencyProxyManifest`](#dependencyproxymanifest) | エッジの終端にあるアイテム。 |

#### `DependencyProxyManifestRegistryConnection`

[`DependencyProxyManifestRegistry`](#dependencyproxymanifestregistry)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dependencyproxymanifestregistryconnectionedges"></a>`edges` | [`[DependencyProxyManifestRegistryEdge]`](#dependencyproxymanifestregistryedge) | エッジのリスト。 |
| <a id="dependencyproxymanifestregistryconnectionnodes"></a>`nodes` | [`[DependencyProxyManifestRegistry]`](#dependencyproxymanifestregistry) | ノードのリスト。 |
| <a id="dependencyproxymanifestregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド

###### `DependencyProxyManifestRegistryConnection.count`

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dependencyproxymanifestregistryconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `DependencyProxyManifestRegistryEdge`

[`DependencyProxyManifestRegistry`](#dependencyproxymanifestregistry)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dependencyproxymanifestregistryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="dependencyproxymanifestregistryedgenode"></a>`node` | [`DependencyProxyManifestRegistry`](#dependencyproxymanifestregistry) | エッジの終端にあるアイテム。 |

#### `DeploymentConnection`

[`Deployment`](#deployment)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="deploymentconnectionedges"></a>`edges` | [`[DeploymentEdge]`](#deploymentedge) | エッジのリスト。 |
| <a id="deploymentconnectionnodes"></a>`nodes` | [`[Deployment]`](#deployment) | ノードのリスト。 |
| <a id="deploymentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DeploymentEdge`

[`Deployment`](#deployment)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="deploymentedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="deploymentedgenode"></a>`node` | [`Deployment`](#deployment) | エッジの終端にあるアイテム。 |

#### `DesignAtVersionConnection`

[`DesignAtVersion`](#designatversion)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="designatversionconnectionedges"></a>`edges` | [`[DesignAtVersionEdge]`](#designatversionedge) | エッジのリスト。 |
| <a id="designatversionconnectionnodes"></a>`nodes` | [`[DesignAtVersion]`](#designatversion) | ノードのリスト。 |
| <a id="designatversionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DesignAtVersionEdge`

[`DesignAtVersion`](#designatversion)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="designatversionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="designatversionedgenode"></a>`node` | [`DesignAtVersion`](#designatversion) | エッジの終端にあるアイテム。 |

#### `DesignConnection`

[`Design`](#design)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="designconnectionedges"></a>`edges` | [`[DesignEdge]`](#designedge) | エッジのリスト。 |
| <a id="designconnectionnodes"></a>`nodes` | [`[Design]`](#design) | ノードのリスト。 |
| <a id="designconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DesignEdge`

[`Design`](#design)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="designedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="designedgenode"></a>`node` | [`Design`](#design) | エッジの終端にあるアイテム。 |

#### `DesignManagementRepositoryRegistryConnection`

[`DesignManagementRepositoryRegistry`](#designmanagementrepositoryregistry)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="designmanagementrepositoryregistryconnectionedges"></a>`edges` | [`[DesignManagementRepositoryRegistryEdge]`](#designmanagementrepositoryregistryedge) | エッジのリスト。 |
| <a id="designmanagementrepositoryregistryconnectionnodes"></a>`nodes` | [`[DesignManagementRepositoryRegistry]`](#designmanagementrepositoryregistry) | ノードのリスト。 |
| <a id="designmanagementrepositoryregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド

###### `DesignManagementRepositoryRegistryConnection.count`

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="designmanagementrepositoryregistryconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `DesignManagementRepositoryRegistryEdge`

[`DesignManagementRepositoryRegistry`](#designmanagementrepositoryregistry)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="designmanagementrepositoryregistryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="designmanagementrepositoryregistryedgenode"></a>`node` | [`DesignManagementRepositoryRegistry`](#designmanagementrepositoryregistry) | エッジの終端にあるアイテム。 |

#### `DesignVersionConnection`

[`DesignVersion`](#designversion)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="designversionconnectionedges"></a>`edges` | [`[DesignVersionEdge]`](#designversionedge) | エッジのリスト。 |
| <a id="designversionconnectionnodes"></a>`nodes` | [`[DesignVersion]`](#designversion) | ノードのリスト。 |
| <a id="designversionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DesignVersionEdge`

[`DesignVersion`](#designversion)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="designversionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="designversionedgenode"></a>`node` | [`DesignVersion`](#designversion) | エッジの終端にあるアイテム。 |

#### `DevopsAdoptionEnabledNamespaceConnection`

[`DevopsAdoptionEnabledNamespace`](#devopsadoptionenablednamespace)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="devopsadoptionenablednamespaceconnectionedges"></a>`edges` | [`[DevopsAdoptionEnabledNamespaceEdge]`](#devopsadoptionenablednamespaceedge) | エッジのリスト。 |
| <a id="devopsadoptionenablednamespaceconnectionnodes"></a>`nodes` | [`[DevopsAdoptionEnabledNamespace]`](#devopsadoptionenablednamespace) | ノードのリスト。 |
| <a id="devopsadoptionenablednamespaceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DevopsAdoptionEnabledNamespaceEdge`

[`DevopsAdoptionEnabledNamespace`](#devopsadoptionenablednamespace)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="devopsadoptionenablednamespaceedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="devopsadoptionenablednamespaceedgenode"></a>`node` | [`DevopsAdoptionEnabledNamespace`](#devopsadoptionenablednamespace) | エッジの終端にあるアイテム。 |

#### `DevopsAdoptionSnapshotConnection`

[`DevopsAdoptionSnapshot`](#devopsadoptionsnapshot)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="devopsadoptionsnapshotconnectionedges"></a>`edges` | [`[DevopsAdoptionSnapshotEdge]`](#devopsadoptionsnapshotedge) | エッジのリスト。 |
| <a id="devopsadoptionsnapshotconnectionnodes"></a>`nodes` | [`[DevopsAdoptionSnapshot]`](#devopsadoptionsnapshot) | ノードのリスト。 |
| <a id="devopsadoptionsnapshotconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DevopsAdoptionSnapshotEdge`

[`DevopsAdoptionSnapshot`](#devopsadoptionsnapshot)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="devopsadoptionsnapshotedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="devopsadoptionsnapshotedgenode"></a>`node` | [`DevopsAdoptionSnapshot`](#devopsadoptionsnapshot) | エッジの終端にあるアイテム。 |

#### `DiscussionConnection`

[`Discussion`](#discussion)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="discussionconnectionedges"></a>`edges` | [`[DiscussionEdge]`](#discussionedge) | エッジのリスト。 |
| <a id="discussionconnectionnodes"></a>`nodes` | [`[Discussion]`](#discussion) | ノードのリスト。 |
| <a id="discussionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DiscussionEdge`

[`Discussion`](#discussion)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="discussionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="discussionedgenode"></a>`node` | [`Discussion`](#discussion) | エッジの終端にあるアイテム。 |

#### `DoraPerformanceScoreCountConnection`

[`DoraPerformanceScoreCount`](#doraperformancescorecount)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="doraperformancescorecountconnectionedges"></a>`edges` | [`[DoraPerformanceScoreCountEdge]`](#doraperformancescorecountedge) | エッジのリスト。 |
| <a id="doraperformancescorecountconnectionnodoradataprojectscount"></a>`noDoraDataProjectsCount` | [`Int!`](#int) | スコープ内にDORAスコアがないプロジェクトの数。 |
| <a id="doraperformancescorecountconnectionnodes"></a>`nodes` | [`[DoraPerformanceScoreCount]`](#doraperformancescorecount) | ノードのリスト。 |
| <a id="doraperformancescorecountconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |
| <a id="doraperformancescorecountconnectiontotalprojectscount"></a>`totalProjectsCount` | [`Int!`](#int) | プロジェクトの総数。 |

#### `DoraPerformanceScoreCountEdge`

[`DoraPerformanceScoreCount`](#doraperformancescorecount)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="doraperformancescorecountedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="doraperformancescorecountedgenode"></a>`node` | [`DoraPerformanceScoreCount`](#doraperformancescorecount) | エッジの終端にあるアイテム。 |

#### `DuoWorkflowConnection`

[`DuoWorkflow`](#duoworkflow)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="duoworkflowconnectionedges"></a>`edges` | [`[DuoWorkflowEdge]`](#duoworkflowedge) | エッジのリスト。 |
| <a id="duoworkflowconnectionnodes"></a>`nodes` | [`[DuoWorkflow]`](#duoworkflow) | ノードのリスト。 |
| <a id="duoworkflowconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DuoWorkflowEdge`

[`DuoWorkflow`](#duoworkflow)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="duoworkflowedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="duoworkflowedgenode"></a>`node` | [`DuoWorkflow`](#duoworkflow) | エッジの終端にあるアイテム。 |

#### `DuoWorkflowEventConnection`

[`DuoWorkflowEvent`](#duoworkflowevent)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="duoworkfloweventconnectionedges"></a>`edges` | [`[DuoWorkflowEventEdge]`](#duoworkfloweventedge) | エッジのリスト。 |
| <a id="duoworkfloweventconnectionnodes"></a>`nodes` | [`[DuoWorkflowEvent]`](#duoworkflowevent) | ノードのリスト。 |
| <a id="duoworkfloweventconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DuoWorkflowEventEdge`

[`DuoWorkflowEvent`](#duoworkflowevent)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="duoworkfloweventedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="duoworkfloweventedgenode"></a>`node` | [`DuoWorkflowEvent`](#duoworkflowevent) | エッジの終端にあるアイテム。 |

#### `EgressNodeConnection`

[`EgressNode`](#egressnode)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="egressnodeconnectionedges"></a>`edges` | [`[EgressNodeEdge]`](#egressnodeedge) | エッジのリスト。 |
| <a id="egressnodeconnectionnodes"></a>`nodes` | [`[EgressNode]`](#egressnode) | ノードのリスト。 |
| <a id="egressnodeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `EgressNodeEdge`

[`EgressNode`](#egressnode)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="egressnodeedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="egressnodeedgenode"></a>`node` | [`EgressNode`](#egressnode) | エッジの終端にあるアイテム。 |

#### `EmailConnection`

[`Email`](#email)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="emailconnectionedges"></a>`edges` | [`[EmailEdge]`](#emailedge) | エッジのリスト。 |
| <a id="emailconnectionnodes"></a>`nodes` | [`[Email]`](#email) | ノードのリスト。 |
| <a id="emailconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `EmailEdge`

[`Email`](#email)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="emailedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="emailedgenode"></a>`node` | [`Email`](#email) | エッジの終端にあるアイテム。 |

#### `EmailParticipantTypeConnection`

[`EmailParticipantType`](#emailparticipanttype)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="emailparticipanttypeconnectionedges"></a>`edges` | [`[EmailParticipantTypeEdge]`](#emailparticipanttypeedge) | エッジのリスト。 |
| <a id="emailparticipanttypeconnectionnodes"></a>`nodes` | [`[EmailParticipantType]`](#emailparticipanttype) | ノードのリスト。 |
| <a id="emailparticipanttypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `EmailParticipantTypeEdge`

[`EmailParticipantType`](#emailparticipanttype)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="emailparticipanttypeedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="emailparticipanttypeedgenode"></a>`node` | [`EmailParticipantType`](#emailparticipanttype) | エッジの終端にあるアイテム。 |

#### `EnvironmentConnection`

[`Environment`](#environment)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="environmentconnectionedges"></a>`edges` | [`[EnvironmentEdge]`](#environmentedge) | エッジのリスト。 |
| <a id="environmentconnectionnodes"></a>`nodes` | [`[Environment]`](#environment) | ノードのリスト。 |
| <a id="environmentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `EnvironmentEdge`

[`Environment`](#environment)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="environmentedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="environmentedgenode"></a>`node` | [`Environment`](#environment) | エッジの終端にあるアイテム。 |

#### `EpicBoardConnection`

[`EpicBoard`](#epicboard)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="epicboardconnectionedges"></a>`edges` | [`[EpicBoardEdge]`](#epicboardedge) | エッジのリスト。 |
| <a id="epicboardconnectionnodes"></a>`nodes` | [`[EpicBoard]`](#epicboard) | ノードのリスト。 |
| <a id="epicboardconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `EpicBoardEdge`

[`EpicBoard`](#epicboard)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="epicboardedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="epicboardedgenode"></a>`node` | [`EpicBoard`](#epicboard) | エッジの終端にあるアイテム。 |

#### `EpicConnection`

[`Epic`](#epic)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="epicconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="epicconnectionedges"></a>`edges` | [`[EpicEdge]`](#epicedge) | エッジのリスト。 |
| <a id="epicconnectionnodes"></a>`nodes` | [`[Epic]`](#epic) | ノードのリスト。 |
| <a id="epicconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `EpicEdge`

[`Epic`](#epic)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="epicedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="epicedgenode"></a>`node` | [`Epic`](#epic) | エッジの終端にあるアイテム。 |

#### `EpicIssueConnection`

[`EpicIssue`](#epicissue)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="epicissueconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="epicissueconnectionedges"></a>`edges` | [`[EpicIssueEdge]`](#epicissueedge) | エッジのリスト。 |
| <a id="epicissueconnectionnodes"></a>`nodes` | [`[EpicIssue]`](#epicissue) | ノードのリスト。 |
| <a id="epicissueconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |
| <a id="epicissueconnectionweight"></a>`weight` | [`Int!`](#int) | イシューコレクションの合計ウェイト。 |

#### `EpicIssueEdge`

[`EpicIssue`](#epicissue)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="epicissueedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="epicissueedgenode"></a>`node` | [`EpicIssue`](#epicissue) | エッジの終端にあるアイテム。 |

#### `EpicListConnection`

[`EpicList`](#epiclist)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="epiclistconnectionedges"></a>`edges` | [`[EpicListEdge]`](#epiclistedge) | エッジのリスト。 |
| <a id="epiclistconnectionnodes"></a>`nodes` | [`[EpicList]`](#epiclist) | ノードのリスト。 |
| <a id="epiclistconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `EpicListEdge`

[`EpicList`](#epiclist)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="epiclistedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="epiclistedgenode"></a>`node` | [`EpicList`](#epiclist) | エッジの終端にあるアイテム。 |

#### `ErrorTrackingStackTraceConnection`

[`ErrorTrackingStackTrace`](#errortrackingstacktrace)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="errortrackingstacktraceconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="errortrackingstacktraceconnectionedges"></a>`edges` | [`[ErrorTrackingStackTraceEdge]`](#errortrackingstacktraceedge) | エッジのリスト。 |
| <a id="errortrackingstacktraceconnectionnodes"></a>`nodes` | [`[ErrorTrackingStackTrace]`](#errortrackingstacktrace) | ノードのリスト。 |
| <a id="errortrackingstacktraceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ErrorTrackingStackTraceEdge`

[`ErrorTrackingStackTrace`](#errortrackingstacktrace)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="errortrackingstacktraceedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="errortrackingstacktraceedgenode"></a>`node` | [`ErrorTrackingStackTrace`](#errortrackingstacktrace) | エッジの終端にあるアイテム。 |

#### `EscalationPolicyTypeConnection`

[`EscalationPolicyType`](#escalationpolicytype)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="escalationpolicytypeconnectionedges"></a>`edges` | [`[EscalationPolicyTypeEdge]`](#escalationpolicytypeedge) | エッジのリスト。 |
| <a id="escalationpolicytypeconnectionnodes"></a>`nodes` | [`[EscalationPolicyType]`](#escalationpolicytype) | ノードのリスト。 |
| <a id="escalationpolicytypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `EscalationPolicyTypeEdge`

[`EscalationPolicyType`](#escalationpolicytype)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="escalationpolicytypeedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="escalationpolicytypeedgenode"></a>`node` | [`EscalationPolicyType`](#escalationpolicytype) | エッジの終端にあるアイテム。 |

#### `EventConnection`

[`Event`](#event)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="eventconnectionedges"></a>`edges` | [`[EventEdge]`](#eventedge) | エッジのリスト。 |
| <a id="eventconnectionnodes"></a>`nodes` | [`[Event]`](#event) | ノードのリスト。 |
| <a id="eventconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `EventEdge`

[`Event`](#event)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="eventedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="eventedgenode"></a>`node` | [`Event`](#event) | エッジの終端にあるアイテム。 |

#### `ExternalAuditEventDestinationConnection`

[`ExternalAuditEventDestination`](#externalauditeventdestination)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="externalauditeventdestinationconnectionedges"></a>`edges` | [`[ExternalAuditEventDestinationEdge]`](#externalauditeventdestinationedge) | エッジのリスト。 |
| <a id="externalauditeventdestinationconnectionnodes"></a>`nodes` | [`[ExternalAuditEventDestination]`](#externalauditeventdestination) | ノードのリスト。 |
| <a id="externalauditeventdestinationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ExternalAuditEventDestinationEdge`

[`ExternalAuditEventDestination`](#externalauditeventdestination)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="externalauditeventdestinationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="externalauditeventdestinationedgenode"></a>`node` | [`ExternalAuditEventDestination`](#externalauditeventdestination) | エッジの終端にあるアイテム。 |

#### `ExternalStatusCheckConnection`

[`ExternalStatusCheck`](#externalstatuscheck)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="externalstatuscheckconnectionedges"></a>`edges` | [`[ExternalStatusCheckEdge]`](#externalstatuscheckedge) | エッジのリスト。 |
| <a id="externalstatuscheckconnectionnodes"></a>`nodes` | [`[ExternalStatusCheck]`](#externalstatuscheck) | ノードのリスト。 |
| <a id="externalstatuscheckconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ExternalStatusCheckEdge`

[`ExternalStatusCheck`](#externalstatuscheck)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="externalstatuscheckedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="externalstatuscheckedgenode"></a>`node` | [`ExternalStatusCheck`](#externalstatuscheck) | エッジの終端にあるアイテム。 |

#### `FeatureFlagConnection`

[`FeatureFlag`](#featureflag)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="featureflagconnectionedges"></a>`edges` | [`[FeatureFlagEdge]`](#featureflagedge) | エッジのリスト。 |
| <a id="featureflagconnectionnodes"></a>`nodes` | [`[FeatureFlag]`](#featureflag) | ノードのリスト。 |
| <a id="featureflagconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `FeatureFlagEdge`

[`FeatureFlag`](#featureflag)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="featureflagedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="featureflagedgenode"></a>`node` | [`FeatureFlag`](#featureflag) | エッジの終端にあるアイテム。 |

#### `GitlabSubscriptionHistoryConnection`

[`GitlabSubscriptionHistory`](#gitlabsubscriptionhistory)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="gitlabsubscriptionhistoryconnectionedges"></a>`edges` | [`[GitlabSubscriptionHistoryEdge]`](#gitlabsubscriptionhistoryedge) | エッジのリスト。 |
| <a id="gitlabsubscriptionhistoryconnectionnodes"></a>`nodes` | [`[GitlabSubscriptionHistory]`](#gitlabsubscriptionhistory) | ノードのリスト。 |
| <a id="gitlabsubscriptionhistoryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `GitlabSubscriptionHistoryEdge`

[`GitlabSubscriptionHistory`](#gitlabsubscriptionhistory)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="gitlabsubscriptionhistoryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="gitlabsubscriptionhistoryedgenode"></a>`node` | [`GitlabSubscriptionHistory`](#gitlabsubscriptionhistory) | エッジの終端にあるアイテム。 |

#### `GoogleCloudArtifactRegistryArtifactConnection`

[`GoogleCloudArtifactRegistryArtifact`](#googlecloudartifactregistryartifact)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="googlecloudartifactregistryartifactconnectionedges"></a>`edges` | [`[GoogleCloudArtifactRegistryArtifactEdge]`](#googlecloudartifactregistryartifactedge) | エッジのリスト。 |
| <a id="googlecloudartifactregistryartifactconnectionnodes"></a>`nodes` | [`[GoogleCloudArtifactRegistryArtifact]`](#googlecloudartifactregistryartifact) | ノードのリスト。 |
| <a id="googlecloudartifactregistryartifactconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `GoogleCloudArtifactRegistryArtifactEdge`

[`GoogleCloudArtifactRegistryArtifact`](#googlecloudartifactregistryartifact)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="googlecloudartifactregistryartifactedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="googlecloudartifactregistryartifactedgenode"></a>`node` | [`GoogleCloudArtifactRegistryArtifact`](#googlecloudartifactregistryartifact) | エッジの終端にあるアイテム。 |

#### `GoogleCloudLoggingConfigurationTypeConnection`

[`GoogleCloudLoggingConfigurationType`](#googlecloudloggingconfigurationtype)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="googlecloudloggingconfigurationtypeconnectionedges"></a>`edges` | [`[GoogleCloudLoggingConfigurationTypeEdge]`](#googlecloudloggingconfigurationtypeedge) | エッジのリスト。 |
| <a id="googlecloudloggingconfigurationtypeconnectionnodes"></a>`nodes` | [`[GoogleCloudLoggingConfigurationType]`](#googlecloudloggingconfigurationtype) | ノードのリスト。 |
| <a id="googlecloudloggingconfigurationtypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `GoogleCloudLoggingConfigurationTypeEdge`

[`GoogleCloudLoggingConfigurationType`](#googlecloudloggingconfigurationtype)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="googlecloudloggingconfigurationtypeedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="googlecloudloggingconfigurationtypeedgenode"></a>`node` | [`GoogleCloudLoggingConfigurationType`](#googlecloudloggingconfigurationtype) | エッジの終端にあるアイテム。 |

#### `GroupAuditEventStreamingDestinationConnection`

[`GroupAuditEventStreamingDestination`](#groupauditeventstreamingdestination)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="groupauditeventstreamingdestinationconnectionedges"></a>`edges` | [`[GroupAuditEventStreamingDestinationEdge]`](#groupauditeventstreamingdestinationedge) | エッジのリスト。 |
| <a id="groupauditeventstreamingdestinationconnectionnodes"></a>`nodes` | [`[GroupAuditEventStreamingDestination]`](#groupauditeventstreamingdestination) | ノードのリスト。 |
| <a id="groupauditeventstreamingdestinationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `GroupAuditEventStreamingDestinationEdge`

[`GroupAuditEventStreamingDestination`](#groupauditeventstreamingdestination)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="groupauditeventstreamingdestinationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="groupauditeventstreamingdestinationedgenode"></a>`node` | [`GroupAuditEventStreamingDestination`](#groupauditeventstreamingdestination) | エッジの終端にあるアイテム。 |

#### `GroupConnection`

[`Group`](#group)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="groupconnectionedges"></a>`edges` | [`[GroupEdge]`](#groupedge) | エッジのリスト。 |
| <a id="groupconnectionnodes"></a>`nodes` | [`[Group]`](#group) | ノードのリスト。 |
| <a id="groupconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `GroupEdge`

[`Group`](#group)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="groupedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="groupedgenode"></a>`node` | [`Group`](#group) | エッジの終端にあるアイテム。 |

#### `GroupMemberConnection`

[`GroupMember`](#groupmember)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="groupmemberconnectionedges"></a>`edges` | [`[GroupMemberEdge]`](#groupmemberedge) | エッジのリスト。 |
| <a id="groupmemberconnectionnodes"></a>`nodes` | [`[GroupMember]`](#groupmember) | ノードのリスト。 |
| <a id="groupmemberconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `GroupMemberEdge`

[`GroupMember`](#groupmember)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="groupmemberedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="groupmemberedgenode"></a>`node` | [`GroupMember`](#groupmember) | エッジの終端にあるアイテム。 |

#### `GroupSavedReplyConnection`

[`GroupSavedReply`](#groupsavedreply)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="groupsavedreplyconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="groupsavedreplyconnectionedges"></a>`edges` | [`[GroupSavedReplyEdge]`](#groupsavedreplyedge) | エッジのリスト。 |
| <a id="groupsavedreplyconnectionnodes"></a>`nodes` | [`[GroupSavedReply]`](#groupsavedreply) | ノードのリスト。 |
| <a id="groupsavedreplyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `GroupSavedReplyEdge`

[`GroupSavedReply`](#groupsavedreply)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="groupsavedreplyedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="groupsavedreplyedgenode"></a>`node` | [`GroupSavedReply`](#groupsavedreply) | エッジの終端にあるアイテム。 |

#### `GroupWikiRepositoryRegistryConnection`

[`GroupWikiRepositoryRegistry`](#groupwikirepositoryregistry)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="groupwikirepositoryregistryconnectionedges"></a>`edges` | [`[GroupWikiRepositoryRegistryEdge]`](#groupwikirepositoryregistryedge) | エッジのリスト。 |
| <a id="groupwikirepositoryregistryconnectionnodes"></a>`nodes` | [`[GroupWikiRepositoryRegistry]`](#groupwikirepositoryregistry) | ノードのリスト。 |
| <a id="groupwikirepositoryregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド

###### `GroupWikiRepositoryRegistryConnection.count`

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="groupwikirepositoryregistryconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `GroupWikiRepositoryRegistryEdge`

[`GroupWikiRepositoryRegistry`](#groupwikirepositoryregistry)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="groupwikirepositoryregistryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="groupwikirepositoryregistryedgenode"></a>`node` | [`GroupWikiRepositoryRegistry`](#groupwikirepositoryregistry) | エッジの終端にあるアイテム。 |

#### `ImportSourceUserConnection`

[`ImportSourceUser`](#importsourceuser)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="importsourceuserconnectionedges"></a>`edges` | [`[ImportSourceUserEdge]`](#importsourceuseredge) | エッジのリスト。 |
| <a id="importsourceuserconnectionnodes"></a>`nodes` | [`[ImportSourceUser]`](#importsourceuser) | ノードのリスト。 |
| <a id="importsourceuserconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ImportSourceUserEdge`

[`ImportSourceUser`](#importsourceuser)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="importsourceuseredgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="importsourceuseredgenode"></a>`node` | [`ImportSourceUser`](#importsourceuser) | エッジの終端にあるアイテム。 |

#### `IncidentManagementOncallRotationConnection`

[`IncidentManagementOncallRotation`](#incidentmanagementoncallrotation)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="incidentmanagementoncallrotationconnectionedges"></a>`edges` | [`[IncidentManagementOncallRotationEdge]`](#incidentmanagementoncallrotationedge) | エッジのリスト。 |
| <a id="incidentmanagementoncallrotationconnectionnodes"></a>`nodes` | [`[IncidentManagementOncallRotation]`](#incidentmanagementoncallrotation) | ノードのリスト。 |
| <a id="incidentmanagementoncallrotationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `IncidentManagementOncallRotationEdge`

[`IncidentManagementOncallRotation`](#incidentmanagementoncallrotation)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="incidentmanagementoncallrotationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="incidentmanagementoncallrotationedgenode"></a>`node` | [`IncidentManagementOncallRotation`](#incidentmanagementoncallrotation) | エッジの終端にあるアイテム。 |

#### `IncidentManagementOncallScheduleConnection`

[`IncidentManagementOncallSchedule`](#incidentmanagementoncallschedule)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="incidentmanagementoncallscheduleconnectionedges"></a>`edges` | [`[IncidentManagementOncallScheduleEdge]`](#incidentmanagementoncallscheduleedge) | エッジのリスト。 |
| <a id="incidentmanagementoncallscheduleconnectionnodes"></a>`nodes` | [`[IncidentManagementOncallSchedule]`](#incidentmanagementoncallschedule) | ノードのリスト。 |
| <a id="incidentmanagementoncallscheduleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `IncidentManagementOncallScheduleEdge`

[`IncidentManagementOncallSchedule`](#incidentmanagementoncallschedule)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="incidentmanagementoncallscheduleedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="incidentmanagementoncallscheduleedgenode"></a>`node` | [`IncidentManagementOncallSchedule`](#incidentmanagementoncallschedule) | エッジの終端にあるアイテム。 |

#### `IncidentManagementOncallShiftConnection`

[`IncidentManagementOncallShift`](#incidentmanagementoncallshift)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="incidentmanagementoncallshiftconnectionedges"></a>`edges` | [`[IncidentManagementOncallShiftEdge]`](#incidentmanagementoncallshiftedge) | エッジのリスト。 |
| <a id="incidentmanagementoncallshiftconnectionnodes"></a>`nodes` | [`[IncidentManagementOncallShift]`](#incidentmanagementoncallshift) | ノードのリスト。 |
| <a id="incidentmanagementoncallshiftconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `IncidentManagementOncallShiftEdge`

[`IncidentManagementOncallShift`](#incidentmanagementoncallshift)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="incidentmanagementoncallshiftedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="incidentmanagementoncallshiftedgenode"></a>`node` | [`IncidentManagementOncallShift`](#incidentmanagementoncallshift) | エッジの終端にあるアイテム。 |

#### `InheritedCiVariableConnection`

[`InheritedCiVariable`](#inheritedcivariable)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="inheritedcivariableconnectionedges"></a>`edges` | [`[InheritedCiVariableEdge]`](#inheritedcivariableedge) | エッジのリスト。 |
| <a id="inheritedcivariableconnectionnodes"></a>`nodes` | [`[InheritedCiVariable]`](#inheritedcivariable) | ノードのリスト。 |
| <a id="inheritedcivariableconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `InheritedCiVariableEdge`

[`InheritedCiVariable`](#inheritedcivariable)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="inheritedcivariableedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="inheritedcivariableedgenode"></a>`node` | [`InheritedCiVariable`](#inheritedcivariable) | エッジの終端にあるアイテム。 |

#### `InstanceAmazonS3ConfigurationTypeConnection`

[`InstanceAmazonS3ConfigurationType`](#instanceamazons3configurationtype)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="instanceamazons3configurationtypeconnectionedges"></a>`edges` | [`[InstanceAmazonS3ConfigurationTypeEdge]`](#instanceamazons3configurationtypeedge) | エッジのリスト。 |
| <a id="instanceamazons3configurationtypeconnectionnodes"></a>`nodes` | [`[InstanceAmazonS3ConfigurationType]`](#instanceamazons3configurationtype) | ノードのリスト。 |
| <a id="instanceamazons3configurationtypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `InstanceAmazonS3ConfigurationTypeEdge`

[`InstanceAmazonS3ConfigurationType`](#instanceamazons3configurationtype)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="instanceamazons3configurationtypeedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="instanceamazons3configurationtypeedgenode"></a>`node` | [`InstanceAmazonS3ConfigurationType`](#instanceamazons3configurationtype) | エッジの終端にあるアイテム。 |

#### `InstanceAuditEventStreamingDestinationConnection`

[`InstanceAuditEventStreamingDestination`](#instanceauditeventstreamingdestination)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="instanceauditeventstreamingdestinationconnectionedges"></a>`edges` | [`[InstanceAuditEventStreamingDestinationEdge]`](#instanceauditeventstreamingdestinationedge) | エッジのリスト。 |
| <a id="instanceauditeventstreamingdestinationconnectionnodes"></a>`nodes` | [`[InstanceAuditEventStreamingDestination]`](#instanceauditeventstreamingdestination) | ノードのリスト。 |
| <a id="instanceauditeventstreamingdestinationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `InstanceAuditEventStreamingDestinationEdge`

[`InstanceAuditEventStreamingDestination`](#instanceauditeventstreamingdestination)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="instanceauditeventstreamingdestinationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="instanceauditeventstreamingdestinationedgenode"></a>`node` | [`InstanceAuditEventStreamingDestination`](#instanceauditeventstreamingdestination) | エッジの終端にあるアイテム。 |

#### `InstanceExternalAuditEventDestinationConnection`

[`InstanceExternalAuditEventDestination`](#instanceexternalauditeventdestination)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="instanceexternalauditeventdestinationconnectionedges"></a>`edges` | [`[InstanceExternalAuditEventDestinationEdge]`](#instanceexternalauditeventdestinationedge) | エッジのリスト。 |
| <a id="instanceexternalauditeventdestinationconnectionnodes"></a>`nodes` | [`[InstanceExternalAuditEventDestination]`](#instanceexternalauditeventdestination) | ノードのリスト。 |
| <a id="instanceexternalauditeventdestinationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `InstanceExternalAuditEventDestinationEdge`

[`InstanceExternalAuditEventDestination`](#instanceexternalauditeventdestination)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="instanceexternalauditeventdestinationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="instanceexternalauditeventdestinationedgenode"></a>`node` | [`InstanceExternalAuditEventDestination`](#instanceexternalauditeventdestination) | エッジの終端にあるアイテム。 |

#### `InstanceGoogleCloudLoggingConfigurationTypeConnection`

[`InstanceGoogleCloudLoggingConfigurationType`](#instancegooglecloudloggingconfigurationtype)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="instancegooglecloudloggingconfigurationtypeconnectionedges"></a>`edges` | [`[InstanceGoogleCloudLoggingConfigurationTypeEdge]`](#instancegooglecloudloggingconfigurationtypeedge) | エッジのリスト。 |
| <a id="instancegooglecloudloggingconfigurationtypeconnectionnodes"></a>`nodes` | [`[InstanceGoogleCloudLoggingConfigurationType]`](#instancegooglecloudloggingconfigurationtype) | ノードのリスト。 |
| <a id="instancegooglecloudloggingconfigurationtypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `InstanceGoogleCloudLoggingConfigurationTypeEdge`

[`InstanceGoogleCloudLoggingConfigurationType`](#instancegooglecloudloggingconfigurationtype)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="instancegooglecloudloggingconfigurationtypeedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="instancegooglecloudloggingconfigurationtypeedgenode"></a>`node` | [`InstanceGoogleCloudLoggingConfigurationType`](#instancegooglecloudloggingconfigurationtype) | エッジの終端にあるアイテム。 |

#### `IntegrationExclusionConnection`

[`IntegrationExclusion`](#integrationexclusion)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="integrationexclusionconnectionedges"></a>`edges` | [`[IntegrationExclusionEdge]`](#integrationexclusionedge) | エッジのリスト。 |
| <a id="integrationexclusionconnectionnodes"></a>`nodes` | [`[IntegrationExclusion]`](#integrationexclusion) | ノードのリスト。 |
| <a id="integrationexclusionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `IntegrationExclusionEdge`

[`IntegrationExclusion`](#integrationexclusion)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="integrationexclusionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="integrationexclusionedgenode"></a>`node` | [`IntegrationExclusion`](#integrationexclusion) | エッジの終端にあるアイテム。 |

#### `IssuableResourceLinkConnection`

[`IssuableResourceLink`](#issuableresourcelink)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="issuableresourcelinkconnectionedges"></a>`edges` | [`[IssuableResourceLinkEdge]`](#issuableresourcelinkedge) | エッジのリスト。 |
| <a id="issuableresourcelinkconnectionnodes"></a>`nodes` | [`[IssuableResourceLink]`](#issuableresourcelink) | ノードのリスト。 |
| <a id="issuableresourcelinkconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `IssuableResourceLinkEdge`

[`IssuableResourceLink`](#issuableresourcelink)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="issuableresourcelinkedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="issuableresourcelinkedgenode"></a>`node` | [`IssuableResourceLink`](#issuableresourcelink) | エッジの終端にあるアイテム。 |

#### `IssueConnection`

[`Issue`](#issue)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="issueconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="issueconnectionedges"></a>`edges` | [`[IssueEdge]`](#issueedge) | エッジのリスト。 |
| <a id="issueconnectionnodes"></a>`nodes` | [`[Issue]`](#issue) | ノードのリスト。 |
| <a id="issueconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |
| <a id="issueconnectionweight"></a>`weight` | [`Int!`](#int) | イシューコレクションの合計ウェイト。 |

#### `IssueEdge`

[`Issue`](#issue)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="issueedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="issueedgenode"></a>`node` | [`Issue`](#issue) | エッジの終端にあるアイテム。 |

#### `IterationCadenceConnection`

[`IterationCadence`](#iterationcadence)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="iterationcadenceconnectionedges"></a>`edges` | [`[IterationCadenceEdge]`](#iterationcadenceedge) | エッジのリスト。 |
| <a id="iterationcadenceconnectionnodes"></a>`nodes` | [`[IterationCadence]`](#iterationcadence) | ノードのリスト。 |
| <a id="iterationcadenceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `IterationCadenceEdge`

[`IterationCadence`](#iterationcadence)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="iterationcadenceedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="iterationcadenceedgenode"></a>`node` | [`IterationCadence`](#iterationcadence) | エッジの終端にあるアイテム。 |

#### `IterationConnection`

[`Iteration`](#iteration)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="iterationconnectionedges"></a>`edges` | [`[IterationEdge]`](#iterationedge) | エッジのリスト。 |
| <a id="iterationconnectionnodes"></a>`nodes` | [`[Iteration]`](#iteration) | ノードのリスト。 |
| <a id="iterationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `IterationEdge`

[`Iteration`](#iteration)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="iterationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="iterationedgenode"></a>`node` | [`Iteration`](#iteration) | エッジの終端にあるアイテム。 |

#### `JiraImportConnection`

[`JiraImport`](#jiraimport)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="jiraimportconnectionedges"></a>`edges` | [`[JiraImportEdge]`](#jiraimportedge) | エッジのリスト。 |
| <a id="jiraimportconnectionnodes"></a>`nodes` | [`[JiraImport]`](#jiraimport) | ノードのリスト。 |
| <a id="jiraimportconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `JiraImportEdge`

[`JiraImport`](#jiraimport)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="jiraimportedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="jiraimportedgenode"></a>`node` | [`JiraImport`](#jiraimport) | エッジの終端にあるアイテム。 |

#### `JiraProjectConnection`

[`JiraProject`](#jiraproject)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="jiraprojectconnectionedges"></a>`edges` | [`[JiraProjectEdge]`](#jiraprojectedge) | エッジのリスト。 |
| <a id="jiraprojectconnectionnodes"></a>`nodes` | [`[JiraProject]`](#jiraproject) | ノードのリスト。 |
| <a id="jiraprojectconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `JiraProjectEdge`

[`JiraProject`](#jiraproject)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="jiraprojectedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="jiraprojectedgenode"></a>`node` | [`JiraProject`](#jiraproject) | エッジの終端にあるアイテム。 |

#### `JobArtifactRegistryConnection`

[`JobArtifactRegistry`](#jobartifactregistry)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="jobartifactregistryconnectionedges"></a>`edges` | [`[JobArtifactRegistryEdge]`](#jobartifactregistryedge) | エッジのリスト。 |
| <a id="jobartifactregistryconnectionnodes"></a>`nodes` | [`[JobArtifactRegistry]`](#jobartifactregistry) | ノードのリスト。 |
| <a id="jobartifactregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド

###### `JobArtifactRegistryConnection.count`

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="jobartifactregistryconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `JobArtifactRegistryEdge`

[`JobArtifactRegistry`](#jobartifactregistry)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="jobartifactregistryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="jobartifactregistryedgenode"></a>`node` | [`JobArtifactRegistry`](#jobartifactregistry) | エッジの終端にあるアイテム。 |

#### `JobNeedUnionConnection`

[`JobNeedUnion`](#jobneedunion)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="jobneedunionconnectionedges"></a>`edges` | [`[JobNeedUnionEdge]`](#jobneedunionedge) | エッジのリスト。 |
| <a id="jobneedunionconnectionnodes"></a>`nodes` | [`[JobNeedUnion]`](#jobneedunion) | ノードのリスト。 |
| <a id="jobneedunionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `JobNeedUnionEdge`

[`JobNeedUnion`](#jobneedunion)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="jobneedunionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="jobneedunionedgenode"></a>`node` | [`JobNeedUnion`](#jobneedunion) | エッジの終端にあるアイテム。 |

#### `LabelConnection`

[`Label`](#label)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="labelconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="labelconnectionedges"></a>`edges` | [`[LabelEdge]`](#labeledge) | エッジのリスト。 |
| <a id="labelconnectionnodes"></a>`nodes` | [`[Label]`](#label) | ノードのリスト。 |
| <a id="labelconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `LabelEdge`

[`Label`](#label)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="labeledgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="labeledgenode"></a>`node` | [`Label`](#label) | エッジの終端にあるアイテム。 |

#### `LdapAdminRoleLinkConnection`

[`LdapAdminRoleLink`](#ldapadminrolelink)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ldapadminrolelinkconnectionedges"></a>`edges` | [`[LdapAdminRoleLinkEdge]`](#ldapadminrolelinkedge) | エッジのリスト。 |
| <a id="ldapadminrolelinkconnectionnodes"></a>`nodes` | [`[LdapAdminRoleLink]`](#ldapadminrolelink) | ノードのリスト。 |
| <a id="ldapadminrolelinkconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `LdapAdminRoleLinkEdge`

[`LdapAdminRoleLink`](#ldapadminrolelink)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ldapadminrolelinkedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="ldapadminrolelinkedgenode"></a>`node` | [`LdapAdminRoleLink`](#ldapadminrolelink) | エッジの終端にあるアイテム。 |

#### `LfsObjectRegistryConnection`

[`LfsObjectRegistry`](#lfsobjectregistry)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="lfsobjectregistryconnectionedges"></a>`edges` | [`[LfsObjectRegistryEdge]`](#lfsobjectregistryedge) | エッジのリスト。 |
| <a id="lfsobjectregistryconnectionnodes"></a>`nodes` | [`[LfsObjectRegistry]`](#lfsobjectregistry) | ノードのリスト。 |
| <a id="lfsobjectregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド

###### `LfsObjectRegistryConnection.count`

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="lfsobjectregistryconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `LfsObjectRegistryEdge`

[`LfsObjectRegistry`](#lfsobjectregistry)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="lfsobjectregistryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="lfsobjectregistryedgenode"></a>`node` | [`LfsObjectRegistry`](#lfsobjectregistry) | エッジの終端にあるアイテム。 |

#### `LicenseHistoryEntryConnection`

[`LicenseHistoryEntry`](#licensehistoryentry)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="licensehistoryentryconnectionedges"></a>`edges` | [`[LicenseHistoryEntryEdge]`](#licensehistoryentryedge) | エッジのリスト。 |
| <a id="licensehistoryentryconnectionnodes"></a>`nodes` | [`[LicenseHistoryEntry]`](#licensehistoryentry) | ノードのリスト。 |
| <a id="licensehistoryentryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `LicenseHistoryEntryEdge`

[`LicenseHistoryEntry`](#licensehistoryentry)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="licensehistoryentryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="licensehistoryentryedgenode"></a>`node` | [`LicenseHistoryEntry`](#licensehistoryentry) | エッジの終端にあるアイテム。 |

#### `LinkedWorkItemTypeConnection`

[`LinkedWorkItemType`](#linkedworkitemtype)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="linkedworkitemtypeconnectionedges"></a>`edges` | [`[LinkedWorkItemTypeEdge]`](#linkedworkitemtypeedge) | エッジのリスト。 |
| <a id="linkedworkitemtypeconnectionnodes"></a>`nodes` | [`[LinkedWorkItemType]`](#linkedworkitemtype) | ノードのリスト。 |
| <a id="linkedworkitemtypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `LinkedWorkItemTypeEdge`

[`LinkedWorkItemType`](#linkedworkitemtype)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="linkedworkitemtypeedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="linkedworkitemtypeedgenode"></a>`node` | [`LinkedWorkItemType`](#linkedworkitemtype) | エッジの終端にあるアイテム。 |

#### `MemberApprovalConnection`

[`MemberApproval`](#memberapproval)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="memberapprovalconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="memberapprovalconnectionedges"></a>`edges` | [`[MemberApprovalEdge]`](#memberapprovaledge) | エッジのリスト。 |
| <a id="memberapprovalconnectionnodes"></a>`nodes` | [`[MemberApproval]`](#memberapproval) | ノードのリスト。 |
| <a id="memberapprovalconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `MemberApprovalEdge`

[`MemberApproval`](#memberapproval)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="memberapprovaledgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="memberapprovaledgenode"></a>`node` | [`MemberApproval`](#memberapproval) | エッジの終端にあるアイテム。 |

#### `MemberInterfaceConnection`

[`MemberInterface`](#memberinterface)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="memberinterfaceconnectionedges"></a>`edges` | [`[MemberInterfaceEdge]`](#memberinterfaceedge) | エッジのリスト。 |
| <a id="memberinterfaceconnectionnodes"></a>`nodes` | [`[MemberInterface]`](#memberinterface) | ノードのリスト。 |
| <a id="memberinterfaceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `MemberInterfaceEdge`

[`MemberInterface`](#memberinterface)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="memberinterfaceedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="memberinterfaceedgenode"></a>`node` | [`MemberInterface`](#memberinterface) | エッジの終端にあるアイテム。 |

#### `MemberRoleConnection`

[`MemberRole`](#memberrole)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="memberroleconnectionedges"></a>`edges` | [`[MemberRoleEdge]`](#memberroleedge) | エッジのリスト。 |
| <a id="memberroleconnectionnodes"></a>`nodes` | [`[MemberRole]`](#memberrole) | ノードのリスト。 |
| <a id="memberroleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `MemberRoleEdge`

[`MemberRole`](#memberrole)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="memberroleedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="memberroleedgenode"></a>`node` | [`MemberRole`](#memberrole) | エッジの終端にあるアイテム。 |

#### `MergeAccessLevelConnection`

[`MergeAccessLevel`](#mergeaccesslevel)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergeaccesslevelconnectionedges"></a>`edges` | [`[MergeAccessLevelEdge]`](#mergeaccessleveledge) | エッジのリスト。 |
| <a id="mergeaccesslevelconnectionnodes"></a>`nodes` | [`[MergeAccessLevel]`](#mergeaccesslevel) | ノードのリスト。 |
| <a id="mergeaccesslevelconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `MergeAccessLevelEdge`

[`MergeAccessLevel`](#mergeaccesslevel)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergeaccessleveledgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mergeaccessleveledgenode"></a>`node` | [`MergeAccessLevel`](#mergeaccesslevel) | エッジの終端にあるアイテム。 |

#### `MergeRequestAssigneeConnection`

[`MergeRequestAssignee`](#mergerequestassignee)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergerequestassigneeconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="mergerequestassigneeconnectionedges"></a>`edges` | [`[MergeRequestAssigneeEdge]`](#mergerequestassigneeedge) | エッジのリスト。 |
| <a id="mergerequestassigneeconnectionnodes"></a>`nodes` | [`[MergeRequestAssignee]`](#mergerequestassignee) | ノードのリスト。 |
| <a id="mergerequestassigneeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `MergeRequestAssigneeEdge`

[`MergeRequestAssignee`](#mergerequestassignee)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergerequestassigneeedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mergerequestassigneeedgenode"></a>`node` | [`MergeRequestAssignee`](#mergerequestassignee) | エッジの終端にあるアイテム。 |

#### `MergeRequestConnection`

[`MergeRequest`](#mergerequest)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergerequestconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="mergerequestconnectionedges"></a>`edges` | [`[MergeRequestEdge]`](#mergerequestedge) | エッジのリスト。 |
| <a id="mergerequestconnectionnodes"></a>`nodes` | [`[MergeRequest]`](#mergerequest) | ノードのリスト。 |
| <a id="mergerequestconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |
| <a id="mergerequestconnectiontotaltimetomerge"></a>`totalTimeToMerge` | [`Float`](#float) | マージリクエストのコレクションについて、マージにかかる時間の合計（秒単位）。 |

#### `MergeRequestDiffConnection`

[`MergeRequestDiff`](#mergerequestdiff)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergerequestdiffconnectionedges"></a>`edges` | [`[MergeRequestDiffEdge]`](#mergerequestdiffedge) | エッジのリスト。 |
| <a id="mergerequestdiffconnectionnodes"></a>`nodes` | [`[MergeRequestDiff]`](#mergerequestdiff) | ノードのリスト。 |
| <a id="mergerequestdiffconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `MergeRequestDiffEdge`

[`MergeRequestDiff`](#mergerequestdiff)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergerequestdiffedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mergerequestdiffedgenode"></a>`node` | [`MergeRequestDiff`](#mergerequestdiff) | エッジの終端にあるアイテム。 |

#### `MergeRequestDiffRegistryConnection`

[`MergeRequestDiffRegistry`](#mergerequestdiffregistry)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergerequestdiffregistryconnectionedges"></a>`edges` | [`[MergeRequestDiffRegistryEdge]`](#mergerequestdiffregistryedge) | エッジのリスト。 |
| <a id="mergerequestdiffregistryconnectionnodes"></a>`nodes` | [`[MergeRequestDiffRegistry]`](#mergerequestdiffregistry) | ノードのリスト。 |
| <a id="mergerequestdiffregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド

###### `MergeRequestDiffRegistryConnection.count`

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergerequestdiffregistryconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `MergeRequestDiffRegistryEdge`

[`MergeRequestDiffRegistry`](#mergerequestdiffregistry)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergerequestdiffregistryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mergerequestdiffregistryedgenode"></a>`node` | [`MergeRequestDiffRegistry`](#mergerequestdiffregistry) | エッジの終端にあるアイテム。 |

#### `MergeRequestEdge`

[`MergeRequest`](#mergerequest)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergerequestedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mergerequestedgenode"></a>`node` | [`MergeRequest`](#mergerequest) | エッジの終端にあるアイテム。 |

#### `MergeRequestParticipantConnection`

[`MergeRequestParticipant`](#mergerequestparticipant)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergerequestparticipantconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="mergerequestparticipantconnectionedges"></a>`edges` | [`[MergeRequestParticipantEdge]`](#mergerequestparticipantedge) | エッジのリスト。 |
| <a id="mergerequestparticipantconnectionnodes"></a>`nodes` | [`[MergeRequestParticipant]`](#mergerequestparticipant) | ノードのリスト。 |
| <a id="mergerequestparticipantconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `MergeRequestParticipantEdge`

[`MergeRequestParticipant`](#mergerequestparticipant)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergerequestparticipantedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mergerequestparticipantedgenode"></a>`node` | [`MergeRequestParticipant`](#mergerequestparticipant) | エッジの終端にあるアイテム。 |

#### `MergeRequestReviewerConnection`

[`MergeRequestReviewer`](#mergerequestreviewer)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergerequestreviewerconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="mergerequestreviewerconnectionedges"></a>`edges` | [`[MergeRequestReviewerEdge]`](#mergerequestrevieweredge) | エッジのリスト。 |
| <a id="mergerequestreviewerconnectionnodes"></a>`nodes` | [`[MergeRequestReviewer]`](#mergerequestreviewer) | ノードのリスト。 |
| <a id="mergerequestreviewerconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `MergeRequestReviewerEdge`

[`MergeRequestReviewer`](#mergerequestreviewer)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergerequestrevieweredgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mergerequestrevieweredgenode"></a>`node` | [`MergeRequestReviewer`](#mergerequestreviewer) | エッジの終端にあるアイテム。 |

#### `MergeTrainCarConnection`

[`MergeTrainCar`](#mergetraincar)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergetraincarconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="mergetraincarconnectionedges"></a>`edges` | [`[MergeTrainCarEdge]`](#mergetraincaredge) | エッジのリスト。 |
| <a id="mergetraincarconnectionnodes"></a>`nodes` | [`[MergeTrainCar]`](#mergetraincar) | ノードのリスト。 |
| <a id="mergetraincarconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `MergeTrainCarEdge`

[`MergeTrainCar`](#mergetraincar)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergetraincaredgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mergetraincaredgenode"></a>`node` | [`MergeTrainCar`](#mergetraincar) | エッジの終端にあるアイテム。 |

#### `MergeTrainConnection`

[`MergeTrain`](#mergetrain)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergetrainconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="mergetrainconnectionedges"></a>`edges` | [`[MergeTrainEdge]`](#mergetrainedge) | エッジのリスト。 |
| <a id="mergetrainconnectionnodes"></a>`nodes` | [`[MergeTrain]`](#mergetrain) | ノードのリスト。 |
| <a id="mergetrainconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `MergeTrainEdge`

[`MergeTrain`](#mergetrain)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergetrainedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mergetrainedgenode"></a>`node` | [`MergeTrain`](#mergetrain) | エッジの終端にあるアイテム。 |

#### `MilestoneConnection`

[`Milestone`](#milestone)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="milestoneconnectionedges"></a>`edges` | [`[MilestoneEdge]`](#milestoneedge) | エッジのリスト。 |
| <a id="milestoneconnectionnodes"></a>`nodes` | [`[Milestone]`](#milestone) | ノードのリスト。 |
| <a id="milestoneconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `MilestoneEdge`

[`Milestone`](#milestone)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="milestoneedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="milestoneedgenode"></a>`node` | [`Milestone`](#milestone) | エッジの終端にあるアイテム。 |

#### `MlCandidateConnection`

[`MlCandidate`](#mlcandidate)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlcandidateconnectionedges"></a>`edges` | [`[MlCandidateEdge]`](#mlcandidateedge) | エッジのリスト。 |
| <a id="mlcandidateconnectionnodes"></a>`nodes` | [`[MlCandidate]`](#mlcandidate) | ノードのリスト。 |
| <a id="mlcandidateconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド

###### `MlCandidateConnection.count`

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlcandidateconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `MlCandidateEdge`

[`MlCandidate`](#mlcandidate)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlcandidateedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mlcandidateedgenode"></a>`node` | [`MlCandidate`](#mlcandidate) | エッジの終端にあるアイテム。 |

#### `MlCandidateMetadataConnection`

[`MlCandidateMetadata`](#mlcandidatemetadata)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlcandidatemetadataconnectionedges"></a>`edges` | [`[MlCandidateMetadataEdge]`](#mlcandidatemetadataedge) | エッジのリスト。 |
| <a id="mlcandidatemetadataconnectionnodes"></a>`nodes` | [`[MlCandidateMetadata]`](#mlcandidatemetadata) | ノードのリスト。 |
| <a id="mlcandidatemetadataconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド

###### `MlCandidateMetadataConnection.count`

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlcandidatemetadataconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `MlCandidateMetadataEdge`

[`MlCandidateMetadata`](#mlcandidatemetadata)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlcandidatemetadataedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mlcandidatemetadataedgenode"></a>`node` | [`MlCandidateMetadata`](#mlcandidatemetadata) | エッジの終端にあるアイテム。 |

#### `MlCandidateMetricConnection`

[`MlCandidateMetric`](#mlcandidatemetric)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlcandidatemetricconnectionedges"></a>`edges` | [`[MlCandidateMetricEdge]`](#mlcandidatemetricedge) | エッジのリスト。 |
| <a id="mlcandidatemetricconnectionnodes"></a>`nodes` | [`[MlCandidateMetric]`](#mlcandidatemetric) | ノードのリスト。 |
| <a id="mlcandidatemetricconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド

###### `MlCandidateMetricConnection.count`

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlcandidatemetricconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `MlCandidateMetricEdge`

[`MlCandidateMetric`](#mlcandidatemetric)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlcandidatemetricedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mlcandidatemetricedgenode"></a>`node` | [`MlCandidateMetric`](#mlcandidatemetric) | エッジの終端にあるアイテム。 |

#### `MlCandidateParamConnection`

[`MlCandidateParam`](#mlcandidateparam)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlcandidateparamconnectionedges"></a>`edges` | [`[MlCandidateParamEdge]`](#mlcandidateparamedge) | エッジのリスト。 |
| <a id="mlcandidateparamconnectionnodes"></a>`nodes` | [`[MlCandidateParam]`](#mlcandidateparam) | ノードのリスト。 |
| <a id="mlcandidateparamconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド

###### `MlCandidateParamConnection.count`

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlcandidateparamconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `MlCandidateParamEdge`

[`MlCandidateParam`](#mlcandidateparam)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlcandidateparamedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mlcandidateparamedgenode"></a>`node` | [`MlCandidateParam`](#mlcandidateparam) | エッジの終端にあるアイテム。 |

#### `MlExperimentConnection`

[`MlExperiment`](#mlexperiment)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlexperimentconnectionedges"></a>`edges` | [`[MlExperimentEdge]`](#mlexperimentedge) | エッジのリスト。 |
| <a id="mlexperimentconnectionnodes"></a>`nodes` | [`[MlExperiment]`](#mlexperiment) | ノードのリスト。 |
| <a id="mlexperimentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド

###### `MlExperimentConnection.count`

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlexperimentconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `MlExperimentEdge`

[`MlExperiment`](#mlexperiment)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlexperimentedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mlexperimentedgenode"></a>`node` | [`MlExperiment`](#mlexperiment) | エッジの終端にあるアイテム。 |

#### `MlModelConnection`

[`MlModel`](#mlmodel)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlmodelconnectionedges"></a>`edges` | [`[MlModelEdge]`](#mlmodeledge) | エッジのリスト。 |
| <a id="mlmodelconnectionnodes"></a>`nodes` | [`[MlModel]`](#mlmodel) | ノードのリスト。 |
| <a id="mlmodelconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド

###### `MlModelConnection.count`

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlmodelconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `MlModelEdge`

[`MlModel`](#mlmodel)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlmodeledgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mlmodeledgenode"></a>`node` | [`MlModel`](#mlmodel) | エッジの終端にあるアイテム。 |

#### `MlModelVersionConnection`

[`MlModelVersion`](#mlmodelversion)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlmodelversionconnectionedges"></a>`edges` | [`[MlModelVersionEdge]`](#mlmodelversionedge) | エッジのリスト。 |
| <a id="mlmodelversionconnectionnodes"></a>`nodes` | [`[MlModelVersion]`](#mlmodelversion) | ノードのリスト。 |
| <a id="mlmodelversionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド

###### `MlModelVersionConnection.count`

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlmodelversionconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `MlModelVersionEdge`

[`MlModelVersion`](#mlmodelversion)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlmodelversionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mlmodelversionedgenode"></a>`node` | [`MlModelVersion`](#mlmodelversion) | エッジの終端にあるアイテム。 |

#### `NamespaceCommitEmailConnection`

[`NamespaceCommitEmail`](#namespacecommitemail)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="namespacecommitemailconnectionedges"></a>`edges` | [`[NamespaceCommitEmailEdge]`](#namespacecommitemailedge) | エッジのリスト。 |
| <a id="namespacecommitemailconnectionnodes"></a>`nodes` | [`[NamespaceCommitEmail]`](#namespacecommitemail) | ノードのリスト。 |
| <a id="namespacecommitemailconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `NamespaceCommitEmailEdge`

[`NamespaceCommitEmail`](#namespacecommitemail)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="namespacecommitemailedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="namespacecommitemailedgenode"></a>`node` | [`NamespaceCommitEmail`](#namespacecommitemail) | エッジの終端にあるアイテム。 |

#### `NamespaceConnection`

[`Namespace`](#namespace)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="namespaceconnectionedges"></a>`edges` | [`[NamespaceEdge]`](#namespaceedge) | エッジのリスト。 |
| <a id="namespaceconnectionnodes"></a>`nodes` | [`[Namespace]`](#namespace) | ノードのリスト。 |
| <a id="namespaceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `NamespaceEdge`

[`Namespace`](#namespace)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="namespaceedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="namespaceedgenode"></a>`node` | [`Namespace`](#namespace) | エッジの終端にあるアイテム。 |

#### `NestedEnvironmentConnection`

[`NestedEnvironment`](#nestedenvironment)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="nestedenvironmentconnectionedges"></a>`edges` | [`[NestedEnvironmentEdge]`](#nestedenvironmentedge) | エッジのリスト。 |
| <a id="nestedenvironmentconnectionnodes"></a>`nodes` | [`[NestedEnvironment]`](#nestedenvironment) | ノードのリスト。 |
| <a id="nestedenvironmentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `NestedEnvironmentEdge`

[`NestedEnvironment`](#nestedenvironment)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="nestedenvironmentedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="nestedenvironmentedgenode"></a>`node` | [`NestedEnvironment`](#nestedenvironment) | エッジの終端にあるアイテム。 |

#### `NoteConnection`

[`Note`](#note)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="noteconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="noteconnectionedges"></a>`edges` | [`[NoteEdge]`](#noteedge) | エッジのリスト。 |
| <a id="noteconnectionnodes"></a>`nodes` | [`[Note]`](#note) | ノードのリスト。 |
| <a id="noteconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `NoteEdge`

[`Note`](#note)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="noteedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="noteedgenode"></a>`node` | [`Note`](#note) | エッジの終端にあるアイテム。 |

#### `ObservabilityLogConnection`

[`ObservabilityLog`](#observabilitylog)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="observabilitylogconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="observabilitylogconnectionedges"></a>`edges` | [`[ObservabilityLogEdge]`](#observabilitylogedge) | エッジのリスト。 |
| <a id="observabilitylogconnectionnodes"></a>`nodes` | [`[ObservabilityLog]`](#observabilitylog) | ノードのリスト。 |
| <a id="observabilitylogconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ObservabilityLogEdge`

[`ObservabilityLog`](#observabilitylog)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="observabilitylogedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="observabilitylogedgenode"></a>`node` | [`ObservabilityLog`](#observabilitylog) | エッジの終端にあるアイテム。 |

#### `ObservabilityMetricConnection`

[`ObservabilityMetric`](#observabilitymetric)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="observabilitymetricconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="observabilitymetricconnectionedges"></a>`edges` | [`[ObservabilityMetricEdge]`](#observabilitymetricedge) | エッジのリスト。 |
| <a id="observabilitymetricconnectionnodes"></a>`nodes` | [`[ObservabilityMetric]`](#observabilitymetric) | ノードのリスト。 |
| <a id="observabilitymetricconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ObservabilityMetricEdge`

[`ObservabilityMetric`](#observabilitymetric)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="observabilitymetricedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="observabilitymetricedgenode"></a>`node` | [`ObservabilityMetric`](#observabilitymetric) | エッジの終端にあるアイテム。 |

#### `ObservabilityTraceConnection`

[`ObservabilityTrace`](#observabilitytrace)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="observabilitytraceconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="observabilitytraceconnectionedges"></a>`edges` | [`[ObservabilityTraceEdge]`](#observabilitytraceedge) | エッジのリスト。 |
| <a id="observabilitytraceconnectionnodes"></a>`nodes` | [`[ObservabilityTrace]`](#observabilitytrace) | ノードのリスト。 |
| <a id="observabilitytraceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ObservabilityTraceEdge`

[`ObservabilityTrace`](#observabilitytrace)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="observabilitytraceedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="observabilitytraceedgenode"></a>`node` | [`ObservabilityTrace`](#observabilitytrace) | エッジの終端にあるアイテム。 |

#### `OncallParticipantTypeConnection`

[`OncallParticipantType`](#oncallparticipanttype)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="oncallparticipanttypeconnectionedges"></a>`edges` | [`[OncallParticipantTypeEdge]`](#oncallparticipanttypeedge) | エッジのリスト。 |
| <a id="oncallparticipanttypeconnectionnodes"></a>`nodes` | [`[OncallParticipantType]`](#oncallparticipanttype) | ノードのリスト。 |
| <a id="oncallparticipanttypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `OncallParticipantTypeEdge`

[`OncallParticipantType`](#oncallparticipanttype)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="oncallparticipanttypeedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="oncallparticipanttypeedgenode"></a>`node` | [`OncallParticipantType`](#oncallparticipanttype) | エッジの終端にあるアイテム。 |

#### `OrganizationConnection`

[`Organization`](#organization)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="organizationconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="organizationconnectionedges"></a>`edges` | [`[OrganizationEdge]`](#organizationedge) | エッジのリスト。 |
| <a id="organizationconnectionnodes"></a>`nodes` | [`[Organization]`](#organization) | ノードのリスト。 |
| <a id="organizationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `OrganizationEdge`

[`Organization`](#organization)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="organizationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="organizationedgenode"></a>`node` | [`Organization`](#organization) | エッジの終端にあるアイテム。 |

#### `OrganizationUserConnection`

[`OrganizationUser`](#organizationuser)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="organizationuserconnectionedges"></a>`edges` | [`[OrganizationUserEdge]`](#organizationuseredge) | エッジのリスト。 |
| <a id="organizationuserconnectionnodes"></a>`nodes` | [`[OrganizationUser]`](#organizationuser) | ノードのリスト。 |
| <a id="organizationuserconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `OrganizationUserEdge`

[`OrganizationUser`](#organizationuser)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="organizationuseredgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="organizationuseredgenode"></a>`node` | [`OrganizationUser`](#organizationuser) | エッジの終端にあるアイテム。 |

#### `PackageBaseConnection`

[`PackageBase`](#packagebase)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="packagebaseconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="packagebaseconnectionedges"></a>`edges` | [`[PackageBaseEdge]`](#packagebaseedge) | エッジのリスト。 |
| <a id="packagebaseconnectionnodes"></a>`nodes` | [`[PackageBase]`](#packagebase) | ノードのリスト。 |
| <a id="packagebaseconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PackageBaseEdge`

[`PackageBase`](#packagebase)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="packagebaseedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="packagebaseedgenode"></a>`node` | [`PackageBase`](#packagebase) | エッジの終端にあるアイテム。 |

#### `PackageConnection`

[`Package`](#package)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="packageconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="packageconnectionedges"></a>`edges` | [`[PackageEdge]`](#packageedge) | エッジのリスト。 |
| <a id="packageconnectionnodes"></a>`nodes` | [`[Package]`](#package) | ノードのリスト。 |
| <a id="packageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PackageDependencyLinkConnection`

[`PackageDependencyLink`](#packagedependencylink)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="packagedependencylinkconnectionedges"></a>`edges` | [`[PackageDependencyLinkEdge]`](#packagedependencylinkedge) | エッジのリスト。 |
| <a id="packagedependencylinkconnectionnodes"></a>`nodes` | [`[PackageDependencyLink]`](#packagedependencylink) | ノードのリスト。 |
| <a id="packagedependencylinkconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PackageDependencyLinkEdge`

[`PackageDependencyLink`](#packagedependencylink)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="packagedependencylinkedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="packagedependencylinkedgenode"></a>`node` | [`PackageDependencyLink`](#packagedependencylink) | エッジの終端にあるアイテム。 |

#### `PackageEdge`

[`Package`](#package)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="packageedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="packageedgenode"></a>`node` | [`Package`](#package) | エッジの終端にあるアイテム。 |

#### `PackageFileConnection`

[`PackageFile`](#packagefile)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="packagefileconnectionedges"></a>`edges` | [`[PackageFileEdge]`](#packagefileedge) | エッジのリスト。 |
| <a id="packagefileconnectionnodes"></a>`nodes` | [`[PackageFile]`](#packagefile) | ノードのリスト。 |
| <a id="packagefileconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PackageFileEdge`

[`PackageFile`](#packagefile)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="packagefileedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="packagefileedgenode"></a>`node` | [`PackageFile`](#packagefile) | エッジの終端にあるアイテム。 |

#### `PackageFileRegistryConnection`

[`PackageFileRegistry`](#packagefileregistry)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="packagefileregistryconnectionedges"></a>`edges` | [`[PackageFileRegistryEdge]`](#packagefileregistryedge) | エッジのリスト。 |
| <a id="packagefileregistryconnectionnodes"></a>`nodes` | [`[PackageFileRegistry]`](#packagefileregistry) | ノードのリスト。 |
| <a id="packagefileregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド

###### `PackageFileRegistryConnection.count`

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="packagefileregistryconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `PackageFileRegistryEdge`

[`PackageFileRegistry`](#packagefileregistry)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="packagefileregistryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="packagefileregistryedgenode"></a>`node` | [`PackageFileRegistry`](#packagefileregistry) | エッジの終端にあるアイテム。 |

#### `PackageTagConnection`

[`PackageTag`](#packagetag)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="packagetagconnectionedges"></a>`edges` | [`[PackageTagEdge]`](#packagetagedge) | エッジのリスト。 |
| <a id="packagetagconnectionnodes"></a>`nodes` | [`[PackageTag]`](#packagetag) | ノードのリスト。 |
| <a id="packagetagconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PackageTagEdge`

[`PackageTag`](#packagetag)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="packagetagedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="packagetagedgenode"></a>`node` | [`PackageTag`](#packagetag) | エッジの終端にあるアイテム。 |

#### `PackagesProtectionRuleConnection`

[`PackagesProtectionRule`](#packagesprotectionrule)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="packagesprotectionruleconnectionedges"></a>`edges` | [`[PackagesProtectionRuleEdge]`](#packagesprotectionruleedge) | エッジのリスト。 |
| <a id="packagesprotectionruleconnectionnodes"></a>`nodes` | [`[PackagesProtectionRule]`](#packagesprotectionrule) | ノードのリスト。 |
| <a id="packagesprotectionruleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PackagesProtectionRuleEdge`

[`PackagesProtectionRule`](#packagesprotectionrule)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="packagesprotectionruleedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="packagesprotectionruleedgenode"></a>`node` | [`PackagesProtectionRule`](#packagesprotectionrule) | エッジの終端にあるアイテム。 |

#### `PagesDeploymentConnection`

[`PagesDeployment`](#pagesdeployment)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pagesdeploymentconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="pagesdeploymentconnectionedges"></a>`edges` | [`[PagesDeploymentEdge]`](#pagesdeploymentedge) | エッジのリスト。 |
| <a id="pagesdeploymentconnectionnodes"></a>`nodes` | [`[PagesDeployment]`](#pagesdeployment) | ノードのリスト。 |
| <a id="pagesdeploymentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PagesDeploymentEdge`

[`PagesDeployment`](#pagesdeployment)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pagesdeploymentedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="pagesdeploymentedgenode"></a>`node` | [`PagesDeployment`](#pagesdeployment) | エッジの終端にあるアイテム。 |

#### `PagesDeploymentRegistryConnection`

[`PagesDeploymentRegistry`](#pagesdeploymentregistry)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pagesdeploymentregistryconnectionedges"></a>`edges` | [`[PagesDeploymentRegistryEdge]`](#pagesdeploymentregistryedge) | エッジのリスト。 |
| <a id="pagesdeploymentregistryconnectionnodes"></a>`nodes` | [`[PagesDeploymentRegistry]`](#pagesdeploymentregistry) | ノードのリスト。 |
| <a id="pagesdeploymentregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド

###### `PagesDeploymentRegistryConnection.count`

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pagesdeploymentregistryconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `PagesDeploymentRegistryEdge`

[`PagesDeploymentRegistry`](#pagesdeploymentregistry)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pagesdeploymentregistryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="pagesdeploymentregistryedgenode"></a>`node` | [`PagesDeploymentRegistry`](#pagesdeploymentregistry) | エッジの終端にあるアイテム。 |

#### `PathLockConnection`

[`PathLock`](#pathlock)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pathlockconnectionedges"></a>`edges` | [`[PathLockEdge]`](#pathlockedge) | エッジのリスト。 |
| <a id="pathlockconnectionnodes"></a>`nodes` | [`[PathLock]`](#pathlock) | ノードのリスト。 |
| <a id="pathlockconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PathLockEdge`

[`PathLock`](#pathlock)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pathlockedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="pathlockedgenode"></a>`node` | [`PathLock`](#pathlock) | エッジの終端にあるアイテム。 |

#### `PendingMemberInterfaceConnection`

[`PendingMemberInterface`](#pendingmemberinterface)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pendingmemberinterfaceconnectionedges"></a>`edges` | [`[PendingMemberInterfaceEdge]`](#pendingmemberinterfaceedge) | エッジのリスト。 |
| <a id="pendingmemberinterfaceconnectionnodes"></a>`nodes` | [`[PendingMemberInterface]`](#pendingmemberinterface) | ノードのリスト。 |
| <a id="pendingmemberinterfaceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PendingMemberInterfaceEdge`

[`PendingMemberInterface`](#pendingmemberinterface)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pendingmemberinterfaceedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="pendingmemberinterfaceedgenode"></a>`node` | [`PendingMemberInterface`](#pendingmemberinterface) | エッジの終端にあるアイテム。 |

#### `PipelineArtifactRegistryConnection`

[`PipelineArtifactRegistry`](#pipelineartifactregistry)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelineartifactregistryconnectionedges"></a>`edges` | [`[PipelineArtifactRegistryEdge]`](#pipelineartifactregistryedge) | エッジのリスト。 |
| <a id="pipelineartifactregistryconnectionnodes"></a>`nodes` | [`[PipelineArtifactRegistry]`](#pipelineartifactregistry) | ノードのリスト。 |
| <a id="pipelineartifactregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド

###### `PipelineArtifactRegistryConnection.count`

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelineartifactregistryconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `PipelineArtifactRegistryEdge`

[`PipelineArtifactRegistry`](#pipelineartifactregistry)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelineartifactregistryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="pipelineartifactregistryedgenode"></a>`node` | [`PipelineArtifactRegistry`](#pipelineartifactregistry) | エッジの終端にあるアイテム。 |

#### `PipelineConnection`

[`Pipeline`](#pipeline)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelineconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="pipelineconnectionedges"></a>`edges` | [`[PipelineEdge]`](#pipelineedge) | エッジのリスト。 |
| <a id="pipelineconnectionnodes"></a>`nodes` | [`[Pipeline]`](#pipeline) | ノードのリスト。 |
| <a id="pipelineconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PipelineEdge`

[`Pipeline`](#pipeline)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelineedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="pipelineedgenode"></a>`node` | [`Pipeline`](#pipeline) | エッジの終端にあるアイテム。 |

#### `PipelineExecutionPolicyConnection`

[`PipelineExecutionPolicy`](#pipelineexecutionpolicy)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelineexecutionpolicyconnectionedges"></a>`edges` | [`[PipelineExecutionPolicyEdge]`](#pipelineexecutionpolicyedge) | エッジのリスト。 |
| <a id="pipelineexecutionpolicyconnectionnodes"></a>`nodes` | [`[PipelineExecutionPolicy]`](#pipelineexecutionpolicy) | ノードのリスト。 |
| <a id="pipelineexecutionpolicyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PipelineExecutionPolicyEdge`

[`PipelineExecutionPolicy`](#pipelineexecutionpolicy)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelineexecutionpolicyedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="pipelineexecutionpolicyedgenode"></a>`node` | [`PipelineExecutionPolicy`](#pipelineexecutionpolicy) | エッジの終端にあるアイテム。 |

#### `PipelineManualVariableConnection`

[`PipelineManualVariable`](#pipelinemanualvariable)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelinemanualvariableconnectionedges"></a>`edges` | [`[PipelineManualVariableEdge]`](#pipelinemanualvariableedge) | エッジのリスト。 |
| <a id="pipelinemanualvariableconnectionnodes"></a>`nodes` | [`[PipelineManualVariable]`](#pipelinemanualvariable) | ノードのリスト。 |
| <a id="pipelinemanualvariableconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PipelineManualVariableEdge`

[`PipelineManualVariable`](#pipelinemanualvariable)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelinemanualvariableedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="pipelinemanualvariableedgenode"></a>`node` | [`PipelineManualVariable`](#pipelinemanualvariable) | エッジの終端にあるアイテム。 |

#### `PipelineMessageConnection`

[`PipelineMessage`](#pipelinemessage)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelinemessageconnectionedges"></a>`edges` | [`[PipelineMessageEdge]`](#pipelinemessageedge) | エッジのリスト。 |
| <a id="pipelinemessageconnectionnodes"></a>`nodes` | [`[PipelineMessage]`](#pipelinemessage) | ノードのリスト。 |
| <a id="pipelinemessageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PipelineMessageEdge`

[`PipelineMessage`](#pipelinemessage)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelinemessageedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="pipelinemessageedgenode"></a>`node` | [`PipelineMessage`](#pipelinemessage) | エッジの終端にあるアイテム。 |

#### `PipelineScheduleConnection`

[`PipelineSchedule`](#pipelineschedule)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelinescheduleconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="pipelinescheduleconnectionedges"></a>`edges` | [`[PipelineScheduleEdge]`](#pipelinescheduleedge) | エッジのリスト。 |
| <a id="pipelinescheduleconnectionnodes"></a>`nodes` | [`[PipelineSchedule]`](#pipelineschedule) | ノードのリスト。 |
| <a id="pipelinescheduleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PipelineScheduleEdge`

[`PipelineSchedule`](#pipelineschedule)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelinescheduleedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="pipelinescheduleedgenode"></a>`node` | [`PipelineSchedule`](#pipelineschedule) | エッジの終端にあるアイテム。 |

#### `PipelineScheduleVariableConnection`

[`PipelineScheduleVariable`](#pipelineschedulevariable)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelineschedulevariableconnectionedges"></a>`edges` | [`[PipelineScheduleVariableEdge]`](#pipelineschedulevariableedge) | エッジのリスト。 |
| <a id="pipelineschedulevariableconnectionnodes"></a>`nodes` | [`[PipelineScheduleVariable]`](#pipelineschedulevariable) | ノードのリスト。 |
| <a id="pipelineschedulevariableconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PipelineScheduleVariableEdge`

[`PipelineScheduleVariable`](#pipelineschedulevariable)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelineschedulevariableedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="pipelineschedulevariableedgenode"></a>`node` | [`PipelineScheduleVariable`](#pipelineschedulevariable) | エッジの終端にあるアイテム。 |

#### `PipelineSecurityReportFindingConnection`

[`PipelineSecurityReportFinding`](#pipelinesecurityreportfinding)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelinesecurityreportfindingconnectionedges"></a>`edges` | [`[PipelineSecurityReportFindingEdge]`](#pipelinesecurityreportfindingedge) | エッジのリスト。 |
| <a id="pipelinesecurityreportfindingconnectionnodes"></a>`nodes` | [`[PipelineSecurityReportFinding]`](#pipelinesecurityreportfinding) | ノードのリスト。 |
| <a id="pipelinesecurityreportfindingconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PipelineSecurityReportFindingEdge`

[`PipelineSecurityReportFinding`](#pipelinesecurityreportfinding)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelinesecurityreportfindingedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="pipelinesecurityreportfindingedgenode"></a>`node` | [`PipelineSecurityReportFinding`](#pipelinesecurityreportfinding) | エッジの終端にあるアイテム。 |

#### `PipelineTriggerConnection`

[`PipelineTrigger`](#pipelinetrigger)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelinetriggerconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="pipelinetriggerconnectionedges"></a>`edges` | [`[PipelineTriggerEdge]`](#pipelinetriggeredge) | エッジのリスト。 |
| <a id="pipelinetriggerconnectionnodes"></a>`nodes` | [`[PipelineTrigger]`](#pipelinetrigger) | ノードのリスト。 |
| <a id="pipelinetriggerconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PipelineTriggerEdge`

[`PipelineTrigger`](#pipelinetrigger)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelinetriggeredgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="pipelinetriggeredgenode"></a>`node` | [`PipelineTrigger`](#pipelinetrigger) | エッジの終端にあるアイテム。 |

#### `ProjectComplianceControlStatusTypeConnection`

[`ProjectComplianceControlStatusType`](#projectcompliancecontrolstatustype)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectcompliancecontrolstatustypeconnectionedges"></a>`edges` | [`[ProjectComplianceControlStatusTypeEdge]`](#projectcompliancecontrolstatustypeedge) | エッジのリスト。 |
| <a id="projectcompliancecontrolstatustypeconnectionnodes"></a>`nodes` | [`[ProjectComplianceControlStatusType]`](#projectcompliancecontrolstatustype) | ノードのリスト。 |
| <a id="projectcompliancecontrolstatustypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ProjectComplianceControlStatusTypeEdge`

[`ProjectComplianceControlStatusType`](#projectcompliancecontrolstatustype)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectcompliancecontrolstatustypeedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="projectcompliancecontrolstatustypeedgenode"></a>`node` | [`ProjectComplianceControlStatusType`](#projectcompliancecontrolstatustype) | エッジの終端にあるアイテム。 |

#### `ProjectComplianceRequirementStatusConnection`

[`ProjectComplianceRequirementStatus`](#projectcompliancerequirementstatus)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectcompliancerequirementstatusconnectionedges"></a>`edges` | [`[ProjectComplianceRequirementStatusEdge]`](#projectcompliancerequirementstatusedge) | エッジのリスト。 |
| <a id="projectcompliancerequirementstatusconnectionnodes"></a>`nodes` | [`[ProjectComplianceRequirementStatus]`](#projectcompliancerequirementstatus) | ノードのリスト。 |
| <a id="projectcompliancerequirementstatusconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ProjectComplianceRequirementStatusEdge`

[`ProjectComplianceRequirementStatus`](#projectcompliancerequirementstatus)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectcompliancerequirementstatusedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="projectcompliancerequirementstatusedgenode"></a>`node` | [`ProjectComplianceRequirementStatus`](#projectcompliancerequirementstatus) | エッジの終端にあるアイテム。 |

#### `ProjectConnection`

[`Project`](#project)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="projectconnectionedges"></a>`edges` | [`[ProjectEdge]`](#projectedge) | エッジのリスト。 |
| <a id="projectconnectionnodes"></a>`nodes` | [`[Project]`](#project) | ノードのリスト。 |
| <a id="projectconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ProjectEdge`

[`Project`](#project)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="projectedgenode"></a>`node` | [`Project`](#project) | エッジの終端にあるアイテム。 |

#### `ProjectMemberConnection`

[`ProjectMember`](#projectmember)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectmemberconnectionedges"></a>`edges` | [`[ProjectMemberEdge]`](#projectmemberedge) | エッジのリスト。 |
| <a id="projectmemberconnectionnodes"></a>`nodes` | [`[ProjectMember]`](#projectmember) | ノードのリスト。 |
| <a id="projectmemberconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ProjectMemberEdge`

[`ProjectMember`](#projectmember)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectmemberedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="projectmemberedgenode"></a>`node` | [`ProjectMember`](#projectmember) | エッジの終端にあるアイテム。 |

#### `ProjectRepositoryRegistryConnection`

[`ProjectRepositoryRegistry`](#projectrepositoryregistry)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectrepositoryregistryconnectionedges"></a>`edges` | [`[ProjectRepositoryRegistryEdge]`](#projectrepositoryregistryedge) | エッジのリスト。 |
| <a id="projectrepositoryregistryconnectionnodes"></a>`nodes` | [`[ProjectRepositoryRegistry]`](#projectrepositoryregistry) | ノードのリスト。 |
| <a id="projectrepositoryregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド

###### `ProjectRepositoryRegistryConnection.count`

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectrepositoryregistryconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `ProjectRepositoryRegistryEdge`

[`ProjectRepositoryRegistry`](#projectrepositoryregistry)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectrepositoryregistryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="projectrepositoryregistryedgenode"></a>`node` | [`ProjectRepositoryRegistry`](#projectrepositoryregistry) | エッジの終端にあるアイテム。 |

#### `ProjectSavedReplyConnection`

[`ProjectSavedReply`](#projectsavedreply)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectsavedreplyconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="projectsavedreplyconnectionedges"></a>`edges` | [`[ProjectSavedReplyEdge]`](#projectsavedreplyedge) | エッジのリスト。 |
| <a id="projectsavedreplyconnectionnodes"></a>`nodes` | [`[ProjectSavedReply]`](#projectsavedreply) | ノードのリスト。 |
| <a id="projectsavedreplyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ProjectSavedReplyEdge`

[`ProjectSavedReply`](#projectsavedreply)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectsavedreplyedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="projectsavedreplyedgenode"></a>`node` | [`ProjectSavedReply`](#projectsavedreply) | エッジの終端にあるアイテム。 |

#### `ProjectSecretConnection`

[`ProjectSecret`](#projectsecret)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectsecretconnectionedges"></a>`edges` | [`[ProjectSecretEdge]`](#projectsecretedge) | エッジのリスト。 |
| <a id="projectsecretconnectionnodes"></a>`nodes` | [`[ProjectSecret]`](#projectsecret) | ノードのリスト。 |
| <a id="projectsecretconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ProjectSecretEdge`

[`ProjectSecret`](#projectsecret)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectsecretedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="projectsecretedgenode"></a>`node` | [`ProjectSecret`](#projectsecret) | エッジの終端にあるアイテム。 |

#### `ProjectSecurityExclusionConnection`

[`ProjectSecurityExclusion`](#projectsecurityexclusion)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectsecurityexclusionconnectionedges"></a>`edges` | [`[ProjectSecurityExclusionEdge]`](#projectsecurityexclusionedge) | エッジのリスト。 |
| <a id="projectsecurityexclusionconnectionnodes"></a>`nodes` | [`[ProjectSecurityExclusion]`](#projectsecurityexclusion) | ノードのリスト。 |
| <a id="projectsecurityexclusionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ProjectSecurityExclusionEdge`

[`ProjectSecurityExclusion`](#projectsecurityexclusion)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectsecurityexclusionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="projectsecurityexclusionedgenode"></a>`node` | [`ProjectSecurityExclusion`](#projectsecurityexclusion) | エッジの終端にあるアイテム。 |

#### `ProjectTargetBranchRuleConnection`

[`ProjectTargetBranchRule`](#projecttargetbranchrule)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projecttargetbranchruleconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="projecttargetbranchruleconnectionedges"></a>`edges` | [`[ProjectTargetBranchRuleEdge]`](#projecttargetbranchruleedge) | エッジのリスト。 |
| <a id="projecttargetbranchruleconnectionnodes"></a>`nodes` | [`[ProjectTargetBranchRule]`](#projecttargetbranchrule) | ノードのリスト。 |
| <a id="projecttargetbranchruleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ProjectTargetBranchRuleEdge`

[`ProjectTargetBranchRule`](#projecttargetbranchrule)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projecttargetbranchruleedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="projecttargetbranchruleedgenode"></a>`node` | [`ProjectTargetBranchRule`](#projecttargetbranchrule) | エッジの終端にあるアイテム。 |

#### `ProjectWikiRepositoryRegistryConnection`

[`ProjectWikiRepositoryRegistry`](#projectwikirepositoryregistry)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectwikirepositoryregistryconnectionedges"></a>`edges` | [`[ProjectWikiRepositoryRegistryEdge]`](#projectwikirepositoryregistryedge) | エッジのリスト。 |
| <a id="projectwikirepositoryregistryconnectionnodes"></a>`nodes` | [`[ProjectWikiRepositoryRegistry]`](#projectwikirepositoryregistry) | ノードのリスト。 |
| <a id="projectwikirepositoryregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド

###### `ProjectWikiRepositoryRegistryConnection.count`

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectwikirepositoryregistryconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `ProjectWikiRepositoryRegistryEdge`

[`ProjectWikiRepositoryRegistry`](#projectwikirepositoryregistry)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectwikirepositoryregistryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="projectwikirepositoryregistryedgenode"></a>`node` | [`ProjectWikiRepositoryRegistry`](#projectwikirepositoryregistry) | エッジの終端にあるアイテム。 |

#### `ProtectedEnvironmentApprovalRuleConnection`

[`ProtectedEnvironmentApprovalRule`](#protectedenvironmentapprovalrule)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="protectedenvironmentapprovalruleconnectionedges"></a>`edges` | [`[ProtectedEnvironmentApprovalRuleEdge]`](#protectedenvironmentapprovalruleedge) | エッジのリスト。 |
| <a id="protectedenvironmentapprovalruleconnectionnodes"></a>`nodes` | [`[ProtectedEnvironmentApprovalRule]`](#protectedenvironmentapprovalrule) | ノードのリスト。 |
| <a id="protectedenvironmentapprovalruleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ProtectedEnvironmentApprovalRuleEdge`

[`ProtectedEnvironmentApprovalRule`](#protectedenvironmentapprovalrule)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="protectedenvironmentapprovalruleedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="protectedenvironmentapprovalruleedgenode"></a>`node` | [`ProtectedEnvironmentApprovalRule`](#protectedenvironmentapprovalrule) | エッジの終端にあるアイテム。 |

#### `ProtectedEnvironmentConnection`

[`ProtectedEnvironment`](#protectedenvironment)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="protectedenvironmentconnectionedges"></a>`edges` | [`[ProtectedEnvironmentEdge]`](#protectedenvironmentedge) | エッジのリスト。 |
| <a id="protectedenvironmentconnectionnodes"></a>`nodes` | [`[ProtectedEnvironment]`](#protectedenvironment) | ノードのリスト。 |
| <a id="protectedenvironmentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ProtectedEnvironmentDeployAccessLevelConnection`

[`ProtectedEnvironmentDeployAccessLevel`](#protectedenvironmentdeployaccesslevel)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="protectedenvironmentdeployaccesslevelconnectionedges"></a>`edges` | [`[ProtectedEnvironmentDeployAccessLevelEdge]`](#protectedenvironmentdeployaccessleveledge) | エッジのリスト。 |
| <a id="protectedenvironmentdeployaccesslevelconnectionnodes"></a>`nodes` | [`[ProtectedEnvironmentDeployAccessLevel]`](#protectedenvironmentdeployaccesslevel) | ノードのリスト。 |
| <a id="protectedenvironmentdeployaccesslevelconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ProtectedEnvironmentDeployAccessLevelEdge`

[`ProtectedEnvironmentDeployAccessLevel`](#protectedenvironmentdeployaccesslevel)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="protectedenvironmentdeployaccessleveledgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="protectedenvironmentdeployaccessleveledgenode"></a>`node` | [`ProtectedEnvironmentDeployAccessLevel`](#protectedenvironmentdeployaccesslevel) | エッジの終端にあるアイテム。 |

#### `ProtectedEnvironmentEdge`

[`ProtectedEnvironment`](#protectedenvironment)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="protectedenvironmentedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="protectedenvironmentedgenode"></a>`node` | [`ProtectedEnvironment`](#protectedenvironment) | エッジの終端にあるアイテム。 |

#### `PushAccessLevelConnection`

[`PushAccessLevel`](#pushaccesslevel)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pushaccesslevelconnectionedges"></a>`edges` | [`[PushAccessLevelEdge]`](#pushaccessleveledge) | エッジのリスト。 |
| <a id="pushaccesslevelconnectionnodes"></a>`nodes` | [`[PushAccessLevel]`](#pushaccesslevel) | ノードのリスト。 |
| <a id="pushaccesslevelconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PushAccessLevelEdge`

[`PushAccessLevel`](#pushaccesslevel)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pushaccessleveledgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="pushaccessleveledgenode"></a>`node` | [`PushAccessLevel`](#pushaccesslevel) | エッジの終端にあるアイテム。 |

#### `ReleaseAssetLinkConnection`

[`ReleaseAssetLink`](#releaseassetlink)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="releaseassetlinkconnectionedges"></a>`edges` | [`[ReleaseAssetLinkEdge]`](#releaseassetlinkedge) | エッジのリスト。 |
| <a id="releaseassetlinkconnectionnodes"></a>`nodes` | [`[ReleaseAssetLink]`](#releaseassetlink) | ノードのリスト。 |
| <a id="releaseassetlinkconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ReleaseAssetLinkEdge`

[`ReleaseAssetLink`](#releaseassetlink)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="releaseassetlinkedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="releaseassetlinkedgenode"></a>`node` | [`ReleaseAssetLink`](#releaseassetlink) | エッジの終端にあるアイテム。 |

#### `ReleaseConnection`

[`Release`](#release)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="releaseconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="releaseconnectionedges"></a>`edges` | [`[ReleaseEdge]`](#releaseedge) | エッジのリスト。 |
| <a id="releaseconnectionnodes"></a>`nodes` | [`[Release]`](#release) | ノードのリスト。 |
| <a id="releaseconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ReleaseEdge`

[`Release`](#release)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="releaseedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="releaseedgenode"></a>`node` | [`Release`](#release) | エッジの終端にあるアイテム。 |

#### `ReleaseEvidenceConnection`

[`ReleaseEvidence`](#releaseevidence)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="releaseevidenceconnectionedges"></a>`edges` | [`[ReleaseEvidenceEdge]`](#releaseevidenceedge) | エッジのリスト。 |
| <a id="releaseevidenceconnectionnodes"></a>`nodes` | [`[ReleaseEvidence]`](#releaseevidence) | ノードのリスト。 |
| <a id="releaseevidenceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ReleaseEvidenceEdge`

[`ReleaseEvidence`](#releaseevidence)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="releaseevidenceedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="releaseevidenceedgenode"></a>`node` | [`ReleaseEvidence`](#releaseevidence) | エッジの終端にあるアイテム。 |

#### `ReleaseSourceConnection`

[`ReleaseSource`](#releasesource)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="releasesourceconnectionedges"></a>`edges` | [`[ReleaseSourceEdge]`](#releasesourceedge) | エッジのリスト。 |
| <a id="releasesourceconnectionnodes"></a>`nodes` | [`[ReleaseSource]`](#releasesource) | ノードのリスト。 |
| <a id="releasesourceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ReleaseSourceEdge`

[`ReleaseSource`](#releasesource)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="releasesourceedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="releasesourceedgenode"></a>`node` | [`ReleaseSource`](#releasesource) | エッジの終端にあるアイテム。 |

#### `RepositoryBlobConnection`

[`RepositoryBlob`](#repositoryblob)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="repositoryblobconnectionedges"></a>`edges` | [`[RepositoryBlobEdge]`](#repositoryblobedge) | エッジのリスト。 |
| <a id="repositoryblobconnectionnodes"></a>`nodes` | [`[RepositoryBlob]`](#repositoryblob) | ノードのリスト。 |
| <a id="repositoryblobconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `RepositoryBlobEdge`

[`RepositoryBlob`](#repositoryblob)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="repositoryblobedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="repositoryblobedgenode"></a>`node` | [`RepositoryBlob`](#repositoryblob) | エッジの終端にあるアイテム。 |

#### `RequirementConnection`

[`Requirement`](#requirement)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="requirementconnectionedges"></a>`edges` | [`[RequirementEdge]`](#requirementedge) | エッジのリスト。 |
| <a id="requirementconnectionnodes"></a>`nodes` | [`[Requirement]`](#requirement) | ノードのリスト。 |
| <a id="requirementconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `RequirementEdge`

[`Requirement`](#requirement)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="requirementedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="requirementedgenode"></a>`node` | [`Requirement`](#requirement) | エッジの終端にあるアイテム。 |

#### `RunnerArchitectureConnection`

[`RunnerArchitecture`](#runnerarchitecture)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="runnerarchitectureconnectionedges"></a>`edges` | [`[RunnerArchitectureEdge]`](#runnerarchitectureedge) | エッジのリスト。 |
| <a id="runnerarchitectureconnectionnodes"></a>`nodes` | [`[RunnerArchitecture]`](#runnerarchitecture) | ノードのリスト。 |
| <a id="runnerarchitectureconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `RunnerArchitectureEdge`

[`RunnerArchitecture`](#runnerarchitecture)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="runnerarchitectureedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="runnerarchitectureedgenode"></a>`node` | [`RunnerArchitecture`](#runnerarchitecture) | エッジの終端にあるアイテム。 |

#### `RunnerPlatformConnection`

[`RunnerPlatform`](#runnerplatform)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="runnerplatformconnectionedges"></a>`edges` | [`[RunnerPlatformEdge]`](#runnerplatformedge) | エッジのリスト。 |
| <a id="runnerplatformconnectionnodes"></a>`nodes` | [`[RunnerPlatform]`](#runnerplatform) | ノードのリスト。 |
| <a id="runnerplatformconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `RunnerPlatformEdge`

[`RunnerPlatform`](#runnerplatform)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="runnerplatformedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="runnerplatformedgenode"></a>`node` | [`RunnerPlatform`](#runnerplatform) | エッジの終端にあるアイテム。 |

#### `SastCiConfigurationAnalyzersEntityConnection`

[`SastCiConfigurationAnalyzersEntity`](#sastciconfigurationanalyzersentity)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="sastciconfigurationanalyzersentityconnectionedges"></a>`edges` | [`[SastCiConfigurationAnalyzersEntityEdge]`](#sastciconfigurationanalyzersentityedge) | エッジのリスト。 |
| <a id="sastciconfigurationanalyzersentityconnectionnodes"></a>`nodes` | [`[SastCiConfigurationAnalyzersEntity]`](#sastciconfigurationanalyzersentity) | ノードのリスト。 |
| <a id="sastciconfigurationanalyzersentityconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `SastCiConfigurationAnalyzersEntityEdge`

[`SastCiConfigurationAnalyzersEntity`](#sastciconfigurationanalyzersentity)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="sastciconfigurationanalyzersentityedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="sastciconfigurationanalyzersentityedgenode"></a>`node` | [`SastCiConfigurationAnalyzersEntity`](#sastciconfigurationanalyzersentity) | エッジの終端にあるアイテム。 |

#### `SastCiConfigurationEntityConnection`

[`SastCiConfigurationEntity`](#sastciconfigurationentity)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="sastciconfigurationentityconnectionedges"></a>`edges` | [`[SastCiConfigurationEntityEdge]`](#sastciconfigurationentityedge) | エッジのリスト。 |
| <a id="sastciconfigurationentityconnectionnodes"></a>`nodes` | [`[SastCiConfigurationEntity]`](#sastciconfigurationentity) | ノードのリスト。 |
| <a id="sastciconfigurationentityconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `SastCiConfigurationEntityEdge`

[`SastCiConfigurationEntity`](#sastciconfigurationentity)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="sastciconfigurationentityedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="sastciconfigurationentityedgenode"></a>`node` | [`SastCiConfigurationEntity`](#sastciconfigurationentity) | エッジの終端にあるアイテム。 |

#### `SastCiConfigurationOptionsEntityConnection`

[`SastCiConfigurationOptionsEntity`](#sastciconfigurationoptionsentity)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="sastciconfigurationoptionsentityconnectionedges"></a>`edges` | [`[SastCiConfigurationOptionsEntityEdge]`](#sastciconfigurationoptionsentityedge) | エッジのリスト。 |
| <a id="sastciconfigurationoptionsentityconnectionnodes"></a>`nodes` | [`[SastCiConfigurationOptionsEntity]`](#sastciconfigurationoptionsentity) | ノードのリスト。 |
| <a id="sastciconfigurationoptionsentityconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `SastCiConfigurationOptionsEntityEdge`

[`SastCiConfigurationOptionsEntity`](#sastciconfigurationoptionsentity)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="sastciconfigurationoptionsentityedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="sastciconfigurationoptionsentityedgenode"></a>`node` | [`SastCiConfigurationOptionsEntity`](#sastciconfigurationoptionsentity) | エッジの終端にあるアイテム。 |

#### `SavedReplyConnection`

[`SavedReply`](#savedreply)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="savedreplyconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="savedreplyconnectionedges"></a>`edges` | [`[SavedReplyEdge]`](#savedreplyedge) | エッジのリスト。 |
| <a id="savedreplyconnectionnodes"></a>`nodes` | [`[SavedReply]`](#savedreply) | ノードのリスト。 |
| <a id="savedreplyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `SavedReplyEdge`

[`SavedReply`](#savedreply)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="savedreplyedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="savedreplyedgenode"></a>`node` | [`SavedReply`](#savedreply) | エッジの終端にあるアイテム。 |

#### `ScanConnection`

[`Scan`](#scan)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="scanconnectionedges"></a>`edges` | [`[ScanEdge]`](#scanedge) | エッジのリスト。 |
| <a id="scanconnectionnodes"></a>`nodes` | [`[Scan]`](#scan) | ノードのリスト。 |
| <a id="scanconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ScanEdge`

[`Scan`](#scan)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="scanedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="scanedgenode"></a>`node` | [`Scan`](#scan) | エッジの終端にあるアイテム。 |

#### `ScanExecutionPolicyConnection`

[`ScanExecutionPolicy`](#scanexecutionpolicy)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="scanexecutionpolicyconnectionedges"></a>`edges` | [`[ScanExecutionPolicyEdge]`](#scanexecutionpolicyedge) | エッジのリスト。 |
| <a id="scanexecutionpolicyconnectionnodes"></a>`nodes` | [`[ScanExecutionPolicy]`](#scanexecutionpolicy) | ノードのリスト。 |
| <a id="scanexecutionpolicyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ScanExecutionPolicyEdge`

[`ScanExecutionPolicy`](#scanexecutionpolicy)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="scanexecutionpolicyedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="scanexecutionpolicyedgenode"></a>`node` | [`ScanExecutionPolicy`](#scanexecutionpolicy) | エッジの終端にあるアイテム。 |

#### `ScanResultPolicyConnection`

[`ScanResultPolicy`](#scanresultpolicy)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="scanresultpolicyconnectionedges"></a>`edges` | [`[ScanResultPolicyEdge]`](#scanresultpolicyedge) | エッジのリスト。 |
| <a id="scanresultpolicyconnectionnodes"></a>`nodes` | [`[ScanResultPolicy]`](#scanresultpolicy) | ノードのリスト。 |
| <a id="scanresultpolicyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ScanResultPolicyEdge`

[`ScanResultPolicy`](#scanresultpolicy)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="scanresultpolicyedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="scanresultpolicyedgenode"></a>`node` | [`ScanResultPolicy`](#scanresultpolicy) | エッジの終端にあるアイテム。 |

#### `ScannedResourceConnection`

[`ScannedResource`](#scannedresource)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="scannedresourceconnectionedges"></a>`edges` | [`[ScannedResourceEdge]`](#scannedresourceedge) | エッジのリスト。 |
| <a id="scannedresourceconnectionnodes"></a>`nodes` | [`[ScannedResource]`](#scannedresource) | ノードのリスト。 |
| <a id="scannedresourceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ScannedResourceEdge`

[`ScannedResource`](#scannedresource)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="scannedresourceedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="scannedresourceedgenode"></a>`node` | [`ScannedResource`](#scannedresource) | エッジの終端にあるアイテム。 |

#### `SentryErrorConnection`

[`SentryError`](#sentryerror)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="sentryerrorconnectionedges"></a>`edges` | [`[SentryErrorEdge]`](#sentryerroredge) | エッジのリスト。 |
| <a id="sentryerrorconnectionnodes"></a>`nodes` | [`[SentryError]`](#sentryerror) | ノードのリスト。 |
| <a id="sentryerrorconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `SentryErrorEdge`

[`SentryError`](#sentryerror)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="sentryerroredgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="sentryerroredgenode"></a>`node` | [`SentryError`](#sentryerror) | エッジの終端にあるアイテム。 |

#### `ServiceConnection`

[`Service`](#service)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="serviceconnectionedges"></a>`edges` | [`[ServiceEdge]`](#serviceedge) | エッジのリスト。 |
| <a id="serviceconnectionnodes"></a>`nodes` | [`[Service]`](#service) | ノードのリスト。 |
| <a id="serviceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ServiceEdge`

[`Service`](#service)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="serviceedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="serviceedgenode"></a>`node` | [`Service`](#service) | エッジの終端にあるアイテム。 |

#### `SeverityOverrideConnection`

[`SeverityOverride`](#severityoverride)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="severityoverrideconnectionedges"></a>`edges` | [`[SeverityOverrideEdge]`](#severityoverrideedge) | エッジのリスト。 |
| <a id="severityoverrideconnectionnodes"></a>`nodes` | [`[SeverityOverride]`](#severityoverride) | ノードのリスト。 |
| <a id="severityoverrideconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `SeverityOverrideEdge`

[`SeverityOverride`](#severityoverride)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="severityoverrideedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="severityoverrideedgenode"></a>`node` | [`SeverityOverride`](#severityoverride) | エッジの終端にあるアイテム。 |

#### `SnippetBlobConnection`

[`SnippetBlob`](#snippetblob)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="snippetblobconnectionedges"></a>`edges` | [`[SnippetBlobEdge]`](#snippetblobedge) | エッジのリスト。 |
| <a id="snippetblobconnectionhasunretrievableblobs"></a>`hasUnretrievableBlobs` | [`Boolean!`](#boolean) | スニペットに取得不能blobがあるかどうかを示します。 |
| <a id="snippetblobconnectionnodes"></a>`nodes` | [`[SnippetBlob]`](#snippetblob) | ノードのリスト。 |
| <a id="snippetblobconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `SnippetBlobEdge`

[`SnippetBlob`](#snippetblob)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="snippetblobedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="snippetblobedgenode"></a>`node` | [`SnippetBlob`](#snippetblob) | エッジの終端にあるアイテム。 |

#### `SnippetConnection`

[`Snippet`](#snippet)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="snippetconnectionedges"></a>`edges` | [`[SnippetEdge]`](#snippetedge) | エッジのリスト。 |
| <a id="snippetconnectionnodes"></a>`nodes` | [`[Snippet]`](#snippet) | ノードのリスト。 |
| <a id="snippetconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `SnippetEdge`

[`Snippet`](#snippet)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="snippetedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="snippetedgenode"></a>`node` | [`Snippet`](#snippet) | エッジの終端にあるアイテム。 |

#### `SnippetRepositoryRegistryConnection`

[`SnippetRepositoryRegistry`](#snippetrepositoryregistry)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="snippetrepositoryregistryconnectionedges"></a>`edges` | [`[SnippetRepositoryRegistryEdge]`](#snippetrepositoryregistryedge) | エッジのリスト。 |
| <a id="snippetrepositoryregistryconnectionnodes"></a>`nodes` | [`[SnippetRepositoryRegistry]`](#snippetrepositoryregistry) | ノードのリスト。 |
| <a id="snippetrepositoryregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド

###### `SnippetRepositoryRegistryConnection.count`

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="snippetrepositoryregistryconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `SnippetRepositoryRegistryEdge`

[`SnippetRepositoryRegistry`](#snippetrepositoryregistry)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="snippetrepositoryregistryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="snippetrepositoryregistryedgenode"></a>`node` | [`SnippetRepositoryRegistry`](#snippetrepositoryregistry) | エッジの終端にあるアイテム。 |

#### `StandardRoleConnection`

[`StandardRole`](#standardrole)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="standardroleconnectionedges"></a>`edges` | [`[StandardRoleEdge]`](#standardroleedge) | エッジのリスト。 |
| <a id="standardroleconnectionnodes"></a>`nodes` | [`[StandardRole]`](#standardrole) | ノードのリスト。 |
| <a id="standardroleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `StandardRoleEdge`

[`StandardRole`](#standardrole)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="standardroleedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="standardroleedgenode"></a>`node` | [`StandardRole`](#standardrole) | エッジの終端にあるアイテム。 |

#### `SubmoduleConnection`

[`Submodule`](#submodule)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="submoduleconnectionedges"></a>`edges` | [`[SubmoduleEdge]`](#submoduleedge) | エッジのリスト。 |
| <a id="submoduleconnectionnodes"></a>`nodes` | [`[Submodule]`](#submodule) | ノードのリスト。 |
| <a id="submoduleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `SubmoduleEdge`

[`Submodule`](#submodule)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="submoduleedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="submoduleedgenode"></a>`node` | [`Submodule`](#submodule) | エッジの終端にあるアイテム。 |

#### `SubscriptionFutureEntryConnection`

[`SubscriptionFutureEntry`](#subscriptionfutureentry)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="subscriptionfutureentryconnectionedges"></a>`edges` | [`[SubscriptionFutureEntryEdge]`](#subscriptionfutureentryedge) | エッジのリスト。 |
| <a id="subscriptionfutureentryconnectionnodes"></a>`nodes` | [`[SubscriptionFutureEntry]`](#subscriptionfutureentry) | ノードのリスト。 |
| <a id="subscriptionfutureentryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `SubscriptionFutureEntryEdge`

[`SubscriptionFutureEntry`](#subscriptionfutureentry)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="subscriptionfutureentryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="subscriptionfutureentryedgenode"></a>`node` | [`SubscriptionFutureEntry`](#subscriptionfutureentry) | エッジの終端にあるアイテム。 |

#### `TerraformStateConnection`

[`TerraformState`](#terraformstate)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="terraformstateconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="terraformstateconnectionedges"></a>`edges` | [`[TerraformStateEdge]`](#terraformstateedge) | エッジのリスト。 |
| <a id="terraformstateconnectionnodes"></a>`nodes` | [`[TerraformState]`](#terraformstate) | ノードのリスト。 |
| <a id="terraformstateconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `TerraformStateEdge`

[`TerraformState`](#terraformstate)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="terraformstateedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="terraformstateedgenode"></a>`node` | [`TerraformState`](#terraformstate) | エッジの終端にあるアイテム。 |

#### `TerraformStateVersionRegistryConnection`

[`TerraformStateVersionRegistry`](#terraformstateversionregistry)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="terraformstateversionregistryconnectionedges"></a>`edges` | [`[TerraformStateVersionRegistryEdge]`](#terraformstateversionregistryedge) | エッジのリスト。 |
| <a id="terraformstateversionregistryconnectionnodes"></a>`nodes` | [`[TerraformStateVersionRegistry]`](#terraformstateversionregistry) | ノードのリスト。 |
| <a id="terraformstateversionregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド

###### `TerraformStateVersionRegistryConnection.count`

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="terraformstateversionregistryconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `TerraformStateVersionRegistryEdge`

[`TerraformStateVersionRegistry`](#terraformstateversionregistry)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="terraformstateversionregistryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="terraformstateversionregistryedgenode"></a>`node` | [`TerraformStateVersionRegistry`](#terraformstateversionregistry) | エッジの終端にあるアイテム。 |

#### `TestCaseConnection`

[`TestCase`](#testcase)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="testcaseconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="testcaseconnectionedges"></a>`edges` | [`[TestCaseEdge]`](#testcaseedge) | エッジのリスト。 |
| <a id="testcaseconnectionnodes"></a>`nodes` | [`[TestCase]`](#testcase) | ノードのリスト。 |
| <a id="testcaseconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `TestCaseEdge`

[`TestCase`](#testcase)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="testcaseedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="testcaseedgenode"></a>`node` | [`TestCase`](#testcase) | エッジの終端にあるアイテム。 |

#### `TestReportConnection`

[`TestReport`](#testreport)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="testreportconnectionedges"></a>`edges` | [`[TestReportEdge]`](#testreportedge) | エッジのリスト。 |
| <a id="testreportconnectionnodes"></a>`nodes` | [`[TestReport]`](#testreport) | ノードのリスト。 |
| <a id="testreportconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `TestReportEdge`

[`TestReport`](#testreport)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="testreportedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="testreportedgenode"></a>`node` | [`TestReport`](#testreport) | エッジの終端にあるアイテム。 |

#### `TestSuiteSummaryConnection`

[`TestSuiteSummary`](#testsuitesummary)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="testsuitesummaryconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="testsuitesummaryconnectionedges"></a>`edges` | [`[TestSuiteSummaryEdge]`](#testsuitesummaryedge) | エッジのリスト。 |
| <a id="testsuitesummaryconnectionnodes"></a>`nodes` | [`[TestSuiteSummary]`](#testsuitesummary) | ノードのリスト。 |
| <a id="testsuitesummaryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `TestSuiteSummaryEdge`

[`TestSuiteSummary`](#testsuitesummary)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="testsuitesummaryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="testsuitesummaryedgenode"></a>`node` | [`TestSuiteSummary`](#testsuitesummary) | エッジの終端にあるアイテム。 |

#### `TimeTrackingTimelogCategoryConnection`

[`TimeTrackingTimelogCategory`](#timetrackingtimelogcategory)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="timetrackingtimelogcategoryconnectionedges"></a>`edges` | [`[TimeTrackingTimelogCategoryEdge]`](#timetrackingtimelogcategoryedge) | エッジのリスト。 |
| <a id="timetrackingtimelogcategoryconnectionnodes"></a>`nodes` | [`[TimeTrackingTimelogCategory]`](#timetrackingtimelogcategory) | ノードのリスト。 |
| <a id="timetrackingtimelogcategoryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `TimeTrackingTimelogCategoryEdge`

[`TimeTrackingTimelogCategory`](#timetrackingtimelogcategory)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="timetrackingtimelogcategoryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="timetrackingtimelogcategoryedgenode"></a>`node` | [`TimeTrackingTimelogCategory`](#timetrackingtimelogcategory) | エッジの終端にあるアイテム。 |

#### `TimelineEventTagTypeConnection`

[`TimelineEventTagType`](#timelineeventtagtype)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="timelineeventtagtypeconnectionedges"></a>`edges` | [`[TimelineEventTagTypeEdge]`](#timelineeventtagtypeedge) | エッジのリスト。 |
| <a id="timelineeventtagtypeconnectionnodes"></a>`nodes` | [`[TimelineEventTagType]`](#timelineeventtagtype) | ノードのリスト。 |
| <a id="timelineeventtagtypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `TimelineEventTagTypeEdge`

[`TimelineEventTagType`](#timelineeventtagtype)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="timelineeventtagtypeedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="timelineeventtagtypeedgenode"></a>`node` | [`TimelineEventTagType`](#timelineeventtagtype) | エッジの終端にあるアイテム。 |

#### `TimelineEventTypeConnection`

[`TimelineEventType`](#timelineeventtype)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="timelineeventtypeconnectionedges"></a>`edges` | [`[TimelineEventTypeEdge]`](#timelineeventtypeedge) | エッジのリスト。 |
| <a id="timelineeventtypeconnectionnodes"></a>`nodes` | [`[TimelineEventType]`](#timelineeventtype) | ノードのリスト。 |
| <a id="timelineeventtypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `TimelineEventTypeEdge`

[`TimelineEventType`](#timelineeventtype)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="timelineeventtypeedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="timelineeventtypeedgenode"></a>`node` | [`TimelineEventType`](#timelineeventtype) | エッジの終端にあるアイテム。 |

#### `TimelogConnection`

[`Timelog`](#timelog)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="timelogconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="timelogconnectionedges"></a>`edges` | [`[TimelogEdge]`](#timelogedge) | エッジのリスト。 |
| <a id="timelogconnectionnodes"></a>`nodes` | [`[Timelog]`](#timelog) | ノードのリスト。 |
| <a id="timelogconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |
| <a id="timelogconnectiontotalspenttime"></a>`totalSpentTime` | [`BigInt!`](#bigint) | 合計経過時間（秒）。 |

#### `TimelogEdge`

[`Timelog`](#timelog)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="timelogedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="timelogedgenode"></a>`node` | [`Timelog`](#timelog) | エッジの終端にあるアイテム。 |

#### `TodoConnection`

[`Todo`](#todo)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="todoconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="todoconnectionedges"></a>`edges` | [`[TodoEdge]`](#todoedge) | エッジのリスト。 |
| <a id="todoconnectionnodes"></a>`nodes` | [`[Todo]`](#todo) | ノードのリスト。 |
| <a id="todoconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `TodoEdge`

[`Todo`](#todo)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="todoedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="todoedgenode"></a>`node` | [`Todo`](#todo) | エッジの終端にあるアイテム。 |

#### `TopicConnection`

[`Topic`](#topic)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="topicconnectionedges"></a>`edges` | [`[TopicEdge]`](#topicedge) | エッジのリスト。 |
| <a id="topicconnectionnodes"></a>`nodes` | [`[Topic]`](#topic) | ノードのリスト。 |
| <a id="topicconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `TopicEdge`

[`Topic`](#topic)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="topicedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="topicedgenode"></a>`node` | [`Topic`](#topic) | エッジの終端にあるアイテム。 |

#### `TreeConnection`

[`Tree`](#tree)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="treeconnectionedges"></a>`edges` | [`[TreeEdge]`](#treeedge) | エッジのリスト。 |
| <a id="treeconnectionnodes"></a>`nodes` | [`[Tree]`](#tree) | ノードのリスト。 |
| <a id="treeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `TreeEdge`

[`Tree`](#tree)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="treeedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="treeedgenode"></a>`node` | [`Tree`](#tree) | エッジの終端にあるアイテム。 |

#### `TreeEntryConnection`

[`TreeEntry`](#treeentry)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="treeentryconnectionedges"></a>`edges` | [`[TreeEntryEdge]`](#treeentryedge) | エッジのリスト。 |
| <a id="treeentryconnectionnodes"></a>`nodes` | [`[TreeEntry]`](#treeentry) | ノードのリスト。 |
| <a id="treeentryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `TreeEntryEdge`

[`TreeEntry`](#treeentry)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="treeentryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="treeentryedgenode"></a>`node` | [`TreeEntry`](#treeentry) | エッジの終端にあるアイテム。 |

#### `UnprotectAccessLevelConnection`

[`UnprotectAccessLevel`](#unprotectaccesslevel)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="unprotectaccesslevelconnectionedges"></a>`edges` | [`[UnprotectAccessLevelEdge]`](#unprotectaccessleveledge) | エッジのリスト。 |
| <a id="unprotectaccesslevelconnectionnodes"></a>`nodes` | [`[UnprotectAccessLevel]`](#unprotectaccesslevel) | ノードのリスト。 |
| <a id="unprotectaccesslevelconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `UnprotectAccessLevelEdge`

[`UnprotectAccessLevel`](#unprotectaccesslevel)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="unprotectaccessleveledgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="unprotectaccessleveledgenode"></a>`node` | [`UnprotectAccessLevel`](#unprotectaccesslevel) | エッジの終端にあるアイテム。 |

#### `UploadRegistryConnection`

[`UploadRegistry`](#uploadregistry)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="uploadregistryconnectionedges"></a>`edges` | [`[UploadRegistryEdge]`](#uploadregistryedge) | エッジのリスト。 |
| <a id="uploadregistryconnectionnodes"></a>`nodes` | [`[UploadRegistry]`](#uploadregistry) | ノードのリスト。 |
| <a id="uploadregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド

###### `UploadRegistryConnection.count`

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="uploadregistryconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `UploadRegistryEdge`

[`UploadRegistry`](#uploadregistry)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="uploadregistryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="uploadregistryedgenode"></a>`node` | [`UploadRegistry`](#uploadregistry) | エッジの終端にあるアイテム。 |

#### `UsageTrendsMeasurementConnection`

[`UsageTrendsMeasurement`](#usagetrendsmeasurement)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="usagetrendsmeasurementconnectionedges"></a>`edges` | [`[UsageTrendsMeasurementEdge]`](#usagetrendsmeasurementedge) | エッジのリスト。 |
| <a id="usagetrendsmeasurementconnectionnodes"></a>`nodes` | [`[UsageTrendsMeasurement]`](#usagetrendsmeasurement) | ノードのリスト。 |
| <a id="usagetrendsmeasurementconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `UsageTrendsMeasurementEdge`

[`UsageTrendsMeasurement`](#usagetrendsmeasurement)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="usagetrendsmeasurementedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="usagetrendsmeasurementedgenode"></a>`node` | [`UsageTrendsMeasurement`](#usagetrendsmeasurement) | エッジの終端にあるアイテム。 |

#### `UserAchievementConnection`

[`UserAchievement`](#userachievement)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="userachievementconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="userachievementconnectionedges"></a>`edges` | [`[UserAchievementEdge]`](#userachievementedge) | エッジのリスト。 |
| <a id="userachievementconnectionnodes"></a>`nodes` | [`[UserAchievement]`](#userachievement) | ノードのリスト。 |
| <a id="userachievementconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `UserAchievementEdge`

[`UserAchievement`](#userachievement)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="userachievementedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="userachievementedgenode"></a>`node` | [`UserAchievement`](#userachievement) | エッジの終端にあるアイテム。 |

#### `UserAddOnAssignmentConnection`

[`UserAddOnAssignment`](#useraddonassignment)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="useraddonassignmentconnectionedges"></a>`edges` | [`[UserAddOnAssignmentEdge]`](#useraddonassignmentedge) | エッジのリスト。 |
| <a id="useraddonassignmentconnectionnodes"></a>`nodes` | [`[UserAddOnAssignment]`](#useraddonassignment) | ノードのリスト。 |
| <a id="useraddonassignmentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `UserAddOnAssignmentEdge`

[`UserAddOnAssignment`](#useraddonassignment)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="useraddonassignmentedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="useraddonassignmentedgenode"></a>`node` | [`UserAddOnAssignment`](#useraddonassignment) | エッジの終端にあるアイテム。 |

#### `UserCalloutConnection`

[`UserCallout`](#usercallout)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="usercalloutconnectionedges"></a>`edges` | [`[UserCalloutEdge]`](#usercalloutedge) | エッジのリスト。 |
| <a id="usercalloutconnectionnodes"></a>`nodes` | [`[UserCallout]`](#usercallout) | ノードのリスト。 |
| <a id="usercalloutconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `UserCalloutEdge`

[`UserCallout`](#usercallout)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="usercalloutedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="usercalloutedgenode"></a>`node` | [`UserCallout`](#usercallout) | エッジの終端にあるアイテム。 |

#### `UserCoreConnection`

[`UserCore`](#usercore)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="usercoreconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="usercoreconnectionedges"></a>`edges` | [`[UserCoreEdge]`](#usercoreedge) | エッジのリスト。 |
| <a id="usercoreconnectionnodes"></a>`nodes` | [`[UserCore]`](#usercore) | ノードのリスト。 |
| <a id="usercoreconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `UserCoreEdge`

[`UserCore`](#usercore)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="usercoreedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="usercoreedgenode"></a>`node` | [`UserCore`](#usercore) | エッジの終端にあるアイテム。 |

#### `UsersQueuedForRolePromotionConnection`

[`UsersQueuedForRolePromotion`](#usersqueuedforrolepromotion)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="usersqueuedforrolepromotionconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="usersqueuedforrolepromotionconnectionedges"></a>`edges` | [`[UsersQueuedForRolePromotionEdge]`](#usersqueuedforrolepromotionedge) | エッジのリスト。 |
| <a id="usersqueuedforrolepromotionconnectionnodes"></a>`nodes` | [`[UsersQueuedForRolePromotion]`](#usersqueuedforrolepromotion) | ノードのリスト。 |
| <a id="usersqueuedforrolepromotionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `UsersQueuedForRolePromotionEdge`

[`UsersQueuedForRolePromotion`](#usersqueuedforrolepromotion)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="usersqueuedforrolepromotionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="usersqueuedforrolepromotionedgenode"></a>`node` | [`UsersQueuedForRolePromotion`](#usersqueuedforrolepromotion) | エッジの終端にあるアイテム。 |

#### `ValueStreamConnection`

[`ValueStream`](#valuestream)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="valuestreamconnectionedges"></a>`edges` | [`[ValueStreamEdge]`](#valuestreamedge) | エッジのリスト。 |
| <a id="valuestreamconnectionnodes"></a>`nodes` | [`[ValueStream]`](#valuestream) | ノードのリスト。 |
| <a id="valuestreamconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ValueStreamEdge`

[`ValueStream`](#valuestream)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="valuestreamedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="valuestreamedgenode"></a>`node` | [`ValueStream`](#valuestream) | エッジの終端にあるアイテム。 |

#### `ValueStreamStageItemsConnection`

[`ValueStreamStageItems`](#valuestreamstageitems)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="valuestreamstageitemsconnectionedges"></a>`edges` | [`[ValueStreamStageItemsEdge]`](#valuestreamstageitemsedge) | エッジのリスト。 |
| <a id="valuestreamstageitemsconnectionnodes"></a>`nodes` | [`[ValueStreamStageItems]`](#valuestreamstageitems) | ノードのリスト。 |
| <a id="valuestreamstageitemsconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ValueStreamStageItemsEdge`

[`ValueStreamStageItems`](#valuestreamstageitems)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="valuestreamstageitemsedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="valuestreamstageitemsedgenode"></a>`node` | [`ValueStreamStageItems`](#valuestreamstageitems) | エッジの終端にあるアイテム。 |

#### `VulnerabilitiesCountByDayConnection`

[`VulnerabilitiesCountByDay`](#vulnerabilitiescountbyday)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="vulnerabilitiescountbydayconnectionedges"></a>`edges` | [`[VulnerabilitiesCountByDayEdge]`](#vulnerabilitiescountbydayedge) | エッジのリスト。 |
| <a id="vulnerabilitiescountbydayconnectionnodes"></a>`nodes` | [`[VulnerabilitiesCountByDay]`](#vulnerabilitiescountbyday) | ノードのリスト。 |
| <a id="vulnerabilitiescountbydayconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `VulnerabilitiesCountByDayEdge`

[`VulnerabilitiesCountByDay`](#vulnerabilitiescountbyday)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="vulnerabilitiescountbydayedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="vulnerabilitiescountbydayedgenode"></a>`node` | [`VulnerabilitiesCountByDay`](#vulnerabilitiescountbyday) | エッジの終端にあるアイテム。 |

#### `VulnerabilityConnection`

[`Vulnerability`](#vulnerability)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="vulnerabilityconnectionedges"></a>`edges` | [`[VulnerabilityEdge]`](#vulnerabilityedge) | エッジのリスト。 |
| <a id="vulnerabilityconnectionnodes"></a>`nodes` | [`[Vulnerability]`](#vulnerability) | ノードのリスト。 |
| <a id="vulnerabilityconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `VulnerabilityContainerImageConnection`

[`VulnerabilityContainerImage`](#vulnerabilitycontainerimage)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="vulnerabilitycontainerimageconnectionedges"></a>`edges` | [`[VulnerabilityContainerImageEdge]`](#vulnerabilitycontainerimageedge) | エッジのリスト。 |
| <a id="vulnerabilitycontainerimageconnectionnodes"></a>`nodes` | [`[VulnerabilityContainerImage]`](#vulnerabilitycontainerimage) | ノードのリスト。 |
| <a id="vulnerabilitycontainerimageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `VulnerabilityContainerImageEdge`

[`VulnerabilityContainerImage`](#vulnerabilitycontainerimage)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="vulnerabilitycontainerimageedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="vulnerabilitycontainerimageedgenode"></a>`node` | [`VulnerabilityContainerImage`](#vulnerabilitycontainerimage) | エッジの終端にあるアイテム。 |

#### `VulnerabilityEdge`

[`Vulnerability`](#vulnerability)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="vulnerabilityedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="vulnerabilityedgenode"></a>`node` | [`Vulnerability`](#vulnerability) | エッジの終端にあるアイテム。 |

#### `VulnerabilityExternalIssueLinkConnection`

[`VulnerabilityExternalIssueLink`](#vulnerabilityexternalissuelink)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="vulnerabilityexternalissuelinkconnectionedges"></a>`edges` | [`[VulnerabilityExternalIssueLinkEdge]`](#vulnerabilityexternalissuelinkedge) | エッジのリスト。 |
| <a id="vulnerabilityexternalissuelinkconnectionnodes"></a>`nodes` | [`[VulnerabilityExternalIssueLink]`](#vulnerabilityexternalissuelink) | ノードのリスト。 |
| <a id="vulnerabilityexternalissuelinkconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `VulnerabilityExternalIssueLinkEdge`

[`VulnerabilityExternalIssueLink`](#vulnerabilityexternalissuelink)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="vulnerabilityexternalissuelinkedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="vulnerabilityexternalissuelinkedgenode"></a>`node` | [`VulnerabilityExternalIssueLink`](#vulnerabilityexternalissuelink) | エッジの終端にあるアイテム。 |

#### `VulnerabilityIssueLinkConnection`

[`VulnerabilityIssueLink`](#vulnerabilityissuelink)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="vulnerabilityissuelinkconnectionedges"></a>`edges` | [`[VulnerabilityIssueLinkEdge]`](#vulnerabilityissuelinkedge) | エッジのリスト。 |
| <a id="vulnerabilityissuelinkconnectionnodes"></a>`nodes` | [`[VulnerabilityIssueLink]`](#vulnerabilityissuelink) | ノードのリスト。 |
| <a id="vulnerabilityissuelinkconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `VulnerabilityIssueLinkEdge`

[`VulnerabilityIssueLink`](#vulnerabilityissuelink)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="vulnerabilityissuelinkedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="vulnerabilityissuelinkedgenode"></a>`node` | [`VulnerabilityIssueLink`](#vulnerabilityissuelink) | エッジの終端にあるアイテム。 |

#### `VulnerabilityManagementPolicyConnection`

[`VulnerabilityManagementPolicy`](#vulnerabilitymanagementpolicy)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="vulnerabilitymanagementpolicyconnectionedges"></a>`edges` | [`[VulnerabilityManagementPolicyEdge]`](#vulnerabilitymanagementpolicyedge) | エッジのリスト。 |
| <a id="vulnerabilitymanagementpolicyconnectionnodes"></a>`nodes` | [`[VulnerabilityManagementPolicy]`](#vulnerabilitymanagementpolicy) | ノードのリスト。 |
| <a id="vulnerabilitymanagementpolicyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `VulnerabilityManagementPolicyEdge`

[`VulnerabilityManagementPolicy`](#vulnerabilitymanagementpolicy)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="vulnerabilitymanagementpolicyedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="vulnerabilitymanagementpolicyedgenode"></a>`node` | [`VulnerabilityManagementPolicy`](#vulnerabilitymanagementpolicy) | エッジの終端にあるアイテム。 |

#### `VulnerabilityScannerConnection`

[`VulnerabilityScanner`](#vulnerabilityscanner)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="vulnerabilityscannerconnectionedges"></a>`edges` | [`[VulnerabilityScannerEdge]`](#vulnerabilityscanneredge) | エッジのリスト。 |
| <a id="vulnerabilityscannerconnectionnodes"></a>`nodes` | [`[VulnerabilityScanner]`](#vulnerabilityscanner) | ノードのリスト。 |
| <a id="vulnerabilityscannerconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `VulnerabilityScannerEdge`

[`VulnerabilityScanner`](#vulnerabilityscanner)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="vulnerabilityscanneredgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="vulnerabilityscanneredgenode"></a>`node` | [`VulnerabilityScanner`](#vulnerabilityscanner) | エッジの終端にあるアイテム。 |

#### `VulnerabilityStateTransitionTypeConnection`

[`VulnerabilityStateTransitionType`](#vulnerabilitystatetransitiontype)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="vulnerabilitystatetransitiontypeconnectionedges"></a>`edges` | [`[VulnerabilityStateTransitionTypeEdge]`](#vulnerabilitystatetransitiontypeedge) | エッジのリスト。 |
| <a id="vulnerabilitystatetransitiontypeconnectionnodes"></a>`nodes` | [`[VulnerabilityStateTransitionType]`](#vulnerabilitystatetransitiontype) | ノードのリスト。 |
| <a id="vulnerabilitystatetransitiontypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `VulnerabilityStateTransitionTypeEdge`

[`VulnerabilityStateTransitionType`](#vulnerabilitystatetransitiontype)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="vulnerabilitystatetransitiontypeedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="vulnerabilitystatetransitiontypeedgenode"></a>`node` | [`VulnerabilityStateTransitionType`](#vulnerabilitystatetransitiontype) | エッジの終端にあるアイテム。 |

#### `WorkItemClosingMergeRequestConnection`

[`WorkItemClosingMergeRequest`](#workitemclosingmergerequest)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="workitemclosingmergerequestconnectionedges"></a>`edges` | [`[WorkItemClosingMergeRequestEdge]`](#workitemclosingmergerequestedge) | エッジのリスト。 |
| <a id="workitemclosingmergerequestconnectionnodes"></a>`nodes` | [`[WorkItemClosingMergeRequest]`](#workitemclosingmergerequest) | ノードのリスト。 |
| <a id="workitemclosingmergerequestconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `WorkItemClosingMergeRequestEdge`

[`WorkItemClosingMergeRequest`](#workitemclosingmergerequest)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="workitemclosingmergerequestedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="workitemclosingmergerequestedgenode"></a>`node` | [`WorkItemClosingMergeRequest`](#workitemclosingmergerequest) | エッジの終端にあるアイテム。 |

#### `WorkItemConnection`

[`WorkItem`](#workitem)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="workitemconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="workitemconnectionedges"></a>`edges` | [`[WorkItemEdge]`](#workitemedge) | エッジのリスト。 |
| <a id="workitemconnectionnodes"></a>`nodes` | [`[WorkItem]`](#workitem) | ノードのリスト。 |
| <a id="workitemconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `WorkItemDescriptionTemplateConnection`

[`WorkItemDescriptionTemplate`](#workitemdescriptiontemplate)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="workitemdescriptiontemplateconnectionedges"></a>`edges` | [`[WorkItemDescriptionTemplateEdge]`](#workitemdescriptiontemplateedge) | エッジのリスト。 |
| <a id="workitemdescriptiontemplateconnectionnodes"></a>`nodes` | [`[WorkItemDescriptionTemplate]`](#workitemdescriptiontemplate) | ノードのリスト。 |
| <a id="workitemdescriptiontemplateconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `WorkItemDescriptionTemplateEdge`

[`WorkItemDescriptionTemplate`](#workitemdescriptiontemplate)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="workitemdescriptiontemplateedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="workitemdescriptiontemplateedgenode"></a>`node` | [`WorkItemDescriptionTemplate`](#workitemdescriptiontemplate) | エッジの終端にあるアイテム。 |

#### `WorkItemEdge`

[`WorkItem`](#workitem)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="workitemedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="workitemedgenode"></a>`node` | [`WorkItem`](#workitem) | エッジの終端にあるアイテム。 |

#### `WorkItemLinkedResourceConnection`

[`WorkItemLinkedResource`](#workitemlinkedresource)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="workitemlinkedresourceconnectionedges"></a>`edges` | [`[WorkItemLinkedResourceEdge]`](#workitemlinkedresourceedge) | エッジのリスト。 |
| <a id="workitemlinkedresourceconnectionnodes"></a>`nodes` | [`[WorkItemLinkedResource]`](#workitemlinkedresource) | ノードのリスト。 |
| <a id="workitemlinkedresourceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `WorkItemLinkedResourceEdge`

[`WorkItemLinkedResource`](#workitemlinkedresource)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="workitemlinkedresourceedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="workitemlinkedresourceedgenode"></a>`node` | [`WorkItemLinkedResource`](#workitemlinkedresource) | エッジの終端にあるアイテム。 |

#### `WorkItemRelatedBranchConnection`

[`WorkItemRelatedBranch`](#workitemrelatedbranch)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="workitemrelatedbranchconnectionedges"></a>`edges` | [`[WorkItemRelatedBranchEdge]`](#workitemrelatedbranchedge) | エッジのリスト。 |
| <a id="workitemrelatedbranchconnectionnodes"></a>`nodes` | [`[WorkItemRelatedBranch]`](#workitemrelatedbranch) | ノードのリスト。 |
| <a id="workitemrelatedbranchconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `WorkItemRelatedBranchEdge`

[`WorkItemRelatedBranch`](#workitemrelatedbranch)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="workitemrelatedbranchedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="workitemrelatedbranchedgenode"></a>`node` | [`WorkItemRelatedBranch`](#workitemrelatedbranch) | エッジの終端にあるアイテム。 |

#### `WorkItemTimelogConnection`

[`WorkItemTimelog`](#workitemtimelog)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="workitemtimelogconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計カウント。 |
| <a id="workitemtimelogconnectionedges"></a>`edges` | [`[WorkItemTimelogEdge]`](#workitemtimelogedge) | エッジのリスト。 |
| <a id="workitemtimelogconnectionnodes"></a>`nodes` | [`[WorkItemTimelog]`](#workitemtimelog) | ノードのリスト。 |
| <a id="workitemtimelogconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |
| <a id="workitemtimelogconnectiontotalspenttime"></a>`totalSpentTime` | [`BigInt!`](#bigint) | 合計経過時間（秒）。 |

#### `WorkItemTimelogEdge`

[`WorkItemTimelog`](#workitemtimelog)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="workitemtimelogedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="workitemtimelogedgenode"></a>`node` | [`WorkItemTimelog`](#workitemtimelog) | エッジの終端にあるアイテム。 |

#### `WorkItemTypeConnection`

[`WorkItemType`](#workitemtype)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="workitemtypeconnectionedges"></a>`edges` | [`[WorkItemTypeEdge]`](#workitemtypeedge) | エッジのリスト。 |
| <a id="workitemtypeconnectionnodes"></a>`nodes` | [`[WorkItemType]`](#workitemtype) | ノードのリスト。 |
| <a id="workitemtypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `WorkItemTypeEdge`

[`WorkItemType`](#workitemtype)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="workitemtypeedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="workitemtypeedgenode"></a>`node` | [`WorkItemType`](#workitemtype) | エッジの終端にあるアイテム。 |

#### `WorkspaceConnection`

[`Workspace`](#workspace)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="workspaceconnectionedges"></a>`edges` | [`[WorkspaceEdge]`](#workspaceedge) | エッジのリスト。 |
| <a id="workspaceconnectionnodes"></a>`nodes` | [`[Workspace]`](#workspace) | ノードのリスト。 |
| <a id="workspaceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `WorkspaceEdge`

[`Workspace`](#workspace)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="workspaceedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="workspaceedgenode"></a>`node` | [`Workspace`](#workspace) | エッジの終端にあるアイテム。 |

#### `WorkspaceVariableConnection`

[`WorkspaceVariable`](#workspacevariable)の接続タイプ。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="workspacevariableconnectionedges"></a>`edges` | [`[WorkspaceVariableEdge]`](#workspacevariableedge) | エッジのリスト。 |
| <a id="workspacevariableconnectionnodes"></a>`nodes` | [`[WorkspaceVariable]`](#workspacevariable) | ノードのリスト。 |
| <a id="workspacevariableconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `WorkspaceVariableEdge`

[`WorkspaceVariable`](#workspacevariable)のエッジ型。

##### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="workspacevariableedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="workspacevariableedgenode"></a>`node` | [`WorkspaceVariable`](#workspacevariable) | エッジの終端にあるアイテム。 |

## オブジェクト型

オブジェクト型は、GitLab GraphQL APIが返すことができるリソースを表します。それには_フィールド_が含まれます。フィールドごとに独自の型があり、それはGraphQLの基本的な[スカラー型](https://graphql.org/learn/schema/#scalar-types)（`String`や`Boolean`など）か、またはその他のオブジェクト型のいずれかです。フィールドに引数がある場合もあります。引数のあるフィールドはトップレベルのクエリと同じようなものであり、フィールドの表の下にオブジェクト型ごとにそのリストが示されています。

詳細については、`graphql.org`の[オブジェクト型とフィールド](https://graphql.org/learn/schema/#object-types-and-fields)を参照してください。

### `AbuseReport`

不正行為レポート。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="abusereportdiscussions"></a>`discussions` | [`AbuseReportDiscussionConnection!`](#abusereportdiscussionconnection) | noteable（ノート可能）に対するすべてのディスカッション。（[接続](#connections)を参照） |
| <a id="abusereportid"></a>`id` | [`AbuseReportID!`](#abusereportid) | 不正行為レポートのグローバルID。 |
| <a id="abusereportlabels"></a>`labels` | [`AbuseReportLabelConnection`](#abusereportlabelconnection) | 不正行為レポートのラベル。（[接続](#connections)を参照） |
| <a id="abusereportnotes"></a>`notes` | [`AbuseReportNoteConnection!`](#abusereportnoteconnection) | noteable（ノート可能）に対するすべてのノート。（[接続](#connections)を参照） |

### `AbuseReportDiscussion`

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="abusereportdiscussionabusereport"></a>`abuseReport` | [`AbuseReport`](#abusereport) | ディスカッションが属する不正行為レポート。 |
| <a id="abusereportdiscussioncreatedat"></a>`createdAt` | [`Time!`](#time) | ディスカッションの作成時のタイムスタンプ。 |
| <a id="abusereportdiscussionid"></a>`id` | [`DiscussionID!`](#discussionid) | ディスカッションのID。 |
| <a id="abusereportdiscussionnotes"></a>`notes` | [`AbuseReportNoteConnection!`](#abusereportnoteconnection) | ディスカッション内のすべてのノート。（[接続](#connections)を参照） |
| <a id="abusereportdiscussionreplyid"></a>`replyId` | [`DiscussionID!`](#discussionid) | ディスカッションへの返信に使用するID。 |
| <a id="abusereportdiscussionresolvable"></a>`resolvable` | [`Boolean!`](#boolean) | オブジェクトを解決できるかどうかを示します。 |
| <a id="abusereportdiscussionresolved"></a>`resolved` | [`Boolean!`](#boolean) | オブジェクトが解決済みかどうかを示します。 |
| <a id="abusereportdiscussionresolvedat"></a>`resolvedAt` | [`Time`](#time) | オブジェクト解決時のタイムスタンプ。 |
| <a id="abusereportdiscussionresolvedby"></a>`resolvedBy` | [`UserCore`](#usercore) | オブジェクトを解決したユーザー。 |

### `AbuseReportLabel`

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="abusereportlabelcolor"></a>`color` | [`String!`](#string) | ラベルの背景色。 |
| <a id="abusereportlabelcreatedat"></a>`createdAt` | [`Time!`](#time) | ラベルが作成された日時。 |
| <a id="abusereportlabeldescription"></a>`description` | [`String`](#string) | ラベルの説明（Markdownをキャッシュ用にHTMLとしてレンダリング）。 |
| <a id="abusereportlabeldescriptionhtml"></a>`descriptionHtml` | [`String`](#string) | `description`のGitLab Flavored Markdownレンダリング。 |
| <a id="abusereportlabelid"></a>`id` | [`AntiAbuseReportsLabelID!`](#antiabusereportslabelid) | 不正行為レポートラベルのグローバルID。 |
| <a id="abusereportlabeltextcolor"></a>`textColor` | [`String!`](#string) | ラベルのテキストの色。 |
| <a id="abusereportlabeltitle"></a>`title` | [`String!`](#string) | ラベルの内容。 |
| <a id="abusereportlabelupdatedat"></a>`updatedAt` | [`Time!`](#time) | ラベルが最後に更新された日時。 |

### `AbuseReportNote`

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="abusereportnoteauthor"></a>`author` | [`UserCore`](#usercore) | ノートを書いたユーザー。 |
| <a id="abusereportnoteawardemoji"></a>`awardEmoji` | [`AwardEmojiConnection`](#awardemojiconnection) | ノートに関連付けられている絵文字リアクションのリスト。（[接続](#connections)を参照） |
| <a id="abusereportnotebody"></a>`body` | [`String!`](#string) | ノートの内容。 |
| <a id="abusereportnotebodyfirstlinehtml"></a>`bodyFirstLineHtml` | [`String!`](#string) | ノートの内容の最初の行。 |
| <a id="abusereportnotebodyhtml"></a>`bodyHtml` | [`String`](#string) | ノートの内容のGitLab Flavored Markdownレンダリング。 |
| <a id="abusereportnotecreatedat"></a>`createdAt` | [`Time!`](#time) | ノートの作成時のタイムスタンプ。 |
| <a id="abusereportnotediscussion"></a>`discussion` | [`AbuseReportDiscussion`](#abusereportdiscussion) | ノートが属するディスカッション。 |
| <a id="abusereportnoteid"></a>`id` | [`AntiAbuseReportsNoteID!`](#antiabusereportsnoteid) | ノートのID。 |
| <a id="abusereportnotelasteditedat"></a>`lastEditedAt` | [`Time`](#time) | ノートが最後に編集された時点のタイムスタンプ。 |
| <a id="abusereportnotelasteditedby"></a>`lastEditedBy` | [`UserCore`](#usercore) | ノートを最後に編集したユーザー。 |
| <a id="abusereportnoteresolvable"></a>`resolvable` | [`Boolean!`](#boolean) | オブジェクトを解決できるかどうかを示します。 |
| <a id="abusereportnoteresolved"></a>`resolved` | [`Boolean!`](#boolean) | オブジェクトが解決済みかどうかを示します。 |
| <a id="abusereportnoteresolvedat"></a>`resolvedAt` | [`Time`](#time) | オブジェクト解決時のタイムスタンプ。 |
| <a id="abusereportnoteresolvedby"></a>`resolvedBy` | [`UserCore`](#usercore) | オブジェクトを解決したユーザー。 |
| <a id="abusereportnoteupdatedat"></a>`updatedAt` | [`Time!`](#time) | ノートの最後のアクティビティーのタイムスタンプ。 |
| <a id="abusereportnoteurl"></a>`url` | [`String`](#string) | Web UIでノートを表示するURL。 |

### `AccessLevel`

ユーザーと、それに関連するオブジェクトとの間の関係のアクセスレベルを表します。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="accesslevelhumanaccess"></a>`humanAccess` | [`String`](#string) | 人間が判読できるアクセスレベルの表示名。 |
| <a id="accesslevelintegervalue"></a>`integerValue` | [`Int`](#int) | アクセスレベルの整数値。 |
| <a id="accesslevelstringvalue"></a>`stringValue` | [`AccessLevelEnum`](#accesslevelenum) | アクセスレベルのenum文字列。 |

### `AccessLevelDeployKey`

GitLabデプロイキーの表現。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="accessleveldeploykeyexpiresat"></a>`expiresAt` | [`Date`](#date) | デプロイキーの有効期限。 |
| <a id="accessleveldeploykeyid"></a>`id` | [`ID!`](#id) | デプロイキーのID。 |
| <a id="accessleveldeploykeytitle"></a>`title` | [`String!`](#string) | デプロイキーのタイトル。 |
| <a id="accessleveldeploykeyuser"></a>`user` | [`AccessLevelUser!`](#accessleveluser) | デプロイキーに割り当てられたユーザー。 |

### `AccessLevelGroup`

GitLabグループの表現。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="accesslevelgroupavatarurl"></a>`avatarUrl` | [`String`](#string) | グループのアバターURL。 |
| <a id="accesslevelgroupid"></a>`id` | [`ID!`](#id) | グループのID。 |
| <a id="accesslevelgroupname"></a>`name` | [`String!`](#string) | グループの名前。 |
| <a id="accesslevelgroupparent"></a>`parent` | [`AccessLevelGroup`](#accesslevelgroup) | 親グループ。 |
| <a id="accesslevelgroupweburl"></a>`webUrl` | [`String!`](#string) | グループのWeb URL。 |

### `AccessLevelUser`

GitLabユーザーの表現。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="accessleveluseravatarurl"></a>`avatarUrl` | [`String`](#string) | ユーザーのアバターのURL。 |
| <a id="accessleveluserid"></a>`id` | [`ID!`](#id) | ユーザーのID。 |
| <a id="accesslevelusername"></a>`name` | [`String!`](#string) | 人間が判読できるユーザー名。ユーザーがプロジェクトボットであり、かつリクエスタにプロジェクト表示の権限がない場合は`****`を返します。 |
| <a id="accessleveluserpublicemail"></a>`publicEmail` | [`String`](#string) | ユーザーの公開メールアドレス。 |
| <a id="accessleveluserusername"></a>`username` | [`String!`](#string) | ユーザーのユーザー名。 |
| <a id="accessleveluserwebpath"></a>`webPath` | [`String!`](#string) | ユーザーのWebパス。 |
| <a id="accessleveluserweburl"></a>`webUrl` | [`String!`](#string) | ユーザーのWeb URL。 |

### `Achievement`

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="achievementavatarurl"></a>`avatarUrl` | [`String`](#string) | アチーブメントのアバターのURL。 |
| <a id="achievementcreatedat"></a>`createdAt` | [`Time!`](#time) | アチーブメント作成時のタイムスタンプ。 |
| <a id="achievementdescription"></a>`description` | [`String`](#string) | アチーブメントの説明またはノート。 |
| <a id="achievementid"></a>`id` | [`AchievementsAchievementID!`](#achievementsachievementid) | アチーブメントのID。 |
| <a id="achievementname"></a>`name` | [`String!`](#string) | アチーブメントの名前。 |
| <a id="achievementnamespace"></a>`namespace` | [`Namespace`](#namespace) | アチーブメントのネームスペース。 |
| <a id="achievementupdatedat"></a>`updatedAt` | [`Time!`](#time) | アチーブメントの最終更新時のタイムスタンプ。 |
| <a id="achievementuserachievements"></a>`userAchievements` {{< icon name="warning-solid" >}} | [`UserAchievementConnection`](#userachievementconnection) | GitLab 15.10で**導入**。**状態**: 実験。アチーブメントの受信者。 |

### `ActivityStream`

ユーザーに関連付けられているアクティビティーストリーム。

#### 引数のあるフィールド

##### `ActivityStream.followedUsersActivity`

現在のユーザーがフォローしているユーザーからのアクティビティー。

{{< details >}}GitLab 17.10で**導入**。**状態**: 実験。{{< /details >}}

[`EventConnection`](#eventconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="activitystreamfollowedusersactivitytarget"></a>`target` | [`EventTarget!`](#eventtarget) | イベントターゲット。 |

### `AddOnPurchase`

ネームスペースのアドオン購入を表します。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="addonpurchaseassignedquantity"></a>`assignedQuantity` | [`Int!`](#int) | 割り当てられたシートの数。 |
| <a id="addonpurchaseid"></a>`id` | [`GitlabSubscriptionsAddOnPurchaseID!`](#gitlabsubscriptionsaddonpurchaseid) | AddOnPurchaseのID。 |
| <a id="addonpurchasename"></a>`name` | [`String!`](#string) | アドオンの名前。 |
| <a id="addonpurchasepurchasedquantity"></a>`purchasedQuantity` | [`Int!`](#int) | 購入したシートの数。 |

### `AddOnUser`

アドオンデータのあるユーザー。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="addonuseractive"></a>`active` | [`Boolean`](#boolean) | ユーザーがアクティブかどうかを示します。 |
| <a id="addonuseravatarurl"></a>`avatarUrl` | [`String`](#string) | ユーザーのアバターのURL。 |
| <a id="addonuserbio"></a>`bio` | [`String`](#string) | ユーザーの経歴。 |
| <a id="addonuserbot"></a>`bot` | [`Boolean!`](#boolean) | ユーザーがボットかどうかを示します。 |
| <a id="addonusercallouts"></a>`callouts` | [`UserCalloutConnection`](#usercalloutconnection) | ユーザーに属するユーザーコールアウト。（[接続](#connections)を参照） |
| <a id="addonusercommitemail"></a>`commitEmail` | [`String`](#string) | ユーザーのデフォルトのコミットメール。 |
| <a id="addonusercreatedat"></a>`createdAt` | [`Time`](#time) | ユーザー作成時のタイムスタンプ。 |
| <a id="addonuserdiscord"></a>`discord` | [`String`](#string) | ユーザーのDiscord ID。 |
| <a id="addonuseremail"></a>`email` {{< icon name="warning-solid" >}} | [`String`](#string) | GitLab 13.7で**非推奨**になりました。名前が変更されました。[`User.publicEmail`](#userpublicemail)を使用してください。 |
| <a id="addonuseremails"></a>`emails` | [`EmailConnection`](#emailconnection) | ユーザーのメールアドレス。（[接続](#connections)を参照） |
| <a id="addonusergitpodenabled"></a>`gitpodEnabled` | [`Boolean`](#boolean) | Gitpodがユーザーレベルで有効になっているかどうか。 |
| <a id="addonusergroupcount"></a>`groupCount` | [`Int`](#int) | ユーザーのグループ数。 |
| <a id="addonusergroupmemberships"></a>`groupMemberships` | [`GroupMemberConnection`](#groupmemberconnection) | ユーザーのグループメンバーシップ。（[接続](#connections)を参照） |
| <a id="addonuserhuman"></a>`human` | [`Boolean`](#boolean) | ユーザーが標準ユーザーかどうかを示します。 |
| <a id="addonuserid"></a>`id` | [`UserID!`](#userid) | ユーザーのグローバルID。 |
| <a id="addonuseride"></a>`ide` | [`Ide`](#ide) | IDEの設定。 |
| <a id="addonuserjobtitle"></a>`jobTitle` | [`String`](#string) | ユーザーの役職。 |
| <a id="addonuserlastactivityon"></a>`lastActivityOn` | [`Date`](#date) | ユーザーが最後に何らかのアクションを実行した日付。 |
| <a id="addonuserlastduoactivityon"></a>`lastDuoActivityOn` | [`Date`](#date) | ユーザーの最後のGitLab Duoアクティビティーの日付。GitLab Duoアクティビティーがあると更新されます。 |
| <a id="addonuserlastloginat"></a>`lastLoginAt` | [`Time`](#time) | 最後のサインインのタイムスタンプ。 |
| <a id="addonuserlinkedin"></a>`linkedin` | [`String`](#string) | ユーザーのLinkedInプロフィール名。 |
| <a id="addonuserlocation"></a>`location` | [`String`](#string) | ユーザーの所在地。 |
| <a id="addonusername"></a>`name` | [`String!`](#string) | 人間が判読できるユーザー名。ユーザーがプロジェクトボットであり、かつリクエスタにプロジェクト表示の権限がない場合は`****`を返します。 |
| <a id="addonusernamespace"></a>`namespace` | [`Namespace`](#namespace) | ユーザーの個人ネームスペース。 |
| <a id="addonusernamespacecommitemails"></a>`namespaceCommitEmails` | [`NamespaceCommitEmailConnection`](#namespacecommitemailconnection) | ユーザーのカスタムネームスペースコミットメール。（[接続](#connections)を参照） |
| <a id="addonuserorganization"></a>`organization` | [`String`](#string) | ユーザーが誰を代表するか、または誰のために働いているか。 |
| <a id="addonuserpreferencesgitpodpath"></a>`preferencesGitpodPath` | [`String`](#string) | ユーザープリファレンスのGitpodセクションのWebパス。 |
| <a id="addonuserprofileenablegitpodpath"></a>`profileEnableGitpodPath` | [`String`](#string) | ユーザーに対してGitpodを有効にするためのWebパス。 |
| <a id="addonuserprojectmemberships"></a>`projectMemberships` | [`ProjectMemberConnection`](#projectmemberconnection) | ユーザーのプロジェクトメンバーシップ。（[接続](#connections)を参照） |
| <a id="addonuserpronouns"></a>`pronouns` | [`String`](#string) | ユーザーの代名詞。 |
| <a id="addonuserpublicemail"></a>`publicEmail` | [`String`](#string) | ユーザーの公開メールアドレス。 |
| <a id="addonusersavedreplies"></a>`savedReplies` | [`SavedReplyConnection`](#savedreplyconnection) | ユーザーが作成した保存済み返信。（[接続](#connections)を参照） |
| <a id="addonuserstate"></a>`state` | [`UserState!`](#userstate) | ユーザーの状態。 |
| <a id="addonuserstatus"></a>`status` | [`UserStatus`](#userstatus) | ユーザー状態。 |
| <a id="addonusertwitter"></a>`twitter` | [`String`](#string) | ユーザーのX （旧Twitter）ユーザー名。 |
| <a id="addonusertype"></a>`type` | [`UserType!`](#usertype) | ユーザーのタイプ。 |
| <a id="addonuseruserpermissions"></a>`userPermissions` | [`UserPermissions!`](#userpermissions) | リソースに対する現在のユーザーの権限。 |
| <a id="addonuseruserpreferences"></a>`userPreferences` | [`UserPreferences`](#userpreferences) | ユーザーのプリファレンス。 |
| <a id="addonuserusername"></a>`username` | [`String!`](#string) | ユーザーのユーザー名。GitLabインスタンス内で固有。 |
| <a id="addonuserwebpath"></a>`webPath` | [`String!`](#string) | ユーザーのWebパス。 |
| <a id="addonuserweburl"></a>`webUrl` | [`String!`](#string) | ユーザーのWeb URL。 |

#### 引数のあるフィールド

##### `AddOnUser.addOnAssignments`

ユーザーのアドオン購入割り当て。

{{< details >}}GitLab 16.4で**導入**。**状態**: 実験。{{< /details >}}

[`UserAddOnAssignmentConnection`](#useraddonassignmentconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="addonuseraddonassignmentsaddonpurchaseids"></a>`addOnPurchaseIds` | [`[GitlabSubscriptionsAddOnPurchaseID!]!`](#gitlabsubscriptionsaddonpurchaseid) | 割り当てを検索する対象のアドオン購入のグローバルID。 |

##### `AddOnUser.assignedMergeRequests`

ユーザーに割り当てられたマージリクエスト。

[`MergeRequestConnection`](#mergerequestconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="addonuserassignedmergerequestsapproved"></a>`approved` | [`Boolean`](#boolean) | 結果を承認済みマージリクエストに制限します。機能フラグ`mr_approved_filter`が有効になっている場合にのみ使用できます。 |
| <a id="addonuserassignedmergerequestsapprovedby"></a>`approvedBy` | [`[String!]`](#string) | 承認者のユーザー名。 |
| <a id="addonuserassignedmergerequestsapprover"></a>`approver` | [`[String!]`](#string) | 承認者である可能性があるユーザー名。 |
| <a id="addonuserassignedmergerequestsauthorusername"></a>`authorUsername` | [`String`](#string) | 作成者のユーザー名。 |
| <a id="addonuserassignedmergerequestsblobpath"></a>`blobPath` {{< icon name="warning-solid" >}} | [`String`](#string) | GitLab 17.7で**導入**。**状態**: 実験。マージリクエストで変更されたblobのパス。state、targetBranches、およびcreatedAfterの引数が必須です。機能フラグ`filter_blob_path`が有効になっている場合にのみ使用できます。 |
| <a id="addonuserassignedmergerequestscreatedafter"></a>`createdAfter` | [`Time`](#time) | 指定タイムスタンプより後に作成されたマージリクエスト。 |
| <a id="addonuserassignedmergerequestscreatedbefore"></a>`createdBefore` | [`Time`](#time) | 指定タイムスタンプより前に作成されたマージリクエスト。 |
| <a id="addonuserassignedmergerequestsdeployedafter"></a>`deployedAfter` | [`Time`](#time) | 指定タイムスタンプより後にデプロイされたマージリクエスト。 |
| <a id="addonuserassignedmergerequestsdeployedbefore"></a>`deployedBefore` | [`Time`](#time) | 指定タイムスタンプより前にデプロイされたマージリクエスト。 |
| <a id="addonuserassignedmergerequestsdeploymentid"></a>`deploymentId` | [`String`](#string) | デプロイのID。 |
| <a id="addonuserassignedmergerequestsdraft"></a>`draft` | [`Boolean`](#boolean) | 結果を下書きマージリクエストに制限します。 |
| <a id="addonuserassignedmergerequestsenvironmentname"></a>`environmentName` | [`String`](#string) | マージリクエストのデプロイ先環境。 |
| <a id="addonuserassignedmergerequestsgroupid"></a>`groupId` | [`GroupID`](#groupid) | 作成されたマージリクエストが属するグループのグローバルID。サブグループ内のマージリクエストが含まれます。 |
| <a id="addonuserassignedmergerequestsiids"></a>`iids` | [`[String!]`](#string) | マージリクエストのIIDの配列（`[1, 2]`など）。 |
| <a id="addonuserassignedmergerequestsin"></a>`in` | [`[IssuableSearchableField!]`](#issuablesearchablefield) | 検索を実行するフィールドを指定します。デフォルトは`[TITLE, DESCRIPTION]`です。`search`引数が必要です。 |
| <a id="addonuserassignedmergerequestsincludearchived"></a>`includeArchived` | [`Boolean`](#boolean) | アーカイブされたプロジェクトからのマージリクエスト。 |
| <a id="addonuserassignedmergerequestslabelname"></a>`labelName` | [`[String]`](#string) | マージリクエストに適用されるラベル。 |
| <a id="addonuserassignedmergerequestslabels"></a>`labels` {{< icon name="warning-solid" >}} | [`[String!]`](#string) | GitLab 17.1で**非推奨**になりました。`labelName`を使用してください。 |
| <a id="addonuserassignedmergerequestsmergedafter"></a>`mergedAfter` | [`Time`](#time) | 指定日付より後にマージされたマージリクエスト。 |
| <a id="addonuserassignedmergerequestsmergedbefore"></a>`mergedBefore` | [`Time`](#time) | 指定日付より前にマージされたマージリクエスト。 |
| <a id="addonuserassignedmergerequestsmergedby"></a>`mergedBy` | [`String`](#string) | マージしたユーザー名。 |
| <a id="addonuserassignedmergerequestsmilestonetitle"></a>`milestoneTitle` | [`String`](#string) | マイルストーンのタイトル。milestoneWildcardIdと互換性がありません。 |
| <a id="addonuserassignedmergerequestsmilestonewildcardid"></a>`milestoneWildcardId` | [`MilestoneWildcardId`](#milestonewildcardid) | マイルストーンIDのワイルドカードでイシューをフィルタリングします。milestoneTitleと互換性がありません。 |
| <a id="addonuserassignedmergerequestsmyreactionemoji"></a>`myReactionEmoji` | [`String`](#string) | 自分のリアクション絵文字でフィルタリングします。 |
| <a id="addonuserassignedmergerequestsnot"></a>`not` | [`MergeRequestsResolverNegatedParams`](#mergerequestsresolvernegatedparams) | 否定条件となる引数リスト。警告: この引数は実験段階であり、将来変更される可能性があります。 |
| <a id="addonuserassignedmergerequestsor"></a>`or` | [`UnionedMergeRequestFilterInput`](#unionedmergerequestfilterinput) | 引数のリストのインクルーシブOR結合。 |
| <a id="addonuserassignedmergerequestsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | 作成されたマージリクエストが属するプロジェクトのグローバルID。projectPathと互換性がありません。 |
| <a id="addonuserassignedmergerequestsprojectpath"></a>`projectPath` | [`String`](#string) | 作成されたマージリクエストが属するプロジェクトのフルパス。projectIdと互換性がありません。 |
| <a id="addonuserassignedmergerequestsreleasetag"></a>`releaseTag` | [`String`](#string) | リリースタグでフィルタリングします。 |
| <a id="addonuserassignedmergerequestsreviewstate"></a>`reviewState` {{< icon name="warning-solid" >}} | [`MergeRequestReviewState`](#mergerequestreviewstate) | GitLab 17.0で**導入**。**状態**: 実験。マージリクエストのレビュアーの状態。 |
| <a id="addonuserassignedmergerequestsreviewstates"></a>`reviewStates` {{< icon name="warning-solid" >}} | [`[MergeRequestReviewState!]`](#mergerequestreviewstate) | GitLab 17.0で**導入**。**状態**: 実験。マージリクエストのレビュアーの状態（複数）。 |
| <a id="addonuserassignedmergerequestsreviewerusername"></a>`reviewerUsername` | [`String`](#string) | レビュアーのユーザー名。 |
| <a id="addonuserassignedmergerequestsreviewerwildcardid"></a>`reviewerWildcardId` | [`ReviewerWildcardId`](#reviewerwildcardid) | レビュアーの有無でフィルタリングします。reviewerUsernameと互換性がありません。 |
| <a id="addonuserassignedmergerequestssearch"></a>`search` | [`String`](#string) | タイトルまたは説明の検索クエリ。 |
| <a id="addonuserassignedmergerequestssort"></a>`sort` | [`MergeRequestSort`](#mergerequestsort) | マージリクエストを条件でソートします。 |
| <a id="addonuserassignedmergerequestssourcebranches"></a>`sourceBranches` | [`[String!]`](#string) | ソースブランチ名の配列。解決済みのマージリクエストには、すべて、これらのブランチのいずれかがソースとして含まれます。 |
| <a id="addonuserassignedmergerequestsstate"></a>`state` | [`MergeRequestState`](#mergerequeststate) | マージリクエストの状態。指定した場合、解決済みのマージリクエストすべてに状態が含まれます。 |
| <a id="addonuserassignedmergerequestssubscribed"></a>`subscribed` | [`SubscriptionStatus`](#subscriptionstatus) | 現在のユーザーがサブスクライブしているマージリクエスト。 |
| <a id="addonuserassignedmergerequeststargetbranches"></a>`targetBranches` | [`[String!]`](#string) | ターゲットブランチ名の配列。解決済みのマージリクエストには、すべて、これらのブランチのいずれかがターゲットとして含まれます。 |
| <a id="addonuserassignedmergerequestsupdatedafter"></a>`updatedAfter` | [`Time`](#time) | 指定タイムスタンプより後に更新されたマージリクエスト。 |
| <a id="addonuserassignedmergerequestsupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | 指定タイムスタンプより前に更新されたマージリクエスト。 |

##### `AddOnUser.authoredMergeRequests`

ユーザーが作成したマージリクエスト。

[`MergeRequestConnection`](#mergerequestconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="addonuserauthoredmergerequestsapproved"></a>`approved` | [`Boolean`](#boolean) | 結果を承認済みマージリクエストに制限します。機能フラグ`mr_approved_filter`が有効になっている場合にのみ使用できます。 |
| <a id="addonuserauthoredmergerequestsapprovedby"></a>`approvedBy` | [`[String!]`](#string) | 承認者のユーザー名。 |
| <a id="addonuserauthoredmergerequestsapprover"></a>`approver` | [`[String!]`](#string) | 承認者である可能性があるユーザー名。 |
| <a id="addonuserauthoredmergerequestsassigneeusername"></a>`assigneeUsername` | [`String`](#string) | 割り当て先ユーザーのユーザー名。 |
| <a id="addonuserauthoredmergerequestsassigneeusernames"></a>`assigneeUsernames` | [`[String!]`](#string) | マージリクエストに割り当てられたユーザーのユーザー名。 |
| <a id="addonuserauthoredmergerequestsassigneewildcardid"></a>`assigneeWildcardId` | [`AssigneeWildcardId`](#assigneewildcardid) | 割り当て先の有無でフィルタリングします。assigneeUsernamesともassigneeUsernameとも互換性がありません。 |
| <a id="addonuserauthoredmergerequestsblobpath"></a>`blobPath` {{< icon name="warning-solid" >}} | [`String`](#string) | GitLab 17.7で**導入**。**状態**: 実験。マージリクエストで変更されたblobのパス。state、targetBranches、およびcreatedAfterの引数が必須です。機能フラグ`filter_blob_path`が有効になっている場合にのみ使用できます。 |
| <a id="addonuserauthoredmergerequestscreatedafter"></a>`createdAfter` | [`Time`](#time) | 指定タイムスタンプより後に作成されたマージリクエスト。 |
| <a id="addonuserauthoredmergerequestscreatedbefore"></a>`createdBefore` | [`Time`](#time) | 指定タイムスタンプより前に作成されたマージリクエスト。 |
| <a id="addonuserauthoredmergerequestsdeployedafter"></a>`deployedAfter` | [`Time`](#time) | 指定タイムスタンプより後にデプロイされたマージリクエスト。 |
| <a id="addonuserauthoredmergerequestsdeployedbefore"></a>`deployedBefore` | [`Time`](#time) | 指定タイムスタンプより前にデプロイされたマージリクエスト。 |
| <a id="addonuserauthoredmergerequestsdeploymentid"></a>`deploymentId` | [`String`](#string) | デプロイのID。 |
| <a id="addonuserauthoredmergerequestsdraft"></a>`draft` | [`Boolean`](#boolean) | 結果を下書きマージリクエストに制限します。 |
| <a id="addonuserauthoredmergerequestsenvironmentname"></a>`environmentName` | [`String`](#string) | マージリクエストのデプロイ先環境。 |
| <a id="addonuserauthoredmergerequestsgroupid"></a>`groupId` | [`GroupID`](#groupid) | 作成されたマージリクエストが属するグループのグローバルID。サブグループ内のマージリクエストが含まれます。 |
| <a id="addonuserauthoredmergerequestsiids"></a>`iids` | [`[String!]`](#string) | マージリクエストのIIDの配列（`[1, 2]`など）。 |
| <a id="addonuserauthoredmergerequestsin"></a>`in` | [`[IssuableSearchableField!]`](#issuablesearchablefield) | 検索を実行するフィールドを指定します。デフォルトは`[TITLE, DESCRIPTION]`です。`search`引数が必要です。 |
| <a id="addonuserauthoredmergerequestsincludearchived"></a>`includeArchived` | [`Boolean`](#boolean) | アーカイブされたプロジェクトからのマージリクエスト。 |
| <a id="addonuserauthoredmergerequestsincludeassigned"></a>`includeAssigned` | [`Boolean`](#boolean) | ユーザーが割り当てられているマージリクエストを含めます。 |
| <a id="addonuserauthoredmergerequestslabelname"></a>`labelName` | [`[String]`](#string) | マージリクエストに適用されるラベル。 |
| <a id="addonuserauthoredmergerequestslabels"></a>`labels` {{< icon name="warning-solid" >}} | [`[String!]`](#string) | GitLab 17.1で**非推奨**になりました。`labelName`を使用してください。 |
| <a id="addonuserauthoredmergerequestsmergedafter"></a>`mergedAfter` | [`Time`](#time) | 指定日付より後にマージされたマージリクエスト。 |
| <a id="addonuserauthoredmergerequestsmergedbefore"></a>`mergedBefore` | [`Time`](#time) | 指定日付より前にマージされたマージリクエスト。 |
| <a id="addonuserauthoredmergerequestsmergedby"></a>`mergedBy` | [`String`](#string) | マージしたユーザー名。 |
| <a id="addonuserauthoredmergerequestsmilestonetitle"></a>`milestoneTitle` | [`String`](#string) | マイルストーンのタイトル。milestoneWildcardIdと互換性がありません。 |
| <a id="addonuserauthoredmergerequestsmilestonewildcardid"></a>`milestoneWildcardId` | [`MilestoneWildcardId`](#milestonewildcardid) | マイルストーンIDのワイルドカードでイシューをフィルタリングします。milestoneTitleと互換性がありません。 |
| <a id="addonuserauthoredmergerequestsmyreactionemoji"></a>`myReactionEmoji` | [`String`](#string) | 自分のリアクション絵文字でフィルタリングします。 |
| <a id="addonuserauthoredmergerequestsnot"></a>`not` | [`MergeRequestsResolverNegatedParams`](#mergerequestsresolvernegatedparams) | 否定条件となる引数リスト。警告: この引数は実験段階であり、将来変更される可能性があります。 |
| <a id="addonuserauthoredmergerequestsor"></a>`or` | [`UnionedMergeRequestFilterInput`](#unionedmergerequestfilterinput) | 引数のリストのインクルーシブOR結合。 |
| <a id="addonuserauthoredmergerequestsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | 作成されたマージリクエストが属するプロジェクトのグローバルID。projectPathと互換性がありません。 |
| <a id="addonuserauthoredmergerequestsprojectpath"></a>`projectPath` | [`String`](#string) | 作成されたマージリクエストが属するプロジェクトのフルパス。projectIdと互換性がありません。 |
| <a id="addonuserauthoredmergerequestsreleasetag"></a>`releaseTag` | [`String`](#string) | リリースタグでフィルタリングします。 |
| <a id="addonuserauthoredmergerequestsreviewstate"></a>`reviewState` {{< icon name="warning-solid" >}} | [`MergeRequestReviewState`](#mergerequestreviewstate) | GitLab 17.0で**導入**。**状態**: 実験。マージリクエストのレビュアーの状態。 |
| <a id="addonuserauthoredmergerequestsreviewstates"></a>`reviewStates` {{< icon name="warning-solid" >}} | [`[MergeRequestReviewState!]`](#mergerequestreviewstate) | GitLab 17.0で**導入**。**状態**: 実験。マージリクエストのレビュアーの状態（複数）。 |
| <a id="addonuserauthoredmergerequestsreviewerusername"></a>`reviewerUsername` | [`String`](#string) | レビュアーのユーザー名。 |
| <a id="addonuserauthoredmergerequestsreviewerwildcardid"></a>`reviewerWildcardId` | [`ReviewerWildcardId`](#reviewerwildcardid) | レビュアーの有無でフィルタリングします。reviewerUsernameと互換性がありません。 |
| <a id="addonuserauthoredmergerequestssearch"></a>`search` | [`String`](#string) | タイトルまたは説明の検索クエリ。 |
| <a id="addonuserauthoredmergerequestssort"></a>`sort` | [`MergeRequestSort`](#mergerequestsort) | マージリクエストを条件でソートします。 |
| <a id="addonuserauthoredmergerequestssourcebranches"></a>`sourceBranches` | [`[String!]`](#string) | ソースブランチ名の配列。解決済みのマージリクエストには、すべて、これらのブランチのいずれかがソースとして含まれます。 |
| <a id="addonuserauthoredmergerequestsstate"></a>`state` | [`MergeRequestState`](#mergerequeststate) | マージリクエストの状態。指定した場合、解決済みのマージリクエストすべてに状態が含まれます。 |
| <a id="addonuserauthoredmergerequestssubscribed"></a>`subscribed` | [`SubscriptionStatus`](#subscriptionstatus) | 現在のユーザーがサブスクライブしているマージリクエスト。 |
| <a id="addonuserauthoredmergerequeststargetbranches"></a>`targetBranches` | [`[String!]`](#string) | ターゲットブランチ名の配列。解決済みのマージリクエストには、すべて、これらのブランチのいずれかがターゲットとして含まれます。 |
| <a id="addonuserauthoredmergerequestsupdatedafter"></a>`updatedAfter` | [`Time`](#time) | 指定タイムスタンプより後に更新されたマージリクエスト。 |
| <a id="addonuserauthoredmergerequestsupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | 指定タイムスタンプより前に更新されたマージリクエスト。 |

##### `AddOnUser.contributedProjects`

ユーザーがコントリビュートしたプロジェクト。

[`ProjectConnection`](#projectconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="addonusercontributedprojectsincludepersonal"></a>`includePersonal` | [`Boolean`](#boolean) | 個人用プロジェクトを含めます。 |
| <a id="addonusercontributedprojectsminaccesslevel"></a>`minAccessLevel` | [`AccessLevelEnum`](#accesslevelenum) | 現在のユーザーに付与されているアクセスレベルが指定されたアクセスレベル以上であるプロジェクトのみを返します。 |
| <a id="addonusercontributedprojectsprogramminglanguagename"></a>`programmingLanguageName` | [`String`](#string) | プロジェクトをプログラミング言語名でフィルタリングします（大文字と小文字は区別されません）。cssやrubyなど。 |
| <a id="addonusercontributedprojectssearch"></a>`search` | [`String`](#string) | 検索クエリ。 |
| <a id="addonusercontributedprojectssort"></a>`sort` | [`ProjectSort`](#projectsort) | コントリビュートされたプロジェクトをソートします。 |

##### `AddOnUser.groups`

ユーザーがアクセスできるグループ。

[`GroupConnection`](#groupconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="addonusergroupspermissionscope"></a>`permissionScope` | [`GroupPermission`](#grouppermission) | ユーザーに付与されているグループに対する権限でフィルタリングします。 |
| <a id="addonusergroupssearch"></a>`search` | [`String`](#string) | グループ名またはパスで検索します。 |
| <a id="addonusergroupssort"></a>`sort` | [`GroupSort`](#groupsort) | 指定された条件でグループをソートします。 |

##### `AddOnUser.organizations`

ユーザーがアクセスできる組織。

{{< details >}}GitLab 16.6で**導入**。**状態**: 実験。{{< /details >}}

[`OrganizationConnection`](#organizationconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="addonuserorganizationssearch"></a>`search` | [`String`](#string) | 組織名またはパスに対して実行できる検索クエリ。 |
| <a id="addonuserorganizationssoloowned"></a>`soloOwned` | [`Boolean`](#boolean) | trueの場合、ユーザーが単独で所有する組織だけが返されます。 |

##### `AddOnUser.reviewRequestedMergeRequests`

レビューのためにユーザーに割り当てられたマージリクエスト。

[`MergeRequestConnection`](#mergerequestconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="addonuserreviewrequestedmergerequestsapproved"></a>`approved` | [`Boolean`](#boolean) | 結果を承認済みマージリクエストに制限します。機能フラグ`mr_approved_filter`が有効になっている場合にのみ使用できます。 |
| <a id="addonuserreviewrequestedmergerequestsapprovedby"></a>`approvedBy` | [`[String!]`](#string) | 承認者のユーザー名。 |
| <a id="addonuserreviewrequestedmergerequestsapprover"></a>`approver` | [`[String!]`](#string) | 承認者である可能性があるユーザー名。 |
| <a id="addonuserreviewrequestedmergerequestsassigneeusername"></a>`assigneeUsername` | [`String`](#string) | 割り当て先ユーザーのユーザー名。 |
| <a id="addonuserreviewrequestedmergerequestsassigneeusernames"></a>`assigneeUsernames` | [`[String!]`](#string) | マージリクエストに割り当てられたユーザーのユーザー名。 |
| <a id="addonuserreviewrequestedmergerequestsassigneewildcardid"></a>`assigneeWildcardId` | [`AssigneeWildcardId`](#assigneewildcardid) | 割り当て先の有無でフィルタリングします。assigneeUsernamesともassigneeUsernameとも互換性がありません。 |
| <a id="addonuserreviewrequestedmergerequestsauthorusername"></a>`authorUsername` | [`String`](#string) | 作成者のユーザー名。 |
| <a id="addonuserreviewrequestedmergerequestsblobpath"></a>`blobPath` {{< icon name="warning-solid" >}} | [`String`](#string) | GitLab 17.7で**導入**。**状態**: 実験。マージリクエストで変更されたblobのパス。state、targetBranches、およびcreatedAfterの引数が必須です。機能フラグ`filter_blob_path`が有効になっている場合にのみ使用できます。 |
| <a id="addonuserreviewrequestedmergerequestscreatedafter"></a>`createdAfter` | [`Time`](#time) | 指定タイムスタンプより後に作成されたマージリクエスト。 |
| <a id="addonuserreviewrequestedmergerequestscreatedbefore"></a>`createdBefore` | [`Time`](#time) | 指定タイムスタンプより前に作成されたマージリクエスト。 |
| <a id="addonuserreviewrequestedmergerequestsdeployedafter"></a>`deployedAfter` | [`Time`](#time) | 指定タイムスタンプより後にデプロイされたマージリクエスト。 |
| <a id="addonuserreviewrequestedmergerequestsdeployedbefore"></a>`deployedBefore` | [`Time`](#time) | 指定タイムスタンプより前にデプロイされたマージリクエスト。 |
| <a id="addonuserreviewrequestedmergerequestsdeploymentid"></a>`deploymentId` | [`String`](#string) | デプロイのID。 |
| <a id="addonuserreviewrequestedmergerequestsdraft"></a>`draft` | [`Boolean`](#boolean) | 結果を下書きマージリクエストに制限します。 |
| <a id="addonuserreviewrequestedmergerequestsenvironmentname"></a>`environmentName` | [`String`](#string) | マージリクエストのデプロイ先環境。 |
| <a id="addonuserreviewrequestedmergerequestsgroupid"></a>`groupId` | [`GroupID`](#groupid) | 作成されたマージリクエストが属するグループのグローバルID。サブグループ内のマージリクエストが含まれます。 |
| <a id="addonuserreviewrequestedmergerequestsiids"></a>`iids` | [`[String!]`](#string) | マージリクエストのIIDの配列（`[1, 2]`など）。 |
| <a id="addonuserreviewrequestedmergerequestsin"></a>`in` | [`[IssuableSearchableField!]`](#issuablesearchablefield) | 検索を実行するフィールドを指定します。デフォルトは`[TITLE, DESCRIPTION]`です。`search`引数が必要です。 |
| <a id="addonuserreviewrequestedmergerequestsincludearchived"></a>`includeArchived` | [`Boolean`](#boolean) | アーカイブされたプロジェクトからのマージリクエスト。 |
| <a id="addonuserreviewrequestedmergerequestslabelname"></a>`labelName` | [`[String]`](#string) | マージリクエストに適用されるラベル。 |
| <a id="addonuserreviewrequestedmergerequestslabels"></a>`labels` {{< icon name="warning-solid" >}} | [`[String!]`](#string) | GitLab 17.1で**非推奨**になりました。`labelName`を使用してください。 |
| <a id="addonuserreviewrequestedmergerequestsmergedafter"></a>`mergedAfter` | [`Time`](#time) | 指定日付より後にマージされたマージリクエスト。 |
| <a id="addonuserreviewrequestedmergerequestsmergedbefore"></a>`mergedBefore` | [`Time`](#time) | 指定日付より前にマージされたマージリクエスト。 |
| <a id="addonuserreviewrequestedmergerequestsmergedby"></a>`mergedBy` | [`String`](#string) | マージしたユーザー名。 |
| <a id="addonuserreviewrequestedmergerequestsmilestonetitle"></a>`milestoneTitle` | [`String`](#string) | マイルストーンのタイトル。milestoneWildcardIdと互換性がありません。 |
| <a id="addonuserreviewrequestedmergerequestsmilestonewildcardid"></a>`milestoneWildcardId` | [`MilestoneWildcardId`](#milestonewildcardid) | マイルストーンIDのワイルドカードでイシューをフィルタリングします。milestoneTitleと互換性がありません。 |
| <a id="addonuserreviewrequestedmergerequestsmyreactionemoji"></a>`myReactionEmoji` | [`String`](#string) | 自分のリアクション絵文字でフィルタリングします。 |
| <a id="addonuserreviewrequestedmergerequestsnot"></a>`not` | [`MergeRequestsResolverNegatedParams`](#mergerequestsresolvernegatedparams) | 否定条件となる引数リスト。警告: この引数は実験段階であり、将来変更される可能性があります。 |
| <a id="addonuserreviewrequestedmergerequestsor"></a>`or` | [`UnionedMergeRequestFilterInput`](#unionedmergerequestfilterinput) | 引数のリストのインクルーシブOR結合。 |
| <a id="addonuserreviewrequestedmergerequestsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | 作成されたマージリクエストが属するプロジェクトのグローバルID。projectPathと互換性がありません。 |
| <a id="addonuserreviewrequestedmergerequestsprojectpath"></a>`projectPath` | [`String`](#string) | 作成されたマージリクエストが属するプロジェクトのフルパス。projectIdと互換性がありません。 |
| <a id="addonuserreviewrequestedmergerequestsreleasetag"></a>`releaseTag` | [`String`](#string) | リリースタグでフィルタリングします。 |
| <a id="addonuserreviewrequestedmergerequestsreviewstate"></a>`reviewState` {{< icon name="warning-solid" >}} | [`MergeRequestReviewState`](#mergerequestreviewstate) | GitLab 17.0で**導入**。**状態**: 実験。マージリクエストのレビュアーの状態。 |
| <a id="addonuserreviewrequestedmergerequestsreviewstates"></a>`reviewStates` {{< icon name="warning-solid" >}} | [`[MergeRequestReviewState!]`](#mergerequestreviewstate) | GitLab 17.0で**導入**。**状態**: 実験。マージリクエストのレビュアーの状態（複数）。 |
| <a id="addonuserreviewrequestedmergerequestssearch"></a>`search` | [`String`](#string) | タイトルまたは説明の検索クエリ。 |
| <a id="addonuserreviewrequestedmergerequestssort"></a>`sort` | [`MergeRequestSort`](#mergerequestsort) | マージリクエストを条件でソートします。 |
| <a id="addonuserreviewrequestedmergerequestssourcebranches"></a>`sourceBranches` | [`[String!]`](#string) | ソースブランチ名の配列。解決済みのマージリクエストには、すべて、これらのブランチのいずれかがソースとして含まれます。 |
| <a id="addonuserreviewrequestedmergerequestsstate"></a>`state` | [`MergeRequestState`](#mergerequeststate) | マージリクエストの状態。指定した場合、解決済みのマージリクエストすべてに状態が含まれます。 |
| <a id="addonuserreviewrequestedmergerequestssubscribed"></a>`subscribed` | [`SubscriptionStatus`](#subscriptionstatus) | 現在のユーザーがサブスクライブしているマージリクエスト。 |
| <a id="addonuserreviewrequestedmergerequeststargetbranches"></a>`targetBranches` | [`[String!]`](#string) | ターゲットブランチ名の配列。解決済みのマージリクエストには、すべて、これらのブランチのいずれかがターゲットとして含まれます。 |
| <a id="addonuserreviewrequestedmergerequestsupdatedafter"></a>`updatedAfter` | [`Time`](#time) | 指定タイムスタンプより後に更新されたマージリクエスト。 |
| <a id="addonuserreviewrequestedmergerequestsupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | 指定タイムスタンプより前に更新されたマージリクエスト。 |

##### `AddOnUser.savedReply`

ユーザーが作成した保存済み返信。

[`SavedReply`](#savedreply)を返します。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="addonusersavedreplyid"></a>`id` | [`UsersSavedReplyID!`](#userssavedreplyid) | 保存済み返信のID。 |

##### `AddOnUser.snippets`

ユーザーが作成したスニペット。

[`SnippetConnection`](#snippetconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="addonusersnippetsids"></a>`ids` | [`[SnippetID!]`](#snippetid) | グローバルスニペットIDの配列。例: `gid://gitlab/ProjectSnippet/1`。 |
| <a id="addonusersnippetstype"></a>`type` | [`TypeEnum`](#typeenum) | スニペットのタイプ。 |
| <a id="addonusersnippetsvisibility"></a>`visibility` | [`VisibilityScopesEnum`](#visibilityscopesenum) | スニペットの表示レベル。 |

##### `AddOnUser.starredProjects`

ユーザーがお気に入り登録したプロジェクト。

[`ProjectConnection`](#projectconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="addonuserstarredprojectsminaccesslevel"></a>`minAccessLevel` | [`AccessLevelEnum`](#accesslevelenum) | 現在のユーザーに付与されているアクセスレベルが指定されたアクセスレベル以上であるプロジェクトのみを返します。 |
| <a id="addonuserstarredprojectsprogramminglanguagename"></a>`programmingLanguageName` | [`String`](#string) | プロジェクトをプログラミング言語名でフィルタリングします（大文字と小文字は区別されません）。cssやrubyなど。 |
| <a id="addonuserstarredprojectssearch"></a>`search` | [`String`](#string) | 検索クエリ。 |
| <a id="addonuserstarredprojectssort"></a>`sort` | [`ProjectSort`](#projectsort) | 指定ソート順でお気に入りプロジェクトを一覧表示します。 |

##### `AddOnUser.timelogs`

ユーザーがログに記録した時刻。

[`TimelogConnection`](#timelogconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="addonusertimelogsenddate"></a>`endDate` | [`Time`](#time) | 日付範囲内のタイムログのうち、ログに記録された日付がendDate以前であるものを一覧表示します。 |
| <a id="addonusertimelogsendtime"></a>`endTime` | [`Time`](#time) | 時刻範囲内のタイムログのうち、ログに記録された時刻がendTime以前であるものを一覧表示します。 |
| <a id="addonusertimelogsgroupid"></a>`groupId` | [`GroupID`](#groupid) | グループのタイムログを一覧表示します。 |
| <a id="addonusertimelogsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | プロジェクトのタイムログを一覧表示します。 |
| <a id="addonusertimelogssort"></a>`sort` | [`TimelogSort`](#timelogsort) | タイムログを特定の順序で一覧表示します。 |
| <a id="addonusertimelogsstartdate"></a>`startDate` | [`Time`](#time) | 日付範囲内のタイムログのうち、ログに記録された日付がstartDate以後であるものを一覧表示します。 |
| <a id="addonusertimelogsstarttime"></a>`startTime` | [`Time`](#time) | 時刻範囲内のタイムログのうち、ログに記録された時刻がstartTime以後であるものを一覧表示します。 |
| <a id="addonusertimelogsusername"></a>`username` | [`String`](#string) | ユーザーのタイムログを一覧表示します。 |

##### `AddOnUser.todos`

ユーザーのto-doアイテム。

[`TodoConnection`](#todoconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="addonusertodosaction"></a>`action` | [`[TodoActionEnum!]`](#todoactionenum) | フィルタリングするアクション。 |
| <a id="addonusertodosauthorid"></a>`authorId` | [`[ID!]`](#id) | 作成者のID。 |
| <a id="addonusertodosgroupid"></a>`groupId` | [`[ID!]`](#id) | グループのID。 |
| <a id="addonusertodosissnoozed"></a>`isSnoozed` | [`Boolean`](#boolean) | To Doアイテムがスヌーズされているかどうか。 |
| <a id="addonusertodosprojectid"></a>`projectId` | [`[ID!]`](#id) | プロジェクトのID。 |
| <a id="addonusertodossort"></a>`sort` | [`TodoSort`](#todosort) | 指定された条件でtodoをソートします。 |
| <a id="addonusertodosstate"></a>`state` | [`[TodoStateEnum!]`](#todostateenum) | todoの状態。 |
| <a id="addonusertodostype"></a>`type` | [`[TodoTargetEnum!]`](#todotargetenum) | todoのタイプ。 |

##### `AddOnUser.userAchievements`

ユーザーのアチーブメント。`achievements`機能フラグが有効になっているネームスペースについてのみ返されます。

{{< details >}}GitLab 15.10で**導入**。**状態**: 実験。{{< /details >}}

[`UserAchievementConnection`](#userachievementconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="addonuseruserachievementsincludehidden"></a>`includeHidden` | [`Boolean`](#boolean) | プロファイルから隠されたアチーブメントを結果に含めるかどうかを示します。 |

##### `AddOnUser.workspaces`

現在のユーザーが所有するワークスペース。

[`WorkspaceConnection`](#workspaceconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="addonuserworkspacesactualstates"></a>`actualStates` | [`[String!]`](#string) | ワークスペースを実際の状態でフィルタリングします。 |
| <a id="addonuserworkspacesagentids"></a>`agentIds` | [`[ClustersAgentID!]`](#clustersagentid) | ワークスペースをエージェントのグローバルIDでフィルタリングします。 |
| <a id="addonuserworkspacesids"></a>`ids` | [`[RemoteDevelopmentWorkspaceID!]`](#remotedevelopmentworkspaceid) | ワークスペースをワークスペースのグローバルIDでフィルタリングします。例: `["gid://gitlab/RemoteDevelopment::Workspace/1"]`。 |
| <a id="addonuserworkspacesincludeactualstates"></a>`includeActualStates` {{< icon name="warning-solid" >}} | [`[String!]`](#string) | GitLab 16.7で**非推奨**になりました。代わりにactual_statesを使用してください。 |
| <a id="addonuserworkspacesprojectids"></a>`projectIds` | [`[ProjectID!]`](#projectid) | ワークスペースをプロジェクトのグローバルIDでフィルタリングします。 |

### `AdminMemberRole`

管理者メンバーロールを表します。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="adminmemberrolecreatedat"></a>`createdAt` | [`Time!`](#time) | メンバーロール作成時のタイムスタンプ。 |
| <a id="adminmemberroledescription"></a>`description` | [`String`](#string) | ロールの説明。 |
| <a id="adminmemberroledetailspath"></a>`detailsPath` {{< icon name="warning-solid" >}} | [`String`](#string) | GitLab 17.4で**導入**。**状態**: 実験。ロールの詳細WebページのURLパス。 |
| <a id="adminmemberroleeditpath"></a>`editPath` {{< icon name="warning-solid" >}} | [`String!`](#string) | GitLab 16.11で**導入**。**状態**: 実験。カスタムロールを編集するためのWeb UIパス。 |
| <a id="adminmemberroleenabledpermissions"></a>`enabledPermissions` {{< icon name="warning-solid" >}} | [`CustomizableAdminPermissionConnection!`](#customizableadminpermissionconnection) | GitLab 17.7で**導入**。**状態**: 実験。カスタムロールに対して有効になっているすべての権限の配列。 |
| <a id="adminmemberroleid"></a>`id` | [`ID!`](#id) | ロールID。 |
| <a id="adminmemberrolememberscount"></a>`membersCount` {{< icon name="warning-solid" >}} | [`Int`](#int) | GitLab 17.3で**導入**。**状態**: 実験。ロールがグループまたはプロジェクトメンバーに直接割り当てられた回数。 |
| <a id="adminmemberrolename"></a>`name` | [`String`](#string) | ロール名。 |
| <a id="adminmemberroleuserscount"></a>`usersCount` {{< icon name="warning-solid" >}} | [`Int`](#int) | GitLab 17.5で**導入**。**状態**: 実験。少なくとも1つのグループまたはプロジェクトでロールが直接割り当てられているユーザーの数。 |

### `AgentConfiguration`

エージェントの設定の詳細。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="agentconfigurationagentname"></a>`agentName` | [`String`](#string) | エージェントの名前。 |

### `AgentMetadata`

接続されているエージェントに関する情報。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="agentmetadatacommit"></a>`commit` | [`String`](#string) | エージェントのバージョンコミット。 |
| <a id="agentmetadatapodname"></a>`podName` | [`String`](#string) | エージェントを実行しているポッドの名前。 |
| <a id="agentmetadatapodnamespace"></a>`podNamespace` | [`String`](#string) | エージェントを実行しているポッドのネームスペース。 |
| <a id="agentmetadataversion"></a>`version` | [`String`](#string) | エージェントのバージョンタグ。 |

### `AgentVersionWarning`

接続されているエージェントのバージョンに関連する警告。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="agentversionwarningmessage"></a>`message` | [`String`](#string) | バージョンに関連する警告メッセージ。 |
| <a id="agentversionwarningtype"></a>`type` | [`String`](#string) | バージョンに関連する警告タイプ。 |

### `AgentWarning`

接続されているエージェントの警告オブジェクト。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="agentwarningversion"></a>`version` | [`AgentVersionWarning`](#agentversionwarning) | バージョンに関連するエージェントの警告。 |

### `AggregationStatus`

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aggregationstatusenabled"></a>`enabled` | [`Boolean!`](#boolean) | バックグラウンド集計が有効か無効か。ライセンスのないダウングレードされたグループおよびプロジェクトの場合、このフィールドは`false`です。 |
| <a id="aggregationstatusestimatednextupdateat"></a>`estimatedNextUpdateAt` | [`Time`](#time) | 次の増分アップデートがいつ発生するかの推定時刻。 |
| <a id="aggregationstatuslastupdateat"></a>`lastUpdateAt` | [`Time`](#time) | 最後の増分アップデート時刻。 |

### `AiAdditionalContext`

AIメッセージの追加コンテキスト。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aiadditionalcontextcategory"></a>`category` | [`AiAdditionalContextCategory!`](#aiadditionalcontextcategory) | 追加コンテキストのカテゴリ。 |
| <a id="aiadditionalcontextcontent"></a>`content` | [`String!`](#string) | 追加コンテキストのコンテンツ。 |
| <a id="aiadditionalcontextid"></a>`id` | [`ID!`](#id) | 追加コンテキストのID。 |
| <a id="aiadditionalcontextmetadata"></a>`metadata` | [`JSON`](#json) | 追加コンテキストのメタデータ。 |

### `AiAgent`

AIエージェント。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aiagentcreatedat"></a>`createdAt` | [`Time!`](#time) | 作成日。 |
| <a id="aiagentid"></a>`id` | [`ID!`](#id) | エージェントのID。 |
| <a id="aiagentlatestversion"></a>`latestVersion` | [`AiAgentVersion`](#aiagentversion) | エージェントの最新バージョン。 |
| <a id="aiagentname"></a>`name` | [`String!`](#string) | エージェントの名前。 |
| <a id="aiagentrouteid"></a>`routeId` | [`Int!`](#int) | エージェントのルーティングID。 |
| <a id="aiagentversions"></a>`versions` | [`[AiAgentVersion!]`](#aiagentversion) | エージェントのバージョン。 |

### `AiAgentVersion`

AIエージェントのバージョン。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aiagentversioncreatedat"></a>`createdAt` | [`Time!`](#time) | エージェントバージョン作成時のタイムスタンプ。 |
| <a id="aiagentversionid"></a>`id` | [`ID!`](#id) | エージェントバージョンのID。 |
| <a id="aiagentversionmodel"></a>`model` | [`String!`](#string) | エージェントのモデル。 |
| <a id="aiagentversionprompt"></a>`prompt` | [`String!`](#string) | エージェントのプロンプト。 |

### `AiConversationsThread`

AI機能の会話スレッド。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aiconversationsthreadconversationtype"></a>`conversationType` | [`AiConversationsThreadsConversationType!`](#aiconversationsthreadsconversationtype) | スレッドの会話タイプ。 |
| <a id="aiconversationsthreadcreatedat"></a>`createdAt` | [`Time!`](#time) | スレッドの作成日。 |
| <a id="aiconversationsthreadid"></a>`id` | [`ID!`](#id) | スレッドのID。 |
| <a id="aiconversationsthreadlastupdatedat"></a>`lastUpdatedAt` | [`Time!`](#time) | スレッドの最終更新日。 |
| <a id="aiconversationsthreadtitle"></a>`title` | [`String`](#string) | スレッドのタイトル。 |

### `AiFeatureSetting`

GitLab Duo Chat機能の設定。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aifeaturesettingcompatiblellms"></a>`compatibleLlms` | [`[String!]`](#string) | この機能と互換性のあるLLM。 |
| <a id="aifeaturesettingfeature"></a>`feature` | [`String!`](#string) | AI機能の識別子。 |
| <a id="aifeaturesettingmainfeature"></a>`mainFeature` | [`String`](#string) | メイン機能の表示名。 |
| <a id="aifeaturesettingprovider"></a>`provider` | [`String!`](#string) | AI機能のわかりやすい名前（「コード補完」など）。 |
| <a id="aifeaturesettingreleasestate"></a>`releaseState` | [`String`](#string) | 機能の現在のリリース状態。 |
| <a id="aifeaturesettingselfhostedmodel"></a>`selfHostedModel` | [`AiSelfHostedModel`](#aiselfhostedmodel) | AI機能で使用するために選択されているセルフホストモデル。 |
| <a id="aifeaturesettingtitle"></a>`title` | [`String`](#string) | AI機能の表示名。 |
| <a id="aifeaturesettingvalidmodels"></a>`validModels` | [`AiSelfHostedModelConnection!`](#aiselfhostedmodelconnection) | 機能と互換性のあるセルフホストモデル。（[接続](#connections)を参照） |

### `AiMessage`

AI機能の通信メッセージ。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aimessageagentversionid"></a>`agentVersionId` | [`AiAgentVersionID`](#aiagentversionid) | メッセージに応答するエージェントバージョンのグローバルID。 |
| <a id="aimessagechunkid"></a>`chunkId` | [`Int`](#int) | ストリーミングメッセージからのチャンクの増分ID。ストリーミングメッセージでない場合はnull。 |
| <a id="aimessagecontent"></a>`content` | [`String`](#string) | raw応答コンテンツ。 |
| <a id="aimessagecontenthtml"></a>`contentHtml` | [`String`](#string) | HTMLとしてのレスポンスコンテンツ。 |
| <a id="aimessageerrors"></a>`errors` | [`[String!]`](#string) | メッセージのエラー。 |
| <a id="aimessageextras"></a>`extras` | [`AiMessageExtras`](#aimessageextras) | 追加のメッセージメタデータ。 |
| <a id="aimessageid"></a>`id` | [`ID`](#id) | メッセージのUUID。 |
| <a id="aimessagerequestid"></a>`requestId` | [`String`](#string) | 元のリクエストのUUID。チャットプロンプトと応答の間で共有されます。 |
| <a id="aimessagerole"></a>`role` | [`AiMessageRole!`](#aimessagerole) | メッセージオーナーロール。 |
| <a id="aimessagethreadid"></a>`threadId` | [`AiConversationThreadID`](#aiconversationthreadid) | チャット会話の既存スレッドのグローバルID。 |
| <a id="aimessagetimestamp"></a>`timestamp` | [`Time!`](#time) | メッセージ作成のタイムスタンプ。 |
| <a id="aimessagetype"></a>`type` | [`AiMessageType`](#aimessagetype) | メッセージタイプ。 |

### `AiMessageExtras`

AIメッセージの追加メタデータ。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aimessageextrasadditionalcontext"></a>`additionalContext` | [`[AiAdditionalContext!]`](#aiadditionalcontext) | メッセージの追加コンテキスト。 |
| <a id="aimessageextrashasfeedback"></a>`hasFeedback` | [`Boolean`](#boolean) | ユーザーがメッセージにフィードバックを提供したかどうか。 |
| <a id="aimessageextrassources"></a>`sources` | [`[JSON!]`](#json) | メッセージの作成に使用されたソース。 |

### `AiMetrics`

ClickHouseが必要です。GitLab Duo Pro付きのPremiumとUltimate、およびEnterpriseのみ。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aimetricscodecontributorscount"></a>`codeContributorsCount` | [`Int`](#int) | コードコントリビューターの数。 |
| <a id="aimetricscodesuggestionsacceptedcount"></a>`codeSuggestionsAcceptedCount` | [`Int`](#int) | コードコントリビューターによって受け入れられたコード提案の総数。 |
| <a id="aimetricscodesuggestionscontributorscount"></a>`codeSuggestionsContributorsCount` | [`Int`](#int) | GitLab Duoコード提案機能を使用したコードコントリビューターの数。 |
| <a id="aimetricscodesuggestionsshowncount"></a>`codeSuggestionsShownCount` | [`Int`](#int) | コードコントリビューターに表示されるコード提案の総数。 |
| <a id="aimetricsduoassigneduserscount"></a>`duoAssignedUsersCount` | [`Int`](#int) | 割り当てられたGitLab Duo ProおよびEnterpriseシートの合計数。期間フィルターを無視します。現在のデータを返します。 |
| <a id="aimetricsduochatcontributorscount"></a>`duoChatContributorsCount` | [`Int`](#int) | GitLab Duo Chat機能を使用したコントリビューターの数。 |
| <a id="aimetricsduoproassigneduserscount"></a>`duoProAssignedUsersCount` {{< icon name="warning-solid" >}} | [`Int`](#int) | GitLab 17.6で**非推奨**になりました。同じ動作が必要な場合は、duoAssignedUsersCountを使用してください。 |
| <a id="aimetricsduousedcount"></a>`duoUsedCount` | [`Int`](#int) | GitLab Duo機能を使用したコントリビューターの数。 |

### `AiSelfHostedModel`

セルフホストLLMサーバー。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aiselfhostedmodelapitoken"></a>`apiToken` | [`String`](#string) | セルフホストモデルサーバーのAPIキー（オプション）。 |
| <a id="aiselfhostedmodelcreatedat"></a>`createdAt` | [`Time!`](#time) | 作成のタイムスタンプ。 |
| <a id="aiselfhostedmodelendpoint"></a>`endpoint` | [`String!`](#string) | セルフホストモデルサーバーのエンドポイント。 |
| <a id="aiselfhostedmodelfeaturesettings"></a>`featureSettings` | [`AiFeatureSettingConnection`](#aifeaturesettingconnection) | セルフホストモデルを使用するAI機能設定。（[接続](#connections)を参照） |
| <a id="aiselfhostedmodelhasapitoken"></a>`hasApiToken` | [`Boolean!`](#boolean) | セルフホストモデルサーバーにAPIキーが設定されているかどうかを示します。 |
| <a id="aiselfhostedmodelid"></a>`id` | [`AiSelfHostedModelID!`](#aiselfhostedmodelid) | セルフホストモデルサーバーのID。 |
| <a id="aiselfhostedmodelidentifier"></a>`identifier` | [`String`](#string) | サードパーティモデルプロバイダーの識別子。 |
| <a id="aiselfhostedmodelmodel"></a>`model` | [`String!`](#string) | デプロイ対象のAIモデル。 |
| <a id="aiselfhostedmodelmodeldisplayname"></a>`modelDisplayName` | [`String!`](#string) | デプロイ対象のAIモデルの表示名。 |
| <a id="aiselfhostedmodelname"></a>`name` | [`String!`](#string) | セルフホストモデルのデプロイ名。 |
| <a id="aiselfhostedmodelreleasestate"></a>`releaseState` | [`AiSelfHostedModelReleaseState!`](#aiselfhostedmodelreleasestate) | モデルのGitLabリリース状態。 |
| <a id="aiselfhostedmodelupdatedat"></a>`updatedAt` | [`Time`](#time) | 最終更新のタイムスタンプ。 |

### `AiUsageData`

デフォルトのPostgreSQLデータベースに保存されているイベントの使用状況データ。3か月間保持されるデータ。パーソナルアクセストークンが必要です。エンドポイントは、トップレベルグループでのみ機能します。GitLab Duo Enterpriseを含むUltimateのみ。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aiusagedatacodesuggestionevents"></a>`codeSuggestionEvents` | [`CodeSuggestionEventConnection`](#codesuggestioneventconnection) | コード提案に関連するイベント。（[接続](#connections)を参照） |

### `AiUserMetrics`

GitLabコード提案とGitLab Duo Chatのユーザーごとの集約メトリクス。ClickHouseが有効になっていること、そしてGitLab Duo Enterpriseアドオンを含むGitLab Ultimateが必要です。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aiusermetricscodesuggestionsacceptedcount"></a>`codeSuggestionsAcceptedCount` | [`Int`](#int) | ユーザーによって受け入れられたコード提案の総数。 |
| <a id="aiusermetricsduochatinteractionscount"></a>`duoChatInteractionsCount` | [`Int`](#int) | GitLab Duo Chatとのユーザーインタラクションの数。 |
| <a id="aiusermetricsuser"></a>`user` | [`AddOnUser!`](#addonuser) | メトリクスに関連付けられているユーザー。 |

### `AiXrayReport`

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aixrayreportlanguage"></a>`language` | [`String!`](#string) | X-Rayレポートの言語。 |

### `AlertManagementAlert`

プロジェクトのアラート管理からのアラートについて説明します。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="alertmanagementalertassignees"></a>`assignees` | [`UserCoreConnection`](#usercoreconnection) | アラートの担当者。（[接続](#connections)を参照） |
| <a id="alertmanagementalertcommenters"></a>`commenters` | [`UserCoreConnection!`](#usercoreconnection) | noteableについてのすべてのコメンター。（[接続](#connections)を参照） |
| <a id="alertmanagementalertcreatedat"></a>`createdAt` | [`Time`](#time) | アラート作成のタイムスタンプ。 |
| <a id="alertmanagementalertdescription"></a>`description` | [`String`](#string) | アラートの説明。 |
| <a id="alertmanagementalertdetails"></a>`details` | [`JSON`](#json) | アラートの詳細。 |
| <a id="alertmanagementalertdetailsurl"></a>`detailsUrl` | [`String!`](#string) | アラート詳細ページのURL。 |
| <a id="alertmanagementalertdiscussions"></a>`discussions` | [`DiscussionConnection!`](#discussionconnection) | noteable（ノート可能）に対するすべてのディスカッション。（[接続](#connections)を参照） |
| <a id="alertmanagementalertendedat"></a>`endedAt` | [`Time`](#time) | アラート終了のタイムスタンプ。 |
| <a id="alertmanagementalertenvironment"></a>`environment` | [`Environment`](#environment) | アラートの環境。 |
| <a id="alertmanagementalerteventcount"></a>`eventCount` | [`Int`](#int) | アラートのイベント数。 |
| <a id="alertmanagementalerthosts"></a>`hosts` | [`[String!]`](#string) | アラート送信元ホストのリスト。 |
| <a id="alertmanagementalertid"></a>`id` | [`ID!`](#id) | アラートのID。 |
| <a id="alertmanagementalertiid"></a>`iid` | [`String!`](#string) | アラートの内部ID。 |
| <a id="alertmanagementalertissue"></a>`issue` | [`Issue`](#issue) | アラートに添付されたイシュー。 |
| <a id="alertmanagementalertissueiid"></a>`issueIid` {{< icon name="warning-solid" >}} | [`String`](#string) | GitLab 13.10で**非推奨**になりました。issueフィールドを使用してください。 |
| <a id="alertmanagementalertmetricsdashboardurl"></a>`metricsDashboardUrl` {{< icon name="warning-solid" >}} | [`String`](#string) | GitLab 16.0で**非推奨**になりました。データは返されません。基盤となる機能は16.0で削除されました。 |
| <a id="alertmanagementalertmonitoringtool"></a>`monitoringTool` | [`String`](#string) | アラート送信元のモニタリングツール。 |
| <a id="alertmanagementalertname"></a>`name` | [`String`](#string) | オブジェクトの名前またはタイトル。 |
| <a id="alertmanagementalertprometheusalert"></a>`prometheusAlert` {{< icon name="warning-solid" >}} | [`PrometheusAlert`](#prometheusalert) | GitLab 17.3で**非推奨**になりました。データは返されません。基盤となる機能は16.0で削除されました。 |
| <a id="alertmanagementalertrunbook"></a>`runbook` | [`String`](#string) | アラートの詳細で定義されているアラートの手順書。 |
| <a id="alertmanagementalertservice"></a>`service` | [`String`](#string) | アラート送信元のサービス。 |
| <a id="alertmanagementalertseverity"></a>`severity` | [`AlertManagementSeverity`](#alertmanagementseverity) | アラートの重大度。 |
| <a id="alertmanagementalertstartedat"></a>`startedAt` | [`Time`](#time) | アラート発生のタイムスタンプ。 |
| <a id="alertmanagementalertstatus"></a>`status` | [`AlertManagementStatus`](#alertmanagementstatus) | アラートの状態。 |
| <a id="alertmanagementalerttitle"></a>`title` | [`String`](#string) | アラートのタイトル。 |
| <a id="alertmanagementalertupdatedat"></a>`updatedAt` | [`Time`](#time) | アラートの最終更新時のタイムスタンプ。 |
| <a id="alertmanagementalertweburl"></a>`webUrl` | [`String!`](#string) | アラートのURL。 |

#### 引数のあるフィールド

##### `AlertManagementAlert.notes`

このnoteableに関するすべてのノート。

[`NoteConnection!`](#noteconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="alertmanagementalertnotesfilter"></a>`filter` | [`NotesFilterType`](#notesfiltertype) | ノートコレクションのタイプ:ALL_NOTES、ONLY_COMMENTS、ONLY_ACTIVITY。 |

##### `AlertManagementAlert.todos`

アラートについての現在のユーザーのto-doアイテム。

[`TodoConnection`](#todoconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="alertmanagementalerttodosaction"></a>`action` | [`[TodoActionEnum!]`](#todoactionenum) | フィルタリングするアクション。 |
| <a id="alertmanagementalerttodosauthorid"></a>`authorId` | [`[ID!]`](#id) | 作成者のID。 |
| <a id="alertmanagementalerttodosgroupid"></a>`groupId` | [`[ID!]`](#id) | グループのID。 |
| <a id="alertmanagementalerttodosissnoozed"></a>`isSnoozed` | [`Boolean`](#boolean) | To Doアイテムがスヌーズされているかどうか。 |
| <a id="alertmanagementalerttodosprojectid"></a>`projectId` | [`[ID!]`](#id) | プロジェクトのID。 |
| <a id="alertmanagementalerttodossort"></a>`sort` | [`TodoSort`](#todosort) | 指定された条件でtodoをソートします。 |
| <a id="alertmanagementalerttodosstate"></a>`state` | [`[TodoStateEnum!]`](#todostateenum) | todoの状態。 |
| <a id="alertmanagementalerttodostype"></a>`type` | [`[TodoTargetEnum!]`](#todotargetenum) | todoのタイプ。 |

### `AlertManagementAlertStatusCountsType`

対象カテゴリのアラートの合計数を表します。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="alertmanagementalertstatuscountstypeacknowledged"></a>`acknowledged` | [`Int`](#int) | プロジェクトの状態がACKNOWLEDGEDのアラートの数。 |
| <a id="alertmanagementalertstatuscountstypeall"></a>`all` | [`Int`](#int) | プロジェクトのアラートの合計数。 |
| <a id="alertmanagementalertstatuscountstypeignored"></a>`ignored` | [`Int`](#int) | プロジェクトの状態がIGNOREDのアラートの数。 |
| <a id="alertmanagementalertstatuscountstypeopen"></a>`open` | [`Int`](#int) | プロジェクトの状態がTRIGGEREDまたはACKNOWLEDGEDのアラートの数。 |
| <a id="alertmanagementalertstatuscountstyperesolved"></a>`resolved` | [`Int`](#int) | プロジェクトの状態がRESOLVEDのアラートの数。 |
| <a id="alertmanagementalertstatuscountstypetriggered"></a>`triggered` | [`Int`](#int) | プロジェクトの状態がTRIGGEREDのアラートの数。 |

### `AlertManagementHttpIntegration`

プロジェクトのアラートを受け入れるために使用されるエンドポイントと認証情報。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="alertmanagementhttpintegrationactive"></a>`active` | [`Boolean`](#boolean) | エンドポイントが現在アラートを受け入れているかどうか。 |
| <a id="alertmanagementhttpintegrationapiurl"></a>`apiUrl` | [`String`](#string) | メトリクスダッシュボードのデータを設定するために、PrometheusメトリクスをクエリできるURL。 |
| <a id="alertmanagementhttpintegrationid"></a>`id` | [`ID!`](#id) | インテグレーションのID。 |
| <a id="alertmanagementhttpintegrationname"></a>`name` | [`String`](#string) | インテグレーションの名前。 |
| <a id="alertmanagementhttpintegrationpayloadalertfields"></a>`payloadAlertFields` | [`[AlertManagementPayloadAlertField!]`](#alertmanagementpayloadalertfield) | カスタムマッピング用のペイロードの例からアラートフィールドを抽出します。 |
| <a id="alertmanagementhttpintegrationpayloadattributemappings"></a>`payloadAttributeMappings` | [`[AlertManagementPayloadAlertMappingField!]`](#alertmanagementpayloadalertmappingfield) | GitLabアラート属性からpayload_exampleに基づくフィールドへのカスタムマッピング。 |
| <a id="alertmanagementhttpintegrationpayloadexample"></a>`payloadExample` | [`JsonString`](#jsonstring) | アラートペイロードの例。 |
| <a id="alertmanagementhttpintegrationtoken"></a>`token` | [`String`](#string) | アラート通知リクエストを認証するために使用するトークン。 |
| <a id="alertmanagementhttpintegrationtype"></a>`type` | [`AlertManagementIntegrationType!`](#alertmanagementintegrationtype) | インテグレーションのタイプ。 |
| <a id="alertmanagementhttpintegrationurl"></a>`url` | [`String`](#string) | アラート通知を受け入れるエンドポイント。 |

### `AlertManagementPayloadAlertField`

カスタムマッピングに使用されるアラートから解析されたフィールド。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="alertmanagementpayloadalertfieldlabel"></a>`label` | [`String`](#string) | 人間が判読できるペイロードパスのラベル。 |
| <a id="alertmanagementpayloadalertfieldpath"></a>`path` | [`[PayloadAlertFieldPathSegment!]`](#payloadalertfieldpathsegment) | ペイロードJSON内の値へのパス。 |
| <a id="alertmanagementpayloadalertfieldtype"></a>`type` | [`AlertManagementPayloadAlertFieldType`](#alertmanagementpayloadalertfieldtype) | 解析された値の型。 |

### `AlertManagementPayloadAlertMappingField`

カスタムマッピングに使用されるアラートから解析されたフィールド（とその名前）。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="alertmanagementpayloadalertmappingfieldfieldname"></a>`fieldName` | [`AlertManagementPayloadAlertFieldName`](#alertmanagementpayloadalertfieldname) | GitLabアラートフィールド名。 |
| <a id="alertmanagementpayloadalertmappingfieldlabel"></a>`label` | [`String`](#string) | 人間が判読できるペイロードパスのラベル。 |
| <a id="alertmanagementpayloadalertmappingfieldpath"></a>`path` | [`[PayloadAlertFieldPathSegment!]`](#payloadalertfieldpathsegment) | ペイロードJSON内の値へのパス。 |
| <a id="alertmanagementpayloadalertmappingfieldtype"></a>`type` | [`AlertManagementPayloadAlertFieldType`](#alertmanagementpayloadalertfieldtype) | 解析された値の型。 |

### `AlertManagementPrometheusIntegration`

プロジェクトのPrometheusアラートを受け入れるために使用されるエンドポイントと認証情報。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="alertmanagementprometheusintegrationactive"></a>`active` | [`Boolean`](#boolean) | エンドポイントが現在アラートを受け入れているかどうか。 |
| <a id="alertmanagementprometheusintegrationapiurl"></a>`apiUrl` | [`String`](#string) | メトリクスダッシュボードのデータを設定するために、PrometheusメトリクスをクエリできるURL。 |
| <a id="alertmanagementprometheusintegrationid"></a>`id` | [`ID!`](#id) | インテグレーションのID。 |
| <a id="alertmanagementprometheusintegrationname"></a>`name` | [`String`](#string) | インテグレーションの名前。 |
| <a id="alertmanagementprometheusintegrationtoken"></a>`token` | [`String`](#string) | アラート通知リクエストを認証するために使用するトークン。 |
| <a id="alertmanagementprometheusintegrationtype"></a>`type` | [`AlertManagementIntegrationType!`](#alertmanagementintegrationtype) | インテグレーションのタイプ。 |
| <a id="alertmanagementprometheusintegrationurl"></a>`url` | [`String`](#string) | アラート通知を受け入れるエンドポイント。 |

### `AmazonS3ConfigurationType`

監査イベントストリーミングのAmazon S3設定を保存します。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="amazons3configurationtypeaccesskeyxid"></a>`accessKeyXid` | [`String!`](#string) | Amazon S3アカウントのアクセスキーID。 |
| <a id="amazons3configurationtypeawsregion"></a>`awsRegion` | [`String!`](#string) | バケットを作成するAWSリージョン。 |
| <a id="amazons3configurationtypebucketname"></a>`bucketName` | [`String!`](#string) | 監査イベントが記録されるバケットの名前。 |
| <a id="amazons3configurationtypegroup"></a>`group` | [`Group!`](#group) | 設定が属するグループ。 |
| <a id="amazons3configurationtypeid"></a>`id` | [`ID!`](#id) | 設定のID。 |
| <a id="amazons3configurationtypename"></a>`name` | [`String!`](#string) | 監査イベントの外部送信先の名前。 |

### `AncestorType`

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ancestortypename"></a>`name` | [`String`](#string) | 祖先の名前。 |
| <a id="ancestortypeversion"></a>`version` | [`String`](#string) | 祖先のバージョン。 |

### `ApiFuzzingCiConfiguration`

GitLab CIでAPIファジングスキャンの設定に関連するデータ。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="apifuzzingciconfigurationscanmodes"></a>`scanModes` | [`[ApiFuzzingScanMode!]`](#apifuzzingscanmode) | 利用可能なすべてのスキャンモード。 |
| <a id="apifuzzingciconfigurationscanprofiles"></a>`scanProfiles` | [`[ApiFuzzingScanProfile!]`](#apifuzzingscanprofile) | すべてのデフォルトスキャンプロファイル。 |

### `ApiFuzzingScanProfile`

APIファジングスキャンプロファイル。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="apifuzzingscanprofiledescription"></a>`description` | [`String`](#string) | プロファイルの短い説明。 |
| <a id="apifuzzingscanprofilename"></a>`name` | [`String`](#string) | プロファイルの固有の名前。 |
| <a id="apifuzzingscanprofileyaml"></a>`yaml` | [`String`](#string) | 構文を強調表示したYAMLのHTML表現。 |

### `ApprovalPolicy`

承認ポリシーを表します。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="approvalpolicyactionapprovers"></a>`actionApprovers` | [`[PolicyApproversType!]`](#policyapproverstype) | 複数の承認者のアクション。 |
| <a id="approvalpolicyallgroupapprovers"></a>`allGroupApprovers` | [`[PolicyApprovalGroup!]`](#policyapprovalgroup) | ユーザーがアクセスできないグループを含め、グループタイプの承認者として可能性のあるすべての承認者。 |
| <a id="approvalpolicycustomroles"></a>`customRoles` | [`[MemberRole!]`](#memberrole) | カスタムロールタイプの承認者。これらのロールに属するユーザーのみが承認者になります。 |
| <a id="approvalpolicydeprecatedproperties"></a>`deprecatedProperties` {{< icon name="warning-solid" >}} | [`[String!]`](#string) | GitLab 16.10で**導入**。**状態**: 実験。ポリシー内のすべての非推奨プロパティ。 |
| <a id="approvalpolicydescription"></a>`description` | [`String!`](#string) | ポリシーの説明。 |
| <a id="approvalpolicyeditpath"></a>`editPath` | [`String!`](#string) | ポリシー編集ページのURL。 |
| <a id="approvalpolicyenabled"></a>`enabled` | [`Boolean!`](#boolean) | ポリシーが有効かどうかを示します。 |
| <a id="approvalpolicyname"></a>`name` | [`String!`](#string) | ポリシーの名前。 |
| <a id="approvalpolicypolicyscope"></a>`policyScope` | [`PolicyScope`](#policyscope) | ポリシーのスコープ。 |
| <a id="approvalpolicyroleapprovers"></a>`roleApprovers` | [`[MemberAccessLevelName!]`](#memberaccesslevelname) | ロールタイプの承認者。これらのロールに属するユーザーのみが承認者になります。 |
| <a id="approvalpolicysource"></a>`source` | [`SecurityPolicySource!`](#securitypolicysource) | ポリシーのソース。そのフィールドは、ソースタイプに応じて異なります。 |
| <a id="approvalpolicyupdatedat"></a>`updatedAt` | [`Time!`](#time) | ポリシーYAMLの最終更新時のタイムスタンプ。 |
| <a id="approvalpolicyuserapprovers"></a>`userApprovers` | [`[UserCore!]`](#usercore) | ユーザータイプの承認者。 |
| <a id="approvalpolicyyaml"></a>`yaml` | [`String!`](#string) | ポリシーのYAML定義。 |

### `ApprovalProjectRule`

誰がマージリクエストを承認できるかに関するプロジェクト承認ルールについて記述します。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="approvalprojectruleapprovalsrequired"></a>`approvalsRequired` | [`Int`](#int) | 必要な承認の数。 |
| <a id="approvalprojectruleeligibleapprovers"></a>`eligibleApprovers` | [`UserCoreConnection`](#usercoreconnection) | 承認ルールについてのマージリクエストを承認する資格のあるユーザーのリスト。（[接続](#connections)を参照） |
| <a id="approvalprojectruleid"></a>`id` | [`GlobalID!`](#globalid) | ルールのID。 |
| <a id="approvalprojectrulename"></a>`name` | [`String`](#string) | ルールの名前。 |
| <a id="approvalprojectruletype"></a>`type` | [`ApprovalRuleType`](#approvalruletype) | ルールのタイプ。 |

### `ApprovalRule`

誰がマージリクエストを承認できるかに関するルールについて記述します。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="approvalruleallowmergewheninvalid"></a>`allowMergeWhenInvalid` | [`Boolean`](#boolean) | ルールが無効な場合に無視できるかどうかを示します。 |
| <a id="approvalruleapprovalsrequired"></a>`approvalsRequired` | [`Int`](#int) | 必要な承認の数。 |
| <a id="approvalruleapproved"></a>`approved` | [`Boolean`](#boolean) | ルールが満たされているかどうかを示します。 |
| <a id="approvalruleapprovedby"></a>`approvedBy` | [`UserCoreConnection`](#usercoreconnection) | ルールで定義されている、マージリクエストを承認したユーザーのリスト。（[接続](#connections)を参照） |
| <a id="approvalrulecommentedby"></a>`commentedBy` | [`UserCoreConnection`](#usercoreconnection) | ルールで定義されている、マージリクエストにコメントしたユーザーのリスト。（[接続](#connections)を参照） |
| <a id="approvalrulecontainshiddengroups"></a>`containsHiddenGroups` | [`Boolean`](#boolean) | 非表示グループの承認者がルールに含まれているかどうかを示します。 |
| <a id="approvalruleeligibleapprovers"></a>`eligibleApprovers` | [`[UserCore!]`](#usercore) | （明示的に定義された、関連グループからの）マージリクエストを承認する資格のあるすべてのユーザーのリスト。 |
| <a id="approvalrulegroups"></a>`groups` | [`GroupConnection`](#groupconnection) | ルールの承認者として追加されたグループのリスト。（[接続](#connections)を参照） |
| <a id="approvalruleid"></a>`id` | [`GlobalID!`](#globalid) | ルールのID。 |
| <a id="approvalruleinvalid"></a>`invalid` | [`Boolean`](#boolean) | 無効のため承認できないルールかどうかを示します。 |
| <a id="approvalrulename"></a>`name` | [`String`](#string) | ルールの名前。 |
| <a id="approvalruleoverridden"></a>`overridden` | [`Boolean`](#boolean) | マージリクエストについてルールがオーバーライドされたかどうかを示します。 |
| <a id="approvalrulescanresultpolicies"></a>`scanResultPolicies` | [`[ApprovalScanResultPolicy!]`](#approvalscanresultpolicy) | ルールに関連付けられているスキャン結果ポリシーのリスト。 |
| <a id="approvalrulesection"></a>`section` | [`String`](#string) | ルール適用対象となるコードオーナーファイルの指定されたセクション。 |
| <a id="approvalrulesourcerule"></a>`sourceRule` | [`ApprovalRule`](#approvalrule) | ルールの作成に使用されるソースルール。 |
| <a id="approvalruletype"></a>`type` | [`ApprovalRuleType`](#approvalruletype) | ルールのタイプ。 |
| <a id="approvalruleusers"></a>`users` | [`UserCoreConnection`](#usercoreconnection) | ルールの承認者として追加されたユーザーのリスト。（[接続](#connections)を参照） |

### `ApprovalScanResultPolicy`

スキャン結果ポリシーを表します。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="approvalscanresultpolicyapprovalsrequired"></a>`approvalsRequired` | [`Int!`](#int) | ポリシーの定義により必要とされる承認を表します。 |
| <a id="approvalscanresultpolicyname"></a>`name` | [`String!`](#string) | ポリシーの名前を表します。 |
| <a id="approvalscanresultpolicyreporttype"></a>`reportType` | [`ApprovalReportType!`](#approvalreporttype) | 承認ルールのreport_typeを表します。 |

### `AssetType`

脆弱性アセットタイプを表します。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="assettypename"></a>`name` | [`String!`](#string) | アセットの名前。 |
| <a id="assettypetype"></a>`type` | [`String!`](#string) | アセットのタイプ。 |
| <a id="assettypeurl"></a>`url` | [`String!`](#string) | アセットのURL。 |

### `AuditEventDefinition`

`ee/config/audit_events/types/<event-type-name>.yml`と`config/audit_events/types/<event-type-name>.yml`で定義されている監査イベントのYAML定義を表します。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="auditeventdefinitiondescription"></a>`description` | [`String!`](#string) | 監査イベントが追跡するアクションの説明。 |
| <a id="auditeventdefinitionfeaturecategory"></a>`featureCategory` | [`String!`](#string) | イベントに関連付けられている機能カテゴリ。 |
| <a id="auditeventdefinitionintroducedbyissue"></a>`introducedByIssue` | [`String`](#string) | イベントを導入するイシューへのリンク。過去の監査イベントの場合、マージリクエストURLではなく、コミットURLの可能性があります。 |
| <a id="auditeventdefinitionintroducedbymr"></a>`introducedByMr` | [`String`](#string) | イベントを導入するマージリクエストへのリンク。過去の監査イベントの場合、マージリクエストURLではなく、コミットURLの可能性があります。 |
| <a id="auditeventdefinitionmilestone"></a>`milestone` | [`String!`](#string) | イベントが導入されたマイルストーン。 |
| <a id="auditeventdefinitionname"></a>`name` | [`String!`](#string) | 監査イベントのキー名。 |
| <a id="auditeventdefinitionsavedtodatabase"></a>`savedToDatabase` | [`Boolean!`](#boolean) | イベントをPostgreSQLデータベースに保存するかどうかを示します。 |
| <a id="auditeventdefinitionstreamed"></a>`streamed` | [`Boolean!`](#boolean) | イベントが外部の宛先にストリーミングされるかどうかを示します。 |

### `AuditEventStreamingHTTPNamespaceFilter`

外部監査イベントストリーミングの宛先に属するサブグループまたはプロジェクトフィルターを表します。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="auditeventstreaminghttpnamespacefilterexternalauditeventdestination"></a>`externalAuditEventDestination` | [`ExternalAuditEventDestination!`](#externalauditeventdestination) | フィルターが属する宛先。 |
| <a id="auditeventstreaminghttpnamespacefilterid"></a>`id` | [`ID!`](#id) | フィルターのID。 |
| <a id="auditeventstreaminghttpnamespacefilternamespace"></a>`namespace` | [`Namespace!`](#namespace) | フィルターが属するグループまたはプロジェクトのネームスペース。 |

### `AuditEventStreamingHeader`

監査ストリーミングの宛先に属するHTTPヘッダーキー/値を表します。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="auditeventstreamingheaderactive"></a>`active` | [`Boolean!`](#boolean) | ヘッダーがアクティブかどうか。 |
| <a id="auditeventstreamingheaderid"></a>`id` | [`ID!`](#id) | ヘッダーのID。 |
| <a id="auditeventstreamingheaderkey"></a>`key` | [`String!`](#string) | ヘッダーのキー。 |
| <a id="auditeventstreamingheadervalue"></a>`value` | [`String!`](#string) | ヘッダーの値。 |

### `AuditEventsStreamingHTTPNamespaceFiltersAddPayload`

AuditEventsStreamingHTTPNamespaceFiltersAddの自動生成された戻り値の型。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="auditeventsstreaminghttpnamespacefiltersaddpayloadclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="auditeventsstreaminghttpnamespacefiltersaddpayloaderrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |
| <a id="auditeventsstreaminghttpnamespacefiltersaddpayloadnamespacefilter"></a>`namespaceFilter` | [`AuditEventStreamingHTTPNamespaceFilter`](#auditeventstreaminghttpnamespacefilter) | 作成されたネームスペースフィルター。 |

### `AuditEventsStreamingHTTPNamespaceFiltersDeletePayload`

AuditEventsStreamingHTTPNamespaceFiltersDeleteの自動生成された戻り値の型。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="auditeventsstreaminghttpnamespacefiltersdeletepayloadclientmutationid"></a>`clientMutationId` | [`String`](#string) | 変異を実行しているクライアントの固有識別子。 |
| <a id="auditeventsstreaminghttpnamespacefiltersdeletepayloaderrors"></a>`errors` | [`[String!]!`](#string) | 変異の実行中に発生したエラー。 |

### `AuditEventsStreamingInstanceHeader`

インスタンスレベルの監査ストリーミングの宛先に属するHTTPヘッダーキー/値を表します。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="auditeventsstreaminginstanceheaderactive"></a>`active` | [`Boolean!`](#boolean) | ヘッダーがアクティブかどうか。 |
| <a id="auditeventsstreaminginstanceheaderid"></a>`id` | [`ID!`](#id) | ヘッダーのID。 |
| <a id="auditeventsstreaminginstanceheaderkey"></a>`key` | [`String!`](#string) | ヘッダーのキー。 |
| <a id="auditeventsstreaminginstanceheadervalue"></a>`value` | [`String!`](#string) | ヘッダーの値。 |

### `AutocompletedUser`

GitLabユーザーのコア表現。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="autocompleteduseractive"></a>`active` | [`Boolean`](#boolean) | ユーザーがアクティブかどうかを示します。 |
| <a id="autocompleteduseravatarurl"></a>`avatarUrl` | [`String`](#string) | ユーザーのアバターのURL。 |
| <a id="autocompleteduserbio"></a>`bio` | [`String`](#string) | ユーザーの経歴。 |
| <a id="autocompleteduserbot"></a>`bot` | [`Boolean!`](#boolean) | ユーザーがボットかどうかを示します。 |
| <a id="autocompletedusercallouts"></a>`callouts` | [`UserCalloutConnection`](#usercalloutconnection) | ユーザーに属するユーザーコールアウト。（[接続](#connections)を参照） |
| <a id="autocompletedusercommitemail"></a>`commitEmail` | [`String`](#string) | ユーザーのデフォルトのコミットメール。 |
| <a id="autocompletedusercreatedat"></a>`createdAt` | [`Time`](#time) | ユーザー作成時のタイムスタンプ。 |
| <a id="autocompleteduserdiscord"></a>`discord` | [`String`](#string) | ユーザーのDiscord ID。 |
| <a id="autocompleteduseremail"></a>`email` {{< icon name="warning-solid" >}} | [`String`](#string) | GitLab 13.7で**非推奨**になりました。名前が変更されました。[`User.publicEmail`](#userpublicemail)を使用してください。 |
| <a id="autocompleteduseremails"></a>`emails` | [`EmailConnection`](#emailconnection) | ユーザーのメールアドレス。（[接続](#connections)を参照） |
| <a id="autocompletedusergitpodenabled"></a>`gitpodEnabled` | [`Boolean`](#boolean) | Gitpodがユーザーレベルで有効になっているかどうか。 |
| <a id="autocompletedusergroupcount"></a>`groupCount` | [`Int`](#int) | ユーザーのグループ数。 |
| <a id="autocompletedusergroupmemberships"></a>`groupMemberships` | [`GroupMemberConnection`](#groupmemberconnection) | ユーザーのグループメンバーシップ。（[接続](#connections)を参照） |
| <a id="autocompleteduserhuman"></a>`human` | [`Boolean`](#boolean) | ユーザーが標準ユーザーかどうかを示します。 |
| <a id="autocompleteduserid"></a>`id` | [`UserID!`](#userid) | ユーザーのグローバルID。 |
| <a id="autocompleteduseride"></a>`ide` | [`Ide`](#ide) | IDEの設定。 |
| <a id="autocompleteduserjobtitle"></a>`jobTitle` | [`String`](#string) | ユーザーの役職。 |
| <a id="autocompleteduserlastactivityon"></a>`lastActivityOn` | [`Date`](#date) | ユーザーが最後に何らかのアクションを実行した日付。 |
| <a id="autocompleteduserlinkedin"></a>`linkedin` | [`String`](#string) | ユーザーのLinkedInプロフィール名。 |
| <a id="autocompleteduserlocation"></a>`location` | [`String`](#string) | ユーザーの所在地。 |
| <a id="autocompletedusername"></a>`name` | [`String!`](#string) | 人間が判読できるユーザー名。ユーザーがプロジェクトボットであり、かつリクエスタにプロジェクト表示の権限がない場合は`****`を返します。 |
| <a id="autocompletedusernamespace"></a>`namespace` | [`Namespace`](#namespace) | ユーザーの個人ネームスペース。 |
| <a id="autocompletedusernamespacecommitemails"></a>`namespaceCommitEmails` | [`NamespaceCommitEmailConnection`](#namespacecommitemailconnection) | ユーザーのカスタムネームスペースコミットメール。（[接続](#connections)を参照） |
| <a id="autocompleteduserorganization"></a>`organization` | [`String`](#string) | ユーザーが誰を代表するか、または誰のために働いているか。 |
| <a id="autocompleteduserpreferencesgitpodpath"></a>`preferencesGitpodPath` | [`String`](#string) | ユーザープリファレンスのGitpodセクションのWebパス。 |
| <a id="autocompleteduserprofileenablegitpodpath"></a>`profileEnableGitpodPath` | [`String`](#string) | ユーザーに対してGitpodを有効にするためのWebパス。 |
| <a id="autocompleteduserprojectmemberships"></a>`projectMemberships` | [`ProjectMemberConnection`](#projectmemberconnection) | ユーザーのプロジェクトメンバーシップ。（[接続](#connections)を参照） |
| <a id="autocompleteduserpronouns"></a>`pronouns` | [`String`](#string) | ユーザーの代名詞。 |
| <a id="autocompleteduserpublicemail"></a>`publicEmail` | [`String`](#string) | ユーザーの公開メールアドレス。 |
| <a id="autocompletedusersavedreplies"></a>`savedReplies` | [`SavedReplyConnection`](#savedreplyconnection) | ユーザーが作成した保存済み返信。（[接続](#connections)を参照） |
| <a id="autocompleteduserstate"></a>`state` | [`UserState!`](#userstate) | ユーザーの状態。 |
| <a id="autocompleteduserstatus"></a>`status` | [`UserStatus`](#userstatus) | ユーザー状態。 |
| <a id="autocompletedusertwitter"></a>`twitter` | [`String`](#string) | ユーザーのX （旧Twitter）ユーザー名。 |
| <a id="autocompletedusertype"></a>`type` | [`UserType!`](#usertype) | ユーザーのタイプ。 |
| <a id="autocompleteduseruserpermissions"></a>`userPermissions` | [`UserPermissions!`](#userpermissions) | リソースに対する現在のユーザーの権限。 |
| <a id="autocompleteduseruserpreferences"></a>`userPreferences` | [`UserPreferences`](#userpreferences) | ユーザーのプリファレンス。 |
| <a id="autocompleteduserusername"></a>`username` | [`String!`](#string) | ユーザーのユーザー名。GitLabインスタンス内で固有。 |
| <a id="autocompleteduserwebpath"></a>`webPath` | [`String!`](#string) | ユーザーのWebパス。 |
| <a id="autocompleteduserweburl"></a>`webUrl` | [`String!`](#string) | ユーザーのWeb URL。 |

#### 引数のあるフィールド

##### `AutocompletedUser.assignedMergeRequests`

ユーザーに割り当てられたマージリクエスト。

[`MergeRequestConnection`](#mergerequestconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="autocompleteduserassignedmergerequestsapproved"></a>`approved` | [`Boolean`](#boolean) | 結果を承認済みマージリクエストに制限します。機能フラグ`mr_approved_filter`が有効になっている場合にのみ使用できます。 |
| <a id="autocompleteduserassignedmergerequestsapprovedby"></a>`approvedBy` | [`[String!]`](#string) | 承認者のユーザー名。 |
| <a id="autocompleteduserassignedmergerequestsapprover"></a>`approver` | [`[String!]`](#string) | 承認者である可能性があるユーザー名。 |
| <a id="autocompleteduserassignedmergerequestsauthorusername"></a>`authorUsername` | [`String`](#string) | 作成者のユーザー名。 |
| <a id="autocompleteduserassignedmergerequestsblobpath"></a>`blobPath` {{< icon name="warning-solid" >}} | [`String`](#string) | GitLab 17.7で**導入**。**状態**: 実験。マージリクエストで変更されたblobのパス。state、targetBranches、およびcreatedAfterの引数が必須です。機能フラグ`filter_blob_path`が有効になっている場合にのみ使用できます。 |
| <a id="autocompleteduserassignedmergerequestscreatedafter"></a>`createdAfter` | [`Time`](#time) | 指定タイムスタンプより後に作成されたマージリクエスト。 |
| <a id="autocompleteduserassignedmergerequestscreatedbefore"></a>`createdBefore` | [`Time`](#time) | 指定タイムスタンプより前に作成されたマージリクエスト。 |
| <a id="autocompleteduserassignedmergerequestsdeployedafter"></a>`deployedAfter` | [`Time`](#time) | 指定タイムスタンプより後にデプロイされたマージリクエスト。 |
| <a id="autocompleteduserassignedmergerequestsdeployedbefore"></a>`deployedBefore` | [`Time`](#time) | 指定タイムスタンプより前にデプロイされたマージリクエスト。 |
| <a id="autocompleteduserassignedmergerequestsdeploymentid"></a>`deploymentId` | [`String`](#string) | デプロイのID。 |
| <a id="autocompleteduserassignedmergerequestsdraft"></a>`draft` | [`Boolean`](#boolean) | 結果を下書きマージリクエストに制限します。 |
| <a id="autocompleteduserassignedmergerequestsenvironmentname"></a>`environmentName` | [`String`](#string) | マージリクエストのデプロイ先環境。 |
| <a id="autocompleteduserassignedmergerequestsgroupid"></a>`groupId` | [`GroupID`](#groupid) | 作成されたマージリクエストが属するグループのグローバルID。サブグループ内のマージリクエストが含まれます。 |
| <a id="autocompleteduserassignedmergerequestsiids"></a>`iids` | [`[String!]`](#string) | マージリクエストのIIDの配列（`[1, 2]`など）。 |
| <a id="autocompleteduserassignedmergerequestsin"></a>`in` | [`[IssuableSearchableField!]`](#issuablesearchablefield) | 検索を実行するフィールドを指定します。デフォルトは`[TITLE, DESCRIPTION]`です。`search`引数が必要です。 |
| <a id="autocompleteduserassignedmergerequestsincludearchived"></a>`includeArchived` | [`Boolean`](#boolean) | アーカイブされたプロジェクトからのマージリクエスト。 |
| <a id="autocompleteduserassignedmergerequestslabelname"></a>`labelName` | [`[String]`](#string) | マージリクエストに適用されるラベル。 |
| <a id="autocompleteduserassignedmergerequestslabels"></a>`labels` {{< icon name="warning-solid" >}} | [`[String!]`](#string) | GitLab 17.1で**非推奨**になりました。`labelName`を使用してください。 |
| <a id="autocompleteduserassignedmergerequestsmergedafter"></a>`mergedAfter` | [`Time`](#time) | 指定日付より後にマージされたマージリクエスト。 |
| <a id="autocompleteduserassignedmergerequestsmergedbefore"></a>`mergedBefore` | [`Time`](#time) | 指定日付より前にマージされたマージリクエスト。 |
| <a id="autocompleteduserassignedmergerequestsmergedby"></a>`mergedBy` | [`String`](#string) | マージしたユーザー名。 |
| <a id="autocompleteduserassignedmergerequestsmilestonetitle"></a>`milestoneTitle` | [`String`](#string) | マイルストーンのタイトル。milestoneWildcardIdと互換性がありません。 |
| <a id="autocompleteduserassignedmergerequestsmilestonewildcardid"></a>`milestoneWildcardId` | [`MilestoneWildcardId`](#milestonewildcardid) | マイルストーンIDのワイルドカードでイシューをフィルタリングします。milestoneTitleと互換性がありません。 |
| <a id="autocompleteduserassignedmergerequestsmyreactionemoji"></a>`myReactionEmoji` | [`String`](#string) | 自分のリアクション絵文字でフィルタリングします。 |
| <a id="autocompleteduserassignedmergerequestsnot"></a>`not` | [`MergeRequestsResolverNegatedParams`](#mergerequestsresolvernegatedparams) | 否定条件となる引数リスト。警告: この引数は実験段階であり、将来変更される可能性があります。 |
| <a id="autocompleteduserassignedmergerequestsor"></a>`or` | [`UnionedMergeRequestFilterInput`](#unionedmergerequestfilterinput) | 引数のリストのインクルーシブOR結合。 |
| <a id="autocompleteduserassignedmergerequestsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | 作成されたマージリクエストが属するプロジェクトのグローバルID。projectPathと互換性がありません。 |
| <a id="autocompleteduserassignedmergerequestsprojectpath"></a>`projectPath` | [`String`](#string) | 作成されたマージリクエストが属するプロジェクトのフルパス。projectIdと互換性がありません。 |
| <a id="autocompleteduserassignedmergerequestsreleasetag"></a>`releaseTag` | [`String`](#string) | リリースタグでフィルタリングします。 |
| <a id="autocompleteduserassignedmergerequestsreviewstate"></a>`reviewState` {{< icon name="warning-solid" >}} | [`MergeRequestReviewState`](#mergerequestreviewstate) | GitLab 17.0で**導入**。**状態**: 実験。マージリクエストのレビュアーの状態。 |
| <a id="autocompleteduserassignedmergerequestsreviewstates"></a>`reviewStates` {{< icon name="warning-solid" >}} | [`[MergeRequestReviewState!]`](#mergerequestreviewstate) | GitLab 17.0で**導入**。**状態**: 実験。マージリクエストのレビュアーの状態（複数）。 |
| <a id="autocompleteduserassignedmergerequestsreviewerusername"></a>`reviewerUsername` | [`String`](#string) | レビュアーのユーザー名。 |
| <a id="autocompleteduserassignedmergerequestsreviewerwildcardid"></a>`reviewerWildcardId` | [`ReviewerWildcardId`](#reviewerwildcardid) | レビュアーの有無でフィルタリングします。reviewerUsernameと互換性がありません。 |
| <a id="autocompleteduserassignedmergerequestssearch"></a>`search` | [`String`](#string) | タイトルまたは説明の検索クエリ。 |
| <a id="autocompleteduserassignedmergerequestssort"></a>`sort` | [`MergeRequestSort`](#mergerequestsort) | マージリクエストを条件でソートします。 |
| <a id="autocompleteduserassignedmergerequestssourcebranches"></a>`sourceBranches` | [`[String!]`](#string) | ソースブランチ名の配列。解決済みのマージリクエストには、すべて、これらのブランチのいずれかがソースとして含まれます。 |
| <a id="autocompleteduserassignedmergerequestsstate"></a>`state` | [`MergeRequestState`](#mergerequeststate) | マージリクエストの状態。指定した場合、解決済みのマージリクエストすべてに状態が含まれます。 |
| <a id="autocompleteduserassignedmergerequestssubscribed"></a>`subscribed` | [`SubscriptionStatus`](#subscriptionstatus) | 現在のユーザーがサブスクライブしているマージリクエスト。 |
| <a id="autocompleteduserassignedmergerequeststargetbranches"></a>`targetBranches` | [`[String!]`](#string) | ターゲットブランチ名の配列。解決済みのマージリクエストには、すべて、これらのブランチのいずれかがターゲットとして含まれます。 |
| <a id="autocompleteduserassignedmergerequestsupdatedafter"></a>`updatedAfter` | [`Time`](#time) | 指定タイムスタンプより後に更新されたマージリクエスト。 |
| <a id="autocompleteduserassignedmergerequestsupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | 指定タイムスタンプより前に更新されたマージリクエスト。 |

##### `AutocompletedUser.authoredMergeRequests`

ユーザーが作成したマージリクエスト。

[`MergeRequestConnection`](#mergerequestconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="autocompleteduserauthoredmergerequestsapproved"></a>`approved` | [`Boolean`](#boolean) | 結果を承認済みマージリクエストに制限します。機能フラグ`mr_approved_filter`が有効になっている場合にのみ使用できます。 |
| <a id="autocompleteduserauthoredmergerequestsapprovedby"></a>`approvedBy` | [`[String!]`](#string) | 承認者のユーザー名。 |
| <a id="autocompleteduserauthoredmergerequestsapprover"></a>`approver` | [`[String!]`](#string) | 承認者である可能性があるユーザー名。 |
| <a id="autocompleteduserauthoredmergerequestsassigneeusername"></a>`assigneeUsername` | [`String`](#string) | 割り当て先ユーザーのユーザー名。 |
| <a id="autocompleteduserauthoredmergerequestsassigneeusernames"></a>`assigneeUsernames` | [`[String!]`](#string) | マージリクエストに割り当てられたユーザーのユーザー名。 |
| <a id="autocompleteduserauthoredmergerequestsassigneewildcardid"></a>`assigneeWildcardId` | [`AssigneeWildcardId`](#assigneewildcardid) | 割り当て先の有無でフィルタリングします。assigneeUsernamesともassigneeUsernameとも互換性がありません。 |
| <a id="autocompleteduserauthoredmergerequestsblobpath"></a>`blobPath` {{< icon name="warning-solid" >}} | [`String`](#string) | GitLab 17.7で**導入**。**状態**: 実験。マージリクエストで変更されたblobのパス。state、targetBranches、およびcreatedAfterの引数が必須です。機能フラグ`filter_blob_path`が有効になっている場合にのみ使用できます。 |
| <a id="autocompleteduserauthoredmergerequestscreatedafter"></a>`createdAfter` | [`Time`](#time) | 指定タイムスタンプより後に作成されたマージリクエスト。 |
| <a id="autocompleteduserauthoredmergerequestscreatedbefore"></a>`createdBefore` | [`Time`](#time) | 指定タイムスタンプより前に作成されたマージリクエスト。 |
| <a id="autocompleteduserauthoredmergerequestsdeployedafter"></a>`deployedAfter` | [`Time`](#time) | 指定タイムスタンプより後にデプロイされたマージリクエスト。 |
| <a id="autocompleteduserauthoredmergerequestsdeployedbefore"></a>`deployedBefore` | [`Time`](#time) | 指定タイムスタンプより前にデプロイされたマージリクエスト。 |
| <a id="autocompleteduserauthoredmergerequestsdeploymentid"></a>`deploymentId` | [`String`](#string) | デプロイのID。 |
| <a id="autocompleteduserauthoredmergerequestsdraft"></a>`draft` | [`Boolean`](#boolean) | 結果を下書きマージリクエストに制限します。 |
| <a id="autocompleteduserauthoredmergerequestsenvironmentname"></a>`environmentName` | [`String`](#string) | マージリクエストのデプロイ先環境。 |
| <a id="autocompleteduserauthoredmergerequestsgroupid"></a>`groupId` | [`GroupID`](#groupid) | 作成されたマージリクエストが属するグループのグローバルID。サブグループ内のマージリクエストが含まれます。 |
| <a id="autocompleteduserauthoredmergerequestsiids"></a>`iids` | [`[String!]`](#string) | マージリクエストのIIDの配列（`[1, 2]`など）。 |
| <a id="autocompleteduserauthoredmergerequestsin"></a>`in` | [`[IssuableSearchableField!]`](#issuablesearchablefield) | 検索を実行するフィールドを指定します。デフォルトは`[TITLE, DESCRIPTION]`です。`search`引数が必要です。 |
| <a id="autocompleteduserauthoredmergerequestsincludearchived"></a>`includeArchived` | [`Boolean`](#boolean) | アーカイブされたプロジェクトからのマージリクエスト。 |
| <a id="autocompleteduserauthoredmergerequestsincludeassigned"></a>`includeAssigned` | [`Boolean`](#boolean) | ユーザーが割り当てられているマージリクエストを含めます。 |
| <a id="autocompleteduserauthoredmergerequestslabelname"></a>`labelName` | [`[String]`](#string) | マージリクエストに適用されるラベル。 |
| <a id="autocompleteduserauthoredmergerequestslabels"></a>`labels` {{< icon name="warning-solid" >}} | [`[String!]`](#string) | GitLab 17.1で**非推奨**になりました。`labelName`を使用してください。 |
| <a id="autocompleteduserauthoredmergerequestsmergedafter"></a>`mergedAfter` | [`Time`](#time) | 指定日付より後にマージされたマージリクエスト。 |
| <a id="autocompleteduserauthoredmergerequestsmergedbefore"></a>`mergedBefore` | [`Time`](#time) | 指定日付より前にマージされたマージリクエスト。 |
| <a id="autocompleteduserauthoredmergerequestsmergedby"></a>`mergedBy` | [`String`](#string) | マージしたユーザー名。 |
| <a id="autocompleteduserauthoredmergerequestsmilestonetitle"></a>`milestoneTitle` | [`String`](#string) | マイルストーンのタイトル。milestoneWildcardIdと互換性がありません。 |
| <a id="autocompleteduserauthoredmergerequestsmilestonewildcardid"></a>`milestoneWildcardId` | [`MilestoneWildcardId`](#milestonewildcardid) | マイルストーンIDのワイルドカードでイシューをフィルタリングします。milestoneTitleと互換性がありません。 |
| <a id="autocompleteduserauthoredmergerequestsmyreactionemoji"></a>`myReactionEmoji` | [`String`](#string) | 自分のリアクション絵文字でフィルタリングします。 |
| <a id="autocompleteduserauthoredmergerequestsnot"></a>`not` | [`MergeRequestsResolverNegatedParams`](#mergerequestsresolvernegatedparams) | 否定条件となる引数リスト。警告: この引数は実験段階であり、将来変更される可能性があります。 |
| <a id="autocompleteduserauthoredmergerequestsor"></a>`or` | [`UnionedMergeRequestFilterInput`](#unionedmergerequestfilterinput) | 引数のリストのインクルーシブOR結合。 |
| <a id="autocompleteduserauthoredmergerequestsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | 作成されたマージリクエストが属するプロジェクトのグローバルID。projectPathと互換性がありません。 |
| <a id="autocompleteduserauthoredmergerequestsprojectpath"></a>`projectPath` | [`String`](#string) | 作成されたマージリクエストが属するプロジェクトのフルパス。projectIdと互換性がありません。 |
| <a id="autocompleteduserauthoredmergerequestsreleasetag"></a>`releaseTag` | [`String`](#string) | リリースタグでフィルタリングします。 |
| <a id="autocompleteduserauthoredmergerequestsreviewstate"></a>`reviewState` {{< icon name="warning-solid" >}} | [`MergeRequestReviewState`](#mergerequestreviewstate) | GitLab 17.0で**導入**。**状態**: 実験。マージリクエストのレビュアーの状態。 |
| <a id="autocompleteduserauthoredmergerequestsreviewstates"></a>`reviewStates` {{< icon name="warning-solid" >}} | [`[MergeRequestReviewState!]`](#mergerequestreviewstate) | GitLab 17.0で**導入**。**状態**: 実験。マージリクエストのレビュアーの状態（複数）。 |
| <a id="autocompleteduserauthoredmergerequestsreviewerusername"></a>`reviewerUsername` | [`String`](#string) | レビュアーのユーザー名。 |
| <a id="autocompleteduserauthoredmergerequestsreviewerwildcardid"></a>`reviewerWildcardId` | [`ReviewerWildcardId`](#reviewerwildcardid) | レビュアーの有無でフィルタリングします。reviewerUsernameと互換性がありません。 |
| <a id="autocompleteduserauthoredmergerequestssearch"></a>`search` | [`String`](#string) | タイトルまたは説明の検索クエリ。 |
| <a id="autocompleteduserauthoredmergerequestssort"></a>`sort` | [`MergeRequestSort`](#mergerequestsort) | マージリクエストを条件でソートします。 |
| <a id="autocompleteduserauthoredmergerequestssourcebranches"></a>`sourceBranches` | [`[String!]`](#string) | ソースブランチ名の配列。解決済みのマージリクエストには、すべて、これらのブランチのいずれかがソースとして含まれます。 |
| <a id="autocompleteduserauthoredmergerequestsstate"></a>`state` | [`MergeRequestState`](#mergerequeststate) | マージリクエストの状態。指定した場合、解決済みのマージリクエストすべてに状態が含まれます。 |
| <a id="autocompleteduserauthoredmergerequestssubscribed"></a>`subscribed` | [`SubscriptionStatus`](#subscriptionstatus) | 現在のユーザーがサブスクライブしているマージリクエスト。 |
| <a id="autocompleteduserauthoredmergerequeststargetbranches"></a>`targetBranches` | [`[String!]`](#string) | ターゲットブランチ名の配列。解決済みのマージリクエストには、すべて、これらのブランチのいずれかがターゲットとして含まれます。 |
| <a id="autocompleteduserauthoredmergerequestsupdatedafter"></a>`updatedAfter` | [`Time`](#time) | 指定タイムスタンプより後に更新されたマージリクエスト。 |
| <a id="autocompleteduserauthoredmergerequestsupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | 指定タイムスタンプより前に更新されたマージリクエスト。 |

##### `AutocompletedUser.contributedProjects`

ユーザーがコントリビュートしたプロジェクト。

[`ProjectConnection`](#projectconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="autocompletedusercontributedprojectsincludepersonal"></a>`includePersonal` | [`Boolean`](#boolean) | 個人用プロジェクトを含めます。 |
| <a id="autocompletedusercontributedprojectsminaccesslevel"></a>`minAccessLevel` | [`AccessLevelEnum`](#accesslevelenum) | 現在のユーザーに付与されているアクセスレベルが指定されたアクセスレベル以上であるプロジェクトのみを返します。 |
| <a id="autocompletedusercontributedprojectsprogramminglanguagename"></a>`programmingLanguageName` | [`String`](#string) | プロジェクトをプログラミング言語名でフィルタリングします（大文字と小文字は区別されません）。cssやrubyなど。 |
| <a id="autocompletedusercontributedprojectssearch"></a>`search` | [`String`](#string) | 検索クエリ。 |
| <a id="autocompletedusercontributedprojectssort"></a>`sort` | [`ProjectSort`](#projectsort) | コントリビュートされたプロジェクトをソートします。 |

##### `AutocompletedUser.groups`

ユーザーがアクセスできるグループ。

[`GroupConnection`](#groupconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="autocompletedusergroupspermissionscope"></a>`permissionScope` | [`GroupPermission`](#grouppermission) | ユーザーに付与されているグループに対する権限でフィルタリングします。 |
| <a id="autocompletedusergroupssearch"></a>`search` | [`String`](#string) | グループ名またはパスで検索します。 |
| <a id="autocompletedusergroupssort"></a>`sort` | [`GroupSort`](#groupsort) | 指定された条件でグループをソートします。 |

##### `AutocompletedUser.mergeRequestInteraction`

ユーザーに関連するマージリクエストの状態。

[`UserMergeRequestInteraction`](#usermergerequestinteraction)を返します。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="autocompletedusermergerequestinteractionid"></a>`id` | [`MergeRequestID!`](#mergerequestid) | マージリクエストのグローバルID。 |

##### `AutocompletedUser.organizations`

ユーザーがアクセスできる組織。

{{< details >}}GitLab 16.6で**導入**。**状態**: 実験。{{< /details >}}

[`OrganizationConnection`](#organizationconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="autocompleteduserorganizationssearch"></a>`search` | [`String`](#string) | 組織名またはパスに対して実行できる検索クエリ。 |
| <a id="autocompleteduserorganizationssoloowned"></a>`soloOwned` | [`Boolean`](#boolean) | trueの場合、ユーザーが単独で所有する組織だけが返されます。 |

##### `AutocompletedUser.reviewRequestedMergeRequests`

レビューのためにユーザーに割り当てられたマージリクエスト。

[`MergeRequestConnection`](#mergerequestconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="autocompleteduserreviewrequestedmergerequestsapproved"></a>`approved` | [`Boolean`](#boolean) | 結果を承認済みマージリクエストに制限します。機能フラグ`mr_approved_filter`が有効になっている場合にのみ使用できます。 |
| <a id="autocompleteduserreviewrequestedmergerequestsapprovedby"></a>`approvedBy` | [`[String!]`](#string) | 承認者のユーザー名。 |
| <a id="autocompleteduserreviewrequestedmergerequestsapprover"></a>`approver` | [`[String!]`](#string) | 承認者である可能性があるユーザー名。 |
| <a id="autocompleteduserreviewrequestedmergerequestsassigneeusername"></a>`assigneeUsername` | [`String`](#string) | 割り当て先ユーザーのユーザー名。 |
| <a id="autocompleteduserreviewrequestedmergerequestsassigneeusernames"></a>`assigneeUsernames` | [`[String!]`](#string) | マージリクエストに割り当てられたユーザーのユーザー名。 |
| <a id="autocompleteduserreviewrequestedmergerequestsassigneewildcardid"></a>`assigneeWildcardId` | [`AssigneeWildcardId`](#assigneewildcardid) | 割り当て先の有無でフィルタリングします。assigneeUsernamesともassigneeUsernameとも互換性がありません。 |
| <a id="autocompleteduserreviewrequestedmergerequestsauthorusername"></a>`authorUsername` | [`String`](#string) | 作成者のユーザー名。 |
| <a id="autocompleteduserreviewrequestedmergerequestsblobpath"></a>`blobPath` {{< icon name="warning-solid" >}} | [`String`](#string) | GitLab 17.7で**導入**。**状態**: 実験。マージリクエストで変更されたblobのパス。state、targetBranches、およびcreatedAfterの引数が必須です。機能フラグ`filter_blob_path`が有効になっている場合にのみ使用できます。 |
| <a id="autocompleteduserreviewrequestedmergerequestscreatedafter"></a>`createdAfter` | [`Time`](#time) | 指定タイムスタンプより後に作成されたマージリクエスト。 |
| <a id="autocompleteduserreviewrequestedmergerequestscreatedbefore"></a>`createdBefore` | [`Time`](#time) | 指定タイムスタンプより前に作成されたマージリクエスト。 |
| <a id="autocompleteduserreviewrequestedmergerequestsdeployedafter"></a>`deployedAfter` | [`Time`](#time) | 指定タイムスタンプより後にデプロイされたマージリクエスト。 |
| <a id="autocompleteduserreviewrequestedmergerequestsdeployedbefore"></a>`deployedBefore` | [`Time`](#time) | 指定タイムスタンプより前にデプロイされたマージリクエスト。 |
| <a id="autocompleteduserreviewrequestedmergerequestsdeploymentid"></a>`deploymentId` | [`String`](#string) | デプロイのID。 |
| <a id="autocompleteduserreviewrequestedmergerequestsdraft"></a>`draft` | [`Boolean`](#boolean) | 結果を下書きマージリクエストに制限します。 |
| <a id="autocompleteduserreviewrequestedmergerequestsenvironmentname"></a>`environmentName` | [`String`](#string) | マージリクエストのデプロイ先環境。 |
| <a id="autocompleteduserreviewrequestedmergerequestsgroupid"></a>`groupId` | [`GroupID`](#groupid) | 作成されたマージリクエストが属するグループのグローバルID。サブグループ内のマージリクエストが含まれます。 |
| <a id="autocompleteduserreviewrequestedmergerequestsiids"></a>`iids` | [`[String!]`](#string) | マージリクエストのIIDの配列（`[1, 2]`など）。 |
| <a id="autocompleteduserreviewrequestedmergerequestsin"></a>`in` | [`[IssuableSearchableField!]`](#issuablesearchablefield) | 検索を実行するフィールドを指定します。デフォルトは`[TITLE, DESCRIPTION]`です。`search`引数が必要です。 |
| <a id="autocompleteduserreviewrequestedmergerequestsincludearchived"></a>`includeArchived` | [`Boolean`](#boolean) | アーカイブされたプロジェクトからのマージリクエスト。 |
| <a id="autocompleteduserreviewrequestedmergerequestslabelname"></a>`labelName` | [`[String]`](#string) | マージリクエストに適用されるラベル。 |
| <a id="autocompleteduserreviewrequestedmergerequestslabels"></a>`labels` {{< icon name="warning-solid" >}} | [`[String!]`](#string) | GitLab 17.1で**非推奨**になりました。`labelName`を使用してください。 |
| <a id="autocompleteduserreviewrequestedmergerequestsmergedafter"></a>`mergedAfter` | [`Time`](#time) | 指定日付より後にマージされたマージリクエスト。 |
| <a id="autocompleteduserreviewrequestedmergerequestsmergedbefore"></a>`mergedBefore` | [`Time`](#time) | 指定日付より前にマージされたマージリクエスト。 |
| <a id="autocompleteduserreviewrequestedmergerequestsmergedby"></a>`mergedBy` | [`String`](#string) | マージしたユーザー名。 |
| <a id="autocompleteduserreviewrequestedmergerequestsmilestonetitle"></a>`milestoneTitle` | [`String`](#string) | マイルストーンのタイトル。milestoneWildcardIdと互換性がありません。 |
| <a id="autocompleteduserreviewrequestedmergerequestsmilestonewildcardid"></a>`milestoneWildcardId` | [`MilestoneWildcardId`](#milestonewildcardid) | マイルストーンIDのワイルドカードでイシューをフィルタリングします。milestoneTitleと互換性がありません。 |
| <a id="autocompleteduserreviewrequestedmergerequestsmyreactionemoji"></a>`myReactionEmoji` | [`String`](#string) | 自分のリアクション絵文字でフィルタリングします。 |
| <a id="autocompleteduserreviewrequestedmergerequestsnot"></a>`not` | [`MergeRequestsResolverNegatedParams`](#mergerequestsresolvernegatedparams) | 否定条件となる引数リスト。警告: この引数は実験段階であり、将来変更される可能性があります。 |
| <a id="autocompleteduserreviewrequestedmergerequestsor"></a>`or` | [`UnionedMergeRequestFilterInput`](#unionedmergerequestfilterinput) | 引数のリストのインクルーシブOR結合。 |
| <a id="autocompleteduserreviewrequestedmergerequestsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | 作成されたマージリクエストが属するプロジェクトのグローバルID。projectPathと互換性がありません。 |
| <a id="autocompleteduserreviewrequestedmergerequestsprojectpath"></a>`projectPath` | [`String`](#string) | 作成されたマージリクエストが属するプロジェクトのフルパス。projectIdと互換性がありません。 |
| <a id="autocompleteduserreviewrequestedmergerequestsreleasetag"></a>`releaseTag` | [`String`](#string) | リリースタグでフィルタリングします。 |
| <a id="autocompleteduserreviewrequestedmergerequestsreviewstate"></a>`reviewState` {{< icon name="warning-solid" >}} | [`MergeRequestReviewState`](#mergerequestreviewstate) | GitLab 17.0で**導入**。**状態**: 実験。マージリクエストのレビュアーの状態。 |
| <a id="autocompleteduserreviewrequestedmergerequestsreviewstates"></a>`reviewStates` {{< icon name="warning-solid" >}} | [`[MergeRequestReviewState!]`](#mergerequestreviewstate) | GitLab 17.0で**導入**。**状態**: 実験。マージリクエストのレビュアーの状態（複数）。 |
| <a id="autocompleteduserreviewrequestedmergerequestssearch"></a>`search` | [`String`](#string) | タイトルまたは説明の検索クエリ。 |
| <a id="autocompleteduserreviewrequestedmergerequestssort"></a>`sort` | [`MergeRequestSort`](#mergerequestsort) | マージリクエストを条件でソートします。 |
| <a id="autocompleteduserreviewrequestedmergerequestssourcebranches"></a>`sourceBranches` | [`[String!]`](#string) | ソースブランチ名の配列。解決済みのマージリクエストには、すべて、これらのブランチのいずれかがソースとして含まれます。 |
| <a id="autocompleteduserreviewrequestedmergerequestsstate"></a>`state` | [`MergeRequestState`](#mergerequeststate) | マージリクエストの状態。指定した場合、解決済みのマージリクエストすべてに状態が含まれます。 |
| <a id="autocompleteduserreviewrequestedmergerequestssubscribed"></a>`subscribed` | [`SubscriptionStatus`](#subscriptionstatus) | 現在のユーザーがサブスクライブしているマージリクエスト。 |
| <a id="autocompleteduserreviewrequestedmergerequeststargetbranches"></a>`targetBranches` | [`[String!]`](#string) | ターゲットブランチ名の配列。解決済みのマージリクエストには、すべて、これらのブランチのいずれかがターゲットとして含まれます。 |
| <a id="autocompleteduserreviewrequestedmergerequestsupdatedafter"></a>`updatedAfter` | [`Time`](#time) | 指定タイムスタンプより後に更新されたマージリクエスト。 |
| <a id="autocompleteduserreviewrequestedmergerequestsupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | 指定タイムスタンプより前に更新されたマージリクエスト。 |

##### `AutocompletedUser.savedReply`

ユーザーが作成した保存済み返信。

[`SavedReply`](#savedreply)を返します。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="autocompletedusersavedreplyid"></a>`id` | [`UsersSavedReplyID!`](#userssavedreplyid) | 保存済み返信のID。 |

##### `AutocompletedUser.snippets`

ユーザーが作成したスニペット。

[`SnippetConnection`](#snippetconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="autocompletedusersnippetsids"></a>`ids` | [`[SnippetID!]`](#snippetid) | グローバルスニペットIDの配列。例: `gid://gitlab/ProjectSnippet/1`。 |
| <a id="autocompletedusersnippetstype"></a>`type` | [`TypeEnum`](#typeenum) | スニペットのタイプ。 |
| <a id="autocompletedusersnippetsvisibility"></a>`visibility` | [`VisibilityScopesEnum`](#visibilityscopesenum) | スニペットの表示レベル。 |

##### `AutocompletedUser.starredProjects`

ユーザーがお気に入り登録したプロジェクト。

[`ProjectConnection`](#projectconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="autocompleteduserstarredprojectsminaccesslevel"></a>`minAccessLevel` | [`AccessLevelEnum`](#accesslevelenum) | 現在のユーザーに付与されているアクセスレベルが指定されたアクセスレベル以上であるプロジェクトのみを返します。 |
| <a id="autocompleteduserstarredprojectsprogramminglanguagename"></a>`programmingLanguageName` | [`String`](#string) | プロジェクトをプログラミング言語名でフィルタリングします（大文字と小文字は区別されません）。cssやrubyなど。 |
| <a id="autocompleteduserstarredprojectssearch"></a>`search` | [`String`](#string) | 検索クエリ。 |
| <a id="autocompleteduserstarredprojectssort"></a>`sort` | [`ProjectSort`](#projectsort) | 指定ソート順でお気に入りプロジェクトを一覧表示します。 |

##### `AutocompletedUser.timelogs`

ユーザーがログに記録した時刻。

[`TimelogConnection`](#timelogconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="autocompletedusertimelogsenddate"></a>`endDate` | [`Time`](#time) | 日付範囲内のタイムログのうち、ログに記録された日付がendDate以前であるものを一覧表示します。 |
| <a id="autocompletedusertimelogsendtime"></a>`endTime` | [`Time`](#time) | 時刻範囲内のタイムログのうち、ログに記録された時刻がendTime以前であるものを一覧表示します。 |
| <a id="autocompletedusertimelogsgroupid"></a>`groupId` | [`GroupID`](#groupid) | グループのタイムログを一覧表示します。 |
| <a id="autocompletedusertimelogsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | プロジェクトのタイムログを一覧表示します。 |
| <a id="autocompletedusertimelogssort"></a>`sort` | [`TimelogSort`](#timelogsort) | タイムログを特定の順序で一覧表示します。 |
| <a id="autocompletedusertimelogsstartdate"></a>`startDate` | [`Time`](#time) | 日付範囲内のタイムログのうち、ログに記録された日付がstartDate以後であるものを一覧表示します。 |
| <a id="autocompletedusertimelogsstarttime"></a>`startTime` | [`Time`](#time) | 時刻範囲内のタイムログのうち、ログに記録された時刻がstartTime以後であるものを一覧表示します。 |
| <a id="autocompletedusertimelogsusername"></a>`username` | [`String`](#string) | ユーザーのタイムログを一覧表示します。 |

##### `AutocompletedUser.todos`

ユーザーのto-doアイテム。

[`TodoConnection`](#todoconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="autocompletedusertodosaction"></a>`action` | [`[TodoActionEnum!]`](#todoactionenum) | フィルタリングするアクション。 |
| <a id="autocompletedusertodosauthorid"></a>`authorId` | [`[ID!]`](#id) | 作成者のID。 |
| <a id="autocompletedusertodosgroupid"></a>`groupId` | [`[ID!]`](#id) | グループのID。 |
| <a id="autocompletedusertodosissnoozed"></a>`isSnoozed` | [`Boolean`](#boolean) | To Doアイテムがスヌーズされているかどうか。 |
| <a id="autocompletedusertodosprojectid"></a>`projectId` | [`[ID!]`](#id) | プロジェクトのID。 |
| <a id="autocompletedusertodossort"></a>`sort` | [`TodoSort`](#todosort) | 指定された条件でtodoをソートします。 |
| <a id="autocompletedusertodosstate"></a>`state` | [`[TodoStateEnum!]`](#todostateenum) | todoの状態。 |
| <a id="autocompletedusertodostype"></a>`type` | [`[TodoTargetEnum!]`](#todotargetenum) | todoのタイプ。 |

##### `AutocompletedUser.userAchievements`

ユーザーのアチーブメント。`achievements`機能フラグが有効になっているネームスペースについてのみ返されます。

{{< details >}}GitLab 15.10で**導入**。**状態**: 実験。{{< /details >}}

[`UserAchievementConnection`](#userachievementconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="autocompleteduseruserachievementsincludehidden"></a>`includeHidden` | [`Boolean`](#boolean) | プロファイルから隠されたアチーブメントを結果に含めるかどうかを示します。 |

##### `AutocompletedUser.workspaces`

現在のユーザーが所有するワークスペース。

[`WorkspaceConnection`](#workspaceconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="autocompleteduserworkspacesactualstates"></a>`actualStates` | [`[String!]`](#string) | ワークスペースを実際の状態でフィルタリングします。 |
| <a id="autocompleteduserworkspacesagentids"></a>`agentIds` | [`[ClustersAgentID!]`](#clustersagentid) | ワークスペースをエージェントのグローバルIDでフィルタリングします。 |
| <a id="autocompleteduserworkspacesids"></a>`ids` | [`[RemoteDevelopmentWorkspaceID!]`](#remotedevelopmentworkspaceid) | ワークスペースをワークスペースのグローバルIDでフィルタリングします。例: `["gid://gitlab/RemoteDevelopment::Workspace/1"]`。 |
| <a id="autocompleteduserworkspacesincludeactualstates"></a>`includeActualStates` {{< icon name="warning-solid" >}} | [`[String!]`](#string) | GitLab 16.7で**非推奨**になりました。代わりにactual_statesを使用してください。 |
| <a id="autocompleteduserworkspacesprojectids"></a>`projectIds` | [`[ProjectID!]`](#projectid) | ワークスペースをプロジェクトのグローバルIDでフィルタリングします。 |

### `AwardEmoji`

ユーザーによって授与された絵文字。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="awardemojidescription"></a>`description` | [`String!`](#string) | 絵文字の説明。 |
| <a id="awardemojiemoji"></a>`emoji` | [`String!`](#string) | アイコンとしての絵文字。 |
| <a id="awardemojiname"></a>`name` | [`String!`](#string) | 絵文字の名前。 |
| <a id="awardemojiunicode"></a>`unicode` | [`String!`](#string) | Unicodeでの絵文字。 |
| <a id="awardemojiunicodeversion"></a>`unicodeVersion` | [`String!`](#string) | 絵文字のUnicodeバージョン。 |
| <a id="awardemojiuser"></a>`user` | [`UserCore!`](#usercore) | 絵文字を授与したユーザー。 |

### `BaseService`

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="baseserviceactive"></a>`active` | [`Boolean`](#boolean) | サービスがアクティブかどうかを示します。 |
| <a id="baseserviceservicetype"></a>`serviceType` | [`ServiceType`](#servicetype) | サービスのタイプ。 |
| <a id="baseservicetype"></a>`type` | [`String`](#string) | サービスのクラス名。 |

### `Blame`

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="blamefirstline"></a>`firstLine` | [`String`](#string) | 指定された範囲のGit Blameの最初の行。 |
| <a id="blamegroups"></a>`groups` | [`[Groups!]`](#groups) | コミットの連続する行でグループ化された Git Blame。 |

### `Blob`

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="blobflatpath"></a>`flatPath` | [`String!`](#string) | エントリのフラットパス。 |
| <a id="blobid"></a>`id` | [`ID!`](#id) | エントリのID。 |
| <a id="bloblfsoid"></a>`lfsOid` | [`String`](#string) | blobのLFS ID。 |
| <a id="blobmode"></a>`mode` | [`String`](#string) | 数値形式のblobモード。 |
| <a id="blobname"></a>`name` | [`String!`](#string) | エントリの名前。 |
| <a id="blobpath"></a>`path` | [`String!`](#string) | エントリのパス。 |
| <a id="blobsha"></a>`sha` | [`String!`](#string) | エントリのSHA。 |
| <a id="blobtype"></a>`type` | [`EntryType!`](#entrytype) | ツリーエントリのタイプ。 |
| <a id="blobwebpath"></a>`webPath` | [`String`](#string) | blobのWebパス。 |
| <a id="blobweburl"></a>`webUrl` | [`String`](#string) | blobのWeb URL。 |

### `BlobSearch`

単一ファイル内の複数マッチ結果のフルJSON構造。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="blobsearchfilecount"></a>`fileCount` {{< icon name="warning-solid" >}} | [`Int`](#int) | GitLab 17.2で**導入**。**状態**: 実験。一致するファイルの総数。 |
| <a id="blobsearchfiles"></a>`files` {{< icon name="warning-solid" >}} | [`[SearchBlobFileType!]`](#searchblobfiletype) | GitLab 17.2で**導入**。**状態**: 実験。一致するファイルのリスト。 |
| <a id="blobsearchmatchcount"></a>`matchCount` {{< icon name="warning-solid" >}} | [`Int`](#int) | GitLab 17.2で**導入**。**状態**: 実験。一致の合計数。 |
| <a id="blobsearchperpage"></a>`perPage` {{< icon name="warning-solid" >}} | [`Int`](#int) | GitLab 17.2で**導入**。**状態**: 実験。ページあたりのファイルの総数。 |
| <a id="blobsearchsearchlevel"></a>`searchLevel` {{< icon name="warning-solid" >}} | [`SearchLevel`](#searchlevel) | GitLab 17.2で**導入**。**状態**: 実験。実行された検索のレベル。 |
| <a id="blobsearchsearchtype"></a>`searchType` {{< icon name="warning-solid" >}} | [`SearchType`](#searchtype) | GitLab 17.2で**導入**。**状態**: 実験。実行された検索のタイプ。 |

### `BlobViewer`

blobコンテンツの表示方法を表します。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="blobviewercollapsed"></a>`collapsed` | [`Boolean!`](#boolean) | blobを折りたたんで表示するかどうかを示します。 |
| <a id="blobviewerfiletype"></a>`fileType` | [`String!`](#string) | コンテンツのファイルタイプ。 |
| <a id="blobviewerloadasync"></a>`loadAsync` | [`Boolean!`](#boolean) | blobコンテンツを非同期でロードするかどうかを示します。 |
| <a id="blobviewerloadingpartialname"></a>`loadingPartialName` | [`String!`](#string) | 部分的な読み込み名。 |
| <a id="blobviewerrendererror"></a>`renderError` | [`String`](#string) | blobコンテンツのレンダリングエラー。 |
| <a id="blobviewertoolarge"></a>`tooLarge` | [`Boolean!`](#boolean) | blobが大きすぎて表示できないかどうかを示します。 |
| <a id="blobviewertype"></a>`type` | [`BlobViewersType!`](#blobviewerstype) | blobビューアーのタイプ。 |

### `BlockingMergeRequests`

このマージリクエストによるマージのために満たす必要のあるルールに関する情報。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="blockingmergerequestshiddencount"></a>`hiddenCount` | [`Int!`](#int) | ユーザーに表示されないブロックマージリクエスト。 |
| <a id="blockingmergerequeststotalcount"></a>`totalCount` | [`Int!`](#int) | ブロックマージリクエストの総数。 |
| <a id="blockingmergerequestsvisiblemergerequests"></a>`visibleMergeRequests` | [`[MergeRequest!]`](#mergerequest) | ユーザーに表示されるブロックマージリクエスト。 |

### `Board`

プロジェクトイシューボードまたはグループイシューボードを表します。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="boardassignee"></a>`assignee` | [`UserCore`](#usercore) | ボードの割り当て先。 |
| <a id="boardcreatedat"></a>`createdAt` | [`Time!`](#time) | ボード作成時のタイムスタンプ。 |
| <a id="boardhidebackloglist"></a>`hideBacklogList` | [`Boolean`](#boolean) | バックログリストを非表示にするかどうか。 |
| <a id="boardhideclosedlist"></a>`hideClosedList` | [`Boolean`](#boolean) | 完了リストを非表示にするかどうか。 |
| <a id="boardid"></a>`id` | [`ID!`](#id) | ボードのID（グローバルID）。 |
| <a id="boarditeration"></a>`iteration` | [`Iteration`](#iteration) | ボードのイテレーション。 |
| <a id="boarditerationcadence"></a>`iterationCadence` | [`IterationCadence`](#iterationcadence) | ボードのイテレーションケイデンス。 |
| <a id="boardlabels"></a>`labels` | [`LabelConnection`](#labelconnection) | ボードのラベル。（[接続](#connections)を参照） |
| <a id="boardmilestone"></a>`milestone` | [`Milestone`](#milestone) | ボードのマイルストーン。 |
| <a id="boardname"></a>`name` | [`String`](#string) | ボードの名前。 |
| <a id="boardupdatedat"></a>`updatedAt` | [`Time!`](#time) | ボードの最終更新タイムスタンプ。 |
| <a id="boardwebpath"></a>`webPath` | [`String!`](#string) | ボードのWebパス。 |
| <a id="boardweburl"></a>`webUrl` | [`String!`](#string) | ボードのWeb URL。 |
| <a id="boardweight"></a>`weight` | [`Int`](#int) | ボードのウェイト。 |

#### 引数のあるフィールド

##### `Board.epics`

ボードイシューに関連付けられているエピック。

[`BoardEpicConnection`](#boardepicconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="boardepicsissuefilters"></a>`issueFilters` | [`BoardIssueInput`](#boardissueinput) | ボードのイシュー選択時に適用されるフィルター。 |

##### `Board.lists`

ボードのリスト。

[`BoardListConnection`](#boardlistconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="boardlistsid"></a>`id` | [`ListID`](#listid) | リストをグローバルIDで検索します。 |
| <a id="boardlistsissuefilters"></a>`issueFilters` | [`BoardIssueInput`](#boardissueinput) | ボードリストでイシューメタデータを取得する際に適用されるフィルター。 |

### `BoardEpic`

イシューボードのエピックを表します。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="boardepicauthor"></a>`author` | [`UserCore!`](#usercore) | エピックの作成者。 |
| <a id="boardepicawardemoji"></a>`awardEmoji` | [`AwardEmojiConnection`](#awardemojiconnection) | エピックに関連付けられている絵文字リアクションのリスト。（[接続](#connections)を参照） |
| <a id="boardepicblocked"></a>`blocked` | [`Boolean`](#boolean) | エピックがブロックされていることを示します。 |
| <a id="boardepicblockedbycount"></a>`blockedByCount` | [`Int`](#int) | このエピックをブロックしているエピックの数。 |
| <a id="boardepicblockedbyepics"></a>`blockedByEpics` | [`EpicConnection`](#epicconnection) | このエピックをブロックしているエピック。（[接続](#connections)を参照） |
| <a id="boardepicblockingcount"></a>`blockingCount` | [`Int`](#int) | このエピックがブロックしているエピックの数。 |
| <a id="boardepicclosedat"></a>`closedAt` | [`Time`](#time) | エピッククローズ時のタイムスタンプ。 |
| <a id="boardepiccolor"></a>`color` | [`String`](#string) | エピックの色。 |
| <a id="boardepiccommenters"></a>`commenters` | [`UserCoreConnection!`](#usercoreconnection) | noteableについてのすべてのコメンター。（[接続](#connections)を参照） |
| <a id="boardepicconfidential"></a>`confidential` | [`Boolean`](#boolean) | エピックが機密かどうかを示します。 |
| <a id="boardepiccreatedat"></a>`createdAt` | [`Time`](#time) | エピック作成時のタイムスタンプ。 |
| <a id="boardepicdefaultprojectforissuecreation"></a>`defaultProjectForIssueCreation` | [`Project`](#project) | イシュー作成のデフォルトプロジェクト。ユーザーが最後のイシューを作成したプロジェクトに基づきます。 |
| <a id="boardepicdescendantcounts"></a>`descendantCounts` | [`EpicDescendantCount`](#epicdescendantcount) | 未解決/完了子孫エピック/イシューの数。 |
| <a id="boardepicdescendantweightsum"></a>`descendantWeightSum` | [`EpicDescendantWeights`](#epicdescendantweights) | エピックとその子孫の未解決イシューと完了イシューの合計ウェイト。 |
| <a id="boardepicdescription"></a>`description` | [`String`](#string) | エピックの説明。 |
| <a id="boardepicdescriptionhtml"></a>`descriptionHtml` | [`String`](#string) | `description`のGitLab Flavored Markdownレンダリング。 |
| <a id="boardepicdiscussions"></a>`discussions` | [`DiscussionConnection!`](#discussionconnection) | noteable（ノート可能）に対するすべてのディスカッション。（[接続](#connections)を参照） |
| <a id="boardepicdownvotes"></a>`downvotes` | [`Int!`](#int) | エピックが受け取った不同意票の数。 |
| <a id="boardepicduedate"></a>`dueDate` | [`Time`](#time) | エピックの期限。 |
| <a id="boardepicduedatefixed"></a>`dueDateFixed` | [`Time`](#time) | エピックの修正期限。 |
| <a id="boardepicduedatefrominheritedsource"></a>`dueDateFromInheritedSource` | [`Time`](#time) | 子エピックまたはマイルストーンから継承されたエピックの期限。 |
| <a id="boardepicduedatefrommilestones"></a>`dueDateFromMilestones` | [`Time`](#time) | マイルストーンから継承されたエピックの期限。 |
| <a id="boardepicduedateisfixed"></a>`dueDateIsFixed` | [`Boolean`](#boolean) | 期限が手動で設定されたかどうかを示します。 |
| <a id="boardepicevents"></a>`events` | [`EventConnection`](#eventconnection) | オブジェクトに関連付けられているイベントのリスト。（[接続](#connections)を参照） |
| <a id="boardepicgroup"></a>`group` | [`Group!`](#group) | エピックが属するグループ。 |
| <a id="boardepichaschildren"></a>`hasChildren` | [`Boolean!`](#boolean) | エピックに子があるかどうかを示します。 |
| <a id="boardepichaschildrenwithintimeframe"></a>`hasChildrenWithinTimeframe` | [`Boolean!`](#boolean) | 指定された期間内にエピックに子があるかどうかを示します。 |
| <a id="boardepichasissues"></a>`hasIssues` | [`Boolean!`](#boolean) | エピックに直接イシューがあるかどうかを示します。 |
| <a id="boardepichasparent"></a>`hasParent` | [`Boolean!`](#boolean) | エピックに親エピックがあるかどうかを示します。 |
| <a id="boardepichealthstatus"></a>`healthStatus` | [`EpicHealthStatus`](#epichealthstatus) | エピックの現在のヘルスステータス。 |
| <a id="boardepicid"></a>`id` | [`ID!`](#id) | エピックのID。 |
| <a id="boardepiciid"></a>`iid` | [`String!`](#string) | エピックの内部ID。 |
| <a id="boardepicissues"></a>`issues` | [`EpicIssueConnection`](#epicissueconnection) | エピックに関連付けられているイシューのリスト。（[接続](#connections)を参照） |
| <a id="boardepiclabels"></a>`labels` | [`LabelConnection`](#labelconnection) | エピックに割り当てられたラベル。（[接続](#connections)を参照） |
| <a id="boardepicname"></a>`name` | [`String`](#string) | オブジェクトの名前またはタイトル。 |
| <a id="boardepicparent"></a>`parent` | [`Epic`](#epic) | エピックの親エピック。 |
| <a id="boardepicparticipants"></a>`participants` | [`UserCoreConnection`](#usercoreconnection) | エピックの参加者のリスト。（[接続](#connections)を参照） |
| <a id="boardepicrelationpath"></a>`relationPath` | [`String`](#string) | エピックとイシューの関係のURIパス。 |
| <a id="boardepicrelativeposition"></a>`relativePosition` | [`Int`](#int) | Epic Tree内でのエピックの相対的な位置。 |
| <a id="boardepicstartdate"></a>`startDate` | [`Time`](#time) | エピックの開始日。 |
| <a id="boardepicstartdatefixed"></a>`startDateFixed` | [`Time`](#time) | エピックの修正開始日。 |
| <a id="boardepicstartdatefrominheritedsource"></a>`startDateFromInheritedSource` | [`Time`](#time) | 子エピックまたはマイルストーンから継承されたエピックの開始日。 |
| <a id="boardepicstartdatefrommilestones"></a>`startDateFromMilestones` | [`Time`](#time) | マイルストーンから継承されたエピックの開始日。 |
| <a id="boardepicstartdateisfixed"></a>`startDateIsFixed` | [`Boolean`](#boolean) | 開始日が手動で設定されたかどうかを示します。 |
| <a id="boardepicstate"></a>`state` | [`EpicState!`](#epicstate) | エピックの状態。 |
| <a id="boardepicsubscribed"></a>`subscribed` | [`Boolean!`](#boolean) | 現在ログインしているユーザーがエピックをサブスクライブしているかどうかを示します。 |
| <a id="boardepictextcolor"></a>`textColor` | [`String`](#string) | エピック用に生成されるテキストの色。 |
| <a id="boardepictitle"></a>`title` | [`String`](#string) | エピックのタイトル。 |
| <a id="boardepictitlehtml"></a>`titleHtml` | [`String`](#string) | `title`のGitLab Flavored Markdownレンダリング。 |
| <a id="boardepicupdatedat"></a>`updatedAt` | [`Time`](#time) | エピック更新時のタイムスタンプ。 |
| <a id="boardepicupvotes"></a>`upvotes` | [`Int!`](#int) | エピックが受け取った同意票の数。 |
| <a id="boardepicuserdiscussionscount"></a>`userDiscussionsCount` | [`Int!`](#int) | エピック内のユーザーディスカッションの数。 |
| <a id="boardepicusernotescount"></a>`userNotesCount` | [`Int!`](#int) | エピックのユーザーノートの数。 |
| <a id="boardepicuserpermissions"></a>`userPermissions` | [`EpicPermissions!`](#epicpermissions) | リソースに対する現在のユーザーの権限。 |
| <a id="boardepicuserpreferences"></a>`userPreferences` | [`BoardEpicUserPreferences`](#boardepicuserpreferences) | イシューボード上のエピックのユーザープリファレンス。 |
| <a id="boardepicwebpath"></a>`webPath` | [`String!`](#string) | エピックのWebパス。 |
| <a id="boardepicweburl"></a>`webUrl` | [`String!`](#string) | エピックのWeb URL。 |

#### 引数のあるフィールド

##### `BoardEpic.ancestors`

エピックの祖先（親）。

[`EpicConnection`](#epicconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="boardepicancestorsauthorusername"></a>`authorUsername` | [`String`](#string) | エピックを作成者でフィルタリングします。 |
| <a id="boardepicancestorsconfidential"></a>`confidential` | [`Boolean`](#boolean) | 指定された機密性でエピックをフィルタリングします。 |
| <a id="boardepicancestorscreatedafter"></a>`createdAfter` | [`Time`](#time) | 指定日付より後に作成されたエピック。 |
| <a id="boardepicancestorscreatedbefore"></a>`createdBefore` | [`Time`](#time) | 指定日付より前に作成されたエピック。 |
| <a id="boardepicancestorscustomfield"></a>`customField` {{< icon name="warning-solid" >}} | [`[WorkItemWidgetCustomFieldFilterInputType!]`](#workitemwidgetcustomfieldfilterinputtype) | GitLab 17.10で**導入**。**状態**: 実験。カスタムフィールドでフィルタリングします。 |
| <a id="boardepicancestorsiid"></a>`iid` | [`ID`](#id) | エピックのIID（1など）。 |
| <a id="boardepicancestorsiidstartswith"></a>`iidStartsWith` | [`String`](#string) | エピックをオートコンプリート用にIIDでフィルタリングします。 |
| <a id="boardepicancestorsiids"></a>`iids` | [`[ID!]`](#id) | エピックのIIDのリスト（`[1, 2]`など）。 |
| <a id="boardepicancestorsin"></a>`in` | [`[IssuableSearchableField!]`](#issuablesearchablefield) | 検索を実行するフィールドを指定します。デフォルトは`[TITLE, DESCRIPTION]`です。`search`引数が必要です。 |
| <a id="boardepicancestorsincludeancestorgroups"></a>`includeAncestorGroups` | [`Boolean`](#boolean) | 祖先グループのエピックを含めます。 |
| <a id="boardepicancestorsincludedescendantgroups"></a>`includeDescendantGroups` | [`Boolean`](#boolean) | 子孫グループのエピックを含めます。 |
| <a id="boardepicancestorslabelname"></a>`labelName` | [`[String!]`](#string) | エピックをラベルでフィルタリングします。 |
| <a id="boardepicancestorsmilestonetitle"></a>`milestoneTitle` | [`String`](#string) | エピックをエピックのイシューから算出されるマイルストーンのタイトルでフィルタリングします。 |
| <a id="boardepicancestorsmyreactionemoji"></a>`myReactionEmoji` | [`String`](#string) | 現在のユーザーが適用したリアクション絵文字でフィルタリングします。 |
| <a id="boardepicancestorsnot"></a>`not` | [`NegatedEpicFilterInput`](#negatedepicfilterinput) | 否定条件となるエピック引数。 |
| <a id="boardepicancestorsor"></a>`or` | [`UnionedEpicFilterInput`](#unionedepicfilterinput) | 引数のリストのインクルーシブOR結合。 |
| <a id="boardepicancestorssearch"></a>`search` | [`String`](#string) | タイトルまたは説明の検索クエリ。 |
| <a id="boardepicancestorssort"></a>`sort` | [`EpicSort`](#epicsort) | エピックをソート順に一覧表示します。 |
| <a id="boardepicancestorsstate"></a>`state` | [`EpicState`](#epicstate) | エピックを状態でフィルタリングします。 |
| <a id="boardepicancestorssubscribed"></a>`subscribed` | [`SubscriptionStatus`](#subscriptionstatus) | 現在のユーザーがサブスクライブしているエピック。 |
| <a id="boardepicancestorstimeframe"></a>`timeframe` | [`Timeframe`](#timeframe) | 指定された期間とオーバーラップするアイテムを一覧表示します。 |
| <a id="boardepicancestorstoplevelhierarchyonly"></a>`topLevelHierarchyOnly` | [`Boolean`](#boolean) | トップレベル階層でエピックをフィルタリングします。 |
| <a id="boardepicancestorsupdatedafter"></a>`updatedAfter` | [`Time`](#time) | 指定日付より後に更新されたエピック。 |
| <a id="boardepicancestorsupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | 指定日付より前に更新されたエピック。 |

##### `BoardEpic.children`

エピックの子（サブエピック）。

[`EpicConnection`](#epicconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="boardepicchildrenauthorusername"></a>`authorUsername` | [`String`](#string) | エピックを作成者でフィルタリングします。 |
| <a id="boardepicchildrenconfidential"></a>`confidential` | [`Boolean`](#boolean) | 指定された機密性でエピックをフィルタリングします。 |
| <a id="boardepicchildrencreatedafter"></a>`createdAfter` | [`Time`](#time) | 指定日付より後に作成されたエピック。 |
| <a id="boardepicchildrencreatedbefore"></a>`createdBefore` | [`Time`](#time) | 指定日付より前に作成されたエピック。 |
| <a id="boardepicchildrencustomfield"></a>`customField` {{< icon name="warning-solid" >}} | [`[WorkItemWidgetCustomFieldFilterInputType!]`](#workitemwidgetcustomfieldfilterinputtype) | GitLab 17.10で**導入**。**状態**: 実験。カスタムフィールドでフィルタリングします。 |
| <a id="boardepicchildreniid"></a>`iid` | [`ID`](#id) | エピックのIID（1など）。 |
| <a id="boardepicchildreniidstartswith"></a>`iidStartsWith` | [`String`](#string) | エピックをオートコンプリート用にIIDでフィルタリングします。 |
| <a id="boardepicchildreniids"></a>`iids` | [`[ID!]`](#id) | エピックのIIDのリスト（`[1, 2]`など）。 |
| <a id="boardepicchildrenin"></a>`in` | [`[IssuableSearchableField!]`](#issuablesearchablefield) | 検索を実行するフィールドを指定します。デフォルトは`[TITLE, DESCRIPTION]`です。`search`引数が必要です。 |
| <a id="boardepicchildrenincludeancestorgroups"></a>`includeAncestorGroups` | [`Boolean`](#boolean) | 祖先グループの子エピックを含めます。 |
| <a id="boardepicchildrenincludedescendantgroups"></a>`includeDescendantGroups` | [`Boolean`](#boolean) | 子孫グループのエピックを含めます。 |
| <a id="boardepicchildrenlabelname"></a>`labelName` | [`[String!]`](#string) | エピックをラベルでフィルタリングします。 |
| <a id="boardepicchildrenmilestonetitle"></a>`milestoneTitle` | [`String`](#string) | エピックをエピックのイシューから算出されるマイルストーンのタイトルでフィルタリングします。 |
| <a id="boardepicchildrenmyreactionemoji"></a>`myReactionEmoji` | [`String`](#string) | 現在のユーザーが適用したリアクション絵文字でフィルタリングします。 |
| <a id="boardepicchildrennot"></a>`not` | [`NegatedEpicFilterInput`](#negatedepicfilterinput) | 否定条件となるエピック引数。 |
| <a id="boardepicchildrenor"></a>`or` | [`UnionedEpicFilterInput`](#unionedepicfilterinput) | 引数のリストのインクルーシブOR結合。 |
| <a id="boardepicchildrensearch"></a>`search` | [`String`](#string) | タイトルまたは説明の検索クエリ。 |
| <a id="boardepicchildrensort"></a>`sort` | [`EpicSort`](#epicsort) | エピックをソート順に一覧表示します。 |
| <a id="boardepicchildrenstate"></a>`state` | [`EpicState`](#epicstate) | エピックを状態でフィルタリングします。 |
| <a id="boardepicchildrensubscribed"></a>`subscribed` | [`SubscriptionStatus`](#subscriptionstatus) | 現在のユーザーがサブスクライブしているエピック。 |
| <a id="boardepicchildrentimeframe"></a>`timeframe` | [`Timeframe`](#timeframe) | 指定された期間とオーバーラップするアイテムを一覧表示します。 |
| <a id="boardepicchildrentoplevelhierarchyonly"></a>`topLevelHierarchyOnly` | [`Boolean`](#boolean) | トップレベル階層でエピックをフィルタリングします。 |
| <a id="boardepicchildrenupdatedafter"></a>`updatedAfter` | [`Time`](#time) | 指定日付より後に更新されたエピック。 |
| <a id="boardepicchildrenupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | 指定日付より前に更新されたエピック。 |

##### `BoardEpic.currentUserTodos`

現在のユーザーのto-doアイテム。

[`TodoConnection!`](#todoconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="boardepiccurrentusertodosstate"></a>`state` | [`TodoStateEnum`](#todostateenum) | to-doアイテムの状態。 |

##### `BoardEpic.linkedWorkItems`

エピックにリンクされた作業アイテム。

[`LinkedWorkItemTypeConnection`](#linkedworkitemtypeconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="boardepiclinkedworkitemsfilter"></a>`filter` | [`WorkItemRelatedLinkType`](#workitemrelatedlinktype) | リンクのタイプでフィルタリングします。サポートされている値: RELATED、BLOCKED_BY、BLOCKS。省略すると、すべてのタイプが返されます。 |

##### `BoardEpic.notes`

このnoteableに関するすべてのノート。

[`NoteConnection!`](#noteconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、および`last: Int`の4つを、標準[ページネーション引数](#pagination-arguments)として受け入れます。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="boardepicnotesfilter"></a>`filter` | [`NotesFilterType`](#notesfiltertype) | ノートコレクションのタイプ:ALL_NOTES、ONLY_COMMENTS、ONLY_ACTIVITY。 |

##### `BoardEpic.reference`

エピックの内部参照。デフォルトでは短縮形式で返されます。

[`String!`](#string)を返します。

###### 引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="boardepicreferencefull"></a>`full` | [`Boolean`](#boolean) | 参照をフルで返すかどうかを示します。 |

### `BoardEpicUserPreferences`

ボードエピックのユーザープリファレンスを表します。

#### フィールド

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="boardepicuserpreferencescollapsed"></a>`collapsed` | [`Boolean!`](#boolean) | エピックを折りたたんで表示するかどうか