**Note:** This file is automatically generated. Please see the [developer
documentation](doc/development/changelog.md) for instructions on adding your own
entry.

## 18.1.1 (2025-06-24)

### Security (5 changes)

- [Fix guest permissions for incident hierarchy updates](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f3cd30dec5fc9123ce7afecc5f94d74b4083f7cf) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5078))
- [Fix the validation logic for IDP Certificate Fingerprint](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f53497ee0ff29b45f4a3698a7085d036891afbe2) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5081))
- [Checking if framework and project have same namespace](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e328730a2b5373b3b400d734b1d6ac3cdb436b19) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5075))
- [Fix incorrect role grant after a user access_request](https://gitlab.com/gitlab-org/security/gitlab/-/commit/cb1b44753248959f3738c502570148cd6ad43059) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5077))
- [Prevent anonymous users from creating uploads](https://gitlab.com/gitlab-org/security/gitlab/-/commit/6e8cee2e35a2f61c610b95569b76ac74d546455a) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5076))

## 18.1.0 (2025-06-18)

### Added (182 changes)

- [Update yaml with branch patterns](https://gitlab.com/gitlab-org/gitlab/-/commit/2ce0ac184a6644496b6ed97db1a155984cba2ca3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193441)) **GitLab Enterprise Edition**
- [Show warning for incidents dragging on status list](https://gitlab.com/gitlab-org/gitlab/-/commit/7aaa20fe6b9ccabe78f6f127e8b10c6213679a7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193563))
- [Configure web_based_commit_signing_enabled with group update endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/50a1c2bc28f1c12b45274c750e68206125fb6b8d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193928)) **GitLab Enterprise Edition**
- [Extracts logic for Pipeline Secret Detection into its own feature card](https://gitlab.com/gitlab-org/gitlab/-/commit/b8c283030b543d87ae62797dfb59c1f54eb7b4bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194103))
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/da28142b6e18617a080dee0924cab70fd32910e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193853))
- [Remove experiment flag from CiLint mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/aac08a48dcf18fbd420f76216a7b9a33b1990980) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194599))
- [New UI for the personal access tokens in the profile settings](https://gitlab.com/gitlab-org/gitlab/-/commit/e5394a7d66393d4881e6ebbcc1e3c96e30ea886a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194582))
- [Add group and project transferred analyzers status event handlers](https://gitlab.com/gitlab-org/gitlab/-/commit/10a79d0acae3cab9c8a8923a598c0ef310868fcb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192449)) **GitLab Enterprise Edition**
- [Enable accessible_code_owners_validation feature by default](https://gitlab.com/gitlab-org/gitlab/-/commit/f361f959dfd8f4e152a92fc8cb6cec03fbb764dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194496)) **GitLab Enterprise Edition**
- [Add setting for bypassing placeholder email confirmation](https://gitlab.com/gitlab-org/gitlab/-/commit/38b3dd1dc1f8582489bf3c74fb669d8d0298b9c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189546)) **GitLab Enterprise Edition**
- [Clean up duo_workflow_commit_tools feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/62e708f3761f60e5a0bc3349388138afb3c1c0ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194486)) **GitLab Enterprise Edition**
- [Add work items display settings to user preferences](https://gitlab.com/gitlab-org/gitlab/-/commit/f99042538ab1cc62c0222d30fbd9cfa9a4751aac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193878))
- [Move the zoekt indexing timeout to the application setting](https://gitlab.com/gitlab-org/gitlab/-/commit/7fefc2e01f79f2b48446058030ba534af597ccf3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194297)) **GitLab Enterprise Edition**
- [Add marked_for_deletion field to Projects GraphQL query](https://gitlab.com/gitlab-org/gitlab/-/commit/fbb60e4f9e7f086d0e3e9546f32b6030e82b5974) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193696))
- [WIP Add toggle for new violations view](https://gitlab.com/gitlab-org/gitlab/-/commit/b0091695cd0843e4bae98d2012201b711cfa8c89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193226)) **GitLab Enterprise Edition**
- [Implement `DELETE /Groups/:id` SCIM endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/91864e91e0f8a5e4868b53c51b98305a46d2d94b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192421)) **GitLab Enterprise Edition**
- [Implement grouping for new adherence report](https://gitlab.com/gitlab-org/gitlab/-/commit/ccb2135f4d7300fe5abd9cb5e47d7f6a19e3c049) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193794)) **GitLab Enterprise Edition**
- [Graphql query for controls coverage](https://gitlab.com/gitlab-org/gitlab/-/commit/8e496e01af42c208b38a1ab1f470f97a6c741f0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192880)) **GitLab Enterprise Edition**
- [Add zoekt node services](https://gitlab.com/gitlab-org/gitlab/-/commit/91efe37e0bf253740f497cfc9c61c9acf6146d31) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192789)) **GitLab Enterprise Edition**
- [Add a worker to update minimum override role](https://gitlab.com/gitlab-org/gitlab/-/commit/b643f313f64b8508686eb87d59fd8cb9ea177347) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188932))
- [Show icons on status lists](https://gitlab.com/gitlab-org/gitlab/-/commit/ebfe58dd27f641446609c2533079b626ca374e6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193966))
- [Implement compliance requirement status hover popup](https://gitlab.com/gitlab-org/gitlab/-/commit/f7b5080207ba8ae313efc9b9f09e03246e3239f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188369)) **GitLab Enterprise Edition**
- [Add GraphQL mutation for updating lifecycles](https://gitlab.com/gitlab-org/gitlab/-/commit/525379752a5fb9c8510ad65cf3786afa383ffb32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192988)) **GitLab Enterprise Edition**
- [Add "select all" button to inputs selector](https://gitlab.com/gitlab-org/gitlab/-/commit/5da173963db25688d41b3fd1cfe29c031270f696) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194077))
- [Add Modal for User Cap settings change](https://gitlab.com/gitlab-org/gitlab/-/commit/2846288ed78915b0c78a069622319b0ecf79f3f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184460)) **GitLab Enterprise Edition**
- [Add missing filters for: Cadence, Iteration](https://gitlab.com/gitlab-org/gitlab/-/commit/695025d8b9f5d168b23a6bb43a7963ffdf538e0c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193448)) **GitLab Enterprise Edition**
- [Personal and Group access token support for new virtual registry scopes](https://gitlab.com/gitlab-org/gitlab/-/commit/ea19b786b6c8b0ebfe943eafd6d98d70b8be522f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189792))
- [Add custom fields filtering to work items list view](https://gitlab.com/gitlab-org/gitlab/-/commit/8f5df65c6d7e18da4c2842a2cd880585e9b4c68a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193834)) **GitLab Enterprise Edition**
- [Allow creation of Prometheus-type HTTP integrations in GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/7ef168efbf9de62f3595c562f6a69c18a5b8d9a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/120197))
- [Add ability to copy the selected ref](https://gitlab.com/gitlab-org/gitlab/-/commit/260aec07f103d35ab88aa3e42bbd35d54c042c06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193724))
- [Create column and setting for confirmation bypass](https://gitlab.com/gitlab-org/gitlab/-/commit/e79f3880aa4019dd638396260e2cc65ec41bde78) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188810)) **GitLab Enterprise Edition**
- [Add an option to insert GLQL view in RTE](https://gitlab.com/gitlab-org/gitlab/-/commit/27a1f387abeeecd849489e6299c3c79ceafb5b40) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194156))
- [Graphql api for listing project compliance violations](https://gitlab.com/gitlab-org/gitlab/-/commit/268d8bd6a426665c9797cae3e13423682da1e0eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192606)) **GitLab Enterprise Edition**
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/c10f840361b24b8e7db92c25655b860b97f0dbba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193854))
- [Add author role badge to Wiki notes](https://gitlab.com/gitlab-org/gitlab/-/commit/362e46e2d6ea3e34ce5e873bd069cd190fcd2e32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194142))
- [Use existing Namespaces::WorkItemsResolver on namespace](https://gitlab.com/gitlab-org/gitlab/-/commit/7184188fa50466ed709206719f18e9e98cb44dde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193714))
- [Support minimum language server client restriction](https://gitlab.com/gitlab-org/gitlab/-/commit/fc2cc87ce811685cc7884af69f22081a2d261608) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193642))
- [Graphql query for framework coverage summary](https://gitlab.com/gitlab-org/gitlab/-/commit/9f4ff6a8af06d4b6e8c7f9d7b1ed486f0b009f33) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192753)) **GitLab Enterprise Edition**
- [Reintroduce backfill migration for vulnerabilities ES index](https://gitlab.com/gitlab-org/gitlab/-/commit/a4905edda8374bf635537859279d2777d65bb441) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194116)) **GitLab Enterprise Edition**
- [Add wiki page subscription backend and GraphQL mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/4d478584807600e505149871df2be7ebf78421bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193342))
- [Create Duo Self-Hosted Provision Service Class](https://gitlab.com/gitlab-org/gitlab/-/commit/7e75d6925a40c576fe75232726d492d7e29361eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193352)) **GitLab Enterprise Edition**
- [Remove duplicated incidents from change failure rate](https://gitlab.com/gitlab-org/gitlab/-/commit/2a2a7111768de87b9b9adb4bb5f10b3ce95bc8d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193910)) **GitLab Enterprise Edition**
- [Add mention of the policy logs in PEP documentation](https://gitlab.com/gitlab-org/gitlab/-/commit/1bb4e120701f00bb74cdecc13cc039870ecfa309) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193800))
- [Remove connection types from CI lint mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/cea4d5c8633355561e73ed165656b882abe52021) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192782))
- [Expose container_scanning_for_registry_enabled in graphql](https://gitlab.com/gitlab-org/gitlab/-/commit/09663b677f09501283a466dd4f9f787c2e2b5456) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193450)) **GitLab Enterprise Edition**
- [Add health status and weight filter for WorkItem API ](https://gitlab.com/gitlab-org/gitlab/-/commit/d0872d58d03b902f1d2979356a479f3525b904a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193114))
- [Add UI for controlling variables restriction in pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/26d0e331e3012124a4bf79576b6d2b25309e4576) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190833))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/abb721e4e60676e516cb4bdb88f898cc0e2861ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194011))
- [Track event when fine-grained permissions are enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/50afb2b9c0265b69874f6398d1d9ad447747145a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192810))
- [New log and event for the adjustment service](https://gitlab.com/gitlab-org/gitlab/-/commit/3f65b7d17a342087631a1a637f0f2f5b81968fdd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192643)) **GitLab Enterprise Edition**
- [Step-up auth: Add support for `included` condition](https://gitlab.com/gitlab-org/gitlab/-/commit/b68d138de87ec673c959550509f99605f4c59cf0) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187491))
- [Allow to update value stream stages on GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/f3077c28bcc5e9ab8f18765bef6e7ac8739b0ce2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193524)) **GitLab Enterprise Edition**
- [Display runner creator and runner created_at within Runners API](https://gitlab.com/gitlab-org/gitlab/-/commit/6974adfdc1bac2b1724bce6b870645ce334a7a6b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191738))
- [Expose status details in the board list API](https://gitlab.com/gitlab-org/gitlab/-/commit/4486ab79fb29261d81de399e9510a6e8790ea355) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193841)) **GitLab Enterprise Edition**
- [Add rechability field to vulnerability index](https://gitlab.com/gitlab-org/gitlab/-/commit/bed4f8f8bca33a914d33815f894cbb47013dbb20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192619)) **GitLab Enterprise Edition**
- [Add ability to sort compliance frameworks](https://gitlab.com/gitlab-org/gitlab/-/commit/739ffb89109603cb7634fbe60d8369cdba5addd4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192560)) **GitLab Enterprise Edition**
- [Create new page for violation details](https://gitlab.com/gitlab-org/gitlab/-/commit/e751acf34d76e479c9829dd5e77a252e12d2ae40) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192686)) **GitLab Enterprise Edition**
- [Add Duo Context Exclusion settings GraphQL interface](https://gitlab.com/gitlab-org/gitlab/-/commit/37abb68e214523219633796f8e1c6da56b52a4d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192819))
- [Add "GET /groups/:id/saml_users" API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/d942843296c886aa9800de4bebda635653b485d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193748)) **GitLab Enterprise Edition**
- [Add filter `ALL` to cluster agents query](https://gitlab.com/gitlab-org/gitlab/-/commit/50c3a76fae60ff539f042a0fdcaf05bf8ed55422) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192329)) **GitLab Enterprise Edition**
- [Release OWASP 2021 grouping](https://gitlab.com/gitlab-org/gitlab/-/commit/13821750dd43595618a30f09cf0f76270a74f14b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192766)) **GitLab Enterprise Edition**
- [Add sorting to compliance_frameworks GraphQL field](https://gitlab.com/gitlab-org/gitlab/-/commit/a0aecb84c5cc79f80e41b0b7f8944a766d3905f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192475)) **GitLab Enterprise Edition**
- [Add Release, Contact, Organisation filters on WorkItems API](https://gitlab.com/gitlab-org/gitlab/-/commit/911cd90b94cd64b3c938074376d20be14119476b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192906))
- [feat: Introducing Labkit::Metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/4a71eb380049a8e381bde495945ddeafc4588077) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188302)) **GitLab Enterprise Edition**
- [Add conan delete package_revision endpoint for v2](https://gitlab.com/gitlab-org/gitlab/-/commit/c6586265313eee149b8edb358c27e03a582ce672) by @oceane_scania ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191910))
- [Add index to `sbom_graph_paths` for efficient EachBatch usage](https://gitlab.com/gitlab-org/gitlab/-/commit/5de136e6f5097b3f7f466bfa08f75debddda94ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193610))
- [Update pipeline inputs view](https://gitlab.com/gitlab-org/gitlab/-/commit/f862064b9115a52b35bd88d791d813c9e9199453) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193286))
- [Allow adding comments to project_compliance_violations](https://gitlab.com/gitlab-org/gitlab/-/commit/59fc3735fa7e81de0a9849286a45fe096439ecc3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193065)) **GitLab Enterprise Edition**
- [Add learn more button to the banner](https://gitlab.com/gitlab-org/gitlab/-/commit/906e932443412e7678273b42f12fd9ef322a1b0c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193573)) **GitLab Enterprise Edition**
- [Add packages_composer_packages database table](https://gitlab.com/gitlab-org/gitlab/-/commit/ea100a16ea7505e1ac99b004908ca39c22dbdc0d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186126))
- [Add index on provider, sync_status to ldap_admin_role_links table](https://gitlab.com/gitlab-org/gitlab/-/commit/c6bde1469358684405c18bb69b6962ccb77b8aa5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193554))
- [Query work item statuses for a namespace](https://gitlab.com/gitlab-org/gitlab/-/commit/8524f8987d1da8901857f8fd80642ceb72b98c2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191897)) **GitLab Enterprise Edition**
- [Cache and restore Work Item sidebar widgets during create](https://gitlab.com/gitlab-org/gitlab/-/commit/1a02ad8a0d7b9dba82a1d0a25a9cad2761da9d81) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192301))
- [Fix and requeue analyzer status backfill migration](https://gitlab.com/gitlab-org/gitlab/-/commit/6b597bec3ffc17ab6b2d5045e5e7458da0cc92ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193293)) **GitLab Enterprise Edition**
- [Drop 2 unused indexes](https://gitlab.com/gitlab-org/gitlab/-/commit/4ac59c6b59f386f606fc08ce8a6bcd603b75f533) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193504))
- [Add event and metric for GET groups/:id/enterprise_users](https://gitlab.com/gitlab-org/gitlab/-/commit/76ac4d9498214115bb30ef849bfaa14d3b80c66a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191615)) **GitLab Enterprise Edition**
- [Remove FF auto_enable_duo_core_settings](https://gitlab.com/gitlab-org/gitlab/-/commit/04edce4a00295e6ad67d508c149012e0eb2c9fe7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193438)) **GitLab Enterprise Edition**
- [Add branch pattern editor](https://gitlab.com/gitlab-org/gitlab/-/commit/bcab3a33424c6234f5d9ab08a8fac7fe0779e794) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193063)) **GitLab Enterprise Edition**
- [Expose policy options for runner jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/9e450d9b0e2e3983ebc173918206256ec9c9ea61) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193187)) **GitLab Enterprise Edition**
- [Add support for placeholder variables in markdown](https://gitlab.com/gitlab-org/gitlab/-/commit/147d21d4ea29b7da2efabb60d57d11fdc0bc3e0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186028))
- [Introduce LicensedFeatures field](https://gitlab.com/gitlab-org/gitlab/-/commit/5397562376e4183a48ecfd63162ec6ffc4831236) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192188))
- [Add oid column to lfs_objects_projects](https://gitlab.com/gitlab-org/gitlab/-/commit/a6df38c1ffd20935af1b513ae1c24ef8938e7ed2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192839))
- [Add AWS Secrets Manager Support](https://gitlab.com/gitlab-org/gitlab/-/commit/e7289eb8d688b7458fa61e4c73f8fd8d57fd3aab) by @DerAstronaut ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191780)) **GitLab Enterprise Edition**
- [Add pagination to a policy list](https://gitlab.com/gitlab-org/gitlab/-/commit/eac228e4489ea7393b359631c76d297eecb45672) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190376)) **GitLab Enterprise Edition**
- [Update work item titles to show html version](https://gitlab.com/gitlab-org/gitlab/-/commit/2bf359303c88f85edcf660505e200a732e3b4292) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187577))
- [Add Activatible concern for audit events](https://gitlab.com/gitlab-org/gitlab/-/commit/9279602f955525919765a3598bf072ccca6992ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190737)) **GitLab Enterprise Edition**
- [Enable security_policies_optional_variables_control by default](https://gitlab.com/gitlab-org/gitlab/-/commit/8827864cfac543024b0d3d47682b3620774587f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193282)) **GitLab Enterprise Edition**
- [Add a `jsonb` column to `vulnerability_exports` table](https://gitlab.com/gitlab-org/gitlab/-/commit/7a9481118043804cf9b389edfc51f96bca71689c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192895)) **GitLab Enterprise Edition**
- [Add license check for work item detail page](https://gitlab.com/gitlab-org/gitlab/-/commit/34eb3cda749d48ad608acd694000e6df2035b9b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192467))
- [Add sync info to admin role ldap sync table](https://gitlab.com/gitlab-org/gitlab/-/commit/8441ae61ab1aa86f2540949b060e5fc83d4ad4a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191695)) **GitLab Enterprise Edition**
- [Add migration to correct vulnerabilities transitioned by auto-resolve](https://gitlab.com/gitlab-org/gitlab/-/commit/9a27e91d317e371afa74be021b309391cfee57a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190859))
- [Update analyzer_namespace_status on project archive event](https://gitlab.com/gitlab-org/gitlab/-/commit/a6628782dc384efaa5527494d64d078bfd4b68ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191931)) **GitLab Enterprise Edition**
- [Add policy exceptions selector](https://gitlab.com/gitlab-org/gitlab/-/commit/191b43c7f01acba4f3b53616acd32d61c3ca99a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192723)) **GitLab Enterprise Edition**
- [Add name column to CI pipeline tables in ClickHouse](https://gitlab.com/gitlab-org/gitlab/-/commit/1a15cb572d6632f700ccb4a7b38ed710b19993d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190848))
- [Add runner tokens to validity checks](https://gitlab.com/gitlab-org/gitlab/-/commit/ec671e3818beb3af098eaf77a66ba90782b7dfde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192314)) **GitLab Enterprise Edition**
- [Hide CRM Contacts widget when source group has no contacts](https://gitlab.com/gitlab-org/gitlab/-/commit/654d2c2eb657565400faf2aebf79cb7abf01d41f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192935))
- [Created index for project violation for created](https://gitlab.com/gitlab-org/gitlab/-/commit/a45d6d070827bb0ea5b8fd7eeacd86e1e9a9cf10) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192746)) **GitLab Enterprise Edition**
- [Build dependency graphs after ingesting SBoM report](https://gitlab.com/gitlab-org/gitlab/-/commit/d5eabfecf1b5c95812446225c0e4d4aa22f881d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184472)) **GitLab Enterprise Edition**
- [Expose prometheus-type HTTP alert integrations in GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/0009bb74d4342f63b4e853b5a0a103a322b1e678) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129758))
- [Add created_by/updated_by to lifecycle and status](https://gitlab.com/gitlab-org/gitlab/-/commit/875763bd1095c9ed3b2b6cbf9be28591c8ab2ac4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192866)) **GitLab Enterprise Edition**
- [Add not_configured counter to AnalyzerGroupStatusType in graphql](https://gitlab.com/gitlab-org/gitlab/-/commit/2f4d627a04f87bafde23e7ba09d0a45433800117) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192207)) **GitLab Enterprise Edition**
- [Remove duo_code_review_multi_file feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/76fdd56e5359cf033f431aeb16382837ed3dca6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192762)) **GitLab Enterprise Edition**
- [Query work item lifecycles for a namespace](https://gitlab.com/gitlab-org/gitlab/-/commit/317b5c92fef13dff126f5482fd75ed3ab18463a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192196))
- [Support creating board lists with status values](https://gitlab.com/gitlab-org/gitlab/-/commit/8a7bb199fa5a24e462406c0ba64a27c0b76e8381) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189433)) **GitLab Enterprise Edition**
- [Enable version filtering by default](https://gitlab.com/gitlab-org/gitlab/-/commit/e6f56225ee250500044bffac540a45068daf6a63) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192291)) **GitLab Enterprise Edition**
- [Adding glab CLI event tracking](https://gitlab.com/gitlab-org/gitlab/-/commit/975a25c811298c8cc2fdf4d3b7ae433bc453e597) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190595))
- [Add status list filtering in issue boards](https://gitlab.com/gitlab-org/gitlab/-/commit/98fa3a63a69401eec465b14c180c2bf2daaa74cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191720))
- [Add lazy-load to projects & requirements section](https://gitlab.com/gitlab-org/gitlab/-/commit/c4ca27859f3abd2c970745aeee87a96a940bcf8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192613)) **GitLab Enterprise Edition**
- [Add group delete event handler](https://gitlab.com/gitlab-org/gitlab/-/commit/236605dc031e1450c9c0bb656656308e8aa7e317) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191189)) **GitLab Enterprise Edition**
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/6a4d3c948fde71a3b97c4aaed6dd6703708fb982) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192608))
- [Enable group hierarchy lookup optimization](https://gitlab.com/gitlab-org/gitlab/-/commit/2d4b28fc0e08c7b30930467ed1868358312e14db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188379))
- [Display only project-specific data in project compliance center](https://gitlab.com/gitlab-org/gitlab/-/commit/e875cb96611aeda872f64fad86630db4fb0348a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192598)) **GitLab Enterprise Edition**
- [Add project_count field to User type in Graphql](https://gitlab.com/gitlab-org/gitlab/-/commit/d1c2fcfd74a9575590d90703eaf8cb42c3c42ab9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191450))
- [Configure delete_limit of async delete pipelines for deleted triggers](https://gitlab.com/gitlab-org/gitlab/-/commit/e4b0b6db4836bcb40500462f6a4b4438a4a67dda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192206))
- [Paginate requirements in framework edit sectino](https://gitlab.com/gitlab-org/gitlab/-/commit/f17a4bfd2babdd36512d91f4c135ceb9024922af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192403)) **GitLab Enterprise Edition**
- [Add project_id index on p_ci_pipeline_variables](https://gitlab.com/gitlab-org/gitlab/-/commit/dbd7f6e44cd631eb42dbe9d2365e387d37fa8191) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191736))
- [Adding documentation for Experimental Feature](https://gitlab.com/gitlab-org/gitlab/-/commit/78149c8d4327d0f2a8f32860965737e0b5cca6b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191104))
- [Small UI changes for long status names](https://gitlab.com/gitlab-org/gitlab/-/commit/a506573b2f3aa883039441ca13fa94d900b0e0b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192462)) **GitLab Enterprise Edition**
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/f662f9b23f702298812320c60b368a82a163568c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192458))
- [Adds groupRunnersEnabled to CiCdSettings GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/19b7deecd3148655a8eb5ebcb1d1ca346aebe523) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192202))
- [Add knowledge graph models](https://gitlab.com/gitlab-org/gitlab/-/commit/adb9697105d13e8530516292e561ad231885a64f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191162)) **GitLab Enterprise Edition**
- [Add namespace analyzer status alignment service](https://gitlab.com/gitlab-org/gitlab/-/commit/537e53011a34c1e5ceb1753bffe98aad4c8ecf97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189363)) **GitLab Enterprise Edition**
- [Allows users to bulk pause/unpause runners in runner lists](https://gitlab.com/gitlab-org/gitlab/-/commit/bdf0713c958bd67d780e6e3dad9ab74f0797773e) by @tonton1728 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187903))
- [Call create mutation when admin role LDAP sync form is submitted](https://gitlab.com/gitlab-org/gitlab/-/commit/9e6fce71ec06998181e5f75df757dc0bb8a19173) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191420)) **GitLab Enterprise Edition**
- [Evaluate project statuses on requirement update](https://gitlab.com/gitlab-org/gitlab/-/commit/63b7004a5755fafbb9945b412c8c560e6b1a4c68) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187512)) **GitLab Enterprise Edition**
- [Email/banner when compromised password is detected](https://gitlab.com/gitlab-org/gitlab/-/commit/08c4ee0ae9e29d692de57705c927b14c65d194a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191921)) **GitLab Enterprise Edition**
- [Add top_namespace_model_ref logic to request](https://gitlab.com/gitlab-org/gitlab/-/commit/6518a77380b51054f47df862563a7170042b8e0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191475)) **GitLab Enterprise Edition**
- [Code Context: use new unit prmitive](https://gitlab.com/gitlab-org/gitlab/-/commit/f36db6894bf37c28bce020696bdda4c64d4ee95e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191919)) **GitLab Enterprise Edition**
- [Add updatedAt field to graphql analyzer statuses types](https://gitlab.com/gitlab-org/gitlab/-/commit/fb99200bf1e040bfeb12bca8fd9ca1e7d7b13693) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192198)) **GitLab Enterprise Edition**
- [Add DuoWorkflowAction to GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/3a7a7bb0233ceed22feed67737a2ca429ac6462f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191303)) **GitLab Enterprise Edition**
- [Add role dropdown to LDAP admin role sync form](https://gitlab.com/gitlab-org/gitlab/-/commit/a63e172f9b4979600548429ba67719413ec453df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191139)) **GitLab Enterprise Edition**
- [Show work item status badge in issue cards](https://gitlab.com/gitlab-org/gitlab/-/commit/7dd9347e8356079fdfa956ae9ce9b096359d1433) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191151))
- [Add csp_namespace_id to application settings](https://gitlab.com/gitlab-org/gitlab/-/commit/7922bf711c6c7b4eca134932a707c8f00c2fd26d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191298)) **GitLab Enterprise Edition**
- [Add script to create AI context migration files](https://gitlab.com/gitlab-org/gitlab/-/commit/92087a50c60fbb52bfaaa2427db5158dec70c8d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191791))
- [Pages live block](https://gitlab.com/gitlab-org/gitlab/-/commit/f725b0cd7220978fc487e3e98dd6a6b0e56c2adf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191809))
- [Updated resource_spec file](https://gitlab.com/gitlab-org/gitlab/-/commit/ccb7109080643ec0870732b8480780df4a17e62c) by @Syandell ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192092))
- [Add deploy token support to Validity checks](https://gitlab.com/gitlab-org/gitlab/-/commit/3fd5d5295c1af7c14aafc5127d1cdb1966bdb995) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187802)) **GitLab Enterprise Edition**
- [ActiveContext: add code embedding files](https://gitlab.com/gitlab-org/gitlab/-/commit/3377d9cd8d423a0f99dfe2cc4cc91a0223f39844) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190313)) **GitLab Enterprise Edition**
- [Add project_compliance_violations DB table](https://gitlab.com/gitlab-org/gitlab/-/commit/457cc8db280f361896232b89d56cf83379a96627) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191311)) **GitLab Enterprise Edition**
- [Add findingTokenStatus to Vulnerability GraphQL type](https://gitlab.com/gitlab-org/gitlab/-/commit/771305bdeae681fcf987f2d1d525d103a2357199) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190440)) **GitLab Enterprise Edition**
- [Protected packages: Generic package push protection](https://gitlab.com/gitlab-org/gitlab/-/commit/b9cf4a11ad09cb99940be2bd87875cabc6ebc0c7) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189435))
- [Add GitHub username to user profile](https://gitlab.com/gitlab-org/gitlab/-/commit/ebdabf763283691dc1c2d26f936e93e68fedc823) by @bufferoverflow ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190014))
- [Introduced policy for Duo Agentic Chat availability](https://gitlab.com/gitlab-org/gitlab/-/commit/e27cf22db0b65d499908771672af6a52208a0557) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191327)) **GitLab Enterprise Edition**
- [Add status widget definition to issue work item type](https://gitlab.com/gitlab-org/gitlab/-/commit/100925332bfd4fb2204f4832f7a437f2a84dc922) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189786))
- [Allow agent CI access sharing across top level groups](https://gitlab.com/gitlab-org/gitlab/-/commit/b1c81e29a83b203415d9c415d84e694aceb39437) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190769))
- [Add Irish to llist of selectable languages in the UI](https://gitlab.com/gitlab-org/gitlab/-/commit/76506506e58d5758d65000b3294c35c7f7ee95fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191651))
- [Make groups GraphQL query countable and add `active` argument](https://gitlab.com/gitlab-org/gitlab/-/commit/030ef93f8710fb5220aa59e8f0b4af5ba5b670c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191398))
- [Remove track_sidekiq_concurrency_limit_execution FF](https://gitlab.com/gitlab-org/gitlab/-/commit/5761e5c90a675b436ae2ce33eebd27a8711178ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191735))
- [Remove gitlab_managed_cluster_resources feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/7c583424bdf53485cc3141e5bb98087cf3744cfa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191718))
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/485422d6051fdd3aed5f4ab1067673e1842366ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191714))
- [Add active column to audit event streaming destination tables](https://gitlab.com/gitlab-org/gitlab/-/commit/85371d8613a498dd49f3dc74aa025b63621c45e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191352)) **GitLab Enterprise Edition**
- [Sync group_push_rules on push_rules write operations](https://gitlab.com/gitlab-org/gitlab/-/commit/73968b211e8489b593df8c8046d7accfbe1c2361) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188143))
- [Add API endpoint to retrieve Conan package revisions](https://gitlab.com/gitlab-org/gitlab/-/commit/d5ce47a3f9d41746385b9e11e8d663279ad09fd8) by @mbo5be ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189380))
- [Add conan delete recipe_revision endpoint for v2](https://gitlab.com/gitlab-org/gitlab/-/commit/1659f1b3185b21011bd88db7eda3655ae88ed60b) by @mbo5be ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186073))
- [GraphQL: Allow retrieving pending jobs compatible with runner](https://gitlab.com/gitlab-org/gitlab/-/commit/d991ff886453569fe3f43f6a9ab73bb910875e75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191130))
- [Add FK on project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/4db3dceff24cb8116242829534cbe1613ef0da46) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191546))
- [Add CompromisedPasswordDetection model and service](https://gitlab.com/gitlab-org/gitlab/-/commit/f0a50f2abd6733c24c6411de43c5e1f2cd90c21a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191112)) **GitLab Enterprise Edition**
- [Add "imported" field to WorkItemType](https://gitlab.com/gitlab-org/gitlab/-/commit/8da21cb86c5c98fe49581cba04b8c6bb2e9c36ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191494))
- [Add ability to filter project and group issues by status](https://gitlab.com/gitlab-org/gitlab/-/commit/fdc51e5cbc9210ff18df731ff6abed37d86e458d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189870))
- [Create index on MRDC synchronously](https://gitlab.com/gitlab-org/gitlab/-/commit/344b413592f00421fa7691dd321ebb9bc6acb031) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191446))
- [Add sync method radios to LDAP create sync form](https://gitlab.com/gitlab-org/gitlab/-/commit/037b21ce820b389810f97759b731e1588f2675b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190929)) **GitLab Enterprise Edition**
- [Add ServerFormGroup for admin role ldap sync form](https://gitlab.com/gitlab-org/gitlab/-/commit/6b32ffc8574473152d9d4f528b082b0147c409be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191164)) **GitLab Enterprise Edition**
- [Filter by access_levels in projects members GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/ec3f042f90ee5fd28d687cff3e40bf1129c58546) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190924))
- [Add bypass option widget](https://gitlab.com/gitlab-org/gitlab/-/commit/5d54d76f23957a2bc2241b7b8881f202a015156f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191160)) **GitLab Enterprise Edition**
- [Add group archived abilities policy](https://gitlab.com/gitlab-org/gitlab/-/commit/d8c427861a92d4fb0dfb24967359923f9e044c85) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188742))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/9861466794a4eb9570ee318ae1d3d56491f31538) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191367))
- [Use Elasticsearch to fetch vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/b82b38b429c9298030b59a7d92926b3167f6d6ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190673)) **GitLab Enterprise Edition**
- [Add the zoekt setting to control parallel processes](https://gitlab.com/gitlab-org/gitlab/-/commit/33014e3157bb92071e095f515419901845407a85) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191283)) **GitLab Enterprise Edition**
- [Translucent glass utility: Add option to pass bg color](https://gitlab.com/gitlab-org/gitlab/-/commit/420af7320347ecb651dc66b9a8d041c47806ed02) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191133))
- [Protected packages: Helm chart push protection](https://gitlab.com/gitlab-org/gitlab/-/commit/8f778b6bc3cd26d94a4f9cb79beb9488d7ce00bd) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189801))
- [Refactor the Ci::Trigger.last_used](https://gitlab.com/gitlab-org/gitlab/-/commit/e3c62ced38005c2fec955b39b33dd6379ed5ad5a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191124))
- [Use ES to fetch identifier names](https://gitlab.com/gitlab-org/gitlab/-/commit/9cc26b5e6849c704626cd8d3097366fb0dd4561f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189627)) **GitLab Enterprise Edition**
- [Updating Learn Gitlab with Get Familiar section](https://gitlab.com/gitlab-org/gitlab/-/commit/4f53f36cc7b93e096ea3d18fe97377e8f117b3c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190915)) **GitLab Enterprise Edition**
- [Fill project analyzer build_id column post pipeline execution](https://gitlab.com/gitlab-org/gitlab/-/commit/5eab5fed0e7637eda3de6d3eaa57a6d60967868d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191197)) **GitLab Enterprise Edition**
- [Use ES to fetch severity counts](https://gitlab.com/gitlab-org/gitlab/-/commit/fe4a66a03b169eaa47f3cccd64ad33e33444ae82) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188597)) **GitLab Enterprise Edition**
- [Backfill software_license_policies with custom licenses](https://gitlab.com/gitlab-org/gitlab/-/commit/17af9ac835eb78080833645d0ced997e33f86f60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190394)) **GitLab Enterprise Edition**
- [Add GraphQL mutation to assign or unassign projects to a runner](https://gitlab.com/gitlab-org/gitlab/-/commit/02fa9f8f31ad8a12e5c762fceb35f79e10a04b08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189579))
- [Show default selected status when creating a work item](https://gitlab.com/gitlab-org/gitlab/-/commit/155f606641c6e81e202bbf804cad441566d806f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190662)) **GitLab Enterprise Edition**
- [Remove cluster_agent_migrations feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/762d27780454d1b898c6b5f0b297f58a03144916) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190626))
- [Remove autocomplete_users_rate_limit FF](https://gitlab.com/gitlab-org/gitlab/-/commit/3ffe16584c4b799fedb32c1f1b9637cfb3b43cef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189015))
- [Extend the existing package license to](https://gitlab.com/gitlab-org/gitlab/-/commit/d935664b967af4d3e503b91d1ae8c4a60aff85df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186258)) **GitLab Enterprise Edition**
- [Add merged date to work item  MR items](https://gitlab.com/gitlab-org/gitlab/-/commit/a8dc3056ea0dd6e170b777952bb816e96568f457) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190742))

### Fixed (204 changes)

- [Fix Value Stream form restore defaults button](https://gitlab.com/gitlab-org/gitlab/-/commit/4b16a7602e85569388429879a814e1b8a74f4cbf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194074)) **GitLab Enterprise Edition**
- [Fix link to the docs page to create project with "git push"](https://gitlab.com/gitlab-org/gitlab/-/commit/3d4e9b7b965dc62a411ad9a09a07ddbf8d636bbb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193998))
- [Fix ref selector branch list](https://gitlab.com/gitlab-org/gitlab/-/commit/7825aea1c73912c7b537759b8ecba71e8c18397c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194570))
- [Only show restore link on project listing when pending deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/31222e087337ffe9ed34484835ea2e2380d5d63e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194534))
- [Make all scanner variables additional variables](https://gitlab.com/gitlab-org/gitlab/-/commit/e9fa61f5f781f88db55cabc427e516b85cfa76e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193522)) **GitLab Enterprise Edition**
- [Ensure overage modal appears for Projects](https://gitlab.com/gitlab-org/gitlab/-/commit/eaf8a4b269ad261319f71b692f174f0b1eec54dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192949))
- [Add data points to Value Stream Analytics overview chart](https://gitlab.com/gitlab-org/gitlab/-/commit/3a0c9e1f237bb9d0693ebf71919ec32929293532) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194497)) **GitLab Enterprise Edition**
- [Handle situation where match line is after target line](https://gitlab.com/gitlab-org/gitlab/-/commit/955a328194a75146dda66de34ca93496ec6c8c97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194243))
- [Fix stuck mirrors logic](https://gitlab.com/gitlab-org/gitlab/-/commit/0ad32c7903f3ca5051593a6337e229a6364eda35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194478)) **GitLab Enterprise Edition**
- [Fix PowerShell variable expansion in Windows release scripts](https://gitlab.com/gitlab-org/gitlab/-/commit/4f529d8786afb882d0ce78a14b506a64b70cd026) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194450))
- [Make `any_merge_request` approval policy rules respect branch spec](https://gitlab.com/gitlab-org/gitlab/-/commit/fade41e234b86f52137d0be7becf89d7f8070a6f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191989)) **GitLab Enterprise Edition**
- [Issue boards: Fix a11y issues](https://gitlab.com/gitlab-org/gitlab/-/commit/d99122306a5a5349b2e37fc2c4289ff82e64cdd4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194170))
- [Activity lists: List should be marked as such (a11y fix)](https://gitlab.com/gitlab-org/gitlab/-/commit/83e0a3afa6dbb0fc82b82238deb9539539fadef0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194435))
- [Pipeline editor visualize tab: Fix a11y issue with heading](https://gitlab.com/gitlab-org/gitlab/-/commit/7d9ddd64eb66e0f609bb4bf9db93542479f741cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194429))
- [Fix wrong check on displaying passed status in popup](https://gitlab.com/gitlab-org/gitlab/-/commit/5c1039830f28251d6708957ff9d9df5e3b9a5648) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194421)) **GitLab Enterprise Edition**
- [Restrict adding a forward slash to node name](https://gitlab.com/gitlab-org/gitlab/-/commit/8ff2a30b41d691891f4fc827cd7c4e5d44d7e3db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191833)) **GitLab Enterprise Edition**
- [Fix stop button in MR widget](https://gitlab.com/gitlab-org/gitlab/-/commit/188529ecd18d4ec12cc45fad3b11008ebccd7bfd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194317))
- [Disable using glab for CI release](https://gitlab.com/gitlab-org/gitlab/-/commit/715a8311fa838f395fc48ae29c1c3c3d57d12b25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194341))
- [Maintain label sorting when LabelLinks exist on Epic and WorkItem](https://gitlab.com/gitlab-org/gitlab/-/commit/39d7656f6b0cb7e117d89016469c351022ec1770) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194227))
- [File diff: Fix border radius issue with lighter syntax themes](https://gitlab.com/gitlab-org/gitlab/-/commit/aae2e3124d8eeb8e6ad3a0642705deada187b8c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194312))
- [Backfill placeholder users that miss an organization](https://gitlab.com/gitlab-org/gitlab/-/commit/8da4cee10b76b89ed19667cb0f524dedce2d6163) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193458))
- [Fix security policy sync workers to use string keys for params](https://gitlab.com/gitlab-org/gitlab/-/commit/c953d9c1918f0c1867f9475ead935d673d089c89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194173)) **GitLab Enterprise Edition**
- [Fix uppercase secret detection report type](https://gitlab.com/gitlab-org/gitlab/-/commit/797ecbcf1277e97c23c88a121fc52c993811dd81) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194253)) **GitLab Enterprise Edition**
- [Make selected only toggle use backend for filtering](https://gitlab.com/gitlab-org/gitlab/-/commit/6ed1bacff11dbfd1bf681e5295faa5b4e9bcbf90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194174)) **GitLab Enterprise Edition**
- [Identify error for scope value field in issue boards](https://gitlab.com/gitlab-org/gitlab/-/commit/7512069162868d9dd413ae1caad56688934e68fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193038))
- [Fix issue board content wrapping](https://gitlab.com/gitlab-org/gitlab/-/commit/b2b0c3fc154761d85aceec7ec0c958073b5ae706) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194218))
- [Ensure scoped labels display properly in source code md preview](https://gitlab.com/gitlab-org/gitlab/-/commit/1ea5c9cef0278799284a271b86a19a6dc950b357) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194201))
- [Fix error when fetching all policies by type](https://gitlab.com/gitlab-org/gitlab/-/commit/c8d21048908dd19eefd39119a97f838294434b89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193216)) **GitLab Enterprise Edition**
- [Adds missing h1 to branches, commits and snippets pages](https://gitlab.com/gitlab-org/gitlab/-/commit/1f03d3b46b60458cb6dc8fccfad5afbf945a7dc8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194187))
- [Iteration cadences: Fix a11y issues](https://gitlab.com/gitlab-org/gitlab/-/commit/fb56fa7e3ed8aeed9fcb4705661b83b4088b1690) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194175))
- [Milestones a11y fix: Add missing h1](https://gitlab.com/gitlab-org/gitlab/-/commit/a8dccfb56b46265b80b145242ac23dcde4ca40d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194172))
- [Labels page: Fix a11y issues](https://gitlab.com/gitlab-org/gitlab/-/commit/b2b4da37615a70e60959d3299b03394bf3765253) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194164))
- [Acvitity pages: Add hidden h1](https://gitlab.com/gitlab-org/gitlab/-/commit/e2b330fa4ae566a4308d3049b0d94f4b46e47a3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194163))
- [Enable batch loading linked work items](https://gitlab.com/gitlab-org/gitlab/-/commit/76cac1e179b8a92f91e418d95ef847961d706343) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194130))
- [Environments page: Fix a11y issues](https://gitlab.com/gitlab-org/gitlab/-/commit/4ab94abe61a9fb8e4612c8afddd75a82da873f3d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194144))
- [Pass seat_control value to FE for non-licensed (EE) instances](https://gitlab.com/gitlab-org/gitlab/-/commit/b38172daa017c62555736cfb8713a83014dae326) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193562)) **GitLab Enterprise Edition**
- [GLQL table shadow fix (darkmode)](https://gitlab.com/gitlab-org/gitlab/-/commit/515593d6e2b81f7963d2719e6719fcbc3b06236a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194026))
- [Avoid extra line when no actions](https://gitlab.com/gitlab-org/gitlab/-/commit/f183b763b4033aa1b4495c3a2d90ed1e5cdd4111) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193355))
- [Prevent value dropdown from overflowing](https://gitlab.com/gitlab-org/gitlab/-/commit/c2b80f6377fbd8ea352c51b1b65a67b932f4fcd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194058))
- [Fix line number in zoekt results](https://gitlab.com/gitlab-org/gitlab/-/commit/de8b998845e78f495dc0c2667fc0ba63f0647cba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192929)) **GitLab Enterprise Edition**
- [Add active nav state to work items](https://gitlab.com/gitlab-org/gitlab/-/commit/0902014ab9455e28009d6918118a4e2edb8063d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193936))
- [Add support for ADDITIONAL_CA_CERT_BUNDLE in glab releases](https://gitlab.com/gitlab-org/gitlab/-/commit/163761b484ed716dd4fa3eecfa0e78402ea1b16a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193000))
- [Fix incorrect redirect when branch doesn't include files](https://gitlab.com/gitlab-org/gitlab/-/commit/8b8c4088437903b987ed14acc4a322ae71e2bc1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193993))
- [Explicitly normalize timestamps to use UTC timezone](https://gitlab.com/gitlab-org/gitlab/-/commit/e3b5081542496b905584afa13b4f07ad1f278eed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192821)) **GitLab Enterprise Edition**
- [Limit Validity Checks to Only Display on Secret Detection Reports](https://gitlab.com/gitlab-org/gitlab/-/commit/a639948502714d012ded63ff32900116a5eba2b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193836)) **GitLab Enterprise Edition**
- [Fix NamespaceStatistics total counter](https://gitlab.com/gitlab-org/gitlab/-/commit/b605b80b4ee90ba1601664b121b494c785a05920) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193845)) **GitLab Enterprise Edition**
- [Transform epic data source properly](https://gitlab.com/gitlab-org/gitlab/-/commit/f871920bf66ff1946a17210884a89de7edaaa54f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193827))
- [Fix border radius of failed jobs widget; update hover state](https://gitlab.com/gitlab-org/gitlab/-/commit/648958ce0fea0a3b0bd3f2a74d4e6997d4132d5a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193807))
- [Fix race condition / segfault in the glab release command](https://gitlab.com/gitlab-org/gitlab/-/commit/3ce96c1e151e382082f95340ba990e0bd6c0bd4c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193796))
- [Fixing Coverage-Check automatically being approved](https://gitlab.com/gitlab-org/gitlab/-/commit/ccdbb46054b4a6a6673efe200e906b2dd06e01a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193541)) **GitLab Enterprise Edition**
- [Fix incorrect log formatting of variables_override without exceptions](https://gitlab.com/gitlab-org/gitlab/-/commit/290f5623d15a91ee05cddef8e4dc5d7c218c707a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193757)) **GitLab Enterprise Edition**
- [Intersperse collection of items with a space](https://gitlab.com/gitlab-org/gitlab/-/commit/b2b334149c58978ad0b179a19ef7d822f4f42518) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193741))
- [Recover when a partition is missing from the current state](https://gitlab.com/gitlab-org/gitlab/-/commit/88189b1ded675d3eccc011c2210d1573de3540b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193727))
- [Add new notification](https://gitlab.com/gitlab-org/gitlab/-/commit/91c5efcbacc39bf2641c513377071a58c1762940) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192807))
- [Increase registry form btns gap](https://gitlab.com/gitlab-org/gitlab/-/commit/698e9450f82852c7ab55ad8651b601d538c9a89e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193682))
- [Prevent create form draft data from clearing when form modal is expanded](https://gitlab.com/gitlab-org/gitlab/-/commit/98a224ca3260ca521c1dc20537c69dbda5f54a34) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193662))
- [bug: Fix mermaid rendering on wiki notes](https://gitlab.com/gitlab-org/gitlab/-/commit/a094da033685bbaaddbb7cd9928fa2d039fa2e5d) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193632))
- [Merge branch '299607-multiple-emails-after-a-single-migration-is-complete' into 'master' ](https://gitlab.com/gitlab-org/gitlab/-/commit/a46611bdd240de7aa6878446d731bb8d360af940) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192966))
- [Fix a11y of board cards by not nesting content inside button](https://gitlab.com/gitlab-org/gitlab/-/commit/09c0bad7e14c868f8becb533eb2bb4e557d122e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192830))
- [Check if policy is enabled before syncing rules](https://gitlab.com/gitlab-org/gitlab/-/commit/5b8b130c05680b1c952f4a1f12bd662ac642363a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193600)) **GitLab Enterprise Edition**
- [Fixed the description on timelogs modals for work items](https://gitlab.com/gitlab-org/gitlab/-/commit/e6d0288c312dbf1e6a30ddad46145fdce9e2968c) by @zillemarco ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193280))
- [Moved @scope definition in search controller](https://gitlab.com/gitlab-org/gitlab/-/commit/771a384cafb8897d98c0feca0258be5748546469) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192262))
- [Add scan_settings schema to scan_execution_policy_content schema](https://gitlab.com/gitlab-org/gitlab/-/commit/ec9c0db4a2db458cc41f09568a9e40a8c01ffa93) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193521)) **GitLab Enterprise Edition**
- [Fix misalignment in pipeline graph](https://gitlab.com/gitlab-org/gitlab/-/commit/07886608708d55ac183c5976c13a486ef8a9fbc1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193507))
- [Fix margin of ordered list in GLQL](https://gitlab.com/gitlab-org/gitlab/-/commit/bf4af59fd01c633aada6a86dc9163dab21887968) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193472))
- [Remove overflow hidden on GLQL tables](https://gitlab.com/gitlab-org/gitlab/-/commit/2e40d78161987cb74e329d3ae0dff00a1ba59e4f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193468))
- [Allow selecting static environment scope](https://gitlab.com/gitlab-org/gitlab/-/commit/c7c6ba9a821383a742a06d30b39f4157e54cd9a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193181))
- [Validate push rules max_file_size](https://gitlab.com/gitlab-org/gitlab/-/commit/57167ec3840e2ee3bccbc95e6934fda5d521ccdb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192945)) **GitLab Enterprise Edition**
- [Fix error when querying custom attributes on non-existing attributable](https://gitlab.com/gitlab-org/gitlab/-/commit/0b137ec38dadb989b431ca39e4d84eedd26520a5) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191851))
- [Force rake gitlab:backup:restore to ignore PG16 `must be able to SET ROLE "gitlab-psql"` error](https://gitlab.com/gitlab-org/gitlab/-/commit/f64e70d0169cdfe958f252128a184b292382bb16) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191501))
- [Limit the number of pipeline count in merge request table](https://gitlab.com/gitlab-org/gitlab/-/commit/0c568f14bb2b3c3ca964a639fe085e197fa4d538) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193205))
- [Geo Sites: Expose disabled registries](https://gitlab.com/gitlab-org/gitlab/-/commit/a09069ae2cfa0beb582ecc2e24a7a2c74442548f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192017)) **GitLab Enterprise Edition**
- [Refactor SimpleOrderBuilder to reduce objects allocation](https://gitlab.com/gitlab-org/gitlab/-/commit/08dc566dc5feccdb490a8899f3f8f7995daf8185) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193262))
- [Isolate project scope for AtomicInternalId shared example](https://gitlab.com/gitlab-org/gitlab/-/commit/72d35e7d554c886d20d91537f8c21eb38a02bffa) by @zakaria-fatahi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192442))
- [Avoid reordering sort enum values](https://gitlab.com/gitlab-org/gitlab/-/commit/ea5e5a2a84102a8d5f03648e234ae6a21c6ba7a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193259))
- [Fix graphQL ID mismatch in replicable detail view](https://gitlab.com/gitlab-org/gitlab/-/commit/85b49fcabec3bfd9d4e11e38b2c1d99dd977099d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192784)) **GitLab Enterprise Edition**
- [Fix Protected Tags show page](https://gitlab.com/gitlab-org/gitlab/-/commit/07b37e442dca7d7f8235f4bcc94a80c2cfe31d11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193256))
- [Fix drawer update not reflecting on item board bug](https://gitlab.com/gitlab-org/gitlab/-/commit/3c334118fa98028cd48804bfceaacaeeb2ff80c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191103))
- [Fixing CI/CD import when user is not authenticated](https://gitlab.com/gitlab-org/gitlab/-/commit/109f6ff82a8eff610ce6f635fed4a7e643fac48c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192833))
- [Dependency Proxy: Restore ExternalAuthorization check on deploy tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/227963334ed582afad2f655e0a2afd5ba748ac87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192399))
- [The mark_all_as_completed! method should also drop halted cache](https://gitlab.com/gitlab-org/gitlab/-/commit/03102c117429b5006173e2b0b74ddff43e586054) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192271)) **GitLab Enterprise Edition**
- [Fix typo in error message](https://gitlab.com/gitlab-org/gitlab/-/commit/61b89fc9185dabf52430db1dc7e4c6806d7ade55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187817)) **GitLab Enterprise Edition**
- [Fix cursor store](https://gitlab.com/gitlab-org/gitlab/-/commit/bd4d7862408d4eefb4551af4ab3a93d24f814fc0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193148)) **GitLab Enterprise Edition**
- [Add active nav state to edit deploy keys](https://gitlab.com/gitlab-org/gitlab/-/commit/dc87b9fbda515d0ca9ef83aaf376403b9ab47a90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192844))
- [Fix: Ensure placeholder users are organization users](https://gitlab.com/gitlab-org/gitlab/-/commit/20c5126ad6706263c91b9ee1262ca7df2f2d0b0b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192790))
- [Fix links in Value Stream Analytics metric tiles and their popovers](https://gitlab.com/gitlab-org/gitlab/-/commit/9751953e4f771faba9955a586674d8f644415942) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192836))
- [Time tooltip triggers on keyboard focus](https://gitlab.com/gitlab-org/gitlab/-/commit/54af0fa2b08ab189a9210f250be4e4a5c0a4baea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192996))
- [Include relative URL in latest release redirect](https://gitlab.com/gitlab-org/gitlab/-/commit/87a527fb7d58eab4e905da1b802d33456fdb26cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192947))
- [Fix emoji picker for users with scrollbars always on](https://gitlab.com/gitlab-org/gitlab/-/commit/d04b3ff7afb7dd808eea799376ed6826b70b611b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192946))
- [Override complexity for Development widget fields](https://gitlab.com/gitlab-org/gitlab/-/commit/746f8c2d4195a56f6925952dff0b89652e617cc9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192917))
- [Gracefully handle timeout when validating git URL](https://gitlab.com/gitlab-org/gitlab/-/commit/29fea36a2709e1f9b621c432257ca6c345c1209e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192879))
- [Refactored project requirement compliance status refresh](https://gitlab.com/gitlab-org/gitlab/-/commit/47db9f234c3e775abd3bd316e6a866d603805b6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191138)) **GitLab Enterprise Edition**
- [Fix subgroup filtering in framework project tab](https://gitlab.com/gitlab-org/gitlab/-/commit/3155e6ab1ca49fa01be1c2266f70755803d733c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192589)) **GitLab Enterprise Edition**
- [Allow `inputs:regex` to match empty strings](https://gitlab.com/gitlab-org/gitlab/-/commit/543d8dda1fc5c67cc3aeb5f938dcd541d13835c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192082))
- [Make `<mark>` within a table cell appear properly](https://gitlab.com/gitlab-org/gitlab/-/commit/c90df70b9bb1850d5619e83b0bcfa6cdf1adb7dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192801))
- [Fixed sidebar not highlighting scope when no search term](https://gitlab.com/gitlab-org/gitlab/-/commit/de87f67fab69455c7ed529c01506bdc362eec2ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191013))
- [Fix race condition while creating scan_result_policy_read](https://gitlab.com/gitlab-org/gitlab/-/commit/5493c0db6b5fe026348fbda406d6316a5bd2bec1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192033)) **GitLab Enterprise Edition**
- [Fix loading standard roles on premium license](https://gitlab.com/gitlab-org/gitlab/-/commit/d6a2da521da958d5be32bdea2adf924b80391e7a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192694))
- [Create worker to handle security policies on project transfer](https://gitlab.com/gitlab-org/gitlab/-/commit/78cf1a460c023329b07ae5363e1efa6d23caabde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191406)) **GitLab Enterprise Edition**
- [Fix cache issue with work item refetch](https://gitlab.com/gitlab-org/gitlab/-/commit/00d5d31cbd799ddfc6513f809d838fbdbbe67371) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192638))
- [Do not make membership of same level as inherited](https://gitlab.com/gitlab-org/gitlab/-/commit/25ee10afe861af0dae9badc37f0cdac09b3042bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190172))
- [Fix typo in SAML warning modal](https://gitlab.com/gitlab-org/gitlab/-/commit/1f61f91a0a418bcece53be507dba9484da91ee0b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192605))
- [Use symbol keys for addtional tracking property](https://gitlab.com/gitlab-org/gitlab/-/commit/e16a8824900092c74228d87202babae3e06ba43d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192527)) **GitLab Enterprise Edition**
- [Enable stream-audit-events-remote-ip-proxy-protocol by default](https://gitlab.com/gitlab-org/gitlab/-/commit/c3136c8cf56c7d2a02e9602591682b63a0f83ac1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192528))
- [Fix Internal Server error from branchRuleCreate mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/c0a6c1236455b9268ec4fc0659ea17b8c53a5d46) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192512))
- [fix: Ensure test stage when enabling sec scans via Config page](https://gitlab.com/gitlab-org/gitlab/-/commit/275be19569618644d5e8471e9e9e28cc29afed7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191482)) **GitLab Enterprise Edition**
- [Fixes spacing of runner skeleton loader](https://gitlab.com/gitlab-org/gitlab/-/commit/18a12adbfa282da265b7d99723f8e89d74c732d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192234))
- [Use count fields instead of querying linked items](https://gitlab.com/gitlab-org/gitlab/-/commit/1c8bb901122fa11a123d627af67d6aa86312df58) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191317))
- [Add branch rules squash option license check](https://gitlab.com/gitlab-org/gitlab/-/commit/2e635eb002d0ef4bc2da2036d1d2575c015ae86f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192222))
- [Fix Upgrade to 18.0: No such column](https://gitlab.com/gitlab-org/gitlab/-/commit/04b41c426a617e0ce1aaef7a57868857b6cb51ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192172))
- [Fix: Restrict reassignment for non-enterprise users](https://gitlab.com/gitlab-org/gitlab/-/commit/5f93d5d74f2709f3111ab8f209e9a0638a52da92) by @PRANJALI-SANKPAL ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190260)) **GitLab Enterprise Edition**
- [Fix the title/body issue for todo apis when it is a duo todo](https://gitlab.com/gitlab-org/gitlab/-/commit/fbf5a17398d42ffdb5201418a6e95f0457cefa4f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192386)) **GitLab Enterprise Edition**
- [Fix n+1 issues on vulnerabilities resolver](https://gitlab.com/gitlab-org/gitlab/-/commit/5f80aafd00ceaf65503e72b3dbcf4f85c1bc3840) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192108)) **GitLab Enterprise Edition**
- [Fix `branch` and `tags` scope in pipelines resolver](https://gitlab.com/gitlab-org/gitlab/-/commit/9d7c6a7ca743273c40593e06938fa6f908dba219) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191638))
- [Fix /issues/new page bugs](https://gitlab.com/gitlab-org/gitlab/-/commit/078f992bd9fd916db247e278a6bcbeb48ece7e1f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191378))
- [Fixes layout of the full job log viewer](https://gitlab.com/gitlab-org/gitlab/-/commit/f04cfafd97e83c0c4a728a8c828bca047abd0d4d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192215))
- [Fix: Make custom status name index case-insensitive](https://gitlab.com/gitlab-org/gitlab/-/commit/c51e0b3a6d88c1fa01142ecba4268f831cbc8a5e) by @PRANJALI-SANKPAL ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191707))
- [Support markdown anchors and multi-line in permalink](https://gitlab.com/gitlab-org/gitlab/-/commit/28bcd9a439de9ac0cdf7efe91f14eebfbcff5bba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191678))
- [Fix escape from work item creation](https://gitlab.com/gitlab-org/gitlab/-/commit/e915bcc3e856158e96dc5eb2c242dc6b923662a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192296))
- [Make JSON import more fault tolerant](https://gitlab.com/gitlab-org/gitlab/-/commit/b6ece15ab0642d0b1c12269a1e27a98a4fa45c4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191992)) **GitLab Enterprise Edition**
- [Fix wrong spacing in commit link](https://gitlab.com/gitlab-org/gitlab/-/commit/1a1aba2e8087a01c19f8cec6d01c76aff65602ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192250))
- [Do not hide the projects list when user searches and result is empty](https://gitlab.com/gitlab-org/gitlab/-/commit/98c53f25d36a46944b1961ccc70cec358d9a51ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191888))
- [Refactor and stabilize batch suggestion tests](https://gitlab.com/gitlab-org/gitlab/-/commit/c8a1f83656e4bcb06bbee20806811fadd7822997) by @zakaria-fatahi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191348))
- [Prevent automatic default template selection on Work Items](https://gitlab.com/gitlab-org/gitlab/-/commit/e3f98c52703dcd9dd7a6d7f42adf73ac00cd1321) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191977))
- [Fix Firefox ESR overrides for work item notes note container query](https://gitlab.com/gitlab-org/gitlab/-/commit/2412d5d18b8c83705938d6703b27c35b3c415c37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192162))
- [Removed FE exposure of findingTokenStatus for Multiversion Compatability](https://gitlab.com/gitlab-org/gitlab/-/commit/403a8df58ded032ccc2e51f51a0eaa3f3829afc5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192141))
- [Pass file path to Duo Workflow](https://gitlab.com/gitlab-org/gitlab/-/commit/2310c7a506cb503a2cb250a099c5a0a989d22edd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192113)) **GitLab Enterprise Edition**
- [Support custom domains when pages run on separate server](https://gitlab.com/gitlab-org/gitlab/-/commit/9c9c33748e31d4bd24d56f7caa6ac02bbac42641) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190501))
- [Trim pages deployment file name to 60 characters](https://gitlab.com/gitlab-org/gitlab/-/commit/5e9dd3ef55c867416b13615534262276fdf2d8bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192088))
- [Remove "new look" badge from project issue board](https://gitlab.com/gitlab-org/gitlab/-/commit/18c6d453e45cb47870f5515e170d505ab852d04d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192044))
- [Fix permissions not showing for selected admin role on user edit page](https://gitlab.com/gitlab-org/gitlab/-/commit/4b50798abfdf9b9a5122b9cbb2955ca1752aea91) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192041)) **GitLab Enterprise Edition**
- [Migrate orphaned timelogs to ghost user](https://gitlab.com/gitlab-org/gitlab/-/commit/768882c01db63aa9301e6fc9537fc70b5dc57b63) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189529))
- [Prevent hiding WI type select in create form](https://gitlab.com/gitlab-org/gitlab/-/commit/e3bef129d71e6b1e07251867cd1d48ead94f6f55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192015))
- [Fix branch rules url in the protected branch redirect banner](https://gitlab.com/gitlab-org/gitlab/-/commit/ca27f76c0ac9c8780830fb17aa3edd696dc91c65) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191361))
- [Elastic::MigrationWorker should not create migrations index](https://gitlab.com/gitlab-org/gitlab/-/commit/545a8c81284d7f0ee0e0ed3dd0330983c1d011c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191862)) **GitLab Enterprise Edition**
- [Fix UX bug related to personal access token scopes](https://gitlab.com/gitlab-org/gitlab/-/commit/ff57c4eef96634987c4969fa49455a1ee2f0de8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191665))
- [Add missing work item/issue feature flags to board controllers](https://gitlab.com/gitlab-org/gitlab/-/commit/6b71d2158ef15912aa2a621e78bc43620505de0c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191239))
- [Default `VulerabilityType.identifiers` to an `[]`](https://gitlab.com/gitlab-org/gitlab/-/commit/1215e73636f1f7e189449f1500b136f910329dd8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191770)) **GitLab Enterprise Edition**
- [Fix visibility of custom roles on SaaS](https://gitlab.com/gitlab-org/gitlab/-/commit/df2d4c347cb71f204214c5c1f26d695cbbc471c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191790)) **GitLab Enterprise Edition**
- [Fix .gitattribute parsing logic](https://gitlab.com/gitlab-org/gitlab/-/commit/b89f1537819fce1725693bec37c92b43b3e4dcea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191948))
- [Apply Rails 7-1-stable patches to fix type map init issues](https://gitlab.com/gitlab-org/gitlab/-/commit/70793b7b387f9b3d1cf8045b683b025fea9c9d94) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191880))
- [Fix wrapping in secret detection confirmation modal](https://gitlab.com/gitlab-org/gitlab/-/commit/9d4c68016a2cc22a46c4e6a2272a1fd25ffb883e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191869))
- [Build list-id for group notifications](https://gitlab.com/gitlab-org/gitlab/-/commit/3ad7444e3c7de9f02f5c5eb9f14de482360075d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191855)) **GitLab Enterprise Edition**
- [fix: Allow user to be passed as a string](https://gitlab.com/gitlab-org/gitlab/-/commit/e6652b27cf5a875cb9d9231b32bd075064291704) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162161))
- [Stabilize dashboard sort preference test with wait](https://gitlab.com/gitlab-org/gitlab/-/commit/acb8ff720f277433118915b712f10d58b292344b) by @zakaria-fatahi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191839))
- [Add full unique index on issuable-resource-links](https://gitlab.com/gitlab-org/gitlab/-/commit/4c0fe2837a37db604625c6b6d713f71c015604ee) by @tomasz.skorupa ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185305))
- [Move fork_networks organization_id NOT NULL to post-migrate](https://gitlab.com/gitlab-org/gitlab/-/commit/bc0abb3148de05d14dde36eeae52f82f5f703adf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191826))
- [Enable pull_ref_directly_from_gitaly FF by default](https://gitlab.com/gitlab-org/gitlab/-/commit/74874c5ccb0032d7a8f802268288c9b2c6c0fd2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191799))
- [Do not truncate titles in GLQL views](https://gitlab.com/gitlab-org/gitlab/-/commit/39f8e83c2c5103845aa7b4f38793841a94a9907e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191814))
- [Ensure geo_node is secondary git_http_controller_spec.rb](https://gitlab.com/gitlab-org/gitlab/-/commit/0b0d5a402703d4b4d106955a7d88e4527826739f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191786)) **GitLab Enterprise Edition**
- [Disable validation limits to stabilize HTTP Integration update spec](https://gitlab.com/gitlab-org/gitlab/-/commit/3e8d7a2185c604a094da8aff0caf19b884891c0b) by @zakaria-fatahi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191772))
- [Fix NoMethodError: Projects::BlobController#update](https://gitlab.com/gitlab-org/gitlab/-/commit/a704c27e6b821bf1bcbaa0c796bacd3c5e140efe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191655))
- [Fix licence widget to align with full report](https://gitlab.com/gitlab-org/gitlab/-/commit/9f57285df615c432797f2a9e00da3d53f7dc37d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191399)) **GitLab Enterprise Edition**
- [Ensure consistent diff ordering in spec](https://gitlab.com/gitlab-org/gitlab/-/commit/3e661d5912048b1b41a2e8d41f00f977dc347d87) by @zakaria-fatahi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191709))
- [Fix error adding timelog when user has invalid timezone set](https://gitlab.com/gitlab-org/gitlab/-/commit/f16706df4becce360e29db84e0e04caaa56bfa7b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191697))
- [Destroy orphaned job artifacts](https://gitlab.com/gitlab-org/gitlab/-/commit/8524462e30f63ebaa409ebd825d04af7b34a073c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191506))
- [Do not run index integrity worker for zoekt search](https://gitlab.com/gitlab-org/gitlab/-/commit/252af93dc3abbc3f8bb2bbc93286cb5c7b20c4f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191418)) **GitLab Enterprise Edition**
- [Prevent rounding of hours for time tracking](https://gitlab.com/gitlab-org/gitlab/-/commit/e939fe1c4247071eceaa55ce4ee77143f11e5566) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191674))
- [Fix updating member with custom role after license downgrade](https://gitlab.com/gitlab-org/gitlab/-/commit/add5aa9ff97610c53ce22d8b58892115cbaccd04) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191676)) **GitLab Enterprise Edition**
- [Zoekt: Only enable search when nodes are online](https://gitlab.com/gitlab-org/gitlab/-/commit/da752eae3626c1ae2a53a29491607bb2e86e9d8a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191666)) **GitLab Enterprise Edition**
- [Fix group icon in token access table](https://gitlab.com/gitlab-org/gitlab/-/commit/87b434996dadb4f5d31e13f1601b2cc02b24ebe4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191572))
- [Fix stream audit events remote_ip for Git over SSH](https://gitlab.com/gitlab-org/gitlab/-/commit/5a54290bd04a1de7e79988d1437d278e51455d6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191408))
- [Update tab count when searching and filtering](https://gitlab.com/gitlab-org/gitlab/-/commit/4270d928c37066ed21fdce17045a5fcec410cd18) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191242))
- [Update `run_job` permission for bridge jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/3a53e10e446c5805bd8e412ddfe216db2e195d32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191636))
- [Focus on username or password field in sign-in tabs](https://gitlab.com/gitlab-org/gitlab/-/commit/41d3ce88ab2bdf747759efdbe796c191e176e274) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191364))
- [Include identifierName filter in the severities count query](https://gitlab.com/gitlab-org/gitlab/-/commit/5740096b63adf3bbff769ac30e04f943a6a145d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191629)) **GitLab Enterprise Edition**
- [Allow canceled Direct transfer to be re-imported](https://gitlab.com/gitlab-org/gitlab/-/commit/7dd61954f0e69374f36b1adfc00d78d5e604067e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191616))
- [Fix HTTP audit event destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/a2dec89e6fdc2b03b650f3c190ca560898892a28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189699)) **GitLab Enterprise Edition**
- [Fix gitpod button is missing in the edit dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/1a82b6917af4abe93182b1e7946a40ad087b3cc9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191559))
- [Fixes escape behavior in work item editors](https://gitlab.com/gitlab-org/gitlab/-/commit/982faa9b6a719e8b7d0a1deb0fd1c03fae013574) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191554))
- [Fix alignment of codeowners info button and branch rules button on repo](https://gitlab.com/gitlab-org/gitlab/-/commit/1eded970f760e3cb856104b3423e45e50486af8d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191379)) **GitLab Enterprise Edition**
- [Fix scrolling on boards when filters don't fit inside the screen](https://gitlab.com/gitlab-org/gitlab/-/commit/8144da28fc308781466ffe4b6961a47ac8c67798) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191125))
- [Add group display uniqueness for the user on in-app trials](https://gitlab.com/gitlab-org/gitlab/-/commit/f4a65d8140cd015aee5ed9d06cdb54b012d139dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191386)) **GitLab Enterprise Edition**
- [Settings section: Fix border appearing on retina like displays](https://gitlab.com/gitlab-org/gitlab/-/commit/807dc2f9c1e421a34bedfca6a8b7b22e6d284a24) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191489))
- [Fix the router issue while closing the designs](https://gitlab.com/gitlab-org/gitlab/-/commit/5209cf5556e30dd5958fc3ba92a510134d33cb55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191304))
- [Work items design management gap fix](https://gitlab.com/gitlab-org/gitlab/-/commit/dfda9a9562828e619895c092507e35b9d9e0d5ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191463))
- [Exclude binary files from ai_reviewable_files](https://gitlab.com/gitlab-org/gitlab/-/commit/ad681b5f1fd490971723f6a39d649344504d46ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191453)) **GitLab Enterprise Edition**
- [Schedule p_ci_pipeline_variables project_id index](https://gitlab.com/gitlab-org/gitlab/-/commit/20cf8ba95bbea0fa08e95f716e58ebb09094b573) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191182))
- [Fix setting confidential and set_parent](https://gitlab.com/gitlab-org/gitlab/-/commit/438d47dd0683ad3fe561d2c1ad9245a123bd2160) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190152))
- [Update @loader method in catalog data loader](https://gitlab.com/gitlab-org/gitlab/-/commit/042d42c22862769f12804ee108553bf8d1cf0d52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191393))
- [Stabilize multi-line suggestion tests](https://gitlab.com/gitlab-org/gitlab/-/commit/d52f5ca8aba5a187512c7a807ee092989f0dbe73) by @zakaria-fatahi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191387))
- [Fix the state filtering for dismissal reason](https://gitlab.com/gitlab-org/gitlab/-/commit/5f45e7bdccd51bcb8a5b37e889da7a6d8c5213a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191233)) **GitLab Enterprise Edition**
- [Stabilize time-sensitive tests](https://gitlab.com/gitlab-org/gitlab/-/commit/e0731ceff71932bd336ff7aac242e76a76f9016f) by @zakaria-fatahi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190954))
- [Make DB metric expectations resilient to zero durations](https://gitlab.com/gitlab-org/gitlab/-/commit/9d6f8cf98d62685ab60f693fc832961691754d16) by @zakaria-fatahi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191213))
- [Check policy scope before syncing with project](https://gitlab.com/gitlab-org/gitlab/-/commit/3fd732e786ea2d11ea613a4519350e62d594f480) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191171)) **GitLab Enterprise Edition**
- [Add test for stale diff_stats memoization](https://gitlab.com/gitlab-org/gitlab/-/commit/0e023fa72b6c464dcc24d15cd58690cb782f10ea) by @zakaria-fatahi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190485))
- [Add exclusions on drawer close](https://gitlab.com/gitlab-org/gitlab/-/commit/f7142cef6733a7de56ae7e33717b116aec0fd4c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190757))
- [Enables numeric values for FQDN in workspace:agent](https://gitlab.com/gitlab-org/gitlab/-/commit/63baf267abcadc3695b54c2c59d890ee5292b937) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190987)) **GitLab Enterprise Edition**
- [Isolate TreeSaver export_path to per-example tempdir](https://gitlab.com/gitlab-org/gitlab/-/commit/944b5c26728763a8b86a6895dbc5bccd0eb904d8) by @zakaria-fatahi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191049)) **GitLab Enterprise Edition**
- [Add text.color.default design token to .dropdown-menu class](https://gitlab.com/gitlab-org/gitlab/-/commit/41484d513707093b0a01059edb80d84cd65cb50a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191249))
- [Fix IDE links returns about:blank in old code dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/1447173c70f30c918e2a74629e836e339533f235) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191236))
- [Hide false-positive template warning on Create Work Item](https://gitlab.com/gitlab-org/gitlab/-/commit/082844b0dbcb8e3d7bd41ff36c903dca94fe4f7b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191090))
- [Fix mr count is not sending on render tracking event](https://gitlab.com/gitlab-org/gitlab/-/commit/3ce9d560f553cfa9fd80205c7a229ac0e9675d35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190714))
- [Repo code owners block: Add missing top border](https://gitlab.com/gitlab-org/gitlab/-/commit/ca5217a217d43daa46f2b0a2aa2870e63306c856) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191193))
- [Removed unnecessary test in TokenValidityBadge spec](https://gitlab.com/gitlab-org/gitlab/-/commit/3ef0a83c6d06e654a151faeffdaf479b4d441b87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190693))
- [Run Sidekiq samplers after Rails initialization](https://gitlab.com/gitlab-org/gitlab/-/commit/c07464744ec991f26dfde6d75de3685145ceb797) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191109))
- [Change create work item modal visibility logic so toast appears](https://gitlab.com/gitlab-org/gitlab/-/commit/d9a693317b6431e3e5dfbc0829ffe31c7f24e3a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189547))
- [Prevent work item sidebar dropdowns from overflowing when narrow](https://gitlab.com/gitlab-org/gitlab/-/commit/84b5bdc8f86bc8a898376c197fcbd660b76be667) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191047))
- [Manage DB connections in with_threads helper](https://gitlab.com/gitlab-org/gitlab/-/commit/822d7d55589a067d5fb8961929e0a08509ffeded) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190937)) **GitLab Enterprise Edition**
- [Fix NoMethodError in RemoveBotForNamespaceWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/084ee0912584ee9d192d3a1d2c0ecda031e09f78) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190931)) **GitLab Enterprise Edition**
- [Support bucket prefix when moving package files in object storage](https://gitlab.com/gitlab-org/gitlab/-/commit/d44281478d887f400dcde2861ef60f4de8115c59) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190855))
- [Fix bug with group settings change trigger CRM validation unnecessarily](https://gitlab.com/gitlab-org/gitlab/-/commit/67921df371657a681054c3d04a4fee55731fffc3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190842))
- [Respect ENV and config variables when initializing Bullet](https://gitlab.com/gitlab-org/gitlab/-/commit/e562c694f8632e8bfe327349be96151a4d985468) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190831))
- [Move showBlobControls logic to header area](https://gitlab.com/gitlab-org/gitlab/-/commit/104109a4c5c7d988d511acbab654f4a23f9d4f58) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190600))

### Changed (222 changes)

- [feat: Add capability to filter mergerequests of commit by state](https://gitlab.com/gitlab-org/gitlab/-/commit/c0e9003d47fbe39bca79f861aa9b3df27e095920) by @gmicouin ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191169))
- [Remove dependency on default organization id](https://gitlab.com/gitlab-org/gitlab/-/commit/b19723897e379d674be6c1864b17a606b946caf1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193614))
- [Update control popup grouping](https://gitlab.com/gitlab-org/gitlab/-/commit/2b49d559c0604dbfd6b5173eed0284fe7eb5dc5a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194544)) **GitLab Enterprise Edition**
- [Remove exclude license packages feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/62d222cfffbad4312c4f70b5c953c2ab6aa5a15b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186717)) **GitLab Enterprise Edition**
- [Map OpenMRs to GlDisclosureDropdownItem API](https://gitlab.com/gitlab-org/gitlab/-/commit/7f974c5b1f811e9e1a4837d8c6f42de00f83a483) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194030))
- [Add filtering by type for a policy list](https://gitlab.com/gitlab-org/gitlab/-/commit/d1408bef72b3329b757d4cd1ee6af12a466f87fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193314)) **GitLab Enterprise Edition**
- [Add tab label to group compliance dashboard tracking](https://gitlab.com/gitlab-org/gitlab/-/commit/02f2f79117f064c8970cd007a059933754a6da79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193658)) **GitLab Enterprise Edition**
- [Send only selected inputs by default](https://gitlab.com/gitlab-org/gitlab/-/commit/d87eb73d9aa5171eb680f8bbe04a6c72c62c5b6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194299))
- [Update UI text for push rules](https://gitlab.com/gitlab-org/gitlab/-/commit/8e8038ce8e109758a4bbf95ef50099b2713a25ea) by @cfleee ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188157)) **GitLab Enterprise Edition**
- [Change `protect_merge_request_pipelines` column default value to true](https://gitlab.com/gitlab-org/gitlab/-/commit/fe6e22ee821b5dffbc19c21936caeafe126174cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194036))
- [Update `vulnerability_export` API to accept `report_data`](https://gitlab.com/gitlab-org/gitlab/-/commit/fd0aaf18d376bc1ef2d310796ab7c7e29ff07150) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193143)) **GitLab Enterprise Edition**
- [Reduce QUEUE_THRESHOLD to ease incremental queue](https://gitlab.com/gitlab-org/gitlab/-/commit/e47486619a7e4fc4f11ae2ce69ad3d8cc2646b69) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194280)) **GitLab Enterprise Edition**
- [Add instructions to empty status report](https://gitlab.com/gitlab-org/gitlab/-/commit/d63bc8d440028c7ff8552ef7751a0ce5090c1836) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193702)) **GitLab Enterprise Edition**
- [Remove default target namespace for external imports](https://gitlab.com/gitlab-org/gitlab/-/commit/88836c40f7e8008dc5b9ddcf91e283fb424cff7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193193))
- [Default enable work_item_epics_list feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/77e2bf0e986af7d58f3a8d4cf18ae1b8bda4d515) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193599)) **GitLab Enterprise Edition**
- [Fix: Removing the "ci" prefix from "server_fqdn" variable](https://gitlab.com/gitlab-org/gitlab/-/commit/08bc1b95935735890d40333b8c603667bc57aed0) by @guptapratibha26 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193991))
- [Force transfer project dropdown to display at top](https://gitlab.com/gitlab-org/gitlab/-/commit/4285f886cab33feade51a3f4e8344f9be7d5b314) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194061))
- [Refactor namespace permissions to use standard permission types](https://gitlab.com/gitlab-org/gitlab/-/commit/51c6b340e135f0d684b23eb57b90dc9f229f981d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194019)) **GitLab Enterprise Edition**
- [Add dark_color_scheme_id column to user_preferences table](https://gitlab.com/gitlab-org/gitlab/-/commit/afa1676064b333a9451f1b2dd4db44a813b32b38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191444))
- [Add graphql mutation to resync security policies](https://gitlab.com/gitlab-org/gitlab/-/commit/41346ac9b4edf7383843faa77648b4fed35d5b71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190404)) **GitLab Enterprise Edition**
- [Remove autofocus on show for runner registration modal](https://gitlab.com/gitlab-org/gitlab/-/commit/0e4c9989c4f234ba1980246527f3b85b9947bb09) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194134))
- [Clean up 'explicit_group_saml_fingerprint_algorithm' FF and old code](https://gitlab.com/gitlab-org/gitlab/-/commit/c1ee9121eb14dc952cb9a2a1f0323eb6a769ebe1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193784)) **GitLab Enterprise Edition**
- [Add additional metadata to zoekt indexing tasks](https://gitlab.com/gitlab-org/gitlab/-/commit/2ea7ae1122fd10fcafd9ff8956f4ff1f1d18b531) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193178)) **GitLab Enterprise Edition**
- [Add Duo Provision Service to Provisioning Workflows](https://gitlab.com/gitlab-org/gitlab/-/commit/23139e41ea355935fd03844fd8aea836debe4762) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194078)) **GitLab Enterprise Edition**
- [Pass PATs scopes from backend to frontend in new UI](https://gitlab.com/gitlab-org/gitlab/-/commit/8dba1c73cb8ed7a17f62b7a2843160dcf38b4d85) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193648))
- [Add WorkspaceTokens model and table](https://gitlab.com/gitlab-org/gitlab/-/commit/92eec53adf159bbf8e5225920357ea8ddef7cbb2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193071)) **GitLab Enterprise Edition**
- [Add type argument to policy resolver](https://gitlab.com/gitlab-org/gitlab/-/commit/bc31a4e6d171d2a48216918fdbf57193badc24e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193218)) **GitLab Enterprise Edition**
- [Remove background for plan details on billing page](https://gitlab.com/gitlab-org/gitlab/-/commit/8b37b717aae034ffae63e3569227b8bbdd93cc2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193907)) **GitLab Enterprise Edition**
- [Job log: Related jobs cleanup](https://gitlab.com/gitlab-org/gitlab/-/commit/91c8b2281a6a73e6946023e820b558571754bff7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193997))
- [Cleanup FF allow_issuer_claim_custom....id_tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/a0a206e72ce7a4fe801c9c46bb696cd14a5f8a00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193762))
- [Rename knn limit to k](https://gitlab.com/gitlab-org/gitlab/-/commit/9309291b23b845dd93c08f9a5ee241003a790105) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193336)) **GitLab Enterprise Edition**
- [Allow GLQL searching ES by the milestone title](https://gitlab.com/gitlab-org/gitlab/-/commit/388bfd16e5efb461482f3dca0f877da3b094b903) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192119))
- [Fix feature flag limit badge](https://gitlab.com/gitlab-org/gitlab/-/commit/3ebe2bc89f90e2bee10ccda0578cfd198c2352c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192993))
- [Restrict LFS file download to project-bound objects](https://gitlab.com/gitlab-org/gitlab/-/commit/f6142e7a4a638bed3de61a5c12d421679a0b4c96) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191723))
- [Frontend changes to support external control name](https://gitlab.com/gitlab-org/gitlab/-/commit/a8c6ec703a56665dd45d77f09bc102dfaa2c2937) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193367)) **GitLab Enterprise Edition**
- [Record target entity ID with spam logs](https://gitlab.com/gitlab-org/gitlab/-/commit/45e1165936314f265dcb9a743d7e5ab1734c1335) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193707))
- [Track security finding severity manual overrides](https://gitlab.com/gitlab-org/gitlab/-/commit/b69a99830aa85d4bf2f971e3a653d3d62cd3249e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190815)) **GitLab Enterprise Edition**
- [Add animation to review button when review is started](https://gitlab.com/gitlab-org/gitlab/-/commit/66c08410ec69439b9b7f41dcfd94406f5689cd2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193809))
- [Enable project-level control of web-based commit signing](https://gitlab.com/gitlab-org/gitlab/-/commit/250275a038bcc22a9c0ac5015dd08e1ee82ba97a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193027)) **GitLab Enterprise Edition**
- [Add aria-label to time entry button](https://gitlab.com/gitlab-org/gitlab/-/commit/8f12c8943a88cb986ad13d9c8bf0d246ef0d3e67) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193016))
- [Add index to labels table](https://gitlab.com/gitlab-org/gitlab/-/commit/026f3fe980892ec4f17427f2590f4f7c4d024204) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193184))
- [Increase background visibility on highlighted job log line](https://gitlab.com/gitlab-org/gitlab/-/commit/16686da9d8b4e0e5ebe3c1bbc31218944dccd325) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193753))
- [Allow preselecting all inputs](https://gitlab.com/gitlab-org/gitlab/-/commit/1e15819527f29e6725587d5d01fd09c83e42c1da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193750))
- [Show allowlist entry for current project at the top](https://gitlab.com/gitlab-org/gitlab/-/commit/8b2dd36d2d178bc9a26c122cc5b340afda4658f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193466))
- [Adds a new Cop to prevent `connection.execute` calls](https://gitlab.com/gitlab-org/gitlab/-/commit/760285964291254876e89c0064c8a3c33b310866) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193545))
- [Update the Hugo tutorial and CI template](https://gitlab.com/gitlab-org/gitlab/-/commit/f9059b005e39ad6ece8daf504843ff8313e01e48) by @annegentle ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175790))
- [Update scanner to project default branch](https://gitlab.com/gitlab-org/gitlab/-/commit/bd9bace5a6239c5d0c51d51d152e76c2127be7be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192876)) **GitLab Enterprise Edition**
- [Drop unique index scoped to the framework](https://gitlab.com/gitlab-org/gitlab/-/commit/ab123a0708b6887ac06321af44203e9e361a5339) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193246)) **GitLab Enterprise Edition**
- [Modify Microsoft Azure integration text](https://gitlab.com/gitlab-org/gitlab/-/commit/119959ea2fc90095489417e828d9a353a1ae6265) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193687)) **GitLab Enterprise Edition**
- [Cleanup FF protect_merge_request_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/f8722efcdc06e64d13347b305f45674c2f17d200) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193077))
- [Remove static_licenses feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/0074d5a6c40940b9ba3441cb2e48795324cd2956) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189814)) **GitLab Enterprise Edition**
- [Backfill data for new fields in the existing work item documents](https://gitlab.com/gitlab-org/gitlab/-/commit/d418e700a1e8a9837903915db944ed3b5be68106) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193590))
- [Update project name error copy](https://gitlab.com/gitlab-org/gitlab/-/commit/31b70c14312290a095fc5ee58dc9f0e805847ba9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193613))
- [Update analyzer statuses on default branch only](https://gitlab.com/gitlab-org/gitlab/-/commit/700dd90d661960a39a851e657f1c58f94e86a2f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193622)) **GitLab Enterprise Edition**
- [Split construct policy methods by type](https://gitlab.com/gitlab-org/gitlab/-/commit/0b55073b46d4c21605e1693a17911877774e6c55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191684)) **GitLab Enterprise Edition**
- [CI/CD Variables drawer: Change visual heading size in drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/8ee63738841b378e85d01fafd5c568272573a9ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193577))
- [Allow customization of issuer claim in ID tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/9f343c3302d5f93682672d32a7f531b749d5a94c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188632))
- [Use composite oauth token for Duo Workflows CI execution](https://gitlab.com/gitlab-org/gitlab/-/commit/17d456f9e3674fbbea6eb622006b2c9d9c02500c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183510)) **GitLab Enterprise Edition**
- [Removes grace period from Lock Retries Cop](https://gitlab.com/gitlab-org/gitlab/-/commit/5fd84c53d809f848da9d2326a821301ad0b4f2a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193547))
- [Make issue type icon focusable](https://gitlab.com/gitlab-org/gitlab/-/commit/4f634e64fb4c5899454e6a5191ea35e9c3ef3aa0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193046))
- [Clarify pipeline error message](https://gitlab.com/gitlab-org/gitlab/-/commit/7c0ecf60fe8a66d408c90467586401e77c19d54f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192184))
- [Move info out of tooltip to fix accessibility problem](https://gitlab.com/gitlab-org/gitlab/-/commit/f2118f2677b5b060161337bdd4545e5ebadc67b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193043)) **GitLab Enterprise Edition**
- [Introduce policy YAML annotation experiment](https://gitlab.com/gitlab-org/gitlab/-/commit/0d3b68447b55ddd0bed5cd6efa605c99ba63f637) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193138)) **GitLab Enterprise Edition**
- [Add extra fields mappings to work items ES index](https://gitlab.com/gitlab-org/gitlab/-/commit/534fe0d3f0d8c90b1a5dccbb906fc0b6d710ffd8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192615))
- [Fix null last_call values in project analyzer status](https://gitlab.com/gitlab-org/gitlab/-/commit/cac783063b77f2972efc3b0edd026b14e9f1ce42) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193264)) **GitLab Enterprise Edition**
- [Add granular job token permissions for self project](https://gitlab.com/gitlab-org/gitlab/-/commit/f32851324793d58aff799804fcaa4414e6e7b732) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192395))
- [Display the selected ref in ref selector group](https://gitlab.com/gitlab-org/gitlab/-/commit/3879865a4375d3adc5ba3962c42923dce3c194ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193239))
- [Remove feature flag ci_limit_commit_statuses](https://gitlab.com/gitlab-org/gitlab/-/commit/bdceb69f493ec082938c920ca90cb25c0a5b1794) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193400))
- [Display help text to admins viewing sub-groups](https://gitlab.com/gitlab-org/gitlab/-/commit/fb3d670007de3a85aff52b86ce9593db863417d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193401))
- [Update Projects API status parameters to respect inherited status](https://gitlab.com/gitlab-org/gitlab/-/commit/2be4f9b8cc6995ff25233a46e98d985bb6d6dbc6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192057))
- [Fix issue with non-supported dependency packager](https://gitlab.com/gitlab-org/gitlab/-/commit/091b91aaf5b0964b17695f2bc86fb6ff2391b4ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191740)) **GitLab Enterprise Edition**
- [Add top 5 countries to country selector](https://gitlab.com/gitlab-org/gitlab/-/commit/bf17eeab78f571cc02ec17361174e97a5bd8ce4c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191683)) **GitLab Enterprise Edition**
- [Allow artifacts from Code-Quality template to be downloaded](https://gitlab.com/gitlab-org/gitlab/-/commit/47d37318a9e7dcd8c0b68da3ee924d146eb0fef7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192459))
- [Allow ai_workflows scope access to POST CI lint](https://gitlab.com/gitlab-org/gitlab/-/commit/970d6ac03d60c6c74ca7c145bf39ed9531b7c916) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193297))
- [Add active context code scheduling service and worker](https://gitlab.com/gitlab-org/gitlab/-/commit/4ec2071ab3b6008b956eabfedea73d368146d3a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192804)) **GitLab Enterprise Edition**
- [Mark row header cells in Google Cloud configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/a848da25542efe58d76e5e312f4563f020ccf8a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193021))
- [Add traversal_ids to notes index](https://gitlab.com/gitlab-org/gitlab/-/commit/55c593a3f08d2e86bd7c415c1d95b1a725de2e31) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193056)) **GitLab Enterprise Edition**
- [Sort default branch at the top of ref dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/5e9c98450918379167c913669381ee278ee73e68) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193243))
- [Fix upsert and project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/f5ad4bd239b4e2bc040594836eb0261b3245f3fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192573))
- [feat: Start remote execution jobs with service account](https://gitlab.com/gitlab-org/gitlab/-/commit/808167b100412c8416de67c97290f59297ffaace) ([merge request](https://gitlab.com/foo/bar/-/merge_requests/186391)) **GitLab Enterprise Edition**
- [Reduce spacing on role details page and fix disabled permissions click](https://gitlab.com/gitlab-org/gitlab/-/commit/f5c7d70ceaf3cc6af37989ae82e42faba5295ce0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192858)) **GitLab Enterprise Edition**
- [Remove FF resolve_vulnerability_claude_3_7_rollout](https://gitlab.com/gitlab-org/gitlab/-/commit/d63ed6647a9bbbcdea58706a8da321c8dcc49537) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190379)) **GitLab Enterprise Edition**
- [Make issue board health statuses keyboard focusable](https://gitlab.com/gitlab-org/gitlab/-/commit/18b09613052b987b097f983b2f2457d2985802e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193064))
- [Update the copy of the heading for Step 1 of Trial Registration Flow](https://gitlab.com/gitlab-org/gitlab/-/commit/c05f7f1bd3ac5a78066b50ae660039900742d31e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193049)) **GitLab Enterprise Edition**
- [Replace build_id type in AnalyzerProjectStatusType to BigInt](https://gitlab.com/gitlab-org/gitlab/-/commit/66cdce51c1ab9d79a47512a01810e7953cfc4173) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192649))
- [Rollout work item embeddings for gitlab project](https://gitlab.com/gitlab-org/gitlab/-/commit/2990040426eb7d24767541fa4d436bb82a7b1e7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192759)) **GitLab Enterprise Edition**
- [Add secure variable as default](https://gitlab.com/gitlab-org/gitlab/-/commit/f64547744047f72fc8fe40b707babd42da8cca15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191405)) **GitLab Enterprise Edition**
- [Update texts for the policy drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/e73512d613ad53c0362a4c601a8e0b9e12ab8a25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192578)) **GitLab Enterprise Edition**
- [Use authorize shorthand instead of Ability.allowed](https://gitlab.com/gitlab-org/gitlab/-/commit/8afb11895266740d3ee17d6004333cef69cf181e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192870)) **GitLab Enterprise Edition**
- [Fix updated_at not updating in analyzer_project_statuses](https://gitlab.com/gitlab-org/gitlab/-/commit/35f93d9c9a865c699953651b6b5b4fe7201f8781) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192907)) **GitLab Enterprise Edition**
- [Reduce permission scope of Duo workflow action](https://gitlab.com/gitlab-org/gitlab/-/commit/8e2825a9118c658d80a540f23ac1c795820990a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193146)) **GitLab Enterprise Edition**
- [Add Pipeline ID to page title](https://gitlab.com/gitlab-org/gitlab/-/commit/7e21edfecb5b1d25a145e7c41af59b46c10cfc9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193126))
- [Commits view: Add 'Browse files' button](https://gitlab.com/gitlab-org/gitlab/-/commit/cb61443941e151f9796f870ed1f8729edfda150d) by @santigl ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188479))
- [Make issue board header data focusable on keyboard](https://gitlab.com/gitlab-org/gitlab/-/commit/b6515527013bcd22b838a32872cf11780eef24ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193054))
- [Downgrade Workhorse PubSub EOF errors to info messages](https://gitlab.com/gitlab-org/gitlab/-/commit/960388a20ac772c572f4b5f74ef7e83e017caa5d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192959))
- [Default enable duo_code_review_show_all_comments](https://gitlab.com/gitlab-org/gitlab/-/commit/4c23966f366a5501eedb2c4bcafe2d850dcdf7bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192973)) **GitLab Enterprise Edition**
- [Allow customer with ramp subscriptions to purchase addons](https://gitlab.com/gitlab-org/gitlab/-/commit/bc78bc08eeaa3cf7031df5c20e065599bfdfd901) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192688)) **GitLab Enterprise Edition**
- [Enable group-level control of web-based commit signing](https://gitlab.com/gitlab-org/gitlab/-/commit/43e51f4fc71c33b9a6adef1115b33d388e90dd59) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191945)) **GitLab Enterprise Edition**
- [Set destroy_fork_network_on_archive true](https://gitlab.com/gitlab-org/gitlab/-/commit/e28df045511e83e20c4487b67def9e7c2cc63b83) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192882))
- [Improve DCR comment line position handling](https://gitlab.com/gitlab-org/gitlab/-/commit/f5d7a15174bdcef1453431805d3db1ad0f2f0425) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192617)) **GitLab Enterprise Edition**
- [Update project_user_defined_variables_restricted_to_maintainers labels](https://gitlab.com/gitlab-org/gitlab/-/commit/ab4a77372fe7ea8bb358bb4aa6c582cf24551d9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192740)) **GitLab Enterprise Edition**
- [Remove default for actual_state_updated_at](https://gitlab.com/gitlab-org/gitlab/-/commit/532bb752618d2f36570f26c63e79587731b0de8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192860)) **GitLab Enterprise Edition**
- [Rename OrganizationUserAlias to OrganizationUserDetail](https://gitlab.com/gitlab-org/gitlab/-/commit/6ddc818e8dc7ffe5b2eb393d5201571123630e89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191575))
- [Move topics list into crudcomponent](https://gitlab.com/gitlab-org/gitlab/-/commit/81717ae7ddb3bf69693a547ed3d59f654fdb1cfe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192840))
- [Change `permanent_deletion_date` GraphQL field for groups and projects](https://gitlab.com/gitlab-org/gitlab/-/commit/64f38305c76559e422d08238a9227d3987aaf9ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192030))
- [Changed issue description template dropdown to default size](https://gitlab.com/gitlab-org/gitlab/-/commit/7f00d5f294f23722fef1625466c9bf8270c6b7f2) by @zillemarco ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192749))
- [Security Inventory data should be visible by Dev+](https://gitlab.com/gitlab-org/gitlab/-/commit/74cfcb5a47d2252902fe49e0380004d7ff26a24e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192163)) **GitLab Enterprise Edition**
- [Replace index with ci_triggers (project_id, id)](https://gitlab.com/gitlab-org/gitlab/-/commit/36bfcbef22f61729ed7f465cf36da4920ffdd005) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192734))
- [Present queue_size and queue_depth in CI job payload](https://gitlab.com/gitlab-org/gitlab/-/commit/e21fce56701af699afc4e8463321bdcce46cf5e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192572))
- [Adjust UI elements and styling of search modal](https://gitlab.com/gitlab-org/gitlab/-/commit/50960f66ce39619a43244981a92c8837c7c54a78) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191965))
- [Change HNSW engine from nmslib to lucene](https://gitlab.com/gitlab-org/gitlab/-/commit/12bb3c2561ed8460a4660d123ade05785a15f826) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192197)) **GitLab Enterprise Edition**
- [Add check for empty policy_hash](https://gitlab.com/gitlab-org/gitlab/-/commit/7e08288f94cc4a5831252c63533eb626a92f50b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192574)) **GitLab Enterprise Edition**
- [Improve adjustment service stability](https://gitlab.com/gitlab-org/gitlab/-/commit/c4e6d780d704bf95b878b367ff7b34a5ed029474) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192679)) **GitLab Enterprise Edition**
- [Move closer access token expiration and lifetime settings](https://gitlab.com/gitlab-org/gitlab/-/commit/37ed8a5ab6a004285854daebfbe436f3933dae4d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192675))
- [Fix responsive layout for admin role LDAP sync table and roles table](https://gitlab.com/gitlab-org/gitlab/-/commit/c16a87122e3ce493008fc83044d92cafd3997479) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191687)) **GitLab Enterprise Edition**
- [Add PHP language support to gitlab-advanced-sast](https://gitlab.com/gitlab-org/gitlab/-/commit/25bcd5ea787b88718e905e04b46daf20bbf6e46e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185133))
- [Update Groups API status parameters to respect inherited status](https://gitlab.com/gitlab-org/gitlab/-/commit/eca3f4fa04e47bd3e6f75d1b868ed0ea1628dd05) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191477))
- [Implement various UI fixes for framework info drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/e8cb4173a87c2984886a033550b8fe0ff7788ad3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192602)) **GitLab Enterprise Edition**
- [Frontend changes to support external control name](https://gitlab.com/gitlab-org/gitlab/-/commit/793512e33ebf26413ba5e44b3a05b856c79c218d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192177)) **GitLab Enterprise Edition**
- [Protected containers: Allow rule editing](https://gitlab.com/gitlab-org/gitlab/-/commit/44dcce39176bb83c03afda9326c04af33883592f) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191241))
- [Add source and target branches to branch_exceptions](https://gitlab.com/gitlab-org/gitlab/-/commit/cf644b8ca8a358a0b1cd4d91fde9128bae31aad0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191829)) **GitLab Enterprise Edition**
- [Remove default selection in project import dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/431bbbf0a49b718c00bdadbf8ad3d48c311b1bcf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190598))
- [Track audit log visits with active frameworks](https://gitlab.com/gitlab-org/gitlab/-/commit/af55168df94f645130488c7b4a2d16777d117b39) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174039)) **GitLab Enterprise Edition**
- [Protect pipelines of MRs between protectd branches](https://gitlab.com/gitlab-org/gitlab/-/commit/c0105f80606d78ea9a6de90de999cf88014154da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188008))
- [Move DuoWorkflowAction to use GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/f1b240a32787610fcceec06836ce6b8f243f8909) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191640)) **GitLab Enterprise Edition**
- [Pass search term for project to backend for attach new issue](https://gitlab.com/gitlab-org/gitlab/-/commit/07fe6597a022d534f50206cac1d9f2cbd157b146) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192244)) **GitLab Enterprise Edition**
- [Increase Duo Code Review request timeout](https://gitlab.com/gitlab-org/gitlab/-/commit/14eacfdf026a77826a41f924f21ca839490396d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192187)) **GitLab Enterprise Edition**
- [Migrate harbor registry breadcrumb to new method](https://gitlab.com/gitlab-org/gitlab/-/commit/a39ee577f9ff393873736f7d9930a6f0be4f7928) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191549))
- [Decrease height of wiki sidebar items](https://gitlab.com/gitlab-org/gitlab/-/commit/e934b9224dd4ba6ed070cc512f386c63e42faaba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192419))
- [Limit the number of tags displayed](https://gitlab.com/gitlab-org/gitlab/-/commit/b3e60c3f516e67aa400eedd2da553a0d177f894a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190470))
- [Use GitLabSchema.parse_gid for ids filter](https://gitlab.com/gitlab-org/gitlab/-/commit/e07ccab30634ff6ae4e2cef6680e3ab7a1c4dc97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191969)) **GitLab Enterprise Edition**
- [Show label names in work items labels widget](https://gitlab.com/gitlab-org/gitlab/-/commit/5c896aa1e1dfd24712019fd30e456ca7496cf842) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189946))
- [Move files from ai/context/ to ai/active_context](https://gitlab.com/gitlab-org/gitlab/-/commit/d7a563445b65cdb27b2d230694d7133af0fdab50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192338)) **GitLab Enterprise Edition**
- [Do not backoff webhook if disabling not enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/ce13b80bf00ef28028cc4498f49b8d5a76c603d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191893))
- [Add Auditor as a filter option to the Admin users page](https://gitlab.com/gitlab-org/gitlab/-/commit/b054bd82e7232dec079c980eb8d452af2c64f932) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192286)) **GitLab Enterprise Edition**
- [Fixed flashing of no results screens while loading](https://gitlab.com/gitlab-org/gitlab/-/commit/652e71a046fa174d1e333e67d685d03703ea47e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192274))
- [Pages settings: Migrate delete action block](https://gitlab.com/gitlab-org/gitlab/-/commit/7c31f2ebba4141dddccaf662c702f8b431e65850) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191757))
- [Remove FF for SSRF protection for dependency proxy](https://gitlab.com/gitlab-org/gitlab/-/commit/1eafc1da85002fd08a84d086b0534c1e53ebe629) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192238))
- [Add patch for attribute_instance_methods_as_symbols_available method](https://gitlab.com/gitlab-org/gitlab/-/commit/c52f2bdf3c3b55d478248bb06600b18d0d0fd21f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191972))
- [Add Prometheus histogram for PEP dry run duration](https://gitlab.com/gitlab-org/gitlab/-/commit/097f36aceb6dbb4d69bd64be49eac6a79a88498a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191611)) **GitLab Enterprise Edition**
- [Increase Duo Workflow goal limit to 16k bytes](https://gitlab.com/gitlab-org/gitlab/-/commit/13461f57b9f087055e23651eead75cdc716c1cbb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192170)) **GitLab Enterprise Edition**
- [Pages settings: Move settings into a Crud](https://gitlab.com/gitlab-org/gitlab/-/commit/5fac14c733f13dca15c698c55791dc3d32b81bfd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192195))
- [Resolve compromised password detection on change](https://gitlab.com/gitlab-org/gitlab/-/commit/dacd7d27d3212166e45224f8d7b8b16223d29493) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191581)) **GitLab Enterprise Edition**
- [Pages settings: Update copy of domain settings](https://gitlab.com/gitlab-org/gitlab/-/commit/3276cff31577fac3cd159787df8cdfae50ba1a00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191749))
- [Make "lock discussion" menu item behave like "confidential" item](https://gitlab.com/gitlab-org/gitlab/-/commit/c04fdb77a5ba72fbefaa233daa6b0dc809988ed5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192165))
- [feat: Enable WebIde to open to line in project](https://gitlab.com/gitlab-org/gitlab/-/commit/26f75856d04b4e09c10788fbac6ca8e0e419e86c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188173))
- [fix: LSP Issue 1955 fix for filtering by type](https://gitlab.com/gitlab-org/gitlab/-/commit/28823c856d329bf1fcc29dcec2ae809fb0052ca7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192027)) **GitLab Enterprise Edition**
- [Expose 'ai_resolution_enabled' in vulnerability serialization](https://gitlab.com/gitlab-org/gitlab/-/commit/cc546a725d43c0e9d842f4edb34be3552890e715) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191342)) **GitLab Enterprise Edition**
- [Clean up aigw v1 chat redirect ff](https://gitlab.com/gitlab-org/gitlab/-/commit/9b9650ae26f819c401a452699c5dbfc6553d6742) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192137))
- [Conditionally sign web based commits on Saas](https://gitlab.com/gitlab-org/gitlab/-/commit/17487310b4cdf200ca7edb9a3cdc46826cca9f05) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191520)) **GitLab Enterprise Edition**
- [Visibility repository help text: Use <code> instead of **](https://gitlab.com/gitlab-org/gitlab/-/commit/048229e27fc7b34fdd8cffbf016a38c13175c272) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191952))
- [Add group cn dropdown for admin role ldap sync form](https://gitlab.com/gitlab-org/gitlab/-/commit/077679a2092d0c239d9a71f860b0d9a571128e39) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190982)) **GitLab Enterprise Edition**
- [Change author of duo todos to internal duo bot](https://gitlab.com/gitlab-org/gitlab/-/commit/c40fe6a57363c2761391ec9304ea361ad7648355) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191527)) **GitLab Enterprise Edition**
- [Combined policy list for policy table](https://gitlab.com/gitlab-org/gitlab/-/commit/a7b3bc843b5d28fa23cf971eb20b7dfe74569b15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190127)) **GitLab Enterprise Edition**
- [Remove forcing legacy epic view](https://gitlab.com/gitlab-org/gitlab/-/commit/6ef4f0b2b24267e6324b72342369615b9cf973f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192095)) **GitLab Enterprise Edition**
- [Add posibility to filter work items by parent reference](https://gitlab.com/gitlab-org/gitlab/-/commit/219003bbeb3dc87d2ddaf5bc9cd463aa7e3eab18) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189012))
- [Move webhook secret token to Vue](https://gitlab.com/gitlab-org/gitlab/-/commit/0c6cba44b44f4297f72660511460296b1bd736f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191498))
- [Fix navigation from environment to job page](https://gitlab.com/gitlab-org/gitlab/-/commit/90b1330828a1454d57dc575f32ebcf2817b405f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191350))
- [Remove duo_chat_read_directly_from_db feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/69ca367064964f453d5df65190e8e88d518fa41c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191259)) **GitLab Enterprise Edition**
- [Expose "active" parameter to the projects graphql api](https://gitlab.com/gitlab-org/gitlab/-/commit/d8b52156c5c14c0a1cbb6b6cd852f3a441452b90) by @dagaranupam ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187068))
- [Don't require password confirmation when password auth is disabled](https://gitlab.com/gitlab-org/gitlab/-/commit/aa6ac27a17194fe302d675901b1f97ef0aed0952) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191995)) **GitLab Enterprise Edition**
- [Don't require password confirmation when group disables password auth](https://gitlab.com/gitlab-org/gitlab/-/commit/276483c4673a63350827e9ffb928edbecb9920af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191261)) **GitLab Enterprise Edition**
- [Zoekt: Add lost node threashold setting](https://gitlab.com/gitlab-org/gitlab/-/commit/96e89c6bb2af80d9cadb49ddcd393e860213ea6f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191662)) **GitLab Enterprise Edition**
- [Always show zoekt preference when feature is enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/7f5f5f7d47c723b1b6b5403fa4df3cc71b9c180e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191472)) **GitLab Enterprise Edition**
- [Allow GLQL searching work items by author name in ES](https://gitlab.com/gitlab-org/gitlab/-/commit/0fa2f639091421624eb364dadfe026a944c85cb7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188554))
- [Default enable use_approval_policy_rules_for_approval_rules](https://gitlab.com/gitlab-org/gitlab/-/commit/9425670c3754daab70bf38aa182db8eaad3df961) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191914)) **GitLab Enterprise Edition**
- [Rename `Inactive Projects` to `Dormant Projects`](https://gitlab.com/gitlab-org/gitlab/-/commit/e90579c3e02be1d8cac4dbb46a463ff232c8f94d) by @bhanutejach9 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189969))
- [Set Fireworks-hosted Codestral as defualt code completion](https://gitlab.com/gitlab-org/gitlab/-/commit/3db78e21256302268d5912de68e3345f841a8d6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191340)) **GitLab Enterprise Edition**
- [Add margin to drawer issue link](https://gitlab.com/gitlab-org/gitlab/-/commit/8cdc9ee403a182abf3079847bec5247d53fb68a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191848))
- [Backfill has_vulnerability_resolution for CWE-78 and CWE-89](https://gitlab.com/gitlab-org/gitlab/-/commit/b4d33b9f5e081bd23848d455d1161b06ca71fe83) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188420)) **GitLab Enterprise Edition**
- [Remove nav spacing in fullscreen on job](https://gitlab.com/gitlab-org/gitlab/-/commit/89866349024b7bb3ffdb83d1a8d6fecaf4f2adb9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191832))
- [Pages: Add tabs](https://gitlab.com/gitlab-org/gitlab/-/commit/e38273ac53f63b17e179ce6350bc1bc518c5bca0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191744))
- [Change batch_size & helper in BackfillWorkItemMilestoneData migration](https://gitlab.com/gitlab-org/gitlab/-/commit/f99d3a04e32372a5e9ed16ccfef88bd011395850) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191645)) **GitLab Enterprise Edition**
- [Pages domain verification status migrations](https://gitlab.com/gitlab-org/gitlab/-/commit/53c44a7ffb6d5c7edd10d82df76a57022b118bec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191787))
- [Remove duoSettings object from Duo setting update GraphQL mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/3a1d19455f7a5efde0a51a2b8947e195434af4c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190971)) **GitLab Enterprise Edition**
- [Add option to force resync security policies](https://gitlab.com/gitlab-org/gitlab/-/commit/9cb0e08e10513d4bb5d47fdb20a3c6dfa176be2c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190358)) **GitLab Enterprise Edition**
- [Log when `.safe_find_or_create_by` cannot find a row that should exist](https://gitlab.com/gitlab-org/gitlab/-/commit/7500f5db88de61bce98f39b27f1196e40c3f0629) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191716))
- [Remove unused href](https://gitlab.com/gitlab-org/gitlab/-/commit/491202ac70ce85267d99dc908ccbdc22cad567af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191682)) **GitLab Enterprise Edition**
- [Use design tokens in pipeline graph job hover](https://gitlab.com/gitlab-org/gitlab/-/commit/bb2fa5db6f31457e1b6b6341b498af89928880eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190255))
- [GLQL table view: Use link color for title link](https://gitlab.com/gitlab-org/gitlab/-/commit/3425118a5ddfcba75c434f066801ae4a04338369) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191632))
- [Pages deployments: Cleanup loading, error and empty states](https://gitlab.com/gitlab-org/gitlab/-/commit/6c49f5dc5539a487a6b4a812612da640a13534ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191625))
- [Convert try walkthrough link to button](https://gitlab.com/gitlab-org/gitlab/-/commit/1c02466aefb625ae62a5cadb6cd624596e3a2bdb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191526)) **GitLab Enterprise Edition**
- [MR widgets: Update border radius from base to lg](https://gitlab.com/gitlab-org/gitlab/-/commit/a6e93185216788cbf20d1ab47d93dca0ce28d88e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191455))
- [Create `project_authorizations_for_migrations` table](https://gitlab.com/gitlab-org/gitlab/-/commit/fccdb4e82373ae69a1fa5e71912376306b4ff97b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190374))
- [Use AI-native terminology](https://gitlab.com/gitlab-org/gitlab/-/commit/1001a08c6fbba5092fdcf80a77128a3492840e54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190792)) **GitLab Enterprise Edition**
- [Migrate google artifact registry breadcrumb to new method](https://gitlab.com/gitlab-org/gitlab/-/commit/0a4090107948a63772d80e4dbd48d877a0276919) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191550)) **GitLab Enterprise Edition**
- [Migrate workspace breadcrumbs to single nav option](https://gitlab.com/gitlab-org/gitlab/-/commit/a238cce65d9d2f1b3b8cfbc5d54a3d587634034e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191228)) **GitLab Enterprise Edition**
- [Use user profile timezone for timelog quick actions and system notes](https://gitlab.com/gitlab-org/gitlab/-/commit/84a274244925213306bd80d6413a3b6c701f7f69) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189648))
- [Clean up `new_implementation_of_invite_members_search` FF and old code](https://gitlab.com/gitlab-org/gitlab/-/commit/d789201f150ac9fbcde2b3faa5f53a76d3ae59f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191516))
- [Project area heading 1 migrations](https://gitlab.com/gitlab-org/gitlab/-/commit/b2f6c5b21a58f2dc5dac42398e36018bb1806f02) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190838))
- [Add human readable audit event labels](https://gitlab.com/gitlab-org/gitlab/-/commit/3d41ff2b310e147456ff90f8de3111115aa6c115) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191088)) **GitLab Enterprise Edition**
- [Notes: Increase border radius from base to lg](https://gitlab.com/gitlab-org/gitlab/-/commit/48119596bef34e3b2c09396e5580d0e2f0d9d856) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191451))
- [Add a flat policy list of all types](https://gitlab.com/gitlab-org/gitlab/-/commit/8726b77c76a6a487db87a37043c83f8f62218f7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185279)) **GitLab Enterprise Edition**
- [Show warning when user has no Duo code review access](https://gitlab.com/gitlab-org/gitlab/-/commit/2547ea734ec2b9783f60ff25df714cba583ac4db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190795)) **GitLab Enterprise Edition**
- [Add UserFilterFormGroup for admin role ldap sync form](https://gitlab.com/gitlab-org/gitlab/-/commit/c4e474e6930c49a9e827387ac907aef26197d139) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191172)) **GitLab Enterprise Edition**
- [Cleanup new_duo_workflow_service feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/725b5a795ca346b3d88dea3d29d8c668e4ec3aaf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191422)) **GitLab Enterprise Edition**
- [Backend changes to support 'external_control_name'](https://gitlab.com/gitlab-org/gitlab/-/commit/922a9516efa26cf10cfed044a11d3fc33e199203) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190422)) **GitLab Enterprise Edition**
- [Migrate CI Secrets breadcrumbs to new method](https://gitlab.com/gitlab-org/gitlab/-/commit/ca4f518fbb6de00cb5b7ecfb17da9222f7bcb8a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191390)) **GitLab Enterprise Edition**
- [Migrate analytics dashboard vue breadcrumb to new injection method](https://gitlab.com/gitlab-org/gitlab/-/commit/74f18fb28f50e6cf335dd112a2c195fc0957d037) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191065))
- [Use timezone related dates in expiring subscription message code](https://gitlab.com/gitlab-org/gitlab/-/commit/efb65dc79d59720f944a06edd8038996cb3e4bea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191003)) **GitLab Enterprise Edition**
- [Add policy validation for pipeline execution schedule count](https://gitlab.com/gitlab-org/gitlab/-/commit/f3a02eef41f9226db4e595a7bf551826ff046bfd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191028)) **GitLab Enterprise Edition**
- [Backfill milestone title and id in work items index](https://gitlab.com/gitlab-org/gitlab/-/commit/120aa7d0615bc5e60a1a415b056f0b62ff3feeb6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189288)) **GitLab Enterprise Edition**
- [Translucent sticky header: Increase transparency in darkmode](https://gitlab.com/gitlab-org/gitlab/-/commit/a411f83305531d047f3e68968aa797c2bf6da2b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191314))
- [Update dependency auto-deploy-image to v2.130.0](https://gitlab.com/gitlab-org/gitlab/-/commit/1670063f2ecbe863ac06e1c297d764c8557ea416) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191280))
- [Backfill pipeline execution policy enforced scans](https://gitlab.com/gitlab-org/gitlab/-/commit/98b24a1f3c44d460c0917e12b9e54b286ce9fe48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181995)) **GitLab Enterprise Edition**
- [Add additional condition for banner](https://gitlab.com/gitlab-org/gitlab/-/commit/729f10f7e4528d88a37cdddcfe697643284defe5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191058)) **GitLab Enterprise Edition**
- [Add outbound allowlist to allowed endpoints for SSRF filter](https://gitlab.com/gitlab-org/gitlab/-/commit/5aae09dedd1c71b5aec1f8e6fd546fef2ba6e8c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188915)) **GitLab Enterprise Edition**
- [Add type-specific policy constructors](https://gitlab.com/gitlab-org/gitlab/-/commit/0ef30f6b8692c8daa68616c336cea916ecd65442) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191086)) **GitLab Enterprise Edition**
- [Use localstorage for todos page size](https://gitlab.com/gitlab-org/gitlab/-/commit/d9bd3764d2e091901d8d4feacec91698fedbfe4e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188493))
- [Update placeholder text for filters in search modal](https://gitlab.com/gitlab-org/gitlab/-/commit/0dddcd056749f35e790cd9cdd269ae6b82e44af8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191188))
- [Convert filter include forked to exlude forks](https://gitlab.com/gitlab-org/gitlab/-/commit/ee147991f3ae70f667ae2109de650052256a9858) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190395))
- [Update banner to include dark mode svg bg](https://gitlab.com/gitlab-org/gitlab/-/commit/463c89f2f39ef464d173ed7bd6be87fb58d74027) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191199)) **GitLab Enterprise Edition**
- [Doorkeeper Heading 1 migrations](https://gitlab.com/gitlab-org/gitlab/-/commit/adbdade701a0d1f89c68c8fc16edede59433adda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190829))
- [Remove pipeline reference from Duo Workflow alert](https://gitlab.com/gitlab-org/gitlab/-/commit/e8a17019d8fbe5eeab1f533f2477e808c7491e34) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191131)) **GitLab Enterprise Edition**
- [Pages deployments: Migrate to Crud](https://gitlab.com/gitlab-org/gitlab/-/commit/e990ac73600eb200bbdbfe3b2bb18689043af657) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191029))
- [Align delete policy button](https://gitlab.com/gitlab-org/gitlab/-/commit/fb1664a57100e696a6e8190c07f6f38464458f38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191089)) **GitLab Enterprise Edition**
- [Update package registry details UI](https://gitlab.com/gitlab-org/gitlab/-/commit/e99138b743dc9a29616f185bae240e7aba65df77) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190884))
- [Migrate Iterations breadcrumb to new injection method](https://gitlab.com/gitlab-org/gitlab/-/commit/36e48f9c4a81ad105d1dadd3966f4be620fba98b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191067)) **GitLab Enterprise Edition**
- [Add max and min date for the new PATs UI](https://gitlab.com/gitlab-org/gitlab/-/commit/08d6f4ba7447905ef2953cd3a588b278a6b6ee13) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191004))
- [Raise default Puma memory limits to 1.5 GB](https://gitlab.com/gitlab-org/gitlab/-/commit/6bddaaa69b5519008438e3e4b54b7371e5d2718f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190880))
- [Update order of container registry header buttons](https://gitlab.com/gitlab-org/gitlab/-/commit/53e74e8488fa7a77ddb8b43736c717ba32f0a727) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190870))
- [Updates the link text for the GitLab community forum](https://gitlab.com/gitlab-org/gitlab/-/commit/f62a23295dc5724971d96c7c24b5f507643a840a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190850))

### Removed (36 changes)

- [Remove work_item_epics feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/6e60516c89a7ead859476b1942109a89dda296a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193617)) **GitLab Enterprise Edition**
- [Remove FF and references](https://gitlab.com/gitlab-org/gitlab/-/commit/920af79a7bc240f3d4cd8fb1061ed88e907be52a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194100))
- [Remove feature flag duo chat react agent claude 4](https://gitlab.com/gitlab-org/gitlab/-/commit/bf1db0761648081efd5d46fd10641df9adcbfdb8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194073)) **GitLab Enterprise Edition**
- [Revert "Merge branch '14389-project-and-branch-variables-for-markdown' into 'master'"](https://gitlab.com/gitlab-org/gitlab/-/commit/a17d693418a6b42cd378de24fdf847d4bb3573a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193977))
- [Delete the `work_items_view_preference` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/0024629616a7cfa6a300493d0b52622dcb8108cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193325))
- [Clean up `blob_repository_vue_header_app` flag](https://gitlab.com/gitlab-org/gitlab/-/commit/5d6fa5b87829c8378eed46b5efdf5ec8b397c3be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193201))
- [Remove namespace_level_work_items feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/83e6e699a10342d2c52e415e1827b20b237fc622) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193609))
- [Drop ci_trigger_requests and remove Ci::TriggerRequest](https://gitlab.com/gitlab-org/gitlab/-/commit/d5e0ae9c824420e580ee9758a3e3c4426e596954) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191769))
- [Drop duplicate index ci_pipeline_variables](https://gitlab.com/gitlab-org/gitlab/-/commit/58bb7ead03fcf59ed4fe4637f9dd8151eba5ce6e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192533))
- [Remove add_on_purchases from AvailableServices](https://gitlab.com/gitlab-org/gitlab/-/commit/1aaa08253c04a1f16dc24806685840cb7be5567f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192366)) **GitLab Enterprise Edition**
- [Dropped project_fingerpint column](https://gitlab.com/gitlab-org/gitlab/-/commit/ad5407d935a6ed527ab58741fd1399b23d7feecc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191265))
- [Stop enqueuing epic validation worker](https://gitlab.com/gitlab-org/gitlab/-/commit/7393277680aac113cb2a22b3c25873c4924ab820) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192391)) **GitLab Enterprise Edition**
- [Delete the `blob_overflow_menu` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/1376b5b00c9c2157218fe6d79f404e0f63e41b3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191325))
- [Dropped project_fingerprint column](https://gitlab.com/gitlab-org/gitlab/-/commit/4ce78db22d33d7e4fe3cae5a2810f371d2228413) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191300))
- [Chore: remove unneeded duo workflow feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/4b7c87c8791e1956e96f069ece5cc8ef75619ede) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193348))
- [Drop unused group_icon and topic_icon helpers](https://gitlab.com/gitlab-org/gitlab/-/commit/11fc6f614b1281f72431a50a2a7fd171dab66e0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193332))
- [Drop unused #search_filter_link method](https://gitlab.com/gitlab-org/gitlab/-/commit/856f9e3c61a79f49e290b7a54c10acb836a60f60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193233))
- [Cleanup BBM BackfillFreeSharedRunnersMinutesLimit](https://gitlab.com/gitlab-org/gitlab/-/commit/1c09f2bdaba2856ebe58a2617295cea54dbec74c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188077))
- [Drop catalog resource component usages table](https://gitlab.com/gitlab-org/gitlab/-/commit/4b520cc7f851ce67ddc90c3055ddf4f6794139d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192871))
- [Update text embeddings for VertexAI Client](https://gitlab.com/gitlab-org/gitlab/-/commit/454a2fd0e2cdd6a07378a112bc8264595fcb9cc3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192144)) **GitLab Enterprise Edition**
- [Remove unused feature flag `work_item_status_transitions`](https://gitlab.com/gitlab-org/gitlab/-/commit/fb92732e7a9b03e002568a1344ff8ca2d8fc4422) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192384))
- [Delete the `search_button_top_right` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/70cff5108e612842e33e5365d6e02c68b2762c0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191161))
- [Revert "Merge branch '434218-revert-ff-removal' into 'master'"](https://gitlab.com/gitlab-org/gitlab/-/commit/74d947f3a8e933f86900a4269e52bbacd24a9dcc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191360)) **GitLab Enterprise Edition**
- [Remove periodicalnamespace_descendants_cache FF](https://gitlab.com/gitlab-org/gitlab/-/commit/672495a9db3d8e321ec3df5d33a00aa7b3dff5c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192752))
- [Remove QueueRefreshOfBrokenAdherenceGroupsWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/0914a7c3c2619fecc011ab443ccf2dedfc246dfa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192273)) **GitLab Enterprise Edition**
- [Remove x-gitlab-duo-seat-count HTTP header](https://gitlab.com/gitlab-org/gitlab/-/commit/0623658221b68cca94467639fbf627fbbf8dbea6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191126)) **GitLab Enterprise Edition**
- [Delete the `advanced_search_work_item_uses_note_fields` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/ba5c971055c798e010f4afded7c6135cb9059827) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191698))
- [Remove include_forked param](https://gitlab.com/gitlab-org/gitlab/-/commit/67a94f91248d2f722d0a59bd9e7bdcf77ed8a88a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191564)) **GitLab Enterprise Edition**
- [Remove unused project_branches helper method](https://gitlab.com/gitlab-org/gitlab/-/commit/55573ced378f73fe7e67ae76f95ef051e1777bd1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191881))
- [Remove unused link_to_wiki_page helper method](https://gitlab.com/gitlab-org/gitlab/-/commit/82a1fca617ddead7b2cf14c62bd4cd4c93129856) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191858))
- [Dropped project_fingerprint column](https://gitlab.com/gitlab-org/gitlab/-/commit/8be9aefdb7b76594679cc07fb98e5c6e5a25045d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191269))
- [Remove read_admin_dasbhoard custom admin ability](https://gitlab.com/gitlab-org/gitlab/-/commit/2a866471b2f5d11c0cb6c574d464638a2742ecb5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189132)) **GitLab Enterprise Edition**
- [Remove redundant index ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/a8ea49c57152f588fff5b7100b90313ead31f0b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191175))
- [Remove derisk FF: `resolve_vulnerability_send_finding_description`](https://gitlab.com/gitlab-org/gitlab/-/commit/dbb75c30330f59814d020927bdf05aa584cf5349) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191313)) **GitLab Enterprise Edition**
- [Drop p_ci_builds.trigger_request_id](https://gitlab.com/gitlab-org/gitlab/-/commit/6227e0c33aaae3fac67c374a32999d42038b6301) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190960))
- [Delete the `zoekt_critical_watermark_stop_indexing` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/a77d81b142b84e1d2b8d39b5015cd10b75197156) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190962))

### Security (19 changes)

- [Added additinal sanitization](https://gitlab.com/gitlab-org/gitlab/-/commit/80d0d595a34410f1784e2d7905a6d55073305f3e)
- [Fix # #1329 - IDOR in compliance framework export endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/126fe92ee74856bda0c83ff425b45eba7d22ae93)
- [Fix XSS with CSP bypass in JSON tables](https://gitlab.com/gitlab-org/gitlab/-/commit/cdcf70509ca177faab705c81fc1ad4c8bc5d8846)
- [security: Git redirection inconsistency](https://gitlab.com/gitlab-org/gitlab/-/commit/54bdbd4638f4d92af0eb9b93b5d379ef861d7b2b)
- [Add validation for board name length](https://gitlab.com/gitlab-org/gitlab/-/commit/b5067ab36cdc5b52c288f670d38183328254b9b4)
- [Protect webhook from excessive payload lengths](https://gitlab.com/gitlab-org/gitlab/-/commit/05d673100709748da289fabb787aa89465029e09)
- [Limit HTTP response size](https://gitlab.com/gitlab-org/gitlab/-/commit/facbc7428698055a032ac6af41a3190fbbdcbca7)
- [Endless Redirect Loop in any project when query param "format" is "git"](https://gitlab.com/gitlab-org/gitlab/-/commit/063e73be3df53e23277ebab797f168ec8a42fe2c)
- [Fix authorization for compliance frameworks projects](https://gitlab.com/gitlab-org/gitlab/-/commit/197955ca0fe63975481c8f282510b5a0447a5c81)
- [Limit length of certificate cluster text fields](https://gitlab.com/gitlab-org/gitlab/-/commit/3aec1d644dbb9423e982eb781e89701dbcdbd3d9)
- [Security 479168 discord zip vulnerability](https://gitlab.com/gitlab-org/gitlab/-/commit/d24760cb6a934838765021a3d5ae14d8b8f00ed7)
- [Remove trace field as it is already added in the interface](https://gitlab.com/gitlab-org/gitlab/-/commit/863e01239a13246c001c2b5e6dd431e16ff90b52)
- [Use CI::VariableValue in BasicEntity to prevent exposing hidden values in collapsible UI element](https://gitlab.com/gitlab-org/gitlab/-/commit/1bd9033103a48e248ada5bcec267b5e02d92aeec)
- [Show full path of project in create MR dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/cc8db4c429b2b24affde59c8fdc9860711c38ab7)
- [Check rate limit for over-sized blobs](https://gitlab.com/gitlab-org/gitlab/-/commit/dadbfc188a26f1a11c83812875595415c24b90c1)
- [Added size constraint validation to notes position fields](https://gitlab.com/gitlab-org/gitlab/-/commit/353f72582ead37c8569ad5a56769236716536cf5)
- [Obfuscate emails in note.bodyFirstLineHtml](https://gitlab.com/gitlab-org/gitlab/-/commit/53605f1fec66d5ad2479d925f02456dc56505cc8)
- [Need to update 2fa requirement after accepting request](https://gitlab.com/gitlab-org/gitlab/-/commit/9ab5c2e1c7b62cf061c9317efacde70a7dba6095)
- [Ensure SAML authn context comes from signed portion of SAML response](https://gitlab.com/gitlab-org/gitlab/-/commit/56e882a0dbe75d773c31a8fc250e0b19d018f22f)

### Performance (7 changes)

- [Delete all user todos in batches from MigrateRecordsToGhostUserService](https://gitlab.com/gitlab-org/gitlab/-/commit/8dcf562e173750c857e8b74c841b4fb212c4322d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192731))
- [Remove skip_custom_roles_queries feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/7be8187b21aafb1b36bfe927ce5333fba286d03b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193694))
- [Performance improvements for gitlab:doctor:secrets](https://gitlab.com/gitlab-org/gitlab/-/commit/2b51c059cc497c5ea949a5ec907b3550745ffb3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190206))
- [Fix SQL N+1 issue for list project MRs endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/32a584dceac69463b1bb37abb347d524ef8648a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192881))
- [Remove reduce_lock_usage_during_partition_creation FF](https://gitlab.com/gitlab-org/gitlab/-/commit/b3f6a67dbcd01509128f5c21a8f6d4f69b7776f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192074))
- [Lazy load set status modal](https://gitlab.com/gitlab-org/gitlab/-/commit/ffa5897ebe0d59830bdb3995e4ee0c79f4ca4587) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191485))
- [Improve performance of Members::ExpiringWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/f3ce677cac9b4ce8d11af05f9571c8213e6a320d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187045))

### Other (217 changes)

- [Adapt documentation to new PATs UI](https://gitlab.com/gitlab-org/gitlab/-/commit/6d68c0148818631768a53c9fc02198cc517f1263) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194585))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/19ce81139e9ac4c3fa6b07e1073af3d8e0996821) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194595))
- [Fix 20 rubocop violations for InternalAffairs/NodeMatcherDirective](https://gitlab.com/gitlab-org/gitlab/-/commit/07f429c165c07c5577d166125c1ce06110e6c34d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193873))
- [Add event store subscription for PolicyResyncEvent](https://gitlab.com/gitlab-org/gitlab/-/commit/c59e41e716045e73e2235597861a67e71baf9dfe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194447)) **GitLab Enterprise Edition**
- [Delete the non-ee version of feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b4d780f07d416b75eff3c09fea3d2919ef86ea2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194506))
- [Add NOT NULL to design_user_mentions](https://gitlab.com/gitlab-org/gitlab/-/commit/a844bb4f3a7a32417f7639b8f9cca3dcf2c8fdbd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194488))
- [Finalize BBM DeleteOrphanedProjectNamespaces](https://gitlab.com/gitlab-org/gitlab/-/commit/d156ad41038e1a7219ebd4e2cdc4d515a95cacfd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193953))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/a39c4a0e5d3d847a94101db53ee8191b3cba9f05) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194404))
- [Do not create duo core todo if a user has already received one](https://gitlab.com/gitlab-org/gitlab/-/commit/6288cf4f4c7d5d3459fab21d2ccaae972b570d23) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193773)) **GitLab Enterprise Edition**
- [Mark first vulnerabilities ES backfill migration as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/8a4a1c793ef744897b6f1c37ac373b5af5499398) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194278)) **GitLab Enterprise Edition**
- [test: Refactor factory usage of project_deploy_token](https://gitlab.com/gitlab-org/gitlab/-/commit/fb94e31f2cdfaadb83fb28af44497ffab8f2d8c0) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193133))
- [Protected containers: Show error details when deleting container images](https://gitlab.com/gitlab-org/gitlab/-/commit/649369f6e121d343f34f25aacd870fb07c24ab72) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185337))
- [Add background migration to delete expired vulnerability exports](https://gitlab.com/gitlab-org/gitlab/-/commit/7efb04a8eb6309bb66fa858eaa35597df413c655) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193399)) **GitLab Enterprise Edition**
- [Remove remove_summarize_merge_request_claude_3_7_sonnet feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b232dc5b17a547619f9a96fa3f668b3f623f64ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193673)) **GitLab Enterprise Edition**
- [Delete scan_result_policy_reads by approval_policy_rule_id](https://gitlab.com/gitlab-org/gitlab/-/commit/375a6807051a0d76ae0d7be3a8c04fc5caab7833) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194169)) **GitLab Enterprise Edition**
- [Backfill jira_tracker_data sharding_key](https://gitlab.com/gitlab-org/gitlab/-/commit/82dc6727aed949a46b918e673b9dbd15d08e763f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194007))
- [Finalize sharding key back-fill migrations for design management](https://gitlab.com/gitlab-org/gitlab/-/commit/d606ff07b85d3353920f7f6761dff65565180b25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194143))
- [Populate organization_id value in in runner tables](https://gitlab.com/gitlab-org/gitlab/-/commit/77e5a6d1f13eb934db4f50ae8357d2006c4ed01f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194119))
- [Backfill zentao_tracker_data sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/6c3a38666cc47b65a3e06c460a0d4113486c83a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192824))
- [Finalize BackfillBulkImportExportBatchesGroupId](https://gitlab.com/gitlab-org/gitlab/-/commit/8feb31db26fae30cb11ac8aa49adb279938b465a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194057))
- [Finaliza BackfillBulkImportExportBatchesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/8c75693ca03be4b82d9e47082637e611a4ac4ee9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194053))
- [Add `name` to pipeline seeding in runner_fleet rake job](https://gitlab.com/gitlab-org/gitlab/-/commit/2f1890af8f4e47ae99580d48f50ebaa1495c2717) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194008))
- [Protected packags: Generic push protection (Part 2)](https://gitlab.com/gitlab-org/gitlab/-/commit/5087566c3939392607966fa62132ff3892309e27) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189656))
- [Fix owasp_top_10 filter to accept multiple owasp values](https://gitlab.com/gitlab-org/gitlab/-/commit/931b20a79004fdc604201fcbf2bf2011ec3081a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191495)) **GitLab Enterprise Edition**
- [Step-up auth: Make conditions evaluation more readable](https://gitlab.com/gitlab-org/gitlab/-/commit/330463a0789fcf718b47542df419bd15a00f5935) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193735))
- [refactor: Avoid magic z-index const for drawer components (Part 2)](https://gitlab.com/gitlab-org/gitlab/-/commit/fcbab6bef9e426ae260172c89a965dc648c32b2d) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192772))
- [Add NOT NULL to incident_management_oncall_shifts](https://gitlab.com/gitlab-org/gitlab/-/commit/7007b3078d9925052470b0384dcbef37e1f76924) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193952))
- [Finalize troubleshoot job claude 3.7 upgrade](https://gitlab.com/gitlab-org/gitlab/-/commit/8c2c264bbe48e0a37c667902a461646ab95b7acf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193416)) **GitLab Enterprise Edition**
- [Swap pk on ci_build_reports to include partition_id](https://gitlab.com/gitlab-org/gitlab/-/commit/cf0b1e679b523ac8e57f449f766021b62c856804) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193933))
- [Remove remove_summarize_code_review_claude_3_7_sonnet feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/05e52ae108b00ab4e2847f1d167448b18b197943) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193766)) **GitLab Enterprise Edition**
- [Remove duo_code_review_full_file feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/201aee80726e79d46080a284c0ba484ee3a4e17c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193922)) **GitLab Enterprise Edition**
- [Finalize BackfillBulkImportConfigurationsOrganizationId](https://gitlab.com/gitlab-org/gitlab/-/commit/15fb32749597d3822c313f3df24a05ade858ab52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193918))
- [Finalize BackfillIssuableSlasNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/7fec3cc533f16b382281ccc4613d1ea8a625add2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193681))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/56a767bf4fa5029ddb481dc46c2e15f9209face2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193896))
- [test: Split up x509 user certificates](https://gitlab.com/gitlab-org/gitlab/-/commit/39c4190bcf7c57e532785468290172f95c1b970e) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193160))
- [Finalize BBM BackfillProtectedBranchUnprotectAccessLevelsProtectedBranch](https://gitlab.com/gitlab-org/gitlab/-/commit/361d73b93ad2e0a85c0ebd0453150328573aecf4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193831))
- [Finalize BackfillBoardsEpicListUserPreferencesGroupId](https://gitlab.com/gitlab-org/gitlab/-/commit/96444e69d380368a03a11f7dbd8721a99ec840c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193824))
- [Add analytics.gitlab.com to CSP](https://gitlab.com/gitlab-org/gitlab/-/commit/df1bd08f115c953e7c24533684ddb949b2e3663f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193683)) **GitLab Enterprise Edition**
- [Add NOT NULL on design_management_designs_versions](https://gitlab.com/gitlab-org/gitlab/-/commit/74653db14d90188362da9c3a72258700e844b636) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193808))
- [Add NOT NULL on project_relation_export_uploads](https://gitlab.com/gitlab-org/gitlab/-/commit/7a69538d7d5f7e92591831dd6157f6d62eca3e30) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193775))
- [Add advanced vulnerability management event](https://gitlab.com/gitlab-org/gitlab/-/commit/3d1e3b7e7e07b30faac60828a07b8551807a71c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192281)) **GitLab Enterprise Edition**
- [Remove the learn_gitlab_redesign feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3d520de842dde637c47fc38bdb77635345848b19) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191859)) **GitLab Enterprise Edition**
- [Refactor helpers for consolidated APIs](https://gitlab.com/gitlab-org/gitlab/-/commit/b9a95c82110a62b4afb09d4181b9dc8b26fe3214) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192814)) **GitLab Enterprise Edition**
- [Update x509 signatures: Add docs for automatic retry on GRPC error](https://gitlab.com/gitlab-org/gitlab/-/commit/b933f311cb5ac8ca2d0e845b070cef8503c34f3a) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193585))
- [Add NOT NULL on bulk_import_export_uploads](https://gitlab.com/gitlab-org/gitlab/-/commit/e02fffb390dfaa2c88800fbb653dacf5a8540b27) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193708))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/d009f9f764d3bbbe3ee5cbaa60d2cf5f43433eef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193706))
- [Remove ci_build_needs index on partition_id](https://gitlab.com/gitlab-org/gitlab/-/commit/5a6d182fee3e389a740b817b844a08b8528f2586) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193211))
- [Add NOT NULL on incident_management_oncall_participants](https://gitlab.com/gitlab-org/gitlab/-/commit/59d799c955442dfe49ad65f9aed0dad710ab6246) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193672))
- [Finalize BackfillIssuableResourceLinksNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/d46c0d4a0ad42f8bbe5b9ed8e33eda2969cc5116) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193657))
- [refactor: Use await nextTick in Framework Table component](https://gitlab.com/gitlab-org/gitlab/-/commit/2706c62680cc5c2fb6dcaeddab382a72a1461f37) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193638)) **GitLab Enterprise Edition**
- [Remove Extension Marketplace feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/a0dd9014ccbf795b608d08d5d739c02dc7b7d933) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192659))
- [Move ci_pipelines into the dynamic schema](https://gitlab.com/gitlab-org/gitlab/-/commit/76631b2f66cd4f46878412a343f18e94c5ed6f5c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191333))
- [Cleanup code related to packages_dependency_proxy_containers_scope_check](https://gitlab.com/gitlab-org/gitlab/-/commit/d2d2102db1d87c8142b817e3cc80e344e116b1b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191282))
- [Add NOT NULL for sharding key on work_item_progresses](https://gitlab.com/gitlab-org/gitlab/-/commit/f46ebb5fa736b8f1c77fd18f4a83c6d4388fabaf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193238))
- [Add organization_id column to runner tables](https://gitlab.com/gitlab-org/gitlab/-/commit/be6ec803c97d7047d29b0f6b4d9866008cf86a38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193171))
- [Remove leftover permalink values](https://gitlab.com/gitlab-org/gitlab/-/commit/8cb739d26fba0489e777cae34c7644f162d70c80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193500))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/c6ac440bc34ce8fe39c78ccbce9449a3805a846b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193556))
- [Finalize BackfillIncidentManagementPendingAlertEscalationsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/953cd295f08ca530dcfee7508274725b27fbacfa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193548))
- [Update x509 signatures: Add automatic retry on GRPC timeout errors](https://gitlab.com/gitlab-org/gitlab/-/commit/ace9c39c746217820fa3d33841437863d34cd129) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192543))
- [Finalize BackfillIncidentManagementOncallShiftsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/e3619b74c08f68a15eb6acee6b9a13c956459164) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193543))
- [Add NOT NULL on incident_management_pending_issue_escalations](https://gitlab.com/gitlab-org/gitlab/-/commit/d25342d33d98605df9adcb8347616092abe6cfa0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193540))
- [Document the PG upgrade process in the Database docs](https://gitlab.com/gitlab-org/gitlab/-/commit/bb0703f1b2e930e287bb0710a7af8e82f3d5d24f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188480))
- [Remove 'audit_events_api_offset_optimization' feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/1b64f6aee119972b198bb3bde6e14cd41a316d30) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193503))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/ae8fb737c81926a5421ca088e569478623c232bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193446))
- [Remove foreign key from `vulnerability_archived_records`](https://gitlab.com/gitlab-org/gitlab/-/commit/bcd0c4d0cc2f30f645cb5f278154ae141f591ac1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193433))
- [Include the repos with mismatched schema_version for indexing](https://gitlab.com/gitlab-org/gitlab/-/commit/2c56a0cc0779eaaeec5802358fb1103c6814f163) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192538)) **GitLab Enterprise Edition**
- [Add async index migration](https://gitlab.com/gitlab-org/gitlab/-/commit/9e3a96ceab698d2ba556233bb307c04d51e11fd8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193389))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/3b8289456bd4912a44667dca519b8a2460681a7a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193386))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/c215672d925c1b6293cdbf5d1bad444d96b65800) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193383))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/a5d2f16040f813655f6ed53250eb9784c2a70821) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193379))
- [Add system defined status id for custom statuses](https://gitlab.com/gitlab-org/gitlab/-/commit/b485e53c5e43bcbb3459da7506dd39ef5c9be3d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192978))
- [Feat: Add RuboCop cop to discourage Current.organization&.id](https://gitlab.com/gitlab-org/gitlab/-/commit/78db040067be0bf87fd0e4df81e4c8e69885db53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192592))
- [Add NOT NULL for sharding key on merge_request_assignment_events](https://gitlab.com/gitlab-org/gitlab/-/commit/0e892b5ab9ccb059e2009cf264e5956b9e6e8cd7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193353))
- [Finalize BackfillMergeRequestAssignmentEventsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/d0f60a05c97e067222cc8958050a82efa88906b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193185))
- [chore(rake): Add logging for x509 commit signature updates](https://gitlab.com/gitlab-org/gitlab/-/commit/91755a60b833fb03651299fd2d110e11d740a0a3) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192504))
- [Finalize BackfillIncidentManagementOncallParticipantsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/a945b61b58df318410b7fd4e00f623d1c4800fa9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193335))
- [Remove ff from code](https://gitlab.com/gitlab-org/gitlab/-/commit/98a10c66bc2fc2f55240142839b7e30424e790a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193329))
- [Finalize BackfillIncidentManagementPendingIssueEscalationsNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/89df94e5598241852e6c59a36da32c93df268e34) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193327))
- [Schedule Vulnerability archival manually](https://gitlab.com/gitlab-org/gitlab/-/commit/7f50c2682399b4a8b6f936075b354168b12dd9fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193303))
- [Move ci_builds into the dynamic schema](https://gitlab.com/gitlab-org/gitlab/-/commit/5d8141ab8128aef4a60a16e2ea863649bcb52419) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191002))
- [Consolidate namespace deletion-related helper methods in a new file](https://gitlab.com/gitlab-org/gitlab/-/commit/c3cb0fe89fc8fdbc43ae9a52bcff164f0ff29af6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191646))
- [Drop project_deletion_schedules table](https://gitlab.com/gitlab-org/gitlab/-/commit/0d2389f70196e25f29f99731412ed1f67abe8781) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192872))
- [Refactor x509 update rake task specs](https://gitlab.com/gitlab-org/gitlab/-/commit/d98a0d752f4c4c991606846251b82652d8884832) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192627))
- [Add NOT NULL for sharding key on issue_metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/9a03f94f36f43382d5c09d1d58b20e0ee387cd50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193236))
- [Sync drop index on ci_job_variables for partition_id](https://gitlab.com/gitlab-org/gitlab/-/commit/fc7aa407724556a32b460133772d661c74e089c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193206))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/c98f3d940b047c5e5bd7e2cd1ddc7caf0a016cb5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192971)) **GitLab Enterprise Edition**
- [Add schema_version to zoekt:info task](https://gitlab.com/gitlab-org/gitlab/-/commit/efe803ff8ba10fa4a88445fcb35ad8443d8b5716) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192644)) **GitLab Enterprise Edition**
- [Refactor code suggestions base task endpoint method](https://gitlab.com/gitlab-org/gitlab/-/commit/c6da03e5bb3844ed563d729ab09edd9feecfe949) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193017)) **GitLab Enterprise Edition**
- [Protected packages: Consolidate CheckDeleteRuleExistenceService](https://gitlab.com/gitlab-org/gitlab/-/commit/6304ccbb2ecd7f3ff9d78493c36fc8a3a9f65d98) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183551))
- [Maven virtual registry: support shareable upstreams](https://gitlab.com/gitlab-org/gitlab/-/commit/3e17a53d110b272e12e822a2daddce221c1cf2c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192151))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/184b48e64d50b3e88599544f1730e4528951f8fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193108))
- [Finalize BBM UpdateStatusForDeprecatedNpmPackages](https://gitlab.com/gitlab-org/gitlab/-/commit/8f8fff8604adbfeae6be25e98e8a48bb5f00838d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193068))
- [Finalize BBM CreateMissingTerraformModuleMetadata](https://gitlab.com/gitlab-org/gitlab/-/commit/899cf365e013c7e93cad0421a8b7da84db67fa04) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192957))
- [Add board_user_preferences sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/e965c973530cd95361812b68f37a0857b657c40d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192787))
- [Remove invalid ticket hierarchy restrictions](https://gitlab.com/gitlab-org/gitlab/-/commit/66c1ee5b61d7a632cc5ef487ce6dc56473dca042) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192897))
- [docs: Apply tabs to x509 documentation sections "Linux" and "Win/macOS"](https://gitlab.com/gitlab-org/gitlab/-/commit/44ed36127c1d20ace5579236bae9851f54dffcf8) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192809))
- [Add `namespace_deletion_schedules` table and model](https://gitlab.com/gitlab-org/gitlab/-/commit/d9644174bc82f4d275590e456d4b743cdd554d24) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192465))
- [Replace index on ci_build_report_results](https://gitlab.com/gitlab-org/gitlab/-/commit/bf907fd885aaf4797c2a6cf2ae4c440ee4cbc450) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192956))
- [Finalize uploads back-fill dependencies](https://gitlab.com/gitlab-org/gitlab/-/commit/96e444c105c2f95cca8519a2d52108035fcab244) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192867))
- [Revise new-changes block message](https://gitlab.com/gitlab-org/gitlab/-/commit/44b189f5a837ad22bdc498878b6b9be8da394317) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192704))
- [Remove push_rule_file_size_limit ff](https://gitlab.com/gitlab-org/gitlab/-/commit/fa8db6e534c0cd1a6bbcd888aef8be0254deede5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191671))
- [Add NOT NULL for sharding key on resource_weight_events](https://gitlab.com/gitlab-org/gitlab/-/commit/476626ed20c7fdf0a2a543053588e80e886bfdf7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192561))
- [Updating Topology Service Client Gem to 20a0104](https://gitlab.com/gitlab-org/gitlab/-/commit/f1f02536a34e619ae9dee6990f9a5c7a6783bcff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190385))
- [Prepare (namespace_id, id) index on sent_notifications](https://gitlab.com/gitlab-org/gitlab/-/commit/15c56e6b79f4a5fa6a63f1cd6cf1a98fcc2599fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192636))
- [Cleanup snippet_ip_restrictions  FF](https://gitlab.com/gitlab-org/gitlab/-/commit/ddabd7ed2d45f69bf56f95173b736a48e4124ca2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192786))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/a4580894d4c73a183aedf770734c0a893169d3b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192435))
- [Finalize BBM BackfillWorkItemProgressesNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/3f59ae2c5786b3705afea15fea8dcee5538437a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192433))
- [Finalize BBM BackfillIssueMetricsNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/9107859af2c6bd90cb272661a437cc7f28b702a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189981))
- [Drop redundant partition_id indexes on ci tables](https://gitlab.com/gitlab-org/gitlab/-/commit/c85e583a4849dbd09f58df51d0ff0149b56e7bba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192849))
- [refactor: Avoid magic number for drawer z-index](https://gitlab.com/gitlab-org/gitlab/-/commit/0d1c3d19358f6301389e73e6fab96210db050049) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192355)) **GitLab Enterprise Edition**
- [Backfill migration to fill project level analyzer status data](https://gitlab.com/gitlab-org/gitlab/-/commit/fe8c75081d60c03792852164436cace269e12503) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187214))
- [Correct documentation for revocation SA PATs](https://gitlab.com/gitlab-org/gitlab/-/commit/d6d975a2bc4f8037a3f735baa769bd9eb54e6375) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192778))
- [Remove web_ide_multi_domain feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/1ecd45fa3ff2af68c2be51b8ffde3e5e46a8a0b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192545))
- [Update docs and comment about missing FKs](https://gitlab.com/gitlab-org/gitlab/-/commit/3842e900b478486bee01b1e710b21b5e68ca9e3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192079))
- [Create namespace_id based indexes for issue lists](https://gitlab.com/gitlab-org/gitlab/-/commit/cda996a7fd15dedbed0a262e4838a99825e20b9d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188876))
- [Update SyncProjectPolicyWorker to handle events](https://gitlab.com/gitlab-org/gitlab/-/commit/61df0f2e097e5f8e4338ad4c6eb5ace6506173df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191788)) **GitLab Enterprise Edition**
- [Async drop index on p_ci_job_artifacts file_final_path](https://gitlab.com/gitlab-org/gitlab/-/commit/d732ccc2248912509648bdc7842b4cf3313057ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192700))
- [Fix Performance/FlatMap offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/1a5bcdd281048669cd52fd4c382a9aa48fc0b413) by @louisraymond ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192143))
- [Async remove index on ci_job_variables](https://gitlab.com/gitlab-org/gitlab/-/commit/c2d0d7edc2f193b1644373c8328ad43407237758) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192692))
- [Use migrate_to_encrypts :asset_proxy_secret_key in ApplicationSetting](https://gitlab.com/gitlab-org/gitlab/-/commit/5660ec3a27383ae274e915c2fca76a8d008f2a94) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189940))
- [Use consistant default values for locks](https://gitlab.com/gitlab-org/gitlab/-/commit/9d6b0cc90e3dfa2019b00f8bfb56325599135fd6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192622))
- [Sync translations from crowdin (2025-05-27)](https://gitlab.com/gitlab-org/gitlab/-/commit/95b213b4d334e989d566ad08239b788a15ebc81a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192641))
- [Add condition to skip stdout silencing based on env variable](https://gitlab.com/gitlab-org/gitlab/-/commit/63743f4134c6ad7a26aa5216728378e5ea26dfbc) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192632))
- [Add parameter hash to SyncProjectPoliciesWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/f36fc33db94f661a524a532b19b0e2d1e8e86b8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192621)) **GitLab Enterprise Edition**
- [Align Geo replicable names in the UI according to the Geo data types](https://gitlab.com/gitlab-org/gitlab/-/commit/81a879d8618a37f4fbf1a2ac8f78c9721ac48c92) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192214)) **GitLab Enterprise Edition**
- [Align Geo data type and Replicated feature flag names](https://gitlab.com/gitlab-org/gitlab/-/commit/f655af679670ec812069e89633509321dff1ecf6) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191694))
- [Sync translations from crowdin (2025-05-26)](https://gitlab.com/gitlab-org/gitlab/-/commit/b551c418da60e0b45a5d43bd5f041987e065699b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192540))
- [Add NOT NULL on security_orchestration_policy_rule_schedules](https://gitlab.com/gitlab-org/gitlab/-/commit/8f804c533e088cba87d9692e700e82e44dea7990) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192318))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/9abaacc0f143cf56b05f48c1732a97e10606ce18) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192519))
- [Improve vulnerability specs where es is used](https://gitlab.com/gitlab-org/gitlab/-/commit/30f914cfbb7965735b20b3bd2f4a8f5abb1bac89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192483)) **GitLab Enterprise Edition**
- [Add schema_version to zoekt_nodes and zoket_repositories](https://gitlab.com/gitlab-org/gitlab/-/commit/18620562dcfe13bc10943bdd58872d69271ad83a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192375))
- [Track token usage for REST API requests from CI runners](https://gitlab.com/gitlab-org/gitlab/-/commit/3c7bcd0e51a5990e63fb99fba65c8f740b7f89d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189430))
- [Increase query limit threshold for license_compliance feature spec](https://gitlab.com/gitlab-org/gitlab/-/commit/3bfe8f17aa5f0bd3a3345aafd590757a1e4347d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192371)) **GitLab Enterprise Edition**
- [Use duo_core_features_enabled in application code](https://gitlab.com/gitlab-org/gitlab/-/commit/314a80ea679b2a1fd23726582d6ebbba29f2a54b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192358)) **GitLab Enterprise Edition**
- [Add NOT NULL for sharding key on status_page_published_incidents](https://gitlab.com/gitlab-org/gitlab/-/commit/21d64a489c6c3fdb91fb6a16e4e3b0f42fd168ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192320))
- [Add NOT NULL on protected_branch_merge_access_levels](https://gitlab.com/gitlab-org/gitlab/-/commit/8b3aa38a5e2b01f5ab1dbbb386a835ad1910a224) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191562))
- [Revert "Reuse hosts during service discovery update"](https://gitlab.com/gitlab-org/gitlab/-/commit/0c0c5d3cb70e37afcfe5fe118d0d5f3ec141b1c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192135))
- [Update ComplianceFrameworkChangedEvent subscription](https://gitlab.com/gitlab-org/gitlab/-/commit/763318f341a003338b9f16b679b91c20c0166beb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191779)) **GitLab Enterprise Edition**
- [Migrate Ancestor widget to use design tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/333dcb912e0ca4aebdb19d1e03f5d35c751f077e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188222))
- [Add logs when creating approval_merge_request_rule](https://gitlab.com/gitlab-org/gitlab/-/commit/d5556fa15ee911ce70e65b07c2c14822c3076e91) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192263)) **GitLab Enterprise Edition**
- [Final steps for resource_milestone_events sharding_key](https://gitlab.com/gitlab-org/gitlab/-/commit/3df14651ac9194c2cf3b363ac0514c917a7f7df3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192255))
- [Remove FF allow_duo_base_access from backend](https://gitlab.com/gitlab-org/gitlab/-/commit/729d7c61739447dc33e887754a19a90a821cf180) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191514)) **GitLab Enterprise Edition**
- [Remove rate limit feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/7285906b97448d127f40e65328fb446549b1ab15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191657))
- [Protected packages: Original package publisher for NuGet worker (Part 1)](https://gitlab.com/gitlab-org/gitlab/-/commit/5fbf73de01d81886981ec1997699bb316e05928a) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188254))
- [Rename index_ci_runner_machines_*_trigram indices](https://gitlab.com/gitlab-org/gitlab/-/commit/6df183120501d194446d5581f43de3bc7c8c929d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191968))
- [Finalize BBM BackfillStatusPagePublishedIncidentsNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/0deb953fd066abb0ecbee4e4526303e0f2b5d071) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192038))
- [Async remove index_ci_build_needs_on_partition_id_build_id](https://gitlab.com/gitlab-org/gitlab/-/commit/d74e92c9587a5cd520cf85fe38dd614c6cb0dec1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192164))
- [Set RunScheduleWorker TTL to max time window](https://gitlab.com/gitlab-org/gitlab/-/commit/de872d3fcea39818ba4088092065c772e86da56a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191980)) **GitLab Enterprise Edition**
- [Readd index_users_for_auditors for GitLab.com](https://gitlab.com/gitlab-org/gitlab/-/commit/24376223252dbb776bd354390a85aeb06eddd12b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192036))
- [Add NOT NULL for sharding key on issue_user_mentions](https://gitlab.com/gitlab-org/gitlab/-/commit/7b0798e444e6f839629cac39a0704de1f7b5b955) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191423))
- [Make sure default values are used when project data is unavailable](https://gitlab.com/gitlab-org/gitlab/-/commit/4b2cde1e5f7bc53517120358fab5020ae09fd62f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192106)) **GitLab Enterprise Edition**
- [Maven virtual registry: support multiple registries](https://gitlab.com/gitlab-org/gitlab/-/commit/2c9ee6deb80e3a4c8648f9ab2f3fd7f82232aa73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191840)) **GitLab Enterprise Edition**
- [Add parameter hash to SyncProjectPolicyWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/0be3aa27a34aa1e8cbde9b48302ddcb5f1815974) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192089)) **GitLab Enterprise Edition**
- [Remove the search_zoekt_proxy FF](https://gitlab.com/gitlab-org/gitlab/-/commit/d725f8de88ca412922e995924ee873531dc1ac4a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191322)) **GitLab Enterprise Edition**
- [Remove Current.organization&.id in registrations controller](https://gitlab.com/gitlab-org/gitlab/-/commit/0d4fdec92a06bb15df81a45e2d5558693db17593) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190775))
- [Finalize BBM BackfillSoftwareLicenseSpdxIdentifierForSoftwareLicensePoli](https://gitlab.com/gitlab-org/gitlab/-/commit/ba0fb1636d4d1dd4300973a63b70a5b2056d6af5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191573))
- [Remove reveal_duo_core_feature feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/a86cbaeca4ae155600268e6db18bc703bd4b39d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191853)) **GitLab Enterprise Edition**
- [Protected packages: Graphql experiment description for helm](https://gitlab.com/gitlab-org/gitlab/-/commit/8ae1f16929f56bb804bd85de4858d8af08e982d4) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191402))
- [Clean up ff revalidate_gpg_fingerprints](https://gitlab.com/gitlab-org/gitlab/-/commit/61ee3b8680e1e105d40a97aaaf919b47d1db612e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191982))
- [Finalize adding sharding key on lists](https://gitlab.com/gitlab-org/gitlab/-/commit/0e6484a30703611d457020997e544aac4da31f66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191817))
- [Remove fallback for Current.organization&.id in api base and users](https://gitlab.com/gitlab-org/gitlab/-/commit/a28c9181cafa691c1edc26cca29c3c1c8c9afadc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190771))
- [Refactor error class assignments to avoid chained assignment](https://gitlab.com/gitlab-org/gitlab/-/commit/3299b35ccddab58ef4f2d08fd22f14efe55aafe1) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191001))
- [Finalize adding sharding key on description_versions](https://gitlab.com/gitlab-org/gitlab/-/commit/6dd6986e944ef9c69cc45a16ffe2e26b2a3a92df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191801))
- [Update documentation about LFK regarding tracking deletions](https://gitlab.com/gitlab-org/gitlab/-/commit/08fd0dc7ed2a67e887a2265a3af2c98f09b9b0a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191708))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/073f74e886bedb222a3961eaa4226a0cb98ddf87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191784))
- [Move ComplianceFrameworkChangedEvent handler to SyncPolicyEventWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/45364b19c2cf69d515332eeb7423cf47bc7f3809) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191773)) **GitLab Enterprise Edition**
- [Added Finalize limit namespace visibility by organization](https://gitlab.com/gitlab-org/gitlab/-/commit/7d411263a6c962cf0c81047047168e2e9b23aac5) by @IP1102 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184873))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/2ade78903412b3f63032578c5c9ada0f8c3f4165) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191434))
- [Finalize BBM BackfillResourceWeightEventsNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/f58f69a2cc71b390d8e5b4432f88a948d9e5e3b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191411))
- [Ensure nuget client receives error message](https://gitlab.com/gitlab-org/gitlab/-/commit/27b42efadbe41a862900a7cc80fb7c311e67f00e) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189196))
- [Replace ci_runner_taggings FK with loose foreign key](https://gitlab.com/gitlab-org/gitlab/-/commit/726c30c8b13c2707ea3ebd023ea16d37fb58c7a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190656))
- [Use provided sort options in es pagination](https://gitlab.com/gitlab-org/gitlab/-/commit/c70c6fcde4640f165f196d67c3cfe2e42935de92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191607)) **GitLab Enterprise Edition**
- [Return highest group access level across all ancestors in Projects API](https://gitlab.com/gitlab-org/gitlab/-/commit/e763c10490834c556295aea321b93b5b97a8bea1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190492))
- [Drop unused issues indexes synchronously](https://gitlab.com/gitlab-org/gitlab/-/commit/915e3bb711e9260dd0a7fb995c0299f10795e3af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191594))
- [Removing unused cross database ignored tables](https://gitlab.com/gitlab-org/gitlab/-/commit/a17ec524e7153c691dfc077c50c7be9bc95469a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191460))
- [Finalize BBM BackfillProtectedBranchMergeAccessLevelsProtectedBranchName](https://gitlab.com/gitlab-org/gitlab/-/commit/c2df459f2f9b060e5629c2db99aa47476f85fa61) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190602))
- [Add NOT NULL for sharding key on issue_emails](https://gitlab.com/gitlab-org/gitlab/-/commit/322105dd0758698ea602ce873d94362776f29513) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190366))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/65fb333d9e6cc1692a0f671a7e3def0627e4e311) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191430))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/7d84a329edf5280c44630637651bdc7430141fa7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191429))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/347c1263b7a201a433eae25ac9a9280e488f8648) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191428))
- [Add NOT NULL for sharding key on resource_link_events](https://gitlab.com/gitlab-org/gitlab/-/commit/b272cb4e405f7e6d27ae92add7822d63c58c89a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191427))
- [Finalize BBM BackfillSentryIssuesNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/00f5bb8d34f7386847b56e8923986e07a4aa3723) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191412))
- [Remove search_work_items_index_notes flag](https://gitlab.com/gitlab-org/gitlab/-/commit/390c1222125669917758d2b124655a6ed06545c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191369)) **GitLab Enterprise Edition**
- [Cleanup bigint conversion for terraform module metadata semver patch](https://gitlab.com/gitlab-org/gitlab/-/commit/5ca50a7e8bb31946f61b5761fdc69b752eee5ed1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191363))
- [Add http timeouts for AuditEventStreamingWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/3c7ae3bd49914655a23064088ef8953d26d3c9ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191353)) **GitLab Enterprise Edition**
- [Move ci_job_artifacts into the dynamic schema](https://gitlab.com/gitlab-org/gitlab/-/commit/58e81dee8465a452912c3f6b49cfd8611cf3d73d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191330))
- [Move ci_stages into the dynamic schema](https://gitlab.com/gitlab-org/gitlab/-/commit/102d7dfc2a400395c668de3fe9f7224656f2359c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191031))
- [Finalize migration BackfillDependencyProxyManifestStatesGroupId](https://gitlab.com/gitlab-org/gitlab/-/commit/86f3a2ad42905fdf1e32b3ce7fd238afbaf82b5d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186186))
- [Clean up `allow_ldap_users_to_authenticate_with_gitlab_username` FF](https://gitlab.com/gitlab-org/gitlab/-/commit/098d68f5968beeb53484316500a37f71ec5a1d15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191312))
- [Add new sli for deleted objects](https://gitlab.com/gitlab-org/gitlab/-/commit/09620f11735b1ad7fff31fc8a2f78ea98211813a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190093))
- [Update labels for virtual registries](https://gitlab.com/gitlab-org/gitlab/-/commit/c7718173a6745b442c4fcfbaef09f7e7ba607c6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190596)) **GitLab Enterprise Edition**
- [Remove FF ci_inputs_for_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/29c32a43038a64aeaa37821df3b254ff92ce449e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188869))
- [Replace tmp index with unique index for Maven packages](https://gitlab.com/gitlab-org/gitlab/-/commit/881d81d43ad01b3e1cdb631fab319058a6a88031) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190992))
- [Add NOT NULL for sharding key on issuable_severities](https://gitlab.com/gitlab-org/gitlab/-/commit/44e97f305b11109135a1b5860a70c72b8dfa855a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191271))
- [Workhorse: set metrics labels for external URLs](https://gitlab.com/gitlab-org/gitlab/-/commit/523c2ff02009ff21b3908fa756afa023a1ebb83c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190921))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/4bcbc34dae830ab85fd612d17ecdabafa8d9b0bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191268))
- [Add NOT NULL on protected_tag_create_access_levels](https://gitlab.com/gitlab-org/gitlab/-/commit/2ef7f86b4e85039b11efb7e57fb65e06e6157ff1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191254))
- [Add NOT NULL for sharding key on packages_pypi_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/d4bfa4f4051a850cc9d6d6b833a99ca9749a9732) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190949))
- [Remove new_issue_attachment_from_vulnerability_bulk_action feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/ed1977822711153fdb1f49864a1afcbcc9c3b788) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190798)) **GitLab Enterprise Edition**
- [Add NOT NULL on approval_project_rules_protected_branches](https://gitlab.com/gitlab-org/gitlab/-/commit/cc466826e8bc275ec58f4ced3f8edce898afe2ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191225))
- [Add NOT NULL for sharding key on pages_domain_acme_orders](https://gitlab.com/gitlab-org/gitlab/-/commit/7dc3ad007adc7cc7bb3ef352931cf4180b87f06f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191223))
- [Remove enhanced_vulnerability_bulk_action feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/a0338ce8eddd05149a4e450df6371ae34b04ea0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190810)) **GitLab Enterprise Edition**
- [Remove work_item_related_vulnerabilities feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b005b195f7d927d65c05bcb2078e94a18e6286d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190811)) **GitLab Enterprise Edition**
- [Protected containers: Improve method names in components](https://gitlab.com/gitlab-org/gitlab/-/commit/d585a7bf5afc706c1361a2651f5ef2d6d035df95) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185841))
- [Move ci_builds_metadata into the dynamic schema](https://gitlab.com/gitlab-org/gitlab/-/commit/8a3af152045d3577c44d8938906bb9d4c699cfff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191033))
- [Add concurrency limit and http timeout for AuditEventStreamingWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/7c1089e3d5ec03467aa1e340202d7bc2299aeb38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189049)) **GitLab Enterprise Edition**
- [Remove duo_chat_multi_thread flag as it is stable](https://gitlab.com/gitlab-org/gitlab/-/commit/57e8cae2806bcb0b1c24cc894b99bf78d25836d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190042)) **GitLab Enterprise Edition**
- [Reindex Elasticsearch work items to update integer with long type](https://gitlab.com/gitlab-org/gitlab/-/commit/f0e628f01fd0abe5f8a89ca740cbb2e396c49683) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190508)) **GitLab Enterprise Edition**
- [Async namespace_id based indexes for issues](https://gitlab.com/gitlab-org/gitlab/-/commit/a9f591af01c7f434b9510199e447927e45e28a41) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188963))
- [Add NOT NULL for sharding key on issuable_metric_images](https://gitlab.com/gitlab-org/gitlab/-/commit/61adbf469048cf0fc62a8bfd956c30cdbc9aa6c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191074))
- [Add NOT NULL for sharding key on packages_rubygems_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/e204745ec25be97a592367b0fa7c8cad461792d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191069))
- [Make telephone optional on in-app trial forms](https://gitlab.com/gitlab-org/gitlab/-/commit/7349da47ac5cfaba7405bf853d55dd3c709c3354) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191062)) **GitLab Enterprise Edition**
- [Add NOT NULL for sharding key on packages_rpm_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/42bf31d304477b9ea16436d4aabc335764b450b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191068))
- [Drop resource_label_events Markdown cache columns](https://gitlab.com/gitlab-org/gitlab/-/commit/4e1695e9dfed15ec85cc163585e66f7c02beeef9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190941))
- [Finalize BBM BackfillResourceLinkEventsNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/fd595f31be545706d287e85b9782b63e47a9f92f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190912))
- [Change users_preferences.organization_groups_projects_display defaults](https://gitlab.com/gitlab-org/gitlab/-/commit/c0bed48fc7a755413edf1090c86a33a798771d37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190331))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/06fdc6c5fb9a7490c5fe8e6b1eb3a8b0f065f950) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189248))

## 18.0.2 (2025-06-11)

### Fixed (5 changes)

- [Fix Upgrade to 18.0: No such column](https://gitlab.com/gitlab-org/security/gitlab/-/commit/bde20c3f31d324493d032be57be4465f0919760e)
- [Fix IDE links returns about:blank in old code dropdown](https://gitlab.com/gitlab-org/security/gitlab/-/commit/633864727f574f9d9b93826bb76d66a790382915)
- [Fix the title/body issue for todo apis when it is a duo todo](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d8080ea15af34cf804ce024b207f2fa4817c87a6) **GitLab Enterprise Edition**
- [Fix gitpod button is missing in the edit dropdown](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4bbef760c63924f2821233d98dc04c1982751430)
- [Move fork_networks organization_id NOT NULL to post-migrate](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2bbea09c16044981bf316dd43544a87e4bf67147)

### Security (8 changes)

- [Protect webhook from excessive payload lengths](https://gitlab.com/gitlab-org/security/gitlab/-/commit/990fae5b6be86c6769c2086578ae2096762e21a8) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5059))
- [Endless Redirect Loop in any project when query param "format" is "git"](https://gitlab.com/gitlab-org/security/gitlab/-/commit/fdbfb6cd14973800abeec182823bcfa647a1a5a8) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5038))
- [Backport for "Add validation for board name length" to 18-0 stable](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ba616a03359751fc3add6f8504c79f4381efa703) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5044))
- [Fix # #1329 - IDOR in compliance framework export endpoint](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ffea57e8e171b120f5f66fe81da39a21e5ab0258) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5041))
- [Fix authorization for compliance frameworks projects](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0d783852162009bc5286a939534f2a5e2f1ae7ef) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5034))
- [security: Git redirection inconsistency](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3fb95759edb3e7729b981bf48140ef9a05a32761) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5020))
- [Fix XSS with CSP bypass in JSON tables](https://gitlab.com/gitlab-org/security/gitlab/-/commit/fcfebf2f188ed90eea3f7db92ebeedcbadc6504d) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5022))
- [Limit HTTP response size](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f8bf80825e1bd802be7be374905600059abd2726) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5014))

## 18.0.1 (2025-05-21)

### Fixed (1 change)

- [Apply Rails 7-1-stable patches to fix type map init issues](https://gitlab.com/gitlab-org/security/gitlab/-/commit/883fb9273c7cd961249d5dbe6bee4df76d704aaf)

### Changed (1 change)

- [Add outbound allowlist to allowed endpoints for SSRF filter](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f64186f3e141c6ca8485b451cb1e264364beaa7a) **GitLab Enterprise Edition**

### Security (10 changes)

- [Use CI::VariableValue in BasicEntity to prevent exposing hidden values in collapsible UI element](https://gitlab.com/gitlab-org/security/gitlab/-/commit/75c84787120ca99c5e385d566207a1b1e5aa3bd1) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5021))
- [Show full path of project in create MR dropdown](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2a2faab0bbb53af58aaf76725f9afb1a732c4349) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5002))
- [Remove trace field as it is already added in the interface](https://gitlab.com/gitlab-org/security/gitlab/-/commit/95cf66aa590556b28884371332175a28c8a934fd) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5004))
- [Security 479168 discord zip vulnerability](https://gitlab.com/gitlab-org/security/gitlab/-/commit/766fab2ac7e498efda2561ee15a68e59af83e633) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5018))
- [Limit length of certificate cluster text fields](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5f61b3d9430ff69c0a69032485c1e8065c7ef1b6) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4999))
- [Check rate limit for over-sized blobs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b920b5eb587da918a3925cfcc2c16217ee12b79c) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5008))
- [Added size constraint validation to notes position fields](https://gitlab.com/gitlab-org/security/gitlab/-/commit/08ea9082a91765c13c2b63b3161dcd4185a24af2) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5005))
- [Obfuscate emails in note.bodyFirstLineHtml](https://gitlab.com/gitlab-org/security/gitlab/-/commit/eaf7702da8bab8041f84d5a24742576342ba2ecc) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5003))
- [Need to update 2fa requirement after accepting request](https://gitlab.com/gitlab-org/security/gitlab/-/commit/dd5abda5785fd824b7056513695a3a17d7555697) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4997))
- [Ensure SAML authn context comes from signed portion of SAML response](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c641624daf734ee6f61adac4a0cc898b894590af) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5010))

## 18.0.0 (2025-05-14)

### Added (177 changes)

- [Backfill vulnerabilities ES index](https://gitlab.com/gitlab-org/gitlab/-/commit/0acf9feff050cb66162ae531c01e8effcbf3ed4e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184819)) **GitLab Enterprise Edition**
- [Add markdown rendering to code quality issue name](https://gitlab.com/gitlab-org/gitlab/-/commit/3eb9b9b62112c2584224988fd2b79cd623266564) by @django1194 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185717))
- [Adding api for listing project requirement statuses](https://gitlab.com/gitlab-org/gitlab/-/commit/48f54c07e47af5087ee958cd61b680e019aa7803) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186260)) **GitLab Enterprise Edition**
- [Add archive column and event handler for project analyzer status](https://gitlab.com/gitlab-org/gitlab/-/commit/c9b7bc92779e08d3316db97d0309552816431e35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189665)) **GitLab Enterprise Edition**
- [Prepare async FK for p_ci_pipelines.trigger_id](https://gitlab.com/gitlab-org/gitlab/-/commit/242e119fc1bd0130e68ff16085531106820e10e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189738))
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/99ece00ff019d2eb2ec30bba53c01d84315214e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190938))
- [Update model validation to new value constraint](https://gitlab.com/gitlab-org/gitlab/-/commit/d086741e5e8e07c6382b7f2d54ff4ce9133a67af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190830)) **GitLab Enterprise Edition**
- [Add wiki endpoints to notes REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/aa66ccc1bc339fc7fe3d385f99bab204de8647c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182483))
- [Remove `duo_code_review_system_note` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/bdbbcfeb59db74ff31df1a9fa64c87d0dd03908c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190704))
- [Add last updated information to Compliance Frameworks table](https://gitlab.com/gitlab-org/gitlab/-/commit/3fcf92a0a628cc0ca864d181e78ba021dd6c1b11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190668)) **GitLab Enterprise Edition**
- [Add configurable cookie salts](https://gitlab.com/gitlab-org/gitlab/-/commit/c99bb3013db0bbcf469ca2f3c99579dba60df1b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190350))
- [Backfill instance integrations organization_id](https://gitlab.com/gitlab-org/gitlab/-/commit/2d81a9f6cb1416ce8620794b748f5edb74990f2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189808))
- [Enable duo_code_review_full_file feature flag by default](https://gitlab.com/gitlab-org/gitlab/-/commit/73f5266f9011fa7aeb5ec1e85659afc9765ad9b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190579)) **GitLab Enterprise Edition**
- [Enable duo_code_review_multi_file feature flag by default](https://gitlab.com/gitlab-org/gitlab/-/commit/f808fc54b373d19ef538e0860f4c28afa689ee26) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190577)) **GitLab Enterprise Edition**
- [Hide Duo availability for Duo Core only scenarios](https://gitlab.com/gitlab-org/gitlab/-/commit/62fdb407dabf2167124cf97afb4f4e473d0d6aa7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190411)) **GitLab Enterprise Edition**
- [Delete old routing docs from Vulnerability Index on Project transfer](https://gitlab.com/gitlab-org/gitlab/-/commit/d1ae078cfe56ca7b1163fdda0bd7d8135b5593f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190083)) **GitLab Enterprise Edition**
- [Add updated_at to ComplianceFrameworkType](https://gitlab.com/gitlab-org/gitlab/-/commit/e5922e1209b06b3c0533e30e8743c99db206c0bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190655)) **GitLab Enterprise Edition**
- [Add reusable TokenValidityBadge component](https://gitlab.com/gitlab-org/gitlab/-/commit/0d11b7c8428f916e0a15641fd39c54a1a23d5185) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190538)) **GitLab Enterprise Edition**
- [Sticky headers: Add translucent glass style](https://gitlab.com/gitlab-org/gitlab/-/commit/65d82b3d8edf66893d2b767ed9c17c2d7a36132e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190203))
- [Add project delete event worker for vulnerability namespace statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/4b8482764e24d915526ac8e76ece16e27f2cd694) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188778)) **GitLab Enterprise Edition**
- [Add messaging to redirect users to Branch rules section](https://gitlab.com/gitlab-org/gitlab/-/commit/e34bb1c658f83628c03c5b96ce9a15b99aa3e05f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189974))
- [Enable enhanced bulk actions and related vulnerabilities by default](https://gitlab.com/gitlab-org/gitlab/-/commit/a2e30ed58a4c19eb11c141a232ddd7713d0c420f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190213)) **GitLab Enterprise Edition**
- [Add column for project web_based_commit_signing_enabled setting](https://gitlab.com/gitlab-org/gitlab/-/commit/0a58797c9cd1d44190b17fd4fd7e779182845356) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189184))
- [Remove job source feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3e2b41894a9b6200681ead3bf2515f668c1245f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190563))
- [Allow session to expire after specific time](https://gitlab.com/gitlab-org/gitlab/-/commit/99ff290074b47316070dec7b43284c73d04d4b46) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190483))
- [Add is_team_member property to workflow API](https://gitlab.com/gitlab-org/gitlab/-/commit/2f3cbf9b972e0ba9abc12896ea5ee87cdec3d394) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190246)) **GitLab Enterprise Edition**
- [Vulnerability webhook events for Groups](https://gitlab.com/gitlab-org/gitlab/-/commit/4e3a92ff0fdb112d722a518d91b8b83179108781) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185569)) **GitLab Enterprise Edition**
- [Add group import histories controller](https://gitlab.com/gitlab-org/gitlab/-/commit/29ae0209420d04922708f1cb7860217257d7f4fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187033))
- [Add Pages/Docusaurus project template](https://gitlab.com/gitlab-org/gitlab/-/commit/812cf972419790e4ddf02e588c1f25d5ab9b606e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189610))
- [Add event forwarder for Snowplow events](https://gitlab.com/gitlab-org/gitlab/-/commit/21c7083a57ff346e3cdb2bf40e0620c257ed142c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190332))
- [Add control for one approval on MRs](https://gitlab.com/gitlab-org/gitlab/-/commit/e6c6ac69de1db981f9bd54c04d5ba05417258ecd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188831)) **GitLab Enterprise Edition**
- [Enable CI-based analyzer event tracking](https://gitlab.com/gitlab-org/gitlab/-/commit/2370e80fb09d401ff684c950d20e48daac75788f) ([merge request](190101!)) **GitLab Enterprise Edition**
- [Adds the analyzer_project_statuses query](https://gitlab.com/gitlab-org/gitlab/-/commit/af3d57992ba4649ee54032a1a5241b867ce6777c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186529)) **GitLab Enterprise Edition**
- [Add columns for web_based_commit_signing_enabled setting](https://gitlab.com/gitlab-org/gitlab/-/commit/dfceabe1c951eb55a0f3d95fb5ec7e755b9ab397) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189144))
- [Add product usage data log](https://gitlab.com/gitlab-org/gitlab/-/commit/b53926cab7e8f3c436f1af0514f973dd627e56d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187132))
- [Add `organization_id` validations to fork_networks](https://gitlab.com/gitlab-org/gitlab/-/commit/4a4a17bc4753a55bae537e712b9c151bf7944e36) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184826))
- [Add Duo Workflow action component](https://gitlab.com/gitlab-org/gitlab/-/commit/aa6e5fbcf9a2d170653a7509c634a1143968df8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189522)) **GitLab Enterprise Edition**
- [Add table for Organizations::OrganizationUserAlias](https://gitlab.com/gitlab-org/gitlab/-/commit/d19c6508471985966168856180bcc3205537478d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189052))
- [The base implementation of the PDF Vulnerability Report](https://gitlab.com/gitlab-org/gitlab/-/commit/eba92b1f5ce53243a48d71220356de8208428c57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185058)) **GitLab Enterprise Edition**
- [Release the routable tokens feature](https://gitlab.com/gitlab-org/gitlab/-/commit/087ffc24a56191e36e19fc3c491661ab01332e59) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190340))
- [Add migration to create hosted runner records](https://gitlab.com/gitlab-org/gitlab/-/commit/f84170a3303af5d6e0151e90abca8ab8e0a47c57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183329)) **GitLab Enterprise Edition**
- [Allow ai_workflows token to create Merge Requests](https://gitlab.com/gitlab-org/gitlab/-/commit/3e8652269377f6386bf0da67c62acd3668284752) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189938))
- [Add arguments to filter board lists by status](https://gitlab.com/gitlab-org/gitlab/-/commit/2ebff2779135ddb73daba3363512eec465482094) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189406)) **GitLab Enterprise Edition**
- [Add `Reload` option to GLQL blocks](https://gitlab.com/gitlab-org/gitlab/-/commit/6ad3ff65fb074c4436aea92c3c990c3fb89dfc40) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190264))
- [Add more accurate cluster health states](https://gitlab.com/gitlab-org/gitlab/-/commit/0be05e0570d5258f30ab73ca09c52163594d706d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190216))
- [ActiveContext: use stored search embedding version during search](https://gitlab.com/gitlab-org/gitlab/-/commit/6a10fa4b4a1a8867d0b1c09867244d40b0f99df4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188549))
- [Add status to board list GraphQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/cf3b79f6a59fc590d33eaece5b24895d02b73b6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189400)) **GitLab Enterprise Edition**
- [Add auto_duo_code_review_enabled setting to REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/247e0c1c64172c5fb4a24b8facc0fed975df4022) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188962)) **GitLab Enterprise Edition**
- [Add sync status, timestamps & error columns to ldap_admin_role_links](https://gitlab.com/gitlab-org/gitlab/-/commit/cce2109b538b9e76dcbdd42c2361a21035c00785) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189576))
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/fb7b4e580e99edd82cf459c086ece4a26a8a2a3e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190159))
- [Add default variable configuration to new policy](https://gitlab.com/gitlab-org/gitlab/-/commit/f618be89bc034fb28691b223d0b38635f31d09df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189767)) **GitLab Enterprise Edition**
- [Add update logic for Duo Core enablement for Self-Managed](https://gitlab.com/gitlab-org/gitlab/-/commit/0eb37d7afb554818772afd1f97fad3c12a8d805f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189774)) **GitLab Enterprise Edition**
- [Display missing Duo configs in info card](https://gitlab.com/gitlab-org/gitlab/-/commit/3bbaf34b65b90f97349a3b45c82cf0e2a5e0ebe8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189889)) **GitLab Enterprise Edition**
- [Add variables overwrite configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/754c1b7060107a28790343c6e33f7d723a54576a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188591)) **GitLab Enterprise Edition**
- [Add author_email column to gpg_signatures table](https://gitlab.com/gitlab-org/gitlab/-/commit/28f2b7018dcfac3a9396819d0b378de675f72491) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189770))
- [Add LDAP badge & filter to the users page in admin area](https://gitlab.com/gitlab-org/gitlab/-/commit/b60a5f785632591ce9a2d2048ea0826629e6b02e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187105))
- [Add batched background migration to dpop column](https://gitlab.com/gitlab-org/gitlab/-/commit/4402c592a71517f4dbf0883e841bb39f3172fc19) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188396))
- [Introduce policy for creating immutable tag rules](https://gitlab.com/gitlab-org/gitlab/-/commit/d07f9ae0b7507500c5f3eb8e36e41d68f8248844) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188667))
- [Add ScheduleWithinWorker to schedule jobs with jitter](https://gitlab.com/gitlab-org/gitlab/-/commit/ab24516e7e8090b9c7f2d11422f21b3665c6a131) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189021))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/bd9667799d2800b027f03604ee32b7180fd10ce4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189884))
- [Add syncing LDAP with admin roles to cron jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/c794e91be1a551c2a49dc7e5f9c676cb18c6edd6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189809))
- [Set branch and pass in workflow_definition](https://gitlab.com/gitlab-org/gitlab/-/commit/205da58ae60cbd65e0d5f0440d5249fcd21b41d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188198)) **GitLab Enterprise Edition**
- [Allow Organization agents when creating workspaces](https://gitlab.com/gitlab-org/gitlab/-/commit/2e6be56213f8a81e2514e2aa853ca8b20cf2d9cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188260))
- [Remove limit_unique_project_downloads_per_namespace_user](https://gitlab.com/gitlab-org/gitlab/-/commit/44ae1deae9961efdae73772bfa9e5ddad051f781) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183101)) **GitLab Enterprise Edition**
- [Add default state and validation](https://gitlab.com/gitlab-org/gitlab/-/commit/b208d2d120f448bf27f6989998d5a93eb83a5ff9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189607)) **GitLab Enterprise Edition**
- [Add protected and immutable tag patterns to tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/4d914f4868c3d79eff538188844a76f00f3b5aba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188812))
- [Add copy permalink to repository overflow menu](https://gitlab.com/gitlab-org/gitlab/-/commit/e7cd462f9e8fdab98423978291857147df79e10f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189208))
- [Show work item status badge in child and linked items](https://gitlab.com/gitlab-org/gitlab/-/commit/156bbb1ce8acfa4da4bf00376ec510548512dfe2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187639)) **GitLab Enterprise Edition**
- [Adding order by attribute to project compliance statuses](https://gitlab.com/gitlab-org/gitlab/-/commit/b582b48da6cf63760aa420a3745af88798084d9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188555)) **GitLab Enterprise Edition**
- [Add group transfer event handler for vulnerability_namespace_statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/b919bf1e1b4b53abda82bd60b8111ce9efd91a89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187742)) **GitLab Enterprise Edition**
- [Add classes for syncing ldap with custom admin roles](https://gitlab.com/gitlab-org/gitlab/-/commit/a2b9976abc34212c3b2c24f13a37356eb447a6d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187526))
- [Add status argument to boardListCreate mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/069820472fdf6f391cc8a795d54139aa607ba70d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189575)) **GitLab Enterprise Edition**
- [Add internal event for dependency list version filtering](https://gitlab.com/gitlab-org/gitlab/-/commit/7b78f4b0f74d45b1587785d987e99a3659fc09dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189356)) **GitLab Enterprise Edition**
- [Show detailed pod status](https://gitlab.com/gitlab-org/gitlab/-/commit/410c19127d85112749024d069fb74d66ecda8737) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189471))
- [Add get package files with revision](https://gitlab.com/gitlab-org/gitlab/-/commit/3f0594d47d476985332e17bf9fd42c16b5c0f049) by @mbo5be ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187850))
- [Auto enable Duo Core features setting when activating a new subscription](https://gitlab.com/gitlab-org/gitlab/-/commit/453874a4e8263f4f0df9327ed4a9d056eddc0147) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189302)) **GitLab Enterprise Edition**
- [Add support for showing Duo Workflow component](https://gitlab.com/gitlab-org/gitlab/-/commit/e8197c3411a81feb5be83da15199bea6f161f1ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189412)) **GitLab Enterprise Edition**
- [Protected packages: NuGet package push protection](https://gitlab.com/gitlab-org/gitlab/-/commit/7a0f09c21f086b35a18b1650ebc2c2d8afa02194) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184059))
- [Add variable override option](https://gitlab.com/gitlab-org/gitlab/-/commit/0f2479c6c7b3dc0ab8c35f51972e155aaab7403b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188451)) **GitLab Enterprise Edition**
- [Add the admin setting to cache the zoekt result](https://gitlab.com/gitlab-org/gitlab/-/commit/a67bb4f0418bdcef5f8da8463698efdf810364fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189266)) **GitLab Enterprise Edition**
- [Add Vulnerability Reads Es finder](https://gitlab.com/gitlab-org/gitlab/-/commit/4f8b2aa9e3fac488013c26e0ff448114e259612a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188112)) **GitLab Enterprise Edition**
- [Allow links from work items to incidents](https://gitlab.com/gitlab-org/gitlab/-/commit/4c2beb6a13fc8b07815e2db387386d1cedb7db5b) by @vedant-jain03 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179152))
- [Update Semver_dialects to 3.7.0](https://gitlab.com/gitlab-org/gitlab/-/commit/8644fd1604f7fa7b801f1366b25e29e75f00f1c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188903))
- [Removes the group_remove_dormant_members FF](https://gitlab.com/gitlab-org/gitlab/-/commit/5f26590a73b43b97bd6421568f77e0bac750cc60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182577)) **GitLab Enterprise Edition**
- [Add silent-mode subscription activation error](https://gitlab.com/gitlab-org/gitlab/-/commit/789e46aa06de32087d86fdfe117ab8bc7bd3e0dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189182)) **GitLab Enterprise Edition**
- [Remove duo_additional_context feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/9f7855164a1e128e3c507a7b88042dcc3b6e9eda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189728)) **GitLab Enterprise Edition**
- [Add application settings to manage CI/CD partitions](https://gitlab.com/gitlab-org/gitlab/-/commit/90cc0aca2de721dd1267d53ab204d91c12beb619) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189131))
- [Add the ability fetch group level sbom component versions](https://gitlab.com/gitlab-org/gitlab/-/commit/84548c661e9c676b5dcb4dc94512329171b1da99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184270)) **GitLab Enterprise Edition**
- [Add upgrade Duo Core card](https://gitlab.com/gitlab-org/gitlab/-/commit/616e892efba73f9418849c5f1c5c804ffaa2123c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189161)) **GitLab Enterprise Edition**
- [ActiveContext: use indexing_embedding_versions to generate embeddings](https://gitlab.com/gitlab-org/gitlab/-/commit/2917e41117d46f489ea81741687fb58780198a5f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188535))
- [Allow admin to update duo_nano_features_enabled Duo setting](https://gitlab.com/gitlab-org/gitlab/-/commit/1b50980b818d52599de87dfe18a4fe638a4e1120) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187565)) **GitLab Enterprise Edition**
- [Add Contributor count to project-level VSD lifecycle metrics table](https://gitlab.com/gitlab-org/gitlab/-/commit/2cf69dd44988783377629f73978b91662aac7815) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188905)) **GitLab Enterprise Edition**
- [Finalize BackfillArchivedAndTraversalIdsToVulnerabilityStatistics BBM](https://gitlab.com/gitlab-org/gitlab/-/commit/f434b124f9f2659869b730db3c4d17245921870c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186127))
- [Adapt Duo configuration info card for Duo Nano](https://gitlab.com/gitlab-org/gitlab/-/commit/63e0af81f3eec6b38817dc436b18db70510c6659) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188625)) **GitLab Enterprise Edition**
- [Remove duo_additional_context feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/22ea25f799e3145a674ea1823ff3c0bfa05689be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188608)) **GitLab Enterprise Edition**
- [Deleting all compliance statuses for a project when moved](https://gitlab.com/gitlab-org/gitlab/-/commit/cbb7e02ea41833ee449fe382af05ec318d5737e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188401)) **GitLab Enterprise Edition**
- [ActiveContext: add operation type upsert_only](https://gitlab.com/gitlab-org/gitlab/-/commit/b943e9370bac46bf149cdf34c24543abc7502fe0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188877))
- [ActiveContext: add migration for updating metadata on collection](https://gitlab.com/gitlab-org/gitlab/-/commit/1296205ef443e6fa0f35dba231e333093c4fbaa5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187724))
- [Add variable override option](https://gitlab.com/gitlab-org/gitlab/-/commit/8bd54e3c657b6ad76c3e94df55e58cb96a7f0999) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188190)) **GitLab Enterprise Edition**
- [Add `up` key shortcut behaviour on Work Items](https://gitlab.com/gitlab-org/gitlab/-/commit/d23299c1e9c87e10d44f27d48cb7f969e1c6960c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189067))
- [Release SAML Groups Duo Add On Assignment](https://gitlab.com/gitlab-org/gitlab/-/commit/0bdc298d3393b2ea6d45d7313781d47801af05f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189231)) **GitLab Enterprise Edition**
- [Introduce GitLab Geo feedback banner](https://gitlab.com/gitlab-org/gitlab/-/commit/eeded6f6d97c20f2e941494d72faeb86b2281cbe) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188378)) **GitLab Enterprise Edition**
- [Raise headers chars for audit event destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/760a0f55d94504811bbb716263fd5cc0df90a398) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188797)) **GitLab Enterprise Edition**
- [Add the ability to filter by version for project](https://gitlab.com/gitlab-org/gitlab/-/commit/65f57b7811f5862f2650e312177b243fe4724f9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188782)) **GitLab Enterprise Edition**
- [Relocate Duo self-hosted pages to Duo settings menu](https://gitlab.com/gitlab-org/gitlab/-/commit/04dec13cf226a3f0fd21fc47b9ef1539dbaa8c9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188522)) **GitLab Enterprise Edition**
- [Enable dormant member limited capacity worker](https://gitlab.com/gitlab-org/gitlab/-/commit/ba0329f1fce5ae80cd47f74f3be1eb9ef9e98e8a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189128)) **GitLab Enterprise Edition**
- [Allows runner URLs to be fetched via a project connection](https://gitlab.com/gitlab-org/gitlab/-/commit/193085b5dd3264057266b9b49832c6a8b9d6c880) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189115))
- [Add `active` parameter to Groups REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/0a0eff64bbbec56fd6d4e53b1b447b33658bc387) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186393))
- [Add optional parent_namespace_id to group delete event](https://gitlab.com/gitlab-org/gitlab/-/commit/8ea54bc9f5f4c6a8a2f4fe7ba2d2a8217ca64e10) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189089))
- [Expose "active" parameter to the Projects REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/0c402a3ac3ad933d737e402b195f5d83ed2408c1) by @dagaranupam ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187416))
- [Display Last GitLab Duo Activity on Duo Seat Utilization Page](https://gitlab.com/gitlab-org/gitlab/-/commit/cd0aff42bbecffad914f3efd7ec90f288474aefd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188609)) **GitLab Enterprise Edition**
- [Add new code suggestions field to GraphQL aiMetrics](https://gitlab.com/gitlab-org/gitlab/-/commit/658ded9e285d641a51cec6b0b716c0bddae2ee88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185844)) **GitLab Enterprise Edition**
- [Filter Non-Applicable Features from Premium Users in Duo Enterprise](https://gitlab.com/gitlab-org/gitlab/-/commit/e205653324bb611eae03d00fcda78c3d52b2af58) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189006)) **GitLab Enterprise Edition**
- [Remove vulnerability redetected note feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/14a90789b11da3edbe153e504f2059a89baeba89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188998)) **GitLab Enterprise Edition**
- [Add status to legacy issues GraphQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/0020fe5afe88e5ac2216d1b6ca51831c8c6cc7b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188950)) **GitLab Enterprise Edition**
- [Add search to pipeline stage dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/bb5c441ac560cf883af9352454a01b9207b97f84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187529))
- [Add group_setting jsonb column to app_settings](https://gitlab.com/gitlab-org/gitlab/-/commit/d4e675cbfd681914624e11664a62341b258079a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187738)) **GitLab Enterprise Edition**
- [Add popover to parent widget link](https://gitlab.com/gitlab-org/gitlab/-/commit/ee77a86279ea4e2787111863499fe77c87fde2d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187763))
- [Add auto_duo_code_review project setting](https://gitlab.com/gitlab-org/gitlab/-/commit/e10315dadbb09b4d838820bb5a044998a0f70002) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188069)) **GitLab Enterprise Edition**
- [Show `Create new emoji` within work items emoji picker](https://gitlab.com/gitlab-org/gitlab/-/commit/49375fc0858518e064bc624d8d83ef8725564818) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187200))
- [Add authenticate v2 endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/d551c0e1972a03a6d76c3509fa49302d4b7209e1) by @mbo5be ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187977))
- [Add latest package revision endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/b1642ce0b585d0fad6304c978f473da8e262967d) by @oceane_scania ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187678))
- [Create merge_request_commits_metadata table](https://gitlab.com/gitlab-org/gitlab/-/commit/779d322c3d6c5027365b1877a8287b777ad537e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186556))
- [feat: Add admin API to revoke user support PIN](https://gitlab.com/gitlab-org/gitlab/-/commit/fab89872bc0fb1a1152f5ef8c48cf218b6807dbd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187657))
- [Add possibility to hide Duo Base from Duo frontend](https://gitlab.com/gitlab-org/gitlab/-/commit/3f93f09400da7178718aaf36cd06f4cde849ec57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188414)) **GitLab Enterprise Edition**
- [Add support for deleting agent managed resources on environment stop](https://gitlab.com/gitlab-org/gitlab/-/commit/1b89c6f673e0df88e9dda09f019e2e60674ae5ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188024))
- [Add column build_id to analzyer_project_statuses table](https://gitlab.com/gitlab-org/gitlab/-/commit/f1ed69c67ee34fe02878e957535ef6bb4a61ebfc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187480))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/3466d88833d521418d88a7bc796fc384746d9d47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188762))
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/bc279117cda8faab7df7204526e9bc378ddb734a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188748))
- [Release scheduled PEP feature as experiment](https://gitlab.com/gitlab-org/gitlab/-/commit/5a81dc1e1953bf16eee914339ba9d5394fc99a6e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187779)) **GitLab Enterprise Edition**
- [Initial commit to create vulnerabilities ES Index](https://gitlab.com/gitlab-org/gitlab/-/commit/cc6420d9e20a593d20faba1f9f3cd8023bd7f38e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185327)) **GitLab Enterprise Edition**
- [Create instance level compute visualization](https://gitlab.com/gitlab-org/gitlab/-/commit/3e4f91883aad570dc84e4171c370564760712f03) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180612))
- [Add Pages/Next.js project template](https://gitlab.com/gitlab-org/gitlab/-/commit/ba6023436ed6fde2796a13641c491e27ed65a680) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188669))
- [Add multiline paste support for custom fields](https://gitlab.com/gitlab-org/gitlab/-/commit/d4d399b8e530ceb73b6571ea497c30363ae3e975) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187970))
- [Add the ability to filter dependecines by version](https://gitlab.com/gitlab-org/gitlab/-/commit/18d9705187ee4166459dbb8a8bea08384e20c410) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188337)) **GitLab Enterprise Edition**
- [Add system note when a vulnerability is redetected](https://gitlab.com/gitlab-org/gitlab/-/commit/6ab0c48c904a1d03c2946833414350561f8e40d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188156)) **GitLab Enterprise Edition**
- [Add support for Duo to GitLab Duo pages](https://gitlab.com/gitlab-org/gitlab/-/commit/e3f45279db9bc1e93cae8787bd418b781a07bbe1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188191)) **GitLab Enterprise Edition**
- [Add endpoint for deletion of all done todos](https://gitlab.com/gitlab-org/gitlab/-/commit/f29a31bda387e8f8758d787a43b018943bdc3a3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184767))
- [Add REST API support for managing pipeline schedule inputs](https://gitlab.com/gitlab-org/gitlab/-/commit/a7c4df60395d079d54c064a58ae7ef1ee2edfba9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185389))
- [Allow LDAP users to authenticate by using their GitLab username](https://gitlab.com/gitlab-org/gitlab/-/commit/55bd866d2440aa6eb6f6d4af5c1ce02e88257638) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186848))
- [Follow-on Root Cause Analysis Hotspot experiment](https://gitlab.com/gitlab-org/gitlab/-/commit/b37ab87a64e2b4265ac96f8f218b1a24058a06d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186914)) **GitLab Enterprise Edition**
- [Use duo_base_features_enabled as attribute instead](https://gitlab.com/gitlab-org/gitlab/-/commit/166c8c4417b62d53aba9396aec0fe79aee3a2874) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188290)) **GitLab Enterprise Edition**
- [Update TroubleshootJob executor to include ai tracking](https://gitlab.com/gitlab-org/gitlab/-/commit/43592eb686dd2395959eaf8a4e1e80f2fd36b2ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187848)) **GitLab Enterprise Edition**
- [Allow to display Rapid Diffs on merge request creation page](https://gitlab.com/gitlab-org/gitlab/-/commit/6785d12068e83c777d6bf639cd0e870eab27cd35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187955))
- [Add MR pipeline support to AST CI/CD templates](https://gitlab.com/gitlab-org/gitlab/-/commit/3b1f2e5dd999bb51684c0ebb01d565f7049f44e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179652))
- [Remove importer_user_mapping_reassignment_csv feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/04af091b73d12ab94939bc2ea18c2543c6b0a5ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187170))
- [Allow batched background migrations to be listed by job name](https://gitlab.com/gitlab-org/gitlab/-/commit/31e0bb577662c7a7f4d565b2f2db8d8f0b833cd5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187413))
- [Support Premium licenses to use self-hosted AI models](https://gitlab.com/gitlab-org/gitlab/-/commit/bcb9b5aeda80f8ae01d32a64e67daf5bb4751870) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188263)) **GitLab Enterprise Edition**
- [Create Rake Task to Bulk Assign Duo Seats](https://gitlab.com/gitlab-org/gitlab/-/commit/43b62ac5f590e7fcaecded495b0c45a93ab8a0c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187230)) **GitLab Enterprise Edition**
- [Add ability to trigger Duo Code Review automatically](https://gitlab.com/gitlab-org/gitlab/-/commit/896cdc462f9a756c0c7d1dd5f8c87eb34cf47c6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187807)) **GitLab Enterprise Edition**
- [Add metrics for mrap package exceptions](https://gitlab.com/gitlab-org/gitlab/-/commit/c13453f8d1a76131dab6563ab2dc40f857cc0658) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187782)) **GitLab Enterprise Edition**
- [Enable Coverband UI](https://gitlab.com/gitlab-org/gitlab/-/commit/7ef4e0200655cf665645ac01fc64bb0ad50d3d12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188364))
- [Add SaaS detection and Duo Workflow paths to admin settings](https://gitlab.com/gitlab-org/gitlab/-/commit/d67f0f207a664147bbaf8d40318af2a851a2d5ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188265)) **GitLab Enterprise Edition**
- [Adds GraphQL queries for vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/da54880f9721635a91264708e815070b16876de4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184633)) **GitLab Enterprise Edition**
- [Add sorting projects by full path](https://gitlab.com/gitlab-org/gitlab/-/commit/2a7f7122de57875e70be6d76ae270bb75ed0f48d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187174))
- [Add email prefix feature for gitlab emails](https://gitlab.com/gitlab-org/gitlab/-/commit/dc07d4577d35ed09b954a1225298c9c82d544ffd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184568))
- [Add support for aliases in GLQL](https://gitlab.com/gitlab-org/gitlab/-/commit/88ad392850ffb6962bfc87554c0ea7719d1e91c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188073))
- [Add status widget to the sidebar of tasks](https://gitlab.com/gitlab-org/gitlab/-/commit/952f888a68cdaffd1a9d5cd304b4ac44f9d135d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187818))
- [Sync Cloud Connector tokens hourly](https://gitlab.com/gitlab-org/gitlab/-/commit/a850c8edaa3cdef48a75afd353c62114515fecdf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188065)) **GitLab Enterprise Edition**
- [Add advanced vulnerability filters to es](https://gitlab.com/gitlab-org/gitlab/-/commit/cd9e68d8ae21a39e18ac0c7a45f2b0153c7d1ebf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187330)) **GitLab Enterprise Edition**
- [Allow titles to contain markdown](https://gitlab.com/gitlab-org/gitlab/-/commit/c6c600b3d523880fcadf5f3f7f784605da28eb90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184070))
- [Add copy button to work item MR modal](https://gitlab.com/gitlab-org/gitlab/-/commit/32c03ee013a8b6d50501771560397dad4f26ebf7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187614))
- [Enable periodical_namespace_descendants... FF](https://gitlab.com/gitlab-org/gitlab/-/commit/73dedc746cc2f968f9d63461d0379a8289c766c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188042))
- [Use whitespace setting on Rapid Diffs page reload](https://gitlab.com/gitlab-org/gitlab/-/commit/9e31eca2f22cf9dbe29f95d71a0929852a3f9e67) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186430))
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/4cdda7c4bb2ce757087e7c04b2f43978f8d5528d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188020))
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/1b3aee797f8fc261ddfd5c407a6d73aa93458afa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188019))
- [Add IdP-scoped SAML group links](https://gitlab.com/gitlab-org/gitlab/-/commit/020ee341c185a4fca9d7d10d8b0757e5533c698d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184213)) **GitLab Enterprise Edition**
- [Add UI setting for AI agents to run pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/f95dd1dea4e6a83d5413cda8bae57938f305b32d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187945)) **GitLab Enterprise Edition**
- [Create organization_push_rules table](https://gitlab.com/gitlab-org/gitlab/-/commit/863894063f80e26b3e62418f57896bcc3360f205) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186908)) **GitLab Enterprise Edition**
- [Enable custom fields by default](https://gitlab.com/gitlab-org/gitlab/-/commit/98ef1bc32d15e1953fe44a59dea94da553e2f705) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187721)) **GitLab Enterprise Edition**
- [Allow owner to update duo_nano_features_enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/ba933c4163a9eb9e19d0263aeaca9f9abb76f0b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187692)) **GitLab Enterprise Edition**
- [Add merge requests data source](https://gitlab.com/gitlab-org/gitlab/-/commit/53e5511d2fdb06b2bd177974eac55e4e22ae49ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186762)) **GitLab Enterprise Edition**
- [Connect current statuses and custom statuses](https://gitlab.com/gitlab-org/gitlab/-/commit/3d7469f264b44df36d2e98c118b7d6ccfe945de4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186943))
- [Added validation for control name and expression](https://gitlab.com/gitlab-org/gitlab/-/commit/d3e52e32c9cfdf38cdbe2b600d585a20ca63939a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187350)) **GitLab Enterprise Edition**
- [Add `permalinkPath` field to TreeType via TreePresenter](https://gitlab.com/gitlab-org/gitlab/-/commit/a078f040d9a31bdea013d1bbce960c03a1684fec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186829))
- [Release conan protected packages feature](https://gitlab.com/gitlab-org/gitlab/-/commit/7e36dd7c2ea7c5d7b142ec4941c8a103a474acb4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187123))
- [Add AST_ENABLE_MR_PIPELINES var to scan execution policies](https://gitlab.com/gitlab-org/gitlab/-/commit/91b59abe2714a73a0ac19a56321a3d44985d907f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186739))

### Fixed (169 changes)

- [Loosen settings.write stub and expectations in GithubService spec](https://gitlab.com/gitlab-org/gitlab/-/commit/aab89e5ff5a8c26e533eb7443ca561039161ecad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190977)) **GitLab Enterprise Edition**
- [Hide delete button for All branches](https://gitlab.com/gitlab-org/gitlab/-/commit/6f230775a12c8b45725a3a15315b55e493d0287f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190942))
- [Handle invalid import URLs](https://gitlab.com/gitlab-org/gitlab/-/commit/d706f1db3ecc915e4d6908d8fa57ce6ac5db24ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190873))
- [Add query params for prefilling new work item](https://gitlab.com/gitlab-org/gitlab/-/commit/74a09ae2ab44693b1a9d20bd2d3c1b536c3247c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190389))
- [Update feature specs to pass when pipeline inputs flag enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/660840e6d53418a3363cadf9ddeca28b2ed8dcf5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189091))
- [Prevent duplicate submissions in work item form](https://gitlab.com/gitlab-org/gitlab/-/commit/2e443c1991ead83be012cb1aeb3afb0ccae86a7a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190772))
- [Move class to component](https://gitlab.com/gitlab-org/gitlab/-/commit/b65a7fa5292503a3a5dea0ce50edc252ae6f182e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189687)) **GitLab Enterprise Edition**
- [Use `no_longer_detected_ids` when auto-resolving vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/5a9e23ff356dc1ed8be07320e30529d24a294dc0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190738)) **GitLab Enterprise Edition**
- [Fix sequence ownership for builds_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/d06c1ad92dddd69330a9d2e45e497c6b0028435c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190701))
- [Use tanuki icon for pages/html import](https://gitlab.com/gitlab-org/gitlab/-/commit/c32634b8b9b8b4b270c9fd3ccc034e010ffe625b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190532))
- [Fix scheduled PEP project schedule (re)creation](https://gitlab.com/gitlab-org/gitlab/-/commit/e8ee4a08d9eb145fc05eb94191adac3dc5bad565) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190088)) **GitLab Enterprise Edition**
- [Fix members list in group protected environments](https://gitlab.com/gitlab-org/gitlab/-/commit/ef7c08ca086f3fa6eee24af15f72a60f17a7a260) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190576)) **GitLab Enterprise Edition**
- [Fix bugs on dependency paths](https://gitlab.com/gitlab-org/gitlab/-/commit/731125ce239fc80107350ded864acd14cbfe2083) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188972)) **GitLab Enterprise Edition**
- [Change workspace scripts volume permission to 555](https://gitlab.com/gitlab-org/gitlab/-/commit/e381248a64826e693a7eb23988f628ffb70da7cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190568))
- [Search Settings checkboxes only visible when instance is licensed](https://gitlab.com/gitlab-org/gitlab/-/commit/69b677c418241e67e8bcb2a3e3149aeeeddfe623) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190522)) **GitLab Enterprise Edition**
- [Fix TypeError for GraphqlController#query parameter](https://gitlab.com/gitlab-org/gitlab/-/commit/ec61ce23658a8d22026463e4781ac356b771683c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190186))
- [Fix creating system notes for mentions in wiki pages](https://gitlab.com/gitlab-org/gitlab/-/commit/9bdb563219e1e1066a4c6988ae23fd300b1623bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189278))
- [Add Imported badge for Comments and System notes](https://gitlab.com/gitlab-org/gitlab/-/commit/3d987cb1c4afea3c5dbaac008336c7d6db887345) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190515))
- [Fix manual job is not clickable (mini graph)](https://gitlab.com/gitlab-org/gitlab/-/commit/cc958fd114b0e6826b8984fbb0f66edaa2f03d68) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190504))
- [Markdown preview header: Fix overlap on left](https://gitlab.com/gitlab-org/gitlab/-/commit/f8d904aa8239a8aa33489f0dbf8ead0764ef6264) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190503))
- [Fix NoMethodError for markdown documents with a single space](https://gitlab.com/gitlab-org/gitlab/-/commit/75b9842dd772bdc50b073ea475cc9c39553d196b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190482))
- [Disable Self-hosted models configurations on GitLab dedicated](https://gitlab.com/gitlab-org/gitlab/-/commit/ec11c67eef4844ba6dad5a022e88e764540736b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190181)) **GitLab Enterprise Edition**
- [Allows clearing Docker Hub Authentication details in the UI](https://gitlab.com/gitlab-org/gitlab/-/commit/28bae318beb333a3c348c08d61ad2e9ca4e2dee8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189998))
- [Support trusted proxies in Workhorse config](https://gitlab.com/gitlab-org/gitlab/-/commit/74f8b1251291641b7d024406085c9807d5411fd7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189530))
- [Add a ping? check before hitting Elasticsearch in admin](https://gitlab.com/gitlab-org/gitlab/-/commit/b4d78e8a84844c2358bd7042a79653d982078e4c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189968)) **GitLab Enterprise Edition**
- [Skip orphan Sbom::Occurrence records when executing CVS](https://gitlab.com/gitlab-org/gitlab/-/commit/fe343c2d9ea7e4f219c793ca44e615642a95af82) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190413))
- [Adapt request for Duo settings update for sub-groups](https://gitlab.com/gitlab-org/gitlab/-/commit/2780802ab3bb5f34c293e003de835816a0b3490b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190386)) **GitLab Enterprise Edition**
- [Link security policy to framework from multiple top-level groups](https://gitlab.com/gitlab-org/gitlab/-/commit/fa777e11694b31d0789dd93232543dec53a81258) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190154)) **GitLab Enterprise Edition**
- [Update comment box warning text](https://gitlab.com/gitlab-org/gitlab/-/commit/c26ac06b4fb7d5433c89b4ffbf3ccb9b42132aed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189037))
- [Hide disable PAT group setting on self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/86e9c09fbb9504bf710f1cc0d03fa82a564317f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189333)) **GitLab Enterprise Edition**
- [Make Geo Registry Names translatable and no longer auto generated](https://gitlab.com/gitlab-org/gitlab/-/commit/356860c514dfbd5958917e65d6699ec43e11c30a) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187676)) **GitLab Enterprise Edition**
- [Fix no method error in SyncPolicyEventWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/c8f26445e538b3f0b7018b6984810492b20c1e8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189920)) **GitLab Enterprise Edition**
- [Save custom_software_license if license is not on SPDX list](https://gitlab.com/gitlab-org/gitlab/-/commit/0539387ad76f3a142a2ff10d76fbb8e95d62ca59) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190124)) **GitLab Enterprise Edition**
- [Fix Web IDE iframe-based OAuth token refresh](https://gitlab.com/gitlab-org/gitlab/-/commit/8658b263f01a8182af274ec5d4ea597c81b4a158) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190307))
- [Fix missing PAT last_used_ips in GitLab CE](https://gitlab.com/gitlab-org/gitlab/-/commit/72e3ad5ce5bdcdc435895ca95b44ce5c4b148378) by @thomasgl-orange ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187714))
- [Fixed command palette edge case](https://gitlab.com/gitlab-org/gitlab/-/commit/6aca0c214ad5d597aef2a40f7da9db90db3361f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187691))
- [Fix overflow issue of issue title in user profile activity](https://gitlab.com/gitlab-org/gitlab/-/commit/0ecffdda3335a6b9200cae61a32cd86ca510a0a7) by @mosampatel78 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190151))
- [Fix work item URLs in activity RSS feeds](https://gitlab.com/gitlab-org/gitlab/-/commit/952d7c27701d6038129ca5b22f6d0f2145d538a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190037))
- [Reschedule deduplicated `SyncScanPoliciesWorker`](https://gitlab.com/gitlab-org/gitlab/-/commit/01f4c967439fec9e0bc3fda80ea7f233699ad70f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189784)) **GitLab Enterprise Edition**
- [Handle race condition in approval rule creation from approval policy](https://gitlab.com/gitlab-org/gitlab/-/commit/36819f0d7a535360705add25cb4b05c993eb194d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190155)) **GitLab Enterprise Edition**
- [Pull branch ref from Gitaly if not present in Redis](https://gitlab.com/gitlab-org/gitlab/-/commit/dc4ca4c4b057256bd426fdcaf24669c428f159fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188492))
- [Skip resolved_by validation on importing records](https://gitlab.com/gitlab-org/gitlab/-/commit/3d3a957982e3ca86fe54da2964f950f3165e8247) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190081))
- [Work items notes: Fix use of shortcut 'r'](https://gitlab.com/gitlab-org/gitlab/-/commit/8ffdf10977c2c1b58eeb1f4a5857c796019f5822) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190052))
- [Update runners/all access](https://gitlab.com/gitlab-org/gitlab/-/commit/669184e393ef3b27b562cabf108aa3eacc263570) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189287)) **GitLab Enterprise Edition**
- [Fix the new DS analyzer CI job image url](https://gitlab.com/gitlab-org/gitlab/-/commit/9865e404f4ee11a8a18f9db0e4478958b9a7647d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189987))
- [Fix subgroup filtering in framework project selection](https://gitlab.com/gitlab-org/gitlab/-/commit/e169b215e090351e3f797807395827aed9d7205e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189869)) **GitLab Enterprise Edition**
- [Fix the deletion callback bug for ES bookkeeping](https://gitlab.com/gitlab-org/gitlab/-/commit/b992a80fe39c6b1f17d794acfa772b222c1e82ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189840)) **GitLab Enterprise Edition**
- [Check for router nav possibility](https://gitlab.com/gitlab-org/gitlab/-/commit/565a04401217352848ed78fb38d278c8efa7c766) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189916))
- [Allow using comment templates in MR reviews](https://gitlab.com/gitlab-org/gitlab/-/commit/e23232fbd07392d56248f270ac7e2181d3bf1700) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189896))
- [Fix title disappearing in CreateWorkItemModal](https://gitlab.com/gitlab-org/gitlab/-/commit/8775f18d2852fb2fd0d95c42071455d18e7abff0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189145))
- [Check for setting before showing ImportHistoryMenu](https://gitlab.com/gitlab-org/gitlab/-/commit/f743d42d55f6562fe8face48899b9af8cea8e3a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189844))
- [Prevent unauthorized users from adding, selecting or archiving designs](https://gitlab.com/gitlab-org/gitlab/-/commit/6fde5be3c02d745f7186a3e5ead6221b37b89d35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189352))
- [Fix read AI Setting error when not logged in](https://gitlab.com/gitlab-org/gitlab/-/commit/7fa7346880d7758ace283e9bfea5f0451a5df7b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189805)) **GitLab Enterprise Edition**
- [Optimize searching projects with component version](https://gitlab.com/gitlab-org/gitlab/-/commit/46a71cc5efc0923b6c73dd1a01c054c0891764bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189728)) **GitLab Enterprise Edition**
- [Alternative Vue breadcrumb injection method](https://gitlab.com/gitlab-org/gitlab/-/commit/99e41df6f4bcc85fb1846e969c3eef0112941cad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186906))
- [Use SECURE_ANALYZERS_PREFIX in new dependency-scanning jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/9aa79fe06d35db7f4ba6b19ca3d897693a434c7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189072))
- [Make `after_script` and `before_script` mutually exclusive with `run` keyword](https://gitlab.com/gitlab-org/gitlab/-/commit/2aea534f75a897c2b8dc6c65e0683b25a707643e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189437))
- [Link security policy to framework from multiple top-level groups](https://gitlab.com/gitlab-org/gitlab/-/commit/7a65bd2bdae0644b46bbf8dbe94d513d90457504) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189075)) **GitLab Enterprise Edition**
- [Package Assets table: Add check for upload slot](https://gitlab.com/gitlab-org/gitlab/-/commit/41f54ffd32e8cd5286e142056648ac4dd74b7bcd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189739))
- [Use issuable name in issuable by email popup](https://gitlab.com/gitlab-org/gitlab/-/commit/4d44bfbb6a71665d010ca68f110edbe5a395470b) by @curs3_w4ll ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188796))
- [Fix manual job is not clickable](https://gitlab.com/gitlab-org/gitlab/-/commit/1f8780c6da5c688df5144e82f3b956b869a64136) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188806))
- [Fix ci variable drawer state](https://gitlab.com/gitlab-org/gitlab/-/commit/c31d0c8d306eb1348ef05c74c988e06061f7a6b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189616))
- [Added detectAndConfirmSensitiveTokens to work_item_comment_form](https://gitlab.com/gitlab-org/gitlab/-/commit/6881c8e05f5910ec3dd2f831106f1f8953cd5863) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189258))
- [Fix CI depended triggers not locks resources](https://gitlab.com/gitlab-org/gitlab/-/commit/c3b4ac42072b79ef6e40de1ecc0e715a33eb0f06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189585))
- [Rescue invalid URI in TransformReferencesWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/e6411642df2cacac53f26cb01a8e59edb6e21217) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189599))
- [Fix typo in FIPS docs page](https://gitlab.com/gitlab-org/gitlab/-/commit/bacb72da48b1f104e6cf1e1d32bd0fb1805e03f3) by @zillemarco ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189597))
- [Add the Parallelism flag in the indexing request](https://gitlab.com/gitlab-org/gitlab/-/commit/bcb7321bf274a42fd165b9105f0640c68ea0b6c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189457)) **GitLab Enterprise Edition**
- [Bump devfile gem to v0.4.3](https://gitlab.com/gitlab-org/gitlab/-/commit/10c0949652f7668d1ac6e67d1e5d991cdfde8ec3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189533))
- [Show unknown status when nil Finding token status](https://gitlab.com/gitlab-org/gitlab/-/commit/2a0a65e3ad5ca575cc56b9719547231a74085ea7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188942)) **GitLab Enterprise Edition**
- [Fix bug where jobs don't show up in stage](https://gitlab.com/gitlab-org/gitlab/-/commit/61ebe2a4dce4723856d7fa3370ebb6b8ead67262) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189506))
- [Refactor NamespaceStatistics schedule worker namespace ids extraction](https://gitlab.com/gitlab-org/gitlab/-/commit/fc70cafe8f7c2f037f75b84c43c2682b83510db0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189239)) **GitLab Enterprise Edition**
- [Hide SSH signature from the tag's message](https://gitlab.com/gitlab-org/gitlab/-/commit/56448381fca598932d06768e3bf93a45c8f39fbc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189422))
- [Fix NoMethodError for Projects::RefsController#logs_tree](https://gitlab.com/gitlab-org/gitlab/-/commit/d17d6f1bc92a709ff83430732d48045c178b31f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189414))
- [Update fast_gettext gem to v4.1.0](https://gitlab.com/gitlab-org/gitlab/-/commit/70106af51da30b40ab033ddff129be50b02b4686) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189383))
- [Fix nullable timelog.user in GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/f57ec6c0594b501c85a665e56ddc5b0bee44cc90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189360))
- [Migrate timelogs for deleted users to ghost user](https://gitlab.com/gitlab-org/gitlab/-/commit/88c549b6344cb3ac32badaaa769838349785f1c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189377))
- [Fix logic to hide work item notifications widget for logged out users](https://gitlab.com/gitlab-org/gitlab/-/commit/57c44c0c84aef96968b4c078bafad68675f8e153) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189370))
- [Consolidate style for "Please register or sign in to reply"](https://gitlab.com/gitlab-org/gitlab/-/commit/2012a03451ec245130b3a30c0fe2df505c651827) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189368))
- [Fix SEP validation for target_default and target_protected branch types](https://gitlab.com/gitlab-org/gitlab/-/commit/4d4975996ab56cab07f7d85180ce684758de9aeb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188710)) **GitLab Enterprise Edition**
- [Ensure primary button on board form remains disabled before modal closes](https://gitlab.com/gitlab-org/gitlab/-/commit/e8065f15b00b2c2b233cad8973fead7961a50060) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189359))
- [Ignore up arrow shortcut trigger if current comment is not empty](https://gitlab.com/gitlab-org/gitlab/-/commit/d1c2ea426129c429eadfc3c232c7b0c3a23ce45d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189339))
- [Prioritize service response when showing issue type fetch error](https://gitlab.com/gitlab-org/gitlab/-/commit/950ed2ac690b94b84d64ff03d47097d720adce50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189330))
- [Remove force_scrollbar feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/98587272f0c49219a990a2804a3a097a4560c0d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189309))
- [Show partial data when there is an error in development widget](https://gitlab.com/gitlab-org/gitlab/-/commit/72cc551278c08d2755877409bd33d2494b3e7e18) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189180)) **GitLab Enterprise Edition**
- [Replace error with message when no comments found in /summarize_comments](https://gitlab.com/gitlab-org/gitlab/-/commit/9a863b063de34ca0cc743f2473095feca49efaa7) by @dagaranupam ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188010)) **GitLab Enterprise Edition**
- [Ensure security policy bot user before executing auto resolve policy](https://gitlab.com/gitlab-org/gitlab/-/commit/392cf48b0a02e5817ac7f20634e109dc86299ea2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189223)) **GitLab Enterprise Edition**
- [Fix issue popover's createdAt for non-relative-time users](https://gitlab.com/gitlab-org/gitlab/-/commit/b394e4a3addc1faeb3fc6edc08c409ac039356c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189221))
- [Only check records with encrypted data in gitlab:doctor:encryption_keys](https://gitlab.com/gitlab-org/gitlab/-/commit/bf17b924fd73b1ec5b759562242ae02a3ce45695) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189030))
- [Improve namespace statistics scheduleWorker performance](https://gitlab.com/gitlab-org/gitlab/-/commit/04458c1f764c9ad2722d87888bc84814b02ddd53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188503)) **GitLab Enterprise Edition**
- [Ensure token status has the correct value](https://gitlab.com/gitlab-org/gitlab/-/commit/4a20c322ade1a5efa6299d5bad696c08ad95ea65) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188839)) **GitLab Enterprise Edition**
- [Account for sign in bar for work item drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/de06234fba9c216b9535b74befaa987fd6d7aade) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189119))
- [Fix policy editor button position](https://gitlab.com/gitlab-org/gitlab/-/commit/7a3fa98bd77a3d8ceb935d62a5f2c40c7df3dfd0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189099)) **GitLab Enterprise Edition**
- [Auto-expand work item description on link navigation](https://gitlab.com/gitlab-org/gitlab/-/commit/72cba1e16964e180d15e2d18739e69556bc89671) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188940))
- [Add key to router-view to ensure re-renders](https://gitlab.com/gitlab-org/gitlab/-/commit/aca1ffd3e7bb2bb5d54e90b7025f7a3b25bc9dd8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188984))
- [Fixed single relation endpoint bugs](https://gitlab.com/gitlab-org/gitlab/-/commit/4e956c29e850337c8c7cc0e582356326b339f2aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187940))
- [Fix CRM validation bug when updating group settings](https://gitlab.com/gitlab-org/gitlab/-/commit/302538bdc502a5356a42dbea847e27f629804065) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188990))
- [Show webhook settings link if user has permissions](https://gitlab.com/gitlab-org/gitlab/-/commit/6bc9536ad3e7a1dc48489fe530288c4024cb848c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153808)) **GitLab Enterprise Edition**
- [Handle nils for prometheus integrations](https://gitlab.com/gitlab-org/gitlab/-/commit/f95ae76cbd29f6fa9ac25d8289f6a7d1c4e7a2ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187672))
- [Add BBMs to fix string config hashes in streaming destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/14e7cc75fc606078ddace5a0a4a51c5903f466e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187558)) **GitLab Enterprise Edition**
- [Fix streaming destinations BBMs](https://gitlab.com/gitlab-org/gitlab/-/commit/9f535b6a718c714fd5817f985b26d9967b087608) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186866)) **GitLab Enterprise Edition**
- [Update assignees search to include participants](https://gitlab.com/gitlab-org/gitlab/-/commit/c6966160e261d9fa48526bcec06e5c295881e7d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188914))
- [Provide set_pipeline_variables policy from backend](https://gitlab.com/gitlab-org/gitlab/-/commit/a3a16813205cf3542a2b2c624063339aa690bcf7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188325))
- [Fix skeleton loader for work item mention popover](https://gitlab.com/gitlab-org/gitlab/-/commit/a9a2f41152a3297025bbab2c91ac1b35a2199ac0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188768))
- [Use CSS-based loaders for work item loading state](https://gitlab.com/gitlab-org/gitlab/-/commit/bc50be7c03ab1e4f0722427a5396a13feff8e351) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188808))
- [Fix quoting of user name in ReplaceTable helper class](https://gitlab.com/gitlab-org/gitlab/-/commit/a4a225317fd45a79d534d2389aedede6233fc80c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188867))
- [Remove unnecessary expectation to fix flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/2ef43c2d4e2110feaee70a6def9c43900ea64131) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188888))
- [Fix broken Dockerfile highlighting](https://gitlab.com/gitlab-org/gitlab/-/commit/d31016d433f2c17aed4f3d31508583b8ea268ac3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188866))
- [Prevent :remove_group perm. when projects cannot be removed by owners](https://gitlab.com/gitlab-org/gitlab/-/commit/a002479429b519cbc2eccd820da83f24a7fcf510) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188530)) **GitLab Enterprise Edition**
- [Hide group settings for dependency proxy if config is disabled](https://gitlab.com/gitlab-org/gitlab/-/commit/becd0d6739a2ead1230050d06016cb5dc475e026) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187046))
- [Fix fluid width invite members banner](https://gitlab.com/gitlab-org/gitlab/-/commit/32342ed3424539090679dd553fab3b4a7103c525) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187431))
- [Clear form on milestone create or cancel](https://gitlab.com/gitlab-org/gitlab/-/commit/e8bf93de415f053079339136d8698f932c0e4038) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188787))
- [Fix token prefix change when PAT prefix is nil](https://gitlab.com/gitlab-org/gitlab/-/commit/11672934e2e6904cb52d1e69eddba50e6ba62e23) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188779))
- [Update fog-xml to v0.1.5](https://gitlab.com/gitlab-org/gitlab/-/commit/eda35d1cf9a4df8ff0b9bb2839f04313aeecdf72) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188739))
- [Fix MR diffs endpoint to respond with pagination headers](https://gitlab.com/gitlab-org/gitlab/-/commit/93f2c9acb5124e913f2248ed57725ee103bee2f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188752))
- [Fix bug with pipeline_schedule.last_pipeline loading all pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/ea0415926bbca5dbb75224c7ab4b89595517f933) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188719))
- [Fix project transfer not prioritizing exact matches](https://gitlab.com/gitlab-org/gitlab/-/commit/13bfd41ea173c664b7dc56a396ad697059ee3674) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188711))
- [Fix GraphQL /assign non-project member quick action (confidential issue)](https://gitlab.com/gitlab-org/gitlab/-/commit/b2f50a44a9d658d25063220e6f63a127a02ade12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188706))
- [Fix design routing issue](https://gitlab.com/gitlab-org/gitlab/-/commit/3b319b2739bc2b26858c22a1d1b4d3716df9f1f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188680))
- [Fix no method error construct pep with invalid policies](https://gitlab.com/gitlab-org/gitlab/-/commit/2eccae599b873d5a09968de951bbf42c9b222c75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187878)) **GitLab Enterprise Edition**
- [Fix suffix alignment for mobile screen](https://gitlab.com/gitlab-org/gitlab/-/commit/f5554527221e36e7550a63fab77b6e3b59d11ad3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188638)) **GitLab Enterprise Edition**
- [Remove unnecessary preload from pipeline schedules API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/898eed15402d4abfa912c2fb1613099fceadc906) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188606))
- [Fixed calling only one proper method to populate count](https://gitlab.com/gitlab-org/gitlab/-/commit/655893669a1a4701691755bc95e3454de7b6d505) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188142))
- [Fix the rendering of token Last Used IPs](https://gitlab.com/gitlab-org/gitlab/-/commit/21b2c7185aaefff1c80a36b1bd77041a587fcf4d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187403))
- [Do not try to update not existing record](https://gitlab.com/gitlab-org/gitlab/-/commit/e52a8caf1e0316bccba00e9ac088d8d7adbd7cf0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188557)) **GitLab Enterprise Edition**
- [Create security_policy_bot on project transfer](https://gitlab.com/gitlab-org/gitlab/-/commit/905be738e6dd46c67259f68cea8c2cdeae24a5c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188551)) **GitLab Enterprise Edition**
- [Use commit email for cherry pick via UI](https://gitlab.com/gitlab-org/gitlab/-/commit/029d75b5e7a683d1c5af3d532aae74d19ee4c9f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188546))
- [Respect fork filter for global zoekt search](https://gitlab.com/gitlab-org/gitlab/-/commit/3956f15e5d445af436b87601b5bffb7794cb3176) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187181)) **GitLab Enterprise Edition**
- [Fix issue where attached JS files couldn't be downloaded](https://gitlab.com/gitlab-org/gitlab/-/commit/c9c4347c6307e6891db7a4f91e17debeb07fb467) by @nikitasakau ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188465))
- [Allow update_runner policy for project runners shared indirectly](https://gitlab.com/gitlab-org/gitlab/-/commit/fde35b37427dd8eaac56f04493da38e4d98f49e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188147))
- [Fix pipeline execution policies limit for group-level policies](https://gitlab.com/gitlab-org/gitlab/-/commit/e058fc1ae26f014a0b41436a1aae12f1c8bdf774) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188293)) **GitLab Enterprise Edition**
- [Move router view out of collapsible section](https://gitlab.com/gitlab-org/gitlab/-/commit/2db21e65606854ad520d2cdf5b34f5ad52bc232e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188450))
- [Adjust package history loading skeleton](https://gitlab.com/gitlab-org/gitlab/-/commit/7a6d8ee856aea84d617eca996824c69e4c1d2102) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188324))
- [Localize work item types in "Change type" modal](https://gitlab.com/gitlab-org/gitlab/-/commit/046f23421274dc4bd6d787ab6a69a60edfb83155) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186859))
- [Fix search SAML redirect for subgroup search](https://gitlab.com/gitlab-org/gitlab/-/commit/d16ad9c2be246e559d27049a8e4f7a51e8d6c092) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187559)) **GitLab Enterprise Edition**
- [Fix toggle text on dropdowns when initially selection is reset](https://gitlab.com/gitlab-org/gitlab/-/commit/3fcf2bab156c24318881896635d4e96e0717e5cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188384))
- [Use fullpath for MR tooltip](https://gitlab.com/gitlab-org/gitlab/-/commit/d3d6a5f1767b845cd39fa25bc89ed5c0bc2431d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188280))
- [Provide set_pipeline_variables policy from backend](https://gitlab.com/gitlab-org/gitlab/-/commit/84a3ea3ae20529bf1ac6fa18462dd4ac915611e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188321))
- [Make sure long inline code in GLFM doesn't overflow its parent](https://gitlab.com/gitlab-org/gitlab/-/commit/7c16784530580706c15dc14bd8f7935c7d6cd85d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188317))
- [Runners list: Delete action fix loading icon](https://gitlab.com/gitlab-org/gitlab/-/commit/e4e6f52e15f5e067fa45730ed643f664e0c06061) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188267))
- [Improve custom field select options validation](https://gitlab.com/gitlab-org/gitlab/-/commit/edbf1d123160fdf29c403b1fa3cbb81cda4ca1f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188278)) **GitLab Enterprise Edition**
- [Update approval_policy_rule_id to loose foreign key](https://gitlab.com/gitlab-org/gitlab/-/commit/2bbca02afb4226109f2cea6819dbf59543b207f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187881)) **GitLab Enterprise Edition**
- [Fix Epic note events in contribution calendar](https://gitlab.com/gitlab-org/gitlab/-/commit/dd3ea5b47163116afecf4a267a3e12d131ea7786) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188139)) **GitLab Enterprise Edition**
- [Fix time discrepancy in open MRs for blob](https://gitlab.com/gitlab-org/gitlab/-/commit/0b5154aa0e1e79b5453fc66ea1e5251a2d4f38d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188241))
- [Fix MWPS notification label and improve event handling](https://gitlab.com/gitlab-org/gitlab/-/commit/28b6bb377edad2d2527c5755d5c7e574ef6fb917) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187572))
- [Protected container repositories Crud migrations](https://gitlab.com/gitlab-org/gitlab/-/commit/41f53690630fc412ff79fbaf40ed86d3809e9810) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188235))
- [Fix alignment of items in vulnerability report on mobile devices](https://gitlab.com/gitlab-org/gitlab/-/commit/81abd8f2435d0c466f1f8088da71050ed22073f8) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188013)) **GitLab Enterprise Edition**
- [Show only scoped Vulnerability Management Policies in policies list](https://gitlab.com/gitlab-org/gitlab/-/commit/b4f600e864ecad59718c8e11947cd59fc46267c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188391)) **GitLab Enterprise Edition**
- [Fix policy index handling for deleted security policies](https://gitlab.com/gitlab-org/gitlab/-/commit/eb4a3c830844775f04a9bba04b77c8aece5b5c85) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187861)) **GitLab Enterprise Edition**
- [Prevent title overflow](https://gitlab.com/gitlab-org/gitlab/-/commit/4d8d7ecec2f557cb6fb2bb4f8364c045543e7043) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188172))
- [Remove potential duplicate settings](https://gitlab.com/gitlab-org/gitlab/-/commit/60e820b9cee0be95b9fb569236626dabf80a019e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187086))
- [Show PMD results in inline code quality diff](https://gitlab.com/gitlab-org/gitlab/-/commit/04056a2003a89d50aa174f2868b4557113f7976b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187759))
- [Fix new issue template work item logic](https://gitlab.com/gitlab-org/gitlab/-/commit/a0d95efcb57724d5e7dfcc20a82cd27c6bb29165) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188165))
- [Display loading icon on the correct button](https://gitlab.com/gitlab-org/gitlab/-/commit/31164126de0941bbd848388f473afdc6d5c50492) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187813)) **GitLab Enterprise Edition**
- [Fix alignment of pending note footers](https://gitlab.com/gitlab-org/gitlab/-/commit/bbe7efe0407fc65d3563e4ee67887886c5c71991) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188149))
- [Fix string conversion for CI Inputs](https://gitlab.com/gitlab-org/gitlab/-/commit/53a620b2b2b0e3f6355f5ef3383fd9db79c15f68) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188093))
- [Pipeline graph: Failed grouped jobs spacing fix](https://gitlab.com/gitlab-org/gitlab/-/commit/ca396408d2bc6aef4b09b68e4c9b38584700b7d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188141))
- [Always log CloudFlare leaked cred reports on signin](https://gitlab.com/gitlab-org/gitlab/-/commit/e2f97eeab0f663ecab06444a0df5608b48f3b1ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187644)) **GitLab Enterprise Edition**
- [Top bar search: Fix alignment on right](https://gitlab.com/gitlab-org/gitlab/-/commit/ccb12a0721bb1ce7f8d66e37ac7d720432202c3e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188126))
- [Use fuzzy search on work item labels dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/835e8f7ff29acceb99b457ba7da843aa231741ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187958))
- [Ensure board card "Card options" menu toggle button has accessible text](https://gitlab.com/gitlab-org/gitlab/-/commit/f2a3190ad9a64a277cc25b23de7dc1a474a9e22e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187770))
- [Allow long downstream pipeline names to break](https://gitlab.com/gitlab-org/gitlab/-/commit/322198275daeb92aca65635f12ba756b890941a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187924))
- [Fix execute_count method on elasticsearch](https://gitlab.com/gitlab-org/gitlab/-/commit/b09ea5ba310416bc219ab7ec2918a55750187ac1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187674)) **GitLab Enterprise Edition**
- [Fix spacing of note header timestamp for notes with system content](https://gitlab.com/gitlab-org/gitlab/-/commit/9d52f0a4cb52b3dbd329d78a59fbddac29a5c358) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187608))
- [Truncate long test suite names](https://gitlab.com/gitlab-org/gitlab/-/commit/9540323800846bfa59d2de6209c96c41399e63fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187734))
- [Fix positioning of GLQL actions dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/5fbe89bf99d5cc2640cfe7ba5acb3fe1d7c36a8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187864))
- [Schedule pipeline: Validate cron timezone](https://gitlab.com/gitlab-org/gitlab/-/commit/c7bac13bb4de5d63e9f2f5872835f15c2b83b965) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187542))
- [Input copy toggle: Add border to input](https://gitlab.com/gitlab-org/gitlab/-/commit/7b2f1f4e1f3e15081a558794773db22e3b9b89f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187736))
- [Ensure end of notification email signature has unique content](https://gitlab.com/gitlab-org/gitlab/-/commit/1402cf2924f1a00d2231e9e38bbc853b27cf8649) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177913))
- [Fix service account email confirmation with domain verification](https://gitlab.com/gitlab-org/gitlab/-/commit/359862a7d153f6e781c0ee18aff16ee8cfead5ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186716)) **GitLab Enterprise Edition**

### Changed (231 changes)

- [Remove custom_software_license feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/757cd23b26f7fcf36c21007059632619a7957439) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188923)) **GitLab Enterprise Edition**
- [Add right sidebar for new learn gitlab](https://gitlab.com/gitlab-org/gitlab/-/commit/73704c32b436dc427a9498786c14998e9d46bd8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190257)) **GitLab Enterprise Edition**
- [Handle nil vulnerability_read for VulnerabilityType](https://gitlab.com/gitlab-org/gitlab/-/commit/654cfdc3c023d7136273c25d122728ec2acde122) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190851))
- [Add base policy attributes](https://gitlab.com/gitlab-org/gitlab/-/commit/f7bbc3770697505539627703812321a477dc23ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190758)) **GitLab Enterprise Edition**
- [User admin detail: Migrate page header to pageHeading](https://gitlab.com/gitlab-org/gitlab/-/commit/49ef6ea0800924b64ac81e3fc72d27904d70aa77) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190821))
- [Remove feature flag zoekt_multimatch_frontend](https://gitlab.com/gitlab-org/gitlab/-/commit/9026c9687cb0ffe208a8b3aff9975c13d3d59f97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190519)) **GitLab Enterprise Edition**
- [Add human/bot filtering options to admin interface](https://gitlab.com/gitlab-org/gitlab/-/commit/cba95694d0e63c2280bf945022e2e0247f65de80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189848))
- [Help menu: Fix contribute link](https://gitlab.com/gitlab-org/gitlab/-/commit/56930931bfeddb00ed804b5e33a2e3f436941e87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190849))
- [Adjust capitalization for service accounts UI](https://gitlab.com/gitlab-org/gitlab/-/commit/988fd3bed9ab48b022996669b4949e46000653f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190983))
- [Update PostgreSQL docs for version 16](https://gitlab.com/gitlab-org/gitlab/-/commit/5f705ff47abe85b4e277457d38fb1d4ea8906171) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190883))
- [Public avatar settings section migration](https://gitlab.com/gitlab-org/gitlab/-/commit/6c7a2781976ad6905d93d3830dc11c6e29312b75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190825))
- [Bump minimum required PostgreSQL version to 16](https://gitlab.com/gitlab-org/gitlab/-/commit/303c4f53a9193735fa63cd9e2a49864e0f4c6497) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190814))
- [Decrease bottom padding in content wrapper](https://gitlab.com/gitlab-org/gitlab/-/commit/15a087a0ed5e599d44fada12d21aea38c2a282ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190863))
- [Update container registry page and shared list item](https://gitlab.com/gitlab-org/gitlab/-/commit/ef3ec868871b25e8a7da040cdaaeb5e8eff1afa6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189541))
- [Improve access tokens options in admin settings](https://gitlab.com/gitlab-org/gitlab/-/commit/ee602d0659969b9047b684b95e915366c9f0f278) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190481))
- [Add style to new_gpg_key_email notification](https://gitlab.com/gitlab-org/gitlab/-/commit/3a9ca923e1d7ca9c72dfff020d5faf79d4f02f86) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190115))
- [Set FF allow_duo_base_access to true](https://gitlab.com/gitlab-org/gitlab/-/commit/ba8462670f0355dfe8398d44fc99127693c22484) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190267)) **GitLab Enterprise Edition**
- [Settings section: Make only heading sticky](https://gitlab.com/gitlab-org/gitlab/-/commit/e6a8c7b5a2be22a46d90868b8763ba1d3603e7b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190372))
- [Roles and permissions detail page: Remove tabs](https://gitlab.com/gitlab-org/gitlab/-/commit/78798e1c9d582677c7fcaf0fa0aa4100e91b4ebf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190205)) **GitLab Enterprise Edition**
- [Permanently enables dependency_proxy_read_write_scopes](https://gitlab.com/gitlab-org/gitlab/-/commit/764bec8d55b80132cd77ad895baf4803085344aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189014))
- [Inclusive due_date for %Started scope](https://gitlab.com/gitlab-org/gitlab/-/commit/84df2b3ddb39d7b04cb6fedbe3c645cc145c5a9e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190770))
- [make control name reflect what is ensured](https://gitlab.com/gitlab-org/gitlab/-/commit/f4a94a4b9c3492b8fe4e798ccc321c0031b4247b) by @erik.petzold1 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190348)) **GitLab Enterprise Edition**
- [Add registry upstream list item and form components](https://gitlab.com/gitlab-org/gitlab/-/commit/f6a30cc8425713ebb25210a15eec886bbbba646b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189692))
- [Add source filter to `newest_first` method in the Pipeline model](https://gitlab.com/gitlab-org/gitlab/-/commit/71b66d60ae9b98d7203be71aa26e40270c6602fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189704))
- [Update tooltip and docs description for Cycle time analytics](https://gitlab.com/gitlab-org/gitlab/-/commit/b1f04bc29ff985368dfa5664f9c6a83cc32a717f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190253))
- [Populate email field if email is present](https://gitlab.com/gitlab-org/gitlab/-/commit/65c973c6f241ecef975ccff47e4bf9997c46082d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190574)) **GitLab Enterprise Edition**
- [Only send modified inputs in pipeline new form](https://gitlab.com/gitlab-org/gitlab/-/commit/0019e91dfc86c1322c9ee7e270f3bba714094d9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189952))
- [Use user organization as fallback for missing organization](https://gitlab.com/gitlab-org/gitlab/-/commit/30989ac9c8e5c8cc4a1811c928709229a72b7065) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190360))
- [Consider namespace bans for Duo root_group_ids](https://gitlab.com/gitlab-org/gitlab/-/commit/2e27f97a05d25ab9a4801fcad827910662faa516) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190702)) **GitLab Enterprise Edition**
- [Bypass permission check to close MRs for archived projects](https://gitlab.com/gitlab-org/gitlab/-/commit/5da37700fc347662c07f9317785a6c8e4d7c0cfe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189438))
- [Add ES bookkeeping when calling update_all or delete_all on vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/bdb2b52745becf675afca7691e9ed753655a3bba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188856)) **GitLab Enterprise Edition**
- [Allow auto enable Duo Core feature setting via seat link sync](https://gitlab.com/gitlab-org/gitlab/-/commit/c96ced572dbe01eefc4814f72bd520b361cebece) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190496)) **GitLab Enterprise Edition**
- [Delete placeholder users when a top level group is deleted](https://gitlab.com/gitlab-org/gitlab/-/commit/c4de5583a26111a02947999c7d2f7f7b2c4122fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188764))
- [ActiveContext: Add consitent error handling for preprocessors](https://gitlab.com/gitlab-org/gitlab/-/commit/48af8dfadf535add828289436aaad4e7e1a288d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190224))
- [Improve UX on CTAs after creation of compliance framework](https://gitlab.com/gitlab-org/gitlab/-/commit/32132a8d25c782dd18743b9b90d50c15d66925ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189275)) **GitLab Enterprise Edition**
- [Refactor AI Setting mutation to return the object](https://gitlab.com/gitlab-org/gitlab/-/commit/7c5528fd86c140b003606e973cf9948bd8ac3790) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189810)) **GitLab Enterprise Edition**
- [Allow only active and non-bot user](https://gitlab.com/gitlab-org/gitlab/-/commit/f7662a649f5c79f7b14533c92466b2423e40db45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190665)) **GitLab Enterprise Edition**
- [Modernize Crud component](https://gitlab.com/gitlab-org/gitlab/-/commit/9d47ce8cc7cd676d0f3a420d6a82205b00798b43) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188572))
- [Disables editing blob for lfs](https://gitlab.com/gitlab-org/gitlab/-/commit/173841652bdd35acda378f22c5c3fb2df28f3923) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190276))
- [Revert user-facing docs for enabling admin bypass placeholder confirmation](https://gitlab.com/gitlab-org/gitlab/-/commit/bc353a34f20ebd5dc41aa22c7604934c557a1f28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190584))
- [Include push_ruleable concern in group_push_rule](https://gitlab.com/gitlab-org/gitlab/-/commit/1b219f4098f0e1b1be145907c67566095b687f8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190414)) **GitLab Enterprise Edition**
- [Extract shared logic from push_rules to a concern](https://gitlab.com/gitlab-org/gitlab/-/commit/289ebf33e730ea5e2bb64bf20f6a5f3cb50bf71b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188997)) **GitLab Enterprise Edition**
- [Update header app and blob overflow menu feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/ac5d5108a24de0c65c847ed3cb1def4880b15673) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190540))
- [Updates project runner details page](https://gitlab.com/gitlab-org/gitlab/-/commit/78e4cd90b2882b04ac47ae5e4857c20d3a4dc6fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189650))
- [Scope Duo Workflow action feature flag to user](https://gitlab.com/gitlab-org/gitlab/-/commit/a7cbd025c9ba366bed0f8795f2d01db53e35db1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190527)) **GitLab Enterprise Edition**
- [Enable better CI/CD analytics for project pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/0c3c3c521ae927bdef78f159a4fa9dfcddf45a0b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190316))
- [Track collapsed diffs from Gitaly to show safe limit warnings](https://gitlab.com/gitlab-org/gitlab/-/commit/c00fd442cf563a1502240b7873570815f9239359) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190442))
- [Enable `commits_from_gitaly` feature flag by default](https://gitlab.com/gitlab-org/gitlab/-/commit/11fb609de5265b6e819007bd283d31cacdc8285f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190477))
- [Update major version of GLAS image](https://gitlab.com/gitlab-org/gitlab/-/commit/2ed3a5740c4c2b2c46a3fe6f834cd74c1336abc5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189787))
- [Remove the extra space on no results](https://gitlab.com/gitlab-org/gitlab/-/commit/eeab5defdeca3709da06d2f4bada64c771a34f73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188793))
- [Update on call schedule to import only data design token color constants](https://gitlab.com/gitlab-org/gitlab/-/commit/72d6d1cb7752657ea475777b708dacbecffbacbf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190163))
- [Add explore GitLab Duo Core banner to MR](https://gitlab.com/gitlab-org/gitlab/-/commit/57eb9edb01476b58c35e610c82c98b41a99a348e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189684)) **GitLab Enterprise Edition**
- [Finalize backfill_secret_push_protection_enabled migration](https://gitlab.com/gitlab-org/gitlab/-/commit/f4b619cd4fc8b5dc2f1b4e7456e54ba46fc2673f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190349))
- [Remove the git_push_create_all_pipelines feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/2f1427ff97782395e7ec642adc1d300aa8471ac5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190248))
- [Make external status checks support group-level protected branches](https://gitlab.com/gitlab-org/gitlab/-/commit/379af69db2345d21217275d3c90e719b11ba361e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189498)) **GitLab Enterprise Edition**
- [Update project template list](https://gitlab.com/gitlab-org/gitlab/-/commit/73460985e8aa3f4560f286c320f7c6c2825207cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189964)) **GitLab Enterprise Edition**
- [Revalidate_gpg_fingerprins ff default_enabled set to true](https://gitlab.com/gitlab-org/gitlab/-/commit/16fb0aade6280a24664bf61422a766442033c6ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190370))
- [Updates enable duo banner to use api](https://gitlab.com/gitlab-org/gitlab/-/commit/dcffae178f02ca21488cd00f826af048bc166c48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190280)) **GitLab Enterprise Edition**
- [Add admin UI control for `scan_execution_policies_schedule_limit`](https://gitlab.com/gitlab-org/gitlab/-/commit/ec6e48db3febcf1e0b6b3fec99329f4c0ae804e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190352)) **GitLab Enterprise Edition**
- [Permanently enables packages_dependency_proxy_containers_scope_check](https://gitlab.com/gitlab-org/gitlab/-/commit/8d6e903236f4c786086b6661a8fa4ec2a7be95c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190324))
- [Role detail view: Migrate components](https://gitlab.com/gitlab-org/gitlab/-/commit/7bcd97f69645f8ec1fd4e8ffde3bb0d00a562af2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190040))
- [Increse max_tokens for review_merge_request](https://gitlab.com/gitlab-org/gitlab/-/commit/b25764e6fe969d4fd810c9e4996feeaa6f5a8736) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190308)) **GitLab Enterprise Edition**
- [Fixes tracking for modal primary event](https://gitlab.com/gitlab-org/gitlab/-/commit/fe6ccb97fe60789474d9072e6405fb5062ec43f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190259)) **GitLab Enterprise Edition**
- [Show message when Duo code review is unavailable](https://gitlab.com/gitlab-org/gitlab/-/commit/e5982fcb0a4728cbbf95f86f531247c32b11a8f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189905)) **GitLab Enterprise Edition**
- [ActiveContext: allow disabling ref fields](https://gitlab.com/gitlab-org/gitlab/-/commit/3a646a03c6dfed049cf6a092608289513e7bbd3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190222))
- [Container registry forms: Set autofocus to add forms](https://gitlab.com/gitlab-org/gitlab/-/commit/82e3469f61c51295d0b9cde03714af7caa1de5f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190199))
- [Create member role: Migrate components used to shared components](https://gitlab.com/gitlab-org/gitlab/-/commit/ae43617f2c8fd73340142492efabd056d49c85ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190036))
- [Drop exact_matches_first_project_transfer feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/192e287227e929ea5da9f9975fcebb48be62cda8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190305))
- [Disable batch update button for disabled features](https://gitlab.com/gitlab-org/gitlab/-/commit/7694814bf89da35e4f7da77458a8a102bcdc6e0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188949)) **GitLab Enterprise Edition**
- [Feature flag default_enabled set to true](https://gitlab.com/gitlab-org/gitlab/-/commit/d90c937034add4de3c27f5020766f5e0dd93d94f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190283))
- [Update example response for Geo site status API](https://gitlab.com/gitlab-org/gitlab/-/commit/e09674c1538dfe1e9419130ab8f6cd7d25888a4e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190256))
- [Package registry: Improve loader to reflect more real world data](https://gitlab.com/gitlab-org/gitlab/-/commit/405a51a4450427024076739f4756652e3286b0d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189796))
- [Document SaaS-only GraphQL schema](https://gitlab.com/gitlab-org/gitlab/-/commit/0195cb3d13fd79f0f0937608d04fbe34a15a67e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189556))
- [Remove company size from company form](https://gitlab.com/gitlab-org/gitlab/-/commit/40ed2704fe92e55589a3c3a36b54bd69441e6b64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189680)) **GitLab Enterprise Edition**
- [Add boolean type custom cell to inputs table](https://gitlab.com/gitlab-org/gitlab/-/commit/dbcb2215ec1ad11ac349be2c183664a4a9126253) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189972))
- [Shorten import options list on group registration page](https://gitlab.com/gitlab-org/gitlab/-/commit/7864c83e60d40a3a56ecf52bfbee313812962425) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189526)) **GitLab Enterprise Edition**
- [Hide Duo availability for Duo Core](https://gitlab.com/gitlab-org/gitlab/-/commit/a6ebd04084397b64ec966717354f6f3f6a713cf7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189778)) **GitLab Enterprise Edition**
- [Update dependency auto-build-image to v4.11.1](https://gitlab.com/gitlab-org/gitlab/-/commit/904b60eeb7c6035aa66546f38e3ce4febc94a3a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190073))
- [Enable open MRs for a file feature by default](https://gitlab.com/gitlab-org/gitlab/-/commit/03df2e20d46a710257c714e40f0dfc770f4c0948) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190051))
- [Package project settings: Use section instead of block component](https://gitlab.com/gitlab-org/gitlab/-/commit/c8e540f1a9f6c22653edb7ff1b481b5c0eb968a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188225))
- [Add ExclusiveLeaseGuard to bulk update](https://gitlab.com/gitlab-org/gitlab/-/commit/76fc7bcd06ad2fe550ff315fc3816f5e24a2b5d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188271)) **GitLab Enterprise Edition**
- [Stop persisting pipeline config](https://gitlab.com/gitlab-org/gitlab/-/commit/bdc421dc22a1a4d46f099ff834ab0a9fd748c6fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189479))
- [Update registration company form](https://gitlab.com/gitlab-org/gitlab/-/commit/201af6dbbc13e201f11652f7091a3109579750a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188164)) **GitLab Enterprise Edition**
- [Make delayed deletion available to all pricing tiers](https://gitlab.com/gitlab-org/gitlab/-/commit/f553dc8a042d1d170b9fbe6e60cb69f3dff4ff71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189976))
- [Reset variables modal to initial state](https://gitlab.com/gitlab-org/gitlab/-/commit/3a3c1697a85552b690a5001990ffc13c67260ee6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189372)) **GitLab Enterprise Edition**
- [Add 'external_control_name' to compliance requirements controls](https://gitlab.com/gitlab-org/gitlab/-/commit/a6858434651e1ddd46762316cd27929a7ac09127) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189851)) **GitLab Enterprise Edition**
- [Add enable duo banner component](https://gitlab.com/gitlab-org/gitlab/-/commit/d96b60158d4f7f49d9864e921c0b45fa8e5e3fdb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188312)) **GitLab Enterprise Edition**
- [Move work item confidentiality loading spinner to actions dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/d90b6011e9b7ecd4dfe93af8d1b49b0eabd8f558) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188920))
- [Separate project and group dependency types in GraphQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/2ba24d078a44e343b3cf87383eefdc806b5172af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188295)) **GitLab Enterprise Edition**
- [Enable using glab for CI release](https://gitlab.com/gitlab-org/gitlab/-/commit/440f6c6a41c509671648890128d60712d55507b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189138))
- [Add API endpoint to update Maven virtual registry upstream position](https://gitlab.com/gitlab-org/gitlab/-/commit/389595ab5456cfd71de1f82c7e8411e07c49b546) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186890))
- [Add ApplicationSetting for the `git_push_create_all_pipelines` ff](https://gitlab.com/gitlab-org/gitlab/-/commit/eb783b1891d46a1ecb9235ab2f26f0bdac733137) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186134))
- [Update milestone scopes](https://gitlab.com/gitlab-org/gitlab/-/commit/7286879b0833f18f5f66909fb743a95b159ea8ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187632))
- [Remove next button from identity verification](https://gitlab.com/gitlab-org/gitlab/-/commit/1b9f301cd065cfaf61c82ef12ef32872e0405e0d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189753)) **GitLab Enterprise Edition**
- [Add archived project to compliance framework filter](https://gitlab.com/gitlab-org/gitlab/-/commit/836c7ca1819e553a2bbf671da19428781efbe302) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178665)) **GitLab Enterprise Edition**
- [Move a variable list to a parent component](https://gitlab.com/gitlab-org/gitlab/-/commit/4b7924ee8b4ecd65073e4740b2fbe767c6168209) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189366)) **GitLab Enterprise Edition**
- [Increased default bcrypt stretches, enabled transparent upgrade](https://gitlab.com/gitlab-org/gitlab/-/commit/905ff18bd2a1e6028dfeadec7ebfbf63687cf7a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177154))
- [Updated Validity Check Badge text to reflect possible design titles](https://gitlab.com/gitlab-org/gitlab/-/commit/e93a58fa579dbd8c2edd29d24b15a550e2a79dd5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189586))
- [Change column default from true to false](https://gitlab.com/gitlab-org/gitlab/-/commit/07fe5b17ed5674495e7a4514f7713477196d976c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188203)) **GitLab Enterprise Edition**
- [Revert MR 189075](https://gitlab.com/gitlab-org/gitlab/-/commit/0bfbf99025e749eb1c6cb202a74cee5262a4f540) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189821)) **GitLab Enterprise Edition**
- [Update package page headings and install instructions](https://gitlab.com/gitlab-org/gitlab/-/commit/54f91a85854c5b649b18bd9567110dbb7245f807) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188338))
- [Pipeline minigraph: Improve search input styles](https://gitlab.com/gitlab-org/gitlab/-/commit/b00bac2af3b6f4fda18c8d8883d8a343e5817880) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189782))
- [Work item: Reduce spacing between title and meta information](https://gitlab.com/gitlab-org/gitlab/-/commit/e80cff3702f6d6b8d13dd1a7710f1e8d54577571) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189632))
- [Re-prepare async index on merge_request_commits_metadata_id](https://gitlab.com/gitlab-org/gitlab/-/commit/5bec662aff0cc1fdaa794d5ecb58eacebe1b26bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189775))
- [Project sidebar badges alignment improvement](https://gitlab.com/gitlab-org/gitlab/-/commit/5eac71f4f96ff2c3ecc2cf68ee2cfac1c751c818) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189769))
- [Rename Security Orchestration Policy to Scheduled Scan Execution Policy](https://gitlab.com/gitlab-org/gitlab/-/commit/ee27f8d36fa8453671b3fcadbcf9f0ed970f64ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189761)) **GitLab Enterprise Edition**
- [Updated move and clone operations to work on work item framework](https://gitlab.com/gitlab-org/gitlab/-/commit/09f1ef29904500a43de00cc6cb55c140375d14b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187589))
- [Model registry: Performance tab changes](https://gitlab.com/gitlab-org/gitlab/-/commit/13a23898a49f54232afef0dafb93a5ad3bc29ca7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189752))
- [Model registry version: Refactor header](https://gitlab.com/gitlab-org/gitlab/-/commit/a0ba8ca17bf4d5683c3a7d2ff943d7858bfba306) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189745))
- [Update variable args in workspaceCreate mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/3954f07818d7c47ac4c2a9fc0fa5f488036bce6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188937)) **GitLab Enterprise Edition**
- [Document tuning of lower Geo concurrency default settings](https://gitlab.com/gitlab-org/gitlab/-/commit/f5180ea6796369b6875ae85f8329c43a42ad60de) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184510))
- [Add Auditor as a filter option to the Admin users page](https://gitlab.com/gitlab-org/gitlab/-/commit/50126ffc6b0e7c108e3ae8e15d25a69b907bf0d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187612)) **GitLab Enterprise Edition**
- [Separate project and group dependency types in GraphQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/b4e191a88744b61d4334ba41e1437c12004eb46c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188295)) **GitLab Enterprise Edition**
- [Disable `confetti_post_signup` cookie](https://gitlab.com/gitlab-org/gitlab/-/commit/cf28bd11d333ae86cc1ef10d6963b391d7e43c0b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189340)) **GitLab Enterprise Edition**
- [Flexible work item sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/fe2cf3461eaa4ff7549f9d24e4901ac0e7ef4905) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186598))
- [Turn auto_devops_banner_disabled on by default to hide the banner](https://gitlab.com/gitlab-org/gitlab/-/commit/3cacbc6449d5fa08022881bfebe83e9c707c19f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189630))
- [Improve interpolation error messaging](https://gitlab.com/gitlab-org/gitlab/-/commit/13d0edf3e3ab1affe113fc6b516f15c165fde371) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189460))
- [Make PDM no-op since it was incorrect](https://gitlab.com/gitlab-org/gitlab/-/commit/8ab2c412638b49dfe80f5c31e968a7e73e4befc1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189591))
- [Runner detail page: Show runners in Crud](https://gitlab.com/gitlab-org/gitlab/-/commit/655a5dbc57bec8ba6170256041a371acea38c88c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188089))
- [Change to async_delete for ci_running_builds.runner_id](https://gitlab.com/gitlab-org/gitlab/-/commit/fc84bfdf30df056f4c1606ddb0eb61961361d38e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189572))
- [Lower Geo replication concurrency default settings](https://gitlab.com/gitlab-org/gitlab/-/commit/aea17157fc02f63ab0be58930285d569217a570a) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184473))
- [Add integration tests for exclude licenses](https://gitlab.com/gitlab-org/gitlab/-/commit/fbd4edb391f4343a561969ecaaf29d222aee3a61) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189477)) **GitLab Enterprise Edition**
- [Add "Open in Workspace" in MR page](https://gitlab.com/gitlab-org/gitlab/-/commit/e140374d9b18355d569de5f5e8cdeeaf10626c58) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187320)) **GitLab Enterprise Edition**
- [Update group and project label in search modal](https://gitlab.com/gitlab-org/gitlab/-/commit/5bf8040fbf230a5d2d8255a266829df55737e631) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187626))
- [Fix the styling of import buttons](https://gitlab.com/gitlab-org/gitlab/-/commit/8c32b48e5ab0028f1426b8613f41614709dbd3f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188822)) **GitLab Enterprise Edition**
- [Use package id in package registry breadcrumbs](https://gitlab.com/gitlab-org/gitlab/-/commit/ed5f2d6666d910926000a9b3d39cf080a8842f57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188628))
- [Update dependency auto-deploy-image to v2.128.0](https://gitlab.com/gitlab-org/gitlab/-/commit/05056cac6cbc7c5985a8ca0d7fda934ed379f979) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189473))
- [Update dependency auto-build-image to v4.11.0](https://gitlab.com/gitlab-org/gitlab/-/commit/a99a02b17977c01fd3485e167c51bcf90ca9aa13) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189472))
- [Model registry detail page improvements](https://gitlab.com/gitlab-org/gitlab/-/commit/c105f1b0c58c6dfb46cd503dbb753e7120b967fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188422))
- [Update error messages for pipeline inputs](https://gitlab.com/gitlab-org/gitlab/-/commit/733094c64f5d24266cab5bf0e28f4852ece3a676) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188784))
- [Add confirmation step before a broadcast messages gets saved](https://gitlab.com/gitlab-org/gitlab/-/commit/6b4ed39a9cba49ac0a50c8e2882c5316ada30232) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189446))
- [Move `workItemStatus` fragment to main query](https://gitlab.com/gitlab-org/gitlab/-/commit/6477e8b23b178f0bb7e071ac127bfa321f36e263) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188212)) **GitLab Enterprise Edition**
- [Set cache: [] in Secret Detection latest template](https://gitlab.com/gitlab-org/gitlab/-/commit/776e726aaec3f7f16c7f612399624e29fd415ad0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186637))
- [Hide child items and linked items widgets when empty and can't edit](https://gitlab.com/gitlab-org/gitlab/-/commit/b900a6ceb9f759ea8cbbf75a96d203496825fa4a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189347))
- [Add a warning modal when disconnecting SAML groups](https://gitlab.com/gitlab-org/gitlab/-/commit/443b211f36dc8ff6cd5c8e4a6dc304066acf1efc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188996))
- [Enable `disable_widget_responses` by default](https://gitlab.com/gitlab-org/gitlab/-/commit/32ce61a8c9be61211451eddc9797ce9149ae486c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189189))
- [Fix PAT last_used_ips for /self API](https://gitlab.com/gitlab-org/gitlab/-/commit/8be64522586e4d5bf453bfaff4783369056c5ce2) by @thomasgl-orange ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187671))
- [Update ffi and mixlib-log gems](https://gitlab.com/gitlab-org/gitlab/-/commit/b0e2cfc8ea1e47495af059d180f99bcc5f6ee4a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189229))
- [Add milestone_title keyword field to work_items index](https://gitlab.com/gitlab-org/gitlab/-/commit/0b5cc20d6a2967b36684dc0843a29cb4633f991d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187717))
- [Expose vulnerabilities fields to Jira integration API](https://gitlab.com/gitlab-org/gitlab/-/commit/54e41f6ef00369d4cb27fd592c056c0ea55beb64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189200)) **GitLab Enterprise Edition**
- [Nullify embedding0 field](https://gitlab.com/gitlab-org/gitlab/-/commit/0cdb926077271296c277ee164b65d747594b2af4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188044)) **GitLab Enterprise Edition**
- [Cleanup plan_limits_repository_size Feature Flag](https://gitlab.com/gitlab-org/gitlab/-/commit/06d735f820763ee5076449a0561ecbb71f0575d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188251))
- [Switch workitem index to use new embedding field and model](https://gitlab.com/gitlab-org/gitlab/-/commit/bc242330a0480da3abfa0ec79c9bd7900b1da7ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187518)) **GitLab Enterprise Edition**
- [Update Duo Nano to Duo Core](https://gitlab.com/gitlab-org/gitlab/-/commit/fb95c24e353724d375fdac67566cadf388dd0551) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189033)) **GitLab Enterprise Edition**
- [Always enable sorting for storage usage quotas](https://gitlab.com/gitlab-org/gitlab/-/commit/c400c43bf076145ab54c26d0ab4ff2af82a016b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189158))
- [Add namespace and project metadata to application context for GLQL](https://gitlab.com/gitlab-org/gitlab/-/commit/810d3120df62314748e73ed2e5cdcaa70b212421) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186951))
- [Add merge_request_commits_metadata_id column to MRDC](https://gitlab.com/gitlab-org/gitlab/-/commit/653cb433e35d81584cc8a992e1aa49e3169f6db7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188985))
- [Log error message when managed resources fail to delete](https://gitlab.com/gitlab-org/gitlab/-/commit/fc600cfd8efdd4a6f8b67b6fd219772f5d12f61b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189103))
- [Add a new ResourceGroup process_mode: "newest_ready_first"](https://gitlab.com/gitlab-org/gitlab/-/commit/8829415364b69d20ab6178bb9b1f368e150cc2f2) by @BageDevimo ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188049))
- [Add infinite scroll to GitHub organizations box](https://gitlab.com/gitlab-org/gitlab/-/commit/aa5a167007e10d6427b3b563e70300a02a769447) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188177))
- [Add actor for static_licenses feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b931f8c3663d6a3da6b0fe53751623e528188be9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187755)) **GitLab Enterprise Edition**
- [Add embedding1 field to workitems index](https://gitlab.com/gitlab-org/gitlab/-/commit/9035c425776b4397e6ccb4bf0242fc77f4554e99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187493)) **GitLab Enterprise Edition**
- [Update environments to use token for websocket](https://gitlab.com/gitlab-org/gitlab/-/commit/0d89e83249730034c8eff554a34a9e179eea8868) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187325))
- [Updated EnforceDatabaseHealthSignalDeferral ignored list](https://gitlab.com/gitlab-org/gitlab/-/commit/2d6f4439cf25e4f03b69b88f3e530c3aea1a9044) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189019))
- [Improve help text for auto user deactivation](https://gitlab.com/gitlab-org/gitlab/-/commit/0823c4b56497423c2530d0991fb1fa579613fb42) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189017))
- [Bump CS and DS analyzer major version](https://gitlab.com/gitlab-org/gitlab/-/commit/e2bccff3b908a16c9c92735d46277956fc935a8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188890))
- [Bump secrets analyzer major version](https://gitlab.com/gitlab-org/gitlab/-/commit/5f19592fbc44d5f06c4705399caea3484018e37f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188938))
- [Bump SD analyzer version to 7](https://gitlab.com/gitlab-org/gitlab/-/commit/88da03792ff3e862be065063c7fafb8574fe7fad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188849))
- [Drop sequences for some ID columns in MRCM table](https://gitlab.com/gitlab-org/gitlab/-/commit/e14e7a8ee505b877af835e44ec26a405b0ca16cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188978))
- [Track all workers concurrency jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/3df4f6a885bf25a1716e8880b2f29c15ef7604df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188415))
- [Runner detail: Delete action](https://gitlab.com/gitlab-org/gitlab/-/commit/193e2e19e8b47f850c3427110350eb529d150f87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187838))
- [Add versioning support to routable token](https://gitlab.com/gitlab-org/gitlab/-/commit/8343330faa9b1d2143da7e402dd189ad69305917) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188441))
- [Package detail page: Move delete button into ellipsis menu](https://gitlab.com/gitlab-org/gitlab/-/commit/65b5b48d8b3cca6f8c50afed3cf513a1c4802e0b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188383))
- [Adds Rubocop rule to enforce worker deferral based on DB health](https://gitlab.com/gitlab-org/gitlab/-/commit/eb4188e3391f4ca6779fbdef55b7c663dcd427c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187967))
- [Hide test button - GitLab for Jira app integration](https://gitlab.com/gitlab-org/gitlab/-/commit/92a53169844982eebd9d71f3dd261b10fbcb24af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188934))
- [Move social accounts into their own section](https://gitlab.com/gitlab-org/gitlab/-/commit/8108b14b006fcc89df21b139198918371d5bc02f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188918))
- [Rename Duo Nano to Duo Core](https://gitlab.com/gitlab-org/gitlab/-/commit/c421cfd65fba2a6f61a646142fdeaa6a86881967) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188898)) **GitLab Enterprise Edition**
- [Skips processing dormant members when deactivated](https://gitlab.com/gitlab-org/gitlab/-/commit/77ab6ec4e2367f043d818e3982e0b22ca04fac58) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188906)) **GitLab Enterprise Edition**
- [Update openapi docs](https://gitlab.com/gitlab-org/gitlab/-/commit/93288653ea518900b0b9d61752881cdf74078ce2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188901))
- [Validate seat assignable add-on](https://gitlab.com/gitlab-org/gitlab/-/commit/b699bbc847c1e8ca03bf2caabaed69059321ba48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188457)) **GitLab Enterprise Edition**
- [Limit the number of concurrent exports in progress](https://gitlab.com/gitlab-org/gitlab/-/commit/b029619550b320b3e36ebe5760c2982e9e7c8777) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187017)) **GitLab Enterprise Edition**
- [Add security_policy_id to compliance_framework_security_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/092df0302039f127eac77063fbf3492803bf92e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186097)) **GitLab Enterprise Edition**
- [Dry'd check for increase in billable count](https://gitlab.com/gitlab-org/gitlab/-/commit/2cf55d6bf92354972e52245ffae5b5bb1c564383) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188406)) **GitLab Enterprise Edition**
- [Change DuoNano to DuoCore](https://gitlab.com/gitlab-org/gitlab/-/commit/7c735db83ad663fde162825eaccfba33c95d8cab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188854)) **GitLab Enterprise Edition**
- [Align API Discovery CI templates with other AST features](https://gitlab.com/gitlab-org/gitlab/-/commit/6b4d207423357a91684767b87c4d24b4f88eaad8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188334))
- [Upgrade Hugo project template](https://gitlab.com/gitlab-org/gitlab/-/commit/e64f7f5cd3e4fc6ebc98a9014a1b8bf054b9293f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188878))
- [Adjust code to work with static licenses catalogue](https://gitlab.com/gitlab-org/gitlab/-/commit/06e1114b7ff140b5331d67b617eddff5d387bd21) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180013)) **GitLab Enterprise Edition**
- [Update `r` key shortcut behaviour on Work Items](https://gitlab.com/gitlab-org/gitlab/-/commit/dc66fa7302f975d1cce494180c6467dac103ec69) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188620))
- [Remove fix_gmail_footer_truncation feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f79c61f1b70f1d354bd4faba216bdaab078fb832) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188819))
- [Remove confidentiality relocation sidebar stub](https://gitlab.com/gitlab-org/gitlab/-/commit/20342f5e6e0d0ce9c7556436f6ecaec87e8dc916) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188292))
- [Rename search admin UI checkboxes and update relevant documentation](https://gitlab.com/gitlab-org/gitlab/-/commit/51d6e13eac86fe62ed58708fa0476265a17f32fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188763))
- [Cleanup FF enable_secrets_provider_check](https://gitlab.com/gitlab-org/gitlab/-/commit/fc51977b4cbe0f0fa0067b9513eaba9be892cc6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188767)) **GitLab Enterprise Edition**
- [Remove beta status from block seat overages for .com](https://gitlab.com/gitlab-org/gitlab/-/commit/3b3d9de12bc9c3255d63291ba6b635fa28c8867f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185946)) **GitLab Enterprise Edition**
- [Remove beta status for BSO self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/df6340a0e60b76b0f8570f23c752b9130cad82e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185949)) **GitLab Enterprise Edition**
- [Introduce subscriptions refactor](https://gitlab.com/gitlab-org/gitlab/-/commit/2747252b8d17d1377b7a4d92d264b76e8a85f3fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/142336))
- [Change user authorization to use terms query for projects](https://gitlab.com/gitlab-org/gitlab/-/commit/c6ae8d6e34d5457ba372ec5c2f89b875f2e11f6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187862)) **GitLab Enterprise Edition**
- [Default `scan_execution_policies_action_limit` setting to 0](https://gitlab.com/gitlab-org/gitlab/-/commit/eda9d36fbe015ee14f9898b05d995324dc968747) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187866)) **GitLab Enterprise Edition**
- [Crud: Change loading state to use skeleton loader](https://gitlab.com/gitlab-org/gitlab/-/commit/620f2bd65c66a7531c055e912b726b3358e68d20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188246))
- [Use read replica for GLQL queries if available](https://gitlab.com/gitlab-org/gitlab/-/commit/4f334e0dc5021c55749f6be7bf0c9085bb6a60c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188245))
- [Make license version optional](https://gitlab.com/gitlab-org/gitlab/-/commit/5ad0b79f9320240190977eafe08067b87588699f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188194)) **GitLab Enterprise Edition**
- [Move branch rules alert into settings block](https://gitlab.com/gitlab-org/gitlab/-/commit/220b066367ab4374bc7dbbb3aeb5e0a440df5104) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188446))
- [Default backdated timelogs to midday (12:00)](https://gitlab.com/gitlab-org/gitlab/-/commit/28e6f1e5d439b1b38a9b0efe7cd388b083ed6df8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188269))
- [Update alignment of package registry page](https://gitlab.com/gitlab-org/gitlab/-/commit/cd05e6d7b0cde619d26395b9b719f8b882598aec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188159))
- [Allow specifying the organization for an Internal User](https://gitlab.com/gitlab-org/gitlab/-/commit/7fb8a73a32ab58113b33b0d24f60ed48e6f8ba89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186690)) **GitLab Enterprise Edition**
- [Update reachability to only be present for](https://gitlab.com/gitlab-org/gitlab/-/commit/aafb7d0ce03ef4c86c842c374d44c446053f9868) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188437)) **GitLab Enterprise Edition**
- [Model registry: Improve upload artifacts of assets](https://gitlab.com/gitlab-org/gitlab/-/commit/017836b75e7d9dd132b4fbd9ab73566a7e26fca2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188417))
- [Add MR pipelines support to Container Scanning CI template](https://gitlab.com/gitlab-org/gitlab/-/commit/b1111dd9571def61d409268eb71aeb36812860b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188416))
- [Added registry setup instruction for group level endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/18658d1039457b2485f706fc3aab4f8bb0219805) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187556))
- [Add UpdateTroubleshootJobEventsPrimaryKey migration](https://gitlab.com/gitlab-org/gitlab/-/commit/f98358dc9548a5f79adcdb11c171e9a7a8527a88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188341))
- [Finalize semver_patch conversion to bigint in terraform module metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/dd80a0fc4421a2881049e173b3bcd50620c14a47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188297))
- [Only refresh seat assignable add-on](https://gitlab.com/gitlab-org/gitlab/-/commit/465c1a8e21cf5902daa72c3d528a19a43a5dd045) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188114)) **GitLab Enterprise Edition**
- [Package group settings: Cleanup settings](https://gitlab.com/gitlab-org/gitlab/-/commit/4e2bd3462d9f06e03bc6a94b0ca36fe02d8a46ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188221))
- [Package detail page migrations](https://gitlab.com/gitlab-org/gitlab/-/commit/0d1e25e9e1a560e4d60f23f25240f297bd0d82cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188277))
- [Set some columns in MRDC to be nullable](https://gitlab.com/gitlab-org/gitlab/-/commit/475a5cc031de9ee7f045748dd3fcec6f1a4acf5b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188358))
- [Update the permalinkPath description](https://gitlab.com/gitlab-org/gitlab/-/commit/32ab3da21ade848361171d4f31f5b968c864fd2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188111))
- [Improve styling of user calendar activities](https://gitlab.com/gitlab-org/gitlab/-/commit/c9a92c0e38fb673f048a7acb9eba43cd4028e3ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188342))
- [Add MR pipelines support to Container Scanning CI template](https://gitlab.com/gitlab-org/gitlab/-/commit/5e12b5d97d5764a8dd96446f17e01c100e0f3914) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188283))
- [Return a success status when stopping an already stopped environment](https://gitlab.com/gitlab-org/gitlab/-/commit/020d342bdf1924fa928fbf6990963897fa168741) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187790))
- [Update DrawIO media bubble edit button copy](https://gitlab.com/gitlab-org/gitlab/-/commit/5e989241a53109ef1e9a969ae0e4c68636a2a08a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188311))
- [Migrate `.setting-message` to Pajamas alert component](https://gitlab.com/gitlab-org/gitlab/-/commit/9f225a36ac4a7d5d266341b5c6fd3dc8ae28cc33) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187870))
- [Updated supported CWE list for Vulnerability Resolution](https://gitlab.com/gitlab-org/gitlab/-/commit/7fa2546309ea021231bf629f99c48a26031137f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188270)) **GitLab Enterprise Edition**
- [Reorder routable token's base-64-payload](https://gitlab.com/gitlab-org/gitlab/-/commit/07ee3242ea2ab7ab07f03794a5cb48e24027d570) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188255))
- [Container registry cleanup policies: Migrate to Crud](https://gitlab.com/gitlab-org/gitlab/-/commit/0ef220b2ca95cc40199a6a24b8a44a1a89c3627e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188239))
- [Allow vertex embeddings model to be passed in](https://gitlab.com/gitlab-org/gitlab/-/commit/848ba8ada9a23513d40bbf27b6fda89d239c80ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187481)) **GitLab Enterprise Edition**
- [Update project runners update page](https://gitlab.com/gitlab-org/gitlab/-/commit/d30957e6606f0a17485711b7f31d21b856b8088f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187360))
- [Improve policy bot message for pipeline failures](https://gitlab.com/gitlab-org/gitlab/-/commit/de8ecdc863d400f40f142fed65fe72701ff7ea93) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187841)) **GitLab Enterprise Edition**
- [Support dynamic predefined question prompts on Duo Chat](https://gitlab.com/gitlab-org/gitlab/-/commit/a6bcc6f672e3710057170e48c16f18c8b9c57e4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187605)) **GitLab Enterprise Edition**
- [Allow shift key in sidebar shortcut](https://gitlab.com/gitlab-org/gitlab/-/commit/fd20c9c7458eec2ccc0ccebb910f9f38655cfb75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187613))
- [Remove resolve_vulnerability_with_ai flag](https://gitlab.com/gitlab-org/gitlab/-/commit/7ad2ca0f7fa936dc886811820bb4bc0fefa08847) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185452)) **GitLab Enterprise Edition**
- [Remove incorrect docs link shown for push rule file size limit](https://gitlab.com/gitlab-org/gitlab/-/commit/528d1fb39fb3202851612107fa0cb0533414b6eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187085)) **GitLab Enterprise Edition**
- [Remove SafelyChangeColumnDefault concern from topics](https://gitlab.com/gitlab-org/gitlab/-/commit/ec8b48ce292cb412a8675fbc189413af6026a5e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188109))
- [Organization switcher: Decrease spacing](https://gitlab.com/gitlab-org/gitlab/-/commit/d4f0b4c6bed8a938d4e7daacd481e567d6e58bd4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188097))
- [Only show convert_to_ticket quick action when Service Desk enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/947c63bda11d33f964b22094fc274ce3217b8cc6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187684))
- [Update Q settings link to Amazon Q console to create profile](https://gitlab.com/gitlab-org/gitlab/-/commit/d4b45501d5c7e8f3d8bf0f8e223abcc15270845d) by @katwal ([merge request](https://gitlab.com/foo/bar/-/merge_requests/187968)) **GitLab Enterprise Edition**
- [Fix alert icon size](https://gitlab.com/gitlab-org/gitlab/-/commit/e611464504f926c65ddb5540c0c4cb49733a3a63) by @yonghyun.jin13 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185525))
- [Wrap multiline selection to collapsible section](https://gitlab.com/gitlab-org/gitlab/-/commit/6dd7fbe6884183e495987021dbf6697ed6541b17) by @Bubbis ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187756))
- [Enabled exclude_license_packages feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/68134330c634be993f56c1e2b3ce4481c4b7bd58) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187896)) **GitLab Enterprise Edition**
- [Remove docker hub alert](https://gitlab.com/gitlab-org/gitlab/-/commit/8b1cf20bceee5175e4b1ca7e8b8283da4f606a6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187160))
- [Add Prometheus histogram for scheduled pipeline execution scheduling](https://gitlab.com/gitlab-org/gitlab/-/commit/d17c87d18802f9dd7b54ac09058cb39783f1a8f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187843)) **GitLab Enterprise Edition**
- [ActiveContext: add query to get all results](https://gitlab.com/gitlab-org/gitlab/-/commit/024a3a907f082f0340b2726d98e2bde0ec414bed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187687))
- [Convert hover overlay text to focus interaction](https://gitlab.com/gitlab-org/gitlab/-/commit/7436e021e3487c05556a1c7abec2ea1b39af1abe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187410))

### Deprecated (1 change)

- [Ignore project_fingerprint and removed usages](https://gitlab.com/gitlab-org/gitlab/-/commit/271e059b63124fa61e3320219ccdd0e579245d49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185329)) **GitLab Enterprise Edition**

### Removed (35 changes)

- [Delete the `zoekt_index_circuit_breaker` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/6e5d3f3ba98abe9d99100fef9dd28d8a2649662b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190328))
- [Remove Twitter identities](https://gitlab.com/gitlab-org/gitlab/-/commit/ff03bf95e376d1ba0b559d80779af209eff03ca9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188411))
- [Disable Limit CI_JOB_TOKEN access scope feature](https://gitlab.com/gitlab-org/gitlab/-/commit/7e80ac2cebd2bbd6f0a2a7d81bfa5b81190812c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189748))
- [Drop support for scan_result_policy in backend](https://gitlab.com/gitlab-org/gitlab/-/commit/ac07348b861c97fb3389665e86b8b6646a214a12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189581)) **GitLab Enterprise Edition**
- [Remove feature flag custom_ability_admin_protected_environments](https://gitlab.com/gitlab-org/gitlab/-/commit/d88ab3e0071481907e0072ab9659ffed764a15dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190209))
- [Removes FF mr_show_reports_immediately](https://gitlab.com/gitlab-org/gitlab/-/commit/ecd85c4cc3bbd62857a874f351890ec0634d0c8a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190287))
- [Remove work item type old ID fallback](https://gitlab.com/gitlab-org/gitlab/-/commit/7c2bcdb4d7933572e2acc6afdaed1e6131f3c5ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190215))
- [Remove IssuesBulkUpdate mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/f6cc9fa0ec0235bf92835ba722c5d59b0bc50e17) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187694))
- [Remove prompt migration feature flags post completion](https://gitlab.com/gitlab-org/gitlab/-/commit/61c538cae1e4bcd0f3dda1a8ea49e176641c4e2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183439)) **GitLab Enterprise Edition**
- [Remove Pages Project templates](https://gitlab.com/gitlab-org/gitlab/-/commit/a6795a45ecf8e9335557ab851c97756696077da4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188791))
- [Delete the `zoekt_optimized_performance_indexing` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/887fdc29de6503a26c4fdf753fab20c86af926fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188860))
- [Remove project limit from the dependency list](https://gitlab.com/gitlab-org/gitlab/-/commit/c25dc285783854b6434844ce656edbbbe62738e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189797)) **GitLab Enterprise Edition**
- [Remove deprecated Terraform CI/CD templates](https://gitlab.com/gitlab-org/gitlab/-/commit/e9ba0927821d0764e0d232dc0a8f1c1b35e694ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190011))
- [Disable Limit CI_JOB_TOKEN access scope feature](https://gitlab.com/gitlab-org/gitlab/-/commit/2392d6cc1e704862fc397692214fd21915afdc5b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189028))
- [Cleans up code_suggestions_include_context_imports ff](https://gitlab.com/gitlab-org/gitlab/-/commit/c194646447f8c02a5706329920976240ecbff6fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189008))
- [Remove Usage model references from create service](https://gitlab.com/gitlab-org/gitlab/-/commit/2120f002b677cb37b9168a905d08288b611186fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189583))
- [Remove the references of trigger_request](https://gitlab.com/gitlab-org/gitlab/-/commit/b5de9978de0b357aa91319efe5e76d0ec1ccb983) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188425))
- [Delete the `elastic_migration_worker` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/be68eedcca56dd54eae850bc855a1abfd088ae61) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187543))
- [Remove deprecated Geo VerificationWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/88acf56f22eb07d7382522e84f2507849fd362f9) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188390)) **GitLab Enterprise Edition**
- [Remove GraphQL Namespace addOnPurchase Field](https://gitlab.com/gitlab-org/gitlab/-/commit/bc50056906ea630c741ba69ec5e0f5820a63d012) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189066)) **GitLab Enterprise Edition**
- [Remove the tmp index for p_ci_builds.trigger_request_id](https://gitlab.com/gitlab-org/gitlab/-/commit/c818a17cd4bfcfa26b4774c1533fd7c1a0afc7e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189122))
- [Remove GraphQL addOnPurchase Query](https://gitlab.com/gitlab-org/gitlab/-/commit/a1165d156f2cb3bf1d5cc852cb720bfbf2fc74f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189053)) **GitLab Enterprise Edition**
- [Merge `more_commits_from_gitaly` FF into `commits_from_gitaly`](https://gitlab.com/gitlab-org/gitlab/-/commit/76894daa835a9771e6ce4ecf987ca8c34d0578b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189188))
- [Remove feature flag cloud_connector_new_token_impl](https://gitlab.com/gitlab-org/gitlab/-/commit/a09148ab8d66905c936934d4c2e294706e9accfd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189177)) **GitLab Enterprise Edition**
- [Remove feature flag ci_only_one_persistent_ref_creation](https://gitlab.com/gitlab-org/gitlab/-/commit/b2a902e297ae43359e2405ba007e139a983c2d09) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187651))
- [Remove custom scan action from policy schema](https://gitlab.com/gitlab-org/gitlab/-/commit/08de8107f348e29e38eb60c58f5b27bac31cdb43) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188580)) **GitLab Enterprise Edition**
- [Remove ff ci_read_trigger_from_ci_pipeline](https://gitlab.com/gitlab-org/gitlab/-/commit/9d914765d21194ec6b1dfd858d27f585a5271d75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182226))
- [Mark the migration as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/adecf9a8dce8db9126a48cab2602b515d9f84bea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188747)) **GitLab Enterprise Edition**
- [Clean up ai_duo_chat_switch feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/0127042ba071e8342be496a36b48979e5600333c) by @aryandutt ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188728))
- [Remove unused #wiki_page_version_author_avatar](https://gitlab.com/gitlab-org/gitlab/-/commit/8341c8ae334691b1efd64209fb97bf39a6254665) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188184))
- [Remove GraphQL `name` field in CiMinutesProjectMonthlyUsage](https://gitlab.com/gitlab-org/gitlab/-/commit/f4d60ddb5e379e7b03323115689d40dccac921b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188402)) **GitLab Enterprise Edition**
- [Remove GraphQL `STORAGE` enum in NamespaceProjectSortEnum](https://gitlab.com/gitlab-org/gitlab/-/commit/ae9fed7232b64f544fe8506edab88d14d214bfec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188395)) **GitLab Enterprise Edition**
- [Remove secret_checks_for_web_requests FF](https://gitlab.com/gitlab-org/gitlab/-/commit/df805dc42363ea683d7ba4db706c9f9845f1e5d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187433))
- [Remove project from the group settings sidebar menu](https://gitlab.com/gitlab-org/gitlab/-/commit/53a72684c02d4f335ca633579f459f7a15ddba05) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188204))
- [Remove duo redirct banners from general settings](https://gitlab.com/gitlab-org/gitlab/-/commit/0c537d2afba4c68abe9c00dcfcd40645cc275a30) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186616))

### Security (7 changes)

- [Improve Octokit::ResponseValidation middleware and add rate limits](https://gitlab.com/gitlab-org/gitlab/-/commit/803ab95a2f20364ecdfdf4a74461bcb9db5edc61)
- [Remove id attribute from OAuth form](https://gitlab.com/gitlab-org/gitlab/-/commit/74620473c5a7d686aafd7792eb0574d9a80d75db)
- [Use IssuePolicy for #issues_readable_by_user](https://gitlab.com/gitlab-org/gitlab/-/commit/542b1da9d89d43450d87752ff09658140d4a3b71)
- [Security unauthorized access to reading branch names](https://gitlab.com/gitlab-org/gitlab/-/commit/65394fc44e4dfb185258c628916488d77dee9781) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189728))
- [Add SecureHeaders middleware with the Nel header](https://gitlab.com/gitlab-org/gitlab/-/commit/fec5ba732d37c690a188a46e7d490bd308995b1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189728))
- [Restrict forwarded headers in Maven dependency proxy](https://gitlab.com/gitlab-org/gitlab/-/commit/424e4908341e3d1cf757b3d305d757a49854765b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189728))
- [Simplify detecting paragraphs for quick actions](https://gitlab.com/gitlab-org/gitlab/-/commit/35a1349e156cdd95d6bbbdf3fd1a4e5c319f77b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189728))

### Performance (11 changes)

- [Delete environments in batches to fix project.destroy! timeout](https://gitlab.com/gitlab-org/gitlab/-/commit/0df2c5a997d0594195a5d58464358ba3d59d0084) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190497))
- [Use bulk_perform to trigger security policy sync](https://gitlab.com/gitlab-org/gitlab/-/commit/698bdad2fbab6598d41538a52564882ebde90822) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190046)) **GitLab Enterprise Edition**
- [Optimize issues banned users query](https://gitlab.com/gitlab-org/gitlab/-/commit/edbe1d7944f696480c0cc05d3e482773da951437) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190314))
- [Delete commit status in batches](https://gitlab.com/gitlab-org/gitlab/-/commit/333534540a325d030963ebb48bf738f9d988ac84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190311))
- [Drop web_hook_logs table](https://gitlab.com/gitlab-org/gitlab/-/commit/8f0302498e76dcc130876eeaeb7c787fa76fdb83) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189420))
- [Prevent timeout in cancel pipeline query during project deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/f168f87c2911b25473eeb8a342fab6ae510185a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189295))
- [Clean up group_microsoft_applications_table FF](https://gitlab.com/gitlab-org/gitlab/-/commit/c704831c9d02f2f567062e04c63762ef164b9ad2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182829)) **GitLab Enterprise Edition**
- [Enable reindexing FF by default](https://gitlab.com/gitlab-org/gitlab/-/commit/6fe07e5bdf5b1d38c0c917a6533d167d365f16b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188548))
- [Use web_hook_logs_daily](https://gitlab.com/gitlab-org/gitlab/-/commit/db6b93b4d12f8a378cb7ff6539c6d1b7140376a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188880))
- [Apply InOperatorOptimization to relative_position](https://gitlab.com/gitlab-org/gitlab/-/commit/e7d33dab700d2b579d732f3870fd0cd25ece639c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187894))
- [Reduce merge request diff batch size for keep-around rake task](https://gitlab.com/gitlab-org/gitlab/-/commit/0b086fc92a383048e169f5bdfebe6b13f336a133) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187451))

### Other (174 changes)

- [Remove duo_code_review_chat feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/c14aada20e4fca2d8d94adc403451cc6f6d83814) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190640)) **GitLab Enterprise Edition**
- [refactor: Consolidate tests for CheckRuleExistenceService](https://gitlab.com/gitlab-org/gitlab/-/commit/9995b824a2975ecb3a687f08a2cc4e0147afa207) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188135))
- [Document how to troubleshoot missing files on the Geo primary site](https://gitlab.com/gitlab-org/gitlab/-/commit/4e53c102e6e0c719f5c09334c815a21eb6ffc692) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188195))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/b94e4afc436fbdbe939db0c1f338f88fc161243f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190201))
- [Return ServiceResponse for Generic::CreatePackageFileService](https://gitlab.com/gitlab-org/gitlab/-/commit/e07a06484083350e6b72255e0261e58d0294a9e2) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189754))
- [Synchronously remove unused index_merge_request_diffs_on_project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/040a6b8e1fefbb46f0f4ece4ee27e9105e84640e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190763))
- [Remove ai_review_merge_request feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e07eee6f089b138a66d654635afd2c6d7f12a1dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190639)) **GitLab Enterprise Edition**
- [Drop index (expire_at, job_id) from p_ci_job_artifacts](https://gitlab.com/gitlab-org/gitlab/-/commit/26fc74d4d1bfbd613a47355c4123b05824f8079b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189532))
- [Remove feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/9b8623c0be69bfb4bdc491c85e59a81d45d0a9ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189923))
- [Clean up feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/7e41dbb49aa133ca5eae0406d4f2f5b569b9a37b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190732)) **GitLab Enterprise Edition**
- [Feature flag cleanup](https://gitlab.com/gitlab-org/gitlab/-/commit/e3fa954bd7584e457fb7eb1e271d3d7d5cc23265) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190727)) **GitLab Enterprise Edition**
- [Workhorse: set metrics labels for external URLs](https://gitlab.com/gitlab-org/gitlab/-/commit/e8122ac903c187ee282926a4358c38330d28c07e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187163))
- [Clean up sum vulnerability count feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/81a477c4f7642776697277e5e08bd618652d463b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190718)) **GitLab Enterprise Edition**
- [Revert MR 187612 until DB query is resolved](https://gitlab.com/gitlab-org/gitlab/-/commit/f4eb8c965e5b786081a817f42ba65d10d30c8b50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190708))
- [Finalize BBM MarkDuplicateMavenPackagesForDestruction](https://gitlab.com/gitlab-org/gitlab/-/commit/be944c01ce5fde3079e2d2dcb84a6f22c2ac718b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190695))
- [Add sent_notifications.namespace_id column](https://gitlab.com/gitlab-org/gitlab/-/commit/eb5a1a060d16c6ee8957d024072c23d1a687953b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190671))
- [Disable product usage data for offline license](https://gitlab.com/gitlab-org/gitlab/-/commit/c266afd050e25722349375590af22d6c2e853c73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190005))
- [Change schema for pipeline_variables](https://gitlab.com/gitlab-org/gitlab/-/commit/65512474f0e7c8e9add9a3cb2c034c9ecc36be64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187555))
- [Sync translations from crowdin (2025-05-08)](https://gitlab.com/gitlab-org/gitlab/-/commit/72f460898a7664942e27bde268bc3f614ab0124c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189436))
- [Remove duo_code_review_claude_3_7_sonnet Feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/6a143afc9eb6d9ef9df71b4ad1b21360a07fc47e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190644)) **GitLab Enterprise Edition**
- [Remove generate_commit_message_claude_3_7 Feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/c3a8e7d0ef1ef5629690188a0a3a3c09b82445b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190643)) **GitLab Enterprise Edition**
- [Remove fallback for Current.organization&.id in groups controller](https://gitlab.com/gitlab-org/gitlab/-/commit/5b7558c0d8d47db49992552b7376c0cf7cdbb9b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190091))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/1f28c5bb966e053ed3770e25f9fc80478dad060f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190622))
- [Finalize BBM BackfillProtectedBranchMergeAccessLevelsProtectedBranchProj](https://gitlab.com/gitlab-org/gitlab/-/commit/e47d3e7d0d5783a6036d0f986f1226b4b9c60a11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190603))
- [Remove usage of default organization in Certificate](https://gitlab.com/gitlab-org/gitlab/-/commit/c3d6a97e1eb047c4f4bd10c085667dc436501af0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189720))
- [Remove new_milestone_filtering_logic flag and use new behaviour globally](https://gitlab.com/gitlab-org/gitlab/-/commit/28a43d0bde21b2f5d54dd10336c8a7af13e0f41a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189988))
- [Remove group_vulnerability_scanners_using_statistics FF](https://gitlab.com/gitlab-org/gitlab/-/commit/d7b878e87d7101ae64c2f09b8323b4812dd70574) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190559)) **GitLab Enterprise Edition**
- [Update CI partitioning threshold to 1TB](https://gitlab.com/gitlab-org/gitlab/-/commit/9bb3e3509aedfa77477643a75398c4855d81e7e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190547))
- [Copy global push rule to organization push rules](https://gitlab.com/gitlab-org/gitlab/-/commit/feacf6441fc75780c07d071f61fce0750e4dcd52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190258))
- [Remove `commit_message_logger` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b1a6b1634fa5efa7125db5bf983b5edf2fb54651) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190474))
- [Add sent_notifications.created_at column](https://gitlab.com/gitlab-org/gitlab/-/commit/4d8f994f6baf6b5f7ba81ead0b085547b17de776) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186703))
- [Drop taggings table](https://gitlab.com/gitlab-org/gitlab/-/commit/5c0147c02cae9e716a32b94b317fe5b32c08f560) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179404))
- [Ignore resource_label_event columns](https://gitlab.com/gitlab-org/gitlab/-/commit/73dadd9740897317d8b16b3e9343bd8db57957be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190451))
- [Add migration to set rate limits to zero for self-managed instances](https://gitlab.com/gitlab-org/gitlab/-/commit/85c1b58a32f08d8e756765a7f074e85a2fe66a2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189906))
- [Replace ff with admin setting](https://gitlab.com/gitlab-org/gitlab/-/commit/c30a5443517fb904d4aaf3e0d26d02fa470226c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190090))
- [Drop siphon_issues.correct_work_item_type_id from CH](https://gitlab.com/gitlab-org/gitlab/-/commit/121c061b14e1fc2350b0858d11e0100b22726507) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190384))
- [Remove correct_work_item_type_id from work item index](https://gitlab.com/gitlab-org/gitlab/-/commit/b8a98c407e4622578d2ae694913e7ae19a8a274c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190211)) **GitLab Enterprise Edition**
- [Improve Geo post-failover clean up documentation](https://gitlab.com/gitlab-org/gitlab/-/commit/e95eb824b9f4887ee93935df56c705d28945357e) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190302))
- [Add NOT NULL for sharding key on issue_email_participants](https://gitlab.com/gitlab-org/gitlab/-/commit/58ceeb4876c4dc88f889f402e6fef9502cc6ebb2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189213))
- [Finalize DeleteOrphanedGroups batched background migration](https://gitlab.com/gitlab-org/gitlab/-/commit/c38090702f974e7292a01d0ecdf5346c4fd9aa94) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190315))
- [Add a new cop to prevent explicit calls for enable_lock_retries!](https://gitlab.com/gitlab-org/gitlab/-/commit/02ae50d009ead802a1bac9d7029b2192d3913d75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189306))
- [Reindex Elasticsearch note index to update integer with long type](https://gitlab.com/gitlab-org/gitlab/-/commit/bd3f3d7bd3ade9ff51536779c6e9c2fc185edc48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189649)) **GitLab Enterprise Edition**
- [Remove populate_and_use_build_source_table feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/c6108347f7e861de29b919264fdd821d1d9fcb05) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190164))
- [Remove ci_enable_live_trace flag](https://gitlab.com/gitlab-org/gitlab/-/commit/fde6743cbeb8ea81efafc0d67781c70204a2d491) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189232))
- [Finalize BBM BackfillIssueLinkIdOnRelatedEpicLinks](https://gitlab.com/gitlab-org/gitlab/-/commit/9f54feb3cdd12e7051153f742e320dcff5eabfeb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189979))
- [Create the temp index for notes project null sync](https://gitlab.com/gitlab-org/gitlab/-/commit/1735007671a453f4063aefe0c5c6753abd5fec3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189423))
- [Backfill DuoCore AddOnPurchase for existing subscription](https://gitlab.com/gitlab-org/gitlab/-/commit/318fbf44554896f5eb5ff40325016f962f90dd8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188884)) **GitLab Enterprise Edition**
- [Run ConcurrencyLimitSampler once per interval](https://gitlab.com/gitlab-org/gitlab/-/commit/0e17b5831b2d3f9576c4274c35e9a2cde990b1bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189327))
- [Add and fill resource_iteration_events group](https://gitlab.com/gitlab-org/gitlab/-/commit/bcc9e05e0bc3781e2ad554436077f04da898f5a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187487))
- [Remove model-level validation for sharding key in issue_assignment_event](https://gitlab.com/gitlab-org/gitlab/-/commit/36bdcdfb95dda260903f7da275373c25acaec414) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189989))
- [Finalize BBM BackfillIssueUserMentionsNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/e51e07d4695bd1aa646810684ba55c88c6bc8fa8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189982))
- [Adds todo notification for self-managed enabling duo core features](https://gitlab.com/gitlab-org/gitlab/-/commit/836771dfc7eebd991134e3c7d62e9c691469c261) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189524)) **GitLab Enterprise Edition**
- [Finalize migration BackfillGroupWikiRepositoryStatesGroupId](https://gitlab.com/gitlab-org/gitlab/-/commit/dad6751839382633da4cd9c0b47b78fd293e595a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186910))
- [Drop unused indexes from issues table](https://gitlab.com/gitlab-org/gitlab/-/commit/42d4042f979586cb46a948289b03605376957cfd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189484))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/551d68d6840fe1b852a36e1bf997bb5ca17d452a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188947))
- [Remove safe navigation operator from Current.organization.id references](https://gitlab.com/gitlab-org/gitlab/-/commit/1b5bdb97f804f57d3054984eedbff9adb9b0dfb1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189118))
- [Add not NULL constraint to fork_networks](https://gitlab.com/gitlab-org/gitlab/-/commit/065d98ac34614613aa1a4aa3093cff2f03a0ac2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188272))
- [Upgrade Jekyll project template](https://gitlab.com/gitlab-org/gitlab/-/commit/98aa3c3418b5c65613dd688c760ce0bedda5e632) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189764))
- [Add NOT NULL constraint on design_management_versions.namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/0f206af6308ecd820a8c7871130f187579493e2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177369))
- [Adds todo notification for self-managed enabling duo core features](https://gitlab.com/gitlab-org/gitlab/-/commit/bdb745981bbd2c047234f241d9ac97c4c1ac21d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189490)) **GitLab Enterprise Edition**
- [Truncate p_ci_build_trace_metadata partition 102 on .com](https://gitlab.com/gitlab-org/gitlab/-/commit/288aeaa795481dcbcc748d9a1c0f3a421e69c80b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189719))
- [Change plan card styling for trial billing page](https://gitlab.com/gitlab-org/gitlab/-/commit/5d4bda16173052d927e7f5a5d0368f0d3f1bf3df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189379)) **GitLab Enterprise Edition**
- [Make pipeline cleanup limits configurable](https://gitlab.com/gitlab-org/gitlab/-/commit/ff0b38df1d72489b441f400c5d1f538076f4e9d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189191))
- [Finalize migration BackfillPipelineExecutionPoliciesConfigLinks](https://gitlab.com/gitlab-org/gitlab/-/commit/0b75e02bbd4a6dd227948054f2fcf2b97e43afe5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189601))
- [Finalize BBM BackfillIssueEmailsNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/06de2463129cb6ccdcea8271ec6002d5dac7f968) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189242))
- [Step-up auth: Use NamespacedSessionStore for accessing session data](https://gitlab.com/gitlab-org/gitlab/-/commit/d5b9612a3e7e50abd248e6f608691cc8ea2171b2) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186803))
- [Drop ci_runner_machines_archived table](https://gitlab.com/gitlab-org/gitlab/-/commit/4eca3b07655ac32d5ea2ef592ff5ed3ae265aaa5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189308))
- [Add FF switch to fetch contributions data from new CH tables](https://gitlab.com/gitlab-org/gitlab/-/commit/01635c1f003e68e232ab9c0d022da5f7468a3253) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187192)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/aa67e01fd76ad8d23b8c3f0f910da14f3f0b3f6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189567))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/14510d99c367089e3b4c0daa1de43a9902520143) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189565))
- [Include ability checks for advanced vulnerability management using ES](https://gitlab.com/gitlab-org/gitlab/-/commit/8da9b6023903673e25017062de19acb795f75f26) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189291)) **GitLab Enterprise Edition**
- [Validate NOT NULL constraint on ci_build_needs.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/8b766650353ed8b64463a06f6c552407aa26b650) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187236))
- [Add a new POST heartbeat endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/83d7680f0beeed096dbb547499174199b616012c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188994)) **GitLab Enterprise Edition**
- [Streamline Project#archived? to hide deletion-related logic](https://gitlab.com/gitlab-org/gitlab/-/commit/64e1c420231ef4d4472c99149643ba323d4d7a42) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188545))
- [Set search_uses_match_queries as default true](https://gitlab.com/gitlab-org/gitlab/-/commit/a5e837e6d0a896a783aed44408e19b861ec08813) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189405)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/903cc6fcd98a007427d827981a685ae1c60e488e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189401))
- [Finalize the finish onboarding for group saml backfill](https://gitlab.com/gitlab-org/gitlab/-/commit/7f0ad9063b18793f59ae616f0b2b8471afd744ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187716))
- [Remove FF hide_merge_requests_from_banned_users](https://gitlab.com/gitlab-org/gitlab/-/commit/3d8542ada0be39bdd29ddd65fd85b1884efc1a38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188770)) **GitLab Enterprise Edition**
- [Improve custom template logging](https://gitlab.com/gitlab-org/gitlab/-/commit/ad8601a67901d36852fb60f62e2524a1cff71634) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189135)) **GitLab Enterprise Edition**
- [Change ai_troubleshoot_job_events foreign key](https://gitlab.com/gitlab-org/gitlab/-/commit/a401a51b6a660be9b9172679a8dba7a261352367) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189004))
- [Ignore blank values in policy field comparison](https://gitlab.com/gitlab-org/gitlab/-/commit/d8511fe6642165e87494cde86ebc61e17c68b6a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189319)) **GitLab Enterprise Edition**
- [Drop ci_runners_archived table](https://gitlab.com/gitlab-org/gitlab/-/commit/c7117f1d98ec28be7bc91107546db311e9b6fd9d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188902))
- [Add not-null constraint check for non-extensions settings](https://gitlab.com/gitlab-org/gitlab/-/commit/6552feea580a83b89fd41d46218e0e5b6128e1e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186795))
- [Sync translations from crowdin (2025-04-25)](https://gitlab.com/gitlab-org/gitlab/-/commit/2e4043849b4da86a3ebaae1c217530d810c44e78) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189282))
- [Reindex Elasticsearch work items to update integer with long type](https://gitlab.com/gitlab-org/gitlab/-/commit/6077d421f24fd38afb2ea1e2bac48a2fccc8cf91) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189044)) **GitLab Enterprise Edition**
- [Remove p_ci_builds_metadata.runtime_runner_features column](https://gitlab.com/gitlab-org/gitlab/-/commit/1ea802ca1d00a02d5a1c14e77f59c187649ef4ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189271))
- [Add the retry rollout logic for failed namespaces](https://gitlab.com/gitlab-org/gitlab/-/commit/e4dab8d06cb4c0ee320efddb0733e94cb1cb2f94) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188249)) **GitLab Enterprise Edition**
- [Sync translations from crowdin (2025-04-24)](https://gitlab.com/gitlab-org/gitlab/-/commit/66feaee0c47079ade929bd946bc1f3672de39390) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188668))
- [Mark 20250113152652 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/9c796a43b47af7d6016263e2b42dbc2411fa5a6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188694)) **GitLab Enterprise Edition**
- [Sync rules from read model on default branch change](https://gitlab.com/gitlab-org/gitlab/-/commit/a2a52e91087f4498eadcf4c3a910a52fcbde7a9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188991)) **GitLab Enterprise Edition**
- [Reindex Elasticsearch merge request to update integer with long type](https://gitlab.com/gitlab-org/gitlab/-/commit/85028a7911e78ae19b76572d4a3fb3ee73f87b52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188909)) **GitLab Enterprise Edition**
- [refactor: Avoid escaping characters in error message in package overview](https://gitlab.com/gitlab-org/gitlab/-/commit/f62690534e950c37d0c0b9810b5176a0c86b04b5) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189173))
- [Add NOT NULL for sharding key on issue_assignment_events](https://gitlab.com/gitlab-org/gitlab/-/commit/047a740e2602143ca9748b32baeeaeeb1190eef2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188803))
- [Set zoekt_critical_watermark_stop_indexing as default_enabled true](https://gitlab.com/gitlab-org/gitlab/-/commit/aad1e71e917cef1c5f1c27211db27681c6bb771f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188746)) **GitLab Enterprise Edition**
- [Mark 20241204115350 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/27a02a7a47a8faf416639cd663a90addacfe905a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188693)) **GitLab Enterprise Edition**
- [Remove mentions to enable_lock_retries! from docs](https://gitlab.com/gitlab-org/gitlab/-/commit/e9eda7a223e4e10d62f55edd78ce86734ed0500e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189063))
- [Conditionally show first name and last name fields on in-app trials](https://gitlab.com/gitlab-org/gitlab/-/commit/ca5980f2ef2927eca65750debf683fef2da5e5a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188816)) **GitLab Enterprise Edition**
- [Lower retries for audit events worker to 3](https://gitlab.com/gitlab-org/gitlab/-/commit/2c55e84fb42cabc22d483c48afbd593a4da42cef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188491)) **GitLab Enterprise Edition**
- [Drop redundant indexes on the issues table](https://gitlab.com/gitlab-org/gitlab/-/commit/a7e1ec70a803300baf1ccb6ad858513f53db668c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189036))
- [Mark 20250203130827 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/c780a44ec688deade4d74fc671b78f9370d31aed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188695)) **GitLab Enterprise Edition**
- [Remove hide_snippets_of_banned_users feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e271662b00cd659739c85267171dd5cdcd088c3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188980))
- [Finalize BBM BackfillPCiPipelineVariablesFromCiTriggerRequests](https://gitlab.com/gitlab-org/gitlab/-/commit/32a599789c1446fde2de335666f8d8de72dc8d03) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188507))
- [Add `canLeave` user permission field for the Groups GQL query](https://gitlab.com/gitlab-org/gitlab/-/commit/e944f6e6e3787657acf4e4a225f9bd934975bd55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188078))
- [Remove vscode_web_ide feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/9965327a0f254486e985104d412ce7f597c67ab2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188427))
- [Finalize settings context hash backfill](https://gitlab.com/gitlab-org/gitlab/-/commit/089df04905ea9db8e5862f1a8187975386b0fca9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184414))
- [Add NOT NULL for sharding key on dast_site_profiles_builds](https://gitlab.com/gitlab-org/gitlab/-/commit/e3c6d32c449a50b68267704187c7ce23ebab853b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186922))
- [Add & backfill sharding keys for protected_branch_push_access_levels](https://gitlab.com/gitlab-org/gitlab/-/commit/c0141a06f90c3da82fd32cdc06e6a103bd716573) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175714))
- [Mark 20250203213829 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/becc557a5ce9f92d0510cfd44138da771c349e56) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188696)) **GitLab Enterprise Edition**
- [Remove safe navigators](https://gitlab.com/gitlab-org/gitlab/-/commit/ff7b5197297353d70a14618b7041cdb5e0ef2811) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187461))
- [Mark 20241107131942 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/bda2872748e68d568a127a0dadc3d02a9fed09b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188657)) **GitLab Enterprise Edition**
- [Refactor and breakdown SyncProjectApprovalPolicyRulesService](https://gitlab.com/gitlab-org/gitlab/-/commit/a7601774353c7b35283bb78c7137b58d404c3b54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184623)) **GitLab Enterprise Edition**
- [Mark 20250204111501 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/d35e4da7d456179d934a304015011f80d187505d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188697)) **GitLab Enterprise Edition**
- [Finalize BackfillPartitionedWebHookLogsDaily](https://gitlab.com/gitlab-org/gitlab/-/commit/af915e9ed57c7868a5afb848c2fdb4f699dfba2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188055))
- [Finalize BBM BackfillPCiPipelinesTriggerId](https://gitlab.com/gitlab-org/gitlab/-/commit/f3a3053918053b10f9b54c2c78454987cfa5b9d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188508))
- [Add migration to remove the jobs of a deprecated worker](https://gitlab.com/gitlab-org/gitlab/-/commit/6d396a1c9eec3a33d7ee52309aea6065ab7065d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188469)) **GitLab Enterprise Edition**
- [Remove custom_fields_feature feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/97fe03247148a7096a342761cb85e138702d9338) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188844))
- [Remove redundant index from job artifacts](https://gitlab.com/gitlab-org/gitlab/-/commit/29cb8c91ec3752ad5f50b20f5748b9b6c5a6962e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187564))
- [Remove deprecated ElasticCommitIndexerWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/a7795c80d7377f2973e229a2ada0406fc6a667ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188853)) **GitLab Enterprise Edition**
- [Include EncryptedAttribute in non-owned files](https://gitlab.com/gitlab-org/gitlab/-/commit/1961c03cab6941c083a2a0a8e7a1d8c1d719ea89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188124))
- [Protected containers: Repository push protection for deploy token](https://gitlab.com/gitlab-org/gitlab/-/commit/58b0f375bb3be08b96287ce13db056763fb50f6a) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185823))
- [Allow null values for namespace_id column in compliance adherence table](https://gitlab.com/gitlab-org/gitlab/-/commit/8558af98f44a94305d2b8c44df031f0d0334791d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188400))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/943a21c720bb2783827e2d094294850467a0e76d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188518))
- [Finalize BBM BackfillIssueEmailParticipantsNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/f07f81dbd87f45c1c75e6aac0d90aa87fffefe0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188655))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/0ead2bef2019860f44bc0aa0e9bf06573488440f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188765))
- [Mark 20241107144941 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/b17bfd504b9fa84122072f515164f2ee75ca4027) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188692)) **GitLab Enterprise Edition**
- [Remove hidden_notes feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/17ad57b94d4922f3749bff261f49d820866dd657) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188760))
- [Add documentation for approving an MR directly after creation/push](https://gitlab.com/gitlab-org/gitlab/-/commit/e0b98bafcc2ac55f88e30c7896b8d41c09d1966d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187255))
- [Optimize and requeue redirect_routes namespace_id backfill](https://gitlab.com/gitlab-org/gitlab/-/commit/c5faf7f4c04ca055c2b8286a38c3581da0d735f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186774))
- [Move custom emoji path logic to widget model](https://gitlab.com/gitlab-org/gitlab/-/commit/392d3baf86abcf6fa77b39f1d998039c41b8283b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188449))
- [Remove unused default_organization initialization from spec](https://gitlab.com/gitlab-org/gitlab/-/commit/7d91e4f8db1feb60dc5a23fa724d0286fd24a426) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188592))
- [Fix timestamp inconsistency for AI events in CH](https://gitlab.com/gitlab-org/gitlab/-/commit/45868adf0777c672eca94802a9eb2463cfbe9cd6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186988)) **GitLab Enterprise Edition**
- [Sync translations from crowdin (2025-04-17)](https://gitlab.com/gitlab-org/gitlab/-/commit/6fed5207ee42e1595f6c8e01d0fcff58d955736c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188556))
- [Finalize migration BulkImportTrackers](https://gitlab.com/gitlab-org/gitlab/-/commit/0044d3a9853acffaa182c1d98801881046dd566e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184776))
- [Delete orphaned ci_runner_machines records on self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/cfa320d79ce681db52f64c719267721936f312ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188083))
- [Finalize BBM BackfillIssueAssignmentEventsNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/93fb69627b7ffb4281ac194a5f0d40270101f05c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188346))
- [Add migration to remove the jobs of a deprecated worker](https://gitlab.com/gitlab-org/gitlab/-/commit/846d3d0bb9802127df84f4756e935ccb398453bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188474)) **GitLab Enterprise Edition**
- [Sync translations from crowdin (2025-04-16)](https://gitlab.com/gitlab-org/gitlab/-/commit/aa6b4a3f992aaf57cb723482793281e9d23d6999) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188460))
- [Swap stage with stage_id column in ci_finished_builds ClickHouse table](https://gitlab.com/gitlab-org/gitlab/-/commit/ba3c033a9c8e747c012e603322636004c401f582) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188096)) **GitLab Enterprise Edition**
- [Add NOT NULL for sharding key on container_repository_states](https://gitlab.com/gitlab-org/gitlab/-/commit/4be266a349dbd2f79bdccd424b6606d6dd87818b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188456))
- [Recreate new code_suggestion_events storage in CH](https://gitlab.com/gitlab-org/gitlab/-/commit/5eed9c45332a63cb63e00da204b795bee5082f7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186860))
- [Remove feature flag group_deletion_notification_email](https://gitlab.com/gitlab-org/gitlab/-/commit/f1e59cd84a5562e4dc08e1e51704f1b0aaaa7bb2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188062))
- [Remove the check_path_traversal_middleware_reject_requests feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/59d60be4affbff27a3593a6707b8fce05794cae7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187709))
- [Finalize fork_networks organization_id backfill](https://gitlab.com/gitlab-org/gitlab/-/commit/cb61d41c55bacb8300f611466d4d6efe6136553e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188382))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/0f63905a4b6e44312b3ec5331f184d1f81854d02) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187248))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/cb4915bfcfa71be767d915e3d4e3770e0bd59202) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187810))
- [Async remove unused index from ci_job_artifacts](https://gitlab.com/gitlab-org/gitlab/-/commit/3ced8018d2a4070b795a4ebe47fc389b7a66533c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188347))
- [Drop unused notes.attachment column](https://gitlab.com/gitlab-org/gitlab/-/commit/6f78ae5c1f20af71a8b2d71091ceeb6ee4478385) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188133))
- [Removed member_promotion_management feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/81c9d125420bbccccb63a9c0b5bc1af271a82d7c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187888))
- [Add and fill resource_iteration_events group](https://gitlab.com/gitlab-org/gitlab/-/commit/e3a5591479dd4e2aca0d42a48a88b8979d414f1f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185139))
- [test: Improve readability of test by applying table syntax](https://gitlab.com/gitlab-org/gitlab/-/commit/4ad16e4539a00b0c5f01ca996c50c397968c62c2) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180229))
- [Document replicator and GitLab component names in Geo glossary](https://gitlab.com/gitlab-org/gitlab/-/commit/f38d5e7548a99ae0563cd90a84fd412c7efa51d4) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187006))
- [Validate NOT NULL constraint on packages_npm_metadata.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/cbe5d1d576f5516290d2b6d915a3b78309efeae2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188202))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/b420faba3d04624c27d78ac89540767c7fdf4951) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188087))
- [Drop credentials columns from virtual registries maven upstreams](https://gitlab.com/gitlab-org/gitlab/-/commit/9e0f3a8f09db0faebd53c24e7d9aee785e0e4bf2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188180))
- [Finalize FixBadShardingKeyIdOnProjectCiRunners migration](https://gitlab.com/gitlab-org/gitlab/-/commit/9cbc6a93d2516650c9f9987e7f9c87546e1b1354) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188163))
- [Add NOT NULL on ci_resources.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/1ad053e3314b89026fba9bbb9d96f92f35521faa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182693))
- [Optimize re-enqueue the RolloutWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/9a7796d48cdf94bc019cc338252fabd2c93ca85c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188138)) **GitLab Enterprise Edition**
- [Clean up branch_rule_squash_settings feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/334db07c3f93cb6738e4dd35aa2839596ba8e9f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186618))
- [Drop package registry application settings individual columns](https://gitlab.com/gitlab-org/gitlab/-/commit/81decd2a7a6783cd325f5fbb2ecb9d4ef741d380) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188113))
- [Remove approval_policies_pipelines_limit feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/0e0ef1bfafa21131bebbce733809713dcd6473b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188094)) **GitLab Enterprise Edition**
- [Step-up auth: Add feature tests for step-up auth scenarios](https://gitlab.com/gitlab-org/gitlab/-/commit/2f1c140da23e672fca056e02ba666de8caf279e8) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176095))
- [Add approval_policy_rule association to ScanResultPolicyRead](https://gitlab.com/gitlab-org/gitlab/-/commit/e06d32838cb1fbfd879eb2a8f4b4e0859dfd7056) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188076)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/1332579edb4a24b2fe1e6ce7df08e001a2e99eda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187979))
- [Rename notification for being added as approver](https://gitlab.com/gitlab-org/gitlab/-/commit/a860bb54496806d7dfac50b0002e075bb016a6fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187571))
- [Remove redundant partition index from job artifacts](https://gitlab.com/gitlab-org/gitlab/-/commit/26f95ca4308d9898926f205e066aeb78a22ebdcd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187858))
- [Add step to disable automated PostgreSQL upgrades in Geo setup docs](https://gitlab.com/gitlab-org/gitlab/-/commit/363f5c6653559882d6c96d69fd8109eb2f3d2f4f) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187832))
- [Remove service_accounts_crud feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/0ddd2f3d0a0175418c3355885c5791aeccc19836) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187689))
- [Add NOT NULL for sharding key on packages_nuget_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/b404d5ebbc48b13a927167d91ab5dbceced305ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187794))
- [Fix RSpec/RedundantAround offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/5527d953e35ceed48dcb792c7c0a0c13aa2e626d) by @JonstonChan ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187640))
- [Finalize migration BackfillIssuableSeveritiesNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/3084d6db66af4e5d571df3703c8191b92e728ffa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187621))
- [Sync translations from crowdin (2025-04-09)](https://gitlab.com/gitlab-org/gitlab/-/commit/dce1b2a2ff09d94e9cb1b8b948d62327463dc729) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186814))
- [Increase severity for logging blob downloads in Geo to warning](https://gitlab.com/gitlab-org/gitlab/-/commit/18bdbd39f6ef881b9a668631d6201081ce876ef8) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186398)) **GitLab Enterprise Edition**
- [Finalize migration BackfillContainerRepositoryStatesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/78f333c76a39d0a85938318b3be49905c19074e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185869))
- [Finalize migration BackfillPackagesRpmMetadataProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/d066d88be1fff7cfcf64017124af797e085a4b4f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184553))

## 17.11.4 (2025-06-11)

### Fixed (2 changes)

- [Fix gitpod button is missing in the edit dropdown](https://gitlab.com/gitlab-org/security/gitlab/-/commit/813a005dc240c1bfafc313ded694317a96f1a877)
- [Attempt to migrate ci_runner_taggings table (try 2)](https://gitlab.com/gitlab-org/security/gitlab/-/commit/706a075f79838d5d8421c5eae2e96a7601164201)

### Security (8 changes)

- [Protect webhook from excessive payload lengths](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a0d74cdeed26661b221446efc90fb5bd19b54d95) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5060))
- [Endless Redirect Loop in any project when query param "format" is "git"](https://gitlab.com/gitlab-org/security/gitlab/-/commit/24d25f0b270337679bcfe282370ad169d137471f) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5039))
- [Backport for "Add validation for board name length" to 17-11-stable](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5ed051286369ec256431faeb44a16c848b6d0edc) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5045))
- [Fix # #1329 - IDOR in compliance framework export endpoint](https://gitlab.com/gitlab-org/security/gitlab/-/commit/071c88429e0974fdf1c0d67e7ba9d1f419843244) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5043))
- [security: Git redirection inconsistency](https://gitlab.com/gitlab-org/security/gitlab/-/commit/373f9840af59eae05b14ea200fa10c1e4ecd7367) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5019))
- [Fix XSS with CSP bypass in JSON tables](https://gitlab.com/gitlab-org/security/gitlab/-/commit/862a14acb446e9f7ce962404d8d472b19d832ff8) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4987))
- [Limit HTTP response size](https://gitlab.com/gitlab-org/security/gitlab/-/commit/94d20db29203681d75da5642fe4d1da51238863e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5015))
- [Fix authorization for compliance frameworks projects](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0eecdfe1df4254e2674efe9c0e309d9325db5c4b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5035))

## 17.11.3 (2025-05-21)

### Fixed (1 change)

- [Merge branch 'bwill/fix-auto-resolve-misalignment' into 'master'](https://gitlab.com/gitlab-org/security/gitlab/-/commit/45c7b8836ebe00032c1c12c319b3a38df58a1330) **GitLab Enterprise Edition**

### Changed (2 changes)

- [Add outbound allowlist to allowed endpoints for SSRF filter](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1e69af7ba0add6b581cf68d1cbb25bdae59fcda6) **GitLab Enterprise Edition**
- [Add backport to fix shortSHA uniqueness](https://gitlab.com/gitlab-org/security/gitlab/-/commit/56f834658d280f32c1c491d18561a6d7fdb18dc2)

### Security (9 changes)

- [Use CI::VariableValue in BasicEntity to prevent exposing hidden values in collapsible UI element](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3ce5ec566dddc9dab96ef984184685c25fc69f41) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4951))
- [Show full path of project in create MR dropdown](https://gitlab.com/gitlab-org/security/gitlab/-/commit/428aa73cd69a5133c8e726eba6631d47ca9faab6) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4972))
- [Security 479168 discord zip vulnerability](https://gitlab.com/gitlab-org/security/gitlab/-/commit/cd8d42946d4f13b91cdf0e68fb74c13fa3566512) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4945))
- [Limit length of certificate cluster text fields](https://gitlab.com/gitlab-org/security/gitlab/-/commit/47af9186f2460faf4382815af35da81bc163eeba) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5000))
- [Check rate limit for over-sized blobs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0e992167ee000e8fb7de00ae5feaa059c5cfb9c8) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4970))
- [Added size constraint validation to notes position fields](https://gitlab.com/gitlab-org/security/gitlab/-/commit/db0ce6860c09da1bec9773fc9a4f6cc4550fdbad) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5006))
- [Obfuscate emails in note.bodyFirstLineHtml](https://gitlab.com/gitlab-org/security/gitlab/-/commit/16877dbcebf3a666e5a62ab1dc556a8de7777930) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4992))
- [Need to update 2fa requirement after accepting request](https://gitlab.com/gitlab-org/security/gitlab/-/commit/6283ed9ef3438bbd06108df0c2dca4ce6ad5ecd1) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4984))
- [Ensure SAML authn context comes from signed portion of SAML response](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0a0a136eced16e4513ee7130d9331aad01590770) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4978))

### Other (1 change)

- [Drop ci_runner_machines_archived table](https://gitlab.com/gitlab-org/security/gitlab/-/commit/61e11b320c03d843cc656321710dc643d692f60f)

## 17.11.2 (2025-05-07)

### Fixed (3 changes)

- [Bump devfile gem to v0.4.3](https://gitlab.com/gitlab-org/security/gitlab/-/commit/fb04def13b13a05ea39ba4bdd8e821427d0e8ed0)
- [Only check records with encrypted data in gitlab:doctor:encryption_keys](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ea74aee315396d7418c5641eb280993a4b19b8bd)
- [Fix MR diffs endpoint to respond with pagination headers](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5da8b87140aec0c7c593d229d37338396ccacd38)

### Changed (1 change)

- [Change to async_delete for ci_running_builds.runner_id](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8869d30b56801b2e8bfd92f876d00637481ead0d)

### Security (3 changes)

- [Improve Octokit::ResponseValidation middleware and add rate limits](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0a091f92508210fb4c251389fa6054fd65becf76) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4935))
- [Remove id attribute from OAuth form](https://gitlab.com/gitlab-org/security/gitlab/-/commit/57f19d6fde464506dc756621c83e6eaf0bfdfc33) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4948))
- [Use IssuePolicy for #issues_readable_by_user](https://gitlab.com/gitlab-org/security/gitlab/-/commit/19c44aecc4fd834c9fbde85003e9e20946e82979) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4955))

## 17.11.1 (2025-04-22)

### Fixed (1 change)

- [Fix string conversion for CI Inputs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/aceb71126fb8ea5be6259a2156c6255bbaa1f3de)

### Changed (1 change)

- [Put allow_composite_identities_to_run_pipelines behind ff](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2287e37df7c9ed82aa54643759e00bbf30a788c8)

### Security (4 changes)

- [Add SecureHeaders middleware with the Nel header](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5a586de4d56429eabe0fb6ebc524894925759d2e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4934))
- [Restrict forwarded headers in Maven dependency proxy](https://gitlab.com/gitlab-org/security/gitlab/-/commit/80244b98dd92312510f4a9276b5adfcbaba8e68a) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4929))
- [Security unauthorized access to reading branch names](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9f9724584d109181e764f79a3b61667520d2212f) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4933))
- [Simplify detecting paragraphs for quick actions](https://gitlab.com/gitlab-org/security/gitlab/-/commit/78466ef2cd3ddee5fbf0db67056a5bccf7c59907) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4925))

## 17.11.0 (2025-04-16)

### Added (211 changes)

- [Requeue batched background migration](https://gitlab.com/gitlab-org/gitlab/-/commit/607d5f56abf2c1f8ab0a2a03b821b45737a06cf4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186925))
- [Add workflow settings](https://gitlab.com/gitlab-org/gitlab/-/commit/b10eda32d7311f9ee036c122d9bbcbe7cc0176af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187300)) **GitLab Enterprise Edition**
- [Changes to record the users who cannot be deleted](https://gitlab.com/gitlab-org/gitlab/-/commit/b8ec63aa5be3ff0dc53565138d6db33816e79513) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183401))
- [Release Pipeline Inputs and add more details in docs](https://gitlab.com/gitlab-org/gitlab/-/commit/cca85fba528c912901e50499be46734c6cc134a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185642))
- [Add metric to determine how many instances configured ClickHouse](https://gitlab.com/gitlab-org/gitlab/-/commit/f3a568c0d9bfcd55dd83c628206f2a367418397b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187682))
- [Add support for variable for pages.expire_in](https://gitlab.com/gitlab-org/gitlab/-/commit/179bde6865465fecaf630bd90b4dda2c4e6b9c35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186536))
- [Implement Root Cause Analysis Hotspot experiment](https://gitlab.com/gitlab-org/gitlab/-/commit/ea225352ec3ea6791c2e71f187416db445239239) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183606)) **GitLab Enterprise Edition**
- [Add Frontend support for finding_token_status](https://gitlab.com/gitlab-org/gitlab/-/commit/76efbbfade61bf728c246f1fbaa30518d08f5d9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187101)) **GitLab Enterprise Edition**
- [Introduce custom status and lifecycle](https://gitlab.com/gitlab-org/gitlab/-/commit/4c7fbdb3c83b7ea8e7425852f7edb568f603ec0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186050))
- [Release duo_chat_multi_thread to self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/57e98bcb7220f683dd68a35648420b6fd780602b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187443)) **GitLab Enterprise Edition**
- [Destroying control statuses on project framework disassociation](https://gitlab.com/gitlab-org/gitlab/-/commit/2c6d4c15b33731522d6cc12d0e7e0664250cbc23) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187277)) **GitLab Enterprise Edition**
- [Add new column to `project_settings` table](https://gitlab.com/gitlab-org/gitlab/-/commit/1e1266023d6908a17e0e8ef5e28f5e74961c64dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187342))
- [Project runner settings: Add new FF for new Vue variant (Part 2)](https://gitlab.com/gitlab-org/gitlab/-/commit/cf4fc67c5ee038ca479ecc64acea6c1411dbfbad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186285))
- [Enabling enable_stale_compliance_status_removal by default](https://gitlab.com/gitlab-org/gitlab/-/commit/6582da1793993dba7695a3e51c6ff79d049b69aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187519)) **GitLab Enterprise Edition**
- [Enabling enable_standards_adherence_dashboard_v2 by default](https://gitlab.com/gitlab-org/gitlab/-/commit/9a6f5ca96661a1062eebc848994c99e16b9e2542) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187517)) **GitLab Enterprise Edition**
- [Trigger AI events backfill on instance setting change](https://gitlab.com/gitlab-org/gitlab/-/commit/a41a86928cee41cf0d30e6023e1330640b80cea5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187345)) **GitLab Enterprise Edition**
- [Add show only selected projects toggle](https://gitlab.com/gitlab-org/gitlab/-/commit/86764264c66ad140b3ac9f72a80ba8ca11a31807) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187396)) **GitLab Enterprise Edition**
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/0ce94fdafaee62042fa9dc00b34f76fbdf25bfa7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187136))
- [Enabling evaluate_compliance_controls by default](https://gitlab.com/gitlab-org/gitlab/-/commit/eabd2dc213fdde9297d95fbdf99824489576257b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187520)) **GitLab Enterprise Edition**
- [Add status widget to the sidebar of tasks](https://gitlab.com/gitlab-org/gitlab/-/commit/241e915ca89e1c488e2191d3b4c535c67387ae62) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185554))
- [Enable FF code_suggestions_include_context_imports by default](https://gitlab.com/gitlab-org/gitlab/-/commit/80a94bec095715e4c05f7f6aab1dd7cbe6bf0525) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187456)) **GitLab Enterprise Edition**
- [Enable Fireworks/Codestral by default for code completion](https://gitlab.com/gitlab-org/gitlab/-/commit/b7c5e213084b7beea6d3448e439f98d22e55c47a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187417)) **GitLab Enterprise Edition**
- [Evaluating external controls for a project](https://gitlab.com/gitlab-org/gitlab/-/commit/5e21af941c8f217217ce0c1e252fcf6d6e4e6e4a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187492)) **GitLab Enterprise Edition**
- [Add Internal Inventory checks](https://gitlab.com/gitlab-org/gitlab/-/commit/214da55ac3178b6e5b56ca7e74e5ff361b033013) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185695)) **GitLab Enterprise Edition**
- [Add additional pipelines usage information](https://gitlab.com/gitlab-org/gitlab/-/commit/bab86d203c2596a5490276bd1998c4ca88a6f6b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187435)) **GitLab Enterprise Edition**
- [Fix editing requirements with external controls](https://gitlab.com/gitlab-org/gitlab/-/commit/14582149211f40d60b2a0dae0d3ad3d9d32ae6ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187469)) **GitLab Enterprise Edition**
- [Fix reference style links after quick actions in RTE](https://gitlab.com/gitlab-org/gitlab/-/commit/c2dc0985e72fa9b56a5a7e7750ff80c9144d32b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187001))
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/94cf0fa9d7eede153084add938b4b3533658280d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186364))
- [Add Duo nano support to new namespace provision API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/5d23a7bf8216aac3edcf19816f4b9dac91cd7ed7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187364)) **GitLab Enterprise Edition**
- [Add instance AI setting to enable or disable Duo Nano features](https://gitlab.com/gitlab-org/gitlab/-/commit/b0f294f12d08b9cc4f5b4287d8ff3728c76064d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187538)) **GitLab Enterprise Edition**
- [Add a settings dropdown to GLQL views](https://gitlab.com/gitlab-org/gitlab/-/commit/f70cb22a2692bc5ed24d4e6fe4b3d0e067abfa73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184788))
- [Expose `newCustomEmojiPath` on WorkItemWidgetAwardEmoji](https://gitlab.com/gitlab-org/gitlab/-/commit/39d2b8af84ab1e446acb411b76cd611279b2ea9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187367))
- [Add policy for deleting registry tag rules](https://gitlab.com/gitlab-org/gitlab/-/commit/688cb61f5c7b7d7bd901e8ed4f88a4001a796917) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186667))
- [Adding MemberApprovalEvent data builder](https://gitlab.com/gitlab-org/gitlab/-/commit/84acd5374ccb807019d3497606671839ee9ac4d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186252)) **GitLab Enterprise Edition**
- [Add catalog column to CloudConnectorAccess](https://gitlab.com/gitlab-org/gitlab/-/commit/09414746fbeedb6974faee910cf7cfca0934972e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185609))
- [Add warning icon and alert for scheduled rules](https://gitlab.com/gitlab-org/gitlab/-/commit/611d4c6ef623571ceacbacf11cfe2c28636088ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185132)) **GitLab Enterprise Edition**
- [Migration to add duo_nano_features_enabled column](https://gitlab.com/gitlab-org/gitlab/-/commit/c2c758af98a43e5a285245adf851c73f7a806a37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186948)) **GitLab Enterprise Edition**
- [Protected containers: Minimum access level delete in project setting UI](https://gitlab.com/gitlab-org/gitlab/-/commit/b800391621f04180991f7781b90f5217b4b90c1a) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184810))
- [Add before_validation :update_project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/139784fb23c0f998c27cbf2abd7cdd9cb32e5b38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184215))
- [Step-up auth: Add omniauth step-up auth for admin mode](https://gitlab.com/gitlab-org/gitlab/-/commit/6c828bfb2ea4537f1ea9ad066971007a8c17b459) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171643))
- [Add SOC2 compliance requirement controls](https://gitlab.com/gitlab-org/gitlab/-/commit/1a55260c954bf3830f78c191f3289a5622017a0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185177)) **GitLab Enterprise Edition**
- [Add copy control ID button to framework info drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/d323abde66a87c16188d381b8f7b513a1e34ff5d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187227)) **GitLab Enterprise Edition**
- [Add filter for placeholder to users module](https://gitlab.com/gitlab-org/gitlab/-/commit/7050ea0f942e6d3ace3c840eed8f08d5d26f3ace) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185481))
- [Add user_profile_visibility_updated audit event](https://gitlab.com/gitlab-org/gitlab/-/commit/c56d0472e84c2c313e9159bb1cfcbae9fcdea314) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187207)) **GitLab Enterprise Edition**
- [Pipline Graph: Group failed jobs on top of stage](https://gitlab.com/gitlab-org/gitlab/-/commit/065a019153de56c596897c4a1e27f5b8ae8d9ca9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186793))
- [Introduce application settings for pipeline execution policy limits](https://gitlab.com/gitlab-org/gitlab/-/commit/9d52a271aff55c80a05fcc6eecaa7d143e9bb667) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185209)) **GitLab Enterprise Edition**
- [Extend Duo Health check with Amazon Q probes](https://gitlab.com/gitlab-org/gitlab/-/commit/99d5ccdf8c98abc3c825e1da821037289dd8849e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187286)) **GitLab Enterprise Edition**
- [Create organization_push_rules table](https://gitlab.com/gitlab-org/gitlab/-/commit/dd1dbec787b2b0325690de6ac436439f7b6a7394) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186740)) **GitLab Enterprise Edition**
- [Fix bug edit framework without projects modified](https://gitlab.com/gitlab-org/gitlab/-/commit/4e0d85ed80507d5399c5b2b509455309feea4fa8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187246)) **GitLab Enterprise Edition**
- [Initial commit to create vulnerabilities ES Index](https://gitlab.com/gitlab-org/gitlab/-/commit/4dcaea98cd2af893135c4c2f9475061225419fff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186827)) **GitLab Enterprise Edition**
- [Default-enable prevent token-prefixed fallback for sessionless](https://gitlab.com/gitlab-org/gitlab/-/commit/96aac77ad527b59cb4d1988eb40110d8293bc553) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187366))
- [ActiveContext: redact unauthorized results](https://gitlab.com/gitlab-org/gitlab/-/commit/33b779e47a284a8034e70be254654fe114e956ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186399))
- [Add Duo Nano support to provision API and service for GitLab.com](https://gitlab.com/gitlab-org/gitlab/-/commit/c97d4d67c7cf1373acb6661ceaf0ddee1c42993b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186605)) **GitLab Enterprise Edition**
- [GraphQL: Expose CiRunner.creationState](https://gitlab.com/gitlab-org/gitlab/-/commit/90073d58d819547b056fbebbb49123817f201213) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187306))
- [Create runner form: Add new FF for new form](https://gitlab.com/gitlab-org/gitlab/-/commit/bff6ec63c9f2884effeeebfdd814fe8a8414e33a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186711))
- [Add project pagination to the update framework page](https://gitlab.com/gitlab-org/gitlab/-/commit/ca6535a65bd414cbdc1b2b3dae30afdbe98958cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186601)) **GitLab Enterprise Edition**
- [Make reindexing settings configurable](https://gitlab.com/gitlab-org/gitlab/-/commit/86d5bec94b3a3b6478d3418fa96d32f5cd25dd10) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186065))
- [Increased the limit on description](https://gitlab.com/gitlab-org/gitlab/-/commit/dc0fd9aae1828ef4fc2b4e282113df76ad4feba0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187039)) **GitLab Enterprise Edition**
- [Destroying requirement statuses on project framework disassociation](https://gitlab.com/gitlab-org/gitlab/-/commit/a8889864a39ab10d7576228e60b87b58808833f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186779)) **GitLab Enterprise Edition**
- [Change behaviour of control update service](https://gitlab.com/gitlab-org/gitlab/-/commit/7cb8578ccfda2bc77d052af9702e277a11756992) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187034)) **GitLab Enterprise Edition**
- [Refresh requirement statuses on control deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/23a4c300afd93c4eb0173526830c33b128e2d787) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186655)) **GitLab Enterprise Edition**
- [Check policy when evaluating control](https://gitlab.com/gitlab-org/gitlab/-/commit/fd474f87ff7a8a20e89e111f8657247e99db26a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186404)) **GitLab Enterprise Edition**
- [Add counts.user_with_nil_external_attribute metric](https://gitlab.com/gitlab-org/gitlab/-/commit/865e4c3aca488de468acbe6db7ad82d7ca5a2c79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184848))
- [Add instance setting to enable or disable Duo Nano features](https://gitlab.com/gitlab-org/gitlab/-/commit/715ff7d2ad861fed4a55e78a6e79368f8ae2091a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187113)) **GitLab Enterprise Edition**
- [Add fluidWidth prop to entity_select and group_select](https://gitlab.com/gitlab-org/gitlab/-/commit/524483532551d61efbaf6de823c4f4045b190c67) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187129))
- [Add filter for placeholder to users module](https://gitlab.com/gitlab-org/gitlab/-/commit/0458b9a9249bdf9a70ba0c04c3647daee3290ff2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185683))
- [Enable policy_mergability_check by default](https://gitlab.com/gitlab-org/gitlab/-/commit/d0432951497cdd00c92f1a6cbc75fbf4166836a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187117)) **GitLab Enterprise Edition**
- [Update duo pro seat assignment email](https://gitlab.com/gitlab-org/gitlab/-/commit/32b9a2ee4cd099d286b7c20920fa8d72a2c4f3fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186006)) **GitLab Enterprise Edition**
- [UI for JSON Import Service](https://gitlab.com/gitlab-org/gitlab/-/commit/a1caf221576bcc3fb3665097d9f061646872a63c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185696)) **GitLab Enterprise Edition**
- [Add Backend Support for finding_token_status](https://gitlab.com/gitlab-org/gitlab/-/commit/ce3dbffa298213b2ebd33496c92d8a52eb2085ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186220)) **GitLab Enterprise Edition**
- [Add projects to the ComplianceFrameworkFilterInputType graphql type](https://gitlab.com/gitlab-org/gitlab/-/commit/9e090816645cb475522d3880a77859a58012eef5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184682)) **GitLab Enterprise Edition**
- [Geo: Enable observability ui feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/7a1577a7e0531af477a5a686f39404db8f56e19e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187023)) **GitLab Enterprise Edition**
- [Groups sort by name, id, path](https://gitlab.com/gitlab-org/gitlab/-/commit/a604e0d1c5d5fdf5da7b2f3bb23a9ccffab3a010) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186482))
- [Create group_push_rule table](https://gitlab.com/gitlab-org/gitlab/-/commit/02ca336b7b46fb587d562490d2449cf09ad9dd58) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185982)) **GitLab Enterprise Edition**
- [Remove `cyclonedx_dependency_list_export` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/a76e66eadf623ec6388398dfcf5dc4497bd896b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187004)) **GitLab Enterprise Edition**
- [Add analytics for CycloneDX exports](https://gitlab.com/gitlab-org/gitlab/-/commit/b05106f2335e7e5243989ab06f55e49cccfe15c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187002)) **GitLab Enterprise Edition**
- [Implement new adherence report drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/7ed305cc1df4985c4e15c18f3ae76d64dce394f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186869)) **GitLab Enterprise Edition**
- [Token prefixes: Add support for deploy tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/c29f837c20be1077e12a9c713b91d2844eba5cfd) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186538))
- [Release the routable tokens feature](https://gitlab.com/gitlab-org/gitlab/-/commit/e07aea5d164d97fc5083df7f13409555e740c0e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186679))
- [ActiveContext: embeddings for documents](https://gitlab.com/gitlab-org/gitlab/-/commit/ad94b28f5fcddf7f2f4f74f12886a8cbda29b011) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186261))
- [Apply Framework to Projects Services](https://gitlab.com/gitlab-org/gitlab/-/commit/f9293b8fca934ffe04efa863c7b1f586190e3b19) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186483)) **GitLab Enterprise Edition**
- [Added analyzer_namespace_statuses table](https://gitlab.com/gitlab-org/gitlab/-/commit/c3488d4752fdde8123a180c357c9aa51519b1b3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185595))
- [Create index on merge_request_diff_files.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/86dd82601511ff10bb32fedbb9aa5cd5e6baea53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186903))
- [Add reverse_issuer_* formats for LDAP Smart Card Authentication](https://gitlab.com/gitlab-org/gitlab/-/commit/603d9ccad6ed6deee67a32301d2181c68f0de294) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186333)) **GitLab Enterprise Edition**
- [Implement filtering in new adherence report](https://gitlab.com/gitlab-org/gitlab/-/commit/c683c129c33ef602041b40b6f9136b6e2243dcda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186566)) **GitLab Enterprise Edition**
- [Adds seat_type enum to seat_assignments](https://gitlab.com/gitlab-org/gitlab/-/commit/a18e13706a936422d6682b8860fbbb4b4a5707b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185602)) **GitLab Enterprise Edition**
- [Create system notes when custom field is changed or removed](https://gitlab.com/gitlab-org/gitlab/-/commit/a39b77951675bb4b42452d9e8fa6c56d64e23b1b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184961)) **GitLab Enterprise Edition**
- [Added new error page for zoekt multi-match](https://gitlab.com/gitlab-org/gitlab/-/commit/f65a1bd1307a6c54dfaae7d3ebc5640a17149b2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186397))
- [Log CloudFlare-reported leaked creds on sign-ins](https://gitlab.com/gitlab-org/gitlab/-/commit/a73844e66762cd198326eaee346555e72a1a8aae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186820)) **GitLab Enterprise Edition**
- [ActiveContext concern to track on ActiveRecord callbacks](https://gitlab.com/gitlab-org/gitlab/-/commit/c0d65d141dc699d0b99448eee48d5f2c20b175cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186530))
- [Add Duo Nano support to provision API and service for GitLab.com](https://gitlab.com/gitlab-org/gitlab/-/commit/845e5403104db1541d6cdf896f73cbdc35dfcd76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186569)) **GitLab Enterprise Edition**
- [Release Duo seat assignment TODO notificiation](https://gitlab.com/gitlab-org/gitlab/-/commit/17be7454434f634074d71410894a2899f342e0c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186742)) **GitLab Enterprise Edition**
- [Add date based expiration to Issue WIT feedback badge](https://gitlab.com/gitlab-org/gitlab/-/commit/a60679dae90e6c18a8b30516fed77a4598e82475) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186731))
- [Add limit to creating requirements in UI](https://gitlab.com/gitlab-org/gitlab/-/commit/557d05e86ab8186821540853316d011c07d77007) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186330)) **GitLab Enterprise Edition**
- [Add system note when a vulnerability is redetected](https://gitlab.com/gitlab-org/gitlab/-/commit/0b6a68d306e0ebf1535304940e7c62094cad7160) by @onasser ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184712)) **GitLab Enterprise Edition**
- [Implement pagination in new adherence report](https://gitlab.com/gitlab-org/gitlab/-/commit/5d60807856ef89145b8287fec3faad2f99f3716e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186548)) **GitLab Enterprise Edition**
- [Added requirement status column to control status](https://gitlab.com/gitlab-org/gitlab/-/commit/409eaae8a3edb3b546cda5ba7d2e39ff8d164b54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186510)) **GitLab Enterprise Edition**
- [Add Duo Nano support to provision API and service for GitLab.com](https://gitlab.com/gitlab-org/gitlab/-/commit/1ade0d8190f17fc327521c1c5c19aa1413bc71b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186455)) **GitLab Enterprise Edition**
- [Enable Snowplow batching](https://gitlab.com/gitlab-org/gitlab/-/commit/bcc0af6b12f3a4dbc0c117e2a4455b21a8f063f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185811))
- [Add read model support for package filtering](https://gitlab.com/gitlab-org/gitlab/-/commit/f990a78a04a97f6d17c8f8f169d4fe0a659e475c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185785)) **GitLab Enterprise Edition**
- [Add pages/Nuxt project template](https://gitlab.com/gitlab-org/gitlab/-/commit/d6ef986c47155a608f8081d62a05384da3030c55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186657))
- [Updating and creating requirement status](https://gitlab.com/gitlab-org/gitlab/-/commit/001ea637c47c53f20b04287076478e51f27fafaa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183502)) **GitLab Enterprise Edition**
- [Release protected maven packages feature](https://gitlab.com/gitlab-org/gitlab/-/commit/a9deb0b20b9384a2385ff33ce57ea802c896d5b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185940))
- [Remove vsd visualizations feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b72c40b0c2e3c3f9a68bc4be41eed99211a8a082) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186222)) **GitLab Enterprise Edition**
- [Implement `PATCH /Groups/:id` SCIM endpoint for self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/d0b38b76845ce66ec17674e2679bddff46662563) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184997)) **GitLab Enterprise Edition**
- [Show only linked items in unlink quick action suggestions](https://gitlab.com/gitlab-org/gitlab/-/commit/16f2b6d96a47ed215afcb901efefc52826ed3781) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183102))
- [Implement basic version of new adherence report](https://gitlab.com/gitlab-org/gitlab/-/commit/64788590869dbc20a44f0f0d23e777d1e0c4694c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186525)) **GitLab Enterprise Edition**
- [Add GET /personal_access_tokens to service_accounts API](https://gitlab.com/gitlab-org/gitlab/-/commit/190fc1eb933d16bcc003b027b5ec65f9a2e7667f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186105)) **GitLab Enterprise Edition**
- [Feat: Add checkbox for group level setting AmazonQ](https://gitlab.com/gitlab-org/gitlab/-/commit/75886ff6d3e3e68305ea4673ed5851cfccb493de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185504)) **GitLab Enterprise Edition**
- [Release group custom service account email](https://gitlab.com/gitlab-org/gitlab/-/commit/5443ba96bdc8ff2aceec9c64ec11bc840bb3b1f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186476)) **GitLab Enterprise Edition**
- [Added validations on associations for control status](https://gitlab.com/gitlab-org/gitlab/-/commit/4fa1bcce1a2be97428d8fb8e21e4da084849b2b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185412)) **GitLab Enterprise Edition**
- [Add top-align to the trash icon in the requirement modal](https://gitlab.com/gitlab-org/gitlab/-/commit/f6e31fe172deb329d5def92bdcc602fedad2b778) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185809)) **GitLab Enterprise Edition**
- [Improve compliance control development flow](https://gitlab.com/gitlab-org/gitlab/-/commit/7741ce67a6d86ad195f815801842051213c39343) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184981)) **GitLab Enterprise Edition**
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/243634e6a8a6a44fde835cf2916ccc8c9ef69866) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186363))
- [Expose `aboutToBeArchived` information for vulnerabilities on GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/df21c0cf26804c74f5619dec7919387d8cb347cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185311)) **GitLab Enterprise Edition**
- [Support getting predominant worker from pg_stat](https://gitlab.com/gitlab-org/gitlab/-/commit/a0fc096e5c6d6906772231635149c07764018997) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174951))
- [DB change to add member_approvals_event column](https://gitlab.com/gitlab-org/gitlab/-/commit/0da4533a8175c9c658b35a8d390713834c672f84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186253))
- [Allow owners to revoke service account tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/ce46298d1582c3a378567d99a716fbd6c2f21c40) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185682)) **GitLab Enterprise Edition**
- [ActiveContext PostgreSQL processor for queries](https://gitlab.com/gitlab-org/gitlab/-/commit/43466653cc5fb481df3d533b144093e9f04f2ea7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184708))
- [Add missing prompt versions for tools](https://gitlab.com/gitlab-org/gitlab/-/commit/753086879608b7eeff6681ce530282037c32b77b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186508)) **GitLab Enterprise Edition**
- [Added analyzer_project_statuses table](https://gitlab.com/gitlab-org/gitlab/-/commit/a9f5c5f8e95ea5b19702e029e203831ac45a8a74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184448)) **GitLab Enterprise Edition**
- [Protected packages: Add minimumAccessLevelForDelete in proj. settings UI](https://gitlab.com/gitlab-org/gitlab/-/commit/c185f79888d91823d5652ded0494a338d0158b62) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180416))
- [Add create MR to work item branch](https://gitlab.com/gitlab-org/gitlab/-/commit/25beeaabcf61eeb08ba4ad2b6d343d3eebaf92b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181479))
- [Add immutable field to access level interface](https://gitlab.com/gitlab-org/gitlab/-/commit/a8b62fb3b13ade00c7ef6c0b3815396f101f7589) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185537))
- [Add summarize_new_merge_request tool](https://gitlab.com/gitlab-org/gitlab/-/commit/fe446fd1343dad3c72cd8984018724a929c182de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186225))
- [Project runner settings: Add new FF for new Vue variant](https://gitlab.com/gitlab-org/gitlab/-/commit/bcd15ec199549fde806cb3d09fd137c16cdff12b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185957))
- [Add tables and models to store SBoM dependency graphs](https://gitlab.com/gitlab-org/gitlab/-/commit/b16610fb476ec633a6a82ef70833c8312ca755a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184240)) **GitLab Enterprise Edition**
- [Release the track_repository_xray_in_ci FF](https://gitlab.com/gitlab-org/gitlab/-/commit/8739ed3c3410c2e0d048c7aa816c1c174dbf630d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186372)) **GitLab Enterprise Edition**
- [Add sort by path to group projects](https://gitlab.com/gitlab-org/gitlab/-/commit/e2f0b581abba7003cf77b6597812eebb2bc5fe0d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186319))
- [Add cylonedx export parameter](https://gitlab.com/gitlab-org/gitlab/-/commit/970dcf8b62bba418669cd9e1ac66f7a457a62311) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185517)) **GitLab Enterprise Edition**
- [Add lastComment presenter for GLQL](https://gitlab.com/gitlab-org/gitlab/-/commit/bf5539c5ea72830a3d39009542b2ef20ca9653da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185864))
- [Save namespace_path to CH when provided for AI usage events](https://gitlab.com/gitlab-org/gitlab/-/commit/cb0fbe6ba0fe44e66cdd25d089eb65c36e8a54a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186082)) **GitLab Enterprise Edition**
- [Add duo workflow checkpoint endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/a0a347b1d95db04976353c694876898c0b5cfeff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185068)) **GitLab Enterprise Edition**
- [Add DB metric for external audit streams](https://gitlab.com/gitlab-org/gitlab/-/commit/eb30a59f8d79655331e17bbe8b1d9a1930e29937) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184339)) **GitLab Enterprise Edition**
- [UI and docuemtation changes for the virtual registry scopes](https://gitlab.com/gitlab-org/gitlab/-/commit/5d170819dd6954c7a51c011a16be774fa766b357) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185059))
- [Add `group_wikis_routes_view` database view](https://gitlab.com/gitlab-org/gitlab/-/commit/4a21a59d0b66e8f3be22a077c13ecefa4a21e5a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179454))
- [Add ClickHouse configuration settings to CE](https://gitlab.com/gitlab-org/gitlab/-/commit/d0bd3059e73399411c54f177115b4c218c34bc03) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184314))
- [Add page size selector to packages list page](https://gitlab.com/gitlab-org/gitlab/-/commit/d8d3ee6f44f3fd5134ffceff8892ffca6c09d551) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185639))
- [Add merge_request_title_regex to project setting](https://gitlab.com/gitlab-org/gitlab/-/commit/3199f464891a04f9e51a2e2adcb360d65686ed76) ([merge request](gitlab.com/gitlab-org/gitlab/-/merge_requests/184935))
- [Add tracking for dependency exports](https://gitlab.com/gitlab-org/gitlab/-/commit/f9772cd3db9e060daadf0fbebfeaeab819457a3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184666)) **GitLab Enterprise Edition**
- [Added a new vulnerability_namespace_statistics table](https://gitlab.com/gitlab-org/gitlab/-/commit/1518390583e40ac6c5e499292956d2132474e58d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182917))
- [Adds organization_id to seat_assignments table](https://gitlab.com/gitlab-org/gitlab/-/commit/67e0f579d3f0feb3cddb22316999c9df490ca87f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185243))
- [Add sort actions to all columns in Storage view in Usage quotas](https://gitlab.com/gitlab-org/gitlab/-/commit/cd221a519efbf260e25acf1df707605582224f2f) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185975))
- [Readds tooltips to icons in dev widget](https://gitlab.com/gitlab-org/gitlab/-/commit/92da858fc56af34310f69659a822e3501baaa076) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185491))
- [Add sort actions to all columns in Storage view in Usage quotas](https://gitlab.com/gitlab-org/gitlab/-/commit/99bac9897781b714cc559968f72f98b92d0cdd15) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184030))
- [Create basic Ai::TroubleshootJobEvent model](https://gitlab.com/gitlab-org/gitlab/-/commit/059e2e5f44940d132d7610e21576cd9f38217391) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184357)) **GitLab Enterprise Edition**
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/2a4a92ffee0de2338feddac824a954b55e1fc252) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185924))
- [Admin Token API: Revoke GitLab Session](https://gitlab.com/gitlab-org/gitlab/-/commit/33ca8a6ce9d216432777a9c1911c4134c47dbbf0) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184047))
- [Notify users if famework export was truncated](https://gitlab.com/gitlab-org/gitlab/-/commit/55410063ed43c20decc62f25245473bda846611d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185089)) **GitLab Enterprise Edition**
- [Add shared_namespace column to workspaces_agent_configs](https://gitlab.com/gitlab-org/gitlab/-/commit/49a26c3b6c46cfa22f049248eda96742f6921145) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185895)) **GitLab Enterprise Edition**
- [Adding framework namespace validation in requirement model](https://gitlab.com/gitlab-org/gitlab/-/commit/c61971b69ef1f08abe909215b11847666c588975) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185403)) **GitLab Enterprise Edition**
- [Add editPath to GraphQL for Compliance Frameworks](https://gitlab.com/gitlab-org/gitlab/-/commit/825ba6859422803e281bf80299960549f157bff3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184122)) **GitLab Enterprise Edition**
- [Add subscribed, due, and updated filters to work items list](https://gitlab.com/gitlab-org/gitlab/-/commit/f73ac993a1fa162aa168047b559d0f14764a9be0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185126))
- [Connect audit event streams from new tables](https://gitlab.com/gitlab-org/gitlab/-/commit/4216b7b7fc844acff542e2840bd4277baa548ef6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181861)) **GitLab Enterprise Edition**
- [Add fix button for Amazon Q quick actions](https://gitlab.com/gitlab-org/gitlab/-/commit/c21ed8abbd8cc93be130505ae2a4edd53c45e92a) by @jlosito ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184055)) **GitLab Enterprise Edition**
- [Added a new vulnerability_namespace_statistics table](https://gitlab.com/gitlab-org/gitlab/-/commit/c6439188ada8e37fc8f651b93000bc1e1b7244b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183131))
- [Add help icon for array types](https://gitlab.com/gitlab-org/gitlab/-/commit/c8ab44586301586c6204c59c143187ed37df7f71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185686))
- [Add endpoint to batch delete todos records](https://gitlab.com/gitlab-org/gitlab/-/commit/e727df8450910e6d53a7806a1df469f9f2ffc4c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184362))
- [Feat: Amazon Q code review button](https://gitlab.com/gitlab-org/gitlab/-/commit/f584b0e6460d2c5ddaf660cba2f9c676459583eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185019)) **GitLab Enterprise Edition**
- [Protected packages: Add minimum_access_level_for_delete to REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/1ae51456277dc246bb22f37c840baf934a0f6704) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180063))
- [Expose contacts_available field for work item CRM contacts widget](https://gitlab.com/gitlab-org/gitlab/-/commit/77c11a4e74fde415c7fcf309310e1016efa8990a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185764))
- [Audit environment_scope changes](https://gitlab.com/gitlab-org/gitlab/-/commit/259f4526e7bcd0a5c2e0212859b549d467dde2fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185253)) **GitLab Enterprise Edition**
- [RequestAccess for non-billable users](https://gitlab.com/gitlab-org/gitlab/-/commit/32a306ce242d5ad73733771a6fda66b3dc009895) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185592)) **GitLab Enterprise Edition**
- [Redirect `/-/u/:id` to user page](https://gitlab.com/gitlab-org/gitlab/-/commit/84c0cfc66919f5bdc0c028f3262798a6eb3475cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185387))
- [Add `project_snippets_view` database view](https://gitlab.com/gitlab-org/gitlab/-/commit/707a1035ebd3bbc871733a4aa7e236a4182cab8a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179452))
- [Support new access token sorting options in the UI](https://gitlab.com/gitlab-org/gitlab/-/commit/f297564d746a31417652d8539e310f0ba6892ed7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184303))
- [Add `personal_snippets_view` database view](https://gitlab.com/gitlab-org/gitlab/-/commit/580a673bb72fbf384e3f669c0aa8e97dbdfe57d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179451))
- [List project control statuses for a requirement](https://gitlab.com/gitlab-org/gitlab/-/commit/fbb55608f9fc822b767708e2f343a139d718d9a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184881)) **GitLab Enterprise Edition**
- [Add a new licenses violation checker for package exclusions](https://gitlab.com/gitlab-org/gitlab/-/commit/9909a20e1807fe4d06286fb32f3df0ab5832c82c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177156)) **GitLab Enterprise Edition**
- [Adds additional context for self-hosted generation](https://gitlab.com/gitlab-org/gitlab/-/commit/2b6c1a2ada36f31f985e2fc3ca25c4bdf9840d32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185263))
- [Implement cronjob to archive vulnerabilities periodically](https://gitlab.com/gitlab-org/gitlab/-/commit/446719210fb0e5c0cd6fa13bb9a4b4aa388971ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185131)) **GitLab Enterprise Edition**
- [Remove the `add_policies_to_ci_job_token` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/da2a9590fef70f8d3d943354152accacc1301f57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185124))
- [Json Import Service for Compliance Frameworks](https://gitlab.com/gitlab-org/gitlab/-/commit/61b6f5013b836bcccd04db7ee8846c1ced125030) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181890)) **GitLab Enterprise Edition**
- [Add Geo rake task for checking tracking DB after promotion](https://gitlab.com/gitlab-org/gitlab/-/commit/e2ac0d6756706e53b9ece6f5bd631ea550b430ab) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184882)) **GitLab Enterprise Edition**
- [Implement `GET /Groups` SCIM endpoint for self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/8e5d3ccf5204ddb5ec34c13bbe3ab974240f1b67) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182371)) **GitLab Enterprise Edition**
- [Add component field to GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/48afb2e05c5557b0ebb3b50e57bdfcc20369b8c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181568)) **GitLab Enterprise Edition**
- [Add ancestor type to GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/4987b990178f755ef2018a892f161f9c34c447af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180747)) **GitLab Enterprise Edition**
- [Add API endpoint to revoke PATs for service accounts](https://gitlab.com/gitlab-org/gitlab/-/commit/f2f46d8c891d6977502aa3c002e7ced7f9038cf5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184287))
- [Add sidebar shortcut, event tracking](https://gitlab.com/gitlab-org/gitlab/-/commit/e50516355eceb44da683e055e3f9f62e887fa3be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184858))
- [Export adherence project statuses report](https://gitlab.com/gitlab-org/gitlab/-/commit/5372718bb8814f2516be194591fe5b45387575de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184762)) **GitLab Enterprise Edition**
- [Show job source in job details](https://gitlab.com/gitlab-org/gitlab/-/commit/8f0e949f30ef4dbe604c7bf8b477b44c971dbea3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184975))
- [Add jobs filter by source](https://gitlab.com/gitlab-org/gitlab/-/commit/57f11b9d0bc898f51696b11ade3b84baac613f15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185028)) **GitLab Enterprise Edition**
- [Added filtering for project requirement compliance statuses](https://gitlab.com/gitlab-org/gitlab/-/commit/ca40912bb1a18d8eecb2e3e1465b6929d75adc7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185135)) **GitLab Enterprise Edition**
- [Add negated filter for component versions](https://gitlab.com/gitlab-org/gitlab/-/commit/f1b959d5225d10e16057e2df9fb0e3d80a8317d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185285)) **GitLab Enterprise Edition**
- [Make field connection type so that we can use pagination](https://gitlab.com/gitlab-org/gitlab/-/commit/9bd97e7678613c31a14acfdf512ffb9772ae5aaa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185178)) **GitLab Enterprise Edition**
- [Add migration issue form](https://gitlab.com/gitlab-org/gitlab/-/commit/986a5333fd91827c7e487405067929dc3a0a9547) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184238))
- [Adds duo workflow to ai_settings](https://gitlab.com/gitlab-org/gitlab/-/commit/e4cfec2c57d6374136d615022714650a335fef01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182894)) **GitLab Enterprise Edition**
- [Update controls in requirement update mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/5bc1c36b0cc2085668ae82f4030abc601613fefa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183476)) **GitLab Enterprise Edition**
- [Add count.admins metric](https://gitlab.com/gitlab-org/gitlab/-/commit/5c70b8bac9102e44b2b44f43c5935b703dd3eeae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184797))
- [Enable extension marketplace by default](https://gitlab.com/gitlab-org/gitlab/-/commit/728255eb752f7eda737a5fb9627946a11f6b1c92) by @pslaughter ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184662))
- [Introduce retention policy alert](https://gitlab.com/gitlab-org/gitlab/-/commit/9a6dacc172e8637eab50dba14f635531203ef197) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184461)) **GitLab Enterprise Edition**
- [Create partitioned table for uploads](https://gitlab.com/gitlab-org/gitlab/-/commit/001e2334b6e1012d6993f703c02a4ef00cf532d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175203))
- [Add inputs banner to pipeline editor](https://gitlab.com/gitlab-org/gitlab/-/commit/092ebe992971dbbbe2ce78c605f377d41e535c46) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185171))
- [Resolve vulnerability using Claude 3.7 Sonnet prompt version](https://gitlab.com/gitlab-org/gitlab/-/commit/a4b46a30a0761a574d93189ecf9e6cb33e676d33) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183607)) **GitLab Enterprise Edition**
- [Add version filtering in project level controller](https://gitlab.com/gitlab-org/gitlab/-/commit/3053dcd4f6b76749aad19f6f340189813e89dce3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184967)) **GitLab Enterprise Edition**
- [ActiveContext migration worker](https://gitlab.com/gitlab-org/gitlab/-/commit/f71823774b908020d978830b589fdb03c7d0c2d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184309))
- [Add inputs to PipelineScheduleUpdate mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/05b695960aaf37fda97c8b35dd6fd2454aadae75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184620))
- [Add CI/CD job token policies switch](https://gitlab.com/gitlab-org/gitlab/-/commit/9a685e0f39eed1fd9fd4fb63f3f7b1fb0cfc8bdc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184516))
- [Remove preload_member_roles from projects resolvers](https://gitlab.com/gitlab-org/gitlab/-/commit/e1a83213ad5e7cd3adc935152e7c2bee037d81a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185045)) **GitLab Enterprise Edition**
- [Add support for organization-wide agent CI authorization](https://gitlab.com/gitlab-org/gitlab/-/commit/fb40299b2c8dde589985a279612c98f3854d0e97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184259))
- [Add pipeline inputs to pipeline schedule](https://gitlab.com/gitlab-org/gitlab/-/commit/2c9ff3fc4442186b7b70723ad680e7736d5f6b06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184698))
- [Update ci schema to support inputs](https://gitlab.com/gitlab-org/gitlab/-/commit/a96cf07705e8b568f12754bd0866cf186ceb2e75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182198))
- [Add `organization_id` code logic to `fork_networks`](https://gitlab.com/gitlab-org/gitlab/-/commit/70ebd734c319b8095ad2419be777bba0eccfa4d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184033))
- [Support sorting params in List package files endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/c78d247c84f7b4fa169760e3d4cd65c309af8f21) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184839))
- [Allow users to input docker hub credentials](https://gitlab.com/gitlab-org/gitlab/-/commit/ccbf4faa4fda1c0327511804b3ec3b9908f88424) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183699))
- [Add notes field to notes work item widget type](https://gitlab.com/gitlab-org/gitlab/-/commit/4c32d7bf9c0dee5045460e9a5a81c2bd33dfdf84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184763))
- [Optimize offsets on Group/Project audit events API](https://gitlab.com/gitlab-org/gitlab/-/commit/031541b13ebf640a867fc787008d1f0f65a2a2fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182031)) **GitLab Enterprise Edition**
- [Add Import usage tab to group usage quotas](https://gitlab.com/gitlab-org/gitlab/-/commit/a53e4aa997b409ed7a0b68162979801934139cea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184500))
- [Add rotate and admin_token_api events with namespace metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/8f47b11957f674c9f8ce27256861c1c745e14100) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184008))
- [Add GraphQL mutation to delete custom admin roles](https://gitlab.com/gitlab-org/gitlab/-/commit/080133fff86c086efe9aa453506355e635e93fab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182217)) **GitLab Enterprise Edition**
- [Add the ability filter by versions](https://gitlab.com/gitlab-org/gitlab/-/commit/719aefc0e3c4a7bc9fb4405c6ffb0cf094b99ef2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184738)) **GitLab Enterprise Edition**

### Fixed (132 changes)

- [Update signatures also for gpg key fingerprints](https://gitlab.com/gitlab-org/gitlab/-/commit/698545e0f359d47d62fa7b3a3e309b26a6c06ae2) by @filipmoc ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182738))
- [Clear session cookie when browser is closed](https://gitlab.com/gitlab-org/gitlab/-/commit/f09c3096e347e7d01a454255a77f814b23109ec9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187882))
- [Fix CI inputs conversion](https://gitlab.com/gitlab-org/gitlab/-/commit/3ebeeb9d293d96ff7cc804baede20bcf4de80aeb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187711))
- [Zoekt: Fix last_rollout_failed_at usage](https://gitlab.com/gitlab-org/gitlab/-/commit/b8f04cafd5f321c866b37e8b3d8cc8d078a598b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187853)) **GitLab Enterprise Edition**
- [Set the MR to unchecked when updating target branch](https://gitlab.com/gitlab-org/gitlab/-/commit/769f38d8500fd685faeb166d427340338d502e66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187249))
- [Fix 500 in Todo API when wiki page todo exists](https://gitlab.com/gitlab-org/gitlab/-/commit/ade00a12203e8d84bf5349aa69ac52724a4db4c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186933))
- [Create progress note for DCR and handle errors better](https://gitlab.com/gitlab-org/gitlab/-/commit/0936eaf0383e732141089f106f3503097cf4ee3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186920)) **GitLab Enterprise Edition**
- [Fix filtering pipelines by merge request branch name](https://gitlab.com/gitlab-org/gitlab/-/commit/1b70e6715e817c185a881f54696324ae6783dffb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187548))
- [Enforce scrollbar on body](https://gitlab.com/gitlab-org/gitlab/-/commit/64f197a0caa2bda54d05c468642242f83557e1be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186498))
- [Fix how title changed system notes rendered](https://gitlab.com/gitlab-org/gitlab/-/commit/7e0459b2a85b509ba5be97b1f1d65447c5ecc6c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187028))
- [Fixed access level statement inviting members to a project or group](https://gitlab.com/gitlab-org/gitlab/-/commit/8cbd72f12c3d5ba4f6614311b3d271ba9c016d82) by @zillemarco ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186837))
- [Safari-specific container query fixes for work items](https://gitlab.com/gitlab-org/gitlab/-/commit/be0a4d0979d034d09fa80afe186e580dca29cbcd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187607))
- [Hide unsupported WI relationship types on free tier](https://gitlab.com/gitlab-org/gitlab/-/commit/19fa0b0f87f056684fae158e7baba0605f56e459) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181481))
- [Check block seat overages during group access request approval](https://gitlab.com/gitlab-org/gitlab/-/commit/c9f4712967f2711bd7e5f84c6d3f2a4c44a31e5b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187266)) **GitLab Enterprise Edition**
- [Fix bug when secrets provider URL given in dotenv](https://gitlab.com/gitlab-org/gitlab/-/commit/e0301d2011d97a5239a6c1934dd650807a23e321) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186617)) **GitLab Enterprise Edition**
- [Include reserved refs in pipeline branch searches](https://gitlab.com/gitlab-org/gitlab/-/commit/f24efc9793f5312fd5ab842c19a0c165f89a4ce3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186590))
- [Preserve ReAct steps in Duo Chat history](https://gitlab.com/gitlab-org/gitlab/-/commit/879066eaafb9a989ad8ca26e97602db7f40e47ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178730)) **GitLab Enterprise Edition**
- [Add project to work item MRs](https://gitlab.com/gitlab-org/gitlab/-/commit/00cb26df89cb07a55eea32ddc8961c5c38a92917) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187044))
- [Show current namespace name in create work item form](https://gitlab.com/gitlab-org/gitlab/-/commit/d27084fc9439215a088824841dbca7900342bf96) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187406))
- [Fix license widget classification](https://gitlab.com/gitlab-org/gitlab/-/commit/7520137ba854217cf9276939de183d146b5a575b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186750)) **GitLab Enterprise Edition**
- [Ensure scan execution policy respects skip_ci for scheduled scans](https://gitlab.com/gitlab-org/gitlab/-/commit/4ec63defd7a44d124556b6ac878a55ea390ed4a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187172)) **GitLab Enterprise Edition**
- [Return the empty result of project is not available for zoekt search](https://gitlab.com/gitlab-org/gitlab/-/commit/6f4e03bf29c987eddeff4e8c7fd78db5d1efaac6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185228)) **GitLab Enterprise Edition**
- [Use case-insensitive comparison for commit SHAs](https://gitlab.com/gitlab-org/gitlab/-/commit/6b18d335ff9872e0c2499c066768fd6ce6c7b86e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187301))
- [Handle errors when smartcard user not found on LDAP server](https://gitlab.com/gitlab-org/gitlab/-/commit/8599551d7a5c8fbfc1f889ecf443f7bbb98f927c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186337)) **GitLab Enterprise Edition**
- [Disable filter shortcut on file browser](https://gitlab.com/gitlab-org/gitlab/-/commit/57b2ab7647423a6084d2fc85c115d0a4a08485e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187284))
- [Stop throwing exceptions when the discussion diff is broken](https://gitlab.com/gitlab-org/gitlab/-/commit/959849ade970c627ac1d4f93be422f383cdba7bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187239))
- [Support `type` param on new incidents page for Work Items](https://gitlab.com/gitlab-org/gitlab/-/commit/0540b46e21097829d7821b965ca941d9c4822ced) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187241))
- [Show current work item assignees for `/unassign`](https://gitlab.com/gitlab-org/gitlab/-/commit/107c3701b35d0e3977ae49bd8b16cb347e2772df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187225))
- [Move notification trigger to list item](https://gitlab.com/gitlab-org/gitlab/-/commit/a98b05916aa501c232ea8417f315bba881dc834c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187215))
- [Fix removal of policies which have reached limits](https://gitlab.com/gitlab-org/gitlab/-/commit/8548b54245c5ff231134aa1af19c02b97e8a1220) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186801)) **GitLab Enterprise Edition**
- [Prevent invalid tokens from falling back to Git password auth](https://gitlab.com/gitlab-org/gitlab/-/commit/d6e67842e926a962e806345a04c8c2bff3ac5229) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185987))
- [Use cached values of Ci::Runner#creation_state](https://gitlab.com/gitlab-org/gitlab/-/commit/87ef321333d685cdfb44673c1495082842351a42) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187153))
- [Fix ActiveRecord::QueryCanceled in RelatedPipelinesFinder](https://gitlab.com/gitlab-org/gitlab/-/commit/54fc2a36d40012e5aab678bc76c00cbcb5a8d1d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183553)) **GitLab Enterprise Edition**
- [Fix broken regex in flaky tests for funnels](https://gitlab.com/gitlab-org/gitlab/-/commit/f74aff2d062014f8d60ced97bd9e194312ed2022) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187148)) **GitLab Enterprise Edition**
- [Allow empty code suggestion in RTE](https://gitlab.com/gitlab-org/gitlab/-/commit/3838f56b1a57b39001e1ba5611bc947d13c464be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187142))
- [Fix setCurrentDiffFileIdFromNote not returning Promise](https://gitlab.com/gitlab-org/gitlab/-/commit/aed7eda6342fca7d5cf28f60b555436ff74a04ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187138))
- [Take a more declarative/dependency injection path for trial alert](https://gitlab.com/gitlab-org/gitlab/-/commit/846164dc0218fcd53e85e50e6441303b862e2dda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186889)) **GitLab Enterprise Edition**
- [Use a more universal selector for initQuickSubmit](https://gitlab.com/gitlab-org/gitlab/-/commit/a545da637312a1a01f017a5cd487d9417c262560) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183365))
- [Override restrict_user_defined_variables](https://gitlab.com/gitlab-org/gitlab/-/commit/38b98d37827aa7c952afa2291e54df275fdc932c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185458))
- [Fix SCIM group sync when externalId is missing](https://gitlab.com/gitlab-org/gitlab/-/commit/21641747ce6fcf824377ba069b306a7ea5de5d19) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186715)) **GitLab Enterprise Edition**
- [Fix loading reference error in YAML editor](https://gitlab.com/gitlab-org/gitlab/-/commit/d534ff91d8ac65bc53eb211b6f981b4f91a02836) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187108)) **GitLab Enterprise Edition**
- [Fix ProjectsRelationBuilder to preload member roles for projects API](https://gitlab.com/gitlab-org/gitlab/-/commit/b6847c901028d43b03e64902fd58954fac6b6e99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183477))
- [Fix the GitLab import button on the user registration process](https://gitlab.com/gitlab-org/gitlab/-/commit/e228f5dd6ee275210bcb4394fd1d6519c852f2e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186901)) **GitLab Enterprise Edition**
- [Ensure files are deleted from storage alongside dependency list exports](https://gitlab.com/gitlab-org/gitlab/-/commit/33e9a2c0c11c5c77484d5bb43ad5d79636d29e90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186998)) **GitLab Enterprise Edition**
- [Update approval_project_rule name validation to include approval policy](https://gitlab.com/gitlab-org/gitlab/-/commit/138a68cedb4c9516766cab4976628065738f9f71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186114)) **GitLab Enterprise Edition**
- [Fix string interpolation in MR discussion filter](https://gitlab.com/gitlab-org/gitlab/-/commit/fb5b19e62448ba524e52bfe95f1d3f43ce8a0497) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186942))
- [Fix bug in remember_me_available? helper](https://gitlab.com/gitlab-org/gitlab/-/commit/aa9d366b84dd48a81cbc43d7f97f97218875ebf8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186882))
- [Bulk indexing cron workers should respect pause setting](https://gitlab.com/gitlab-org/gitlab/-/commit/e35165b543e22c48c4e8941ec502bf13f95a4356) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186885)) **GitLab Enterprise Edition**
- [Do not try to access root ancestor if project is not under a group](https://gitlab.com/gitlab-org/gitlab/-/commit/8532473ef8ea3c7350b794b680a4981440d41eb9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186877)) **GitLab Enterprise Edition**
- [Pluralize bulk_import_csv mailer text](https://gitlab.com/gitlab-org/gitlab/-/commit/51d704cb9fe0a47430e7846ed05d6b0e79744712) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184976))
- [Fix behavior of merged MR widget](https://gitlab.com/gitlab-org/gitlab/-/commit/75f741e675ed6e48d12c151a999749add6bd95d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186844))
- [Fix Duo Code Review failures when SAML SSO is enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/e90c41e6c81431af61b9a00b03457c7a2638b670) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186071)) **GitLab Enterprise Edition**
- [Fix N+1 queries in Linked Items widget](https://gitlab.com/gitlab-org/gitlab/-/commit/12b312e9809e5a00e6d1293caf485521143f1b13) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186076)) **GitLab Enterprise Edition**
- [Fix NoMethodError in IdentityVerifable](https://gitlab.com/gitlab-org/gitlab/-/commit/98fa85a6eaf3acabe9edec153fdb2da7be542a61) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186467)) **GitLab Enterprise Edition**
- [Update mr widget to consider cyclonedx artifacts](https://gitlab.com/gitlab-org/gitlab/-/commit/eeb294e06b6cff3faada41365fd0b9dc6ddcae50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186603)) **GitLab Enterprise Edition**
- [Properly fetch assigned Duo users for self-managed instances](https://gitlab.com/gitlab-org/gitlab/-/commit/c05331954bf9b1ea43798f63166885fa2dde65ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186712)) **GitLab Enterprise Edition**
- [Add line type to Duo Code Review input and handle chunk headers](https://gitlab.com/gitlab-org/gitlab/-/commit/4f3ed69d2f264d631924ad4b15946f1cb37049e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186517)) **GitLab Enterprise Edition**
- [Fix ANSI color parsing and add specs](https://gitlab.com/gitlab-org/gitlab/-/commit/285bd10383c65ea3ec2ccf4d44d0d695e4754bad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186625))
- [Fix 2 flaky tests](https://gitlab.com/gitlab-org/gitlab/-/commit/88f35c3c6b0b36369618442827b04895aba5f6ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186609))
- [Prevent negative number entry in CI/CD admin limit inputs](https://gitlab.com/gitlab-org/gitlab/-/commit/97dd57ecf17030d5019cc6636716c644d2ecd63e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186594))
- [Support AWS assume roles in Advanced search](https://gitlab.com/gitlab-org/gitlab/-/commit/5dcc8e2a5bab32956488435c4bbda71454fa0898) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185877)) **GitLab Enterprise Edition**
- [Fix accessibility of pipeline labels](https://gitlab.com/gitlab-org/gitlab/-/commit/797b04242409449e31a852916af0b26e81decb49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186486))
- [Fix troubleshoot_job policy](https://gitlab.com/gitlab-org/gitlab/-/commit/797610d3dfe1e3262910a0e18d29b29438d0c5a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186059)) **GitLab Enterprise Edition**
- [Fix 'Connect a cluster' button at group level](https://gitlab.com/gitlab-org/gitlab/-/commit/62192f2c3e214d54b2e21559f9f493d85ff682f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186168))
- [Pre-authorize work items children field](https://gitlab.com/gitlab-org/gitlab/-/commit/9170449b6d2560e806a4e430154ae9c3944ccd89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182556))
- [Increase max packages limit for bulk destroy mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/37a76cc68c6bd136561a9551d32fc600ac748a73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186494))
- [Fix: Omit null fields in CycloneDX export](https://gitlab.com/gitlab-org/gitlab/-/commit/20e900b824824a6da90877bb5d021174c1e7ae8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182147))
- [Optimize SAML SSO session filtering in GroupsFinder](https://gitlab.com/gitlab-org/gitlab/-/commit/5e89fa606e290e1f100b476ee2d0dc4143165ffd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185382)) **GitLab Enterprise Edition**
- [Fix encoding for patch and diff responses](https://gitlab.com/gitlab-org/gitlab/-/commit/23c4ebac9acf007d19bc38c050d5ed682d01a9c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186437))
- [Remove wrongly displayed line for Free Namespaces](https://gitlab.com/gitlab-org/gitlab/-/commit/fe069d924f10ccd229282eab1ccc5465bfe9ac42) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186425)) **GitLab Enterprise Edition**
- [Delete duplicate CI taggings in gitlab:db:deduplicate_tags](https://gitlab.com/gitlab-org/gitlab/-/commit/6dc2877c43aa0f42bc84813d2f2158334c5bc9d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186131))
- [Move group.cluster_agents field to CE](https://gitlab.com/gitlab-org/gitlab/-/commit/02401a4d60084abea5143a08554388aca42c2be6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186395)) **GitLab Enterprise Edition**
- [Fix auditing when same status is updated](https://gitlab.com/gitlab-org/gitlab/-/commit/9ca05f244185f382108299a3b3584669a960311c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186389)) **GitLab Enterprise Edition**
- [Fix pipelines mini graph separator](https://gitlab.com/gitlab-org/gitlab/-/commit/3400906915d963ab19e4b6b0bd26d1439a1d979f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186367))
- [Work item due dates ce and ee version](https://gitlab.com/gitlab-org/gitlab/-/commit/2c092b63c3a4c47291892c050d38abc2c20c02bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185719)) **GitLab Enterprise Edition**
- [Avoid possible project authorization race condtions on project create](https://gitlab.com/gitlab-org/gitlab/-/commit/b264b307b26ce712bed6c168681215263b269a02) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185330))
- [Add job source options](https://gitlab.com/gitlab-org/gitlab/-/commit/a607e65dd4862e8385e37d14cc415db8220eba23) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186173)) **GitLab Enterprise Edition**
- [Update style of top bar search and fix a11y concern](https://gitlab.com/gitlab-org/gitlab/-/commit/3d4a3f40dc6878b9cfc9d04d04cbdc9fe7faba56) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186144))
- [Allow user to use keyboard to access pipeline job status tags](https://gitlab.com/gitlab-org/gitlab/-/commit/dc3f9eb6560bdd97375e7742594ee209fbfb8194) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185977))
- [Normalize pm_affected_packages package_name](https://gitlab.com/gitlab-org/gitlab/-/commit/41957a4a01238186c75758bcc8d6b447522a6090) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183732))
- [Return merge request count for non hidden users only](https://gitlab.com/gitlab-org/gitlab/-/commit/df4f76326d45708dab959565b879a887a6d17392) by @dagaranupam ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186177))
- [Ensure runner taggings are copied from taggings](https://gitlab.com/gitlab-org/gitlab/-/commit/c3282be1cb39693edd161659dd98ca45e047146e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186236))
- [Drop unwanted sequence on foreign key project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/550b92e65897756295b29f454dcc5324960c2a9a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186242))
- [Adjust work item create loading top margin](https://gitlab.com/gitlab-org/gitlab/-/commit/f01244527c7877f2227f6f9d583a501f6d3807ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186181))
- [Fix free push limit on non-saas](https://gitlab.com/gitlab-org/gitlab/-/commit/81a966fdae23daeb661bcc8bafe37b2e8f86c814) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186122))
- [Fix invalid pipelines for scan execution policies](https://gitlab.com/gitlab-org/gitlab/-/commit/811fad03fff1d00fe8c8d02f9e1761827c5fbb53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185861)) **GitLab Enterprise Edition**
- [Send lowercase Cloud Connector HTTP headers](https://gitlab.com/gitlab-org/gitlab/-/commit/21a9d9690b8494c80e53fa7f3303323487914a8a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185072)) **GitLab Enterprise Edition**
- [Mark License Usage Banner as Dismissable After API Export](https://gitlab.com/gitlab-org/gitlab/-/commit/11be46bb3331f34e61ae6896511b209e37de3662) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185792)) **GitLab Enterprise Edition**
- [Ensure new epic route has a title](https://gitlab.com/gitlab-org/gitlab/-/commit/3b623c03894bb051b54a74576b6c5e63ce9a125c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185701)) **GitLab Enterprise Edition**
- [Fix analytics dashboard editor confirm prompt](https://gitlab.com/gitlab-org/gitlab/-/commit/e053ca3d28537b298f7ab06c2f1f65a27a7af7b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185833)) **GitLab Enterprise Edition**
- [Configure first day of week according to user preferences](https://gitlab.com/gitlab-org/gitlab/-/commit/3fa16d77233e511583e03e15ef0087d9e542c91c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186104))
- [Apply group/project access token rotation logic to project_bot only](https://gitlab.com/gitlab-org/gitlab/-/commit/c90f8bde21946fef126891e2dd4404151f1935c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185462))
- [Apply labels from quick actions and widget sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/c3fbd903697bf76389a5352921d222933205e98f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186074))
- [Remove the rebase_sha != newrev check](https://gitlab.com/gitlab-org/gitlab/-/commit/cfbe13d5b347858beb05d2e3d2fa8627e40ca5b9) ([merge request](gitlab.com/gitlab-org/gitlab/-/merge_requests/184558)) **GitLab Enterprise Edition**
- [Ensure current user is first to appear in assignee list if assigned](https://gitlab.com/gitlab-org/gitlab/-/commit/debf918b2bf7205ac4d72909bae390191fe91d28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186015))
- [Fix missing autocompletes for work item comments](https://gitlab.com/gitlab-org/gitlab/-/commit/f144f10554b329c16138fbf1dcf927cea9b20910) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185685))
- [Reset pagination when changing todos filters](https://gitlab.com/gitlab-org/gitlab/-/commit/bbed22002b8fd5448ffacb8eca7746c99be61c92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185817))
- [Remove unknown license insertion](https://gitlab.com/gitlab-org/gitlab/-/commit/103e4e780d131a7aff8dc5369526657f8a325379) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185163)) **GitLab Enterprise Edition**
- [Init conversion of terraform modules metadata semver to bigint](https://gitlab.com/gitlab-org/gitlab/-/commit/20d12cea8ffc69f25d720bb7a2a7dcdc2a341ed9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185252))
- [Correctly set archive for the archived records](https://gitlab.com/gitlab-org/gitlab/-/commit/226ad569cebe826888defeaa6aacf647e941f3b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185774)) **GitLab Enterprise Edition**
- [Fix handling of HTTP 500 errors in Geo GraphQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/a9f12cf445f7434a07b7751031fada9750d8bd55) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185506)) **GitLab Enterprise Edition**
- [Fix handling for current controls](https://gitlab.com/gitlab-org/gitlab/-/commit/a54bbce0fe64b113bacc1beb7100fc5e92bfd6ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185546)) **GitLab Enterprise Edition**
- [Retain existing page params while using design version dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/09edeeaad36cc872f434f4da72be7d5d30cc927a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185700))
- [Use semantic h3 for subscription table row title](https://gitlab.com/gitlab-org/gitlab/-/commit/ef72287637935d65b1f0eb515128a67c47baca2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185339)) **GitLab Enterprise Edition**
- [Fix drag handles on work items loaded outside issue view](https://gitlab.com/gitlab-org/gitlab/-/commit/88fe04d5e722be64e286a8890625a7b0604da356) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185688))
- [Send only required fields to protected environment](https://gitlab.com/gitlab-org/gitlab/-/commit/c0b99b2b6513280f71429f725335c65878a03327) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185613))
- [Fix partitioned uploads table FK on projects](https://gitlab.com/gitlab-org/gitlab/-/commit/9a9fb6740cb228357018e11f91fbe6ea570bfe53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185596))
- [Return success when pending promotions fails if user is billable](https://gitlab.com/gitlab-org/gitlab/-/commit/6ab29a04de252cd0ebfc0ac36d3b80a341d1befb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184894)) **GitLab Enterprise Edition**
- [Fix notification settings for Epic notifications](https://gitlab.com/gitlab-org/gitlab/-/commit/066c0acee523f2936fb3f1ca4a6ce48176c15f7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185572)) **GitLab Enterprise Edition**
- [Fix issue when empty plans sorting to of terraform reports widget in MRs](https://gitlab.com/gitlab-org/gitlab/-/commit/5cb7b1f371be184f1a05674d8a7bacf7b893a2e8) by @BageDevimo ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185044))
- [Account for design note paths](https://gitlab.com/gitlab-org/gitlab/-/commit/1e3c4b04c2d600511fee131983a4ff6c777dae08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185119))
- [Replace HTML entities with normal characters](https://gitlab.com/gitlab-org/gitlab/-/commit/b16bee6fc88f570e9f275c22ae6ae0bca3e4a39e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185446))
- [Add pipeline syntax check when publish and pages.publish both specified](https://gitlab.com/gitlab-org/gitlab/-/commit/5661b37e5227bc95812e2162bc74a317dcf99f2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184878))
- [Enables full screen in create work item](https://gitlab.com/gitlab-org/gitlab/-/commit/6209c7076cbe62e374303d693f26b58d85c7e497) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185352))
- [Retain drawer params while switching design versions](https://gitlab.com/gitlab-org/gitlab/-/commit/0e54fdef6597fa4358ef3979f863b95fd58c5cfb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185321))
- [Truncate name in `namespace_metadata` panel](https://gitlab.com/gitlab-org/gitlab/-/commit/c24011b4479a2a23b92d9aea21fdde1ab28c5ef6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184831)) **GitLab Enterprise Edition**
- [Fix lookup of find_diff_start_pipeline_with_security_reports](https://gitlab.com/gitlab-org/gitlab/-/commit/7575f70a715c707753f0cf9692c5344c3c34a625) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185162)) **GitLab Enterprise Edition**
- [Add a11y labels to star, fork, MR and issue links on vue project list](https://gitlab.com/gitlab-org/gitlab/-/commit/dd0221bf14f6509db41577a9543dd54ee3beef2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184503))
- [Don't add duplicate emojis to emoji cache](https://gitlab.com/gitlab-org/gitlab/-/commit/fa319c125f4240e45486f35d9202b02670a43516) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184999))
- [Adjust prompt_version for summarize_new_merge_request](https://gitlab.com/gitlab-org/gitlab/-/commit/90e7bcf64a4091a7967931ea6ce086e4c742b8e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184818)) **GitLab Enterprise Edition**
- [Fix award emoji policy for group-level work items](https://gitlab.com/gitlab-org/gitlab/-/commit/f8af9621f79e6390f33b5acd5614533ae05b3a39) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185098)) **GitLab Enterprise Edition**
- [Fix gitattributes parser to apply patterns to subdirectories](https://gitlab.com/gitlab-org/gitlab/-/commit/c51af4068f732677989e071d47298d8ba0cb9785) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178281))
- [Fix bug in Mutation.ciJobTokenScopeRemoveProject](https://gitlab.com/gitlab-org/gitlab/-/commit/f9019e30584bbe69d873260286ed453738275cb6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185080))
- [Fix end date filter in global time tracking report](https://gitlab.com/gitlab-org/gitlab/-/commit/d9f3c08324b3628e9aa8861d28952253a89dd4d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185057))
- [Ignore pending member in Direct Transfer member pipeline](https://gitlab.com/gitlab-org/gitlab/-/commit/45a28f3e3b6e3016ce58a750273a1e0aa73bbc8a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184360))
- [Avoid unrelated items from affecting finishing onboarding](https://gitlab.com/gitlab-org/gitlab/-/commit/926d3444800ac96725f92f07d73b121731144b6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184949)) **GitLab Enterprise Edition**
- [Removes ordering requirement for funnel sync test](https://gitlab.com/gitlab-org/gitlab/-/commit/dda230ffb3171954739c071bcdb6e221852db17e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184956))
- [Detect organization_id change to be synced in project callback](https://gitlab.com/gitlab-org/gitlab/-/commit/20d7eeee84a1c2bafe77d96104091d5b513be0bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184892))
- [Update docs to shoe private incident comments could be public](https://gitlab.com/gitlab-org/gitlab/-/commit/d4fd821c30682a46fd10208bfa528ed78885f6d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184902))
- [Use source repository storage for forking process](https://gitlab.com/gitlab-org/gitlab/-/commit/0a1c67c212ca2e9558d5d09675011798ea2dce4f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183992))
- [Tags::CreateService: add a handler for NoRepository exception](https://gitlab.com/gitlab-org/gitlab/-/commit/0c5c735956eb2d057bcf218d8d63ad7752b8e71b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184759))
- [Show "Copy to clipboard" button in snippet descriptions](https://gitlab.com/gitlab-org/gitlab/-/commit/fefd83246978f5fd851521430aef3ae6198ef761) by @puxlit ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184752))

### Changed (195 changes)

- [Display /new command in suggested slash commands](https://gitlab.com/gitlab-org/gitlab/-/commit/790045dd3de20ea82afebef6d7b8c62fcf4e5d07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178832)) **GitLab Enterprise Edition**
- [Show correct http error when accessing security policies](https://gitlab.com/gitlab-org/gitlab/-/commit/e4d66ab8f18d9d8919f7b23f3947c603a676d395) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186683)) **GitLab Enterprise Edition**
- [Update astro project template and move to pages/astro](https://gitlab.com/gitlab-org/gitlab/-/commit/47db86f29f718b3340db3ea1c4bdfe154dc519c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187661))
- [Always show new thread when opening Duo Chat](https://gitlab.com/gitlab-org/gitlab/-/commit/2f4b128f09b29070f0d6d7a10f89afd3413452d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186984)) **GitLab Enterprise Edition**
- [Stores instance ai logging config to database](https://gitlab.com/gitlab-org/gitlab/-/commit/305feb6657d58bea2f6ca389a1e56b6dbea91965) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186678))
- [Remove project_authorizations_update_in_background feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/ff0c7161ac3ecfbc93072ae88bfe8c7d54734461) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187762))
- [Clarify access to PEP configuration when using $CI_JOB_TOKEN](https://gitlab.com/gitlab-org/gitlab/-/commit/1f0c8dc20f127c816acf07792a48d8bfc3b38eae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187712))
- [Remove seat assignment not null constraint](https://gitlab.com/gitlab-org/gitlab/-/commit/ed0737d0b1ba8ee8a7753e793e3bb73d6782af21) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185599))
- [Cleanup feature flags for vulnerability export](https://gitlab.com/gitlab-org/gitlab/-/commit/310f92c08fa801a188f48c79e29fc8cb34bf51c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187285))
- [ActiveContext: allow ref to define unique identifier](https://gitlab.com/gitlab-org/gitlab/-/commit/0261da0ddf338deaaa281adf5447a5b763d4799c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186986))
- [Project runner settings: Simplify group runner crud](https://gitlab.com/gitlab-org/gitlab/-/commit/f61a3914183c9f011f412a2b66a0ad046507a5d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187288))
- [Swap ordering of Self-hosted Duo tabs](https://gitlab.com/gitlab-org/gitlab/-/commit/7e9e3a185cb238fe6b7383a2685b6cb7bc20ed71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187660)) **GitLab Enterprise Edition**
- [Remove default value from topics sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/a587d594eebaf00e5e4bb0260d0215e169027d5b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186103))
- [Replace FK with LFK on lfs_object_states](https://gitlab.com/gitlab-org/gitlab/-/commit/9530f041a08c495e38596ac69fdb74191bae71c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186760))
- [Set product_usage_data FF enabled by default](https://gitlab.com/gitlab-org/gitlab/-/commit/a0cdd23e493a681c9169c18e22d3cd8e44998885) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187634))
- [Add modal when importing to personal namespace](https://gitlab.com/gitlab-org/gitlab/-/commit/77a5687b2ec5d8d991171dfaad0638c1c28f22ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186830))
- [Update search bar width and button text](https://gitlab.com/gitlab-org/gitlab/-/commit/7185a4f1b809818149821470a9bf4a84808083a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186593))
- [Keep selected labels in the list in the labels selector](https://gitlab.com/gitlab-org/gitlab/-/commit/77787e06587afdf493c32f769a9edbf3f37f4584) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186850))
- [Add created and update design events to contribution calendar](https://gitlab.com/gitlab-org/gitlab/-/commit/4373738d449042724b371ce76d0883eb23cac9d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186011))
- [Update PAT logic for tokens with expiry beyond 1 year](https://gitlab.com/gitlab-org/gitlab/-/commit/513bea2e8f5a3a8a3b1e236371e0d6a3641d6fda) by @guptapratibha26 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186314))
- [Add reachability into vulnerability list](https://gitlab.com/gitlab-org/gitlab/-/commit/181438c8e68ff1f8c399cb35834ab818db6ca21e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186879)) **GitLab Enterprise Edition**
- [Convert commands to filter in search modal](https://gitlab.com/gitlab-org/gitlab/-/commit/7b37714228af40808abb2d3f589f020fc48e234e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186580))
- [Update issue popover to include start–due date range](https://gitlab.com/gitlab-org/gitlab/-/commit/28f6772fa568a6e4fb2fbee2fd4367019e22521c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187010))
- [CI/CD Variables: Migrate masked value to dots](https://gitlab.com/gitlab-org/gitlab/-/commit/2f9ae7a444b6d6be2c0b77756a87031588a2f639) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187504))
- [Set security_policy_id to compliance_framework_security_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/0e14966b6b13979ee6fe224c7c6ca5997d7c6c2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186019)) **GitLab Enterprise Edition**
- [Compliance status report style tweaks](https://gitlab.com/gitlab-org/gitlab/-/commit/180055ad6d6629e5f9b6f6e92199bac69a48af23) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187490)) **GitLab Enterprise Edition**
- [Remove small or medium entries from Migration/UpdateLargeTable list](https://gitlab.com/gitlab-org/gitlab/-/commit/8123975b52a4916dc48b5645ec25e651034f14b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187428))
- [Create new Geo verification state table for Terraform::StateVersion](https://gitlab.com/gitlab-org/gitlab/-/commit/3a2605ea24dccd4a1e1539f8d03909fb4a6fbcc6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182457)) **GitLab Enterprise Edition**
- [Fix the placement of rca troubleshoot button](https://gitlab.com/gitlab-org/gitlab/-/commit/78f81b2ea0946bc12248fb57d504ef9d7bc0bd76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185364))
- [Change sidekiq queueing related duration logic](https://gitlab.com/gitlab-org/gitlab/-/commit/5a17a56105842065a139f77bf7383146b4b28ea1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186982))
- [Project runner page: Migrate to Vue](https://gitlab.com/gitlab-org/gitlab/-/commit/93a610b2de09a3bec37691b60f67f16988da0c90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186963))
- [fix: Updated Amazon Q error message note](https://gitlab.com/gitlab-org/gitlab/-/commit/cd080fc8c16df008d6452c142dc338491add44cd) by @protsivd ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186992)) **GitLab Enterprise Edition**
- [Update Code Generation to Claude 3.7 Sonnet](https://gitlab.com/gitlab-org/gitlab/-/commit/bf7caddbb7d419f02f0b1174ad5a32bb5dbb6010) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184335)) **GitLab Enterprise Edition**
- [Update compliance status report content](https://gitlab.com/gitlab-org/gitlab/-/commit/2fbf31072b291aa224cfd06dbc4dc1f59da03167) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187254)) **GitLab Enterprise Edition**
- [Set vulnerability_report_type_scanner_filter to default enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/81347c2e0f967e4a80497c8118ebe3e37a07e4ac) ([merge request](!187121)) **GitLab Enterprise Edition**
- [Removes organization_id default value](https://gitlab.com/gitlab-org/gitlab/-/commit/f26b98f7e1aa0a9207032bc852e4064c2f94fce2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186274))
- [Implement better rendering of compliance dashboard side drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/ec8da87c2616edad501c10443a6c86e6df813c13) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187282)) **GitLab Enterprise Edition**
- [Pipeline header: Migrate to use shared PageHeading component](https://gitlab.com/gitlab-org/gitlab/-/commit/f3e5846b877df9a467184619c6a5fa1fe873abb2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187283))
- [Default enable generate_commit_message_claude_3_7](https://gitlab.com/gitlab-org/gitlab/-/commit/ac83517c337ee78f5df5dde13f73e057f5177ee1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187240)) **GitLab Enterprise Edition**
- [Default enable duo_code_review_claude_3_7_sonnet](https://gitlab.com/gitlab-org/gitlab/-/commit/c9fcfd735133cc05651dc5a42b39278eb148fb5d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187237)) **GitLab Enterprise Edition**
- [Add last_used_at attribute to SSHKey API entity](https://gitlab.com/gitlab-org/gitlab/-/commit/ef5bdaad7cb08a5a19fa3d0d66dabca45b03100b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187229))
- [Add skip ci configuration to default policy](https://gitlab.com/gitlab-org/gitlab/-/commit/f73ada4ba8ef35e18de2bbe4204eb6ac953d392e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186088)) **GitLab Enterprise Edition**
- [Remove security_policy_bot_worker feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/667fc2a68a1faab954fc06da8aa756e9f1783242) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186137)) **GitLab Enterprise Edition**
- [Limit scan execution policy schedule `actions`](https://gitlab.com/gitlab-org/gitlab/-/commit/bde3e26038edb2dd2e4b199f37eca9b8f9ea0b44) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186864)) **GitLab Enterprise Edition**
- [Map source ghost users to destination ghost users in importers](https://gitlab.com/gitlab-org/gitlab/-/commit/bf76e9d2178fe9e894ec0026303f6ea7ad34b8c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186788))
- [Runner page: Update assigned projects](https://gitlab.com/gitlab-org/gitlab/-/commit/7d1d6c653ac3c64c088d29dfd4086dd3e35d5ed5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186842))
- [Improve the text so that the message is clearer](https://gitlab.com/gitlab-org/gitlab/-/commit/8c2b1d03bc8e7b37feb648b30ac4ec568c583caf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185641)) **GitLab Enterprise Edition**
- [Add ES filters for vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/a9afa02e5e8a4c48d6452f4ba04ddd813fc23680) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184888)) **GitLab Enterprise Edition**
- [Compliance style tweaks](https://gitlab.com/gitlab-org/gitlab/-/commit/f59956335d8f1bdba04f0e3390d98578b378cea3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186767)) **GitLab Enterprise Edition**
- [Rename main plan to base product in namespace provision API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/f0b07dea7ce729424323a4731a7dd04858cb235a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186978)) **GitLab Enterprise Edition**
- [Refactor SPP scan prechecks into PreconditionValidator class](https://gitlab.com/gitlab-org/gitlab/-/commit/ff486e999afd0564a1a3a4ab5ebbc0a67a5e74a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183432))
- [Add Live Trace Application Setting](https://gitlab.com/gitlab-org/gitlab/-/commit/c1c3868fb552d4cbd1c8b8c9ade9ef85e94cfa9e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186182))
- [Updates to subscription cards](https://gitlab.com/gitlab-org/gitlab/-/commit/722360a66752b6c0f88ea1c286f63d0179266d0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186033)) **GitLab Enterprise Edition**
- [Update location tooltip in the dependency page](https://gitlab.com/gitlab-org/gitlab/-/commit/c7db66d4677c208267b21fcd764a46fb82855c72) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186311)) **GitLab Enterprise Edition**
- [Limit scan execution policy pipeline `actions`](https://gitlab.com/gitlab-org/gitlab/-/commit/541e47271b36676b2dd96f157286a4e9d7266fcc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186854)) **GitLab Enterprise Edition**
- [Render Markdown in Pipeline Variable descriptions](https://gitlab.com/gitlab-org/gitlab/-/commit/2be99a1250ef09ac4e86054f7a5a5f0b34837787) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183823))
- [Add polling to last commit](https://gitlab.com/gitlab-org/gitlab/-/commit/156b03050e9284db828ba5ba01ecfcba5addbaa6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186888))
- [Expose expected archival date of vulnerability on GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/79dd3a18c1da3dc3c6353f93a55c298ec49c0750) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186974)) **GitLab Enterprise Edition**
- [Refactor error tracking widget to use GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/4eb5b403652e642e5f8304092ecf5812947b9f2c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185826))
- [MR elipsis menu: Add icons](https://gitlab.com/gitlab-org/gitlab/-/commit/85c9b35730442e21f50182e6cfbb9a6b9164b6b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186953))
- [Add pipelines fine-grained permission for job tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/28bc3f6f84f8e6b4a9c0b69afea4e68e6896f880) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186965))
- [Remove feature flag on protected tags](https://gitlab.com/gitlab-org/gitlab/-/commit/407d5552b4e929e23a39b5ed231e61e1c876144d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186353))
- [Evaluate only for projects assigned to the framework](https://gitlab.com/gitlab-org/gitlab/-/commit/6a4c3d8808401712fad3778d8855da1d334b23f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186940)) **GitLab Enterprise Edition**
- [Log token OAuth application ID when available](https://gitlab.com/gitlab-org/gitlab/-/commit/b45fcea1020bcc9c52506940a0458cd98ad59946) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186915))
- [Convert array types back to array on emit](https://gitlab.com/gitlab-org/gitlab/-/commit/94ea873fe2d4c985ebaf03a0708a91bb6d1e38fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186170))
- [Sync removal pages_deployments_deleted_at_index](https://gitlab.com/gitlab-org/gitlab/-/commit/be5ac9021f42fbb98fc7497464974f68ed6bbfda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186432))
- [Update downstream name for multi-project child pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/19a9edf28914856217226cfc46695c2805ea3d4c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186191))
- [Migrate `.settings-message` elements to the Alert component](https://gitlab.com/gitlab-org/gitlab/-/commit/5b0a4819f94a4993dd30c8bceee0cbedbdd76b57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186849))
- [Update availability of analytics dashboard designer to experiment](https://gitlab.com/gitlab-org/gitlab/-/commit/08bc0be88b4c731583daea90c1a9fdf79509128d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185377)) **GitLab Enterprise Edition**
- [Add max actions to scan execution policy](https://gitlab.com/gitlab-org/gitlab/-/commit/ef044efa160eb5eda9deb0842f82293c678b00c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186622)) **GitLab Enterprise Edition**
- [Update to proper tailwind classes](https://gitlab.com/gitlab-org/gitlab/-/commit/9e12ec7c92372855728bc30185a2635b43704a42) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186619)) **GitLab Enterprise Edition**
- [Reset accesslevel to Guest when promotion on a billable role](https://gitlab.com/gitlab-org/gitlab/-/commit/81d99e3a31add02958b55f6093b556dbf3eaee57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186096)) **GitLab Enterprise Edition**
- [ActiveContext: add chunk preprocessors](https://gitlab.com/gitlab-org/gitlab/-/commit/3bc923ea370d7353ab72517d86a27086502c2aed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185913))
- [Add `scan_execution_policies_schedule_limit` application setting](https://gitlab.com/gitlab-org/gitlab/-/commit/0891c018ef6152b5945e103f2fab02cd0280ac54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186095)) **GitLab Enterprise Edition**
- [Update company controller urgency](https://gitlab.com/gitlab-org/gitlab/-/commit/5a2a0443340448f9c0482ed1b94302b67f1659a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186713))
- [Add security_policy_id to compliance_framework_security_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/3d188b6c9f01bfb51999908a4be9dab307228c00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185962)) **GitLab Enterprise Edition**
- [Move Your Workspaces from Edit Menu to Code Menu](https://gitlab.com/gitlab-org/gitlab/-/commit/8aeb89b4efe04a9e26274ac0f8402cf139e63252) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178492))
- [Runner edit: Improve view of project restrictions](https://gitlab.com/gitlab-org/gitlab/-/commit/11516c3bc142b50c715eafba440d611ef40175cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185118))
- [Make instance_type runners routable](https://gitlab.com/gitlab-org/gitlab/-/commit/b3bf24fecb32b755f2244fa28a8a8339b52ca11d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186706))
- [Expose expires_at field for exports](https://gitlab.com/gitlab-org/gitlab/-/commit/92f5fc78f1c1cee112b26dfb775ac9e0939a78e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186460)) **GitLab Enterprise Edition**
- [ActiveContext: support multiple jsons](https://gitlab.com/gitlab-org/gitlab/-/commit/6f6f1f9ad13203e82b2573933befa67457448341) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185781))
- [New work item kebab menu: Add icons to items](https://gitlab.com/gitlab-org/gitlab/-/commit/a9be666f296b03008347eafa7be722b3c7c5ecf0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186295))
- [Adjust alignment of project artifacts table](https://gitlab.com/gitlab-org/gitlab/-/commit/d6d8d90558edbefb70e5911cb6bf142b33567df6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186613))
- [Fix Duo Chat buttons that do not work on multithreaded](https://gitlab.com/gitlab-org/gitlab/-/commit/64685355f7f0685c419041f569556ea1c1c81a08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186606)) **GitLab Enterprise Edition**
- [Remove second CTA on group members page](https://gitlab.com/gitlab-org/gitlab/-/commit/671c76341149981925babd85a8f2d5b74f45fa7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186584)) **GitLab Enterprise Edition**
- [Add more details to estimate_cluster_size, udpate docs](https://gitlab.com/gitlab-org/gitlab/-/commit/9b24f0acdf5b444ee30021aa8b8b128351924588) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186118)) **GitLab Enterprise Edition**
- [Change file result title to two-lines](https://gitlab.com/gitlab-org/gitlab/-/commit/6e6c37cdcf9f6c8ec57101958da8fab3dff796b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186235))
- [Add ability to distinguish Duo Chat commands from buttons](https://gitlab.com/gitlab-org/gitlab/-/commit/4173685335eaf80c592991c14989cf0cef0fa8db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186338)) **GitLab Enterprise Edition**
- [Sync new index and drop old one for p_ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/6c28b69078e9a5739bd154945049335eca143e7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185025))
- [Allow users to customize Pages publish directory in setup wizard](https://gitlab.com/gitlab-org/gitlab/-/commit/7f2aeca2f94342766e481a790095374d86d3964b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185658))
- [Consolidate package registry application settings into one JSONB column](https://gitlab.com/gitlab-org/gitlab/-/commit/d3bc3cd744e2326d28cd3bc29bbe19dd6533ffec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186130))
- [Return the namespace cluster agent mapping after it is deleted](https://gitlab.com/gitlab-org/gitlab/-/commit/495bc4a22825045fc21eb9cfc7bc94b84a7a294d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184950)) **GitLab Enterprise Edition**
- [Refactor by_traversal_ids filter](https://gitlab.com/gitlab-org/gitlab/-/commit/b0582a80c26c77d89f99a40b3cee57bb51c49df0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186515)) **GitLab Enterprise Edition**
- [Runners project settings: Overhaul display of runners](https://gitlab.com/gitlab-org/gitlab/-/commit/c26a4798608d5283f32cf305423c2e5e53bfc871) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185232))
- [Remove vulnerabilities_as_webhook_events FF](https://gitlab.com/gitlab-org/gitlab/-/commit/5451d946b1d78fd9930027bc3eec2dd438511040) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186218)) **GitLab Enterprise Edition**
- [Token prefixes: Make feed tokens backwards compatible](https://gitlab.com/gitlab-org/gitlab/-/commit/c8f5d5757aa0d2242ffc474d358a685b900448af) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185538))
- [Respect global time tracking hours-only setting in work item issues view](https://gitlab.com/gitlab-org/gitlab/-/commit/b280fdfc997402b110083c9d414023b13ae4a29d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186480))
- [Allow internal users read external status checks response](https://gitlab.com/gitlab-org/gitlab/-/commit/9c109e566efd1f385e17fc3a71ae7b873db40e76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185740)) **GitLab Enterprise Edition**
- [Hide Instance tab from Create from template page](https://gitlab.com/gitlab-org/gitlab/-/commit/6a78f3d1e0c49fc36485592a92dede34a1e47a49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185832)) **GitLab Enterprise Edition**
- [Changed show more and less button inconsistent wording](https://gitlab.com/gitlab-org/gitlab/-/commit/a36496ebceb61a7eb6840100d78b0d4b13210d99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186110))
- [Added scoped items to user search in command palette](https://gitlab.com/gitlab-org/gitlab/-/commit/0388f125a48e6cce08eacba6d5c18f8d2c4e777f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185974))
- [Add index that covers project_id, path_prefix, id in pages_deployments](https://gitlab.com/gitlab-org/gitlab/-/commit/ec80d3b2bf1df0498c1141de84a3e8f0b9e7e3ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185610))
- [Store the Kubernetes objects created when using managed resources](https://gitlab.com/gitlab-org/gitlab/-/commit/3c36e1f15e69a4bf16d181d9004d2716c294803e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186369))
- [Return unique Sbom::Component by name](https://gitlab.com/gitlab-org/gitlab/-/commit/65ae9788a37f92a03cbdcf370860408b70aa66bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185816)) **GitLab Enterprise Edition**
- [Add immutability to tag rule model](https://gitlab.com/gitlab-org/gitlab/-/commit/617300f4018c525b53f48ce97db913bf7a757352) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183135))
- [Add documentation for `monospace` property in pipeline wizard](https://gitlab.com/gitlab-org/gitlab/-/commit/d41dab16f6f9e5cf659c0635f8361952077fa894) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186308))
- [Add tooltip to task list actions menu](https://gitlab.com/gitlab-org/gitlab/-/commit/b7fb55fe7e31b318a0c71fb33fc0bbb5fa1d454f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185691))
- [Drop cache_validity_hours from maven vreg registries table](https://gitlab.com/gitlab-org/gitlab/-/commit/7ba3feb3b77bcd53148d876c1f2b997f6104a2f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186239)) **GitLab Enterprise Edition**
- [More comfortable styles for custom wiki sidebar content](https://gitlab.com/gitlab-org/gitlab/-/commit/96e238f8a988564c5e33cbfe8ab963b2cdabe0d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185678))
- [Add label to color picker GlFormInputGroup](https://gitlab.com/gitlab-org/gitlab/-/commit/b30a86f863be953e4aa8343f8ad074456a3c1fb0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179129))
- [Show requirements info in Frameworks report and Drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/9f5ec6a524dd06ccc350662fa45046b21da39739) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177042)) **GitLab Enterprise Edition**
- [Move service ping worker to sticky data_consistency](https://gitlab.com/gitlab-org/gitlab/-/commit/5889eff92a1c14a7a21adc47eafa28c5baa6d95c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185983))
- [Improve CodeOwner section parsing logic](https://gitlab.com/gitlab-org/gitlab/-/commit/e24928c25da271e0022860b00e5fc2dee9d916b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185180)) **GitLab Enterprise Edition**
- [CI Pipeline graph: Indicate groups as failed if job has failed](https://gitlab.com/gitlab-org/gitlab/-/commit/3eb1500607eed11abb0f3df20f9e1b0db621182f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185583))
- [Re-establish agent association for environments lacking agent links](https://gitlab.com/gitlab-org/gitlab/-/commit/9e0e9eb824d58d93fa61172e535fe9aacd5c3720) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185048))
- [Make entire collapsible state container widget header clickable](https://gitlab.com/gitlab-org/gitlab/-/commit/72aae849388e349eeba145f6063443c57b9d06f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185852))
- [Remove search_migration_cleanup feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4fe7a8b762104562a40f72f2b9c606332057303f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186162)) **GitLab Enterprise Edition**
- [Add docker hub rate limits alert](https://gitlab.com/gitlab-org/gitlab/-/commit/4ae9434c82c13e8c36dbc722fc61bcd779f5ba31) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186149))
- [Move partition_id to token payload](https://gitlab.com/gitlab-org/gitlab/-/commit/1862822c55cdc49491ff5840656df76dab453def) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183554))
- [Add not null constraint to started_at](https://gitlab.com/gitlab-org/gitlab/-/commit/7351751c164adb70859201a4f129f7340588d446) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175317))
- [Add conditional rounded corner styling](https://gitlab.com/gitlab-org/gitlab/-/commit/319824c07bb834eadc4bb030e9d477cd37572107) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186115))
- [Remove skip ci feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/65020b7a8cf05753218a7f1ae6051fce01948c3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184518)) **GitLab Enterprise Edition**
- [Cleanup of feature flag 'filter_unknown_licenses_by_spdx_identifier'](https://gitlab.com/gitlab-org/gitlab/-/commit/23cfec0b763245f3b1b64b0f5f5a928d6e7cdf9e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184652))
- [Remove commit details async feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/303e8f543303f3c5ebe78921700bb170d7b18699) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186063))
- [Include "directly addressed" when filtering for "mentioned"](https://gitlab.com/gitlab-org/gitlab/-/commit/c9c7f068da72712cc57c54f669a55af4afe1a60f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185447))
- [Container queries for work item note content](https://gitlab.com/gitlab-org/gitlab/-/commit/67185c8b6c524372371a630a006eddd7553ce2ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184654))
- [Sort destination namespace results by similarity](https://gitlab.com/gitlab-org/gitlab/-/commit/66acef6bcece309ab72f2dad815d2fddbbb09667) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186001))
- [SPP refactor audit logger](https://gitlab.com/gitlab-org/gitlab/-/commit/2192df7d85689f386b330b926d051b36509767f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183479))
- [Mini pipeline graph: Add max height to downstream dropdowns](https://gitlab.com/gitlab-org/gitlab/-/commit/615e4f74954f2dcf1743a7d809ffd4150aec89c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185984))
- [Deactivate dormant users from enterprise groups](https://gitlab.com/gitlab-org/gitlab/-/commit/b299a615390e0c7be3cdcaddf314fa7c63af15ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184161)) **GitLab Enterprise Edition**
- [Remove FF use_related_pipelines_for_policy_evaluation](https://gitlab.com/gitlab-org/gitlab/-/commit/d55258e11c8bb70d70c868c4e76ef16d766be831) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185942)) **GitLab Enterprise Edition**
- [Project runner: Update destructive actions to secondary buttons](https://gitlab.com/gitlab-org/gitlab/-/commit/d4a61d3b683937c52205cf443232bdaea2ee37c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185603))
- [Remove auto resolve banner](https://gitlab.com/gitlab-org/gitlab/-/commit/561889420b1f82297309fd518689d40741cae651) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185061)) **GitLab Enterprise Edition**
- [Cleanup Duo Chat Claude 3.7 feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/9d24b8b50f7edc71b5a2f20563e58f28f737a844) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185744))
- [Improve performance in edit framework screen](https://gitlab.com/gitlab-org/gitlab/-/commit/1d6f8ced1bf8356bb5449eb1c309f89275cb3509) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182029)) **GitLab Enterprise Edition**
- [Make entire header of collapsible crud component clickable to toggle](https://gitlab.com/gitlab-org/gitlab/-/commit/e8a9a51819dddb186ca722785e6d72db9ce2773f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183882))
- [Update layout of pipeline schedules variables form](https://gitlab.com/gitlab-org/gitlab/-/commit/05539c687ab8dcf55c43bd4d0823ea32967a7c00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185821))
- [Update existing external status check secret](https://gitlab.com/gitlab-org/gitlab/-/commit/3694a8831e880406372910b9950aa5b13362d9d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184072)) **GitLab Enterprise Edition**
- [Add arguments to Geo bulk update mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/7f2efb7f1db702634c3c9a37ff0576b946669850) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184960)) **GitLab Enterprise Edition**
- [Swap FK project_repositories.project_id for LFK](https://gitlab.com/gitlab-org/gitlab/-/commit/7da1ae6107c95456d33436f0f41bb6759072d2be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185307))
- [Document IMDS V2 hop limit and other troubleshooting information](https://gitlab.com/gitlab-org/gitlab/-/commit/be4344a6b1c0f96a1ebc9c712585fe4a4f1b3cdd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185698))
- [Deprecate `restrict_user_defined_variables` in REST docs](https://gitlab.com/gitlab-org/gitlab/-/commit/feeb78693a3323fc7e4ad03b97620205af2abe5b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185594))
- [Update array validation](https://gitlab.com/gitlab-org/gitlab/-/commit/f2213f93d5c69134c3d11997f2340e3adabe5d74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185293))
- [Remove user autocomplete feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/83eacb7a9cf52061007ed7cb7009e2406ca15d02) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185577))
- [Preserve text selection after removing or adding emphasis](https://gitlab.com/gitlab-org/gitlab/-/commit/2f5a8855ac0f7bee63bdebb77c58b66a96136ae4) by @Bubbis ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183087))
- [Add LFK triggers to pool_repositories](https://gitlab.com/gitlab-org/gitlab/-/commit/7304fc55df0d121569744f6e70d2a81bba0f1922) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182933))
- [Add userCalloutsDismisser to pipeline inputs adoption banner](https://gitlab.com/gitlab-org/gitlab/-/commit/697df2b8fb0bf04fab8797ce333a00ff3a1ee314) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185652))
- [Silence ActiveContext worker logs](https://gitlab.com/gitlab-org/gitlab/-/commit/75f8e0e84fba3f7575351d46f9ed1abf94b7d315) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185628)) **GitLab Enterprise Edition**
- [Token prefixes: Clarify level of support of automatic secret detection](https://gitlab.com/gitlab-org/gitlab/-/commit/951db3dba2910f4511e302c7155ad7cfaad94e40) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185590))
- [Swap FK group_wiki_repository_states.group_id for LFK](https://gitlab.com/gitlab-org/gitlab/-/commit/c2b0f8c80ff13dd7dec06dfed701d406d70084de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185323))
- [Revisit snoozed todos timestamp display](https://gitlab.com/gitlab-org/gitlab/-/commit/2241a7f035d12f4f1b71d5a57afa7b651d0ae510) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184843))
- [Use UserCounts for Your Work > Issues pill](https://gitlab.com/gitlab-org/gitlab/-/commit/e0f41badddcfa04a9e02699df254e4ae5e77c16a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185066))
- [Use UserCounts for Your Work > Merge requests pill](https://gitlab.com/gitlab-org/gitlab/-/commit/82dd97aef6d425d30fb14d9b89369bef3735e741) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185066))
- [Use UserCounts for Your Work > To-Do List pill](https://gitlab.com/gitlab-org/gitlab/-/commit/f553a56b4b1f8a8795e8ead171277fc7ca55f80d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185066))
- [Swap FK group_wiki_repositories.group_id for LFK](https://gitlab.com/gitlab-org/gitlab/-/commit/251b96b0e1242d8e286de56c188cf06056674531) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185301)) **GitLab Enterprise Edition**
- [Allow to add inherited members to the group level protected environments](https://gitlab.com/gitlab-org/gitlab/-/commit/2ff85ea996a75177e24883e90db0ade9caf80cac) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185409)) **GitLab Enterprise Edition**
- [GraphQL: Rename CiPipelineCiSources to CiPipelineSources](https://gitlab.com/gitlab-org/gitlab/-/commit/a2e776b2d5cea0983e25d47257ca69a292a753b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184971))
- [Update protected packages feature to allow rule editing](https://gitlab.com/gitlab-org/gitlab/-/commit/4f30abb2dc09807ca302cda4f97aacbbcc4f4d13) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184868))
- [Allow for clicking anywhere on failed jobs widget to expand it](https://gitlab.com/gitlab-org/gitlab/-/commit/615745887d18b01c7a48244abf3a0f4fce2f3a54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185347))
- [Use grid and container queries for layout of work item design widget](https://gitlab.com/gitlab-org/gitlab/-/commit/cccd8c41ce9ed7f7eeb1e3b08cd875b7253299e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185172))
- [Swap FK geo_node_namespace_links.namespace_id for LFK](https://gitlab.com/gitlab-org/gitlab/-/commit/a86b9b4c4cdc1902d29a01f5c71db36644e5282f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185319))
- [Swap FK pool_repositories.source_project_id for LFK](https://gitlab.com/gitlab-org/gitlab/-/commit/8f3c73d0de50a461af26cf77fa1385db7345e4a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185316))
- [Swap FK project_states.project_id for LFK](https://gitlab.com/gitlab-org/gitlab/-/commit/e2f27c59a1360c06eb835404cc9567de5e3ca495) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185313))
- [Remove pending members on switch from user caps to block seat overages](https://gitlab.com/gitlab-org/gitlab/-/commit/ec6048411622a5084fe41b7985c85f742d09a339) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184254)) **GitLab Enterprise Edition**
- [Rename `Created` sort option to `Recommended` in the todos app](https://gitlab.com/gitlab-org/gitlab/-/commit/0d5b057afabd13ba28a792bdc182c78d6a117378) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184982))
- [CI Pipeline graph: Indicate failed job on group better](https://gitlab.com/gitlab-org/gitlab/-/commit/a38d6ecf7724f413787082cd104f1b0c4259de7c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185269))
- [Validate saml and scim for sso requirements](https://gitlab.com/gitlab-org/gitlab/-/commit/10265371ad0f5797258cbd6169ecb852c2697d66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183465)) **GitLab Enterprise Edition**
- [Check marketplace_home_url with user opt in](https://gitlab.com/gitlab-org/gitlab/-/commit/f939f624d92d97dce326ef4f82d4c441cfe6cf2c) by @pslaughter ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184569))
- [Update Google Cloud setup instructions](https://gitlab.com/gitlab-org/gitlab/-/commit/794ad935c88f5b73185bc2f01a7ae315ead6fad2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185145))
- [Update the status timeout message for Geo metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/0ae98c12a2aa6b3c07cc68d7a61348de2caaeb48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183082)) **GitLab Enterprise Edition**
- [ActiveContext build partition from name and number](https://gitlab.com/gitlab-org/gitlab/-/commit/70ab3b2fd5b6964389ab53112c36f9be406a9b18) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184775))
- [To-do dashboard: Optimistic updates to global count](https://gitlab.com/gitlab-org/gitlab/-/commit/65eb16ee11b77736cc2df95977ca80cbb3e06bd7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185112))
- [To-do dashboard: Tie pending counts to global UserCounts](https://gitlab.com/gitlab-org/gitlab/-/commit/5339e2c30ce88c36af936d1522998b3d3b321664) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185112))
- [Update form UX by marking optional fields](https://gitlab.com/gitlab-org/gitlab/-/commit/9764a0a306e8cb34d3520b1182dd7169b864c3e6) by @ahmad-kashkoush ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184678))
- [Prepare async index creation for p_ci_pipelines trigger_id and id desc](https://gitlab.com/gitlab-org/gitlab/-/commit/a5130c00d00a42994f77a823a03165bb633d47de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185017))
- [Update secureflag text](https://gitlab.com/gitlab-org/gitlab/-/commit/10603f96988caf5b35989c31d4c4a6c57995cc95) by @mega6382 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168274))
- [Sentence case container registry](https://gitlab.com/gitlab-org/gitlab/-/commit/6b7717ad0cb3ce954fbfe1b92b68a6f886c663ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183770))
- [Improve visibility for Database review in MR description](https://gitlab.com/gitlab-org/gitlab/-/commit/be92362ae798a30c85145d6fa16933d2e8fe4481) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184945))
- [Update projects finder to filter topics from user's organization](https://gitlab.com/gitlab-org/gitlab/-/commit/bdd8b550aa5a3ac41ad7c4e6137ea6f4e980820f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182816))
- [Rename Jobs column to Jobs Artifacts for consistency](https://gitlab.com/gitlab-org/gitlab/-/commit/8598e6cbb4eade39883caf3dd99f8e41e1ae42e2) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184932))
- [Adjust FeatureSettings Mutation to allow batch updates](https://gitlab.com/gitlab-org/gitlab/-/commit/33e5583db0cf97e8202996085af6ffd5665930b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183319)) **GitLab Enterprise Edition**
- [Retry SyncServiceTokenWorker for up to 12 times](https://gitlab.com/gitlab-org/gitlab/-/commit/a97df4612ab6fcece1dd84a922fb61ca35e1666c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184924)) **GitLab Enterprise Edition**
- [Add Placeholder badge to admin users](https://gitlab.com/gitlab-org/gitlab/-/commit/ce3d39e9c3c6ae5e0723d23174873f3f064bcf65) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184927))
- [Update copy for User Cap disclaimer](https://gitlab.com/gitlab-org/gitlab/-/commit/7a6c4d645dc2272c82a744abf92e1a11c9475231) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184585)) **GitLab Enterprise Edition**
- [Raise error when deleting images with rules](https://gitlab.com/gitlab-org/gitlab/-/commit/3e4461ac6da80f8142e8064a34a2f8836dba95fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183128))
- [Admin roles and permissions: Migrate components used](https://gitlab.com/gitlab-org/gitlab/-/commit/626440238a992e9601ea0bc2bf5fcde376eddcc3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184895))
- [Refine SAST template patterns](https://gitlab.com/gitlab-org/gitlab/-/commit/9b877a6a24bc9790a959977164d8ec40aceb6a2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184795))
- [Filter Pipelines API by created_at date](https://gitlab.com/gitlab-org/gitlab/-/commit/897c56e0fbaec5b040967fbdcbb13d37834b88de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182576))
- [Update amazon q notes](https://gitlab.com/gitlab-org/gitlab/-/commit/f35084ca566c2b6284110d447f4f135285426480) by @jlosito ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183858)) **GitLab Enterprise Edition**
- [Geo Replication List: Make name more readable](https://gitlab.com/gitlab-org/gitlab/-/commit/cacd26fea72ea6efdabfbc2de07d53b2671ea041) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184490)) **GitLab Enterprise Edition**
- [Consolidate unknown license feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/7c239b1784a4c487428671a7bc0a334e20c39ce4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184661)) **GitLab Enterprise Edition**
- [Update dependency auto-deploy-image to v2.126.0](https://gitlab.com/gitlab-org/gitlab/-/commit/154198926473e5a8658a4b2723d42a14156a8e71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184589))
- [Remove Current.organization_id method](https://gitlab.com/gitlab-org/gitlab/-/commit/aa649ae71de4aa73e3a90b43805b2d16f0060ffa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184304)) **GitLab Enterprise Edition**
- [Prefix export subject line with exportable name](https://gitlab.com/gitlab-org/gitlab/-/commit/eaf73911c27e5add8a50a5d36943072b8e6ee937) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184101)) **GitLab Enterprise Edition**
- [Remove onboarding_step_full_uri feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/7f2d598492efe079b57ab29e13f429c1b23fd0cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183362)) **GitLab Enterprise Edition**

### Removed (31 changes)

- [Marked SetComplianceFramework deprecated](https://gitlab.com/gitlab-org/gitlab/-/commit/700059f5c986c52cc6f1d2fef4ddbc6f5b2b02f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187703)) **GitLab Enterprise Edition**
- [Remove Fireworks/Qwen support for SaaS](https://gitlab.com/gitlab-org/gitlab/-/commit/a9f0f05dcdece186f342d6a00314be0c9adfd001) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187397)) **GitLab Enterprise Edition**
- [Delete the `search_sidekiq_default_concurrency_limit` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b598cab0a8542ec4ad148edfe1ecf1fd30648085) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187544))
- [Delete the `zoekt_index_pending_delete_repos` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/6235a0cd39c4210b9e00246970f0f70277f43bf1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187349))
- [Dropping control_expression and requirement_type columns](https://gitlab.com/gitlab-org/gitlab/-/commit/92e8354bc9dbb799a0acd2a3075a54117e5b6a49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187281)) **GitLab Enterprise Edition**
- [Attempt 3 to remove the broken fk_fb57e6cc56_p](https://gitlab.com/gitlab-org/gitlab/-/commit/256e1bda904215d8223d677348e822380315ecb8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187090))
- [Remove spp_scan_diffs ff](https://gitlab.com/gitlab-org/gitlab/-/commit/6a04424e1b32628b42100b5acad15738cee94185) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185882))
- [Remove the merge_when_pipeline_succeeds code](https://gitlab.com/gitlab-org/gitlab/-/commit/dfb0c1d6ba11007200405684191ad88e904a5296) ([merge request](gitlab.com/gitlab-org/gitlab/-/merge_requests/185557))
- [Attempt 2 to remove the broken fk_fb57e6cc56_p](https://gitlab.com/gitlab-org/gitlab/-/commit/938c2bda54ea3a6eceb1b1832b4b97b6724a0b25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186507))
- [Drop p_ci_pipelines_trigger_id_idx](https://gitlab.com/gitlab-org/gitlab/-/commit/a9b4bac80eabb19a05a54a43ae00dc8de5f1c7ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186771))
- [Remove parse_conan_metadata_on_upload flag code](https://gitlab.com/gitlab-org/gitlab/-/commit/6ef6ddfde7b2c9b3ce575d1e179b39361e8c211f) by @mbo5be ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186292))
- [Remove hide_projects_of_banned_users feature](https://gitlab.com/gitlab-org/gitlab/-/commit/935ab67237cf8ddeabd3ce67f2242ae4cd04cad7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185004))
- [Remove amazon_q_chat_and_code_suggestions feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b6afbcb12ccc383bd107d8117d39a1b6085d56d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186296))
- [Remove all code of `/remind_me` proof-of-concept](https://gitlab.com/gitlab-org/gitlab/-/commit/222d20391416971d072a3ed9166ee84e9bd9a15f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185413))
- [Remove unused code for UsersFinder](https://gitlab.com/gitlab-org/gitlab/-/commit/0494fc1654dc0c125cd9f57123c305fe264af44f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186254))
- [Remove "Work item" option from category filter](https://gitlab.com/gitlab-org/gitlab/-/commit/e2a2eacf82fedf30dfff20fba2b15b9c9ca04847) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186077))
- [Remove broken fk fk_fb57e6cc56_p](https://gitlab.com/gitlab-org/gitlab/-/commit/bdef81677156fb2b810a6aa8e1928c5f4b7bd08c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185024))
- [Removed ignore rule for dropped column](https://gitlab.com/gitlab-org/gitlab/-/commit/a0f8c3ce465ce9a4efbb7615cb4793bdb38171a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185854)) **GitLab Enterprise Edition**
- [Do not report search_zoekt_task_processing_queue_size in sidekiq](https://gitlab.com/gitlab-org/gitlab/-/commit/3567128b2ff312542bc1216710dc30ea240cf001) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185690)) **GitLab Enterprise Edition**
- [Remove `dora_projects_comparison_subgroups` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/dd5c9c41baf40a2c2942832b13bc3280b5a57592) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185815)) **GitLab Enterprise Edition**
- [Remove auto-deletion of banned user projects](https://gitlab.com/gitlab-org/gitlab/-/commit/1adc9de4b09f54cd975c9d1d6160603d16927097) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185456))
- [Remove broken foreign key fk_f29c5f4380_p](https://gitlab.com/gitlab-org/gitlab/-/commit/b14f6daa11f85114cc5e076d189fa65a55bd8ca8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183987))
- [Delete the `zoekt_reduced_pull_frequency` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/79b450511d02e9e35f1d0568169317ec43d0a9f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185581))
- [Remove sep max_concurrency application setting](https://gitlab.com/gitlab-org/gitlab/-/commit/0030eebb4dc99348ad6b6fa261fecef7b8edd2dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178892))
- [Attempt 2 to remove fk fk_a2141b1522_p](https://gitlab.com/gitlab-org/gitlab/-/commit/4b90a137a2a761f94c5b3e508556043aac8f8a9e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184285))
- [Remove old implementation of the Environment folder page](https://gitlab.com/gitlab-org/gitlab/-/commit/61e57062a646fddaf5acb34d5451f21e673c6792) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183212)) **GitLab Enterprise Edition**
- [Remove broken foreign key fk_rails_e214655a86_p](https://gitlab.com/gitlab-org/gitlab/-/commit/61ac96cca1592fc541a41f96f8bbb16f16e20afd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184022))
- [Delete the `zoekt_node_assignment` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/a47351923e759c445216fc40b11287021a1bf004) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184821))
- [Remove ci_auth_job_finder_in_runner_api and Ci::Build#valid_token?](https://gitlab.com/gitlab-org/gitlab/-/commit/a95dda6083aaccc4abb44f63de45f9a82278c5ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184565))
- [Remove unused method #project_merge_requests_list_more_actions_data](https://gitlab.com/gitlab-org/gitlab/-/commit/34dae138f5238465e1d59536f716a08c0063238f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184835))
- [Remove filtering by packager](https://gitlab.com/gitlab-org/gitlab/-/commit/a622a18052b941d6765edf17408002e0061d9434) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184613)) **GitLab Enterprise Edition**

### Security (14 changes)

- [Add delay to when pointer events are enabled for 0Auth authorize page](https://gitlab.com/gitlab-org/gitlab/-/commit/e02da7cb01b2bda6eaedbf5e9d50133d39587e48)
- [Set the IP address state for Action Cable requests](https://gitlab.com/gitlab-org/gitlab/-/commit/4dfcaa61c92e172341175df32a2f5c844d8f0d81)
- [Do not enable pprof by default in Workhorse](https://gitlab.com/gitlab-org/gitlab/-/commit/753ddb6865f23dc2403bb03bb902772c9c381218)
- [Global search count leak for confidential issues](https://gitlab.com/gitlab-org/gitlab/-/commit/4be506cb69b703f41dc6edff34687a3a60b7a3ac)
- [Adding validation for Ci::Pipeline](https://gitlab.com/gitlab-org/gitlab/-/commit/8606ad7c7593b54fab2a1844d611db358e2f3187)
- [Bump workhorse golang-jwt/jwt to 5.2.2](https://gitlab.com/gitlab-org/gitlab/-/commit/1f741e3aa42d69891bdb5eb127531f951e5cfd24)
- [Filter LFS objects to prevent unauthorized access in merge requests](https://gitlab.com/gitlab-org/gitlab/-/commit/e71f6b01064d79f4933354d58cbac94f77fe0660) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186959))
- [Add CI/CD project setting `allow_composite_identities_to_run_pipelines`](https://gitlab.com/gitlab-org/gitlab/-/commit/d996802255df23ea7857868ce1375efb6883c525)
- [Inherit current_user external status while rotating project/group token](https://gitlab.com/gitlab-org/gitlab/-/commit/138f3c4b1549314e4286155c92def410b4c4e118)
- [Prevent XSS via merge error on the merge request page](https://gitlab.com/gitlab-org/gitlab/-/commit/5e1e1affa536552d9d7f1d50a081a6e98682d8be)
- [Sync organization user access when admin status changes](https://gitlab.com/gitlab-org/gitlab/-/commit/3837a1ad2486f34a2d3376bbea1382b9ff9fa980)
- [Add validations for the project_name of Harbor integration](https://gitlab.com/gitlab-org/gitlab/-/commit/d71bb82df57e812e557165c4650349b81eb2d807)
- [Sanitize returned input on asciidoc Timeout](https://gitlab.com/gitlab-org/gitlab/-/commit/e6fbb87bfa3ee2bc00d0a62b685bc540488a86dd)
- [Add limit to resource counts in tfplan merge request report](https://gitlab.com/gitlab-org/gitlab/-/commit/ef8fda85fb9386476224169a22dd12c962dbf802)

### Performance (2 changes)

- [Enable bitbucket_server_notes_separate_worker by default](https://gitlab.com/gitlab-org/gitlab/-/commit/d4e8f69aac54c48eb666bfe450aa755a5c040c5a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187133))
- [Reduce queries when building pipeline webhook data](https://gitlab.com/gitlab-org/gitlab/-/commit/277360202bfd0521aa5899c0e38b5ac97a8ac55f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184704)) **GitLab Enterprise Edition**

### Other (157 changes)

- [Create new contributions materialized view](https://gitlab.com/gitlab-org/gitlab/-/commit/d27fccd1927a0135e6d1e427d5cd65c5ae7e9940) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186895))
- [GraphQL: Remove deprecation of ciMinutesUsed](https://gitlab.com/gitlab-org/gitlab/-/commit/06dc9f1e6594dd1df402883b97ea75d973f288d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187830))
- [GraphQL: Remove deprecation of runner active field](https://gitlab.com/gitlab-org/gitlab/-/commit/bc3663090aace201020204101a12cb8882ac4d12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187829))
- [Remove feature flag project_deletion_notification_email](https://gitlab.com/gitlab-org/gitlab/-/commit/9f9c3d3f00cba757bd0f262fbc0eb24a02e713fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187157))
- [Remove bulk_update_work_items_mutation feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d02591ffae276c43cb7f0d8f84033056fc64e05f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187720))
- [Add and backfill lists sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/324243f85509102dba4a6bf938bf9a35d4652cc9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186991))
- [Finalize the finish onboarding for enterprise user backfill](https://gitlab.com/gitlab-org/gitlab/-/commit/7b31575b8b25b006293fa801833b56eef3501cef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187713))
- [Fix Duo with Amazon policy](https://gitlab.com/gitlab-org/gitlab/-/commit/f0d250e5d4fa090b3fbc7119fb1e99f46bf9b5da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187675))
- [Add NOT NULL for sharding key on \](https://gitlab.com/gitlab-org/gitlab/-/commit/5a86e3b3fbe4053fae141d93855427a40fab8eb1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187636))
- [Remove feature flag for PK lookup using functions](https://gitlab.com/gitlab-org/gitlab/-/commit/5e7a4fce88345fb27cc60608d686d4595cd15005) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180892))
- [Add created rule ID to security policy diff](https://gitlab.com/gitlab-org/gitlab/-/commit/d79b850aefad9c2601bc2236ba6c7d7e30d9b634) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187175)) **GitLab Enterprise Edition**
- [Remove application code from onboarding status role backfill](https://gitlab.com/gitlab-org/gitlab/-/commit/b6bab5b60d44f5bb61a0a6de8c6eb348e3623ed1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187401))
- [Finalize migration IncidentManagementIssuableEscalation](https://gitlab.com/gitlab-org/gitlab/-/commit/7a13eabfd47740f828af60e2cb1693aaad4767cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187219))
- [Add and backfill organization_id for bulk_import_configurations](https://gitlab.com/gitlab-org/gitlab/-/commit/53111765c9d49e929828f846aa8d9999a1743f68) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187337))
- [Remove worker data consistency feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4a2bedaa0999bda69a612e712187f5269fa1ac49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187287))
- [Force update reserved_storage_bytes for overprovisioned indices](https://gitlab.com/gitlab-org/gitlab/-/commit/5001ad3093f3dfab603050928328fe928c970f36) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186410)) **GitLab Enterprise Edition**
- [Remove filtering_optimization_for_work_items references](https://gitlab.com/gitlab-org/gitlab/-/commit/3bd09dedffb3ff429ebf092dadfb5e5527200c80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187444))
- [Clarify when "due soon" email is sent](https://gitlab.com/gitlab-org/gitlab/-/commit/2979308ed713acba949c167d04f8909eaee51042) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187185))
- [Protected packages: Extend docs for minimum access level for delete](https://gitlab.com/gitlab-org/gitlab/-/commit/80d5cbf1329f2ff171f5bce4ed5418374bd23961) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186585))
- [Add NOT NULL for sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/035d1a5f065fd86f3c36b40abd0ebfa06105a9cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186784))
- [Extract Work Item userPermissions to its own fragment for CE & EE](https://gitlab.com/gitlab-org/gitlab/-/commit/d855ebf9a62d419103aa3ec88749f60e43b8560a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187007)) **GitLab Enterprise Edition**
- [No-op FinalizeBackfillCiRunnerMachinesPartitionedTable migration](https://gitlab.com/gitlab-org/gitlab/-/commit/70e3051e3508e4fb48a06a2d613770efca1b3d1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187339))
- [Add NOT NULL on vulnerability_external_issue_links.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/b217c3e0924442b6d5ffc7fdd7b58d1532d98eab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182697))
- [Make "Approved by" MR fliter use sentence case](https://gitlab.com/gitlab-org/gitlab/-/commit/01223f527b179794072c1bb1916e47870218cfe4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187159))
- [Add NOT NULL for sharding key on packages_npm_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/6a7ffcefa7130810da169e44585b50d2a631c427) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186623))
- [Reindex Elasticsearch project index to update integer with long type](https://gitlab.com/gitlab-org/gitlab/-/commit/81b308dda26bc8b13eb9aa8e75ecdf5593405162) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187003)) **GitLab Enterprise Edition**
- [Finalize migration BackfillIssuableMetricImagesNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/6d101f05e0780d4c749e8ddf0e13723bd64e88f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187220))
- [Clarify that "Watch" doesn't include all notifications](https://gitlab.com/gitlab-org/gitlab/-/commit/e3f01f15bd93a4dd436e8b9843451b518b2dd04a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187193))
- [Delete ci build trace metadata record after archive](https://gitlab.com/gitlab-org/gitlab/-/commit/bfdc5fd7a61f6a1cb155077ed07b4e02278d6f7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186748))
- [Update values for ci_runner_machines_archived in LFKs](https://gitlab.com/gitlab-org/gitlab/-/commit/9288aff65a4de1b5b276325a85198267b8850997) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187110))
- [Cleanup Redis BufferedCounter post migration](https://gitlab.com/gitlab-org/gitlab/-/commit/374854440b3c717fbc25bd908f63b7c7bcb9b18e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187130))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/e33145e961fe6e352595e0dc76be9883192d62dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187125))
- [Remove feature flag autocomplete_projects_use_search_service](https://gitlab.com/gitlab-org/gitlab/-/commit/8cbd1b5263bd298ee181864b2a324400ecdb4e73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186513))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/b6e4015fae95cfd9db3aa76f2ef868d4127765a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187087))
- [Document how to troubleshoot object storage migration inconsistencies](https://gitlab.com/gitlab-org/gitlab/-/commit/4ee9c4307eb09f5867746e4bdd0296e90e1f99c1) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185399))
- [Add migration to delete orphaned routes](https://gitlab.com/gitlab-org/gitlab/-/commit/a225ffdc3203253a9d4e6f4b9dd0277f16555e76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186659))
- [Update Storybook to v7](https://gitlab.com/gitlab-org/gitlab/-/commit/ffdd260314665407ecf16c5e28de85bd7147d81e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174526))
- [Fetch component name from sbom_components](https://gitlab.com/gitlab-org/gitlab/-/commit/11b873f1ad39eacb388724c256cf1cc539bd74ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186813)) **GitLab Enterprise Edition**
- [Finalize migration BackfillFreeSharedRunnersMinutesLimit](https://gitlab.com/gitlab-org/gitlab/-/commit/bb892643553ac1466e97936f72f131a9b66ddc94) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186909))
- [Remove GitLab Duo features from Duo with Amazon Q docs](https://gitlab.com/gitlab-org/gitlab/-/commit/481c4fe4cc3c8875907bd6edbecb52678b0124ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186884)) **GitLab Enterprise Edition**
- [Remove force_cancel_build FF](https://gitlab.com/gitlab-org/gitlab/-/commit/12fb08061b4a4c413e8f04844b800dea41cafa59) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186132))
- [Ignore runtime_runner_features on builds metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/e9061dea14c673928236db4254826a7fe6ad37ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186826))
- [Clean up feature flag cleanup_stale_policy_violations](https://gitlab.com/gitlab-org/gitlab/-/commit/8a2c2aecdafaf719a2b0054b4662fcd3cbae869c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186785)) **GitLab Enterprise Edition**
- [Clean up feature flag pat_expiry_inherited_members_notification](https://gitlab.com/gitlab-org/gitlab/-/commit/35c0b7fb4143d84e2ab98f58b82ba40981b42455) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184677))
- [Add API endpoint rate limit for virtual registries](https://gitlab.com/gitlab-org/gitlab/-/commit/7db3f49ffae17fee7d15075555e99dd8a9f473da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185280))
- [Sync translations from crowdin (2025-04-02)](https://gitlab.com/gitlab-org/gitlab/-/commit/ddda898e27625b9185582657225377aa22eb1b12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186677))
- [Drop issues.correct_work_item_type_id column](https://gitlab.com/gitlab-org/gitlab/-/commit/cf28d67cbed6f9853e0aa3d243002f2f56974992) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185979))
- [Clean up blame_ignore_revs feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/99ed55ecf0640228cafff594c5bcd50f283b50ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186479))
- [Sync translations from crowdin (2025-03-31)](https://gitlab.com/gitlab-org/gitlab/-/commit/bb6a4f8b3669210ad509f490e1606598a60fceb6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185933))
- [Update workers data_consistency](https://gitlab.com/gitlab-org/gitlab/-/commit/f9d3c90f714b821ae4c06ba4a9b47068281dc240) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186079))
- [Limit dependency paths returned for a vuln](https://gitlab.com/gitlab-org/gitlab/-/commit/f2b99c01cd3114cad42d082ba6f4be1b3ca2f43e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186543)) **GitLab Enterprise Edition**
- [Document Container Repositories as part of the Geo data types](https://gitlab.com/gitlab-org/gitlab/-/commit/c20840b17ab0ff8865a68a37df975c841a6d6517) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186343))
- [Finalize migration BackfillPersonalAccessTokenSevenDaysNotificationSent](https://gitlab.com/gitlab-org/gitlab/-/commit/9910ff959837c7d44efe7293bf15ce855c8fec3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185359))
- [Add NOT NULL for sharding key on incident_management_escalation_rules](https://gitlab.com/gitlab-org/gitlab/-/commit/e89c5865d42321b0d79e0c25c20a47a29e664bf1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186611))
- [Ensure user is authorized to push NuGet packages](https://gitlab.com/gitlab-org/gitlab/-/commit/4fa32f666589542c5492d52db9f6c0ff547f1107) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184495))
- [Make "Target Branch" MR filter use sentence case](https://gitlab.com/gitlab-org/gitlab/-/commit/3fa9c0472c651b9a13b96e46e995d640f28f826e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186160))
- [Add documentation to service access tokens revocation](https://gitlab.com/gitlab-org/gitlab/-/commit/ae7ee293278f0dbc533efacf8e285716aa4b53ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184288))
- [Fix flaky tests for Loose Foreign Keys](https://gitlab.com/gitlab-org/gitlab/-/commit/4150b637c32af5e932d067e3d18cea130b5952b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185770))
- [Add project export event tracking](https://gitlab.com/gitlab-org/gitlab/-/commit/a8b38425a7cdb826c5d579155c64dc45c9e37e20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186125))
- [Add NOT NULL for sharding key on milestone_releases](https://gitlab.com/gitlab-org/gitlab/-/commit/dce0b3bb845f9572d8eba695fe8d204c2522283e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186452))
- [Migrate Amazon instance audit event destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/ec0e2a07e5d2a383ba76c1672492562350d1ccb9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184039)) **GitLab Enterprise Edition**
- [Remove deprecation for cancel pipelines api](https://gitlab.com/gitlab-org/gitlab/-/commit/92f80a2b42188cff73819da0aea32940ade5c578) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185919))
- [Removes the add_timezone_to_web_operations](https://gitlab.com/gitlab-org/gitlab/-/commit/23ec12fcb4de4f57d37414318440fb75efdbeb60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186156))
- [Display with Amazon Q on duo chat button when enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/bfd8bbe2e43b66f96cc519638da38bd19ef8b939) by @jlosito ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186012)) **GitLab Enterprise Edition**
- [Remove cancel gracefully from metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/eeb8e8dbaf0dcc7bd18ca95a6be184e563759be2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186123))
- [Backfill organization_id on fork_networks](https://gitlab.com/gitlab-org/gitlab/-/commit/1d79c7141aba4f455d2e634ade1616dadf77be4c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184051))
- [Add duo seat assignment task to learn gitlab](https://gitlab.com/gitlab-org/gitlab/-/commit/899a7912601d7b22d0721d166e284e6568e16fb3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185851)) **GitLab Enterprise Edition**
- [Add reemit event to speedup](https://gitlab.com/gitlab-org/gitlab/-/commit/efc0ea19dbf160c46f6c3cd407d1f316ba54c6fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186241)) **GitLab Enterprise Edition**
- [Drop admin-token from internal CDot](https://gitlab.com/gitlab-org/gitlab/-/commit/2efd4eb72bb0ff502710ee0faec1fe3f00a7b79e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184780)) **GitLab Enterprise Edition**
- [Rename usage of file to blob in Geo](https://gitlab.com/gitlab-org/gitlab/-/commit/b84b39131e82339a59404ae5187edc56df1da651) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186346)) **GitLab Enterprise Edition**
- [Remove runner registration token deprecations](https://gitlab.com/gitlab-org/gitlab/-/commit/0d5a4c568799502738d402a0afc7690a1f7373fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184746))
- [Add BBM to migrate group legacy HTTP destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/f449a751040c897fd1bb7f2e1f974b3ab90c41cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183044)) **GitLab Enterprise Edition**
- [Migrate Google Group audit event destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/c5edb778f8753667f9b9a276dad7d613e0e03443) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183043)) **GitLab Enterprise Edition**
- [Add BBM to migrate group legacy Amazon destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/8f371333271b960c02b961c87bfabea124e3d984) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183042)) **GitLab Enterprise Edition**
- [Add NOT NULL on error_tracking_error_events.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/483fa08cec0f7c8c1c7931d328df2299ed738aef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184908))
- [Remove beta from Amazon Q auto complete descriptions](https://gitlab.com/gitlab-org/gitlab/-/commit/4c4ae3d5aed1505d5ea3b7951c067c439e6b4671) by @jlosito ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185976)) **GitLab Enterprise Edition**
- [Move the FF to ops to enable by default](https://gitlab.com/gitlab-org/gitlab/-/commit/73fe131fdde462efa11f3b39cba4a908e080eefa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185994)) **GitLab Enterprise Edition**
- [Remove the `merge_request_dashboard_merge_checks` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/9645bb26657da635edfcdffefb623bb6b7729785) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185943))
- [Make work item quick actions text consistent](https://gitlab.com/gitlab-org/gitlab/-/commit/ceb79039f8611097f114005f6d7f10355acb99fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185087))
- [Backfill redirect_routes.namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/1e33da44b5da277319eb653e5db004ee31b6efc5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183967))
- [Add NOT NULL on vulnerability_occurrence_identifiers.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/0794341940e412b1a505c8d7c34dfc4725289380) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184914))
- [Add NOT NULL on projected_environment_deploy_access_level sharding keys](https://gitlab.com/gitlab-org/gitlab/-/commit/75137f87db9a17e22ac39e065b8f04abed907b9e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184913))
- [Finalize migration BackfillDependencyProxyBlobStatesGroupId](https://gitlab.com/gitlab-org/gitlab/-/commit/daf547adfe7d3b995eb8232b96ac5242c21d49ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185870))
- [Finalize migration SetTotalNumberOfVulnerabilitiesForExistingProjects](https://gitlab.com/gitlab-org/gitlab/-/commit/df45c6189205abd62569e5cc7eb0a019fc778a27) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185868))
- [Deprecate the merge_when_pipeline_suceeds push option for auto_merge](https://gitlab.com/gitlab-org/gitlab/-/commit/1c915d0c94497794fc12b8f38e928279db833a01) ([merge request](gitlab.com/gitlab-org/gitlab/-/merge_requests/185368))
- [Finish user onboarding when the user is an enterprise user](https://gitlab.com/gitlab-org/gitlab/-/commit/ac0cbee13c7bf9b0f8ad78496510bff97cb60771) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183597))
- [Finalize migration BackfillPackagesRubygemsMetadataProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/15a3e84b510257d98dec982f3f792cda6cb3c0dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184715))
- [Initialize conversion of MergeRequestDiff Id columns to bigint](https://gitlab.com/gitlab-org/gitlab/-/commit/71e0d153588fd08112c9a0ae7bb7dbf82a1184b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185829))
- [Add information about the known issue](https://gitlab.com/gitlab-org/gitlab/-/commit/d8bcaa2c14d936d4240ba520af5321397232f5f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185787)) **GitLab Enterprise Edition**
- [Add a description for the /using_docker_images doc to improve SEO](https://gitlab.com/gitlab-org/gitlab/-/commit/dee061d10d949d7b99c32573c55db44f025db645) by @nikitasakau ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185830))
- [Create new ClickHouse events table](https://gitlab.com/gitlab-org/gitlab/-/commit/64a3543aca26be2e214d54da0a0e7f34b34326f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185318))
- [Complete the virtual registry cleanup worker rename](https://gitlab.com/gitlab-org/gitlab/-/commit/a338bc736c82b53e3b55221097cc03cd060d394a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185394))
- [Sync translations from crowdin (2025-03-25)](https://gitlab.com/gitlab-org/gitlab/-/commit/7e26a7e2736f436063927065fd0a4aed45a002e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185766))
- [Add models for mapping ldap group to admin custom role](https://gitlab.com/gitlab-org/gitlab/-/commit/e589958fceefed248c5bbc53005900e18168d74b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184606))
- [Re-queue migration to delete orphaned groups](https://gitlab.com/gitlab-org/gitlab/-/commit/dfacf7c245612677611ed6a2813f5a5510b852d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183639))
- [Remove ai_features_enabled and improve ai_features_banned policy](https://gitlab.com/gitlab-org/gitlab/-/commit/a3209ecd33628f3983179f964a523bd7737b7acb) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185526)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/e21af91d984ef28ba6459ca517a70d6a7ee0f5ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185560))
- [Add organization support to merge request diff commit users](https://gitlab.com/gitlab-org/gitlab/-/commit/7ce6b0fc39df4192bf8074e48ecf505c7b83613e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185110))
- [Remove the `todos_bulk_actions` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/577e106ee27a3eecf940ff8358c940f74818c7ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185346))
- [Backfill approval_policy_rule_id in scan_result_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/6ccf311aeccb8fdaf7f44b1357e4a793af506aae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182584)) **GitLab Enterprise Edition**
- [Drop RequeueDeleteOrphanedPartitionedCiRunnerMachineRecords](https://gitlab.com/gitlab-org/gitlab/-/commit/ed977ff792a53e994c52ee3934543972f51882b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185296))
- [Drop DeleteOrphanedPartitionedCiRunnerMachineRecords migration](https://gitlab.com/gitlab-org/gitlab/-/commit/79d60a9bb8dbbb138a4389c0b7f75b5bc364ca5f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185296))
- [No-op ci_runner_machines_687967fa8a table backfill migration](https://gitlab.com/gitlab-org/gitlab/-/commit/310f927b571674eb0c3960e267cdec3b074da8ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185296))
- [Fix Graphql/ResourceNotAvailableError offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/2ed1cbe93de40c86345d295ec909ffc1a29e9f97) by @prileygraham ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180834))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/e107e3da94327918efaf640241a594454dd6cd1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185614))
- [Add and backfill project_id for packages_helm_file_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/f16f444609ac7965540542cfbb9ab319a9fab272) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185225))
- [Sync translations from crowdin (2025-03-24)](https://gitlab.com/gitlab-org/gitlab/-/commit/c342c7eaf74ae19cab3fae1789bf8af2e98c75ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185612))
- [Change "My-Reaction" filter to "My reaction"](https://gitlab.com/gitlab-org/gitlab/-/commit/e15615edffe8179f3e20142a85280a450097a09a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185235))
- [Removing old CI partition tables from LFK config file](https://gitlab.com/gitlab-org/gitlab/-/commit/7d44361993406fe7c5f375f957a2bfe0a790c0b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185121))
- [Add NOT NULL on merge_request_user_mentions.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/cf81582254b6fc4e6555ef200fa558617ccc5ffc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182696))
- [Remove custom debug message in organization_controller_spec](https://gitlab.com/gitlab-org/gitlab/-/commit/1c3f1e497d978584e75251af4b4432cf34f58c33) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185116))
- [Finalize migration FixProjectSettingsHasVulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/908f2157b1ddbe4070b89bdf5e10a845cb9094ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185360))
- [Add service pings for runner token expiration by runner type](https://gitlab.com/gitlab-org/gitlab/-/commit/94f2d2bde346fcf8aaf783d5b875b398de1ec4c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185544))
- [Drop partitioned copy of merge_request_diff_commits](https://gitlab.com/gitlab-org/gitlab/-/commit/b12f17e6a154982cf14fb25e225eae1e1ed0db75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182794))
- [Add and backfill project_id for packages_package_file_build_infos](https://gitlab.com/gitlab-org/gitlab/-/commit/de7d888a47d5e4341533b4d3502410469610cbd8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185226))
- [Add and backfill project_id for packages_debian_file_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/f1faf75aacce3a84f932961ab44c75b625ec70e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185223))
- [Add and backfill project_id for packages_conan_file_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/0b9cd3abebf7ed1e8cdf5b0bbd833b2cb1272d80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185222))
- [Reduce increased query count for decomposition](https://gitlab.com/gitlab-org/gitlab/-/commit/8e35239767074e9621ed6e5d21c75b128aecb8ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169462)) **GitLab Enterprise Edition**
- [Sync translations from crowdin (2025-03-21)](https://gitlab.com/gitlab-org/gitlab/-/commit/52ca52e86774590083d0952b0f3bdf7a583f0144) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184937))
- [Create new code suggestion_daily_events table in ClickHouse](https://gitlab.com/gitlab-org/gitlab/-/commit/c9527257888fb70347e474010b050bce2806a296) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184384))
- [Add NOT NULL on ci_trigger_requests.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/7b75b21d1df9cc28be24e44a13be87865fef8990) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183978))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/2b6836ff9f0397430475ed4756ca80f78ac80ba5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185022))
- [Add NOT VALID NOT NULL constraint to ci_build_needs.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/a40e2473127323771d0917e4db70d22e17e8b5ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184429))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/0007b4407a08c274f6d3b5e8386d135562a3cd4f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184409))
- [Finalize migration BackfillPagesDomainAcmeOrdersProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/c0a538e21a1465f7269501b6a2395e5b0f5bd815) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185358))
- [Finalize migration BackfillPagesDeploymentStatesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/1b90033fbb162c58f28fd889c0ba07f729b35cfe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184716))
- [Re-queue BackfillOnboardingStatusRole migration](https://gitlab.com/gitlab-org/gitlab/-/commit/68c02ea30a8ab9d86c53458d0306281cfcd25939) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185314))
- [Cleanup use_ssot_for_ultimate_trial_eligibility feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/7c1126cf5be78af89bb4412e07fbb02b143d502b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184228)) **GitLab Enterprise Edition**
- [Partition vulnerability archival related tables](https://gitlab.com/gitlab-org/gitlab/-/commit/5d1181f3db11af23945fc359d8100a04f2f9a36a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184636))
- [Finalize migration BackfillPackagesNpmMetadataProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/fdeb4e944512dd64f7a878170c8c65e949623946) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184244))
- [Make "Search Within" filter use sentence case](https://gitlab.com/gitlab-org/gitlab/-/commit/3e9ec2c241619f3916dd8f4eacf1f7e7e7e2c0e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185242))
- [Finalize migration BackfillPackagesNugetMetadataProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/9626d2ee0f38acfe721db3e2d085a459cfa3af85) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184245))
- [Finalize migration BackfillPackagesPypiMetadataProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/0b9e8608a1a36ba152e29b7ee3f0a38a1dcce003) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184398))
- [Changing "acknowledgement" to American spelling](https://gitlab.com/gitlab-org/gitlab/-/commit/19482e03405abb5a30629742b6aeaa5d7796a3b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184185))
- [Add ComplianceFrameworks count metric](https://gitlab.com/gitlab-org/gitlab/-/commit/65a0d1a5b02b0dd3a17fcbccf19f4987da90f850) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184686)) **GitLab Enterprise Edition**
- [Validate NOT NULL on packages_package_files](https://gitlab.com/gitlab-org/gitlab/-/commit/206a29e962dc22471b2048030b292b0d4680b79b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185064))
- [Remove ElasticIndexingControlWorker class and related files](https://gitlab.com/gitlab-org/gitlab/-/commit/da995f512ce7802652502d807f8f535537dd7ad2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185117)) **GitLab Enterprise Edition**
- [Reindex Elasticsearch note index to update integer with long type](https://gitlab.com/gitlab-org/gitlab/-/commit/931811688773ad39a383085ad311fc699af9f1c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184202)) **GitLab Enterprise Edition**
- [Add a migration to remove the routes that are pending deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/2511830eba3c91e74220ac10c0eb88cbe57f519e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184755))
- [Finalize Jira Cloud App connection migration](https://gitlab.com/gitlab-org/gitlab/-/commit/fb1848e5f751d9aea913f7f37d72b6a9cd103789) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182655))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/44768066556396b8383a53b29b07b41a7f8f97eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184699))
- [Add NOT NULL on protected_environment_approval_rules sharding keys](https://gitlab.com/gitlab-org/gitlab/-/commit/8786c32355d62950e10d01a5df220b42f3ac9ac6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184433))
- [Validate NOT NULL on approvals.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/c661813293801d1b29508b7b614755e4594eefbc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181753))
- [Remove feature flag "Cleanup codeowners_file_exclusions"](https://gitlab.com/gitlab-org/gitlab/-/commit/e401dccecda97e19b0e8446c9e9fd75621783c8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184860))
- [Add NOT NULL on epic_issues.namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/3aedaf0d2504b12e55eb33a6f821ea4fdc69468e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184430))
- [Initial commit: Remove log_response_length feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/67f898e963cfe4e69d1010c1fc5fc225aaff7b80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184261))
- [Add and backfill project_id for incident_management_oncall_shifts](https://gitlab.com/gitlab-org/gitlab/-/commit/daf87c99cfa202afa3c3e630424132a927eaa55a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184772))
- [Migrate Google Instance audit event destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/612f69d5384fb5eb70ce5c9988d044bc963699ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184058)) **GitLab Enterprise Edition**
- [Add and backfill project_id for incident_management_oncall_participants](https://gitlab.com/gitlab-org/gitlab/-/commit/a4022477085b70781f2274f40371a9379513743b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184771))
- [Add NOT NULL on ci_build_pending_states.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/c7687705e69682b2de71a4bdd276259b7a521db3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183975))
- [Remove feature flag label_keep_around_ref_metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/055e3a95ed3944a246d3f4e36cb564faf3866ad1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184847))
- [Log Runner info for Release builds](https://gitlab.com/gitlab-org/gitlab/-/commit/7c68a6e351a79f7a42a31964424b0973f10f23ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184817))
- [Protected containers: Fix metadata for FF minium access level for delete](https://gitlab.com/gitlab-org/gitlab/-/commit/c58346a842c888740a58582d90e53ad72e710053) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184812))
- [Sync translations from crowdin (2025-03-15)](https://gitlab.com/gitlab-org/gitlab/-/commit/0fe7bd747fd69148424c5903522c0e36421e39bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184696))
- [Cleanupp the no_onboarding_enterprise_users feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/7d9d548746a1b6dd2f2f074f64c7758745fb0494) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184478)) **GitLab Enterprise Edition**
- [Remove feature flag allow_merge_request_pipelines_from_fork](https://gitlab.com/gitlab-org/gitlab/-/commit/b62f9187a57cc5ba66ce26889516cc55a425181a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182862))
- [Finalize migration BackfillNewAuditEventTables](https://gitlab.com/gitlab-org/gitlab/-/commit/1bc0f07ffd3af5b9fab8a0ea0b1af5f2759d25db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181881))

## 17.10.8 (2025-06-11)

### Fixed (2 changes)

- [Fix gitpod button is missing in the edit dropdown](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c3ad6f66e6f17a5bf8fa2489a7335dfa58fc55a6)
- [Attempt to migrate ci_runner_taggings table (try 2)](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c2520ea439dcb4fee531fcc39efc85ab4b607a6c)

### Security (7 changes)

- [Protect webhook from excessive payload lengths](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1fb7390786ae5c22ec7f1bc172423a76835aa14c) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5061))
- [Endless Redirect Loop in any project when query param "format" is "git"](https://gitlab.com/gitlab-org/security/gitlab/-/commit/fddb00a30506eb534dc9e1f5c1923eee3e33c0b3) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5040))
- [Backport for "Add validation for board name length" to 17-10-stable](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a69cf8ef367ef1897158af0619cd537fe5d2a5df) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5046))
- [Fix # #1329 - IDOR in compliance framework export endpoint](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7b4f9e9fb7411a18185ada44dc88dd264e6a228b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5042))
- [security: Git redirection inconsistency](https://gitlab.com/gitlab-org/security/gitlab/-/commit/12003cbfb9b4081a352724922e6ed9aa97656ace) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4900))
- [Fix XSS with CSP bypass in JSON tables](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1b02f9ed79b3a999baae5c02fa4f26c487927cba) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4988))
- [Limit HTTP response size](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1411cb581f68400b5370d694cce3c67e5f0e2294) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5016))

## 17.10.7 (2025-05-21)

### Security (9 changes)

- [Use CI::VariableValue in BasicEntity to prevent exposing hidden values in collapsible UI element](https://gitlab.com/gitlab-org/security/gitlab/-/commit/6e71c801f9fea1afe19de9911813d4921c98bbd4) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4952))
- [Show full path of project in create MR dropdown](https://gitlab.com/gitlab-org/security/gitlab/-/commit/bb2266cdea6444523aa98a400f91a6c494391987) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4973))
- [Security 479168 discord zip vulnerability](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1f913df837c85a447f5d3b1bb9e929dbf950c3db) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4946))
- [Limit length of certificate cluster text fields](https://gitlab.com/gitlab-org/security/gitlab/-/commit/414468af6fd95eef1a2d9ec0161ddd361f6c4619) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5001))
- [Check rate limit for over-sized blobs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/63f67c5ca1c2ff013b2784786b4af92b675f9ea9) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4976))
- [Added size constraint validation to notes position fields](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7c430a29ae43c91ed0b01eb976e158be6c3847a7) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5007))
- [Obfuscate emails in note.bodyFirstLineHtml](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7f955b50aa72821f04ab8b7998c5260c13af9801) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4993))
- [Need to update 2fa requirement after accepting request](https://gitlab.com/gitlab-org/security/gitlab/-/commit/68c6a45662755fb7c00935dbf588fe22d9275aad) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4983))
- [Ensure SAML authn context comes from signed portion of SAML response](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3822ca4e9e5050a90908c933a56b266eca24e959) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4979))

### Other (1 change)

- [Drop ci_runner_machines_archived table](https://gitlab.com/gitlab-org/security/gitlab/-/commit/21e2e68dd2ad0bd83979243618b0ca0f79b7f578)

## 17.10.6 (2025-05-07)

### Fixed (2 changes)

- [Bump devfile gem to v0.4.3](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c4840d962f0d7c7b0358e9f88727a6bfabb1bf90)
- [Only check records with encrypted data in gitlab:doctor:encryption_keys](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2552b470ad275177d3b2cd8673fecb6b46edde50)

### Changed (1 change)

- [Change to async_delete for ci_running_builds.runner_id](https://gitlab.com/gitlab-org/security/gitlab/-/commit/541c04acdcb4662d1da9752bc57e4f35b3132394)

### Security (3 changes)

- [Improve Octokit::ResponseValidation middleware and add rate limits](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3643c75ca34b0d50ddd0ada526d73c33f49b8222) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4936))
- [Remove id attribute from OAuth form](https://gitlab.com/gitlab-org/security/gitlab/-/commit/09f38647c06a2e1ac3d84510a4f04729b3d6fe86) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4949))
- [Use IssuePolicy for #issues_readable_by_user](https://gitlab.com/gitlab-org/security/gitlab/-/commit/777d7a4b6f5b4101d8d1d174365006f2f112ccff) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4956))

## 17.10.5 (2025-04-22)

### Fixed (3 changes)

- [Fix 500 in Todo API when wiki page todo exists](https://gitlab.com/gitlab-org/security/gitlab/-/commit/71215f0615fad3167fb96b521b9628e11ea30a5d)
- [Clear session cookie when browser is closed](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7c77ca404d9be7166d8ef991013394483b3f0371)
- [Fix workspaces reconciliation to send inventory config map correctly](https://gitlab.com/gitlab-org/security/gitlab/-/commit/aba508e925aea81c4d47555254e6a657edc94863) **GitLab Enterprise Edition**

### Security (4 changes)

- [Add SecureHeaders middleware with the Nel header](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0e180be62768513438f86ea99f0a4a305cca46b6) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4919))
- [Restrict forwarded headers in Maven dependency proxy](https://gitlab.com/gitlab-org/security/gitlab/-/commit/faa100503f89d08e51549e4f35f362c9945dbb6f) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4930))
- [Security unauthorized access to reading branch names](https://gitlab.com/gitlab-org/security/gitlab/-/commit/dc2f917499f58ed9ccff23158b39528b62b71c2f) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4895))
- [Simplify detecting paragraphs for quick actions](https://gitlab.com/gitlab-org/security/gitlab/-/commit/507e465f21b5be5297eda7a67f0ba75994df88d8) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4926))

### Other (1 change)

- [No-op FinalizeBackfillCiRunnerMachinesPartitionedTable migration](https://gitlab.com/gitlab-org/security/gitlab/-/commit/119891459658f48120bcef02b1b66e3e78c78865)

## 17.10.4 (2025-04-09)

### Fixed (2 changes)

- [Fix invalid pipelines for scan execution policies](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b27b9794e62f4e8ba33e2f56c1c7c64872b4e771) **GitLab Enterprise Edition**
- [Move group.cluster_agents field to CE](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d649d85eab978e106135cc03db4baf261d5d8cb3) **GitLab Enterprise Edition**

### Security (7 changes)

- [Bump workhorse golang-jwt/jwt to 5.2.2](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0ccf3be7475234aca2c54bd1b0283cd9efed6d87) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4912))
- [Global search count leak for confidential issues](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2a6b55c797818a232b0b6ca271f42f594f5a2eae) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4907))
- [Set the IP address state for Action Cable requests](https://gitlab.com/gitlab-org/security/gitlab/-/commit/eef77387081aaf590f13dcdbd7faa6cbadd26bb7) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4904))
- [Bump Golang Oauth2 >=0.27.0](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ee730000f88d319bbd70ce828a0b21118e30231b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4893))
- [Adding validation for Ci::Pipeline](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5d8162f4dfd64d817adef4b2bfd6ce174b66fa44) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4884))
- [Add delay to when pointer events are enabled for 0Auth authorize page](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d54f30acea881202ae0b225c20d306633d7708bf) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4888))
- [Do not enable pprof by default in Workhorse](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4e61600d751d0aba541d8019c9c6419762acc1b7) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4891))

## 17.10.3 (2025-04-02)

No changes.

## 17.10.2 (2025-04-02)

### Fixed (2 changes)

- [Fix free push limit on non-saas](https://gitlab.com/gitlab-org/gitlab/-/commit/41d60e463f147b2cc76889e0f97a3192a9654ec9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186166))
- [Ensure runner taggings are copied from taggings](https://gitlab.com/gitlab-org/gitlab/-/commit/225b22847600e53bcf83d26b85e0a5e80b38c470) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186279))

### Other (1 change)

- [No-op ci_runner_machines_687967fa8a table backfill migration](https://gitlab.com/gitlab-org/gitlab/-/commit/5e9c7c787a1fb500707fbbceea2dccd1fd86ab92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185304))

## 17.10.1 (2025-03-26)

### Security (7 changes)

- [Sync organization user access when admin status changes](https://gitlab.com/gitlab-org/security/gitlab/-/commit/49c7f443c828187785f8714509933a1228e00c89) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4882))
- [Prevent XSS via merge error on the merge request page](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8410e21aa289a55ce8e65258af5bcc2c3073e1f1) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4881))
- [Inherit current_user external status while rotating project/group token](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c9a33f8331d54a8925006c5dce8738203328e759) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4865))
- [Add validations for the project_name of Harbor integration](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8fdb151d20d24d9f51dac9efa0aba92d6a31ce97) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4864))
- [Sanitize returned input on asciidoc Timeout](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e32acea8a77d03b3403a097e2284e173885884b0) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4863))
- [Add CI/CD project setting `allow_composite_identities_to_run_pipelines`](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5cfde6ed6799bb16350aab55218b0904ccb7b053) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4876))
- [Add limit to resource counts in tfplan merge request report](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0ec13496f360b7d600cf604995d8f90276bef0c9) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4870))

## 17.10.0 (2025-03-19)

### Added (150 changes)

- [Add CI runner manager custom executor count to service ping](https://gitlab.com/gitlab-org/gitlab/-/commit/0ff760ca3f36016b6558c9d27e3b0cefeb1fe827) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184308))
- [Add compliance control: auth_sso_enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/e386ea2d8ebab9512a2552011da1e10520595ee8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183762)) **GitLab Enterprise Edition**
- [Protected containers: Integrate delete protection in REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/074e863f366b85096f8e59dd93ba046b30692de8) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183729))
- [Destroy compliance statuses when project is deleted](https://gitlab.com/gitlab-org/gitlab/-/commit/48105bbba27648d01879e9c72ab2f0538abec2b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183997)) **GitLab Enterprise Edition**
- [Add GraphQL query for organization cluster agents](https://gitlab.com/gitlab-org/gitlab/-/commit/0a58bad5b22f26825368ffbc1560b74c05637c5f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183728))
- [Export squash options](https://gitlab.com/gitlab-org/gitlab/-/commit/2219cde7bf1098f3f07d51a22d30d3d8c5ccb622) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175472)) **GitLab Enterprise Edition**
- [Add query to pipeline inputs form](https://gitlab.com/gitlab-org/gitlab/-/commit/10237c60e0680d7a219d504320a1b87205f4f7a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183587))
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/f90fc44e30f41f8a33d0ff8b8b79765d94189d76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184718))
- [Added graphql query for listing project compliance statuses](https://gitlab.com/gitlab-org/gitlab/-/commit/c1e2223ba7c2321445d6de70bacdf4df737ad830) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183640)) **GitLab Enterprise Edition**
- [Emit input data to pipeline new form](https://gitlab.com/gitlab-org/gitlab/-/commit/1e8c63a524d7c3a9c9fb1ff92a4bdaa2d11bcbeb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184375))
- [Add missing sorting options to access token APIs](https://gitlab.com/gitlab-org/gitlab/-/commit/fecf59b69b870f037442b5fea70d32b7d0c135a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184298))
- [Add work item view controls](https://gitlab.com/gitlab-org/gitlab/-/commit/663aecae54ae491c642bb5986bdb38983df8a880) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181184))
- [Backfill software_license_policies without spdx and custom_license](https://gitlab.com/gitlab-org/gitlab/-/commit/e8187711095b23e1dbefd31480512859d3daa9e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181736)) **GitLab Enterprise Edition**
- [Updating pipeline inputs form](https://gitlab.com/gitlab-org/gitlab/-/commit/9f133639227253535e7fbb30110d162abffa010b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184112))
- [Track credentials inventory page visits on SAAS, SM & Dedicated](https://gitlab.com/gitlab-org/gitlab/-/commit/c8ce6b9ae02e3f693c8986032b6c3a5cddc18c81) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184346)) **GitLab Enterprise Edition**
- [Add inputs to pipeline schedule endpoints](https://gitlab.com/gitlab-org/gitlab/-/commit/f08790547e5fa28746ae880788d96400fd0374ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184019))
- [Support filtering work items by timeframe](https://gitlab.com/gitlab-org/gitlab/-/commit/65916874d04584fa91188da709910dfd50d8f129) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181904))
- [Release GitLab Query Language (GLQL) Beta](https://gitlab.com/gitlab-org/gitlab/-/commit/bd5d4c6eaa885e0fd514e543d9d5bf1a38e00450) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184168))
- [Add createdAt field to source_user_type](https://gitlab.com/gitlab-org/gitlab/-/commit/b39d88016f4fb445487c2bac5cd944214cb6e50b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182177))
- [Automatically scan pubspec.lock files when new analyzer enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/706c6a20a3221223cb5c4877344914e0d39d23ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184379))
- [Add admin page for targeted messages basic upload](https://gitlab.com/gitlab-org/gitlab/-/commit/f08d3ffa800c991c7b22a8bd118fff0fe003e84b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183052)) **GitLab Enterprise Edition**
- [Implement vulnerability archive export API](https://gitlab.com/gitlab-org/gitlab/-/commit/ff0904799c49d21d5e82cee60ba034fd1f69d487) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183521)) **GitLab Enterprise Edition**
- [Create merge_request_approval_settings table](https://gitlab.com/gitlab-org/gitlab/-/commit/0b44f525835df85f0261eb0bc64daa3b84a26743) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183679)) **GitLab Enterprise Edition**
- [ActiveContext preprocessor for embeddings](https://gitlab.com/gitlab-org/gitlab/-/commit/5017fd3d05b4a2be28d424a2be78561b2a089809) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183693))
- [Respect tag protection rules when deleting tags](https://gitlab.com/gitlab-org/gitlab/-/commit/c99b88552ecf214475b5d6f13adebf710af57ba6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180661))
- [Show subgroup projects in the DORA projects comparison visualization](https://gitlab.com/gitlab-org/gitlab/-/commit/910ecaf74f432346fa7d420ee8a67521ad0d66f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184211)) **GitLab Enterprise Edition**
- [Enable importer_user_mapping_reassignment_csv flag by default](https://gitlab.com/gitlab-org/gitlab/-/commit/278aee25d619a71912eb645cb479020b39df64ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184169))
- [Add count of createdservice_accounts,28d](https://gitlab.com/gitlab-org/gitlab/-/commit/03dcd1495e212b94d580c6bf81bd18fd1f85a053) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183222)) **GitLab Enterprise Edition**
- [Add by_project_id scope to ProjectSettings](https://gitlab.com/gitlab-org/gitlab/-/commit/e5ad00c21571e79f1acd187b4c937588b2498858) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180296)) **GitLab Enterprise Edition**
- [Enable the `todos_bulk_actions` FF by default](https://gitlab.com/gitlab-org/gitlab/-/commit/40563c25b3cd9d3d1baf39fb38a87e1fbedd9497) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184151))
- [Add shortcut tooltips](https://gitlab.com/gitlab-org/gitlab/-/commit/f669b3a6963bbb161d35f36947da7ed698801171) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183757))
- [ActiveContext preprocessors for preload and bulk embeddings](https://gitlab.com/gitlab-org/gitlab/-/commit/dcdec6b4eea2f043aa32481a410ddaf2137d7f10) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183374))
- [Add the ability to search versions](https://gitlab.com/gitlab-org/gitlab/-/commit/c00d278bfa68375ebd0b7dcd287f2f2311e007c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183105)) **GitLab Enterprise Edition**
- [Add service account update endpoint for groups](https://gitlab.com/gitlab-org/gitlab/-/commit/5404b436347d7441bb5b0870ce1d3e3d56cb6113) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182607)) **GitLab Enterprise Edition**
- [Added code to auto approve pending promotions via ldap](https://gitlab.com/gitlab-org/gitlab/-/commit/f7d60b5b3f319ff31e884a7d796c294570ef86d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182423)) **GitLab Enterprise Edition**
- [Admin Token API: Revoke pipeline trigger tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/765c467ac4315c33ecf61e5ba0fe7f82b4572351) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181598))
- [Expose path_lock permissions in graphql endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/894e13e9c6753b396706170fc7ebadbf6b367862) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184242)) **GitLab Enterprise Edition**
- [Protected packages: Add minimum_access_level_for_delete to GRAPHQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/dd2c7c3ab12793bc8023de5bac784fb191fec601) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180260))
- [Add `usage_count` data source and visualizations](https://gitlab.com/gitlab-org/gitlab/-/commit/7b371873cfb3041ab919221d1c12529f36cd90a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183891)) **GitLab Enterprise Edition**
- [Add Duo with Amazon Q to Duo interface](https://gitlab.com/gitlab-org/gitlab/-/commit/11a972aa5d8cf7937e8810f5e2c1c0efc75c3873) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182120)) **GitLab Enterprise Edition**
- [Model experiments: Add artifacts list](https://gitlab.com/gitlab-org/gitlab/-/commit/c7cb2c8c359e8c3fb2c39782ef81c2e59360b479) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183678))
- [Add excluded_merge_requests table](https://gitlab.com/gitlab-org/gitlab/-/commit/09179454c488f3eb5601f5f9b362347fa7da61f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182488))
- [Add vulnerability_severity_overrides table](https://gitlab.com/gitlab-org/gitlab/-/commit/a985600fdcc410d872dea0f9a40bd9e347612a86) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176952)) **GitLab Enterprise Edition**
- [Introduce Ci::ProjectWithPipelineVariable model and migration](https://gitlab.com/gitlab-org/gitlab/-/commit/6197a60603908283344b91e0350fe0ca03e477f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176022))
- [Protected packages: Integrate delete protection](https://gitlab.com/gitlab-org/gitlab/-/commit/98b2aaeabd1eed7a2867f342bd9d2ba63ab595e2) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179931))
- [Add ci_pipeline_schedule_inputs table](https://gitlab.com/gitlab-org/gitlab/-/commit/378b5df8157a955108e45bbc8423b2dd647f5a48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182763))
- [Add duo_chat_troubleshoot_job to FLAGGED_FEATURES](https://gitlab.com/gitlab-org/gitlab/-/commit/317691ac2664f6ceb4a1ef9eec23abc0a530cf64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184134)) **GitLab Enterprise Edition**
- [Remove users_search_scoped_to_authorized_namespaces_advanced_search flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e951adcae07423cd2168fdfc53f5677d63e16fc5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184125)) **GitLab Enterprise Edition**
- [Add Authz::UserGroupMemberRole model](https://gitlab.com/gitlab-org/gitlab/-/commit/7c8eb82dc54b884203206bdffb598b03a9391260) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182980)) **GitLab Enterprise Edition**
- [Add `parent_path` argument to Groups GQL resolver](https://gitlab.com/gitlab-org/gitlab/-/commit/4a8aab2d65bcf3a3d0f9ee846f3bbacc25900d49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183012))
- [Added a new vulnerability_namespace_statistics table](https://gitlab.com/gitlab-org/gitlab/-/commit/6c5539a6df41b93423a715036ec17681821bdaf1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183138))
- [Support admin custom roles on SaaS](https://gitlab.com/gitlab-org/gitlab/-/commit/4117831792cc903acf9a9c62209dcf27fb441d83) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181559)) **GitLab Enterprise Edition**
- [Implement `GET /Groups/:id` SCIM endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/052e8d5b635a77ce8994ff05d395ecbdcd14ef38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181577)) **GitLab Enterprise Edition**
- [Add WorkItemWidgetVulnerabilities with related vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/7c6acbd08fbb273e5250f175ae7f747b6055b072) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183548)) **GitLab Enterprise Edition**
- [Prevent decremeting stars of project with zero star count](https://gitlab.com/gitlab-org/gitlab/-/commit/c9b3c9629ad2b537ae32104af0efc1766d09c0b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183481))
- [Added table and model for project requirement status](https://gitlab.com/gitlab-org/gitlab/-/commit/ae8b8a4fd10691298e4bd7470683bc7860c25f5f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183484)) **GitLab Enterprise Edition**
- [Enable Duo Code Review and change it to beta](https://gitlab.com/gitlab-org/gitlab/-/commit/60dc901bf62c1bce545668d6334d362a865a891d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183478)) **GitLab Enterprise Edition**
- [Add inputs adoption banner](https://gitlab.com/gitlab-org/gitlab/-/commit/e636f6533b62a10abe1729f01e97f3183f35eb0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183407))
- [Add dependency paths data to vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/98401d1dd27cfd7cd4d383448c6fa2ecb5950475) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183487)) **GitLab Enterprise Edition**
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/b2c8391c0fdab273c7a2e1d15a1a2272948f7f37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183856))
- [Show blame preferences when .git-blame-ignore-revs file exists](https://gitlab.com/gitlab-org/gitlab/-/commit/cee1cfacd22437ca8556977c93cd897011541327) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182827))
- [Bulk add controls while requirement creation](https://gitlab.com/gitlab-org/gitlab/-/commit/d883fe61541afa002f63e21202c18b53d66e5597) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181898)) **GitLab Enterprise Edition**
- [Add groups GQL query argument to only return groups with user membership](https://gitlab.com/gitlab-org/gitlab/-/commit/7fffc8b4136d61a113caa2831d697c882ed13408) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183161))
- [Add ability to force cancel jobs stuck in canceling status](https://gitlab.com/gitlab-org/gitlab/-/commit/1a70128e344b4ad63adc84134ba0207b031cba15) by @ajuckel ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179137))
- [Add put API endpoint to support uploading recipe package files](https://gitlab.com/gitlab-org/gitlab/-/commit/6eea3d1010efdcdc023e0f0d0a4c26d8867fd6d2) by @oceane_scania ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181393))
- [Add the `RecentlyViewedMergeRequestsResolver` class](https://gitlab.com/gitlab-org/gitlab/-/commit/8e4c6010d12f75cf730a2658a037b154a0698a2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183706))
- [Introduce GroupDora type with projects](https://gitlab.com/gitlab-org/gitlab/-/commit/d039f1486c4f93cc6d736d2a1e7858446039930d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181975)) **GitLab Enterprise Edition**
- [Introduce separate rate limiter for /autocomplete/users](https://gitlab.com/gitlab-org/gitlab/-/commit/c56892fd850d37dba6aaadd58bcd232d7b0bd1ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183244))
- [Track Cloud Connector token signing metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/91861f52d73a451a5d1d312878c3828aa9202e2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183676)) **GitLab Enterprise Edition**
- [Add vulnerability_severity_overrides table](https://gitlab.com/gitlab-org/gitlab/-/commit/bce60bb6a9bd6a2de27beff230ce3cebef9e420f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176952)) **GitLab Enterprise Edition**
- [Process security report observability events](https://gitlab.com/gitlab-org/gitlab/-/commit/c4be99cf6fd9777f8308aa2f093f3a70e05b229d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175612))
- [Capture job token policies for API endpoints](https://gitlab.com/gitlab-org/gitlab/-/commit/bc7f41bba693e4fb6afcec218ba2e6f7f781f371) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182582))
- [Update vulnerabilities ExternalIssueLink create service](https://gitlab.com/gitlab-org/gitlab/-/commit/a81fd7f5dfa68a8dd2d322952dec905178a5a35e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181950)) **GitLab Enterprise Edition**
- [Migrate table cell dropdown to a bubble menu](https://gitlab.com/gitlab-org/gitlab/-/commit/a3e34dfe4c15c3d865c8685b83190bce4d00b675) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182909))
- [Add Duo with Amazon Q support to SM/Dedicated provisioning](https://gitlab.com/gitlab-org/gitlab/-/commit/445de297eb3a4b2d226f60d6ed3354d8515c3d0c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183529)) **GitLab Enterprise Edition**
- [Add value renderer](https://gitlab.com/gitlab-org/gitlab/-/commit/4c119afc75d69056bab78c2b26e1ead1121fcc17) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182799))
- [Remove block_seat_overages feeature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/42db137830172086da6e0014f9fd30a1af196068) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181653)) **GitLab Enterprise Edition**
- [Add import history table and import source table components](https://gitlab.com/gitlab-org/gitlab/-/commit/d5e4d47d16a22c4034489c7e2f849dbf40d6b78f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180098))
- [Add namespace_metadata visualization and data source](https://gitlab.com/gitlab-org/gitlab/-/commit/1e0753a2b28826057b41e8b9419820df2e76c877) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183096)) **GitLab Enterprise Edition**
- [Add CSV format to group dependency export](https://gitlab.com/gitlab-org/gitlab/-/commit/78781796626b4dedb2597aaa8e4228a3b9015cff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183097)) **GitLab Enterprise Edition**
- [Restrict manual job variables](https://gitlab.com/gitlab-org/gitlab/-/commit/709a35fd11d4becb26763c2575e38d1610b28838) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183068))
- [Cloud Connector: add key rotation rake tasks](https://gitlab.com/gitlab-org/gitlab/-/commit/54a43ecebdea34e1667589302f9074212bace19a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182711)) **GitLab Enterprise Edition**
- [Create GraphQL endpoint to return pipeline inputs](https://gitlab.com/gitlab-org/gitlab/-/commit/be04d0ea0fff216ac93b64b8cddd2579574fc3ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182609))
- [Add Project.forkedFrom to graphql api](https://gitlab.com/gitlab-org/gitlab/-/commit/9ba1c9b57d20d61ff05e23204998c5b86d19aa05) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183115))
- [Add error tracking widget to work items](https://gitlab.com/gitlab-org/gitlab/-/commit/440bb7783d17ddb814e684d9ea04c0b554492817) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181983))
- [Enable cluster agents for groups](https://gitlab.com/gitlab-org/gitlab/-/commit/b8d6ec5cd500c71846ddf5891e725d3d0b470cb6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182628))
- [Apply GitHub markdown reformatting to more objects](https://gitlab.com/gitlab-org/gitlab/-/commit/16570e16526ead2673d16eda5e46dadbe102f92e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181297))
- [Improve pipeline execution policy documentation](https://gitlab.com/gitlab-org/gitlab/-/commit/4e6657b52057a2a53f8c20687e163c165a88e3b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182269))
- [Add GraphQL API for querying dedicated usage filters](https://gitlab.com/gitlab-org/gitlab/-/commit/747d7f9796b33e5af5b364a70ce9f4b7089774f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181383)) **GitLab Enterprise Edition**
- [Add namespace package setting for audit events](https://gitlab.com/gitlab-org/gitlab/-/commit/6e1017c7db9da4e696bb6fbd3203355deed9f1c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182310))
- [Adding the CI_PROJECT_NAMESPACE_SLUG variable](https://gitlab.com/gitlab-org/gitlab/-/commit/481185f5bfcb475d6ad8df8d7b66bd82a5f18168) by @tonton1728 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181988))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/d8222b92a2c63fb1fd44bd3511a01d173a26c1fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183193))
- [ActiveContext OpenSearch processor for queries](https://gitlab.com/gitlab-org/gitlab/-/commit/61448378d87d011d0ee462548111e50ce0cf47a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183192))
- [Add support for /epic on work_items](https://gitlab.com/gitlab-org/gitlab/-/commit/3e19a48db9e3043b8f7aef2a1567d973db1048b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181750)) **GitLab Enterprise Edition**
- [Add `organization_id` field to `fork_networks`](https://gitlab.com/gitlab-org/gitlab/-/commit/34c02117ed94dbb83d583852ec0ec30f67f55f88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182898))
- [Add vulnerability id for create work item](https://gitlab.com/gitlab-org/gitlab/-/commit/80a8757f432c2d2e464c5717d35cd3a49b6b9c3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181895))
- [Pre-select permissions when creating a custom role](https://gitlab.com/gitlab-org/gitlab/-/commit/080b2dac7f9dd28879dfb62d0114a609c9da903c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178060)) **GitLab Enterprise Edition**
- [Append any value defined in pages.publish to artifact paths](https://gitlab.com/gitlab-org/gitlab/-/commit/f4fe9adc6581fbebbdcb7a2b3bc4b405dbe714ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180239))
- [Add a limited count field to registries](https://gitlab.com/gitlab-org/gitlab/-/commit/2da96a9139f78087ec65db80dd997d863028202a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183189)) **GitLab Enterprise Edition**
- [Implement `POST /Groups` SCIM endpoint for self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/bda74db95a055eaa7720b22a00867f1b162235b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180831)) **GitLab Enterprise Edition**
- [GraphQL query for component dependency path](https://gitlab.com/gitlab-org/gitlab/-/commit/01b9e3dbb1e0a59c6f709e2cb79ffe21826cd101) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182289)) **GitLab Enterprise Edition**
- [Add pipeline inputs table](https://gitlab.com/gitlab-org/gitlab/-/commit/39762c32ec5147924304e1e4320686cf16bf36f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182676))
- [Add worker to assign security bot for namespaces](https://gitlab.com/gitlab-org/gitlab/-/commit/97a31e6586895bf2e461f577b15f86c597f8e483) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181182)) **GitLab Enterprise Edition**
- [Remove feature flag change_data_consistency_for_permissions_workers](https://gitlab.com/gitlab-org/gitlab/-/commit/fa64b4ffc6fee61e2591cd334bbe63e2c5952cde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182975))
- [Allow users to /q test in mr note](https://gitlab.com/gitlab-org/gitlab/-/commit/952392123f3c5764ec1b2d00c87e4732c76f3af7) by @jlosito ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182010)) **GitLab Enterprise Edition**
- [Add models for system defined status](https://gitlab.com/gitlab-org/gitlab/-/commit/91e8062dcf2ea2fba8f0e0b1ace91b6582542327) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181962))
- [Add default role to variables settings](https://gitlab.com/gitlab-org/gitlab/-/commit/a240e2b741a3f02975974ac408b4552a9226c8ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181272))
- [Add index on merge_request_diffs for id and project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/2b5e662ed26b2ff40cd6d677ea48371fa084bcd5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173929))
- [Support duo_chat_2 conversation type](https://gitlab.com/gitlab-org/gitlab/-/commit/dbaf33ea2547f3658fdb70bab1422bfa535ffd6f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181771)) **GitLab Enterprise Edition**
- [Expose CI_JOB_GROUP_NAME variable for builds](https://gitlab.com/gitlab-org/gitlab/-/commit/cd0ce46c878ad8c521e02d1d7ab3a56107700544) by @azinke ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179447))
- [Add find_or_initialize_project_control_status](https://gitlab.com/gitlab-org/gitlab/-/commit/6bb465ef64ab325605d62196a866207717ff444e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180107)) **GitLab Enterprise Edition**
- [Expose `blocked_work_items` feature availability in WI permissions](https://gitlab.com/gitlab-org/gitlab/-/commit/ac8edbb59ecc74d007303de508e3f3a72b71e7c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182158)) **GitLab Enterprise Edition**
- [Add GraphQL for WorkItems::UserPreference](https://gitlab.com/gitlab-org/gitlab/-/commit/e2d5263ee9f18ef213f41bd386fe42afb9a389f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176975))
- [Release PAT expiry notifications to inherited group and project members](https://gitlab.com/gitlab-org/gitlab/-/commit/1acddc4e2a70d9b52eeb0d83063b721ffa219377) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182055))
- [Promote model version through api](https://gitlab.com/gitlab-org/gitlab/-/commit/600cfc3169aef35e2ebce46dfe6bff9ead9f916e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182777))
- [Introduce a GraphQL mutation to archive vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/f1872a8335f6b88b1eea2da5fd39d4c6babf2539) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181986)) **GitLab Enterprise Edition**
- [Add user_discussions_count to WorkItem API](https://gitlab.com/gitlab-org/gitlab/-/commit/5d0a04b4dd55874cae26b4b393bd2048e9422446) by @vedant-jain03 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179164))
- [Add migration to create missing nuget symbols](https://gitlab.com/gitlab-org/gitlab/-/commit/2148e0dc8fc667635cbbb5fc8699250121e1fd2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173869))
- [Enable users to fetch all WorkItems they have access through GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/83be9dc0b25f78c83d8af5194ddd99e3ff14bdc2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177484))
- [Preload policies in contributed and starred projects resolvers](https://gitlab.com/gitlab-org/gitlab/-/commit/1bfafed705e6f6366429823d93c81ae9fbb0887e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182494))
- [Markdown: Select text and paste URL to create link](https://gitlab.com/gitlab-org/gitlab/-/commit/bcd2a3bcc3f4b91c4e5afc6828df8e1bbe03d083) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182471))
- [Add export dropdown to dependency list](https://gitlab.com/gitlab-org/gitlab/-/commit/f112339a2cf3853179fc89aeff5383a9b1260a97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180617)) **GitLab Enterprise Edition**
- [GraphQL: search by commit in the repository](https://gitlab.com/gitlab-org/gitlab/-/commit/013cd757b4e6441bf77b0948e22d8e7d7f3c967e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179542))
- [Add external control fields to GraphQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/7017d5d7f382e0f179282e9dfbcb7ee22aebaf31) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181318)) **GitLab Enterprise Edition**
- [Make Ci::Runner#token routable](https://gitlab.com/gitlab-org/gitlab/-/commit/82024706866a6ba3ce64ce25bfc9d22464bec059) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170634))
- [Removes limited_capacity_member_destruction FF](https://gitlab.com/gitlab-org/gitlab/-/commit/f636f1de5af54404ac76c4c6d3ebd7d8892c8198) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180185))
- [Add comment summarization to work items](https://gitlab.com/gitlab-org/gitlab/-/commit/f75414f0787901a7ca9565f8bf36d6ee34c7aaaa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181712)) **GitLab Enterprise Edition**
- [Removes billable_member_async_deletion FF](https://gitlab.com/gitlab-org/gitlab/-/commit/543a9f346f427743a7513e779b28d81f9e7f910a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180184)) **GitLab Enterprise Edition**
- [Show auto-resolve info banner on vulnerability report](https://gitlab.com/gitlab-org/gitlab/-/commit/741da3d24853da9e3084d8d9af116cdeaa9c879f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181967)) **GitLab Enterprise Edition**
- [Make Users API rate limits configurable](https://gitlab.com/gitlab-org/gitlab/-/commit/4ed1d53f75058b391a135323788383d22122feef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181054))
- [Add switch for CI/CD Job Token format](https://gitlab.com/gitlab-org/gitlab/-/commit/953335cecad9625afa08aa0f44a7ee99c119c5d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181293))
- [Show Start/Due date sort options in Work Item list](https://gitlab.com/gitlab-org/gitlab/-/commit/eb0f231b4b440d525960e7924aefc6cfca52ee7b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182173))
- [Remove feature flag pipeline_execution_policy_analyze_configs](https://gitlab.com/gitlab-org/gitlab/-/commit/d834b44e1ddc9133be84e4f4009f18d6b14bc50b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181963)) **GitLab Enterprise Edition**
- [Add import history stats and error components](https://gitlab.com/gitlab-org/gitlab/-/commit/81f0cc980422fdc96084ab00f1aae21f267a8c23) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181146))
- [Add runner ID filter for dedicated usage query](https://gitlab.com/gitlab-org/gitlab/-/commit/4d2b776c4b7d22ee1bc4fa09bf915851067326d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181916)) **GitLab Enterprise Edition**
- [ActiveContext OpenSearch executor for migrations](https://gitlab.com/gitlab-org/gitlab/-/commit/ef037daaf65a75748fba84d529c888f825af81c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181971))
- [ActiveContext Find partition by serializing collection](https://gitlab.com/gitlab-org/gitlab/-/commit/010dc11145cd18c3a4e9dc27503a57cfabefe72a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181525))
- [Mutation for destroying compliance control](https://gitlab.com/gitlab-org/gitlab/-/commit/f2c8c7c90b9b389026fa225f8952cbb64e850040) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177878)) **GitLab Enterprise Edition**
- [Add Support PIN UI functionality](https://gitlab.com/gitlab-org/gitlab/-/commit/3bf456b1fe8e3c31ed8793289fd58df46c81e8cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176922))
- [Add system note when submitted review is "comments only"](https://gitlab.com/gitlab-org/gitlab/-/commit/45c24bde9d692e042b86a9910829dd9e841eb767) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179149))
- [Enable work item description templates](https://gitlab.com/gitlab-org/gitlab/-/commit/a38540c58ed75d15cf8b9215286b6b4eeae41450) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181688))
- [Protected packages: Add basics for package delete protection](https://gitlab.com/gitlab-org/gitlab/-/commit/241a1dc3e3f74996f62aee1208a5db0db34d3046) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179739))
- [Display warning banner when LFS is misconfigured](https://gitlab.com/gitlab-org/gitlab/-/commit/05d5a2034f2b2e4ef97f3641d7d31be1cc30ca51) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181953))
- [Expose error tracking stack trace though GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/5d848cf139d116004f57e599925adcb9f264b46a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181520))
- [Adds project_id and namespace_id to JWT payload](https://gitlab.com/gitlab-org/gitlab/-/commit/df5a3ac35174b81aa16e90cdbe8d6b6879f0d7e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180975))
- [Add peek functionality for ResourceUsageLimiter](https://gitlab.com/gitlab-org/gitlab/-/commit/64a1d528b65f0afec148df972b4a92f935ccb4fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174808))
- [Add move button to work item Issue type actions menu](https://gitlab.com/gitlab-org/gitlab/-/commit/10e007178488cb7473d56da2417ed041c96859b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178799))
- [Add support for api site profiles in DAST Scan Execution Policies](https://gitlab.com/gitlab-org/gitlab/-/commit/5849f39b6cf27cdecaaeae4e45218b0b844e8b50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181411)) **GitLab Enterprise Edition**
- [Clean up display_password_requirements feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/55e94756c3d8337cc38b1a7914820584dfe3d4d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181446)) **GitLab Enterprise Edition**
- [Handle Silent Mode for Audit Events streaming](https://gitlab.com/gitlab-org/gitlab/-/commit/ff7b8d7fde8a37b37503636f65aa5c85d020b5db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181421)) **GitLab Enterprise Edition**

### Fixed (183 changes)

- [Detect JSON tables even with other lang params](https://gitlab.com/gitlab-org/gitlab/-/commit/292c8ffa2f3d7d8d0f47a9198538a2a0a31294c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184635))
- [Make sure a.anchor::after has position absolute all the time](https://gitlab.com/gitlab-org/gitlab/-/commit/c1dcb71b1bbc80e840ebbf08e779683c62998919) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184220))
- [Do not enforce job token permissions for public endpoints](https://gitlab.com/gitlab-org/gitlab/-/commit/e7c4bc1d5bdbd23fbef1a2e50a3fb78f0e4f95f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184087))
- [Fix URL escaping in badges API](https://gitlab.com/gitlab-org/gitlab/-/commit/a7329a7c08b2f1120e59266e7581f682beca441f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183543))
- [Add migration to delete zoekt_replicas with evicted zoekt_indices](https://gitlab.com/gitlab-org/gitlab/-/commit/52c2600fe5210921814c06eb32c884de09f89ff8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183685))
- [Fix group level auth for epics advanced search](https://gitlab.com/gitlab-org/gitlab/-/commit/4970eff19fff21b05b379820e8721044fe4678c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183748)) **GitLab Enterprise Edition**
- [Handle duplication error](https://gitlab.com/gitlab-org/gitlab/-/commit/331dad5654cc4f1a51f225fc05be8c717096a401) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184116))
- [Fix comment templates](https://gitlab.com/gitlab-org/gitlab/-/commit/4f47d3a1b79133d7e34ef10fa60fb7adb83a00ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181913))
- [Add conditional Flux reconciliation update](https://gitlab.com/gitlab-org/gitlab/-/commit/20c4a32f9d0f64f5c856a8be135f66b6aa6fb218) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184505))
- [Fix integrations table alignment](https://gitlab.com/gitlab-org/gitlab/-/commit/162506aa1f6c74ad4b3cbdf9cb1ecc803e524aae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184538))
- [Fix VSA filtered search bar overflow issue when many filters are applied](https://gitlab.com/gitlab-org/gitlab/-/commit/fc3e4fb731dfc097cb590f3902f49bed41887352) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184520))
- [Prevent new user registration when block seat overages is enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/4c35d12bb2ee647da185ba77d599e7a8a72c7f72) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183913)) **GitLab Enterprise Edition**
- [GLQL table: Fix inclusion of table in description field](https://gitlab.com/gitlab-org/gitlab/-/commit/f04c4eadd5785b631e5d8a53db025cd3a6db7b75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184435))
- [Rolled up dates only when rollUp is true](https://gitlab.com/gitlab-org/gitlab/-/commit/f70825f10d5b6f30a5dfd84c18a6173099665729) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183455))
- [Fix: Skip agent authorization check for environment creation in REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/2ea4c98270a76bcee6076e62e34cb848373397c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184403))
- [Stop scroll misbehavior when linking to comments](https://gitlab.com/gitlab-org/gitlab/-/commit/ee0d8c9c7bc426f9a0f3c8e5168e4e063440c32e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184009))
- [Prevent WI sticky header edit button from shrinking when title is long](https://gitlab.com/gitlab-org/gitlab/-/commit/4dc4486acc993895573c8f680b7795a3ae3a5aaf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184370))
- [Add additional checks for group projects](https://gitlab.com/gitlab-org/gitlab/-/commit/5ddc49644b4a823ee21c5beb75eda09f24d1ff4e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184350)) **GitLab Enterprise Edition**
- [Only load vulnerability related records when actually exporting](https://gitlab.com/gitlab-org/gitlab/-/commit/8129bf948471ba32e66c439c73311a77217b8f38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184195)) **GitLab Enterprise Edition**
- [Reorder runners backfill migrations](https://gitlab.com/gitlab-org/gitlab/-/commit/73f53b6c5b762686a30c74a95b9d70ebbb033cb1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184341))
- [Ignore math on spaced_link_filter](https://gitlab.com/gitlab-org/gitlab/-/commit/cd90ac39b4eda4d2c7407135923ce81370a850ab) by @Bubbis ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182626))
- [Fix read more button styling](https://gitlab.com/gitlab-org/gitlab/-/commit/d73c72a76e02169002b34ac4e230f76199513556) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184262))
- [Zoekt: Fix undefined feature flag handling in gitlab:zoekt:info](https://gitlab.com/gitlab-org/gitlab/-/commit/e256adfb3719ced95f2d3d65ecca40f2eafca1a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184315)) **GitLab Enterprise Edition**
- [Refactor rule_index while updating security policy](https://gitlab.com/gitlab-org/gitlab/-/commit/ab2cdaddfdc50e2c768223b26e374260f08d5567) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183117)) **GitLab Enterprise Edition**
- [Return an error if the parent DNE / Lacks permissions](https://gitlab.com/gitlab-org/gitlab/-/commit/c02e35aba467208a49f8a410ce7e30c0df87021c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183938))
- [Removes ordering requirement for funnel sync test](https://gitlab.com/gitlab-org/gitlab/-/commit/8c7211bcf6c6a626c70ef95c6221f528896ba204) by @max.woolf ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184167))
- [Add check for nullability for compliance framework](https://gitlab.com/gitlab-org/gitlab/-/commit/80dacf519c6c6cb8c7c2f9798104f9e83514a10f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183665)) **GitLab Enterprise Edition**
- [Fix sorting issue credential inventory](https://gitlab.com/gitlab-org/gitlab/-/commit/836b8d90e45b9e42deaf227336abd6e2271e93a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183076))
- [Add `description` param to the service access tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/5bda9dffa3bc75f3e365fbc27dcd2e1e00dd70f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184099))
- [Reduce redundant Redis parameter initialization](https://gitlab.com/gitlab-org/gitlab/-/commit/ba04c2c1baf5e337c26944628d5d685d1adc8be3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184218))
- [Fix gitlab:elastic:info rake task](https://gitlab.com/gitlab-org/gitlab/-/commit/4c602bd80431c20b978061327f516f55bdcd87b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184278)) **GitLab Enterprise Edition**
- [Fix work item draft and description with "\n\n"](https://gitlab.com/gitlab-org/gitlab/-/commit/87c3e20492c3bff884fb43115db95cf921052f8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184273))
- [Add fallback for yaml editor](https://gitlab.com/gitlab-org/gitlab/-/commit/12d75bbde14dfba0a7888d6b7c0837e49c42ba39) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183917))
- [Improve a11y of Integrations table](https://gitlab.com/gitlab-org/gitlab/-/commit/19760748a3040424f67095ca78c5584dcd001b06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183756))
- [Fix inconsistent state for project-level approval settings](https://gitlab.com/gitlab-org/gitlab/-/commit/14e9785890325f4793b24f5a387d3a49d0382210) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183677)) **GitLab Enterprise Edition**
- [Ensure "Edit release" links have accessible labels](https://gitlab.com/gitlab-org/gitlab/-/commit/8dc2fef337a0247cec4a2a361931901e11183ba5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183749))
- [Fix error when fetching custom roles when used in policies](https://gitlab.com/gitlab-org/gitlab/-/commit/e4c5855c011b493275b6d45b333436d18cde76c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183506)) **GitLab Enterprise Edition**
- [Add 99 to valid onboarding_status_role value](https://gitlab.com/gitlab-org/gitlab/-/commit/98e2a7d659dd64d0374990d0ad9412fa561bdee8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184159)) **GitLab Enterprise Edition**
- [Don't use DestroyExportWorker on successful export](https://gitlab.com/gitlab-org/gitlab/-/commit/4c895fd1c74ff725cc9efe68bad87f1f1d0635ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184175)) **GitLab Enterprise Edition**
- [Fix CI/CD variable settings with custom role](https://gitlab.com/gitlab-org/gitlab/-/commit/63e034a43296ac1fbd632ebd458e9167da693a41) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183448))
- [Fix merge request pipelines on ambiguous refs](https://gitlab.com/gitlab-org/gitlab/-/commit/9e126a06392558f8f4787cfd55c1bc0f34992c62) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158976))
- [Remove tsquery_deduplicate_search_terms feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/076fd9d3aa223ded31fb11a6c66c92950f01c9fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183538))
- [Handle undefined body and html for rte](https://gitlab.com/gitlab-org/gitlab/-/commit/0792e0e9f73c4e20c941543b707bc8eaae4195cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184140))
- [Use normalized package_name during](https://gitlab.com/gitlab-org/gitlab/-/commit/47a734bb9cfdbeb1728dddfe34e7d88fe5772f29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183995)) **GitLab Enterprise Edition**
- [Update pipeline variables polling](https://gitlab.com/gitlab-org/gitlab/-/commit/2ea276fb72ed30bb2ff890ab82d1fcd0c80eefcf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183881))
- [Fix rebase failure alert variant](https://gitlab.com/gitlab-org/gitlab/-/commit/d6a647ce6583c6e35b3b2f47f8d8c796c36c56c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184085))
- [Ensure "Edit release" links have accessible labels](https://gitlab.com/gitlab-org/gitlab/-/commit/58234022a177f8bba09ce7e7b459f3fb5d029f1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183747))
- [Adapt Duo Chat Slash commands for multi-threaded](https://gitlab.com/gitlab-org/gitlab/-/commit/435a8408c1dc0b4f0ec9be6d0222596f3ede3292) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183822)) **GitLab Enterprise Edition**
- [Passing color contrast for job log line numbers](https://gitlab.com/gitlab-org/gitlab/-/commit/f42daf67b72a3d3af7fc3db27fb7d1c3190e5f14) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179551))
- [Show full job sidebar when troubleshoot bar exists](https://gitlab.com/gitlab-org/gitlab/-/commit/c64143a64c44f534ddb72bb6aaf0e0c926c212e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184053))
- [fix: Use short ref name as fallback in pipeline UI](https://gitlab.com/gitlab-org/gitlab/-/commit/5ac5fc25933c71fda32a3e8ecc760b44e19210be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184052))
- [Add unverified_author_email to grahql endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/763dae9e6b0848fb2066f458c64905c6e374dfe7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181805))
- [Allow anonymous users to load pipeline analytics](https://gitlab.com/gitlab-org/gitlab/-/commit/60839c49f24800433380a6cf1724b3801a441e8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184032))
- [Fix WorkItemType for reference work items](https://gitlab.com/gitlab-org/gitlab/-/commit/8cf4e1496ac11e4df12491dbd75e0bfaaee5f7e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183647))
- [Stop redirection loop with welcome during onboarding](https://gitlab.com/gitlab-org/gitlab/-/commit/4cfcc6d997a75c36ffb1407ac7c057081c6f64d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183899)) **GitLab Enterprise Edition**
- [Capture model experiment creation RecordNotUnique error](https://gitlab.com/gitlab-org/gitlab/-/commit/8262f11a4e82b11183453beadc5fd33720845fdc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183515))
- [Fix frozen array error with custom analyzers](https://gitlab.com/gitlab-org/gitlab/-/commit/0337089fedacf862073554e7efb6002a222a36fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183879)) **GitLab Enterprise Edition**
- [Fix Rack Attack incorrectly rate limiting runner API](https://gitlab.com/gitlab-org/gitlab/-/commit/f3547556874377474cfe1f64ccbb22f83088a8e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183764))
- [Fix SHM health check not enabling properly](https://gitlab.com/gitlab-org/gitlab/-/commit/f15f2bb428b3b968f4e6f4c1bc8138bb5e2e0123) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183692)) **GitLab Enterprise Edition**
- [Use Redis pipeline creation for MR commit pushes](https://gitlab.com/gitlab-org/gitlab/-/commit/cd290ed3a3a5a6d95eb7682f819033d51a9fb5c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182449))
- [Use design tokens for diff file row and linked diff file](https://gitlab.com/gitlab-org/gitlab/-/commit/31c22efb66f6aa22e5873aa5e41da7e3abf2efdc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183456))
- [Convert DuoEnterprise trials lead form to view component](https://gitlab.com/gitlab-org/gitlab/-/commit/b798acf110292b70f58bfe4e7e74659db0e07716) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181874)) **GitLab Enterprise Edition**
- [Fix confidential filters for epics advanced search](https://gitlab.com/gitlab-org/gitlab/-/commit/f877c05292ba8dce79a21dca6c4b035b133218f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183437)) **GitLab Enterprise Edition**
- [Add all actions to sticky header](https://gitlab.com/gitlab-org/gitlab/-/commit/c0bcc11ee7c87b0929de3a4360543ba12a20228f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183547))
- [A11y improvements for user profile and admin user groups/projects page](https://gitlab.com/gitlab-org/gitlab/-/commit/d3c36d30eaabbcbb2269737dd784fefe8771d656) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183438))
- [Ensure revoke token buttons have unique link text](https://gitlab.com/gitlab-org/gitlab/-/commit/17eba2966bce266c1c53ee148a25ef2c48237876) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183265))
- [Fix path rejection for Dependency path](https://gitlab.com/gitlab-org/gitlab/-/commit/c619aed99d762435b976d2b952cb1bf5ed2260ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183682)) **GitLab Enterprise Edition**
- [Make sure aside has its implicit complementary role](https://gitlab.com/gitlab-org/gitlab/-/commit/8d26b5a8977a99875ad57990439c71ef8deb219c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163483))
- [Fix admin_display_duo_addon_settings? check](https://gitlab.com/gitlab-org/gitlab/-/commit/e430aa150ff69f89553f28d4c0eae7be55fd9266) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183507)) **GitLab Enterprise Edition**
- [Prevent invalidating remember tokens on logout](https://gitlab.com/gitlab-org/gitlab/-/commit/ce87820a7879854e1b4d891ec5e6cecdcdedad57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183471))
- [Fix checkbox toggling in work item notes](https://gitlab.com/gitlab-org/gitlab/-/commit/59fb1b71fde5b2baf98da1f049ee78d4dfe6fb36) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182771))
- [Fixes CE profile Usage Quotas rendering](https://gitlab.com/gitlab-org/gitlab/-/commit/26dda60685d6d6e6bc856e8e499337175f58f60f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183577))
- [Don't auto-resolve dismissed vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/0c393436c2bdca79b59eb9bed59204b0efadd139) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183430)) **GitLab Enterprise Edition**
- [Include before_sha in PEP pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/7ab7e8b5779495b84e9736a41cd56932e533af09) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182876)) **GitLab Enterprise Edition**
- [Added long line truncation for frontend highlighting](https://gitlab.com/gitlab-org/gitlab/-/commit/5331b6595deda1f9335dc159da3295a8b98782a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180761))
- [Requeue migration to resync policy project links](https://gitlab.com/gitlab-org/gitlab/-/commit/16e6f0d7d385b9a592954b5295fd9986f9d5c497) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183065)) **GitLab Enterprise Edition**
- [Capture model registry version creation PG errors](https://gitlab.com/gitlab-org/gitlab/-/commit/4983076ce1b477e1917477127dc664ce9bdef9a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183475))
- [Do not disable OAuth by "Disable personal access tokens" group setting](https://gitlab.com/gitlab-org/gitlab/-/commit/cc8aa847dc94ac1137e44b9756dbeede53b4e4aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183488)) **GitLab Enterprise Edition**
- [Stop user onboarding for group saml](https://gitlab.com/gitlab-org/gitlab/-/commit/7ac701f3ebf87cec739b6c73bbb1f60e2b68da52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183252)) **GitLab Enterprise Edition**
- [Update PruneProjectExportJobsWorker cronjob schedule](https://gitlab.com/gitlab-org/gitlab/-/commit/6c12d7f4e62e3e3cd022149a1fd8b352e6ccbf85) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182971))
- [Add optional chaining to ref response](https://gitlab.com/gitlab-org/gitlab/-/commit/6be2fb04c6d44f908c6bb353d9f73134bab43631) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183463))
- [Improve a11y of Help menu](https://gitlab.com/gitlab-org/gitlab/-/commit/9ee75f409cd732fac04028728e4f9adf6c4e66ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183443))
- [Ensure feature flag edit buttons have unique link text](https://gitlab.com/gitlab-org/gitlab/-/commit/ff5b26da8223f551d23727614b7f17548156acde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183262))
- [Remove filter_saml_enforced_resources_from_graphql feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3dfd246265acffb47d687e6ff570c7cd61effa88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183417))
- [Improve a11y of links in Whats New drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/6c972a1025f12977e675b8ab27effd38db834c7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183411))
- [Show copy to clipboard button on mermaid code block](https://gitlab.com/gitlab-org/gitlab/-/commit/51c99b275e8f029d45fc821544d3170c14681739) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183247))
- [Fix RTE loading indicator position](https://gitlab.com/gitlab-org/gitlab/-/commit/4ab6ae83369e6dc425b32069fe4feb841c5e03ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183358))
- [Ensure user edit links in admin have unique text](https://gitlab.com/gitlab-org/gitlab/-/commit/d3776f58bfee2dbd6317f0eacec18194a4d203f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183268))
- [Ensure docs and config links on admin dashboard are accessible](https://gitlab.com/gitlab-org/gitlab/-/commit/92bbbbe6d7716fb430a0b5613089348600818502) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183379))
- [Fix source and target branch in dev widget](https://gitlab.com/gitlab-org/gitlab/-/commit/f869a5f30ad71946f26f2fd38a4b044aa4cbc522) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182504))
- [Fix group filter on work items list](https://gitlab.com/gitlab-org/gitlab/-/commit/71ea84e06fa0f37ab7caa2ff259f87b81cb6934c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182163))
- [Fix custom_ability_ feature flag usage](https://gitlab.com/gitlab-org/gitlab/-/commit/e2a0044a21eb2f34421407c6330ddf7326eccca3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181738)) **GitLab Enterprise Edition**
- [Fix pipeline marked invalid when var is empty string](https://gitlab.com/gitlab-org/gitlab/-/commit/6f7428aa9d35043e547d8cd49af29f22a7e22441) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182993))
- [Add aria-desrcribedby for status links in admin jobs table](https://gitlab.com/gitlab-org/gitlab/-/commit/7f428f94f13e0d9bffb626206a17aacc457adcde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183271))
- [Fix open vsx resource url template](https://gitlab.com/gitlab-org/gitlab/-/commit/934cd0b99786c79f88cd85aee3eb0713c26f23d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183071))
- [Stream audit events only once using feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d25fe8a7bab78fe6a08add1d404c6ecc314ed9ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182587)) **GitLab Enterprise Edition**
- [Fix missing graphql field](https://gitlab.com/gitlab-org/gitlab/-/commit/04d9869db9c7a8ab420824a9097ca17c1b4fd279) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182755))
- [Skip entry owners check for exclusion pattern](https://gitlab.com/gitlab-org/gitlab/-/commit/d372d595a373019a8911fc4ebfc342dc5a305aa7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182403))
- [Fix invalid sort in placeholder users app](https://gitlab.com/gitlab-org/gitlab/-/commit/3e701946fbd9edf1701cd1af653cafab4aa8f8ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183210))
- [Fix emoji key in suggestions dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/e3c0846074f55ff1b8663a21e2e0a77ef7192a37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183206))
- [Abuse report: Fix a11y issues](https://gitlab.com/gitlab-org/gitlab/-/commit/8c0885c040e944e05f922d9c7a8170d86d09da59) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182237))
- [Process auto megre on page load if required](https://gitlab.com/gitlab-org/gitlab/-/commit/b4afe537d2771232a0925f1ea4fdf19d69d1aafb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182992))
- [Fix downloads failing due to duplicate SSRF filters](https://gitlab.com/gitlab-org/gitlab/-/commit/b42c01c7b2ae04d03f6404bba02c102d1a3621e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182493))
- [Implement repository archive cache cleaning inside Workhorse](https://gitlab.com/gitlab-org/gitlab/-/commit/6ba452632a17b32d4b33dab2bac117d0bf4388ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182796))
- [Split cyclonedx artifact into multiple reports](https://gitlab.com/gitlab-org/gitlab/-/commit/fca94833bb4694bc11989cf4694d7ce3184f950e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182324)) **GitLab Enterprise Edition**
- [Fix the pipe search for zoekt exact search mode](https://gitlab.com/gitlab-org/gitlab/-/commit/2efdc94d5f275b73561f5bc995ecbac8f227b48a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181424))
- [Fix workItem parent dropdown item click](https://gitlab.com/gitlab-org/gitlab/-/commit/55d5bbf5098b0addbe4d314b2029f47f59f27360) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183030))
- [Preserve selected items in dropdown text](https://gitlab.com/gitlab-org/gitlab/-/commit/f8380923b9cfa09edbbd71e966bcc8a3b2d9d7c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182644)) **GitLab Enterprise Edition**
- [Model runs: Handle not destroyed error](https://gitlab.com/gitlab-org/gitlab/-/commit/d6f6576effe05e5674fa201d9383520ba50fc4fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183004))
- [Return a bad request status if an environment fails to stop via API](https://gitlab.com/gitlab-org/gitlab/-/commit/c56d035749724865d7af64522cb9da6ca64e12b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181339))
- [Update typo](https://gitlab.com/gitlab-org/gitlab/-/commit/7150c42a347e74248764f5740c226ecb1ba26714) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182964))
- [Reset selected exceptions projects](https://gitlab.com/gitlab-org/gitlab/-/commit/90e389ee13fe424ac6ce75b9be5f6b54998c6693) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182951)) **GitLab Enterprise Edition**
- [Adjust help text for instance wide restricted access setting](https://gitlab.com/gitlab-org/gitlab/-/commit/35a26ea5a74820766963e95b25ece5faf19a160c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182942)) **GitLab Enterprise Edition**
- [Fixed missing regex and syntax options buttons in topbar](https://gitlab.com/gitlab-org/gitlab/-/commit/56e67fb1140ef5e8187a3c23be5459f56ec556c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182879))
- [Delete security_policies when policy.yml becomes invalid](https://gitlab.com/gitlab-org/gitlab/-/commit/97faf8265c2515d8be730d59347036c074d512d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181837)) **GitLab Enterprise Edition**
- [Show rebase button if user can push to source branch](https://gitlab.com/gitlab-org/gitlab/-/commit/b1ee4cb4ec7f2c3004fec739dc41b9a19779d055) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182793))
- [Fix emoji award button styling for selected state](https://gitlab.com/gitlab-org/gitlab/-/commit/55b0ea60941defa2f88173aef312090303122df4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182787))
- [Prevent CiIcon text color from being overridden](https://gitlab.com/gitlab-org/gitlab/-/commit/5b56510e4ed97325f49eb9446c1ac57de973061f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182780))
- [Ensure badge popover opens on click](https://gitlab.com/gitlab-org/gitlab/-/commit/564879f68bd353271e1f5127ff7f2623a0aa0a5d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182399))
- [Zoekt: Fix missing repo logic](https://gitlab.com/gitlab-org/gitlab/-/commit/4d58b55f51fd4bc248d4e107286654d0170815af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182585)) **GitLab Enterprise Edition**
- [Fix issuable filter focus shortcut](https://gitlab.com/gitlab-org/gitlab/-/commit/27ae7b1fefbe1f9d50f19d46cdcfb4300ef66af8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/152427))
- [Release status badge: Fix border not appearing render issue](https://gitlab.com/gitlab-org/gitlab/-/commit/f43308b6ee0cb1d6094231b475c25d13523f6d68) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182743))
- [Catch Key errors in Google Cloud audit event steaming](https://gitlab.com/gitlab-org/gitlab/-/commit/8e8deebfec32552d114fefabf6f4f8a805471ebb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182712))
- [Add background migration to resync policy project links](https://gitlab.com/gitlab-org/gitlab/-/commit/c95a6596ba20a6c3c93199c9aca0737443ed611a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181164)) **GitLab Enterprise Edition**
- [Use semantic H2 for "Related jobs" header](https://gitlab.com/gitlab-org/gitlab/-/commit/bcdd2db8fbfd8e52f17989c38ad1a9c4d0c5cbf9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182320))
- [Set default for pipeline dependency export](https://gitlab.com/gitlab-org/gitlab/-/commit/ad56573215a5f6efb5a71eeb025a9b1a548eace8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182634)) **GitLab Enterprise Edition**
- [Prevent deletion of project_bot users with non-expiring access tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/6937915aed1d3d2a8eb215b39d3f335cf41f9257) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182621))
- [Fix accessibility of Whats New drawer headers](https://gitlab.com/gitlab-org/gitlab/-/commit/07ab934351c9bc663873da6da25eda1a3e4cc6f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182625))
- [Fix skip to main content button UI](https://gitlab.com/gitlab-org/gitlab/-/commit/18ada5a052e02bd2286e21accd94b05203a4a36d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182614))
- [Fix indentation for default yaml file](https://gitlab.com/gitlab-org/gitlab/-/commit/31b54f898cff97841117b07a80d352766c47e881) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182572)) **GitLab Enterprise Edition**
- [Add validation styling for approver widget](https://gitlab.com/gitlab-org/gitlab/-/commit/1fafa422669bf6c9fe31a575047110c16d59ecc5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182482)) **GitLab Enterprise Edition**
- [Prevent double escaping forward slashes](https://gitlab.com/gitlab-org/gitlab/-/commit/ed79877215e03aac58ca4e741c2cf0f2c46940df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182548))
- [Fix badly formatted help link on some integrations](https://gitlab.com/gitlab-org/gitlab/-/commit/c6e860551a4f0d88169c4ec7d60af3235b681426) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181348))
- [Update truncato](https://gitlab.com/gitlab-org/gitlab/-/commit/8fa7d5929775e178722695e7a7f4809949219d7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182200))
- [Load missing from dropdown groups](https://gitlab.com/gitlab-org/gitlab/-/commit/18070d862a34930548be629b2fad9a4353b17a53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182333)) **GitLab Enterprise Edition**
- [Fix "code_owner_approval_required" override when the param is not set](https://gitlab.com/gitlab-org/gitlab/-/commit/a575c3c0fe86d5d5a5b91de4567d789f0e285f26) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181419)) **GitLab Enterprise Edition**
- [Fix pagination issue on empty To-Do dashboard pages](https://gitlab.com/gitlab-org/gitlab/-/commit/fe80749758601efb8e719213877b7d0ebba92396) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182434))
- [Fix policies for GitLab Duo code suggestions and glab ask](https://gitlab.com/gitlab-org/gitlab/-/commit/d088304f4783cb875f87b8e8112a73afd4dd302c) by @stepech ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182315)) **GitLab Enterprise Edition**
- [Issue boards: Add new item projects select a11y label fix](https://gitlab.com/gitlab-org/gitlab/-/commit/fc4e8458003d36bdbb833902bfd31323e9f94b97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182270))
- [Use semantic H3 for "Can't scan the code" section of 2FA setup](https://gitlab.com/gitlab-org/gitlab/-/commit/f03e5814e2c8017341b312bd226b4fde91636864) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182336))
- [Use semantic headers in SingleStatComponent in admin elasticsearch form](https://gitlab.com/gitlab-org/gitlab/-/commit/4cafbb359a0d98d0e7f1569a8247ff27f53f6355) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182335))
- [Use semantic headers for user stat cards in admin and unique links](https://gitlab.com/gitlab-org/gitlab/-/commit/9cb7f6973875f8c3c5461bc5c28ec850ac3353a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182332))
- [Correct acessibility header issues in admin dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/8bf74f71d69482dbd868642338c5d5088d69ddde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182329))
- [Use H2 for job empty state](https://gitlab.com/gitlab-org/gitlab/-/commit/789f9d20e05516ef6296b426c16478a840aee741) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182322))
- [Prevent Child item expand toggle from overlapping child item](https://gitlab.com/gitlab-org/gitlab/-/commit/40ab430c4e8b465551104a8a9aaffce4271d460c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182169))
- [Fix detection of empty merge request approval policy](https://gitlab.com/gitlab-org/gitlab/-/commit/8e0adb60fac29ec4b05a9662b708315915a46e8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179623)) **GitLab Enterprise Edition**
- [Fix MR approval policy evaluation for chained MRs](https://gitlab.com/gitlab-org/gitlab/-/commit/5295fe63551a4343e09864472de3bcf267511d22) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176630)) **GitLab Enterprise Edition**
- [Ensure Md header anchor shows even when description is collapsed](https://gitlab.com/gitlab-org/gitlab/-/commit/52774c106c5c541abc358589d3f543007fc880a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182182))
- [Fix previous/next commit buttons on merge requests](https://gitlab.com/gitlab-org/gitlab/-/commit/3a138546fef5a1091cc3a9cd0f42091d4fb64098) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182168))
- [Fix work item epic listing button](https://gitlab.com/gitlab-org/gitlab/-/commit/d4ad029021d68a70b49ad94181da77b59f2487fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182061))
- [Fixes deactive active deployment with same path](https://gitlab.com/gitlab-org/gitlab/-/commit/39c329746f7572ca18f9658182706d8778ea25bb) by @Rumple_17 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179100))
- [Load missing from dropdown frameworks](https://gitlab.com/gitlab-org/gitlab/-/commit/88eb6009e897872b69afcc1e79aed8bf7f480313) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182184)) **GitLab Enterprise Edition**
- [Load missing from dropdown projects](https://gitlab.com/gitlab-org/gitlab/-/commit/cee88f87f5fb2a76e0bf9b1e77a15b967273bd04) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182137)) **GitLab Enterprise Edition**
- [Add max length calculations and user indications to status form](https://gitlab.com/gitlab-org/gitlab/-/commit/feabf8d1b869709939c6842e98b7546b9f8ad1a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179618))
- [Resync security_policies with incorrect index](https://gitlab.com/gitlab-org/gitlab/-/commit/d4374e2a95a7c0d9cefb3cffad1f3ddd04fd8bd3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181303)) **GitLab Enterprise Edition**
- [Adjusts BSO logic for free groups](https://gitlab.com/gitlab-org/gitlab/-/commit/cf4d27e5b61cc2279c2269765a759dc2b4f76986) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181765)) **GitLab Enterprise Edition**
- [Dompurify: Allow background-color style attribute on GlLabel](https://gitlab.com/gitlab-org/gitlab/-/commit/68405c44650f7c8c07037d3d918bcdccb009e7e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180194))
- [Allow read access for admin job token permissions](https://gitlab.com/gitlab-org/gitlab/-/commit/cd925b93d1ac6fe05091e91794e5d7767b2c852b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181970))
- [Fix setting ci_id_token_sub_claim_components](https://gitlab.com/gitlab-org/gitlab/-/commit/82f296045e3c76fd8a23c9471cbd152769a5016a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181981)) **GitLab Enterprise Edition**
- [Fixes admin page CI minutes css class usage](https://gitlab.com/gitlab-org/gitlab/-/commit/27b10b521c2df4f4a053b98f0973f4569f4f58ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180797)) **GitLab Enterprise Edition**
- [Correct milestone in featue flag definition](https://gitlab.com/gitlab-org/gitlab/-/commit/043d54854c4503589331a2387f7a134ba97d052f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181991)) **GitLab Enterprise Edition**
- [Ignore policy schema validation for custom roles](https://gitlab.com/gitlab-org/gitlab/-/commit/ad4151cb5b83f3956cb66936fc3c4eb0af513cc8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182026)) **GitLab Enterprise Edition**
- [Keep value stream analytics active in sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/1f3d18edc4350f445e9b99fba1de6010dfa95fd8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181844))
- [Add queuing worker for broken adherences](https://gitlab.com/gitlab-org/gitlab/-/commit/c616ddd831d78a973f8dfe77de149ce9e809046c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179944)) **GitLab Enterprise Edition**
- [Fix severity filtering for severity overridden security findings](https://gitlab.com/gitlab-org/gitlab/-/commit/5044210769ef8ba1955b860bf6c11f3ae538a44b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181998)) **GitLab Enterprise Edition**
- [Skip processed members](https://gitlab.com/gitlab-org/gitlab/-/commit/0c7861ca1e89f61c7a9254cc6a744674f28d6d3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180935))
- [Fix DOMPurify validation for SVGs](https://gitlab.com/gitlab-org/gitlab/-/commit/9464f220997d8d4f5d7eea34cd00f0e18d4d0834) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181941))
- [Import GitHub collaborators consistently](https://gitlab.com/gitlab-org/gitlab/-/commit/4eefdb14c629edbad6a29a5c3eb8b0e55f08041a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180685))
- [Fix edit framework refresh bug](https://gitlab.com/gitlab-org/gitlab/-/commit/d3eb0a43790295bb3ac4dedd73f759089ce3bc29) by @nradina ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181290))
- [Add min size to confidential icon](https://gitlab.com/gitlab-org/gitlab/-/commit/42c1fb65dc6a85e5fe03a96fa3c1bdd36994d5a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181779))
- [Generate correct agent URL in managed resource annotations](https://gitlab.com/gitlab-org/gitlab/-/commit/75e8af59be806dfe396c3bcec421008d29351de1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181839))
- [Small alignment fixes in merge widget](https://gitlab.com/gitlab-org/gitlab/-/commit/ae895daf7a003acb4f0acdd8ce327cb318eaa180) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181834))
- [Change date toggle when updated via subscriptions](https://gitlab.com/gitlab-org/gitlab/-/commit/28e939251dc80c52283ef7d32b43c48f9b7c59ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181654)) **GitLab Enterprise Edition**
- [Hide markdown editor fullscreen button when work item is in drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/4c7a183471138021d80cae1ee691ac1f5ea7a77f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180626))
- [Fix release evidence tag name generation](https://gitlab.com/gitlab-org/gitlab/-/commit/d80669df6168f308e010f3f35baad2555045cb25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180772))
- [Fix ambiguous created_at column for pipeline_configuration_full_path](https://gitlab.com/gitlab-org/gitlab/-/commit/0e7ef108f246a1bef4a3765c3340875dbdd0a30f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181334)) **GitLab Enterprise Edition**
- [Fix audit event http streaming under feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/5fb51e7e0a621a1b8a2ffecb207996919bd91141) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181009)) **GitLab Enterprise Edition**
- [Update query for banned user project deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/637bbb91b0ee3b802d220cab2a5130d7042cdbc4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181592))
- [Safely handle when sanitized Elastic result is blank](https://gitlab.com/gitlab-org/gitlab/-/commit/ead89bd40ebcad3b7f88216d45fef06fad735781) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181760)) **GitLab Enterprise Edition**
- [Use correct project when fetching managed resources templates](https://gitlab.com/gitlab-org/gitlab/-/commit/da815aee5ea74e58c86b5020268e93277dde3972) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181749))
- [Fix 'Apply' button for WI dates widget](https://gitlab.com/gitlab-org/gitlab/-/commit/c94cca690189e346d7107c2e90067fe930777d01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181578))
- [Allow access to publicly accessible features from job tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/9d03265f820d7b92cb3b3a8fb1370fc92f503029) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179717))
- [Make multi-word label matching case-insensitive](https://gitlab.com/gitlab-org/gitlab/-/commit/3ceafd23802ab2a38b5ad60a85a7956270fe2281) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180823))

### Changed (189 changes)

- [Use epic creation adapter in more places](https://gitlab.com/gitlab-org/gitlab/-/commit/852f75d079c36a2ba3d0fcd5a4d3ce41c0da442c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181767)) **GitLab Enterprise Edition**
- [Add email delivery for vulnerabilities exports](https://gitlab.com/gitlab-org/gitlab/-/commit/360ecb7d206e7fce820c6b30c96e700d37e984ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183169)) **GitLab Enterprise Edition**
- [Update CI steps syntax specification](https://gitlab.com/gitlab-org/gitlab/-/commit/8fddc95cde27be66643f4bd1bc8a6a5b0384291b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184005))
- [Document how to use a custom PEP pre stage as non-blocking](https://gitlab.com/gitlab-org/gitlab/-/commit/e65edda1f9f55b42e59b31ce76a95a3b95707581) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184603))
- [Finalize delete_orphaned_stage_records](https://gitlab.com/gitlab-org/gitlab/-/commit/67ce59edcfe157444b31c6eafa012f0d70f02209) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178120))
- [Finalize backfill subscription_add_on_purchases](https://gitlab.com/gitlab-org/gitlab/-/commit/97916629289e446348c9d91768b908655c82f7ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184336))
- [Improve performance of CI/CD analytics page](https://gitlab.com/gitlab-org/gitlab/-/commit/98b0b808163da3e7f0e62140fa9c57f80b51bbf4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184328))
- [Update description for q test mr norm and diff](https://gitlab.com/gitlab-org/gitlab/-/commit/f34979a5d3829b18b4ab20b8e9e54be7dd49465a) by @jlosito ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183853)) **GitLab Enterprise Edition**
- [Changed text on the breadcrumbs for creating new entities in projects:](https://gitlab.com/gitlab-org/gitlab/-/commit/5aba39fe7e5fb5367df098e5dbc3e752c48f2ae5) by @illia_bakunovskyi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174315))
- [Crud, MR widget, settings block: Add preference for reduced motion](https://gitlab.com/gitlab-org/gitlab/-/commit/37ea97fceee67309f370a3ea9d36c4055c6dbe1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184434))
- [Remove feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/03b521aa7c270d000618343c536b315f06e20b76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184330)) **GitLab Enterprise Edition**
- [Refresh member authorized projects in background job](https://gitlab.com/gitlab-org/gitlab/-/commit/19b9a244692d21a6b6a4f3226f04df8074be4702) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183920))
- [Enable migrated prompts for summarize comments](https://gitlab.com/gitlab-org/gitlab/-/commit/256d33b1cc2c21f6243055db31847fde5a90c685) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184447))
- [Refactored util to fix sm billable logic](https://gitlab.com/gitlab-org/gitlab/-/commit/fc3ac3521061f789c0493e50eed38c52299e6163) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184305)) **GitLab Enterprise Edition**
- [Add header to project snippets page](https://gitlab.com/gitlab-org/gitlab/-/commit/8e3eed6da4d3e93746014d0638992a84b5c89222) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184201))
- [Enable configuration of Duo Chat sub-features](https://gitlab.com/gitlab-org/gitlab/-/commit/03a24fdcb780fa5d04b621b3b0a79f31d9f152de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175349)) **GitLab Enterprise Edition**
- [Show skipped rows in CSV reassignment email](https://gitlab.com/gitlab-org/gitlab/-/commit/98b291c2ac1fd9a921dee908078dc16ea74ffc9d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183449))
- [Expose correlation ID in overloaded message](https://gitlab.com/gitlab-org/gitlab/-/commit/d9fe2edb9e63f3b0c5131d6b541512c322ba6b15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182908))
- [Update dependency auto-deploy-image to v2.125.0](https://gitlab.com/gitlab-org/gitlab/-/commit/c091dd0c9f2725ec9c488d66bbe6f5fd130493c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184388))
- [Add group and project scope for basic users autocomplete](https://gitlab.com/gitlab-org/gitlab/-/commit/8217c1ac948c9022805f61d3fdd43ff2d527dd21) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182557))
- [RCA/Troubleshoot uses new Claude 3.7 model](https://gitlab.com/gitlab-org/gitlab/-/commit/50bac36c3516db7e8c7fa6a6b4d8e825040456a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184364)) **GitLab Enterprise Edition**
- [Release the Docker Hub credentials support in the Dependency Proxy](https://gitlab.com/gitlab-org/gitlab/-/commit/58d339780ba2cbe87e6a57ecfd3a89f1c71e901b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183020))
- [Update code creation slash commands to Claude 3.7 Sonnet](https://gitlab.com/gitlab-org/gitlab/-/commit/0f6788435f293cacf8eab113fbbf1da654293e3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184333)) **GitLab Enterprise Edition**
- [Remove deprecated remote_development_agent_config references](https://gitlab.com/gitlab-org/gitlab/-/commit/8ce5e46c151eb5a14c036b60b25f897a478cdcbf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183427)) **GitLab Enterprise Edition**
- [Release squash commits options for branch rules](https://gitlab.com/gitlab-org/gitlab/-/commit/236f5a3a9ddc7eaf9a3a1c29a4d3ba85985382c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184177))
- [GLQL: Add Crud to views](https://gitlab.com/gitlab-org/gitlab/-/commit/94e52b56a4fe7b079c802e90560bcc6ab29d8f11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183709))
- [Vulnerability finding: Update design of form](https://gitlab.com/gitlab-org/gitlab/-/commit/1566dddbcf26cb42ec43535df3e894b36c996815) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183668))
- [Move Seat Control > Restricted Access to paid plans only](https://gitlab.com/gitlab-org/gitlab/-/commit/5e9eff2ed6eb41e8aafd7ac78c018b12e2516800) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183983)) **GitLab Enterprise Edition**
- [Release ignore specific revisions in git blame](https://gitlab.com/gitlab-org/gitlab/-/commit/ba43eb5cce1014310146c73086781447bdba375b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184260))
- [Tables: Add scroll indicator](https://gitlab.com/gitlab-org/gitlab/-/commit/8c90370c3fdade51379b0406e52781fa98e2cf49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181650))
- [Update class for to-do item on hover](https://gitlab.com/gitlab-org/gitlab/-/commit/251652370cf6d24bba2fd4afe254ab706df4587e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184064))
- [Update page headings in the CI/CD analytics pages](https://gitlab.com/gitlab-org/gitlab/-/commit/aadca97beb43dc8b4499df58f41f6a2a487d0920) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184282))
- [Remove feature flag `dependency_scanning_using_sbom_reports`](https://gitlab.com/gitlab-org/gitlab/-/commit/11ffa7c2fcd06e030f29ffad39b7719f8339d55f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184295)) **GitLab Enterprise Edition**
- [Clean up labels UI](https://gitlab.com/gitlab-org/gitlab/-/commit/23eb196ed6bf89e45438ff66e3ad9acd5a502156) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183767))
- [Improve error message for webhook name description](https://gitlab.com/gitlab-org/gitlab/-/commit/1bfe6b2c061108c4f17b4d50b9b3ceb0ac35022d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184256))
- [Default enable duo_code_review_claude_3_7_sonnet](https://gitlab.com/gitlab-org/gitlab/-/commit/2f99149eb71a65eb7f60987c252d50928810beaa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184253)) **GitLab Enterprise Edition**
- [Default enable generate_commit_message_claude_3_7](https://gitlab.com/gitlab-org/gitlab/-/commit/d096074c61b313db95350670e709270db9668e6b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184255)) **GitLab Enterprise Edition**
- [SPP docs diff scan web requests feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b27eeb5198d9c9eb2b345012bef5a01b3b1d8e8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183741))
- [Make snippet list info focusable](https://gitlab.com/gitlab-org/gitlab/-/commit/f546698d83357dec5e75abb5fbc7122ee32ed96b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184209))
- [Add archived only project filter to project graphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/f286badda17c876009be947c1c100996dba4972f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182667))
- [Optimize file size check using quarantine dir and add EE-specific check](https://gitlab.com/gitlab-org/gitlab/-/commit/b13520eba56ce581ad58a54fdd422c082d4afd76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183600)) **GitLab Enterprise Edition**
- [Remove group_dependency_list_csv_export feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e44cee8234d6469a28d4ada3e3d5d551bafb36dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184206)) **GitLab Enterprise Edition**
- [Updating /troubleshoot or RCA AI Feature to pull prompt from AI Gateway](https://gitlab.com/gitlab-org/gitlab/-/commit/e0363d9d5d2c2a9a8b20bd47f027e1ceb2b7f6ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184198))
- [Rollout manual severity overrides feature](https://gitlab.com/gitlab-org/gitlab/-/commit/2bfe5a82b28c6912a0687dcfb614568cede38231) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183528)) **GitLab Enterprise Edition**
- [Move GLQL SLIs to its new controller](https://gitlab.com/gitlab-org/gitlab/-/commit/84e91e1952036022ae5a581852bc6b467a467022) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183842))
- [Bump PG default version for CI](https://gitlab.com/gitlab-org/gitlab/-/commit/18d719abee7707e3ba84a918475f840785823b65) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183537))
- [Update Sidekiq memory killer docs](https://gitlab.com/gitlab-org/gitlab/-/commit/d3b2009da3a40bcdd5f6bf273a4d02149196f602) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184130))
- [Remove `your_work_projects_vue` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/dfd2721c1deee154dafc60257ac142613c8fbda6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183429))
- [Move CI_PAGES_HOSTNAME from build.rb to project.rb](https://gitlab.com/gitlab-org/gitlab/-/commit/05346c2fe6c110cd90e642f9ecb336d0fb6818e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183671))
- [Rename Rack Attack log field: request_method -> method](https://gitlab.com/gitlab-org/gitlab/-/commit/c41459d2c6805f332fa1e2ea853890c0ec33ffcd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183888))
- [Add v2 approval rule associations to user and user group](https://gitlab.com/gitlab-org/gitlab/-/commit/6726d1dba0c7a6669a4c78577342161cb648cbeb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179877)) **GitLab Enterprise Edition**
- [Ingest and display direct dependencies](https://gitlab.com/gitlab-org/gitlab/-/commit/5ae47e2187a0e021a3c8932a9ff6d2526ca378be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183246)) **GitLab Enterprise Edition**
- [Add ReplicatorEvents module to seperate event logic from other files](https://gitlab.com/gitlab-org/gitlab/-/commit/93516f6be6ed412b9cd1b47f666cbb79db3fc090) by @bymayanksingh ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/126397)) **GitLab Enterprise Edition**
- [Add tooltip directive to remove snooze](https://gitlab.com/gitlab-org/gitlab/-/commit/8d83822cf76894f87fdff54a63dd97c2246a16a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184071))
- [Add policy type property to editors](https://gitlab.com/gitlab-org/gitlab/-/commit/ec785719c49eb7a49921972a54034f94c24d0bd9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183557)) **GitLab Enterprise Edition**
- [Mlflow get run to return less metrics data](https://gitlab.com/gitlab-org/gitlab/-/commit/9f0cea5f74bf821de69ee44a8ed1ca07df46f7f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183838))
- [Block local URLs for external controls on SaaS](https://gitlab.com/gitlab-org/gitlab/-/commit/012e0578b04d796232a52469232c9569eaff4ae0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182877)) **GitLab Enterprise Edition**
- [Simplify admin_display_duo_addon_settings? method](https://gitlab.com/gitlab-org/gitlab/-/commit/3b724ee7f410aab4a32731510e9dee2bb2d422b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183970)) **GitLab Enterprise Edition**
- [For autocomplete scoped search options, check greater than or equal](https://gitlab.com/gitlab-org/gitlab/-/commit/9c308bf7badb9d240fea90433f930e12248d39f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183972))
- [Enable unblock_rules_using_pipeline_execution_policies by default](https://gitlab.com/gitlab-org/gitlab/-/commit/7db3d37252923a5d16d94e74c8aa18a59f709acb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184023)) **GitLab Enterprise Edition**
- [Update policy_tuning wording to account for pipeline execution policies](https://gitlab.com/gitlab-org/gitlab/-/commit/1c2f01ab5263ce4e0e349b204f78d7741535e569) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183840)) **GitLab Enterprise Edition**
- [Use secure defaults for token storage in TokenAuthenticatable](https://gitlab.com/gitlab-org/gitlab/-/commit/4e111ec3a500290d450b27e501f373512a5338aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183341))
- [Update documentation of policy_tuning with pipeline execution policies](https://gitlab.com/gitlab-org/gitlab/-/commit/0a14ae58cf4fd2cef7614b3cde2278b47fa0190e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183839))
- [Update User Cap settings related error message](https://gitlab.com/gitlab-org/gitlab/-/commit/08b33b9bb09f471cf219ad41b88cfeb49b44c1c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183652)) **GitLab Enterprise Edition**
- [Sync FK `fk_rails_507416c33a_p`](https://gitlab.com/gitlab-org/gitlab/-/commit/01926187255bd87b75c823552f93eafa39cc76b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178117))
- [Add validation for approvals required](https://gitlab.com/gitlab-org/gitlab/-/commit/58c3a67bf114fab167e19a9aad984f7a5ae00071) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183835)) **GitLab Enterprise Edition**
- [Changed regex button colors to design tokem colors](https://gitlab.com/gitlab-org/gitlab/-/commit/3fe6e6583c8903b6638991eb4c4a17b37464b35d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183406))
- [Change text limit for duo workflow event message](https://gitlab.com/gitlab-org/gitlab/-/commit/7c73cc21d95567bbba3ca1226a6ff40d8095b7b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183885))
- [Use progress track when importing single relations](https://gitlab.com/gitlab-org/gitlab/-/commit/13db8ffb657c7b004278be14583f44b7d0c91404) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183862))
- [Use sentence case for package registry](https://gitlab.com/gitlab-org/gitlab/-/commit/a02a09e91f8e8048222ad82b182ba11240791ab7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183533))
- [Rename custom status widget to status widget](https://gitlab.com/gitlab-org/gitlab/-/commit/ef78e820ad7994c643871e83a7b22288fadfd61b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183026))
- [Use text.color.link for hover color in issuable sidebar controls](https://gitlab.com/gitlab-org/gitlab/-/commit/4aa2d94087a7cae2e018ffc0ecec152a8d3812a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183307))
- [Rename the status widget to the verification status widget](https://gitlab.com/gitlab-org/gitlab/-/commit/5c40e02e1b4ce0853c586d873b700a4a2ad86f5a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182520))
- [Making existing pipeline colours more vibrant and supporting additional pipeline statuses](https://gitlab.com/gitlab-org/gitlab/-/commit/951a8521a3c27b6a2021944a7c14255eea033b81) by @barton.tomas ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181091))
- [Display test duration time in 24hr format](https://gitlab.com/gitlab-org/gitlab/-/commit/1a5376274170ea5b8ae58a99515acef701f60be0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183705))
- [Add check to prevent banning paid users](https://gitlab.com/gitlab-org/gitlab/-/commit/a208f3fa4240018ed34c3a008c813c4f57bbf738) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183733)) **GitLab Enterprise Edition**
- [Exclude bot users from dormant removal](https://gitlab.com/gitlab-org/gitlab/-/commit/09382f5c28a1d59a3e995bd3db3a660b371ba05f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183489)) **GitLab Enterprise Edition**
- [System notes: Update icon design tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/f01f4bddd2a672e45ef721a9a7a32f76892849bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183228))
- [Fix auto-applying labels when creating a child issue](https://gitlab.com/gitlab-org/gitlab/-/commit/af0c49b0e31215cfae3f5e02f9627cd6242093df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181605))
- [Restrict new pipeline variables](https://gitlab.com/gitlab-org/gitlab/-/commit/19287da677c161a6e7704ef2cca4d3c2a36eefcb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183420))
- [Runner registration page should not be accessible if registered](https://gitlab.com/gitlab-org/gitlab/-/commit/5168e6cb936042bcbc95d4df8129b4f40a94933b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183178))
- [Add awareness banner for new adhernece report](https://gitlab.com/gitlab-org/gitlab/-/commit/4f005d444b3b24fb23ce3a0cf5308b1193bf8964) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182870)) **GitLab Enterprise Edition**
- [Raise runner token_encrypted length from 128 to 512 bytes](https://gitlab.com/gitlab-org/gitlab/-/commit/ae363528ed36452c7a666dafedf6f8cb5be2d5d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183454))
- [Update feature name to GitLab Duo Self-Hosted in the UI](https://gitlab.com/gitlab-org/gitlab/-/commit/f252a8e7e6504d8c5b47026dedcd6474ac24b24d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182672)) **GitLab Enterprise Edition**
- [Design item: Improve a11y label, contrast and alignment](https://gitlab.com/gitlab-org/gitlab/-/commit/81fceee656b91ecaf5d7c0ec8da2b3f856c0a2bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182722))
- [Remove `reject_security_policy_project_deletion_groups` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b561e72ddbe970548d29876625d3e06142d82f80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183334)) **GitLab Enterprise Edition**
- [Update Compliance Center Breadcrumbs](https://gitlab.com/gitlab-org/gitlab/-/commit/fad978ee4b44c2c246daaafdace629832e0f2d05) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182571)) **GitLab Enterprise Edition**
- [Allow requesting multiple embeddings from vertex](https://gitlab.com/gitlab-org/gitlab/-/commit/389f3afe454440fbe0d161936fc350fea871a0cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182989)) **GitLab Enterprise Edition**
- [Delete the `index_todos_on_author_id` index](https://gitlab.com/gitlab-org/gitlab/-/commit/abfdd0837dcd8e61bbe438c5b91760656448512a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183434))
- [Clean up validate_codeowner_users feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/ab9568cf9bde17ad4dabed53c80cca143c29b508) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182817))
- [Restrict pipeline schedule variables](https://gitlab.com/gitlab-org/gitlab/-/commit/03af63e9d24d362f6668c9f7d070348bdf1b1f8d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183370))
- [Prevent double policy update](https://gitlab.com/gitlab-org/gitlab/-/commit/18f34792108f9f55be10432dc94a071da5d4b309) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183387)) **GitLab Enterprise Edition**
- [Write multiple PEP schedules](https://gitlab.com/gitlab-org/gitlab/-/commit/fa43c2e4209548f1a1856759eb03d7870a02c64c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180714)) **GitLab Enterprise Edition**
- [Add PG 17 to nightly rspec builds](https://gitlab.com/gitlab-org/gitlab/-/commit/5667867f40e4e635d3e286a4db7bb64c47f43db3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182730))
- [Remove FF projectComponentFilter](https://gitlab.com/gitlab-org/gitlab/-/commit/200b808ee862447e97bf33ca2f2f5c6b7452320c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180350)) **GitLab Enterprise Edition**
- [Update seats related notifications](https://gitlab.com/gitlab-org/gitlab/-/commit/048f5998001dcda45b2629a5a800f63d8481ebd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181811)) **GitLab Enterprise Edition**
- [Backfill pipeline execution policy config links](https://gitlab.com/gitlab-org/gitlab/-/commit/d680bee9f4f8ac181b3a0a2f87a8d5cd8d4dd2b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181151)) **GitLab Enterprise Edition**
- [Update dependency auto-deploy-image to v2.124.0](https://gitlab.com/gitlab-org/gitlab/-/commit/c232855b436be8a2463481971f439df7456ca99b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179863))
- [Skip updated failed zoekt tasks to processing](https://gitlab.com/gitlab-org/gitlab/-/commit/f720c56ff067f6515520e5e3cbe51f1b6f865a6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183272)) **GitLab Enterprise Edition**
- [Add enterprise_user key to allowlist](https://gitlab.com/gitlab-org/gitlab/-/commit/90d8c668c96e0278c2aac8c77b8f439a52b51f90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183267))
- [Re-enable PG16 nightly integration jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/6650424340878d2dc84370530ac1ff3e2c7c5558) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182619))
- [Show type label for all pipeline types](https://gitlab.com/gitlab-org/gitlab/-/commit/ba2e11c9c4ef1aaf56c54d7cb8a1a16e2d0e49be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179760))
- [Update UX for dependency proxy for packages settings](https://gitlab.com/gitlab-org/gitlab/-/commit/c46a4336cb16690c4ce3eba3f38515118f0e52b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182818)) **GitLab Enterprise Edition**
- [Update Application Secrets developer docs](https://gitlab.com/gitlab-org/gitlab/-/commit/49221d20ce09b10ce64b59ea8adc5750d1a71ed8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181271))
- [Wiki notes: Update design tokens used, bugfixes](https://gitlab.com/gitlab-org/gitlab/-/commit/2d9703161a74b67714182a9e04d60abb8e6c9c75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183175))
- [Add learn more link to Disable PAT for enterprise users docs](https://gitlab.com/gitlab-org/gitlab/-/commit/99019772b511a6e7c381c600c5337455abb58771) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182965)) **GitLab Enterprise Edition**
- [Sync FK `fk_rails_494e57ee78_p`](https://gitlab.com/gitlab-org/gitlab/-/commit/0efb97716db5f501eecfd63ec807a3ea4231ae98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177980))
- [Align submit buttons for policy cards](https://gitlab.com/gitlab-org/gitlab/-/commit/f4de386d04494a3b7e51a5a40b79af4e7686b469) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183180)) **GitLab Enterprise Edition**
- [Remove feature flag separate_group_scim_table](https://gitlab.com/gitlab-org/gitlab/-/commit/15645449430e62f421a2d37ca7068d3fb5296f8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181148))
- [Improve development widget error message](https://gitlab.com/gitlab-org/gitlab/-/commit/47bf43d79cd6cd4d82863d3f4f5a59f59e350cce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182445))
- [Migrate web_ide_extensions_marketplace ff to data](https://gitlab.com/gitlab-org/gitlab/-/commit/838c777f1cb49ec2d8dcb48ccf8f479d6568c859) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181152))
- [Extends work item shortcut support](https://gitlab.com/gitlab-org/gitlab/-/commit/0f4e1426a03a2d5900dabb415af1490f288e9af9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182327))
- [Remove `reject_security_policy_project_deletion` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/6a75854eacda80e35f8e646d6a919d7f0a65aae3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182413))
- [Update icon in nav to use import](https://gitlab.com/gitlab-org/gitlab/-/commit/df1435f4c1a67aa8e7ebf9b7b0ab604285d58370) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182428))
- [Advanced Search user autocomplete scoped to auth namespaces](https://gitlab.com/gitlab-org/gitlab/-/commit/837a8bed6e3832eb3a0c5ebee069d24eaeb9899f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182277)) **GitLab Enterprise Edition**
- [Execute GitLabDocumentation tool via Agents](https://gitlab.com/gitlab-org/gitlab/-/commit/22446d49a5ccc1a83dda2f3c81f53e9e35020887) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180273)) **GitLab Enterprise Edition**
- [Remove id mapping from skip ci](https://gitlab.com/gitlab-org/gitlab/-/commit/d1987eab6331b866189362dc131309f67c80917c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183027)) **GitLab Enterprise Edition**
- [Remove two related Cloud Connector FFs](https://gitlab.com/gitlab-org/gitlab/-/commit/586288de96c39c5066639f3f4587cf6d82f716c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183010)) **GitLab Enterprise Edition**
- [Introduce new policy for deleting image tags](https://gitlab.com/gitlab-org/gitlab/-/commit/d8413839057daf0fb9b54cb6828c45717137354d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181857))
- [Replace feature flags for email restrictions with setting](https://gitlab.com/gitlab-org/gitlab/-/commit/a522fce6849ad6050e25019076bd5447eff587f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182601))
- [Persist analytics dashboards filter bar selections in the URL](https://gitlab.com/gitlab-org/gitlab/-/commit/a6e5427eb7185be432d8fc32f3ac929fceba488d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182465))
- [Stop logging Direct Transfer pipeline steps](https://gitlab.com/gitlab-org/gitlab/-/commit/52a86894e07455790c3486b5bbcf1547c64d4215) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182966))
- [Migrate restrict_user_defined_variables to `true`](https://gitlab.com/gitlab-org/gitlab/-/commit/998d84eeb4f49a9be9396f21ac8b2263f38ebee6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181856))
- [Fix Style/FormatString offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/7b948e371a1fd5fe9d0596c774c67ed0814064fd) by @JonstonChan ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180293))
- [Copying over the rest of the pipeline variables form code](https://gitlab.com/gitlab-org/gitlab/-/commit/d210d4b52efec681e99a34f717ee0b6e9d4916c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182455))
- [Add scheduling columns to PEP schedules](https://gitlab.com/gitlab-org/gitlab/-/commit/1fd72554464971cf1e05cf8f4d0b0be8cab24264) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180708)) **GitLab Enterprise Edition**
- [Shorten text when leaving comment as review](https://gitlab.com/gitlab-org/gitlab/-/commit/c85dffde22659b99c05637016af530dbb464ab15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182885))
- [Adjust texts for exclude license packages](https://gitlab.com/gitlab-org/gitlab/-/commit/92c1ac78928ed40614bc4c60c2a58960c9858d47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182740)) **GitLab Enterprise Edition**
- [Create new Geo verification state table for SnippetRepository](https://gitlab.com/gitlab-org/gitlab/-/commit/a7e7a8303af57ed28ca095719bfff1190693d30e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181255)) **GitLab Enterprise Edition**
- [Add ids argument for descendant groups](https://gitlab.com/gitlab-org/gitlab/-/commit/f846d2b6a971fca31ed76918aef7e6591eeb46ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182411))
- [Fetch details of banned and blocked users](https://gitlab.com/gitlab-org/gitlab/-/commit/59540294796a74d28a8e1ec9c8ae46d0ffa1c567) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182218))
- [Abstract pipeline_variables_form to its own component](https://gitlab.com/gitlab-org/gitlab/-/commit/c240c18d7349fbf8622d1a7efe071f7a913f86fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182376))
- [Document Workhorse repository archive cache](https://gitlab.com/gitlab-org/gitlab/-/commit/ce38353bf2ba67f4381632db12df95a0b006fab8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182810))
- [Improve dependency export API usability](https://gitlab.com/gitlab-org/gitlab/-/commit/c1c21fe6bf4c1f811db1b0e3453a69c316032136) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182814)) **GitLab Enterprise Edition**
- [Clean up auto_assign_duo_seat feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3a71ad12a8c1e888ed710ec55d08106078fd2707) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182638)) **GitLab Enterprise Edition**
- [Change strings to use consistant ellipses](https://gitlab.com/gitlab-org/gitlab/-/commit/aeb6a8a1dc3f4f7dae354b4d0402e7290f305531) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182709))
- [Add zoekt setting to control rollout batch size](https://gitlab.com/gitlab-org/gitlab/-/commit/2fdb68a4bcbdc18879e77f83384dc4ebec3d938b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182581)) **GitLab Enterprise Edition**
- [Added delete oauth connection on Amazon Q disconnect](https://gitlab.com/gitlab-org/gitlab/-/commit/a5c5d0ee36dbbd37e91fd1a8c66353d5eaaf3551) by @protsivd ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182043)) **GitLab Enterprise Edition**
- [Deprecate the `force_to_redownload` field in Types::Geo::RegistryType](https://gitlab.com/gitlab-org/gitlab/-/commit/651735dbe5dcbdbdbef42b0692584e7377c6b898) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182342)) **GitLab Enterprise Edition**
- [Add bulk dismissed event and subscriber](https://gitlab.com/gitlab-org/gitlab/-/commit/64799942060e65f084e8ef420bd046a5394b8abe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181239)) **GitLab Enterprise Edition**
- [Save licenses outside of the spdx catalog as custom licenses](https://gitlab.com/gitlab-org/gitlab/-/commit/fd33f8ca15745c0bb7e144ca5eef502274913e74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181454)) **GitLab Enterprise Edition**
- [Allow use to select a date range of Runner Usage](https://gitlab.com/gitlab-org/gitlab/-/commit/e6e9b74b758bf8c306c9d54dba7185e23fa77c86) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182095))
- [Allow dashboard panel to reload data with query overrides](https://gitlab.com/gitlab-org/gitlab/-/commit/7e05ab0554047785fae5929c90f0046d28487c00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181955))
- [Add ai context migration model](https://gitlab.com/gitlab-org/gitlab/-/commit/a4e9b17d25adcadb76b07afff4deb11042f741dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181238)) **GitLab Enterprise Edition**
- [Delete dropdown item in label list use danger variant](https://gitlab.com/gitlab-org/gitlab/-/commit/104f17a715665f916426eadc0bebb3c24d140673) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182301))
- [Use tertiary explore projects button](https://gitlab.com/gitlab-org/gitlab/-/commit/cc55c1746705eca56bd8e8f111d320a4688aa8f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182447))
- [Update active context Collections table](https://gitlab.com/gitlab-org/gitlab/-/commit/b02468dab2f8df0e8a08351bd184752b289d6d5b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181923))
- [Update bundler to v2.6.5](https://gitlab.com/gitlab-org/gitlab/-/commit/3e387d7f9a7d8802b371e17dbbf1d8741b698bd8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182381))
- [Extract fromYaml method shared method](https://gitlab.com/gitlab-org/gitlab/-/commit/8dc39af3ac2ca661a978c18823a92a55ddd783ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182288)) **GitLab Enterprise Edition**
- [Change markdown multiline quoting behaviour on already quoted lines](https://gitlab.com/gitlab-org/gitlab/-/commit/d31b9144e6eb513d9ff7dd9038ee4d0f6d1fabb8) by @Bubbis ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178744))
- [Update Pod counters to reflect search filter results on environment page](https://gitlab.com/gitlab-org/gitlab/-/commit/6879ae9e2912f0978fce5e0cfa0c675a07095024) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182283))
- [Remove action approvers from helper](https://gitlab.com/gitlab-org/gitlab/-/commit/c6121a53ee5e95730049ca81831127f70b31e328) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179138)) **GitLab Enterprise Edition**
- [Add UI for pipeline variables minimum role project setting](https://gitlab.com/gitlab-org/gitlab/-/commit/0fc948bdf08c32be1d91ad44229017355105bee4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172304))
- [Clarify tooltip message](https://gitlab.com/gitlab-org/gitlab/-/commit/52e8fec529460437601269b4800c3f34b7388ec6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181635)) **GitLab Enterprise Edition**
- [Avoid writing over the severity override](https://gitlab.com/gitlab-org/gitlab/-/commit/7c488d2191af61f37271003f047c69f8368bc4a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178804)) **GitLab Enterprise Edition**
- [Improve API error for invalid sub claim component](https://gitlab.com/gitlab-org/gitlab/-/commit/94a7572382c6fa633dad1906d0330acfa404bb70) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182257)) **GitLab Enterprise Edition**
- [Cleanup duo_chat_drop_redis_storage feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/a03300e094fd10129aba3a8cf89c629617084b1b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181908)) **GitLab Enterprise Edition**
- [Log Duo Chat M2000 Error Code](https://gitlab.com/gitlab-org/gitlab/-/commit/f180046f9efe4fd1927cbb91addfd32d69bca031) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181374)) **GitLab Enterprise Edition**
- [Support custom pipcompile lockfile in DS latest template](https://gitlab.com/gitlab-org/gitlab/-/commit/681405f7aee3b098a571904577567445b403bd01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182159)) **GitLab Enterprise Edition**
- [Change keyFields for ScanExecution type](https://gitlab.com/gitlab-org/gitlab/-/commit/4c3ee50cdbb218ca5c528c06d6f36ebec4b687fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181964)) **GitLab Enterprise Edition**
- [Remove work_items_alpha flag from Move button](https://gitlab.com/gitlab-org/gitlab/-/commit/0f978d4f7e339e41cb1a5879deecfb17febdb8ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182203))
- [Add minor UI changes for Severity Override](https://gitlab.com/gitlab-org/gitlab/-/commit/bfc92587714e9657eb40e056a4d3c6a7d6abbbfc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181504)) **GitLab Enterprise Edition**
- [Move Troubleshoot button inside the sticky footer](https://gitlab.com/gitlab-org/gitlab/-/commit/24712bb718b5662492fccf6055dcdeae545246c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182161))
- [Update allow/deny list payload](https://gitlab.com/gitlab-org/gitlab/-/commit/864f1a10c388122cf9216c1e4c665f2a41cfb3b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181803)) **GitLab Enterprise Edition**
- [Remove the `snoozed_todos_sort_order` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/ac94d0496961302f66f4ac54c68b2cc3b215d627) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181569))
- [Static reachability job process only DS artifacts](https://gitlab.com/gitlab-org/gitlab/-/commit/2e31ea086cfccd5821e4d2cf20b091e999c1e8c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182146))
- [Add minimum override role to CI/CD settings mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/6b5df91c72490ebf6e3ce8c0d81ed2b273a6b814) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174598))
- [Disable group ascendency validation on Direct Transfer](https://gitlab.com/gitlab-org/gitlab/-/commit/62406aa03a2a89cfbe737a02498172965919d65d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181804))
- [Redesign the action buttons for manual jobs to improve usability](https://gitlab.com/gitlab-org/gitlab/-/commit/8788ba4dd38f3b037f085ba665dca68da3f9e933) by @shakahwath.hussain ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176368))
- [Model registry: Clarify buttons and titles](https://gitlab.com/gitlab-org/gitlab/-/commit/abf269dfe1f4934159d30287d4c68ab2f08c6cdf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181667))
- [Update repository limit notifications](https://gitlab.com/gitlab-org/gitlab/-/commit/d616887c8433614bf46589297bd434844967a201) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180779)) **GitLab Enterprise Edition**
- [Enable `ensure_pipeline_policy_pre_stage_complete` by default](https://gitlab.com/gitlab-org/gitlab/-/commit/96a26299aedbeee75aa91a46d2a31714e4ad4dde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182081)) **GitLab Enterprise Edition**
- [Disable remove user button for last owners](https://gitlab.com/gitlab-org/gitlab/-/commit/bcc2a5de1434dc14af0666c8d16e277544c4ab7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181706))
- [Allow Duo Chat to be resizable on self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/4bc8783dfa525925fb4d02bfa59d4eb5aef8c03b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182008)) **GitLab Enterprise Edition**
- [DB migration to add Milestone widget to Epic work item type](https://gitlab.com/gitlab-org/gitlab/-/commit/6dc651b7964b668bab5bf802bfd2865eac6d0a60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180857))
- [Add zoekt index watermark level update callback](https://gitlab.com/gitlab-org/gitlab/-/commit/99e74190a8de611665e2bc53305717e09d31dc63) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181056)) **GitLab Enterprise Edition**
- [Remove the `pat_ip` derisk feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e5e5dc5a1a1df71e08f03eb15a874880f2a063a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178297))
- [Fix vulnerability autoresolve flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/8f104fb74fe0395c8f0bccdc9fd4fe73418e51c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181850)) **GitLab Enterprise Edition**
- [Fix: Enhance error handling for expired relation export keys](https://gitlab.com/gitlab-org/gitlab/-/commit/1f33e7ad1000bf370345ef452dcf89a4eb8e9e96) by @guptapratibha26 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180802))
- [Improve error handling when creating new directory](https://gitlab.com/gitlab-org/gitlab/-/commit/3a2dc8755ae5724af24ac3d5c08b137dd9077625) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181766))
- [Add ai active context connection model](https://gitlab.com/gitlab-org/gitlab/-/commit/20ffcf455d6416152dabc185a711c06bb1eb7985) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181400)) **GitLab Enterprise Edition**
- [Change project export download rate limit](https://gitlab.com/gitlab-org/gitlab/-/commit/111898b836da5fb2b11e5ad6d236f61e43d63983) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181822))
- [Update Duo Pro usage button to Purchase seats](https://gitlab.com/gitlab-org/gitlab/-/commit/96223f384f943cec325236044c52c31285530160) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181198))
- [Show badge for multiple licenses and tooltip for unknown licenses](https://gitlab.com/gitlab-org/gitlab/-/commit/bedc31cdda02002aa6b759a0b2f99be0603bcd3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181109)) **GitLab Enterprise Edition**
- [Add animation to a menu section chevron](https://gitlab.com/gitlab-org/gitlab/-/commit/559870d1035469987698b183812ee2f24b1b5c0c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174872))
- [Make the Troubleshoot button in the Job Log app sticky](https://gitlab.com/gitlab-org/gitlab/-/commit/8ab43ed407e9802f0b8782e48cf81819b9fb2225) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181565))
- [Set new host URL params when initializing Web IDE](https://gitlab.com/gitlab-org/gitlab/-/commit/4b0d2f3d5da8c26e5c0938cbab983e53a029b1bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180050))
- [Fix Style/FormatString offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/7794ffa690251e1693a8c274dd9e83c56fe160ba) by @JonstonChan ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178810))
- [Readd 422 error context to omniauth error page](https://gitlab.com/gitlab-org/gitlab/-/commit/4e5756c7c67cda1ddfbb9e671584a94a6d4754ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180272))

### Removed (28 changes)

- [Remove all *_tab ff and mark migration as noop](https://gitlab.com/gitlab-org/gitlab/-/commit/6d39c9ed199d759ee0bfeb47edff26ce7a6731f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184734)) **GitLab Enterprise Edition**
- [Removal of non Claude 3 Model](https://gitlab.com/gitlab-org/gitlab/-/commit/b54d187639389b1d5769f70f6275e0bd4ded1373) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184545)) **GitLab Enterprise Edition**
- [BBM for removing orphaned notes](https://gitlab.com/gitlab-org/gitlab/-/commit/765cbfc79aa7d02c6fc3119cf72fde4d7b713cec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180624))
- [Removed feature flag extended_expiry_webhook_execution_setting](https://gitlab.com/gitlab-org/gitlab/-/commit/969c5b6c9aad0481e0bc08ba98d43c572c90bbc6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184300))
- [Remove note on commit real-time update on MR](https://gitlab.com/gitlab-org/gitlab/-/commit/505145665f4d839c36ef697299217fc67816c6af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184138))
- [Clean up `blob_repository_vue_header_app` flag](https://gitlab.com/gitlab-org/gitlab/-/commit/ea324a8af683f6f7492beccfa5135a7e0b0b455a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183259))
- [Cleanup Claude 3.5 Haiku feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/8a0c9c47d30b2068b0939a2e6def188a19f934b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184065)) **GitLab Enterprise Edition**
- [Delete the `zoekt_cache_search_responses` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/daf7dbe21fd620026e52d1a2dcb7f3fa9db58e5d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183217))
- [Remove broken foreign key fk_a2141b1522_p](https://gitlab.com/gitlab-org/gitlab/-/commit/8f2a98491b3f40aaeb4a8dcc48c4a9cdcdc82064) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183638))
- [Remove unused feature flag and partially completed code](https://gitlab.com/gitlab-org/gitlab/-/commit/037bde32ecb4d09c468418843dcfd4bd983b2e20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182334))
- [Delete increased concurrency indexing ff](https://gitlab.com/gitlab-org/gitlab/-/commit/8b8835c716e3c8f2de08bdb58f218a9f55b3553a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183211))
- [Remove redundant code from new pipeline page](https://gitlab.com/gitlab-org/gitlab/-/commit/cc4d772df7ac3f066367698e2858ecf5c5f25983) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182475))
- [Remove unused feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/c2b836e7496cd44e46ee3fc6a0b681c8e1b89634) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183168))
- [Remove confidence columns from vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/1b5ca4b70ec67878056c4b6a20d6b9595b1d182e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182637))
- [Delete the `zoekt_reallocation_task` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/06a4e04e0766cc886bb2851880c5caf39850bdbc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182901))
- [Delete the `zoekt_scheduling_worker` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3e83080edc1d00ce4941bb5e7d99b0fba3f64801) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182854))
- [Delete the `zoekt_replica_state_updates` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/86666f9a3e92547cad804f9fd94b4d87343ca318) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182853))
- [Removing use_typhoeus_elasticsearch_adapter flag](https://gitlab.com/gitlab-org/gitlab/-/commit/de12601a214b480862d82a6551356dfaeae5df40) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182284)) **GitLab Enterprise Edition**
- [Delete the `zoekt_random_force_reindexing` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4bc693c8b00a5d1b2d2127dd644d12a81e9dd5f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182555))
- [Delete the `zoekt_internal_api_register_nodes` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/5acf245b53f22d6fbf7a2a3a48ffd9ab24621f37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182552))
- [Drop geo_event_log.repositories_changed_event_id column](https://gitlab.com/gitlab-org/gitlab/-/commit/076e72c9c49b1918944025dc56afdc0628e7e929) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182462))
- [Remove DB table system hooks and NoStiSystemHooks model](https://gitlab.com/gitlab-org/gitlab/-/commit/263172a41bb0e49daeea14c21e6dd0eae92e90c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182115))
- [Delete the `pipeline_stage_set_last_modified` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3a76d872b3704e8123980ee574148f7b7f7ff6ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182100))
- [Remove yaml format feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f093b1c6795693dd09713f75472b87cfd1ebc8bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181705)) **GitLab Enterprise Edition**
- [Remove ignored AI application settings columns](https://gitlab.com/gitlab-org/gitlab/-/commit/c223ba9a8a34fa163703c0fa00434f3dc6bf35cc) by @crenz ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179175))
- [Remove fetch-arkose-data-exchange-payload feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/2907cbaac718c92ecc5c4571b7c3766826c39868) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181670))
- [Remove custom_ability_read_admin_users feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/201a335f9b22c643bff7314c8effa2acefa874ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181571)) **GitLab Enterprise Edition**
- [Remove pass_add_on_name_for_trial_requests feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/1e2bccd193d6dcf06f863b74c3872f7ea3f08b07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179725))

### Security (18 changes)

- [Fix ruby-saml gemspec](https://gitlab.com/gitlab-org/gitlab/-/commit/c2c5be905c6c6989373e6c5d098293ee2c5f2811)
- [Mask unencoded userinfo in project mirror errors](https://gitlab.com/gitlab-org/gitlab/-/commit/08ae64432f8ea3a57d4f1f731fed435a34087f76)
- [approval_rules name is unbounded](https://gitlab.com/gitlab-org/gitlab/-/commit/57a03b551b4c1442a17368b0a99a6173fcec387e)
- [Vendor GraphQL gem](https://gitlab.com/gitlab-org/gitlab/-/commit/163192bd96554bfc1e57a87b722a13c936753357)
- [Ruby-SAML updates](https://gitlab.com/gitlab-org/gitlab/-/commit/4d45b6fa090a6d4a879eb04d9e156eaecddd26c0)
- [Limit preview size](https://gitlab.com/gitlab-org/gitlab/-/commit/10b827df7c47db18d805f361d82d78f570eb0898)
- [Prevent custom role to activate group members](https://gitlab.com/gitlab-org/gitlab/-/commit/6ee484f51bf9ca4b554fd996e808d9c0a1082e61)
- [Filter out internal notes if the recipient do not have access](https://gitlab.com/gitlab-org/gitlab/-/commit/1ccf3302c55f26b50772709588d1e37ddfb10438)
- [Maintainer can inject shell code in Google integration configurations that...](https://gitlab.com/gitlab-org/gitlab/-/commit/649d3dea98eb12d185791d022f04c39eb4ff4fd4)
- [Revert "Merge branch 'security-private-artifacts-jobs-api' into 'master'"](https://gitlab.com/gitlab-org/gitlab/-/commit/82064a60dccb41503704b7b103662fa47d9604b0)
- [Bump KAS version](https://gitlab.com/gitlab-org/gitlab/-/commit/f0c1092e0b6b76ac7305e872a706bff2b83bc27a)
- [Use stricter CSP values in the packages dependency proxy](https://gitlab.com/gitlab-org/gitlab/-/commit/1801feb9cee23ee0e40b4118f92b85c0a16ade78)
- [Escape work item dropdown items and restrict HTML tags](https://gitlab.com/gitlab-org/gitlab/-/commit/c8b9fff5b661fc66476d45a96372e7fd5477a000)
- [Fix access to read code review analytics in private projects](https://gitlab.com/gitlab-org/gitlab/-/commit/3e82c62c208678269aee11038662e8b4cbf70c54)
- [Increase minimum role in SPP to read policy yaml](https://gitlab.com/gitlab-org/gitlab/-/commit/8006df30b1661af00c010c7507962c72fcfcc3fa)
- [Check user access for artifacts in Jobs API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/ae8cd6c91e3e5c4fd2645182e902f4d7d9a059d8)
- [Resolve "Enterprise User with disabled PATs can still use PATs"](https://gitlab.com/gitlab-org/gitlab/-/commit/5567f530d5145142dcbd9eeafaa21ce8356ea5a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181669)) **GitLab Enterprise Edition**
- [Resolve "Enterprise User with disabled PATs can still create PATs"](https://gitlab.com/gitlab-org/gitlab/-/commit/a5484070e64511211bce9f6076635361938e2b03) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181661)) **GitLab Enterprise Edition**

### Performance (12 changes)

- [Improve User#verified_emails when emails are preloaded](https://gitlab.com/gitlab-org/gitlab/-/commit/21c9c55cba38e58d825ddb75277fe5efffcc191c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184663))
- [Set the patch_id outside of the DB TXN](https://gitlab.com/gitlab-org/gitlab/-/commit/2f4a3e2f5eebe23d6f277de789ffa0cdb5c41a1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179734))
- [Fix backend filtering in RTE autocomplete](https://gitlab.com/gitlab-org/gitlab/-/commit/c7b0872098ba9a3e3974ba913ed5f86e4df4c7d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183637))
- [Model: Improve performance of with_version_count scope](https://gitlab.com/gitlab-org/gitlab/-/commit/6a82a69352bc9f2079cc15ebadb200a6145307aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183031))
- [Update the authentication codeowners yml & script](https://gitlab.com/gitlab-org/gitlab/-/commit/ec85af3ebb68c73de6838e5e6881a67ce53f207e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178264))
- [Improve query performance for all_projects_pages_domains query](https://gitlab.com/gitlab-org/gitlab/-/commit/787589188a8a493cd15631cc21af9333c7663aef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182897)) **GitLab Enterprise Edition**
- [Enable ci_merge_request_variables_preload and remove the FF](https://gitlab.com/gitlab-org/gitlab/-/commit/803f8812bd94e381bc9703a4eaa7da628da6ee8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182252))
- [Prevent N+1 queries when fetching issue references](https://gitlab.com/gitlab-org/gitlab/-/commit/b8e8954f33d6e2bca470161a17a6574d80034ecb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182233))
- [Optimize build.execute_hooks when creating pipeline](https://gitlab.com/gitlab-org/gitlab/-/commit/3213e2e4bc384cbee052ecadfbeef5faaaed7e17) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182074))
- [Validate p_ci_pipeline_variables#project_id constraint](https://gitlab.com/gitlab-org/gitlab/-/commit/0337ecbd1e3ebaffa46d2a0c8755f0f479e29153) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180066))
- [Deliver reassignment mails later](https://gitlab.com/gitlab-org/gitlab/-/commit/84ed112184b3aa05897472f67f50e26ff9738fc9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181826))
- [Enable bitbucket_import_resumable_worker flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e91cf215414b44559710a9f473526650eda91679) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181647))

### Other (194 changes)

- [Add NOT NULL on ml_candidate_metrics.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/31aefa505b8e64330eb8db7119a7de5e5b90272e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184431))
- [Add NOT NULL on ml_candidate_params.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/3d32c3f1fbae958cdb56c3410fbb61d474f312b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184432))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/34e391840a30714cc639abac909d9ad79d58f09b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184766))
- [Add and backfill project_id for merge_request_context_commit_diff_files](https://gitlab.com/gitlab-org/gitlab/-/commit/49a59903299a998d3e3aa6fcc8f917516dcfa384) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183935))
- [Add compliance control status transition events and metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/1c3565339b78cff53f7cc40603dedec6f66b078e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183256)) **GitLab Enterprise Edition**
- [Add NOT NULL on ci_build_trace_chunks.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/719454739f9bd4be3b0a5f829cd848aab0c16f9a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183976))
- [Documenting Cells configuration for OmniBus and Helm Charts](https://gitlab.com/gitlab-org/gitlab/-/commit/98830eb3b96587647db39a0a48774e35c302767a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180957))
- [Improve documentation access token API](https://gitlab.com/gitlab-org/gitlab/-/commit/ab0baf261c3861b95ad53e8008ffa57cd08bdfde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184291))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/1513d44c30d0adefd16f414040b3aeb22df00f90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183188))
- [Model registry: Simplify table mechanism](https://gitlab.com/gitlab-org/gitlab/-/commit/83de5babd1f2280f6f9cacf7c36ffffb9e26a186) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184031))
- [Add and backfill project_id for packages_nuget_dependency_link_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/7ae94045c8f36be77c7199028df8a1b1ea53e5ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184610))
- [Add NOT NULL for sharding key on packages_package_files](https://gitlab.com/gitlab-org/gitlab/-/commit/12f461033ac48f9a51c124a2162aeb5327625b6e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184630))
- [Add NOT NULL for sharding key on incident_management_oncall_rotations](https://gitlab.com/gitlab-org/gitlab/-/commit/793d6b8f03b7b8be59f8619a18debdcd78b4cb88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184622))
- [Sync translations from crowdin (2025-03-14)](https://gitlab.com/gitlab-org/gitlab/-/commit/7e8edbc6510143d8a01eca2c05453283833f4315) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184615))
- [Add sequence to partitioned runner tables](https://gitlab.com/gitlab-org/gitlab/-/commit/3889fe2e32946d647fe721f2dd82aa67fdc5644f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183817))
- [Remove Gitlab::Redis::ClusterSessions post migration](https://gitlab.com/gitlab-org/gitlab/-/commit/dad64361c6b56ec1f4dd3ec2033f74b47ff5d3c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184562))
- [Add NOT NULL on ci_builds_runner_session.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/8ca1bd48a443e69bdb0f7d8e78d5c04df0f22ead) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183977))
- [Add NOT NULL constraint on ci_unit_test_failures.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/24cc5df25fb46d675a38c142efa631dae68453c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182507))
- [Add NOT NULL constraint on packages_dependency_links.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/41c3220cc4261eac7a1df63cd48ec6f562b5cbe1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182510))
- [Migrate HTTP instance audit event destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/7d19d209c72089be675034093286dd4e6f394163) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184035)) **GitLab Enterprise Edition**
- [Skip saving pipeline config when using inputs](https://gitlab.com/gitlab-org/gitlab/-/commit/e8af953ebc6ddedf3df806694625f5dcf31b447c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184318))
- [Add & backfill sharding keys for snippet_user_mentions](https://gitlab.com/gitlab-org/gitlab/-/commit/114308c19e8ebf0e6d6f97bfcb969701c6172707) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180836))
- [Add & backfill sharding keys for snippet_statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/4f30c94fba6bc2068ce33ad64dd6b90e17ad7bfa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183124))
- [Add & backfill sharding keys for snippet_repositories](https://gitlab.com/gitlab-org/gitlab/-/commit/bbcb0efba3bc4c7b6fa577fa14c6c89721255aef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175410))
- [No-op 20250307080100 migration and retry in 20250307080101](https://gitlab.com/gitlab-org/gitlab/-/commit/f60155196640decafdf40d185c2d4bb7a758cf52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184439))
- [Add ProjectsWithComplianceFrameworks metric](https://gitlab.com/gitlab-org/gitlab/-/commit/a056fce989d95e9c324c6fdd3a06b172a93bd01a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183422)) **GitLab Enterprise Edition**
- [Add compliance requirement metrics for controls and policies](https://gitlab.com/gitlab-org/gitlab/-/commit/f5dd408a36e4391b554c17382658f4d49131e014) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183382)) **GitLab Enterprise Edition**
- [Sync translations from crowdin (2025-03-13)](https://gitlab.com/gitlab-org/gitlab/-/commit/59d23b74f074baf95a4d64249a788c0674e41919) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184470))
- [Remove Gitlab::Sessions::RedisStore as session store](https://gitlab.com/gitlab-org/gitlab/-/commit/b9c288656b9e40f699462ced6a5225888ec2f087) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181637))
- [Remove update_merge_request_worker_sticky feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d48f58a5d02537aa44e2fa752c471ae15e10a98a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184411))
- [test: Add missing feature categories for tests related to system access](https://gitlab.com/gitlab-org/gitlab/-/commit/ec53d463bf176db2350a85713bd11e41ea87e4ce) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176700)) **GitLab Enterprise Edition**
- [Sync translations from crowdin (2025-03-12)](https://gitlab.com/gitlab-org/gitlab/-/commit/3fe80a44d1b019acea6600a575d2815522a65548) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184036))
- [Finalize migration BackfillMembersRequestAcceptedAt](https://gitlab.com/gitlab-org/gitlab/-/commit/0187d67271e58fd710180e5faaab1f9fb7531e37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184105))
- [Add internal event tracking to placeholder reassignment](https://gitlab.com/gitlab-org/gitlab/-/commit/0244f146f8fb5794a545685d391afc86ce68d59a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182679))
- [Enable reassignment throttling feature](https://gitlab.com/gitlab-org/gitlab/-/commit/cf25daf2d4444f1f0a621a48a53a95b99e004991) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184131))
- [Replace ci_runner_machines with partitioned table](https://gitlab.com/gitlab-org/gitlab/-/commit/5680b0559d160a214e72ad23dfb2c38e7a7a4706) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182859))
- [Finalize migration BackfillMilestoneReleasesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/9b0a98b5985cb66cab0ce731115b17a1ab6c3967) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184106))
- [Remove redundant validate in BulkImport::Entity](https://gitlab.com/gitlab-org/gitlab/-/commit/f9e4a8ae23165520a44882e17bdcbe1231ad2441) by @n.h.long.9697 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182760))
- [Improving Cells validation message](https://gitlab.com/gitlab-org/gitlab/-/commit/a7127cc046b94832eb4d835debf800c92e264d91) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184040))
- [Finalize migration BackfillIncidentManagementEscalationRulesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/cff739e1dfd123693cf7d18bb74484ad013b7dfb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183765))
- [Add and backfill project_id for deployment_merge_requests](https://gitlab.com/gitlab-org/gitlab/-/commit/577d1817d5424403700b709fb27d086153ba714f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183738))
- [Add and backfill wiki_page_slugs for namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/60acb9075de7b0101bfc4a89f0e0d7accbec26b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183332))
- [Remove Gitlab::Redis::ClusterSessions post migration](https://gitlab.com/gitlab-org/gitlab/-/commit/9d143551abc59e6a0b30d4af42af96c3e876dac5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181631))
- [Finalize BackfillIncMgmtTimelineEventTagLinksProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/61bed0e11899a199c01095e59046834b32260d92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183908))
- [Finalize migration RerunEpicDatesToWorkItemDatesSourcesSync](https://gitlab.com/gitlab-org/gitlab/-/commit/d55563e12754a5aa85eb18aa8cc6cc871fdb6342) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183282))
- [Remove bulk_create_scan_result_policies Feature Flag](https://gitlab.com/gitlab-org/gitlab/-/commit/6558e1637d19ab0bdee0b5c494e9acb56c37fb6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183509)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/60445f0f5ef1c52460e85dec9257113edd26badd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183923))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/f9e0c3fe1aa6e74eebbb473ab2cad86509065583) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184119))
- [Populate redirect_routes.namespace_id on save](https://gitlab.com/gitlab-org/gitlab/-/commit/b258d82c870660dbd251af5a5e7fc6e29eef722a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183974))
- [Add FK constraint and index on merge_request_user_mentions.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/21634826da4ff0ee4d3400ae6a519d5480257694) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183971))
- [Fix merged MRs that reverted to "closed" state](https://gitlab.com/gitlab-org/gitlab/-/commit/ea4ef3c3809ae45a71be0b8fd97f46b3ae0b789a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181021))
- [Remove existing users from onboarding if they have group saml](https://gitlab.com/gitlab-org/gitlab/-/commit/81605ddb9c114dba8a6030fa728cf06b6b0f8575) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183559))
- [Fix Style/SendWithLiteralMethodName offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/7a47fc425ded8d3f51274b0ff069710655b2e0ca) by @albertoroldanq ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179585)) **GitLab Enterprise Edition**
- [Remove the `mr_approvers_filter_hidden_users` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/275476b7757ed7665b6b5f8293773eb1d3142327) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183058))
- [Add and backfill project_id for approval_merge_request_rules_approved_ap](https://gitlab.com/gitlab-org/gitlab/-/commit/880a4f383dafaf9bf80088aa005e133f17657a5c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183352))
- [Replace ci_runners with partitioned table](https://gitlab.com/gitlab-org/gitlab/-/commit/21cbc3beac1b4c58eb47a0b2c2a791100f3ec124) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183508))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/8abda5c1de7f6556f0dd4c23a856a339fcea8f3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183628))
- [Add and backfill project_id for approval_merge_request_rules_users](https://gitlab.com/gitlab-org/gitlab/-/commit/f683b5501f484b294bc22fc8acb4d397312bbc48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183354))
- [refactor: Add oauth_login_counter before request phase middleware](https://gitlab.com/gitlab-org/gitlab/-/commit/9788d7d1f3502027cf474f697859ce1a38f774a9) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177720))
- [Finalize migration BackfillCiSecureFileStatesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/0f0499f55fb0dd86819daf179cc65ca5586f137e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181727))
- [Finalize migration BackfillIncidentManagementOncallRotationsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/9d8a6e53c97108433caf92fcdd93ad2427f2e8a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183766))
- [Finalize migration BackfillDastSiteProfilesBuildsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/49960c402969bd5aa2d56778e7d4ef11711631fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183452))
- [Finalize migration to backfill namespace_id in policy rule schedules](https://gitlab.com/gitlab-org/gitlab/-/commit/ccaffa6a8e7908f3ee13541b513acaf247a99961) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183280))
- [Finalize BackfillApprovalProjectRulesProtectedBranchesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/23b71c4faf18a88099a60620d1285c0b61876e91) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183451))
- [Add CountFrameworksWithRequirementsMetric](https://gitlab.com/gitlab-org/gitlab/-/commit/bbb8bb5eaac6575034ba865fbca77f0be0c5347c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183414)) **GitLab Enterprise Edition**
- [Add and backfill project_id for packages_debian_project_component_files](https://gitlab.com/gitlab-org/gitlab/-/commit/773bf078489ae099410dbe3e929bf2793a007746) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183806))
- [Rename remote development namespace cluster agent mapping table](https://gitlab.com/gitlab-org/gitlab/-/commit/b6c3b59f2a95317f93df1db680fbf065abeadb30) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181926)) **GitLab Enterprise Edition**
- [Add NOT NULL constraint on packages_debian_project_components.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/67e6453223fb1a1b6fbe9650c0ec05e54babb696) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182509))
- [Cleans up authentication_logs_migration_for_allowlist feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/5664ef2019c354fb2eaf15d9c3ff211258de39a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183773))
- [Create ClickHouse table to store group traversal namespaces paths](https://gitlab.com/gitlab-org/gitlab/-/commit/93eeeb09c78e953d3587f4577d2c6ada4d4caaf2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182164))
- [Add namespace_id column to redirect_routes](https://gitlab.com/gitlab-org/gitlab/-/commit/133f4815bcfd064c3d4ed34164d18b66744c2d15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183002))
- [Add performance bar to GraphQL explorer](https://gitlab.com/gitlab-org/gitlab/-/commit/57190ec595dcf60febe30b83deb8685c430adcae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171948))
- [Validate not null constraint on projects.project_namespace_id column](https://gitlab.com/gitlab-org/gitlab/-/commit/595684382c459d18bccd0f3444fd53a2065f4412) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183649))
- [Refactor Cells configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/1dd42ed25234e1be37273ad4399d5db4501bfda3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181708))
- [Add and backfill namespace_id for incident_management_pending_issue_esca](https://gitlab.com/gitlab-org/gitlab/-/commit/d7b8feaf1b544a8a342c9937189f74fbd7ddd4ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183047))
- [Remove shared_namespace_locks feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/79b86d8e467ac2a7292a7e0b484d1c76003f5abd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183624))
- [Use occurrence id to fetch dependency graph](https://gitlab.com/gitlab-org/gitlab/-/commit/4b42d50e7ad8b20fd974042949aabbca0797477b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183625)) **GitLab Enterprise Edition**
- [Finalize migration BackfillCiBuildTraceMetadataProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/2673238b6d419b4eba095409874c325011b4b23e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182192))
- [Backfill onboarding_status_setup_for_company from user_preferences](https://gitlab.com/gitlab-org/gitlab/-/commit/b071a20a528b307bc84905604c3de6e46029a99d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180602))
- [Add approval_policy_rule_id to scan_result_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/a79788d08fdc1f319da981a4dbf8a016044c2476) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182418)) **GitLab Enterprise Edition**
- [Remove broken FK between builds and pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/214d2295825675a79262f5c7e6aa42daa31d54ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174115))
- [Move Import file removal to a cron job](https://gitlab.com/gitlab-org/gitlab/-/commit/1d6c03f0b2047a6bb9f69035f68028911c549063) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182101))
- [Remove ci_runner_manager_runtime_features feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/2b5b8d8b5aa36ce8ae32381d5bca5afc5bb3db8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183500))
- [Finalize BackfillSecurityOrchestrationPolicyRuleSchedulesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/77d6f49595b87fcaf6534c741e1b04f735d80f84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183281))
- [Finalize Batched Background Migration](https://gitlab.com/gitlab-org/gitlab/-/commit/63460747ade74fac657a198f1ba118644daa6649) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182653))
- [Remove groups/discovers_helper.rb](https://gitlab.com/gitlab-org/gitlab/-/commit/0a893e67ca9a85f2dac582e86e16732ab2467e99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182779)) **GitLab Enterprise Edition**
- [Reindex work items to index notes data](https://gitlab.com/gitlab-org/gitlab/-/commit/c2cb179046c0fc700b9bd4e2d27fcd8824bb7ca2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182950)) **GitLab Enterprise Edition**
- [Replace ci_runners with partitioned table](https://gitlab.com/gitlab-org/gitlab/-/commit/93cf156a339a7e14815600a92d1329430842eb55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182549))
- [Add and ensure presence of resource_mileston_events.namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/f7a9511c8e3455e0b9c7219718d440f24ca5b82a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181868))
- [Add ability to manage experimental features for security policies](https://gitlab.com/gitlab-org/gitlab/-/commit/5b2f637b31e942f79731e5d5042265fa5d17bd0b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182484))
- [Add index on approvals.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/b1edb2fc3ba2a3d7a1ac4f1b4b572a941fb1876e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182066))
- [Add NOT NULL on ci_pipeline_schedule_variables.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/63c118d28f7d0c4653365219ed1ca1f175253121) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182681))
- [Add and backfill project_id for push_event_payloads](https://gitlab.com/gitlab-org/gitlab/-/commit/f03f3991fa283cdc1216032c028a2e9651503d46) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183123))
- [Finalize protected_environment_deploy_access_levels backfill](https://gitlab.com/gitlab-org/gitlab/-/commit/2d5e8328b7b7071b1781091af90d5e4bf6db9bda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183279))
- [Validate NOT NULL on approval_merge_request_rules sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/6e98f72a64120a0700df81b63bd8c3e569e19133) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180907))
- [Add and backfill project_id for scan_result_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/ecc5b7abfd71962f8e6d2ee4ea04d6714dda4f48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183125))
- [Minor improvements to the performance bar](https://gitlab.com/gitlab-org/gitlab/-/commit/a45c755ba147f735a076ec0e780ce5406bfefeb2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181397))
- [Finalize migration BackfillProtectedTagCreateAccessLevelsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/e7824f9ab214f3c7e6f840bceffc4bd83bb5eccd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181208))
- [Remove dead code around recaptcha_on_top_level_group_creation feature](https://gitlab.com/gitlab-org/gitlab/-/commit/64a32f0674c13f333c5cea96b1bb796efca850b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183174))
- [Finalize migration BackfillMlCandidateParamsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/f52900d7b38399494433fc148be672d576d1de1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183109))
- [Finalize migration MakeSecurityPolicyBotsPrivate](https://gitlab.com/gitlab-org/gitlab/-/commit/1d8014071f93ee3b942952b72dd7085d31f44f08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182962))
- [Finalize protected_environment_deploy_access_levels backfill](https://gitlab.com/gitlab-org/gitlab/-/commit/0242462664281a7470b6bd66e24aff5fbce9a6ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183110))
- [Move Import file removal to a cron job](https://gitlab.com/gitlab-org/gitlab/-/commit/e4a7ff58142e84458a3f18e838de333c2ab9891c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181784))
- [Finalize migration BackfillReservedStorageBytes](https://gitlab.com/gitlab-org/gitlab/-/commit/446f6068b41b0bc819f2a392931bec463912622c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182189))
- [Store project namespace traversal paths on ClickHouse](https://gitlab.com/gitlab-org/gitlab/-/commit/cfd2482073576de3332749d8effac5085491b59e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183053))
- [Introduce `Vulnerabilities::ArchiveExport` model](https://gitlab.com/gitlab-org/gitlab/-/commit/fa145e30591667582b14f1d1b32776aeaa89a3ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182290))
- [Reindex Elasticsearch merge request to update integer with long type](https://gitlab.com/gitlab-org/gitlab/-/commit/28c969e902362b492225b6f4dde9519febfbc10e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182255)) **GitLab Enterprise Edition**
- [Reindex Elasticsearch user index to update integer with long type](https://gitlab.com/gitlab-org/gitlab/-/commit/94eee10017dd8e418eb5c55eb393c481c570ead7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182733)) **GitLab Enterprise Edition**
- [Reindex Elasticsearch note index to update integer with long type](https://gitlab.com/gitlab-org/gitlab/-/commit/f1d971c86bbf29b1570f9053912495739cd01e53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182727)) **GitLab Enterprise Edition**
- [Finalize "generate commit message" migration to AI Gateway](https://gitlab.com/gitlab-org/gitlab/-/commit/a70658e227b2cca454cb26a1814d96bef4261414) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182969))
- [Finalize migration BackfillCiBuildsRunnerSessionProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/0b08c2dec0ebf6b469870b8991c0c50e73942d7a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181723))
- [Finalize migration BackfillMlCandidateMetricsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/f4c506f3a2dfb67fc8c07662cb3bcd3fc4a69e2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182963))
- [Finalize migration BackfillVulnerabilityOccurrenceIdentifiersProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/43ace000ca708a9a960ae988e141efe4e1fd7efd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182654))
- [fix(rubocop): Fix Performance/MapCompact offenses in app/models/ci](https://gitlab.com/gitlab-org/gitlab/-/commit/6d9cae74b9ed8e5624a7337140790548c246196f) by @thelooter ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182956))
- [Remove kubernetes_agent_protected_branches feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/2280141eebab910158a344951cda78586086c6e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182895))
- [Remove feature flag pat_organization_filter](https://gitlab.com/gitlab-org/gitlab/-/commit/f42e8601404015866abc046fa007213c0c65965d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182700))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/ae18647f643704cf2f6499f419657cd04c8e96e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182673))
- [Finalize migration BackfillEpicIssuesNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/2a1fbf479b636c5120a0dd5da996be85f3c6553d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181719))
- [Finalize migration FixNamespaceIdForWorkItemParentLinks](https://gitlab.com/gitlab-org/gitlab/-/commit/709b7692ef46039fcb7b070452e379b306fea145) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182656))
- [Fix any bad sharding_key_id values on project runners](https://gitlab.com/gitlab-org/gitlab/-/commit/b612a0ad4c82d5cea8c3150ff0e905b766dba52f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182527))
- [Update work_item_type_custom_fields FK](https://gitlab.com/gitlab-org/gitlab/-/commit/c0e5b9b6a88fe42dd340bf52f58f0aecff705618) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182051))
- [Fix Style/SymbolProc offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/9b31b6baeaaf314685c4db110d1fab87137d102d) by @barton.tomas ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181311))
- [Introduce data retention guidelines](https://gitlab.com/gitlab-org/gitlab/-/commit/23b9659db568b77e904904c2867678adbc485c97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178455))
- [Add NOT NULL on vulnerability_state_transitions.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/1342a12bf73ab1563caf9a50032445531dffcc46) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182698))
- [Finalize migration BackfillErrorTrackingErrorEventsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/5f59c6f57262511849ebe59ddf2c59d18ac8f383) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181720))
- [Save runner runtime features to runner manager](https://gitlab.com/gitlab-org/gitlab/-/commit/e6e0813759ff8742c2588d177b88234227643506) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181817))
- [Validate NOT NULL constraint on packages_build_infos.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/bef629ebe02c776886e60bc68c86e0c4945df568) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182526))
- [Validate NOT NULL constraint on merge_request_reviewers.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/37ccc8b5902a7eb24ab73f3f2566b93d1c1d4c16) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182524))
- [Add NOT NULL constraint on evidences.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/00b2cc0f4e3c24ba40dc42fb72ebd63424445982) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182508))
- [Add NOT NULL constraint on packages_maven_metadata.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/34ba8b3e62d8edbcd68e2feebef08835f2ba47b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182511))
- [Add and backfill namespace_id for issue_assignees](https://gitlab.com/gitlab-org/gitlab/-/commit/ef77f05e872bed20da94544321182e10886f0f0c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174106))
- [Finalize migration BackfillCiPipelineScheduleVariablesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/a42d96684acb006b4a063db76787b079ba3baab6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181725))
- [Remove correct_work_item_type_id from work item index](https://gitlab.com/gitlab-org/gitlab/-/commit/0a4d85e57d8a517352dc310766612f65d93e98d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182551)) **GitLab Enterprise Edition**
- [Replace client lib with pure HTTP implementation](https://gitlab.com/gitlab-org/gitlab/-/commit/e5bbaf93c43c83fafcda8c33f5ef36de46ff1759) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182567))
- [Add new Elastic commit indexer worker](https://gitlab.com/gitlab-org/gitlab/-/commit/7e93d41685abe15dee084588f2a0116e845a0c98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182114)) **GitLab Enterprise Edition**
- [Enable virtual_registry_maven_cleanup_new_worker_class by default](https://gitlab.com/gitlab-org/gitlab/-/commit/2bd137bcf385496fcecbda4eb5ca13192eab70ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182560))
- [Remove security widget findings FF](https://gitlab.com/gitlab-org/gitlab/-/commit/951b74877df8075bfb226d25fa6c59ddf331c9ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182541)) **GitLab Enterprise Edition**
- [Remove show_diff_if_head_sha_commit_is_missing flag](https://gitlab.com/gitlab-org/gitlab/-/commit/18512914ed74fce2ba2e2ec80a6117a2a4f0577b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182473))
- [Creates event trigger to alter range of new sequences](https://gitlab.com/gitlab-org/gitlab/-/commit/e51a48ba87ecbc70d2c65976e320773f78445045) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181115))
- [Add the new state deleted in Zoekt::Repository model](https://gitlab.com/gitlab-org/gitlab/-/commit/130f7b5e27c367a177c3e396e2c2bee1cc05557e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182402)) **GitLab Enterprise Edition**
- [Remove `global_file_size_check` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/fa8667b80dda3cb3ed44e755350f4ab041124783) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173546))
- [Remove reference to taggings table in deduplicate_tags rake task](https://gitlab.com/gitlab-org/gitlab/-/commit/9f0c508f50e4a1aef2f138bb54598f54e4d6b72f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182412))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/11ae1fa569bcd1fb28067bf7783c65395fe4e789) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182408))
- [Cleanup security_policy_custom_roles feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4a482bbc33a50ab16f01cb97fadc4fce861b533d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181530)) **GitLab Enterprise Edition**
- [Finalize migration BackfillMergeRequestUserMentionsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/7d9d3d2c63248e538d7b61887018f1d4a5964882) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181880))
- [Validate NOT NULL on merge_request_blocks sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/917a705a30218442626274a9a6357a5dadf3ca52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180913))
- [Remove feature flag `policies_always_override_project_ci`](https://gitlab.com/gitlab-org/gitlab/-/commit/e257a9ab9abbfb4c2d8063cb157a83f57083ae9e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182001)) **GitLab Enterprise Edition**
- [Finalize Batched Background Migration](https://gitlab.com/gitlab-org/gitlab/-/commit/44b224d018493b6edb7709829996f7fff6c34f97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182188))
- [Finalize migration BackfillEvidencesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/f7e005bbb6dae8a5a54952afa898255b5e1f8902) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181721))
- [Finalize migration BackfillCiBuildTraceChunksProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/4ebba95792c93a88c2e4a8272b3ed8e3595dd0e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182191))
- [Finalize migration BackfillCiBuildPendingStatesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/a078e50c90c13218f744954c02347f9efa9477cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182190))
- [Add tables/model for targeted messages](https://gitlab.com/gitlab-org/gitlab/-/commit/65a84e0299508cb21ae7b6e3005fbfadd92809d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179303))
- [Remove ai_commit_reader_for_chat flag](https://gitlab.com/gitlab-org/gitlab/-/commit/cb549de5bdda28c27cf091ee46e5671cf6c7c053) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181555)) **GitLab Enterprise Edition**
- [Add and backfill group_id for packages_debian_group_component_files](https://gitlab.com/gitlab-org/gitlab/-/commit/8831e8e773a144d62789c57b2214119aec2fed2c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182117))
- [Add and backfill project_id for project_relation_export_uploads](https://gitlab.com/gitlab-org/gitlab/-/commit/c5d70a305c577138d6d56302d60efc475a1c9ebe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182116))
- [Add NOT NULL constraint on packages_debian_group_components.group_id](https://gitlab.com/gitlab-org/gitlab/-/commit/41410bb73a81cd0eeac8015352e418174cd47247) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181064))
- [Release vulnerability report identifier filter for group level](https://gitlab.com/gitlab-org/gitlab/-/commit/022bbec4123ec5d75d52e6887c16c0e7b92078d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182084)) **GitLab Enterprise Edition**
- [Finalize migration FixSyncedEpicWorkItemParentLinks](https://gitlab.com/gitlab-org/gitlab/-/commit/ee62a87c75df8be99e1d0c39faccf55b3c7aae4c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181330))
- [Validate NOT NULL on project_relation_exports sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/83472208a7c3e9cead4fe9ad3bd3c7dcfe83130e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180914))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/65082c9a54186e0a4e93a9385c27bd14d5493221) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182057))
- [Validate NOT NULL on draft_notes sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/96c9c3d3b0804a90b8ac55aad7e6275f03d8491f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180909))
- [Finalize migration AlterWebhookDeletedAuditEvent](https://gitlab.com/gitlab-org/gitlab/-/commit/6adbc44d84adb7c1674107904bac2ce700fc524c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181480))
- [Finalize migration BackfillCiResourcesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/8dbde447f2810fc89d81bee928b15cead1e0d179) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181726))
- [Refactor approvals widget](https://gitlab.com/gitlab-org/gitlab/-/commit/f684e7be723f58344ff96249e5895083f5fb9d87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178957)) **GitLab Enterprise Edition**
- [Remove Elasticsearch settings from application settings](https://gitlab.com/gitlab-org/gitlab/-/commit/95418b5ea732f2a6231ea2247ba91cbd00b0d24e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181660))
- [Remove unused ClickHouse table ci_failed_pipelines_counts_by_namespace](https://gitlab.com/gitlab-org/gitlab/-/commit/1d308570d9f40b634931244284b5ed2afa6b0b9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182019))
- [Validate NOT NULL on status_check_responses sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/9ea39e80542b6b24e37beab0d116d2353013eb31) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180701))
- [Validate NOT NULL on vulnerability_finding_links sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/80472e5665b50192db1c2dd89142c959d3a35e40) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180689))
- [Finalize migration NullifyBuildsAutoCanceledById](https://gitlab.com/gitlab-org/gitlab/-/commit/e9e3a23bd6de3670ec2f89147a28d72c618301f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181732))
- [Finalize migration BackfillCiTriggerRequestsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/775a69f8fb60e26f6c223c2c29eaad35cafd25b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181729))
- [Finalize migration DeleteOrphanedPipelineVariableRecords](https://gitlab.com/gitlab-org/gitlab/-/commit/eb8c59eb0aca189f4c9ba30dca3804b2e2ea8769) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181730))
- [Finalize migration BackfillCiBuildNeedsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/ff678d0f38fe270d298d3e45ccf5250a947d68cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181722))
- [Reindex work items for type id alignment](https://gitlab.com/gitlab-org/gitlab/-/commit/5df7fbe7e36914f295983efabc7e42afd5ce7c63) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181790)) **GitLab Enterprise Edition**
- [Finalize migration BackfillCiUnitTestFailuresProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/928f7d0dfeeb581c6488838fedb5c34986ca10c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181728))
- [Finalize migration BackfillPackagesPackageFilesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/11ed1d8ac4ebe9ed6550e1277bebc25f57365a2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181882))
- [Finalize migration BackfillVulnerabilityStateTransitionsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/e578dec947e6092be8e3b8bfd2a2c8ddc885ac51) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181203))
- [Remove ElasticIndexingControlWorker job instances](https://gitlab.com/gitlab-org/gitlab/-/commit/e48ffffd972ca76c738cb7beb938c2ea8e34ab60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181668))
- [Change routes.namespace_id from LFK to regular foreign key](https://gitlab.com/gitlab-org/gitlab/-/commit/9a75bbf1cdd6eea1532e8deda641db683b59e531) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181772))
- [Finalize migration BackfillVulnerabilityExternalIssueLinksProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/84e34ecdf8fb4b7e174b59390dfdb5deae5ad338) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181209))
- [Remove concurrency_limit_process_commit_worker feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/0d19797675118823b66844c18a8939fbb8b3b39e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181758))
- [Add NOT NULL constraint on merge_request_reviewers.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/b8045ea96420397aeccc721315a9b74d7a0dea9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181081))
- [Use the pipeline creation meta data rather than project.ci?](https://gitlab.com/gitlab-org/gitlab/-/commit/a5cb7724df7dfb75862c248b314d269626c1b2e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181745))
- [Validate NOT NULL on merge_request_assignees sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/a517000bab7e91b063f7edd37609af4e17500d6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180912))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/0244921f55a133eb8dd57e17c212edb6e62cc2e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181491))
- [Update maven virtual registry cache entries table](https://gitlab.com/gitlab-org/gitlab/-/commit/fae2f9df5189040d8790d7c98c37c1dd21828d04) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181707))
- [Re-enqueue LimitNamespaceVisibilityByOrganizationVisibility migration](https://gitlab.com/gitlab-org/gitlab/-/commit/4f536c2bd45495263e6f5706117245307f58e148) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181640))
- [Add NOT NULL constraint on merge_requests_closing_issues.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/b61c2e1c39dec7a91d43f7ef2a12fdc769fee767) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181082))
- [Finalize migration BackfillPackagesMavenMetadataProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/d27b6ead984e72424569109176e998a5c7bdce5f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181207))
- [Add NOT NULL constraint on vulnerability_merge_request_links.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/ef7913273b9a45cce654fbadb46e06524c59550a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181080))
- [Add NOT NULL constraint on vulnerability_issue_links.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/c34add13294a3d6f1e22c9747685cb712da9b1c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181079))
- [Validate NOT NULL on epic_user_mentions sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/661448171c0c5f2ac9dd8984f406db19d7169ba1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180910))
- [Validate NOT NULL on issue_links sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/88d10656deca31b2af41b3fcb20f5c56aa88af7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180911))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/998d8028213da6bf0c3c1c08301797c8b3395c28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180234))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/8ae69a3765cfb7561db95e43faa30cc60fac6444) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177662))

## 17.9.8 (2025-05-07)

### Fixed (2 changes)

- [Bump devfile gem to v0.4.3](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4586145dda8558f5af93e24aaeeb7810dd8d4986)
- [Only check records with encrypted data in gitlab:doctor:encryption_keys](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8ea60ee95fa9603bbfab42374ce4be932f80c571)

### Security (3 changes)

- [Improve Octokit::ResponseValidation middleware and add rate limits](https://gitlab.com/gitlab-org/security/gitlab/-/commit/dbf91625730119709829caf0de36a1a0a85e1cca) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4937))
- [Remove id attribute from OAuth form](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c62d3390b16495e22db7aca5ea2464d5b3c2df24) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4950))
- [Use IssuePolicy for #issues_readable_by_user](https://gitlab.com/gitlab-org/security/gitlab/-/commit/03bdcca386dda566770614d21b099e2819b86b53) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4957))

## 17.9.7 (2025-04-22)

### Security (4 changes)

- [Add SecureHeaders middleware with the Nel header](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5e9112ba2d6fac340e1dbfc4b0330bdcff2f82bc) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4920))
- [Restrict forwarded headers in Maven dependency proxy](https://gitlab.com/gitlab-org/security/gitlab/-/commit/24d73f3e778471c4e0153af174f2d8b44e106108) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4931))
- [Security unauthorized access to reading branch names](https://gitlab.com/gitlab-org/security/gitlab/-/commit/cb09987371857b97ec3cc5774b9f214c9db7c8a6) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4923))
- [Simplify detecting paragraphs for quick actions](https://gitlab.com/gitlab-org/security/gitlab/-/commit/29d3f746b02137aaff4364473ce62f701d208e27) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4927))

### Other (2 changes)

- [Clean up BackfillCiRunnerMachinesPartitionedTable migration](https://gitlab.com/gitlab-org/security/gitlab/-/commit/76d351431e07b3a695356c7b78ac16d23b180302)
- [No-op FinalizeBackfillCiRunnerMachinesPartitionedTable migration](https://gitlab.com/gitlab-org/security/gitlab/-/commit/fb16e2ebcc6188b3f9bb0bc30e7e2b709484f3b1)

## 17.9.6 (2025-04-09)

### Security (6 changes)

- [Bump workhorse golang-jwt/jwt to 5.2.2](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ac61772efb740af0684755d1db7d057f412b218e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4913))
- [Global search count leak for confidential issues](https://gitlab.com/gitlab-org/security/gitlab/-/commit/46932e9f78e0b138b8fd7320b2e4e4c09f2fcfc0) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4908))
- [Set the IP address state for Action Cable requests](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7019ae8aa04f49f66d7db86ec4023f816f8e90f1) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4905))
- [Adding validation for Ci::Pipeline](https://gitlab.com/gitlab-org/security/gitlab/-/commit/33961db6cab6ac4d3cc99d4ad521f160b43aafe2) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4885))
- [Add delay to when pointer events are enabled for 0Auth authorize page](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b154f7884178a622da6d60fdcbd1097ce50cc6cb) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4852))
- [Do not enable pprof by default in Workhorse](https://gitlab.com/gitlab-org/security/gitlab/-/commit/94aba826029e01791e394456aa9dd6a5db497415) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4890))

## 17.9.5 (2025-04-02)

No changes.

## 17.9.4 (2025-04-01)

### Fixed (1 change)

- [Ensure runner taggings are copied from taggings](https://gitlab.com/gitlab-org/gitlab/-/commit/40aa3c8333f19f65f7a74526d61c228e2525f3c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186278))

### Other (1 change)

- [No-op ci_runner_machines_687967fa8a table backfill migration](https://gitlab.com/gitlab-org/gitlab/-/commit/9339d0b92dae455ad74d27cde67bc897b153eaf8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185303))

## 17.9.3 (2025-03-26)

### Fixed (2 changes)

- [Reorder runners backfill migrations](https://gitlab.com/gitlab-org/security/gitlab/-/commit/75f2ae1a6f0716fe70a8ab48fa300e7448fc02aa)
- [Update dependency gitlab-mail_room to v0.0.27](https://gitlab.com/gitlab-org/security/gitlab/-/commit/153fab2966eb8b9266bfe6625fbebee936b1ce50)

### Security (7 changes)

- [Sync organization user access when admin status changes](https://gitlab.com/gitlab-org/security/gitlab/-/commit/21b924368fccad62c8329c243e086f5fcfa824aa) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4847))
- [Prevent XSS via merge error on the merge request page](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2574af89065d099ec8148f8ac22a02739fa27f2a) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4880))
- [Inherit current_user external status while rotating project/group token](https://gitlab.com/gitlab-org/security/gitlab/-/commit/254f27669b281314fef74c3830b4a812f64708d4) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4866))
- [Add validations for the project_name of Harbor integration](https://gitlab.com/gitlab-org/security/gitlab/-/commit/eefe5150b0b9681a564757197c8ce2668088e32b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4857))
- [Sanitize returned input on asciidoc Timeout](https://gitlab.com/gitlab-org/security/gitlab/-/commit/6041ddbe1808506e5194ef89190f3e44c47badd1) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4842))
- [Add CI/CD project setting `allow_composite_identities_to_run_pipelines`](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4922213de1af01d53c68ecca81524c472fa7fa06) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4875))
- [Add limit to resource counts in tfplan merge request report](https://gitlab.com/gitlab-org/security/gitlab/-/commit/bfec8bb2981359dca26092f8ee79abe569465f4a) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4871))

## 17.9.2 (2025-03-11)

### Fixed (3 changes)

- [Fix the pipe search for zoekt exact search mode](https://gitlab.com/gitlab-org/security/gitlab/-/commit/22030051963d488575df6a2cca19e1d4e0d82a2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183373))
- [Prevent deletion of project_bot users with non-expiring access tokens](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0249d460f0f6b7f867e7a4171e0effae2e4e5135)
- [Use correct project when fetching managed resources templates](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9bac9ffcd01abff2bf0d4d38829655e394dea3b3)

### Security (8 changes)

- [Vendor GraphQL gem](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e78a52dcafa4c7316e01d4dcd35a33ab9623f532) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4841))
- [Ruby-SAML updates](https://gitlab.com/gitlab-org/security/gitlab/-/commit/780f136abbf4b27c18485e5c173aaa18acfcb644) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4828))
- [Prevent custom role to activate group members](https://gitlab.com/gitlab-org/security/gitlab/-/commit/efbd1afae3cce6bb4e03e91ed82b7af27671977f) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4833))
- [approval_rules name is unbounded](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9a4e857ea3223fe56536a81f3d1fdadb833eca8d) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4838))
- [Limit preview size](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b2ce61725c9946766a2a964377fc756d87e8234e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4821))
- [Maintainer can inject shell code in Google integration configurations that...](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7fd30226d79520b742abd9edc01055766f56c39b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4824))
- [Filter out internal notes if the recipient do not have access](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a55e5b359912daa90ef07c73ebd66b4bb9b0e2c3) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4815))
- [Mask unencoded userinfo in project mirror errors](https://gitlab.com/gitlab-org/security/gitlab/-/commit/af6f445b66c3353652c47ad36b1c700c2c0572a1) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4789))

## 17.9.1 (2025-02-26)

### Fixed (1 change)

- [Fix instance level dashboard by default severity override](https://gitlab.com/gitlab-org/security/gitlab/-/commit/56d2f940bb6e87b34e4f26ba9a298f28360dd23a) **GitLab Enterprise Edition**

### Security (4 changes)

- [Increase minimum role in SPP to read policy yaml](https://gitlab.com/gitlab-org/security/gitlab/-/commit/593c0a6f70564e9570fb16b25a37298eacf6c644) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4718))
- [Fix access to read code review analytics in private projects](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0faa526c76e3c523ff6486057c5b5b07e8e4e5d9) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4794))
- [Escape work item dropdown items and restrict HTML tags](https://gitlab.com/gitlab-org/security/gitlab/-/commit/fc777a98ebd45b30ab95bc0d94a418479d15f09c) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4788))
- [Use stricter CSP values in the packages dependency proxy](https://gitlab.com/gitlab-org/security/gitlab/-/commit/922d3ad17cf7493a10f8dbf90c0cae8d9d4b063d) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4787))

## 17.9.0 (2025-02-19)

### Added (202 changes)

- [Add GraphQL API for visualizing dedicated hosted runner compute usage](https://gitlab.com/gitlab-org/gitlab/-/commit/e10ed189e9751c952f151582bc252c6fe3facbaf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179854)) **GitLab Enterprise Edition**
- [Adds the `experiment` status for analytics dashboards](https://gitlab.com/gitlab-org/gitlab/-/commit/df3439845aa82540c67eec2d787da1727e246f7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180879)) **GitLab Enterprise Edition**
- [Allow adding comments on Wiki pages](https://gitlab.com/gitlab-org/gitlab/-/commit/962ae956d85337b4bd2b39f68ee090310018e6b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181518))
- [Add integrity verification for remote CI includes](https://gitlab.com/gitlab-org/gitlab/-/commit/5ba3eaea9ead230ac8b5e05db2aa52feed47afee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178593))
- [Set default_enabled to true for feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4527baca1d925264574ca6cbdee15c17c2567392) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181535)) **GitLab Enterprise Edition**
- [Set `default_enabled` to `true` for the feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4d09aa620d997d5c078a673b8491c363f1b97238) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181539)) **GitLab Enterprise Edition**
- [Remove maven_extract_package_model feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/73081481fc5d991f6f2b3a662d47a852156b214f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181366))
- [ActiveContext add preprocessors for references](https://gitlab.com/gitlab-org/gitlab/-/commit/d5d91112ad701855c64f1b9cfc63862fb05022dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181671))
- [Add worker to unassign security bot](https://gitlab.com/gitlab-org/gitlab/-/commit/d0c82d558321c289164d7ab25adb9a905064410c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180760)) **GitLab Enterprise Edition**
- [Introduce project.vulnerabilityArchives GraphQL field](https://gitlab.com/gitlab-org/gitlab/-/commit/28459e82005e6faa13074a0aa823852c53894bb5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181102)) **GitLab Enterprise Edition**
- [ActiveContext postgres indexer](https://gitlab.com/gitlab-org/gitlab/-/commit/8ae3016c1d25ee2be105f8fdb02c1890b3597387) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180719))
- [Add support for created_at on work_items create API](https://gitlab.com/gitlab-org/gitlab/-/commit/39079ed89c4d34f80c77436bd8a60aa55b045f18) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180903))
- [Add `Shared groups` tab to group overview](https://gitlab.com/gitlab-org/gitlab/-/commit/144b070b5c5975d6a8ce83700fdf7eeb748056f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181039))
- [Model registry: Support loading runs](https://gitlab.com/gitlab-org/gitlab/-/commit/57ffba14b4bf304308fc57f0eb1e2aeaef042333) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177136))
- [Add API endpoints for group level integrations](https://gitlab.com/gitlab-org/gitlab/-/commit/a884ebabbe7b41e2b50552673123c943a1a37654) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179694))
- [Admin Token API: Revoke Feature Flags Client token](https://gitlab.com/gitlab-org/gitlab/-/commit/23e99f5bdd2985517afb82dcad7560bec8d63a16) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181096))
- [Update flag for duo chat include file context](https://gitlab.com/gitlab-org/gitlab/-/commit/cd269a964d09827c44aa50d80f01d9e8870d943c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181305)) **GitLab Enterprise Edition**
- [Add pipeline analytics for groups on GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/226a0be9c4c8ec595b577aa4171c260d72af7a75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180579))
- [Add organization and job title to user synced attributes](https://gitlab.com/gitlab-org/gitlab/-/commit/5780048d27619f8fc59c74e4665a5f81d818ee6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175662))
- [Query evaluator for expression control](https://gitlab.com/gitlab-org/gitlab/-/commit/a56f18e9eee736b60e61d32825c52f8f3689f4aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177981)) **GitLab Enterprise Edition**
- [Add vulnerability_severity_overrides table](https://gitlab.com/gitlab-org/gitlab/-/commit/6e35bd6cc5dbaafe63083a659ab1f830dd31763e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176952)) **GitLab Enterprise Edition**
- [Display dropdown text explainer on component token](https://gitlab.com/gitlab-org/gitlab/-/commit/0db6b774e3c3a1d1472db258e761c03e80b163d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181132)) **GitLab Enterprise Edition**
- [feat: Protected packages: Maven package push protection](https://gitlab.com/gitlab-org/gitlab/-/commit/863e774de5e5cbb14abf0ee1b713e08532dd25f5) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/147055))
- [Show message when approaching Pages deployments limit](https://gitlab.com/gitlab-org/gitlab/-/commit/3ec667b154e067411adeab55d53024ae1d08c772) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181119)) **GitLab Enterprise Edition**
- [Add error tracking widget to work items](https://gitlab.com/gitlab-org/gitlab/-/commit/40be2a269d54672ad62d755dc727677ae76a04ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179719))
- [Added resources widget](https://gitlab.com/gitlab-org/gitlab/-/commit/508b5d8572aae2e046f422fddb90bacc287ed8eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174793))
- [Expose sign_in_restrictions from ApplicationSettings API](https://gitlab.com/gitlab-org/gitlab/-/commit/cfc21639522a54eadc08456e908596288942be43) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181247))
- [Add thread ID to AI completion response](https://gitlab.com/gitlab-org/gitlab/-/commit/f2d23a004c00bd0cdd596433ab46bb395aae2d07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181129)) **GitLab Enterprise Edition**
- [Add enforce_email_subaddress_restrictions application setting](https://gitlab.com/gitlab-org/gitlab/-/commit/f73c3599f23cfcd86d917cd3dff9e01af2c0b656) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180446))
- [Add support for severity overrides in pipeline security finding type](https://gitlab.com/gitlab-org/gitlab/-/commit/16d52222936a6b710336a5f169955a7b2d82c9f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180965)) **GitLab Enterprise Edition**
- [Add inject_policy_ci as default pipeline execution config strategy](https://gitlab.com/gitlab-org/gitlab/-/commit/b8dbacfaca8fa99b8c16820ca79f945028ba035f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178715)) **GitLab Enterprise Edition**
- [Add service class to trigger external control](https://gitlab.com/gitlab-org/gitlab/-/commit/916189504f2a02067a06124c512421d8f3a2fde8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180016)) **GitLab Enterprise Edition**
- [Implement revisions/:recipe_revision/:file_name endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/e8507d2207825d45595e17f9a19f02622bbf843d) by @oceane_scania ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176600))
- [Add `MALFORMED_ENTRY_OWNER` error for CODEOWNERS](https://gitlab.com/gitlab-org/gitlab/-/commit/8b3d59d5a60a99c87198e4483266bf1d5345ff79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180978)) **GitLab Enterprise Edition**
- [Reschedule backfill of vulnerabilities.detected_at](https://gitlab.com/gitlab-org/gitlab/-/commit/5853bb891dd91aa91a700d59d819b8c377f86266) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181192))
- [Add UI for subscribed filter](https://gitlab.com/gitlab-org/gitlab/-/commit/2fdefbe87845ff4ea239e57c96e149433422228b) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/136007))
- [Promote runs in standalone experiments to a model version](https://gitlab.com/gitlab-org/gitlab/-/commit/1a03c7d720859001ad67c39d91bbd649e2fc3f9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179228))
- [Add an option to specify language for file icon](https://gitlab.com/gitlab-org/gitlab/-/commit/27cedf7a09ed3f72ca178199de6a865cb34cb977) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178147))
- [Added ability to manage compliance frameworks at project level](https://gitlab.com/gitlab-org/gitlab/-/commit/289c328d971955585001bd98cd2995817fb63d5e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180103)) **GitLab Enterprise Edition**
- [Add swift to package_metadata_purl_types](https://gitlab.com/gitlab-org/gitlab/-/commit/b93db4245313e9124fa95feffcaab58d7c15643b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179539))
- [Pipeline mini graph downstream jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/8308e8c57f7f5c5a10ef475e7f457d5f52b94c6e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180464))
- [Expose lastDuoActivityOn user field in GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/b21ed8bec3f2759373364b71f0f4d1b6aba661f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179704)) **GitLab Enterprise Edition**
- [Load SoftwareLicenses names from catalogue](https://gitlab.com/gitlab-org/gitlab/-/commit/fc8c388dc89f6c2eccd1f4720d8dd3f1a6b44631) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179744)) **GitLab Enterprise Edition**
- [Add rebase button to MR widget if available](https://gitlab.com/gitlab-org/gitlab/-/commit/5c173ad53be80ad970925c3ca939f31d6e2ccac7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179906))
- [Adds root redirect feature](https://gitlab.com/gitlab-org/gitlab/-/commit/13e68cb8b4e5d3454d0ba8907adcac62d80ef920) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180352))
- [Add updatedAt ExperimentType graphql type](https://gitlab.com/gitlab-org/gitlab/-/commit/749226c85913910f03d9854f2a02481c28351fd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180789))
- [Document how to use Azure workload and managed identities](https://gitlab.com/gitlab-org/gitlab/-/commit/9e98e06cefcf376edc47f536db9c45d6d1ed6f9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180471))
- [Add missing json fields to WorkspacesAgentConfigType](https://gitlab.com/gitlab-org/gitlab/-/commit/1fdd573893efef6783ea5d7b2362c8315cb528a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180084)) **GitLab Enterprise Edition**
- [Add scim_group_uid to saml_group_links](https://gitlab.com/gitlab-org/gitlab/-/commit/96193ac9e8a1497bc0b0f226a93c6ed140c71b08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180288))
- [Add vulnerability_severity_overrides table](https://gitlab.com/gitlab-org/gitlab/-/commit/3e7c02d5ef712f639890c48653e8a641e127ae66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176952)) **GitLab Enterprise Edition**
- [Add model-level default for Vulnerability#detected_at](https://gitlab.com/gitlab-org/gitlab/-/commit/2bfab9155b623d325dfb03ac3cb8fda7f1562274) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180582)) **GitLab Enterprise Edition**
- [Browser history added](https://gitlab.com/gitlab-org/gitlab/-/commit/5317e50b07b3745e3d31720e19b94b7280b2226c) by @nraj0408 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178564))
- [Extend GraphQL dependency type](https://gitlab.com/gitlab-org/gitlab/-/commit/b37c46db2f05402dd5941c445a0241b8b69a0aa2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179062)) **GitLab Enterprise Edition**
- [Add the model record id to a replicable item in the Geo replicables list](https://gitlab.com/gitlab-org/gitlab/-/commit/7197613a81b99ffdeb89bb5fec63dd265129b971) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180713)) **GitLab Enterprise Edition**
- [Update Create Page with Default Devfile](https://gitlab.com/gitlab-org/gitlab/-/commit/3b67cd76913ddf43c0b48410a58ff581a425a255) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178554)) **GitLab Enterprise Edition**
- [Remove oauth2_device_grant_flow FF](https://gitlab.com/gitlab-org/gitlab/-/commit/090d9c7355a1bf61862de3694d4c2f37763464c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179941))
- [Add group-level pages access control setting](https://gitlab.com/gitlab-org/gitlab/-/commit/ac2862886d7a678a1f21da2e627934423b221edd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176757))
- [Add service class to trigger external control](https://gitlab.com/gitlab-org/gitlab/-/commit/abb0fe967bf6c3d289e890954c6f1fa6800e572b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180010)) **GitLab Enterprise Edition**
- [Remove async dependency export feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/d2031ca30cdba6259ff3d16d7f56f08f21510b0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180586)) **GitLab Enterprise Edition**
- [This commit adds support to delete Duo Chat threads through GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/2aa3b75f31561821bde25266c92a36d12a1e9d74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180286)) **GitLab Enterprise Edition**
- [Admin Token API: Identify Incoming Email Tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/b4191575ba438c80f7f3f0a764432a716ea0c100) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177077))
- [Add new sort option placeholders](https://gitlab.com/gitlab-org/gitlab/-/commit/eb347c4edb48578ceb3b69f1c795213a7bdc57a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180491))
- [Add clusters_managed_resources table](https://gitlab.com/gitlab-org/gitlab/-/commit/626d3c542ddc4a9c9917d427b424a9129d4b371a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177525))
- [Add support for unassigning user from an admin custom role in GraohQL](https://gitlab.com/gitlab-org/gitlab/-/commit/c54d6294d6b1358a456437a2e1c490c426ed12b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179975))
- [Remove the check_ip_address_for_email_verification FF](https://gitlab.com/gitlab-org/gitlab/-/commit/5da69994aaa49f17208fd4701ad6952ebc98da4a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180408))
- [Introduce CloudConnector::Keys model](https://gitlab.com/gitlab-org/gitlab/-/commit/ffe4c884044d57f4926a5debe4994507e1064498) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179559)) **GitLab Enterprise Edition**
- [Add parameter to toggle if email is sent on export completion](https://gitlab.com/gitlab-org/gitlab/-/commit/1142ccbb14db33ab82e1c1d4dff6291d004c46e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180065))
- [Add streaming to new audit event models](https://gitlab.com/gitlab-org/gitlab/-/commit/8adefcd95e0d123cbd80e84dee93b886f83493b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179746)) **GitLab Enterprise Edition**
- [Exempt specific files from Codeowners rules](https://gitlab.com/gitlab-org/gitlab/-/commit/80bf09e34d5098f3d7c2d3cbf21bb5203550952f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180162)) **GitLab Enterprise Edition**
- [Add popover support on milestone in WI Sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/a5f0988e8ee13108ecb743a4238dcdde39733d46) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179902))
- [Audit authorizing an OAuth application](https://gitlab.com/gitlab-org/gitlab/-/commit/d167cc1196a2e326da447f05ae0ff61d22071d8d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179187))
- [Allow read_admin_monitoring access to audit_logs](https://gitlab.com/gitlab-org/gitlab/-/commit/5643f57cdaf612d399a8d2ad15d417217ad268fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179894)) **GitLab Enterprise Edition**
- [Markdown: Select text and paste URL to create link](https://gitlab.com/gitlab-org/gitlab/-/commit/b4b4a68bbaf272c02861b80c9442b279868e49c8) by @ajuckel ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178942))
- [Prompt user to enter missing access token](https://gitlab.com/gitlab-org/gitlab/-/commit/aadc94754b88cfe47290093d948c296e90379fab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178471))
- [Adding correlation_id attribute to duo workflow message event api](https://gitlab.com/gitlab-org/gitlab/-/commit/8ab95fdce39a7cfb3d72a295c3e2a2413be56848) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179642)) **GitLab Enterprise Edition**
- [Feat(Blob): Add PlantUML render support for Blob Viewer](https://gitlab.com/gitlab-org/gitlab/-/commit/e7faf55c710462e5e8edfee38e59b591323f5a20) by @schurzi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179301))
- [Add ability to snooze to-dos until a custom time](https://gitlab.com/gitlab-org/gitlab/-/commit/547196b5992810f0dcfbcbdad83e28c7d45015fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178490))
- [Add queue_namespace as an attribute for Sidekiq routing rules](https://gitlab.com/gitlab-org/gitlab/-/commit/df657a65d9b0f6a69d851fb5074c2d4d44d2a858) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180136))
- [Enforce NOT NULL constraint on vulnerabilities.detected_at](https://gitlab.com/gitlab-org/gitlab/-/commit/6e83857ad3f0b32d6edf7b67baf7f157bd85284e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179644))
- [Admin Token API: Revoke Runner authentication token](https://gitlab.com/gitlab-org/gitlab/-/commit/af6882352654e8a3fb74680cc5e20ef830cb98e1) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179066))
- [Add indexes to web_hook_logs_daily](https://gitlab.com/gitlab-org/gitlab/-/commit/bc8f49c1002f35659dcccab9316af8a81e4eea5c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180155))
- [Add `read_admin_users` permission](https://gitlab.com/gitlab-org/gitlab/-/commit/f32d0556c5256aace13be5cf7c1bfd0bfaba9f76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177514)) **GitLab Enterprise Edition**
- [Introduce archival related entities](https://gitlab.com/gitlab-org/gitlab/-/commit/6112c120c21c17ad875a232aca7fe1314d2aec1f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179569))
- [Add a new 'Index version' to the elastic info rake task](https://gitlab.com/gitlab-org/gitlab/-/commit/4be6369d9033d165bff2648abd095e922b60a26f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179446/)) **GitLab Enterprise Edition**
- [Add license check to the fields allowedParentTypes and allowedChildTypes](https://gitlab.com/gitlab-org/gitlab/-/commit/7dfb4bdd52ea82069281a1b8f1ec6d99dd8fd0e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178863)) **GitLab Enterprise Edition**
- [Resolve MR issue with new work item](https://gitlab.com/gitlab-org/gitlab/-/commit/be4f7cb7df5fcd78b6fa636f2950ad118d39c3e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176703))
- [ActiveContext OpenSearch indexer](https://gitlab.com/gitlab-org/gitlab/-/commit/1f2fb3f07effb2a08ff178ed5b01238c9ef56eba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179662)) **GitLab Enterprise Edition**
- [Extend dashboard date range filter configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/f9bdf7f45ce982644a4e3bb822f8045bdba3937c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178999)) **GitLab Enterprise Edition**
- [Remove microsoft_azure_group_sync FF](https://gitlab.com/gitlab-org/gitlab/-/commit/48921fc8f38a8d3da5aeff0442bb950beeac4c2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179942))
- [Add `project_design_management_routes_view` database view](https://gitlab.com/gitlab-org/gitlab/-/commit/6c52398635b7ae345bc7ffdd6a16ba388597db9a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179449))
- [Add `project_routes_view` database view](https://gitlab.com/gitlab-org/gitlab/-/commit/dbb6013c0a22018fbda0adbd08f161bee01f25fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179443))
- [Add “Added from log” icon in job token allowlist UI](https://gitlab.com/gitlab-org/gitlab/-/commit/024a9f1f3e9b7558f011cdafbc55677a395d3400) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177785))
- [Add ActiveContext reference class](https://gitlab.com/gitlab-org/gitlab/-/commit/b18c45d566f9f9dc47299da9b6df071eef3394e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179362)) **GitLab Enterprise Edition**
- [Introduce a NamespaceSettingsUpdate mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/39eb31f777242fd317a60cb1a476a17930b16c33) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178328))
- [Enable ability to view IP addresses in access tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/c702d20887db4e8050af35dfeb59d07897cf8079) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179747))
- [Create work_item_user_preferences table](https://gitlab.com/gitlab-org/gitlab/-/commit/5eeed2127c1ed09460bb1ec344bf671bdd396017) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176869))
- [GraphQL: Populate `timeSeries.count` field in AnalyticsType](https://gitlab.com/gitlab-org/gitlab/-/commit/c76b632d494f9bd5cf8a07493705428be1129e1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179378))
- [Prevent unnecessary processing of AutoDevops with overriding PEP](https://gitlab.com/gitlab-org/gitlab/-/commit/3484e63a7a201a1e19dba5b3755bc303a3562dab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178581))
- [Allow SSH keys to be filtered by created at and expires at](https://gitlab.com/gitlab-org/gitlab/-/commit/8f13ba6e5e73e282ee7a04e34a4587c048d18ce0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177010))
- [Added severity override support in MR security widget](https://gitlab.com/gitlab-org/gitlab/-/commit/fc9784b8d0757ecc7727f886cd7bcf85ac6c92ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178862)) **GitLab Enterprise Edition**
- [Admin Token API: Identify GitLab sessions](https://gitlab.com/gitlab-org/gitlab/-/commit/e48740b4c37ff005f4d4838ea093517521ed6987) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178022))
- [Add Security Risk Management feature categories](https://gitlab.com/gitlab-org/gitlab/-/commit/4375b0f45d403676e4ad9687338e099fd8c12546) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179556))
- [Add external_url to compliance_requirements_control](https://gitlab.com/gitlab-org/gitlab/-/commit/ce08f6d06ef52b16bc94317f4996bdfd9ae9c4e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179256)) **GitLab Enterprise Edition**
- [Admin Token API: Add support for revocation of Cluster Agent Tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/5d772a541ab4ab2d8122e7d6174a17b3e7b692f4) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178211))
- [GraphQL: Add `timeSeries.durationStatistics` field to AnalyticsType](https://gitlab.com/gitlab-org/gitlab/-/commit/30a55af07876d9673e104d3710174f348da07972) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179006))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/c6ade453311f2cdf21092351d029fdc8f0831d38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179675))
- [Add Amazon Q role arn validation](https://gitlab.com/gitlab-org/gitlab/-/commit/e1289305102f93fe8e5567feed0a11755e70b448) by @protsivd ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176883))
- [Add read_admin_monitoring permission](https://gitlab.com/gitlab-org/gitlab/-/commit/9389c1b393661845a9aca3a0e5cc445ff83114a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179439)) **GitLab Enterprise Edition**
- [Add security findings severity override mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/6692d998f1ea68ead25ba0b3322ce7141bae3393) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178167)) **GitLab Enterprise Edition**
- [Add anti_abuse_settings column to application_settings table](https://gitlab.com/gitlab-org/gitlab/-/commit/e517c5475d7cd069757a09a22a25e8c8d0f1d905) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179596))
- [Prioritize vulnerability severity when resolving security findings](https://gitlab.com/gitlab-org/gitlab/-/commit/d4ea75f6b0576e591e54b73920515b46cf03b9c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179566)) **GitLab Enterprise Edition**
- [Backfill web_hook_logs_daily](https://gitlab.com/gitlab-org/gitlab/-/commit/26afa6c7fd59c118cfdb40fb1fa448203e8dda9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176714))
- [Enable Vulnerability Change Status modal by default](https://gitlab.com/gitlab-org/gitlab/-/commit/147651617959d746884a92d0938deb7a719626b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179346)) **GitLab Enterprise Edition**
- [Add more details for zoekt performance bar in multimatch](https://gitlab.com/gitlab-org/gitlab/-/commit/5fff92091005feabadff9f70fcd2826775de88ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178585)) **GitLab Enterprise Edition**
- [Release SAML Groups Duo Add On Assignment](https://gitlab.com/gitlab-org/gitlab/-/commit/b607682fe6cedf2b13f274c00fc83be8118ad7fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179575)) **GitLab Enterprise Edition**
- [ActiveContext indexer for elasticsearch](https://gitlab.com/gitlab-org/gitlab/-/commit/687828665b8b9ca9dd41f061f12467b499c00504) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178705)) **GitLab Enterprise Edition**
- [Add AI impact visualizations to the analytics dashboard designer](https://gitlab.com/gitlab-org/gitlab/-/commit/e20557c5803c7430e68d6f20684c1edfca964269) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179406)) **GitLab Enterprise Edition**
- [Add GraphQL fields for pipeline creation status](https://gitlab.com/gitlab-org/gitlab/-/commit/a0a443daa6f7aecd0c328fcaa2d9a8232a5b8557) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178558))
- [Allow to configure LFS link batch size via environment variable](https://gitlab.com/gitlab-org/gitlab/-/commit/1f94146a5dc045bd26abd8dd6e8384c8f61b4be7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179401))
- [Crud HAML component: Adds collapsible feature](https://gitlab.com/gitlab-org/gitlab/-/commit/cdc2fe0808f2690a8f52a44cd51bdaf37d5997fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178917))
- [Adding GraphQL mutations to trigger Allowlist Autopopulation processes](https://gitlab.com/gitlab-org/gitlab/-/commit/d85923693b43f15f3808e6bc72d2c44a5bfb1c84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177465))
- [Added update mutation for compliance requirement controls](https://gitlab.com/gitlab-org/gitlab/-/commit/0671b32c256d2a9c67b988e0f500a5ef8f307725) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178290)) **GitLab Enterprise Edition**
- [Block Seat Overage for SM](https://gitlab.com/gitlab-org/gitlab/-/commit/a3b64dcfa0002f10bffb5413a6ac43c6112cb2ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176655)) **GitLab Enterprise Edition**
- [Introduce endpoint to discover cert-based clusters](https://gitlab.com/gitlab-org/gitlab/-/commit/47309f441d5076ace208273fa1b5404afebc13fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178883))
- [Add clusters_managed_resources table](https://gitlab.com/gitlab-org/gitlab/-/commit/f2a0aa14f2d4388fb0a531ce45f03b6760324424) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178118))
- [Remove composite identity FF](https://gitlab.com/gitlab-org/gitlab/-/commit/3939f6cfbe12ea64c10f297cdab3b563e3da3a00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176977))
- [Admin Token API: Identify Feature Flags client token](https://gitlab.com/gitlab-org/gitlab/-/commit/8c52f104a381be850c7ecda66f540a8f98402854) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177431))
- [Add `raw_diff` endpoint to merge request API](https://gitlab.com/gitlab-org/gitlab/-/commit/0b917ddeab3856f35724b86110e50f99df1ce349) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178813))
- [Adds not-null migration for ComplianceViolation on target_project](https://gitlab.com/gitlab-org/gitlab/-/commit/b2d8389e9872fa4ed24a8464ff3a5e3272abef4e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173748)) **GitLab Enterprise Edition**
- [Add diff_lines endpoint to blobs controller](https://gitlab.com/gitlab-org/gitlab/-/commit/5c3299904e75137a37b48e00c8d2012b57137bb3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176274))
- [Throw error when incorrect scope is used in auditor](https://gitlab.com/gitlab-org/gitlab/-/commit/102678b9703be032c11bf8470b9eb57ec5639b2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178412)) **GitLab Enterprise Edition**
- [Add self_rotate scope for access token self rotate endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/e81424a4075c4f577bf6a18636abacb9c7be6c86) by @ajuckel ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178111))
- [Backfill archived and traversal_ids for vulnerability_statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/35210641f9eb708eb3b20828c927ae6ff9dd58ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177993))
- [Add manage protected tags custom permission](https://gitlab.com/gitlab-org/gitlab/-/commit/1bf44697e2df4796f6d6a9fe6b6e082002f2d4ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178059)) **GitLab Enterprise Edition**
- [ActiveContext processes refs from queues via cron worker](https://gitlab.com/gitlab-org/gitlab/-/commit/54a834f35fc46e2ece7688c0d5dacfdd7444cb4f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177732)) **GitLab Enterprise Edition**
- [Add cloud_connector_keys ApplicationSetting](https://gitlab.com/gitlab-org/gitlab/-/commit/ccd0fee30852d2495d8e5cf2ad6aac986811e842) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178857)) **GitLab Enterprise Edition**
- [Create AiUserMetrics table and model](https://gitlab.com/gitlab-org/gitlab/-/commit/d3085c206f130f3582eaa6b0520e1202a78a2a41) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178559)) **GitLab Enterprise Edition**
- [Expose linkType in field linkedWorkItems](https://gitlab.com/gitlab-org/gitlab/-/commit/663126084427a6eca2f869b295804c71ba95d1f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178569))
- [Use security_findings for security mr widget](https://gitlab.com/gitlab-org/gitlab/-/commit/861dcf7cda90c12b9e4c0a7fd53104b58247e8b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173949)) **GitLab Enterprise Edition**
- [Add protection rules to TagType](https://gitlab.com/gitlab-org/gitlab/-/commit/9b3842c5720bc748a767f64aeb9c651d2834cad4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177039))
- [Schedule web_hook_logs_daily indexes](https://gitlab.com/gitlab-org/gitlab/-/commit/ea98672ae62e65d55eaba035408ea17c726b69d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178413))
- [Add skip ci configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/1289cda2687208d5df9b56a6e28206986525b312) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178496)) **GitLab Enterprise Edition**
- [Changes to support group level report for severities count api](https://gitlab.com/gitlab-org/gitlab/-/commit/ea010ca8e2a39717ae846b1fc793194ecd6de314) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175913)) **GitLab Enterprise Edition**
- [Support expires_at param for group service account PAT rotation API](https://gitlab.com/gitlab-org/gitlab/-/commit/da24662ab3d9c45cadea88e9662652030bcbc2a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178608))
- [Add skip ci configuration to a policy drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/e992c73c7cb6d191d708b84f8edfb006dcfff4c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178497)) **GitLab Enterprise Edition**
- [Add instance setting to restrict private user profiles](https://gitlab.com/gitlab-org/gitlab/-/commit/1e554fccecaab8043e7917f4e3d655cda3979c11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178683)) **GitLab Enterprise Edition**
- [Add migration to enable read_compliance_dashboard in member roles](https://gitlab.com/gitlab-org/gitlab/-/commit/5b786f31332cc5eb9d78d578b3467a5596576ae0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176834))
- [Improve throttling during user record reassignment](https://gitlab.com/gitlab-org/gitlab/-/commit/e19d519b4aac0d2ed8b9b3a93a4fb6e75784d605) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175961))
- [List threads GraphQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/d6554b7ff2fdaac663b5170ca31ea1dcbf7c2d6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178268)) **GitLab Enterprise Edition**
- [Add Duo Chat usage rate to AI analytics dashboard metric table](https://gitlab.com/gitlab-org/gitlab/-/commit/b1f04b75f2e22a86b0dec9e06941767378490ad5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178622)) **GitLab Enterprise Edition**
- [Add worker architecture for scheduled PEP](https://gitlab.com/gitlab-org/gitlab/-/commit/90273ea98412565ec0976272596db620d996084e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175246))
- [Fix documentation for confidential incidents visibility](https://gitlab.com/gitlab-org/gitlab/-/commit/8cb53be2a5e4b439ed9ecd1ad0bb889d6c96c84e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178600))
- [Introduce codeSuggestionsContexts for CurrentUser](https://gitlab.com/gitlab-org/gitlab/-/commit/ea41fdb1c536f1c7cce1c4963b9f06370912732e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178402)) **GitLab Enterprise Edition**
- [GraphQL: add TagDelete mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/2595da6b07f1c560572bb51b9d9d76dee4f641ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176000))
- [Remove the `todos_snoozing` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/61007f1f42a7d22b987f8c6e771166023c5aba20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178205))
- [Use helper to update stream destinations from legacy API](https://gitlab.com/gitlab-org/gitlab/-/commit/846db30be279ba234c677fa6686ff8e5b07476f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177927)) **GitLab Enterprise Edition**
- [Expose cvss v3 in vulnerability details page](https://gitlab.com/gitlab-org/gitlab/-/commit/905b8c7ccc7e9c56fe4e06dad963a88864302171) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177071)) **GitLab Enterprise Edition**
- [Add "PATCH /groups/:id/enterprise_users/:user_id/disable_two_factor" API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/0eae379570a111e73967345bb7439c090ae7257c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177943)) **GitLab Enterprise Edition**
- [Support thread id in AiAction GraphQL mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/faafe1390e5f6dcea51394e4be8964e463a9293e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177053)) **GitLab Enterprise Edition**
- [Define sharding key for events](https://gitlab.com/gitlab-org/gitlab/-/commit/9ebccbfd61f9effd683eba842c981ad3c9611a80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177810))
- [Delete paired audit event destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/24bcc1c111e1abb2d89eb39098899f83a7933068) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175018)) **GitLab Enterprise Edition**
- [Add project topics to CI/CD Catalog](https://gitlab.com/gitlab-org/gitlab/-/commit/31a74b76e32e349600866ff681b3d90941383d1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177522))
- [Add Ci/CD job token policies static analysis](https://gitlab.com/gitlab-org/gitlab/-/commit/1b79cc3e031b305423b91344894da94e4ce2ad92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174474))
- [Adding mutation for creating compliance controls](https://gitlab.com/gitlab-org/gitlab/-/commit/039b1a25458fbff2c8047807291c8d8135946d4e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177557)) **GitLab Enterprise Edition**
- [Add AiDuoChatEvent model](https://gitlab.com/gitlab-org/gitlab/-/commit/f258d566bc8bfb576219cb8000c4edff7ca726c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177239)) **GitLab Enterprise Edition**
- [Defined event and metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/238fa7990ad7ff0d8f2f4bd694b0b1ed384c3abe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177663)) **GitLab Enterprise Edition**
- [Add last_approved_at event to VSA](https://gitlab.com/gitlab-org/gitlab/-/commit/5becf3114cfe34f9b83180ce9ded32cc62070d96) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175989))
- [Surface user.type to frontend](https://gitlab.com/gitlab-org/gitlab/-/commit/9e6ffe21b5e28a48bb9c99bf310a9104b38df744) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173343))
- [Improve UX of registering a GitLab agent](https://gitlab.com/gitlab-org/gitlab/-/commit/1944090910bdeb979966da792baccf6701de593e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177777))
- [Release DAST UI additional varibles feature](https://gitlab.com/gitlab-org/gitlab/-/commit/b88727b6f9fef1d7a883ba3cfadb3dc85bd13ddf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177703)) **GitLab Enterprise Edition**
- [Introduce write_virtual_registry scope](https://gitlab.com/gitlab-org/gitlab/-/commit/a9c6ad66a75f71de1541e0c4beabb4c03aeff770) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174496))
- [Add metrics for sep scheduled scans using time_window](https://gitlab.com/gitlab-org/gitlab/-/commit/ad6cb54f4ace2d66ccc7cf948e860e212d21a348) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176472)) **GitLab Enterprise Edition**
- [Add ability to add related item for work items](https://gitlab.com/gitlab-org/gitlab/-/commit/9393fb5dd0acc0c39a21417d1de6b6711e6edc79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178025))
- [Let ActiveContext add references to a queue](https://gitlab.com/gitlab-org/gitlab/-/commit/96a2f68a81d96b8957b9c8186a30f31d7ed086c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177232)) **GitLab Enterprise Edition**
- [Update vulnerability_statistic.archived when project is archived](https://gitlab.com/gitlab-org/gitlab/-/commit/ca3a10992082fe478f88e05450bf1625fbf5f4ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177990)) **GitLab Enterprise Edition**
- [Prepare not-null for ci_pipeline_messages.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/316cb408d16671ba65a06827fcb0156475471693) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173952))
- [Implement filtered search UI for credentials](https://gitlab.com/gitlab-org/gitlab/-/commit/6174fc9c2a5d7f6a5122bfd36f9ca14c6ba493ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176677))
- [Add Code Suggestions acceptance rate to AI usage metrics table](https://gitlab.com/gitlab-org/gitlab/-/commit/9e100fad76e1225ec1bc39c044d6824b8907131e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178063)) **GitLab Enterprise Edition**
- [Persist licenses column to support component filtering](https://gitlab.com/gitlab-org/gitlab/-/commit/cfff99a93f516acf8b31273689135e0a7ad6ff2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177297)) **GitLab Enterprise Edition**
- [Add feature flag for anthropic prompt caching](https://gitlab.com/gitlab-org/gitlab/-/commit/0b8a752d16de2d3c6e2fcd4367a734fe89f568d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177642)) **GitLab Enterprise Edition**
- [Update Report class to return new dependencies for licenses](https://gitlab.com/gitlab-org/gitlab/-/commit/c09fcb8a4b4a422ad9338472385110168b4dcfd0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177499)) **GitLab Enterprise Edition**
- [Admin Token API: Identify CI/CD Job Tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/a08cb8061ca3c0090e8c0a897203418f36c74e44) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175234))
- [Extend selective sync scope to the primary checksumming](https://gitlab.com/gitlab-org/gitlab/-/commit/f4077e068bf62a2a3056788c461dcfdf56285836) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174453)) **GitLab Enterprise Edition**
- [Add uri validation for licenses purl](https://gitlab.com/gitlab-org/gitlab/-/commit/51af1ab294bfb1e62072544a39d63afc70db0fd3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178048)) **GitLab Enterprise Edition**
- [Add `expires_at` column to `vulnerability_exports`](https://gitlab.com/gitlab-org/gitlab/-/commit/22470dafc1a3f1a648df9af09de3aa35f929b1cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178043))
- [Add `expires_at` column to `dependency_list_exports`](https://gitlab.com/gitlab-org/gitlab/-/commit/315d101e1d08e8b5fe2b36c79acfef308c7be636) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178042))
- [Add elastic client to active context gem](https://gitlab.com/gitlab-org/gitlab/-/commit/3eb2ecf09c2ada617a05ce7579188419da1eec67) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177093)) **GitLab Enterprise Edition**
- [GitLab storybook add missing features](https://gitlab.com/gitlab-org/gitlab/-/commit/8a53c4c86895574fa692f5e57b8840d26a640896) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178028))
- [Allow gem to register queues](https://gitlab.com/gitlab-org/gitlab/-/commit/45f08dd9d0231325d4b50c3cfe61c18208197669) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177086)) **GitLab Enterprise Edition**
- [Allow users to configure skip_ci behavior for scan execution policy](https://gitlab.com/gitlab-org/gitlab/-/commit/e55cd2e211a21c660485b2aa38fed932a5dcf4cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174975)) **GitLab Enterprise Edition**
- [Add "GET /groups/:id/enterprise_users/:user_id" API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/1bbd02c210c485836f06fac618308a71acc2ac50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176328)) **GitLab Enterprise Edition**
- [Remove Epics scope and replace it with work_item type epic](https://gitlab.com/gitlab-org/gitlab/-/commit/5923033037a48aec0e943a0e294e100eee0dea99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173915)) **GitLab Enterprise Edition**
- [Add vulnerability_severity_overrides table](https://gitlab.com/gitlab-org/gitlab/-/commit/6052e201a22a5a7703646627858bb407fc743bec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176952)) **GitLab Enterprise Edition**
- [Defined event and metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/03ddd6f4ad8778ed213eacbc018f9a3381fff6d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177315)) **GitLab Enterprise Edition**
- [Add traversal_ids to vulnerability_statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/5cf9d0e45242f7a015265f8542ab635c6484ca3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177591))
- [Add helper method to update legacy destination from stream destination](https://gitlab.com/gitlab-org/gitlab/-/commit/59a1c4f98b633c9a7f426e430082245ba27e1d6b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175892)) **GitLab Enterprise Edition**
- [Model Registry: Add ability to get Model Version by alias](https://gitlab.com/gitlab-org/gitlab/-/commit/89fc8baebe17ce2fb325be73e9646b9e81149d92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177715))
- [Fetch latest pipeline if no arguments are passed](https://gitlab.com/gitlab-org/gitlab/-/commit/f21c98cced9cd1d77ed613c8a83d300dfe0fc683) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172934))
- [Add /create_merge_request quickaction to work items](https://gitlab.com/gitlab-org/gitlab/-/commit/b6689979b26b6efb6ac0fa0eb6f3ea797307618e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177815))
- [Add reports identification](https://gitlab.com/gitlab-org/gitlab/-/commit/34ecaf8c1589b9555e03944c6e62ff2400d9db0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177764))
- [Run dependency scanning on uv.lock detection](https://gitlab.com/gitlab-org/gitlab/-/commit/56c2f10a0260df218c634e89a6f17370a5593529) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177637))
- [Release group credentials inventory feature](https://gitlab.com/gitlab-org/gitlab/-/commit/02765aaa84fce62deebbc78d95a43264fd596de1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177286))

### Fixed (242 changes)

- [Hide Edit button for work item metadata for Guest users](https://gitlab.com/gitlab-org/gitlab/-/commit/60a70a940b66ec9319b54b9e75ab81284008958e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180418))
- [Update net-imap gem](https://gitlab.com/gitlab-org/gitlab/-/commit/83853b3ce0f5a00859fd778ea8341b20e87c026b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181666))
- [Fix runner owner if necessary when runner assigned to a project](https://gitlab.com/gitlab-org/gitlab/-/commit/30df5eb287573c54549791d3194aebabf1759ba7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180417))
- [Fix vulnerability severify badge rendering](https://gitlab.com/gitlab-org/gitlab/-/commit/82f9dc41e51dbae899fb273fc85c7a8383ecdd3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181422)) **GitLab Enterprise Edition**
- [Fix incident layout when new issue look is turned on](https://gitlab.com/gitlab-org/gitlab/-/commit/6915eb6aa3713f3836b7121e2f2b74bddba90b47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181432))
- [Fix returning cached severity value after severity override](https://gitlab.com/gitlab-org/gitlab/-/commit/b009659d565b632cf6ab2bf297c5811ee7d6f368) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181078)) **GitLab Enterprise Edition**
- [Backfill default pages deployment limit](https://gitlab.com/gitlab-org/gitlab/-/commit/85c514c45b3f4e32349b3bdbb8579fc1a8f523ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180735))
- [Upgrade net-http-persistent gem to 4.0.2 to fix connection pool issues](https://gitlab.com/gitlab-org/gitlab/-/commit/bcd1e19c7a06956786723ddaac1a9dab7b0ab289) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181361))
- [Fix: Removing all domains does not reset primary domain](https://gitlab.com/gitlab-org/gitlab/-/commit/3ef229df51784a61d573255af21f9512bb4c99cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181150))
- [Add default value to plan deployment limits](https://gitlab.com/gitlab-org/gitlab/-/commit/249053e17e69b7fec91243a1e0c9476260a9beca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180538))
- [Render files based on the correct file sizes](https://gitlab.com/gitlab-org/gitlab/-/commit/17ed419dbb845db15b3f79034f8b625487220b01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180718))
- [Fix incorrect branch access check](https://gitlab.com/gitlab-org/gitlab/-/commit/82cf739d24cc489de8cc7d6d4b2e5a9ba468ea3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180225))
- [Fixed UX flow when when author filter dropdown opens](https://gitlab.com/gitlab-org/gitlab/-/commit/201f0d52e0237da2fb91b5b36ce745d662ce74e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180389))
- [Update getBlobSearchCountQuery variables](https://gitlab.com/gitlab-org/gitlab/-/commit/a685e3d0f90331c7490a6adc3ee2780a4206de0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181256)) **GitLab Enterprise Edition**
- [It is not necessary to set FK when moving issue under new parent](https://gitlab.com/gitlab-org/gitlab/-/commit/37dc9bb9b44ac780ac8b116ca2a75eec1c090748) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181244)) **GitLab Enterprise Edition**
- [Enforce SEP jobs when `pipeline_source` is a string](https://gitlab.com/gitlab-org/gitlab/-/commit/f1ff087c8ab29687a3bd454f1c5c417c2993901e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180977)) **GitLab Enterprise Edition**
- [Fix Ci::RunnerTagging sharding_key_id validation](https://gitlab.com/gitlab-org/gitlab/-/commit/7a1d48ed2ce01859821402ba06bb2c2927b6ea63) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181228))
- [Fix overflow issues on snippets page](https://gitlab.com/gitlab-org/gitlab/-/commit/3114caf280b0293acd3523926bb2dd3118571075) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181212))
- [Fix work item issues webhook event type and object kind](https://gitlab.com/gitlab-org/gitlab/-/commit/abebbb2372b6f2bdcea8cb339a1fb395ec65df8d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180959))
- [Add custom role preloader to projects resolver](https://gitlab.com/gitlab-org/gitlab/-/commit/c23b7647331216fd96fe93821627635f18f55cfe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179471)) **GitLab Enterprise Edition**
- [Fix CRM issue filters when contacts not sourced from root group](https://gitlab.com/gitlab-org/gitlab/-/commit/38e9186565f1ab07060fcf888256ac33b836679a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180290))
- [Add content_disposition to export downloads](https://gitlab.com/gitlab-org/gitlab/-/commit/efa9e8afe4b455acb16d5a57d86f451fe58f95e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181187)) **GitLab Enterprise Edition**
- [Strip trailing newline from rendered Kroki and PlantUML diagram source](https://gitlab.com/gitlab-org/gitlab/-/commit/23358b316db540b78c984112035fd34b163b68c8) by @puxlit ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180830))
- [Width correction](https://gitlab.com/gitlab-org/gitlab/-/commit/aa243cffc71fc0ab75087efa92cdce54d10a5152) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181140))
- [Remove `repo` if agent project is null](https://gitlab.com/gitlab-org/gitlab/-/commit/c666f122017f0f59b6862235ea3b2ff8f5307537) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181138))
- [Change Security Finding to reference project from scan](https://gitlab.com/gitlab-org/gitlab/-/commit/f5a5c721dd9472dc1ecc30bcbd6f41f7ff69e674) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180246)) **GitLab Enterprise Edition**
- [Fix overlap with description](https://gitlab.com/gitlab-org/gitlab/-/commit/164d7bdc2b259948e92eab397e4e28c7348d48fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181127))
- [Ensure issues has fixed dates](https://gitlab.com/gitlab-org/gitlab/-/commit/4d846bb333c5a45dc2d66545da4f95403af3248d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179882))
- [Make `any_merge_request` rules respect `branch_exceptions`](https://gitlab.com/gitlab-org/gitlab/-/commit/c78165cd5eccfb06346e869b811a18c8331907a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181121)) **GitLab Enterprise Edition**
- [Fix member guidelines resulting in overflow in group member view](https://gitlab.com/gitlab-org/gitlab/-/commit/e78c5e5dd1dd12ded84b1b46c0c85a27f8e28ff0) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181077))
- [Increase query limiting threshold](https://gitlab.com/gitlab-org/gitlab/-/commit/5ec65d649d8228bd363a3b1ef437ee5aff24d304) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181050))
- [Update stop environment API to use different policy](https://gitlab.com/gitlab-org/gitlab/-/commit/e06dfd496bb2fc113bf47ab2d31dadc50b134e4a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181042))
- [Clean up remote_mirror_retry_with_delay feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f95ad0f4fcbcb5997dd30135db1cb4a5c58ef0bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181016))
- [Fix linking of policy to the project](https://gitlab.com/gitlab-org/gitlab/-/commit/9f1b4be90a16318abd5afeff65494071c919baec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180615)) **GitLab Enterprise Edition**
- [Zoekt cache should invalidate if multi match chunk size changes](https://gitlab.com/gitlab-org/gitlab/-/commit/1ab722b63d5ccf3e969cdf1ff71a06d66fd35682) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180603)) **GitLab Enterprise Edition**
- [Fix broken vulnerability management save functionality](https://gitlab.com/gitlab-org/gitlab/-/commit/44c8f86c99914ad2fdc3a6f0b62bb05aceec95b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180979)) **GitLab Enterprise Edition**
- [Determine file id from hash](https://gitlab.com/gitlab-org/gitlab/-/commit/5869bcc04ab2e34fe4c62b6154998822933a749d) by @crenz ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179483))
- [Nav eval > Enable filters button](https://gitlab.com/gitlab-org/gitlab/-/commit/81fba6b66963d120752d3b7ee4a6725e4573ed54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180808))
- [Handle invalid repository names gracefully](https://gitlab.com/gitlab-org/gitlab/-/commit/1a05d7d47f51c6a4484ca461bad8ffb3b5109f07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180140))
- [Add group-level validation for audit events feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/cb09b1c52c96e1f9d84c24a69adbe739ded2a299) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180245)) **GitLab Enterprise Edition**
- [Dismiss alert upon toggling labels in Tasks by type chart in VSA](https://gitlab.com/gitlab-org/gitlab/-/commit/9bc1b0be53bbf1da81a0f0e709edccf0984d4b85) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180790)) **GitLab Enterprise Edition**
- [Support merge request variables in pipeline execution policies](https://gitlab.com/gitlab-org/gitlab/-/commit/7f717a84ab5162a36284ddfdc3ed1c61c565df16) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180945)) **GitLab Enterprise Edition**
- [Fix link rendering in GitHub integration](https://gitlab.com/gitlab-org/gitlab/-/commit/ec86a5937e20304eeb8efef5e0ba71f416970df2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180833)) **GitLab Enterprise Edition**
- [Fix AddOnPurchase API override trial attribute bug when deprovision](https://gitlab.com/gitlab-org/gitlab/-/commit/036af5fd756acba8a5c6ff3680f2ba5a88572210) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179989)) **GitLab Enterprise Edition**
- [Prevent Direct Transfer from re-enqueueing timed-out pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/d8d2eb0d6b9c4de34aa0501c7b115f3f16cdccde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179097))
- [Fix getExperiments Graphql Query](https://gitlab.com/gitlab-org/gitlab/-/commit/354973fc34402c2e40a61143c7cb78b9b7beb4d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180786))
- [Use common insertText in dropzone_input to preserve browser undo](https://gitlab.com/gitlab-org/gitlab/-/commit/232c934fff752dcfccc6af13d537da1512d65d08) by @Bubbis ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180255))
- [Fix: add name prop to instances of devops_adoption_table_cell_flag.vue](https://gitlab.com/gitlab-org/gitlab/-/commit/4c76cbaad6fbb013e5b21267d3cf5f05169a6ce7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180781))
- [Do not list pending migrations if search service unreachable](https://gitlab.com/gitlab-org/gitlab/-/commit/e2db31e58bcd175d11b9770a64b95cf2be908054) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179782)) **GitLab Enterprise Edition**
- [Do not allow assigning non-admin custom roles directly to users](https://gitlab.com/gitlab-org/gitlab/-/commit/1e2a91d337438c87e0634a49f18db284cb620a70) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180036))
- [Display download message conditionally](https://gitlab.com/gitlab-org/gitlab/-/commit/70073f093ae8b3a9b0c229c79500c4820075fb1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179872))
- [Fix issue work item spacing issue related to gutter classes](https://gitlab.com/gitlab-org/gitlab/-/commit/84315fa4292c4d2d0dc9b7e09e926d1976c447e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180444))
- [Update policy for stop environment REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/4d360debd97526343e9b73231f51475a1735878b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179955))
- [Fix console error during filter search](https://gitlab.com/gitlab-org/gitlab/-/commit/3e3871cf0c3939b40f30af010fc865c8f382edcc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180715)) **GitLab Enterprise Edition**
- [Fix remote response broadcast messages with target path](https://gitlab.com/gitlab-org/gitlab/-/commit/2a68bbbd72ca5a9b2e8d921da7d005116d43985c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180730))
- [Ensure correct header is present for work item detail](https://gitlab.com/gitlab-org/gitlab/-/commit/f43ddf9fe14017676c9561bd9f2d642844de4328) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179595))
- [Fix bug of missing groups in JobTokenAllowlist](https://gitlab.com/gitlab-org/gitlab/-/commit/77083af5168dbf0b9ccbee1cb2c3fe74270b7b3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180174))
- [Display the correct Direct Connections value in Duo admin page](https://gitlab.com/gitlab-org/gitlab/-/commit/c961b96c366156112dd94bfae75d5cd935a256ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180653)) **GitLab Enterprise Edition**
- [Add conditional operation for system note](https://gitlab.com/gitlab-org/gitlab/-/commit/bdbd6cd3ddb56e3891e928dbca5c459beb548533) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180652))
- [Exclude file upload trigger from closing drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/8df532e9399c7dfe16077bcd2da9f1bb02c8f343) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180614))
- [Send additional params to getBlobSearchCountQuery](https://gitlab.com/gitlab-org/gitlab/-/commit/77848b97386313e38c729856a98b44ec0396a2dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180584)) **GitLab Enterprise Edition**
- [Ignore database policies check for enforcing SEP](https://gitlab.com/gitlab-org/gitlab/-/commit/376afd4a9d416daf1e943ef3425f4fc0aeb61d3e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180572)) **GitLab Enterprise Edition**
- [Fix scrolling to clipped file browser items](https://gitlab.com/gitlab-org/gitlab/-/commit/b14e81b24cc5e08d75c017154f26afd475926f66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180501))
- [Fix dependency proxy with some object storage providers](https://gitlab.com/gitlab-org/gitlab/-/commit/722885885103561fc3f9ed21669cc3a8e1e4234c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180493))
- [Fix button name](https://gitlab.com/gitlab-org/gitlab/-/commit/f2f65baa33d80d2600e9810f20f53fa030c8e4d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180505))
- [Return false for pending_migrations? if indexing disabled](https://gitlab.com/gitlab-org/gitlab/-/commit/9f835ae08d0fe1b129ded874cb01d36468eb3676) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179873)) **GitLab Enterprise Edition**
- [Add aria-label to delete project modal](https://gitlab.com/gitlab-org/gitlab/-/commit/67a23dae4796fd0c0ef979becd946f05c43f221b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179904))
- [Capture enter & tab in related MR field](https://gitlab.com/gitlab-org/gitlab/-/commit/52462f83600ba15ad97682e9acf81421fc6ffef2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180069)) **GitLab Enterprise Edition**
- [Update topics path for badges](https://gitlab.com/gitlab-org/gitlab/-/commit/79df35daa739ed798bb28f65ebf0be5a25d6b5d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180439))
- [Add gitRef support for workspaces](https://gitlab.com/gitlab-org/gitlab/-/commit/b5aef619477f050e05e8a31bf7b64ee61a457f25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177680)) **GitLab Enterprise Edition**
- [Fix compare branches from the fork](https://gitlab.com/gitlab-org/gitlab/-/commit/725438556bfc2b93a119cdcc0ff31ecd391aeeb9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180377))
- [Add ids to a policy actions and rules](https://gitlab.com/gitlab-org/gitlab/-/commit/531d3772c95ebeb44fc1eab91e7cf3bd5559182b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180045)) **GitLab Enterprise Edition**
- [Persist payload attributes of code suggestion events](https://gitlab.com/gitlab-org/gitlab/-/commit/25ee8f327d081add325bd6ebe7a5022f956aa5ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179285)) **GitLab Enterprise Edition**
- [Fixes Restricted access  gitlab.com bugs](https://gitlab.com/gitlab-org/gitlab/-/commit/86a1ef6d14c2135c6ac5dcc39f6087eb9f5bacb7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180167)) **GitLab Enterprise Edition**
- [Improve error-handling when editing blobs](https://gitlab.com/gitlab-org/gitlab/-/commit/999e6f87acf97d6567285d765f3a100ed767883b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178994))
- [Fix epic creation when instance templates are set](https://gitlab.com/gitlab-org/gitlab/-/commit/51a9d63250077c5f189d8b4e904c5a6134aa1b9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179354)) **GitLab Enterprise Edition**
- [Fix Duo Chat getting slower by message increase](https://gitlab.com/gitlab-org/gitlab/-/commit/bce50800a52720cc322d08e896854813864d5e1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180157)) **GitLab Enterprise Edition**
- [Fix QueryCanceled error in PersistSecurityPoliciesWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/5848e6683ea05beb02d8da791722d7859132432b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179600)) **GitLab Enterprise Edition**
- [Fix SecurityPolicyDefault to work with mr pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/14b774ef3fc2606ed600362c128d7936a77f8c45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179614)) **GitLab Enterprise Edition**
- [Add aria-label to single file editor search input for accessible name](https://gitlab.com/gitlab-org/gitlab/-/commit/d502021f90d1cfedcd349c26aec527c1df240754) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179953))
- [Add comment to cache when submitting a comment on a work item](https://gitlab.com/gitlab-org/gitlab/-/commit/4700e414f53439e63021e20f6982609d3c02c01a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180268))
- [Improve Value Stream Analytics path navigation accessibility](https://gitlab.com/gitlab-org/gitlab/-/commit/c3f657d4fe802113161cb7ecaa166d02ed2c1f6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179110)) **GitLab Enterprise Edition**
- [Fix calculation of owner project when project runner is assigned](https://gitlab.com/gitlab-org/gitlab/-/commit/323f41d1f62523e294709183c300182de54d8613) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180264))
- [MLOps run with no metrics with step results in failed display](https://gitlab.com/gitlab-org/gitlab/-/commit/f8db332da32c570e417e1e1c836960a8dfd873f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180182))
- [Fix find file on blame page](https://gitlab.com/gitlab-org/gitlab/-/commit/895521414fdcdfa43685ffc4ce7ade171832e6fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180127))
- [Update pipeline graph](https://gitlab.com/gitlab-org/gitlab/-/commit/8a3be768ec8fa1efa32b1bc70e0fbf87ceb732cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178645))
- [Dismiss value stream created/updated success alert upon its deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/e218bee31df078c89f9bad81bc217deebb5310a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179770)) **GitLab Enterprise Edition**
- [Fix GQL Error on accessing Job Token Authentication log](https://gitlab.com/gitlab-org/gitlab/-/commit/f5fc5e8308972d365760722aa9d893269b6f4553) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178401))
- [Remove jobs_api_use_primary_to_authenticate feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/bc8add8c936aacb800a44f305d908923790da7d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179772))
- [Fix Ctrl+k command palette keyboard shortcut](https://gitlab.com/gitlab-org/gitlab/-/commit/34ebf56313da82656d958385dd3b60bcacac5714) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178451))
- [Add a way to present Epics using WorkItem new logic](https://gitlab.com/gitlab-org/gitlab/-/commit/3459be7cc8881451b1bca765954db0feede409ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178363)) **GitLab Enterprise Edition**
- [Use comma-separated IDs for skipping groups](https://gitlab.com/gitlab-org/gitlab/-/commit/3e46fe6938391839e9a173e87994b6f5515f0d3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179186))
- [Remove graphql_minimal_auth_methods FpF](https://gitlab.com/gitlab-org/gitlab/-/commit/3fcb284f6f9849bb57a9388f46295ef0a1929906) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179940))
- [Display custom permission title](https://gitlab.com/gitlab-org/gitlab/-/commit/feb64da636e12b96de7a4c67443b5790b9c8e9c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179597)) **GitLab Enterprise Edition**
- [Only check pending migrations if indexing enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/3a673a93e6ab45303b4378c93700cdf6d88fc95b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179300)) **GitLab Enterprise Edition**
- [Remove duplicated controls for narrow viewport](https://gitlab.com/gitlab-org/gitlab/-/commit/21efc44a289d4d5f82d0c587d21331f0bef27711) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179057))
- [Fix the exact code search](https://gitlab.com/gitlab-org/gitlab/-/commit/760f54ac4888e1cda8762392eb5e36914b072860) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179268)) **GitLab Enterprise Edition**
- [Fix "Edit single file" option for empty files](https://gitlab.com/gitlab-org/gitlab/-/commit/bc8e6917681da411b7cc28ac6af159b17008633a) by @sahilsarawagi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179370))
- [Redirect group searches when SSO enabled and expired](https://gitlab.com/gitlab-org/gitlab/-/commit/0f720784a9c55efaf42afebbb785a1d6fa0c738a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179104)) **GitLab Enterprise Edition**
- [Fix storing incorrect policy index in scan_result_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/77fc1e014a36df6e9507a4774ab5f7dc1d804513) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179860)) **GitLab Enterprise Edition**
- [MR actions: Fix alignment and responsive behavior](https://gitlab.com/gitlab-org/gitlab/-/commit/d572003c76781491dbdbcc683b4caa52cff7d3a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179828))
- [Include SEP jobs with overriding PEPs](https://gitlab.com/gitlab-org/gitlab/-/commit/f03326873cb7146be5ef43fe740ff5761d7ca04a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179366)) **GitLab Enterprise Edition**
- [Fix todos for user mentions in wiki page comments](https://gitlab.com/gitlab-org/gitlab/-/commit/6abf9064e91a59ad5ee0c029b469f70da648f4f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178583))
- [Add missing `hasParent` to Hierarchy widget definition](https://gitlab.com/gitlab-org/gitlab/-/commit/2949213c79e1ae6e1688823d02a1e0ff2eac0204) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178969)) **GitLab Enterprise Edition**
- [Ensure dropdown toggle has accessible text on work item create MR button](https://gitlab.com/gitlab-org/gitlab/-/commit/0f524345df92960b4e8d1ae34248a1b69907d3c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179756))
- [Decrease inline button min-height in merge conflict page](https://gitlab.com/gitlab-org/gitlab/-/commit/34ab1be28de3fef3c15d524bd60680fa3b740e8c) by @mschoenlaub ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178959))
- [Enable submit buttons](https://gitlab.com/gitlab-org/gitlab/-/commit/fca494462ff5d9a5fb1fee1d265215792aedfc88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179315)) **GitLab Enterprise Edition**
- [Fix MergeRequestsComplianceViolations not null migrations](https://gitlab.com/gitlab-org/gitlab/-/commit/8eed879311a068fb0cae5f9f3cc107c5aad454ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179567))
- [Allow user to have only 1 admin member role](https://gitlab.com/gitlab-org/gitlab/-/commit/d6de3ddd969b5162cd65bfc7a415c006f4b0664a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179528))
- [Removed coverage check learn more link](https://gitlab.com/gitlab-org/gitlab/-/commit/75404e5b7fee97a3488cd91c9d67d995bbfe1042) by @peterhdangg ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179162)) **GitLab Enterprise Edition**
- [Add a post deploment migration fixing the scim data](https://gitlab.com/gitlab-org/gitlab/-/commit/97afa60e8bc7854500ef48ded08131de13d9b244) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178326))
- [Update error message for validation errors of slugs](https://gitlab.com/gitlab-org/gitlab/-/commit/63911c2b00720f491628d3814083de3aac5f11e1) by @schurzi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179178))
- [Fix a11y issue for new todos dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/84b796a15b9c3f607c9b1cd8cd750e80e7cceca3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178737))
- [Model Registry: Fix default_experiment path](https://gitlab.com/gitlab-org/gitlab/-/commit/6d007a5a36b776d99a8809d4d38e468b1825b9e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179387))
- [Fix CI_RUNNER_TAGS regression](https://gitlab.com/gitlab-org/gitlab/-/commit/f39af4c70d1237010ccdee30b3612b938a27c002) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179671))
- [Fix API logging of JSON float/boolean param values](https://gitlab.com/gitlab-org/gitlab/-/commit/1c822c03a031bb907fed8fa5e8c924618c676ff5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179659))
- [Filter out SAML projects when SAML session has expired](https://gitlab.com/gitlab-org/gitlab/-/commit/f932a3506b2d2f37e1b71971a93f44f662c9d8fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179650)) **GitLab Enterprise Edition**
- [Filter out SAML projects when SAML session has expired](https://gitlab.com/gitlab-org/gitlab/-/commit/f8b50e46e824731a9c6b0357686026b49e31a9db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179651)) **GitLab Enterprise Edition**
- [Add alert when global search and logged out groups exist](https://gitlab.com/gitlab-org/gitlab/-/commit/87fd2d66256a6af49000577741ac3a08c19dabe8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179114)) **GitLab Enterprise Edition**
- [Filter out SAML projects when SAML session has expired](https://gitlab.com/gitlab-org/gitlab/-/commit/32f8e5f02f0cf7a22bbdd4ad551069e20d2a8f81) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179111)) **GitLab Enterprise Edition**
- [Ensure file tree table has row headers](https://gitlab.com/gitlab-org/gitlab/-/commit/d3503c72e32f2c1e756fe0a6d0e240aae3f8c770) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179123))
- [Fix commit length](https://gitlab.com/gitlab-org/gitlab/-/commit/b81d096e62410217aa467cae9414e75bfda05e12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179584))
- [Tags list: Fix alignment of actions](https://gitlab.com/gitlab-org/gitlab/-/commit/f0e0a46547ba87164966bf7bf23f881e1fe6cbdb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179357))
- [Add role to informative icons for monitor settings](https://gitlab.com/gitlab-org/gitlab/-/commit/588e89f28dd793a2a0242afd2aabd0b6caee2029) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179065))
- [Two-factor quth: Add title to QR Code SVG](https://gitlab.com/gitlab-org/gitlab/-/commit/e324552600a5da75cd35db6628f29c090288d1c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179030))
- [Add work item title and description in draft](https://gitlab.com/gitlab-org/gitlab/-/commit/f76b559e13432cb3910b1885e9208c05eb418d9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179475))
- [Fixed invalid states for custom stage fields in VSA settings form](https://gitlab.com/gitlab-org/gitlab/-/commit/2e9a48e1c74fec7056ae2bdf073c454613df3721) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178962)) **GitLab Enterprise Edition**
- [Use proper HTML semantics in shortcuts modal window](https://gitlab.com/gitlab-org/gitlab/-/commit/e68ba40da7823344d8b5d55a5c541f766aa64d6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179456))
- [Avoid hard-coding test integer](https://gitlab.com/gitlab-org/gitlab/-/commit/e35e7f95e3fedd188a07f9c4f8bdce3da7370636) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178820))
- [Only show re-request review button to users who have permission](https://gitlab.com/gitlab-org/gitlab/-/commit/86d8caf0c6d0404759f9e4b4fa251c7637562548) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179442)) **GitLab Enterprise Edition**
- [Wrap devops table help icon with `gl-button`](https://gitlab.com/gitlab-org/gitlab/-/commit/49fb985503a1cfc5fd314ecadf69f45fde479aac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178955)) **GitLab Enterprise Edition**
- [Fix loading pipeline execution policies with missing project](https://gitlab.com/gitlab-org/gitlab/-/commit/942db7605235f49ea5e83da7fd59051b19ee633b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177876)) **GitLab Enterprise Edition**
- [Fix bug with contacts autocomplete checking root group not CRM group](https://gitlab.com/gitlab-org/gitlab/-/commit/483e9b6ad3d82cd350f223ada99e980222b2e8b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179415))
- [Uses billable or nonbillable trait for  member roles](https://gitlab.com/gitlab-org/gitlab/-/commit/1cdc43bdbaa41c76abe9708c5cef2761d1fe2ce7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179400)) **GitLab Enterprise Edition**
- [Hide comment template button in work item description](https://gitlab.com/gitlab-org/gitlab/-/commit/089fc806c4d0d3e9ee889919bce411f7ccb0fd09) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178607))
- [Update to use `gl-button` instead of `gl-icon` in `visibility-icon`](https://gitlab.com/gitlab-org/gitlab/-/commit/5c8e79d601c8a3a7b1a3c8590ad17a1ca6602180) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179102)) **GitLab Enterprise Edition**
- [Remove exclude_child_pipelines_from_tag_branch_query feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/94cc6562bd9390fbb2eaaff72a4abf024580f6f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162308))
- [Fix category of collapsed issue sidebar notification button](https://gitlab.com/gitlab-org/gitlab/-/commit/a583d5b86c1c02f520a8a488d8928af162d9e331) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178907))
- [Rescue timeout errors in GeoNodeStatus metrics queries](https://gitlab.com/gitlab-org/gitlab/-/commit/76201b66b96956e90bbb4f09f477fb1c777a2776) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177100)) **GitLab Enterprise Edition**
- [Use primary DB when authenticating via job token in jobs API](https://gitlab.com/gitlab-org/gitlab/-/commit/61e5ce682e5d979d36d005663db20e81462771bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179189))
- [Skip scheduling service cache if no period is provided](https://gitlab.com/gitlab-org/gitlab/-/commit/99dea4b34308aab407a8216f84257d731fff0ddb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179259)) **GitLab Enterprise Edition**
- [Fix resource_tokens page in credentials](https://gitlab.com/gitlab-org/gitlab/-/commit/f3941e3293040803a426f4cb12d0db8c76551a57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177268)) **GitLab Enterprise Edition**
- [Fix pages multiple deployments limit for forgotten plans](https://gitlab.com/gitlab-org/gitlab/-/commit/e6313a1dac35c9c5d75c5139cdb96cd4e33cf87a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179280))
- [Take scrollbar width into account when calculating collapsed sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/c7870c67547251714c4d00ae32912554498bba8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178913))
- [Use `canUpdate` policy to control close button visibility](https://gitlab.com/gitlab-org/gitlab/-/commit/1283da06cc020728ba8f07a057a22abbf90bcb25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179113))
- [Work items design management: Fix alignment](https://gitlab.com/gitlab-org/gitlab/-/commit/10b01e7877c62bb3f787c9a1c9aeb0aca4148a81) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179245))
- [Update validations for pipeline removal](https://gitlab.com/gitlab-org/gitlab/-/commit/d52ae45616ba4c2a69039ac838deb805e9cf2061) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179241))
- [Localize type names in work item create form](https://gitlab.com/gitlab-org/gitlab/-/commit/c04746ccb148e134b9bb37c98173bdabd4d7f47e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178891))
- [Fix NoMethodError when quick action users are not set](https://gitlab.com/gitlab-org/gitlab/-/commit/9461e6e9c50336cb1b12d03b1174b6c841129985) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179208))
- [Fix routing for projects with dots in catalog](https://gitlab.com/gitlab-org/gitlab/-/commit/31c5b6f06a02c5570962a4bab92a3d6e6766232d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178420))
- [Update project settings approval widget](https://gitlab.com/gitlab-org/gitlab/-/commit/cfd0b0de1fbbf3c8ee0fefadb0ba005ed88e3014) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179161)) **GitLab Enterprise Edition**
- [Skip cyclonedx report when its type is set to](https://gitlab.com/gitlab-org/gitlab/-/commit/e487d0c107698b6ff89c8c4893d57a2448a5da00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179070)) **GitLab Enterprise Edition**
- [Ensure DevOps Reports tables have row headers](https://gitlab.com/gitlab-org/gitlab/-/commit/7efd4af79515d00adeebc47a5d578bbeb8aea5fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179126)) **GitLab Enterprise Edition**
- [Ensure admin subscripton page tables have row headers](https://gitlab.com/gitlab-org/gitlab/-/commit/9749ae55259c8bc771ecd76ee62b4443c9027884) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179116))
- [Ensure Admin users table has appropriate row headers](https://gitlab.com/gitlab-org/gitlab/-/commit/1db7b541f1761cd1baaa7efd32131abd37eafe30) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179118))
- [Ensure PAT table rows have a row header](https://gitlab.com/gitlab-org/gitlab/-/commit/17b50450c318748cf77f6b7c384c541924e9edf1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179121))
- [Add labels to color picker inputs in user preferences](https://gitlab.com/gitlab-org/gitlab/-/commit/1aa51c9d4ab40e0f7d6500dea050582378455e71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179134))
- [Ensure Kubernetes cluster table rows have row headers](https://gitlab.com/gitlab-org/gitlab/-/commit/b8bc8242dce645a4a49ed85224f58ae77656d4ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179127))
- [Ensure Job cell is the row header for Jobs table](https://gitlab.com/gitlab-org/gitlab/-/commit/a79966ace7f6aaf11a428f793d0487529d826064) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179120))
- [Ensure board move to top/bottom buttons have role](https://gitlab.com/gitlab-org/gitlab/-/commit/97f0dc0ff75b324d0238239630c9198a22a251d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179109))
- [Update to use `gl-button` for feature flag description info](https://gitlab.com/gitlab-org/gitlab/-/commit/f0ad03c6d1c15e56672f008f1a13680394ca80ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179108))
- [Fix review/draft notes using only quick actions](https://gitlab.com/gitlab-org/gitlab/-/commit/50d3453096d7b9ff3798a853ddd1f67964e94dcc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174028))
- [Fix alignment of user profile info](https://gitlab.com/gitlab-org/gitlab/-/commit/ce642707942e63e34e9500cc7cc76cddf4931fa1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178768))
- [Editor toolbar: Add role and aria-label](https://gitlab.com/gitlab-org/gitlab/-/commit/97ed86f942b66d26d42ccbc7d16b82f03b4b377d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179086))
- [Pass schedule param to execution policy pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/e24bc594a778e41c9e19897a3c97acfa4759eac2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179078)) **GitLab Enterprise Edition**
- [Verification: Add missing id for form label to work](https://gitlab.com/gitlab-org/gitlab/-/commit/2bfdbb9d563f819957a51cb272400ff5ddd4327e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179079))
- [Monitor settings: Fix a11y issue with labels](https://gitlab.com/gitlab-org/gitlab/-/commit/fcd92b637b7c6b69f79fef3772837e82727ed147) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179074))
- [Pages: Adds label to input fields on step 2](https://gitlab.com/gitlab-org/gitlab/-/commit/2b2b610c890da85c7570259f060c346bfd055389) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179064))
- [Design management (legacy): Add aria-label to checkbox](https://gitlab.com/gitlab-org/gitlab/-/commit/5a6e61aceccf862ecbf090d0d7fce70dbba1fb0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179061))
- [Project acess tokens: Fix select label for attribute value](https://gitlab.com/gitlab-org/gitlab/-/commit/fc43934a1f243811c8d15d5b60bb9637b12ae115) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179056))
- [Remove "project_templates_reporter_access" feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/8e3087647e35c1b6fcee99cba66bbeabb9e1e10c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178440))
- [Make sure badges visible for non-admins](https://gitlab.com/gitlab-org/gitlab/-/commit/3d11ac0b813b2011e8307522c26edf03c6cb13f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178615))
- [Content editor: Add missing aria-label](https://gitlab.com/gitlab-org/gitlab/-/commit/c827b0e6c425efb6b638ada70ecd4667de1984c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179013))
- [Add missing name for disclosure button on group list page](https://gitlab.com/gitlab-org/gitlab/-/commit/679183cb828b65f29464877b4f626b1c6e4a917c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179012))
- [Add missing name for disclosure button](https://gitlab.com/gitlab-org/gitlab/-/commit/980dbd41c9c46b303d07f1caeb9510dcf2e1ae3d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179009))
- [Instance overview: Fix link focus](https://gitlab.com/gitlab-org/gitlab/-/commit/85bf45195f110f7b86db35193982fb3659ad15e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179003))
- [Fix ActionView::MissingTemplate for CompareController](https://gitlab.com/gitlab-org/gitlab/-/commit/0c7a2daf5b5e17b46ab892876a2cd8e73bb11c1f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179000))
- [Commment user link: Add focus ring](https://gitlab.com/gitlab-org/gitlab/-/commit/e97970a3f48083defdfdafb8ed4f9cba2dc89ec5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178998))
- [Fix intermittent logouts even with remember me](https://gitlab.com/gitlab-org/gitlab/-/commit/7e603e1f1c361707030efbc983f26123c264b7e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178035))
- [Add missing names for buttons on policies, labels and clusters table](https://gitlab.com/gitlab-org/gitlab/-/commit/5e473df1776113475fbf7d717df7c3255f19f520) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178947))
- [Fix error for anonymous users on Projects::Ml::CandidatesController#show](https://gitlab.com/gitlab-org/gitlab/-/commit/c8386d5d25008c864cc77c87d4c320fd81a12f29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178127))
- [Finalize deduplication of issuable_resource_links](https://gitlab.com/gitlab-org/gitlab/-/commit/875082b5b5f157a748e1a34e755ffd85270f62cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173180))
- [Fix memory leak in DiffFile.vue](https://gitlab.com/gitlab-org/gitlab/-/commit/c69eee775a67f6bfdd3fb9d2aaa3a73b36fb673c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178719))
- [Upload large export files outside DB transaction](https://gitlab.com/gitlab-org/gitlab/-/commit/c5ae4fb2d8512a25076c75e204d73166f75be929) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178738)) **GitLab Enterprise Edition**
- [Fixes merge reports section in the widget not being fully hidden](https://gitlab.com/gitlab-org/gitlab/-/commit/2e0d65caf46e85c135bf9707678099fb1c6bbfd6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178704))
- [Add error handling to dependency export creation](https://gitlab.com/gitlab-org/gitlab/-/commit/cbbfccaae5bb063bcc5a696f3b4d01855a335edc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178784)) **GitLab Enterprise Edition**
- [Fixed layout issue on the invite member modal component](https://gitlab.com/gitlab-org/gitlab/-/commit/04c433bcab5a7e4e983434ff2dc01527ae7b3fed) by @zillemarco ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177866))
- [Wrap project card content on small screens](https://gitlab.com/gitlab-org/gitlab/-/commit/cece05e6a4b1a6882269b3f255c936d4f808cd4a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178772))
- [Fix projectAnalytics.aggregate.durationStatistics nil values](https://gitlab.com/gitlab-org/gitlab/-/commit/98796b1a1e88d04734fdadcac4041da31f63e8fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178623))
- [Fix 500 error when tag delete process fails](https://gitlab.com/gitlab-org/gitlab/-/commit/101a88eb94fa3abf19a42f97f8700cebedbb6e08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178305))
- [Remove useless validations for subgroup settings](https://gitlab.com/gitlab-org/gitlab/-/commit/b091d9c397ee39bff08ff264f6312115c664a5e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178724))
- [Add static analysis checks for job token policies](https://gitlab.com/gitlab-org/gitlab/-/commit/7671020a737ec7ea2f47315c151c4cd851ac886e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178731))
- [Fix DumpWriteBufferCronWorker with multiple attribute groups](https://gitlab.com/gitlab-org/gitlab/-/commit/948bf45a2f20de092899f94070acccb26d7df3a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178701)) **GitLab Enterprise Edition**
- [Fix permission issue for On-demand scans](https://gitlab.com/gitlab-org/gitlab/-/commit/407581b35997a9895c726c5c3e90e4ff792e91f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178546)) **GitLab Enterprise Edition**
- [Fix 500 error when `ciPipelineStage` query has an invalid id](https://gitlab.com/gitlab-org/gitlab/-/commit/3255d75107f3bbc69fabc6c47d3e41f70f6b5bb5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178708))
- [Add db trigger to fill wiki user mention sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/471bdaabf3fa7e61d44d10f53ab27eb1cd0c9c1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176220))
- [Fix 500 error on unauthenticated audit event](https://gitlab.com/gitlab-org/gitlab/-/commit/d560015f51a2051c97acbcca367c6afcb1dccf79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177631)) **GitLab Enterprise Edition**
- [Fix vulnerability details header alignment](https://gitlab.com/gitlab-org/gitlab/-/commit/5ecf5a8c43074ecdd2c489a82f678a6cde295a24) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178409)) **GitLab Enterprise Edition**
- [Fix Workhorse failing on 64-bit unaligned access on Raspberry Pi 32-bit](https://gitlab.com/gitlab-org/gitlab/-/commit/a01304965ae462ad33600aac4105d9858a5addd3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178476))
- [Support capitalized response for smart server reply](https://gitlab.com/gitlab-org/gitlab/-/commit/115f07789b4824688d8e8b21a8735f0a409dc75b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178443))
- [Fix nil input in causing SetGroupSecretPushProtectionService to fail](https://gitlab.com/gitlab-org/gitlab/-/commit/1027ae4430f17868ed1d278fc462bb225bcd9126) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178423)) **GitLab Enterprise Edition**
- [Ensure user external attribute is preserved and not null](https://gitlab.com/gitlab-org/gitlab/-/commit/9ed71364e017727777ed85dd6b73b5e5d8d32e1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177671))
- [Delete scan_result_policy_reads when deleting security policies](https://gitlab.com/gitlab-org/gitlab/-/commit/5cde89d6508d102898d72cd49118cb1e121ac2f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176183)) **GitLab Enterprise Edition**
- [Use `moveDesign` permission to control design reordering](https://gitlab.com/gitlab-org/gitlab/-/commit/4ce172136250cbaa767c0419750be32600756104) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176695))
- [Fix rescue statement by returning expected value](https://gitlab.com/gitlab-org/gitlab/-/commit/8e1d81a96d51cd13f4e8253ea137129b4f3b0203) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177736))
- [Fix descendant filter for security policies](https://gitlab.com/gitlab-org/gitlab/-/commit/49f21df654dc503b18f60632232688ad36d49cab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176840)) **GitLab Enterprise Edition**
- [Use naive component-based state approach for infinite list](https://gitlab.com/gitlab-org/gitlab/-/commit/0465cbbe0dd01bd394d11246032d9f10937d9587) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178309)) **GitLab Enterprise Edition**
- [Include support_bot comments in MRs to Duo Chat context](https://gitlab.com/gitlab-org/gitlab/-/commit/df7041245d088b35da2dc5d1674e1716567dc516) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178300)) **GitLab Enterprise Edition**
- [Fix weight attribute truncation on related items](https://gitlab.com/gitlab-org/gitlab/-/commit/bce0eb7f967ad2484a3831fe464867ec902dc285) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178289))
- [Fix shared agents list](https://gitlab.com/gitlab-org/gitlab/-/commit/d5c15f048fa79417ca7b3587cdbed141e9140f45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178220))
- [Fix member role preloaders when IDs are passed instead of objects](https://gitlab.com/gitlab-org/gitlab/-/commit/d809a0e6acff7065b1c48cb4dde4485b67074d6e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178260)) **GitLab Enterprise Edition**
- [Don't show incorrect median value for Overview tab of VSA](https://gitlab.com/gitlab-org/gitlab/-/commit/ccf0986782e1f34507575d8760efa29dc0846677) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177894))
- [Check for admin in remote_mirror_setting_enabled?](https://gitlab.com/gitlab-org/gitlab/-/commit/42070bf85628a37e9f18fe88c6af036662efd208) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177351)) **GitLab Enterprise Edition**
- [Fix commit tags badge link text color in dark mode](https://gitlab.com/gitlab-org/gitlab/-/commit/49aebe3a1ff1588476f70fc0b5559ed5c7f01d67) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178241))
- [Prevent guest users from locking issue discussion](https://gitlab.com/gitlab-org/gitlab/-/commit/19549b3273e56559b02afa98b7f63f0d45ec1344) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177498))
- [Fix work item parent reset error on create work item](https://gitlab.com/gitlab-org/gitlab/-/commit/a4911031f8418e9b04893d8c2bfbe929bde757fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178210))
- [Cloud Connector: Fix health check for dev use case](https://gitlab.com/gitlab-org/gitlab/-/commit/84cb865b890a703d49fe4bb921625078cbdf68e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178189)) **GitLab Enterprise Edition**
- [Redirect users not in onboarding to root_path](https://gitlab.com/gitlab-org/gitlab/-/commit/71e5567405f0d9fb9a27e4d1329f6351bf7d9943) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177926)) **GitLab Enterprise Edition**
- [Fix text color of rich text suggestion added line text](https://gitlab.com/gitlab-org/gitlab/-/commit/4f8f03971105ad3d05e07d1bbfc6b4d56c29322a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178077))
- [Remove limit of max 5 defined policies from json schema](https://gitlab.com/gitlab-org/gitlab/-/commit/2e98670af2bc0f7285e42770404252b5a434a9b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177849)) **GitLab Enterprise Edition**
- [Show diff when diff_refs.head_sha has been pruned](https://gitlab.com/gitlab-org/gitlab/-/commit/f5e992a71a1cc1e30f59444bd5923945476cd1ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178082))
- [Fix SCIM revoked identities](https://gitlab.com/gitlab-org/gitlab/-/commit/114a2889409845abf15d2b19d07468d176644d03) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177882)) **GitLab Enterprise Edition**
- [Fix console warning on work items new page](https://gitlab.com/gitlab-org/gitlab/-/commit/222b840246e11f721255aa1d3b5a5646940b853d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177985))
- [Move to-dos actions out of the main link](https://gitlab.com/gitlab-org/gitlab/-/commit/a030702d5e6d8ae2966f9564328b78add2b31706) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177906))
- [GitHub import handle requested_reviewer nil](https://gitlab.com/gitlab-org/gitlab/-/commit/2d9dc9bde00750b843c28fc814e1541460d2b7d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176929))
- [Fix console error on work item detail page](https://gitlab.com/gitlab-org/gitlab/-/commit/e4272d358a3ca4c000b42c28fcaa7316ce67ecf1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177989))
- [Use UTF-8 encoding for email notifications](https://gitlab.com/gitlab-org/gitlab/-/commit/8f3492a026c9e6bbbdba542ac4e0ab077a9ef7b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177979))
- [Show diff when diff_refs.head_sha has been pruned](https://gitlab.com/gitlab-org/gitlab/-/commit/556f98c6a0ecf6363f8e868c7971af674bc644b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177932))
- [Handle case when deployable is nil](https://gitlab.com/gitlab-org/gitlab/-/commit/a68a751a6f9076c5304a105660c3eaa7d130afa5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177862))
- [Apply all filters to flowMetricsQuery](https://gitlab.com/gitlab-org/gitlab/-/commit/0d23535ef9b32a21f012701fe1bddecd6d871b24) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173710))
- [Handle nil `#mapped_user_id` in `SourceUserMapper`](https://gitlab.com/gitlab-org/gitlab/-/commit/f60feb618c7cd230b6209c936ba377e689df2607) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167713))
- [Reset variable visibility on form reset](https://gitlab.com/gitlab-org/gitlab/-/commit/6f6dfcf13fed717c33e637a20c790276dfee3d91) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177925))
- [Fix issue template loading for templates with spaces in names](https://gitlab.com/gitlab-org/gitlab/-/commit/0a422abb7f8da911c0e3d9510c259c806ee3ee8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177819))
- [Fix merge_after moving on each edit if server timezone is not UTC](https://gitlab.com/gitlab-org/gitlab/-/commit/875e6080e7089e3ecee69a8ff562b9a842cf8f18) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177792))
- [Fix merge request list empty state](https://gitlab.com/gitlab-org/gitlab/-/commit/4717688f581d4e4ea96c06064c69e8be2b9801bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177790))
- [Resolve vulnerability modal error race condition](https://gitlab.com/gitlab-org/gitlab/-/commit/e5cd80a386b41168804e15c4f1a2d45e60901d4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177463)) **GitLab Enterprise Edition**
- [Fix error when deleting all optional variables](https://gitlab.com/gitlab-org/gitlab/-/commit/167e3fbf4f12f2751319ce1b1e77fc2ad92604cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177610)) **GitLab Enterprise Edition**
- [Render code line breaks in vulnerability](https://gitlab.com/gitlab-org/gitlab/-/commit/a1b941e99cda85f119c2d0160dac83d48b6c040b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177592)) **GitLab Enterprise Edition**
- [Fix scroll position while loading comments](https://gitlab.com/gitlab-org/gitlab/-/commit/51abef50387e258e03b17d03f1f0f9010862314b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177432))
- [Prevent guests from locking MR or assigning reviewers](https://gitlab.com/gitlab-org/gitlab/-/commit/837fc32ee2926203b9c95d026aabf1b392cb2b17) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177500))
- [Add H1 to legacy issue edit page for screen reader users](https://gitlab.com/gitlab-org/gitlab/-/commit/6e7c215d9bdb27243433c502c7d57dfa606af442) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177311))
- [Fix HAML rendering](https://gitlab.com/gitlab-org/gitlab/-/commit/d2edd404053b6242441cade901894c3be28d4bdc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174222))

### Changed (273 changes)

- [Adjust import history table row toggle](https://gitlab.com/gitlab-org/gitlab/-/commit/cdb0c96f4742e0a40c35c26590cc374b54a60503) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181324))
- [Add dropdown to load projects for multiple groups](https://gitlab.com/gitlab-org/gitlab/-/commit/4341efde8d8f3f485d0a8d003b577b8db9000b61) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179908)) **GitLab Enterprise Edition**
- [Add db migration for vscode_extension_marketplace](https://gitlab.com/gitlab-org/gitlab/-/commit/6261c4308ecadf59fa4f91b36b1def7318c9011f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181038))
- [Update the latest DS template to use the new DS analyzer](https://gitlab.com/gitlab-org/gitlab/-/commit/bb549cdcba3ad71177654dcb107c87132244ed73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181546)) **GitLab Enterprise Edition**
- [Remove mark_resolved_vulnerabilities_with_sbom_scans feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3bae81c1d43c4d7d5163589c2052c751e3662ac6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181556))
- [Apply gl-card styling to code suggestion blocks](https://gitlab.com/gitlab-org/gitlab/-/commit/336cf8f7e193b3924fe73d1b2f7fd5ce7ef08bcb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180032))
- [Move Add to tree control](https://gitlab.com/gitlab-org/gitlab/-/commit/d3cf7b34544d74e8bf25d99dd7a7fa3d5db4e548) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180951))
- [Improve accessibility for project and commit views](https://gitlab.com/gitlab-org/gitlab/-/commit/5e8351225e39788128f75adee48b4d9dd81a1eba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181287))
- [Pass interface and client information to AI Gateway](https://gitlab.com/gitlab-org/gitlab/-/commit/8b6277e4376b9565607a791371f38570eb8abade) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181351)) **GitLab Enterprise Edition**
- [Fix 500 error on IP restrictions when checking snippets](https://gitlab.com/gitlab-org/gitlab/-/commit/5ad5acc6cc64eead987a113d20265ca1f033caaf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180331)) **GitLab Enterprise Edition**
- [Update the CI templates for DS to use the new DS analyzer](https://gitlab.com/gitlab-org/gitlab/-/commit/b929fca32a1664abd50982bed666f9e816950081) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178065)) **GitLab Enterprise Edition**
- [Change new github project error message](https://gitlab.com/gitlab-org/gitlab/-/commit/4505a22a99cbc982e72d0d5e0a3e36ee1ba3dca7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180398)) **GitLab Enterprise Edition**
- [Migrate model experiments listing page to graphql](https://gitlab.com/gitlab-org/gitlab/-/commit/57fb55a1c6ec83c52fb854b173fd5d60a5baeff7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179227))
- [Improve invalid owners detection in CODEOWNERS](https://gitlab.com/gitlab-org/gitlab/-/commit/3232479ca81628d0b47c4a269516056d7207e329) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180936)) **GitLab Enterprise Edition**
- [Link custom software license to software license policies](https://gitlab.com/gitlab-org/gitlab/-/commit/2d76c9f19f4d98a388f1439d0413ae79f0026d14) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180958)) **GitLab Enterprise Edition**
- [Admin Token API: Revoke Incoming Email Tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/20b24a6b20c1efe70ef4d422facdc00916f313f6) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180763))
- [Call MarkAsResolvedService after an SBOM security scan](https://gitlab.com/gitlab-org/gitlab/-/commit/84f7e9b86d27ac44559a3dc88d8e79175c103ef7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179119)) **GitLab Enterprise Edition**
- [Show a visual when the environment is in the stopping state](https://gitlab.com/gitlab-org/gitlab/-/commit/2bea53abb3e7d23e8498dd48d377d96cd67d27b8) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179981))
- [Consider user permissions when validating Code Owners](https://gitlab.com/gitlab-org/gitlab/-/commit/cb8de9cab36618b63717d354d2e37379ace939a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179310)) **GitLab Enterprise Edition**
- [Add v2 approval rule table and model](https://gitlab.com/gitlab-org/gitlab/-/commit/ff11799500d08e8973f30cc1631747db6c85d11b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179839)) **GitLab Enterprise Edition**
- [Document inject_policy strategy for pipeline execution policies](https://gitlab.com/gitlab-org/gitlab/-/commit/b6df56a570ce5b9eb4bcb8f12721883dc84c6d37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180753))
- [Fix Pages CI Variables](https://gitlab.com/gitlab-org/gitlab/-/commit/7a921eed857f485162cd6963524c18c09a6541ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180697)) **GitLab Enterprise Edition**
- [Cloud Connector: Expose keys from database](https://gitlab.com/gitlab-org/gitlab/-/commit/ae993b45782688be5a1c7936caa3013ff33fb91d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180385)) **GitLab Enterprise Edition**
- [Prevent user from downloading empty CSV](https://gitlab.com/gitlab-org/gitlab/-/commit/f13ab0d87ebf9e40bcb7453547c6d97ed6122d9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178750))
- [Zoekt: Rollout the zoekt_reemit_events FF](https://gitlab.com/gitlab-org/gitlab/-/commit/83ba2346fa9bbf78443172a9f73363ad7802e5d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181236)) **GitLab Enterprise Edition**
- [Remove unnecessary codes](https://gitlab.com/gitlab-org/gitlab/-/commit/517c561f0d96265fe70aad4857329c0cadb863ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181235)) **GitLab Enterprise Edition**
- [Remove loose_foreign_keys_for_polymorphic_associations FF](https://gitlab.com/gitlab-org/gitlab/-/commit/2fcaa2f0ef87b9e4f037abc42012a5891b8b39f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181230)) **GitLab Enterprise Edition**
- [Removed feature flag search_mr_filter_source_branch](https://gitlab.com/gitlab-org/gitlab/-/commit/63085168dc34ddd2f7cb8e724882a5fce98ce37a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180254)) **GitLab Enterprise Edition**
- [Change label ID field type to Types::GlobalIDType[::Label]](https://gitlab.com/gitlab-org/gitlab/-/commit/58f9bf93f8a05212089952ec746c97125d4650e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180861))
- [Update squash options update mutation to support all branches rules](https://gitlab.com/gitlab-org/gitlab/-/commit/d032aa51232ea99473a39e618b67abe631f78cab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181197))
- [Remove claude_3_5_sonnet_20241022_for_code_gen feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/bb1c6002aa72b324611cd4c9fd8f4fb082a1c42e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181171))
- [Update links to full docs URLs to skip index](https://gitlab.com/gitlab-org/gitlab/-/commit/52ddf2df64cc7581fa8a512ca2c96e64135b079b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180890))
- [Update comment to be mandatory in bulk severity override mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/7940c4755222436ac92e381a7575d251a0f192f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180856)) **GitLab Enterprise Edition**
- [Update links to full docs URLs to skip index](https://gitlab.com/gitlab-org/gitlab/-/commit/8b443ae2b89990b015616a5715ede5ff2fc73ef6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180877))
- [Add import history table destination formatter](https://gitlab.com/gitlab-org/gitlab/-/commit/9fa2503be6091a70b6758b18c323a6f2deac6c11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181139))
- [Documentation changes for rename prsd to spp](https://gitlab.com/gitlab-org/gitlab/-/commit/900367780a0937cc867bd0495e4b00623114997c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179768))
- [Add import history table row and header container components](https://gitlab.com/gitlab-org/gitlab/-/commit/10c21c32bfb29140ba566300e4f7c4a2f3ea61d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181133))
- [Rename index files in application security docs](https://gitlab.com/gitlab-org/gitlab/-/commit/38ad6c3c83f6fe0ae5effda4705a80cea0a9be4f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180670))
- [Allow shortcuts to remove markdown](https://gitlab.com/gitlab-org/gitlab/-/commit/56a5da78b1e8a9d5d289bf8dbcba33190decbfd4) by @Bubbis ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178466))
- [Import group: Migrate components used](https://gitlab.com/gitlab-org/gitlab/-/commit/860d84886f5d409dcc451eaa43f8455f2a16ebf4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180376))
- [Import groups by direct transfer: Cleanup interface](https://gitlab.com/gitlab-org/gitlab/-/commit/5fa416018ba93d7fc1b322c3a46287c396046a63) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180534))
- [Use work item epic-issue adapter by default](https://gitlab.com/gitlab-org/gitlab/-/commit/18b013c0e78f38919145837ea1cac6748d44253c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179457)) **GitLab Enterprise Edition**
- [Automatically update subsequent ordered lines in plain markdown editor](https://gitlab.com/gitlab-org/gitlab/-/commit/840b52b736faf3d2057ce735d43a0a75ac5ebca7) by @Bubbis ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179924))
- [Disallow project runners from being unassigned from owner](https://gitlab.com/gitlab-org/gitlab/-/commit/7e12e9e35cc733f19219766b1f74593fbcced459) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180368))
- [Update links to full docs URLs to skip index](https://gitlab.com/gitlab-org/gitlab/-/commit/794d4d9acb46c5fc0e6bc822339f3fea9bb4da21) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180891))
- [Improve error messages for custom stage fields in VSA settings form](https://gitlab.com/gitlab-org/gitlab/-/commit/e06abb354bb3fe08b3e3af186e4ff79e4baf242c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180628)) **GitLab Enterprise Edition**
- [Change user ID field type to Types::GlobalIDType[::User]](https://gitlab.com/gitlab-org/gitlab/-/commit/09ef044849ab1b23292f9342f21c665df1e37b0b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180901))
- [Add an explanation why the CI variable value cannot be masked](https://gitlab.com/gitlab-org/gitlab/-/commit/1e5f1c32c0df6886828bdaab70fe6192f7862fb1) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180778))
- [Change repository controls into a dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/1fef76663f6fbeb3b7dbfb29c9434d6b50894bc4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179713))
- [Update error message for `needs` CI keyword](https://gitlab.com/gitlab-org/gitlab/-/commit/efafa546b5c3d30d67207dbc523e7bb696bb1088) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180411))
- [Move the troubleshoot button to a sticky footer](https://gitlab.com/gitlab-org/gitlab/-/commit/274323e5558ddbb6e1883c53785113ba1226e93e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179599))
- [Handle ghost users consistently](https://gitlab.com/gitlab-org/gitlab/-/commit/b4a2a3e4cd473e041a87d0de04cc20f32ef42b59) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179829))
- [Update sort labels to be consistent across groups and projects](https://gitlab.com/gitlab-org/gitlab/-/commit/96a6229dfe0fe860cfb0dc69b69a0288d057e855) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180971))
- [Store recently delete billable members to ease the sync up](https://gitlab.com/gitlab-org/gitlab/-/commit/6aedb357a5c9c5d7f4503023d6819ee1fe8d998e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179497)) **GitLab Enterprise Edition**
- [Cleanup left over cross-db suppressions](https://gitlab.com/gitlab-org/gitlab/-/commit/9400bef33e7a70fda7912415da62dd234a705336) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180156)) **GitLab Enterprise Edition**
- [Default-enable security policy project deletion prevention](https://gitlab.com/gitlab-org/gitlab/-/commit/acf2eda151ecc2440a89949068aff2e05cdaaa7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180919)) **GitLab Enterprise Edition**
- [Update links to full docs URLs to skip index](https://gitlab.com/gitlab-org/gitlab/-/commit/fbbd7ddb1ba1121ffbe6ebd9a20e9a492c5c19de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180872))
- [Rename index files for user/group clusters and contribution_analytics](https://gitlab.com/gitlab-org/gitlab/-/commit/c233d986b6ad614addd286880964c2d5592266df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180862))
- [Update CI_JOB_TOKEN JWT payload](https://gitlab.com/gitlab-org/gitlab/-/commit/7ff6775c4a8e75a2e82d1c71fb698e65c4cb99cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179710))
- [Add the ability to download compliance frameworks](https://gitlab.com/gitlab-org/gitlab/-/commit/5f1d1eeb548779a4c30e0512b8591c52e52c5762) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179588)) **GitLab Enterprise Edition**
- [Add GET /projects/:id/remote_mirrors/:mirror_id/public_key API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/b2e4e6ed8aba5cfd4daca37f66fc0630222cf43e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180291))
- [Enhance resilience of single relation import Sidekiq worker](https://gitlab.com/gitlab-org/gitlab/-/commit/c60a86b76da83ff94ea925dcb19299dd7189867a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180780))
- [Do not drill props to BlobButtonGroup](https://gitlab.com/gitlab-org/gitlab/-/commit/c5af509ef855a555c498795de49d4ddafd30503f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180228)) **GitLab Enterprise Edition**
- [Rename index files for Hugo migration](https://gitlab.com/gitlab-org/gitlab/-/commit/eb4ebf62e45b7032f2ca3cc781f0e94a24dc1bc7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180702))
- [Remove codeowner_role_approvers ff](https://gitlab.com/gitlab-org/gitlab/-/commit/5a184e9cab71b9718bd6ccde720bc793fc70baeb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180213)) **GitLab Enterprise Edition**
- [Advanced search: Cleanup sections](https://gitlab.com/gitlab-org/gitlab/-/commit/be83f3f4bb5eeb958ab81371b4bfda2bc9012312) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180528))
- [Zoekt: Update dot_com_rollout task](https://gitlab.com/gitlab-org/gitlab/-/commit/60badd1dabce96f76f3a8c6c888f29bb56b3c966) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180250)) **GitLab Enterprise Edition**
- [Rename index.md to _index.md for compatibility with docs-gitlab-com](https://gitlab.com/gitlab-org/gitlab/-/commit/2fbc794ac4b80280259083d17bff7a2ab44626af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180660))
- [Rename index.md to _index.md for compatibility with docs-gitlab-com](https://gitlab.com/gitlab-org/gitlab/-/commit/97ee7b1468c4efc6e3179bc1ed674cb1030195df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180656))
- [Rename index.md to _index.md for compatibility with docs-gitlab-com](https://gitlab.com/gitlab-org/gitlab/-/commit/67be33ed902a1b2bfcbff95ee900cd465b45967c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180636))
- [Restructures code coverage doc and incorporates test coverage viz doc](https://gitlab.com/gitlab-org/gitlab/-/commit/011ef1ecb20dab2361aed524fb79e97a1403636d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179914))
- [Rename index.md to _index.md for compatibility with docs-gitlab-com](https://gitlab.com/gitlab-org/gitlab/-/commit/54e5990d20fcd2f1794213957825bc6f0ae31887) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180633))
- [Rename from index.md to _index.md](https://gitlab.com/gitlab-org/gitlab/-/commit/3dac072e0ca276cc1140cffb4a14a0f64a4d9fbc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180591))
- [Update pages service](https://gitlab.com/gitlab-org/gitlab/-/commit/3d308fff32ac822da8a44ad2a54dc582d9e74052) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172950))
- [Update create pipeline mutation to use GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/dbee4e48eda3f5746bdcf2ed4aa9cdcb879ea332) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176728))
- [Add ComplianceFrameworksController for JSON export](https://gitlab.com/gitlab-org/gitlab/-/commit/61d2316255c27bb528552964cadb9a924a6693c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178817)) **GitLab Enterprise Edition**
- [Change UX flow of license exclude packages](https://gitlab.com/gitlab-org/gitlab/-/commit/29ada8d32f4f89eb4de812e792218dd60caa69f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180466)) **GitLab Enterprise Edition**
- [Include AllBranchesRules in non-EE branch rules responses](https://gitlab.com/gitlab-org/gitlab/-/commit/b5a86ce83fa7db401eaf7bd4dbdb46739b90ff51) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176815))
- [Remove $registryClass from replicableTypeUpdate mutation in Geo](https://gitlab.com/gitlab-org/gitlab/-/commit/e3c4ef64dfce174dabf7f3fd5368e4b654d95eed) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180635)) **GitLab Enterprise Edition**
- [Create downstream_pipeline_dropdown.vue](https://gitlab.com/gitlab-org/gitlab/-/commit/1a0ffa67bf38c1e924aa814a36b20f15d7bc64e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180277))
- [Add `cronjob_child` tag to Sidekiq cronjob workers](https://gitlab.com/gitlab-org/gitlab/-/commit/3639ca35760294f2bcbad0fa6e7a9ef6be88ec35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180595))
- [Add v2 approval rule table and model](https://gitlab.com/gitlab-org/gitlab/-/commit/96b1539ac6107076ee52980ac2f8d4d7a2330abb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179839)) **GitLab Enterprise Edition**
- [Remove fully rolled-out feature flag for Duo Chat conciseness](https://gitlab.com/gitlab-org/gitlab/-/commit/ba07a9681036dee959b796b6af4d98e54d743cc8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179910)) **GitLab Enterprise Edition**
- [Check root namespace for ci_jwt_groups_direct feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/1e0c8792b388dc9d8a7e97459e3cfe0e5bf056a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180588))
- [Set traversal_ids on vulnerability stat insert](https://gitlab.com/gitlab-org/gitlab/-/commit/3f8da50cd8f7fe0664a8a0947abb06d548ee2a83) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180343)) **GitLab Enterprise Edition**
- [Add more spacing to super-sidebar toggle button](https://gitlab.com/gitlab-org/gitlab/-/commit/c4621410ec633e8c60885164376125443c424f5a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180214))
- [Rename index.md to _index.md for compatibility with docs-gitlab-com](https://gitlab.com/gitlab-org/gitlab/-/commit/619b57d6eb323e9ead10b899a6c2ee837c858235) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180507))
- [Include users from custom roles as MR approvers](https://gitlab.com/gitlab-org/gitlab/-/commit/079feaf0edfce2c08aca2dd4238e5c6472ed736c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176698)) **GitLab Enterprise Edition**
- [Import status: Update component](https://gitlab.com/gitlab-org/gitlab/-/commit/d2b3e933a7b65158b335dcf5a53c2687c4f0e09d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180544))
- [Rename variable and environments index files](https://gitlab.com/gitlab-org/gitlab/-/commit/9ed0a4aa06ab2c5893414cd57055b0fcb1b5f44a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180510))
- [Remove without_archived_projects](https://gitlab.com/gitlab-org/gitlab/-/commit/738d71de0bbb789527037a37f063da00bdcbcb09) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179215)) **GitLab Enterprise Edition**
- [Rename CI YAML index file](https://gitlab.com/gitlab-org/gitlab/-/commit/49252fd68acee80049f32501f1bb79d30789fd92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180508))
- [Reflow work item buttons](https://gitlab.com/gitlab-org/gitlab/-/commit/8e47f923233534225fd4145d507d1e74b05620f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180486))
- [Cleanup pages_multiple_versions_setting feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/9a49142e6efc04704c09dc2109c87f985c0e880c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179678))
- [Remove cross-DB modification](https://gitlab.com/gitlab-org/gitlab/-/commit/b9c7c3cdc6496a0e7c08fad67b7b3bb50a134c54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179578)) **GitLab Enterprise Edition**
- [Expose squash options for all branches rules in free plan](https://gitlab.com/gitlab-org/gitlab/-/commit/9504920e53c7017b10e052b585d23e1583cbaa50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179248))
- [Topic badge tooltip enhancement](https://gitlab.com/gitlab-org/gitlab/-/commit/fd0523b2732c3b8d4a52e04d807b1e5f997dce91) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180442))
- [Ingest all licenses for components with at least one known license](https://gitlab.com/gitlab-org/gitlab/-/commit/7c8bade68600978bc78278081f0764aeef837776) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179373)) **GitLab Enterprise Edition**
- [Make project visibility icon keyboard focusable](https://gitlab.com/gitlab-org/gitlab/-/commit/6681acbbe2b88df6dd5e73735be4bdbeacf37f8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179099))
- [Model Experiments: Sort data descending](https://gitlab.com/gitlab-org/gitlab/-/commit/f669f1a1697a9c6638b68f0df9a9c4004b4fa103) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180219))
- [Visibility settings: Migrate to GlCard](https://gitlab.com/gitlab-org/gitlab/-/commit/de457211bac9841f963b860465a005f637f27126) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180168))
- [Remove callback for adding user to default organization](https://gitlab.com/gitlab-org/gitlab/-/commit/f0c081dec9b4cf9a36a95508ed36a26c081f4565) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175288))
- [Permanently enables duplicate exceptions for packages](https://gitlab.com/gitlab-org/gitlab/-/commit/8a2aca920d5d63c9fdc3f8aa67e5245d00ea2a09) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178828))
- [Admin Token API: Reset OAuth Application Secrets](https://gitlab.com/gitlab-org/gitlab/-/commit/6e4b9bb9bec1bf6d9f495f435b268c1bc1fa351a) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179035))
- [Remove feature-flag drop_lease_usage_project_recalculate_workers](https://gitlab.com/gitlab-org/gitlab/-/commit/15dd6082e96c318dfc33696bc401ce3fea137397) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179956))
- [Cleanup bigint conversion for geo_event_log.geo_event_id](https://gitlab.com/gitlab-org/gitlab/-/commit/1436e59b4e28de3251fb9420e32c05cd21c8fa9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180270))
- [Update text for license rule](https://gitlab.com/gitlab-org/gitlab/-/commit/25f841529e9e0a2db1acfe566ca20601d598743c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180298)) **GitLab Enterprise Edition**
- [Commit: Update page header to use PageHeading component](https://gitlab.com/gitlab-org/gitlab/-/commit/431f5c04379bbd74aac081c59f94b09760bd3321) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179843))
- [Add import history to your work nav bar](https://gitlab.com/gitlab-org/gitlab/-/commit/6a2b9bee919e0aa56968f5ccc771294a0cc2c604) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179752))
- [Fix duplicate emails sent for PrAT and GrAT expiring tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/7b5cfb0a0d985bf0911890ece03daf776158a11f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179774))
- [Enable FF by default for project dependency page](https://gitlab.com/gitlab-org/gitlab/-/commit/97fe90f0d76ad7cff66c2ea409e70c1e09676d4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180208))
- [Improve UI text for syntax theme selection](https://gitlab.com/gitlab-org/gitlab/-/commit/5c812d26c0299bae424df83656934b504db3bf8a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179316))
- [Move publish to pages.publish](https://gitlab.com/gitlab-org/gitlab/-/commit/e238b973efcd4c821e9e53869e4b68fc356fee55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178425))
- [Add discernible text to project notifications button](https://gitlab.com/gitlab-org/gitlab/-/commit/73104ef9dda7d199e4f1e6e3af9c5853609e0093) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179088))
- [Use background status warning on matched text](https://gitlab.com/gitlab-org/gitlab/-/commit/a422a79dd8112fd559ae22233c16a3fceac4fdfb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178551))
- [Improve seat controls copy](https://gitlab.com/gitlab-org/gitlab/-/commit/f8456f59de921d453bf27b2f0a3adca70094bf48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179341)) **GitLab Enterprise Edition**
- [Split microsoft_applications tables](https://gitlab.com/gitlab-org/gitlab/-/commit/c14c6677d9c79728fefcf4b8852070c97a8a5df5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177531)) **GitLab Enterprise Edition**
- [Improve to-do items' styling](https://gitlab.com/gitlab-org/gitlab/-/commit/2213208a98e1fc5e7e2c941dd8a0dd8b94f884d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179865))
- [Always allow pipeline variables in ondemand_dast_validation pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/4c44be2a1d3457d57f4d8a6f42c6451d1cc15c60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179903))
- [Increase fileSize threshold for Highlight.js](https://gitlab.com/gitlab-org/gitlab/-/commit/dd783497e650d3c1eee08f2665492e52fd89edc4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179687))
- [Add in-product announcement for legacy IDE removal](https://gitlab.com/gitlab-org/gitlab/-/commit/ae4259a13dc78ae4f591f288841621de4fa062d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179239))
- [Update gitlab-glfm-markdown and prometheus-client-mmap gems](https://gitlab.com/gitlab-org/gitlab/-/commit/8323a4ab49421030e921b2f65281eb03349609df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179987))
- [Update import page header](https://gitlab.com/gitlab-org/gitlab/-/commit/5f4f7c8f1abdb51cdcc595184c73c8cb67fc155f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178329))
- [Change group SPP feature category to security_testing_configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/51808306d0cf2786b0d8ca3a026421eb77c8cbd8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179800)) **GitLab Enterprise Edition**
- [Add table creator to plain markdown editor](https://gitlab.com/gitlab-org/gitlab/-/commit/411ed41ba97387b51d49dd996344b01b5023c2d6) by @Bubbis ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179150))
- [Load linked to SPP groups](https://gitlab.com/gitlab-org/gitlab/-/commit/9a96403384c04b7b6dcda5a5fa02fa7d12cd4ff4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176899)) **GitLab Enterprise Edition**
- [Remove feature-flag drop_lease_usage_authorized_projects_worker](https://gitlab.com/gitlab-org/gitlab/-/commit/ee9ded971cadb9269be7e07a1a91f080276bc8a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179957))
- [Add partially disabled mode](https://gitlab.com/gitlab-org/gitlab/-/commit/d6daad196893a5331743d34752b4cec77178c1f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179576)) **GitLab Enterprise Edition**
- [Refactor limit check](https://gitlab.com/gitlab-org/gitlab/-/commit/2ea8714a2b9157b6db96719090b5e42804a63aa8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179943))
- [Update breadcrumbs to match tabs and view in the Geo replication](https://gitlab.com/gitlab-org/gitlab/-/commit/094febba8a130c5956edc18954d3b755e6a3cd57) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179535)) **GitLab Enterprise Edition**
- [Truncate the project description when it is long in the CI/CD Catalog](https://gitlab.com/gitlab-org/gitlab/-/commit/2a960511fa6c68bdaf9801fe49d3f176f280017d) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179919))
- [Add ordering when updating used storage bytes for zoekt indices](https://gitlab.com/gitlab-org/gitlab/-/commit/24e39810f158f3fbe70aa06bf56ae26c083b563d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179589)) **GitLab Enterprise Edition**
- [Add number formatting to ci minutes limit banner](https://gitlab.com/gitlab-org/gitlab/-/commit/5cc5994a4be39a9562b32c875e92fb4629e99547) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178736)) **GitLab Enterprise Edition**
- [Add sast tooltip and download link](https://gitlab.com/gitlab-org/gitlab/-/commit/133da063848431b465e6aa26533d3c4d4d5219c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179587))
- [Allow MarkAsResolvedService to scope by report type](https://gitlab.com/gitlab-org/gitlab/-/commit/43f5960c0ffbcad3281ebac1e7374983664b7134) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179117)) **GitLab Enterprise Edition**
- [Update re2 to v2.15.0](https://gitlab.com/gitlab-org/gitlab/-/commit/f2ecf1dc9babfaa44d27846a3fe334bded2c70f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177830))
- [Make file tree and modified icon focusable](https://gitlab.com/gitlab-org/gitlab/-/commit/83147e205945f3a91d96c66ab1a4226c429196dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179125))
- [Rename seat controls section to singular](https://gitlab.com/gitlab-org/gitlab/-/commit/011daf9a0ec4ff662eae311e209f2ecee96d895e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179821)) **GitLab Enterprise Edition**
- [Rename Sign-up restrictions settings section](https://gitlab.com/gitlab-org/gitlab/-/commit/d6b27dbcbe55e8cbced28bcb619cedf3970518b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179806)) **GitLab Enterprise Edition**
- [Restrict tag rule ops  when Gitlab API is not supported](https://gitlab.com/gitlab-org/gitlab/-/commit/cca1e6f0a357f281772fb4bcd5c4865cd2d2c566) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178403))
- [Add project_id to DescriptionTemplates & split singular/bulk fields](https://gitlab.com/gitlab-org/gitlab/-/commit/88e566b2302b524f8c270614a67c040a743f81f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178968)) **GitLab Enterprise Edition**
- [Runner Authentication Tokens: Explain how a token can be resetted](https://gitlab.com/gitlab-org/gitlab/-/commit/68f9f89eda000b71f168f082b5329b3714dd409e) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179568))
- [Sync security policies when protected branch is modified](https://gitlab.com/gitlab-org/gitlab/-/commit/baa80b19ada0713f53ac8e309bb16176364d4c5c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172447)) **GitLab Enterprise Edition**
- [Add linked groups resolver](https://gitlab.com/gitlab-org/gitlab/-/commit/9e86e857c5c885615a54a62745fa8df0df1c1db9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176670)) **GitLab Enterprise Edition**
- [Resolve cross-join in security project statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/e216cf5b19d187d079682687ba7cdd2979615a00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178886)) **GitLab Enterprise Edition**
- [Update notification to Admin](https://gitlab.com/gitlab-org/gitlab/-/commit/2787651b9d8ec653d851c8cd8fdaa483db674c29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178135)) **GitLab Enterprise Edition**
- [Pipeline wizard placeholder use design tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/3159309971d08a5813282f315b5eb993363c9e9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179683))
- [Migrate authored todos to GhostUser](https://gitlab.com/gitlab-org/gitlab/-/commit/aa50e780315cccd9f161950b27f93b37de23f195) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179359))
- [Add discernible text to merge request overview activity sorting button](https://gitlab.com/gitlab-org/gitlab/-/commit/75bae30f1dc949835e03ca8bcda5c9a674929819) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179080))
- [Set vuln stat traversal_ids when setting pipeline](https://gitlab.com/gitlab-org/gitlab/-/commit/5c18882dc6f5796905975c403847eb35fcdc7d6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179663)) **GitLab Enterprise Edition**
- [Restrict creation of new rules if over maximum](https://gitlab.com/gitlab-org/gitlab/-/commit/66022d3d0e04b12548e3fc449eccd637402730c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178996))
- [Allow option to do multi node search on zoekt proxy](https://gitlab.com/gitlab-org/gitlab/-/commit/e283f8dc44801de6313792a9e3e1a181bd893937) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171867)) **GitLab Enterprise Edition**
- [Add partially disabled mode](https://gitlab.com/gitlab-org/gitlab/-/commit/a548e1d70447d29a8ede2bc35a68d3b85c0e95e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179312)) **GitLab Enterprise Edition**
- [Remove feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e250af6a857eddc16c04353ab4cd03d8203dc54f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178643)) **GitLab Enterprise Edition**
- [Papercuts 17.9](https://gitlab.com/gitlab-org/gitlab/-/commit/6b615d3a0d937b66f7b564cd687ad28c894de58b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178934))
- [Enhance CI/CD variable drawer UI with popovers for help content](https://gitlab.com/gitlab-org/gitlab/-/commit/7d02e593eb57110c7e0943daf1f207dcfb000096) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179531))
- [Enable specifying a semantic element for the CRUD component container](https://gitlab.com/gitlab-org/gitlab/-/commit/2fa74ffb9619bced6a949cd4ca3f5df40cc8731b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179072))
- [Return ids of created vulnerabilities with SBOM scanning](https://gitlab.com/gitlab-org/gitlab/-/commit/e279a1f8b0c53d6042ee2b8da45e35e661d2323f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179115)) **GitLab Enterprise Edition**
- [Add protected tag to the container registry](https://gitlab.com/gitlab-org/gitlab/-/commit/bbe6002d9fe79922bc36c3e526f2018d2aa8ebe4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179130))
- [Do not update target entities if todos change](https://gitlab.com/gitlab-org/gitlab/-/commit/10f68bba4f12ccc129d0e41af77fd2d50a923216) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179421))
- [Refactored non-billable check for Gitlab.com BSO](https://gitlab.com/gitlab-org/gitlab/-/commit/fcdf66930362ee1f3f7b71996dce5cd2c3447e87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179392)) **GitLab Enterprise Edition**
- [Reduce layout shifts in usage quotas > pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/8f93c9c6ed0319eda268ad04068b0afe968010eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178274)) **GitLab Enterprise Edition**
- [Integration: Item changes](https://gitlab.com/gitlab-org/gitlab/-/commit/cef357c32e2cdd6dcea082622e4ae0a052a1c8c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178155))
- [Single/Multiple choice component: Update selected and disabled](https://gitlab.com/gitlab-org/gitlab/-/commit/c0c5f54bdaca627985f77d880b4102ba39deb68d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179356))
- [Remove cross-join from namespace historical statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/7f71f082a03f41fd1b87646e63a8bd80f2a6a69d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178899)) **GitLab Enterprise Edition**
- [Fix some RSpec/BeEmpty offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/db5d60c9fa58ef3032ada69f5b6a100c46b08d31) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179355))
- [Use small text for description.](https://gitlab.com/gitlab-org/gitlab/-/commit/f0576eaadeb832d3bc21079023c0775b63adcea1) by @nomad_blaze ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179166))
- [Remove feature flag after globally enbaling](https://gitlab.com/gitlab-org/gitlab/-/commit/d8ac2e35ace131bdf620400bc5ca4547bb1db0ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178748)) **GitLab Enterprise Edition**
- [Update software license policies with custom licenses](https://gitlab.com/gitlab-org/gitlab/-/commit/16f859c9217d3742efdca2b12eccc8f9b16b734d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172406)) **GitLab Enterprise Edition**
- [Show commit SHA in target column of AuditEvents table](https://gitlab.com/gitlab-org/gitlab/-/commit/925d525e518e6f5491098441431b6b095ce3ccaa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175229)) **GitLab Enterprise Edition**
- [Admin Token API: Clarify historic prefixes are only excluded for PATs](https://gitlab.com/gitlab-org/gitlab/-/commit/8ab3749fece8c6341d474494c6c317f056b6d608) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179075))
- [Elaticsearch issue query boost iid by 50](https://gitlab.com/gitlab-org/gitlab/-/commit/9f956a664831cb50ffa79ae8a4c6fa9c5561c9a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179205)) **GitLab Enterprise Edition**
- [Validate not-null and update sharding key for ci_pipeline_messages](https://gitlab.com/gitlab-org/gitlab/-/commit/871d49f698be95c50a7ae646947ab362c92ad4cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178397))
- [Compliance framework dropdown order change & style update](https://gitlab.com/gitlab-org/gitlab/-/commit/82684c85088158fa9a3028ad979802749e9fc24f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179192)) **GitLab Enterprise Edition**
- [Finalize backfilling epic work item data](https://gitlab.com/gitlab-org/gitlab/-/commit/77186da82599ee2f9cdbc144682a8e8c1bf159f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177734))
- [Allow null access levels on rule creation](https://gitlab.com/gitlab-org/gitlab/-/commit/f83db7383cd91442c17b00b8ff05ea1764812744) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179176))
- [Execute pipelines for PEP project schedules](https://gitlab.com/gitlab-org/gitlab/-/commit/6b45bc4310e20b2cbaa3e6a85deb9b840af0d134) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176427)) **GitLab Enterprise Edition**
- [Work item note activity buttons enabled while loading](https://gitlab.com/gitlab-org/gitlab/-/commit/986fe3dccd4fa672d0baecbdba5e7d1a3c4b35e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178006))
- [Show timeago tooltip on tab](https://gitlab.com/gitlab-org/gitlab/-/commit/ac6f39d9f25b3ef51f56cda52fd9d32ab5e53920) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179105))
- [Add discernible text to network/repository graph search button](https://gitlab.com/gitlab-org/gitlab/-/commit/9efbb580a4c0d4b23fd3aebeb4e14cd4d734d55d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179055))
- [Add label to feature flag instance ID regeneration input](https://gitlab.com/gitlab-org/gitlab/-/commit/45495de42b6f08530d706fc655b4e368f0bab095) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179087))
- [Create and trigger the an event to update the](https://gitlab.com/gitlab-org/gitlab/-/commit/d3ecdaab0c07c47ebb7c057c578937fcc9002f41) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178456)) **GitLab Enterprise Edition**
- [Remove branch_names_sorting feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/a0568da1a4ac74540d4bf91694c6a5bc1d507f87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178930))
- [Specify username and password required](https://gitlab.com/gitlab-org/gitlab/-/commit/1ca91064941859b678653e7aba6e80be7470de8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179071))
- [Update dependency @gitlab/web-ide to ^0.0.1-dev-20250110172049](https://gitlab.com/gitlab-org/gitlab/-/commit/e4737b60741600ff4e19b5f71665906b2198b607) by @gitlab-dependency-update-bot ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177778))
- [Update traversal_ids for vulnerability statistic](https://gitlab.com/gitlab-org/gitlab/-/commit/001425af112c9c7d57f251e13b32bce5b6539fb3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178989)) **GitLab Enterprise Edition**
- [Only log elasticsearch metrics if the cluster is red](https://gitlab.com/gitlab-org/gitlab/-/commit/3db51e9ee9c516dfc6c470442ba8796a44937164) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178830)) **GitLab Enterprise Edition**
- [Release create NuGet packages on the fly feature](https://gitlab.com/gitlab-org/gitlab/-/commit/89800fbff272f77bd87bb37312b45671c2751c1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177868))
- [Allow `max_artifact_size` to be changed via the REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/ba543cede3416ec32aadf81c5c0ba7ea742e8ada) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178343))
- [Integrations detail page: Migrations and small visual fixes](https://gitlab.com/gitlab-org/gitlab/-/commit/7caa2a849c1847177e1cd2b0bbd981c67a65a7c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178141))
- [Clean up duo_chat_storage_postgresql feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/4bc93ba4d086fe23287f0cfb18a7b1d0d42964ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178985)) **GitLab Enterprise Edition**
- [fix: Move call to `AiRelatedSettingsChangedEvent`](https://gitlab.com/gitlab-org/gitlab/-/commit/be7dd579a02145148a45177fe00a37d96c3c8a71) by @yashikajotwani12 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178015)) **GitLab Enterprise Edition**
- [Make new header app default](https://gitlab.com/gitlab-org/gitlab/-/commit/f6524fdd92ad5f6780c47619ff83451ef7532b93) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176182))
- [Clean up PATs::ExpiringWorker extended logging](https://gitlab.com/gitlab-org/gitlab/-/commit/00f537820d5b6bce9a247dc6c9728e2739f9b048) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178918))
- [Clean up `rewrite_history_ui` flag](https://gitlab.com/gitlab-org/gitlab/-/commit/8fa34d7df6f796a5bca25abbef7de69082c26a69) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178746))
- [Add class level config for simple zoekt scheduling service tasks](https://gitlab.com/gitlab-org/gitlab/-/commit/6f70909303f32dbda6531c3921cc2772d2a5819b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178606)) **GitLab Enterprise Edition**
- [Allow access fields on Protection::TagRule to be null](https://gitlab.com/gitlab-org/gitlab/-/commit/9b50aa04af2a406da4dd84161a9a3712fc5a1d05) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178294))
- [Remove move_ai_tracking_to_instrumentation_layer feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/024aa1591ca793a598cdc445212601b5bef252f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176060))
- [Only claim human users as enterprise](https://gitlab.com/gitlab-org/gitlab/-/commit/1f70379bc5353f9f463ecdea9208d1e22e3c614d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178707)) **GitLab Enterprise Edition**
- [Update skip ci payload](https://gitlab.com/gitlab-org/gitlab/-/commit/f8936bf2a6f4f84adf05df98e3fb693074134ad5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178758)) **GitLab Enterprise Edition**
- [Improve heading hierarchy and accessibility on group import](https://gitlab.com/gitlab-org/gitlab/-/commit/77900b8c87a9e3683074d9de21f0d6112af51171) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178850))
- [Replace '.' character on organization path](https://gitlab.com/gitlab-org/gitlab/-/commit/7cc5261a6e01628c9792a30df292f013506d396f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176942))
- [Update SPDX to 3.26.0](https://gitlab.com/gitlab-org/gitlab/-/commit/1cb95e2b8f439ff2cea29a61d85a01b0a21420f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178747))
- [Show only folder name and a link to the folder in the environments list](https://gitlab.com/gitlab-org/gitlab/-/commit/6cee7a8a61f69c2afaab23421b0f5f6c24ada905) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178383))
- [Fix counter and remove first/last pages from applications](https://gitlab.com/gitlab-org/gitlab/-/commit/e48fc7cdbf3d2d0b5453e8b780b313217183ac3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178001))
- [Process repo_to_delete worker in a single batch](https://gitlab.com/gitlab-org/gitlab/-/commit/eed152dcdf7ebeb005a3fcb6be162bc0c60f3493) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177336)) **GitLab Enterprise Edition**
- [Resolve cross-joins from InstanceSecurityDashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/7435dd779418dfd1dcb896cbe25562e822079ca0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178422)) **GitLab Enterprise Edition**
- [Expand publish variables for pages deployment](https://gitlab.com/gitlab-org/gitlab/-/commit/31dde2b6f36abbd2ddbf4f8fd65f58e013459006) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176228))
- [Prevent creation of placeholder users for deleted users](https://gitlab.com/gitlab-org/gitlab/-/commit/64418acf386713ee42dcd80909f3ac4ae2bdab94) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177804))
- [Remove delete_inactive_project_bot_users FF](https://gitlab.com/gitlab-org/gitlab/-/commit/6dd16aa0bdb65169c4dc48059e140712e0a514d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178541))
- [Align deletion action between groups and projects in the settings page](https://gitlab.com/gitlab-org/gitlab/-/commit/a31c670604af833ccbae4110d6d6101f5cb326a6) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175873)) **GitLab Enterprise Edition**
- [Clean up duo_chat_storage_postgresql feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/e787c9b6a8e07ab27ee99390cfd205cabba70092) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178671)) **GitLab Enterprise Edition**
- [Update streaming filters docs links](https://gitlab.com/gitlab-org/gitlab/-/commit/c849b6b0240757405bb28719ce1258a61d0bd203) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178660)) **GitLab Enterprise Edition**
- [Add setup_for_company to onboarding status json](https://gitlab.com/gitlab-org/gitlab/-/commit/0fc8ade000f67e57aa7ab7210d7921cd225db94b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178655))
- [Show "delete model" and "version" links only with permission](https://gitlab.com/gitlab-org/gitlab/-/commit/85e3aa2e19c28f47bc28b9161f4f1576eec72677) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178161))
- [Add sast/dast identification on job](https://gitlab.com/gitlab-org/gitlab/-/commit/1eb05b445cfb495f034c7641a11f3b64ee33f9f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177924))
- [Remove retain_resource_access_token_user_after_revoke FF](https://gitlab.com/gitlab-org/gitlab/-/commit/80585cd90bf408e03754e4baef8a0ee049ccb66a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178587))
- [Remove policies check from pipeline tooling](https://gitlab.com/gitlab-org/gitlab/-/commit/bf8bb81136b2b203097e11de0066abffdc8f3465) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178612))
- [Add secret_token for compliance requirement controls](https://gitlab.com/gitlab-org/gitlab/-/commit/39260bb79457f5f001445e2119dc88849814cdda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178204)) **GitLab Enterprise Edition**
- [Hide "promote run" button when no permission exists](https://gitlab.com/gitlab-org/gitlab/-/commit/102e83ff3e9152ba30099f0ba70aa7b14d6dd64a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178400))
- [Extend DescriptionTemplate type to include category](https://gitlab.com/gitlab-org/gitlab/-/commit/5f94b1c8ff61b322ef701948601fa2a77e282533) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178340))
- [Add notes to mention permissions related to a DAST scan](https://gitlab.com/gitlab-org/gitlab/-/commit/ea911b3ab97698299402b5fe40b5e242e7e570d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178272)) **GitLab Enterprise Edition**
- [Add pending status for req. controls](https://gitlab.com/gitlab-org/gitlab/-/commit/ec958af6cdc47735f03bd3070215e0d033c85434) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178601)) **GitLab Enterprise Edition**
- [Remove search_mr_filter_author feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/a46a4e06faf26b03b43db37e0ea0210b525a86ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178418)) **GitLab Enterprise Edition**
- [Update license exceptions format](https://gitlab.com/gitlab-org/gitlab/-/commit/c1c32f2c964a8b47afe085b9804325c39666ecc8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178586)) **GitLab Enterprise Edition**
- [Remove enable_inactive_tokens_deletion_cron_worker FF](https://gitlab.com/gitlab-org/gitlab/-/commit/873b4572d3ab9df5db6deef806a8ac6e2414c9c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178548))
- [Fix jira api required field](https://gitlab.com/gitlab-org/gitlab/-/commit/a4d153e908a97d5ca7ac4023af2c9dbcff5d8cf1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178501))
- [Refactor where actions appear in the accessibility MR widget](https://gitlab.com/gitlab-org/gitlab/-/commit/ad3dd2e09eb185eb15f203d463fb471a4f499c4c) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178009))
- [Increase spacing between to-do link and actions](https://gitlab.com/gitlab-org/gitlab/-/commit/e3fa439c8486fb0a8d0e8c3248819063f370fc1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178469))
- [Hide "Delete experiment" for model experiment without permission](https://gitlab.com/gitlab-org/gitlab/-/commit/05cdd0ad6bd7ebc88bda38d23701f89c9a147f78) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178160))
- [Added ability to close the board modal with esc or background click](https://gitlab.com/gitlab-org/gitlab/-/commit/8ed48a58d373c44eaef3329f8b7053d28462648c) by @zillemarco ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177917))
- [Remove deprecated and disabled SAST jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/ac9163e7495bf9e97ee4fff3e47c7eef0d4668a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178093))
- [Bump nokogiri to v1.18](https://gitlab.com/gitlab-org/gitlab/-/commit/21767d759eee1bdd6b41cc0cd98283e302edd332) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177832))
- [Refactor scheduling service to use dispatch helper](https://gitlab.com/gitlab-org/gitlab/-/commit/20e9d30fe5a0e993a43d202fbe9ca3c82edcac2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178068)) **GitLab Enterprise Edition**
- [Update error message when password validation fails](https://gitlab.com/gitlab-org/gitlab/-/commit/9e218cb5eadce64dbe027819ee78326519b7d43c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178212)) **GitLab Enterprise Edition**
- [Remove cross-join from .grades_for with instance](https://gitlab.com/gitlab-org/gitlab/-/commit/eac5c394df278311f181d7ca4c191919c5790cb2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175602)) **GitLab Enterprise Edition**
- [Add new workspace_variables query API](https://gitlab.com/gitlab-org/gitlab/-/commit/68e5df4ce0ac7560b43df6fffe5ca15a70806ed9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176617)) **GitLab Enterprise Edition**
- [Return all validation errors when manual vulnerability creation fails](https://gitlab.com/gitlab-org/gitlab/-/commit/17e1fe4512a1493be6d433363467a946f4b8f7a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178321)) **GitLab Enterprise Edition**
- [Remove unused prop](https://gitlab.com/gitlab-org/gitlab/-/commit/4a7e36f410cc0a9466167b94dc76e7c92deddebe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175016))
- [Get group grades using vulnerability statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/a645327bd838f9ae5bb2c63ee396af69d875d071) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178024)) **GitLab Enterprise Edition**
- [Remove alert_message_faq from storage banners](https://gitlab.com/gitlab-org/gitlab/-/commit/a47d2a61ca95aa5119f4c07cdce7c0ae930c7936) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177548)) **GitLab Enterprise Edition**
- [Save the LDAP tab pressed in cookie](https://gitlab.com/gitlab-org/gitlab/-/commit/449e4329fe2f660aaec1d35cd421c3b6ea99a36b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178285))
- [Change registry protection rule admin text to Adminstrator](https://gitlab.com/gitlab-org/gitlab/-/commit/59039cb4f4b9f7281a703f2ac29bcb709fee7059) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177822))
- [Update spacing](https://gitlab.com/gitlab-org/gitlab/-/commit/7da90ebc36611dcde05db21466d3ee781f569e82) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177598))
- [Enable the highlighting and memoization of admin tabs](https://gitlab.com/gitlab-org/gitlab/-/commit/1afe3eb9faaf0f7d068492a54e2c20c8f81d8b19) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178227))
- [Update dependency auto-deploy-image to v2.118.0](https://gitlab.com/gitlab-org/gitlab/-/commit/6084fb4b6b4bf994dc0eecb305d7010e1230d278) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176171))
- [LicenseScanning Report refactoring](https://gitlab.com/gitlab-org/gitlab/-/commit/bc064752a7938f8ea54054007c83a24eb97274df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178236)) **GitLab Enterprise Edition**
- [Update pre-populated branch name when user can push to branch](https://gitlab.com/gitlab-org/gitlab/-/commit/f36ba81ab3ab83f80e0827a6751cffe52568b9ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177626))
- [Warn user if iteration has confidential issues they can't access](https://gitlab.com/gitlab-org/gitlab/-/commit/e02799bc74a642c5e11882cb9a8664b552b832fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177324)) **GitLab Enterprise Edition**
- [Replace paginator for keyset paginator admin applications](https://gitlab.com/gitlab-org/gitlab/-/commit/4480b38758533ee86872f536a2d4d812bcf6fe0c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178216))
- [Use page heading component in feature flags list view](https://gitlab.com/gitlab-org/gitlab/-/commit/1741fa717525979723f45e7c060c4f292c7aa15f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177606))
- [Model Registry: Rename candidate to run](https://gitlab.com/gitlab-org/gitlab/-/commit/c6ec750f706472d4e9e5d58414f67a4b7f7c9b2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178158))
- [Show agent version warnings from KAS](https://gitlab.com/gitlab-org/gitlab/-/commit/538d4f63763e401c19b3372c89b34de588a5d327) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175419))
- [Add separate tabs for project and shared agents](https://gitlab.com/gitlab-org/gitlab/-/commit/d367829d1a98b40bb1b6855941d2f13f9d05e9d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177776)) **GitLab Enterprise Edition**
- [Topics subpage: Cleanup and layout refinements](https://gitlab.com/gitlab-org/gitlab/-/commit/efc40d523b19e28b93af7ae7d997f4e037f7e622) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177735))
- [Add index to import_source_user_placeholder_references](https://gitlab.com/gitlab-org/gitlab/-/commit/a19d12399ebd716d8b30f8abd5369bd5da301437) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177908))
- [Set traversal_ids upon vuln statistics ingestion](https://gitlab.com/gitlab-org/gitlab/-/commit/58e79bd253cfe2617963562bee117b80a2e7b06d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178125)) **GitLab Enterprise Edition**
- [Move conan v1 search endpoint to conan shared endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/7491d190e84e98a474dd341866b634df85530b5e) by @oceane_scania ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177226))
- [Get group grades using vulnerability statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/06a459c696b129930da7bf0843a14ade7eb0b6c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177892)) **GitLab Enterprise Edition**
- [Support multiple oidc providers](https://gitlab.com/gitlab-org/gitlab/-/commit/96592394aac78974b53072c42dcc81d3f0806fdc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/138734)) **GitLab Enterprise Edition**
- [Process repo_to_index event with one batch at a time](https://gitlab.com/gitlab-org/gitlab/-/commit/67c1050899ebe1af8a49101dc35eff3dab890e3e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177337)) **GitLab Enterprise Edition**
- [Use page heading component in compliance center dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/0bd4f92a03a5a23e43183c101b9e2b745bfa1245) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177611)) **GitLab Enterprise Edition**
- [Replace VulnerabilitiesFinder with VulnerabilityReadsFinder](https://gitlab.com/gitlab-org/gitlab/-/commit/be1f80f0cb6062443d8c79453b3ebaf64d1fd3f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175947)) **GitLab Enterprise Edition**
- [Generalize relationship quick action copy](https://gitlab.com/gitlab-org/gitlab/-/commit/04ddcc20b3e2d130f089709e1c2d2ecd3a45d166) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177506))
- [Move full page tooltip to right](https://gitlab.com/gitlab-org/gitlab/-/commit/5278fc367f4c151ca1417c0d532a45f3026ba868) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177893))
- [Drop ipaddr as a dependency](https://gitlab.com/gitlab-org/gitlab/-/commit/c686572c634887d56b4fbe184ed5ca7fbb5f931c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177833))
- [Expose linked work item state on LinkedItemType](https://gitlab.com/gitlab-org/gitlab/-/commit/044545504eb79a71eb9e24a2c9cd44a731f3d106) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176449))
- [Move Seat Control to licensed feature](https://gitlab.com/gitlab-org/gitlab/-/commit/2d40d3354c03d374497912251012bc1cf63ae5da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177379)) **GitLab Enterprise Edition**
- [Add an icon to the bypassed reviews event in the MR timeline](https://gitlab.com/gitlab-org/gitlab/-/commit/005c78dc41ec6b497cd18d46a96958ea2b2c3f8e) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177675))
- [Change checkbox placement in Artifacts stacked view](https://gitlab.com/gitlab-org/gitlab/-/commit/0390aa87e42568e468c5ba9ac69780634176b2e8) by @Deepak18-06 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164674))
- [Remove job token auth feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4ef775a78dc64305987ec24f657df50f2d34db45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177796))
- [Unhide container repository protection rules API](https://gitlab.com/gitlab-org/gitlab/-/commit/9410666adc4dea3843e6f1c5a9adb8fab6246866) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177673))
- [Switch from delete_all to destroy_all for user add-on assignments](https://gitlab.com/gitlab-org/gitlab/-/commit/8454058ef90a9fd9e7250d79e15a119e70d2319f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177421)) **GitLab Enterprise Edition**

### Deprecated (5 changes)

- [Add deprecation announcements for DS build support and Gemnasium](https://gitlab.com/gitlab-org/gitlab/-/commit/6f47693b764200bb1e859cb965bee9427b11bead) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178084))
- [Geo GraphQL API: Deprecate keyword arg](https://gitlab.com/gitlab-org/gitlab/-/commit/08353244cd5218dbb453eb521bd945158e531ab6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180479)) **GitLab Enterprise Edition**
- [Fix deprecated field name](https://gitlab.com/gitlab-org/gitlab/-/commit/5bbb9b65c9ad7a73d73a88dd85cc2a0aa1150b6b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180181))
- [Redirect page visit on group projects page to the group overview](https://gitlab.com/gitlab-org/gitlab/-/commit/18f61d737d8e5f74efd5309403210cb58c6c2202) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179339))
- [Ignore confidence columns on Vulnerability model](https://gitlab.com/gitlab-org/gitlab/-/commit/517e0b69180edd7e2db985b6b38ee11798e6900b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169303)) **GitLab Enterprise Edition**

### Removed (24 changes)

- [Remove rake task to enable or disable work item epics](https://gitlab.com/gitlab-org/gitlab/-/commit/cddde54fef5a5b792b22f942730d1288565e3a5b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181641)) **GitLab Enterprise Edition**
- [Ignoring expression and type column from requirement](https://gitlab.com/gitlab-org/gitlab/-/commit/9da46e715aa37934639a417c4face156a573bf4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180549)) **GitLab Enterprise Edition**
- [Remove availableFromAccessLevel field](https://gitlab.com/gitlab-org/gitlab/-/commit/f85416708c4b520c109dc26d7eaaccaaedc7134f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181014)) **GitLab Enterprise Edition**
- [Remove buildForecast graphQL endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/e9686da31ae79747287f6a7c1a8762d8281b9850) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180932)) **GitLab Enterprise Edition**
- [Remove All tab from To-Do dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/0315ffeeb10a57b63ab83d1e4bce15716916bbb9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180589))
- [Removed feature flag by_pass_two_factor_for_current_session](https://gitlab.com/gitlab-org/gitlab/-/commit/669684f3bfbe765a99c80a5bec4cc8a3853e5323) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180968))
- [Remove richText from bloblSearch graphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/136ca3261f8adb8bb4125fc778c6e9f5ebc6f0a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180631)) **GitLab Enterprise Edition**
- [Remove epic_metrics table, models and associated references](https://gitlab.com/gitlab-org/gitlab/-/commit/35969dd2061ba03f983bfca23ae4bb538eebf2dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179477))
- [Remove web_ide_settings_context_hash feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/db6e46b374dcbcf1bdb8da4f294de3d20d368701) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180261))
- [Remove scan_execution_pipeline_concurrency_control ff](https://gitlab.com/gitlab-org/gitlab/-/commit/a789f0667984cb673f0a316a48dbaac80107ec71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180271))
- [Remove temporary indicies from packages_dependencies table](https://gitlab.com/gitlab-org/gitlab/-/commit/a2ab3d2934dbc512d4858df0b3507c0cca626221) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180068))
- [Revert "Merge branch 'autoflow/basic-workitems-events' into 'master'"](https://gitlab.com/gitlab-org/gitlab/-/commit/86932b640d5b66016fdd15a48bfabd84cf0de0f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179738))
- [Add post-deploy migration to drop unused column](https://gitlab.com/gitlab-org/gitlab/-/commit/a953059e6d1b315711ac315ba32acce3dfb9499d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179672))
- [Remove function-based namespace lookups](https://gitlab.com/gitlab-org/gitlab/-/commit/e2b24e2e22b9ca305c5394d0ed3b5b81ffefb03d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179582))
- [Ignore sep max_concurrency application setting](https://gitlab.com/gitlab-org/gitlab/-/commit/b6b93d1b7a6dfef41ade5087989c3c6a7398a0a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178926)) **GitLab Enterprise Edition**
- [Removed the ignore rule for dropped column](https://gitlab.com/gitlab-org/gitlab/-/commit/b6c24134e6027be0ff8a76bb1625c8577e7d1cda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178634)) **GitLab Enterprise Edition**
- [Remove todos_vue_application feature flag and all inactive code](https://gitlab.com/gitlab-org/gitlab/-/commit/693fdd971c102dbea090265330fc48b79c8463b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175863))
- [Remove `index_vulnerabilities_on_detected_at_and_id` synchronously](https://gitlab.com/gitlab-org/gitlab/-/commit/eafdd7f3a291b56b9d4d339d3db9e27262878d06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178444))
- [Remove license_scanning_with_sbom_licenses feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e86dfe29cafdabdc07ef379ea82ab2c5281a0dcb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172437))
- [Remove sep scheduled scans application settings unused view](https://gitlab.com/gitlab-org/gitlab/-/commit/41059c39126eb43c8178f44b7c99d8179b1ad6c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177502)) **GitLab Enterprise Edition**
- [Remove hybrid search](https://gitlab.com/gitlab-org/gitlab/-/commit/4427c4367181f3c87da434006cf08ddbfd1ad045) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178151)) **GitLab Enterprise Edition**
- [Drop advanced_scopes from personal_access_tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/9ccd253eb52146d0961e2fe71a71eb6ad31b139b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178110))
- [Remove failing merge request approval rules metric](https://gitlab.com/gitlab-org/gitlab/-/commit/03c4913f0fb7e4cc99c6e3fc17ed0531b897b614) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177494)) **GitLab Enterprise Edition**
- [Remove broken compliance_total_unique_counts weekly, monthly metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/fb1a1b8c60a7b6c7ff707eefab324b8ecb60ff79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175901)) **GitLab Enterprise Edition**

### Security (15 changes)

- [Revert "Update Kas version to the lastest sha"](https://gitlab.com/gitlab-org/gitlab/-/commit/c89db5ed4a62eb58c81030f453d25741a138dc03)
- [Do not allow Planner role to update or delete incidents](https://gitlab.com/gitlab-org/gitlab/-/commit/96c29d4cea022495546617429116226c65b6c779)
- [Reduce number of object allocations on PAT endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/6f4aea90bd0b6bfe61109173aaeb422d05e6f870)
- [Prevent SSRF attacks for Workspaces](https://gitlab.com/gitlab-org/gitlab/-/commit/277faf3747bcc4b6d4beb9d04548c1037ac28840)
- [Security Duo Chat Escape Unknown Domain Hyperlinks](https://gitlab.com/gitlab-org/gitlab/-/commit/babc054870124dc9faad58f9580ca5cd1d48d9c4)
- [Fixes XSS on the target branch in the merge request widget](https://gitlab.com/gitlab-org/gitlab/-/commit/e5f4d1cdbaf813741491013e4c2ab2a5ec758ba0)
- [Prevent read code access when repository is disabled](https://gitlab.com/gitlab-org/gitlab/-/commit/047963e52d1905b2c053c02e014f09c4150a7682)
- [Unsubscribe from actioncable channel when PAT is revoked](https://gitlab.com/gitlab-org/gitlab/-/commit/74adac8edd65cd3cb830e1674f540ee2566d749c)
- [Update Kas version to the lastest sha](https://gitlab.com/gitlab-org/gitlab/-/commit/55609a21ea82501fb0ec4ce8b33e318c764a9e6c)
- [Add offset optimization to audits event API](https://gitlab.com/gitlab-org/gitlab/-/commit/d6fa8fa871e821f805e55f65405ba23bb977d6eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178619)) **GitLab Enterprise Edition**
- [Fix protected variable exfiltration](https://gitlab.com/gitlab-org/gitlab/-/commit/cea3d30eca2ebb9aedd749a4f43f98e328eef350) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179611))
- [Avoid recursive sidekiq calls on cyclic work item hierarchies](https://gitlab.com/gitlab-org/gitlab/-/commit/9d135851bac232665aeadceba56c12104c9ea625) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179611))
- [Enhance rich viewer sanitization](https://gitlab.com/gitlab-org/gitlab/-/commit/2841af0777cef60413aae3ce6844871defa41a4d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179611))
- [Respect the private profile constraints](https://gitlab.com/gitlab-org/gitlab/-/commit/d589410f5a99fc6a5c0b6e524e7255f6f0b6a49b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179611))
- [Reduce REGEXP_TIMEOUT_SECONDS to 40 seconds](https://gitlab.com/gitlab-org/gitlab/-/commit/d2fc6336b69f407a85791ec3b7c5196e3102a31d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177104))

### Performance (11 changes)

- [Optimize build.execute_hooks when creating pipeline](https://gitlab.com/gitlab-org/gitlab/-/commit/45035a5245db22e4ed74e7fa7b8090e8e5881943) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180687))
- [Set idempotency_arguments to SyncProjectPolicyWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/85d166340df03146803e63c579121d34f69076c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180807)) **GitLab Enterprise Edition**
- [Fix cache of branch_requires_code_owner_approval?](https://gitlab.com/gitlab-org/gitlab/-/commit/7e5c090b672f377b3ce9dfdbdbd32f00b4a853c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179697)) **GitLab Enterprise Edition**
- [Reduce N+1 in project GraphQL project queries](https://gitlab.com/gitlab-org/gitlab/-/commit/e069f4f163556c196ebf480096a841a80b122a02) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179330))
- [Update import_failures sharding](https://gitlab.com/gitlab-org/gitlab/-/commit/e50235c033fb5f544fcdf765f0445c487b3bcf92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168393))
- [Share preloads across multiple GraphQL project resolvers](https://gitlab.com/gitlab-org/gitlab/-/commit/bf32e7ecdd878abc22d97ef8e30fa4ba51b9fe4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178978))
- [Remove auto_merge_process_worker_pipeline feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/12b04a6a1940e82c426de20582719ebfb5f052b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178960))
- [Replace check_rate_limit! with check_rate_limit_by_user_or_ip!](https://gitlab.com/gitlab-org/gitlab/-/commit/c0966deb97a024268264261b0c9e2c8b3c340688) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178698))
- [Remove check_oversized_blobs_without_blob_stitcher ff](https://gitlab.com/gitlab-org/gitlab/-/commit/d52e793e4dfc12ec4c3f6168e0e00e15171e7930) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178538))
- [Improve resolved vulnerabilities performance with SM-specific index](https://gitlab.com/gitlab-org/gitlab/-/commit/18fdf4440e5fb1bfaea76227f8846cd81ecde826) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176561))
- [Create system_hooks table](https://gitlab.com/gitlab-org/gitlab/-/commit/a458033864081335284f266a5e049eddb79df57a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175729))

### Other (283 changes)

- [Add Telegram instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/394bb24682fa2dfd0875e163d0e69d00fb51f65d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179361)) **GitLab Enterprise Edition**
- [Add sharding_key to board_labels table](https://gitlab.com/gitlab-org/gitlab/-/commit/d4a3c5c55e2ff2cc65aca58cf074d3f1534dc915) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180642))
- [Validate not null on vulnerability_finding_evidences sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/92a224568bf154feddd978c563e9131fbcaaf520) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179802))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/e9c7395aad1295c8273e514e0750a6c671e73890) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181656))
- [Finalize migration BackfillIssuesDatesWithWorkItemDatesSources](https://gitlab.com/gitlab-org/gitlab/-/commit/229253de212912cf19b21496656abbbca3bf5f8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177108))
- [Remove deprecation notice for runner fields in REST entity](https://gitlab.com/gitlab-org/gitlab/-/commit/ccf62b7e357cfb0fb49dd00b68d38d79a8ffb2cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181507))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/07a2e9f9868318eb77e68dffdb6d6ae43a18466a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181345))
- [Finalize migration BackfillWikiPageSlugsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/30e55f7585b0c1105a1bf5feb57ff991d6dd0975) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177106))
- [Set pipl user soft deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/5f42e8b268021dc7af1d6b5acb4e4911a7efab11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181112)) **GitLab Enterprise Edition**
- [Add MicrosoftTeams instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/a401d57449e004f0cee509d2af57086d105236e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179510))
- [Address non-blocking comments](https://gitlab.com/gitlab-org/gitlab/-/commit/dafba28a6d912b7ecc37a39af14bb43924cb1f6e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181409)) **GitLab Enterprise Edition**
- [Add new CDot internal endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/0a9a74fad8114a606d8cb44788124604881b33e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180980)) **GitLab Enterprise Edition**
- [Sync setup_for_company in user_preferences and onboarding_status](https://gitlab.com/gitlab-org/gitlab/-/commit/a1d6499bd848592ea04ff15e4680853b34c40a5c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179314)) **GitLab Enterprise Edition**
- [Fix rubocop offenses for conan package tests](https://gitlab.com/gitlab-org/gitlab/-/commit/e79b188473dd83e0a726099e92f6564fe7b83c8f) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181117))
- [Expose project/root_namespace ids for Workhorse requests](https://gitlab.com/gitlab-org/gitlab/-/commit/530bd18faf94c7f585559148f5ecd53b87274b19) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/150337))
- [Remove numbers from alerts integration settings](https://gitlab.com/gitlab-org/gitlab/-/commit/4f06441cf93e2e38da882e554ea930f2cbc4a179) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181291))
- [Remove current_page_context_prompt_in_aigw feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/dc3a89a7d919493b03a447ab7e251a265ca9af56) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181273)) **GitLab Enterprise Edition**
- [Remove Search::Zoekt::IndexOverWatermarkEventWorker job instances](https://gitlab.com/gitlab-org/gitlab/-/commit/107a89f2c3e325c454c403eb5eae620d3fe4a0d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181258))
- [Reject API calls from orphaned project runners with HTTP 403](https://gitlab.com/gitlab-org/gitlab/-/commit/63cdafa71506f3010c1be6d99fc2203f5b4570c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180918))
- [Add and backfill namespace_id for design_management_repository_states](https://gitlab.com/gitlab-org/gitlab/-/commit/f6a78a4b95a83d584139f002fd5fc4bfc909d502) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180426))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/84c56408940e120d1a36f694c4e444d14e66b8a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181051))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/bcb0f3b6cfb3c1c0157cb4f6fcf96bddbefd0ad9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180233))
- [Finalize migration BackfillZoektReplicas](https://gitlab.com/gitlab-org/gitlab/-/commit/30f834fda8794352de8512f2648f98b31b99700f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181210))
- [Finalize migration BackfillPackagesDependencyLinksProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/53b57c46287fc7b5b03d01cc6a56e061d69167e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181206))
- [Finalize migration BackfillPackagesDebianProjectComponentsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/7c6407a123064ebac47b60f8422c60d624d5a15a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181205))
- [Add & backfill sharding keys for bulk_import_failures](https://gitlab.com/gitlab-org/gitlab/-/commit/789f0f980e19aeb99c88a5187d91d86e0114c0b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180435))
- [Model registry: Remove unused components](https://gitlab.com/gitlab-org/gitlab/-/commit/9593840707a61ddb268b8f1c95d67273a77753b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181131))
- [Add Teamcity instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/aa871b2d7f83f8d169778d27d9733a2a7f4e2f40) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178920))
- [Add a migration to limit group visibility by organization visibility](https://gitlab.com/gitlab-org/gitlab/-/commit/497bbcc6412f73b3e6b608bbae088a0aa4a559ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179827))
- [Set packages_debian_project_architectures.project_id as NOT NULL](https://gitlab.com/gitlab-org/gitlab/-/commit/ecc1c3d91e975b21ae64b47ba3c71d1581ee4dd1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181065))
- [Add NOT NULL constraint on packages_debian_group_architectures.group_id](https://gitlab.com/gitlab-org/gitlab/-/commit/0e06b4b843c79e0b43b1a5785666d4cee8dc4103) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181062))
- [Add NOT NULL constraint on packages_conan_metadata.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/8d43a17278c06e3cc7ba5460c3a89b20994e3ac6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181061))
- [Set external_status_checks_protected_branches.project_id as NOT NULL](https://gitlab.com/gitlab-org/gitlab/-/commit/d83381aeddbd4469836cf661140b4a0c151346a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181060))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/07f6c6500aeeeeb4eca90b5991f2772c3c329bd5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180874))
- [Validate NOT NULL on vulnerability_findings_remediations sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/0188d5ba1b557073f6fe5238c9648d8fa38cc401) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180698))
- [Validate NOT NULL on terraform_state_versions sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/f73aab982ab39bbf8dcb71c7f08ab232f550512d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180699))
- [Add unique constraints on ci_runners_e59bb2812d partitions](https://gitlab.com/gitlab-org/gitlab/-/commit/6f943a68c4741d1cc740c16dcee009deac683f21) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180721))
- [Add ExternalWiki instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/b27aed0b35963486f037325e8b5535508511cdd3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178723))
- [Remove search_group_sso_redirect feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/58430e78b8944270332bdd6056888b412f679a12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180750)) **GitLab Enterprise Edition**
- [Remove search_global_sso_redirect feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/fa4b9a22532a728d7754577b7f20f37c23616cb4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180748))
- [Add Harbor instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/e37a19936a5657f9d61b9ba8dee12c97b3cf8b5e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178895))
- [Use ResetAuthenticationTokenService in Runner API](https://gitlab.com/gitlab-org/gitlab/-/commit/4b5b546b2baa3856ccc8d860bc45e18d29370022) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180365))
- [Validate NOT NULL on wiki_repository_states sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/ce1f4c9abd2ce52a504394c3b63644461f2e4fd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180700))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/f7c59ccd03152e00a5f9a1e6754b318b7bb4ad32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180943))
- [Cleanup feature flag ff_pages_use_open_file](https://gitlab.com/gitlab-org/gitlab/-/commit/dc2dfcd69c62d2399e579006e7bce37951bb4be5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180926))
- [Validate NOT NULL on work_item_parent_links sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/20ca5bb3701f21a33bb27ae7cfe8c3e98af89427) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180915))
- [Validate NOT NULL on approval_project_rules_users sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/2dd29ce8a65960b4877de8eb788823fd6a2ce2e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180908))
- [Validate NOT NULL on approval_merge_request_rule_sources sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/80f92b08ae80023a4c78fc144163949133b685c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180906))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/643b4f09e052b89fab01e3f60734ebe9a014882e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180820))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/6dd1c1fe592cce48d1871406775ec91829cc7ff3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180819))
- [Add EmailsOnPush instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/f4a911f73c5d7808a3b7f9e87d30a5f677ff4b8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178460))
- [Add and backfill project_id for merge_request_cleanup_schedules](https://gitlab.com/gitlab-org/gitlab/-/commit/d97485474fe4af3423543a3c3d399f2d3360534a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180840))
- [Add & backfill sharding keys for bulk_import_trackers](https://gitlab.com/gitlab-org/gitlab/-/commit/eb3e6e26d792e2b39b72e9e1af5f648b8d571f31) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180437))
- [Add and backfill project_id for merge_request_predictions](https://gitlab.com/gitlab-org/gitlab/-/commit/5bde5a0fd8b82d288e0fe50d8bc9f340f9766ef7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180839))
- [Add and backfill project_id for requirements_management_test_reports](https://gitlab.com/gitlab-org/gitlab/-/commit/f1f90901e1dcd89ca06891f0e1cb51c84a63e9b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180838))
- [Add and backfill namespace_id for design_user_mentions](https://gitlab.com/gitlab-org/gitlab/-/commit/f161cf269bdf41d631b7179505dfbc0269d3c6aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180837))
- [Admin Token API: Revoke Impersonation tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/fa3555c11e65fffddf58cf85373ac2c714c0c1ee) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180745))
- [Add NOT NULL constraint on approvals sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/68aec3940a1095753619849f9fa543b2c702c677) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177402))
- [Validate NOT NULL on vulnerability_finding_signatures sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/20e396173dff1fa1b7a404781832980d0b7ad4e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180692))
- [Add NOT NULL constraint on ml_model_metadata.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/6ef1b13948de9c0e6211d7e28bf84998e9da70d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179816))
- [Requeue backfill for target_project_id on ComplianceViolations table](https://gitlab.com/gitlab-org/gitlab/-/commit/30c2d30f5f525aad5deccd11d7297ac80dd7a9b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180053))
- [Refactor NuGet package enqueuing](https://gitlab.com/gitlab-org/gitlab/-/commit/60c426dc2182e4d3027362f1834d62c30c8ba772) by @holtvogt ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170649))
- [Add Discord instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/a35e764f30106abd9a7dfbbea6b1cfd33f7653f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178313))
- [Add and backfill project_id for operations_scopes](https://gitlab.com/gitlab-org/gitlab/-/commit/2be897fcaa970746cf359680b854e96f1963726a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180223))
- [Add and backfill project_id for merge_request_diff_details](https://gitlab.com/gitlab-org/gitlab/-/commit/d22e78e61eb5a1cb193a82a794c32379b07aa464) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180428))
- [Add & backfill sharding keys for bulk_import_export_batches](https://gitlab.com/gitlab-org/gitlab/-/commit/9aea28f1fb2110b01a83245ce53a398f280620fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180432))
- [Add & backfill sharding keys for required_code_owners_sections](https://gitlab.com/gitlab-org/gitlab/-/commit/680051f9862194503da017d2217933308fefaba3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180440))
- [Mark 20241025160103 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/eb9e5c0e091fd29a8a4297f55f7050fb88ca74c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180209)) **GitLab Enterprise Edition**
- [Mark 20241106201829 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/ce8b72a008b8cf757134f8218a2e25cab35d1c6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180211)) **GitLab Enterprise Edition**
- [Add and backfill namespace_id for design_management_designs_versions](https://gitlab.com/gitlab-org/gitlab/-/commit/63c5d772706cae84776db17804c4dc51febe6872) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180220))
- [Validate not null on sbom_occurrences_vulnerabilities sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/68265ff0d5d16c5db5b218d4dd1711780b9c8c58) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179798))
- [Add & backfill sharding keys for snippet_repository_storage_moves](https://gitlab.com/gitlab-org/gitlab/-/commit/d2195c80d81f5e0cb3ca8f300734874bdff1558d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180441))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/1c533c6f6163dc4e56e4d8eb9388b69839557ce5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180489))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/f9d94114531036aa118c1c25ed369de95b05a545) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180232))
- [Remove vulnerability_report_security_scores feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/1e1624fc4c949e5a3ce3a12482787a1fcace1c68) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180447)) **GitLab Enterprise Edition**
- [Reindex Elasticsearch projects index to update integer with long type](https://gitlab.com/gitlab-org/gitlab/-/commit/22f8a5431d535c677c13461ec4c5715316e252e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180165)) **GitLab Enterprise Edition**
- [Reindex Elasticsearch users index to update integer with long type](https://gitlab.com/gitlab-org/gitlab/-/commit/5da816f4ab67fb65a537330b488348782db62db0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180178)) **GitLab Enterprise Edition**
- [Remove `sourcegraph` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/8c9cdd9df086c6191643b3c1d2933aa63ca90432) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173712))
- [refactor: Use BaseProjectService for container protection services](https://gitlab.com/gitlab-org/gitlab/-/commit/e9694d06c385b843d892c214f7f70f553783a4d1) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180386))
- [Protected packages: Remove deprecation warnings in GRAPHQL](https://gitlab.com/gitlab-org/gitlab/-/commit/0e59997cd265ff15b22114345812ffc6675a34b2) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180372))
- [Change FF ownership](https://gitlab.com/gitlab-org/gitlab/-/commit/e5a43acd604fcb754e683cd3f56ccc80297c6eea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180355)) **GitLab Enterprise Edition**
- [Delete track_user_access_from_pipl_countries FF](https://gitlab.com/gitlab-org/gitlab/-/commit/28f1bb7b79df3d64d1065f213e7b8129a7b147c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180358)) **GitLab Enterprise Edition**
- [Mark 20241105111645 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/ca4b2f9c98b12817819c4449430e2408b4c8a560) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180210)) **GitLab Enterprise Edition**
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/5d14d1300261e6678e521a3c345acd4608c5ea64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175841))
- [Add milestones not null sharding key constraint](https://gitlab.com/gitlab-org/gitlab/-/commit/e5cbda153f88c9ef8ba14d57cbf306f15e866fac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179791))
- [Instrument the creation of CI runners](https://gitlab.com/gitlab-org/gitlab/-/commit/e5215d8d81f110be7061f7ddc40a3729a00cf3a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179876))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/683257901596c5866198a209b94208ce2019b273) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180248))
- [Add and backfill group_id for boards_epic_list_user_preferences](https://gitlab.com/gitlab-org/gitlab/-/commit/98722aad8dc8e147fcdb3a22d217379e5044514f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180037))
- [Extend SyncNamespaceService for add-on purchases](https://gitlab.com/gitlab-org/gitlab/-/commit/513b625b2a90d06053c13e417878404bfb26787e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179667)) **GitLab Enterprise Edition**
- [Add and backfill project_id for dast_pre_scan_verification_steps](https://gitlab.com/gitlab-org/gitlab/-/commit/01061bad39fb4cefa39d91730b6865cd7e73a2de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180046))
- [Reindex Elasticsearch wiki index to update integer with long type](https://gitlab.com/gitlab-org/gitlab/-/commit/689152bcf724fd6d938f2a319bfbf85f28f1e4de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180023)) **GitLab Enterprise Edition**
- [Add Confluence instance integraiton model](https://gitlab.com/gitlab-org/gitlab/-/commit/efe3bc858502348b5ccbe17abd43b874d01def71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179500))
- [Add sharding key to board_assignees](https://gitlab.com/gitlab-org/gitlab/-/commit/c9773b4e168cd0cba3c6eefb7463b857776f9a11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178949))
- [Set sharding key for merge_requests_compliance_violations](https://gitlab.com/gitlab-org/gitlab/-/commit/0a6a1d20a7973dbcdffba4b2a66564685e256cf2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178769))
- [Fix Layout/LineLength offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/b83474fe688ca025b63538bdb7eaa721ab61eef3) by @ikelax ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169988))
- [Add new provision service](https://gitlab.com/gitlab-org/gitlab/-/commit/10484bec1461437e282be0cfd0f4864b65d07537) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178532)) **GitLab Enterprise Edition**
- [test: Improve readability of test by applying table syntax](https://gitlab.com/gitlab-org/gitlab/-/commit/9d150b29950176b9a19c61e462a610f8a3fb1bd1) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179518))
- [Remove start and due date widget from incident WIT](https://gitlab.com/gitlab-org/gitlab/-/commit/d40b31788b76d44efcd72cd1acd4e362760d7192) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180002))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/121897473d6152994d061ff201cd4d3eb66d5929) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180003))
- [Add NOT NULL constraint to release_links.project_id column](https://gitlab.com/gitlab-org/gitlab/-/commit/b67da92b8fbdef3b44485fb94c8bd248f99f4fe2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177235))
- [Add NOT NULL constraint on draft_notes.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/0b4bb46dd01704ec5753f334ffd72711f1673664) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177403))
- [Fix 20 rubocop violations for Layout/ArrayAlignment](https://gitlab.com/gitlab-org/gitlab/-/commit/297c8179c1eea1683a0990c07c53d777d7a6981e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179945))
- [Add project_namespace_id_from and project_namespace_id_to](https://gitlab.com/gitlab-org/gitlab/-/commit/34844d1c7dfe1d9512fac9b6eae9f74ab5eafaa8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179558)) **GitLab Enterprise Edition**
- [Extend documentation for includes in code blocks](https://gitlab.com/gitlab-org/gitlab/-/commit/e3bfef24e98b0b29236f5facfe5a0eeeac23d478) by @schurzi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179571))
- [Mark 20240814223217 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/24930e28bff39fbd2aba3f228efc3257a9f8be6b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178353)) **GitLab Enterprise Edition**
- [Add NOT NULL constraint on ml_candidate_metadata.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/e9a445a37ec0f40913c1ea37f9ec1daa0353b869) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179814))
- [Add FK back to issues.work_item_type_id](https://gitlab.com/gitlab-org/gitlab/-/commit/ff2878f48c843cd7fc38a89505a9b8c15734b856) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178495))
- [Add NOT NULL constraint on merge_request_blocks.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/275fadb87a1d3a5d05a30d5c9068aeb9d48b45bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177399))
- [Create siphon tables for namespace details and bulk imports](https://gitlab.com/gitlab-org/gitlab/-/commit/d255645902f3cf5ace52846b086005f4de3cb06a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179726))
- [Add NOT NULL constraint to boards sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/ec3e6f8822bcdbdc7c86cb28601fee40dcb6499d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179112))
- [Remove vulnerability_filtering_by_identifier feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/1761599e30a460a805893129ed9de76985ec5393) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179525)) **GitLab Enterprise Edition**
- [Add custom fields widget to all work item types](https://gitlab.com/gitlab-org/gitlab/-/commit/d7f5cfcaffdb7f542010866cb1da4f8c7b832899) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176206))
- [Partition Manager to automatically attack LFK trigger to new partitions](https://gitlab.com/gitlab-org/gitlab/-/commit/b5f7e144a29f359100daff4bf7d5a7f66dcce912) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175310))
- [Remove duplicate shared spec](https://gitlab.com/gitlab-org/gitlab/-/commit/237d7898012050db19cde69a880fef54489bdd8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179705))
- [Finalize migration BackfillPackagesDebianProjectArchitecturesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/f3aea4ac41401beff21677a7c0179a48983ffa79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178652))
- [Add trigger token expiration](https://gitlab.com/gitlab-org/gitlab/-/commit/e6e7076f775930c802ffcbbede986aef28e102c9) by @william.allen1 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/146912))
- [Add not null constraint on vulnerability_finding_signatures.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/2df4fea30d70ffc96ffa8eeac059b603867820f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177376))
- [Add NOT NULL constraint on approval_merge_request_rules.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/827d3f28a4db1be0c2c5c95ff70b4614bc609524) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177401))
- [Add NOT NULL constraint on work_item_parent_links.namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/14cc21b8f98649f73107a253fb12af499eee69f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177413))
- [Add NOT NULL constraint on merge_request_context_commits.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/6eb1beca38bbc762fbc754b73930dba146f2bd66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177405))
- [Add not null constraint on dast_scanner_profiles_builds.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/4be2a19dae1488eea1bbe04efa3a9cf27ec4e85e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177358))
- [Add NOT NULL constraint on epic_user_mentions.group_id](https://gitlab.com/gitlab-org/gitlab/-/commit/bef15865d7805fcaf247c7f23c3b922df99983c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177411))
- [Add NOT NULL constraint on status_check_responses.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/775015ad54377942c8a706663292252c7496058d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177392))
- [Cleanup throttle_with_process_commit_worker_pool feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b3cfec256f9a7cc89c748c7d3e361177bf4f8db6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179619))
- [Create cluster_agent_migrations table](https://gitlab.com/gitlab-org/gitlab/-/commit/523f4fe602825c8f366b8aa9fc44e01c48f924ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179324))
- [test: Fix typo in test](https://gitlab.com/gitlab-org/gitlab/-/commit/4d18974c58a6c66e1c441499917d85ffd82b4979) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179533))
- [Create ClickHouse siphon tables for milestones and events](https://gitlab.com/gitlab-org/gitlab/-/commit/b3a838ed16e81b83c004a188e02efa9d42449063) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179573))
- [Rename feature flag for enhanced vulnerability bulk actions](https://gitlab.com/gitlab-org/gitlab/-/commit/cdb6a2d0505da67f6c8878cb4380cb5ee723add0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179488)) **GitLab Enterprise Edition**
- [Add MattermostSlashCommands instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/fde3040722cb2adae6cda19cd14e8b6df69467a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179534))
- [Add MockCi instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/413881770e1b1e90e53ba62d05e5a4ab57ac4ed0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179505))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/fca2ade31a2c0214b55defe6f5e328f400fdc01e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178459))
- [Remove the index_curation feature](https://gitlab.com/gitlab-org/gitlab/-/commit/fd013ff12c41c351fef7b5c216e157ea02e2f2e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179017))
- [Fix pngquant script by requiring logger](https://gitlab.com/gitlab-org/gitlab/-/commit/9646145ce34962ece56921e02d76ac35893f4ca6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179424))
- [Add MockMonitoring instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/f4ee73047604c86392b2a2bf09d589f93cdae026) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179423))
- [Add Phorge instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/38a55b6af6476d2d199c3293c19ebccbf9b7b37d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179422))
- [Add PipelinesEmail instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/f24fbc7f28c4d09fd987de4d1dc3f2e0ebea7206) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179419))
- [Add Pivotaltracker instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/e986da76167b91bbca8654c4886d30c3a29a097d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179413))
- [Fix Usernamespace Audit events](https://gitlab.com/gitlab-org/gitlab/-/commit/e49d9dedfee119b3adbe2791155efc6b633cfe4c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177095))
- [Add Pumble instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/a29d262ad54d8eaa17315cd5048fa90a8e312af0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179393))
- [Add Pushover instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/dba353e2d84e7167ed4ac2114a126f0820610a3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179388))
- [Remove Ci::Tagging model](https://gitlab.com/gitlab-org/gitlab/-/commit/c8b209b006180066151afc5d52a69a1c67352313) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179384))
- [Add Redmine instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/4622b0480e80a9f76569b210d866259b1b139189) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179377))
- [Remove enforce_global_file_size_limit feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/2b7fea4f1c1e0b35475731944ba6dfa1efa91ade) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179347))
- [Handle case where pipeline can be nil in FindingsFinder](https://gitlab.com/gitlab-org/gitlab/-/commit/f67428c81caaadacecad9efec81db70338453877) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178545)) **GitLab Enterprise Edition**
- [Add NOT NULL constraint on project_relation_exports.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/94410f407af125bacf3762f5a892031d135a4c56) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177407))
- [Add NOT NULL constraint on merge_request_assignees.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/6f1c17c72025e21e0d55749196df912155cb9ce0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177404))
- [Add NOT NULL constraint on vulnerability_finding_links.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/7fe709c43216f6e52d7d0b1da322cd1b8cdde387) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177375))
- [Mark 20241003142503 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/f23b78db89f7e6435adf24047f3288d911153f62) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178357)) **GitLab Enterprise Edition**
- [Add UnifyCircuit instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/0cfe9941b377efd1c9cc250f47bd7685c991908f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179265))
- [Remove Ci::Tagging association](https://gitlab.com/gitlab-org/gitlab/-/commit/5d65b36c743da8bc7716a27dcc080c8450b0d4e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178462))
- [Finalize migration BackfillMergeRequestReviewersProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/3fdb4a69858d56908582e7fffe7205d938020eef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177331))
- [Add WebexTeams instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/2e090ba15e11d278c273819ee727033608e8bb39) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179264))
- [Finalize migration for backfilling security policies](https://gitlab.com/gitlab-org/gitlab/-/commit/cef94778b25b23517145dcc44a9b01b7b5996471) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175231))
- [Backfill p_ci_pipeline_variables from ci_trigger_requests](https://gitlab.com/gitlab-org/gitlab/-/commit/a89820fc031f68e3022749be9c32039800e8bc06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175399))
- [Add Youtrack instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/b45096f739d95719a7c40c5eb2536da4faf99991) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179251))
- [Add warning to DT docs](https://gitlab.com/gitlab-org/gitlab/-/commit/3bd54863ac7934bffef246c53fe2d296a2c558f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179223))
- [Move registration_objective to onboarding_status column](https://gitlab.com/gitlab-org/gitlab/-/commit/3aa1fb5916b699b26fbdb14937728a52b613b2ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176428)) **GitLab Enterprise Edition**
- [Validate not null constraint on projects.project_namespace_id column](https://gitlab.com/gitlab-org/gitlab/-/commit/1f98c0759263f01d803fa2d3bc9ed3e05bea1be8) by @c0rydoras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178729))
- [Refactor Cell Configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/9aed1004d100d4afcb9357b8c8e2fac2fecca9c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177988))
- [Mark 20241017094601 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/ce85551f2ff50e33975c5c31b8290e6cddd47bd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178359)) **GitLab Enterprise Edition**
- [Remove multiple_todos feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/a5d66c1fe59147287de1a64d2f14b92f35b9c47a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178897))
- [Add CustomIssueTracker instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/7f8c2e5fc6dabef6650edfd56355de67c9009969) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178019))
- [Add DiffblueCover instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/a7d4bc9db454f1e357e62e45129948ee5b3d4d7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178027))
- [Add Ewm instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/bc747914b77a5fe0630fae8acc343002746b14b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178721))
- [Finalize 20250109133913 batched migration](https://gitlab.com/gitlab-org/gitlab/-/commit/06f17ea420b60a57f7ff94a23468d4d46e8b74fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179042))
- [Finalize 20250108170045 batched migration](https://gitlab.com/gitlab-org/gitlab/-/commit/f1d718bd046922ccf1f20e30a602a9e6ae76c382) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179039))
- [Finalize RecalculateShardingKeyIdForOrphanedProjectRunners](https://gitlab.com/gitlab-org/gitlab/-/commit/9f1efb3c43b7405817c0bc1b85597f59e9be1c29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179036))
- [Remove `merge_request_dashboard_new_lists` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4b64fdf95f5811fb4a41b67e513d5030bb86d6af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179020))
- [Set vulnerability_findings_remediations.project_id as NOT NULL](https://gitlab.com/gitlab-org/gitlab/-/commit/8fbd1ab0bc5c0ef21962e0359caf85efba5408b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177377))
- [Add NOT NULL constraint on issue_links.namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/ea831ddb2c5fb9ac74967c13093e029b0ed7e901) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177412))
- [Consolidate secure tokens feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/3759f68a47d2d136f8643312ff21d2a399531e51) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178404))
- [Add not null constraint on packages_build_infos.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/ad2fa4c965ea6c090d271f65eb45ff4c0f4f5d01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177362))
- [Remove feature flag for pipeline cleanup](https://gitlab.com/gitlab-org/gitlab/-/commit/7477598a4ac0e5e3eb1c01505f43cbe6d9b1fc70) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178754))
- [Add Irker instance intergration](https://gitlab.com/gitlab-org/gitlab/-/commit/4627b5f5f4f339b94746be4a0a61b6da843d34fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178903))
- [Finalize migration BackfillResourceLinkEvents](https://gitlab.com/gitlab-org/gitlab/-/commit/0a89eccff629ad5f2c4ff43867905e3460f68dd1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178649))
- [Create ClickHouse siphon table for notes](https://gitlab.com/gitlab-org/gitlab/-/commit/6f316a39360b0e002b08cc583446f5aa81ba7514) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178914))
- [Remove toggle_redis_6_0_compatibility FF](https://gitlab.com/gitlab-org/gitlab/-/commit/7b5ceece82f6dbaafb85c9922fcaafe21e66712b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178908))
- [Finalize migration BackfillPackagesConanMetadataProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/506d8e4b73f25ac9b912ad6f4b623fc099b052d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178097))
- [Store failed pipeline counts on ClickHouse](https://gitlab.com/gitlab-org/gitlab/-/commit/44e1c4298a4ce3f7c7729d6a59143a3606bf0c28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178621))
- [Finalize migration BackfillDetectedAtFromCreatedAtColumn](https://gitlab.com/gitlab-org/gitlab/-/commit/b39e2b7a1e9b1ced2f35eaa2f9bb1bed6a56903e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178847))
- [Creating table for scheduling user deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/9e7fb70e48bd79bd5487da1f78bfdd2596516b73) by @Anzala09 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167520))
- [Remove Gitlab::Redis::ClusterDbLoadBalancing store post migration](https://gitlab.com/gitlab-org/gitlab/-/commit/04a4ee4a34370aeaebf8d32af3b952591a7ffc56) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178566))
- [Add not null constraint on dast_profiles_pipelines.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/0e9503bbd0cfcf490be1423fbee222e826003abc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177355))
- [Add not null constraint on vulnerability_finding_evidences.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/ed54de0b63934d399fd35aea64f5dacb15ba0970) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177374))
- [Finalize SkipCompanyOnboardingStep batched migration](https://gitlab.com/gitlab-org/gitlab/-/commit/2c6a8df111776ef4eabb2882a948f475f61e2af2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178780))
- [Finalize migration ResyncHasVulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/bfaeda1c54fdc6c67c27fa96d1ee2ec970a53caa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177797))
- [Mark 20240716141532 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/99c4346ef6dd695dd0dc27f067df221298cadec3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178351)) **GitLab Enterprise Edition**
- [Clean up dora_charts_forecast feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f44868e274be3d757399e5f9beac44e3833096bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178325)) **GitLab Enterprise Edition**
- [Add HangoutsChat instance integration](https://gitlab