/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.columns.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.gephi.datalab.plugin.manipulators.columns.ColumnValuesFrequency;
import org.gephi.datalab.spi.DialogControls;
import org.gephi.datalab.spi.columns.AttributeColumnsManipulator;
import org.gephi.datalab.spi.columns.AttributeColumnsManipulatorUI;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Table;
import org.gephi.ui.components.JFreeChartDialog;
import org.gephi.ui.components.SimpleHTMLReport;
import org.jfree.chart.JFreeChart;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class ColumnValuesFrequencyUI
extends JPanel
implements AttributeColumnsManipulatorUI {
    private ColumnValuesFrequency manipulator;
    private Table table;
    private Column column;
    private Map<Object, Integer> valuesFrequencies;
    private JFreeChart pieChart;
    private JFreeChartDialog pieChartDialog;
    private SimpleHTMLReport reportDialog;
    private JButton configurePieChartButton;
    private JButton showReportButton;

    public ColumnValuesFrequencyUI() {
        this.initComponents();
    }

    public void setup(AttributeColumnsManipulator m, GraphModel graphModel, Table table, Column column, DialogControls dialogControls) {
        this.table = table;
        this.column = column;
        this.manipulator = (ColumnValuesFrequency)m;
        this.valuesFrequencies = this.manipulator.buildValuesFrequencies(table, column);
        this.configurePieChartButton.setEnabled(this.valuesFrequencies.size() <= 100);
    }

    public void unSetup() {
        if (this.reportDialog != null) {
            this.reportDialog.dispose();
        }
        if (this.pieChartDialog != null) {
            this.pieChartDialog.dispose();
        }
    }

    public String getDisplayName() {
        return this.manipulator.getName();
    }

    public JPanel getSettingsPanel() {
        return this;
    }

    public boolean isModal() {
        return false;
    }

    private void initComponents() {
        this.configurePieChartButton = new JButton();
        this.showReportButton = new JButton();
        this.configurePieChartButton.setIcon(ImageUtilities.loadImageIcon((String)"DataLaboratoryPlugin/category.png", (boolean)false));
        this.configurePieChartButton.setText(NbBundle.getMessage(ColumnValuesFrequencyUI.class, (String)"ColumnValuesFrequencyUI.configurePieChartButton.text"));
        this.configurePieChartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnValuesFrequencyUI.this.configurePieChartButtonActionPerformed(evt);
            }
        });
        this.showReportButton.setIcon(ImageUtilities.loadImageIcon((String)"DataLaboratoryPlugin/application-block.png", (boolean)false));
        this.showReportButton.setText(NbBundle.getMessage(ColumnValuesFrequencyUI.class, (String)"ColumnValuesFrequencyUI.showReportButton.text"));
        this.showReportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnValuesFrequencyUI.this.showReportButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.configurePieChartButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 9, Short.MAX_VALUE).addComponent(this.showReportButton).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.configurePieChartButton).addComponent(this.showReportButton)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void configurePieChartButtonActionPerformed(ActionEvent evt) {
        if (this.pieChart == null) {
            this.pieChart = this.manipulator.buildPieChart(this.valuesFrequencies);
        }
        if (this.pieChartDialog != null) {
            this.pieChartDialog.setVisible(true);
        } else {
            this.pieChartDialog = new JFreeChartDialog(WindowManager.getDefault().getMainWindow(), this.pieChart.getTitle().getText(), this.pieChart, 1000, 1000);
        }
    }

    private void showReportButtonActionPerformed(ActionEvent evt) {
        if (this.pieChart == null) {
            this.pieChart = this.manipulator.buildPieChart(this.valuesFrequencies);
        }
        String html = this.manipulator.getReportHTML(this.table, this.column, this.valuesFrequencies, this.pieChart, this.pieChartDialog != null ? this.pieChartDialog.getChartSize() : null);
        if (this.reportDialog != null) {
            this.reportDialog.dispose();
        }
        this.reportDialog = new SimpleHTMLReport(WindowManager.getDefault().getMainWindow(), html);
    }
}

