/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.text.MessageFormat;
import org.freeplane.core.util.TextUtils;
import org.freeplane.plugin.script.ExecuteScriptAction;
import org.freeplane.plugin.script.ScriptingGuiConfiguration;

public class ScriptingMenuUtils {
    static final String LABEL_AVAILABLE_MODES_TOOLTIP = "ExecuteScript.available_modes.tooltip";
    static final String LABEL_NO_SCRIPTS_AVAILABLE = "ExecuteScripts.noScriptsAvailable";

    public static String parentLocation(String location) {
        int indexOfSlash = location.lastIndexOf(47);
        if (indexOfSlash == -1) {
            throw new IllegalArgumentException("location is not an absolute path: " + location);
        }
        return location.substring(0, indexOfSlash);
    }

    public static String getMenuItemTitle(ScriptingGuiConfiguration.ScriptMetaData metaData, ExecuteScriptAction.ExecutionMode executionMode) {
        String titleKey = metaData.getTitleKey(executionMode);
        String scriptName = metaData.getScriptName();
        String translation = titleKey != null ? TextUtils.getText((String)titleKey, (String)titleKey.replace('_', ' ')) : ScriptingMenuUtils.scriptNameToMenuItemTitle(scriptName);
        return translation.contains("{0}") ? MessageFormat.format(translation, ScriptingMenuUtils.scriptNameToMenuItemTitle(scriptName)) : translation;
    }

    public static String scriptNameToMenuItemTitle(String scriptName) {
        String translation = TextUtils.getText((String)scriptName, (String)TextUtils.getText((String)("addons." + scriptName), null));
        if (translation != null) {
            return translation;
        }
        String capitalized = scriptName.length() < 2 ? scriptName : scriptName.substring(0, 1).toUpperCase() + scriptName.substring(1);
        return capitalized.replaceAll("([a-z])([A-Z])", "$1 $2");
    }

    public static String noScriptsAvailableMessage() {
        return "<html><body><em>" + TextUtils.getText((String)LABEL_NO_SCRIPTS_AVAILABLE) + "</em></body></html>";
    }

    public static String getMenuTitle(ScriptingGuiConfiguration.ScriptMetaData metaData, ExecuteScriptAction.ExecutionMode executionMode) {
        String specialLocation = metaData.getMenuLocation(executionMode);
        if (specialLocation == null) {
            return ScriptingMenuUtils.scriptNameToMenuItemTitle(metaData.getScriptName());
        }
        return ScriptingMenuUtils.getTitleForLocation(specialLocation);
    }

    public static String getTitleForLocation(String location) {
        int index = location.lastIndexOf(47);
        String lastKey = location.substring(index + 1);
        return TextUtils.getText((String)lastKey, (String)TextUtils.getText((String)("addons." + lastKey), (String)lastKey));
    }
}

