/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReferenceArray;

final class AtomicReferenceArrayCodec<V>
implements ObjectCodec<AtomicReferenceArray<V>> {
    AtomicReferenceArrayCodec() {
    }

    @Override
    public Class<AtomicReferenceArray<V>> getEncodedClass() {
        return AtomicReferenceArray.class;
    }

    @Override
    public void serialize(SerializationContext context, AtomicReferenceArray<V> obj, CodedOutputStream codedOut) throws SerializationException, IOException {
        int length = obj.length();
        codedOut.writeInt32NoTag(length);
        for (int i = 0; i < length; ++i) {
            context.serialize(obj.getPlain(i), codedOut);
        }
    }

    @Override
    public AtomicReferenceArray<V> deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        int length = codedIn.readInt32();
        AtomicReferenceArray result = new AtomicReferenceArray(length);
        for (int i = 0; i < length; ++i) {
            result.setPlain(i, context.deserialize(codedIn));
        }
        return result;
    }
}

