/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;

public class ArrayCodec<T>
implements ObjectCodec<T[]> {
    private final Class<T> componentType;
    private final Class<T[]> arrayType;

    public static <T> ArrayCodec<T> forComponentType(Class<T> componentType) {
        Class<T[]> arrayType = Array.newInstance(componentType, 0).getClass();
        return new ArrayCodec<T>(componentType, arrayType);
    }

    private ArrayCodec(Class<T> componentType, Class<T[]> arrayType) {
        this.componentType = componentType;
        this.arrayType = arrayType;
    }

    @Override
    public final Class<T[]> getEncodedClass() {
        return this.arrayType;
    }

    @Override
    public final void serialize(SerializationContext context, T[] obj, CodedOutputStream codedOut) throws SerializationException, IOException {
        codedOut.writeInt32NoTag(obj.length);
        try {
            for (T item : obj) {
                context.serialize(item, codedOut);
            }
        }
        catch (StackOverflowError e) {
            throw new SerializationException("StackOverflow serializing array", e);
        }
    }

    @Override
    public final T[] deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        Object[] result = (Object[])Array.newInstance(this.componentType, codedIn.readInt32());
        try {
            for (int i = 0; i < result.length; ++i) {
                result[i] = context.deserialize(codedIn);
            }
        }
        catch (StackOverflowError e) {
            throw new SerializationException("StackOverflow deserializing array", e);
        }
        return result;
    }

    static final class ObjectArrayCodec
    extends ArrayCodec<Object> {
        ObjectArrayCodec() {
            super(Object.class, Object[].class);
        }
    }
}

