"use strict";
/*
  Simplified BSD License (see LICENSES/BSD-2-Clause.txt or https://opensource.org/licenses/BSD-2-Clause)
  SPDX-FileCopyrightText: Ansible Project
  SPDX-License-Identifier: BSD-2-Clause
*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.addToDestination = void 0;
const dom_1 = require("./dom");
function addToDestination(destination, paragraph, opts) {
    for (const part of paragraph) {
        switch (part.type) {
            case dom_1.PartType.ERROR:
                destination.push(opts.formatError(part));
                break;
            case dom_1.PartType.BOLD:
                destination.push(opts.formatBold(part));
                break;
            case dom_1.PartType.CODE:
                destination.push(opts.formatCode(part));
                break;
            case dom_1.PartType.HORIZONTAL_LINE:
                destination.push(opts.formatHorizontalLine(part));
                break;
            case dom_1.PartType.ITALIC:
                destination.push(opts.formatItalic(part));
                break;
            case dom_1.PartType.LINK:
                destination.push(opts.formatLink(part));
                break;
            case dom_1.PartType.MODULE: {
                let url;
                if (opts.pluginLink) {
                    url = opts.pluginLink({ fqcn: part.fqcn, type: 'module' });
                }
                destination.push(opts.formatModule(part, url));
                break;
            }
            case dom_1.PartType.RST_REF:
                destination.push(opts.formatRSTRef(part));
                break;
            case dom_1.PartType.URL:
                destination.push(opts.formatURL(part));
                break;
            case dom_1.PartType.TEXT:
                destination.push(opts.formatText(part));
                break;
            case dom_1.PartType.ENV_VARIABLE:
                destination.push(opts.formatEnvVariable(part));
                break;
            case dom_1.PartType.OPTION_NAME: {
                let url;
                if (part.plugin && opts.pluginOptionLikeLink) {
                    url = opts.pluginOptionLikeLink(part.plugin, part.entrypoint, 'option', part.link, part.plugin === opts.currentPlugin);
                }
                destination.push(opts.formatOptionName(part, url));
                break;
            }
            case dom_1.PartType.OPTION_VALUE:
                destination.push(opts.formatOptionValue(part));
                break;
            case dom_1.PartType.PLUGIN: {
                let url;
                if (opts.pluginLink) {
                    url = opts.pluginLink(part.plugin);
                }
                destination.push(opts.formatPlugin(part, url));
                break;
            }
            case dom_1.PartType.RETURN_VALUE: {
                let url;
                if (part.plugin && opts.pluginOptionLikeLink) {
                    url = opts.pluginOptionLikeLink(part.plugin, part.entrypoint, 'retval', part.link, part.plugin === opts.currentPlugin);
                }
                destination.push(opts.formatReturnValue(part, url));
                break;
            }
        }
    }
}
exports.addToDestination = addToDestination;
//# sourceMappingURL=format.js.map