/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.users;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.catalina.Group;
import org.apache.catalina.Role;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.users.AbstractUser;

public class GenericUser<UD extends UserDatabase>
extends AbstractUser {
    protected final UD database;
    protected final CopyOnWriteArrayList<Group> groups = new CopyOnWriteArrayList();
    protected final CopyOnWriteArrayList<Role> roles = new CopyOnWriteArrayList();

    GenericUser(UD UD, String string, String string2, String string3, List<Group> list, List<Role> list2) {
        this.database = UD;
        this.username = string;
        this.password = string2;
        this.fullName = string3;
        if (list != null) {
            this.groups.addAll(list);
        }
        if (list2 != null) {
            this.roles.addAll(list2);
        }
    }

    @Override
    public Iterator<Group> getGroups() {
        return this.groups.iterator();
    }

    @Override
    public Iterator<Role> getRoles() {
        return this.roles.iterator();
    }

    @Override
    public UserDatabase getUserDatabase() {
        return this.database;
    }

    @Override
    public void addGroup(Group group) {
        if (this.groups.addIfAbsent(group)) {
            this.database.modifiedUser(this);
        }
    }

    @Override
    public void addRole(Role role) {
        if (this.roles.addIfAbsent(role)) {
            this.database.modifiedUser(this);
        }
    }

    @Override
    public boolean isInGroup(Group group) {
        return this.groups.contains(group);
    }

    @Override
    public boolean isInRole(Role role) {
        return this.roles.contains(role);
    }

    @Override
    public void removeGroup(Group group) {
        if (this.groups.remove(group)) {
            this.database.modifiedUser(this);
        }
    }

    @Override
    public void removeGroups() {
        if (!this.groups.isEmpty()) {
            this.groups.clear();
            this.database.modifiedUser(this);
        }
    }

    @Override
    public void removeRole(Role role) {
        if (this.roles.remove(role)) {
            this.database.modifiedUser(this);
        }
    }

    @Override
    public void removeRoles() {
        if (!this.roles.isEmpty()) {
            this.database.modifiedUser(this);
        }
        this.roles.clear();
    }

    @Override
    public void setFullName(String string) {
        this.database.modifiedUser(this);
        super.setFullName(string);
    }

    @Override
    public void setPassword(String string) {
        this.database.modifiedUser(this);
        super.setPassword(string);
    }

    @Override
    public void setUsername(String string) {
        this.database.modifiedUser(this);
        super.setUsername(string);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof GenericUser) {
            GenericUser genericUser = (GenericUser)object;
            return genericUser.database == this.database && this.username.equals(genericUser.getUsername());
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.database == null ? 0 : this.database.hashCode());
        n = 31 * n + (this.username == null ? 0 : this.username.hashCode());
        return n;
    }
}

