%%
%% This is file `omgtudoc-asoiu.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% omgtudoc-asoiu.dtx  (with options: `class')
%% Класс omgtudoc-asoiu предназначен для документов,
%% подготавливаемых на кафедре "Автоматизированные системы
%% обработки информации и управления" Омского государственного
%% технического университета. Он основан на классе article и
%% для своей работы требует XeTeX или LuaLaTeX.
%% 
%% The omgtudoc-asoiu class is to be used for documents which are
%% prepared on the "Automated systems of information
%% processing and control" (ASOIU) of Omsk State Technical
%% University. This class is based on article class
%% and requires XeTeX or LuaLaTeX for proper working.
%% 
%% Copyright (C) 2025 Danila A. Kondratenko
%% 
%% This file may be distributed and/or modified under the
%% conditions of the LaTeX Project Public License, either
%% version 1.3 of this license or (at your option) any later
%% version. The latest version of this license is in:
%% 
%%      http://www.latex-project.org/lppl.txt
%% 
%% and version 1.3c or later is part of all distributions of
%% LaTeX version 2008-05-04 or later.
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{omgtudoc-asoiu}
    [2025-02-21 v1.1b
Class for ASOIU documents]
\LoadClass[a4paper,12pt]{article}
\RequirePackage[left=30mm,right=15mm,top=20mm,bottom=20mm]{geometry}
\newcommand\@document@type{}
\def\CurrentOption{}
\newif\if@within@section
\@within@sectionfalse
\DeclareOption{labreport}{\renewcommand\@document@type{labreport}}
\DeclareOption{courseproj}{\renewcommand\@document@type{courseproj}}
\DeclareOption{minimal}{\renewcommand\@document@type{minimal}}
\DeclareOption{withinsection}{\@within@sectiontrue}
\ExecuteOptions{minimal}
\ProcessOptions
\input{omgtudoc-asoiu-\@document@type.tpt}
\RequirePackage{polyglossia}
\setdefaultlanguage[forceheadingpunctuation=false]{russian}
\addto\captionsrussian{%
    \renewcommand\figurename{Рисунок}%
    \renewcommand\tablename{Таблица}%
}
\RequirePackage{caption}
\DeclareCaptionLabelSeparator{emdash}{~---~}
\captionsetup[figure]{labelsep=emdash,justification=centerlast}
\captionsetup[table]{labelsep=emdash,justification=justified,singlelinecheck=false}
\renewcommand*{\rmdefault}{minntx}
\RequirePackage[]{newtxmath}
\RequirePackage{tempora}
\RequirePackage[no-math]{fontspec}
\setmainfont{tempora}
\renewcommand\normalsize{\@setfontsize\normalsize{14}{16}%
    \abovedisplayskip 14pt plus 3pt minus 7pt%
    \abovedisplayshortskip 0pt plus 4pt%
    \belowdisplayshortskip 7pt plus 4pt minus 3pt%
    \belowdisplayskip \abovedisplayskip}
\renewcommand\small{\@setfontsize\small\@xiipt{14}%
    \abovedisplayskip 12pt plus 3pt minus 7pt%
    \abovedisplayshortskip 0pt plus 3pt%
    \belowdisplayshortskip 6pt plus 3pt minus 3pt%
    \belowdisplayskip \abovedisplayskip}
\renewcommand\footnotesize{\@setfontsize\footnotesize\@xpt\@xiipt}
\renewcommand\scriptsize{\@setfontsize\scriptsize\@viiipt{9.5}}
\renewcommand\tiny{\@setfontsize\tiny\@vipt\@viipt}
\renewcommand\large{\@setfontsize\large\@xviipt{22}}
\renewcommand\Large{\@setfontsize\Large\@xxpt{25}}
\renewcommand\LARGE{\@setfontsize\LARGE\@xxvpt{30}}
\renewcommand\huge{\@setfontsize\huge{30}{35}}
\renewcommand\Huge{\@setfontsize\Huge{36}{40}}
\normalsize
\linespread{1.3}
\setlength\parskip{0pt}
\setlength\parindent{12.5mm}
\def\ps@plain{\let\@mkboth\@gobbletwo
     \let\@oddhead\@empty\def\@oddfoot{\hfil\rmfamily\thepage
     \hfil}\let\@evenhead\@empty\let\@evenfoot\@oddfoot}
\pagestyle{plain}
\renewcommand\section{\clearpage\@startsection{section}{1}{\parindent}%
        {0pt}{1sp}{\normalfont\normalsize\bfseries}}
\renewcommand\subsection{\@startsection{subsection}{2}{\parindent}%
    {0pt}{1sp}{\normalfont\normalsize\bfseries}}
\setcounter{secnumdepth}{4}
\renewcommand\paragraph{\@startparagraph{paragraph}{3}}
\renewcommand\subparagraph{\@startparagraph{subparagraph}{4}}
\def\@startparagraph#1#2{
    \if #2>\c@secnumdepth%
    \else%
    \refstepcounter{#1}%
    \fi%
    \@ifstar{{}\unnamed@paragraph{#1}{#2}}{\@dblarg{\named@paragraph{#1}{#2}}}%
}
\def\named@paragraph#1#2[#3]#4{%
    \addcontentsline{toc}{#1}{%
        \protect\numberline{%
            \csname the#1\endcsname\space}%
            #3%
    }%\par
    \def\otu@partitle{{#4}}%
    \paragraph@heading{#1}%
}
\def\unnamed@paragraph#1#2{
    \let\otu@partitle\@empty%
    \paragraph@heading{#1}%
}
\def\paragraph@heading#1{%
    \@nobreakfalse
    \global\@noskipsectrue
    \everypar{%
      \if@noskipsec
        \global\@noskipsecfalse
       {\setbox\z@\lastbox}%
        \clubpenalty\@M
        \begingroup%
            \hskip\parindent%
            \normalfont\normalsize\bfseries
            \csname the#1\endcsname\,%
            \ifx\otu@partitle\empty\relax\else\otu@partitle\relax\fi\,%
        \endgroup
        \unskip
      \else
        \clubpenalty \@clubpenalty
        \everypar{}%
      \fi}%
    \ignorespaces%
}
\counterwithout{paragraph}{subsubsection}
\counterwithout{subsubsection}{subsection}
\counterwithout{subsubsection}{section}
\counterwithin{paragraph}{subsection}
\renewcommand\theparagraph{\thesubsection.\@arabic\c@paragraph}
\renewcommand\thesubparagraph{\theparagraph.\@arabic\c@subparagraph}
\let\subsubsection\@@@undefined@@@
\let\l@subsubsection\@@@undefined@@@
\let\c@subsubsection\@@@undefined@@@
\renewcommand*\l@section[2]{\@dottedtocline{1}{0em}{1em}{\textbf{#1}}{#2}}
\renewcommand*\l@subsection{\@dottedtocline{2}{2ex}{2em}}
\renewcommand*\l@paragraph{\@dottedtocline{3}{4ex}{3em}}
\RequirePackage[sorting=none,bibstyle=omgtudoc-asoiu-gost-numeric,%
citestyle=gost-numeric]{biblatex}
\def\centered@heading#1{%
    \clearpage%
    \par%
    \addcontentsline{toc}{section}{#1}%
    \begingroup%
    \centering\normalfont\normalsize\bfseries\MakeUppercase%
    {\hfill #1 \hfill}
    \endgroup \par
}
\def\centered@heading@nontoc#1{%
    \begingroup%
    \centering\normalfont\normalsize\bfseries\MakeUppercase%
    {\hfill #1 \hfill}
    \endgroup \par
}
\newcommand{\preface}{\centered@heading{Введение}}
\newcommand{\conclusion}{\centered@heading{Заключение}}
\newcommand{\abbreviations}{\centered@heading{Перечень сокращений и
обозначений}}
\newcommand{\terms}{\centered@heading{Термины и определения}}
\newcommand{\termsandabbrev}{\centered@heading{Определения,
сокращения и обозначения}}
\renewcommand\tableofcontents{%
    \centered@heading@nontoc{\contentsname}%
    \@starttoc{toc}%
    }
\defbibheading{otuasoiubibliography}[\bibname]{%
    \centered@heading{#1}}
\DeclarePrintbibliographyDefaults{heading=otuasoiubibliography}
\RequirePackage{amsmath}
\if@within@section
\numberwithin{equation}{section}
\counterwithin{table}{section}
\counterwithin{figure}{section}
\fi
\RequirePackage{totcount}
\RequirePackage{assoccnt}
\RequirePackage{xspace}
\newtotcounter{@figures}
\regtotcounter{figure}
\DeclareAssociatedCounters{figure}{@figures}
\newcommand\totalfigures{\total{@figures}\xspace}
\newtotcounter{@tables}
\regtotcounter{table}
\DeclareAssociatedCounters{table}{@tables}
\newcommand\totaltables{\total{@tables}\xspace}
\newtotcounter{@appendices}
\setcounter{@appendices}{0}
\DeclareAssociatedCounters{appendix}{@appendices}
\newcommand\totalappendices{\total{@appendices}\xspace}
\newtotcounter{@equations}
\DeclareAssociatedCounters{equation}{@equations}
\newcommand\totalequations{\total{@equations}\xspace}
\regtotcounter{page}
\newcommand\totalpages{\total{page}\xspace}
\newtotcounter{@sourceref}
\AtEveryBibitem{\stepcounter{@sourceref}}
\newcommand\totalsources{\total{@sourceref}\xspace}
\def\gostasbuk@Alph#1{\ifcase#1\or
   А\or Б\or В\or Г\or Д\or Е\or Ж\or
   И\or К\or Л\or М\or Н\or П\or Р\or
   С\or Т\or У\or Ф\or Х\or Ц\or Ш\or
   Щ\or Э\or Ю\or Я%
   \else\ClassError{omgtudoc-asoiu}{Invalid value of counter}\fi
}
\def\GostAsbuk#1{\expandafter\gostasbuk@Alph\csname c@#1\endcsname}
\newtotcounter{appendix}
\newcommand\appendices{%
    \counterwithin{section}{appendix}%
    \addtocontents{toc}{\setcounter{tocdepth}{0}}%
    \renewcommand\thesection{\theappendix.\arabic{section}}%
    \renewcommand\section{\@startsection{section}{1}{\parindent}%
        {0pt}{1sp}{\normalfont\normalsize\bfseries}}%
    \renewcommand\theappendix{\GostAsbuk{appendix}}%
    \counterwithout{equation}{section}%
    \counterwithout{figure}{section}%
    \counterwithout{table}{section}%
    \numberwithin{equation}{appendix}%
    \counterwithin{figure}{appendix}%
    \counterwithin{table}{appendix}
}
\def\@startappendix#1#2{
    \clearpage%
    \SuspendCounters{@figures}%
    \SuspendCounters{@tables}%
    \SuspendCounters{@equations}%
    \refstepcounter{appendix}%
    \ResumeSuspendedCounters%
    \addcontentsline{toc}{appendix}{Приложение \theappendix\space (#1) #2}%
    \begingroup
    \centering\normalfont\normalsize\bfseries%
    ПРИЛОЖЕНИЕ \theappendix{}\\
    \centering ({#1})\\
    \centering {\hfill #2 \hfill}
    \endgroup
    \par
}
\renewcommand{\appendix}{\@startappendix{обязательное}}
\newcommand{\appendixhelp}{\@startappendix{справочное}}
\newcommand{\appendixrec}{\@startappendix{рекомендуемое}}
\newcommand*\l@appendix[2]{\@dottedtocline{0}{0em}{3em}{\textbf{#1}}{#2}}
\RequirePackage{etoolbox}
\renewcommand\maketitle{%
    \ifcsdef{@titlepage@template}{\@titlepage@template%
    \thispagestyle{empty}%
    \newpage}{}
}
\setlength\leftmargini{0pt}
\setlength\leftmarginii{0pt}
\setlength\leftmarginiii{0pt}
\setlength\leftmarginiv{0pt}
\setlength\leftmarginv{0pt}
\setlength\leftmarginvi{0pt}
\setlength\labelwidth{0pt}
\setlength\labelsep{0pt}
\def\@listI{\leftmargin=\leftmargini
            \itemindent\parindent
            \listparindent\parindent
            \itemsep=0pt
            \parsep=0pt
            \topsep=0pt}
\let\@listi\@listI
\def\@listii{\leftmargin=\leftmarginii
            \itemindent\parindent
            \listparindent\parindent
            \itemsep=0pt
            \parsep=0pt
            \topsep=0pt}
\def\@listiii{\leftmargin=\leftmarginiii
            \itemindent\parindent
            \listparindent\parindent
            \itemsep=0pt
            \parsep=0pt
            \topsep=0pt}
\def\@listiv{\leftmargin=\leftmarginiv
            \itemindent\parindent
            \listparindent\parindent
            \itemsep=0pt
            \parsep=0pt
            \topsep=0pt}
\def\@listv{\leftmargin=\leftmarginv
            \itemindent\parindent
            \listparindent\parindent
            \itemsep=0pt
            \parsep=0pt
            \topsep=0pt}
\def\@listvi{\leftmargin=\leftmarginvi
            \itemindent\parindent
            \listparindent\parindent
            \itemsep=0pt
            \parsep=0pt
            \topsep=0pt}
\def\gostasbuk@alph#1{\ifcase#1\or
   а\or б\or в\or г\or д\or е\or ж\or
   и\or к\or л\or м\or н\or п\or р\or
   с\or т\or у\or ф\or х\or ц\or ш\or
   щ\or э\or ю\or я%
   \else\ClassError{omgtudoc-asoiu}{Invalid value of counter}\fi
}
\def\gostasbuk#1{\expandafter\gostasbuk@alph\csname c@#1\endcsname}
\def\itemize{%
  \ifnum \@itemdepth >\thr@@\@toodeep\else
    \advance\@itemdepth\@ne
    \edef\@itemitem{labelitem\romannumeral\the\@itemdepth}%
    \expandafter
    \list
      \csname\@itemitem\endcsname
      {\def\makelabel##1{##1~}}%
  \fi}
\def\enumerate{%
  \ifnum \@enumdepth >\thr@@\@toodeep\else
    \advance\@enumdepth\@one
    \edef\@enumctr{enum\romannumeral\the\@enumdepth}%
    \expandafter
    \list
      \csname label\@enumctr\endcsname
      {\usecounter\@enumctr\def\makelabel##1{##1~}}%
  \fi}
\renewcommand\labelitemi{---}
\renewcommand\labelitemii{---}
\renewcommand\labelitemiii{---}
\renewcommand\labelitemiv{---}
\renewcommand\theenumi{\gostasbuk{enumi}}
\renewcommand\theenumii{\gostasbuk{enumii}}
\renewcommand\theenumiii{\gostasbuk{enumii}}
\renewcommand\theenumiv{\gostasbuk{enumii}}
\renewcommand\labelenumi{\theenumi)}
\renewcommand\labelenumii{\theenumii)}
\renewcommand\labelenumiii{\theenumiii)}
\renewcommand\labelenumiv{\theenumiv)}
\endinput
%%
%% End of file `omgtudoc-asoiu.cls'.
