/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.PerReplicaStates;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.KeeperException;

public class ClusterStatus {
    private final ZkStateReader zkStateReader;
    private final SolrParams solrParams;
    private final String collection;
    public static final String INCLUDE_ALL = "includeAll";
    public static final String LIVENODES_PROP = "liveNodes";
    public static final String CLUSTER_PROP = "clusterProperties";
    public static final String ALIASES_PROP = "aliases";

    public ClusterStatus(ZkStateReader zkStateReader, SolrParams params) {
        this.zkStateReader = zkStateReader;
        this.solrParams = params;
        this.collection = params.get("collection");
    }

    public void getClusterStatus(NamedList<Object> results) throws KeeperException, InterruptedException {
        SimpleOrderedMap clusterStatus = new SimpleOrderedMap();
        boolean includeAll = this.solrParams.getBool(INCLUDE_ALL, true);
        boolean withLiveNodes = this.solrParams.getBool(LIVENODES_PROP, includeAll);
        boolean withClusterProperties = this.solrParams.getBool(CLUSTER_PROP, includeAll);
        boolean withRoles = this.solrParams.getBool("roles", includeAll);
        boolean withCollection = includeAll || this.collection != null;
        boolean withAliases = this.solrParams.getBool(ALIASES_PROP, includeAll);
        List liveNodes = null;
        if (withLiveNodes || this.collection != null) {
            liveNodes = this.zkStateReader.getZkClient().getChildren("/live_nodes", null, true);
            if (withLiveNodes) {
                clusterStatus.add("live_nodes", (Object)liveNodes);
            }
        }
        Aliases aliases = null;
        if (withCollection || withAliases) {
            aliases = this.zkStateReader.getAliases();
        }
        if (withCollection) {
            assert (liveNodes != null);
            this.fetchClusterStatusForCollOrAlias((NamedList<Object>)clusterStatus, liveNodes, aliases);
        }
        if (withAliases) {
            this.addAliasMap(aliases, (NamedList<Object>)clusterStatus);
        }
        if (withClusterProperties) {
            Map clusterProps = this.zkStateReader.getClusterProperties();
            if (clusterProps == null) {
                clusterProps = Collections.emptyMap();
            }
            clusterStatus.add("properties", clusterProps);
        }
        if (withRoles) {
            Map roles = Collections.emptyMap();
            if (this.zkStateReader.getZkClient().exists("/roles.json", true).booleanValue()) {
                roles = (Map)Utils.fromJSON((byte[])this.zkStateReader.getZkClient().getData("/roles.json", null, null, true));
            }
            clusterStatus.add("roles", roles);
        }
        results.add("cluster", (Object)clusterStatus);
    }

    private void fetchClusterStatusForCollOrAlias(NamedList<Object> clusterStatus, List<String> liveNodes, Aliases aliases) {
        Stream<DocCollection> collectionStream;
        HashMap<String, List> collectionVsAliases = new HashMap<String, List>();
        Map aliasVsCollections = aliases.getCollectionAliasListMap();
        for (Map.Entry entry : aliasVsCollections.entrySet()) {
            String alias = (String)entry.getKey();
            List colls = (List)entry.getValue();
            for (String coll : colls) {
                if (this.collection != null && !this.collection.equals(coll)) continue;
                List list = collectionVsAliases.computeIfAbsent(coll, k -> new ArrayList());
                list.add(alias);
            }
        }
        ClusterState clusterState = this.zkStateReader.getClusterState();
        String routeKey = this.solrParams.get("_route_");
        String shard = this.solrParams.get("shard");
        if (this.collection == null) {
            collectionStream = clusterState.collectionStream();
        } else {
            DocCollection collState = clusterState.getCollectionOrNull(this.collection);
            if (collState != null) {
                collectionStream = Stream.of(collState);
            } else {
                if (!aliasVsCollections.containsKey(this.collection)) {
                    SolrException solrException = new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + this.collection + " not found");
                    solrException.setMetadata("CLUSTERSTATUS", "NOT_FOUND");
                    throw solrException;
                }
                collectionStream = ((List)aliasVsCollections.get(this.collection)).stream().map(arg_0 -> ((ClusterState)clusterState).getCollectionOrNull(arg_0)).filter(Objects::nonNull);
            }
        }
        SimpleOrderedMap collectionProps = new SimpleOrderedMap();
        collectionStream.forEach(arg_0 -> this.lambda$fetchClusterStatusForCollOrAlias$1(routeKey, shard, collectionVsAliases, (NamedList)collectionProps, arg_0));
        this.crossCheckReplicaStateWithLiveNodes(liveNodes, (NamedList<Object>)collectionProps);
        clusterStatus.add("collections", (Object)collectionProps);
    }

    private void addAliasMap(Aliases aliases, NamedList<Object> clusterStatus) {
        Map collectionAliasMap = aliases.getCollectionAliasMap();
        if (!collectionAliasMap.isEmpty()) {
            clusterStatus.add(ALIASES_PROP, (Object)collectionAliasMap);
        }
    }

    private Map<String, Object> getCollectionStatus(Map<String, Object> collection, String name, Set<String> requestedShards) {
        if (collection == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + name + " not found");
        }
        if (requestedShards == null || requestedShards.isEmpty()) {
            return ClusterStatus.postProcessCollectionJSON(collection);
        }
        Map shards = (Map)collection.get("shards");
        HashMap selected = new HashMap();
        for (String selectedShard : requestedShards) {
            if (!shards.containsKey(selectedShard)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + name + " shard: " + selectedShard + " not found");
            }
            selected.put(selectedShard, shards.get(selectedShard));
            collection.put("shards", selected);
        }
        return ClusterStatus.postProcessCollectionJSON(collection);
    }

    protected void crossCheckReplicaStateWithLiveNodes(List<String> liveNodes, NamedList<Object> collectionProps) {
        for (Map.Entry next : collectionProps) {
            Map collMap = (Map)next.getValue();
            Map shards = (Map)collMap.get("shards");
            for (Object nextShard : shards.values()) {
                Map shardMap = (Map)nextShard;
                Map replicas = (Map)shardMap.get("replicas");
                for (Object nextReplica : replicas.values()) {
                    String node_name;
                    Map replicaMap = (Map)nextReplica;
                    if (Replica.State.getState((String)((String)replicaMap.get("state"))) == Replica.State.DOWN || liveNodes.contains(node_name = (String)replicaMap.get("node_name"))) continue;
                    replicaMap.put("state", Replica.State.DOWN.toString());
                }
            }
        }
    }

    public static Map<String, Object> postProcessCollectionJSON(Map<String, Object> collection) {
        Map<String, Map> shards = collection != null ? collection.getOrDefault("shards", Collections.emptyMap()) : Collections.emptyMap();
        ArrayList<Health> healthStates = new ArrayList<Health>(shards.size());
        shards.forEach((shardName, s) -> {
            Map replicas = s.getOrDefault("replicas", Collections.emptyMap());
            int[] totalVsActive = new int[2];
            boolean hasLeader = false;
            for (Map r : replicas.values()) {
                totalVsActive[0] = totalVsActive[0] + 1;
                boolean active = false;
                if (Replica.State.ACTIVE.toString().equals(r.get("state"))) {
                    totalVsActive[1] = totalVsActive[1] + 1;
                    active = true;
                }
                if (!"true".equals(r.get("leader")) || !active) continue;
                hasLeader = true;
            }
            float ratioActive = totalVsActive[0] == 0 ? 0.0f : (float)totalVsActive[1] / (float)totalVsActive[0];
            Health health = Health.calcShardHealth(ratioActive, hasLeader);
            s.put("health", health.toString());
            healthStates.add(health);
        });
        collection.put("health", Health.combine(healthStates).toString());
        return collection;
    }

    private /* synthetic */ void lambda$fetchClusterStatusForCollOrAlias$1(String routeKey, String shard, Map collectionVsAliases, NamedList collectionProps, DocCollection clusterStateCollection) {
        String name = clusterStateCollection.getName();
        HashSet<String> requestedShards = new HashSet<String>();
        if (routeKey != null) {
            DocRouter router = clusterStateCollection.getRouter();
            Collection slices = router.getSearchSlices(routeKey, null, clusterStateCollection);
            for (Slice slice : slices) {
                requestedShards.add(slice.getName());
            }
        }
        if (shard != null) {
            String[] paramShards = shard.split(",");
            requestedShards.addAll(Arrays.asList(paramShards));
        }
        byte[] bytes = Utils.toJSON((Object)clusterStateCollection);
        Map docCollection = (Map)Utils.fromJSON((byte[])bytes);
        Map<String, Object> collectionStatus = this.getCollectionStatus(docCollection, name, requestedShards);
        collectionStatus.put("znodeVersion", clusterStateCollection.getZNodeVersion());
        collectionStatus.put("creationTimeMillis", clusterStateCollection.getCreationTime().toEpochMilli());
        if (collectionVsAliases.containsKey(name) && !((List)collectionVsAliases.get(name)).isEmpty()) {
            collectionStatus.put(ALIASES_PROP, collectionVsAliases.get(name));
        }
        String configName = clusterStateCollection.getConfigName();
        collectionStatus.put("configName", configName);
        if (this.solrParams.getBool("prs", false) && clusterStateCollection.isPerReplicaState()) {
            PerReplicaStates prs = clusterStateCollection.getPerReplicaStates();
            collectionStatus.put("PRS", prs);
        }
        collectionProps.add(name, collectionStatus);
    }

    public static enum Health {
        GREEN,
        YELLOW,
        ORANGE,
        RED;

        public static final float ORANGE_LEVEL = 0.5f;
        public static final float RED_LEVEL = 0.0f;

        public static Health calcShardHealth(float fractionReplicasUp, boolean hasLeader) {
            if (hasLeader) {
                if (fractionReplicasUp == 1.0f) {
                    return GREEN;
                }
                if (fractionReplicasUp > 0.5f) {
                    return YELLOW;
                }
                if (fractionReplicasUp > 0.0f) {
                    return ORANGE;
                }
                return RED;
            }
            return RED;
        }

        public static Health combine(Collection<Health> states) {
            Health res = GREEN;
            for (Health state : states) {
                if (state.ordinal() <= res.ordinal()) continue;
                res = state;
            }
            return res;
        }
    }
}

