/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DeprecatedAttributes;
import org.apache.commons.cli.Option;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.file.PathUtils;
import org.apache.solr.cli.CLIO;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudHttp2SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.JsonMapResponseParser;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.client.solrj.response.CoreAdminResponse;
import org.apache.solr.cloud.ZkConfigSetService;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.EnvUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.ConfigSetService;
import org.noggit.CharArr;
import org.noggit.JSONWriter;

public class CreateTool
extends ToolBase {
    public CreateTool() {
        this(CLIO.getOutStream());
    }

    public CreateTool(PrintStream stdout) {
        super(stdout);
    }

    @Override
    public String getName() {
        return "create";
    }

    @Override
    public String getHeader() {
        return "Creates a core or collection depending on whether Solr is running in standalone (core) or SolrCloud mode (collection).\nIf you are using standalone mode you must run this command on the Solr server itself.\n\nList of options:";
    }

    @Override
    public List<Option> getOptions() {
        return List.of(Option.builder((String)"c").longOpt("name").hasArg().argName("NAME").required(true).desc("Name of collection or core to create.").build(), Option.builder((String)"sh").longOpt("shards").hasArg().argName("#").desc("Number of shards; default is 1.").build(), Option.builder((String)"rf").longOpt("replication-factor").hasArg().argName("#").desc("Number of copies of each document across the collection (replicas per shard); default is 1.").build(), Option.builder((String)"replicationFactor").longOpt("replicationFactor").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.7").setDescription("Use --replication-factor instead").get()).hasArg().argName("#").required(false).desc("Number of copies of each document across the collection (replicas per shard); default is 1.").build(), Option.builder((String)"d").longOpt("conf-dir").argName("DIR").hasArg().desc("Configuration directory to copy when creating the new collection; default is _default.").build(), Option.builder((String)"confdir").longOpt("confdir").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.7").setDescription("Use --conf-dir instead").get()).argName("DIR").hasArg().required(false).desc("Configuration directory to copy when creating the new collection; default is _default.").build(), Option.builder((String)"n").longOpt("conf-name").argName("NAME").hasArg().required(false).desc("Configuration name; default is the collection name.").build(), Option.builder((String)"confname").longOpt("confname").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.7").setDescription("Use --conf-name instead").get()).argName("NAME").hasArg().required(false).desc("Configuration name; default is the collection name.").build(), Option.builder((String)"p").longOpt("port").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.7").setDescription("Use --solr-url instead").get()).argName("PORT").hasArg().required(false).desc("Port of a local Solr instance where you want to create the new core.").build(), SolrCLI.OPTION_SOLRURL, SolrCLI.OPTION_SOLRURL_DEPRECATED, SolrCLI.OPTION_SOLRURL_DEPRECATED_SHORT, SolrCLI.OPTION_ZKHOST, SolrCLI.OPTION_ZKHOST_DEPRECATED, SolrCLI.OPTION_VERBOSE_DEPRECATED);
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        SolrCLI.raiseLogLevelUnlessVerbose(cli);
        if (cli.hasOption("p")) {
            EnvUtils.setProperty((String)"jetty.port", (String)cli.getOptionValue("p"));
        }
        try (SolrClient solrClient = SolrCLI.getSolrClient(cli);){
            if (SolrCLI.isCloudMode(solrClient)) {
                this.createCollection(cli);
            } else {
                this.createCore(cli, solrClient);
            }
        }
    }

    protected void createCore(CommandLine cli, SolrClient solrClient) throws Exception {
        String coreName = cli.getOptionValue("name");
        String solrUrl = SolrCLI.getOptionWithDeprecatedAndDefault(cli, "solr-url", "solrUrl", SolrCLI.getDefaultSolrUrl());
        String solrInstallDir = System.getProperty("solr.install.dir");
        String confDirName = SolrCLI.getOptionWithDeprecatedAndDefault(cli, "conf-dir", "confdir", "_default");
        Path configsetDir = Paths.get(confDirName, new String[0]);
        Path solrInstallDirPath = Paths.get(solrInstallDir, new String[0]);
        if (!Files.isDirectory(configsetDir, new LinkOption[0])) {
            this.ensureConfDirExists(solrInstallDirPath, configsetDir);
        }
        this.printDefaultConfigsetWarningIfNecessary(cli);
        NamedList systemInfo = solrClient.request((SolrRequest)new GenericSolrRequest(SolrRequest.METHOD.GET, "/admin/info/system"));
        String coreRootDirectory = (String)systemInfo.get("core_root");
        if (SolrCLI.safeCheckCoreExists(solrUrl, coreName)) {
            throw new IllegalArgumentException("\nCore '" + coreName + "' already exists!\nChecked core existence using Core API command");
        }
        Path coreInstanceDir = Paths.get(coreRootDirectory, coreName);
        Path confDir = this.getFullConfDir(solrInstallDirPath, configsetDir).resolve("conf");
        if (!Files.isDirectory(coreInstanceDir, new LinkOption[0])) {
            Files.createDirectories(coreInstanceDir, new FileAttribute[0]);
            if (!Files.isDirectory(coreInstanceDir, new LinkOption[0])) {
                throw new IOException("Failed to create new core instance directory: " + coreInstanceDir.toAbsolutePath());
            }
            FileUtils.copyDirectoryToDirectory((File)confDir.toFile(), (File)coreInstanceDir.toFile());
            this.echoIfVerbose("\nCopying configuration to new core instance directory:\n" + coreInstanceDir.toAbsolutePath(), cli);
        }
        this.echoIfVerbose("\nCreating new core '" + coreName + "' using CoreAdminRequest", cli);
        try {
            CoreAdminResponse res = CoreAdminRequest.createCore((String)coreName, (String)coreName, (SolrClient)solrClient);
            if (this.verbose) {
                this.echo(res.jsonStr());
                this.echo("\n");
            }
            this.echo(String.format(Locale.ROOT, "\nCreated new core '%s'", coreName));
        }
        catch (Exception e) {
            PathUtils.deleteDirectory((Path)coreInstanceDir);
            throw e;
        }
    }

    protected void createCollection(CommandLine cli) throws Exception {
        Http2SolrClient.Builder builder = ((Http2SolrClient.Builder)((Http2SolrClient.Builder)new Http2SolrClient.Builder().withIdleTimeout(30L, TimeUnit.SECONDS)).withConnectionTimeout(15L, TimeUnit.SECONDS)).withKeyStoreReloadInterval(-1L, TimeUnit.SECONDS);
        String zkHost = SolrCLI.getZkHost(cli);
        try (CloudHttp2SolrClient cloudSolrClient = SolrCLI.getCloudHttp2SolrClient(zkHost, builder);){
            this.echoIfVerbose("Connecting to ZooKeeper at " + zkHost, cli);
            cloudSolrClient.connect();
            this.createCollection((CloudSolrClient)cloudSolrClient, cli);
        }
    }

    protected void createCollection(CloudSolrClient cloudSolrClient, CommandLine cli) throws Exception {
        NamedList response;
        boolean configExistsInZk;
        String collectionName = cli.getOptionValue("name");
        String solrInstallDir = System.getProperty("solr.install.dir");
        String confName = SolrCLI.getOptionWithDeprecatedAndDefault(cli, "conf-name", "confname", null);
        String confDir = SolrCLI.getOptionWithDeprecatedAndDefault(cli, "conf-dir", "confdir", "_default");
        Path solrInstallDirPath = Paths.get(solrInstallDir, new String[0]);
        Path confDirPath = Paths.get(confDir, new String[0]);
        this.ensureConfDirExists(solrInstallDirPath, confDirPath);
        this.printDefaultConfigsetWarningIfNecessary(cli);
        Set liveNodes = cloudSolrClient.getClusterState().getLiveNodes();
        if (liveNodes.isEmpty()) {
            throw new IllegalStateException("No live nodes found! Cannot create a collection until there is at least 1 live node in the cluster.");
        }
        String solrUrl = SolrCLI.getOptionWithDeprecatedAndDefault(cli, "solr-url", "solrUrl", null);
        if (solrUrl == null) {
            String firstLiveNode = (String)liveNodes.iterator().next();
            solrUrl = ZkStateReader.from((CloudSolrClient)cloudSolrClient).getBaseUrlForNodeName(firstLiveNode);
        }
        int numShards = Integer.parseInt(cli.getOptionValue("shards", String.valueOf(1)));
        int replicationFactor = Integer.parseInt(SolrCLI.getOptionWithDeprecatedAndDefault(cli, "replication-factor", "replicationFactor", "1"));
        boolean bl = configExistsInZk = confName != null && !confName.trim().isEmpty() && ZkStateReader.from((CloudSolrClient)cloudSolrClient).getZkClient().exists("/configs/" + confName, true) != false;
        if (!".system".equals(collectionName)) {
            if (configExistsInZk) {
                this.echo("Re-using existing configuration directory " + confName);
            } else {
                if (confName == null || confName.trim().isEmpty()) {
                    confName = collectionName;
                }
                Path configsetsDirPath = SolrCLI.getConfigSetsDir(solrInstallDirPath);
                ZkConfigSetService configSetService = new ZkConfigSetService(ZkStateReader.from((CloudSolrClient)cloudSolrClient).getZkClient());
                Path confPath = ConfigSetService.getConfigsetPath(confDir, configsetsDirPath.toString());
                this.echoIfVerbose("Uploading " + confPath.toAbsolutePath() + " for config " + confName + " to ZooKeeper at " + cloudSolrClient.getClusterStateProvider().getQuorumHosts(), cli);
                configSetService.uploadConfig(confName, confPath, true);
            }
        }
        if (SolrCLI.safeCheckCollectionExists(solrUrl, collectionName)) {
            throw new IllegalStateException("\nCollection '" + collectionName + "' already exists!\nChecked collection existence using CollectionAdminRequest");
        }
        this.echoIfVerbose("\nCreating new collection '" + collectionName + "' using CollectionAdminRequest", cli);
        try {
            CollectionAdminRequest.Create req = CollectionAdminRequest.createCollection((String)collectionName, (String)confName, (int)numShards, (int)replicationFactor);
            req.setResponseParser((ResponseParser)new JsonMapResponseParser());
            response = cloudSolrClient.request((SolrRequest)req);
        }
        catch (SolrServerException sse) {
            throw new Exception("Failed to create collection '" + collectionName + "' due to: " + sse.getMessage());
        }
        if (this.verbose) {
            CharArr arr = new CharArr();
            new JSONWriter(arr, 2).write(response.asMap(10));
            this.echo(arr.toString());
        }
        Object endMessage = String.format(Locale.ROOT, "Created collection '%s' with %d shard(s), %d replica(s)", collectionName, numShards, replicationFactor);
        if (confName != null && !confName.trim().isEmpty()) {
            endMessage = (String)endMessage + String.format(Locale.ROOT, " with config-set '%s'", confName);
        }
        this.echo((String)endMessage);
    }

    private Path getFullConfDir(Path solrInstallDir, Path confDirName) {
        return SolrCLI.getConfigSetsDir(solrInstallDir).resolve(confDirName);
    }

    private void ensureConfDirExists(Path solrInstallDir, Path confDirName) {
        Path fullConfDir;
        if (!Files.isDirectory(confDirName, new LinkOption[0]) && !Files.isDirectory(fullConfDir = this.getFullConfDir(solrInstallDir, confDirName), new LinkOption[0])) {
            this.echo("Specified configuration directory " + confDirName + " not found!");
            System.exit(1);
        }
    }

    private void printDefaultConfigsetWarningIfNecessary(CommandLine cli) {
        String confDirectoryName = SolrCLI.getOptionWithDeprecatedAndDefault(cli, "conf-dir", "confdir", "_default");
        String confName = SolrCLI.getOptionWithDeprecatedAndDefault(cli, "conf-name", "confname", "");
        if (confDirectoryName.equals("_default") && (confName.equals("") || confName.equals("_default"))) {
            String collectionName = cli.getOptionValue("name");
            String solrUrl = SolrCLI.getOptionWithDeprecatedAndDefault(cli, "solr-url", "solrUrl", SolrCLI.getDefaultSolrUrl());
            String curlCommand = String.format(Locale.ROOT, "curl %s/solr/%s/config -d '{\"set-user-property\": {\"update.autoCreateFields\":\"false\"}}'", solrUrl, collectionName);
            String configCommand = String.format(Locale.ROOT, "bin/solr config -c %s -s %s --action set-user-property --property update.autoCreateFields --value false", collectionName, solrUrl);
            this.echo("WARNING: Using _default configset. Data driven schema functionality is enabled by default, which is");
            this.echo("         NOT RECOMMENDED for production use.");
            this.echo("");
            this.echo("         To turn it off:");
            this.echo("            " + curlCommand);
            this.echo("         Or:");
            this.echo("            " + configCommand);
        }
    }
}

