/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.boxes.iso23001.part7;

import java.math.BigInteger;
import java.util.Arrays;
import org.mp4parser.tools.Hex;

public class CencSampleAuxiliaryDataFormat {
    public byte[] iv = new byte[0];
    public Pair[] pairs = null;

    public int getSize() {
        int size = this.iv.length;
        if (this.pairs != null && this.pairs.length > 0) {
            size += 2;
            size += this.pairs.length * 6;
        }
        return size;
    }

    public Pair createPair(int clear, long encrypted) {
        if (clear <= 127) {
            if (encrypted <= 127L) {
                return new ByteBytePair(clear, encrypted);
            }
            if (encrypted <= 32767L) {
                return new ByteShortPair(clear, encrypted);
            }
            if (encrypted <= Integer.MAX_VALUE) {
                return new ByteIntPair(clear, encrypted);
            }
            return new ByteLongPair(clear, encrypted);
        }
        if (clear <= Short.MAX_VALUE) {
            if (encrypted <= 127L) {
                return new ShortBytePair(clear, encrypted);
            }
            if (encrypted <= 32767L) {
                return new ShortShortPair(clear, encrypted);
            }
            if (encrypted <= Integer.MAX_VALUE) {
                return new ShortIntPair(clear, encrypted);
            }
            return new ShortLongPair(clear, encrypted);
        }
        if (encrypted <= 127L) {
            return new IntBytePair(clear, encrypted);
        }
        if (encrypted <= 32767L) {
            return new IntShortPair(clear, encrypted);
        }
        if (encrypted <= Integer.MAX_VALUE) {
            return new IntIntPair(clear, encrypted);
        }
        return new IntLongPair(clear, encrypted);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CencSampleAuxiliaryDataFormat entry = (CencSampleAuxiliaryDataFormat)o;
        if (!new BigInteger(this.iv).equals(new BigInteger(entry.iv))) {
            return false;
        }
        return !(this.pairs != null ? !Arrays.equals(this.pairs, entry.pairs) : entry.pairs != null);
    }

    public int hashCode() {
        int result = this.iv != null ? Arrays.hashCode(this.iv) : 0;
        result = 31 * result + (this.pairs != null ? Arrays.hashCode(this.pairs) : 0);
        return result;
    }

    public String toString() {
        return "Entry{iv=" + Hex.encodeHex(this.iv) + ", pairs=" + Arrays.toString(this.pairs) + '}';
    }

    private abstract class AbstractPair
    implements Pair {
        private AbstractPair() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pair pair = (Pair)o;
            if (this.clear() != pair.clear()) {
                return false;
            }
            return this.encrypted() == pair.encrypted();
        }

        public String toString() {
            return "P(" + this.clear() + "|" + this.encrypted() + ")";
        }
    }

    private class ByteBytePair
    extends AbstractPair {
        private byte clear;
        private byte encrypted;

        public ByteBytePair(int clear, long encrypted) {
            this.clear = (byte)clear;
            this.encrypted = (byte)encrypted;
        }

        @Override
        public int clear() {
            return this.clear;
        }

        @Override
        public long encrypted() {
            return this.encrypted;
        }
    }

    private class ByteIntPair
    extends AbstractPair {
        private byte clear;
        private int encrypted;

        public ByteIntPair(int clear, long encrypted) {
            this.clear = (byte)clear;
            this.encrypted = (int)encrypted;
        }

        @Override
        public int clear() {
            return this.clear;
        }

        @Override
        public long encrypted() {
            return this.encrypted;
        }
    }

    private class ByteLongPair
    extends AbstractPair {
        private byte clear;
        private long encrypted;

        public ByteLongPair(int clear, long encrypted) {
            this.clear = (byte)clear;
            this.encrypted = encrypted;
        }

        @Override
        public int clear() {
            return this.clear;
        }

        @Override
        public long encrypted() {
            return this.encrypted;
        }
    }

    private class ByteShortPair
    extends AbstractPair {
        private byte clear;
        private short encrypted;

        public ByteShortPair(int clear, long encrypted) {
            this.clear = (byte)clear;
            this.encrypted = (short)encrypted;
        }

        @Override
        public int clear() {
            return this.clear;
        }

        @Override
        public long encrypted() {
            return this.encrypted;
        }
    }

    private class IntBytePair
    extends AbstractPair {
        private int clear;
        private byte encrypted;

        public IntBytePair(int clear, long encrypted) {
            this.clear = clear;
            this.encrypted = (byte)encrypted;
        }

        @Override
        public int clear() {
            return this.clear;
        }

        @Override
        public long encrypted() {
            return this.encrypted;
        }
    }

    private class IntIntPair
    extends AbstractPair {
        private int clear;
        private int encrypted;

        public IntIntPair(int clear, long encrypted) {
            this.clear = clear;
            this.encrypted = (int)encrypted;
        }

        @Override
        public int clear() {
            return this.clear;
        }

        @Override
        public long encrypted() {
            return this.encrypted;
        }
    }

    private class IntLongPair
    extends AbstractPair {
        private int clear;
        private long encrypted;

        public IntLongPair(int clear, long encrypted) {
            this.clear = clear;
            this.encrypted = encrypted;
        }

        @Override
        public int clear() {
            return this.clear;
        }

        @Override
        public long encrypted() {
            return this.encrypted;
        }
    }

    private class IntShortPair
    extends AbstractPair {
        private int clear;
        private short encrypted;

        public IntShortPair(int clear, long encrypted) {
            this.clear = clear;
            this.encrypted = (short)encrypted;
        }

        @Override
        public int clear() {
            return this.clear;
        }

        @Override
        public long encrypted() {
            return this.encrypted;
        }
    }

    public static interface Pair {
        public int clear();

        public long encrypted();
    }

    private class ShortBytePair
    extends AbstractPair {
        private short clear;
        private byte encrypted;

        public ShortBytePair(int clear, long encrypted) {
            this.clear = (short)clear;
            this.encrypted = (byte)encrypted;
        }

        @Override
        public int clear() {
            return this.clear;
        }

        @Override
        public long encrypted() {
            return this.encrypted;
        }
    }

    private class ShortIntPair
    extends AbstractPair {
        private short clear;
        private int encrypted;

        public ShortIntPair(int clear, long encrypted) {
            this.clear = (short)clear;
            this.encrypted = (int)encrypted;
        }

        @Override
        public int clear() {
            return this.clear;
        }

        @Override
        public long encrypted() {
            return this.encrypted;
        }
    }

    private class ShortLongPair
    extends AbstractPair {
        private short clear;
        private long encrypted;

        public ShortLongPair(int clear, long encrypted) {
            this.clear = (short)clear;
            this.encrypted = encrypted;
        }

        @Override
        public int clear() {
            return this.clear;
        }

        @Override
        public long encrypted() {
            return this.encrypted;
        }
    }

    private class ShortShortPair
    extends AbstractPair {
        private short clear;
        private short encrypted;

        public ShortShortPair(int clear, long encrypted) {
            this.clear = (short)clear;
            this.encrypted = (short)encrypted;
        }

        @Override
        public int clear() {
            return this.clear;
        }

        @Override
        public long encrypted() {
            return this.encrypted;
        }
    }
}

