/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.admin.kadmin.local;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.shaded.org.apache.kerby.KOptions;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.admin.kadmin.local.AdminHelper;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.admin.kadmin.local.LocalKadmin;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.common.EncryptionUtil;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.common.KrbUtil;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.identity.backend.BackendConfig;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.identity.backend.IdentityBackend;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.keytab.Keytab;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.request.KrbIdentity;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.server.KdcConfig;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.server.KdcSetting;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.server.KdcUtil;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.server.ServerSetting;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalKadminImpl
implements LocalKadmin {
    private static final Logger LOG = LoggerFactory.getLogger(LocalKadminImpl.class);
    private final ServerSetting serverSetting;
    private final IdentityBackend backend;

    public LocalKadminImpl(KdcConfig kdcConfig, BackendConfig backendConfig) throws KrbException {
        this.backend = KdcUtil.getBackend(backendConfig);
        this.serverSetting = new KdcSetting(kdcConfig, backendConfig);
    }

    public LocalKadminImpl(ServerSetting serverSetting) throws KrbException {
        this.backend = KdcUtil.getBackend(serverSetting.getBackendConfig());
        this.serverSetting = serverSetting;
    }

    public LocalKadminImpl(File confDir) throws KrbException {
        BackendConfig tmpBackendConfig;
        KdcConfig tmpKdcConfig = KdcUtil.getKdcConfig(confDir);
        if (tmpKdcConfig == null) {
            tmpKdcConfig = new KdcConfig();
        }
        if ((tmpBackendConfig = KdcUtil.getBackendConfig(confDir)) == null) {
            tmpBackendConfig = new BackendConfig();
        }
        this.serverSetting = new KdcSetting(tmpKdcConfig, tmpBackendConfig);
        this.backend = KdcUtil.getBackend(tmpBackendConfig);
    }

    public LocalKadminImpl(KdcSetting kdcSetting, IdentityBackend backend) {
        this.serverSetting = kdcSetting;
        this.backend = backend;
    }

    private String getTgsPrincipal() {
        return KrbUtil.makeTgsPrincipal(this.serverSetting.getKdcRealm()).getName();
    }

    @Override
    public String getKadminPrincipal() {
        return KrbUtil.makeKadminPrincipal(this.serverSetting.getKdcRealm()).getName();
    }

    @Override
    public void checkBuiltinPrincipals() throws KrbException {
        String tgsPrincipal = this.getTgsPrincipal();
        String kadminPrincipal = this.getKadminPrincipal();
        if (this.backend.getIdentity(tgsPrincipal) == null || this.backend.getIdentity(kadminPrincipal) == null) {
            String errorMsg = "The built-in principals do not exist in the backend, please run the kdcinit tool.";
            LOG.error(errorMsg);
            throw new KrbException(errorMsg);
        }
    }

    @Override
    public void createBuiltinPrincipals() throws KrbException {
        String tgsPrincipal = this.getTgsPrincipal();
        if (this.backend.getIdentity(tgsPrincipal) != null) {
            String errorMsg = "The tgs principal already exists in backend.";
            LOG.error(errorMsg);
            throw new KrbException(errorMsg);
        }
        this.addPrincipal(tgsPrincipal);
        String kadminPrincipal = this.getKadminPrincipal();
        if (this.backend.getIdentity(kadminPrincipal) != null) {
            String errorMsg = "The kadmin principal already exists in backend.";
            LOG.error(errorMsg);
            throw new KrbException(errorMsg);
        }
        this.addPrincipal(kadminPrincipal);
    }

    @Override
    public void deleteBuiltinPrincipals() throws KrbException {
        this.deletePrincipal(this.getTgsPrincipal());
        this.deletePrincipal(this.getKadminPrincipal());
    }

    @Override
    public KdcConfig getKdcConfig() {
        return this.serverSetting.getKdcConfig();
    }

    @Override
    public BackendConfig getBackendConfig() {
        return this.serverSetting.getBackendConfig();
    }

    @Override
    public IdentityBackend getIdentityBackend() {
        return this.backend;
    }

    @Override
    public void addPrincipal(String principal) throws KrbException {
        principal = this.fixPrincipal(principal);
        this.addPrincipal(principal, new KOptions());
    }

    @Override
    public void addPrincipal(String principal, KOptions kOptions) throws KrbException {
        principal = this.fixPrincipal(principal);
        KrbIdentity identity = AdminHelper.createIdentity(principal, kOptions);
        List<EncryptionKey> keys = EncryptionUtil.generateKeys(this.getKdcConfig().getEncryptionTypes());
        identity.addKeys(keys);
        this.backend.addIdentity(identity);
    }

    @Override
    public void addPrincipal(String principal, String password) throws KrbException {
        principal = this.fixPrincipal(principal);
        this.addPrincipal(principal, password, new KOptions());
    }

    @Override
    public void addPrincipal(String principal, String password, KOptions kOptions) throws KrbException {
        principal = this.fixPrincipal(principal);
        KrbIdentity identity = AdminHelper.createIdentity(principal, kOptions);
        List<EncryptionKey> keys = EncryptionUtil.generateKeys(principal, password, this.getKdcConfig().getEncryptionTypes());
        identity.addKeys(keys);
        this.backend.addIdentity(identity);
    }

    @Override
    public void exportKeytab(File keytabFile, String principal) throws KrbException {
        principal = this.fixPrincipal(principal);
        this.exportKeytab(keytabFile, Collections.singletonList(principal));
    }

    @Override
    public void exportKeytab(File keytabFile, List<String> principals) throws KrbException {
        LinkedList<KrbIdentity> identities = new LinkedList<KrbIdentity>();
        for (String principal : principals) {
            KrbIdentity identity = this.backend.getIdentity(principal);
            if (identity == null) {
                throw new KrbException("Can not find the identity for principal " + principal);
            }
            identities.add(identity);
        }
        AdminHelper.exportKeytab(keytabFile, identities);
    }

    @Override
    public void exportKeytab(File keytabFile) throws KrbException {
        Keytab keytab = AdminHelper.createOrLoadKeytab(keytabFile);
        Iterable<String> principals = this.backend.getIdentities();
        for (String principal : principals) {
            KrbIdentity identity = this.backend.getIdentity(principal);
            if (identity == null) continue;
            AdminHelper.exportToKeytab(keytab, identity);
        }
        AdminHelper.storeKeytab(keytab, keytabFile);
    }

    @Override
    public void removeKeytabEntriesOf(File keytabFile, String principal) throws KrbException {
        principal = this.fixPrincipal(principal);
        AdminHelper.removeKeytabEntriesOf(keytabFile, principal);
    }

    @Override
    public void removeKeytabEntriesOf(File keytabFile, String principal, int kvno) throws KrbException {
        principal = this.fixPrincipal(principal);
        AdminHelper.removeKeytabEntriesOf(keytabFile, principal, kvno);
    }

    @Override
    public void removeOldKeytabEntriesOf(File keytabFile, String principal) throws KrbException {
        principal = this.fixPrincipal(principal);
        AdminHelper.removeOldKeytabEntriesOf(keytabFile, principal);
    }

    @Override
    public void deletePrincipal(String principal) throws KrbException {
        principal = this.fixPrincipal(principal);
        this.backend.deleteIdentity(principal);
    }

    @Override
    public void modifyPrincipal(String principal, KOptions kOptions) throws KrbException {
        KrbIdentity identity = this.backend.getIdentity(principal = this.fixPrincipal(principal));
        if (identity == null) {
            throw new KrbException("Principal \"" + principal + "\" does not exist.");
        }
        AdminHelper.updateIdentity(identity, kOptions);
        this.backend.updateIdentity(identity);
    }

    @Override
    public void renamePrincipal(String oldPrincipalName, String newPrincipalName) throws KrbException {
        oldPrincipalName = this.fixPrincipal(oldPrincipalName);
        KrbIdentity oldIdentity = this.backend.getIdentity(newPrincipalName = this.fixPrincipal(newPrincipalName));
        if (oldIdentity != null) {
            throw new KrbException("Principal \"" + oldIdentity.getPrincipalName() + "\" is already exist.");
        }
        KrbIdentity identity = this.backend.getIdentity(oldPrincipalName);
        if (identity == null) {
            throw new KrbException("Principal \"" + oldPrincipalName + "\" does not exist.");
        }
        this.backend.deleteIdentity(oldPrincipalName);
        identity.setPrincipalName(newPrincipalName);
        identity.setPrincipal(new PrincipalName(newPrincipalName));
        this.backend.addIdentity(identity);
    }

    @Override
    public KrbIdentity getPrincipal(String principalName) throws KrbException {
        KrbIdentity identity = this.backend.getIdentity(principalName);
        return identity;
    }

    @Override
    public List<String> getPrincipals() throws KrbException {
        Iterable<String> principalNames = this.backend.getIdentities();
        LinkedList<String> principalList = new LinkedList<String>();
        Iterator<String> iterator = principalNames.iterator();
        while (iterator.hasNext()) {
            principalList.add(iterator.next());
        }
        return principalList;
    }

    @Override
    public List<String> getPrincipals(String globString) throws KrbException {
        Pattern pt = AdminHelper.getPatternFromGlobPatternString(globString);
        if (pt == null) {
            return this.getPrincipals();
        }
        boolean containsAt = pt.pattern().indexOf(64) != -1;
        LinkedList<String> result = new LinkedList<String>();
        List<String> principalNames = this.getPrincipals();
        for (String principal : principalNames) {
            String toMatch = containsAt ? principal : principal.split("@")[0];
            Matcher m4 = pt.matcher(toMatch);
            if (!m4.matches()) continue;
            result.add(principal);
        }
        return result;
    }

    @Override
    public void changePassword(String principal, String newPassword) throws KrbException {
        KrbIdentity identity = this.backend.getIdentity(principal = this.fixPrincipal(principal));
        if (identity == null) {
            throw new KrbException("Principal " + principal + " was not found. Please check the input and try again");
        }
        List<EncryptionKey> keys = EncryptionUtil.generateKeys(principal, newPassword, this.getKdcConfig().getEncryptionTypes());
        identity.addKeys(keys);
        this.backend.updateIdentity(identity);
    }

    @Override
    public void updateKeys(String principal) throws KrbException {
        KrbIdentity identity = this.backend.getIdentity(principal = this.fixPrincipal(principal));
        if (identity == null) {
            throw new KrbException("Principal " + principal + "was not found. Please check the input and try again");
        }
        List<EncryptionKey> keys = EncryptionUtil.generateKeys(this.getKdcConfig().getEncryptionTypes());
        identity.addKeys(keys);
        this.backend.updateIdentity(identity);
    }

    @Override
    public void release() throws KrbException {
        if (this.backend != null) {
            this.backend.stop();
        }
    }

    @Override
    public int size() throws KrbException {
        return this.getPrincipals().size();
    }

    private String fixPrincipal(String principal) {
        if (!principal.contains("@")) {
            principal = principal + "@" + this.serverSetting.getKdcRealm();
        }
        return principal;
    }
}

