'''OpenGL extension EXT.EGL_image_storage

This module customises the behaviour of the 
OpenGL.raw.GL.EXT.EGL_image_storage to provide a more 
Python-friendly API

Overview (from the spec)
	
	The OpenGL ES extension OES_EGL_image provides a mechanism for creating
	GL textures sharing storage with EGLImage objects (in other words, creating
	GL texture EGLImage targets).  The extension was written against the
	OpenGL ES 2.0 specification, which does not have the concept of immutable
	textures.  As a result, it specifies that respecification of a texture by
	calling TexImage* on a texture that is an EGLImage target causes it to be
	implicitly orphaned.  In most cases, this is not the desired behavior, but
	rather a result of an application error.
	
	This extension provides a mechanism for creating texture objects that are
	both EGLImage targets and immutable.  Since immutable textures cannot be
	respecified, they also cannot accidentally be orphaned, and attempts to do
	so generate errors instead of resulting in well-defined, but often
	undesirable and surprising behavior.  It provides a strong guarantee that
	texture data that is intended to be shared will remain shared.
	
	EGL extension specifications are located in the EGL Registry at
	
	    http://www.khronos.org/registry/egl/

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/EGL_image_storage.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.EXT.EGL_image_storage import *
from OpenGL.raw.GL.EXT.EGL_image_storage import _EXTENSION_NAME

def glInitEglImageStorageEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION